#include "StdAfx.h"
#include "EventHandler.h"
#include "vssjscript.h"
#include "registry.h"
#include "exception.h"
#include "unknown.h"
#include "hinstance.h"

BOOL __stdcall DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved) throw () {
	switch (dwReason) {
	case DLL_PROCESS_ATTACH:
		::hInstance = hInstance;
		break;
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
		break;
	case DLL_PROCESS_DETACH:
		::hInstance = 0;
		break;
	}
    return TRUE;
} 

HRESULT __stdcall DllGetClassObject(REFCLSID rclsid, REFIID riid, void **ppv) throw () try {
	if (!ppv) throw _com_error(E_POINTER);
	if (!::IsEqualCLSID(rclsid, CLSID_EventHandler)) throw _com_error(CLASS_E_CLASSNOTAVAILABLE);
	EventHandler *instance = new EventHandler;
	instance->AddRef();
	HRESULT hr = instance->QueryInterface(riid, ppv);
	instance->Release();
	return S_OK;
} catch (_com_error &hr) {
	return hr.Error();
} catch (...) {
	return E_UNEXPECTED;
}

HRESULT __stdcall DllCanUnloadNow() throw () {
    return (UnknownImpl::ServerCount() == 0) ? S_OK : S_FALSE;
}

Registry GetRegistry() {

	TCHAR filename[MAX_PATH];
	if (!::GetModuleFileName(hInstance, filename, MAX_PATH)) throw _win32_error(::GetLastError());

	return Registry(
		Registry::Root(HKEY_CLASSES_ROOT,
			Registry::Key(TEXT("CLSID\\{78FF782A-867B-47E7-AD93-03074970ADFC}"),
				Registry::Value(TEXT(""), TEXT("VSSJScript.EventHandler")),
				Registry::Key(TEXT("InprocServer32"),
					Registry::Value(TEXT(""), filename),
					Registry::Value(TEXT("ThreadingModel"), TEXT("Apartment"))),
				Registry::Key(TEXT("ProgID"),
					Registry::Value(TEXT(""), TEXT("VSSJScript.EventHandler"))))),
		Registry::Root(HKEY_CLASSES_ROOT,
			Registry::Key(TEXT("VSSJScript.EventHandler"),
				Registry::Value(TEXT(""), TEXT("VSSJScript.EventHandler")),
				Registry::Key(TEXT("CLSID"),
					Registry::Value(TEXT(""), TEXT("{78FF782A-867B-47E7-AD93-03074970ADFC}"))))));
}

HRESULT __stdcall DllRegisterServer() throw () try {
	Registry r = GetRegistry();
	r.Create();
	return S_OK;
} catch (_com_error &hr) {
	return hr.Error();
} catch (...) {
	return E_UNEXPECTED;
}

HRESULT __stdcall DllUnregisterServer(void) throw () try {
	Registry r = GetRegistry();
	r.Delete();
	return S_OK;
} catch (_com_error &hr) {
	return hr.Error();
} catch (...) {
	return E_UNEXPECTED;
}
