#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>

#include "hinstance.h"
#include "exception.h"

struct MessageWindow {
public:
	struct Listener {
		friend MessageWindow;
	protected:
		virtual LRESULT WindowProc(HWND h, UINT m, WPARAM w, LPARAM l) {
			return ::DefWindowProc(h, m, w, l);
		}
	};

	MessageWindow() : handle(0), listener(nullptr) {
		Create(); 
	}

	~MessageWindow() {
		Destroy();
	}

	HWND GetHandle(void) const { return handle; }

	void SetListener(Listener *l) {
		listener = l;
	}
private:
	void Create(void) {
		Destroy();
		HINSTANCE instance = ::hInstance;
		ATOM a = RegisterClass(instance);
		handle = ::CreateWindowEx(
			0,
			reinterpret_cast<LPCTSTR>(a),
			nullptr,
			WS_OVERLAPPEDWINDOW,
			0, 0, 10, 10,
			0 /* not HWND_MESSAGE, to receive "TaskbarCreated" message. */,
			0,
			instance,
			this);
		if (handle == 0) throw _win32_error(::GetLastError());
	}

	void Destroy(void) {
		listener = nullptr;
		if (handle != 0) {
			::DestroyWindow(handle);
			handle = 0;
		}
	}

	static ATOM RegisterClass(HINSTANCE instance) {
		static ATOM Atom = 0;
		if (Atom == 0) {
			WNDCLASSEX wc;
			wc.cbSize = sizeof(wc);
			wc.style = 0;
			wc.lpfnWndProc = WindowProc;
			wc.cbClsExtra = 0;
			wc.cbWndExtra = 0;
			wc.hInstance = instance;
			wc.hIcon = 0;
			wc.hCursor = ::LoadCursor(0, IDC_ARROW);
			wc.hbrBackground = (HBRUSH)COLOR_WINDOW;
			wc.lpszMenuName = nullptr;
			wc.lpszClassName = TEXT("{134379A2-E9B7-4F20-BBCF-65965DBC6E42}");
			wc.hIconSm = 0;
			Atom = ::RegisterClassEx(&wc);
			if (Atom == 0) throw _win32_error(::GetLastError());
		}
		return Atom;
	}

	static LRESULT __stdcall WindowProc(HWND h, UINT m, WPARAM w, LPARAM l) throw() {
		if (m == WM_CREATE) {
			::SetLastError(0);
			LONG gwl = ::SetWindowLong(h, GWL_USERDATA, reinterpret_cast<LONG>(reinterpret_cast<CREATESTRUCT *>(l)->lpCreateParams));
			if (gwl == 0) {
				DWORD e = ::GetLastError();
				if (e != 0) return -1;
			}
		}
		LONG gwl = ::GetWindowLong(h, GWL_USERDATA);
		if (gwl != 0) {
			MessageWindow *This = reinterpret_cast<MessageWindow *>(gwl);
			if (This->listener) {
				return This->listener->WindowProc(h, m, w, l);
			}
		}
		return ::DefWindowProc(h, m, w, l);
	}

	HWND handle;
	Listener *listener;
};
