/*
 * jquery.dropdown.js
 * jquery uiにマッチしたdropdownlist plugin
 * 内部的にはjquery uiのmenuを使用
 * version: 0.91
 * copyright (C) infodb.org 2012
 *
 * usage:
 *  <input type="text" id="dropdownlist" value="xxx" placeholder="label">
 *  $("#dropdownlist").dropdown(options);
 *
 * options:
 *   list: string
 *     リストデータを取得するURL。リストデータはjquery uiのmenuの仕様に依存する。
 *     選択された時にはliタグのid属性およびaタグのテキストを引数にchoiceで登録した関数が呼ばれる。
 *   listURL: function
 *     動的にURLを変更する場合の関数を指定する。
 *     listオプションかlistURLを指定しないとリストは表示されない。
 *   listData: function
 *     リストデータを取得する際にサーバに投げるデータを返戻する関数。
 *     関数はdata=value&data2=value2...の形式か、{"data": "value"}の形式で返戻すること。
 *   choice: function
 *     値が選択された時のコールバック関数。idおよびcaptionが引数として渡される。
 *   empty: string
 *     空選択を許可する場合に、その空選択文字列を指定する。(動的変更は不可)
 *   maxHeight: int
 *     最大高さを設定します。その高さ以上になった場合はスクロールされるようになります。
 *     オプションを指定しなかった場合にはスクロールはされません。
 * methods:
 *   $("#dropdownlist").dropdown('clear', caption);
 *     選択されているアイテムをクリアする。captionを指定するとその文字列に置き換える。
 *   $("#dropdownlist").dropdown('readonly', true / false);
 *     ドロップダウンの読取専用状態を制御する。
 *   $("#dropdownlist").dropdown("enabled", true / false);
 *     ドロップダウンのenabledを制御する。
 */
(function($) {
  function applyValue(btnObj, id, caption) {
    btnObj.find("input[type='hidden']").val(id);
    btnObj.find('span:first').text(caption);
  }
  function hideAndRemove(listObj) {
    listObj.hide('fast', function(){
      listObj.remove();
    });
  }
  function uniqueId() {
    var randam = Math.floor(Math.random() * 1000);
    var date = new Date();
    var time = date.getTime();
    return randam + '_' + time.toString();
  }
  function successHandler(btnObj, html) {
    var offsetTop = btnObj.offset().top + btnObj.height() + 3;
    var offsetLeft = btnObj.offset().left;
    var width = btnObj.width();
    var listObj = $(html);
    var options = btnObj.data('dropdown');

    var id = btnObj.find("input[type='hidden']").val();
    if(options.empty != undefined) {
      listObj.prepend('<li><a>' + options.empty + '</a></li>');
      if(id == null || id == '') {
        listObj.find('li:first').addClass('ui-corner-all ui-state-active');
      }
    }
    if(id != null && id != '') {
      listObj.find('#' + id).addClass('ui-corner-all ui-state-active');
    }
    listObj.css({
        "position": "absolute"
      , "top": offsetTop
      , "left": offsetLeft
      , "width": width
      , "display": "none"
      , "z-index": 2000
    });
    if(options.maxHeight != undefined) {
      listObj.css({
        "max-height": options.maxHeight
        , "overflow": "auto"
      });
    }
    listObj.attr("tabindex", "0");
    listObj.blur(function() {
      hideAndRemove($(this));
    });
    listObj.appendTo($("body")).menu({
      select: function(event, ui) {
        var id = ui.item.attr('id');
        var caption = ui.item.find('a:first').text();
        applyValue(btnObj, id, caption);
        hideAndRemove(listObj);
        if(options.choice != undefined) {
          options.choice(id, caption);
        }
      }
    });
    listObj.find('.ui-menu').css("width", width);
    listObj.show(300, function(){
      listObj.focus();
    });
  }
  var methods = {
    init : function(options) {
      return this.each(function(){
        var id = $(this).attr('id');
        if(id == undefined) {
            id = uniqueId();
        }
        var clazz = $(this).attr('class');
        var width = $(this).width();
        var disabled = $(this).attr('disabled');
        var readonly = $(this).attr('readonly');
        var title = $(this).attr('title');
        var tag = '<a id="' + id + '_anchor" ';
        if(title != undefined) {
          tag += 'title="' + title + '" ';
        }
        tag += 'class="ui-dropdown ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-secondary" role="button" aria-disabled="false">';
        tag += '<input type="hidden" id="' + id + '" name="' + $(this).attr('name') + '" value="' + $(this).attr('value') + '">';
        tag += '<span class="ui-button-text" style="padding-left 10px;">';
        tag += $(this).attr('placeholder');
        tag += '</span><span class="ui-button-icon-secondary ui-icon ui-icon-triangle-1-s"/></a>';
        $(this).replaceWith(tag);
        if(disabled) {
            $('#' + id + '_anchor').attr('disabled', 'disabled');
            $('#' + id + '_anchor').addClass('ui-state-disabled');
        }
        if(readonly) {
            $('#' + id + '_anchor').attr('readonly', 'readonly');
            $('#' + id + '_anchor>span.ui-button-icon-secondary')
                .removeClass('ui-icon-triangle-1-s')
                .addClass('ui-icon-locked');
        }
        $('#' + id + '_anchor')
          .data('dropdown', options)
          .addClass(clazz)
          .css({"width": width, "text-align": "left"})
          .click(function(){
            var btnObj = $(this);
            if(btnObj.attr('disabled') || btnObj.attr('readonly')) {
                return false;
            }
            var url = options.list;
            if(options.listURL != undefined) {
              url = options.listURL();
            }
            var data = "";
            if(options.listData != undefined){
              data = options.listData();
            }
            $.ajax({
                cache: false
              , url: url
              , data: data
              , type: "POST"
              , dataType: "html"
              , success: function(html) {
                successHandler(btnObj, html);
              }
            });
            return false;
          });
      });
    }
    , clear : function(value) {
      return this.each(function(){
        var btnObj = $(this).parent();
        options = btnObj.data('dropdown');
        var caption = '';
        if(options.empty != undefined) {
          caption = options.empty;
        }
        if(value != undefined) {
            caption = value;
        }
        applyValue(btnObj, '', caption);
      });
    }
    , readonly : function(value) {
        return this.each(function() {
            var btnObj = $(this).parent();
            if(value == true) {
                btnObj.attr('readonly', 'readonly');
                btnObj.find('span.ui-button-icon-secondary')
                    .removeClass('ui-icon-triangle-1-s')
                    .addClass('ui-icon-locked');
            } else {
                btnObj.removeAttr('readonly');
                btnObj.find('span.ui-button-icon-secondary')
                    .removeClass('ui-icon-locked')
                    .addClass('ui-icon-triangle-1-s');
            }
        });
    }
    , enabled : function(value) {
        return this.each(function() {
            var btnObj = $(this).parent();
            if(value == true) {
                btnObj.removeAttr('disabled');
                btnObj.removeClass('ui-state-disabled');
            } else {
                btnObj.attr('disabled', 'disabled');
                btnObj.addClass('ui-state-disabled');
            }
        })
    }
  };
  $.fn.dropdown = function(method) {
    if(methods[method]) {
      return methods[method].apply(this, Array.prototype.slice.call( arguments, 1));
    } else if(typeof method === 'object' || !method) {
      return methods.init.apply(this, arguments);
    } else {
      $.error('Method ' + method + ' does not exist on jQuery.dropdown');
      return null;
    }
  }
})(jQuery);
