/*
 * jquery.exsel.js
 * jQuery UIにマッチしたselect拡張プラグイン
 *
 * version: 0.56
 * copyright (C) infodb.org 2013
 *
 */
(function($) {
    $.widget('custom.exsel', {
        options: {
            select: undefined
            , maxHeight: 250
            , readonly: undefined
            , disabled: undefined
            , width: 'auto'
            , finder: 'auto'
            , filter: undefined
        }
        , _anchorBtn: null
        , _menu: null
        , _lastKeyword: null
        , _create: function() {
            this.wrapper = $('<span>').insertAfter(this.element);
            this.element.hide();
            this._createAnchorButton();
        }
        , _createAnchorButton: function() {
            if(this.options.width === 'auto') {
                this.options.width = this.element.width() + 26;
            }
            if(typeof this.options.readonly === 'undefined') {
                this.options.readonly = this.element.is('[readonly]');
            }
            if(typeof this.options.disabled === 'undefined') {
                this.options.disabled = this.element.is(':disabled');
            }
            var selected = this.element.children(':selected');
            var value = selected.val() ? selected.text() : '　'; // 全角スペースで高さを確保する
            
            this._anchorBtn = $('<a>')
                .appendTo(this.wrapper)
                .text(value)
                .css({
                    'width': this.options.width
                });
            var clazz = this.element.attr('class');
            if(clazz !== undefined) {
                this._anchorBtn.addClass(clazz);
            }
            var margin = this.element.css('margin');
            if(margin !== undefined && margin !== '') {
                this._anchorBtn.css('margin', margin);
            } else {
                var marTop = this.element.css('margin-top');
                if(marTop !== undefined && marTop !== '') {
                    this._anchorBtn.css('margin-top', marTop);
                }
                var marLeft = this.element.css('margin-left');
                if(marLeft !== undefined && marLeft !== '') {
                    this._anchorBtn.css('margin-left', marLeft);
                }
                var marRight = this.element.css('margin-right');
                if(marRight !== undefined && marRight !== '') {
                    this._anchorBtn.css('margin-right', marRight);
                }
                var marBottom = this.element.css('margin-bottom');
                if(marBottom !== undefined) {
                    this._anchorBtn.css('margin-bottom', marBottom);
                }
            }
            var icon = 'ui-icon-triangle-1-s';
            if(this.options.readonly === true) {
                icon = 'ui-icon-locked';
            }
            this._anchorBtn.button({
                icons: { secondary: icon }
            });
            if(this.options.disabled) {
                this._anchorBtn.button('option', 'disabled', true);
            }
            this._anchorBtn.children('.ui-button-text').css({
                'text-align': 'left'
                , 'padding-top': '0.3em'
                , 'padding-bottom': '0.3em'
            });
            this._on(this._anchorBtn, {
                click: '_buttonClicked'
            });
        }
        , _buttonClicked: function(event) {
            var iam = this;
            if(iam._menu !== null) { // 開いている状態でクリックしたら、メニュー閉じるだけ。
                iam._destroyMenu();
                return;
            }
            iam._trigger('open');
            if(iam.options.readonly === true) {
                return;
            }
            iam._menu = this._createMenu();
            if(iam._menu === null) {
                return;
            }
            iam._menu.css({
                'position': 'absolute'
                , 'z-index': 2000
                , 'width': iam.options.width
            })
            .appendTo('body')
            .position({
                of: iam._anchorBtn
                , my: 'left top'
                , at: 'left bottom+1'
            })
            .show('fast', function() {
                if(iam._menu.find('input').length > 0) {
                    iam._menu.find('input').focus();
                }
            });
            $(document).one('click', function() {
                iam._destroyMenu();
            });
            $(document).one('dialogclose', function() {
                iam._destroyMenu();
            });
            $(document).one('exselopen', function() {
                iam._destroyMenu();
            });
            return false;
        }
        , _createMenu: function() {
            var options = this.element.children('option');
            if(options.length === 0) {
                return null;
            }
            if(this.options.finder === 'always') {
                return this._createMenuEx(options);
            }
            if(this.options.finder === 'auto' && options.length > 20) {
                return this._createMenuEx(options);
            }
            var menu = $('<ul>').hide();
            this._createMenuItem(options, menu, '');
            this._applyMenu(menu);
            return menu;
        }
        , _createMenuItem: function(options, menu, keyword) {
            var allMode = true;
            if(options.length >= 50) {
                allMode = false;
            }
            var filter = null;
            if(typeof this.options.filter !== 'undefined') {
                filter = this.options.filter();
            }
            var re = null;
            if(keyword !== '') {
                re = new RegExp(keyword, 'i');
            }
            options.map(function() {
                var txt = $(this).text();
                var kw = $(this).data('keyword');
                if(filter !== null) {
                    if($(this).data('filter') != filter) {
                        return;
                    }
                }
                if(re !== null) {
                    if(!txt.match(re)) {
                        if(typeof kw !== 'undefined') {
                            if(!kw.match(re)) {
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                } else if(allMode === false) {
                    return;
                }
                var a = $('<a>').text(txt);
                var li = $('<li>').attr('id', $(this).val());
                if($(this).prop('selected')) {
                    li.addClass('ui-state-active ui-corner-all');
                }
                li.append(a).appendTo(menu);
            });
        }
        , _createMenuEx: function(options) {
            var menu = $('<div>')
                    .hide()
                    .addClass('ui-corner-all ui-widget ui-widget-content')
                    .css({
                        'padding': 2
                    });
            // テキストボックス作る
            var inputArea = $('<div>')
                .css({
                    'position': 'relative'
                })
                .appendTo(menu);

            var input = $('<input>')
                .attr('type', 'text')
                .css({
                    'margin-bottom': '5px'
                    , 'width': this.options.width - 26
                    , 'padding-right': '18px'
                })
                .appendTo(inputArea);
            if(this._lastKeyword !== null) {
                input.val(this._lastKeyword);
            }
            var icon = $('<span>')
                .addClass('ui-icon ui-icon-search')
                .css({
                    'position': 'absolute'
                    , 'right': '4px'
                    , 'top': '10px'
                })
                .appendTo(inputArea);
            if(options.length < 50 || this._lastKeyword !== null) { // 50以下ならリスト作る
                var submenu = $('<ul>').appendTo(menu);
                this._createMenuItem(options, submenu, input.val());
                this._applyMenu(submenu);
            }
            input.click(function() {
                return false;
            });
            iam = this;
            input.keyup(function() {
                menu.find('ul').remove();
                iam._lastKeyword = input.val();
                if(input.val() !== '') {
                    var submenu = $('<ul>').appendTo(menu);
                    iam._createMenuItem(options, submenu, input.val());
                    iam._applyMenu(submenu);
                }
            });
            return menu;
        }
        , _applyMenu: function(menu) {
            var iam = this;
            menu.menu({
                select: function(event, ui) {
                    var id = ui.item.attr('id');
                    var txt = ui.item.find('a:first').text();
                    iam._anchorBtn.children('.ui-button-text').text(txt);
                    iam.element.val(id);
                    if(typeof iam.options.select !== 'undefined') {
                        iam.options.select(id, txt);
                    }
                    iam._destroyMenu();
                }
            })
            .css({
                'max-height': iam.options.maxHeight
                , 'overflow': 'auto'
            });
        }
        , _destroyMenu: function() {
            if(this._menu === null) {
                return;
            }
            var iam = this;
            this._menu.hide('fast', function() {
                iam._menu.remove();
                iam._menu = null;
            });
        }
        , _setOption: function(key, value) {
            switch(key) {
                case 'readonly':
                    if(value === true) {
                        this._anchorBtn.find('span.ui-icon').removeClass('ui-icon-triangle-1-s');
                        this._anchorBtn.find('span.ui-icon').addClass('ui-icon-locked');
                    } else {
                        this._anchorBtn.find('span.ui-icon').removeClass('ui-icon-locked');
                        this._anchorBtn.find('span.ui-icon').addClass('ui-icon-triangle-1-s');
                    }
                    this.options.readonly = value;
                    return;
                case 'disabled':
                    this._anchorBtn.button('option', 'disabled', value);
                    this.options.disabled = value;
                    return;
            }
        
            this._super('_setOption', key, value);
        }
        , _destroy: function() {
            this.wrapper.remove();
            this.element.show();
        }
        , reset: function() {
            if(typeof this.options.filter === 'undefined') {
                return;
            }
            var filter = this.options.filter();
            if(filter === null) {
                return;
            }
            var iam = this;
            var options = this.element.children('option');
            options.each(function() {
                if($(this).data('filter') == filter) {
                    var id = $(this).val();
                    var txt = $(this).text();
                    iam._anchorBtn.children('.ui-button-text').text(txt);
                    iam.element.val(id);
                    if(typeof iam.options.select !== 'undefined') {
                        iam.options.select(id, txt);
                    }
                    return false;
                }
                return true;
            });
        }
    });
})(jQuery);
