﻿/*
  ==============================================================================

  This is an automatically generated file created by the Jucer!

  Creation date:  16 May 2010 2:59:32pm

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Jucer version: 1.12

  ------------------------------------------------------------------------------

  The Jucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-6 by Raw Material Software ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...
#include "includes.h"
//[/Headers]

#include "SequenceEditor.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]
using namespace juce;
//==============================================================================
SequenceEditor::SequenceEditor (sf::SequenceFilter * const owner)
    : seqFilter(owner),AudioProcessorEditor(owner),
      playButton (0),
      positionSlider (0),
      stopButton (0),
      rewindButton (0),
      samplePositionLabel1 (0),
      samplePositionLabel (0),
      tickCountLabel (0),
      tickCounterLabel (0),
      Label2 (0),
      Label3 (0),
      tempoSlider (0),
      NumeratorEditor (0),
      Label4 (0),
      DenomEditor (0),
      Label5 (0),
      timeBaseComboBox (0),
      Label6 (0),
      timeLabel (0),
      Label7 (0),
      barCounterLabel (0),
      pathTextEditor (0),
      fileSelectButton (0),
      pauseButton (0),
      label (0),
      recordButton (0)
{
    addAndMakeVisible (playButton = new TextButton (T("Play Button")));
    playButton->setButtonText (T("Play"));
    playButton->addButtonListener (this);

    addAndMakeVisible (positionSlider = new Slider (T("Position Slider")));
    positionSlider->setRange (0, 10, 0);
    positionSlider->setSliderStyle (Slider::LinearHorizontal);
    positionSlider->setTextBoxStyle (Slider::NoTextBox, false, 80, 20);
    positionSlider->addListener (this);

    addAndMakeVisible (stopButton = new TextButton (T("Stop Button")));
    stopButton->setButtonText (T("Stop"));
    stopButton->addButtonListener (this);

    addAndMakeVisible (rewindButton = new TextButton (T("Rewind Button")));
    rewindButton->setButtonText (T("Rewind"));
    rewindButton->addButtonListener (this);

    addAndMakeVisible (samplePositionLabel1 = new Label (T("Sample Position Label1"),
                                                         T("Sample Position")));
    samplePositionLabel1->setFont (Font (15.0000f, Font::plain));
    samplePositionLabel1->setJustificationType (Justification::centredLeft);
    samplePositionLabel1->setEditable (false, false, false);
    samplePositionLabel1->setColour (TextEditor::textColourId, Colours::black);
    samplePositionLabel1->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (samplePositionLabel = new Label (T("samplePositionLabel"),
                                                        String::empty));
    samplePositionLabel->setFont (Font (15.0000f, Font::plain));
    samplePositionLabel->setJustificationType (Justification::centredRight);
    samplePositionLabel->setEditable (false, false, false);
    samplePositionLabel->setColour (TextEditor::textColourId, Colours::black);
    samplePositionLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (tickCountLabel = new Label (T("tick Count Label"),
                                                   T("Tick count")));
    tickCountLabel->setFont (Font (15.0000f, Font::plain));
    tickCountLabel->setJustificationType (Justification::centredLeft);
    tickCountLabel->setEditable (false, false, false);
    tickCountLabel->setColour (TextEditor::textColourId, Colours::black);
    tickCountLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (tickCounterLabel = new Label (T("tickCounterLabel"),
                                                     String::empty));
    tickCounterLabel->setFont (Font (15.0000f, Font::plain));
    tickCounterLabel->setJustificationType (Justification::centredRight);
    tickCounterLabel->setEditable (false, false, false);
    tickCounterLabel->setColour (TextEditor::textColourId, Colours::black);
    tickCounterLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (Label2 = new Label (T("Label2"),
                                           T("Tempo(Bpm)")));
    Label2->setFont (Font (15.0000f, Font::plain));
    Label2->setJustificationType (Justification::centredLeft);
    Label2->setEditable (false, false, false);
    Label2->setColour (TextEditor::textColourId, Colours::black);
    Label2->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (Label3 = new Label (T("Label2"),
                                           T("拍子")));
    Label3->setFont (Font (15.0000f, Font::plain));
    Label3->setJustificationType (Justification::centredLeft);
    Label3->setEditable (false, false, false);
    Label3->setColour (TextEditor::textColourId, Colours::black);
    Label3->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (tempoSlider = new Slider (T("tempoSlider")));
    tempoSlider->setRange (0, 500, 1);
    tempoSlider->setSliderStyle (Slider::LinearHorizontal);
    tempoSlider->setTextBoxStyle (Slider::TextBoxLeft, false, 80, 20);
    tempoSlider->addListener (this);

    addAndMakeVisible (NumeratorEditor = new TextEditor (T("NumeratorEditor")));
    NumeratorEditor->setMultiLine (false);
    NumeratorEditor->setReturnKeyStartsNewLine (false);
    NumeratorEditor->setReadOnly (false);
    NumeratorEditor->setScrollbarsShown (true);
    NumeratorEditor->setCaretVisible (true);
    NumeratorEditor->setPopupMenuEnabled (true);
    NumeratorEditor->setText (String::empty);

    addAndMakeVisible (Label4 = new Label (T("Label2"),
                                           T("/")));
    Label4->setFont (Font (15.0000f, Font::plain));
    Label4->setJustificationType (Justification::centredLeft);
    Label4->setEditable (false, false, false);
    Label4->setColour (TextEditor::textColourId, Colours::black);
    Label4->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (DenomEditor = new TextEditor (T("DenomEditor")));
    DenomEditor->setMultiLine (false);
    DenomEditor->setReturnKeyStartsNewLine (false);
    DenomEditor->setReadOnly (false);
    DenomEditor->setScrollbarsShown (true);
    DenomEditor->setCaretVisible (true);
    DenomEditor->setPopupMenuEnabled (true);
    DenomEditor->setText (String::empty);

    addAndMakeVisible (Label5 = new Label (T("Label2"),
                                           T("タイムベース")));
    Label5->setFont (Font (15.0000f, Font::plain));
    Label5->setJustificationType (Justification::centredLeft);
    Label5->setEditable (false, false, false);
    Label5->setColour (TextEditor::textColourId, Colours::black);
    Label5->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (timeBaseComboBox = new ComboBox (T("timeBaseComboBox")));
    timeBaseComboBox->setEditableText (false);
    timeBaseComboBox->setJustificationType (Justification::centredLeft);
    timeBaseComboBox->setTextWhenNothingSelected (String::empty);
    timeBaseComboBox->setTextWhenNoChoicesAvailable (T("(no choices)"));
    timeBaseComboBox->addItem (T("24"), 1);
    timeBaseComboBox->addItem (T("48"), 2);
    timeBaseComboBox->addItem (T("96"), 3);
    timeBaseComboBox->addItem (T("192"), 4);
    timeBaseComboBox->addItem (T("384"), 5);
    timeBaseComboBox->addItem (T("480"), 6);
    timeBaseComboBox->addItem (T("960"), 7);
    timeBaseComboBox->addListener (this);

    addAndMakeVisible (Label6 = new Label (T("Label2"),
                                           T("時間")));
    Label6->setFont (Font (15.0000f, Font::plain));
    Label6->setJustificationType (Justification::centredLeft);
    Label6->setEditable (false, false, false);
    Label6->setColour (TextEditor::textColourId, Colours::black);
    Label6->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (timeLabel = new Label (T("timeLabel"),
                                              String::empty));
    timeLabel->setFont (Font (15.0000f, Font::plain));
    timeLabel->setJustificationType (Justification::centredRight);
    timeLabel->setEditable (false, false, false);
    timeLabel->setColour (TextEditor::textColourId, Colours::black);
    timeLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (Label7 = new Label (T("Label2"),
                                           T("小節/拍/Tick")));
    Label7->setFont (Font (15.0000f, Font::plain));
    Label7->setJustificationType (Justification::centredLeft);
    Label7->setEditable (false, false, false);
    Label7->setColour (TextEditor::textColourId, Colours::black);
    Label7->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (barCounterLabel = new Label (T("barCounterLabel"),
                                                    String::empty));
    barCounterLabel->setFont (Font (15.0000f, Font::plain));
    barCounterLabel->setJustificationType (Justification::centredRight);
    barCounterLabel->setEditable (false, false, false);
    barCounterLabel->setColour (TextEditor::textColourId, Colours::black);
    barCounterLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (pathTextEditor = new TextEditor (T("pathTextEditor")));
    pathTextEditor->setMultiLine (false);
    pathTextEditor->setReturnKeyStartsNewLine (false);
    pathTextEditor->setReadOnly (false);
    pathTextEditor->setScrollbarsShown (true);
    pathTextEditor->setCaretVisible (true);
    pathTextEditor->setPopupMenuEnabled (true);
    pathTextEditor->setText (String::empty);

    addAndMakeVisible (fileSelectButton = new TextButton (T("fileSelectButton")));
    fileSelectButton->setButtonText (T("..."));
    fileSelectButton->addButtonListener (this);

    addAndMakeVisible (pauseButton = new TextButton (T("pauseButton")));
    pauseButton->setButtonText (T("Pause"));
    pauseButton->addButtonListener (this);

    addAndMakeVisible (label = new Label (T("new label"),
                                          T("Song Poisition")));
    label->setFont (Font (15.0000f, Font::plain));
    label->setJustificationType (Justification::centredLeft);
    label->setEditable (false, false, false);
    label->setColour (TextEditor::textColourId, Colours::black);
    label->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (recordButton = new TextButton (T("recordButton")));
    recordButton->setButtonText (T("Record"));
    recordButton->addButtonListener (this);


    //[UserPreSize]
    //[/UserPreSize]

    setSize (480, 300);

    //[Constructor] You can add your own custom stuff here..
	seqFilter->addListener(this);
	updateWidgets();
    //[/Constructor]
}

SequenceEditor::~SequenceEditor()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    deleteAndZero (playButton);
    deleteAndZero (positionSlider);
    deleteAndZero (stopButton);
    deleteAndZero (rewindButton);
    deleteAndZero (samplePositionLabel1);
    deleteAndZero (samplePositionLabel);
    deleteAndZero (tickCountLabel);
    deleteAndZero (tickCounterLabel);
    deleteAndZero (Label2);
    deleteAndZero (Label3);
    deleteAndZero (tempoSlider);
    deleteAndZero (NumeratorEditor);
    deleteAndZero (Label4);
    deleteAndZero (DenomEditor);
    deleteAndZero (Label5);
    deleteAndZero (timeBaseComboBox);
    deleteAndZero (Label6);
    deleteAndZero (timeLabel);
    deleteAndZero (Label7);
    deleteAndZero (barCounterLabel);
    deleteAndZero (pathTextEditor);
    deleteAndZero (fileSelectButton);
    deleteAndZero (pauseButton);
    deleteAndZero (label);
    deleteAndZero (recordButton);

    //[Destructor]. You can add your own custom destruction code here..
    seqFilter->removeListener(this);
	seqFilter->editorBeingDeleted (this);

    //[/Destructor]
}

//==============================================================================
void SequenceEditor::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]
    g.fillAll (Colours::white);

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void SequenceEditor::resized()
{
    playButton->setBounds (16, 48, 56, 24);
    positionSlider->setBounds (120, 96, 336, 24);
    stopButton->setBounds (144, 48, 56, 24);
    rewindButton->setBounds (208, 48, 56, 24);
    samplePositionLabel1->setBounds (16, 128, 88, 16);
    samplePositionLabel->setBounds (120, 128, 216, 16);
    tickCountLabel->setBounds (16, 152, 88, 16);
    tickCounterLabel->setBounds (120, 152, 216, 16);
    Label2->setBounds (16, 224, 88, 16);
    Label3->setBounds (16, 248, 88, 16);
    tempoSlider->setBounds (120, 224, 240, 16);
    NumeratorEditor->setBounds (120, 248, 40, 16);
    Label4->setBounds (160, 248, 16, 16);
    DenomEditor->setBounds (176, 248, 40, 16);
    Label5->setBounds (16, 272, 88, 16);
    timeBaseComboBox->setBounds (120, 272, 96, 16);
    Label6->setBounds (16, 176, 88, 16);
    timeLabel->setBounds (120, 176, 216, 16);
    Label7->setBounds (16, 200, 88, 16);
    barCounterLabel->setBounds (120, 200, 216, 16);
    pathTextEditor->setBounds (16, 16, 392, 24);
    fileSelectButton->setBounds (424, 16, 32, 24);
    pauseButton->setBounds (80, 48, 56, 24);
    label->setBounds (16, 96, 80, 16);
    recordButton->setBounds (272, 48, 56, 24);
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void SequenceEditor::buttonClicked (Button* buttonThatWasClicked)
{
    //[UserbuttonClicked_Pre]
    //[/UserbuttonClicked_Pre]

    if (buttonThatWasClicked == playButton)
    {
        //[UserButtonCode_playButton] -- add your button handler code here..
		seqFilter->play();
        //[/UserButtonCode_playButton]
    }
    else if (buttonThatWasClicked == stopButton)
    {
        //[UserButtonCode_stopButton] -- add your button handler code here..
		seqFilter->stop();
		//[/UserButtonCode_stopButton]
    }
    else if (buttonThatWasClicked == rewindButton)
    {
        //[UserButtonCode_rewindButton] -- add your button handler code here..
		seqFilter->rewind();
        //[/UserButtonCode_rewindButton]
    }
    else if (buttonThatWasClicked == fileSelectButton)
    {
        //[UserButtonCode_fileSelectButton] -- add your button handler code here..
		 FileChooser fc (L"MIDIファイルオープン",
				 File::nonexistent,
                    L"*.MID");

		if (fc.browseForFileToOpen()){
			File f(fc.getResult());
			if(!seqFilter->readSequenceDataFromFile(f))
			{
				juce::AlertWindow::showMessageBox(juce::AlertWindow::WarningIcon,L"エラー",L"MIDIファイルオープン時にエラーが発生しました。");
			} else {
			};
	    }

        //[/UserButtonCode_fileSelectButton]
    }
    else if (buttonThatWasClicked == pauseButton)
    {
        //[UserButtonCode_pauseButton] -- add your button handler code here..
		seqFilter->suspendProcessing(!seqFilter->isSuspended());
        //[/UserButtonCode_pauseButton]
    }
    else if (buttonThatWasClicked == recordButton)
    {
        //[UserButtonCode_recordButton] -- add your button handler code here..
        //[/UserButtonCode_recordButton]
    }

    //[UserbuttonClicked_Post]
    //[/UserbuttonClicked_Post]
}

void SequenceEditor::sliderValueChanged (Slider* sliderThatWasMoved)
{
    //[UsersliderValueChanged_Pre]
    //[/UsersliderValueChanged_Pre]

    if (sliderThatWasMoved == positionSlider)
    {
        //[UserSliderCode_positionSlider] -- add your slider handling code here..
		seqFilter->setPosition(positionSlider->getValue());
		seqFilter->allNotesOff();
        //[/UserSliderCode_positionSlider]
    }
    else if (sliderThatWasMoved == tempoSlider)
    {
        //[UserSliderCode_tempoSlider] -- add your slider handling code here..
        //[/UserSliderCode_tempoSlider]
    }

    //[UsersliderValueChanged_Post]
    //[/UsersliderValueChanged_Post]
}

void SequenceEditor::comboBoxChanged (ComboBox* comboBoxThatHasChanged)
{
    //[UsercomboBoxChanged_Pre]
    //[/UsercomboBoxChanged_Pre]

    if (comboBoxThatHasChanged == timeBaseComboBox)
    {
        //[UserComboBoxCode_timeBaseComboBox] -- add your combo box handling code here..
        //[/UserComboBoxCode_timeBaseComboBox]
    }

    //[UsercomboBoxChanged_Post]
    //[/UsercomboBoxChanged_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...
void SequenceEditor::updateWidgets()
{
	// ファイル名
	if(!seqFilter->isEmptyData())
	{
		pathTextEditor->setText(seqFilter->getMIDIFileInfo().getFileName());
		samplePositionLabel->setText((boost::wformat(L"%f") % seqFilter->getSamplePosition()).str().c_str(),false);
		tickCounterLabel->setText((boost::wformat(L"%f") % seqFilter->getTickCounter()).str().c_str(),false);
		tempoSlider->setValue(seqFilter->getTempo());
		NumeratorEditor->setText(String(seqFilter->getNumerator()));
		DenomEditor->setText(String(seqFilter->getTimeDenominator()));
		timeBaseComboBox->setText(String(seqFilter->getTimeBase()));

		if(!positionSlider->isMouseButtonDown())
		{
			positionSlider->setRange(0.0,seqFilter->getLastTick(),1.0);
			positionSlider->setValue(floor(seqFilter->getTickCounter()),false,false);
		}

		timeLabel->setText((boost::wformat(L"%f") % (seqFilter->getSamplePosition() /seqFilter->getSampleRate())).str().c_str(),false);
		int bar = (int)(seqFilter->getTickCounter() / (seqFilter->getTimeBase() * seqFilter->getNumerator() * 4.0 / seqFilter->getTimeDenominator()));
		int beat = (int)((seqFilter->getTickCounter() - bar * (seqFilter->getTimeBase() * seqFilter->getNumerator() * 4.0 / seqFilter->getTimeDenominator())) / seqFilter->getTimeBase()); 
		int tick = (int)(seqFilter->getTickCounter() - bar * (seqFilter->getTimeBase() * seqFilter->getNumerator() * 4.0 / seqFilter->getTimeDenominator()) - beat * seqFilter->getTimeBase());
		barCounterLabel->setText((boost::wformat(L"%05d/%05d/%05d") % bar % beat % tick).str().c_str(),false);

	}


	// 再生・録音制御部分の状態
	if(seqFilter->isPlaying())
	{
		// プレイ中
		playButton->setEnabled(false);
		stopButton->setEnabled(true);
		pauseButton->setEnabled(true);
		rewindButton->setEnabled(true);
		recordButton->setEnabled(false);
	} else {
		//
		if(seqFilter->isSuspended()){
			playButton->setEnabled(true);
			stopButton->setEnabled(true);
			rewindButton->setEnabled(true);
			pauseButton->setEnabled(true);
			recordButton->setEnabled(false);
		} else {
			// 停止
			playButton->setEnabled(!seqFilter->isEmptyData());
			stopButton->setEnabled(false);
			pauseButton->setEnabled(false);
			rewindButton->setEnabled(true);
			recordButton->setEnabled(false);
		}
	}



}
//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Jucer information section --

    This is where the Jucer puts all of its metadata, so don't change anything in here!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="SequenceEditor" componentName=""
                 parentClasses="public AudioProcessorEditor, public AudioProcessorListener"
                 constructorParams="sf::SequenceFilter * const owner" variableInitialisers="seqFilter(owner),AudioProcessorEditor(owner)&#10;"
                 snapPixels="8" snapActive="1" snapShown="1" overlayOpacity="0.330000013"
                 fixedSize="1" initialWidth="480" initialHeight="300">
  <BACKGROUND backgroundColour="ffffffff"/>
  <TEXTBUTTON name="Play Button" id="903e8fb2eed14838" memberName="playButton"
              virtualName="" explicitFocusOrder="0" pos="16 48 56 24" buttonText="Play"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
  <SLIDER name="Position Slider" id="19f10fb91090d27f" memberName="positionSlider"
          virtualName="" explicitFocusOrder="0" pos="120 96 336 24" min="0"
          max="10" int="0" style="LinearHorizontal" textBoxPos="NoTextBox"
          textBoxEditable="1" textBoxWidth="80" textBoxHeight="20" skewFactor="1"/>
  <TEXTBUTTON name="Stop Button" id="85dca0996126b3b0" memberName="stopButton"
              virtualName="" explicitFocusOrder="0" pos="144 48 56 24" buttonText="Stop"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
  <TEXTBUTTON name="Rewind Button" id="221ae7a0b304b51e" memberName="rewindButton"
              virtualName="" explicitFocusOrder="0" pos="208 48 56 24" buttonText="Rewind"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
  <LABEL name="Sample Position Label1" id="86d2411620297cbe" memberName="samplePositionLabel1"
         virtualName="" explicitFocusOrder="0" pos="16 128 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="Sample Position" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <LABEL name="samplePositionLabel" id="982b7c6aac5ec9b6" memberName="samplePositionLabel"
         virtualName="" explicitFocusOrder="0" pos="120 128 216 16" edTextCol="ff000000"
         edBkgCol="0" labelText="" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="34"/>
  <LABEL name="tick Count Label" id="41a28ee87dc21d8" memberName="tickCountLabel"
         virtualName="" explicitFocusOrder="0" pos="16 152 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="Tick count" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="33"/>
  <LABEL name="tickCounterLabel" id="20fe68c5a754dca1" memberName="tickCounterLabel"
         virtualName="" explicitFocusOrder="0" pos="120 152 216 16" edTextCol="ff000000"
         edBkgCol="0" labelText="" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="34"/>
  <LABEL name="Label2" id="9881e20411e49fba" memberName="Label2" virtualName=""
         explicitFocusOrder="0" pos="16 224 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="Tempo(Bpm)" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="33"/>
  <LABEL name="Label2" id="cca38f5e9c9e96a3" memberName="Label3" virtualName=""
         explicitFocusOrder="0" pos="16 248 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="&#25293;&#23376;" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <SLIDER name="tempoSlider" id="ef86ec81f7210895" memberName="tempoSlider"
          virtualName="" explicitFocusOrder="0" pos="120 224 240 16" min="0"
          max="500" int="1" style="LinearHorizontal" textBoxPos="TextBoxLeft"
          textBoxEditable="1" textBoxWidth="80" textBoxHeight="20" skewFactor="1"/>
  <TEXTEDITOR name="NumeratorEditor" id="e4ad0f461fa7e5f0" memberName="NumeratorEditor"
              virtualName="" explicitFocusOrder="0" pos="120 248 40 16" initialText=""
              multiline="0" retKeyStartsLine="0" readonly="0" scrollbars="1"
              caret="1" popupmenu="1"/>
  <LABEL name="Label2" id="75847c686e6d25f4" memberName="Label4" virtualName=""
         explicitFocusOrder="0" pos="160 248 16 16" edTextCol="ff000000"
         edBkgCol="0" labelText="/" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="33"/>
  <TEXTEDITOR name="DenomEditor" id="cfdfbe945fd51b07" memberName="DenomEditor"
              virtualName="" explicitFocusOrder="0" pos="176 248 40 16" initialText=""
              multiline="0" retKeyStartsLine="0" readonly="0" scrollbars="1"
              caret="1" popupmenu="1"/>
  <LABEL name="Label2" id="fbc84477c0ce3c27" memberName="Label5" virtualName=""
         explicitFocusOrder="0" pos="16 272 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="&#12479;&#12452;&#12512;&#12505;&#12540;&#12473;"
         editableSingleClick="0" editableDoubleClick="0" focusDiscardsChanges="0"
         fontname="Default font" fontsize="15" bold="0" italic="0" justification="33"/>
  <COMBOBOX name="timeBaseComboBox" id="8c7deab27b4ca8d6" memberName="timeBaseComboBox"
            virtualName="" explicitFocusOrder="0" pos="120 272 96 16" editable="0"
            layout="33" items="24&#10;48&#10;96&#10;192&#10;384&#10;480&#10;960"
            textWhenNonSelected="" textWhenNoItems="(no choices)"/>
  <LABEL name="Label2" id="488443d747b94fd8" memberName="Label6" virtualName=""
         explicitFocusOrder="0" pos="16 176 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="&#26178;&#38291;" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <LABEL name="timeLabel" id="49297182a63cb379" memberName="timeLabel"
         virtualName="" explicitFocusOrder="0" pos="120 176 216 16" edTextCol="ff000000"
         edBkgCol="0" labelText="" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="34"/>
  <LABEL name="Label2" id="435964b4d437e6b6" memberName="Label7" virtualName=""
         explicitFocusOrder="0" pos="16 200 88 16" edTextCol="ff000000"
         edBkgCol="0" labelText="&#23567;&#31680;/&#25293;/Tick" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <LABEL name="barCounterLabel" id="418db9782f99e7d6" memberName="barCounterLabel"
         virtualName="" explicitFocusOrder="0" pos="120 200 216 16" edTextCol="ff000000"
         edBkgCol="0" labelText="" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="34"/>
  <TEXTEDITOR name="pathTextEditor" id="e9de41f1264a6965" memberName="pathTextEditor"
              virtualName="" explicitFocusOrder="0" pos="16 16 392 24" initialText=""
              multiline="0" retKeyStartsLine="0" readonly="0" scrollbars="1"
              caret="1" popupmenu="1"/>
  <TEXTBUTTON name="fileSelectButton" id="ca4806c8b25d0984" memberName="fileSelectButton"
              virtualName="" explicitFocusOrder="0" pos="424 16 32 24" buttonText="..."
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
  <TEXTBUTTON name="pauseButton" id="af9c3103ca38fcc1" memberName="pauseButton"
              virtualName="" explicitFocusOrder="0" pos="80 48 56 24" buttonText="Pause"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
  <LABEL name="new label" id="6400270700bd668e" memberName="label" virtualName=""
         explicitFocusOrder="0" pos="16 96 80 16" edTextCol="ff000000"
         edBkgCol="0" labelText="Song Poisition" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <TEXTBUTTON name="recordButton" id="3e936031e211c9ae" memberName="recordButton"
              virtualName="" explicitFocusOrder="0" pos="272 48 56 24" buttonText="Record"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif
