﻿/*
  ==============================================================================

  This is an automatically generated file created by the Jucer!

  Creation date:  12 Oct 2009 7:27:01 pm

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Jucer version: 1.11

  ------------------------------------------------------------------------------

  The Jucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-6 by Raw Material Software ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...
#include "includes.h"
using namespace JUCE_NAMESPACE;
#include "WASAPI.h"
//[/Headers]

#include "WASAPIControlPanel.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
WASAPIControlPanel::WASAPIControlPanel (sf::WASAPIInterface* wasapi)
    : Component (T("WASAPI Control Panel")),
      MMCSSgroup (0),
      deviceSharingGroup (0),
      deviceModeExclusiveButton (0),
      deviceModeShareButton (0),
      playbackVolumeGroup (0),
      playbackVolumeslider (0),
      enableMMCSSButton (0),
      MMCSSHigh (0),
      MMCSSNormalButton (0),
      MMCSSCriticalButton (0),
      MMCSSLowButton (0),
      playbackModeGroup (0),
      pushmodeButton (0),
      eventModeButton (0),
      bufferLatencyGroup (0),
      bufferLatacySlider (0),
      latencyMinLabel (0),
      latencyMaxLabel (0),
      OKButton (0),
      CancelButton (0)
{
    addAndMakeVisible (MMCSSgroup = new GroupComponent (T("MMCSSgroup"),
                                                        T("MMCSS")));

    addAndMakeVisible (deviceSharingGroup = new GroupComponent (T("device Sharing Group"),
                                                                T("Device Sharing")));

    addAndMakeVisible (deviceModeExclusiveButton = new ToggleButton (T("deviceModeExclusiveButton")));
    deviceModeExclusiveButton->setButtonText (T("Exclusive Mode"));
    deviceModeExclusiveButton->setRadioGroupId (1);
    deviceModeExclusiveButton->addButtonListener (this);
    deviceModeExclusiveButton->setToggleState (true, false);

    addAndMakeVisible (deviceModeShareButton = new ToggleButton (T("deviceModeShareButton")));
    deviceModeShareButton->setButtonText (T("Share Mode"));
    deviceModeShareButton->setRadioGroupId (1);
    deviceModeShareButton->addButtonListener (this);

    addAndMakeVisible (playbackVolumeGroup = new GroupComponent (T("playbackVolumeGroup"),
                                                                 T("Playback Volume")));

    addAndMakeVisible (playbackVolumeslider = new Slider (T("playbackVolumeslider")));
    playbackVolumeslider->setRange (0, 1, 0.01);
    playbackVolumeslider->setSliderStyle (Slider::LinearHorizontal);
    playbackVolumeslider->setTextBoxStyle (Slider::TextBoxLeft, false, 80, 20);
    playbackVolumeslider->addListener (this);

    addAndMakeVisible (enableMMCSSButton = new ToggleButton (T("enableMMCSSButton")));
    enableMMCSSButton->setButtonText (T("Enable MMCSS"));
    enableMMCSSButton->addButtonListener (this);
    enableMMCSSButton->setToggleState (true, false);

    addAndMakeVisible (MMCSSHigh = new ToggleButton (T("MMCSSHigh")));
    MMCSSHigh->setButtonText (T("High"));
    MMCSSHigh->setRadioGroupId (4);
    MMCSSHigh->addButtonListener (this);

    addAndMakeVisible (MMCSSNormalButton = new ToggleButton (T("MMCSSNormalButton")));
    MMCSSNormalButton->setButtonText (T("Normal"));
    MMCSSNormalButton->setRadioGroupId (4);
    MMCSSNormalButton->addButtonListener (this);

    addAndMakeVisible (MMCSSCriticalButton = new ToggleButton (T("MMCSSCriticalButton")));
    MMCSSCriticalButton->setButtonText (T("Critical"));
    MMCSSCriticalButton->setRadioGroupId (4);
    MMCSSCriticalButton->addButtonListener (this);
    MMCSSCriticalButton->setToggleState (true, false);

    addAndMakeVisible (MMCSSLowButton = new ToggleButton (T("MMCSSLowButton")));
    MMCSSLowButton->setButtonText (T("Low"));
    MMCSSLowButton->setRadioGroupId (4);
    MMCSSLowButton->addButtonListener (this);

    addAndMakeVisible (playbackModeGroup = new GroupComponent (T("playbackModeGroup"),
                                                               T("Playback Mode")));

    addAndMakeVisible (pushmodeButton = new ToggleButton (T("pushmodeButton")));
    pushmodeButton->setButtonText (T("Push Mode"));
    pushmodeButton->setRadioGroupId (3);
    pushmodeButton->addButtonListener (this);

    addAndMakeVisible (eventModeButton = new ToggleButton (T("eventModeButton")));
    eventModeButton->setButtonText (T("Event Mode"));
    eventModeButton->setRadioGroupId (3);
    eventModeButton->addButtonListener (this);
    eventModeButton->setToggleState (true, false);

    addAndMakeVisible (bufferLatencyGroup = new GroupComponent (T("bufferLatencyGroup"),
                                                                T("Buffer Latency")));

    addAndMakeVisible (bufferLatacySlider = new Slider (T("bufferLatacySlider")));
    bufferLatacySlider->setRange (1, 100, 1);
    bufferLatacySlider->setSliderStyle (Slider::LinearHorizontal);
    bufferLatacySlider->setTextBoxStyle (Slider::NoTextBox, false, 80, 20);
    bufferLatacySlider->addListener (this);

    addAndMakeVisible (latencyMinLabel = new Label (T("latencyMinLabel"),
                                                    T("1ms")));
    latencyMinLabel->setFont (Font (11.2000f, Font::plain));
    latencyMinLabel->setJustificationType (Justification::centredLeft);
    latencyMinLabel->setEditable (false, false, false);
    latencyMinLabel->setColour (TextEditor::textColourId, Colours::black);
    latencyMinLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (latencyMaxLabel = new Label (T("latencyMaxLabel"),
                                                    T("100ms")));
    latencyMaxLabel->setFont (Font (11.2000f, Font::plain));
    latencyMaxLabel->setJustificationType (Justification::centredLeft);
    latencyMaxLabel->setEditable (false, false, false);
    latencyMaxLabel->setColour (TextEditor::textColourId, Colours::black);
    latencyMaxLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (OKButton = new TextButton (T("OKButton")));
    OKButton->setButtonText (T("OK"));
    OKButton->addButtonListener (this);

    addAndMakeVisible (CancelButton = new TextButton (T("CancelButton")));
    CancelButton->setButtonText (T("Cancel"));
    CancelButton->addButtonListener (this);


    //[UserPreSize]
    //[/UserPreSize]

    setSize (680, 310);

    //[Constructor] You can add your own custom stuff here..
	if(wasapi->isMMCSSEnabled())
	{
		enableMMCSSButton->setToggleState(true,false);
		switch(wasapi->getMmThreadPriority())
		{
		case sf::AVRT_PRIORITY_CRITICAL:
			MMCSSCriticalButton->setToggleState(true,false);
			break;
		case sf::AVRT_PRIORITY_HIGH:
			MMCSSHigh->setToggleState(true,false);
			break;
		case sf::AVRT_PRIORITY_NORMAL:
			MMCSSNormalButton->setToggleState(true,false);
			break;
		case sf::AVRT_PRIORITY_LOW:
			MMCSSLowButton->setToggleState(true,false);
			break;
		}
	} else {
		enableMMCSSButton->setToggleState(false,false);
		MMCSSCriticalButton->setEnabled(false);
		MMCSSHigh->setEnabled(false);
		MMCSSNormalButton->setEnabled(false);
		MMCSSLowButton->setEnabled(false);
	}

	wasaInterface_ = wasapi;
	boost::archive::text_oarchive ar(backup_);
	bufferLatacySlider->setRange(wasapi->getMinPeriod(),wasapi->getDefaultPeriod(),1);
	bufferLatacySlider->setValue(wasapi->getBufferLatency());
	latencyMaxLabel->setText((boost::wformat(L"%dms") % wasapi->getDefaultPeriod()).str().c_str(),false);
	latencyMinLabel->setText((boost::wformat(L"%dms") % wasapi->getMinPeriod()).str().c_str(),false);
	ar << (*wasapi);

//	valueChanged = false;
    //[/Constructor]
}

WASAPIControlPanel::~WASAPIControlPanel()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    deleteAndZero (MMCSSgroup);
    deleteAndZero (deviceSharingGroup);
    deleteAndZero (deviceModeExclusiveButton);
    deleteAndZero (deviceModeShareButton);
    deleteAndZero (playbackVolumeGroup);
    deleteAndZero (playbackVolumeslider);
    deleteAndZero (enableMMCSSButton);
    deleteAndZero (MMCSSHigh);
    deleteAndZero (MMCSSNormalButton);
    deleteAndZero (MMCSSCriticalButton);
    deleteAndZero (MMCSSLowButton);
    deleteAndZero (playbackModeGroup);
    deleteAndZero (pushmodeButton);
    deleteAndZero (eventModeButton);
    deleteAndZero (bufferLatencyGroup);
    deleteAndZero (bufferLatacySlider);
    deleteAndZero (latencyMinLabel);
    deleteAndZero (latencyMaxLabel);
    deleteAndZero (OKButton);
    deleteAndZero (CancelButton);

    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void WASAPIControlPanel::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.fillAll (Colours::white);

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void WASAPIControlPanel::resized()
{
    MMCSSgroup->setBounds (344, 24, 304, 144);
    deviceSharingGroup->setBounds (24, 24, 304, 64);
    deviceModeExclusiveButton->setBounds (48, 48, 112, 24);
    deviceModeShareButton->setBounds (200, 48, 104, 24);
    playbackVolumeGroup->setBounds (24, 96, 304, 72);
    playbackVolumeslider->setBounds (48, 120, 256, 24);
    enableMMCSSButton->setBounds (352, 80, 104, 24);
    MMCSSHigh->setBounds (472, 112, 56, 24);
    MMCSSNormalButton->setBounds (560, 56, 56, 24);
    MMCSSCriticalButton->setBounds (472, 56, 56, 24);
    MMCSSLowButton->setBounds (560, 112, 56, 24);
    playbackModeGroup->setBounds (24, 168, 304, 120);
    pushmodeButton->setBounds (40, 200, 88, 24);
    eventModeButton->setBounds (40, 240, 88, 24);
    bufferLatencyGroup->setBounds (136, 184, 184, 96);
    bufferLatacySlider->setBounds (176, 224, 104, 24);
    latencyMinLabel->setBounds (144, 224, 31, 24);
    latencyMaxLabel->setBounds (280, 224, 31, 24);
    OKButton->setBounds (496, 224, 150, 24);
    CancelButton->setBounds (496, 256, 150, 24);
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void WASAPIControlPanel::buttonClicked (Button* buttonThatWasClicked)
{
    //[UserbuttonClicked_Pre]
    //[/UserbuttonClicked_Pre]

    if (buttonThatWasClicked == deviceModeExclusiveButton)
    {
        //[UserButtonCode_deviceModeExclusiveButton] -- add your button handler code here..
		// wasaInterface_->setExclusiveMode(deviceModeExclusiveButton->getToggleState());
		if(!wasaInterface_->getExclusiveMode())
		{
			valueChanged_ = true;
		}
        //[/UserButtonCode_deviceModeExclusiveButton]
    }
    else if (buttonThatWasClicked == deviceModeShareButton)
    {
        //[UserButtonCode_deviceModeShareButton] -- add your button handler code here..
		if(wasaInterface_->getExclusiveMode())
		{
			valueChanged_ = true;
		}
		//wasaInterface_->setExclusiveMode(!deviceModeShareButton->getToggleState());
        //[/UserButtonCode_deviceModeShareButton]
    }
    else if (buttonThatWasClicked == enableMMCSSButton)
    {
        //[UserButtonCode_enableMMCSSButton] -- add your button handler code here..
		wasaInterface_->enableMMCSS(enableMMCSSButton->getToggleState());
		MMCSSStateChange();
        //[/UserButtonCode_enableMMCSSButton]
    }
    else if (buttonThatWasClicked == MMCSSHigh)
    {
        //[UserButtonCode_MMCSSHigh] -- add your button handler code here..
		wasaInterface_->setMmThreadPriority(sf::AVRT_PRIORITY_HIGH);
        //[/UserButtonCode_MMCSSHigh]
    }
    else if (buttonThatWasClicked == MMCSSNormalButton)
    {
        //[UserButtonCode_MMCSSNormalButton] -- add your button handler code here..
		wasaInterface_->setMmThreadPriority(sf::AVRT_PRIORITY_NORMAL);
        //[/UserButtonCode_MMCSSNormalButton]
    }
    else if (buttonThatWasClicked == MMCSSCriticalButton)
    {
        //[UserButtonCode_MMCSSCriticalButton] -- add your button handler code here..
		wasaInterface_->setMmThreadPriority(sf::AVRT_PRIORITY_CRITICAL);
        //[/UserButtonCode_MMCSSCriticalButton]
    }
    else if (buttonThatWasClicked == MMCSSLowButton)
    {
        //[UserButtonCode_MMCSSLowButton] -- add your button handler code here..
		wasaInterface_->setMmThreadPriority(sf::AVRT_PRIORITY_LOW);
        //[/UserButtonCode_MMCSSLowButton]
    }
    else if (buttonThatWasClicked == pushmodeButton)
    {
        //[UserButtonCode_pushmodeButton] -- add your button handler code here..

        //[/UserButtonCode_pushmodeButton]
    }
    else if (buttonThatWasClicked == eventModeButton)
    {
        //[UserButtonCode_eventModeButton] -- add your button handler code here..
        //[/UserButtonCode_eventModeButton]
    }
    else if (buttonThatWasClicked == OKButton)
    {
        //[UserButtonCode_OKButton] -- add your button handler code here..
		juce::DialogWindow* dlg = dynamic_cast<juce::DialogWindow*>(getParentComponent());
		dlg->closeButtonPressed();

		//[/UserButtonCode_OKButton]
    }
    else if (buttonThatWasClicked == CancelButton)
    {
        //[UserButtonCode_CancelButton] -- add your button handler code here..
		boost::archive::text_iarchive tia(backup_);
		tia >> (*wasaInterface_);
		juce::DialogWindow* dlg = dynamic_cast<juce::DialogWindow*>(getParentComponent());
		dlg->closeButtonPressed();
		//this->
	
        //[/UserButtonCode_CancelButton]
    }

    //[UserbuttonClicked_Post]
    //[/UserbuttonClicked_Post]
}

void WASAPIControlPanel::sliderValueChanged (Slider* sliderThatWasMoved)
{
    //[UsersliderValueChanged_Pre]
    //[/UsersliderValueChanged_Pre]

    if (sliderThatWasMoved == playbackVolumeslider)
    {
        //[UserSliderCode_playbackVolumeslider] -- add your slider handling code here..
        //[/UserSliderCode_playbackVolumeslider]
    }
    else if (sliderThatWasMoved == bufferLatacySlider)
    {
        //[UserSliderCode_bufferLatacySlider] -- add your slider handling code here..
        //[/UserSliderCode_bufferLatacySlider]
    }

    //[UsersliderValueChanged_Post]
    //[/UsersliderValueChanged_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...
//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Jucer information section --

    This is where the Jucer puts all of its metadata, so don't change anything in here!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="WASAPIControlPanel" componentName="WASAPI Control Panel"
                 parentClasses="public Component" constructorParams="sf::WASAPIInterface* wasapi"
                 variableInitialisers="" snapPixels="8" snapActive="1" snapShown="1"
                 overlayOpacity="0.330000013" fixedSize="0" initialWidth="680"
                 initialHeight="310">
  <BACKGROUND backgroundColour="ffffffff"/>
  <GROUPCOMPONENT name="MMCSSgroup" id="f570316aff63ee4b" memberName="MMCSSgroup"
                  virtualName="" explicitFocusOrder="0" pos="344 24 304 144" title="MMCSS"/>
  <GROUPCOMPONENT name="device Sharing Group" id="de842faf904e56d3" memberName="deviceSharingGroup"
                  virtualName="" explicitFocusOrder="0" pos="24 24 304 64" title="Device Sharing"/>
  <TOGGLEBUTTON name="deviceModeExclusiveButton" id="f00f943b21b10b5d" memberName="deviceModeExclusiveButton"
                virtualName="" explicitFocusOrder="0" pos="48 48 112 24" buttonText="Exclusive Mode"
                connectedEdges="0" needsCallback="1" radioGroupId="1" state="1"/>
  <TOGGLEBUTTON name="deviceModeShareButton" id="8a3a33afa4fd0a42" memberName="deviceModeShareButton"
                virtualName="" explicitFocusOrder="0" pos="200 48 104 24" buttonText="Share Mode"
                connectedEdges="0" needsCallback="1" radioGroupId="1" state="0"/>
  <GROUPCOMPONENT name="playbackVolumeGroup" id="fb0149d2177ac85d" memberName="playbackVolumeGroup"
                  virtualName="" explicitFocusOrder="0" pos="24 96 304 72" title="Playback Volume"/>
  <SLIDER name="playbackVolumeslider" id="72f4161cc0fbabd7" memberName="playbackVolumeslider"
          virtualName="" explicitFocusOrder="0" pos="48 120 256 24" min="0"
          max="1" int="0.01" style="LinearHorizontal" textBoxPos="TextBoxLeft"
          textBoxEditable="1" textBoxWidth="80" textBoxHeight="20" skewFactor="1"/>
  <TOGGLEBUTTON name="enableMMCSSButton" id="37bb190ce70ff3e5" memberName="enableMMCSSButton"
                virtualName="" explicitFocusOrder="0" pos="352 80 104 24" buttonText="Enable MMCSS"
                connectedEdges="0" needsCallback="1" radioGroupId="0" state="1"/>
  <TOGGLEBUTTON name="MMCSSHigh" id="166bcc72e96dde1c" memberName="MMCSSHigh"
                virtualName="" explicitFocusOrder="0" pos="472 112 56 24" buttonText="High"
                connectedEdges="0" needsCallback="1" radioGroupId="4" state="0"/>
  <TOGGLEBUTTON name="MMCSSNormalButton" id="463592eba4904b99" memberName="MMCSSNormalButton"
                virtualName="" explicitFocusOrder="0" pos="560 56 56 24" buttonText="Normal"
                connectedEdges="0" needsCallback="1" radioGroupId="4" state="0"/>
  <TOGGLEBUTTON name="MMCSSCriticalButton" id="e102657cad8cc52b" memberName="MMCSSCriticalButton"
                virtualName="" explicitFocusOrder="0" pos="472 56 56 24" buttonText="Critical"
                connectedEdges="0" needsCallback="1" radioGroupId="4" state="1"/>
  <TOGGLEBUTTON name="MMCSSLowButton" id="14e8030ee844c0c3" memberName="MMCSSLowButton"
                virtualName="" explicitFocusOrder="0" pos="560 112 56 24" buttonText="Low"
                connectedEdges="0" needsCallback="1" radioGroupId="4" state="0"/>
  <GROUPCOMPONENT name="playbackModeGroup" id="b744c808179aca47" memberName="playbackModeGroup"
                  virtualName="" explicitFocusOrder="0" pos="24 168 304 120" title="Playback Mode"/>
  <TOGGLEBUTTON name="pushmodeButton" id="a243dafc3f227e2c" memberName="pushmodeButton"
                virtualName="" explicitFocusOrder="0" pos="40 200 88 24" buttonText="Push Mode"
                connectedEdges="0" needsCallback="1" radioGroupId="3" state="0"/>
  <TOGGLEBUTTON name="eventModeButton" id="ac34a480091b482f" memberName="eventModeButton"
                virtualName="" explicitFocusOrder="0" pos="40 240 88 24" buttonText="Event Mode"
                connectedEdges="0" needsCallback="1" radioGroupId="3" state="1"/>
  <GROUPCOMPONENT name="bufferLatencyGroup" id="7c390e1cd9149299" memberName="bufferLatencyGroup"
                  virtualName="" explicitFocusOrder="0" pos="136 184 184 96" title="Buffer Latency"/>
  <SLIDER name="bufferLatacySlider" id="f082a73036b39afe" memberName="bufferLatacySlider"
          virtualName="" explicitFocusOrder="0" pos="176 224 104 24" min="1"
          max="100" int="1" style="LinearHorizontal" textBoxPos="NoTextBox"
          textBoxEditable="1" textBoxWidth="80" textBoxHeight="20" skewFactor="1"/>
  <LABEL name="latencyMinLabel" id="3902f369abb19ae1" memberName="latencyMinLabel"
         virtualName="" explicitFocusOrder="0" pos="144 224 31 24" edTextCol="ff000000"
         edBkgCol="0" labelText="1ms" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="11.2"
         bold="0" italic="0" justification="33"/>
  <LABEL name="latencyMaxLabel" id="28a8ce91dbb915fb" memberName="latencyMaxLabel"
         virtualName="" explicitFocusOrder="0" pos="280 224 31 24" edTextCol="ff000000"
         edBkgCol="0" labelText="100ms" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="11.2"
         bold="0" italic="0" justification="33"/>
  <TEXTBUTTON name="OKButton" id="efefe9bec6189fcb" memberName="OKButton" virtualName=""
              explicitFocusOrder="0" pos="496 224 150 24" buttonText="OK" connectedEdges="0"
              needsCallback="1" radioGroupId="0"/>
  <TEXTBUTTON name="CancelButton" id="4e027ec1e85f2a20" memberName="CancelButton"
              virtualName="" explicitFocusOrder="0" pos="496 256 150 24" buttonText="Cancel"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif
