/* basic.c

   some of X-BASIC compatible functions

   Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "../sted.h"
#include "sted_screen.h"

extern "C" {

/* graphic functions */

void
fill( int in_x0, int in_y0, int in_x1, int in_y1, unsigned int in_col )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->GraphicsFill(in_x0, in_y0, in_x1, in_y1, in_col);
  return;
}

void
box( int in_x0, int in_y0, int in_x1, int in_y1, unsigned int in_col, unsigned int in_ls )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->GraphicsBox(in_x0, in_y0, in_x1, in_y1, in_col, in_ls);
  return;
}

int
point( int in_x, int in_y )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->GraphicsPoint(in_x, in_y);
}

void
line( int in_x0, int in_y0, int in_x1, int in_y1, int in_col, int in_ls )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->GraphicsLine(in_x0, in_y0, in_x1, in_y1, in_col, in_ls);
  return;
}

void
symbol( int in_x, int in_y, char *in_st, char in_h, char in_v, char in_mo, int in_p, char in_an )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->SetGraphicsColor(in_p);
  scr->GraphicsPuts(in_x, in_y, in_st);
  return;
}


/* other functions */

/* returns string describing current day(?) */
char *dtasc( unsigned int j ) {

  static char dtasc_name[10];
  int y,a,b;

  a=(j>>9)&0x7f;
  b=a%10;
  a=a%100-b;
  y=a+b;
  
  snprintf(dtasc_name, 10, "%02d-%02d-%02d", y, ((j>>5)&0x0f)+1, j&0x1f );

  return dtasc_name;
}

/* returns string describing current time(?) */
char *tmasc( unsigned int j ) {

  static char tmasc_name[10];

  snprintf(tmasc_name, 10, "%02d:%02d:%02d", (j>>11)&0x1f, (j>>5)&0x3f, (j&0x1f)*2 );
  return tmasc_name;
}

/* returns mouse positions */
int 
mspos( int *out_x, int *out_y )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;
  return scr->GetMousePos(out_x, out_y);
}

/* returns someting B-) */
void b_striS ( char * buf, int bufSize, int num ) {
  int r;

  r=snprintf( buf, bufSize, "%d", num );
  if ( r < 0 ) {
    buf[0]='\0';
  }
  return;
}

/* set current Kanji mode */
void KNJCTRL( int i, int j ) {

  /* not implemented */
  return;
}

}
