/*
  iocs_graph.c

  functions for compatibility to iocslib
  ( containing mainly graphics oriented functions )

  Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "../sted.h"
#include "sted_screen.h"

extern "C" {

/* variables */

int iocs_graph_home;

/* functions */

int
_iocs_crtmod( int in_mode )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  if ( in_mode < 0x100 ) {
    if ( in_mode==17 ) {
      scr->CloseWindow();
    } else {
      scr->InitWindow();
      scr->ClsAll();
    }
  }

  return 0;
}

void
_iocs_g_clr_on( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->GraphicsClear();

  return;
}

int
_iocs_gpalet( int in_no, int in_color )
{
  int ret=0;
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  ret = scr->SetGraphicsPalette(in_no, in_color);
  return ret;
}

int
_iocs_home( int in_page, int in_x, int in_y )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  /* y=0 or 512 ( page select? ) */

  iocs_graph_home = in_y>511 ? 1:0;
  scr->GraphicsHome(iocs_graph_home);
  return 0;
}

int
_iocs_tgusemd( int text_gr, int mode )
{
  return 0; /* G-RAM is not used */
}

int
_iocs_window( int sx, int sy, int ex, int ey )
{

  return 0; /* ignore */
}

}
