/*
  iocs_tgraph.c

  functions for compatibility to iocslib
  ( containing mainly text-graphics oriented functions )

  Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "../sted.h"
#include "sted_screen.h"

extern "C" {

int
_iocs_tpalet( int in_no, int in_code )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->SetTextPalette(in_no, in_code);
}

void
_iocs_txbox( const struct _x68_txfillptr *ptr )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->TextXBox( ptr->x, ptr->y, ptr->x1, ptr->y1, ptr->vram_page );
  return;
}

void
_iocs_txfill ( const struct _x68_txfillptr *ptr )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->TextFill( ptr->vram_page, ptr->x, ptr->y, ptr->x1, ptr->y1, ptr->fill_patn );

  return;
}

void
_iocs_txrascpy ( int sr_dst, int copy, int mode )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;
  scr->TextRasterCopy( sr_dst&0xff, sr_dst>>8, copy, mode );
  return;
}

void
_iocs_txxline ( const struct _x68_xlineptr *ptr )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->TextXXLine( ptr->vram_page, ptr->x, ptr->y, ptr->x1, ptr->line_style );
  return;
}

void
_iocs_txyline ( const struct _x68_ylineptr *ptr )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->TextXYLine( ptr->vram_page, ptr->x, ptr->y, ptr->y1, ptr->line_style );
  return;
}

}
