/*
  x68funcs.c

  functions for compatibility to X680x0

  Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "../sted.h"
#include "sted_screen.h"

/* global variables */

extern "C" {

const int x68_scancode[]={
  0x35, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
  0x09, 0x0a, 0x28, 0x27, 0x31, 0x0c, 0x32, 0x33,
  0x0b, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
  0x09, 0x0a, 0x28, 0x27, 0x31, 0x0c, 0x32, 0x33,
  0x1b, 0x1e, 0x2e, 0x2c, 0x20, 0x13, 0x21, 0x22,
  0x23, 0x18, 0x24, 0x25, 0x26, 0x30, 0x2f, 0x19,
  0x1a, 0x11, 0x14, 0x1f, 0x15, 0x17, 0x2d, 0x12,
  0x2b, 0x16, 0x2a, 0x1c, 0x0e, 0x29, 0x0d, 0x34,
  0x1b, 0x1e, 0x2e, 0x2c, 0x20, 0x13, 0x21, 0x22,
  0x23, 0x18, 0x24, 0x25, 0x26, 0x30, 0x2f, 0x19,
  0x1a, 0x11, 0x14, 0x1f, 0x15, 0x17, 0x2d, 0x12,
  0x2b, 0x16, 0x2a, 0x1c, 0x0e, 0x29, 0x0d
};

/*
  void strmfe( char dest, *char *node , char *extention )

   destination = node.ext
 */

void strmfe( char *dest, const char *node, const char *ext ) {

  char *last,*temp;

  temp = (char *)malloc( sizeof(char) * 1024 );

  if ( ((last=const_cast<char*>(strrchr(node, (int)'.'))) != NULL) &&
      (((int)*(last-1)!='.') && ((int)*(last+1)!='/'))) {
    strncpy( temp, node, (size_t)(last-node+1));
    strcat( temp, ext );
  } else {
    strcpy( temp, node );
    strcat( temp, "." );
    strcat( temp, ext );
  }

  strcpy( dest, temp );
  free(temp);
  return;
}

/*
  double val( char *st )

   converts numeric strings to floating pointted number
 */

double val( char *st ) {

/* original "val" function allows following expressions:
    &Hxx
    &Oxx
    &Boo
 */

  return(atof(st));
}

/*
  child ( char *cl )

   execute specified commands in child process
 */

int child( char *cl ) {

  int ret;
  int l;
  char tmp[1024];

  strcpy( tmp, cl );
  l=strlen( tmp );
  for ( ;l>=2;l-- ) {
    if ( tmp[l]==':'  && isalpha(tmp[l-1]) && (tmp[l-2]==' ' || l==0) ) {
      tmp[l--]=' ';
      tmp[l--]=' ';
    }
  }

  ret=system( tmp );
  return ret;
}

/*
 */

void
key_wait( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;
  scr->KeyWait();
}

void
key_midi_wait( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;
  scr->MidiWait();
}

void
key_mouse_wait( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;
  scr->MouseWait();
}

void
key_midi_player_wait( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;
  scr->MidiPlayerWait();
}

int
sted_sleep(long in_usec)
{
	CSTedScreenBase* scr;

	scr = GetDriver();
	if (!scr) return 0;
	scr->USleep(in_usec);
}

void
disable_update_screen(void)
{
	CSTedScreenBase* scr;

	scr = GetDriver();
	if (!scr) return;
	scr->DisableUpdateWindow();
}

void
update_screen(void)
{
	CSTedScreenBase* scr;

	scr = GetDriver();
	if (!scr) return;
	scr->UpdateWindow();
}


/* system initialize */

static CSTedScreenBase* fScreenDriver = NULL;

void
STed_system_initialize( int *argc, char ***argv )
{
  rcd = NULL;
  issted3 = 0;

  fScreenDriver = NULL;

  fScreenDriver = CreateScreenDriver(16);
  fScreenDriver->KeyInit();
  fScreenDriver->SetX68ScanCode(x68_scancode);
  return;
}

}

CSTedScreenBase*
GetDriver(void)
{
  return fScreenDriver;
}
