#pragma once
/*
  ==============================================================================

   This file is part of the WinAudioJuce
   Copyright 2010 by Satoshi Fujiwara.

   S.F.Tracker can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   S.F.Tracker is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with S.F.Tracker; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/

namespace boost {
namespace serialization {

	template<class Archive>
	inline void save(Archive & ar, const juce::String & s, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("JuceString",std::wstring(s));
	}

	template<class Archive>
	inline void load(Archive & ar, juce::String & s, const unsigned int version)
	{
		std::wstring s1;
		ar & boost::serialization::make_nvp("JuceString",s1);
		s = s1.c_str();
	}

	template <class Archive>
		void serialize(Archive& ar, juce::PluginDescription& pd, const unsigned int version)
		{
			ar & make_nvp("Category",pd.category);
			ar & make_nvp("fileOrIdentifier",pd.fileOrIdentifier);
			ar & make_nvp("isInstrument",pd.isInstrument);
			ar & make_nvp("lastFileModTime",pd.lastFileModTime);
			ar & make_nvp("manufacturerName",pd.manufacturerName);
			ar & make_nvp("name",pd.name);
			ar & make_nvp("numInputChannels",pd.numInputChannels);
			ar & make_nvp("numOutputChannels",pd.numOutputChannels);
			ar & make_nvp("pluginFormatName",pd.pluginFormatName);
			ar & make_nvp("uid",pd.uid);
			ar & make_nvp("version",pd.version);
		}

	template <class Archive>
	void save(Archive& ar,const juce::Time& t, const unsigned int version)
	{
		//juce::int64 intmillisSinceEpoch;
		ar & make_nvp("TimeValue",t.toMilliseconds());

	}

	template <class Archive>
		void load(Archive& ar,juce::Time& t, const unsigned int version)
	{
		juce::int64 intmillisSinceEpoch;
		ar & make_nvp("TimeValue",intmillisSinceEpoch);
		t = juce::Time(intmillisSinceEpoch);
	}

	template <class Archive>
	void save(Archive& ar,const juce::MemoryBlock& m, const unsigned int version)
	{
		//int size = m.getSize();
		//ar & make_nvp("MemoryBrockSize",size);
		//const char * mem = (const char * )m.getData();
		//for(int i = 0;i < size;++i)
		//{
		//	ar & make_nvp("Data",*mem);
		//	++mem;
		//}

		ar & make_nvp("Data",m.toHexString());

	}


	template <class Archive>
		void load(Archive& ar,juce::MemoryBlock& m, const unsigned int version)
	{
		//int size;
		//ar & make_nvp("MemoryBrockSize",size);
		//m.setSize(size);
		//char * mem = (char * )m.getData(); 
		//for(int i = 0;i < size;++i)
		//{
		//	char d;
		//	ar & make_nvp("Data",d);
		//	mem[i] = d;
		//}
		juce::String data;
		ar & make_nvp("Data",data);
		m.loadFromHexString(data);
	}

}
}

BOOST_SERIALIZATION_SPLIT_FREE(juce::String);
BOOST_SERIALIZATION_SPLIT_FREE(juce::Time);
BOOST_SERIALIZATION_SPLIT_FREE(juce::MemoryBlock);

