{
SSTP Bottle Surface Preview Plug-In for "SVG"
(C)2003 naru, Mikage Sawatari / SSTP Bottle
}

library TSG;

{$R *.res}

uses
  Windows, Classes, SysUtils, Graphics, IniFiles, Dialogs, PngImage;

const
  ConfigFile = 'TSG.ini';

var
  MyPath: String;
  TalkShow: String;
  Ghost2File: TStringList;

  Pic: TPicture;       // ǂݎ摜(*.png)
  PicFileName: String; // ̃t@C


procedure LoadGhosts(GhostDir: String);
var F: TSearchRec;
    i: integer;
    Ini: TIniFile;
    Ghost: String;
    IniFileName: String;
begin
  Ghost2File.Clear;
  i := FindFirst(GhostDir + '\*', FaDirectory, F);
  if i = 0 then begin
    repeat
      if (F.Name <> '..') and (F.Name <> '.') then
      begin
        try
          IniFileName := GhostDir + '\' + F.Name + '\ghost.ini';
          if FileExists(IniFileName) then
          begin
            Ini := TIniFIle.Create(IniFileName);
            Ghost := Ini.ReadString('General', 'SakuraName', '');
            if Ghost <> '' then
            begin
              Ghost2File.Values[Ghost] := F.Name;
            end;
          end;
        except
          ;
        end;
      end;
      i := FindNext(F);
    until i <> 0;
  end;
  FindClose(F);
end;

procedure Load(Path: PChar); cdecl;
var Ini: TIniFile;
begin
  MyPath := Path;
  Ini := TIniFile.Create(MyPath + ConfigFile);
  try
    TalkShow := Ini.ReadString('TSG', 'TalkShow', '');
  finally
    Ini.Free;
  end;

  Ghost2File := TStringList.Create;

  if not FileExists(TalkShow) then
    ShowMessage('TSG.dll Warning: Ghost file is not specified')
  else
    LoadGhosts(ExtractFileDir(TalkShow) + '\Ghost');

  Pic := TPicture.Create;
  PicFileName := '';
end;

procedure Unload; cdecl;
begin
  Ghost2File.Free;
  Pic.Free;
end;

function GetVersion(DLLName: PChar; NameLen: integer;
  var Version: integer; var CanConfigure: boolean): integer; cdecl;
const ThisDLL = 'TSG Surface Loader Ver. 1.0';
begin
  Version := 1;
  CanConfigure := true;
  StrLCopy(DLLName, ThisDLL, NameLen);
  Result := Length(ThisDLL) + 1;
end;

function FetchBmpFile(Ghost: String; Surface: integer): String;
var FileName: String;
begin
  Result := '';
  if Ghost2File.Values[Ghost] = '' then
    Exit
  else
  begin
    FileName := ExtractFilePath(TalkShow) + '\Ghost\' +
      Ghost2File.Values[Ghost] + '\' + IntToStr(Surface) + '.png';
    if FileExists(FileName) then
    begin
      Result := FileName;
    end;
  end;
end;

// GhostŎw肳S[XgSurfaceԂ̃T[tBXC[WۂɓǂݏoB
// HŎw肳Ărbg}bvɏoƁB
function GetImage(Ghost: PChar; Surface: integer; H: HBITMAP): integer; cdecl;
var Bmp: TBitmap;
    BmpFile: String;
begin
  try
    BmpFile := FetchBmpFile(Ghost, Surface);
    if BmpFile = '' then // ̂悤ȃS[Xĝ̂悤ȃT[tBX͌Ȃ
    begin
      Result := 1;
      Exit;
    end;
    Bmp := TBitmap.Create;
    try
      Bmp.Handle := H;
      if PicFileName <> BmpFile then
      begin
        try
          Pic.LoadFromFile(BmpFile);
          PicFileName := BmpFile;
        except
          // 蒼
          FreeAndNil(Pic);
          Pic := TPicture.Create;
          PicFileName := '';
          raise;
        end;
      end;
      Bmp.Canvas.Draw(0, 0, Pic.Graphic);
    finally
      Bmp.ReleaseHandle;
      Bmp.Free;
    end;
    Result := 0;
  except
    Result := 1;
  end;
end;

function GetImageSize(Ghost: PChar; Surface: integer;
  var w, h: integer): integer; cdecl;
var BmpFile: String;
begin
  try
    BmpFile := FetchBmpFile(Ghost, Surface);
    if BmpFile = '' then // ̂悤ȃS[Xĝ̂悤ȃT[tBX͌Ȃ
    begin
      Result := 1;
      Exit;
    end;
    if PicFileName <> BmpFile then
    begin
      try
        Pic.LoadFromFile(BmpFile);
        PicFileName := BmpFile;
      except
        // 蒼
        FreeAndNil(Pic);
        Pic := TPicture.Create;
        PicFileName := '';
        raise;
      end;
    end;
    w := Pic.Width;
    h := Pic.Height;
    Result := 0;
  except
    Result := 1;
  end;
end;

// DLLŗL̐ݒsB
//
procedure Configure; cdecl;
var OpenDialog: TOpenDialog;
    Ini: TIniFile;
begin
  try
    ShowMessage('Specify the loaction of TalkShow.exe.');
    OpenDialog := TOpenDialog.Create(nil);
    try
      OpenDialog.Filter := 'TalkShow Application(TalkShow.exe)|TalkShow.exe|' +
       'All Files(*.*)|*.*';
      OpenDialog.FileName := TalkShow;
      if OpenDialog.Execute then
      begin
        TalkShow := OpenDialog.FileName;
        Ini := TIniFile.Create(MyPath + ConfigFile);
        try
          Ini.WriteString('TSG', 'TalkShow', TalkShow);
        finally
          Ini.Free;
        end;
        Ghost2File.Clear;
        LoadGhosts(ExtractFileDir(TalkShow) + '\Ghost');
      end;
    finally
      OpenDialog.Free;
    end;
  except
    on E: Exception do
      ShowMessage(E.Message);
  end;
end;

exports
  Load,
  Unload,
  GetVersion,
  Configure,
  GetImage,
  GetImageSize;

begin

end.
