package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import java.io.File;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ReportProperty;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ex.WriteException;


public abstract class HtmlConverter {
    
    protected String xml;
    protected String dest;
    protected ReportProperty prop;
    
    public HtmlConverter(String xml, String dest, ReportProperty prop) {
        this.xml = xml;
        this.dest = dest;
        this.prop = prop;
    }
    
    public void convert() throws WriteException {
        preConvert();
        
        File xsltFile = prop.getXslt();
        Source xmlSource = new StreamSource(new File(xml));
        Source xslt = new StreamSource(xsltFile);
        Result result = getTransformResult();
        
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer(xslt);
            configTransformer(tf);
            tf.transform(xmlSource, result);
        } catch (TransformerConfigurationException e) {
            throw new WriteException(e);
        } catch (TransformerException e) {
            throw new WriteException(e);
        } finally {
            postConvert();
        }
    }
    
    protected void configTransformer(Transformer tf) {
    }

    protected abstract Result getTransformResult();
    protected abstract void preConvert();
    protected abstract void postConvert();
    
}
