package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


public class TestSuiteVO {
    
    private String id;
    private String name;
    private List testCases;
    
    private long failures;
    private long errors;
    private long time;
    private Date timeStamp;
    
    public TestSuiteVO(String id, String name) {
        this.id = id;
        this.name = name;
        
        this.testCases = new ArrayList();
        this.timeStamp = new Date();
    }
    
    public void addTestCase(TestCaseVO testCase) {
        testCases.add(testCase);
        time += testCase.getTime();
        
        if (testCase.isError()) {
            errors++;
        } else if (testCase.isFailure()) {
            failures++;
        }
        
    }
    
    public String getId() {
        return id;
    }
    
    public double getTimeInSecond() {
        return time / 1000.;
    }
    
    public String getName() {
        return name;
    }
    
    public List getTestCases() {
        return testCases;
    }
    
    public long getTests() {
        return testCases.size();
    }
    
    public long getFailures() {
        return failures;
    }
    
    public long getErrors() {
        return errors;
    }
    
    public long getTime() {
        return time;
    }
    
    public Date getTimeStamp() {
        return timeStamp;
    }
    
    public String getPackage() {
        int index = name.lastIndexOf('.');
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

}
