package jp.gr.java_conf.ykhr.common.converter;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import jp.gr.java_conf.ykhr.common.ex.ReadException;
import jp.gr.java_conf.ykhr.common.utils.ReaderUtils;
import jp.gr.java_conf.ykhr.common.utils.Utils;

public class HeaderBaseConverter implements Converter {

    public <T> Collection<T> toBeanCollection(Class<T> clazz, Collection<String[]> elements) throws ReadException {

        Map<String, PropertyDescriptor> nameToProperty = getNameToPropertyMapping(clazz);

        Collection<T> beans = new ArrayList<T>();
        Iterator<String[]> iter = elements.iterator();
        String[] header = iter.next();

        // validate
        checkNotSameHeader(header);
        Set<String> ignores = getIgnoreHeader(header, nameToProperty);
        logInnoreHeader(ignores);

        for (; iter.hasNext();) {
            String[] data = iter.next();
            T bean = ReaderUtils.createBeanInstance(clazz);

            for (int i = 0; i < data.length; i++) {
                PropertyDescriptor desc = nameToProperty.get(header[i]);
                if (desc == null) {
                    continue;
                }
                
                Method method = desc.getWriteMethod();
                Class<?>[] types = method.getParameterTypes();
                if (types.length < 1) {
                    continue;
                }
                Object param = ReaderUtils.convertType(data[i], types[0]);
                if (param != null) {
                    ReaderUtils.setObject(bean, method, param);
                }
            }

            beans.add(bean);
        }

        return beans;
    }

    private void logInnoreHeader(Set<String> ignores) {
        // TODO Auto-generated method stub
        
    }

    /**
     * Beanɑ݂Ȃwb_[擾B
     * 
     * @param headers
     * @param nameToProperty
     * @return
     */
    private Set<String> getIgnoreHeader(String[] headers, Map<String, PropertyDescriptor> nameToProperty) {
        Set<String> result = new HashSet<String>();
        for (String header : headers) {
            if (!nameToProperty.containsKey(header)) {
                result.add(header);
            }
        }
        return result;
    }

    /**
     * ̃wb_[ȂȂ`FbNB
     * 
     * @param header
     * @throws ReadException
     */
    private void checkNotSameHeader(String[] header) throws ReadException {
        Set<String> set = new HashSet<String>(Arrays.asList(header));
        if (set.size() != header.length) {
            throw new ReadException();
        }
    }

    /**
     * wb_[ƃvpeB̃}bsO擾B
     * @param <T>
     * @param clazz
     * @return
     * @throws ReadException
     */
    private <T> Map<String, PropertyDescriptor> getNameToPropertyMapping(Class<T> clazz) throws ReadException {
        try {
            return Utils.createCsvNameToProperty(clazz);
        } catch (IntrospectionException e) {
            throw new ReadException(e);
        }
    }

}
