package jp.gr.java_conf.ykhr.csvutil;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

import jp.gr.java_conf.ykhr.SampleBean;
import jp.gr.java_conf.ykhr.common.converter.MapConverter;
import jp.gr.java_conf.ykhr.common.converter.PriorityConverter;
import jp.gr.java_conf.ykhr.csvutil.config.ReaderConfig;
import jp.gr.java_conf.ykhr.csvutil.core.CSVReader;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SampleCsvReadTest {
    
    @Before
    public void before() {
        System.out.println("start***");
    }
    
    @After
    public void after() {
        System.out.println("end***");
        System.out.println();
    }
    
    @Test
    public void read01() throws Exception {
        CSVReader reader = new CSVReader();
        
        InputStream is = getResourceAsStream("sample_read1.csv");
        
        Collection<SampleBean> list = reader.read(is, SampleBean.class);
        for (SampleBean bean : list) {
            System.out.println(bean);
        }
    }
    
    @Test
    public void read02() throws Exception {
        CSVReader reader = new CSVReader(new PriorityConverter());
        ReaderConfig config = new ReaderConfig();
        config.setExistHeader(false);
        
        InputStream is = getResourceAsStream("sample_read2.csv");
        
        Collection<SampleBean> list = reader.read(is, SampleBean.class, config);
        for (SampleBean bean : list) {
            System.out.println(bean);
        }
        
    }
    
    @Test
    public void read03() throws Exception {
        CSVReader reader = new CSVReader(new PriorityConverter());
        ReaderConfig config = new ReaderConfig();
        config.setSeparator("\t");
        config.setExistHeader(false);
        
        InputStream is = getResourceAsStream("sample_read3.csv");
        
        Collection<SampleBean> list = reader.read(is, SampleBean.class, config);
        for (SampleBean bean : list) {
            System.out.println(bean);
        }
    }
    
    @Test
    @SuppressWarnings("unchecked")
    // 芴̂Map
    public void read04() throws Exception {
        CSVReader reader = new CSVReader(new MapConverter());
        
        InputStream is = getResourceAsStream("sample_read1.csv");
        
        Collection<Map> list = reader.read(is, Map.class);
        for (Map bean : list) {
            System.out.println(bean);
        }
    }
    
    private InputStream getResourceAsStream(String str) {
        return getClass().getClassLoader().getResourceAsStream(str);
    }

}
