package jp.gr.java_conf.ykhr.csvutil;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Map.Entry;

import jp.gr.java_conf.ykhr.SampleBean;
import jp.gr.java_conf.ykhr.common.ex.WriteException;
import jp.gr.java_conf.ykhr.csvutil.config.WriteConfig;
import jp.gr.java_conf.ykhr.csvutil.core.CSVWriter;

import org.junit.Test;


public class SampleCsvWriteTest {
    
    @Test
    public void write01() {
        List<SampleBean> list = new ArrayList<SampleBean>();
        SampleBean bean1 = new SampleBean();
        bean1.setName("ykhr");
        bean1.setAge(26);
        bean1.setNickName("ykhr-kokko");
        list.add(bean1);
        
        SampleBean bean2 = new SampleBean();
        bean2.setName("kokko");
        bean2.setAge(23);
        bean2.setNickName("xxxxx");
        list.add(bean2);

        SampleBean bean3 = new SampleBean();
        bean3.setName("hoge\"-\"foo");
        bean3.setAge(99);
        bean3.setNickName("hoge\r\nfoo");
        bean3.setTekitouField("tekitou");
        list.add(bean3);
        
        SampleBean bean4 = new SampleBean();
        bean4.setName("null-man");
        bean4.setNickName(null);
        bean4.setAge(40);
        list.add(bean4);
        
        CSVWriter writer = new CSVWriter();
        try {
            writer.write(new File("target/choco_csvutil/sample_write1.csv"), list, SampleBean.class);
        } catch (WriteException e) {
            e.printStackTrace();
        }
    }
    
    @Test
    public void write02() {
        List<SampleBean> list = new ArrayList<SampleBean>();
        SampleBean bean1 = new SampleBean();
        bean1.setName("ykhr");
        bean1.setAge(26);
        bean1.setNickName("ykhr-kokko");
        list.add(bean1);
        
        SampleBean bean2 = new SampleBean();
        bean2.setName("kokko");
        bean2.setAge(23);
        bean2.setNickName("xxxxx");
        list.add(bean2);

        SampleBean bean3 = new SampleBean();
        bean3.setName("hoge\"-\"foo");
        bean3.setAge(99);
        bean3.setNickName("hoge\r\nfoo");
        bean3.setTekitouField("tekitou");
        list.add(bean3);
        
        SampleBean bean4 = new SampleBean();
        bean4.setName("null-man");
        bean4.setNickName(null);
        bean4.setAge(40);
        list.add(bean4);
        
        CSVWriter writer = new CSVWriter();
        WriteConfig config = new WriteConfig();
        config.setSeparator("\t");
        config.setWriteHeader(false);
        config.setQuoteAlways(false);
        
        try {
            writer.write(new File("target/choco_csvutil/sample_write2.csv"), list, SampleBean.class, config);
        } catch (WriteException e) {
            e.printStackTrace();
        }
    }
    
    @Test
    public void test() {
        Properties p = System.getProperties();
        for (Entry<Object ,Object> entry : p.entrySet()) {
            System.out.println(entry.getKey()+ ":" + entry.getValue());
        }
    }

}
