package jp.gr.java_conf.ykhr.excelutil;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

import jp.gr.java_conf.ykhr.SampleBean;
import jp.gr.java_conf.ykhr.common.converter.MapConverter;
import jp.gr.java_conf.ykhr.common.converter.PriorityConverter;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;


public class SampleExcelReadTest {
    
    @Before
    public void before() {
        System.out.println("start***");
    }
    
    @After
    public void after() {
        System.out.println("end***");
        System.out.println();
    }
    
    @Test
    public void test01() throws Exception {
        ExcelReader reader = new ExcelReader();
        
        InputStream is = getResourceAsStream("sample_read1.xls");
        
        Collection<SampleBean> list = reader.read(is, SampleBean.class);
        for (SampleBean bean : list) {
            System.out.println(bean);
        }
    }

    @Test
    public void test02() throws Exception {
        ExcelReader reader = new ExcelReader(new PriorityConverter(true));
        
        InputStream is = getResourceAsStream("sample_read1.xls");
        
        Collection<SampleBean> list = reader.read(is, SampleBean.class);
        for (SampleBean bean : list) {
            System.out.println(bean);
        }
    }

    @Test
    @SuppressWarnings("unchecked")
    public void test03() throws Exception {
        ExcelReader reader = new ExcelReader(new MapConverter());
        
        InputStream is = getResourceAsStream("sample_read1.xls");
        
        Collection<Map> list = reader.read(is, Map.class);
        for (Map bean : list) {
            System.out.println(bean);
        }
    }
    
    private InputStream getResourceAsStream(String str) {
        return getClass().getClassLoader().getResourceAsStream(str);
    }
    
}
