package jp.xet.eclipse.memopad.actions;

import jp.xet.eclipse.memopad.MemopadPlugin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

/**
 * Show Memopad Action.
 * @author ykhr
 */
public class ShowMemopadAction implements IWorkbenchWindowActionDelegate {
    
    /**
     * IWorkbenchWindow
     */
    private IWorkbenchWindow window = null;

    /**
     * @{inheritDoc}
     */
    public void dispose() {
    }

    /**
     * @{inheritDoc}
     */
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    /**
     * @{inheritDoc}
     */
    public void run(IAction action) {
        try {
            window.getActivePage().showView(MemopadPlugin.VIEW_ID);            
        } catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    /**
     * @{inheritDoc}
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }

}
