package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class XsltDialog extends Dialog {
    
    private IProject project;
    private InputCache cache;
    private Text inText = null;
    private Text outText = null;
    private Text propText = null;
    
    private String input;
    private String output;
    private String property;
    
    public XsltDialog(Shell parentShell, IFile xslFile, InputCache cache) {
        super(parentShell);
        this.project = xslFile.getProject();
        this.cache = cache;
        
        if (cache.hasLastConfig()) {
            input = cache.getStoreValue(InputCache.KEY_INPUT);
            output = cache.getStoreValue(InputCache.KEY_OUTPUT);
            property = cache.getStoreValue(InputCache.KEY_PROPERTY);
        } else {
            input = ""; //$NON-NLS-1$
            output = ""; //$NON-NLS-1$
            property = ""; //$NON-NLS-1$
        }
    }
    
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Dialog_Title);
    }
    
    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite) super.createDialogArea(parent);
        
        Composite composite = new Composite(comp, SWT.NONE);
        composite.setLayout(new GridLayout(3, false));
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        
        Label inLabel = new Label(composite, SWT.NULL);
        inLabel.setText(Messages.Dialog_Xslt_Input);
        
        inText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        inText.setText(input);
        GridData inTextData = new GridData(GridData.FILL_HORIZONTAL);
        inTextData.widthHint = 200;
        inText.setLayoutData(inTextData);
        
        Button inButton = new Button(composite, SWT.PUSH);
        inButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        inButton.setText(Messages.Dialog_Browse);
        SelectResourceListener inListener 
            = new SelectResourceListener(project, inText, ".xml", //$NON-NLS-1$
                    Messages.Dialog_Title_SelectXml);
        inButton.addSelectionListener(inListener);
        
        new Label(composite, SWT.NULL).setText(Messages.Dialog_Xslt_Output);
        outText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        outText.setText(output);
        outText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        new Label(composite, SWT.NULL); // dummy
        
        new Label(composite, SWT.NULL).setText(Messages.Dialog_Xslt_Parameter);
        propText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        propText.setText(property);
        propText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        Button propButton = new Button(composite, SWT.PUSH);
        propButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        propButton.setText(Messages.Dialog_Browse);
        SelectResourceListener propListener 
            = new SelectResourceListener(project, propText, ".properties", //$NON-NLS-1$
                    Messages.Dialog_Title_SelectProperty);
        propButton.addSelectionListener(propListener);
        
        return composite;
    }
    
    protected void okPressed() {
        input = inText.getText();
        output = outText.getText();
        property = propText.getText();
        cache.storeLastValue(InputCache.KEY_INPUT, input);
        cache.storeLastValue(InputCache.KEY_OUTPUT, output);
        cache.storeLastValue(InputCache.KEY_PROPERTY, property);
        super.okPressed();
    }
    
    public String getInput() {
        return input;
    }
    
    public String getOutput() {
        return output;
    }
    
    public String getProperty() {
        return property;
    }
    
    private static class FileExtensionFilter extends ViewerFilter {
        private String ext;
        
        public FileExtensionFilter(String ext) {
            this.ext = ext;
        }
        
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return true;
            } else if (element instanceof IFile) {
                IFile file = (IFile) element;
                return file.getName().endsWith(ext);
            }
            return false;
        }
    }
    
    private static class SelectResourceListener extends SelectionAdapter {
        private IProject project;
        private Text replText;
        private String filterExt;
        private String dialogTitle;
        
        public SelectResourceListener(IProject project, Text text, String filterExt, String title) {
            super();
            this.project = project;
            this.replText = text;
            this.filterExt = filterExt;
            this.dialogTitle = title;
        }
        
        public void widgetSelected(SelectionEvent e) {
            ElementTreeSelectionDialog dialog 
                = new ElementTreeSelectionDialog(
                        Activator.getShell(), 
                        new WorkbenchLabelProvider(), 
                        new WorkbenchContentProvider());
            
            dialog.setTitle(dialogTitle);
            dialog.setInput(project);
            dialog.setAllowMultiple(false);
            dialog.setHelpAvailable(false);
            dialog.addFilter(new FileExtensionFilter(filterExt));
            dialog.setComparator(new ResourceComparator(ResourceComparator.TYPE));
            
            int code = dialog.open();
            if (code == Window.OK) {
                IFile file = (IFile) dialog.getResult()[0];
                replText.setText(file.getProjectRelativePath().toPortableString());
            }
        }
    }

}
