package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.Activator;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.Messages;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count.CounterJob;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CountAction implements IObjectActionDelegate {
    
    private ISelection selection;
    
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}
    
    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
    
	public void run(IAction action) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        
        try {
            Collection compUnits = collectCompilationUnit((IStructuredSelection) selection);
            if (compUnits.size() != 0) {
                new CounterJob(compUnits).schedule();
            } else {
                MessageDialog.openInformation(Activator.getShell(), null, Messages.Message_NoCountFile);
            }
        } catch (JavaModelException e) {
            Activator.logError(e);
        }
	}
    
    private Collection collectCompilationUnit(IStructuredSelection selection) throws JavaModelException {
        List compilationUnits = new ArrayList();
        
        for (Iterator iter = selection.iterator(); iter.hasNext(); ) {
            IJavaElement element = (IJavaElement) iter.next();
            collect(element, compilationUnits);
        }
        
        return compilationUnits;
    }
    
    private void collect(IJavaElement javaElement, Collection elements) throws JavaModelException {
        if (javaElement.getElementType() == IJavaElement.COMPILATION_UNIT) {
            elements.add(javaElement);
            return;
        }
        
        IParent parent = null;
        if (javaElement.getElementType() == IJavaElement.JAVA_PROJECT) {
            parent = (IJavaProject) javaElement;
        } else if (javaElement.getElementType() == IJavaElement.PACKAGE_FRAGMENT_ROOT) {
            IPackageFragmentRoot root = (IPackageFragmentRoot) javaElement;
            if (isSourceKind(root)) {
                parent = root;
            }
        } else if (javaElement.getElementType() == IJavaElement.PACKAGE_FRAGMENT) {
            IPackageFragment packageFragment = (IPackageFragment) javaElement;
            IPackageFragmentRoot root = (IPackageFragmentRoot) packageFragment.getParent();
            if (isSourceKind(root)) {
                parent = packageFragment;
            }
        }
        
        if (parent != null) {
            if (parent.hasChildren()) {
                IJavaElement[] children = parent.getChildren();
                for (int i = 0; i < children.length; i++) {
                    collect(children[i], elements);
                }
            }
        }
        
        
    }

    private boolean isSourceKind(IPackageFragmentRoot root) throws JavaModelException {
        return root.getKind() == IPackageFragmentRoot.K_SOURCE;
    }
    
}
