package jp.xet.eclipse.strictjava.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * TODO for daisuke
 * 
 * @since 1.0.0
 * @version $Id: NewStrictJavaProjectWizardPage.java 132 2009-10-04 15:31:01Z daisuke_m $
 * @author daisuke
 */
class NewStrictJavaProjectWizardPage extends NewJavaProjectWizardPageOne {
	
	private static final IPath[] EXCLUDE_JAVA = new IPath[] {
		new Path("**/*.java")
	};
	
	private static final IPath[] EXCLUDE_NONE = {};
	
	private static final IPath[] SOURCE_PATHS = new IPath[] {
		new Path("src/main/java"),
		new Path("src/main/resources"),
		new Path("src/test/java"),
		new Path("src/test/resources"),
	};
	
	private static final IPath MAIN_OUT = new Path("target/classes");
	
	private static final IPath TEST_OUT = new Path("target/test-classes");
	
	private NewStrictJavaProjectWizardPageTwo page2;
	
	private Text groupIdText;
	
	private Text copyrightHolderText;
	

	NewStrictJavaProjectWizardPage() {
		page2 = new NewStrictJavaProjectWizardPageTwo(this);
	}
	
	/**
	 * TODO for daisuke
	 * 
	 * @return
	 * @since TODO
	 */
	public String getCopyrightHolder() {
		return copyrightHolderText.getText();
	}
	
	/**
	 * TODO for daisuke
	 * 
	 * @return
	 * @since TODO
	 */
	public String getGroupId() {
		return groupIdText.getText();
	}
	
	/**
	 * TODO for daisuke
	 * 
	 * @return
	 * @since TODO
	 */
	public IJavaProject getJavaProject() {
		return page2.getJavaProject();
	}
	
	@Override
	public IPath getOutputLocation() {
		IPath projectPath = new Path(getProjectName()).makeAbsolute();
		return projectPath.append(MAIN_OUT);
	}
	
	@Override
	public IClasspathEntry[] getSourceClasspathEntries() {
		IPath projectPath = new Path(getProjectName()).makeAbsolute();
		
		List<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
		
		for (IPath path : SOURCE_PATHS) {
			IPath[] exclusionPattern = path.toString().contains("resources") ? EXCLUDE_JAVA : EXCLUDE_NONE;
			IPath specificOutputLocation = path.toString().contains("test") ? projectPath.append(TEST_OUT) : null;
			
			IClasspathEntry entry =
					JavaCore.newSourceEntry(projectPath.append(path), exclusionPattern, specificOutputLocation);
			entries.add(entry);
		}
		
		entries.add(JavaCore.newContainerEntry(new Path("org.devzuz.q.maven.jdt.core.mavenClasspathContainer")));
		
		return entries.toArray(new IClasspathEntry[entries.size()]);
	}
	
	/**
	 * TODO for daisuke
	 * 
	 * @since TODO
	 */
	public void performCancel() {
		page2.performCancel();
	}
	
	/**
	 * TODO for daisuke
	 * 
	 * @param monitor
	 * @throws InterruptedException 
	 * @throws CoreException 
	 * @since TODO
	 */
	public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
		page2.performFinish(monitor);
	}
	
	@Override
	protected Control createProjectLayoutControl(Composite composite) {
		Group group = new Group(composite, SWT.NONE);
		group.setFont(composite.getFont());
		group.setLayout(new GridLayout(2, false));
		group.setLayoutData(new GridData(GridData.FILL_BOTH));
		group.setText("Miscellaneous");
		
		Label label = new Label(group, SWT.NONE);
		label.setText("Group ID:");
		
		groupIdText = new Text(group, SWT.BORDER);
		groupIdText.setText("org.example");
		groupIdText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		label = new Label(group, SWT.NONE);
		label.setText("Copyright holder:");
		
		copyrightHolderText = new Text(group, SWT.BORDER);
		copyrightHolderText.setText("${user}");
		copyrightHolderText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		return group;
	}
	

	class NewStrictJavaProjectWizardPageTwo extends NewJavaProjectWizardPageTwo {
		
		NewStrictJavaProjectWizardPageTwo(NewJavaProjectWizardPageOne mainPage) {
			super(mainPage);
		}
		
		@Override
		protected void initializeBuildPath(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
			super.initializeBuildPath(javaProject, monitor);
			
			IWorkspaceRoot root = javaProject.getProject().getWorkspace().getRoot();
			
			IClasspathEntry[] sourceClasspathEntries = getSourceClasspathEntries();
			for (IClasspathEntry classpathEntry : sourceClasspathEntries) {
				IPath outputLocation = classpathEntry.getOutputLocation();
				if (outputLocation != null && outputLocation.segmentCount() > 1) {
					IFolder folder = root.getFolder(outputLocation);
					createDerivedFolder(folder, true, true, new SubProgressMonitor(monitor, 1));
				}
				
			}
		}
		
		private void createDerivedFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor)
				throws CoreException {
			if (folder.exists() == false) {
				IContainer parent = folder.getParent();
				if (parent instanceof IFolder) {
					createDerivedFolder((IFolder) parent, force, local, null);
				}
				folder.create(force ? (IResource.FORCE | IResource.DERIVED) : IResource.DERIVED, local, monitor);
			}
		}
		
	}
	
}
