/*
 * Decompiled with CFR 0.152.
 */
package jp.xet.eclipse.strictjava.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class NewStrictJavaProjectWizardPage
extends NewJavaProjectWizardPageOne {
    private static final IPath[] EXCLUDE_JAVA = new IPath[]{new Path("**/*.java")};
    private static final IPath[] EXCLUDE_NONE = new IPath[0];
    private static final IPath[] SOURCE_PATHS = new IPath[]{new Path("src/main/java"), new Path("src/main/resources"), new Path("src/test/java"), new Path("src/test/resources")};
    private static final IPath MAIN_OUT = new Path("target/classes");
    private static final IPath TEST_OUT = new Path("target/test-classes");
    private NewStrictJavaProjectWizardPageTwo page2 = new NewStrictJavaProjectWizardPageTwo(this);
    private Text groupIdText;
    private Text copyrightHolderText;

    NewStrictJavaProjectWizardPage() {
    }

    public String getCopyrightHolder() {
        return this.copyrightHolderText.getText();
    }

    public String getGroupId() {
        return this.groupIdText.getText();
    }

    public IJavaProject getJavaProject() {
        return this.page2.getJavaProject();
    }

    public IPath getOutputLocation() {
        IPath projectPath = new Path(this.getProjectName()).makeAbsolute();
        return projectPath.append(MAIN_OUT);
    }

    public IClasspathEntry[] getSourceClasspathEntries() {
        IPath projectPath = new Path(this.getProjectName()).makeAbsolute();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IPath[] iPathArray = SOURCE_PATHS;
        int n = SOURCE_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IPath[] exclusionPattern = path.toString().contains("resources") ? EXCLUDE_JAVA : EXCLUDE_NONE;
            IPath specificOutputLocation = path.toString().contains("test") ? projectPath.append(TEST_OUT) : null;
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)projectPath.append(path), (IPath[])exclusionPattern, (IPath)specificOutputLocation);
            entries.add(entry);
            ++n2;
        }
        entries.add(JavaCore.newContainerEntry((IPath)new Path("org.devzuz.q.maven.jdt.core.mavenClasspathContainer")));
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    public void performCancel() {
        this.page2.performCancel();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.page2.performFinish(monitor);
    }

    protected Control createProjectLayoutControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        group.setText("Miscellaneous");
        Label label = new Label((Composite)group, 0);
        label.setText("Group ID:");
        this.groupIdText = new Text((Composite)group, 2048);
        this.groupIdText.setText("org.example");
        this.groupIdText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)group, 0);
        label.setText("Copyright holder:");
        this.copyrightHolderText = new Text((Composite)group, 2048);
        this.copyrightHolderText.setText("${user}");
        this.copyrightHolderText.setLayoutData((Object)new GridData(768));
        return group;
    }

    class NewStrictJavaProjectWizardPageTwo
    extends NewJavaProjectWizardPageTwo {
        NewStrictJavaProjectWizardPageTwo(NewJavaProjectWizardPageOne mainPage) {
            super(mainPage);
        }

        protected void initializeBuildPath(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            IClasspathEntry[] sourceClasspathEntries;
            super.initializeBuildPath(javaProject, monitor);
            IWorkspaceRoot root = javaProject.getProject().getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = sourceClasspathEntries = NewStrictJavaProjectWizardPage.this.getSourceClasspathEntries();
            int n = sourceClasspathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                IPath outputLocation = classpathEntry.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    IFolder folder = root.getFolder(outputLocation);
                    this.createDerivedFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++n2;
            }
        }

        private void createDerivedFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
            if (!folder.exists()) {
                IContainer parent = folder.getParent();
                if (parent instanceof IFolder) {
                    this.createDerivedFolder((IFolder)parent, force, local, null);
                }
                folder.create(force ? 1025 : 1024, local, monitor);
            }
        }
    }
}

