package jp.xet.eclipse.activitytracker;

import jp.xet.eclipse.activitytracker.views.UserActivityView;

import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/**
 * Key listener.
 */
public class UserActivityListener implements Listener {
	
	private UserActivityView view;
	
	private Event prev = new Event();
	
	private boolean trackMouse;
	

	public void handleEvent(Event e) {
		if (view == null) {
			return;
		}
		
		if (e.type == SWT.MouseDown) {
			if (trackMouse) {
				view.printControl("Mouse Down");
			}
			return;
		}
		if (e.type == SWT.MouseUp) {
			if (trackMouse) {
				view.printControl("Mouse Up");
			}
			return;
		}
		
		// あーカッコ悪い…。
		if (e.time == prev.time && prev.keyCode == e.keyCode) {
			return;
		}
		if (e.time - prev.time < 200 && prev.keyCode == e.keyCode) {
			if (prev.type == SWT.Traverse && e.type == SWT.KeyDown) {
				return;
			}
			if (prev.type == SWT.Traverse && e.type == SWT.KeyUp) {
				return;
			}
			if (prev.type == SWT.KeyDown && e.type == SWT.KeyUp) {
				return;
			}
		}
		prev = e;
		// カッコ悪いゾーン終了
		
		int accelerator = SWTKeySupport.convertEventToModifiedAccelerator(e);
		KeyStroke stroke = SWTKeySupport.convertAcceleratorToKeyStroke(accelerator);
		KeySequence keySequence = KeySequence.getInstance(stroke);
		String text = stroke.format().trim();
		
		IKeyLookup lookup = KeyLookupFactory.getDefault();
		
		if (stroke.getModifierKeys() == 0 || stroke.getModifierKeys() == lookup.getShift()) {
			stroke = SWTKeySupport.convertAcceleratorToKeyStroke(stroke.getNaturalKey());
			text = stroke.format().trim();
			if (keySequence.isComplete()) {
				if (text.length() == 1) {
					view.printLetter(text);
				} else if (text.length() > 1) {
					view.printControl(text);
				}
			}
		} else {
			if (keySequence.isComplete() && text.length() > 0) {
				view.printControl(text);
			}
		}
		
	}
	
	/**
	 * Set the view to output.
	 * 
	 * @param view the view to output
	 */
	public void setOutput(UserActivityView view) {
		this.view = view;
	}
	
	/**
	 * TODO for daisuke
	 * 
	 * @param trackMouse
	 */
	public void setTrackMouse(boolean trackMouse) {
		this.trackMouse = trackMouse;
	}
}
