package jp.gr.java_conf.ykhr.csvutil.escaper;


public class DefaultEscaper implements Escaper, Unescaper {
    
    private static final String SPACE = " ";
    private static final String DOUBLE_QUOTA = "\"";
    private static final char DOUBLE_QUOTA_CHAR = '\"';
    private static final String ESCAPED_DQ = "\"\"";
    
    public String toStringValue(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }
    
    public String escape(String value) {
        return value.replaceAll(DOUBLE_QUOTA, ESCAPED_DQ);
    }
    
    public boolean needEscape(String value) {
        return value.contains(DOUBLE_QUOTA);
    }
    
    public boolean needQuote(String value, boolean escaping) {
        if (escaping) {
            return true;
        } else if(value.length() == 0) {
            return false;
        }
        return value.contains("\r") || value.contains("\n") 
                || value.startsWith(SPACE) || value.endsWith(SPACE);
    }
    
    public boolean isEscappedValue(String contents, int index) {
        if (contents.length() < index + 2) {
            return false;
        }
        return contents.charAt(index) == DOUBLE_QUOTA_CHAR
            && contents.charAt(index + 1) == DOUBLE_QUOTA_CHAR;
    }

    public int skipLengthAfterUnescape() {
        return 1;
    }

    public String unescape(String contents, int index) {
        return DOUBLE_QUOTA;
    }
    
}
