package jp.gr.java_conf.ykhr.eclipse.plugin.chocosc;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;


public class OpenLastClosedEditor implements IWorkbenchWindowActionDelegate, IStartup {
    
    private static LimitStack editorHistory = new LimitStack(10);
    
    private static IPartListener editorCloseTracker = new IPartListener() {
        
        public void partActivated(org.eclipse.ui.IWorkbenchPart part) {
        }
        
        public void partBroughtToTop(IWorkbenchPart part) {
        }
        
        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                editorHistory.push(part);
            }
        }
        
        public void partDeactivated(IWorkbenchPart part) {
        }
        
        public void partOpened(IWorkbenchPart part) {
        }
        
    };
    
	/**
	 * The constructor.
	 */
	public OpenLastClosedEditor() {
	}
    
    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
	public void run(IAction action) {
        IEditorPart part = (IEditorPart)  editorHistory.pop();
        
        if (part != null) {
            IWorkbenchPartSite site = part.getSite();
            IEditorInput editorInput = part.getEditorInput();
            
            try {
                IDE.openEditor(site.getPage(), editorInput, site.getId());
            } catch (PartInitException e) {
                Activator.logError(e);
            }
        }
	}

	/* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}
    
	/* (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
	}
    
    /* (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
	public void init(IWorkbenchWindow window) {
	}
    
    /* (non-Javadoc)
     * @see org.eclipse.ui.IStartup#earlyStartup()
     */
    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable() {
            public void run() {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(editorCloseTracker);
            }
        });
    }
    
}