package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class RunXsltJob extends WorkspaceJob {
    
    private static final String name = "Choco XSLT"; //$NON-NLS-1$
    private RunDescription desc;
   
    public RunXsltJob(RunDescription desc) {
        super(name);
        this.desc = desc;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        
        monitor.beginTask(name, 2);
        
        try {
            File xslFile = new File(desc.getXsl());
            Source inputSource = getInputSource();
            Source xslSource = new StreamSource(xslFile);
            Result result = getOutputResult(xslFile);
            Properties prop = getXslParam();
            
            monitor.worked(1);
            if (!monitor.isCanceled()) {
                doTransform(inputSource, xslSource, result, prop);
            }
            
        } catch (Exception e) {
            throw new CoreException(
                    new Status(IStatus.ERROR, Activator.PLUGIN_ID, 0, e.getMessage(), e));
        } finally {
            monitor.done();
        }
        
        return Status.OK_STATUS;
    }

    private Source getInputSource() {
        String input = desc.getInput();
        return new StreamSource(new File(input));
    }

    private Properties getXslParam() throws IOException {
        Properties prop = new Properties();
        String propertyPath = desc.getProperty();
        
        if (propertyPath != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertyPath);
                prop.load(fis);
            } finally {
                if (fis != null) { 
                    try {
                        fis.close();
                    } catch (IOException e) {
                        Activator.logError(e);
                    }
                }
            }
        }
        return prop;
    }

    private Result getOutputResult(File xslFile) {
        StreamResult result = null;
        String output = desc.getOutput();
        
        if (output == null) {
            String consoleName = name + " [" + xslFile.getName() + "]"; //$NON-NLS-1$ //$NON-NLS-2$ 
            MessageConsole console  = new MessageConsole(consoleName, null);
            
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.addConsoles(new IConsole[]{console});
            consoleManager.showConsoleView(console);
            
            result = new StreamResult(console.newMessageStream());
        } else {
            result = new StreamResult(new File(output));
        }
        
        return result;
    }
    
    private void doTransform(Source xml, Source xslt, Result result, Properties xsltParam) 
    throws TransformerConfigurationException, TransformerException {
        
        Transformer tf = TransformerFactory.newInstance().newTransformer(xslt);
        for (Iterator iter = xsltParam.entrySet().iterator(); iter.hasNext(); ) {
            Map.Entry entry = (Map.Entry) iter.next();
            tf.setParameter((String) entry.getKey(), entry.getValue());
        }
        tf.transform(xml, result);
    }
    
}
