package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter;

import java.io.File;

import org.eclipse.jface.preference.IPreferenceStore;


public class ReportPropertyHelper {
    
    public static final String KEY_XSLT_KIND = "xslt.kind";
    
    public static final int XSLT_KIND_NOFRAME = 1;
    public static final int XSLT_KIND_FRAME = 2;
    public static final int XSLT_KIND_CUSTOM = 3;
    
    public static final String KEY_CUSTOM_PATH = "xslt.custompath";
    public static final String KEY_CUSTOM_TYPE = "xslt.customtype";
    
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIR = 2;
    
    private static final String FRAMES_XSLT = "junit-frames.xsl";
    private static final String NOFRAMES_XSLT = "junit-noframes.xsl";
    
    private static class AntFrameProperty extends ReportProperty {
        public AntFrameProperty() {
            super(TYPE_DIR, JUnitReporterActivator.getAntStyle(FRAMES_XSLT));
        }
    }

    private static class AntNoFrameProperty extends ReportProperty {
        public AntNoFrameProperty() {
            super(TYPE_FILE, JUnitReporterActivator.getAntStyle(NOFRAMES_XSLT));
        }
    }
    
    public static ReportProperty createReportProperty() {
        IPreferenceStore store = JUnitReporterActivator.getDefault().getPreferenceStore();
        int kind = store.getInt(KEY_XSLT_KIND);
        
        if (kind == XSLT_KIND_NOFRAME) {
            return new AntNoFrameProperty();
        } else if (kind == XSLT_KIND_FRAME) {
            return new AntFrameProperty();
        } else if (kind == XSLT_KIND_CUSTOM) {
            String xslt = store.getString(KEY_CUSTOM_PATH);
            int type = store.getInt(KEY_CUSTOM_TYPE);
            return new ReportProperty(type, new File(xslt));
        }
        
        // default
        return new AntFrameProperty();
    }

}
