package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.JUnitReporterActivator;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ex.WriteException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;


public class ReporterJob extends Job {
    
    private IReporterCommand command;
    
    public ReporterJob(IReporterCommand command) {
        super(command.getName());
        
        this.command = command;
    }
    
    protected IStatus run(IProgressMonitor monitor) {
        try {
            command.execute(monitor);
        } catch (WriteException e) {
            JUnitReporterActivator.logError(e);
            asyncShowInfomation("Error", e.getMessage());
        }
        
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void asyncShowInfomation(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable() {
            public void run() {
                MessageDialog.openInformation(JUnitReporterActivator.getShell(), 
                        title, message);
            }
        });
    }
    
}
