package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count4em;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;

import net.sourceforge.metrics.calculators.Calculator;
import net.sourceforge.metrics.calculators.InvalidSourceException;
import net.sourceforge.metrics.core.Metric;
import net.sourceforge.metrics.core.sources.AbstractMetricSource;

public class MethodJavadocCalculator extends Calculator {
    
    public MethodJavadocCalculator() {
        super(Constant.METHOD_JDLINE);
    }
    
    public void calculate(AbstractMetricSource source) throws InvalidSourceException {
        if (source.getLevel() != METHOD) {
            throw new IllegalArgumentException();
        }
        
        CompilationUnit cu = source.getParsedCompilationUnit();
        MethodDeclaration method = (MethodDeclaration) source.getASTNode();
        int methodLine = Utils.getLineLength(cu, method.getJavadoc());
        source.setValue(new Metric(Constant.METHOD_JDLINE, methodLine));
    }

}
