package jp.gr.java_conf.ykhr.listfindbugs;

import java.util.HashMap;
import java.util.Map;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MessageHandler extends DefaultHandler {
    
    private Map<String, MessageVo> messages = new HashMap<String, MessageVo>();
    private boolean inBugPattern = false;
    private boolean inShortDescription = false;
    private boolean inDetails = false;
    private String currentType;
    private StringBuilder shortDescBuilder = new StringBuilder(100);
    private StringBuilder detailBuilder = new StringBuilder(300);
    
    public Map<String, MessageVo> getMessages() {
        return messages;
    }
    
    public void reset() {
        messages = new HashMap<String, MessageVo>();;
        inBugPattern = false;
        inShortDescription = false;
        inDetails = false;
        currentType = null;
        shortDescBuilder.setLength(0);
        detailBuilder.setLength(0);
    }
    
    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("BugPattern".equals(name)) {
            inBugPattern = true;
            currentType = attributes.getValue("type");
        } else if (inBugPattern && "ShortDescription".equals(name)) {
            inShortDescription = true;
        } else if (inBugPattern && "Details".equals(name)) {
            inDetails = true;
        }
    }
    
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (inShortDescription) {
            shortDescBuilder.append(new String(ch, start, length));
        } else if (inDetails) {
            detailBuilder.append(new String(ch, start, length));
        }
    }
    
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("BugPattern".equals(name)) {
            MessageVo vo = new MessageVo(currentType, shortDescBuilder.toString(), detailBuilder.toString());
            messages.put(vo.getType(), vo);
            
            inBugPattern = false;
            shortDescBuilder.setLength(0);
            detailBuilder.setLength(0);
        } else if ("ShortDescription".equals(name)) {
            inShortDescription = false;
        } else if ("Details".equals(name)) {
            inDetails = false;
        }
    }

}
