package jp.xet.eclipse.strictjava;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

/**
 * The activator class controls the plug-in life cycle
 */
public class StrictJavaPlugin extends AbstractUIPlugin {
	
	/** The plug-in ID */
	public static final String PLUGIN_ID = "jp.xet.eclipse.strictjava";
	
	// The shared instance
	private static StrictJavaPlugin plugin;
	

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static StrictJavaPlugin getDefault() {
		return plugin;
	}
	
	@SuppressWarnings("unchecked")
	public static void makeStrict(IJavaProject javaProject, Map<String, String> replace, IProgressMonitor monitor) {
		monitor.beginTask("copy settings", 15);
		
		IProject project = javaProject.getProject();
		
		try {
			project.setDefaultCharset("UTF-8", null);
			
			ProjectScope projectScope = new ProjectScope(project);
			IEclipsePreferences node = projectScope.getNode(Platform.PI_RUNTIME);
			node.put(Platform.PREF_LINE_SEPARATOR, "\r\n");
			node.flush();
		} catch (CoreException e) {
			e.printStackTrace();
		} catch (BackingStoreException e) {
			e.printStackTrace();
		}
		monitor.worked(1);
		
		configureBuilderAndNature(project);
		monitor.worked(2);
		
		copyFile(project, ".checkstyle", replace);
		monitor.worked(1);
		copyFile(project, ".fbprefs", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, "checkstyle.xml", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, "findbugs.xml", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, "pom.xml", replace);
		monitor.worked(1);
		
		copyFile(project, ".settings/org.eclipse.jdt.launching.prefs", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, ".settings/org.eclipse.jdt.ui.prefs", replace);
		monitor.worked(1);
		copyFile(project, ".settings/org.eclipse.ltk.core.refactoring.prefs", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, ".settings/org.eclipse.pde.prefs", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, ".settings/org.eclipse.wst.sse.core.prefs", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, ".settings/org.eclipse.wst.validation.prefs", Collections.EMPTY_MAP);
		monitor.worked(1);
		copyFile(project, ".settings/org.eclipse.jdt.core.prefs", replace);
		monitor.worked(1);
	}
	
	private static void addBuilder(IProjectDescription description, List<ICommand> builders, String builderId) {
		for (ICommand builder : builders) {
			if (builder.getBuilderName().equals(builderId)) {
				return;
			}
		}
		builders.add(newCommand(description, builderId));
	}
	
	private static void addNature(List<String> natures, String natureId) {
		if (natures.contains(natureId)) {
			return;
		}
		natures.add(natureId);
	}
	
	private static void configureBuilderAndNature(IProject project) {
		try {
			IProjectDescription description = project.getDescription();
			
			List<ICommand> builders = new ArrayList<ICommand>(Arrays.asList(description.getBuildSpec()));
			addBuilder(description, builders, JavaCore.BUILDER_ID);
			addBuilder(description, builders, "org.devzuz.q.maven.jdt.core.mavenIncrementalBuilder");
			addBuilder(description, builders, "net.sf.eclipsecs.core.CheckstyleBuilder");
			addBuilder(description, builders, "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder");
			description.setBuildSpec(builders.toArray(new ICommand[builders.size()]));
			
			List<String> natures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
			addNature(natures, JavaCore.NATURE_ID);
			addNature(natures, "org.devzuz.q.maven.jdt.core.mavenNature");
			addNature(natures, "net.sf.eclipsecs.core.CheckstyleNature");
			addNature(natures, "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature");
			description.setNatureIds(natures.toArray(new String[natures.size()]));
			
			project.setDescription(description, null);
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	private static void copyFile(IProject project, String fileLocation, Map<String, String> replaces) {
		try {
			IFile file = project.getFile(new Path(fileLocation));
			if (file.exists()) {
				file.delete(true, null);
			}
			InputStream resourceStream = openResourceStream(fileLocation);
			if (replaces.isEmpty() == false) {
				String content = IOUtils.toString(resourceStream);
				try {
					resourceStream.close();
				} catch (Exception e) {
					// ignore
				}
				for (Map.Entry<String, String> replace : replaces.entrySet()) {
					content = content.replace(replace.getKey(), replace.getValue());
				}
				resourceStream = new ByteArrayInputStream(content.getBytes());
			}
			file.create(resourceStream, true, null);
		} catch (CoreException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private static ICommand newCommand(IProjectDescription description, String builderId) {
		ICommand newCommand = description.newCommand();
		newCommand.setBuilderName(builderId);
		return newCommand;
	}
	
	private static InputStream openResourceStream(String name) throws IOException {
		URL resource = getDefault().getBundle().getResource("src/main/resources/" + name);
		URLConnection connection = resource.openConnection();
		connection.setUseCaches(false);
		return connection.getInputStream();
	}
	
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}
	
	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}
	
}
