package jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core";
    
    private static final String EXT_ID = PLUGIN_ID + ".warningerActionPoint";

    // The shared instance
    private static Activator plugin;
    
    private List<IWarningerAction> actions = null;
    
    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = plugin.getWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    public static void logError(Throwable t, String message) {
        log(new Status(IStatus.ERROR, PLUGIN_ID, 0, message, t));
    }

    public static void logError(Throwable t) {
        logError(t, "Error");
    }

    public static void log(IStatus status) {
        getDefault().getLog().log(status);
    }
    
    public List<IWarningerAction> getWarningerActions() {
        if (actions == null) {
            loadAction();
        }
        return actions;
    }
    
    public void loadAction() {
        actions = new ArrayList<IWarningerAction>();
        
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXT_ID);
        
        if (point == null) {
            return;
        }
        
        IExtension[] extensions = point.getExtensions();
        for (IExtension extension : extensions) {
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            
            for (IConfigurationElement config : configElements) {
                if ("action".equals(config.getName())) {
                    try {
                        Object obj = config.createExecutableExtension("class");
                        if (obj instanceof IWarningerAction) {
                            actions.add((IWarningerAction) obj);
                        } else {
                            // TODO
                        }
                    } catch (CoreException e) {
                        logError(e);
                    }
                }
            }
            
        }
        
    }

}
