/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mailbox.h 264 2007-07-12 08:23:10Z hiro $
 */

/*
 *		[{bNX@\
 */

#ifndef TOPPERS_MAILBOX_H
#define TOPPERS_MAILBOX_H

#include <queue.h>

/*
 *  [{bNXubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct mailbox_initialization_block {
	ATR			mbxatr;			/* [{bNX */
	PRI			maxmpri;		/* bZ[WDx̍ől */
} MBXINIB;

/*
 *  [{bNXǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 *
 *  bZ[WL[bZ[W̗Dx̏ꍇɂ́Cpk_last͎g
 *  D܂CbZ[WL[̏ꍇipk_headNULL̏ꍇjɂC
 *  pk_last͖łD
 */
typedef struct mailbox_control_block {
	QUEUE		wait_queue;		/* [{bNX҂L[ */
	const MBXINIB *p_mbxinib;	/* ubNւ̃|C^ */
	T_MSG		*pk_head;		/* 擪̃bZ[W */
	T_MSG		*pk_last;		/* ̃bZ[W */
} MBXCB;

/*
 *  [{bNX҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ŏ2̃tB[hʂɂȂĂD
 */
typedef struct mailbox_waiting_information {
	WINFO		winfo;			/* W̑҂ubN */
	MBXCB		*p_mbxcb;		/* ҂Ă郁[{bNX̊ǗubN */
	T_MSG		*pk_msg;		/* MbZ[W */
} WINFO_MBX;

/*
 *  [{bNXID̍őlikernel_cfg.cj
 */
extern const ID	tmax_mbxid;

/*
 *  [{bNXubÑGAikernel_cfg.cj
 */
extern const MBXINIB	mbxinib_table[];

/*
 *  [{bNXǗubÑGAikernel_cfg.cj
 */
extern MBXCB	mbxcb_table[];

/*
 *  [{bNXǗubN烁[{bNXIDo߂̃}N
 */
#define	MBXID(p_mbxcb)	((ID)(((p_mbxcb) - mbxcb_table) + TMIN_MBXID))

/*
 *  [{bNX@\̏
 */
extern void	initialize_mailbox(void);

#endif /* TOPPERS_MAILBOX_H */
