/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: wait.h 748 2008-03-07 17:18:06Z hiro $
 */

/*
 *		҂ԊǗW[
 */

#ifndef TOPPERS_WAIT_H
#define TOPPERS_WAIT_H

#include "task.h"
#include "time_event.h"

/*
 *  ^XN̗Dx̑҂L[ւ̑}
 *
 *  p_tcbŎw肳^XNC^XNDx̃L[p_queueɑ}D
 *  L[̒ɓDx̃^XNꍇɂ́C̍Ōɑ}D
 */
Inline void
queue_insert_tpri(QUEUE *p_queue, TCB *p_tcb)
{
	QUEUE	*p_entry;
	uint_t	priority = p_tcb->priority;

	for (p_entry = p_queue->p_next; p_entry != p_queue;
										p_entry = p_entry->p_next) {
		if (priority < ((TCB *) p_entry)->priority) {
			break;
		}
	}
	queue_insert_prev(p_entry, &(p_tcb->task_queue));
}

/*
 *  ҂Ԃւ̈ڍs
 *
 *  s̃^XN҂ԂɈڍsD̓Iɂ́Cs̃^XN
 *  fBL[폜CTCBp_winfotB[hCWINFOp_tmevtbtB[
 *  hݒ肷D
 */
Inline void
make_wait(WINFO *p_winfo)
{
	(void) make_non_runnable(p_runtsk);
	p_runtsk->p_winfo = p_winfo;
	p_winfo->p_tmevtb = NULL;
}

/*
 *  ҂Ԃւ̈ڍsi^CAEgwj
 *
 *  s̃^XNC^CAEgwtő҂ԂɈڍsD
 *  Iɂ́Cs̃^XNfBL[폜CTCBp_winfotB[
 *  hCWINFOp_tmevtbtB[hݒ肷D܂C^CCxgu
 *  bNo^D
 */
extern void	make_wait_tmout(WINFO *p_winfo, TMEVTB *p_tmevtb, TMO tmout);

/*
 *  IuWFNg҂L[̍폜
 *
 *  p_tcbŎw肳^XNCEʐMIuWFNg̑҂L[ɂ
 *  ȂĂ΁C҂L[폜D
 */
Inline void
wait_dequeue_wobj(TCB *p_tcb)
{
	if (TSTAT_WAIT_WOBJ(p_tcb->tstat)) {
		queue_delete(&(p_tcb->task_queue));
	}
}

/*
 *  ԑ҂̂߂̃^CCxgubN̓o^
 *
 *  p_tcbŎw肳^XNɑ΂āCԑ҂̂߂̃^CCxgu
 *  bNo^Ă΁Co^D
 */
Inline void
wait_dequeue_tmevtb(TCB *p_tcb)
{
	if (p_tcb->p_winfo->p_tmevtb != NULL) {
		tmevtb_dequeue(p_tcb->p_winfo->p_tmevtb);
	}
}

/*
 *  ҂
 *
 *  p_tcbŎw肳^XN̑҂ԂD̓Iɂ́C^CC
 *  xgubNo^Ă΁Co^D܂C^XN
 *  ԂXVC҂^XN̕ԒlE_OKƂD҂L[
 *  ̍폜͍sȂD҂^XNւ̃fBXpb`Kvȏ
 *  ɂtrueԂD
 */
extern bool_t	wait_complete(TCB *p_tcb);

/*
 *  ^CAEgɔ҂
 *
 *  p_tcbŎw肳^XNC҂L[ɂȂĂΑ҂L[
 *  폜C^XNԂXVD܂C҂^XN̕
 *  lCwait_tmoutłE_TMOUTCwait_tmout_okłE_OKƂD҂
 *  ^XNւ̃fBXpb`KvȎ́CreqflgtrueɂD
 *
 *  wait_tmout_oḱCdly_tskŎg߂̂̂ŁC҂L[폜
 *  sȂD
 *
 *  ̊֐C^CCxg̃R[obN֐Ƃėp邽߂
 *  ̂ŁC݃nhĂяo邱Ƃz肵ĂD
 */
extern void	wait_tmout(TCB *p_tcb);
extern void	wait_tmout_ok(TCB *p_tcb);

/*
 *  ҂Ԃ̋
 *
 *  p_tcbŎw肳^XN̑҂ԂIɉD̓Iɂ́C
 *  ^XN҂L[ɂȂĂΑ҂L[폜C^CC
 *  xgubNo^Ă΂o^D܂C^XN
 *  ԂXVC҂^XN̕ԒlE_RLWAIƂD܂C
 *  ҂^XNւ̃fBXpb`KvȏꍇɂtrueԂD
 */
extern bool_t	wait_release(TCB *p_tcb);

/*
 *  ҂L[̐擪̃^XNID
 *
 *  p_wait_queueŎw肵҂L[̐擪̃^XNIDԂD҂L[
 *  ̏ꍇɂ́CTSK_NONEԂD
 */
Inline ID
wait_tskid(QUEUE *p_wait_queue)
{
	if (!queue_empty(p_wait_queue)) {
		return(TSKID((TCB *) p_wait_queue->p_next));
	}
	else {
		return(TSK_NONE);
	}
}

/*
 *  EʐMIuWFNg̊ǗubN̋ʕ샋[`
 *
 *  EʐMIuWFNg̏ubNƊǗubN̐擪͋
 *  ʂɂȂĂDȉ́C̋ʕ߂̌^у[`Q
 *  łD
 *
 *  ̑҂L[EʐMIuWFNg̏ꍇC擪ȊȎ҂
 *  L[𑀍삷ꍇɂ́C̃[`͎gȂD܂CIuWF
 *  NgTA_TPRIrbgQƂ̂ŁC̃rbg𑼂̖ړIɎg
 *  ꍇC̃[`͎gȂD
 */

/*
 *  EʐMIuWFNg̏ubN̋ʕ
 */
typedef struct wait_object_initialization_block {
	ATR			wobjatr;		/* IuWFNg */
} WOBJINIB;

/*
 *  EʐMIuWFNg̊ǗubN̋ʕ
 */
typedef struct wait_object_control_block {
	QUEUE		wait_queue;		/* ҂L[ */
	const WOBJINIB *p_wobjinib;	/* ubNւ̃|C^ */
} WOBJCB;

/*
 *  EʐMIuWFNg̑҂ubN̋ʕ
 *
 *  ̍\̂́C҂ubNiWINFOjgiIuWFNgw
 *  ̌pɑĵł邪CWINFOp̂Œ`Ă邽
 *  ߂ɁC1̃tB[hƂĊ܂߂ĂD
 */
typedef struct wait_object_waiting_information {
	WINFO	winfo;			/* W̑҂ubN */
	WOBJCB	*p_wobjcb;		/* ҂IuWFNg̊ǗubN */
} WINFO_WOBJ;

/*
 *  EʐMIuWFNgɑ΂҂Ԃւ̈ڍs
 *  
 *  s̃^XN҂ԂɈڍsCEʐMIuWFNg̑҂L[
 *  ɂȂD܂C҂ubNiWINFOjp_wobjcbݒ肷D
 *  wobj_make_wait_tmout́C^CCxgubN̓o^sD
 */
extern void	wobj_make_wait(WOBJCB *p_wobjcb, WINFO_WOBJ *p_winfo);
extern void	wobj_make_wait_tmout(WOBJCB *p_wobjcb, WINFO_WOBJ *p_winfo,
											TMEVTB *p_tmevtb, TMO tmout);

/*
 *  ^XNDxύX̏
 *
 *  EʐMIuWFNgɑ΂҂Ԃɂ^XN̗DxύX
 *  ꂽꍇɁC҂L[̒ł̃^XN̈ʒuCD
 */
Inline void
wobj_change_priority(WOBJCB *p_wobjcb, TCB *p_tcb)
{
	if ((p_wobjcb->p_wobjinib->wobjatr & TA_TPRI) != 0U) {
		queue_delete(&(p_tcb->task_queue));
		queue_insert_tpri(&(p_wobjcb->wait_queue), p_tcb);
	}
}

/*
 *  ҂L[̏
 *
 *  ҂L[ɂȂĂ^XNׂđ҂D҂
 *  ^XN̕ԒĺCE_DLTƂD҂^XNւ̃fBXpb`
 *  KvȏꍇtrueCłȂꍇfalseԂD
 */
extern bool_t	init_wait_queue(QUEUE *p_wait_queue);

#endif /* TOPPERS_WAIT_H */
