/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: upd72001.h 873 2008-04-11 10:32:26Z hiro $
 */

/*
 *		PD72001p ȈSIOhCo
 */

#ifndef TOPPERS_UPD72001_H
#define TOPPERS_UPD72001_H

/*
 *  VAI/O|[g̒`
 */
#define TNUM_SIOP		2		/* T|[gVAI/O|[g̐ */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block	SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_RDY_SND		1U		/* M\R[obN */
#define SIO_RDY_RCV		2U		/* MʒmR[obN */

/*
 *  SIOhCȍ[`
 */
extern void		upd72001_initialize(void);

/*
 *  I[vĂ|[g邩H
 */
extern bool_t	upd72001_openflag(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*upd72001_opn_por(ID siopid, intptr_t exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void		upd72001_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern bool_t	upd72001_snd_chr(SIOPCB *siopcb, char_t c);

/*
 *  VAI/O|[g̕M
 */
extern int_t	upd72001_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void		upd72001_ena_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void		upd72001_dis_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void		upd72001_isr(void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void		upd72001_irdy_snd(intptr_t exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void		upd72001_irdy_rcv(intptr_t exinf);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_UPD72001_H */
