/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		VAI/OfoCXiSIOjhCoiRSK-M16C-62Ppj
 */

#ifndef TOPPERS_TARGET_SERIAL_H
#define TOPPERS_TARGET_SERIAL_H

#include "RSK-M16C-62P.h"
#include "m16c/m16c_uart.h"

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO_TX	TINHNO_S2TNACK		/* ݃nhԍ */
#define INTNO_SIO_TX	TINTNO_S2TNACK		/* ݔԍ */
#define INHNO_SIO_RX	TINHNO_S2RACK		/* ݃nhԍ */
#define INTNO_SIO_RX	TINTNO_S2RACK		/* ݔԍ */
#define INTPRI_SIO		-6				/* ݗDx */
#define INTATR_SIO		TA_NULL			/* ݑ */

#ifndef TOPPERS_MACRO_ONLY


/*
 *  SIOhCȍ
 */
extern void		sio_initialize(intptr_t exinf);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*sio_opn_por(ID siopid, intptr_t exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void		sio_cls_por(SIOPCB *p_siopcb);

/*
 *  SIO̊݃nh
 */
extern void sio_tx_isr(intptr_t exinf);
extern void sio_rx_isr(intptr_t exinf);

/*
 *  SIO̊݃nh
 */
extern void		sio_handler(void);

/*
 *  VAI/O|[gւ̕M
 */
extern bool_t		sio_snd_chr(SIOPCB *siopcb, char_t c);

/*
 *  VAI/O|[g̕M
 */
extern int_t	sio_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void		sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void		sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void		sio_irdy_snd(intptr_t exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void		sio_irdy_rcv(intptr_t exinf);


#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_SERIAL_H */
