/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *		vZbTˑW[iM16Cpj
 */

#include "kernel_impl.h"

/*
 *  ݗvC̑̐ݒ(vZbTˑ)
 */
void
m16c_config_int(INTNO intno)
{
	/* ݗvIWX^ݒ肷 */
	switch(intno)
	{
		case	TINTNO_INT0:
		*((volatile uint8_t *) TADR_SFR_IFSR) |= 0x01;
		break;
		case	TINTNO_INT1:
		*((volatile uint8_t *) TADR_SFR_IFSR) |= 0x02;
		break;
		case	TINTNO_INT2:
		*((volatile uint8_t *) TADR_SFR_IFSR) |= 0x04;
		break;
		case	TINTNO_INT3:
		*((volatile uint8_t *) TADR_SFR_IFSR) |= 0x08;
		break;
		case	TINTNO_INT4:
		*((volatile uint8_t *) TADR_SFR_IFSR) |= 0x10;
		break;
		case	TINTNO_INT5:
		*((volatile uint8_t *) TADR_SFR_IFSR) |= 0x20;
		break;
		default:
		/* INT݈ȊO̓RtBM[^ňُƂB */
		break;
	}
}

/* ݗvWX^ */
volatile uint8_t * const intc_reg[INHNO_MAX] = 
{
	/* 0- */
	NULL ,	/* BRK */
	NULL ,	/* Reserve */
	NULL ,	/* Reserve */
	NULL ,	/* Reserve */
	(volatile uint8_t *)TADR_SFR_INT3IC ,	/* INT3	*/
	(volatile uint8_t *)TADR_SFR_TB5IC ,	/* ^C}B5	*/
	(volatile uint8_t *)TADR_SFR_TB4IC ,	/* ^C}B4	*/
	(volatile uint8_t *)TADR_SFR_TB3IC ,	/* ^C}B3	*/
	/* 8- */
	(volatile uint8_t *)TADR_SFR_INT5IC ,	/* SIO4,INT5 */
	(volatile uint8_t *)TADR_SFR_INT4IC ,	/* SIO3,INT4 */
	(volatile uint8_t *)TADR_SFR_BCNIC ,	/* UARToXՓˌo */
	(volatile uint8_t *)TADR_SFR_DM0IC ,	/* DMA0 */
	(volatile uint8_t *)TADR_SFR_DM1IC ,	/* DMA1 */
	(volatile uint8_t *)TADR_SFR_KUPIC ,	/* L[͊ */
	(volatile uint8_t *)TADR_SFR_ADIC  ,	/* A/D */
	(volatile uint8_t *)TADR_SFR_S2TIC ,	/* UART2M */
	/* 16- */
	(volatile uint8_t *)TADR_SFR_S2RIC ,	/* UART2M */
	(volatile uint8_t *)TADR_SFR_S0TIC ,	/* UART0M */
	(volatile uint8_t *)TADR_SFR_S0RIC ,	/* UART0M */
	(volatile uint8_t *)TADR_SFR_S1TIC ,	/* UART1M */
	(volatile uint8_t *)TADR_SFR_S1RIC ,	/* UART1M */
	(volatile uint8_t *)TADR_SFR_TA0IC ,	/* ^C}A0	*/
	(volatile uint8_t *)TADR_SFR_TA1IC ,	/* ^C}A1	*/
	(volatile uint8_t *)TADR_SFR_TA2IC ,	/* ^C}A2	*/
	/* 24- */
	(volatile uint8_t *)TADR_SFR_TA3IC ,	/* ^C}A3	*/
	(volatile uint8_t *)TADR_SFR_TA4IC ,	/* ^C}A4	*/
	(volatile uint8_t *)TADR_SFR_TB0IC ,	/* ^C}B0	*/
	(volatile uint8_t *)TADR_SFR_TB1IC ,	/* ^C}B1	*/
	(volatile uint8_t *)TADR_SFR_TB2IC ,	/* ^C}B2	*/
	(volatile uint8_t *)TADR_SFR_INT0IC ,	/* INT0	*/
	(volatile uint8_t *)TADR_SFR_INT1IC ,	/* INT1	*/
	(volatile uint8_t *)TADR_SFR_INT2IC ,	/* INT2	*/
	/* 32- */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	/* 40- */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	/* 48- */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	/* 56- */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
	NULL ,	/* INT */
};
