/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *		vZbTˑW[iM16Cpj
 *
 *  ̃CN[ht@ĆCtarget_config.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

#ifndef TOPPERS_MACRO_ONLY

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include "prc_insn.h"
#include "interrupt.h"


/*
 *  ^XNReLXgp̃X^bNl
 */

#define TOPPERS_ISTKPT(istk, istksz) ((STK_T *)((char_t *)(istk) + (istksz)))

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	void		*sp;		/* X^bN|C^ */
	uint32_t	pc;			/* vOJE^ */
} CTXB;

/*
 *  ݔ񐔂ۑϐ
 */
extern uint16_t intnest;


/*
 *  CPUbNԂł̊ݗDx}XN
 *
 *  TIPM_LOCḰCCPUbNԂł̊ݗDx}XNCȂ킿CJ[l
 *  ǗÔׂ̂Ă̊ݗv}XNlɒ`D
 *
 *  ႦTIPM_LOCK-6ɐݒ肷ƁCx7݂̊J[lǗO
 *  ȂDTIPM_LOCK-7ɐݒ肷ƁCNMIȊOɃJ[lǗO݂̊
 *  ݂ȂƂɂȂȉꍇɂ-7ɐݒ肷邱Ƃ𐄏jD
 */
#ifndef TIPM_LOCK
#define TIPM_LOCK	(-7)		/* J[lǗO݂݂̊Ȃ */
#endif /* TIPM_LOCK */

/*
 *  TOPPERSWݏf̎
 *
 */

/*
 *  ReLXg̎Q
 *
 *  M16Cł́C݂̖߂悪^XNǂ𔻒f邽߂ intnest
 *  gpĂDpăReLXg𔻒fD
 */
Inline bool_t
sense_context(void)
{
	/*  lXgJE^0Ȃ^XNReLXg  */
	return (intnest > 0);
}

/*
 *  CPUbNtÔ߂̕ϐ
 *
 *  ̕ϐ́CCPUbNԂ̎̂ݏĂ悢̂ƂD
 */
#if TIPM_LOCK != -7
extern bool_t		lock_flag;		/* CPUbNtO̒lێϐ */
extern uint16_t	saved_ipl;		/* ݗDxxۑϐ */
#endif	/* TIPM_LOCK != -7	*/

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ݗDx}XN̊O\Ɠ\̕ϊ
 *
 *  M16Cł́CtOWX^iFLGj̉12`14rbgڂ3rbg
 *  ݗDxxiIPLjuĂD
 *  J[lǗO݂ꍇIPLgpsD
 *  J[l͊ݗDx}XNi-1A̒ljŊǗ
 *  邽IPLƂ̕ϊKvƂȂD
 */
#define IPL2IPM(ipl)	(-((PRI)((ipl) >> 12)))			/* IPLIPM	*/
#define IPM2IPL(ipm)	(((uint16_t)(-(ipm))) << 12)	/* IPMIPL	*/


/*
 *  CPUbNԂł̊ݗDx}XNIPL
 */
#define IPL_LOCK	(IPM2IPL(TIPM_LOCK))

/*
 *  TIPM_ENAALLiݗDx}XNSjIPL
 */
#define IPL_ENAALL		(IPM2IPL(TIPM_ENAALL))

#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUbNԂւ̈ڍs
 *
 *  IPMin[hEFÅݗDx}XNjCsaved_iipmɕۑCJ[
 *  lǗÔׂ̂Ă̊ݗv}XNliTIPM_LOCKj
 *  ɐݒ肷D܂Clock_flagtrueɂD
 *
 *  IPMCŏTIPM_LOCKƓ荂ꍇɂ́C
 *  saved_iipmɕۑ݂̂ŁCTIPM_LOCKɂ͐ݒ肵ȂD́Cf
 *  ̊ݗDx}XNCTIPM_LOCKƓ荂xɐݒ
 *  ĂԂɂD
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjŌĂ΂邱Ƃ
 *  Ȃ̂Ƒz肵ĂD
 */
Inline void
x_lock_cpu(void)
{
#if TIPM_LOCK == -7
	disint();
#else	/* TIPM_LOCK == -7	*/
	uint16_t	ipl;

	/*
	 *  current_ipl()̕Ԃl𒼐saved_iplɕۑCꎞϐipl
	 *  pĂ̂́Ccurrent_ipl()Ă񂾒Ɋ݂C
	 *  Nꂽݏsaved_iplύX\邽߂
	 *  D
	 */
	ipl = current_ipl();
	if (IPL_LOCK > ipl) {
		set_ipl(IPL_LOCK);
	}
	saved_ipl = ipl;
	lock_flag = true;
#endif	/* TIPM_LOCK == -7	*/
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()

/*
 *  CPUbNԂ̉
 *
 *  lock_flagfalseɂCIPMin[hEFÅݗDx}XNjC
 *  saved_iipmɕۑlɖ߂D
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjł̂݌Ă΂
 *  ̂Ƒz肵ĂD
 */
Inline void
x_unlock_cpu(void)
{
#if TIPM_LOCK == -7
	enaint();
#else	/* TIPM_LOCK == -7	*/
	lock_flag = false;
	set_ipl(saved_ipl);
#endif	/* TIPM_LOCK == -7	*/
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()

/*
 *  CPUbNԂ̎Q
 */
Inline bool_t
x_sense_lock(void)
{
#if TIPM_LOCK == -7
	return((bool_t)((current_flgreg() & FLG_I_MASK) == 0));
#else	/* TIPM_LOCK == -7	*/
	return lock_flag;
#endif	/* TIPM_LOCK == -7	*/
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()

/*
 * if́jݗDx}XN̐ݒ
 *
 *  CPUbNtONAĂ鎞́Cn[hEFÅݗDx}
 *  XNݒ肷DCPUbNtOZbgĂ鎞́Csaved_iipm
 *  ݒ肵CɁCn[hEFÅݗDx}XNCݒ肵悤
 *  if́jݗDx}XNTIPM_LOCK̍ɐݒ肷D
 */
Inline void
x_set_ipm(PRI intpri)
{
	set_ipl((current_ipl() & ~FLG_IPL_MASK) | IPM2IPL(intpri));
}

#define t_set_ipm(intpri)	x_set_ipm(intpri)
#define i_set_ipm(intpri)	x_set_ipm(intpri)

/*
 * if́jݗDx}XN̎Q
 *
 *  CPUbNtONAĂ鎞̓n[hEFÅݗDx}
 *  XNCZbgĂ鎞saved_iipmQƂD
 */
Inline PRI
x_get_ipm(void)
{
	return IPL2IPM(current_ipl() & FLG_IPL_MASK);
}

#define t_get_ipm()	x_get_ipm()
#define i_get_ipm()	x_get_ipm()


/*
 *  ݔԍ͈̔͂̔
 */
#define VALID_INTNO(intno)	((intno) < INHNO_MAX)
#define VALID_INTNO_DISINT(intno)	VALID_INTNO(intno)
#define VALID_INTNO_CFGINT(intno)	VALID_INTNO(intno)

/*
 *  IPL犄ݐ䃌WX^ł̕\ɕϊ}N
 */
#define IPL2ILVL(ipl)	(-(ipl))

/*
 *  ݃Rg[WX^̃AhXe[u
 *  (target_config.cɒ`)
 */
extern volatile uint8_t * const intc_reg[];

/*
 *  ݗṽx`e[u
 *  (tfɂo)
 */
extern const PRI intpri_table[];

/*
 *  ݐ䃌WX^֘A̒`
 */
#define INTC_LVLMASK	(0x07U)
#define INTC_IRMASK		(0x08U)
#define INTC_POLMASK	(0x10U)		/* INT݂̂ */
#define INTC_LVSMASK	(0x20U)		/* INT݂̂ */

#define INTC_POLHIGH	(0x10U)		/* INT݂̂ */
#define INTC_POLLOW		(0x00U)		/* INT݂̂ */
#define INTC_LVSEDGE	(0x00U)		/* INT݂̂ */
#define INTC_LVSLVL		(0x20U)		/* INT݂̂ */

/*
 *  ݗv֎~tÕZbg
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tOZbg悤Ƃꍇɂ́CfalseԂD
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	/* x`0łꍇCFG_INTĂȂ */
	if(intpri_table[intno] == 0U)
	{
		return (false);
	}
	*intc_reg[intno] &= ~INTC_LVLMASK;

	return(true);
}

#define t_disable_int(intno)	x_disable_int(intno)
#define i_disable_int(intno)	x_disable_int(intno)

/*
 *  ݗv֎~tÕNA
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CfalseԂD
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	/* x`0łꍇCFG_INTĂȂ */
	if(intpri_table[intno] == 0U)
	{
		return (false);
	}
	/* ݃xɖ߂ */
	*intc_reg[intno] = (*intc_reg[intno] & ~INTC_LVLMASK) | IPL2ILVL(intpri_table[intno]);
	
	return(true);
}

#define t_enable_int(intno)		x_enable_int(intno)
#define i_enable_int(intno)		x_enable_int(intno)

/*
 *  ݗṽNA
 */
Inline void
x_clear_int(INTNO intno)
{
	*(intc_reg[intno]) &= ~INTC_IRMASK;
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)

/*
 *  ݗṽ`FbN
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	return (((*intc_reg[intno] & INTC_IRMASK) == INTC_IRMASK)? true : false);
}

#define t_probe_int(intno)		x_probe_int(intno)
#define i_probe_int(intno)		x_probe_int(intno)

/*
 *  ݗvC̑̐ݒ
 */
extern void	x_config_int(INTNO intno, ATR intatr, PRI intpri);

/*
 *  ݃nh̓ŕKvIRC
 *
 */
Inline void
i_begin_int(INTNO intno)
{
	/* ɍsׂ͂Ȃ */
}

/*
 *  ݃nh̏oŕKvIRC
 *
 */
Inline void
i_end_int(INTNO intno)
{
	/* ɍsׂ͂Ȃ */
}


/*
 *  ōD揇ʃ^XNւ̃fBXpb`iprc_support.a30j
 *
 *  dispatch́C^XNReLXgĂяoꂽT[rXR[
 *  ĂяôׂŁC^XNReLXgECPUbNԁEfBXpb
 *  `ԁEif́jݗDx}XNSԂŌĂяo
 *  ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  fBXpb`̓Jniprc_support.a30j
 *
 *  start_dispatch́CJ[lNɌĂяôׂŁCSĂ̊
 *  ֎~ԁiS݃bNԂƓ̏ԁjŌĂяoȂ
 *  ȂȂD
 */
extern void	start_dispatch(void) NoReturn;

/*
 *  ݂̃ReLXĝĂăfBXpb`iprc_support.a30j
 *
 *  exit_and_dispatch́Cext_tskĂяôׂŁC^XNReL
 *  XgECPUbNԁEfBXpb`ԁEif́jݗD
 *  x}XNSԂŌĂяoȂ΂ȂȂD
 */
#define _kernel_exit_and_dispatch();	\
	_exit_and_dispatch();		\
	ercd = E_SYS;
extern void	_exit_and_dispatch(void) NoReturn;

/*
 *  J[l̏Ǐďoiprc_support.a30j
 *
 *  call_exit_kerneĺCJ[l̏IɌĂяôׂŁC^XN
 *  ReLXgɐ؂芷āCJ[l̏Iiexit_kerneljĂяo
 *  D
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D̎_
 *  ŃX^bN̈gĂ͂ȂȂD
 *
 *  activate_contextCCC֐ł͂Ȃ}N`ƂĂ̂́C
 *  ̎_łTCB`ĂȂ߂łD
 */
extern void	start_r(void);
extern uint8_t *tsk_sp;

#define activate_context(p_tcb)																\
{																							\
	{																						\
		(p_tcb)->tskctxb.sp = (void*)((uint32_t)(p_tcb)->p_tinib->stk + 					\
						(uint16_t)(p_tcb)->p_tinib->stksz);									\
		(p_tcb)->tskctxb.pc = (uint32_t)start_r;											\
	}																						\
}

/*
 *  calltex͎gpȂ
 */
#define OMIT_CALLTEX

/*
 *  ݃nh̐ݒ
 *
 *  M16CROMɊ݃xN^zu邽߁C{֐͋֐ŎD
 */
Inline void
x_define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPUOnh̐ݒ
 *
 *  M16CROMɗOxN^zu邽߁C{֐͋֐ŎD
 */
Inline void
x_define_exc(EXCNO excno, FP exchdr)
{
}

/*
 *  /Onh̓̐}N
 *
 *  ev[gt@Cɂ萶邽ߋ}NƂD
 */
#define HDR_ENTRY(hdr, intexc_num , tobejmp)

/*
 *  ݃nh̓̐}N
 */
#define _INT_ENTRY(inhno, inthdr)				_kernel_##inthdr##_##inhno##_entry
#define INT_ENTRY(inhno, inthdr)				_INT_ENTRY(inhno , inthdr)

#define _INTHDR_ENTRY(inhno, inhno_num ,inthdr)	\
		extern _kernel_##inthdr##_##inhno##_entry(void);
#define INTHDR_ENTRY(inhno, inhno_num ,inthdr)	_INTHDR_ENTRY(inhno, inhno_num ,inthdr)

/*
 *  CPUOnh̓̐}N
 */
#define _EXC_ENTRY(excno , exchdr)					_kernel_##exchdr##_##excno##_entry
#define EXC_ENTRY(excno , exchdr)					_EXC_ENTRY(excno , exchdr)

#define _EXCHDR_ENTRY(excno , excno_num , exchdr)	\
		extern _kernel_##exchdr##_##excno##_entry(void);
#define EXCHDR_ENTRY(excno , excno_num , exchdr)	_EXCHDR_ENTRY(excno , excno_num , exchdr)


/*
 *  CPUO̔̃ReLXg̎Q
 *
 *  CPUO̔̃ReLXgC^XNReLXg̎falseC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	/* 
	 *  lXgJE^1Ȃ^XNReLXg
	 */
	return( intnest > 1u );
}

/*
 *  CPUO̔IPL̎Q
 */
Inline uint16_t
exc_get_ipl(void *p_excinf)
{
	return(((*((uint8_t *)((uintptr_t)p_excinf+19))) & 0x70U) >> 4u);
}

Inline bool_t
exc_sense_i(void *p_excinf)
{
	return((*((uint8_t *)((uintptr_t)p_excinf+18)) & 0x40U) != 0u);
}

/*
 *  CPUO̔̃ReLXgƊ݂̃}XNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłCS݃bNԂłȂCCPUbNԂłȂC
 *  if́jݗDx}XNSԂł鎞trueCł
 *  falseԂiCPUOJ[lǗO̊ݏŔ
 *  ꍇɂfalseԂjD
 *
 *  J[lsłȂ (TIPM_LOCK== -7) ItO == 0
 *                         (else)           IPL < IPL_LOCK
 *  ^XNReLXgł遨intnest == 0
 *  S݃bNłȂ ItO == 0
 *  ݗDx}XNSIPL == 0
 *  
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return(!exc_sense_context(p_excinf)
			&& !exc_sense_i(p_excinf)
			&& (exc_get_ipl(p_excinf) == IPL_ENAALL));
}

/*
 *  CPUO̔̃ReLXgƊ݁^CPUbNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłCS݃bNԂłȂCCPUbNԂłȂ
 *  trueCłȂfalseԂiCPUOJ[lǗO̊
 *  ŔꍇɂfalseԂjD
 *
 *  J[lsłȂ (TIPM_LOCK== -7) ItO == 0
 *                         (else)           IPL < TIPM_LOCK
 *  ^XNReLXgł遨intnest < 1 
 *  S݃bNłȂ ItO == 0
 *  CPUbNԂłȂ(TIPM_LOCK== -7) ItO == 0
 *                         (else)           IPL < TIPM_LOCK
 */
Inline bool_t
exc_sense_unlock(void *p_excinf)
{
#if TIPM_LOCK == -7
	return(!exc_sense_context(p_excinf)
			&& exc_sense_i(p_excinf));
#else
	return(!exc_sense_context(p_excinf)
			&& exc_sense_i(p_excinf)
			&& exc_get_ipl(p_excinf) < TIPM_LOCK);
#endif
}

/*
 *  vZbTˑ̏
 */
extern void	prc_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	prc_terminate(void);


#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_PRC_CONFIG_H */
