/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: exception.c 748 2008-03-07 17:18:06Z hiro $
 */

/*
 *		CPUOǗ@\
 */

#include "kernel_impl.h"
#include "task.h"
#include "exception.h"

/*
 *  g[XO}ÑftHg`
 */
#ifndef LOG_XSNS_DPN_ENTER
#define LOG_XSNS_DPN_ENTER(p_excinf)
#endif /* LOG_XSNS_DPN_ENTER */

#ifndef LOG_XSNS_DPN_LEAVE
#define LOG_XSNS_DPN_LEAVE(state)
#endif /* LOG_XSNS_DPN_LEAVE */

#ifndef LOG_XSNS_XPN_ENTER
#define LOG_XSNS_XPN_ENTER(p_excinf)
#endif /* LOG_XSNS_XPN_ENTER */

#ifndef LOG_XSNS_XPN_LEAVE
#define LOG_XSNS_XPN_LEAVE(state)
#endif /* LOG_XSNS_XPN_LEAVE */

/* 
 *  CPUOnhǗ@\̏
 */
#ifdef TOPPERS_excini
#ifndef OMIT_INITIALIZE_EXCEPTION

void
initialize_exception(void)
{
	uint_t			i;
	const EXCINIB	*p_excinib;

	for (p_excinib = excinib_table, i = 0; i < tnum_excno; p_excinib++, i++) {
		x_define_exc(p_excinib->excno, p_excinib->exc_entry);
	}
}

#endif /* OMIT_INITIALIZE_EXCEPTION */
#endif /* TOPPERS_excini */

/*
 *  CPUO̔ReLXg̎Q
 */

/*
 *  CPUÕfBXpb`ۗԂ̎Q
 *
 *  CPUOnhdisdspω邱Ƃ͂Ȃ߁CCPUO
 *  disdspۑĂKv͂ȂD
 */
#ifdef TOPPERS_xsns_dpn

bool_t
xsns_dpn(void *p_excinf)
{
	bool_t	state;

	LOG_XSNS_DPN_ENTER(p_excinf);
	state = (exc_sense_intmask(p_excinf) && !disdsp) ? false : true;
	LOG_XSNS_DPN_LEAVE(state);
	return(state);
}

#endif /* TOPPERS_xsns_dpn */

/*
 *  CPUÕ^XNOۗԂ̎Q
 *
 *  CPUOnhp_runtskp_runtsk->enatexω邱Ƃ͂Ȃ
 *  ߁CCPUOp_runtsk->enatexۑĂKv͂
 *  D
 */
#ifdef TOPPERS_xsns_xpn

bool_t
xsns_xpn(void *p_excinf)
{
	bool_t	state;

	LOG_XSNS_XPN_ENTER(p_excinf);
	state = (exc_sense_unlock(p_excinf)
				&& p_runtsk != NULL && p_runtsk->enatex) ? false : true;
	LOG_XSNS_XPN_LEAVE(state);
	return(state);
}

#endif /* TOPPERS_xsns_xpn */
