/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: target_timer.h 889 2008-04-11 11:17:35Z hiro $
 */

/*
 *		^C}hCoiDVE68K/40pj
 */

#ifndef TOPPERS_TARGET_TIMER_H
#define TOPPERS_TARGET_TIMER_H

#include <sil.h>
#include "dve68k.h"

/*
 *  ^C}݃nho^̂߂̒萔
 */
#define INHNO_TIMER		TINHNO_TT0		/* ݃nhԍ */
#define INTNO_TIMER		TINTNO_TT0		/* ݔԍ */
#define INTPRI_TIMER	TIRQ_LEVEL4		/* ݗDx */
#define INTATR_TIMER	TA_EDGE			/* ݑ */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef uint32_t	CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *
 *  DVE68K/40ł́C^C}1ʕbɃJEgAbvD
 */
#define TIMER_CLOCK				1000U
#define TO_CLOCK(nume, deno)	((CLOCK)(TIMER_CLOCK * (nume) / (deno)))
#define TO_USEC(clock)			(((SYSUTM) clock) * 1000U / TIMER_CLOCK)

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK		((CLOCK) 0xffffffU)

/*
 *  ^C}~܂ł̎ԁinsecPʁj
 *
 *  lɍ͂ȂD
 */
#define TIMER_STOP_DELAY	200U

/*
 *  WX^̐ݒl
 */
#define CSR12_START		0x80000000U		/* ^C} */
#define CSR12_STOP		0x00000000U		/* ^C}~ */

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
extern void	target_timer_initialize(intptr_t exinf);

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
extern void	target_timer_terminate(intptr_t exinf);

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
target_timer_get_current(void)
{
	CLOCK		clk;
	uint32_t	saved_csr12;
	SIL_PRE_LOC;

	/*
	 *  ^C}̓ꎞIɒ~C^C}lǂݏoD^C}̓
	 *  ꎞIɒ~ƁCVXe邽߂ɖ]܂Ȃ
	 *  CDVE68K/40̃n[hEFAIȐłCނȂD
	 *  ŏɗ}邽߂ɁC݃bNԂƂD
	 */
	SIL_LOC_INT();
	saved_csr12 = dga_read((void *) TADR_DGA_CSR12);
	dga_write((void *) TADR_DGA_CSR12, CSR12_STOP);
	sil_dly_nse(TIMER_STOP_DELAY);
	clk = dga_read((void *) TADR_DGA_CSR13) & 0x00ffffffU;
	dga_write((void *) TADR_DGA_CSR12, saved_csr12);
	SIL_UNL_INT();
	return(clk);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline bool_t
target_timer_probe_int(void)
{
	return(x_probe_int(INTNO_TIMER));
}

/*
 *  ^C}݃nh
 */
extern void	target_timer_handler(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_TIMER_H */
