﻿Public Class frmMain
    Dim output As String

    Private Sub btnAnalyze_Click(sender As System.Object, e As System.EventArgs) Handles btnAnalyze.Click
        ReAnalyze()
    End Sub

    Private Sub Analyze()
        Dim board As Board = BoardViewer1.kyokumen
        Dim checkStateDir = My.Application.Info.DirectoryPath
        Const checkStateName As String = "doubutu.checkState.exe"
        Dim sjisEnc As System.Text.Encoding = System.Text.Encoding.GetEncoding("Shift_JIS")
        Using ws As New System.IO.StreamWriter(String.Format("{0}\init.txt", checkStateDir), False, sjisEnc)
            ws.Write(board.ToString)
        End Using
        Dim psInfo As New System.Diagnostics.ProcessStartInfo
        psInfo.Arguments = "init.txt"
        psInfo.WorkingDirectory = checkStateDir
        psInfo.FileName = checkStateDir & "\" & checkStateName
        psInfo.CreateNoWindow = True
        psInfo.UseShellExecute = False
        psInfo.RedirectStandardError = True

        Try
            Using p As System.Diagnostics.Process =
            System.Diagnostics.Process.Start(psInfo)
                output = p.StandardError.ReadToEnd()
                output = output.Replace(vbCr + vbCrLf, vbLf)
            End Using
        Catch ex As Exception
            output = $"エラー:{checkStateName}が正常に実行できませんでした。"
        End Try


    End Sub

    Private Sub BoardViewer1_Editing(sender As System.Object, e As doubutu.UI.Form.Control.Board.EditingEventArgs) Handles BoardViewer1.Editing
        e.IsMove = True
        If Not BoardViewer1.kyokumen.CanMove(e.MovingValue) Then
            e.Cancel = True
        End If
        If e.MouseRightClicked Then
            e.Cancel = True
        End If
    End Sub

    Private Sub btnUndoFirst_Click(sender As System.Object, e As System.EventArgs) Handles btnUndoFirst.Click
        BoardViewer1.kyokumen.UndoAll()
        FormUpdate()
    End Sub

    Private Sub btnUndo_Click(sender As System.Object, e As System.EventArgs) Handles btnUndo.Click
        BoardViewer1.kyokumen.Undo()
        FormUpdate()
    End Sub

    Private Sub btnNext_Click(sender As System.Object, e As System.EventArgs) Handles btnNext.Click
        BoardViewer1.kyokumen.DoNext()
        FormUpdate()
    End Sub

    Private Sub BoardViewer1_Edited(sender As System.Object, e As doubutu.UI.Form.Control.Board.EditedEventArgs) Handles BoardViewer1.Edited
        ReAnalyze()
    End Sub

    Private Sub BackgroundWorker1_DoWork(sender As System.Object, e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        Analyze()
    End Sub

    Private Sub BackgroundWorker1_RunWorkerCompleted(sender As System.Object, e As System.ComponentModel.RunWorkerCompletedEventArgs) Handles BackgroundWorker1.RunWorkerCompleted
        Dim lines As String() = output.Split(vbLf)
        ListBox1.Items.Clear()
        ListBox1.Items.AddRange(lines)
    End Sub

    Private Sub chkRotated_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkRotated.CheckedChanged
        BoardViewer1.IsBoardViewRotated = chkRotated.Checked
        BoardViewer1.DrawCurrentBitmap()
    End Sub

    Private Sub btnBestMove_Click(sender As System.Object, e As System.EventArgs) Handles btnBestMove.Click
        Dim lines As String() = output.Split(vbLf)
        Dim bestMoveCode As String = String.Empty
        For Each line As String In lines
            If line.StartsWith("Move") Then
                bestMoveCode = line.Substring(7, 7)
                Exit For
            End If
        Next
        If bestMoveCode <> String.Empty Then
            Dim move As Move = New Move(bestMoveCode)
            BoardViewer1.kyokumen.DoMove(move)
            FormUpdate()
            ReAnalyze()
        End If
    End Sub

    Private Sub FormUpdate()
        BoardViewer1.DrawCurrentBitmap()
        output = String.Empty
        ListBox1.Items.Clear()
    End Sub

    Private Sub ReAnalyze()
        While BackgroundWorker1.IsBusy
            Threading.Thread.Sleep(1)
            Application.DoEvents()
        End While
        output = String.Empty
        ListBox1.Items.Clear()
        BackgroundWorker1.RunWorkerAsync()
    End Sub

    Private Sub ListBox1_Click(sender As System.Object, e As System.EventArgs) Handles ListBox1.Click
        If ListBox1.SelectedIndex = -1 Then
            Exit Sub
        End If
        Dim line As String = DirectCast(ListBox1.SelectedItem, String)
        Dim startIdx As Integer = line.IndexOfAny({"+"c, "-"c})
        Dim movecode As String = line.Substring(startIdx, 7)
        Dim move As New Move(movecode)
        If BoardViewer1.kyokumen.CanMove(move) Then
            BoardViewer1.kyokumen.DoMove(move)
            FormUpdate()
            ReAnalyze()
        End If
    End Sub
End Class
