﻿Public Class Move

    Public Sub New(ByVal FromPos As Position, ByVal toPos As Position, ByVal komaVal As Koma)
        Me.New(FromPos.X, FromPos.Y, toPos.X, toPos.Y, komaVal)
    End Sub

    Public Sub New(ByVal FromX As Integer, ByVal FromY As Integer, ByVal ToX As Integer, ToY As Integer, ByVal komaVal As Koma)
        FromPos = New Position(FromX, FromY)
        ToPos = New Position(ToX, ToY)
        Koma = komaVal
        If MustPromote() Then
            Dim komaside As Koma = KomaUtil.KomaSideKoma(komaVal)
            Koma = komaside + Form.Koma.NI
        End If
    End Sub

    Public Sub New(ByVal code As String)
        Debug.Assert(code.Length = 7)
        FromPos = New Position(code.Substring(1, 2))
        ToPos = New Position(code.Substring(3, 2))
        Dim side As Side = SideUtil.GetSide(code(0))
        Koma = KomaUtil.GetKomaFromCode(code.Substring(5, 2), side)
    End Sub

    Public Overrides Function ToString() As String
        Return SideUtil.ToCode(KomaUtil.KomaSide(Koma)) &
            FromPos.ToString &
            ToPos.ToString &
            KomaUtil.ToCode(Koma)
    End Function
    ''' <summary>
    ''' 駒の移動元のマス
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property FromPos As Position
    ''' <summary>
    ''' 駒の移動先のマス
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ToPos As Position
    ''' <summary>
    ''' 移動した駒の種類
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Koma As Koma

    ''' <summary>
    ''' 取った駒の種類
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property CapturedPiece As Koma = Form.Koma.Empty

    ''' <summary>
    ''' なりごまとなるか（ヒヨコがニワトリになるか）
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function MustPromote()
        If FromPos.IsCaptured Then
            Return False
        End If
        If Koma = Form.Koma.GoteHI Then
            If ToPos.Y = 4 Then
                Return True
            End If
        End If
        If Koma = Form.Koma.SenteHI Then
            If ToPos.Y = 1 Then
                Return True
            End If
        End If
        Return False
    End Function

    ''' <summary>
    ''' なったか
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property IsPromote As Boolean

    Public Shared Operator =(ByVal op1 As Move, ByVal op2 As Move)
        Return op1.ToString = op2.ToString
    End Operator
    Public Shared Operator <>(ByVal op1 As Move, ByVal op2 As Move)
        Return Not (op1 = op2)
    End Operator
End Class
