import PyQt4.QtGui as QtGui
from PyQt4 import QtCore
import sys
import time
import cfgui
from hsLogger import hsLogger
from threading import Thread

from sweepingRobot_2014 import hoppingSweeper
#logging.basicConfig(level=logging.DEBUG)

class hsMain(QtGui.QWidget):
    mode=0
    
    def __init__(self):
        super(hsMain,self).__init__()
        self.hs=hoppingSweeper.hoppingSweeper("radio://0/9/250K",45000,48000)
        #self.hs=hoppingSweeper.hoppingSweeper("radio://0/10/250K",45000,48000)
        self.panel =cfgui.panel_widget()
        self.setInterface()
        self.hslogger=hsLogger()
        self.hslogger.makelogger()
        
        
        
    def setInterface(self):
        self.panel.button_widget.connect_button.clicked.connect(self.getConnection)
        self.panel.button_widget.connect_button.clicked.connect(self.panel.button_widget.connect_disenable)
        self.panel.button_widget.disconnect_button.clicked.connect(self.disConnection)
        self.panel.button_widget.disconnect_button.clicked.connect(self.panel.button_widget.connect_enable)

        self.panel.log_widget.val1.setText(self.hs.collector.moniMagValue)
        self.panel.log_widget.val2.setText(self.hs.collector.moniYawValue)
        self.panel.log_widget.val3.setText(self.hs.collector.moniRollValue)

        self.panel.thrust_widget.thrust_slider.valueChanged.connect(self.panel.thrust_widget.change_thrustValue)
        self.panel.thrust_widget.roll_slider.valueChanged.connect(self.panel.thrust_widget.change_rollValue)
        self.panel.thrust_widget.pitch_slider.valueChanged.connect(self.panel.thrust_widget.change_pitchValue)
        self.panel.thrust_widget.yaw_slider.valueChanged.connect(self.panel.thrust_widget.change_yawValue)
        
        self.panel.thrust_widget.thrust_slider.valueChanged.connect(self.change_thrust)    
        self.panel.thrust_widget.roll_slider.valueChanged.connect(self.change_roll)
        self.panel.thrust_widget.pitch_slider.valueChanged.connect(self.change_pitch)
        self.panel.thrust_widget.yaw_slider.valueChanged.connect(self.change_yaw)
    
        self.panel.Checkbox_widget.mode1_box.stateChanged.connect(self.setmode1)
        self.panel.Checkbox_widget.mode2_box.stateChanged.connect(self.setmode2)
        self.panel.Checkbox_widget.manual_box.stateChanged.connect(self.setmanual)
        self.panel.direction_widget.redButton.pressed.connect(self.step_motion)
        self.panel.direction_widget.redButton.released.connect(self.default_motion)
        self.panel.direction_widget.greenButton.pressed.connect(self.green_motion)
        self.panel.direction_widget.greenButton.released.connect(self.default_motion)
        self.panel.direction_widget.blueButton.pressed.connect(self.blue_motion)
        self.panel.direction_widget.blueButton.released.connect(self.default_motion)
        self.panel.direction_widget.noLEDButton.pressed.connect(self.noLED_motion)
        self.panel.direction_widget.noLEDButton.released.connect(self.default_motion)



    def change_thrust(self,value):
        if value==0:
            self.hs.actor.thrust =value
        else:
            self.hs.actor.thrust =value*499+10001  
    def change_pitch(self,value):
        self.hs.actor.pitch=value
    def change_roll(self,value):
        self.hs.actor.roll=value
    def change_yaw(self,value):
        self.hs.actor.yaw=value
    def setmode1(self,state):
        if(state!=0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "1")
            self.panel.Checkbox_widget.mode2_box.setCheckState(0)
            self.panel.Checkbox_widget.manual_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode2_box.checkState()==0 and
             self.panel.Checkbox_widget.manual_box.checkState()==0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "0")            
    def setmode2(self,state):
        if(state!=0):
            self.hs.crazyflie.param.set_value("flightmode.althold","1")
            self.panel.Checkbox_widget.mode1_box.setCheckState(0)
            self.panel.Checkbox_widget.manual_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode1_box.checkState()==0 and
             self.panel.Checkbox_widget.manual_box.checkState()==0):
            self.hs.crazyflie.param.set_value("flightmode.althold", "0") 
    def setmanual(self,state):
        if(state!=0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "3")
            self.panel.Checkbox_widget.mode1_box.setCheckState(0)
            self.panel.Checkbox_widget.mode2_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode2_box.checkState()==0 and
             self.panel.Checkbox_widget.mode1_box.checkState()==0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "0")      
    def step_motion(self):
        self.hs.actor.groundMove("FORWARD",15)

    def green_motion(self):
        time.sleep(2)
        #self.hs.startOperationT()
        self.hs.startAdaptationLogic()
        print(self.hs.analyzer.analyzeRemainPath())
    def blue_motion(self):
        time.sleep(2)
        self.hs.startOperation2()
    def noLED_motion(self):
        time.sleep(3)
        self.hs.actor.groundMove("FORWARD", 30)
    def default_motion(self):
        self.pitch=0
        self.roll=0
    def getConnection(self):
        self.hs.getConnection()
        #self.hs0.getConnection()
        self.f=open('data.txt','w')
        Thread(target=self.logUpdater).start()
    def disConnection(self):
        self.p=0
        self.hs.stopOperation()

        self.hs.disConnection()
        #self.f.close()

    def logUpdater(self):
        self.p=1
        self.hslogger.log_messsage(
                                    #"state"+","
                                    #+"seaquens+","
                                    "resultX"+","
                                    +"resultY"+","
                                    +"resultOfYaw"+","
                                    +"remain"+","
                                    +"state"+","
                                    +"xSafety"+","
                                    +"ySafety"+","
                                    +"x"+","
                                    +"y"+","
                                    #"goal"+","
                                    +"timeCounter"+","
                                    +"flightTime"+","
                                    +"cpi"+","
                                    +"spi"+","
                                    +"ev"+","
                                    +"ac"+","
                                    +"pv"+","
                                    +"strategy"
                                   )

        while self.p==1:
            self.panel.log_widget.val1Value.setText("%.2f"%self.hs.collector.getPositionByCam()[0])
            self.panel.log_widget.val2Value.setText("%.2f"%self.hs.collector.getPositionByCam()[1])
            self.panel.log_widget.val3Value.setText("%.2f"%self.hs.collector.getDirect())
            self.hslogger.log_messsage(
                                       #str(self.hs.decider.state)+","
                                       #+str(self.hs.decider.seaquense)+","
                                       str(self.hs.decider.result.resultOfPosition[0])+","
                                       +str(self.hs.decider.result.resultOfPosition[1])+","
                                       +str(self.hs.decider.result.resultOfYaw)+","
                                       +str(self.hs.remain)+","
                                       +str(self.hs.decider.state)+","
                                       +str(self.hs.decider.result.resultOfsafety[0])+","
                                       +str(self.hs.decider.result.resultOfsafety[1])+","
                                       +str(self.hs.collector.getPositionByCam()[0])+","
                                       +str(self.hs.collector.getPositionByCam()[1])+","
                                       
                                       #+str(self.hs.analyzer.goal)+","
                                       +str(self.hs.timeCounter)+","
                                       +str(self.hs.collector.flightTime)+","
                                       +str(self.hs.cpi)+","
                                       +str(self.hs.spi)+","
                                       +str(self.hs.ev)+","
                                       +str(self.hs.ac)+","
                                       +str(self.hs.pv)+","
                                       +str(self.hs.strategy)
                                       )
            time.sleep(0.2)
            #self.panel.thrust_widget.thrust_slider.setValue(self.hs.actor.thrust)
            #self.panel.thrust_widget.roll_slider.setValue(self.hs.actor.roll)
            #self.panel.thrust_widget.pitch_slider.setValue(self.hs.actor.pitch)
            #self.panel.thrust_widget.yaw_slider.setValue(self.hs.actor.yaw)
 
def main():
    app =QtGui.QApplication(sys.argv)
    cf = hsMain()    
    
    main_window =QtGui.QMainWindow()
    main_window.setWindowTitle("crazyflie")
    main_window.setCentralWidget(cf.panel)
    main_window.show()
    
    app.exec_()
    
if __name__=="__main__":
    main()