import logging,time
from cfclient.utils.logconfigreader import LogConfig
from cflib import crtp
from cflib.crazyflie import Crazyflie
from threading import Thread
from collector import collector
from actor import actor
import socket

class interface(object):
    collector
    actor
    batteryCoverThrust=8750
    def __init__(self,uri,actor,collector):
        self.collector=collector
        self.collectorClass=self.collector.getMoniClass()
        self.collectorValue=self.collector.getCollectorVlue()
        self.collectorType=self.collector.getCollectorType()
                                                        
        self.actor =actor
        self.crazyflie=Crazyflie()
        self.crazyflie.connected.add_callback(self.connected)
        self.crazyflie.disconnected.add_callback(self.disconnected)
        self.crazyflie.connection_failed.add_callback(self.connection_failed)
        self.crazyflie.connection_lost.add_callback(self.connection_lost)
        self.uri=uri
        crtp.init_drivers()
    def connected(self,uri):
        self.log =self.updatee()
        self.crazyflie.log.add_config(self.log)
        
        if self.log.valid:
            self.log.data_received_cb.add_callback(self.log_collector)
            self.log.start()
    def disconnected(self,uri):
        print "Disconnected from %s" %(uri)
           
    def connection_failed(self,uri,msg):
        print "Connection to %s failed: %s" %(uri,msg)

    def connection_lost(self,uri,msg):
        print "Connection to %s failed: %s" %(uri,msg)

    def getConnection(self):
        self.crazyflie.open_link(self.uri)
        self.crazyflie.connected.add_callback(self.connected)
        self.makeReceiver('127.0.0.1',8000)
        Thread(target=self.puls_command).start()    

    def disConnection(self):
        self.crazyflie.close_link()
        self.destroyReciever()
    def logging_error(self,logconf,msg):
        print "Error when logging %s" %logconf.name
        
    def updatee(self):
        self.collector_conf=LogConfig(self.collectorClass,100)
        map(lambda x,y:self.collector_conf.add_variable(self.collectorClass+"."+x,y),self.collectorValue,self.collectorType)        
        return self.collector_conf
    def log_collector(self,timestamp,data,logconf):
        self.collectorContents=[]
        map(lambda x:self.collectorContents.append(data[self.collectorClass+"."+x]),self.collectorValue)
        self.collector.setCollectorContents(self.collectorContents)
        
    def puls_command(self):
        while 1:
            if(self.actor.thrust!=0 and self.collector.getBattery()>0):
                t=self.batteryCoverThrust*(3.8-self.collector.getBattery())
            else:
                t=0
            #print(t)
            self.crazyflie.commander.send_setpoint(self.actor.roll, self.actor.pitch, self.actor.yaw, self.actor.thrust+t)
            time.sleep(0.1)            

##################################################################
#if you need position, you activate this function
#and when the robot' move finish, you must call destroyReciever
    def makeReceiver(self,ipAddress,portNum):
        self.host=ipAddress
        self.port=portNum
        self.backlog=10
        self.bufsize=4096
        self.activate=1
        self.sock=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        self.sock.connect((self.host,self.port))
        self.th=Thread(target=self.receive)
        self.th.start()
    def destroyReciever(self):
        self.activate=0 
        self.sock.close()
    def receive(self):
        while(self.activate==1):
            ob=self.sock.recv(self.bufsize)
            xy=ob.split(',')
            self.x=xy[0]
            self.y=xy[1]
            #self.x=self.sock.recv(self.bufsize)
            #self.y=self.sock.recv(self.bufsize)
            
            try:
                self.collector.setPosition([float(self.x),float(self.y)])
            except ValueError:
                print "there are some strange value"   