package multiConcurrentModel;

import java.util.*;

public class State extends ModelMaterial implements Cloneable{
	private HashMap<String,Transition> toTransition;
	private List<String> toTransitionNameList;
	private List<Transition> fromTransitionList;
	private int toTransitionPointer;
	
	public State(String name){
		super(name);
		toTransition=new HashMap<String,Transition>();
		toTransitionNameList=new ArrayList<String>();
		fromTransitionList=new ArrayList<Transition>();
	}
	public void addToTransition(Transition tr){
		if(!containsToTransition(tr.toString())){
			toTransitionNameList.add(tr.toString());
			toTransition.put(tr.toString(), tr);
		}
	}
	public void addFromTransition(Transition tr){
		fromTransitionList.add(tr);
	}

	public boolean containsToTransition(String name){
		return this.toTransitionNameList.contains(name);
	}
	public State getToStateByTransition(String tr){
		return this.toTransition.get(tr).getTo();
	}
	Boolean hasToTransitions(){
		return !toTransition.isEmpty();
		
	}
	
	public int getToTransitionNum(){
		return this.toTransitionNameList.size();
	}
	public Transition getToTransition(int i){
		return this.toTransition.get(this.toTransitionNameList.get(i));
	}
	public Transition getToTransition(String name){
		return this.toTransition.get(name);
	}
	public int getFromTransitionNum(){
		return this.fromTransitionList.size();
	}

	public Transition getFromTransition(int i){
		return this.fromTransitionList.get(i);
	}
	@Override
	public boolean hasNext() {
		return toTransitionPointer< toTransition.size();
	}
	@Override
	public
	ModelMaterial next() {
		return getToTransition(toTransitionPointer++); 
	}
	@Override
	public void reset() {
		toTransitionPointer=0;
		// TODO ꂽ\bhEX^u
		
	}
	public State getClone(){
		State s=null;
		try {
			s =(State) this.clone();
			s.reset();
		} catch (CloneNotSupportedException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		return s;
	}
}
