package multiConcurrentModel;

import java.util.HashMap;
import java.util.List;

public class Transition extends ModelMaterial{
	private State from;
	private State to;
	private boolean isControllable,used;
	private HashMap<String,String> errorStringMap;
	public Transition(String name,State from,State to){
		super(name);
		this.from=from;
		this.to=to;
		this.isControllable=false;
		this.used=false;
	}
	
	public Transition(String name) {
		super(name);
		this.isControllable=false;
	}
	public void setTo(State to){
		this.to=to;
	}
	public void setFrom(State from){
		this.from=from;
	}
	public State getFrom(){
//		System.out.println("getFrom:"+from);
		return this.from;
	}
	public State getTo(){
		return this.to;
	}
	public void setIsControllable(){
		isControllable=true;
	}
	
	public boolean isControllable(){
		return isControllable;
	}

	@Override
	boolean hasNext() {
		// TODO ꂽ\bhEX^u
		return false;
	}

	@Override
	ModelMaterial next() {
		// TODO ꂽ\bhEX^u
		used=true;
		return this.to;
	}

	@Override
	void reset() {
		used=false;
	}

	public void setErrorStrings(State env,List<State> initReq) {
		// TODO Auto-generated method stub
		used=true;
		if(errorStringMap==null)errorStringMap=new HashMap<String,String>();
		String errorString =env.getName(),error="";
		for(int i=0;i<initReq.size();i++){
			String tmp=initReq.get(i).toString();
			if(tmp.contains("ERROR")){
				if(error!="")error=error.concat("&&");
				tmp=tmp+i;
				error=error.concat(tmp);
			}
			errorString=errorString.concat(tmp);
			/*
			this.deadList.add(false);//*/
		}
		System.out.println("Set error string as"+errorString+" for "+error+ "@"+this);
		errorStringMap.put(error,errorString);
	}
	public String getErrorString(String error){
		if(errorStringMap==null||errorStringMap.get(error)==null){
			System.out.println("ERROR: no errorString with "+error+"@"+this+used);
			return null;
		}
		return errorStringMap.get(error);
	}
}
