;; -*- mode: fundamental; coding: euc-jp -*-
;; Medium-Large size dictionary for SKK system
;;
;; Copyright (C) 1988-1995, 1997, 1999-2006
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Hironobu Takahashi <takahasi@tiny.or.jp>,
;; Masahiro Doteguchi, Miki Inooka,
;; Yukiyoshi Kameyama <kameyama@kuis.kyoto-u.ac.jp>,
;; Akihiko Sasaki, Dai Ando, Junichi Okukawa,
;; Katsushi Sato and Nobuhiro Yamagishi
;; Mikio NAKAJIMA <minakaji@osaka.email.ne.jp>
;; SKK Development Team <skk@ring.gr.jp>
;;
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Version: SKK-JISYO.ML,v 2.0 2018/02/03
;; Keywords: japanese
;; Created: April 13, 2003
;; Last Modified: 2018/02/03
;;
;; This dictionary is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.
;;
;; This dictionary is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 51 Franklin St, Fifth Floor,
;; Boston, MA 02110-1301, USA.
;;
;; M 辞書と L 辞書の中間サイズの辞書、という意味で ML 辞書と名付けまし
;; た。PDA などハードディスク (メモリ) が限られた機種でも使用できるよ
;; う、1MB を超えないサイズを維持することを目標としたいと思います。
;; この辞書の origin は、L 辞書です。
;;
;; (1)L 辞書から広辞苑第四版に掲載されている語を抜き出し、
;; (2)L 辞書から接頭辞、接尾辞を抜き出し、
;; (3)ひらがな 10 文字以上のエントリを削除し、
;; (4)都道府県、県庁所在地を追加し、
;; (5)記号類をいくつか追加し、
;; (6)更に S 辞書のコンテンツを追加
;;
;; して作成しました。加除のご希望は、理由を添えて skk@ring.gr.jp
;; まで。
;;
;; okuri-ari entries.
わるよi /悪酔/
わるびr /悪怯/
わるだくm /悪巧/
わるがしこi /悪賢/
わるs /悪/
わるk /悪/
わるi /悪/
わりもどs /割り戻/割戻/
わりふr /割り振/
わりつk /割り付/割付/
わりだs /割出/割り出/
わりこm /割込/割り込/
わりきr /割り切/
わりあt /割当/割り当/
わりt /割/
わらぶk /藁葺/
わらu /笑/
わらk /笑/
わらi /笑/
わめk /喚/叫/
わびずまi /侘住/
わびs /侘/
わのr /輪乗/
わななk /戦慄/
わなg /輪投/
わとj /和綴/
わだかまr /蟠/
わたりあるk /渡り歩/
わたしこm /渡し込/
わたt /渡/
わたs /渡/
わたr /渡/渉/亘/亙/
わずらw /煩/
わずらu /患/煩/
わずk /僅/
わすr /忘/
わしづかm /鷲掴/
わざわi /災/
わざt /態/
わくぐm /枠組/
わぎr /輪切/
わきまe /弁/
わきたt /沸き立/
わきあg /沸き上/
わかがえr /若返/
わかt /分/別/
わかs /若/
わかr /別/分/判/
わかk /若/
わかi /若/
わs /和/
わr /割/
わk /分/沸/湧/涌/
わg /我/
わb /詫/侘/
ろんz /論/
ろんj /論/
ろくn /碌/
ろうs /労/弄/聾/
れいn /例/
るいs /類/
りんt /凛/
りりs /凛々/凛凛/律々/
りょうびらk /両開/
りゃくs /略/
りまわr /利回/
りばらi /利払/
りづm /理詰/
りつk /利付/
りっs /律/
りさg /利下/
りぐi /利食/
りくつづk /陸続/
りくあg /陸揚/
りきm /力/
りおt /利落/
りあg /利上/
りs /利/
らんぎr /乱切/
よわよわs /弱々/
よわふくm /弱含/
よわたr /世渡/
よわs /弱/
よわr /弱/
よわm /弱/
よわk /弱/
よわi /弱/
よろこb /喜/
よろs /宜/
よりつk /寄付/
よりそu /寄り添/
よめとr /嫁取/
よめいr /嫁入/
よみながs /読み流/
よみとr /読み取/
よみこm /読み込/詠み込/
よみきr /読切/
よみがえr /蘇/甦/
よみかえs /読み返/
よみかk /読み書/
よみかe /読み替/
よみd /読み/
よまわr /夜回/
よふかs /夜更/
よふk /夜更/
よびもどs /呼び戻/
よびとm /呼び止/
よびだs /呼出/呼び出/
よびたt /呼び立/
よびこm /呼び込/
よびかk /呼び掛/呼掛/
よびあつm /呼び集/
よにg /夜逃/
よなよn /夜な夜/
よなおs /世直/
よなk /夜泣/
よどおs /夜通/
よどm /澱/淀/
よっt /四/
よだt /夜立/
よそおu /装/
よそおi /装/
よそu /装/
よせがk /寄せ書/
よせあつm /寄せ集/
よじr /捩/
よしあs /善し悪/
よごs /汚/
よごr /汚/
よこわr /横割/
よこばしr /横走/
よこばi /横這/
よこながs /横流/
よこどr /横取/
よことb /横跳/
よこづk /横付/
よこだおs /横倒/
よこずk /横好/
よこすべr /横滑/
よこぎr /横切/
よこがk /横書/
よこs /寄越/遣/
よくばr /欲張/
よくs /浴/
よぎr /過/
よかr /善か/
ようよu /漸/
ようやk /漸/
ようむk /用向/
ようちあさがk /夜討ち朝駆/
ようだt /用立/
ようずm /用済/
ようじんぶかi /用心深/
ようt /夜討/
ようs /要/擁/
ようd /様/
よいっぱr /宵っ張/
よいごs /宵越/
よあるk /夜歩/
よあそb /夜遊/
よあk /夜明/
よz /攀/
よw /酔/
よu /酔/
よt /四/因/酔/
よs /寄/良/善/止/
よr /寄/因/依/拠/選/撚/縒/
よn /世/
よm /読/詠/
よk /良/善/避/
よj /攀/
よi /良/酔/善/好/佳/
よg /善/
よb /呼/喚/
ゆわかs /湯沸/
ゆるy /緩/
ゆるs /許/赦/
ゆるm /緩/弛/
ゆるk /緩/
ゆるi /緩/
ゆゆs /由々/由由/忌々/
ゆめみr /夢見/
ゆびさs /指差/
ゆびおr /指折/
ゆどおs /湯通/
ゆとうよm /湯桶読/
ゆだn /委/
ゆたk /豊/
ゆずりわたs /譲り渡/
ゆずりうk /譲り受/
ゆずt /譲/
ゆずr /譲/
ゆきわたr /行き渡/
ゆきなやm /行き悩/
ゆきどk /雪解/
ゆきとどk /行き届/
ゆきつk /行き付/
ゆきだおr /行き倒/
ゆきがk /行き掛/
ゆきかよu /行き通/
ゆきかえr /行き帰/
ゆきかu /行き交/
ゆきあu /行き合/
ゆがn /歪/
ゆがm /歪/
ゆえn /故/
ゆうやk /夕焼/
ゆうまぐr /夕間暮/
ゆうびんうk /郵便受/
ゆうばr /夕晴/
ゆうばe /夕映/
ゆうすずm /夕涼/
ゆうきづk /勇気付/
ゆうs /有/
ゆうn /優/
ゆうb /夕/
ゆw /結/
ゆu /結/
ゆs /揺/
ゆr /揺/
ゆk /行/逝/往/
ゆi /結/
ゆd /茹/
やんごとなs /止事無/
やわr /柔/軟/和/
やわi /柔/
やりとr /遣り取/
やりこm /遣り込/
やみつk /病み付/
やみあがr /病み上/
やまわk /山分/
やまもr /山盛/
やまびらk /山開/
やまのぼr /山登/
やまづm /山積/
やまぞi /山沿/
やまそだt /山育/
やまごe /山越/
やまくずr /山崩/
やまあるk /山歩/
やまs /疾/疚/
やぶにらm /藪睨/
やぶさk /吝/
やぶr /破/敗/
やにさg /脂下/
やどなs /宿無/
やどかr /宿借/
やどs /宿/
やどr /宿/
やといいr /雇い入/
やとu /雇/傭/
やとi /雇/
やつざk /八つ裂/
やつs /窶/
やつr /窶/
やっt /八/
やすうけあi /安請合/
やすうr /安売/
やすあがr /安上/
やすs /安/易/
やすr /安/
やすm /休/安/
やすk /易/安/
やすi /安/易/
やじr /野次/
やしなu /養/
やしなi /養/
やさしi /優し/易し/
やさs /易/優/
やけこg /焼け焦/
やぐらなg /櫓投/
やくよk /厄除/
やくまわr /役回/
やくづk /役付/
やくだt /役立/
やくs /訳/約/
やきはらu /焼き払/
やきなまs /焼鈍/
やきなおs /焼き直/焼直/
やきつk /焼き付/
やがt /軈/
やかまs /喧/
やt /八/
やs /痩/
やr /遣/
やm /辞/病/止/罷/已/
やk /焼/
もんなs /文無/
もんぜんばらi /門前払/
もんくなs /文句無/
もろi /脆/
もりつk /盛り付/
もりこm /盛り込/
もりあわs /盛合/
もりあg /盛り上/盛上/
もらw /貰/
もらu /貰/
もらt /貰/
もらi /貰/
もらe /貰/
もよおs /催/
もようがe /模様替/
もよr /最寄/
もみけs /揉み消/
ものわすr /物忘/
ものものs /物々/
ものほs /物干/
ものずk /物好/
ものすごi /物凄/
ものしr /物知/
ものごi /物乞/
ものぐさi /懶/
ものがたr /物語/
ものかk /物書/
ものおもi /物思/
ものおぼe /物覚/
ものおz /物怖/
ものおj /物怖/
ものうi /物憂/
ものいr /物入/
ものいi /物言/
もぬk /蛻/
もどt /戻/
もどs /戻/
もどr /戻/
もどk /擬/
もとどおr /元通/
もとうr /元売/
もとr /戻/悖/
もとm /求/
もてあまs /持て余/
もてあそb /弄/玩/
もつr /縺/
もっぱr /専/
もっとm /最/尤/
もったいなi /勿体無/
もっt /以/
もちよr /持ち寄/
もちはこb /持ち運/
もちなおs /持ち直/
もちだs /持ち出/
もちこたe /持ち堪/
もちこs /持ち越/
もちこm /持ち込/持込/
もちかえr /持ち帰/
もちかk /持ち掛/
もちかe /持ち替/
もちあg /持ち上/
もちi /用/
もだe /悶/
もたらs /齎/
もたr /凭/靠/
もたg /擡/
もじどおr /文字通/
もじr /捩/
もしm /若し/
もしk /若し/
もぐりこm /潜り込/
もぐr /潜/
もくろm /目論/
もくs /黙/目/
もえあg /燃え上/
もうしわk /申し分/
もうしひらk /申し開/
もうしでr /申し出/
もうしつk /申し付/
もうしたt /申し立/申立/
もうしそe /申し添/
もうしこm /申し込/
もうしいr /申し入/
もうしあg /申し上/
もうs /申/
もうk /設/儲/
もy /燃/萌/
もt /持/以/
もs /若/燃/模/
もr /盛/漏/守/洩/
もm /揉/
もe /燃/萌/
めんどうくさi /面倒臭/
めんくらu /面喰/
めんくi /面食/
めんz /免/
めんs /面/
めんj /免/
めりこm /減り込/
めべr /目減/
めばr /目張/
めばe /芽生/
めぬきどおr /目抜き通/
めぬk /目抜/
めとr /娶/
めつk /目付/
めったうt /滅多打/
めったn /滅多/
めだt /目立/
めずらs /珍/
めじろおs /目白押/
めしいr /召し入/
めしあg /召し上/
めざわr /目障/
めざまs /目覚/
めざとi /目敏/
めざs /目指/目刺/
めざm /目覚/目醒/
めぐr /巡/廻/回/
めぐm /恵/
めくるめk /目眩/
めくばr /目配/
めくr /捲/
めきk /目利/
めかくs /目隠/
めうつr /目移/
めいきゅういr /迷宮入/
めいうt /銘打/
めいz /命/銘/
めいr /滅入/
めいj /命/銘/
めあたらs /目新/
めあt /目当/
めあk /目明/
めs /召/
めr /減/
めd /愛/
むりじi /無理強/
むらg /群/叢/簇/
むねやk /胸焼/
むねあg /棟上/
むなさわg /胸騒/
むなs /空/虚/
むとどk /無届/
むつかs /難/
むつm /睦/
むっt /六/
むちうt /鞭打/鞭/
むだづかi /無駄遣/
むせb /咽/噎/
むずかs /難/
むずかr /憤/
むすびつk /結び付/
むすb /結/
むしよk /虫除/
むしぼs /虫干/
むしふうj /虫封/
むしばm /蝕/
むしとr /虫取/
むしくi /虫食/
むしかえs /蒸し返/
むしあつi /蒸し暑/
むしr /寧/毟/
むさぼr /貪/
むごi /酷/惨/
むこu /向こ/
むくu /報/
むくi /報/酬/
むかえいr /迎え入/
むかu /対/
むかi /向か/
むかe /迎/邀/
むt /六/
むs /蒸/咽/噎/
むr /群/蒸/
むk /向/剥/
みわたs /見渡/
みわすr /見忘/
みわk /見分/
みよr /身寄/
みょうn /妙/
みやまいr /宮参/
みやぶr /見破/
みやびy /雅/
みやづかe /宮仕/
みやすs /見易/
みやすi /見易/
みやこおt /都落/
みもだe /身悶/
みもt /身持/
みむk /見向/
みみよr /耳寄/
みみなr /耳馴/耳鳴/
みみざわr /耳障/
みみかk /耳掻/
みみうt /耳打/
みみあたらs /耳新/
みまわs /見回/
みまわr /見回/
みまもr /見守/
みまちがu /見間違/
みまちがi /見間違/
みまちがe /見間違/
みまかr /身罷/
みまu /見舞/
みぶるi /身震/
みぶr /身振/
みひらk /見開/
みばe /見栄/見映/
みはらi /未払/
みはなs /見放/
みはじm /見始/
みはかr /見計/
みはr /見張/見晴/
みのまわr /身の回/
みのがs /見逃/
みのr /実/稔/
みねうt /峰打/
みぬk /見抜/
みにくi /醜/見難/
みならu /見習/
みならi /見習/
みなみむk /南向/
みなごろs /皆殺/
みなぎr /漲/
みなおs /見直/
みなs /見做/看做/
みなr /見慣/見馴/
みなg /身投/
みとどk /見届/
みとがm /見咎/
みとおs /見通/
みとr /見惚/見蕩/
みとm /認/
みてとr /見て取/
みてくr /見て呉/
みづらi /見辛/
みづくろi /身繕/
みつもr /見積/
みつぞろi /三つ揃/
みつけだs /見付け出/
みつくろu /見繕/
みつかr /見付か/
みつk /見付/
みつg /貢/
みっt /三/
みちびk /導/
みちづr /道連/
みちがi /見違/
みだしなm /身嗜/
みだs /乱/見出/
みだr /乱/淫/妄/
みたt /見立/
みそm /見初/
みせびらk /店開/
みせじまi /店仕舞/
みせがまe /店構/
みせかk /見せ掛/
みずわr /水割/
みずもr /水漏/
みずみずs /瑞々/瑞瑞/
みずまs /水増/
みずまk /水撒/
みずぶとr /水太/
みずびたs /水浸/
みずはk /水捌/
みずたまr /水溜/
みずたk /水炊/
みずぜm /水攻/水責/
みずくさi /水臭/
みずきr /水切/
みずがr /水涸/
みずかr /自/
みずあらi /水洗/
みずあそb /水遊/
みずあg /水揚/
みずあb /水浴/
みすt /見捨/
みすk /見透/
みすe /見据/
みじんぎr /微塵切/
みじかm /短/
みじかk /短/
みじかi /短/身近/
みじm /惨/
みしr /見知/
みさだm /見定/
みごろs /見殺/
みごたe /見応/
みごしらe /身拵/
みこs /見越/
みこm /見込/
みぐるs /見苦/
みくだs /見下/
みぎまわr /右回/
みぎきk /右利/
みぎがk /右書/
みきわm /見極/
みきr /見切/
みきk /見聞/
みがわr /身代/
みがまe /身構/
みがたm /身固/
みがk /磨/
みかぎr /見限/
みかえs /見返/
みかえr /見返/
みかk /見掛/
みおぼe /見覚/
みおとs /見落/
みおとr /見劣/
みおくr /見送/
みおt /見落/
みえみe /見え見/
みえっぱr /見栄っ張/
みうしなu /見失/
みうごk /身動/
みうr /身売/
みうk /見受/
みいだs /見出/
みいr /見入/実入/
みあわs /見合/
みあu /見合/
みあk /見飽/
みあi /見合/
みあg /見上/
みy /見/
みt /満/見/三/充/
みs /見/魅/
みr /見/観/視/診/
みn /観/
みe /見/
まわs /回/廻/周/
まわr /周/回/廻/
まるやk /丸焼/
まるもうk /丸儲/
まるめこm /丸め込/
まるみe /丸見/
まるだs /丸出/
まるがかe /丸抱/
まるがr /丸刈/
まるうつs /丸写/
まるあらi /丸洗/
まるm /丸/
まるk /丸/
まるi /丸/円/
まよw /迷/
まよu /迷/
まよk /魔除/
まよi /迷/
まもなk /間も無/
まもt /守/
まもr /守/護/
まみr /塗/
まみe /見/
まほうつかi /魔法使/
まぶs /眩/塗/
まびk /間引/
まばゆi /目映/眩/
まばたk /瞬/
まばr /疎/
まのb /間延/
まねr /真似/
まねk /招/
まぬかr /免/
まぬk /間抜/
まにあu /間に合/
まにあi /間に合/
まなb /学/
まどろm /微睡/
まどかk /窓掛/
まどw /惑/
まどu /惑/
まどr /間取/
まどk /円/
まどi /惑/
まとはずr /的外/
まとw /纏/
まとu /纏/
まとm /纏/
まつかざr /松飾/
まつw /纏/
まつr /祭/奉/祀/
まっぷたt /真っ二/
まっとu /全/
まったいr /真っ平/
まったk /全/
まっすg /真っ直/
まっさかr /真っ盛/
まちぼうk /待ち惚/
まちぶs /待ち伏/
まちはずr /町外/
まちどおs /待ち遠/
まちがu /間違/
まちがt /間違/
まちがi /間違/
まちがe /間違/
まちかまe /待ち構/
まちうk /待ち受/
まちあわs /待合/
まちあk /待ち明/
まだs /未だ/
またたk /瞬/
またぎk /又聞/
またがs /又貸/
またがr /又借/
またh /又/
またg /跨/
まぜがk /交ぜ書/
まずs /貧/
まずi /不味/
まじろg /瞬/
まじなi /呪/
まじw /交/
まじe /交/雑/
ましt /況し/
まさs /正/
まさr /勝/優/
まさn /正/
まごびk /孫引/
まことn /誠/
まぐr /紛/
まくぎr /幕切/
まくあk /幕開/
まくr /捲/
まぎれこm /紛れ込/
まぎr /紛/
まきわr /薪割/
まきもどs /巻き戻/
まきつk /巻き付/
まきぞe /巻き添/
まきこm /巻き込/
まきかえs /巻き返/
まきおこs /巻き起/
まきあg /巻き上/
まがまがs /禍禍/禍々/
まがu /紛/
まがs /間貸/
まがr /曲/間借/
まがi /擬/紛/
まかなu /賄/
まかs /任/委/
まかr /罷/
まえわたs /前渡/
まえもっt /前以/
まえむk /前向/
まえぶr /前触/
まえばらi /前払/
まえだおs /前倒/
まえがs /前貸/
まえがr /前借/
まえかk /前掛/
まえおk /前置/
まえうr /前売/
まうs /申/
まいこm /舞い込/
まいr /参/
まあたらs /真新/
まz /交/混/先/雑/
まu /舞/
まt /待/俟/
まs /増/摩/益/坐/在/
まk /負/巻/蒔/撒/捲/播/
まj /交/混/雑/
まg /曲/
まd /未/
ぽんびk /ぽん引/
ぼっs /没/
ぼうよm /棒読/
ぼうびk /棒引/
ぼうだt /棒立/
ぼうきr /棒切/
ぼうy /坊/
ぼk /呆/惚/暈/
ほんよm /本読/
ほんぶr /本降/
ほろb /滅/亡/
ほれぼr /惚れ惚/
ほれこm /惚れ込/
ほりぬk /掘り抜/
ほりだs /掘り出/
ほりかえs /掘り返/
ほまr /誉/
ほほえm /微笑/頬笑/
ほふr /屠/
ほのぐらi /仄暗/
ほのk /仄/
ほねやすm /骨休/
ほねぬk /骨抜/
ほねなs /骨無/
ほねつg /骨接/
ほねおr /骨折/
ほどとおi /程遠/
ほどこs /施/
ほどk /解/
ほとんd /殆/
ほとばしr /迸/
ほてr /火照/
ほっs /欲/
ほだs /絆/
ほそながi /細長/
ほそs /細/
ほそr /細/
ほそm /細/
ほそi /細/
ほじr /穿/
ほしうらなi /星占/
ほしi /欲し/
ほごあずかr /保護預/
ほころb /綻/
ほこr /誇/
ほぐr /解/
ほがr /朗/
ほおばr /頬張/
ほうりだs /放り出/
ほうりこm /放り込/
ほうむr /葬/
ほうz /焙/報/
ほうr /放/抛/
ほうj /報/焙/
ほs /欲/干/乾/
ほr /彫/掘/惚/恍/耄/
ほm /褒/誉/
ほe /吠/
べんz /弁/
べんj /弁/
べつn /別/
べs /可/
べk /可/
へんn /変/
へりくだr /謙/遜/
へらs /減ら/
へつらu /諂/
へだt /隔/
へこm /凹/
へr /減/経/歴/
ぶんかつばらi /分割払/
ぶどまr /歩留/
ぶつぎr /ぶつ切/
ぶあつi /分厚/部厚/
ぶt /撃/打/撲/
ぶr /振/
ふんばr /踏ん張/
ふんs /扮/
ふわたr /不渡/
ふわk /腑分/
ふれこm /触れ込/
ふるまu /振舞/
ふるくさi /古臭/
ふるw /震/
ふるu /奮/揮/振/篩/震/
ふるt /奮/
ふるs /古/
ふるm /古/
ふるk /古/
ふるi /古/旧/震/故/
ふるe /震/
ふるb /古/
ふりわk /振り分/
ふりむk /振り向/
ふりまわs /振り回/
ふりはらu /振り払/
ふりにg /振り逃/
ふりつk /振り付/振付/
ふりだs /振り出/降り出/
ふりこm /振り込/振込/降り込/
ふりかえr /振り返/
ふりかk /振り掛/
ふりかe /振り替/
ふゆやすm /冬休/
ふゆばr /冬晴/
ふゆきとどk /不行届/
ふゆがr /冬枯/
ふやs /殖や/増や/
ふむk /不向/
ふみたおs /踏み倒/
ふみこm /踏み込/踏込/
ふみきr /踏み切/
ふみいr /踏み入/
ふまe /踏ま/
ふばらi /不払/
ふぬk /腑抜/
ふなよi /船酔/
ふなもr /舟盛/
ふなのr /船乗/
ふなづm /船積/
ふとどk /不届/
ふとs /太/
ふとr /太/
ふとm /太/
ふとi /太/
ふでづかi /筆遣/
ふでたt /筆立/
ふでいr /筆入/
ふてくさr /ふて腐/
ふつかよi /二日酔/
ふっとb /吹っ飛/
ふちどr /縁取/
ふたたb /再/
ふたしk /不確/
ふたt /二/
ふぞろi /不揃/
ふせg /防/拒/
ふしまわs /節回/
ふしづk /節付/
ふさわs /相応/
ふさg /塞/
ふけr /耽/
ふくろばr /袋貼/
ふくろとj /袋綴/
ふくろだたk /袋叩/
ふくs /服/復/覆/
ふくr /膨/脹/
ふくn /含/
ふくm /含/
ふきぬk /吹抜/
ふきとおs /吹き通/
ふきとb /吹き飛/
ふきつk /吹き付/
ふきだまr /吹き溜/
ふきだs /噴き出/吹き出/
ふきさらs /吹き曝/
ふきこm /吹き込/
ふきかe /吹替/
ふきあg /吹き上/
ふがいなi /腑甲斐無/
ふかよm /深読/
ふかなさk /深情/
ふかおi /深追/
ふかいr /深入/
ふかs /深/蒸/
ふかm /深/
ふかk /深/
ふかi /深/
ふえふk /笛吹/
ふうじこm /封じ込/
ふうがわr /風変/
ふうz /封/
ふうs /諷/
ふうj /封/
ふいr /不入/
ふy /増/殖/
ふt /振/降/
ふs /伏/付/臥/附/
ふr /振/触/降/
ふn /踏/
ふm /踏/践/履/
ふk /吹/更/噴/老/拭/深/葺/
ふi /吹/
ふe /増/殖/
びょうよm /秒読/
ひんs /瀕/
ひわたr /火渡/
ひろいだs /拾い出/
ひろu /拾/
ひろs /広/
ひろm /広/
ひろi /広/拾/弘/
ひろg /広/拡/
ひるやすm /昼休/
ひるすg /昼過/
ひるさがr /昼下/
ひるがえt /翻/
ひるがえs /翻/
ひるがえr /翻/
ひるm /怯/
ひらめk /閃/
ひらとj /平綴/
ひらきなおr /開き直/
ひらあやまr /平謝/
ひらt /平/
ひらk /開/
ひらi /開/
ひょうよm /票読/
ひょうしぬk /拍子抜/
ひょうs /表/評/
ひやs /冷/
ひやk /日焼/冷/
ひゃくしょうよm /百姓読/
ひもとk /紐解/繙/
ひまつぶs /暇潰/
ひまs /日増/
ひびわr /罅割/
ひびk /響/
ひのいr /日の入/
ひのb /日延/
ひねr /捻/撚/拈/
ひにくr /皮肉/
ひなあそb /雛遊/
ひどr /日取/
ひどi /酷/
ひとりだt /独り立/
ひとりじm /独り占/
ひとよs /人寄/
ひとやすm /一休/
ひとめぼr /一目惚/
ひとみしr /人見知/
ひとまわr /一回/
ひとまかs /人任/
ひとまt /人待/
ひとひねr /一捻/
ひとばらi /人払/
ひとはたらk /一働/
ひとはしr /一走/
ひとねいr /一寝入/
ひとにぎr /一握/
ひとなつk /人懐/
ひとどおr /人通/
ひととおr /一通/
ひとづかi /人使/
ひとつづk /一続/
ひとちがi /人違/
ひとだすk /人助/
ひとだかr /人集/
ひとたまr /一溜/
ひとずk /人好/
ひとさらi /人攫/
ひとごろs /人殺/
ひとごm /人込/
ひとこいs /人恋/
ひとくi /人喰/
ひとぎらi /人嫌/
ひとぎk /人聞/
ひときr /一切/
ひとかかe /一抱/
ひとかi /人買/
ひとえn /偏/
ひとあr /一荒/
ひとt /一/
ひとs /等/均/斉/
ひとr /独/
ひでr /日照/
ひつk /火付/
ひっぱりこm /引っ張り込/
ひっぱr /引っ張/引張/
ひったくr /引っ手繰/
ひっこs /引越/引っ越/
ひっこm /引っ込/
ひっかかr /引っ掛/
ひっかk /引っ掛/引っ掻/
ひだりよt /左四/
ひだりよr /左寄/
ひだりむk /左向/
ひだりまわr /左回/
ひだりまk /左巻/
ひだりきk /左利/
ひだまr /日溜/
ひだt /肥立/
ひたはしr /直走/
ひたかくs /直隠/
ひたs /浸/漬/
ひたr /浸/
ひそm /潜/顰/
ひそk /密/
ひぜm /火攻/火責/
ひずm /歪/
ひじょうn /非常/
ひじかk /肘掛/
ひしゃg /拉/
ひしめk /犇/
ひざまずk /跪/
ひざかk /膝掛/
ひざs /日差/
ひさしぶr /久し振/
ひさかたぶr /久方振/
ひさs /久/尚/
ひさg /販/鬻/拉/
ひけs /火消/
ひくs /低/
ひくm /低/
ひくk /低/
ひくi /低/
ひきわたs /引き渡/引渡/
ひきわk /引き分/
ひきもどs /引き戻/
ひきまわs /引き回/
ひきぬk /引き抜/
ひきにg /轢き逃/
ひきとおs /引き通/
ひきとr /引き取/引取/
ひきとm /引き止/
ひきつづk /引き続/
ひきつr /引き攣/引き連/
ひきつk /引き付/
ひきつg /引き継/引継/
ひきだs /引出/引き出/
ひきたt /引き立/引立/
ひきずりこm /引き摺り込/
ひきずr /引き摺/
ひきしめr /引き締め/
ひきしm /引締/
ひきさr /引き去/
ひきさk /引き裂/
ひきさg /引き下/引下/
ひきこm /引き込/
ひきがたr /弾き語/
ひきかえs /引き返/
ひきかe /引き替/
ひきおとs /引き落/
ひきうk /引き受/引受/
ひきあt /引き当/
ひきあi /引合/
ひきあg /引き上/引き揚/
ひきi /率/
ひがしむk /東向/
ひがえr /日帰/
ひがm /僻/
ひがk /日掛/
ひかr /光/
ひかe /控/
ひえこm /冷え込/
ひいr /火入/
ひいd /秀/
ひあそb /火遊/
ひあg /干上/乾上/
ひy /冷/
ひs /比/秘/
ひr /干/
ひm /秘/
ひk /引/弾/挽/曳/牽/退/碾/轢/
ひe /冷/
ばっs /罰/
ばちがi /場違/
ばかs /魅/
ばかr /許/
ばr /張/
ばk /化/
はんびらk /半開/
はんだづk /半田付/
はんだずk /半田付/
はんごろs /半殺/
はんs /反/
はんj /判/
はわたr /刃渡/
はれわたr /晴れ渡/
はればr /晴れ晴/
はるやすm /春休/
はるk /遥/
はりめぐr /張り巡/
はりつけr /貼り付け/
はりつk /貼り付/張り付/
はりだs /張り出/
はりこm /張り込/
はりきr /張り切/
はりかe /張り替/
はりあu /張り合/
はりあi /張合/
はらばi /腹這/
はらちがi /腹違/
はらだt /腹立/
はらごしらe /腹拵/
はらぐろi /腹黒/
はらきr /腹切/
はらがまe /腹構/
はらいわたs /払い渡/
はらいもどs /払戻/
はらいだs /払出/
はらいこm /払込/払い込/
はらw /払/
はらu /払/掃/
はらt /払/
はらo /払/
はらm /孕/
はらi /払/祓/
はらe /払/
はゆs /映/
はやだs /早出/
はやざk /早咲/
はやぐi /早食/
はやがわr /早変/
はやがえr /早帰/
はやおk /早起/
はやうt /早打/
はやいものがt /早い者勝/
はやs /速/早/囃/
はやr /流行/逸/早/
はやm /早/速/
はやk /早/速/
はやi /速/早/疾/捷/
はめこm /嵌め込/
はみがk /歯磨/
はまr /填/嵌/
はべr /侍/
はぶr /羽振/
はぶk /省/羽振/
はびこr /蔓延/
はばひろi /幅広/
はばかr /憚/
はばm /阻/難/
はねのk /撥ね除/
はねあg /跳ね上/
はなればなr /離れ離/
はならb /歯並/
はなびe /花冷/
はなばなs /華々/花々/華華/
はなはd /甚/
はなしずk /話好/
はなしこm /話し込/
はなしがi /放し飼/
はなしあu /話し合/
はなしあi /話し合/
はなざかr /花盛/
はなぐもr /花曇/
はなうr /花売/
はなy /華/花/
はなt /放/
はなs /離/放/話/
はなr /離/放/
はどm /歯止/
はてs /果て/
はつのr /初乗/
はつうr /初売/
はっs /発/
はっp /葉っ/
はちうe /鉢植/
はだざわr /肌触/
はださむi /肌寒/
はだかk /肌掛/
はだあi /肌合/
はだk /開/
はたらk /働/
はたふr /旗振/
はたたk /羽撃/
はたけちがi /畑違/
はたきこm /叩き込/
はたあg /旗揚/
はたs /果/
はたk /叩/
はずかしm /辱/
はずかs /恥ずか/
はずs /外/
はずr /外/
はずm /弾/勢/
はすむかi /斜向/
はじm /始/初/創/
はじk /弾/
はしわたs /橋渡/
はしりぬk /走り抜/
はしりこm /走り込/
はしりがk /走り書/
はしょr /端折/
はしぞm /箸初/
はしおr /端折/
はしおk /箸置/
はしr /走/奔/
はざわr /歯触/
はさみこm /挟み込/
はさみうt /挟み撃/
はさm /挟/
はごたe /歯応/
はこびこm /運び込/
はこいr /箱入/
はこb /運/
はげまs /励ま/
はげs /激/烈/劇/
はげm /励/
はぐくm /育/
はぐr /逸/
はくおs /箔押/
はくs /博/
はぎしr /歯軋/
はぎr /歯切/端切/
はきちがe /履き違/
はきだs /掃き出/吐き出/
はきさしもどs /破棄差戻/
はがゆi /歯痒/
はかりうr /量り売/
はかまいr /墓参/
はかばかs /捗々/
はかなm /果無/
はかなi /儚/果敢無/果無/
はかどr /捗/
はかr /図/計/測/量/諮/謀/
はおr /羽織/
はえぬk /生え抜/
はいりこm /入り込/
はいよr /這い寄/
はいつくばr /這い蹲/
はいs /排/廃/拝/配/
はいr /入/這入/
はz /恥/爆/羞/
はy /生/映/
はu /這/
はt /果/貼/
はs /馳/
はr /張/晴/腫/脹/貼/
はn /跳/撥/
はm /食/嵌/
はk /掃/吐/履/刷/捌/穿/着/佩/
はj /恥/羞/
はg /剥/禿/
はe /生/栄/映/
のろけr /惚気/
のろu /呪/詛/
のろi /呪/鈍/
のりづk /糊付/
のりつg /乗り継/
のりだs /乗り出/
のりこm /乗り込/
のりこe /乗り越/
のりきr /乗り切/
のりかe /乗り換/乗換/
のりおくr /乗り遅/
のりいr /乗り入/
のやk /野焼/
のみほs /飲み干/
のみすg /飲み過/
のみこm /飲込/飲み込/呑み込/
のぼs /上/
のぼr /登/上/昇/
のばなs /野放/
ののしr /罵/
のづm /野積/
のっとr /乗っ取/則/
のちぞe /後添/
のたれじn /野垂れ死/
のぞきこm /覗き込/
のぞm /望/臨/
のぞk /除/覗/覘/臨/
のざらs /野晒/
のこs /残/遺/
のこr /残/
のがs /逃/
のがr /逃/遁/
のうなs /能無/
のt /載/
のs /載/乗/伸/
のr /乗/載/伸/
のm /飲/呑/
のk /退/除/
のb /述/延/伸/陳/
ねんばらi /年払/
ねんごr /懇/
ねんいr /念入/
ねんz /念/
ねんj /念/
ねりあるk /練り歩/
ねらいうt /狙い撃/
ねらu /狙/
ねらt /狙/
ねらi /狙/
ねむりこm /眠り込/
ねむt /眠/
ねむs /眠/
ねむr /眠/睡/
ねむi /眠/
ねまわs /根回/
ねぼk /寝惚/
ねぶかi /根深/
ねぶr /舐/
ねぶm /値踏/
ねびk /値引/
ねびe /寝冷/
ねばりづよi /粘り強/
ねばr /粘/
ねなs /根無/
ねづよi /根強/
ねづk /根付/
ねつk /寝付/
ねっs /熱/
ねっk /根っ/
ねちがe /寝違/
ねだm /寝溜/
ねたm /妬/
ねずみとr /鼠取/
ねすごs /寝過/
ねじr /捻/捩/
ねじk /拗/
ねざs /根差/
ねざm /寝覚/
ねさg /値下/
ねころg /寝転/
ねころb /寝転/
ねこm /寝込/
ねぐるs /寝苦/
ねくずr /値崩/
ねぎらu /犒/
ねぎらi /犒/
ねぎr /値切/
ねがえr /寝返/
ねがいさg /願い下/
ねがu /願/
ねがi /願/
ねおk /寝起/
ねうごk /値動/
ねいr /寝入/
ねあらi /値洗/
ねあがr /値上/根上/
ねあk /寝明/
ねあg /値上/
ねz /捻/捩/
ねs /寝/
ねr /寝/練/錬/粘/煉/
ねm /睨/
ねk /寝/
ねj /捻/捩/
ぬるm /微温/
ぬるi /微温/
ぬりつぶs /塗り潰/
ぬりこm /塗り込/
ぬめr /滑/
ぬのきr /布切/
ぬすみぐi /盗み食/
ぬすみぎk /盗み聞/
ぬすm /盗/
ぬけだs /抜け出/
ぬけがk /抜け駆/
ぬぐu /拭/
ぬぐi /拭/
ぬくm /温/
ぬくi /温/
ぬぎすt /脱ぎ捨/
ぬきとおs /貫き通/
ぬきだs /抜き出/
ぬきさs /抜き差/
ぬかばたらk /糠働/
ぬかr /泥濘/
ぬu /縫/
ぬt /塗/
ぬr /塗/濡/
ぬk /抜/脱/
ぬi /縫/抜/
ぬg /脱/
にんげんばなr /人間離/
にんげんぎらi /人間嫌/
にらみつk /睨み付/
にらみあi /睨み合/
にらm /睨/
にまいげr /二枚蹴/
にぼs /煮干/
にほんざs /二本差/
にぶs /鈍/
にぶr /鈍/
にぶi /鈍/
にばんせんj /二番煎/
にぬk /煮抜/
になu /担/
になi /担/
にづくr /荷造/
につm /煮詰/
にちょうなg /二丁投/
にだs /煮出/
にたt /煮立/
にたk /煮炊/
にじゅううつs /二重写/
にじr /躙/
にじm /滲/
にしむk /西向/
にごs /濁/
にごr /濁/
にこy /柔/和/
にこm /煮込/
にげまわr /逃げ回/
にげまどu /逃げ惑/
にげだs /逃げ出/
にげこm /逃げ込/
にげきr /逃げ切/
にげかくr /逃げ隠/
にげかえr /逃げ帰/
にげおくr /逃げ遅/
にくばなr /肉離/
にくにくs /憎々/
にくづk /肉付/
にくずr /荷崩/
にくs /憎/難/
にくr /憎/
にくm /憎/
にくi /憎/難/
にぎy /賑/
にぎw /賑/
にぎr /握/
にがわらi /苦笑/
にがにがs /苦々/
にがs /苦/
にがr /苦/
にがm /苦/
にがi /苦/
にかよu /似通/
におうだt /仁王立/
におw /匂/
におu /匂/臭/
におi /匂/
におe /匂/
にあw /似合/
にあu /似合/
にあt /似合/
にあi /似合/
にあg /荷揚/
にy /煮/
にs /似/
にr /似/煮/
にg /逃/
にe /煮/
なんなk /難無/
なんt /何/
なんr /何/
なんn /何/
なんk /何/
なんd /何/
なれあu /馴れ合/
なるべk /成る可/
なりゆk /成り行/成行/
なりふr /形振/
なりたt /成り立/成立/
ならw /習/
ならu /習/倣/
ならs /均/
ならi /習/倣/
ならb /並/
なよs /名寄/
なやn /悩/
なやm /悩/
なめs /鞣/
なめr /滑/
なみはずr /並外/
なみのr /波乗/
なみうt /波打/
なまやさs /生易/
なまやk /生焼/
なまめk /艶/
なまぬるi /生温/
なまにe /生煮/
なまなまs /生生/生々/
なまじろi /生白/
なまごろs /生殺/
なまぐさi /生臭/
なまがわk /生乾/
なまえまk /名前負/
なまr /鈍/訛/
なまk /怠/懶/
なべt /並べ/
なぶr /嬲/
なびk /靡/
なのr /名乗/名告/
なにひとt /何一/
なにはさておk /何は扨措/
なにげなi /何気無/
なにかt /何彼/
なにm /何/
なにk /何/
なにg /何/
ななまがr /七曲/
ななころびやおk /七転び八起/
ななt /七/
ななs /名無/
ななm /斜/
なづk /名付/
なつやすm /夏休/
なつむk /夏向/
なつk /懐/
なだかi /名高/
なだt /名立/
なだr /傾/雪崩/
なだm /宥/
なぞらe /擬/准/準/
なぞとk /謎解/
なずm /泥/
なすr /擦/
なじr /詰/
なじm /馴染/
なしくずs /済し崩/
なざs /名指/
なさけなi /情け無/
なさk /情/
なごy /和/
なごm /和/
なげやr /投げ遣/
なげづr /投げ釣/
なげつk /投げ付/
なげだs /投げ出/
なげこm /投げ込/
なげうt /抛/擲/
なげいr /投げ入/
なげk /嘆/歎/
なけr /泣け/
なぐりこm /殴り込/
なぐさm /慰/
なぐr /殴/擲/
なくなk /泣く泣/
なきわかr /泣き別/
なきねいr /泣き寝入/
なきだs /泣き出/
なきあk /泣き明/
ながれこm /流れ込/
ながれあるk /流れ歩/
ながびk /長引/
ながつづk /長続/
ながしこm /流し込/
ながいk /長生/
ながs /流/長/
ながr /流/永/乍/
ながm /眺/長/
ながk /長/
ながi /長/永/
なかよs /仲良/
なかまわr /仲間割/
なかまはずr /仲間外/
なかまいr /仲間入/
なかぬk /中抜/
なかづr /中吊/
なかだるm /中弛/
なかたがi /仲違/
なかじm /中締/
なかおt /中落/
なかr /勿/
なかn /中/
なかb /半/
なおs /直/治/
なおr /直/治/
なうt /名う/
ないまz /綯い交/
ないがしr /蔑/
なu /綯/
なs /無/成/為/生/
なr /慣/鳴/馴/成/生/為/熟/
なm /並/嘗/舐/
なk /無/鳴/泣/亡/啼/
なi /無/亡/
なg /凪/投/薙/無/
なe /萎/
どわすr /度忘/
どろよk /泥除/
どろくさi /泥臭/
どもr /吃/土盛/
どなりこm /怒鳴り込/
どなr /怒鳴/
どしゃぶr /土砂降/
どくづk /毒突/
どくけs /毒消/
どくs /毒/
どうまわr /胴回/
どうじょうやぶr /道場破/
どうじn /同時/
どうじm /胴締/
どうぐだt /道具立/
どうきづk /動機付/
どうあg /胴上/
どうz /動/
どうj /動/
どs /度/
とんぼがえr /蜻蛉返/
とんがr /尖/
とろk /蕩/盪/
とりわk /取り分/
とりよs /取り寄/鳥寄/
とりやm /取り止/
とりもどs /取り戻/
とりむすb /取り結/
とりみだs /取り乱/
とりまわs /取り回/
とりまとm /取り纏/
とりまk /取り巻/
とりはらu /取り払/
とりはずs /取り外/
とりはこb /取り運/
とりはかr /取り計/
とりのぞk /取り除/
とりのこs /取り残/
とりなおs /取り直/
とりなs /取り成/執り成/
とりつくろu /取り繕/
とりつくs /取り尽/
とりつk /取り付/取付/
とりつg /取り次/
とりちがe /取り違/
とりちr /取り散/
とりだs /取り出/
とりたt /取り立/
とりそろe /取り揃/
とりそこn /取り損/
とりしらb /取調/取り調/
とりしまr /取り締ま/取締/
とりしきr /取り仕切/
とりしm /取り締/
とりさばk /取り捌/
とりさr /取り去/
とりさg /取り下/
とりこわs /取り壊/
とりこぼs /取り零/
とりこs /取り越/
とりこm /取り込/
とりけs /取り消/取消/
とりくずs /取り崩/
とりくm /取り組/
とりきm /取り決/取り極/
とりかわs /取り交/
とりかたm /取り固/
とりかこm /取り囲/
とりかえs /取り返/
とりかk /取り掛/
とりかe /取り替/
とりおさe /取り抑/
とりおこなu /執り行/
とりおk /取り置/
とりいそg /取り急/
とりいr /取り入/取入/
とりあらそu /取り争/
とりあつかu /取り扱/
とりあつかi /取扱/
とりあつm /取り集/
とりあu /取り合/
とりあg /取り上/
とらがr /虎刈/
とらw /捕/囚/
とらe /捉/捕/
ともばたらk /共働/
ともなw /伴/
ともなu /伴/
ともなt /伴/
ともなi /伴/
ともだおr /共倒/
ともぐi /共食/
ともかせg /共稼/
ともえなg /巴投/
ともs /灯/点/
ともr /灯/点/
ともn /共/
とむらu /弔/訪/
とみn /頓/
とまどu /戸惑/
とまどi /戸惑/
とまr /泊/止/留/
とぼs /乏/点/
とぼk /惚/恍/
とびまわr /飛び回/
とびのr /飛び乗/
とびのk /飛び退/
とびでr /飛び出/
とびちr /飛び散/
とびだs /飛び出/
とびたt /飛び立/
とびこs /飛び越/
とびこm /飛び込/
とびこe /飛び越/
とびかu /飛び交/
とびおk /飛び起/
とびいr /飛び入/
となr /隣/
となe /唱/称/
とどろk /轟/
とどこおr /滞/
とどけでr /届け出/
とどm /留/止/停/
とどk /届/
ととのu /整/調/
ととのe /整/調/
とてm /迚/
とつg /嫁/
とってかえs /取って返/
とっておk /取って置/
とっk /疾っ/
とだe /途絶/
とじまr /戸締/
とじこm /閉じ込/綴じ込/
としよr /年寄/
としこs /年越/
としおi /年老/
とざs /鎖/
とこずr /床擦/
とげとげs /刺刺/
とけこm /溶け込/
とくべつあつかi /特別扱/
とくn /特/
とぎれr /途切れ/
とぎr /途切/
ときはなt /解き放/
ときあk /説き明/解き明/
ときn /時/
とがr /尖/
とがm /咎/
とおりぬk /通り抜/
とおりこs /通り越/
とおまわs /遠回/
とおまわr /遠回/
とおまk /遠巻/
とおぼe /遠吠/
とおのr /遠乗/
とおのk /遠退/
とおs /通/遠/徹/
とおr /通/
とおk /遠/
とおi /遠/
とうとu /疾う疾/
とうとs /尊/
とうとi /尊/貴/
とうとb /尊/貴/
とうz /投/
とうn /当/
とうj /投/
といあわs /問合/問い合わ/
といあw /問い合/
とz /閉/綴/
とu /問/疾/
とt /撮/
とr /取/撮/捕/執/採/
とm /止/富/留/泊/停/
とk /解/溶/説/疾/融/熔/鎔/
とj /閉/綴/
とi /問/
とg /研/遂/磨/
とb /飛/跳/
でもどr /出戻/
でむかe /出迎/
でむk /出向/
でまわr /出回/
でまかs /出任/
ではじm /出始/
ではいr /出入/
でなおs /出直/
でづっぱr /出突っ張/
でっぱr /出っ張/
でだs /出出/
でたt /出立/
でぞm /出初/
でそろu /出揃/
ですg /出過/
でしいr /弟子入/
できばe /出来映/
できあg /出来上/
できt /出来/
できs /出来/
できr /出来/
できn /出来/
できm /出来/
でかせg /出稼/
でかk /出掛/
でおくr /出遅/
でいr /出入/
であるk /出歩/
であu /出会/出合/
であi /出会/
でt /出/
でr /出/
てんびk /天引/
てんばいかいもどs /転売買戻/
てんとr /点取/
てんこもr /天こ盛/
てんz /転/
てんj /転/
てわたs /手渡/
てわk /手分/
てりこm /照り込/
てりかえs /照り返/
てらu /衒/
てまわs /手回/
てまどr /手間取/
てほどk /手解/
てぶr /手振/手ぶ/
てびかe /手控/
てばやi /手早/
てばなs /手放/
てはじm /手始/
てぬk /手抜/
てならi /手習/
てなおs /手直/
てどr /手取/
てとr /手取/
てづまr /手詰/
てづくr /手作/
てづかm /手掴/
てづm /手詰/
てつづk /手続/
てつだu /手伝/
てつだt /手伝/
てつだi /手伝/
てつだe /手伝/
てっとりばやi /手っ取り早/
てっs /徹/
てちがi /手違/
てだすk /手助/
てだt /手立/
てだs /手出/
てじm /手締/
てざわr /手触/
てざs /手差/
てさばk /手捌/
てさぐr /手探/
てさg /手提/
てごわi /手強/
てこずr /梃摺/
てこいr /梃入/
てくばr /手配/
てぎr /手切/
てきびs /手厳/
てきs /適/
てがたi /手堅/
てがかr /手掛/
てがk /手書/手掛/手懸/
ておくr /手遅/
ておt /手落/
ておs /手押/
ておi /手負/
ていたi /手痛/
ていs /呈/挺/訂/
ていr /手入/
てあらi /手洗/
てあぶr /手焙/
てあつi /手厚/
てあm /手編/
てr /照/
づらi /辛/
づたi /伝/
づr /連/
づm /詰/
づk /付/
つんざk /劈/
つれだt /連れ立/
つれだs /連れ出/
つれこm /連れ込/
つるs /吊/
つるm /連/
つりこm /釣り込/
つりあu /釣り合/
つりあg /釣上/釣り上/吊り上/
つらよごs /面汚/
つらぬk /貫/
つらがまe /面構/
つらあt /面当/
つらs /辛/
つらn /連/列/
つらi /辛/
つよs /強/
つよm /強/
つよk /強/
つよi /強/
つよg /強/
つゆはらi /露払/
つやy /艶/
つもr /積/
つめよr /詰め寄/
つめこm /詰め込/
つめかe /詰め替/
つめあわs /詰合/
つめt /冷/
つむg /紡/
つみぶかi /罪深/
つみたt /積立/
つみこm /積み込/
つみかさn /積み重/
つまみぐi /撮み食/
つまびk /爪弾/
つまはじk /爪弾/
つまどr /褄取/
つまs /約/
つまr /詰/
つまm /撮/摘/抓/
つぼm /窄/蕾/
つぶよr /粒選/
つぶやk /呟/
つぶぞろi /粒揃/
つぶs /潰/
つぶr /潰/瞑/
つばめがえs /燕返/
つのr /募/
つねr /抓/
つねn /常/
つなわたr /綱渡/
つなひk /綱引/
つなg /繋/
つどu /集/
つどi /集/
つとn /夙/
つとm /勤/努/務/勉/
つづr /綴/
つづm /約/
つづk /続/
つつみこm /包み込/
つつぬk /筒抜/
つつしm /謹/慎/
つつm /包/
つつk /突/
つっぷs /突っ伏/
つっぱしr /突っ走/
つっぱr /突っ張/
つっつk /突っ突/
つったt /突っ立/
つっこm /突っ込/
つっきr /突っ切/
つっかk /突っ掛/
つっかe /支/閊/
つちかu /培/
つたなi /拙/
つたw /伝/
つたu /伝/
つたe /伝/
つずr /綴/
つこうまつr /仕/
つけたs /付け足/
つけこm /付け込/漬け込/
つけくわe /付け加/
つけかe /付け替/
つけいr /付け入/
つけあg /付け上/
つぐなu /償/
つぐなi /償/
つぐm /噤/
つくろu /繕/
つくりなおs /作り直/
つくりだs /作り出/
つくs /尽/
つくr /作/造/
つくn /捏/
つぎn /次/
つきまとu /付き纏/
つきばらi /月払/
つきはなs /突き放/
つきはじm /月初/
つきぬk /突き抜/
つきとおs /突き通/
つきとm /突き止/
つきつk /突き付/
つきだs /突き出/
つきたt /突き立/
つきそu /付き添/
つきそi /付添/
つきすすm /突き進/
つきさs /突き刺/
つきくずs /突き崩/
つきぎr /月切/
つきぎm /月極/
つきがk /月掛/
つきおとs /突き落/
つきおくr /月遅/
つきあu /付き合/
つきあt /突き当/
つきあg /突き上/
つがu /番/
つかまつr /仕/
つかさどr /司/掌/
つかいわk /使い分/
つかいばしr /使い走/
つかいはt /使い果/
つかいすt /使い捨/
つかいこm /使い込/
つかw /使/遣/
つかu /使/遣/
つかr /疲/
つかn /束/
つかm /捕/掴/捉/攫/
つかi /使/遣/
つかe /仕/支/閊/
つうz /通/
つうj /通/
ついやs /費や/
ついy /費/
ついn /遂/
ついe /費/潰/
ついd /序/
つt /突/
つr /釣/連/吊/
つm /詰/摘/積/
つk /付/着/突/漬/就/尽/吐/衝/附/築/撞/搗/
つi /突/
つg /継/次/接/告/
ちんさg /賃下/
ちんがs /賃貸/
ちんがr /賃借/
ちんあg /賃上/
ちりばm /鏤/
ちりぢr /散り散/
ちょうむすb /蝶結/
ちょうけs /帳消/
ちょうz /長/
ちゅうづr /宙吊/
ちゅうがえr /宙返/
ちゅうs /沖/注/註/冲/
ちゃのm /茶飲/
ちゃくばらi /着払/
ちゃくm /茶汲/
ちゃうk /茶請/
ちまよu /血迷/
ちばしr /血走/
ちぬr /血塗/
ちなm /因/
ちっt /些/
ちぢみこm /縮み込/
ちぢみあg /縮み上/
ちぢr /縮/
ちぢm /縮/
ちぢk /縮/
ちちばなr /乳離/
ちぞm /血染/
ちじm /縮/
ちぎr /契/
ちがw /違/
ちがu /違/交/
ちがt /違/
ちがi /違/
ちがe /違/
ちからまかs /力任/
ちからづよi /力強/
ちからぞe /力添/
ちかよr /近寄/
ちかづk /近付/
ちかu /誓/盟/
ちかt /誓/
ちかs /近/親/
ちかk /近/
ちかi /近/誓/
ちいさn /小さ/
ちいs /小/
ちr /散/
ちb /禿/
だんどr /段取/
だんちがi /段違/
だんz /断/
だんj /断/
だるi /怠/
だめおs /駄目押/
だまりこm /黙り込/
だましうt /騙し討/
だまt /黙/
だまs /騙/
だまr /黙/
だっs /脱/
だっk /抱っ/
だしぬk /出し抜/
だしいr /出し入/
だしあu /出し合/
だきこm /抱き込/
だいなs /台無/
だいすk /大好/
だいきらi /大嫌/
だいs /題/
だt /立/建/
だs /出/堕/
だk /抱/
たんn /単/
たわむr /戯/
たわm /撓/
たわk /戯/
たれながs /垂れ流/
たれこm /垂れ込/
たるm /弛/
たらいまわs /盥回/
たらz /足ら/
たらs /誑/
たよt /頼/
たよr /頼/便/
たゆたu /揺蕩/
たゆm /弛/
たやすi /容易/
たもt /保/
ためらu /躊躇/
ためs /試/
ためn /為/
たむろs /屯/
たむk /手向/
たまわr /賜/
たまよk /弾除/
たまつk /玉突/
たまげr /魂消/
たまぎr /魂消/
たまいr /玉入/
たまr /溜/
たまn /偶/
たべかk /食べ掛/
たべr /食べ/
たぶらk /誑/
たびなr /旅慣/
たびだt /旅立/
たびかさn /度重/
たばなs /手放/
たばかr /謀/
たばn /束/
たのみこm /頼み込/
たのs /楽/
たのn /頼/
たのm /頼/恃/
たねぎr /種切/
たねあかs /種明/
たなざらs /店晒/
たなおろs /棚卸/
たなあg /棚上/
たどりつk /辿り着/
たどr /辿/
たとe /喩/譬/例/
たてまつr /奉/
たてまs /建増/
たてなおs /立て直/
たてとおs /立て通/
たてつづk /立て続/
たてつk /楯突/
たてがk /縦書/
たてかk /立て掛/
たてかe /立て替/建て替/
たづくr /田作/
たっとi /貴/尊/
たっとb /尊/貴/
たっs /達/
たちよr /立ち寄/
たちよm /立読/
たちむk /立ち向/
たちまわr /立ち回/
たちまt /忽/
たちふさg /立ち塞/
たちはたらk /立ち働/
たちのk /立ち退/
たちなおr /立ち直/
たちとおs /立ち通/
たちさr /立ち去/
たちこm /立ち籠/
たちきr /断ち切/
たちうt /太刀打/
たちいr /立ち入/立入/
たちあu /立ち会/立ち合/
たちあg /立ち上/
ただよw /漂/
ただよu /漂/
ただt /直/
ただs /正/但/質/糺/
ただr /爛/
たたみこm /畳み込/
たたずm /佇/
たたきだs /叩き出/
たたきこm /叩き込/
たたきあg /叩き上/
たたかw /戦/闘/
たたかu /戦/闘/
たたかi /戦/闘/
たたr /祟/
たたm /畳/
たたk /叩/敲/
たたe /称/湛/
たそがr /黄昏/
たずさw /携/
たずさe /携/
たずn /尋/訊/訪/
たすきぞr /襷反/
たすきがk /襷掛/
たすk /助/扶/
たしなm /嗜/窘/
たしk /確/慥/
たけs /猛/
たけr /猛/哮/
たぐr /手繰/
たくわe /蓄/貯/
たくらm /企/
たくまs /逞/
たくs /託/
たくm /巧/
たぎr /滾/
たきこm /炊き込/
たがやs /耕/
たがいちがi /互い違/
たがu /違/
たがi /互/違/
たがe /違/
たからさがs /宝探/
たかぶr /昂/
たかのぞm /高望/
たかなr /高鳴/
たかs /高/
たかr /集/
たかm /高/
たかk /高/
たかi /高/
たおy /嫋/
たおs /倒/
たおr /倒/斃/手折/
たえだe /絶え絶/
たえがたi /耐え難/
たえz /絶え/
たいげんどm /体言止/
たいあたr /体当/
たいs /対/
たいr /平/
たy /絶/
たt /立/建/断/裁/絶/経/起/発/
たs /足/
たr /垂/足/
たm /溜/矯/
たk /炊/焚/長/闌/
たe /耐/絶/堪/
たb /食/
ぞんz /存/
ぞんj /存/
ぞくs /属/
ぞくn /俗/
ぞm /初/
そんz /損/
そんs /存/
そんj /損/
そろu /揃/
そろt /揃/
そろi /揃/
そろe /揃/
それとなk /其と無/
そらんz /諳/
そらんj /諳/
そめぬk /染め抜/
そめだs /染め出/
そめこm /染め込/
そむk /背/叛/
そぼt /濡/
そぶr /素振/
そびe /聳/
そばだt /峙/
そねm /嫉/妬/猜/
そなえつk /備え付/
そなw /備/
そなe /供/備/具/
そとむk /外向/
そとまわr /外回/
そとがk /外掛/
そでぐr /袖刳/
そだt /育/
そそのかs /唆/嗾/
そそぎこm /注ぎ込/
そそg /注/灌/
そしr /謗/誹/
そこびe /底冷/
そこぬk /底抜/
そこなu /害/
そこいr /底入/
そこあg /底上/
そこn /損/
そくs /則/即/
そうなm /総嘗/
そうだt /総立/
そうぞうs /騒々/
そうそu /然う然/
そうけだt /総毛立/
そうくずr /総崩/
そうs /奏/
そw /添/
そu /沿/添/副/
そt /沿/添/
そr /反/剃/逸/
そn /其/
そm /初/染/
そi /沿/
そg /削/殺/
そe /添/副/
ぜんだt /膳立/
ぜっs /絶/
せんまいどおs /千枚通/
せんびk /線引/
せんぬk /栓抜/
せんにんぎr /千人斬/
せんなi /詮無/
せんたくばさm /洗濯挟/
せんぞがえr /先祖返/
せんかたなi /詮方無/
せんz /煎/先/
せんs /僭/
せんj /煎/
せわずk /世話好/
せわs /忙/
せもたr /背凭/
せめたt /攻め立/責め立/
せめこm /攻め込/
せめg /鬩/
せまくるs /狭苦/
せまs /狭/
せまr /迫/逼/
せまi /狭/
せぶm /瀬踏/
せばm /狭/
せのb /背伸/
せつn /切/
せつk /責付/
せっつk /責付/
せっs /接/
せちがらi /世知辛/
せせらわらu /嘲笑/
せけんずr /世間擦/
せきばらi /咳払/
せきたt /急き立/
せおu /背負/
せいぞろi /勢揃/
せいs /制/征/
せr /競/迫/糶/
せm /攻/責/
せk /急/堰/塞/
ずるi /狡/
ずぶぬr /ずぶ濡/
ずぶとi /図太/
ずどr /図取/
ずつk /頭突/
ずうずうs /図々/
ずk /付/
すわりこm /座り込/
すわr /座/坐/
すれちがu /擦れ違/
するどi /鋭/
すりよr /擦り寄/摩り寄/
すりむk /擦り剥/
すりへr /磨り減/
すりぬk /擦り抜/
すりつぶs /磨り潰/
すりこm /摺り込/摩り込/刷り込/
すりきr /摺り切/摩り切/
すりかe /摩り替/
すもぐr /素潜/
すみやk /炭焼/
すみこm /住み込/
すみy /速/
すまu /住ま/
すまi /住ま/
すぼm /窄/
すべりこm /滑り込/
すべからk /須/
すべt /全/総/滑/
すべr /滑/辷/
すぶr /素振/
すばらs /素晴/
すばやi /素早/
すばなr /巣離/
すばr /素晴/
すなわt /即/則/
すなどr /漁/
すどまr /素泊/
すどおs /素通/
すどおr /素通/
すでn /既/
すてさr /捨て去/
すてr /捨て/
すだt /巣立/
すたr /廃/頽/
すそわk /裾分/
すそとr /裾取/
すずなr /鈴生/
すずs /涼/
すずm /涼/
すすりなk /啜り泣/
すすr /啜/
すすm /進/勧/薦/
すすk /煤/
すすg /漱/濯/
すじちがi /筋違/
すじがねいr /筋金入/
すじr /捩/
すさm /荒/進/遊/
すさb /荒/進/遊/
すごs /凄/
すごm /凄/
すごk /凄/
すごi /凄/
すこぶr /頗/
すこy /健/
すこs /少/
すぐr /優/勝/選/
すくなi /少な/寡/
すくいなg /掬い投/
すくいだs /救い出/
すくu /救/掬/抄/済/巣く/
すくn /少/
すくm /竦/
すくi /救/掬/
すきとおr /透き通/
すきずk /好き好/
すきこm /漉き込/
すききらi /好き嫌/
すがすがs /清々/
すがr /縋/
すかs /賺/
すえながk /末長/
すえおk /据置/据え置/
すいとr /吸い取/
すいだs /吸い出/吸出/
すいこm /吸い込/
すw /据/
すu /吸/
すt /捨/棄/
すr /擦/摺/刷/擂/為/剃/摩/磨/掏/
すm /済/住/澄/棲/栖/清/
すk /好/透/梳/空/漉/鋤/抄/剥/
すi /酸/
すg /過/直/
すe /据/饐/
すb /統/総/
じんどr /陣取/
じんとr /陣取/
じわr /地割/
じょうやとi /常雇/
じょうさs /状差/
じょうけんづk /条件付/
じょうz /乗/
じょうj /乗/
じゅんぐr /順繰/
じゅんおくr /順送/
じゅんz /準/殉/
じゅんj /準/
じゅくs /熟/
じゅうりょうあg /重量挙/
じゅうばこよm /重箱読/
じゃらs /戯/
じべt /地べ/
じひびk /地響/
じなr /地鳴/
じづm /字詰/
じつづk /地続/
じつn /実/
じつh /実/
じっぱひとからg /十把一絡/
じだいおくr /時代後/
じずm /字詰/
じくばr /字配/
じがたm /地固/
じかんぎr /時間切/
じかづk /直付/
じかn /直/
じあまr /字余/
じs /辞/侍/持/
じr /焦/
しんじr /信じ/
しんきくさi /心気臭/
しんいr /新入/
しんz /信/
しんn /真/
しんj /信/
しわよs /皺寄/
しわがr /嗄/
しわk /仕分/
しわi /吝/
しろぬr /白塗/
しろぬk /白抜/
しろk /白/
しろi /白/
しるs /記/著/印/誌/徴/標/
しりぬぐi /尻拭/
しりぞk /退/斥/
しりごm /尻込/
しりきr /尻切/
しりあu /知り合/
しりあi /知合/
しらべr /調べ/
しらじらs /白々/
しらz /知ら/
しらs /知ら/報/
しらm /白/
しらk /白/
しらb /調/
しょっきr /初っ切/
しょげr /悄気/
しょくs /食/
しょきばらi /暑気払/
しょうどうがi /衝動買/
しょうこしらb /証拠調/
しょうこr /性懲/
しょうぎだおs /将棋倒/
しょうz /生/
しょうs /称/抄/証/
しょうj /生/
しょu /背負/
しょs /処/
しゅっせばらi /出世払/
しゅくs /祝/
しゅうねんぶかi /執念深/
しゅうあk /週明/
しゅt /主/
しゃべt /喋/
しゃべr /喋/
しゃっきんとr /借金取/
しゃちほこばr /鯱張/
しゃしんうつr /写真写/
しゃがr /嗄/
しもやk /霜焼/
しもがr /霜枯/
しめつk /締め付/締付/
しめだs /締め出/
しめくくr /締め括/
しめきr /締切/締め切/
しめs /示/湿/
しめr /湿/
しむk /仕向/
しみこm /染み込/
しみいr /染み入/
しまながs /島流/
しまu /仕舞/終/了/
しぼりだs /絞り出/
しぼr /搾/絞/
しぼm /萎/凋/
しぶs /渋/
しぶr /渋/
しぶm /渋/
しぶk /渋/
しぶi /渋/
しびr /痺/
しばらk /暫/
しばたk /瞬/
しばかr /柴刈/芝刈/
しばs /暫/
しばr /縛/
しはらw /支払/
しはらu /支払/
しはらt /支払/
しはらi /支払/
しのびわらi /忍び笑/
しのびよr /忍び寄/
しのびこm /忍び込/
しのごn /四の五/
しのg /凌/
しのb /偲/忍/
しにくi /為難/
しなぞろe /品揃/
しなさだm /品定/
しなぎr /品切/
しなu /撓/
しなr /撓/
しとm /仕留/
しったかぶr /知ったか振/
しっかr /確/
しっs /失/
しちめんどうくさi /七面倒臭/
しちながr /質流/
しちうk /質請/
しちいr /質入/
しだs /仕出/
しだr /垂/
したよm /下読/
したむk /下向/
したまわr /下回/
したばたらk /下働/
したばe /下生/
したぬr /下塗/
したどr /下取/
したてひねr /下手捻/
したてなg /下手投/
したてだしなg /下手出し投/
したづm /下積/
したたr /滴/
したたm /認/
したしらb /下調/
したしm /親し/
したざわr /舌触/
したごしらe /下拵/
したがu /従/順/随/
したがt /従/
したがk /下書/
したがi /従/
したがe /従/随/
したうt /舌打/
したu /慕/
したt /仕立/
したs /親/
しずみこm /沈み込/
しずr /垂/
しずm /沈/静/鎮/
しずk /静/
しごとはじm /仕事始/
しごk /扱/
しこr /凝/痼/
しこm /仕込/
しげr /茂/繁/
しげm /茂/
しげk /繁/
しけr /湿気/
しぐr /時雨/
しくm /仕組/
しきんぐr /資金繰/
しきりなおs /仕切り直/
しきつm /敷き詰/
しきr /仕切/頻/
しかたなi /仕方無/
しかくi /四角/
しかえs /仕返/
しかt /叱/
しかs /然/併/
しかr /叱/然/
しかm /顰/
しかk /仕掛/
しおくr /仕送/
しおr /萎/
しおk /仕置/
しうt /仕打/
しいれr /仕入れ/
しいたg /虐/
しいt /強い/
しいs /弑/
しいr /仕入/
しあわs /仕合/幸/
しあu /為合/
しあg /仕上/
しs /死/資/
しr /知/
しn /死/
しm /締/占/絞/染/閉/沁/緊/浸/凍/滲/
しk /敷/如/及/若/
しi /強/誣/
ざs /座/差/
ざr /戯/
さんすくm /三竦/
さんz /参/
さんs /産/
さんj /参/
さわy /爽/
さわt /触/
さわr /触/障/
さわg /騒/
さらu /復習/攫/浚/渫/
さらs /晒/曝/
さらn /更/然ら/
さらk /曝/
さらe /渫/浚/
さらb /然ら/
さやあt /鞘当/
さむs /寒/
さむk /寒/
さむi /寒/
さむg /寒/
さみs /淋/寂/
さまよu /さ迷/
さまたg /妨/
さまがわr /様変/
さびどm /錆止/
さびs /寂/淋/
さびr /寂/
さばおr /鯖折/
さばk /裁/捌/
さながr /宛/
さとがえr /里帰/
さとs /諭/
さとr /悟/
さついr /札入/
さっt /颯/
さっs /察/
さだm /定/
さだk /定/
さそいこm /誘い込/
さそu /誘/
さそi /誘/
さずk /授/
さすらu /流離/
さすr /摩/
さしわたs /差渡/
さしもどs /差し戻/差戻/
さしむかi /差向/
さしむk /差し向/
さしまわs /差し回/
さしひかe /差し控/差控/
さしひk /差し引/
さしのぼr /差し上/差し昇/
さしとおs /刺し通/
さしとm /差し止/
さしつかw /差し遣/
さしつかe /差し支/差支/
さしちがe /差し違/刺し違/
さしだs /差出/差し出/
さしたt /差し立/
さしせまr /差し迫/
さししめs /指し示/
さしさわr /差障/差し障/
さしころs /刺し殺/
さしこm /差し込/射し込/
さしかw /差し交/
さしかk /差し掛/
さしかe /差し替/挿し替/
さしおさe /差押/
さしおk /差し置/
さしいそg /差し急/
さしいr /差し入/挿し入/差入/
さしあu /差し合/
さしあt /差し当/
さしあg /差し上/
ささやk /囁/
ささy /細/
ささg /捧/
ささe /支/
さげすm /蔑/貶/
さけよi /酒酔/
さけのm /酒飲/
さけづk /酒漬/
さけb /叫/
さぐりあi /探り合/
さぐr /探/
さくづk /作付/
さきわたs /先渡/
さきゆk /先行/
さきまわr /先回/
さきぶr /先触/
さきばらi /先払/
さきばしr /先走/
さきどr /先取/
さきだt /先立/
さきがk /先駆/
さきおくr /先送/
さきうt /先打/
さきいk /先行/
さきn /先/
さがしだs /探し出/
さがs /探/捜/
さがr /下が/
さかもr /酒盛/
さかむs /酒蒸/
さかまk /逆巻/
さかのぼr /遡/泝/溯/
さかだt /逆立/
さかうらm /逆恨/
さかs /逆/賢/
さかr /逆/盛/
さかn /盛/
さかe /栄/
さえわたr /冴え渡/
さえずr /囀/
さえぎr /遮/
さいわi /幸/
さいはt /最果/
さいなm /嘖/
さいs /際/
さs /挿/差/刺/指/鎖/注/点/捺/
さr /去/然/
さm /覚/冷/醒/褪/然/
さk /避/割/咲/裂/
さg /下/提/
さe /冴/冱/
さb /錆/荒/寂/
ごろうz /御覧/
ごろうj /御覧/
ごようはじm /御用始/
ごようおさm /御用納/
ごぶがr /五分刈/
ごばらi /後払/
ごとs /如/
ごぞんz /御存/
ごぞんj /御存/
ござi /御座/
ごくつぶs /穀潰/
ごうじょっぱr /強情っ張/
ごs /越/期/伍/
ごe /越/
こんまk /根負/
こんばんh /今晩/
こんにちh /今日/
こんくらb /根競/
こわばr /強張/
こわs /壊/怖/毀/恐/
こわr /壊/毀/
こわk /小分/恐/怖/
こわi /恐/怖/強/
こわg /怖/恐/
ころげこm /転げ込/
ころがりこm /転がり込/
ころs /殺/
ころg /転/
ころb /転/
こりかたm /凝り固/
こらe /怺/堪/
こやs /肥や/
こもどr /小戻/
こもr /籠/隠/
こめつk /米搗/
こむらがえr /腓返/
こみだs /小見出/
こまわr /小回/
こまむすb /細結/
こまねk /拱/
こまぬk /拱/
こまたすくi /小股掬/
こまぐm /駒組/
こまぎr /細切/
こまかi /細か/
こまr /困/
こまm /小ま/
こまk /細/
こまi /細/
こぼt /毀/
こぼs /零/毀/
こぼr /溢/零/毀/
こぶr /小降/小振/
こばなr /子離/
こばしr /小走/
こばm /拒/
このm /好/
こなs /熟/
こなr /熟/
こどもずk /子供好/
ことわりがk /断り書/
ことわr /断/
ことほどさようn /事程左様/
ことほg /言祝/寿/
ことばづかi /言葉遣/
ことばあそb /言葉遊/
ことづt /言伝/
ことづk /託/言付/
ことたr /事足/
ことずk /託/
ことごとk /尽/悉/
ことこまk /事細/
ことかk /事欠/
ことえr /言選/
こといm /言忌/
ことあg /言挙/
ことn /異/殊/
こてなg /小手投/
こてしらb /小手調/
こづr /子連/
こづk /小突/
こつあg /骨揚/
こだかi /小高/
こだs /小出/
こたe /答/応/堪/
こぞt /挙/
こぞr /挙/
こそだt /子育/
こそg /刮/
こすからi /狡辛/
こすr /擦/錯/
こすi /狡/
こじr /抉/拗/
こしらe /拵/
こしまわr /腰回/
こしぬk /腰抜/
こしなg /腰投/
こしづk /腰付/
こしくだk /腰砕/
こしかk /腰掛/
こざかs /小賢/
こごろs /子殺/
こごr /凝/
こごm /屈/
こごe /凍/
こころよi /快/
こころもとなi /心許無/
こころまt /心待/
こころぼそi /心細/
こころのこr /心残/
こころづよi /心強/
こころづくs /心尽/
こころづかi /心遣/
こころづk /心付/
こころざs /志/
こころぐるs /心苦/
こころくばr /心配/
こころがまe /心構/
こころがk /心掛/
こころおt /心落/
こころおk /心置/
こころいr /心入/
こころあたr /心当/
こころあt /心当/
こころm /試/
ここのt /九/
ここちよi /心地好/
こけらおとs /柿落/
こきざm /小刻/
こがらs /木枯/
こがr /焦/
こおr /凍/氷/
こえがわr /声変/
こうむr /被/蒙/
こうごうs /神々/
こうごk /小動/
こうz /高/講/
こうj /講/高/
こうb /香/
こいs /恋/
こy /肥/
こu /乞/請/恋/斯/
こs /越/漉/濃/濾/鼓/超/
こr /凝/懲/樵/
こn /来/此/捏/込/
こm /込/混/籠/
こk /扱/痩/放/倒/濃/
こi /濃/乞/請/
こg /焦/漕/扱/
こe /越/超/肥/
こb /媚/
げんなおs /験直/
げんz /減/
げんn /現/
げんj /減/
げきs /激/
げs /解/
げn /実/
けんとうちがi /見当違/
けんz /献/
けわs /険/
けむt /煙/
けむr /煙/烟/
けむi /煙/
けみs /閲/
けぶかi /毛深/
けぶr /煙/烟/
けぶi /煙/
けなs /貶/
けどr /気取/
けづくろi /毛繕/
けっs /決/結/
けちr /蹴散/
けだるi /気怠/
けだかs /気高/
けだかi /気高/
けだs /蓋/
けたはずr /桁外/
けたちがi /桁違/
けたぐr /蹴手繰/
けたおs /蹴倒/
けずr /削/梳/
けしさr /消し去/
けしかk /嗾/
けさがたm /袈裟固/
けぎらi /毛嫌/
けがs /汚/穢/
けがr /汚/穢/
けかえs /蹴返/
けいきづk /景気付/
けあg /蹴上/
けs /消/怪/
けr /蹴/
ぐちr /愚痴/
くんよm /訓読/
くんづk /君付/
くわだt /企/
くわずぎらi /食わず嫌/
くわw /加/
くわs /詳/
くわr /区割/
くわk /区分/
くわe /加/銜/
くろびかr /黒光/
くろぬr /黒塗/
くろこg /黒焦/
くろi /黒/
くれなずm /暮れ泥/
くるめk /眩/
くるしまぎr /苦し紛/
くるw /狂/
くるu /狂/
くるs /苦/
くるo /狂/
くるm /包/
くるi /狂/
くりもどs /繰り戻/
くりのb /繰延/
くりだs /繰り出/
くりこs /繰り越/
くりこm /繰り込/
くりかえs /繰り返/繰返/
くりあg /繰上/繰り上/
くらざらe /蔵浚/
くらがe /鞍替/
くらいどr /位取/
くらいづk /位付/
くらいつk /食らい付/
くらいこm /食らい込/
くらいs /位/
くらu /食ら/
くらs /暮/暗/
くらm /眩/暗/
くらi /暗/昏/冥/
くらg /暗/
くらb /比/較/競/
くゆr /燻/
くやしなk /悔し泣/
くやs /悔/口惜/
くやm /悔/
くもゆk /雲行/
くもがくr /雲隠/
くもr /曇/
くみとr /汲み取/
くみたてr /組み立て/
くみたt /組み立/組立/
くみこm /組み込/
くみかe /組替/組み替/
くみいr /組み入/組入/
くみあわs /組合/組み合/
くみs /与/
くぼm /窪/凹/
くびひねr /首捻/
くびなg /首投/
くびっぴk /首っ引/
くびくくr /首縊/
くびr /縊/括/
くばr /配/
くどk /口説/
くつろg /寛/
くつずr /靴擦/
くつがえs /覆/
くつがえr /覆/
くっs /屈/
くちよごs /口汚/
くちぶr /口振/
くちふうj /口封/
くちばしr /口走/
くちなおs /口直/
くちどm /口止/
くちだs /口出/
くちぞe /口添/
くちずさm /口遊/
くちごたe /口答/
くちぎたなi /口穢/
くちきr /口切/
くちきk /口利/
くちおs /口惜/
くちうつs /口移/
くちあたr /口当/
くだt /下/
くだs /下/降/
くだr /下/降/
くだk /砕/
くずきr /葛切/
くずおr /頽/
くずs /崩/
くずr /崩/
くすりづk /薬漬/
くすりうr /薬売/
くすぶr /燻/
くすぐr /擽/
くじびk /籤引/
くじk /挫/
くしざs /串刺/
くしけずr /梳/
くさわk /草分/
くさとr /草取/
くさs /臭/
くさr /腐/鏈/
くさm /臭/
くさi /臭/
くぐr /潜/
くくr /括/
くぎづk /釘付/
くぎr /区切/
くいにg /食い逃/
くいつぶs /食い潰/
くいちがu /食い違/
くいちがi /食い違/
くいちr /食い散/
くいさg /食い下/
くいこm /食い込/
くいあらたm /悔い改/
くいあr /食い荒/
くy /悔/
くw /食/喰/
くu /食/喰/
くt /朽/喰/
くs /屈/奇/
くr /来/繰/暮/食/呉/眩/
くm /組/酌/汲/
くi /食/悔/喰/
くe /食/喰/
ぎんz /吟/
ぎりだt /義理立/
ぎょうぎょうs /仰々/仰仰/
ぎゅうじr /牛耳/
ぎゃくもどr /逆戻/
ぎゃくびk /逆引/
ぎゃくばr /逆張/
ぎむづk /義務付/
ぎs /擬/
きんとうわr /均等割/
きんz /禁/
きんj /禁/
きをつk /気を付/
きわどi /際疾/
きわだt /際立/
きわm /極/究/窮/
きろくやぶr /記録破/
きれこm /切れ込/
きれいずk /綺麗好/
きりもr /切り盛/
きりもm /錐揉/
きりふk /霧吹/
きりひらk /切開/
きりはなs /切り離/
きりぬk /切り抜/切抜/
きりどおs /切通/
きりとおs /切り通/
きりとr /切取/切り取/
きりつm /切り詰/
きりだs /切り出/切出/
きりすt /切り捨/切捨/
きりさk /切り裂/
きりさg /切下/
きりこm /切込/
きりきざm /切り刻/
きりかえs /切り返/
きりかえr /切り換え/
きりかe /切り替/切り換/切替/切換/
きりおとs /切り落/
きりあu /斬り合/
きりあg /切上/
きらw /嫌/
きらu /嫌/
きらt /嫌/
きらi /嫌/
きよs /清/
きよr /清/
きよm /清/浄/
きよi /清/
きょうみぶかi /興味深/
きょうざm /興醒/
きょうz /興/
きょうs /供/
きょうj /興/
きゅうs /窮/
きやすm /気休/
きやすi /気安/
きやs /着痩/
きゃくよs /客寄/
きゃくひk /客引/
きゃくあつかi /客扱/
きもだめs /肝試/
きもいr /肝煎/
きもt /気持/
きめこm /決め込/
きむずかs /気難/
きみわるi /気味悪/
きまぐr /気紛/
きまt /決/
きまr /極/決/
きぶくr /着脹/
きびしi /厳し/
きびs /厳/
きばr /気張/
きのぼr /木登/
きのr /気乗/
きぬk /気抜/
きにいr /気に入/
きながs /着流/
きなr /生成/
きどおs /着通/
きどr /気取/
きづかu /気遣/
きづかr /気疲/
きづかi /気遣/
きづk /気付/
きづi /気付/
きつk /気付/着付/
きっかk /切っ掛/
きっs /喫/
きちがi /気違/
きだt /気立/
きたむk /北向/
きたなs /汚/
きたなi /汚/穢/
きたs /来/
きたr /来/
きたe /鍛/
きそづk /基礎付/
きそくただs /規則正/
きそu /競/
きそi /競/
きずかi /気遣/
きずk /築/気付/
きしr /軋/轢/
きしm /軋/
きざs /兆/
きざm /刻/
きさk /気さ/
きこm /着込/
きぐm /木組/
きくばr /気配/
ききわk /聞き分/
ききにくi /聞き難/
ききとおs /聞き通/
ききとr /聞き取/
ききだs /聞き出/
ききずt /聞き捨/
ききこm /聞き込/
ききぐるs /聞き苦/
ききおぼe /聞き覚/
ききいr /聞き入/
きがまe /気構/
きがかr /気掛/
きがn /気兼/
きがe /着替/
きかざr /着飾/
きおくr /気後/
きおu /気負/
きおt /気落/
きおi /気負/
きいろi /黄色/
きy /消/
きt /来/
きs /着/記/期/帰/
きr /切/着/斬/鑽/著/
きm /決/極/黄/
きk /聞/聴/効/利/
きi /聴/
きe /消/
がんばt /頑張/
がんばr /頑張/
がまんづよi /我慢強/
がっしょうひねr /合掌捻/
がけくずr /崖崩/
がえんz /肯/
がえんj /肯/
がいs /害/概/
がt /勝/
がk /掛/
かんやどr /神宿/
かんばs /芳/
かんのんびらk /観音開/
かんちがi /勘違/
かんだかi /甲高/疳高/
かんじとr /感じ取/
かんぐr /勘繰/
かんきr /缶切/
かんがみr /鑑み/
かんがえこm /考え込/
かんがe /考/
かんかつちがi /管轄違/
かんz /感/
かんs /関/冠/
かんj /感/
かわむk /皮剥/
かわづr /川釣/
かわぞi /川沿/
かわくだr /川下/
かわきr /皮切/
かわいr /可愛/
かわいk /可愛/
かわいi /可愛/
かわいg /可愛/
かわs /交/躱/
かわr /変/代/替/
かわk /渇/乾/
かろy /軽/
かれr /涸/
かるがるs /軽々/
かるs /軽/
かるk /軽/
かるi /軽/
かりわたs /仮渡/
かりぬi /仮縫/
かりとr /刈取/刈り取/
かりだs /狩り出/借り出/駆り出/
かりたt /駆り立/
かりずまi /仮住/
かりこm /刈り込/
かりきr /借り切/
かりかs /借り貸/
かりうk /借り受/
かりいr /借り入/刈り入/借入/
かりあつm /駆り集/
かりあg /借り上/刈り上/
かりn /仮/
からむs /空蒸/
からみあu /絡み合/
からまわr /空回/
からぶr /空振/
からぶk /乾拭/
からづm /空積/
からだk /空焚/
からたけわr /幹竹割/
からさわg /空騒/
からうr /空売/
からあg /空揚/
からs /辛/枯ら/
からn /絡/
からm /絡/辛/搦/
からi /辛/
からg /絡/紮/
かよw /通/
かよu /通/
かよi /通/
かゆs /痒/
かゆm /痒/
かゆi /痒/
かやぶk /茅葺/
かやr /蚊遣/
かもs /醸/
かむr /被/
かみゆi /髪結/
かみつk /噛み付/
かみだのm /神頼/
かみしほうがたm /上四方固/
かみきr /紙切/
かみかざr /髪飾/
かみかくs /神隠/
かまびすs /喧/
かまu /構/
かまi /構/
かまe /構/
かぼそi /か細/
かぶわk /株分/
かぶs /被/
かぶr /被/
かばu /庇/
かはらi /過払/
かねもうk /金儲/
かねまわr /金回/
かねづかi /金遣/
かねそなe /兼ね備/
かねあi /兼合/
かねt /予/
かにばさm /蟹挟/
かならz /必/
かなしばr /金縛/
かなぎr /金切/
かながk /仮名書/
かなu /叶/適/
かなs /悲/哀/愛/
かなe /叶/
かなd /奏/
かつt /嘗/
かつg /担/
かつe /餓/
かちまk /勝ち負/
かちにg /勝ち逃/
かちこs /勝ち越/
かたわr /傍/片割/
かたりあu /語り合/
かたりあk /語り明/
かたよr /偏/片寄/
かたむすb /片結/
かたむk /傾/
かたびらk /片開/
かたばかr /形許/
かたなs /形無/
かたどおr /型通/
かたどr /象/模/
かたづk /片付/
かたつk /型付/肩付/
かたたたk /肩叩/
かたたがe /方違/
かたじけなi /忝/辱/
かたこr /肩凝/
かたくるs /堅苦/
かたがわr /肩代/
かたおもi /片思/
かたおs /型押/
かたいr /肩入/
かたy /片/
かたs /固/堅/難/硬/
かたr /語/騙/
かたm /固/
かたi /硬/堅/固/難/
かぞe /数/
かぜむk /風向/
かぜとおs /風通/
かせg /稼/
かずk /被/
かすr /擦/掠/
かすm /霞/掠/翳/
かすk /微/幽/
かじr /齧/
かしまs /姦/
かしつk /貸し付/
かしだs /貸し出/貸出/
かしずk /傅/
かしこs /賢/
かしこm /畏/
かしこi /賢/
かしきr /貸し切/貸切/
かしかr /貸し借/
かしg /傾/
かざりたt /飾り立/
かざむk /風向/
かざs /翳/
かざr /飾/
かさばr /嵩張/
かさn /重/
かさm /嵩/
かこつk /託/
かこいこm /囲い込/
かこu /囲/
かこm /囲/
かこi /囲/
かげr /翳/陰/
かけもt /掛持/
かけまわr /駆け回/
かけひk /駆引/
かけどおs /駆け通/
かけこm /駆け込/
かけr /翔/
かぐわs /馨/香/
かくのごとk /斯くの如/
かくづk /格付/
かくしどr /隠し撮/
かくさg /格下/
かくぎr /角切/
かくがr /角刈/
かくあg /格上/
かくt /斯く/
かくs /隠/匿/画/
かくr /隠/
かぎざk /鉤裂/
かぎt /限/
かぎr /限/
かきわk /掻き分/書き分/
かきもr /書き漏/
かきのこs /書き残/
かきぬk /書き抜/
かきなおs /書き直/
かきなr /掻き鳴/
かきとどm /書き留/
かきとr /書き取/
かきつづr /書き綴/
かきつづk /書き続/
かきつたe /書き伝/
かきつくs /書き尽/
かきつk /書き付/
かきちr /書き散/
かきだs /書き出/書出/掻き出/
かきたt /書き立/
かきたs /書き足/
かきぞm /書き初/
かきそんz /書き損/
かきそんj /書き損/
かきそe /書き添/
かきすt /書き捨/掻き捨/
かきしるs /書き記/
かきこm /書き込/書込/
かきけs /掻き消/
かきくわe /書き加/
かきくだs /書き下/
かきくずs /書き崩/
かきかe /書換/書き替/
かきおよb /書き及/
かきおさm /書き納/
かきおくr /書き送/
かきおk /書き置/
かきうつs /書き写/
かきいr /書き入/
かきあらわs /書き表/
かきあらたm /書き改/
かきあやまr /書き誤/
かきあつm /掻き集/
かきあg /書き上/
かがやk /輝/耀/
かがm /屈/
かかわr /拘/関/係/
かかえこm /抱え込/
かかw /関/
かかr /係/掛/
かかg /掲/
かかe /抱/
かおむk /顔向/
かおみしr /顔見知/
かおまk /顔負/
かおぶr /顔触/
かおつk /顔付/
かおだt /顔立/
かおだs /顔出/
かおあわs /顔合/
かおr /香/馨/薫/
かえりざk /返り咲/
かえりうt /返り討/
かえりm /顧/省/
かえt /却/
かえs /返/帰/還/
かえr /帰/返/還/
かいもどs /買戻/
かいもとm /買い求/
かいまみr /垣間見/
かいびかe /買い控/
かいとr /買取/買い取/
かいたs /買い足/
かいしm /買占/買い占/
かいごろs /飼い殺/
かいこm /買い込/
かいぐi /買い食/
かいがいs /甲斐甲斐/
かいかぶr /買い被/
かいかe /買い換/
かいおk /買い置/
かいs /介/解/会/
かw /変/代/替/換/交/
かu /買/交/飼/支/
かt /勝/且/克/
かs /貸/課/化/科/淅/嫁/架/呵/
かr /借/苅/刈/駆/狩/枯/嗄/涸/
かn /兼/彼/噛/
かm /噛/咬/嚼/
かk /書/掛/欠/架/駆/懸/賭/掻/駈/繋/斯/闕/舁/
かi /買/飼/交/書/
かg /嗅/
かe /変/替/代/換/
おんびk /音引/
おんなたらs /女誑/
おんなずk /女好/
おんなざかr /女盛/
おんなぎらi /女嫌/
おんがえs /恩返/
おわs /御座/在/
おわr /終/
おろそk /疎/
おろおぼe /疎覚/
おろs /卸/
おろk /愚/
おれまがr /折れ曲/
おりなs /織り成/
おりたたm /折畳/折り畳/
おりこm /折込/折り込/織り込/
おりかえs /折り返/折返/
おりいt /折り入/
おりいr /折り入/
おりあs /折悪/
おりあi /折合/
およs /凡/
およg /泳/游/
およb /及/
おやゆずr /親譲/
おももt /面持/
おもむk /赴/趣/
おもねr /阿/
おもてむk /表向/
おもてどおr /表通/
おもてだt /表立/
おもてがk /表書/
おもてあm /表編/
おもしろs /面白/
おもしろm /面白/
おもしろk /面白/
おもしろi /面白/
おもしろg /面白/
おもざs /面差/
おもくるs /重苦/
おもおもs /重々/
おもいどおr /思い通/
おもいつk /思い付/
おもいちがi /思い違/
おもいだs /思い出/
おもいたt /思い立/
おもいしr /思い知/
おもいこm /思い込/
おもいきt /思い切/
おもいきr /思い切/
おもいおもi /思い思/
おもいいr /思い入/
おもいあg /思い上/
おもu /思/想/
おもt /重/思/
おもs /重/
おもr /重/
おもn /主/
おもm /重/
おもi /思/重/想/
おまもr /御守/
おまいr /御参/
おぼえこm /覚え込/
おぼs /覚/思/
おぼr /溺/
おぼe /覚/
おぶu /負/
おびやk /脅/
おびただs /夥/
おびe /怯/脅/
おひとよs /御人好/
おののk /戦/
おのz /自/
おなz /同/
おなj /同/
おどろk /驚/
おどろi /驚/
おどs /脅/縅/
おどr /躍/踊/
おどk /脅/
おとろe /衰/
おとなs /大人/
おとずr /訪/
おとしいr /陥/
おとしm /貶/
おとこざかr /男盛/
おとs /落/
おとr /劣/
おてあg /御手上/
おつg /御告/
おっt /追っ/
おちぶr /落魄/零落/
おちばたk /落葉焚/
おちつk /落着/落ち着/
おちこm /落ち込/
おちいr /陥/
おちあu /落ち合/
おちr /堕ち/墜ち/落ち/
おだy /穏/
おだt /煽/
おたけb /雄叫/
おぞまs /悍/鈍/
おそれいr /恐れ入/
おそまk /遅蒔/
おそざk /遅咲/
おそw /教/
おそu /襲/
おそs /遅/
おそr /恐/畏/怖/
おそk /遅/
おそi /遅/
おぜんだt /御膳立/
おしよs /押し寄/
おしとおs /押し通/
おしつk /押し付/
おしだs /押し出/
おしたおs /押し倒/
おしすすm /推し進/
おしこm /押し込/
おしきs /御仕着/
おしかk /押し掛/
おしえこm /教え込/
おしg /惜し/
おしe /教/
おさなs /幼/
おさなi /幼/
おさえこm /抑え込/
おさm /収/修/治/納/
おさe /抑/押/
おごそk /厳/
おごr /傲/奢/驕/
おこなu /行/
おこなi /行/
おこたr /怠/
おこs /興/起/遣/熾/
おこr /興/怒/起/
おけr /於け/
おくりむかe /送り迎/
おくりとどk /送り届/
おくりだs /送り出/
おくりたおs /送り倒/
おくりこm /送り込/
おくs /臆/
おくr /送/遅/後/贈/
おぎなu /補/
おぎなi /補/
おきわたs /沖渡/
おきわすr /置き忘/
おきぬk /起き抜/
おきたt /起き立/
おきざr /置き去/
おきかえr /置き換え/
おきかe /置き換/置換/
おきあg /起き上/
おがm /拝/
おかっぴk /岡っ引/
おかえs /御返/
おかs /犯/冒/侵/
おおわらi /大笑/
おおもr /大盛/
おおみだs /大見出/
おおまわr /大回/
おおぶr /大降/
おおどおr /大通/
おおづm /大詰/
おおぐi /大食/
おおうりだs /大売出/
おおうつs /大写/
おおうk /大受/
おおあr /大荒/
おおu /覆/被/蔽/
おおs /多/仰/
おおr /大/
おおm /多/
おおk /大/多/
おおi /多/覆/大/
おうぼしゃりまわr /応募者利回/
おうz /応/
おうj /応/
おいろなおs /御色直/
おいはらu /追い払/
おいはらi /追い払/
おいぬk /追い抜/
おいつm /追い詰/
おいつk /追い付/
おいだs /追い出/追出/
おいたt /生い立/追い立/
おいしげr /生い茂/
おいこs /追い越/
おいこm /追い込/老い込/
おいかk /追い掛/
おいうt /追い討/
おいt /於/
おz /怖/
おw /終/
おu /負/追/生/
おt /落/追/堕/墜/
おs /押/惜/推/圧/
おr /降/折/織/下/居/
おk /起/置/於/擱/
おj /怖/
おi /老/追/負/
おe /終/
おb /帯/
えんむすb /縁結/
えんどおi /縁遠/
えんだt /円建/
えんきr /縁切/
えんz /演/
えんj /演/
えりごのm /選り好/
えりぐr /襟刳/
えらびだs /選び出/
えらs /偉/
えらi /偉/
えらb /選/
えとk /絵解/
えづk /餌付/
えだわかr /枝分/
えだぶr /枝振/
えぐr /抉/
えきうr /駅売/
えがたi /得難/
えがk /描/
えがi /描/
えかk /絵描/
えいz /映/
えいr /絵入/
えt /得/
えr /得/選/
えm /笑/
うんだめs /運試/
うわむk /上向/
うわまわr /上回/
うわばk /上履/
うわのs /上乗/
うわのr /上乗/
うわぬr /上塗/
うわてひねr /上手捻/
うわてなg /上手投/
うわてだしなg /上手出し投/
うわづm /上積/
うわずm /上澄/
うわすべr /上滑/
うわがk /上書/
うろおぼe /疎覚/
うれゆk /売行/
うれs /嬉/
うれi /憂/愁/
うれe /憂/愁/
うるわs /麗/
うるさi /煩/
うるおu /潤/
うるおs /潤/
うるm /潤/
うりわたs /売り渡/売渡/
うりだs /売り出/売出/
うりこm /売り込/
うりきr /売り切/
うりかi /売り買/
うりあg /売上/
うらやm /羨/
うらなu /占/
うらなi /占/
うらどおr /裏通/
うらづk /裏付/
うらぎr /裏切/
うらがえs /裏返/
うらあm /裏編/
うらr /麗/
うらm /恨/怨/
うやまu /敬/
うやうやs /恭/
うめあわs /埋め合/
うめk /呻/
うみづr /海釣/
うみだs /生み出/産み出/
うまのr /馬乗/
うまs /旨/
うまr /生/
うまm /旨/
うまi /旨/
うばu /奪/
うばt /奪/
うのm /鵜呑/
うぬぼr /己惚/自惚/
うなだr /項垂/
うなずk /頷/
うながs /促/
うなr /唸/
うとm /疎/
うとi /疎/
うでだめs /腕試/
うでたてふs /腕立て伏/
うでぐm /腕組/
うできk /腕利/
うでがたm /腕固/
うでおs /腕押/
うつむk /俯/
うつぶs /俯/
うつくs /美/
うつs /移/映/写/
うつr /移/写/映/遷/虚/
うっとうs /鬱陶/
うったe /訴/
うっすr /薄/
うちわもm /内輪揉/
うちわたs /内渡/
うちよs /打ち寄/
うちやぶr /打ち破/討ち破/
うちまわr /内回/
うちほろb /討ち滅/
うちはらu /打ち払/
うちはなs /打ち放/
うちぬk /打ち抜/
うちながm /打ち眺/
うちなおs /打ち直/
うちなr /打ち鳴/
うちとおs /打ち通/
うちとr /打ち取/
うちとk /打ち解/
うちつk /打ち付/
うちだs /打ち出/
うちたt /打ち立/
うちこわs /打ち壊/
うちころs /打ち殺/
うちこm /打込/打ち込/
うちけs /打ち消/
うちくだk /打ち砕/
うちくずs /打ち崩/
うちきr /打ち切/
うちがk /内掛/
うちかt /打ち勝/
うちかk /打掛/
うちいr /討ち入/
うちあわs /打合/
うちあk /打ち明/
うちあg /打ち上/
うたがu /疑/
うたがi /疑/
うたいだs /歌い出/
うたw /謳/
うたu /歌/謡/唄/謳/
うたi /歌/
うそぶk /嘯/
うずまk /渦巻/
うずたかi /堆/
うずくまr /踞/蹲/
うずk /疼/
うすわらi /薄笑/
うすよごr /薄汚/
うすぐらi /薄暗/
うすぎたなi /薄汚/
うすきみわるi /薄気味悪/
うすあきなi /薄商/
うすs /薄/
うすr /薄/
うすm /薄/
うすk /薄/
うすi /薄/
うしろむk /後ろ向/
うしみt /丑三/
うしなu /失/
うしおi /牛追/
うしr /後/
うさんくさi /胡散臭/
うごめk /蠢/
うごk /動/
うけわたs /受け渡/
うけもどs /受け戻/
うけもt /受け持/受持/
うけながs /受け流/
うけとr /受け取/受取/
うけとm /受け止/
うけつk /受け付/
うけつg /受け継/
うけたまわr /承/
うけこたe /受け答/
うけおu /請け負/
うけいr /受け入/受入/
うけあu /請け合/受け合/
うけあi /請合/
うきだs /浮き出/
うきたt /浮き立/
うきしずm /浮き沈/
うきがs /浮貸/
うきうk /浮き浮/
うきあしだt /浮足立/
うきあg /浮き上/
うがt /穿/
うかがu /伺/窺/
うかがi /伺/窺/
うかr /浮か/
うえつk /植え付/
うえこm /植え込/
ういういs /初々/
うw /植/
うt /打/撃/討/
うs /失/憂/
うr /売/熟/得/
うm /埋/産/生/倦/膿/績/
うk /受/浮/請/憂/
うi /憂/浮/
うe /飢/植/
いんn /陰/
いわu /祝/
いわr /謂/
いわk /曰/
いわb /言わ/
いろわk /色分/
いろどr /彩/
いろづk /色付/
いろちがi /色違/
いろだs /色出/
いろおt /色落/
いろあi /色合/
いれちがi /入れ違/
いれたt /入れ立/
いれこm /入れ込/
いれかe /入れ替/入れ換/
いりみだr /入り乱/
いりびたr /入り浸/
いりこm /入り込/
いりくm /入り組/
いらだt /苛立/
いらu /弄/
いらt /苛/
いやしくm /苟/
いやしm /卑し/
いやs /卑/癒/
いやg /嫌/
いみづk /意味付/
いみきらu /忌み嫌/
いみあi /意味合/
いまひとt /今一/
いましm /戒/誡/
いまいまs /忌々/
いまy /今/
いまd /未/
いぶかs /訝/
いぶかr /訝/
いぶs /燻/
いぶr /燻/
いばr /威張/
いのちびろi /命拾/
いのちとr /命取/
いのちごi /命乞/
いのちがk /命懸/
いのこr /居残/
いのr /祈/
いねむr /居眠/
いねかr /稲刈/
いぬじn /犬死/
いぬk /居抜/射貫/
いならb /居並/
いななk /嘶/
いなおr /居直/
いなm /否/
いどm /挑/
いとなm /営/
いとu /厭/
いとs /愛/
いでたt /出で立/
いてつk /凍て付/
いつわr /偽/
いつづk /居続/
いつくs /慈/
いつt /五/
いつk /居着/何時/
いっぽんだt /一本立/
いってんばr /一点張/
いっせいn /一斉/
いっこだt /一戸建/
いっきn /一気/
いっs /逸/
いちりんざs /一輪挿/
いちもんなs /一文無/
いちづk /位置付/
いちずk /位置付/
いちじるs /著/
いちがいn /一概/
いだk /抱/
いだi /抱/
いたわr /労/
いたみどm /痛み止/
いたみいr /痛み入/
いたばさm /板挟/
いただk /頂/戴/
いただi /戴/
いたずらn /徒/
いたいたs /痛々/
いたt /至/
いたs /致/痛/
いたr /至/到/
いたm /痛/傷/悼/炒/
いたi /痛/
いたg /痛/
いぞr /居反/
いそがs /忙/
いそs /勤/
いそg /急/
いずr /何/
いすわr /居座/
いすくm /射竦/
いじわるi /意地悪/
いじっぱr /意地っ張/
いじr /弄/
いじm /苛/
いしゅがえs /意趣返/
いしやk /石焼/
いしなg /石投/
いしづくr /石造/
いしぐm /石組/
いざなu /誘/
いざなi /誘/
いざr /躄/
いさぎよi /潔/
いさかi /諍/
いさm /勇/
いごk /動/
いこu /憩/
いこm /鋳込/
いこi /憩/
いくt /幾/
いくr /幾/
いぎもうしたt /異議申立/
いきわかr /生き別/
いきりたt /熱り立/
いきまk /息巻/
いきのこr /生き残/
いきぬk /息抜/
いきながr /生き長/
いきどおr /憤/
いきづかi /息遣/
いきづm /息詰/行き詰/
いきつk /行き付/
いきつg /息継/
いきちがu /行き違/
いきちがi /行き違/
いきだおr /行き倒/
いきごm /意気込/
いきぐるs /息苦/
いきぎr /息切/
いきがk /行き掛/
いきかよu /行き通/
いきかえr /生き返/行き帰/
いきおいづk /勢い付/
いきおいこm /勢い込/
いきおi /勢/
いきうつs /生き写/
いきいk /生き生/
いきあu /行き合/
いきr /熱/
いかt /怒/
いかr /怒/
いかn /如何/
いえどm /雖/
いえr /癒え/
いいわたs /言い渡/言渡/
いいわk /言い分/
いいよr /言い寄/
いいもr /言い漏/
いいまわs /言い回/
いいまぎr /言い紛/
いいまk /言い負/
いいふくm /言い含/
いいふr /言い触/
いいひろm /言い広/
いいひらk /言い開/
いいはなt /言い放/
いいはr /言い張/
いいのこs /言い残/
いいのがr /言い逃/
いいぬk /言い抜/
いいならw /言い習/
いいなおs /言い直/
いいとおs /言い通/
いいつたe /言い伝/
いいつくs /言い尽/
いいつk /言い付/
いいだs /言い出/
いいそe /言い添/
いいすg /言い過/
いいこm /言い籠/
いいけs /言い消/
いいきr /言い切/
いいかえs /言い返/
いいかk /言い掛/
いいかe /言い換/
いいおよb /言い及/
いいおとs /言い落/
いいおくr /言い送/
いいおk /言い置/
いいあるk /言い歩/
いいあらわs /言い表/
いいあらそu /言い争/
いいあらそi /言い争/
いいあやまr /言い誤/
いいあu /言い合/
いいあt /言い当/
いいあi /言い合/
いあわs /居合/
いy /癒/
いu /言/云/謂/
いt /行/凍/
いr /入/居/射/要/鋳/煎/容/炒/
いn /去/
いm /忌/
いk /行/生/活/往/
いi /好/言/
いe /癒/
あんz /案/
あんn /暗/
あんk /餡/
あんj /案/
あわびむすb /鮑結/
あわだt /泡立/粟立/
あわただs /慌/
あわせもt /合わせ持/
あわt /慌/
あわs /合/併/
あわr /哀/憐/
あわi /淡/
あるk /歩/
ありがとu /有り難/有難/
ありがたi /有難/
ありうr /有り得/
あらわs /表/現/著/
あらわr /現/表/
あらたm /改/
あらそu /争/
あらそi /争/
あらがu /争/
あらがi /争/
あらかせg /荒稼/
あらかじm /予/
あらいながs /洗い流/
あらいだs /洗い出/
あらあらs /荒々/
あらz /非/
あらu /洗/
あらt /新/
あらs /粗/
あらr /荒/
あらi /洗/粗/荒/
あらb /荒/
あゆみよr /歩み寄/
あゆm /歩/
あやまt /誤/過/
あやまr /誤/謝/
あやつr /操/
あやu /危/
あやs /怪/
あやm /怪/危/
あやb /危/
あめふr /雨降/
あみうt /網打/
あまやどr /雨宿/
あまもよi /雨催/
あまもr /雨漏/
あまねk /遍/普/
あまっさe /剰/
あまだr /雨垂/
あまごi /雨乞/
あまくだr /天下/
あまからi /甘辛/
あまy /甘/
あまs /余/甘/
あまr /余/
あまm /甘/
あまi /甘/
あまe /甘/
あぶらあg /油揚/
あぶr /炙/焙/溢/
あぶn /危/
あふr /溢/
あばr /暴/
あばk /暴/
あはなt /畔放/
あなほr /穴掘/
あなねらi /穴狙/
あなどr /侮/
あながt /強/
あなうm /穴埋/
あともどr /後戻/
あとまわs /後回/
あとばらi /後払/
あとくさr /後腐/
あとかたづk /後片付/
あとおs /後押/
あでy /艶/
あてはまr /当て嵌/
あてはm /当て嵌/
あてつk /当て付/
あてこm /当て込/
あつらe /誂/
あつまr /集/集ま/
あつくるs /暑苦/
あつかw /扱/
あつかu /扱/
あつかt /扱/
あつかo /扱/
あつかi /扱/
あつかe /扱/
あつs /暑/厚/熱/
あつm /集/厚/
あつk /厚/熱/暑/
あつi /熱/暑/厚/
あつg /暑/
あったk /暖/
あっs /圧/
あたらしi /新し/
あたらs /新/
あたまわr /頭割/
あたまだs /頭出/
あたまうt /頭打/
あたたm /暖/温/
あたたk /暖/温/
あたu /能/
あたr /辺/当/中/
あたe /与/
あそびほうk /遊び惚/
あそびあk /遊び明/
あそn /遊/
あそb /遊/
あせr /焦/
あずk /預/
あじつk /味付/
あじw /味/
あしまわr /足回/
あしぶm /足踏/
あしばらi /足払/
あしどr /足取/
あししげk /足繁/
あしがらm /足搦/
あしがたm /足固/
あしがかr /足掛/
あしかk /足掛/
あざわらu /嘲笑/
あざむk /欺/
あざけr /嘲/
あざy /鮮/
あさやk /朝焼/
あさぐろi /浅黒/
あさがえr /朝帰/
あさおk /朝起/
あさs /浅/
あさr /漁/
あさk /浅/
あさi /浅/
あこがr /憧/
あけわたs /明け渡/
あけたt /開け閉/
あけくれr /明け暮れ/
あけくr /明け暮/
あぐm /倦/
あくr /明く/
あきらm /諦/
あきなu /商/
あきなi /商/
あきr /明/呆/
あがりこm /上がり込/
あがなu /購/贖/
あがなi /贖/
あがr /騰/挙が/揚が/上が/
あがm /崇/
あかぬk /垢抜/
あかs /赤/
あかr /赤/明/明か/
あかn /赤/
あかi /赤/紅/
あおむk /仰向/
あおたがi /青田買/
あおじろi /青白/蒼白/
あおt /煽/
あおr /煽/
あおk /青/
あおi /青/蒼/
あおg /仰/
あえt /敢え/
あえg /喘/
あいまt /相俟/
あいのr /相乗/
あいなr /相成/
あいつg /相次/
あいたいs /相対/
あいそわらi /愛想笑/
あいかわr /相変/
あいうt /相討/
あいs /愛/
あw /合/会/逢/遭/
あu /合/逢/会/遭/遇/
あt /当/充/宛/
あs /悪/褪/
あr /有/在/荒/或/
あm /編/
あk /飽/開/空/明/厭/倦/
あi /合/会/
あg /挙/揚/上/
あe /和/
あb /浴/
;; okuri-nasi entries.
>あん /案/
>い /医/
>いき /域/行き/行/
>いち /市/
>いろ /色/
>いん /員/
>えいぎょうしょ /営業所/
>えき /駅/
>えん /園/
>おやかた /親方/
>おん /音/
>か /下/化/科/課/可/
>かい /回/界/会/海/階/
>かく /核/
>かた /型/方/
>かん /感/間/艦/館/観/官/管/
>が /画/
>がい /街/外/
>がた /型/
>がわ /側/
>き /器/機/期/記/
>きゅう /級/
>きょく /局/
>く /区/
>くみ /組/
>くん /君/
>ぐみ /組/組み/
>ぐん /郡/群/
>け /家/
>けい /系/型/
>けん /研/県/権/圏/
>こ /個/
>こう /港/
>こく /国/
>ご /後/語/
>ごう /号/
>ごと /毎/
>ごろ /頃/
>さ /差/
>さき /先/
>さく /策/
>さま /様/
>ざい /剤/
>し /市/氏/誌/師/子/視/紙/
>しき /式/
>した /下/
>しつ /室/
>してん /支店/
>しゃ /者/車/
>しゅう /集/州/
>しょ /書/所/
>しょう /症/証/省/
>じ /時/
>じてん /辞典/
>じゅう /中/
>じゅつ /術/
>じゅん /順/
>じょう /上/状/場/
>じん /陣/人/
>すう /数/
>ず /図/
>ずみ /済/
>せい /制/性/生/製/
>せつ /説/
>せん /線/
>せんせい /先生/
>ぜんたい /全体/
>そう /層/相/槽/奏/
>そく /則/
>ぞく /族/
>たい /帯/隊/
>たち /達/
>だい /台/大/代/
>だいがく /大学/
>だん /談/団/
>ち /値/地/
>ちゅう /中/注/
>ちょう /町/長/調/庁/
>つい /対/
>つう /通/
>つき /付き/
>てい /邸/
>てき /的/
>てん /点/
>と /都/
>とう /等/
>とうじ /当時/
>ど /度/
>どう /道/
>どうし /同士/
>どの /殿/
>ない /内/
>など /等/
>のう /能/
>は /派/
>はい /杯/
>はば /幅/
>はん /藩/半/班/版/
>ばい /倍/
>ばん /版/盤/
>ひ /比/費/
>ひょう /表/票/
>ひん /品/
>び /日/
>びょう /病/
>ふ /府/
>ふう /風/
>ぶ /部/
>ぶつ /物/
>ぶん /分/文/
>へん /編/
>べつ /別/
>べん /弁/
>ほう /法/
>まい /枚/
>まえ /前/
>まち /町/
>むら /村/
>め /目/
>めい /名/
>めん /面/
>もく /目/
>もと /元/
>や /屋/
>やく /訳/
>ゆき /行き/行/
>よう /用/
>よく /翼/
>よてい /予定/
>らん /欄/
>りつ /率/
>りょう /料/量/
>りょく /力/
>るい /類/
>れい /例/
>れき /歴/
>ろく /録/
>ろん /論/
>わ /羽/
>わき /脇/
AIDS /エイズ/
Adam /アダム/
Alpha /Α/
America /アメリカ/
Arbeit /アルバイト/
Australia /オーストラリア/
Barium /バリウム/
Beta /Β/
Booby /ブービー/
Brown /ブラウン/
Budapest /ブダペスト/
Caesar /シーザー/
Chlamydia /クラミジア/
Christmas /クリスマス/
Cyrillic /А/Б/В/Г/Д/Е/Ё/Ж/З/И/Й/К/Л/М/Н/О/П/Р/С/Т/У/Ф/Х/Ц/Ч/Ш/Щ/Ъ/Ы/Ь/Э/Ю/Я/
Dagger /ダガー/
Delta /Δ/
Deutschland /ドイツ/独逸/
Edinburgh /エディンバラ/
Edward /エドワード/
Egypt /エジプト/
Elizabeth /エリザベス/
Eskimo /エスキモー/
Europa /ヨーロッパ/
Eve /イブ/
Fourier /フーリエ/
Frankenstein /フランケンシュタイン/
Gamma /Γ/
George /ジョージ/
Greek /Α/Β/Γ/Δ/Ε/Ζ/Η/Θ/Ι/Κ/Λ/Μ/Ν/Ξ/Ο/Π/Ρ/Σ/Τ/Υ/Φ/Χ/Ψ/Ω/
Grimm /グリム/
Henry /ヘンリー/
Hudson /ハドソン/
Hungary /ハンガリー/
Indian /インディアン/
John /ジョン/
Jupiter /ジュピター/
Lilliput /リリパット/
London /ロンドン/
Lynch /リンチ/
Manhattan /マンハッタン/
Marie /マリー/
Mary /メアリ/
Mercury /マーキュリー/
Miami /マイアミ/
Minerva /ミネルヴァ/
Mu /Μ/
Newsweek /ニューズウィーク/
Norway /ノルウェー/
Olympic /オリンピック/
Omega /Ω/
PS /P.S./
Peanuts /ピーナッツ/
Peter /ピーター/
Philips /フィリップス/
Pi /Π/
Richard /リチャード/
Robin /ロビン/
Rose /ローズ/
Sappho /サッフォー/
Scotch /スコッチ/
Sigma /Σ/
Singapore /シンガポール/
Sweden /スウェーデン/
Tibet /チベット/
Toronto /トロント/
Vega /ベガ/
Venus /ビーナス/
Versailles /ベルサイユ/ヴェルサイユ/
Vietnam /ベトナム/
Watson /ワトソン/
XEROX /ゼロックス/
a /エー/
abnormal /アブノーマル/
about /アバウト/
abstract /アブストラクト/
academic /アカデミック/
academy /アカデミー/
accent /アクセント/
access /アクセス/
accessory /アクセサリー/
accident /アクシデント/
accordion /アコーディオン/
account /アカウント/
ace /エース/
acryl /アクリル/
action /アクション/
active /アクティブ/
actual /アクチュアル/
ad /アド/
adam /アダム/
adaptation /アダプテーション/
adapter /アダプター/
address /アドレス/
adhoc /アドホック/
adlib /アドリブ/
admission /アドミッション/
adult /アダルト/
advantage /アドバンテージ/
adventure /アドベンチャー/
advice /アドバイス/
adviser /アドバイザー/
aerobics /エアロビクス/
aerogramme /エアログラム/
africa /アフリカ/
afro /アフロ/
aftercare /アフターケア/
agent /エージェント/
agribusiness /アグリビジネス/
ahead /アヘッド/
ai /AI/
aids /エイズ/
air /エア/
aircheck /エアチェック/
airmail /エアメール/
alarm /アラーム/
album /アルバム/
alcohol /アルコール/
alcove /アルコーブ/
alfred /アルフレッド/
algorithm /アルゴリズム/
alien /エイリアン/
all /オール/
allegro /アレグロ/
alligator /アリゲーター/
allnight /オールナイト/
almond /アーモンド/
alpen /アルペン/
alpha /α/アルファ/
alphabet /アルファベット/
alto /アルト/
amateur /アマチュア/
amazon /アマゾン/
amenity /アメニティ/
america /アメリカ/亜米利加/
american /アメリカン/
amoeba /アメーバ/
amsterdam /アムステルダム/
amusement /アミューズメント/
analog /アナログ/
analogy /アナロジー/
analysis /アナリシス/
analyst /アナリスト/
analyzer /アナライザー/
anarchy /アナーキー/
anchor /アンカー/
andes /アンデス/
angel /エンジェル/
angle /アングル/
angstrom /オングストローム/
anima /アニマ/
animation /アニメーション/
animism /アニミズム/
annex /アネックス/
announce /アナウンス/
announcer /アナウンサー/
anode /アノード/
ansi /ANSI/
antenna /アンテナ/
anthology /アンソロジー/
anti /アンチ/
antithese /アンチテーゼ/
aphorism /アフォリズム/
apollo /アポロ/
apparel /アパレル/
appeal /アピール/
apple /アップル/
application /アプリケーション/
appointment /アポイントメント/
approach /アプローチ/
apron /エプロン/
aquamarine /アクアマリン/
arab /アラブ/
arabia /アラビア/
arbeit /アルバイト/
arc /アーク/
arcade /アーケード/
arch /アーチ/
architecture /アーキテクチャー/
area /エリア/
arena /アリーナ/
aria /アリア/
arm /アーム/
army /アーミー/
arrange /アレンジ/
art /アート/
asbestos /アスベスト/
ascii /アスキー/ASCII/
asia /アジア/亜細亜/
aspect /アスペクト/
asphalt /アスファルト/
assistant /アシスタント/
association /アソシエーション/
atelier /アトリエ/
athome /アットホーム/
atom /アトム/
attack /アタック/
attraction /アトラクション/
attractive /アトラクティブ/
attribute /属性/
auction /オークション/
audio /オーディオ/
audition /オーディション/
auditorium /オーディトリアム/
australia /オーストラリア/
authorize /オーソライズ/
auto /オート/
automatic /オートマチック/
automation /オートメーション/
automaton /オートマトン/
average /アベレージ/
baby /ベビー/
back /バック/
backbone /バックボーン/
backfire /バックファイア/
background /バックグラウンド/
backnumber /バックナンバー/
backup /バックアップ/
bacteria /バクテリア/
badge /バッジ/
badminton /バドミントン/
bag /バッグ/
balance /バランス/
balcony /バルコニー/
ball /ボール/
ballet /バレエ/
balloon /バルーン/
banana /バナナ/
band /バンド/
bangkok /バンコク/
bank /バンク/
bar /バー/
barber /バーバー/
barcode /バーコード/
bargain /バーゲン/
barium /バリウム/
baroque /バロック/
base /ベース/
baseball /ベースボール/
baseline /ベースライン/
basic /ベーシック/
basket /バスケット/
bass /ベース/バス/
bassoon /バスーン/
bat /バット/
bath /バス/
batter /バッター/
battery /バッテリー/
batting /バッティング/
baud /ボー/
bazar /バザー/
bbc /BBC/
beach /ビーチ/
beagle /ビーグル/
beaker /ビーカー/
beam /ビーム/
beat /ビート/
bed /ベッド/
beef /ビーフ/
beginner /ビギナー/
bell /ベル/
belt /ベルト/
bench /ベンチ/
bend /ベンド/
berlin /ベルリン/
best /ベスト/
bestseller /ベストセラー/
beta /β/ベータ/
better /ベター/
bias /バイアス/
bible /バイブル/
big /ビッグ/
bike /バイク/
bikini /ビキニ/
bilingual /バイリンガル/
bill /ビル/
bio /バイオ/
bird /バード/
bishop /ビショップ/
bit /ビット/
black /ブラック/
blackbox /ブラックボックス/
blackhole /ブラックホール/
blade /ブレード/
blank /ブランク/
blend /ブレンド/
blind /ブラインド/
block /ブロック/
blocking /ブロッキング/
blouse /ブラウス/
blow /ブロー/
blue /ブルー/
blueberry /ブルーベリー/
blues /ブルース/
board /ボード/
boat /ボート/
bob /ボブ/
bohm /ベーム/
boiled /ボイルド/
boiler /ボイラー/
bold /ボールド/
bonnet /ボンネット/
bonus /ボーナス/
booby /ブービー/
boogie /ブギ/
book /ブック/
boom /ブーム/
booth /ブース/
boots /ブーツ/
border /ボーダー/
boss /ボス/
boston /ボストン/
bottle /ボトル/
bottleneck /ボトルネック/
bouquet /ブーケ/
bourbon /バーボン/
boutique /ブティック/
bowling /ボーリング/ボウリング/
box /ボックス/
boxer /ボクサー/
boxing /ボクシング/
boy /ボーイ/
boyish /ボーイッシュ/
brace /ブレース/
bracket /ブラケット/
brain /ブレーン/
brake /ブレーキ/
branch /ブランチ/
brand /ブランド/
brandy /ブランデー/
brassband /ブラスバンド/
brazil /ブラジル/
break /ブレーク/
breaker /ブレーカー/
bridal /ブライダル/
bridge /ブリッジ/
broad /ブロード/
bronze /ブロンズ/
brother /ブラザー/
brown /ブラウン/
brush /ブラシ/
brushup /ブラッシュアップ/
bubble /バブル/
bucket /バケット/
buffer /バッファー/
bug /バグ/
building /ビルディング/
built-in /ビルトイン/
builtin /ビルトイン/
bull /ブル/
bumper /バンパー/
bureau /ビューロー/
burger /バーガー/
burma /ビルマ/
burner /バーナー/
burst /バースト/
bus /バス/
bush /ブッシュ/
business /ビジネス/
businessman /ビジネスマン/
butter /バター/
butterfly /バタフライ/
buzzer /ブザー/
bypass /バイパス/
byte /バイト/
cabaret /キャバレー/
cabbage /キャベツ/
cabin /キャビン/
cabinet /キャビネット/
cable /ケーブル/
cad /CAD/
caddie /キャディー/
caesar /シーザー/
cafe /カフェ/
cage /ケージ/
cake /ケーキ/
calendar /カレンダー/
california /カリフォルニア/
call /コール/
callsign /コールサイン/
callus /カルス/
calorie /カロリー/
cambridge /ケンブリッジ/
camera /カメラ/
cameraman /カメラマン/
camp /キャンプ/
campaign /キャンペーン/
campus /キャンパス/
canada /カナダ/
cancel /キャンセル/
candle /キャンドル/
canne /カンヌ/
cannon /キャノン/
canon /カノン/
canopus /カノープス/
canvas /キャンバス/
cap /キャップ/
capacitance /キャパシタンス/
capital /キャピタル/
captain /キャプテン/
caption /キャプション/
car /カー/
caramel /キャラメル/
carbon /カーボン/
carburetor /キャブレター/
card /カード/
cardigan /カーディガン/
care /ケア/
career /キャリア/
carnival /カーニバル/
carpenter /カーペンター/
carpet /カーペット/
cartridge /カートリッジ/
case /ケース/
cash /キャッシュ/
casino /カジノ/
cassette /カセット/
cast /キャスト/
caster /キャスター/
casual /カジュアル/
catalog /カタログ/
catalogue /カタログ/
catch /キャッチ/
catcher /キャッチャー/
category /範疇/
cd /CD/
cdrom /CD-ROM/
cello /チェロ/
cellulose /セルロース/
cent /セント/
center /センター/
centering /センタリング/
centi /センチ/
centre /センター/
century /センチュリー/
ceylon /セイロン/
chain /チェーン/
chair /チェア/
challenge /チャレンジ/
challenger /チャレンジャー/
chameleon /カメレオン/
champion /チャンピオン/
championship /チャンピオンシップ/
chance /チャンス/
change /チェンジ/
channel /チャンネル/チャネル/
chaos /カオス/
character /キャラクター/
charge /チャージ/
charleston /チャールストン/
charm /チャーム/
charming /チャーミング/
chart /チャート/
charter /チャーター/
cheap /チープ/
check /チェック/
checker /チェッカー/
checkin /チェックイン/
checkout /チェックアウト/
checkpoint /チェックポイント/
cheese /チーズ/
cheesecake /チーズケーキ/
chef /シェフ/
chemical /ケミカル/
cherry /チェリー/
chess /チェス/
chicago /シカゴ/
chicken /チキン/
chief /チーフ/
chime /チャイム/
chimera /キメラ/
china /チャイナ/
chinese /チャイニーズ/
chip /チップ/
chocolate /チョコレート/
choice /チョイス/
choke /チョーク/
chop /チョップ/
chopper /チョッパー/
chord /コード/
chordname /コードネーム/
chorus /コーラス/
christian /クリスチャン/
christmas /クリスマス/
church /チャーチ/
cinema /シネマ/
cinnamon /シナモン/
circle /サークル/
circuit /サーキット/
circus /サーカス/
cisc /CISC/
claim /クレーム/
clamp /クランプ/
class /クラス/
classic /クラシック/
clause /クローズ/
clean /クリーン/
cleaner /クリーナー/
cleaning /クリーニング/
clear /クリア/
client /クライアント/
climax /クライマックス/
clinic /クリニック/
clip /クリップ/
clock /クロック/
clone /クローン/
closeup /クローズアップ/
club /クラブ/倶楽部/
clutch /クラッチ/
coach /コーチ/
coaster /コースター/
coat /コート/
cobol /COBOL/
cocaine /コカイン/
cockpit /コックピット/
cocoa /ココア/
coda /コーダ/
code /コード/
coding /コーディング/
coffee /コーヒー/
coherent /コヒーレント/
coil /コイル/
coin /コイン/
cola /コーラ/
cold /コールド/
collectcall /コレクトコール/
collection /コレクション/
collector /コレクター/
college /カレッジ/
colon /コロン/
color /カラー/
colorado /コロラド/
colorful /カラフル/
colour /カラー/
columbia /コロンビア/
column /コラム/
combination /コンビネーション/
combo /コンボ/
comeback /カムバック/
comedian /コメディアン/
comedy /コメディー/喜劇/
comic /コミック/
comical /コミカル/
comma /カンマ/
command /コマンド/
comment /コメント/
commercial /コマーシャル/
commissioner /コミッショナー/
commit /コミット/
communication /コミュニケーション/
communist /コミュニスト/
compact /コンパクト/
companion /コンパニオン/
compatible /コンパチブル/
compile /コンパイル/
compiler /コンパイラー/
complex /コンプレックス/
component /コンポーネント/
computer /コンピューター/
concept /コンセプト/
concert /コンサート/
concerthall /コンサートホール/
concerto /コンチェルト/
concrete /コンクリート/
condenser /コンデンサー/
condition /コンディション/
condor /コンドル/
conductance /コンダクタンス/
connection /コネクション/
consensus /コンセンサス/
console /コンソール/
consortium /コンソーシアム/
constant /コンスタント/
consultant /コンサルタント/
contact /コンタクト/
container /コンテナ/
contents /コンテンツ/
contest /コンテスト/
context /コンテクスト/
contrast /コントラスト/
control /コントロール/
convenience /コンビニエンス/
convention /コンベンション/
conventional /コンベンショナル/
convert /コンバート/
cook /クック/
cookie /クッキー/
cooking /クッキング/
cooky /クッキー/
cool /クール/
cooler /クーラー/
coop /コープ/
coordinator /コーディネーター/
copy /コピー/
copyright /コピーライト/
cord /コード/
core /コア/
coretime /コアタイム/
corn /コーン/
corner /コーナー/
cornflakes /コーンフレーク/
corona /コロナ/
cosine /コサイン/
cosmos /コスモス/
cost /コスト/
counselor /カウンセラー/
count /カウント/
counter /カウンター/
country /カントリー/
couple /カップル/
coupling /カップリング/
coupon /クーポン/
course /コース/
court /コート/
cover /カバー/
cpu /CPU/
crack /クラック/
cracker /クラッカー/
cracking /クラッキング/
craft /クラフト/
crane /クレーン/
crash /クラッシュ/
crayon /クレヨン/
cream /クリーム/
create /クリエート/
credit /クレジット/
creditcard /クレジットカード/
croissant /クロワッサン/
cross /クロス/
crown /クラウン/
cruise /クルーズ/
cruiser /クルーザー/
crystal /クリスタル/
cuba /キューバ/
cue /キュー/
culture /カルチャー/
cup /カップ/
curl /カール/
curling /カーリング/
current /カレント/
curriculum /カリキュラム/
curry /カレー/
cursor /カーソル/
curtain /カーテン/
curve /カーブ/
cushion /クッション/
custom /カスタム/
cut /カット/
cute /キュート/
cutter /カッター/
cutting /カッティング/
cyborg /サイボーグ/
cycle /サイクル/
cyclotron /サイクロトロン/
cylinder /シリンダー/
cymbal /シンバル/
cyrillic /а/б/в/г/д/е/ё/ж/з/и/й/к/л/м/н/о/п/р/с/т/у/ф/х/ц/ч/ш/щ/ъ/ы/ь/э/ю/я/
dagger /ダガー/
damage /ダメージ/
damper /ダンパー/
dance /ダンス/
dancer /ダンサー/
dark /ダーク/
darwin /ダーウィン/
dash /ダッシュ/
data /データ/
database /データベース/
date /デート/
davinci /ダヴィンチ/
day /デー/
dead /デッド/
deadline /デッドライン/
deadlock /デッドロック/
dealer /ディーラー/
debug /デバッグ/
debut /デビュー/
deck /デッキ/
decoration /デコレーション/
default /デフォルト/
delicate /デリケート/
delta /δ/デルタ/
deluxe /デラックス/
demerit /デメリット/
democracy /デモクラシー/
demonstration /デモンストレーション/
denmark /デンマーク/
denver /デンヴァー/
design /デザイン/
designer /デザイナー/
desk /デスク/
detroit /デトロイト/
device /デバイス/
devil /デビル/
diagram /ダイアグラム/
dial /ダイアル/ダイヤル/
diamond /ダイアモンド/ダイヤモンド/
diesel /ディーゼル/
diet /ダイエット/
digest /ダイジェスト/
digital /ディジタル/デジタル/
dilemma /ジレンマ/
dimension /ディメンション/
dining /ダイニング/
dinner /ディナー/
diode /ダイオード/
direct /ダイレクト/
directmail /ダイレクトメール/
director /ディレクター/
disc /ディスク/
discount /ディスカウント/
discussion /ディスカッション/
disk /ディスク/
display /ディスプレー/
diving /ダイビング/
docking /ドッキング/
doctor /ドクター/
document /ドキュメント/
documentation /ドキュメンテーション/
doek /ズック/
dog /ドッグ/
dogfight /ドッグファイト/
dogmatic /ドグマチック/
dollar /ドル/ダラー/
dome /ドーム/
dominant /ドミナント/
dominion /ドミニオン/
domino /ドミノ/
door /ドア/
dortmund /ドルトムント/
dot /ドット/
double /ダブル/
doughnut /ドーナツ/
down /ダウン/
downtown /ダウンタウン/
dracula /ドラキュラ/
draft /ドラフト/
dragon /ドラゴン/
drama /ドラマ/
dramaturgie /ドラマツルギー/
drastic /ドラスティック/
draw /ドロー/
drawers /ズロース/
drawing /ドローイング/
dream /ドリーム/
dress /ドレス/
dressing /ドレッシング/
dribble /ドリブル/
drill /ドリル/
drink /ドリンク/
drip /ドリップ/
drive /ドライブ/
driver /ドライバー/
drop /ドロップ/
drug /ドラッグ/
drum /ドラム/
drummer /ドラマー/
dry /ドライ/
dubbing /ダビング/
duct /ダクト/
duet /デュエット/
dummy /ダミー/
dump /ダンプ/
dynamic /ダイナミック/
dynamism /ダイナミズム/
dynamite /ダイナマイト/
dynamo /ダイナモ/
earth /アース/
easy /イージー/
eccentric /エキセントリック/
echo /エコー/
ecology /エコロジー/
economist /エコノミスト/
economy /エコノミー/
eden /エデン/
edge /エッジ/
edinburgh /エディンバラ/
edition /エディション/
editor /エディター/
edward /エドワード/
effect /エフェクト/
egoism /エゴイズム/
egoist /エゴイスト/
egypt /エジプト/
eight /エイト/
electron /エレクトロン/
electronics /エレクトロニクス/
elegant /エレガント/
element /エレメント/
elementary /エレメンタリー/
elevator /エレベーター/
eleven /イレブン/
elf /エルフ/
elite /エリート/
elocution /エロキューション/
emblem /エンブレム/
emotion /エモーション/
emulation /エミュレーション/
enamel /エナメル/
encore /アンコール/
end /エンド/
endless /エンドレス/
endorphin /エンドルフィン/
energy /エナジー/
engine /エンジン/
engineer /エンジニア/
england /イングランド/
english /イングリッシュ/
enjoy /エンジョイ/
enquete /アンケート/
ensemble /アンサンブル/
entropy /エントロピー/
entry /エントリー/
epicurean /エピキュリアン/
epilogue /エピローグ/
episode /エピソード/
epoch /エポック/
equal /イコール/
erica /エリカ/
eros /エロス/
eroticism /エロチシズム/
error /エラー/
escalate /エスカレート/
escalator /エスカレーター/
escape /エスケープ/
escargot /エスカルゴ/
escort /エスコート/
eskimo /エスキモー/
essence /エッセンス/
essential /エッセンシャル/
estrogen /エストロゲン/
ethiopia /エチオピア/
ethnic /エスニック/
etiquette /エチケット/
etude /エチュード/
euclid /ユークリッド/
europa /欧羅巴/
eve /イヴ/イブ/
evening /イブニング/
event /イベント/
ever /エバー/
exchange /エクスチェンジ/
expert /エキスパート/
express /エクスプレス/
extra /エキストラ/
face /フェース/
facsimile /ファクシミリ/
fact /ファクト/
factor /ファクター/
fade /フェード/
fair /フェア/
family /ファミリー/
familyrestaurant /ファミリーレストラン/
fan /ファン/
fantasy /ファンタジー/
faraday /ファラデー/
fashion /ファッション/
fashionable /ファッショナブル/
fault /フォールト/
fax /ファックス/
feedback /フィードバック/
feeling /フィーリング/
feet /フィート/
feminism /フェミニズム/
fence /フェンス/
fender /フェンダー/
ferrite /フェライト/
ferry /フェリー/
festival /フェスティバル/
fetishism /フェティシズム/
fever /フィーバー/
fiance /フィアンセ/
fiancee /フィアンセ/
fiber /ファイバー/
fiction /フィクション/
field /フィールド/
fight /ファイト/
fighter /ファイター/
figure /フィギュア/
file /ファイル/
film /フィルム/
filter /フィルター/
final /ファイナル/
finance /ファイナンス/
finger /フィンガー/
finish /フィニッシュ/
finland /フィンランド/
fire /ファイア/
first /ファースト/
firstname /ファーストネーム/
fish /フィッシュ/
fit /フィット/
fitness /フィットネス/
fizz /フィズ/
flag /フラッグ/
flake /フレーク/
flange /フランジ/
flap /フラップ/
flash /フラッシュ/
flat /フラット/
flexible /フレキシブル/
flight /フライト/
flip /フリップ/
float /フロート/
floor /フロア/
florida /フロリダ/
flow /フロー/
flowchart /フローチャート/
flower /フラワー/
flute /フルート/
fly /フライ/
flying /フライング/
focus /フォーカス/
folk /フォーク/
folkdance /フォークダンス/
follow /フォロー/
font /フォント/
fool /フール/
foot /フット/
football /フットボール/
footwork /フットワーク/
force /フォース/
ford /フォード/
fork /フォーク/
form /フォーム/
formal /フォーマル/
format /フォーマット/
formation /フォーメーション/
forte /フォルテ/
forum /フォーラム/
forward /フォワード/
foundation /ファウンデーション/ファンデーション/
fourier /フーリエ/
fox /フォックス/
fractal /フラクタル/
fragment /フラグメント/
frame /フレーム/
framework /フレームワーク/
franc /フラン/
france /フランス/仏蘭西/
franchise /フランチャイズ/
frankenstein /フランケンシュタイン/
free /フリー/
french /フレンチ/
fresh /フレッシュ/
fret /フレット/
friedchicken /フライドチキン/
friend /フレンド/
front /フロント/
frontier /フロンティア/
fruit /フルーツ/
fruits /フルーツ/
frustration /フラストレーション/
fry /フライ/
full /フル/
fullname /フルネーム/
function /ファンクション/機能/
fund /ファンド/
funky /ファンキー/
fuse /ヒューズ/
fusion /フュージョン/
fuzzy /ファジー/
gag /ギャグ/
gain /ゲイン/
gal /ギャル/
gallery /ギャラリー/
gamble /ギャンブル/
gambler /ギャンブラー/
game /ゲーム/
gamma /γ/
gang /ギャング/
gap /ギャップ/
garage /ガレージ/
garden /ガーデン/
garnet /ガーネット/
gas /ガス/瓦斯/
gasoline /ガソリン/
gate /ゲート/
gather /ギャザー/
gauge /ゲージ/
gauss /ガウス/
gay /ゲイ/
gear /ギヤ/ギア/
gel /ゲル/
genom /ゲノム/
genre /ジャンル/
gentleman /ゼントルマン/
george /ジョージ/
georgia /ジョージア/
gestalt /ゲシュタルト/
gesture /ジェスチャー/
ghost /ゴースト/
gift /ギフト/
giga /ギガ/
girl /ガール/
glass /グラス/
glasswool /グラスウール/
glider /グライダー/
global /グローバル/
glue /グルー/
go /ゴー/
goal /ゴール/
gold /ゴールド/
golden /ゴールデン/
golf /ゴルフ/
golfer /ゴルファー/
gom /ゴム/
gong /ゴング/
good /グッド/
goods /グッズ/
gossip /ゴシップ/
gothic /ゴシック/
gourmet /グルメ/
grab /グラブ/
grade /グレード/
gram /グラム/
grammar /グラマー/
grand /グランド/
grandpiano /グランドピアノ/
grandprix /グランプリ/
grape /グレープ/
graph /グラフ/
graphic /グラフィック/
gray /グレイ/
great /グレート/
greek /α/β/γ/δ/ε/ζ/η/θ/ι/κ/λ/μ/ν/ξ/ο/π/ρ/σ/τ/υ/φ/χ/ψ/ω/
green /グリーン/
grey /グレー/
grid /グリッド/
grimm /グリム/
grip /グリップ/
ground /グラウンド/
group /グループ/
guard /ガード/
guardian /ガーディアン/
guest /ゲスト/
guidance /ガイダンス/
guide /ガイド/
guideline /ガイドライン/
guitar /ギター/
guitarist /ギタリスト/
gum /ガム/
gun /ガン/
gut /ガット/
guts /ガッツ/
gym /ジム/
gypsy /ジプシー/
gyro /ジャイロ/
h /エッチ/
hacker /ハッカー/
hair /ヘア/
half /ハーフ/
hall /ホール/
hamburger /ハンバーガー/
hammer /ハンマー/
hand /ハンド/
handbook /ハンドブック/
handkerchief /ハンカチーフ/
handle /ハンドル/
handling /ハンドリング/
hanger /ハンガー/
hanoi /ハノイ/
happening /ハプニング/
happy /ハッピー/
hard /ハード/
hardcopy /ハードコピー/
hardcover /ハードカバー/
harddisk /ハードディスク/
hardware /ハードウェア/
harmony /ハーモニー/
harp /ハープ/
hat /ハット/
hatch /ハッチ/
hatchback /ハッチバック/
hawaii /ハワイ/
head /ヘッド/
heading /ヘッディング/
headphone /ヘッドホン/
health /ヘルス/
hearing /ヒアリング/
heart /ハート/
heat /ヒート/
heater /ヒーター/
heavy /ヘビー/
heel /ヒール/
heights /ハイツ/
helicopter /ヘリコプター/
helium /ヘリウム/
helmet /ヘルメット/
helper /ヘルパー/
henry /ヘンリー/
herb /ハーブ/
hero /ヒーロー/
heroine /ヒロイン/
hertz /ヘルツ/
hetero /ヘテロ/
high /ハイ/
highlight /ハイライト/
highschool /ハイスクール/
hightech /ハイテク/
hiking /ハイキング/
hill /ヒル/
hint /ヒント/
hip /ヒップ/
histogram /ヒストグラム/
history /ヒストリー/
hit /ヒット/
hockey /ホッケー/
hold /ホールド/
holder /ホルダー/
hole /ホール/
holiday /ホリデー/
holography /ホログラフィー/
holon /ホロン/
home /ホーム/
homeless /ホームレス/
homeroom /ホームルーム/
homerun /ホームラン/
homesick /ホームシック/
homing /ホーミング/
homo /ホモ/
honeymoon /ハネムーン/
honolulu /ホノルル/
hook /フック/
hop /ホップ/
hope /ホープ/
hopper /ホッパー/
horizont /ホリゾント/
horn /ホーン/ホルン/
horror /ホラー/
hospice /ホスピス/
host /ホスト/
hot /ホット/
hotel /ホテル/
hour /アワー/
house /ハウス/
howling /ハウリング/
hudson /ハドソン/
human /ヒューマン/
humming /ハミング/
humour /ユーモア/
hunter /ハンター/
hunting /ハンティング/
hurricane /ハリケーン/
hybrid /ハイブリッド/
hydra /ヒドラ/
hypertext /ハイパーテキスト/
hyphen /ハイフン/
ice /アイス/
icebox /アイスボックス/
icecream /アイスクリーム/
icon /アイコン/
idea /アイディア/
identity /アイデンティティー/
idiom /イディオム/
idol /アイドル/
illinois /イリノイ/
illusion /イリュージョン/
illustration /イラストレーション/
image /イメージ/
imitation /イミテーション/
impact /インパクト/
impedance /インピーダンス/
impression /インプレッション/
impulse /インパルス/
in /イン/
inch /インチ/吋/
index /インデックス/
indexation /インデクセーション/
india /インド/
indian /インディアン/
indonesia /インドネシア/
inductance /インダクタンス/
induction /インダクション/
industrial /インダストリアル/
inflation /インフレーション/
information /インフォメーション/情報/
infrastructure /インフラストラクチャー/
ink /インク/
inner /インナー/
input /インプット/
insert /インサート/
insertion /インサーション/
inside /インサイド/
insider /インサイダー/
inspiration /インスピレーション/
install /インストール/
instant /インスタント/
instructor /インストラクター/
integration /インテグレーション/
intellectual /インテレクチュアル/
intercept /インターセプト/
interface /インターフェース/
interferon /インターフェロン/
intern /インターン/
international /インターナショナル/
internet /インターネット/
interpol /インターポール/
interval /インターバル/
interview /インタビュー/
intonation /イントネーション/
introduction /イントロダクション/
inverter /インバーター/
invoice /インボイス/
ion /イオン/
iowa /アイオワ/
iraq /イラク/
ireland /アイルランド/
iron /アイアン/
irony /アイロニー/
irregular /イレギュラー/
iso /ISO/
israel /イスラエル/
italia /イタリア/
italic /イタリック/
item /アイテム/
ivy /アイビー/
jack /ジャック/
jacket /ジャケット/
jam /ジャム/
japan /ジャパン/
japanese /ジャパニーズ/
jazz /ジャズ/
jeans /ジーンズ/
jeep /ジープ/
jelly /ゼリー/
jesus /イエス/イエズス/
jet /ジェット/
jig /ジグ/
jigsaw /ジグソー/
jinx /ジンクス/
job /ジョブ/
jogging /ジョギング/
john /ジョン/
joint /ジョイント/
joke /ジョーク/
joker /ジョーカー/
jordan /ジョルダン/
journal /ジャーナル/
judge /ジャッジ/
juice /ジュース/
jukebox /ジュークボックス/
jumbo /ジャンボ/
jump /ジャンプ/
jumper /ジャンパー/
jungle /ジャングル/
junior /ジュニア/
junk /ジャンク/
jupiter /ジュピター/
just /ジャスト/
keep /キープ/
keeper /キーパー/
kentucky /ケンタッキー/
kenya /ケニア/
key /キー/
keyboard /キーボード/
keyword /キーワード/
kick /キック/
kickoff /キックオフ/
kid /キッド/
kilo /キロ/
king /キング/
kiosk /キオスク/
kiss /キス/キッス/
kit /キット/
kitchen /キッチン/
knife /ナイフ/
knight /ナイト/
knob /ノブ/
knock /ノック/
knot /ノット/節/
knowhow /ノウハウ/
koala /コアラ/
label /ラベル/レーベル/
lady /レディー/
lamp /ランプ/
lan /LAN/
landing /ランディング/
landscape /ランドスケープ/
lane /レーン/
language /ランゲージ/
lantern /ランタン/
lap /ラップ/
laptop /ラップトップ/
laser /レーザー/
laserdisk /レーザーディスク/
last /ラスト/
latin /ラテン/
laundry /ランドリー/
lavender /ラベンダー/
layout /レイアウト/
lead /リード/
leader /リーダー/
leadership /リーダーシップ/
league /リーグ/
lease /リース/
leather /レザー/
left /レフト/
leghorn /レグホーン/
lemon /レモン/檸檬/
lens /レンズ/
lesson /レッスン/
let /レット/
letter /レター/
lettering /レタリング/
level /レベル/
lever /レバー/
library /ライブラリー/
licence /ライセンス/
license /ライセンス/
life /ライフ/
lifework /ライフワーク/
lift /リフト/
light /ライト/
lighter /ライター/
lilliput /リリパット/
lime /ライム/
limit /リミット/
line /ライン/
liner /ライナー/
lineup /ラインアップ/
link /リンク/
linkage /リンケージ/
lion /ライオン/
lip /リップ/
lisp /リスプ/
list /リスト/
lithium /リチウム/
litre /リットル/
live /ライブ/
liver /レバー/
living /リビング/
load /ロード/
loan /ローン/
lobby /ロビー/
local /ローカル/
location /ロケーション/
lock /ロック/
locker /ロッカー/
lockout /ロックアウト/
lodge /ロッジ/
logic /ロジック/論理/
logical /ロジカル/
logo /ロゴ/
logos /ロゴス/
london /ロンドン/
long /ロング/
looks /ルックス/
loop /ループ/
loose /ルーズ/
loss /ロス/
lot /ロット/
lotus /ロータス/
lounge /ラウンジ/
love /ラブ/
loveletter /ラブレター/
low /ロー/
lucky /ラッキー/
lunch /ランチ/
lupe /ルーペ/
lute /リュート/
macaroni /マカロニ/
machine /マシン/マシーン/
macro /マクロ/
madonna /マドンナ/
mafia /マフィア/
magazine /マガジン/
magenta /マゼンタ/
magic /マジック/
magma /マグマ/
magnet /マグネット/
magnetic /マグネチック/
mail /メール/
main /メイン/メーン/
maintenance /メンテナンス/
maison /メゾン/
major /メジャー/
make /メーク/
maker /メーカー/
makeup /メーキャップ/
mall /モール/
mama /ママ/
mambo /マンボ/
manage /マネージ/
management /マネージメント/
manager /マネージャー/
mandrill /マンドリル/
mania /マニア/
manicure /マニキュア/
mannequin /マヌカン/マネキン/
manner /マナー/
manpower /マンパワー/
mansion /マンション/
mantle /マントル/
manual /マニュアル/
map /マップ/
mapping /マッピング/
marathon /マラソン/
marble /マーブル/
march /マーチ/
margin /マージン/
marie /マリー/
mark /マーク/マルク/
market /マーケット/
marketing /マーケティング/
marshall /マーシャル/
mart /マート/
maryland /メリーランド/
mascara /マスカラ/
mascot /マスコット/
mask /マスク/
masochism /マゾヒズム/
masochist /マゾヒスト/
mass /マス/
massage /マッサージ/
massmedia /マスメディア/
mast /マスト/
master /マスター/
masturbation /マスターベーション/
mat /マット/
match /マッチ/
matrix /マトリックス/
mayday /メーデー/
mayonnaise /マヨネーズ/
meat /ミート/
mechanic /メカニック/
mechanical /メカニカル/
mechanism /メカニズム/
medal /メダル/
media /メディア/
medium /ミディアム/
medley /メドレー/
meeting /ミーティング/
mega /メガ/
meistersinger /マイスタージンガー/
melody /メロディー/
melon /メロン/
meltdown /メルトダウン/
member /メンバー/
membership /メンバーシップ/
memo /メモ/
memorandum /メモランダム/
memorial /メモリアル/
memory /メモリー/
mental /メンタル/
menu /メニュー/
mercury /マーキュリー/
merit /メリット/
merry /メリー/
merrychristmas /メリークリスマス/
mesh /メッシュ/
message /メッセージ/
messe /メッセ/
meta /メタ/
metal /メタル/
metamorphose /メタモルフォーゼ/
metaphor /メタファー/
meter /メートル/メーター/
method /メソッド/
metric /メトリック/
metro /メトロ/
mexico /メキシコ/
miami /マイアミ/
michigan /ミシガン/
micro /マイクロ/ミクロ/
micron /ミクロン/
microphone /マイクロフォン/
middle /ミドル/
midnight /ミッドナイト/
mild /マイルド/
mile /マイル/
milestone /マイルストーン/
milk /ミルク/
mill /ミル/
milli /ミリ/
mineral /ミネラル/
mini /ミニ/
minimum /ミニマム/
miniskirt /ミニスカート/
minor /マイナー/
mint /ミント/
minus /マイナス/
mips /MIPS/
miracle /ミラクル/
mirror /ミラー/
mis /ミス/
miscast /ミスキャスト/
miss /ミス/
missile /ミサイル/
mission /ミッション/
mister /ミスター/
mit /MIT/
mix /ミックス/
mixer /ミキサー/
mobile /モビール/
mocha /モカ/
mode /モード/
model /モデル/
modelling /モデリング/
modem /モデム/
modern /モダン/
module /モジュール/
moire /モアレ/
mol /モル/
moment /モーメント/
monad /モナド/
money /マネー/
mongol /モンゴル/
monitor /モニター/
monkey /モンキー/
monograph /モノグラフ/
monomer /単量体/
monopoly /モノポリー/
monorail /モノレール/
monotone /モノトーン/
monster /モンスター/
montage /モンタージュ/
montecarlo /モンテカルロ/
mood /ムード/
moon /ムーン/
moonlight /ムーンライト/
moore /ムーア/
moral /モラル/
morning /モーニング/
mosaic /モザイク/
motel /モーテル/
mother /マザー/
motif /モティーフ/
motion /モーション/
motivation /モチベーション/
motor /モーター/
mount /マウント/
movie /ムービー/
ms-dos /MS-DOS/
msdos /MS-DOS/
mu /μ/
muffler /マフラー/
muller /ミュラー/
multi /マルチ/
multimedia /マルチメディア/
music /ミュージック/
musical /ミュージカル/
musician /ミュージシャン/
my /マイ/
mysterious /ミステリアス/
mystery /ミステリー/
naive /ナイーブ/
name /ネーム/
naming /ネーミング/
narration /ナレーション/
narrator /ナレーター/
nasa /NASA/
national /ナショナル/
natural /ナチュラル/
naturalist /ナチュラリスト/
navigator /ナビゲーター/
nebula /ネビュラ/
neck /ネック/
necktie /ネクタイ/
needs /ニーズ/
negative /ネガティブ/
negotiation /ネゴシエーション/
neon /ネオン/
nervous /ナーバス/
net /ネット/
network /ネットワーク/
networking /ネットワーキング/
neuro /ニューロ/
neuron /ニューロン/
neutral /ニュートラル/
new /ニュー/
newmedia /ニューメディア/
news /ニュース/
newton /ニュートン/
newyork /ニューヨーク/
newzealand /ニュージーランド/
next /ネクスト/
nice /ナイス/ニース/
nicholas /ニコラス/
nickel /ニッケル/
nickname /ニックネーム/
night /ナイト/
nihil /ニヒル/
nihilism /ニヒリズム/
nihilist /ニヒリスト/
nine /ナイン/
no /ノー/
nocomment /ノーコメント/
node /ノード/
noise /ノイズ/
non /ノン/
nonsense /ナンセンス/
norma /ノルマ/
normal /ノーマル/
norway /諾威/ノルウェー/
notch /ノッチ/
note /ノート/
notebook /ノートブック/
novel /ノベル/
ntt /NTT/
nuance /ニュアンス/
nude /ヌード/
number /ナンバー/
numbering /ナンバリング/
nuts /ナッツ/
nymph /ニンフ/
oasis /オアシス/
object /オブジェクト/
observer /オブザーバー/
ocarina /オカリナ/
ocean /オーシャン/
octave /オクターブ/
octet /オクテット/
off /オフ/
offense /オフェンス/
office /オフィス/
official /オフィシャル/
offline /オフライン/
offset /オフセット/
ohm /オーム/
oil /オイル/
ok /オーケー/
old /オールド/
olive /オリーブ/
olympic /オリンピック/
omega /ω/オメガ/
omnibus /オムニバス/
on /オン/
one /ワン/
online /オンライン/
only /オンリー/
ontario /オンタリオ/
opal /オパール/
open /オープン/
opening /オープニング/
opera /オペラ/
operatingsystem /オペレーティングシステム/
operation /オペレーション/
operator /オペレーター/演算子/
option /オプション/
orange /オレンジ/
orchestra /オーケストラ/
order /オーダー/
oregon /オレゴン/
oriental /オリエンタル/
orientation /オリエンテーション/
orifice /オリフィス/
origin /オリジン/
original /オリジナル/
orion /オリオン/
orthodox /オーソドックス/
os /OS/
oscar /オスカー/
oscilloscope /オシロスコープ/
oslo /オスロ/
othello /オセロ/
out /アウト/
outdoor /アウトドア/
outlaw /アウトロー/
outline /アウトライン/
output /アウトプット/出力/
outsider /アウトサイダー/
oven /オーブン/
over /オーバー/
overcoat /オーバーコート/
overflow /オーバーフロー/
overlap /オーバーラップ/
owner /オーナー/
oxford /オックスフォード/
oxygen /酸素/
pace /ペース/
pack /パック/
package /パッケージ/
packet /パケット/
packing /パッキング/
pad /パッド/
page /ページ/頁/
paint /ペイント/
pair /ペア/
pajamas /パジャマ/
pakistan /パキスタン/
palace /パレス/
palette /パレット/
pallet /パレット/
pamphlet /パンフレット/
pan /パン/
panda /パンダ/
pandora /パンドラ/
panel /パネル/
paneldiscussion /パネルディスカッション/
panelist /パネリスト/
panic /パニック/
panorama /パノラマ/
pansy /パンジー/
pantograph /パンタグラフ/
pants /パンツ/
papa /パパ/
paper /ペーパー/
paperback /ペーパーバック/
para /パラ/
parade /パレード/
paradigm /パラダイム/
paradise /パラダイス/
paradox /パラドックス/
paragraph /パラグラフ/
parallel /パラレル/
parameter /パラメーター/
paranoia /パラノイア/
paraphrase /パラフレーズ/
paris /パリ/
park /パーク/
parking /パーキング/
parody /パロディー/
parsec /パーセク/
parsley /パセリ/
part /パート/
partner /パートナー/
parts /パーツ/
party /パーティー/
pasadena /パサデナ/
pascal /パスカル/
pass /パス/
passing /パッシング/
passive /パッシブ/
passport /パスポート/
paste /ペースト/
pastel /パステル/
patch /パッチ/
patrol /パトロール/
patron /パトロン/
pattern /パターン/
pause /ポーズ/
pay /ペイ/
peace /ピース/
peak /ピーク/
peanuts /ピーナッツ/
pearl /パール/
pedal /ペダル/
pen /ペン/
penalty /ペナルティー/
pendant /ペンダント/
pending /ペンディング/
penguin /ペンギン/
penname /ペンネーム/
pennant /ペナント/
penny /ペニー/
pentagon /ペンタゴン/
percent /パーセント/
percentage /パーセンテージ/
percussion /パーカッション/
performance /パフォーマンス/
period /ピリオド/
personal /パーソナル/
perspective /パースペクティブ/
peru /ペルー/
pet /ペット/
peter /ピーター/
pheromone /フェロモン/
philadelphia /フィラデルフィア/
phoenix /フェニックス/
photo /フォト/
phrase /フレーズ/
physical /フィジカル/
pi /π/パイ/
pianist /ピアニスト/
piano /ピアノ/
pick /ピック/
pickup /ピックアップ/
pie /パイ/
pill /ピル/
pilot /パイロット/
pin /ピン/
pinch /ピンチ/
pine /パイン/
pineapple /パイナップル/
pingpong /ピンポン/
pink /ピンク/
pioneer /パイオニア/
pipe /パイプ/
pipeline /パイプライン/
pipeorgan /パイプオルガン/
pistol /ピストル/
piston /ピストン/
pit /ピット/
pitch /ピッチ/
pitcher /ピッチャー/
pitching /ピッチング/
pivot /ピボット/
pizza /ピザ/
place /プレース/
plain /プレーン/
plan /プラン/
plankton /プランクトン/
planner /プランナー/
planning /プランニング/
plant /プラント/
planter /プランター/
plasma /プラズマ/
plastic /プラスチック/
plate /プレート/
platform /プラットホーム/
platon /プラトン/
play /プレー/
player /プレーヤー/
plaza /プラザ/
please /プリーズ/
pleats /プリーツ/
plot /プロット/
plug /プラグ/
plus /プラス/
pocket /ポケット/
point /ポイント/
pointer /ポインター/
poker /ポーカー/
poland /ポーランド/
pole /ポール/
policy /ポリシー/
polymer /ポリマー/重合体/
polyphony /ポリフォニー/
polypropylene /ポリプロピレン/
pony /ポニー/
pool /プール/
poppy /ポピー/
pops /ポップス/
popular /ポピュラー/
port /ポート/
portable /ポータブル/
portfolio /ポートフォリオ/
portrait /ポートレート/
portugal /ポルトガル/
pose /ポーズ/
position /ポジション/
post /ポスト/
poster /ポスター/
pot /ポット/
potatochip /ポテトチップ/
potential /ポテンシャル/
pound /ポンド/パウンド/
powder /パウダー/
power /パワー/
powerful /パワフル/
practical /プラクティカル/
prefab /プレハブ/
prelude /プレリュード/
present /プレゼント/
press /プレス/
pressure /プレッシャー/
price /プライス/
pride /プライド/
primitive /プリミティブ/
prince /プリンス/
princess /プリンセス/
print /プリント/
printer /プリンター/
prism /プリズム/
privacy /プライバシー/
private /プライベート/
process /プロセス/
procyon /プロキオン/
produce /プロデュース/
producer /プロデューサー/
product /プロダクト/
production /プロダクション/
professional /プロフェッショナル/
profile /プロフィール/
program /プログラム/
programmer /プログラマー/
programming /プログラミング/
project /プロジェクト/
projector /プロジェクター/
prologue /プロローグ/
promotion /プロモーション/
prompt /プロンプト/
propaganda /プロパガンダ/
proper /プロパー/
proportion /プロポーション/
propose /プロポーズ/
protect /プロテクト/
protestant /プロテスタント/
protocol /プロトコル/
pub /パブ/
public /パブリック/
publicity /パブリシティ/
pulp /パルプ/
pulse /パルス/
punch /パンチ/
puncher /パンチャー/
pure /ピュア/
purge /パージ/
push /プッシュ/
puzzle /パズル/
pyramid /ピラミッド/
quartette /カルテット/
queen /クイーン/
question /クエスチョン/
quick /クイック/
quiz /クイズ/
quota /クォータ/
quotation /クォーテーション/
r /アール/
r&d /Ｒ＆Ｄ/
race /レース/
racer /レーサー/
rack /ラック/
racket /ラケット/
radar /レーダー/
radian /ラジアン/
radio /ラジオ/
ragtime /ラグタイム/
rail /レール/
rally /ラリー/
ram /RAM/
ramp /ランプ/
random /ランダム/
range /レンジ/
rank /ランク/
ranking /ランキング/
rare /レア/
raster /ラスター/
rat /ラット/
rate /レート/
ray /レイ/
reach /リーチ/
reaction /リアクション/
reader /リーダー/
reading /リーディング/
real /リアル/
realtime /リアルタイム/
reasonable /リーズナブル/
recall /リコール/
receipt /レシート/
receive /レシーブ/
reception /レセプション/
record /レコード/
recorder /レコーダー/
recording /レコーディング/
recreation /レクリエーション/
recruit /リクルート/
recycle /リサイクル/
red /レッド/
reel /リール/
referee /レフェリー/
reference /リファレンス/
refine /リファイン/
reflector /リフレクター/
reform /リフォーム/
refrain /リフレイン/
refresh /リフレッシュ/
register /レジスター/
regular /レギュラー/
rehabilitation /リハビリテーション/
rehearsal /リハーサル/
relation /リレーション/
relax /リラックス/
relay /リレー/
release /リリース/
remote /リモート/
rentacar /レンタカー/
rental /レンタル/
repeat /リピート/
report /レポート/リポート/
reporter /レポーター/
request /リクエスト/
requiem /レクイエム/
research /リサーチ/
reserve /リザーブ/
reset /リセット/
resort /リゾート/
restaurant /レストラン/
resume /レジュメ/
retire /リタイア/
review /レビュー/
revival /リバイバル/
rewrite /リライト/
rhythm /リズム/
ribbon /リボン/
ribosome /リボソーム/
rice /ライス/
rich /リッチ/
richard /リチャード/
rider /ライダー/
right /ライト/
ring /リング/
rinse /リンス/
risc /リスク/RISC/
risk /リスク/
rival /ライバル/
road /ロード/
roaster /ロースター/
robin /ロビン/
robot /ロボット/
rock /ロック/
rocket /ロケット/
roll /ロール/
roller /ローラー/
rolling /ローリング/
rom /ロム/ROM/
roma /ローマ/羅馬/
roman /ロマン/
romance /ロマンス/
romania /ルーマニア/
roof /ルーフ/
room /ルーム/
roomservice /ルームサービス/
root /ルート/
roots /ルーツ/
rope /ロープ/
rose /ローズ/
rosemary /ローズマリー/
rotary /ロータリー/
rotation /ローテーション/
rouge /ルージュ/
rough /ラフ/
round /ラウンド/
route /ルート/
routine /ルーチン/
royal /ロイヤル/
rubber /ラバー/
ruby /ルビー/
rugby /ラグビー/
rule /ルール/
run /ラン/
runner /ランナー/
running /ランニング/
rush /ラッシュ/
s /エス/
saddle /サドル/
sadism /サディズム/
sadist /サディスト/
safe /セーフ/
sage /セージ/
sailor /セーラー/
saison /セゾン/
salad /サラダ/
salary /サラリー/
sale /セール/
sales /セールス/
salesman /セールスマン/
salmon /サーモン/
sample /サンプル/
sampling /サンプリング/
sand /サンド/
sandal /サンダル/
sandwich /サンドイッチ/
sanfrancisco /サンフランシスコ/
sausage /ソーセージ/
save /セーブ/
sax /サックス/
scalar /スカラー/
scale /スケール/
scandal /スキャンダル/
scenario /シナリオ/
scene /シーン/
schedule /スケジュール/
school /スクール/
science /サイエンス/
score /スコア/
scotch /スコッチ/
scott /スコット/
scramble /スクランブル/
scrap /スクラップ/
scratch /スクラッチ/
screen /スクリーン/
script /スクリプト/
scroll /スクロール/
scuba /スキューバ/
seafood /シーフード/
seal /シール/
seamless /シームレス/
search /サーチ/
season /シーズン/
seat /シート/
seattle /シアトル/
second /セカンド/
sect /セクト/
section /セクション/
sectionalism /セクショナリズム/
sector /セクター/
sedan /セダン/
seed /シード/
segment /セグメント/
select /セレクト/
selection /セレクション/
self /セルフ/
selfservice /セルフサービス/
semi /セミ/
semicolon /セミコロン/
seminar /セミナー/
senior /シニア/
sensational /センセーショナル/
sense /センス/
sensor /センサー/
sentence /センテンス/
seoul /ソウル/
sequence /シーケンス/シークエンス/
serge /サージ/
series /シリーズ/
serious /シリアス/
server /サーバー/
service /サービス/
session /セッション/
set /セット/
setting /セッティング/
seven /セブン/
severe /シビア/
sex /セックス/
sexual /性的/
sexy /セクシー/
sgml /SGML/
shadow /シャドー/
shaft /シャフト/
shampoo /シャンプー/
shanghai /シャンハイ/上海/
share /シェア/
sharp /シャープ/
shaver /シェーバー/
sheet /シート/
shell /シェル/
shelter /シェルター/
shepherd /シェパード/
sherbet /シャーベット/
shield /シールド/
shift /シフト/
ship /シップ/
shirt /シャツ/
shock /ショック/
shocking /ショッキング/
shoes /シューズ/
shoot /シュート/
shop /ショップ/
shopping /ショッピング/
short /ショート/
shorts /ショーツ/
shot /ショット/
show /ショー/
shower /シャワー/
shuffle /シャッフル/
shutter /シャッター/
shy /シャイ/
side /サイド/
sigma /σ/シグマ/
sign /サイン/
signal /シグナル/
silhouette /シルエット/
silicon /シリコン/
silk /シルク/
silver /シルバー/
simple /シンプル/
simulation /シミュレーション/
simulator /シミュレーター/
sine /サイン/
singapore /シンガポール/
singer /シンガー/
singersongwriter /シンガーソングライター/
single /シングル/
siren /サイレン/
sitar /シタール/
situation /シチュエーション/
size /サイズ/
skate /スケート/
skeleton /スケルトン/
sketch /スケッチ/
ski /スキー/
skier /スキーヤー/
skill /スキル/
skip /スキップ/
skirt /スカート/
sky /スカイ/
skyline /スカイライン/
slacks /スラックス/
slash /スラッシュ/
slice /スライス/
slide /スライド/
slider /スライダー/
sliding /スライディング/
slim /スリム/
slime /スライム/
slip /スリップ/
slipper /スリッパ/
slit /スリット/
slogan /スローガン/
slope /スロープ/
slot /スロット/
slow /スロー/
slump /スランプ/
smalltalk /Smalltalk/
smart /スマート/
smile /スマイル/
smog /スモッグ/
smooth /スムーズ/
snack /スナック/
snap /スナップ/
snapshot /スナップショット/
sneaker /スニーカー/
snob /スノッブ/
snow /スノー/
soap /ソープ/
soccer /サッカー/
social /ソーシャル/
socket /ソケット/
socks /ソックス/
soda /ソーダ/
soft /ソフト/
softball /ソフトボール/
software /ソフトウェア/
sole /ソール/
solenoid /ソレノイド/
solid /ソリッド/
soliton /ソリトン/
solo /ソロ/
sommelier /ソムリエ/
sonar /ソナー/
sonata /ソナタ/
song /ソング/
sophia /ソフィア/
soprano /ソプラノ/
sort /ソート/
soul /ソウル/
sound /サウンド/
soup /スープ/
source /ソース/
space /スペース/
spade /スペード/
spaghetti /スパゲッティ/
spain /スペイン/
span /スパン/
spare /スペア/
spark /スパーク/
speaker /スピーカー/
special /スペシャル/
specialist /スペシャリスト/
speech /スピーチ/
speed /スピード/
speedup /スピードアップ/
spell /スペル/
spelling /スペリング/
spice /スパイス/
spike /スパイク/
spin /スピン/
spindle /スピンドル/
spiral /スパイラル/
spirit /スピリット/
sponge /スポンジ/
sponsor /スポンサー/
spool /スプール/
spoon /スプーン/
sport /スポーツ/
sports /スポーツ/
sportsman /スポーツマン/
spot /スポット/
spray /スプレー/
spring /スプリング/
sprinkler /スプリンクラー/
spur /シュプール/
spy /スパイ/
squeeze /スクイズ/
srilanka /スリランカ/
staff /スタッフ/
stage /ステージ/
stainless /ステンレス/
stamp /スタンプ/
stance /スタンス/
stand /スタンド/
standard /スタンダード/
star /スター/
start /スタート/
starter /スターター/
starting /スターティング/
state /ステート/
statement /ステートメント/
static /スタティック/
station /ステーション/
status /ステータス/
steak /ステーキ/
steel /スチール/
steering /ステアリング/
step /ステップ/
stereo /ステレオ/
stereotype /ステレオタイプ/
stew /シチュー/
stewardess /スチュワーデス/
stick /スティック/
sticker /ステッカー/
still /スチル/スチール/
stock /ストック/
stockholm /ストックホルム/
stoic /ストイック/
stop /ストップ/
stopper /ストッパー/
stopwatch /ストップウォッチ/
store /ストア/
storm /ストーム/
story /ストーリー/
stove /ストーブ/
straight /ストレート/
strap /ストラップ/
street /ストリート/
stress /ストレス/
strike /ストライキ/ストライク/
string /ストリング/
strings /ストリングス/
strip /ストリップ/
stripe /ストライプ/
stroke /ストローク/
stud /スタッド/
studio /スタジオ/
stuff /スタッフ/
style /スタイル/
sub /サブ/
subject /サブジェクト/
submarine /サブマリン/
subtitle /サブタイトル/
sugar /シュガー/
suggest /サジェスト/
suggestion /サジェスチョン/
suit /スーツ/
suitcase /スーツケース/
summer /サマー/
sun /サン/
sunday /サンデー/
sunglass /サングラス/
super /スーパー/
supercomputer /スーパーコンピューター/
superman /スーパーマン/
supermarket /スーパーマーケット/
support /サポート/
supporter /サポーター/
survival /サバイバル/
suspense /サスペンス/
suspension /サスペンション/
swap /スワップ/
sweat /スウェット/
sweater /セーター/
sweden /スウェーデン/
sweeper /スイーパー/
sweet /スイート/スウィート/
swimming /スイミング/
swing /スウィング/
switch /スイッチ/
symbol /シンボル/
symphony /シンフォニー/
symposium /シンポジウム/
synapse /シナプス/
syndrome /シンドローム/
syntax /シンタックス/
system /システム/
tabaco /タバコ/
table /テーブル/
tablet /タブレット/
taboo /タブー/
tackle /タックル/
tail /テール/
take /テイク/
talent /タレント/
tandem /タンデム/
tank /タンク/
tannin /タンニン/
tap /タップ/
tape /テープ/
target /ターゲット/
task /タスク/
taskforce /タスクフォース/
tautology /トートロジー/
tax /タックス/
taxi /タクシー/
tea /ティー/
team /チーム/
technic /テクニック/
technical /テクニカル/
technique /テクニック/
technology /テクノロジー/
tee /ティー/
teenager /ティーンエージャー/
teflon /テフロン/
telemark /テレマーク/
telemeter /テレメーター/
telephone /テレフォン/
teleport /テレポート/
teletype /テレタイプ/
television /テレビジョン/
tempo /テンポ/
ten /テン/
tenant /テナント/
tennis /テニス/
tension /テンション/
tensor /テンソル/
tent /テント/
term /ターム/
terminal /ターミナル/
territory /テリトリー/
terrorist /テロリスト/
test /テスト/
testcase /テストケース/
tester /テスター/
texas /テキサス/
text /テキスト/
thai /タイ/
thailand /タイ/
thema /テーマ/
theory /セオリー/
thesaurus /シソーラス/
third /サード/
thomas /トマス/
thomson /トムソン/
three /スリー/
thrill /スリル/
thrilling /スリリング/
thyme /タイム/
ticket /チケット/
tie /タイ/
tiger /タイガー/
tight /タイト/
tile /タイル/
time /タイム/
timecard /タイムカード/
timely /タイムリー/
timeout /タイムアウト/
timer /タイマー/
timing /タイミング/
tip /チップ/
tire /タイヤ/
tirol /チロル/
titan /タイタン/
title /タイトル/
toilet /トイレット/
tomato /トマト/
tone /トーン/
toner /トナー/
tool /ツール/
top /トップ/
topic /トピック/
topping /トッピング/
torque /トルク/
torus /トーラス/
total /トータル/
touch /タッチ/
tough /タフ/
tour /ツアー/
touring /ツーリング/
tournament /トーナメント/
towel /タオル/
tower /タワー/
town /タウン/
trace /トレース/
track /トラック/
trad /トラッド/
trade /トレード/
trademark /トレードマーク/
training /トレーニング/
tramp /トランプ/
transceiver /トランシーバー/
transfer /トランスファー/
translation /トランスレーション/
transport /トランスポート/
trap /トラップ/
travel /トラベル/
traverse /トラバース/
tray /トレイ/
tree /ツリー/
trend /トレンド/
trial /トライアル/
triangle /トライアングル/
trick /トリック/
tricky /トリッキー/
trim /トリム/
trimming /トリミング/
trio /トリオ/
trip /トリップ/
trouble /トラブル/
troy /トロイ/
truck /トラック/
trump /トランプ/
trumpet /トランペット/
trunk /トランク/
trunks /トランクス/
trust /トラスト/
try /トライ/
tuba /チューバ/
tube /チューブ/
tulip /チューリップ/
tuna /ツナ/
tuner /チューナー/
tuning /チューニング/
tunnel /トンネル/
turbine /タービン/
turbo /ターボ/
turingmachine /チューリングマシン/
turn /ターン/
tutor /チューター/
tuxedo /タキシード/
tweed /ツイード/
twin /ツイン/
twist /ツイスト/
two /ツー/
type /タイプ/
ultra /ウルトラ/
unbalance /アンバランス/
underline /アンダーライン/
unfair /アンフェア/
uniform /ユニフォーム/
union /ユニオン/
unique /ユニーク/
unit /ユニット/
universal /ユニバーサル/
unix /UNIX/ユニックス/
untouchable /アンタッチャブル/
up /アップ/
urban /アーバン/
user /ユーザー/
utility /ユーティリティー/
utopia /ユートピア/
value /バリュー/
valve /バルブ/
vanilla /バニラ/
variation /バリエーション/
vector /ベクター/
vega /ベガ/
veil /ベール/
venture /ベンチャー/
venus /ヴィーナス/
versailles /ベルサイユ/ヴェルサイユ/
version /バージョン/
vest /ベスト/
veteran /ベテラン/ヴェテラン/
vibrato /ビブラート/
victor /ビクター/
victoria /ビクトリア/
video /ビデオ/
videotape /ビデオテープ/
videotex /ビデオテックス/
vietnam /ベトナム/
villa /ビラ/
vinyl /ビニール/
viola /ヴィオラ/
virus /ビールス/
visa /ビザ/
vision /ビジョン/
vista /ビスタ/
visual /ビジュアル/
vitamin /ビタミン/
vitamine /ビタミン/
vocal /ボーカル/
voice /ボイス/
volt /ボルト/
voltage /ボルテージ/
volume /ボリューム/
volunteer /ボランティア/
wagner /ワグナー/
wagon /ワゴン/
waist /ウェスト/
waiver /ウェーバー/
walk /ウォーク/
washington /ワシントン/
watch /ウォッチ/
watching /ウォッチング/
water /ウォーター/
waterproof /ウォータープルーフ/
watson /ワトソン/
wave /ウェーブ/
wax /ワックス/
wear /ウェア/
webster /ウェブスター/
wedding /ウェディング/
weddingdress /ウェディングドレス/
week /ウィーク/
weekly /ウィークリー/
well-done /ウェルダン/
western /ウェスタン/
wet /ウェット/
wheel /ホイール/
whiskey /ウィスキー/
whisky /ウィスキー/
whistle /ホイッスル/
white /ホワイト/
wide /ワイド/
wild /ワイルド/
winch /ウィンチ/
wine /ワイン/
wineglass /ワイングラス/
wink /ウィンク/
winker /ウィンカー/
winter /ウィンター/
wiper /ワイパー/
wire /ワイヤ/
wireless /ワイヤレス/
woman /ウーマン/
wood /ウッド/
wool /ウール/
word /ワード/
work /ワーク/
workbook /ワークブック/
worker /ワーカー/
workshop /ワークショップ/
workstation /ワークステーション/
world /ワールド/
worst /ワースト/
wrap /ラップ/
writer /ライター/
x /エックス/
xerox /ゼロックス/
yacht /ヨット/
yard /ヤード/
yellow /イエロー/
yes /イエス/
yoga /ヨガ/
you /ユー/
young /ヤング/
zarathustra /ツァラトゥストラ/
zephyr /ゼファー/
zero /ゼロ/
zone /ゾーン/
zoom /ズーム/
zoomin /ズームイン/
zoomout /ズームアウト/
あ /阿/唖/亜/娃/
ああ /嗚呼/噫/
あい /愛/哀/相/藍/埃/間/挨/合/
あいあいがさ /相合傘/
あいいく /愛育/
あいいろ /藍色/
あいいん /愛飲/合印/
あいうち /相討ち/相打ち/
あいえ /藍絵/
あいえんか /愛煙家/
あいおい /相生/
あいか /哀歌/
あいかぎ /合鍵/
あいかた /合方/相方/
あいかわ /相川/鮎川/
あいかん /哀歓/哀感/
あいがみ /間紙/藍紙/
あいがん /哀願/愛玩/
あいがんどうぶつ /愛玩動物/
あいき /愛機/
あいきどう /合気道/
あいきゃく /相客/
あいきょう /愛敬/愛嬌/愛郷/
あいぎ /合着/間着/
あいぎん /愛吟/
あいけい /愛敬/
あいけん /愛犬/
あいこ /愛顧/
あいこう /愛好/
あいこく /愛国/哀哭/
あいことば /合言葉/
あいご /愛護/
あいごま /合駒/
あいさい /愛妻/
あいさつ /挨拶/
あいざわ /会沢/
あいし /間紙/哀史/哀詩/
あいしゃ /愛車/
あいしゅう /哀愁/愛執/
あいしょ /愛書/
あいしょう /相性/愛称/愛誦/愛唱/愛妾/
あいじ /愛児/
あいじょう /愛情/哀情/愛嬢/
あいじん /愛人/
あいず /合図/会津/
あいずばんだいさん /会津磐梯山/
あいせき /相席/哀惜/愛惜/
あいせつ /哀切/
あいぜつ /哀絶/
あいぜん /愛染/
あいそ /愛想/哀訴/
あいそう /愛想/
あいそく /愛息/
あいそづかし /愛想尽かし/
あいそわらい /愛想笑い/
あいそん /愛孫/
あいぞう /愛憎/愛蔵/
あいたい /相対/
あいだ /間/会田/
あいだがら /間柄/
あいち /愛知/
あいちけん /愛知県/
あいちゃく /愛着/
あいちょう /愛鳥/哀調/愛重/
あいつ /彼奴/
あいづ /会津/
あいづち /相槌/
あいづばんだいさん /会津磐梯山/
あいづわかまつ /会津若松/
あいて /相手/
あいてかた /相手方/
あいてがた /相手方/
あいてしだい /相手次第/
あいとう /哀悼/
あいどく /愛読/
あいにく /生憎/
あいねずみ /藍鼠/
あいのり /相乗り/
あいはん /合判/相判/
あいば /愛馬/
あいびき /合挽き/
あいふく /間服/合服/
あいふだ /合札/
あいぶ /愛撫/
あいべつ /哀別/愛別/
あいべつりく /愛別離苦;愛する者との死別の苦しみ/
あいべや /相部屋/
あいぼ /愛慕/
あいぼう /相棒/
あいま /合間/
あいまい /曖昧/
あいまいもこ /曖昧模糊/
あいまって /相俟って/
あいみたがい /相身互い/
あいみるちゃ /藍海松茶/
あいもち /相持ち/
あいやく /相役/
あいやど /相宿/
あいよう /愛用/
あいよく /愛欲/
あいら /姶良;地名/
あいらく /哀楽/
あいるらんど /愛蘭/
あいれん /哀憐/愛憐/
あいろ /隘路/
あいわ /哀話/
あうん /阿吽/
あえぎ /喘ぎ/
あえて /敢えて/
あえば /饗庭/
あえもの /和え物/
あえん /亜鉛/
あえんか /亜鉛華/
あお /青/
あおあお /青々/
あおい /葵/
あおいきといき /青息吐息/
あおいし /青石/
あおいのうえ /葵上/
あおいまつり /葵祭/
あおいろ /青色/
あおいろしんこく /青色申告/
あおかち /青褐/
あおかび /青黴/
あおがえる /青蛙/
あおがしま /青ヶ島/
あおがり /青刈り/
あおき /青木/
あおきがはら /青木ヶ原/
あおきこ /青木湖/
あおぎり /青桐/
あおくさ /青草/
あおげ /青毛/
あおざかな /青魚/
あおしま /青島/
あおしんごう /青信号/
あおじそ /青紫蘇/
あおじゃしん /青写真/
あおじる /青汁/
あおすじ /青筋/
あおそ /青苧/青麻/
あおぞら /青空/
あおた /青田/
あおたがい /青田買い/
あおたがり /青田刈り/
あおだいしょう /青大将/
あおだけ /青竹/
あおだたみ /青畳/
あおだち /青立ち/
あおち /青地/
あおてんじょう /青天井/
あおと /青砥/
あおなし /青梨/
あおに /青二/青丹/
あおにさい /青二才/
あおにび /青鈍/
あおねおんせん /青根温泉/
あおの /青野/
あおのり /青海苔/
あおば /青葉/
あおばじょう /青葉城/
あおばやま /青葉山/
あおびょうし /青表紙/青標紙/
あおほん /青本/
あおみ /青み/
あおみどり /青緑/
あおむけ /仰向け/
あおむし /青虫/
あおもの /青物/
あおもり /青森/
あおもりけん /青森県/
あおもりし /青森市/
あおや /青屋/
あおやき /青焼/
あおやぎ /青柳/
あおやなぎ /青柳/
あおやま /青山/
あおり /煽り/
あか /赤/垢/亜科/閼伽/
あかあか /赤々/明々/
あかいしだけ /赤石岳/
あかいろ /赤色/
あかいわし /赤鰯/
あかがい /赤貝/
あかがね /銅/
あかがみ /赤紙/
あかぎ /赤城/赤木/
あかぎさん /赤城山/
あかぐま /赤熊/
あかげ /赤毛/
あかげら /赤啄木鳥/
あかこほん /赤小本/
あかご /赤子/赤児/
あかさか /赤坂/
あかさかみつけ /赤坂見附/
あかざ /藜/
あかし /明石/証/灯/
あかしお /赤潮/
あかしかいきょう /明石海峡/
あかしんごう /赤信号/
あかしんぶん /赤新聞/
あかじ /赤字/赤地/
あかじそ /赤紫蘇/
あかずきん /赤頭巾/
あかせん /赤線/
あかだな /閼伽棚/
あかだま /赤玉/
あかちゃん /赤ちゃん/
あかちょうちん /赤提灯/
あかつき /暁/閼伽坏/
あかつち /赤土/
あかてん /赤点/
あかでんわ /赤電話/
あかに /赤丹/
あかぬけ /垢抜け/
あかね /茜/
あかねいろ /茜色/
あかはじ /赤恥/
あかはた /赤旗/
あかはだ /赤肌/赤膚/
あかはだか /赤裸/
あかはに /赤埴/
あかはら /赤腹/
あかばな /赤花/
あかびら /赤平/
あかふだ /赤札/
あかほん /赤本/
あかぼう /赤帽/
あかま /赤間/
あかまじんぐう /赤間神宮/
あかまつ /赤松/
あかみ /赤身/赤み/
あかみず /赤水/
あかみそ /赤味噌/
あかむし /赤虫/
あかむらさき /赤紫/
あかめ /赤目/
あかもん /赤門/
あから /赤ら/
あからがお /赤ら顔/
あかり /明かり/
あかるみ /明るみ/
あかん /阿寒/
あかんこ /阿寒湖/
あかんたい /亜寒帯/
あかんぼう /赤ん坊/
あがた /県/
あがない /贖い/
あがのがわ /阿賀野川/
あがりだか /上がり高/
あき /秋/安芸/空き/穐/
あきかぜ /秋風/
あきかん /空き缶/
あきがわ /秋川/
あきぐち /秋口/
あきさめ /秋雨/
あきしの /秋篠/
あきしのでら /秋篠寺/
あきしののみや /秋篠宮/
あきしま /昭島/
あきす /空き巣/
あきぞら /秋空/
あきた /秋田/
あきたいぬ /秋田犬/
あきたけん /秋田県/秋田犬/
あきたし /秋田市/
あきただいがく /秋田大学/
あきち /空き地/
あきつ /秋津/蜻蛉/
あきづき /秋月/
あきない /商い/
あきないぐち /商い口/
あきなす /秋茄子/
あきなり /秋成/
あきはばら /秋葉原/
あきば /秋場/
あきばしょ /秋場所/
あきばれ /秋晴/
あきびより /秋日和/
あきほ /秋穂/
あきま /空き間/
あきや /空き家/
あきやま /秋山/
あきよしだい /秋吉台/
あきらか /明らか/
あきらめ /諦め/
あきれ /呆れ/
あきんど /商人/
あぎと /顎/
あぎょう /ア行/
あく /悪/握/灰汁/幄/渥/
あくい /悪意/
あくいん /悪因/
あくいんあっか /悪因悪果;悪い原因に伴う悪い結果/
あくうん /悪運/
あくえき /悪疫/
あくえきしつ /悪液質;癌腫等の末期の衰弱状態/
あくえん /悪縁/
あくかんじょう /悪感情/
あくぎ /悪戯/
あくぎょう /悪業/悪行/
あくげんた /悪源太/
あくごう /悪業/
あくさい /悪妻/悪才/
あくざいりょう /悪材料/
あくしつ /悪質/悪疾/
あくしゃ /幄舎/
あくしゅ /握手/悪手/悪趣/
あくしゅう /悪習/悪臭/
あくしゅみ /悪趣味/
あくしょ /悪所/
あくしょう /悪性/
あくしん /悪心/
あくじ /悪事/
あくじき /悪食/
あくじゅんかん /悪循環/
あくじょ /悪女/
あくせい /悪性/悪政/悪声/
あくせいしゅよう /悪性腫瘍/
あくせん /悪戦/悪銭/
あくせんくとう /悪戦苦闘/
あくぜい /悪税/
あくそう /悪相/悪僧/
あくた /芥/
あくたい /悪態/
あくたがわ /芥川/
あくたがわしょう /芥川賞/
あくたれ /悪たれ/
あくたろう /悪太郎;いたずらっ子/
あくだま /悪玉/
あくち /悪血/
あくてん /悪天/
あくとう /悪党/悪投/
あくとく /悪徳/
あくどう /悪童/悪道/
あくなき /飽くなき/
あくにち /悪日/
あくにん /悪人/
あくぬき /灰汁抜き/
あくね /阿久根/
あくねん /悪念/
あくはつとほ /握髪吐哺/
あくば /悪罵/
あくひつ /悪筆/
あくひょう /悪評/
あくび /欠伸/悪日/
あくびょう /悪病/
あくびょうどう /悪平等/
あくふう /悪風/
あくぶん /悪文/
あくへい /悪弊/
あくへき /悪癖/
あくへん /悪変/
あくほう /悪法/悪報/
あくま /悪魔/
あくまで /飽く迄/
あくみょう /悪名/
あくむ /悪夢/
あくめい /悪名/
あくやく /悪役/
あくゆう /悪友/
あくよう /悪用/
あくらつ /悪辣/
あくりょう /悪霊/
あくりょく /握力/
あくりょくけい /握力計/
あくる /明くる/
あくれい /悪例/
あくろ /悪路/
あぐい /安居院/
あぐら /胡床/胡坐/
あけ /朱/明け/
あけがた /明け方/
あけがらす /明烏/
あけくれ /明け暮れ/
あけたて /開け閉て/
あけち /明智/
あけちみつひで /明智光秀/
あけぼの /曙/
あけぼのいろ /曙色/
あげ /上げ/揚げ/
あげあし /揚げ足/挙足/
あげお /上尾/
あげかじ /上げ舵/
あげく /挙句/揚句/
あげくだし /上げ下し/
あげくのはて /挙句の果て/
あげさげ /上げ下げ/
あげしお /上げ潮/
あげぜん /上げ膳/
あげぞこ /上げ底/
あげだま /揚げ玉/
あげち /上地/
あげなべ /揚げ鍋/
あげは /揚羽/
あげば /揚げ場/
あげまき /総角/
あげまつ /上松/
あげもの /揚げ物/
あこう /赤穂/亜綱/
あこうざんたい /亜高山帯/
あこぎ /阿漕/
あこめ /衵/袙/
あご /顎/
あごひげ /顎鬚/
あごひも /顎紐/
あごわん /英虞湾/
あさ /朝/麻/
あさい /浅井/
あさいち /朝市/
あさいと /麻糸/
あさおき /朝起き/
あさか /朝霞/安積/浅香/
あさかぜ /朝風/
あさかわ /浅川/朝川/
あさがえり /朝帰り/
あさがお /朝顔/
あさがた /朝方/
あさぎ /浅葱/浅黄/麻木/浅木/
あさぎいろ /浅葱色/
あさぎぬ /麻衣/
あさぎり /朝霧/
あさぎりこうげん /朝霧高原/
あさくさ /浅草/
あさくら /朝倉/
あさけ /朝明/
あさげ /朝餉/
あさざけ /朝酒/
あさしお /朝潮/
あさしも /朝霜/
あさじ /浅茅/
あさじえ /浅知恵/
あさすおう /浅蘇芳/
あさせ /浅瀬/
あさだ /浅田/麻田/
あさだち /朝立ち/
あさぢ /浅茅/
あさぢえ /浅知恵/
あさって /明後日/
あさつゆ /朝露/
あさづけ /浅漬/
あさづま /朝妻/
あさと /朝戸/
あさなわ /麻縄/
あさぬま /浅沼/
あさね /朝寝/
あさねぼう /朝寝坊/
あさの /浅野/
あさのは /麻の葉/
あさのみ /麻の実/
あさはか /浅はか/
あさはなだ /浅縹/
あさば /浅場/
あさばん /朝晩/
あさひ /旭/朝日/
あさひかわ /旭川/
あさひがわ /旭川/
あさひしんぶん /朝日新聞/
あさひだけ /旭岳/
あさひな /朝比奈/
あさひやま /朝日山/
あさぶろ /朝風呂/
あさぼらけ /朝ぼらけ;曙,東雲/
あさま /浅間/朝間/
あさまおんせん /浅間温泉/
あさまやま /浅間山/
あさみ /浅見/
あさみどり /浅緑/
あさみや /朝宮/
あさめし /朝飯/
あさめしまえ /朝飯前/
あさもや /朝靄/
あさやけ /朝焼け/
あさやま /朝山/
あさゆ /朝湯/
あさゆう /朝夕/
あさり /浅蜊/
あされん /朝練/
あざ /字/痣/
あざな /字/
あざぶ /麻布/
あざみ /薊/
あざやか /鮮やか/
あざらし /海豹/
あし /足/葦/脚/蘆/悪し/芦/
あしあと /足跡/
あしうら /足裏/
あしお /足尾/
あしおと /足音/
あしかが /足利/
あしかがたかうじ /足利尊氏/
あしかがよしみつ /足利義満/
あしかけ /足掛け/
あしかせ /足枷/
あしがかり /足掛り/
あしがた /足型/足形/
あしがため /足固め/
あしがら /足柄/
あしがらみ /足搦み/
あしがる /足軽/
あしきしゅうきゅう /ア式蹴球/
あしくせ /足癖/
あしくび /足首/
あしげ /足蹴/葦毛/
あしこし /足腰/
あしごしらえ /足拵え/
あしずりみさき /足摺岬/
あした /明日/朝/
あしだ /芦田/
あしだい /足代/
あしだひとし /芦田均/
あしつき /足付/
あしつぎ /足継ぎ/
あしどめ /足留め/
あしどり /足取り/
あしなが /足長/
あしなみ /足並/
あしのこう /足の甲/
あしば /足場/
あしばや /足早/
あしばらい /足払い/
あしび /馬酔木/
あしびょうし /足拍子/
あしぶみ /足踏み/
あしべつ /芦別/
あしまかせ /足任せ/
あしまわり /足回り/
あしもと /足元/足下/足許/
あしや /芦屋/
あしゅ /亜種/
あしゅら /阿修羅/
あしょうさん /亜硝酸/
あしょうさんえん /亜硝酸塩/
あしよわ /足弱/
あしわざ /足技/
あしわら /葦原/
あじ /味/鰺/鯵/
あじあ /亜細亜/
あじか /簣/
あじけない /味気ない/
あじさい /紫陽花/
あじつけ /味付け/
あじのもと /味の素/
あじま /安島/
あじみ /味見/
あじゃり /阿闍梨/
あじろ /網代/足代/
あす /明日/
あすか /飛鳥/明日香/
あすかい /飛鳥井/
あすかやま /飛鳥山/
あすら /阿修羅/
あずかりきん /預り金/
あずき /小豆/
あずきいろ /小豆色/
あずきもち /小豆餅/
あずけ /預け/
あずけあい /預合/
あずさ /梓/
あずさがわ /梓川/
あずち /安土/堋/
あずま /吾妻/吾嬬/東/
あずまかがみ /吾妻鏡/東鑑/
あずまばし /吾妻橋/
あずまや /四阿/東屋/
あずみの /安曇野/
あせ /汗/
あせとり /汗取り/
あせび /馬酔木/
あせみず /汗水/
あせも /汗疹/
あせり /焦り/
あぜ /畦/畔/
あぜくら /校倉/
あぜみち /畦道/
あぜん /唖然/
あそ /阿蘇/
あそう /麻生/阿僧/
あそうぎ /阿僧祇/
あそさん /阿蘇山/
あそび /遊び/
あそびがみ /遊び紙/
あそびごころ /遊び心/
あそびにん /遊び人/
あそびめ /遊女/
あそみ /朝臣/
あそん /朝臣/
あたい /値/価/
あたか /安宅/
あたかも /宛/
あたけ /安宅/
あたご /愛宕/
あたごやま /愛宕山/
あたま /頭/
あたまうち /頭打ち/
あたまかず /頭数/
あたまきん /頭金/
あたまごなし /頭ごなし/
あたまだし /頭出し/
あたまでっかち /頭でっかち/
あたまわり /頭割り/
あたみ /熱海/
あたらしや /新屋/
あたり /当り/辺り/辺/
あたりまえ /当り前/
あたん /亜炭/
あだ /仇/徒/
あだうち /仇討/
あだごと /徒事/
あだしの /化野/
あだたらやま /安達太良山/
あだち /足立/安達/
あだな /綽名/渾名/徒名/
あだばな /徒花/
あだゆめ /徒夢/
あっか /悪化/悪貨/
あっかく /圧覚/
あっかん /悪漢/圧巻/
あっかんじょう /悪感情/
あっき /悪鬼/
あっけ /呆気/
あっこう /悪口/
あっこうぞうごん /悪口雑言/
あっさい /圧砕/
あっさく /圧搾/
あっさつ /圧殺/
あっし /圧死/
あっしゅく /圧縮/
あっしゅくき /圧縮機/
あっしゅくきちょう /圧縮記帳/
あっしゅくくうき /圧縮空気/
あっしゅくりつ /圧縮率/
あっしょう /圧勝/
あっせい /圧政/圧制/
あっせん /斡旋/
あってん /圧点/
あっとう /圧倒/
あっとうてき /圧倒的/
あっぱく /圧迫/
あっぱれ /天晴/遖/
あっぷく /圧服/
あつ /圧/篤/斡/
あつあつ /熱々/
あつえん /圧延/
あつかい /扱い/
あつかん /熱燗/
あつがみ /厚紙/
あつぎ /厚木/厚着/
あつげしょう /厚化粧/
あつさ /暑さ/
あつさしのぎ /暑さ凌ぎ/
あつじ /厚地/
あつた /熱田/
あつたじんぐう /熱田神宮/
あつで /厚手/
あつにゅう /圧入/
あつまり /集り/
あつみ /厚み/渥美/
あつみはんとう /渥美半島/
あつもの /羹/
あつもり /敦盛/
あつよう /厚様/
あつらえ /誂え/
あつりょく /圧力/
あつりょくがま /圧力釜/
あつりょくけい /圧力計/
あつりょくだんたい /圧力団体/
あつりょくなべ /圧力鍋/
あつれき /軋轢/
あづち /安土/
あづま /吾妻/
あて /宛/当て/
あてうま /当て馬/
あてさき /宛先/
あてじ /宛字/当て字/
あてずいりょう /当て推量/
あてずっぽう /当てずっぽう/
あてつけ /当て付け/
あてど /当て所/
あてな /宛名/
あてみ /当て身/
あてもの /当て物/
あで /艶/
あですがた /艶姿/
あでやか /艶やか/
あと /後/跡/
あとあし /後脚/
あとあじ /後味/
あとあと /後々/
あとおい /後追い/
あとおし /後押し/
あとかた /跡形/
あとかたづけ /後片付け/
あとがき /後書/
あとがま /後釜/
あときん /後金/
あとくされ /後腐れ/
あとくち /後口/
あとさき /後先/
あとさく /後作/
あとざん /後産/
あとしまつ /後始末/
あとぞめ /後染め/
あとち /跡地/
あとぢえ /後知恵/
あとつぎ /跡継ぎ/
あとづけ /後付/
あととり /跡取り/
あとのり /後乗り/
あとはん /後版/
あとばらい /後払い/
あとべ /跡部/
あとまわし /後回し/
あとみ /跡見/
あとめ /跡目/
あともどり /後戻り/
あとやく /後厄/
あな /穴/孔/
あなうま /穴馬/
あなうめ /穴埋め/
あながち /強ち/
あなぐま /穴熊/
あなぐら /穴蔵/窖/
あなご /穴子/
あなた /貴方/
あなたがた /貴方方/
あなば /穴場/
あなほり /穴掘り/
あなやま /穴山/
あなん /阿南/
あに /兄/豈/
あにうえ /兄上/
あにき /兄貴/
あにぎみ /兄君/
あにでし /兄弟子/
あによめ /兄嫁/嫂/
あね /姉/姐/
あねうえ /姉上/
あねがわ /姉川/
あねき /姉貴/
あねぎみ /姉君/
あねご /姐御/姉御/
あねさき /姉崎/
あねさま /姉様/
あねったい /亜熱帯/
あのよ /彼の世/
あはなち /畔放ち/
あばしり /網走/
あばた /痘痕/
あばら /肋/
あばらぼね /肋骨/
あばれ /暴れ/
あばれんぼう /暴れん坊/
あひる /家鴨/鶩/
あび /阿鼻/
あびき /網引/
あびきょうかん /阿鼻叫喚/
あびこ /我孫子/
あびじごく /阿鼻地獄/
あふりか /阿弗利加/
あぶ /虻/
あぶく /泡/
あぶくまがわ /阿武隈川/
あぶな /危な/
あぶなえ /危絵/
あぶはちとらず /虻蜂取らず/
あぶみ /鐙/
あぶら /油/脂/膏/
あぶらあげ /油揚げ/
あぶらあげぼん /油揚本/
あぶらあせ /脂汗/
あぶらいし /油石/
あぶらいろ /油色/
あぶらえ /油絵/
あぶらがみ /油紙/
あぶらしょう /脂性/
あぶらぜみ /油蝉/
あぶらとり /脂取り/
あぶらな /油菜/
あぶらみ /脂身/
あぶらむし /油虫/
あへん /阿片/
あへんくつ /阿片窟/
あべ /阿部/安部/安倍/阿倍/
あべかわ /安倍川/
あべの /阿倍野/
あほ /阿呆/
あほう /阿房/
あほうどり /信天翁/
あほだらきょう /阿呆陀羅経/
あま /天/尼/海人/亜麻/蜑/海士/雨/甘/
あまあし /雨足/
あまいろ /亜麻色/
あまえ /甘え/
あまえび /甘海老/
あまかす /甘粕/
あまかぜ /雨風/
あまかわ /甘皮/天川/
あまがえる /雨蛙/
あまがき /甘柿/
あまがさ /雨傘/
あまがさき /尼崎/
あまぎ /甘木/雨着/
あまくさ /天草/
あまくさしろう /天草四郎/
あまくさばん /天草版/
あまくだり /天下り/
あまくち /甘口/
あまぐ /雨具/
あまぐも /雨雲/
あまぐり /甘栗/
あまこ /尼子/
あまごい /雨乞い/
あまざけ /甘酒/
あましょく /甘食/
あまじお /甘塩/
あまず /甘酢/
あまぞら /雨空/
あまた /数多/
あまだ /天田/
あまだい /甘鯛/
あまだれ /雨垂れ/
あまちゃ /甘茶/
あまつ /天津/
あまつぶ /雨粒/
あまでら /尼寺/
あまとう /甘党/
あまど /雨戸/
あまどい /雨樋/
あまなっとう /甘納豆/
あまなつ /甘夏/
あまに /甘煮/
あまの /天野/
あまのいわと /天の磐戸/
あまのがわ /天の河/天の川/
あまのじゃく /天邪鬼/
あまのはしだて /天橋立/
あまべ /海部/
あまみ /奄美/甘味/
あまみおおしま /奄美大島/
あまみず /雨水/
あまもよい /雨催い/
あまもよう /雨模様/
あまもり /雨漏り/
あまやどり /雨宿り/
あまり /余り/
あまるべ /余部/
あまるめ /余目/
あみ /網/阿弥/
あみうち /網打ち/
あみがさ /編笠/
あみしろ /網代/
あみだ /阿弥陀/
あみだどう /阿弥陀堂/
あみだな /網棚/
あみだぶつ /阿弥陀仏/
あみてん /網点/
あみど /網戸/
あみのめ /網の目/
あみばり /編針/
あみぼう /編棒/
あみめ /網目/編目/
あみもと /網元/
あみもの /編物/
あみやき /網焼き/
あめ /雨/飴/天/
あめあられ /雨霰/
あめいせんそう /蛙鳴蝉噪/
あめいろ /飴色/
あめおとこ /雨男/
あめおんな /雨女/
あめかぜ /雨風/
あめだま /飴玉/
あめつち /天地/
あめに /飴煮/
あめのもり /雨森/
あめふり /雨降り/
あめもよう /雨模様/
あめりか /亜米利加/
あもい /厦門/
あもく /亜目/
あもん /亜門/
あや /文/綾/絢/
あやおり /綾織/
あやぎぬ /綾絹/
あやし /怪し/
あやせ /綾瀬/
あやつりにんぎょう /操人形/
あやべ /綾部/
あやまち /過ち/
あやまり /誤り/
あやめ /文目/菖蒲/
あゆ /阿諛/鮎/
あゆみ /歩み/
あら /新/粗/荒/
あらい /荒井/新井/
あらいがき /洗柿/
あらいがみ /洗い髪/
あらいし /荒石/
あらいしゅ /洗朱/
あらいそ /荒磯/
あらいだし /洗い出し/
あらいば /洗い場/
あらいもの /洗い物/
あらうま /荒馬/
あらうみ /荒海/
あらお /荒尾/
あらおり /粗織/
あらかじめ /予め/予/
あらかせぎ /荒稼ぎ/
あらかた /粗方/
あらかわ /荒川/粗皮/
あらかわほうすいろ /荒川放水路/
あらがね /鉱;未精錬の金属/
あらき /荒木/
あらきだ /荒木田/
あらぎょう /荒行/
あらくれ /荒くれ/
あらけずり /粗削り/
あらごと /荒事/
あらごなし /荒ごなし/
あらし /嵐/
あらしごと /荒仕事/
あらしね /荒稲/
あらしやま /嵐山/
あらすじ /粗筋/
あらそい /争い/
あらた /新た/新田/荒田/
あらため /改め/
あらためて /改めて/
あらづくり /粗造り/
あらて /新手/
あらと /荒砥/
あらなみ /荒波/
あらなわ /荒縄/
あらの /荒野/
あらはた /荒畑/
あらひとがみ /現人神/
あらほうし /荒法師/
あらぼとけ /新仏/
あらまき /新巻/荒巻/
あらむしゃ /荒武者/
あらめ /荒目/
あらもの /荒物/
あらや /新屋/
あらやしき /新屋敷/
あらやま /荒山/
あらゆ /新湯/
あららぎ /蘭/
あらりえき /粗利益/荒利益/
あらりょうじ /荒療治/
あられ /霰/
あらわ /露/
あらわざ /荒技/荒業/
あり /蟻/
ありあけ /有明/
ありあけかい /有明海/
ありかた /在り方/
ありがた /有難/
ありがとう /有り難う/
ありがね /有り金/
ありくい /食蟻獣/
ありさか /有坂/
ありさま /有様/
ありさわ /有沢/
ありさん /阿里山/
ありしよ /在りし世/
ありじごく /蟻地獄/
ありた /有田/
ありだ /有田/
ありだか /有り高/
ありづか /蟻塚/
ありてい /有り体/
ありはら /在原/
ありま /有馬/
ありまおんせん /有馬温泉/
ありゅう /亜流/
ありゅうさん /亜硫酸/
ありよう /有り様/
ありわら /在原/
ある /或る/或/
あるいは /或いは/
あるかなし /有るか無し/
あるが /有賀/
あるじ /主/
あるちゅう /アル中/
あるときばらい /有る時払い/
あるふぁ /α/
あるふぁせん /α線/
あれ /荒れ/
あれしょう /荒れ性/
あれち /荒地/荒れ地/
あれの /荒れ野/
あれもよう /荒れ模様/
あわ /泡/粟/阿波/安房/
あわざ /阿波座/
あわしま /淡島/
あわじ /淡路/
あわじしま /淡路島/
あわず /粟津/
あわせ /袷/
あわせて /併せて/
あわた /粟田/
あわたてき /泡立て器/
あわつぶ /粟粒/
あわづ /粟津/
あわづおんせん /粟津温泉/
あわばこ /泡箱/
あわび /鮑/鰒/
あわびむすび /鮑結び/
あわもり /泡盛/
あわゆき /淡雪/
あわれ /哀れ/
あん /安/案/暗/行/庵/闇/按/菴/餡/杏/鞍/
あんい /安易/
あんいつ /安逸/安佚/
あんうつ /暗鬱/
あんうん /暗雲/
あんえい /暗影/安永/
あんか /安価/行火/案下/
あんかっしょく /暗褐色/
あんかん /安閑/
あんが /安臥/
あんがい /案外/
あんき /暗記/暗鬼/安徽/安危/
あんきょ /安居/暗渠/
あんぎゃ /行脚/
あんぎょう /安行/
あんくん /暗君/
あんぐう /行宮/
あんけい /安慶/
あんけん /案件/
あんけんさつ /暗剣殺/
あんこ /餡こ/
あんこう /鮟鱇/安康/
あんこうがた /鮟鱇形/
あんこうしょく /暗紅色/
あんこうなべ /鮟鱇鍋/
あんこく /暗黒/
あんこくがい /暗黒街/
あんこくじ /安国寺/
あんこくじだい /暗黒時代/
あんこくせいうん /暗黒星雲/
あんこくめん /暗黒面/
あんごう /暗号/暗合/
あんさつ /暗殺/
あんざん /安産/暗算/鞍山/
あんざんがん /安山岩/
あんししょく /暗紫色/
あんしつ /暗室/
あんしゅう /暗愁/
あんしゅつ /案出/
あんしょう /暗証/暗礁/暗誦/諳誦/
あんしょく /暗色/
あんしん /安心/
あんしんりつめい /安心立命/
あんじ /暗示/案じ/
あんじゅ /庵主/
あんじゅう /安住/
あんじゅんのう /暗順応/
あんじょう /安城/鞍上/
あんず /杏/杏子/
あんせい /安静/安政/
あんせいど /安静度/
あんせきしょく /暗赤色/
あんぜん /安全/暗然/
あんぜんき /安全器/
あんぜんきょういく /安全教育/
あんぜんぐつ /安全靴/
あんぜんけん /安全圏/
あんぜんせい /安全性/
あんぜんそうち /安全装置/
あんぜんちたい /安全地帯/
あんぜんぱい /安全牌/
あんぜんべん /安全弁/
あんぜんほしょう /安全保障/
あんぜんりつ /安全率/
あんそうおん /暗騒音/
あんそく /安息/
あんたい /安泰/
あんたくせいろ /安宅正路/
あんたん /暗澹/
あんだ /安打/
あんち /安置/
あんちゃく /安着/
あんちゅう /暗中/
あんちゅうひやく /暗中飛躍/
あんちゅうもさく /暗中模索/
あんちょく /安直/
あんてい /安定/
あんてん /暗転/
あんとう /安東/暗闘/
あんど /安堵/
あんどう /安藤/安東/
あんどん /行灯/闇鈍/
あんない /案内/
あんないしゃ /案内者/
あんないじょう /案内状/
あんないにん /案内人/
あんなか /安中/
あんに /暗に/
あんにん /杏仁/
あんねい /安寧/
あんねいちつじょ /安寧秩序/
あんのじょう /案の定/
あんのん /安穏/
あんばい /按排/塩梅/
あんぴ /安否/
あんぶ /鞍部/
あんぶん /按分/案文/案分/
あんぷ /暗譜/
あんぽ /安保/
あんぽう /罨法/
あんま /按摩/
あんまく /暗幕/
あんみん /安眠/
あんめん /暗面/
あんもく /暗黙/
あんもち /餡餅/
あんや /暗夜/
あんやく /暗躍/
あんやこうろ /暗夜行路/
あんゆ /暗喩/
あんらく /安楽/
あんらくいす /安楽椅子/
あんらくし /安楽死/
あんりゅう /暗流/
あんろくざん /安禄山/
い /位/為/意/井/唯/偉/異/亥/医/遺/違/衣/胃/緯/維/移/畏/易/慰/尉/威/委/夷/囲/依/伊/以/彙/居/猪/五/姨/已/帷/彝/堰/胆/如/謂/萎/惟/椅/
い> /異/
いーふぁん /一翻/
いあい /居合/遺愛/
いあく /帷幄/
いあくじょうそう /帷幄上奏/
いあつ /威圧/
いあん /慰安/
いあんふ /慰安婦/
いい /飯/伊井/謂/井伊/
いいあい /言い合い/
いいあらそい /言い争い/
いいかえ /言い換え/
いいかげん /好い加減/
いいかた /言い方/
いいぐさ /言い草/
いいざかおんせん /飯坂温泉/
いいじょう /言い条/
いいすぎ /言い過ぎ/
いいすて /言い捨て/
いいずか /飯塚/
いいだ /飯田/
いいだくだく /唯唯諾諾/
いいだせん /飯田線/
いいつたえ /言い伝え/
いいづか /飯塚/
いいなずけ /許嫁/
いいぬま /飯沼/
いいね /言い値/
いいのがれ /言い逃れ/
いいぶん /言い分/
いいまわし /言回し/
いいもりやま /飯盛山/
いいやま /飯山/
いいわけ /言訳/言い訳/
いいわたし /言渡し/
いいん /委員/医院/医員/
いいんかい /委員会/
いいんちょう /委員長/
いうなれば /言うなれば/
いえ /家/
いえい /遺影/遺詠/
いえがまえ /家構え/
いえがら /家柄/
いえき /胃液/
いえじ /家路/
いえすじ /家筋/
いえつき /家付き/
いえで /家出/
いえどころ /家所/
いえども /雖も/
いえもち /家持ち/
いえもと /家元/
いえやしき /家屋敷/
いえよう /家様/
いえん /胃炎/以遠/
いえんけん /以遠権/
いおう /硫黄/
いおうじ /医王寺/
いおえ /五百枝/
いおり /庵/
いおんびん /イ音便/
いか /以下/医科/異化/烏賊/
いかい /位階/猪飼/
いかいよう /胃潰瘍/
いかが /如何/
いかがく /医化学/
いかく /威嚇/
いかくちょう /胃拡張/
いかすい /胃下垂/
いかずち /雷/
いかた /伊方/
いかだ /筏/
いかつ /威喝/
いかなご /玉筋魚/
いかなる /如何なる/
いかに /如何に/
いかひ /異花被/
いかほ /伊香保/
いかほど /如何程/
いかよう /如何様/
いかり /錨/怒り/碇/
いかりがた /怒り肩/
いかる /鵤/斑鳩/
いかるが /斑鳩/
いかん /如何/移管/遺憾/偉観/衣冠/医官/尉官/異観/
いかんそく /維管束/
いかんそくたい /衣冠束帯/
いが /伊賀/
いがい /以外/意外/遺骸/貽貝/
いがく /医学/
いがぐり /毬栗/
いがぐりあたま /毬栗頭/
いがた /鋳型/
いがらし /五十嵐/
いがん /依願/胃癌/
いがんめんしょく /依願免職/
いき /息/域/意気/粋/閾/遺棄/壱岐/委棄/行き/生き/位記/
いきいき /生き生き/
いきうつし /生き写し/
いきうま /生き馬/
いきうめ /生埋め/
いきおい /勢い/
いきか /閾下/
いきかた /生き方/行き方/
いきがい /域外/生き甲斐/
いきがみ /生き神/
いきき /往き来/行き来/
いきぎも /生き肝/
いきぎれ /息切れ/
いきけんこう /意気軒昂/
いきごみ /意気込み/
いきさき /行先/
いきさつ /経緯/
いきざい /遺棄罪/
いきざま /生き様/
いきしな /行きしな/
いきしに /生き死に/
いきしょうちん /意気消沈/
いきじごく /生き地獄/
いきじびき /生き字引/
いきすぎ /行過ぎ/
いきすじ /粋筋/
いきそそう /意気沮喪/
いきち /閾値/生き血/
いきちがい /行き違い/
いきつき /生月/
いきつぎ /息継ぎ/
いきつけ /行き付け/
いきづかい /息遣い/
いきとうごう /意気投合/
いきない /域内/
いきにんぎょう /生き人形/
いきぬき /息抜き/
いきのこり /生き残り/
いきのした /息の下/
いきのね /息の根/
いきのまつばら /生の松原/
いきはじ /生き恥/
いきば /行き場/
いきぼとけ /生き仏/
いきみ /生き身/
いきもの /生き物/
いきやすめ /息休め/
いきょ /依拠/
いきょう /異境/異教/異郷/
いきょく /医局/委曲/
いきようよう /意気揚々/意気揚揚/
いきりょう /生き霊/
いきわかれ /生き別れ/
いぎ /意義/異議/威儀/異義/
いぎもうしたて /異議申立て/
いぎょう /偉業/異形/遺業/医業/
いぎりす /英吉利/
いく /育/幾/生/郁/
いくい /生井/
いくえ /幾重/
いくえい /育英/
いくさ /戦/
いくさぶぎょう /軍奉行/
いくさものがたり /軍物語/
いくしま /生島/
いくしゅ /育種/
いくじ /育児/意気地/
いくじきゅうぎょう /育児休業/
いくじなし /意気地無し/
いくすう /育雛/
いくせい /育成/
いくた /生田/幾多/
いくたがわ /生田川/
いくたじんじゃ /生田神社/
いくたび /幾度/
いくたま /生玉/
いくつ /幾つ/
いくとせ /幾年/
いくど /幾度/
いくどうおん /異口同音/
いくにち /幾日/
いくの /生野/
いくは /的/
いくばく /幾許/幾何/
いくびょう /育苗/
いくぶん /幾分/
いくほど /幾程/
いくよ /幾夜/
いくら /幾ら/
いくらか /幾らか/
いくりん /育林/
いくん /遺訓/
いぐさ /藺草/
いぐるみ /弋/
いけ /池/
いけい /畏敬/異型/異形/
いけいれん /胃痙攣/
いけうお /活魚/
いけうち /池内/
いけがき /生垣/
いけす /生簀/
いけたに /池谷/
いけだ /池田/
いけにえ /犠牲/
いけの /池野/
いけのぼう /池坊/
いけはぎ /生剥/
いけばな /活花/
いけぶくろ /池袋/
いけべ /池辺/
いけん /意見/違憲/異見/遺賢/
いけんこうこく /意見広告/
いげた /井桁/
いげん /威厳/
いこい /憩い/
いこう /以降/移行/意向/移項/偉功/威光/遺稿/偉効/遺構/
いこく /異国/
いこくじょうちょ /異国情緒/
いこじ /意固地/依怙地/
いこつ /遺骨/
いこま /生駒/
いこまやま /生駒山/
いこん /遺恨/
いご /以後/囲碁/
いごこち /居心地/
いごころ /居心/
いごん /遺言/
いさい /委細/異彩/偉才/異才/
いさお /勲/功/
いさかい /諍い/
いさく /遺作/
いささか /聊か/
いさつ /縊殺/
いさみあし /勇み足/
いさりび /漁火/
いさわ /石和/
いさん /遺産/胃酸/胃散/違算/
いさんぜい /遺産税/
いさんそうぞく /遺産相続/
いざい /偉材/異材/
いざかや /居酒屋/
いざなぎのみこと /伊邪那岐命/伊弉諾尊/
いざよい /十六夜/
いざわ /伊沢/
いし /石/医師/意思/意志/遺志/遺址/縊死/遺子/
いしあたま /石頭/
いしい /石井/
いしうす /石臼/
いしおか /石岡/
いしかい /医師会/
いしかべ /石壁/
いしかり /石狩/
いしかりがわ /石狩川/
いしかりなべ /石狩鍋/
いしかわ /石川/
いしかわけん /石川県/
いしかわじま /石川島/
いしかわたくぼく /石川啄木/
いしがき /石垣/
いしがきじま /石垣島/
いしがま /石釜/
いしがみ /石神/
いしがめ /石亀/
いしき /意識/
いしきしょうがい /意識障害/
いしきてき /意識的/
いしきふめい /意識不明/
いしきりば /石切場/
いしく /石工/
いしぐみ /石組み/
いしぐろ /石黒/
いしけり /石蹴り/
いしげ /石毛/
いしこ /石子/
いしころ /石塊/
いしざか /石坂/
いしざき /石崎/
いししゅぎ /意思主義/
いしじ /石地/
いしず /石津/
いしずえ /礎/
いしずか /石塚/
いしだ /石田/
いしだか /石高/
いしだたみ /石畳/甃/
いしだみつなり /石田三成/
いしだりゅう /石田流/
いしだん /石段/
いしつ /異質/遺失/
いしつぶつ /遺失物/
いしつみ /石積み/
いしづ /石津/
いしづか /石塚/
いしづくり /石造り/
いしのうりょく /意思能力/
いしのまき /石巻/
いしはくじゃく /意志薄弱/
いしはら /石原/
いしばい /石灰/
いしばし /石橋/
いしひょうじ /意思表示/
いしぶし /石伏/
いしぶみ /碑/
いしほう /医師法/
いしぼとけ /石仏/
いしま /石間/
いしみち /石道/
いしみつ /石光/
いしむら /石村/
いしむろ /石室/
いしもだ /石母田/
いしもち /石持/
いしゃ /医者/
いしゃりょう /慰謝料/
いしや /石屋/
いしやき /石焼き/
いしやきいも /石焼き芋/
いしやま /石山/
いしやまでら /石山寺/
いしゅ /異種/意趣/
いしゅう /異臭/蝟集/遺習/
いしゅがえし /意趣返し/
いしゅく /萎縮/畏縮/
いしゅつ /移出/
いしゆみ /弩/
いしょ /遺書/医書/移書/異書/
いしょう /衣裳/衣装/意匠/異称/囲障/
いしょうけん /意匠権/
いしょく /移植/委嘱/異色/衣食/依嘱/
いしょくじゅう /衣食住/
いしょくどうげん /医食同源/
いしわた /石綿/
いしわら /石原/
いしわり /石割/
いしん /威信/維新/異心/遺臣/
いしんでんしん /以心伝心/
いじ /維持/意地/遺児/医事/異字/
いじっぱり /意地っ張り/
いじめ /苛め/
いじゃく /胃弱/
いじゅう /移住/
いじゅつ /医術/
いじょう /以上/異常/委譲/異状/移乗/移譲/
いじょうきしょう /異常気象/
いじょうふ /偉丈夫/
いじょく /居職/
いじり /井尻/
いじわる /意地悪/
いじん /異人/偉人/
いじんかん /異人館/
いす /椅子/
いすう /異数/
いすずがわ /五十鈴川/
いず /伊豆/
いずこ /何処/
いずし /出石/
いずつ /井筒/
いずはら /厳原/
いずはんとう /伊豆半島/
いずみ /泉/和泉/出水/
いずみおおつ /泉大津/
いずみがわ /泉川/
いずみきょうか /泉鏡花/
いずみさの /泉佐野/
いずも /出雲/
いずもざき /出雲崎/
いずもたいしゃ /出雲大社/
いずれ /何れ/
いせ /伊勢/
いせい /異性/以西/威勢/為政/
いせいしゃ /為政者/
いせいたい /異性体/
いせえび /伊勢海老/
いせき /移籍/遺跡/
いせさき /伊勢崎/
いせじ /伊勢路/
いせじんぐう /伊勢神宮/
いせつ /異説/
いせはら /伊勢原/
いせまいり /伊勢参り/
いせや /伊勢屋/
いせわん /伊勢湾/
いせん /緯線/
いぜん /以前/依然/
いぜんけい /已然形/
いそ /磯/五十/
いそう /移送/位相/移相/遺草/
いそうかいせき /位相解析/
いそうき /移相器/
いそうくうかん /位相空間/
いそうろう /居候/
いそがい /磯貝/
いそぎあし /急ぎ足/
いそし /勤し/
いそしぎ /磯鷸/
いそじ /磯路/五十路/
いそだ /礒田/
いそなみ /磯波/
いそべ /磯辺/
いそま /磯間/
いそまつ /磯松/
いそやま /磯山/
いそん /依存/
いそんひん /易損品/
いぞう /遺贈/
いぞく /遺族/
いぞり /居反り/
いぞん /異存/依存/
いた /板/痛/
いたい /遺体/異体/板井/
いたいいたいびょう /イタイイタイ病/
いたいじ /異体字/
いたかぶ /板株/
いたがき /板垣/
いたがね /板金/
いたがみ /板紙/
いたがらす /板硝子/
いたきれ /板切れ/
いたく /委託/依託/
いたくしょうこきん /委託証拠金/
いたくはんばい /委託販売/
いたくばいばい /委託売買;証券会社が顧客の委託により行う有価証券の売買、⇔自己売買/
いたくら /板倉/
いたけだか /居丈高/
いたこ /潮来/
いたざい /板材/
いたしかた /致し方/
いたじき /板敷/
いたずら /徒/
いたずらに /徒に/
いただき /頂/
いたち /鼬/
いたって /至って/
いたづけ /板付/
いたで /痛手/
いたど /板戸/
いたのま /板の間/
いたば /板場/
いたばさみ /板挟み/
いたばし /板橋/
いたばり /板張/
いたびょうし /板表紙/
いたぶんこ /板文庫/
いたべい /板塀/
いたま /板間/
いたまえ /板前/
いたみ /伊丹/
いたみどめ /痛み止め/
いため /板目/
いためがみ /板目紙/
いためもの /炒め物/
いたもち /板持/
いたや /板谷/板屋/
いたやとうげ /板谷峠/
いたよせ /板寄/
いたん /異端/
いたんしゃ /異端者/
いたんしんもん /異端審問/
いたんじ /異端児/
いだい /偉大/医大/
いだつ /遺脱/
いだてん /韋駄天/
いち /一/位置/壱/市/
いち> /一/
いちあん /一案/
いちい /一意/一位/櫟/
いちいせんしん /一意専心/
いちいたいすい /一衣帯水/
いちいち /一々/
いちいてき /一意的/
いちいん /一員/一因/一院/
いちいんせい /一院制/
いちう /一宇/
いちえ /一会/
いちえん /一円/
いちおう /一応/
いちおく /一億/
いちかたりゅう /都方流/一方流/
いちかわ /市川/
いちかわだいもん /市川大門/
いちかわふさえ /市川房枝/
いちがい /一概/
いちがいに /一概に/
いちがしら /市頭/
いちがつ /一月/
いちがや /市ヶ谷/
いちがん /一眼/一丸/
いちき /一木/
いちぎ /一義/
いちぎてき /一義的/
いちぎゅうめいち /一牛鳴地/
いちぎょう /一行/
いちく /移築/
いちぐう /一隅/
いちぐん /一群/一軍/
いちけんしき /一見識/
いちげい /一芸/
いちげき /一撃/
いちげつさんしゅう /一月三舟/
いちげん /一言/一見/一元/
いちげんか /一元化/
いちげんこじ /一言居士/
いちげんろん /一元論/
いちこ /市子/
いちこじん /一個人/
いちこつ /壱越/
いちご /苺/一期/莓/
いちごいちえ /一期一会/
いちごん /一言/
いちごんいっく /一言一句/
いちごんはんく /一言半句/
いちざ /一座/
いちじ /一時/一次/一事/一字/
いちじいっく /一字一句/
いちじかりいれきん /一時借入金/
いちじかん /一時間/
いちじかんすう /一次関数/
いちじきん /一時金/
いちじく /無花果/
いちじしのぎ /一時凌ぎ/
いちじせんきん /一字千金/
いちじつ /一日/
いちじつさんしゅう /一日三秋/
いちじつせんしゅう /一日千秋/
いちじてき /一時的/
いちじのがれ /一時逃れ/
いちじばらい /一時払い/
いちじばん /一字版/
いちじふさいり /一事不再理/
いちじへんかん /一次変換/
いちじほうていしき /一次方程式/
いちじゅういっさい /一汁一菜/
いちじゅん /一巡/一順/一旬/
いちじょ /一助/一女/
いちじょう /一条/一場/
いちじょうじ /一乗寺/
いちじん /一陣/
いちじんぶつ /一人物/
いちず /一途/
いちぞく /一族/
いちぞん /一存/
いちだい /一代/
いちだいき /一代記/
いちだいじ /一大事/
いちだくせんきん /一諾千金/
いちだん /一段/一団/
いちだんらく /一段落/
いちど /一度/
いちどう /一同/一堂/一道/
いちどく /一読/
いちな /一名/
いちなん /一難/
いちに /一二/
いちにち /一日/
いちにょ /一如/
いちにん /一任/一人/
いちにんしょう /一人称/
いちにんまえ /一人前/
いちねん /一年/一念/
いちねんき /一年忌/
いちねんそう /一年草/
いちねんほっき /一念発起/
いちのう /一能/
いちのせき /一関/
いちのみや /一宮/一の宮/
いちはら /市原/
いちはらの /市原野/
いちば /市場/
いちばい /一倍/
いちばつひゃっかい /一罰百戒/
いちばん /一番/
いちばんて /一番手/
いちばんていとう /一番抵当/
いちばんでし /一番弟子/
いちばんのり /一番乗り/
いちばんぼし /一番星/
いちばんめ /一番目/
いちばんやり /一番槍/
いちひめ /市姫/
いちひめにたろう /一姫二太郎/
いちびょうそくさい /一病息災/
いちぶ /一部/一分/
いちぶしじゅう /一部始終/
いちぶはんけつ /一部判決/
いちぶぶん /一部分/
いちぶほけん /一部保険/
いちぶん /一分/
いちべつ /一瞥/一別/
いちぼう /一望/
いちぼくいっそう /一木一草/
いちまい /一枚/
いちまいいわ /一枚岩/
いちまいえ /一枚絵/
いちまつ /一抹/市松/
いちまつもよう /市松模様/
いちまんえん /一万円/
いちまんえんさつ /一万円札/
いちみ /一味/
いちみととう /一味徒党/
いちみどうしん /一味同心/
いちみゃく /一脈/
いちむら /市村/
いちめい /一名/一命/
いちめん /一面/
いちめんしき /一面識/
いちめんてき /一面的/
いちもう /一毛/
いちもうさく /一毛作/
いちもうだじん /一網打尽/
いちもく /一目/
いちもくさん /一目散/
いちもくりょうぜん /一目瞭然/
いちもつ /一物/逸物/
いちもん /一門/一文/
いちもんいっとう /一問一答/
いちもんじ /一文字/
いちもんなし /一文無し/
いちもんはんせん /一文半銭/
いちもんふち /一文不知/
いちもんふつう /一文不通/
いちや /一夜/
いちやく /一躍/一役/
いちゅう /意中/移駐/
いちゆう /一揖/
いちょ /遺著/
いちょう /胃腸/移調/銀杏/移牒/公孫樹/医長/
いちょうがっき /移調楽器/
いちよう /一様/一葉/
いちようぶんぷ /一様分布/
いちようらいふく /一陽来復/
いちよく /一翼/
いちらん /一覧/
いちらんひょう /一覧表/
いちり /一理/一里/一利/
いちりいちがい /一利一害/
いちりき /一力/
いちりつ /一律/市立/
いちりづか /一里塚/
いちりゅう /一流/
いちりゅうまんばい /一粒万倍/
いちりょう /一両/
いちりょうじつ /一両日/
いちりん /一輪/
いちりんしゃ /一輪車/
いちる /一縷/
いちるい /一塁/一類/
いちれい /一礼/一例/
いちれつ /一列/
いちれん /一連/
いちれんたくしょう /一蓮托生/
いちろ /一路/
いちわり /一割/
いっか /一家/一過/一価/
いっかい /一回/一階/一介/一塊/
いっかいき /一回忌/
いっかく /一角/一画/
いっかくじゅう /一角獣/
いっかくせんきん /一攫千金/
いっかげん /一家言/
いっかせい /一過性/
いっかだんらん /一家団欒/
いっかつ /一括/一喝/
いっかん /一貫/一環/一巻/
いっかんきょういく /一貫教育/
いっき /一気/一揆/一騎/逸機/
いっきいちゆう /一喜一憂/
いっきうち /一騎打/
いっきかせい /一気呵成/
いっきとうせん /一騎当千/
いっきに /一気に/
いっきゅう /一級/一休/
いっきょ /一挙/
いっきょいちどう /一挙一動/
いっきょう /一興/一驚/
いっきょく /一曲/一局/
いっきょりょうとく /一挙両得/
いっく /一句/
いっけい /一計/一景/一系/
いっけつ /一決/一穴/溢血/
いっけん /一見/一件/一軒/一間/
いっけんしき /一見識/
いっけんや /一軒家/
いっこ /一個/一顧/一戸/一己/
いっこう /一行/一向/一考/
いっこういっき /一向一揆/
いっこうしゅう /一向宗/
いっこく /一刻/一国/
いっこくいちじょう /一国一城/
いっこくせんきん /一刻千金/
いっこじん /一個人/
いっこだて /一戸建て/
いっこん /一献/
いっこんぞめ /一斤染/
いっさ /一茶/
いっさい /一切/一再/
いっさいがっさい /一切合切/
いっさいきょう /一切経/
いっさいたふ /一妻多夫/
いっさいてん /一斎点/
いっさく /一昨/一策/
いっさくじつ /一昨日/
いっさくねん /一昨年/
いっさくばん /一昨晩/
いっさくや /一昨夜/
いっさつ /一札/
いっさんか /一酸化/
いっさんかたんそ /一酸化炭素/
いっさんかちっそ /一酸化窒素/
いっし /一矢/一子/一指/一死/一糸/逸史/
いっしき /一式/一色/
いっしそうでん /一子相伝/
いっしつ /一室/一失/
いっしつりえき /逸失利益/
いっしどうじん /一視同仁/
いっしはんせん /一紙半銭/
いっしゃせんり /一瀉千里/
いっしゅ /一種/
いっしゅう /一周/一蹴/一週/
いっしゅうかん /一週間/
いっしゅうき /一周忌/一周期/
いっしゅうねん /一周年/
いっしゅく /一宿/
いっしゅくいっぱん /一宿一飯/
いっしゅつ /逸出/
いっしゅん /一瞬/
いっしゅんかん /一瞬間/
いっしょ /一緒/一所/一書/
いっしょう /一生/一升/一笑/一将/
いっしょうがい /一生涯/
いっしょうけんめい /一生懸命/
いっしょく /一色/
いっしょくそくはつ /一触即発/
いっしょくた /一緒くた/
いっしょけんめい /一所懸命/
いっしん /一新/一心/一身/一審/
いっしんいったい /一進一退/
いっしんきょう /一神教/
いっしんじょう /一身上/
いっしんとう /一親等/
いっしんどうたい /一心同体/
いっしんふらん /一心不乱/
いっすい /一睡/溢水/
いっすん /一寸/
いっすんぼうし /一寸法師/
いっせ /一世/
いっせい /一斉/一世/一声/
いっせいしゃげき /一斉射撃/
いっせいちだい /一世一代/
いっせいに /一斉に/
いっせき /一隻/一席/一石/一夕/
いっせきにちょう /一石二鳥/
いっせつ /一節/一説/
いっせつたしょう /一殺多生/
いっせつな /一刹那/
いっせん /一線/一銭/一戦/一閃/
いっせんきゅう /一線級/
いっそう /一層/一掃/逸走/
いっそく /一足/
いっそくとび /一足飛び/
いったい /一体/一帯/
いったいぜんたい /一体全体/
いったん /一旦/一端/一反/
いっち /一致/
いっちはんかい /一知半解/
いっちゃく /一着/
いっちゅう /一中/
いっちょう /一朝/一丁/一張/
いっちょういっし /一張一弛/
いっちょういっせき /一朝一夕/
いっちょういったん /一長一短/
いっちょうら /一張羅/
いっちょくせん /一直線/
いっつい /一対/
いっつう /一通/
いって /一手/
いってい /一定/
いってき /一滴/一擲/
いってきせんきん /一擲千金/
いってつ /一徹/
いってん /一点/一転/
いってんき /一転機/
いってんばり /一点張り/
いっと /一途/一斗/
いっとう /一等/一党/一頭/一刀/一統/
いっとうこく /一等国/
いっとうせい /一等星/
いっとうそく /一投足/
いっとうへい /一等兵/
いっとうりょうだん /一刀両断/
いっとき /一時/
いっとく /一得/
いっとくいっしつ /一得一失/
いっぱ /一派/一波/
いっぱい /一杯/一敗/
いっぱく /一泊/一拍/一白/
いっぱし /一端/
いっぱつ /一発/一髪/
いっぱつや /一発屋/
いっぱん /一般/一半/一班/
いっぱんか /一般化/
いっぱんかいけい /一般会計/
いっぱんかく /一般角/
いっぱんきょういく /一般教育/
いっぱんきょうよう /一般教養/
いっぱんこう /一般項/
いっぱんしょく /一般職/
いっぱんじん /一般人/
いっぱんせい /一般性/
いっぱんせんきょ /一般選挙/
いっぱんてき /一般的/
いっぱんほう /一般法/
いっぱんよぼう /一般予防/
いっぱんろん /一般論/
いっぴき /一匹/
いっぴきおおかみ /一匹狼/
いっぴつ /一筆/
いっぴつけいじょう /一筆啓上/
いっぴん /一品/逸品/
いっぴんいっしょう /一顰一笑/
いっぷ /一夫/
いっぷいっぷ /一夫一婦/
いっぷう /一風/
いっぷく /一服/
いっぷたさい /一夫多妻/
いっぺいそつ /一兵卒/
いっぺき /一碧/
いっぺん /一遍/一編/一片/一変/一篇/一偏/
いっぺんとう /一辺倒/
いっぽ /一歩/
いっぽう /一方/一報/一法/
いっぽうつうこう /一方通行/
いっぽうてき /一方的/
いっぽん /一本/
いっぽんか /一本化/
いっぽんぎ /一本気/
いっぽんしょうぶ /一本勝負/
いっぽんぜおい /一本背負/
いっぽんだち /一本立ち/
いっぽんばし /一本橋/
いっぽんみち /一本道/
いっぽんやり /一本槍/
いつ /一/五/逸/何時/壱/厳/溢/
いつう /胃痛/
いつか /五日/何時か/
いつき /五木/斎/
いつくしま /厳島/
いつくしまじんじゃ /厳島神社/
いつざい /逸材/
いつだつ /逸脱/
いつつ /五つ/
いつづけ /居続け/
いつぶつ /逸物/
いつぶん /逸聞/
いつも /何時も/
いつわ /逸話/
いつわり /偽り/
いづつ /井筒/
いづな /飯綱/
いて /射手/
いてき /夷狄/
いてざ /射手座/
いてん /移転/
いてんしゅうし /移転収支/
いてんとうき /移転登記/
いで /井手/出/
いでん /遺伝/位田/
いでんあんごう /遺伝暗号/
いでんがく /遺伝学/
いでんし /遺伝子/
いでんしこうがく /遺伝子工学/
いでんしざ /遺伝子座/
いでんしそうさ /遺伝子操作/
いでんじょうほう /遺伝情報/
いでんせい /遺伝性/
いでんびょう /遺伝病/
いと /糸/意図/異図/
いといがわ /糸魚川/
いとう /伊藤/伊東/以東/
いときりば /糸切歯/
いとく /懿徳/威徳/遺徳/
いとぐち /糸口/
いとぐるま /糸車/
いとこ /従兄弟/従姉妹/
いとしご /いとし子/
いとぞこ /糸底/
いとづくり /糸作り/
いとてき /意図的/
いとま /暇/
いとまき /糸巻/
いとまごい /暇乞い/
いとまん /糸満/
いとめ /糸目/
いど /井戸/緯度/異土/
いどう /移動/異動/異同/医道/
いどうど /移動度/
いどうへいきん /移動平均/
いどころ /居所/
いどばた /井戸端/
いどばたかいぎ /井戸端会議/
いどみず /井戸水/
いな /否/稲/伊那/
いない /以内/稲井/
いなおりごうとう /居直り強盗/
いなか /田舎/
いなかず /稲数/
いなかもの /田舎者/
いながき /稲垣/
いなぎ /稲城/稲木/稲置/
いなこ /稲子/
いなご /蝗/
いなさく /稲作/
いなざわ /稲沢/
いなしき /稲敷/
いなず /稲津/
いなずま /稲妻/
いなだ /稲田/
いなづ /稲津/
いなば /稲場/稲葉/因幡/
いなほ /稲穂/
いなむら /稲村/
いなや /否や/
いなり /稲荷/
いなりまち /稲荷町/
いなりやま /稲荷山/
いなわしろ /猪苗代/
いなわしろこ /猪苗代湖/
いなん /以南/
いにしえ /古/
いにゅう /移入/
いにん /委任/
いにんけいり /委任経理/
いにんじょう /委任状/
いにんとうち /委任統治/
いにんめいれい /委任命令/
いにんりっぽう /委任立法/
いぬ /犬/狗/戌/
いぬい /乾/
いぬいもん /乾門/
いぬかい /犬飼/犬養/
いぬかいつよし /犬養毅/
いぬかみ /犬上/
いぬがみ /犬神/
いぬき /居抜き/
いぬころ /犬ころ/
いぬじに /犬死に/
いぬぞり /犬橇/
いぬちくしょう /犬畜生/
いぬぼうざき /犬吠埼/
いぬめ /犬目/
いぬやま /犬山/
いぬやまじょう /犬山城/
いね /稲/
いねかり /稲刈り/
いねむり /居眠り/
いのう /稲生/伊能/異能/
いのうえ /井上/
いのこり /居残り/
いのしし /猪/
いのち /命/
いのちがけ /命懸け/
いのちごい /命乞い/
いのちづな /命綱/
いのちとり /命取り/
いのちびろい /命拾い/
いのなか /井の中/
いのふ /胃の腑/
いのまた /猪俣/
いは /伊波/
いはい /違背/位牌/
いはく /医博/威迫/
いはつ /遺髪/衣鉢/
いはら /伊原/井原/
いはん /違反/違犯/
いば /射場/
いばく /帷幕/
いばしょ /居場所/
いばしんえん /意馬心猿/
いばら /茨/荊/棘/井原/
いばらき /茨木/茨城/
いばらきけん /茨城県/
いばらぎけん /茨城県/
いばらのみち /茨の道/
いひょう /意表/
いひん /遺品/
いびがわ /揖斐川/
いびき /鼾/
いびしゃ /居飛車/
いびつ /歪/
いふ /畏怖/委付/異父/
いふう /威風/遺風/異風/
いふきょうだい /異父兄弟/
いふく /衣服/威服/異腹/
いぶ /慰撫/威武/
いぶか /井深/
いぶき /息吹/伊吹/
いぶきやま /伊吹山/
いぶくろ /胃袋/
いぶしぎん /燻し銀/
いぶすき /指宿/
いぶつ /遺物/異物/
いぶり /胆振/
いぶん /異聞/異文/遺文/遺聞/
いぶんし /異分子/
いへき /胃壁/
いへん /異変/韋編/
いほう /違法/異邦/彙報/移封/遺芳/
いほうこうい /違法行為/
いほうじん /異邦人/
いほうせい /異方性/
いほうせいそきゃく /違法性阻却/
いほく /以北/
いほん /異本/
いぼ /異母/疣/
いぼく /遺墨/
いま /今/居間/
いまい /今井/
いまいち /今一/今市/
いまがわ /今川/
いまがわやき /今川焼/
いまこまち /今小町/
いまごろ /今頃/
いまさら /今更/
いましがた /今し方/
いましめ /戒め/
いまじぶん /今時分/
いますこし /今少し/
いまだ /未だ/
いまだに /未だに/
いまちづき /居待月/
いまで /今出/
いまど /今戸/
いまどき /今時/
いまにし /今西/
いまばり /今治/
いまひとつ /今一つ/
いまふう /今風/
いままで /今迄/
いまみち /今道/
いまみや /今宮/
いまむら /今村/
いまや /今や/
いまよう /今様/
いまよういろ /今様色/
いまり /伊万里/
いみ /意味/
いみあい /意味合い/
いみき /忌寸/
いみしん /意味深/
いみしんちょう /意味深長/
いみな /諱/
いみょう /異名/
いみろん /意味論/
いみん /移民/
いむ /医務/
いめい /異名/威名/遺命/
いも /芋/薯/藷/妹/
いもうと /妹/
いもかわ /芋川/
いもじ /鋳物師/
いもづる /芋蔓/
いもと /妹/
いもにかい /芋煮会/
いもの /鋳物/
いものし /鋳物師/
いもばん /芋版/
いもむし /芋虫/
いもめじ /芋目地/
いもようかん /芋羊羹/
いもん /慰問/
いや /嫌/厭/祖谷/弥/
いやいや /嫌々/
いやおう /否応/
いやがらせ /嫌がらせ/
いやき /嫌気/
いやく /意訳/違約/医薬/
いやくきん /違約金/
いやくぶがいひん /医薬部外品/
いやくぶんぎょう /医薬分業/
いやけ /嫌気/
いやしくも /苟も/
いやみ /厭み/嫌み/
いゆう /畏友/
いよ /伊予/壱与/
いよう /異様/医用/威容/偉容/
いよく /意欲/
いよくてき /意欲的/
いよみしま /伊予三島/
いら /苛/
いらい /以来/依頼/
いらいら /苛苛/苛々/
いらか /甍/
いらくさ /蕁麻/刺草/
いらつ /苛つ/
いらん /伊蘭/
いり /圦/入り/
いりあい /入会/
いりあいけん /入会権/
いりあいち /入会地/
いりうみ /入海/
いりえ /入江/
いりおもて /西表/
いりぐち /入口/
いりしお /入潮/
いりの /入野/
いりひ /入り日/
いりふね /入り船/
いりべ /入部/
いりむこ /入り婿/
いりもや /入母屋/
いりや /入谷/
いりゅう /慰留/遺留/移流/
いりゅうぶん /遺留分/
いりょう /医療/衣料/衣糧/
いりょうかご /医療過誤/
いりょうほう /医療法/
いりょうほうじん /医療法人/
いりょうほけん /医療保険/
いりょく /威力/偉力/意力/
いりよう /入り用/
いるい /衣類/異類/彙類/
いるか /海豚/
いるす /居留守/
いるま /入間/
いるまがわ /入間川/
いれい /異例/慰霊/威令/違例/
いれき /入木/
いれこ /入れ子/入籠/
いれずみ /入れ墨/
いれたて /入れ立て/
いれちがい /入れ違い/
いれぢえ /入れ知恵/
いれば /入れ歯/
いれふだ /入れ札/
いれもの /入れ物/容れ物/
いろ /色/
いろあい /色合い/
いろいろ /色々/色色/
いろう /慰労/遺漏/
いろうざき /石廊崎/
いろえんぴつ /色鉛筆/
いろおち /色落ち/
いろおとこ /色男/
いろおんど /色温度/
いろおんな /色女/
いろか /色香/
いろかず /色数/
いろかわ /色川/
いろがみ /色紙/
いろがわり /色変り/
いろけ /色気/
いろこ /色子/
いろこい /色恋/
いろごと /色事/
いろごとし /色事師/
いろごのみ /色好み/
いろじかけ /色仕掛け/
いろじろ /色白/
いろずり /色刷/
いろつや /色艶/
いろなおし /色直し/
いろはじるいしょう /色葉字類抄/
いろぶみ /色文/
いろぶんかい /色分解/
いろめ /色目/
いろめがね /色眼鏡/
いろもの /色物/
いろわけ /色分け/
いろん /異論/
いろんな /色んな/
いわ /違和/磐/岩/
いわあな /岩穴/
いわい /祝/岩井/
いわいごと /祝事/
いわお /巌/
いわかげ /岩陰/
いわかど /岩角/
いわかん /違和感/
いわき /岩城/磐城/
いわきさん /岩木山/
いわく /曰く/
いわくに /岩国/
いわくら /岩倉/
いわくらともみ /岩倉具視/
いわさ /岩佐/
いわさき /岩崎/
いわし /鰮/鰯/
いわした /岩下/
いわしろ /岩代/
いわずもがな /言わずもがな/
いわせ /岩瀬/
いわた /岩田/磐田/
いわつき /岩槻/
いわつぼ /岩壺/
いわて /岩手/
いわてけん /岩手県/
いわてだいがく /岩手大学/
いわと /岩戸/
いわな /岩魚/
いわなみ /岩波/
いわぬま /岩沼/
いわね /岩根/
いわの /岩野/
いわはだ /岩肌/
いわば /岩場/言わば/
いわふじ /岩藤/
いわふね /岩船/
いわぶち /岩淵/
いわぶろ /岩風呂/
いわま /岩間/
いわまつ /岩松/
いわみ /石見/岩見/
いわみざわ /岩見沢/
いわみず /岩水/
いわむろ /岩室/
いわもと /岩本/
いわや /岩屋/窟/
いわやま /岩山/
いわゆる /所謂/
いわれ /謂れ/
いん /音/引/印/隠/陰/因/韻/院/胤/淫/飲/姻/員/婬/尹/殷/韵/寅/蔭/咽/允/
いんい /陰萎/
いんいつ /隠逸/
いんうつ /陰鬱/
いんえい /陰影/印影/陰翳/
いんか /引火/允可/印可/
いんかく /陰核/
いんかしょくぶつ /隠花植物/
いんかてん /引火点/
いんかん /印鑑/
いんかんしょうめい /印鑑証明/
いんかんすう /陰関数/
いんが /因果/印画/陰画/
いんがい /院外/員外/
いんがおうほう /因果応報/
いんがかんけい /因果関係/
いんがし /印画紙/
いんがせい /因果性/
いんがりつ /因果律/
いんき /陰気/印記/
いんきょ /隠居/殷墟/允許/
いんきょく /陰極/
いんきょくせん /陰極線/
いんきん /陰金/
いんぎ /院議/
いんぎゃく /淫虐/
いんぎょう /印形/隠形/
いんぎん /慇懃/
いんぎんぶれい /慇懃無礼/
いんけい /陰茎/
いんけん /陰険/引見/隠顕/
いんげん /隠元/
いんこ /鸚哥/
いんこう /淫行/咽喉/印行/
いんこく /印刻/陰刻/
いんご /隠語/
いんごう /因業/院号/
いんさつ /印刷/
いんさつき /印刷機/
いんさつきょく /印刷局/
いんさん /陰惨/
いんざい /印材/
いんし /因子/印紙/淫祠/淫祀/
いんしぜい /印紙税/
いんしつ /陰湿/
いんしぶんせき /因子分析/
いんしゅ /飲酒/
いんしゅう /因襲/因習/
いんしょう /印象/印章/引照/引証/
いんしょうしゅぎ /印象主義/
いんしょうてき /印象的/
いんしょうは /印象派/
いんしょく /飲食/
いんしょくぶつ /飲食物/
いんしん /陰唇/殷賑/
いんじ /印字/印璽/韻字/
いんじき /印字機/
いんじゃ /隠者/
いんじゅ /印綬/
いんじゅん /因循/
いんじゅんこそく /因循姑息/
いんすい /引水/
いんすう /因数/
いんすうていり /因数定理/
いんすうぶんかい /因数分解/
いんずう /員数/
いんせい /院生/陰性/院政/隠棲/
いんせき /隕石/引責/姻戚/
いんせつ /引接/
いんせん /陰線/
いんぜい /印税/
いんぜん /隠然/
いんそつ /引率/
いんぞく /姻族/
いんたい /引退/隠退/
いんち /吋/引致/韻致/
いんちょう /院長/
いんてい /陰梃/
いんてん /院展/
いんでんき /陰電気/
いんでんし /陰電子/
いんとう /咽頭/淫蕩/
いんとうえん /咽頭炎/
いんとく /隠匿/
いんとくざい /隠匿罪/
いんとん /隠遁/
いんど /印度/
いんどう /引導/
いんどしな /印度支那/
いんない /院内/
いんないかんせん /院内感染/
いんに /陰に/因位/
いんにく /印肉/
いんにん /隠忍/
いんにんじちょう /隠忍自重/
いんねん /因縁/
いんのう /陰嚢/
いんのしま /因島/
いんのしょう /院庄/
いんばい /淫売/
いんばぬま /印旛沼/
いんばん /印判/
いんび /淫靡/隠微/
いんぴ /隠避/
いんぶ /陰部/
いんぶん /韻文/
いんぷ /陰阜/印譜/淫婦/
いんぺい /隠蔽/
いんぼう /陰謀/
いんぽん /印本/院本/淫本/
いんめつ /湮滅/隠滅/
いんめん /印面/
いんもう /陰毛/
いんもん /陰門/
いんゆ /隠喩/引喩/
いんよう /引用/飲用/陰陽/
いんようふ /引用符/
いんよく /淫欲/
いんらん /淫乱/
いんりつ /韻律/
いんりょう /飲料/
いんりょく /引力/
いんりょくけん /引力圏/
いんれい /引例/
いんれき /陰暦/
いんろう /印籠/
いんわい /淫猥/
う /雨/右/有/鵜/卯/迂/羽/宇/烏/禹/兎/得/憂/
うぃーん /維納/
うい /初/有為/
ういきょう /茴香/
ういざん /初産/
ういじん /初陣/
ういてんぺん /有為転変/
ういむじょう /有為無常/
ういろう /外郎/
うえ /上/飢え/↑/
うえき /植木/
うえきばち /植木鉢/
うえさま /上様/
うえした /上下/
うえじ /植字/
うえじま /上島/
うえすぎ /上杉/
うえすぎけんしん /上杉謙信/
うえた /植田/
うえだ /上田/
うえつ /羽越/
うえつけ /植付け/
うえつほんせん /羽越本線/
うえの /上野/
うえのえき /上野駅/
うえのはら /上野原/
うえはら /上原/
うえむら /植村/上村/
うえもん /右衛門/
うえん /迂遠/
うお /魚/
うおいちば /魚市場/
うおうさおう /右往左往/
うおがし /魚河岸/
うおごころ /魚心/
うおざ /魚座/
うおづ /魚津/
うおのめ /魚の目/
うおみ /魚見/
うおや /魚屋/
うおんびん /ウ音便/
うか /羽化/雨下/
うかい /迂回/鵜飼/
うかがいしょ /伺い書/
うかつ /迂闊/
うかとうせん /羽化登仙/
うかぬかお /浮かぬ顔/
うかれ /浮かれ/
うかれめ /浮かれ女/
うかわ /鵜川/
うかんむり /ウ冠/
うがい /嗽/
うがき /宇垣/
うがん /右岸/
うき /雨期/雨季/憂き/
うき> /浮/
うきあし /浮足/
うきいし /浮石/
うきくさ /浮草/
うきぐ /浮具/
うきぐも /浮雲/
うきごし /浮腰/
うきさんばし /浮桟橋/
うきしずみ /浮き沈み/
うきしま /浮島/
うきす /浮巣/
うきせいこう /雨奇晴好/
うきた /浮田/
うきつ /浮津/
うきな /浮名/
うきはし /浮橋/
うきふね /浮舟/
うきぶくろ /浮袋/
うきぼり /浮彫/
うきみ /浮身/憂き身/
うきめ /憂き目/
うきょう /右京/
うきよ /浮世/憂き世/
うきよえ /浮世絵/
うきよぼん /浮世本/
うきわ /浮輪/
うぐいす /鶯/鴬/
うぐいすいろ /鶯色/
うぐいすちゃ /鶯茶/
うけい /右傾/
うけいれ /受入れ/
うけおい /請負/
うけおいにん /請負人/
うけかた /受け方/
うけぐち /受け口/
うけこたえ /受け答え/
うけごし /受け腰/
うけざら /受け皿/
うけしょ /請書/
うけつけ /受付/
うけて /受け手/
うけとりかんじょう /受取勘定/
うけとりしょうしょ /受取証書/
うけとりてがた /受取手形/
うけとりにん /受取人/
うけにん /請人/
うけはらい /受け払い/
うけぶみ /請文/
うけみ /受身/
うけわたし /受け渡し/
うげん /迂言/右舷/
うこうれんらくせん /宇高連絡船/
うこさべん /右顧左眄/
うこん /鬱金/右近/
うこんいろ /鬱金色/
うご /羽後/雨後/
うごう /烏合/
うごうのしゅう /烏合の衆/
うごき /動き/
うさ /宇佐/憂さ/
うさぎ /兎/
うさぎごや /兎小屋/
うさばらし /憂さ晴らし/
うさみ /宇佐美/
うさん /胡散/
うさんくさい /胡散臭い/
うし /牛/丑/齲歯/
うしお /潮/
うしかい /牛飼/
うしがえる /牛蛙/
うしく /牛久/
うしごめ /牛込/
うしのひ /丑の日/
うしぶか /牛深/
うしまど /牛窓/
うしみつ /丑三つ/
うしや /牛屋/
うしらん /烏糸欄/
うしろ /後ろ/後/
うしろあし /後ろ足/
うしろあわせ /後ろ合せ/
うしろおし /後ろ押し/
うしろかげ /後ろ影/
うしろがみ /後ろ髪/
うしろすがた /後ろ姿/
うしろで /後ろ手/
うしろまえ /後ろ前/
うしろみ /後見/後ろ身/
うしろむき /後ろ向き/
うしろゆび /後ろ指/
うしわかまる /牛若丸/
うしんしつ /右心室/
うしんぼう /右心房/
うじ /氏/宇治/蛆/
うじい /雲林院/
うじがみ /氏神/
うじがわ /宇治川/
うじこ /氏子/
うじすじょう /氏素姓/
うじな /宇品/
うじふさ /氏房/
うじむし /蛆虫/
うじやまだ /宇治山田/
うじょう /羽状/鵜匠/有情/
うじょうふくよう /羽状複葉/
うじょうみゃく /羽状脈/
うす /臼/碓/薄/
うすあきない /薄商い/
うすあじ /薄味/
うすい /雨水/碓井/
うすいた /薄板/
うすいとうげ /碓氷峠/
うすいろ /薄色/
うすうす /薄々/
うすかわ /薄皮/
うすがみ /薄紙/
うすき /臼杵/
うすぎ /薄着/
うすぎぬ /薄衣/
うすくち /薄口/
うすくらがり /薄暗がり/
うすくれない /薄紅/
うすぐも /薄雲/
うすぐもり /薄曇/
うすげしょう /薄化粧/
うすこうばい /薄紅梅/
うすざん /有珠山/
うすじ /薄地/
うすじお /薄塩/
うすずみ /薄墨/
うすずみいろ /薄墨色/
うすずみがみ /薄墨紙/
うすちゃ /薄茶/
うすっぺら /薄っぺら/
うすで /薄手/
うすにく /薄肉/
うすねず /薄鼠/
うすのろ /薄鈍/
うすはないろ /薄花色/
うすはなざくら /薄花桜/
うすはなだ /薄縹/
うすば /薄刃/
うすび /薄日/
うすべに /薄紅/
うすみどり /薄緑/
うすむらさき /薄紫/
うすめ /薄目/
うすもの /薄物/
うすもよう /薄模様/
うすやみ /薄闇/
うすよう /薄葉/薄様/
うすら /薄ら/
うすわらい /薄笑い/
うず /渦/
うずき /疼き/
うずしお /渦潮/
うずでんりゅう /渦電流/
うずまき /渦巻/
うずまさ /太秦/
うずら /鶉/
うずらいし /鶉石/
うずらの /鶉野/
うせい /迂生/
うせつ /右折/
うせもの /失せ物/
うぜん /羽前/
うそ /嘘/鷽/嘯/
うそく /右側/
うそさむ /うそ寒/
うそっぱち /嘘っぱち/
うそつき /嘘吐き/
うそはっけんき /嘘発見器/
うそはっぴゃく /嘘八百/
うぞうむぞう /有象無象/
うた /歌/唄/
うたあわせ /歌合/
うたい /謡/
うたいて /歌い手/
うたいぼん /謡本/
うたいめ /歌い女/
うたかい /歌会/
うたかた /泡沫/
うたがい /疑い/
うたがわ /歌川/
うたぎれ /歌切/
うたぐち /歌口/
うたげ /宴/
うたごえ /歌声/
うたごころ /歌心/
うたしない /歌志内/
うたのかみ /雅楽頭/
うたひめ /歌姫/
うたびと /歌人/
うたまくら /歌枕/
うたまろ /歌麿/
うたよみ /歌詠み/
うだ /宇陀/
うだい /宇内/
うだいじん /右大臣/
うだがわ /宇田川/
うち /内/打ち/家/
うちあわせ /打合せ/
うちいけ /内池/
うちいで /打出/
うちいり /内入り/
うちいわい /内祝/
うちうち /内々/
うちうみ /内海/
うちうら /内浦/
うちかけ /打掛け/
うちかた /打ち方/内方/
うちがけ /内掛け/
うちがし /打菓子/
うちがたな /打刀/
うちがわ /内側/
うちき /内気/
うちきず /打傷/
うちきん /内金/
うちぎぬ /打衣/
うちくび /打首/
うちげんかん /内玄関/
うちこし /打越/
うちざた /内沙汰/
うちじに /討死/
うちだ /内田/
うちちがい /打違い/
うちづら /内面/
うちで /打出/
うちでし /内弟子/
うちでのこづち /打出の小槌/
うちなだ /内灘/
うちにわ /内庭/
うちぬき /打抜き/
うちの /内野/
うちのり /内法/
うちばば /内馬場/
うちばらい /内払い/
うちべんけい /内弁慶/
うちぼう /内房/
うちぼり /内堀/
うちまく /内幕/
うちまご /内孫/
うちまた /内股/
うちまたごうやく /内股膏薬/
うちまわり /内回り/
うちみ /打見/
うちみず /打ち水/
うちむき /内向き/
うちむそう /内無双/
うちむら /内村/
うちもうこ /内蒙古/
うちもの /打物/
うちやま /内山/
うちゅう /宇宙/雨中/
うちゅうきち /宇宙基地/
うちゅうくうかん /宇宙空間/
うちゅうこうがく /宇宙工学/
うちゅうじん /宇宙塵/
うちゅうせん /宇宙船/宇宙線/
うちゅうそくど /宇宙速度/
うちゅうつうしん /宇宙通信/
うちゅうていすう /宇宙定数/
うちゅうふく /宇宙服/
うちゅうろん /宇宙論/
うちゆ /内湯/
うちょうてん /有頂天/
うちわ /内輪/団扇/
うちわく /内枠/
うちわけ /内訳/
うちわたし /内渡し/
うちわもめ /内輪揉め/
うっき /鬱気/
うっくつ /鬱屈/
うっけつ /鬱血/鬱結/
うっこ /鬱乎/
うっこんこう /鬱金香/
うっせき /鬱積/
うっそう /鬱蒼/鬱葱/
うっそく /鬱塞/
うったえ /訴え/
うって /討手/
うっとう /鬱陶/
うっぷん /鬱憤/
うつ /鬱/欝/蔚/
うつうつ /鬱鬱/
うつくしがはら /美ヶ原/
うつし /写し/
うつしよ /現世/
うつせみ /空蝉/
うつぜん /鬱然/
うつつ /現/
うつて /打つ手/
うつのみや /宇都宮/
うつのみやし /宇都宮市/
うつびょう /鬱病/
うつぼつ /鬱勃/
うつゆう /鬱悒/
うつりが /移り香/
うつりぎ /移り気/
うつろ /虚ろ/
うつろい /移ろい/
うつわ /器/
うづき /卯月/
うてき /雨滴/
うてな /台/
うてん /雨天/
うで /腕/
うできき /腕利き/
うでぎ /腕木/
うでくらべ /腕比べ/
うでぐみ /腕組み/
うでじまん /腕自慢/
うでずもう /腕相撲/
うでぞろい /腕揃い/
うでたてふせ /腕立て伏せ/
うでだめし /腕試し/
うでっぷし /腕っ節/
うでどけい /腕時計/
うでぶし /腕節/
うでまえ /腕前/
うでまくら /腕枕/
うでわ /腕輪/
うと /宇土/
うどじんぐう /鵜戸神宮/
うどねり /内舎人/
うどん /饂飩/
うどんこ /饂飩粉/
うなかみ /海上/
うなぎ /鰻/
うなじ /項/
うなじゅう /鰻重/
うなどん /鰻丼/
うなばら /海原/
うなり /唸り/
うに /海胆/
うぬ /己/
うぬぼれ /自惚れ/
うね /畝/畦/
うねび /畝傍/
うねま /畝間/
うねめ /采女/
うの /宇野/
うのはな /卯の花/
うのみ /鵜呑み/
うのめたかのめ /鵜の目鷹の目/
うは /右派/
うば /乳母/姥/
うばいし /姥石/
うばぐるま /乳母車/
うばざくら /姥桜/
うひょう /雨氷/
うひょうえ /右兵衛/
うぶ /産/初/
うぶぎ /産着/
うぶげ /産毛/
うぶごえ /産声/
うぶすな /産土/
うぶや /産屋/
うぶゆ /産湯/
うへん /右辺/羽片/
うべ /宇部/宜/
うほう /右方/
うま /馬/午/
うまいち /馬市/
うまいり /馬入/
うまじるし /馬標/
うまずら /馬面/
うまたて /馬立/
うまづら /馬面/
うまに /甘煮/馬荷/
うまのすけ /右馬助/
うまのほね /馬の骨/
うまのり /馬乗り/
うまば /馬場/
うまぶね /馬槽/
うまみ /旨み/
うまや /厩/
うまれ /生れ/
うみ /海/膿/
うみかぜ /海風/
うみがめ /海亀/
うみせんやません /海千山千/
うみづき /産み月/
うみづり /海釣り/
うみどり /海鳥/
うみなり /海鳴り/
うみねこ /海猫/
うみのいえ /海の家/
うみのさち /海の幸/
うみびらき /海開き/
うみべ /海辺/
うみぼうず /海坊主/
うみやま /海山/
うむ /有無/
うめ /梅/
うめあわせ /埋め合せ/
うめがえ /梅枝/
うめがたに /梅ヶ谷/
うめがわ /梅川/
うめき /呻き/埋木/
うめくさ /埋草/
うめざき /梅崎/
うめしゅ /梅酒/
うめず /梅酢/
うめぞの /梅園/
うめぞめ /梅染/
うめたて /埋立て/
うめだ /梅田/
うめはら /梅原/
うめぼし /梅干/
うめみ /梅見/
うもう /羽毛/
うよ /紆余/
うよきょくせつ /紆余曲折/
うよく /右翼/
うら /裏/浦/占/
うら> /裏/
うらあみ /裏編み/
うらうち /裏打/
うらおもて /裏表/
うらかいどう /裏街道/
うらかぜ /浦風/
うらかた /裏方/
うらかみ /浦上/
うらが /浦賀/
うらがえし /裏返し/
うらがき /裏書/
うらがききんし /裏書禁止/
うらがきじょうと /裏書譲渡/
うらがきにん /裏書人/
うらがすいどう /浦賀水道/
うらがね /裏金/
うらがみ /浦上/
うらがわ /裏側/
うらきど /裏木戸/
うらきもん /裏鬼門/
うらぎり /裏切り/
うらぐち /裏口/
うらけい /裏罫/
うらごえ /裏声/
うらごし /裏漉し/
うらさく /裏作/
うらしま /浦島/
うらしまたろう /浦島太郎/
うらじ /裏地/
うらじろ /裏白/
うらじろれんが /裏白連歌/
うらせんけ /裏千家/
うらそえ /浦添/
うらづけ /裏付け/
うらて /裏手/
うらどおり /裏通り/
うらない /占い/
うらなみ /浦波/
うらにほん /裏日本/
うらにわ /裏庭/
うらはら /裏腹/
うらばなし /裏話/
うらばんぐみ /裏番組/
うらびょうし /裏表紙/
うらべ /卜部/浦辺/
うらぼん /盂蘭盆/
うらまち /裏町/
うらまど /裏窓/
うらみ /浦見/
うらみごと /怨み言/
うらみち /裏道/
うらめ /裏目/
うらめい /裏銘/
うらもん /裏門/
うらやす /浦安/
うらやま /裏山/浦山/
うらら /麗ら/
うららか /麗らか/
うらわ /浦和/
うり /瓜/
うりあげ /売上げ/
うりあげさいけん /売上債権/
うりあげぜい /売上税/
うりう /瓜生/
うりかい /売り買い/
うりかけ /売掛/
うりかけきん /売掛金/
うりかた /売方/
うりきれ /売切れ/
うりくち /売り口/
うりぐい /売り食い/
うりこ /売子/
うりことば /売り言葉/
うりごえ /売り声/
うりだし /売出し/
うりだてぎょく /売建玉/
うりて /売手/
うりぬし /売主/
うりね /売値/
うりば /売場/
うりもの /売物/
うりゅう /瓜生/
うりゅうの /瓜生野/
うりょう /雨量/
うりょうけい /雨量計/
うりわたし /売渡し/
うるう /閏/
うるうづき /閏月/
うるうどし /閏年/
うるうびょう /閏秒/
うるさ /煩/
うるさがた /うるさ型/
うるし /漆/
うるしえ /漆絵/
うるしまけ /漆負け/
うるち /粳/
うるむち /烏魯木斉/
うるめ /潤目/
うれあし /売れ足/
うれい /憂い/愁い/
うれえ /愁え/憂え/
うれくち /売れ口/
うれし /嬉し/
うれしがらせ /嬉しがらせ/
うれしなき /嬉し泣き/
うれしの /嬉野/
うれすじ /売れ筋/
うれだか /売れ高/
うれゆき /売行き/
うろ /迂路/空/雨露/
うろおぼえ /疎覚え/
うろこ /鱗/
うろこぐも /鱗雲/
うろん /胡乱/
うわ /上/
うわあご /上顎/
うわえ /上絵/
うわがき /上書き/
うわがみ /上紙/
うわき /浮気/
うわきもの /浮気者/
うわぎ /上着/上衣/
うわくちびる /上唇/
うわぐすり /釉/
うわぐつ /上靴/
うわごと /譫言/
うわさ /噂/
うわさばなし /噂話/
うわじま /宇和島/
うわすべり /上滑り/
うわずみ /上澄み/
うわちょうし /上調子/
うわっつら /上っ面/
うわっぱり /上っ張り/
うわつら /上面/
うわづつみ /上包み/
うわづみ /上積み/
うわて /上手/
うわてだしなげ /上手出し投げ/
うわてなげ /上手投げ/
うわてひねり /上手捻り/
うわに /上荷/
うわぬり /上塗り/
うわね /上値/
うわのせ /上乗せ/
うわのそら /上の空/
うわのり /上乗り/
うわばき /上履き/
うわばり /上張り/
うわべ /上辺/
うわまえ /上前/
うわむき /上向き/
うわめ /上目/
うわもの /上物/
うわや /上屋/
うわやく /上役/
うわん /右腕/
うん /運/雲/暈/云/
うんえい /運営/
うんか /雲霞/
うんかい /雲海/
うんが /運河/
うんき /運気/
うんきゅう /運休/
うんけい /運慶/
うんげん /繧繝/
うんこう /運行/運航/
うんこく /雲谷/
うんさん /雲散/
うんさんむしょう /雲散霧消/
うんざん /運算/
うんしゅう /温州/雲州/雲集/
うんしゅうむさん /雲集霧散/
うんしょうむさん /雲消霧散/
うんしん /運針/
うんじょう /雲上/運上/
うんすい /雲水/
うんせい /運勢/
うんぜん /雲仙/
うんぜんだけ /雲仙岳/
うんそう /運送/
うんそうぎょう /運送業/
うんそうじょう /運送状/
うんそうにん /運送人/
うんそうほけん /運送保険/
うんそうりょう /運送料/
うんだい /雲台/
うんだめし /運試し/
うんちく /蘊蓄/薀蓄/
うんちん /運賃/
うんちんひょう /運賃表/
うんてん /運転/
うんてんし /運転士/
うんてんしきん /運転資金/
うんてんしほん /運転資本/
うんてんしゅ /運転手/
うんでい /雲泥/
うんでいのさ /雲泥の差/
うんどう /運動/
うんどういん /運動員/
うんどうか /運動家/
うんどうかい /運動会/
うんどうがく /運動学/
うんどうぐつ /運動靴/
うんどうしんけい /運動神経/
うんどうじょう /運動場/
うんどうひ /運動費/
うんどうりょう /運動量/
うんどんこん /運鈍根/
うんなん /雲南/
うんぬん /云々/
うんの /海野/
うんのう /蘊奥/雲衲/
うんぱん /運搬/
うんぴつ /運筆/
うんぷてんぷ /運否天賦/
うんぼ /雲母/
うんむ /雲霧/
うんめい /運命/
うんめいてき /運命的/
うんめいろん /運命論/
うんも /雲母/
うんゆ /運輸/
うんゆだいじん /運輸大臣/
うんよう /運用/
うんりゅう /雲竜/
うんりょう /雲量/
え /回/会/絵/重/恵/餌/荏/江/柄/得/枝/慧/衣/榎/依/
えあわせ /絵合/
えい /英/映/影/鋭/詠/衛/穎/泳/永/栄/嬰/営/叡/咏/纓/翳/裔/郢/頴/盈/瑛/洩/曳/
えいい /鋭意/営為/栄位/
えいいん /影印/
えいえい /営々/営営/
えいえん /永遠/
えいか /穎果/詠歌/
えいかいわ /英会話/
えいかく /鋭角/
えいかん /栄冠/
えいが /映画/栄華/
えいがかん /映画館/
えいがかんとく /映画監督/
えいがげいじゅつ /映画芸術/
えいき /鋭気/英気/
えいきごう /嬰記号/
えいきゅう /永久/
えいきゅうきかん /永久機関/
えいきゅうし /永久歯/
えいきゅうじしゃく /永久磁石/
えいきょう /影響/永享/
えいぎょう /営業/
えいぎょうあんない /営業案内/
えいぎょうけん /営業権/
えいぎょうしょ /営業所/
えいぎょうしょとく /営業所得/
えいぎょうじょうと /営業譲渡/
えいぎょうていし /営業停止/
えいぎょうねんど /営業年度/
えいぎょうひ /営業費/
えいぎょうりえき /営業利益/
えいぎん /詠吟/
えいけい /鋭形/
えいけつ /永訣/英傑/
えいげんじ /永源寺/
えいこ /栄枯/
えいこう /栄光/曳航/曳行/営口/
えいこうだん /曳光弾/
えいこく /英国/
えいこさくけん /永小作権/
えいこん /英魂/
えいご /英語/
えいごう /永劫/
えいごうかいき /永劫回帰/
えいさい /英才/穎才/栄西/
えいさいきょういく /英才教育/
えいさくぶん /英作文/
えいざん /叡山/
えいし /英姿/英詩/英資/詠史/衛視/
えいしゃ /映写/営舎/泳者/
えいしゃき /映写機/
えいしゃく /栄爵/
えいしゃぼん /影写本/
えいしゃまく /映写幕/
えいしゅ /英主/
えいしゅつ /詠出/
えいしゅん /英俊/
えいしょ /英書/
えいしょう /詠唱/永正/
えいしょうぼん /影鈔本/影照本/
えいしょく /栄職/
えいしん /栄進/詠進/
えいじ /英字/嬰児/永治/
えいじしんぶん /英字新聞/
えいじつ /永日/
えいじゅ /衛戍/
えいじゅう /永住/
えいじょく /栄辱/
えいじん /英人/
えいすうじ /英数字/
えいせい /衛生/衛星/永世/永逝/永生/
えいせいがく /衛生学/
えいせいこく /衛星国/
えいせいちゅうけい /衛星中継/
えいせいちゅうりつ /永世中立/
えいせいつうしん /衛星通信/
えいせいてき /衛生的/
えいせいとし /衛星都市/
えいせいほうそう /衛星放送/
えいせん /曳船/
えいぜん /営繕/
えいそう /営倉/営巣/
えいぞう /映像/営造/影像/
えいぞうしんごう /映像信号/
えいぞうぶつ /営造物/
えいぞく /永続/
えいたい /永代/
えいたつ /栄達/
えいたん /詠嘆/詠歎/
えいだい /永代/
えいだつ /穎脱/
えいだん /営団/英断/
えいち /英知/叡知/叡智/
えいてい /営庭/
えいてん /栄転/栄典/
えいとく /永徳/
えいねん /永年/
えいねんきんぞく /永年勤続/
えいのう /営農/
えいはつ /映発/
えいびん /鋭敏/
えいふつ /英仏/
えいぶん /英文/
えいぶんがく /英文学/
えいぶんぽう /英文法/
えいへい /衛兵/
えいへいじ /永平寺/
えいべい /英米/
えいべいほう /英米法/
えいべつ /永別/
えいほう /英法/鋭鋒/
えいみん /永眠/
えいめい /英名/英明/
えいもん /営門/
えいやく /英訳/
えいゆう /英雄/
えいよ /栄誉/
えいよう /栄養/栄耀/
えいようえいが /栄耀栄華/
えいようか /栄養価/
えいようがく /栄養学/
えいようきかん /栄養器官/
えいようし /栄養士/
えいようしっちょう /栄養失調/
えいようしょく /栄養食/
えいようせいしょく /栄養生殖/
えいようそ /栄養素/
えいようはんしょく /栄養繁殖/
えいらく /永楽/
えいり /営利/鋭利/絵入り/
えいりこうい /営利行為/
えいりしゅぎ /営利主義/
えいりほうじん /営利法人/
えいりょ /叡慮/
えいりょう /英領/
えいりん /営林/映倫/
えいりんしょ /営林署;国有林の保護、監督を行う官庁/
えいれい /英霊/
えいれんぽう /英連邦/
えいわ /英和/永和/
えいわじてん /英和辞典/
えいん /会陰/
えかき /絵描き/絵書き/
えがお /笑顔/
えがたい /得難い/
えがら /絵柄/
えがわ /江川/
えき /駅/役/益/疫/液/易/腋/奕/掖/
えきいん /駅員/
えきうり /駅売り/
えきか /液化/腋窩/液果/腋下/
えきが /腋芽/
えきがく /疫学/易学/
えききょう /易経/
えききん /益金/
えきぎゅう /役牛/
えきざい /液剤/
えきしゃ /易者/駅舎/
えきしゃさんゆう /益者三友/
えきしょう /液晶/
えきじゅう /液汁/
えきじょう /液状/
えきす /越幾斯/
えきせいかくめい /易姓革命/
えきたい /液体/
えきたいねんりょう /液体燃料/
えきだん /易断/
えきちく /役畜/
えきちゅう /益虫/
えきちょう /駅長/益鳥/
えきでん /駅伝/
えきとう /駅頭/
えきどめ /駅止め/
えきばしゃ /駅馬車/
えきひ /液肥/
えきびょう /疫病/
えきべん /駅弁/
えきほんや /駅本屋/
えきむ /役務/
えきめい /駅名/
えきゆう /益友/
えきり /疫痢/
えきりんぼん /易林本/
えぎ /江木/
えぎぬ /絵絹/
えくぼ /靨/
えぐち /江口/
えけい /恵瓊/
えげ /会下/
えこ /依怙/
えこう /回向/
えこじ /依怙地/
えことば /絵詞/
えごころ /絵心/
えごよみ /絵暦/
えさ /餌/
えさし /江差/江刺/
えざら /絵皿/
えし /壊死/画師/絵師/
えしき /会式/
えしゃく /会釈/
えしゃじょうり /会者定離/
えじ /衛士/
えじき /餌食/
えじぷと /埃及/
えじま /江島/
えすがた /絵姿/
えず /絵図/
えずめん /絵図面/
えせ /似非/似而非/
えそ /壊疽/
えそらごと /絵空事/
えぞ /蝦夷/
えぞう /絵像/
えぞち /蝦夷地/
えたい /得体/
えたじま /江田島/
えだ /枝/
えだうち /枝打ち/
えだがわ /枝川/
えだげ /枝毛/
えだずみ /枝炭/
えだは /枝葉/
えだばん /枝番/
えだぶり /枝振り/
えだまめ /枝豆/
えだみち /枝道/
えちご /越後/
えちごじし /越後獅子/
えちごや /越後屋/
えちごゆざわ /越後湯沢/
えちぜん /越前/
えっきょう /越境/
えっけん /越権/謁見/
えっちゅう /越中/
えっちゅうじま /越中島/
えっとう /越冬/
えっぷく /悦服/
えっぺい /閲兵/
えつ /閲/越/謁/悦/粤/鉞/
えつどく /閲読/
えつねん /越年/
えつらく /悦楽/
えつらん /閲覧/
えつれき /閲歴/
えづけ /餌付け/
えて /得手/
えてかって /得手勝手/
えてこう /猿公/
えてして /得てして/
えでほん /絵手本/
えと /干支/
えとう /江藤/
えとき /絵解き/
えとく /会得/
えど /江戸/穢土/
えどえ /江戸絵/
えどがわ /江戸川/
えどがわく /江戸川区/
えどがわらんぽ /江戸川乱歩/
えどじだい /江戸時代/
えどじょう /江戸城/
えどっこ /江戸っ子/
えどばくふ /江戸幕府/
えどひがん /江戸彼岸/
えどま /江戸間/
えどまえ /江戸前/
えどむらさき /江戸紫/
えな /恵那/胞衣/
えにし /縁/
えにっき /絵日記/
えにわ /恵庭/
えのき /榎/
えのぐ /絵具/
えのしま /江ノ島/
えのもと /榎本/
えはがき /絵葉書/
えばら /江原/荏原/
えひめ /愛媛/
えひめけん /愛媛県/
えび /海老/蝦/
えびいろ /葡萄色/
えびす /恵比寿/夷/恵比須/戎/蛭子/
えびちゃ /葡萄茶/
えびな /海老名/
えびはら /海老原/
えふだ /絵札/
えふで /絵筆/
えべつ /江別/
えほん /絵本/
えぼし /烏帽子/
えま /絵馬/江馬/
えまき /絵巻/
えまきもの /絵巻物/
えみ /恵美/笑み/江見/
えみし /蝦夷/
えむら /江村/
えもじ /絵文字/
えもの /獲物/得物/
えものがたり /絵物語/
えもん /衣紋/衛門/
えようえいが /栄耀栄華/
えら /鰓/腮/
えり /襟/衿/
えりあか /襟垢/
えりがみ /襟髪/
えりくび /襟首/
えりぐり /襟刳り/
えりごのみ /選り好み/
えりしょう /襟章/
えりぬき /選り抜き/
えりまき /襟巻/
えりもと /襟元/
えりもみさき /襟裳岬/
えん /円/延/煙/淵/演/塩/鉛/遠/苑/艶/縁/猿/焔/炎/沿/援/掩/怨/宴/園/厭/燕/焉/冤/衍/烟/筵/薗/奄/鴛/堰/
えんいん /遠因/延引/援引/
えんう /煙雨/
えんうんどう /円運動/
えんえい /遠泳/
えんえき /演繹/
えんえきほう /演繹法/
えんえん /延々/奄奄/蜿蜒/
えんお /厭悪/
えんおう /閻王/
えんか /演歌/塩化/円価/円貨/嚥下/縁家/
えんかあえん /塩化亜鉛/
えんかい /宴会/沿海/遠海/延会/
えんかいしゅう /沿海州/
えんかく /遠隔/沿革/
えんかくそうさ /遠隔操作/
えんかつ /円滑/
えんかぶつ /塩化物/
えんかわせ /円為替/
えんかん /鉛管/煙管/
えんがい /塩害/煙害/円蓋/掩蓋/
えんがわ /縁側/
えんがん /沿岸/遠眼/
えんき /延期/塩基/
えんきょう /円鏡/延享/延慶/
えんきょく /婉曲/
えんきょり /遠距離/
えんきり /縁切り/
えんきん /遠近/
えんきんほう /遠近法/
えんぎ /演技/縁起/演義/延喜/
えんぎなおし /縁起直し/
えんぎもの /縁起物/
えんくう /円空/
えんぐみ /縁組/
えんぐん /援軍/
えんけい /円形/遠景/燕京/
えんけいげきじょう /円形劇場/
えんげ /嚥下/
えんげい /園芸/演芸/
えんげき /演劇/
えんげきろん /演劇論/
えんげつとう /偃月刀/
えんげん /淵源/怨言/
えんこ /円弧/縁故/塩湖/
えんこう /円光/
えんこうきんこう /遠交近攻/
えんこうじばん /円光寺版/
えんこうるい /円口類/
えんこん /怨恨/
えんご /援護/掩護/縁語/
えんごく /遠国/
えんごしゃげき /掩護射撃/
えんさ /怨嗟/
えんさき /縁先/
えんさん /塩酸/
えんざい /冤罪/
えんざん /演算/塩山/遠山/鉛槧/
えんざんかいろ /演算回路/
えんざんし /演算子/
えんし /遠視/艶姿/
えんしつ /煙室/
えんしゃっかん /円借款/
えんしゅう /演習/円周/遠州/
えんしゅうりつ /円周率/
えんしゅつ /演出/
えんしゅつか /演出家/
えんしょ /炎暑/艶書/
えんしょう /炎症/延焼/艶笑/袁紹/遠称/
えんしょく /怨色/
えんしん /遠心/延伸/円心/
えんしんぶんりき /遠心分離機/
えんしんりょく /遠心力/
えんじ /園児/臙脂/衍字/
えんじいろ /臙脂色/
えんじつてん /遠日点/
えんじゃ /縁者/演者/
えんじゃく /燕雀/
えんじゅ /槐/
えんじゅく /円熟/
えんじゅつ /演述/
えんじょ /援助/
えんじょう /炎上/
えんじん /猿人/円陣/厭人/
えんすい /円錐/塩水/
えんすいけい /円錐形/
えんすいめん /円錐面/
えんずい /延髄/
えんせい /遠征/厭世/延性/
えんせいがい /袁世凱/
えんせき /宴席/遠戚/
えんせん /沿線/厭戦/
えんぜつ /演説/演舌/
えんぜん /艶然/婉然/嫣然/
えんそ /塩素/遠祖/
えんそう /演奏/
えんそうかい /演奏会/
えんそうば /円相場/
えんそく /遠足/
えんそくこ /堰塞湖/
えんそさん /塩素酸/
えんたい /延滞/掩体/淹滞/
えんたいきん /延滞金/
えんたいりそく /延滞利息/
えんたいりょう /延滞料/
えんたく /円卓/
えんたん /鉛丹/
えんだい /演題/遠大/演台/縁台/
えんだか /円高/
えんだて /円建て/
えんだん /演壇/縁談/
えんち /遠地/園地/園池/
えんちてん /遠地点/
えんちゃく /延着/
えんちゅう /円柱/
えんちゅうめん /円柱面/
えんちょう /延長/園長/円頂/
えんちょうこくい /円頂黒衣/
えんちょうせん /延長線/延長戦/
えんちょく /鉛直/
えんちょくせん /鉛直線/
えんつづき /縁続き/
えんてい /園丁/堰堤/
えんてん /遠点/炎天/
えんてんかつだつ /円転滑脱/
えんでん /塩田/
えんとう /円筒/遠投/遠島/煙筒/
えんとく /延徳/
えんとつ /煙突/
えんどう /遠藤/沿道/豌豆/筵道/
えんどうまめ /豌豆豆/
えんどおい /縁遠い/
えんどく /煙毒/鉛毒/
えんにち /縁日/
えんねつ /炎熱/
えんねん /延年/
えんのう /延納/
えんのした /縁の下/
えんばく /燕麦/
えんばん /円板/円盤/鉛版/
えんぱつ /延発/
えんび /燕尾/
えんびふく /燕尾服/
えんぴ /円匙/
えんぴつ /鉛筆/
えんぶ /円舞/演武/演舞/
えんぶきょく /円舞曲/
えんぶん /塩分/艶聞/延文/艶文/
えんへんこう /円偏光/
えんぺい /掩蔽/援兵/
えんぺん /縁辺/
えんぼう /遠望/遠謀/怨望/
えんぽう /遠方/延宝/
えんぽん /円本/艶本/
えんま /閻魔/
えんまがお /閻魔顔/
えんまく /煙幕/
えんまだいおう /閻魔大王/
えんまちょう /閻魔帳/
えんまん /円満/
えんむ /煙霧/
えんむすび /縁結び/
えんめい /延命/
えんもく /演目/
えんもくとじ /鳶目兎耳/
えんや /塩冶/
えんやす /円安/
えんゆ /縁由/
えんゆう /円融/
えんゆうかい /園遊会/
えんよう /援用/遠洋/艶容/
えんようぎょぎょう /遠洋漁業/
えんようこうかい /遠洋航海/
えんらい /遠雷/遠来/
えんり /厭離/
えんりえど /厭離穢土/
えんりゃく /延暦/
えんりゃくじ /延暦寺/
えんりょ /遠慮/
えんるい /縁類/
えんろ /遠路/
お /汚/緒/小/尾/雄/御/男/牡/悪/苧/麻/於/和/
お> /御/
おーすとらりあ /濠太剌利/
おーすとりあ /墺太利/
おあがり /お上がり/
おい /甥/笈/追/老い/
おいえげい /御家芸/
おいえそうどう /御家騒動/
おいえりゅう /御家流/
おいかぜ /追風/
おいさき /生い先/老い先/
おいたち /生い立ち/
おいたて /追立て/
おいち /お市/
おいて /於て/追風/
おいてきぼり /置いてきぼり/
おいはぎ /追剥/
おいばらい /追い払い/
おいまつ /老松/
おいみどり /老緑/
おいめ /負い目/
おいらく /老いらく/
おいらん /花魁/
おいろなおし /御色直し/
おいわい /御祝/
おいわけ /追分/
おう /横/桜/応/黄/翁/王/殴/欧/押/往/奥/央/凹/皇/襖/墺/媼/鴎/旺/鴬/
おうあ /欧亜/
おうあん /応安/
おうい /王位/横位/
おういつ /横溢/汪溢/
おういん /押印/押韻/
おうう /奥羽/
おうえい /応永/
おうえん /応援/
おうおう /往々/
おうか /桜花/謳歌/欧化/応化/王化/
おうかくまく /横隔膜/
おうかん /王冠/往還/
おうが /横臥/
おうがい /鴎外/
おうきゅう /応急/王宮/
おうきゅうてあて /応急手当/
おうぎ /扇/
おうぎがた /扇形/
おうぎょく /黄玉/
おうけ /王家/
おうけん /王権/
おうこう /横行/往航/王侯/王公/
おうこく /王国/
おうごん /黄金/
おうごんじだい /黄金時代/
おうごんすう /黄金数/
おうさか /逢坂/
おうさつ /鏖殺/殴殺/応札/
おうさま /王様/
おうざ /王座/
おうし /牡牛/横死/雄牛/黄紙/
おうしざ /牡牛座/
おうしつ /王室/
おうしゃ /王者/
おうしゅ /応手/
おうしゅう /応酬/欧州/押収/奥州/
おうしょう /王将/応召/
おうしょうくん /王昭君/
おうしょく /黄色/
おうしん /往信/往診/
おうじ /王子/往時/皇子/往事/王地/
おうじつ /往日/
おうじつせい /横日性/
おうじゃ /王者/
おうじゅ /応需/
おうじゅく /黄熟/
おうじゅほうしょう /黄綬褒章/
おうじょ /王女/皇女/
おうじょう /往生/王城/
おうじょうぎわ /往生際/
おうすい /王水/
おうせ /逢瀬/
おうせい /旺盛/王政/王制/
おうせいふっこ /王政復古/
おうせつ /応接/
おうせつしつ /応接室/
おうせん /応戦/鏖戦/
おうそ /応訴/
おうそう /押送/
おうぞく /王族/
おうたい /応対/横隊/黄体/
おうだ /殴打/
おうだく /応諾/
おうだん /横断/黄疸/
おうだんほどう /横断歩道/
おうだんまく /横断幕/
おうだんめん /横断面/
おうち /樗/楝/
おうちゃく /横着/
おうちょう /王朝/
おうて /王手/追手/
おうてい /奥底/
おうてっこう /黄鉄鉱/
おうてびしゃ /王手飛車/
おうてん /横転/
おうと /嘔吐/王都/
おうとう /応答/桜桃/
おうとつ /凹凸/
おうど /王土/黄土/
おうどいろ /黄土色/
おうどう /王道/横道/黄道/黄銅/
おうどうこう /黄銅鉱/
おうどうらくど /王道楽土/
おうな /媼/嫗/
おうなつ /押捺/
おうに /黄丹/
おうにん /応仁/
おうにんのらん /応仁の乱/
おうねん /往年/
おうのう /懊悩/
おうはん /凹版/黄斑/
おうばく /黄蘗/黄檗/
おうばくさん /黄檗山/
おうばくしゅう /黄檗宗/
おうばくばん /黄檗版/
おうばんぶるまい /椀飯振舞/
おうひ /王妃/奥秘/
おうふう /欧風/
おうふく /往復/
おうふくきっぷ /往復切符/
おうふくはがき /往復葉書/
おうぶん /欧文/応分/
おうへい /横柄/
おうへん /応変/
おうべい /欧米/
おうほう /応報/王法/往訪/
おうぼ /応募/
おうぼう /横暴/
おうぼしゃりまわり /応募者利回り/
おうみ /近江/
おうみはちまん /近江八幡/
おうむ /鸚鵡/
おうむがえし /鸚鵡返し/
おうめ /青梅/
おうめかいどう /青梅街道/
おうめせん /青梅線/
おうめん /凹面/
おうめんきょう /凹面鏡/
おうもんきん /横紋筋/
おうよう /応用/鷹揚/
おうようかがく /応用科学/
おうようすうがく /応用数学/
おうようぶつりがく /応用物理学/
おうようもんだい /応用問題/
おうらい /往来/
おうらいもの /往来物/
おうりつ /王立/
おうりゅう /横流/
おうりょう /横領/
おうりょうざい /横領罪/
おうりょうし /押領使/
おうりょく /応力/
おうりん /黄燐/
おうろ /往路/欧露/
おえ /小江/
おえつ /嗚咽/
おお /大/
おお> /大/
おおあえ /大饗/
おおあざ /大字/
おおあし /大足/
おおあじ /大味/
おおあせ /大汗/
おおあたり /大当り/
おおあな /大穴/
おおあまのおうじ /大海人皇子/
おおあめ /大雨/
おおあらい /大洗/
おおあり /大有り/
おおあれ /大荒れ/
おおあわて /大慌て/
おおい /大井/大炊/
おおいがわ /大井川/
おおいし /大石/
おおいそ /大磯/
おおいた /大分/大板/
おおいたけん /大分県/
おおいたし /大分市/
おおいちばん /大一番/
おおいちょう /大銀杏/
おおいなる /大いなる/
おおいに /大いに/
おおいのかみ /大炊頭/
おおいり /大入り/
おおいりぶくろ /大入袋/
おおうえ /大上/
おおうち /大内/
おおうちばん /大内版/
おおうちやま /大内山/
おおうつし /大写し/
おおうなばら /大海原/
おおうら /大浦/
おおうりだし /大売出し/
おおえ /大江/大兄/
おおえど /大江戸/
おおえやま /大江山/
おおおか /大岡/
おおおく /大奥/
おおおとこ /大男/
おおかぜ /大風/
おおかた /大方/
おおかたびら /大帷子/
おおかべ /大壁/
おおかみ /狼/大神/
おおかわ /大川/
おおかわぐち /大川口/
おおがい /頁/大貝/
おおがき /大垣/
おおがた /大型/大潟/大形/
おおがたかぶ /大型株/
おおがね /大金/大鐘/
おおがねもち /大金持/
おおがら /大柄/
おおき /大木/
おおきい /大きい/
おおきど /大木戸/
おおきな /大きな/
おおきに /大きに/
おおきみ /大君/
おおぎり /大切り/
おおく /多く/
おおくち /大口/
おおくに /大国/
おおくびえ /大首絵/
おおくぼ /大久保/大窪/
おおくま /大熊/大隈/
おおくましげのぶ /大隈重信/
おおくら /大倉/大蔵/
おおくらだいじん /大蔵大臣/
おおぐれ /大暮/
おおげさ /大袈裟/
おおこうち /大河内/
おおごえ /大声/
おおごし /大腰/
おおごしょ /大御所/
おおごと /大事/
おおごま /大駒/
おおさか /大阪/大坂/
おおさかさやま /大阪狭山/
おおさかし /大阪市/
おおさかじょう /大阪城/
おおさかだいがく /大阪大学/
おおさかべん /大阪弁/
おおさかわん /大阪湾/
おおさじ /大匙/
おおざけ /大酒/
おおざっぱ /大雑把/
おおしお /大潮/大塩/
おおした /大下/
おおしま /大島/
おおしまつむぎ /大島紬/
おおじ /大路/祖父/
おおじしん /大地震/
おおじだい /大時代/
おおじょたい /大所帯/
おおすが /大須賀/
おおすぎ /大杉/
おおすじ /大筋/
おおすみ /大隅/
おおすみはんとう /大隅半島/
おおず /大洲/
おおずもう /大相撲/
おおせ /仰せ/
おおぜい /大勢/
おおぜき /大関/
おおそうじ /大掃除/
おおそとがり /大外刈/
おおぞこ /大底/
おおぞら /大空/
おおぞん /大損/
おおた /太田/大田/
おおたか /大高/
おおたがわ /太田川/
おおたき /大多喜/
おおたけ /大竹/
おおたちまわり /大立回り/
おおたに /大谷/
おおたま /大玉/
おおたわら /大田原/
おおだ /大田/
おおだい /大台/
おおだいこ /大太鼓/
おおだて /大館/
おおだてもの /大立者/
おおだな /大店/
おおだま /大玉/
おおだんな /大旦那/
おおつ /大津/
おおつえ /大津絵/
おおつか /大塚/大束/
おおつき /大槻/大月/
おおつごもり /大晦/
おおつし /大津市/
おおつち /大槌/
おおづかみ /大掴み/
おおづつ /大筒/
おおづな /大綱/
おおづめ /大詰め/
おおて /大手/
おおてすじ /大手筋/
おおてまち /大手町/
おおてもん /大手門/
おおで /大手/
おおでき /大出来/
おおとかげ /大蜥蜴/
おおとの /大殿/
おおとも /大友/大伴/
おおともそうりん /大友宗麟/
おおとり /大鳥/
おおとりじんじゃ /大鳥神社/
おおど /大戸/
おおどうぐ /大道具/
おおどおり /大通り/
おおどころ /大所/
おおどしま /大年増/
おおどまり /大泊/
おおな /大名/
おおなた /大鉈/
おおなみ /大波/
おおにし /大西/
おおにわ /大庭/
おおにんずう /大人数/
おおぬき /大貫/
おおぬま /大沼/
おおね /大根/
おおの /大野/
おおのじょう /大野城/
おおはし /大橋/
おおはじ /大恥/
おおはば /大幅/
おおはら /大原/
おおはらの /大原野/
おおば /大庭/大葉/祖母/大羽/大場/
おおばん /大判/大番/
おおばんぶるまい /大盤振舞/
おおひら /大平/
おおひろ /大広/
おおひろま /大広間/
おおびき /大引/
おおびゃくしょう /大百姓/
おおふなと /大船渡/
おおぶ /大府/
おおぶね /大船/
おおぶり /大降り/
おおぶろしき /大風呂敷/
おおべや /大部屋/
おおほん /大本/
おおぼけ /大歩危/
おおぼし /大星/
おおま /大間/
おおまえ /大前/
おおまか /大まか/
おおまがり /大曲/
おおまじめ /大真面目/
おおまた /大股/
おおまち /大町/
おおまわり /大回り/
おおまんどころ /大政所/
おおみ /大身/
おおみえ /大見得/
おおみしま /大三島/
おおみず /大水/
おおみそか /大晦日/
おおみだし /大見出し/
おおみち /大道/
おおみなと /大湊/
おおみね /大峰/
おおみや /大宮/
おおみよ /大御代/
おおみわじんじゃ /大神神社/
おおむかし /大昔/
おおむぎ /大麦/
おおむこう /大向う/
おおむた /大牟田/
おおむね /概/大旨/
おおむら /大村/
おおむらわん /大村湾/
おおむろ /大室/
おおめ /大目/
おおめだま /大目玉/
おおめつけ /大目付/
おおもじ /大文字/
おおもと /大本/
おおもときょう /大本教/
おおもの /大物/
おおもり /大森/大盛り/
おおもん /大門/
おおや /大矢/大谷/大家/大屋/大宅/
おおやけ /公/大宅/
おおやけごと /公事/
おおやま /大山/
おおやまざき /大山崎/
おおゆき /大雪/
おおゆみ /大弓/
おおよそ /大凡/
おおよど /大淀/
おおわざ /大技/
おおわし /大鷲/
おおわだ /大和田/
おおわらい /大笑い/
おおわらわ /大童/
おか /丘/岡/陸/
おかあさま /御母様/
おかえし /御返し/
おかくら /岡倉/
おかげ /御蔭/御陰/
おかげさま /御蔭様/
おかざき /岡崎/
おかしらつき /尾頭付/
おかじま /岡島/
おかじょうき /陸蒸気/
おかた /御方/
おかだ /岡田/
おかだけいすけ /岡田啓介/
おかっぴき /岡っ引き/
おかづり /陸釣/
おかばしょ /岡場所/
おかぶ /御株/
おかぼ /陸稲/
おかみ /御上/岡見/
おかめ /傍目/
おかめはちもく /傍目八目/
おかもち /岡持/
おかもと /岡本/
おかや /岡谷/
おかやま /岡山/
おかやまけん /岡山県/
おかやまし /岡山市/
おかやまだいがく /岡山大学/
おかん /悪寒/
おが /男鹿/
おがくず /大鋸屑/
おがさ /小笠/
おがさわら /小笠原/
おがさわらしょとう /小笠原諸島/
おがさわらりゅう /小笠原流/
おがた /尾形/緒方/
おがはんとう /男鹿半島/
おがみ /男神/
おがや /小萱/
おがら /麻幹/
おがわ /小川/
おき /隠岐/置き/熾/起き/沖/
おきあい /沖合/
おきいし /置石/
おきかえ /置換え/
おきがさ /置き傘/
おきざり /置き去り/
おきす /沖洲/
おきたま /置賜/
おきつ /興津/
おきつち /置き土/
おきて /掟/
おきてがみ /置手紙/
おきどけい /置時計/
おきどころ /置き所/
おきな /翁/
おきなあめ /翁飴/
おきなわ /沖縄/
おきなわけん /沖縄県/
おきなわほんとう /沖縄本島/
おきぬけ /起き抜け/
おきのしま /隠岐島/沖ノ島/
おきのとりしま /沖ノ鳥島/
おきば /置き場/
おきび /熾火/
おきぶみ /置文/
おきみやげ /置土産/
おきもの /置物/
おきゃん /御侠/
おきや /置屋/
おきわたし /沖渡し/
おぎ /荻/小木/
おぎの /荻野/
おぎはら /荻原/
おぎゅう /荻生/
おぎゅうそらい /荻生徂徠/
おぎわら /荻原/
おく /屋/奥/臆/憶/億/
おくがい /屋外/
おくがき /奥書/
おくがた /奥方/
おくさま /奥様/
おくさん /奥さん/
おくざしき /奥座敷/
おくしゃ /屋舎/
おくしりとう /奥尻島/
おくじょう /屋上/
おくじょちゅう /奥女中/
おくせつ /憶説/
おくそく /憶測/臆測/
おくそこ /奥底/
おくたま /奥多摩/
おくだ /奥田/
おくだん /臆断/
おくち /奥地/
おくちょう /億兆/
おくづけ /奥付/
おくて /奥手/
おくでん /奥伝/
おくど /奥土/
おくない /屋内/
おくに /阿国/
おくにっこう /奥日光/
おくのて /奥の手/
おくのほそみち /奥の細道/
おくば /奥歯/
おくびょう /臆病/
おくびょうかぜ /臆病風/
おくびょうもの /臆病者/
おくまん /億万/
おくまんちょうじゃ /億万長者/
おくむら /奥村/
おくめ /奥目/
おくめん /臆面/
おくやま /奥山/
おくゆき /奥行/
おくりがな /送り仮名/
おくりじょう /送り状/
おくりたおし /送り倒し/
おくりだし /送り出し/
おくりな /諡/
おくりぬし /送り主/贈り主/
おくりび /送り火/
おくりむかえ /送り迎え/
おくりもの /贈物/
おくれ /遅れ/
おくれげ /後れ毛/
おぐし /御髪/
おぐち /尾口/
おぐま /小熊/
おぐら /小倉/
おぐらあん /小倉餡/
おぐらしきし /小倉色紙/
おぐらやま /小倉山/
おぐり /小栗/
おぐるま /小車/
おけ /桶/
おけがわ /桶川/
おけつ /悪血/
おけはざま /桶狭間/
おけや /桶屋/
おけら /螻蛄/
おける /於ける/
おこう /汚行/
おことてん /乎古止点/
おこない /行い/
おこり /瘧/
おごおり /小郡/
おごそか /厳か/
おごり /奢り/傲り/驕り/
おさ /長/
おさえ /抑え/
おさえこみ /抑え込み/
おさけび /雄叫び/
おさだ /長田/
おさだめがき /御定書/
おさな /幼/
おさない /小山内/幼い/
おさながお /幼顔/
おさなご /幼子/
おさなごころ /幼心/
おさなともだち /幼友達/
おさななじみ /幼馴染/
おさふね /長船/
おさめ /納め/
おざき /尾崎/
おざきこうよう /尾崎紅葉/
おざさ /小笹/
おざわ /小沢/
おし /唖/押し/
おしえ /教え/押絵/
おしえご /教え子/
おしおき /御仕置/
おしかく /押角/
おしかけ /押し掛け/
おしかた /押方/
おしかわ /押川/
おしがみ /押紙/
おしきせ /御仕着せ/
おしげ /惜しげ/
おしずし /押鮨/
おしたおし /押し倒し/
おしだし /押し出し/
おしつけ /押し付け/
おして /押手/
おしどり /鴛鴦/
おしなべて /押し並べて/
おしね /晩稲/
おしば /押し葉/
おしばな /押し花/
おしべ /雄蕊/
おしほり /押堀/
おしま /渡島/
おしまい /御仕舞/
おしまはんとう /渡島半島/
おしむらくは /惜しむらくは/
おしめ /押目/
おしもんどう /押問答/
おしゃか /御釈迦/
おしゃかさま /御釈迦様/
おしゃく /御酌/
おしゃれ /御洒落/
おしゅう /汚臭/
おしょう /和尚/
おしょく /汚職/
おしろい /白粉/
おしわり /押割り/
おしん /悪心/
おしんこ /御新香/
おじか /牡鹿/
おじぎ /御辞儀/
おじぎそう /含羞草/
おじけ /怖気/
おじさん /小父さん/
おじま /小島/
おじゃま /御邪魔/
おじょう /御嬢/
おじょうさま /御嬢様/
おじょうさん /御嬢さん/
おじょく /汚辱/
おす /牡/雄/♂/
おすい /汚水/
おすみつき /御墨付/
おず /小津/
おせじ /御世辞/
おせち /御節/
おせっかい /御節介/
おせわさま /御世話様/
おせん /汚染/
おぜ /小瀬/
おぜぬま /尾瀬沼/
おぜんだて /御膳立て/
おそ /遅/
おそうまれ /遅生れ/
おそかれはやかれ /遅かれ早かれ/
おそざき /遅咲き/
おそし /遅し/
おそぢえ /遅知恵/
おそで /遅出/
おそば /遅場/御側/
おそばん /遅番/
おそまき /遅蒔き/
おそまつ /御粗末/
おそらく /恐らく/
おそらくは /恐らくは/
おそるべき /恐るべき/
おそれ /虞/恐れ/畏れ/
おそれざん /恐山/
おそん /汚損/
おたけび /雄叫び/
おたび /御旅/
おたふく /お多福/
おたま /御玉/
おたまじゃくし /御玉杓子/
おたる /小樽/
おだ /織田/小田/
おだいもく /御題目/
おだく /汚濁/
おだけ /雄竹/
おだて /煽て/
おだに /小谷/
おだのぶなが /織田信長/
おだのぶひで /織田信秀/
おだぶつ /御陀仏/
おだまき /苧環/
おだやか /穏やか/
おだわら /小田原/
おだわらじょう /小田原城/
おち /越智/落ち/
おちあい /落合/
おちうど /落人/
おちかた /遠方/
おちど /落度/越度/
おちば /落葉/
おちばたき /落葉焚き/
おちびと /落人/
おちむしゃ /落武者/
おちめ /落ち目/
おちゃ /御茶/
おちゃのみず /御茶の水/
おちょぼぐち /おちょぼ口/
おぢや /小千谷/
おっくう /億劫/
おって /追手/追って/
おってがき /追而書/
おっと /夫/
おっとせい /膃肭臍/
おっとりがたな /押っ取り刀/
おつ /乙/
おつげ /御告げ/
おつしゅ /乙種/
おつとめ /御勤め/
おつや /御通夜/
おづ /小津/
おづつ /尾筒/
おて /御手/
おてあげ /御手上げ/
おてん /汚点/
おてんとさま /御天道様/
おてんば /御転婆/
おでい /汚泥/
おと /音/乙/
おとうさま /御父様/
おとうと /弟/
おとうとでし /弟弟子/
おとうとぶん /弟分/
おとぎ /御伽/
おとぎぞうし /御伽草子/
おとぎりそう /弟切草/
おとこ /男/
おとこぐるい /男狂い/
おとこげいしゃ /男芸者/
おとこごころ /男心/
おとこざか /男坂/
おとこざかり /男盛り/
おとこしゅう /男衆/
おとこじょたい /男所帯/
おとこだて /男伊達/
おとこで /男手/
おとこなき /男泣き/
おとこのこ /男の子/
おとこまえ /男前/
おとこまさり /男勝り/
おとこみょうり /男冥利/
おとこもの /男物/
おとこやく /男役/
おとこやま /男山/
おとこゆ /男湯/
おとさた /音沙汰/
おとし /落し/
おとしあな /落し穴/
おとしだね /落し胤/
おとしもの /落し物/
おとずれ /訪れ/
おとつい /一昨日/
おととい /一昨日/
おととし /一昨年/
おとどまち /大殿町/
おとな /大人/
おとひめ /乙姫/
おとめ /少女/乙女/
おとめざ /乙女座/
おとり /囮/劣り/
おとろえ /衰え/
おとわ /音羽/
おとわやま /音羽山/
おどけ /戯け/
おどし /縅/脅し/
おどり /踊り/
おどりこ /踊り子/
おどりて /踊り手/
おどりば /踊り場/
おどろき /驚き/
おないどし /同い年/
おなが /尾長/
おなご /女子/
おなじ /同じ/
おなじく /同じく/
おなはま /小名浜/
おなみ /男波/
おなり /御成/
おなりもん /御成門/
おなんどいろ /御納戸色/
おに /鬼/
おにがしま /鬼ヶ島/
おにがわら /鬼瓦/
おにごっこ /鬼ごっこ/
おにば /鬼歯/
おにばば /鬼婆/
おにび /鬼火/
おにわばん /御庭番/
おね /尾根/
おの /斧/小野/己/
おのえ /尾上/
おのおの /各/各々/
おのずか /小野塚/
おのずから /自ずから/
おのずと /自ずと/
おのだ /小野田/
おのづか /小野塚/
おのでら /小野寺/
おのみち /尾道/
おのれ /己/
おはつ /お初/
おはよう /お早う/
おはら /大原/
おば /伯母/叔母/小母/
おばさん /小母さん/
おばすて /姨捨/
おばた /小幡/
おばな /雄花/尾花/
おばなざわ /尾花沢/
おばま /小浜/
おひつじざ /牡羊座/
おひとよし /御人好し/
おひなさま /御雛様/
おひゃくど /御百度/
おひれ /尾鰭/
おひろめ /御披露目/
おび /帯/飫肥/
おびいた /帯板/
おびえ /怯え/
おびがね /帯金/
おびがみ /帯紙/
おびこうこく /帯広告/
おびした /帯下/
おびじ /帯地/
おびじめ /帯締め/
おびじょう /帯状/
おびと /首/
おびばんぐみ /帯番組/
おびひろ /帯広/
おびふう /帯封/
おびれ /尾鰭/
おふくろ /御袋/
おふせ /御布施/
おふだ /御札/
おふみ /御文/
おふれ /御触れ/
おぶさ /綬/
おぶち /尾駮/
おぶつ /汚物/
おぶね /小舟/
おぼえ /覚え/
おぼえがき /覚書/
おぼえず /覚えず/
おぼし /男星/思し/
おぼつかな /覚束無/
おぼろ /朧/
おぼろづき /朧月/
おぼろづきよ /朧月夜/
おまいり /御参り/
おまえ /御前/
おまえざき /御前崎/
おまち /雄町/
おまつり /御祭/
おまつりさわぎ /御祭騒ぎ/
おまもり /御守り/
おみ /臣/麻績/
おみあし /御御足/
おみき /御神酒/
おみこし /御神輿/
おみそれ /御見逸れ/
おみなえし /女郎花/
おみね /小峰/
おみやげ /御土産/
おむろ /御室/
おめい /汚名/
おめいこう /御命講/
おめが /Ω/ω/
おめみえ /御目見得/
おも /主/面/重/
おもい /思い/想い/思/
おもいいれ /思い入れ/
おもいおもい /思い思い/
おもいがわ /思川/
おもいきや /思いきや/
おもいきり /思い切り/
おもいこみ /思い込み/
おもいちがい /思い違い/
おもいつき /思い付き/
おもいで /思い出/想い出/
おもいでばなし /思い出話/
おもいどおり /思い通り/
おもいもの /思い者/
おもかげ /面影/俤/
おもかじ /面舵/
おもがわり /面変り/
おもさ /重さ/
おもざし /面差し/
おもしろ /面白/
おもしろい /面白い/
おもしろさ /面白さ/
おもしろはんぶん /面白半分/
おもしろみ /面白み/
おもだか /沢瀉/
おもだち /面立ち/
おもちゃ /玩具/
おもて /表/面/
おもてあみ /表編み/
おもてかた /表方/
おもてかんばん /表看板/
おもてがえ /表替え/
おもてがき /表書き/
おもてがまえ /表構え/
おもてがわ /表側/
おもてぐち /表口/
おもてぐみ /表組/
おもてけい /表罫/
おもてげんかん /表玄関/
おもてさく /表作/
おもてざた /表沙汰/
おもてじ /表地/
おもてせんけ /表千家/
おもてどおり /表通り/
おもてにほん /表日本/
おもてむき /表向き/
おもてめい /表銘/
おもてもん /表門/
おもてやま /表山/
おもと /御許/
おもなが /面長/
おもに /重荷/主に/
おものがわ /雄物川/
おもばば /重馬場/
おもみ /重み/
おもむき /趣/
おももち /面持ち/
おもや /母屋/
おもゆ /重湯/
おもり /重り/錘/
おもわく /思わく/
おもわすれ /面忘れ/
おもわず /思わず/
おもわれびと /思われ人/
おや /親/
おやいも /親芋/
おやかた /親方/
おやかぶ /親株/
おやがいしゃ /親会社/
おやがかり /親掛り/
おやがわり /親代り/
おやく /御役/
おやこ /親子/
おやこうこう /親孝行/
おやこなべ /親子鍋/
おやご /親御/
おやごころ /親心/
おやざと /親里/
おやしお /親潮/
おやしらず /親不知/
おやじ /親父/親字/親爺/
おやだ /親田/
おやだま /親玉/
おやなぎ /小柳/
おやばか /親馬鹿/
おやふこう /親不孝/
おやぶね /親船/
おやぶん /親分/
おやべ /小矢部/
おやま /小山/女形/御山/
おやまだ /小山田/
おやみ /小止み/
おやもと /親元/
おやゆずり /親譲り/
おやゆび /親指/
およそ /凡そ/
およばずながら /及ばず乍ら/
および /及び/
およびごし /及び腰/
おらんだ /和蘭/
おり /折/澱/織/檻/
おりあい /折合い/
おりあしく /折悪しく/
おりおり /折々/
おりがみ /折紙/
おりけい /折罫/
おりしも /折しも/
おりちょう /折丁/
おりづめ /折詰/
おりづる /折鶴/
おりど /折戸/
おりばこ /折箱/
おりひめ /織姫/
おりひめぼし /織姫星/
おりふし /折節/
おりべ /織部/
おりべやき /織部焼/
おりほん /折本/
おりめ /折目/織目/
おりもと /織元/
おりもの /織物/下り物/
おりやま /折山/
おれ /折れ/俺/
おれい /御礼/
おれくち /折れ口/
おれさま /俺様/
おれせん /折れ線/
おれめ /折れ目/
おろ /悪露/疎/
おろおぼえ /疎覚え/
おろか /愚か/
おろかもの /愚か者/
おろし /卸/
おろしうり /卸売/
おろしうりしじょう /卸売市場/
おろしがね /下ろし金/
おろしどんや /卸問屋/
おろしね /卸値/
おろそか /疎か/
おろち /大蛇/
おわい /汚穢/
おわせ /尾鷲/
おわり /尾張/終り/
おわりあさひ /尾張旭/
おわりね /終値/
おん /音/温/御/恩/穏/遠/怨/
おん> /御/
おんあい /恩愛/
おんあつ /音圧/
おんい /恩威/
おんいき /音域/
おんいん /音韻/
おんえん /恩怨/
おんかい /音階/
おんかた /御方/
おんかん /音感/
おんが /温雅/
おんがえし /恩返し/
おんがく /音楽/
おんがくか /音楽家/
おんがくかい /音楽会/
おんがくどう /音楽堂/
おんがん /温顔/
おんき /遠忌/
おんきゅう /恩給/
おんきょう /音響/
おんきょうがく /音響学/
おんきょうこうか /音響効果/
おんぎ /恩義/恩誼/音義/
おんぎょく /音曲/
おんくん /音訓/
おんぐう /恩遇/
おんけい /恩恵/音型/
おんけつ /温血/
おんけん /穏健/
おんげん /音源/
おんこ /恩顧/
おんこう /温厚/恩光/
おんこちしん /温故知新/
おんこちしんしょ /温故知新書/
おんごく /遠国/
おんさ /音叉/
おんし /恩師/恩賜/
おんししょう /恩賜賞/
おんしつ /音質/温室/
おんしつこうか /温室効果/
おんしゃ /恩赦/
おんしゃく /恩借/
おんしゅう /恩讐/温州/
おんしょう /温床/恩賞/恩詔/
おんしょく /音色/温色/
おんしらず /恩知らず/
おんしん /音信/
おんじ /陰地/音字/
おんじゅうとんこう /温柔敦厚/
おんじゅつ /恩恤/
おんじゅん /温順/
おんじょう /温情/恩情/音声/
おんじん /恩人/
おんすい /温水/
おんすうりつ /音数律/
おんせい /音声/
おんせいがく /音声学/
おんせいきごう /音声記号/
おんせいげんご /音声言語/
おんせつ /音節/
おんせつもじ /音節文字/
おんせん /温泉/
おんせんやど /温泉宿/
おんそ /音素/
おんそく /音速/
おんそもじ /音素文字/
おんそろん /音素論/
おんぞうえく /怨憎会苦/
おんぞうし /御曹司/御曹子/
おんぞん /温存/
おんたい /御大/温帯/
おんたく /恩沢/
おんたけ /御岳/
おんだん /温暖/
おんち /音痴/恩地/
おんちゅう /御中/
おんちょう /恩寵/音調/温調/
おんつう /音通/
おんてい /音程/
おんてき /怨敵/
おんてん /恩典/温点/
おんと /音吐/
おんとう /穏当/温湯/
おんとろうろう /音吐朗朗/
おんど /温度/音頭/
おんどく /音読/
おんどけい /温度計/
おんどり /雄鳥/
おんどる /温突/
おんな /女/
おんない /恩愛/
おんながた /女形/
おんなぐるい /女狂い/
おんなけいず /婦系図/
おんなげいしゃ /女芸者/
おんなごころ /女心/
おんなごろし /女殺し/
おんなざか /女坂/
おんなざかり /女盛り/
おんなずき /女好き/
おんなずもう /女相撲/
おんなたらし /女誑し/
おんなで /女手/
おんなのこ /女の子/
おんなばら /女腹/
おんなへん /女偏/
おんなもじ /女文字/
おんなもの /女物/
おんなやく /女役/
おんなゆ /女湯/
おんねん /怨念/
おんのじ /御の字/
おんば /穏婆/
おんばひがさ /乳母日傘/
おんばん /音盤/
おんぱ /音波/恩波/
おんびき /音引き/
おんびん /穏便/音便/
おんぴょうもじ /音標文字/
おんぷ /音符/音譜/
おんみ /御身/
おんみつ /隠密/
おんみょう /陰陽/
おんめい /音名/恩命/
おんやく /音訳/
おんよう /陰陽/温容/
おんようじ /陰陽師/
おんようどう /陰陽道/
おんよく /温浴/
おんよみ /音読/
おんり /厭離/
おんりつ /音律/
おんりょう /音量/怨霊/温良/
おんわ /温和/穏和/
か /下/日/歌/化/家/仮/花/夏/火/暇/香/靴/果/蚊/過/貨/課/菓/華/荷/苛/箇/稼/禍/河/架/科/寡/嫁/嘉/可/加/佳/価/何/鹿/顆/呵/戈/渦/彼/个/訛/霞/迦/蝦/茄/禾/珂/伽/
か> /可/
かあさま /母様/
かあさん /母さん/
かあちゃん /母ちゃん/
かあつ /加圧/
かい /下位/甲斐/下意/歌意/交い/買い/飼い/会/回/解/開/改/界/海/階/快/介/壊/械/貝/戒/皆/絵/悔/怪/懐/街/塊/灰/魁/晦/拐/隗/潰/楷/槐/櫂/誡/諧/恢/廻/芥/蟹/
かい> /開/改/
かいあく /改悪/
かいあげ /買上げ/
かいあわせ /貝合せ/
かいい /怪異/魁偉/会意/介意/海尉/
かいいき /海域/
かいいぬ /飼犬/
かいいん /会員/改印/海員/開院/
かいいんとどけ /改印届/
かいうん /海運/開運/
かいえき /改易/
かいえん /開演/開園/海淵/海燕/
かいえんたい /海援隊/
かいおうせい /海王星/
かいおき /買い置き/
かいおん /快音/
かいおんせつ /開音節/
かいか /開花/開化/階下/開架/怪火/
かいかい /開会/恢恢/
かいかく /改革/
かいかけ /買掛/
かいかけきん /買掛金/
かいかた /買方/
かいかつ /快活/
かいかん /快感/会館/開管/開館/快漢/怪漢/開巻/
かいが /絵画/怪訝/
かいがい /海外/
かいがく /開学/
かいがら /貝殻/
かいがん /海岸/開眼/
かいがんせん /海岸線/
かいがんだんきゅう /海岸段丘/
かいき /怪奇/快気/回帰/会期/回忌/皆既/開基/買気/会規/
かいきげっしょく /皆既月食/
かいきしょく /皆既食/
かいきせん /回帰線/
かいきにっしょく /皆既日食/
かいきゅう /階級/懐旧/
かいきゅういしき /階級意識/
かいきょ /快挙/
かいきょう /回教/海峡/懐郷/海況/契経/
かいきょく /開局/
かいきり /買切り/
かいきん /解禁/皆勤/開襟/
かいぎ /会議/懐疑/回議/解義/
かいぎしょ /会議所/
かいぎは /懐疑派/
かいぎゃく /諧謔/
かいぎょ /海魚/
かいぎょう /改行/開業/
かいぎょうい /開業医/
かいぎろく /会議録/
かいくかん /開区間/
かいくん /回訓/
かいぐ /戒具/
かいぐい /買い食い/
かいぐん /海軍/
かいぐんしょう /海軍省/
かいぐんだいじん /海軍大臣/
かいけい /会計/会稽/塊茎/快慶/
かいけいかんさ /会計監査/
かいけいがく /会計学/
かいけいけんさいん /会計検査院/
かいけいけんさかん /会計検査官/
かいけいざん /会稽山/
かいけいし /会計士/
かいけいねんど /会計年度/
かいけいのはじ /会稽の恥/
かいけいほう /会計法/
かいけおんせん /皆生温泉/
かいけつ /解決/怪傑/魁傑/
かいけつびょう /壊血病/
かいけん /会見/改憲/懐剣/
かいげん /戒厳/改元/開眼/
かいげんれい /戒厳令/
かいこ /蚕/懐古/解雇/回顧/
かいこう /開校/開講/改稿/開口/回航/海港/海溝/開港/邂逅/開高/海口/
かいこういちばん /開口一番/
かいこうしょく /灰黄色/
かいこうたけし /開高健/
かいこく /戒告/海国/開国/
かいことば /買い言葉/
かいこま /甲斐駒/
かいこん /開墾/悔恨/塊根/
かいご /介護/改悟/戒護/悔悟/
かいごう /会合/改号/
かいごうしゅうき /会合周期/
かいごろし /飼い殺し/
かいさ /海佐/階差/
かいさい /開催/快哉/皆済/
かいさく /改作/
かいさつ /改札/開札/
かいさつぐち /改札口/
かいさん /解散/海産/
かいさんぶつ /海産物/
かいざい /介在/
かいざいく /貝細工/
かいざん /改竄/海山/
かいし /開始/海士/怪死/界紙/懐紙/
かいしき /解式/
かいしつ /開室/
かいしめ /買占め/
かいしゃ /会社/膾炙/
かいしゃいん /会社員/
かいしゃく /解釈/介錯/
かいしゃこうせい /会社更生/
かいしゃこうせいほう /会社更生法/
かいしゃほうもん /会社訪問/
かいしゅう /回収/改修/会衆/改宗/
かいしゅうごう /開集合/
かいしゅん /回春/悔悛/改悛/
かいしょ /会所/楷書/
かいしょう /解消/改称/甲斐性/快勝/海商/会商/海相/海将/
かいしょうなし /甲斐性無し/
かいしょく /会食/解職/
かいしん /改新/会心/回診/改心/快心/開進/回心/戒心/改進/
かいじ /開示/快事/海事/解字/怪事/
かいじゅ /槐樹/
かいじゅう /怪獣/懐柔/晦渋/海獣/
かいじょ /解除/介助/
かいじょう /会場/階乗/海上/開場/階上/回状/開城/塊状/
かいじょうけん /海上権/
かいじょうほけん /海上保険/
かいじょけん /解除権/
かいじょじょうけん /解除条件/
かいじん /怪人/灰塵/灰燼/
かいすい /海水/
かいすいぎ /海水着/
かいすいよく /海水浴/
かいすう /回数/
かいすうけん /回数券/
かいず /海津/海図/
かいずか /貝塚/
かいせい /快晴/改正/回生/開成/改姓/
かいせいそう /海成層/
かいせき /解析/会席/懐石/
かいせきがく /解析学/
かいせききかがく /解析幾何学/
かいせきりきがく /解析力学/
かいせきりょうり /会席料理/
かいせつ /解説/開設/回折/
かいせつこうし /回折格子/
かいせん /回線/会戦/回旋/改選/開戦/疥癬/海戦/回船/界線/
かいぜつ /快絶/
かいぜん /改善/
かいそ /改組/開祖/
かいそう /階層/改装/回想/回送/海草/会葬/快走/海藻/回漕/潰走/改葬/海曹/
かいそうしゃ /回送車/
かいそうろく /回想録/
かいそく /快速/会則/快足/
かいそん /海損/
かいぞう /改造/解像/
かいぞうど /解像度/
かいぞうりょく /解像力/
かいぞえ /介添/
かいぞく /海賊/
かいぞくせん /海賊船/
かいぞくばん /海賊版/
かいぞめ /買い初め/
かいぞん /買い損/
かいたい /解体/懐胎/拐帯/
かいたいしんしょ /解体新書/
かいたく /開拓/
かいだい /解題/改題/開題/
かいだく /快諾/
かいだし /買出し/
かいだん /階段/会談/怪談/戒壇/快談/
かいだんじ /快男児/
かいち /垣内/
かいちく /改築/
かいちゅう /海中/回虫/懐中/蛔虫/改鋳/
かいちゅうこうえん /海中公園/
かいちゅうでんとう /懐中電灯/
かいちゅうどけい /懐中時計/
かいちょう /会長/快調/階調/怪鳥/開帳/諧調/回腸/海鳥/開庁/
かいちょうおん /海潮音/
かいちん /開陳/
かいつう /開通/
かいつけ /買付/
かいづ /海津/
かいづか /貝塚/
かいて /買手/
かいてい /改訂/海底/改定/開廷/階梯/海程/
かいてき /快適/
かいてん /回転/開店/廻天/廻転/
かいてんいす /回転椅子/
かいてんうんどう /回転運動/
かいてんかく /回転角/
かいてんけい /回転計/
かいてんし /回転子/
かいてんしきん /回転資金/
かいてんじかい /回転磁界/
かいてんじく /回転軸/
かいてんずし /回転寿司/
かいてんたい /回転体/
かいてんたいしょう /回転対称/
かいてんめん /回転面/
かいてんもくば /回転木馬/
かいてんよく /回転翼/
かいてんりつ /回転率/
かいでん /皆伝/
かいと /垣内/
かいとう /回答/解凍/解答/会頭/怪盗/解糖/快刀/解党/
かいとうしゃ /回答者/
かいとり /買取り/
かいどう /街道/会堂/海道/会同/怪童/
かいどく /解読/回読/買い得/会読/
かいどり /飼鳥/
かいな /腕/
かいなん /海南/海難/
かいなんきゅうじょ /海難救助/
かいなんとう /海南島/
かいにゅう /介入/
かいにゅうけん /介入権/
かいにん /解任/懐妊/
かいにんじょう /解任状/
かいぬし /買主/飼主/
かいね /買値/
かいは /会派/
かいはい /改廃/
かいはくしつ /灰白質/
かいはくしょく /灰白色/
かいはつ /開発/
かいはん /改版/解版/
かいば /海馬/飼葉/
かいばしら /貝柱/
かいばつ /海抜/皆伐/
かいばら /貝原/
かいひ /回避/会費/開扉/
かいひょう /開票/解氷/界標/海氷/
かいひん /海浜/
かいび /快美/
かいびかえ /買い控え/
かいびゃく /開闢/
かいふ /回付/開府/
かいふう /開封/海風/
かいふき /貝吹/
かいふく /回復/快復/恢復/
かいふくき /回復期/
かいふくとうき /回復登記/
かいぶつ /怪物/
かいぶつせいむ /開物成務/
かいぶん /回文/灰分/怪聞/
かいぶんしょ /怪文書/
かいへい /開閉/海兵/開平/皆兵/
かいへいき /開閉器/
かいへいたい /海兵隊/
かいへいだん /海兵団/
かいへん /改変/改編/壊変/貝偏/
かいべん /快弁/快便/
かいぺーじ /改頁/
かいほ /海保/
かいほう /開放/解放/解法/会報/介抱/快方/快報/海北/海法/開方/開法/懐抱/
かいほうけいざい /開放経済/
かいほうげん /開放弦/
かいほうてき /開放的/
かいほつ /開発/
かいぼう /解剖/海防/海膨/
かいぼうかん /海防艦/
かいぼうがく /解剖学/
かいまく /開幕/
かいまみ /垣間見/
かいみょう /戒名/
かいみん /快眠/
かいむ /皆無/会務/
かいめい /解明/改名/晦明/開明/晦冥/
かいめつ /壊滅/潰滅/
かいめん /界面/海綿/海面/
かいめんたい /海綿体/
かいめんどうぶつ /海綿動物/
かいもうぶ /回盲部/
かいもく /皆目/
かいもどし /買戻し/
かいもの /買物/
かいもん /開門/海門/開聞/
かいもんきょくろ /槐門棘路/
かいもんだけ /開聞岳/
かいやく /解約/改訳/
かいゆ /快癒/
かいゆう /回遊/会友/
かいゆうぎょ /回遊魚/
かいよう /潰瘍/海洋/海容/
かいらい /傀儡/
かいらいせいけん /傀儡政権/
かいらく /快楽/偕楽/
かいらくえん /偕楽園/
かいらくげんそく /快楽原則/
かいらん /回覧/解纜/潰乱/壊乱/
かいらんばん /回覧板/
かいり /浬/乖離/海里/解離/
かいりき /怪力/
かいりく /海陸/
かいりつ /戒律/介立/
かいりど /解離度/
かいりゅう /海流/開立/
かいりょう /改良/
かいりょうしゅ /改良種/
かいりょくらんしん /怪力乱神/
かいれい /海嶺/回礼/
かいれき /改暦/
かいれつ /開裂/
かいろ /回路/海路/懐炉/
かいろう /回廊/海老/
かいろうどうけつ /偕老同穴/
かいわ /会話/
かいわい /界隈/
かいわたい /会話体/
かいわぶん /会話文/
かいわん /怪腕/
かいん /課員/下院/禍因/
かうん /家運/
かえ /替え/
かえい /嘉永/
かえうた /替え歌/
かえき /課役/
かえぎ /替着/
かえし /返し/
かえしわざ /返し技/
かえだま /替え玉/
かえち /替地/
かえって /却って/
かえで /楓/
かえば /替刃/
かえり /帰り/返り/
かえりうち /返り討ち/
かえりぎわ /帰り際/
かえりぐるま /帰り車/
かえりざき /返り咲き/
かえりしんざん /帰り新参/
かえりち /返り血/
かえりみ /顧み/
かえりみち /帰り道/帰り路/
かえる /蛙/
かえん /火焔/火炎/
かえんびん /火炎瓶/
かお /顔/貌/
かおあわせ /顔合せ/
かおいろ /顔色/
かおう /花王/花押/嘉応/
かおかたち /顔容/
かおく /家屋/
かおじゃしん /顔写真/
かおだし /顔出し/
かおだち /顔立ち/
かおつき /顔付き/
かおつなぎ /顔繋ぎ/
かおづくり /顔作り/
かおぶれ /顔触れ/
かおまけ /顔負け/
かおみしり /顔見知り/
かおみせ /顔見世/
かおむけ /顔向け/
かおやく /顔役/
かおよごし /顔汚し/
かおよせ /顔寄せ/
かおり /香/
かおる /馨/
かか /嬶/仮果/
かかあ /嚊/嬶/
かかえ /抱え/
かかく /価格/過客/家格/
かかさま /母様/
かかし /案山子/
かかと /踵/
かかみがはら /各務原/
かかり /係り/係/
かかりあい /掛り合い/
かかりいん /係員/
かかりかん /係官/
かかりじょし /係助詞/
かかりちょう /係長/
かかん /果敢/可換/花冠/
かが /加賀/花芽/
かがい /加害/課外/禍害/
かがいしゃ /加害者/
かがく /科学/化学/価額/下顎/歌学/
かがくきかい /化学機械/
かがくぎじゅつ /科学技術/
かがくけつごう /化学結合/
かがくこうがく /化学工学/
かがくこうぎょう /化学工業/
かがくごうせい /化学合成/
かがくしき /化学式/
かがくしゃ /科学者/
かがくじょうたつ /下学上達/
かがくせん /化学戦/
かがくせんい /化学繊維/
かがくそうさ /科学捜査/
かがくてき /科学的/化学的/
かがくてきほうほう /科学的方法/
かがくてつがく /科学哲学/
かがくはくぶつかん /科学博物館/
かがくはんのう /化学反応/
かがくばんのう /科学万能/
かがくひりょう /化学肥料/
かがくぶっしつ /化学物質/
かがくへいき /化学兵器/
かがくへいこう /化学平衡/
かがくへんか /化学変化/
かがくりょうほう /化学療法/
かがみ /鏡/各務/
かがみいし /鏡石/
かがみいわ /鏡岩/
かがみえ /鏡絵/
かがみがた /鏡形/
かがみびらき /鏡開き/
かがみやま /鏡山/
かがやき /輝き/
かがり /篝/
かがりび /篝火/
かがわ /香川/賀川/
かがわけん /香川県/
かがん /河岸/
かき /下記/柿/垣/夏期/夏季/牡蠣/火気/花器/火器/花卉/花期/蛎/
かきあげ /掻揚げ/掻上げ/書上げ/
かきあじ /書き味/
かきいれ /書入れ/
かきいれどき /書入れ時/
かきいろ /柿色/
かきうち /垣内/
かきおき /書き置き/
かきかえ /書換え/
かきかた /書き方/
かきがらちょう /蠣殻町/
かきことば /書き言葉/
かきこみ /書込み/
かきざき /蠣崎/
かきしぶ /柿渋/
かきすて /書捨て/掻き捨て/
かきそんじ /書き損じ/
かきぞめ /書き初め/
かきた /垣田/
かきつ /嘉吉/
かきつけ /書付/
かきつばた /燕子花/杜若/
かきて /書き手/
かきとめ /書留/
かきとめゆうびん /書留郵便/
かきどなり /垣隣/
かきね /垣根/
かきねごし /垣根越し/
かきのき /柿木/
かきのもと /柿本/
かきはん /書判/
かきほん /書本/
かきもち /柿餅/欠餅/
かきもの /書き物/
かきゃくせん /貨客船/
かきや /垣屋/
かきやまぶし /柿山伏/
かきゅう /下級/火急/加給/火球/
かきゅうき /過給器/
かきゅうしん /下級審/
かきゅうてき /可及的/
かきょ /科挙/家居/
かきょう /佳境/架橋/華僑/家郷/歌境/嘉慶/
かきょく /歌曲/
かきわけ /書分け/
かきん /課金/瑕瑾/家禽/
かぎ /鉤/鍵/鈎/
かぎあな /鍵穴/
かぎざき /鉤裂き/
かぎっこ /鍵っ子/
かぎづめ /鉤爪/
かぎばり /鉤針/
かぎゃく /可逆/加虐/苛虐/
かぎゃくはんのう /可逆反応/
かぎゅう /蝸牛/
かぎょう /稼業/家業/課業/カ行/
かぎり /限り/限/
かく /確/各/客/覚/革/隔/閣/較/角/穫/獲/殻/核/格/拡/廓/嚇/画/斯く/鶴/槨/膈/佳句/郭/赫/撹/劃/
かく> /各/
かくあげ /格上げ/
かくい /各位/隔意/
かくいつ /画一/劃一/
かくいつてき /画一的/
かくいん /各員/客員/閣員/
かくう /架空/
かくうんどうりょう /角運動量/
かくえき /各駅/
かくえきていしゃ /各駅停車/
かくおち /角落ち/
かくかい /角界/
かくかく /赫赫/赫々/
かくかぞく /核家族/
かくがい /格外/閣外/
かくがた /角形/
かくがり /角刈り/
かくきょり /角距離/
かくぎ /閣議/
かくぎょう /角行/
かくぎり /角切り/
かくげつ /隔月/各月/客月/
かくげん /格言/確言/
かくこう /各校/
かくご /覚悟/
かくさ /格差/較差/
かくさく /画策/
かくさげ /格下げ/
かくさん /拡散/核酸/
かくざ /擱坐/擱座/
かくざい /角材/
かくざとう /角砂糖/
かくし /各氏/各紙/各誌/客死/核子/隠し/
かくしあじ /隠し味/
かくしき /格式/
かくしげい /隠し芸/
かくしご /隠し子/
かくしごと /隠し事/
かくしつ /確執/角質/革質/
かくしつそう /角質層/
かくして /斯くして/
かくしどころ /隠し所/
かくしどり /隠し撮り/
かくしゃ /覚者/各社/
かくしゃく /矍鑠/
かくしゅ /各種/馘首/鶴首/核種/
かくしゅう /隔週/確執/客愁/
かくしゅがっこう /各種学校/
かくしょ /各所/
かくしょう /確証/各省/
かくしょうたい /核小体/
かくしん /確信/革新/核心/客心/隔心/
かくしんてき /革新的/
かくしんはん /確信犯/
かくじ /各自/
かくじっけん /核実験/
かくじつ /確実/隔日/
かくじつせい /確実性/
かくじゅう /拡充/
かくじょし /格助詞/
かくじん /各人/
かくすい /角錐/
かくすう /画数/
かくせい /覚醒/隔世/廓清/
かくせいいでん /隔世遺伝/
かくせいき /拡声器/
かくせいざい /覚醒剤/
かくせつ /確説/
かくぜつ /隔絶/
かくぜん /画然/確然/
かくそう /各層/核相/
かくそくど /角速度/
かくたる /確たる/
かくたん /喀痰/
かくたんけんさ /喀痰検査/
かくだ /角田/
かくだい /拡大/
かくだいかいしゃく /拡大解釈/
かくだいきょう /拡大鏡/
かくだいず /拡大図/
かくだん /格段/
かくだんとう /核弾頭/
かくち /各地/隔地/確知/覚知/
かくちく /角逐/
かくちしゃ /隔地者/
かくちゅう /角柱/
かくちょう /拡張/格調/
かくちょうし /拡張子/
かくづけ /格付け/
かくて /斯くて/
かくてい /確定/各停/
かくていきげん /確定期限/
かくていきばいばい /確定期売買/
かくていさいけん /確定債権/
かくていさいばん /確定裁判/
かくていしんこく /確定申告/
かくていてき /確定的/
かくていはんけつ /確定判決/
かくていひづけ /確定日付/
かくとう /格闘/確答/挌闘/
かくとく /獲得/
かくとくけいしつ /獲得形質/
かくど /角度/確度/客土/赫怒/
かくない /閣内/
かくに /角煮/
かくにん /確認/
かくねん /隔年/客年/
かくねんりょう /核燃料/
かくのう /格納/
かくのうこ /格納庫/
かくのごとく /斯くの如く/
かくのだて /角館/
かくは /各派/
かくはん /各般/拡販/攪拌/
かくはんのう /核反応/
かくばくはつ /核爆発/
かくひつ /擱筆/
かくびき /画引き/
かくぶ /各部/
かくぶそう /核武装/
かくぶつちち /格物致知/
かくぶん /確聞/
かくぶんれつ /核分裂/
かくへいき /核兵器/
かくへき /隔壁/
かくべえじし /角兵衛獅子/
かくべつ /格別/各別/
かくほ /確保/
かくほう /確報/
かくほうめん /各方面/
かくぼう /角帽/
かくまき /角巻/
かくまく /角膜/隔膜/
かくまくいしょく /角膜移植/
かくまくえん /角膜炎/
かくめい /革命/
かくめいか /革命家/
かくめいじ /革命児/
かくめいてき /革命的/
かくもん /各問/
かくやく /確約/
かくやす /格安/
かくゆうごう /核融合/
かくよう /各様/
かくよくし /核抑止/
かくらん /攪乱/霍乱/
かくり /隔離/
かくりつ /確率/確立/
かくりつかてい /確率過程/
かくりつぶんぷ /確率分布/
かくりつへんすう /確率変数/
かくりつろん /確率論/
かくりょう /閣僚/
かくりょく /核力/
かくれ /隠れ/
かくれが /隠れ家/
かくろん /各論/
かくん /家訓/家君/
かぐ /家具/下愚/
かぐう /仮寓/
かぐやひめ /かぐや姫/
かぐら /神楽/
かけ /賭け/掛/
かけい /家系/筧/家計/火刑/花形/嘉慶/下掲/花茎/家兄/
かけいず /家系図/
かけいぼ /家計簿/
かけうり /掛売り/
かけおち /駆落ち/
かけがい /掛買い/
かけがえ /掛替え/
かけがわ /掛川/
かけきん /掛金/
かけごえ /掛け声/
かけごと /賭事/
かけざん /掛け算/
かけしょうぎ /賭将棋/
かけじく /掛軸/
かけず /掛図/
かけだおれ /掛倒れ/
かけつ /可決/
かけど /掛戸/
かけはし /懸橋/掛橋/
かけひ /筧/
かけひき /駆引き/
かけふだ /掛札/
かけぶとん /掛布団/
かけべり /掛減り/
かけもち /掛持ち/
かけもの /掛物/
かけら /欠片/
かけん /家憲/
かげ /陰/影/蔭/鹿毛/翳/
かげえ /影絵/
かげき /過激/歌劇/
かげきは /過激派/
かげきよ /景清/
かげぐち /陰口/
かげごと /陰言/
かげぜん /陰膳/
かげつ /花月/箇月/
かげひなた /陰日向/
かげぼうし /影法師/
かげぼし /陰干し/
かげむしゃ /影武者/
かげやま /陰山/景山/
かげゆ /勘解由/
かげろう /陽炎/蜉蝣/蜻蛉/
かげん /加減/下限/下弦/寡言/嘉元/嘉言/
かげんじょうじょ /加減乗除/
かげんほう /加減法/
かこ /過去/
かこいもの /囲い者/
かこう /加工/河口/下降/火口/河港/加功/華甲/下行/仮構/花梗/歌稿/
かこうがん /花崗岩/
かこうきゅう /火口丘/
かこうげん /火口原/
かこうこ /火口湖/
かこうし /加工紙/
かこうせん /下降線/
かこうぜき /河口堰/
かこうち /可耕地/
かこうぼうえき /加工貿易/
かこがわ /加古川/
かこく /苛酷/過酷/河谷/
かこくぼん /家刻本/
かこくるい /禾穀類/
かこちょう /過去帳/
かこつ /化骨/
かこぶんし /過去分詞/
かこみきじ /囲み記事/
かこん /禍根/
かご /籠/過誤/加護/駕籠/華語/訛語/歌語/篭/
かごう /化合/加号/
かごうぶつ /化合物/
かごしま /鹿児島/
かごしまけん /鹿児島県/
かごしまし /鹿児島市/
かごしまだいがく /鹿児島大学/
かごしまほんせん /鹿児島本線/
かごしまわん /鹿児島湾/
かごと /託言/
かごん /過言/
かさ /笠/傘/嵩/瘡/暈/
かさい /火災/家裁/葛西/加西/
かさいし /笠石/
かさいぶつ /火砕物/
かさいほけん /火災保険/
かさいりゅう /火砕流/
かさおか /笠岡/
かさぎ /笠置/笠木/
かさく /佳作/家作/寡作/仮作/
かささぎ /鵲/
かさたて /傘立/
かさだか /嵩高/
かさつ /苛察/
かさなり /重なり/
かさぬい /笠縫/
かさね /重ね/襲/
かさねぎ /重ね着/
かさねつぎ /重ね継ぎ/
かさねて /重ねて/
かさぶくろ /傘袋/
かさま /笠間/
かさまつ /笠松/
かさん /加算/可算/家産/加餐/
かさんか /過酸化/
かさんかすいそ /過酸化水素/
かさんかすいそすい /過酸化水素水/
かさんき /加算器/
かさんしゅうごう /可算集合/
かさんぜい /加算税/
かさんめいし /可算名詞/
かざ /風/
かざあな /風穴/
かざい /家財/貨財/歌材/
かざおれ /風折れ/
かざかみ /風上/
かざぐも /風雲/
かざぐるま /風車/
かざごえ /風邪声/
かざしも /風下/
かざと /風戸/
かざはや /風早/
かざま /風間/
かざまつり /風祭/
かざまど /風窓/
かざみ /風見/
かざみどり /風見鶏/
かざむき /風向き/
かざりけ /飾り気/
かざりけい /飾り罫/
かざりつけ /飾り付け/
かざりまど /飾り窓/
かざりもの /飾り物/
かざん /火山/華山/
かざんかつどう /火山活動/
かざんがん /火山岩/
かざんさいせつぶつ /火山砕屑物/
かざんたい /火山帯/
かざんだん /火山弾/
かざんばい /火山灰/
かざんばいち /火山灰地/
かざんみゃく /火山脈/
かし /菓子/歌詞/橿/樫/可視/貸し/仮死/華氏/下肢/河岸/瑕疵/下賜/花糸/
かしい /香椎/
かしうり /貸売り/
かしかた /貸方/
かしかぶ /貸株/
かしかり /貸し借り/
かしかん /下士官/
かしきり /貸切り/
かしきん /貸金/
かしこうせん /可視光線/
かしこし /貸越/
かしさげ /貸下げ/
かしざしき /貸座敷/
かししつ /貸室/
かしせき /貸席/
かしたんぽ /瑕疵担保/
かしだおれ /貸倒れ/
かしだし /貸出し/
かしち /貸地/
かしちん /貸賃/
かしつ /過失/
かしつけ /貸付/
かしつけきん /貸付金/
かしつけしんたく /貸付信託/
かしつそうさい /過失相殺/
かしつちしざい /過失致死罪/
かしつはん /過失犯/
かして /貸手/
かしぬし /貸し主/
かしはら /橿原/
かしはらじんぐう /橿原神宮/
かしば /香芝/
かしぶんさん /家資分散/
かしほん /貸本/
かしま /鹿島/貸間/加島/
かしまじんぐう /鹿島神宮/
かしもと /貸元/
かしゃ /貨車/火車/華奢/
かしゃく /呵責/仮借/
かしゃわたし /貨車渡し/
かしや /貸家/菓子屋/
かしゅ /歌手/火酒/
かしゅう /歌集/加州/賀集/家集/
かしょ /個所/箇所/家書/歌書/華胥/
かしょう /仮称/過小/歌唱/過少/寡少/火傷/花床/仮象/河床/過賞/
かしょく /過食/華燭/河蝕/火食/仮植/家職/貨殖/
かしょくのてん /華燭の典/
かしょぶんしょとく /可処分所得/
かしら /頭/
かしらがき /頭書/
かしらもじ /頭文字/
かしりょう /貸料/
かしわ /柏/栢/
かしわぎ /柏木/
かしわざき /柏崎/
かしわで /膳/
かしわもち /柏餅/
かしわら /柏原/
かしん /過信/家臣/歌神/花唇/花心/
かしんれいげつ /嘉辰令月/
かじ /梶/家事/火事/鍛冶/舵/加持/嘉事/
かじい /梶井/
かじいもとじろう /梶井基次郎/
かじか /鰍/杜父魚/河鹿/
かじかざわ /鰍沢/
かじき /梶木/
かじきとう /加持祈祷/
かじし /華字紙/
かじしんぱんほう /家事審判法/
かじた /梶田/
かじつ /果実/過日/佳日/夏日/
かじつしゅ /果実酒/
かじば /火事場/
かじゃ /冠者/
かじや /鍛冶屋/
かじゅ /果樹/
かじゅう /加重/果汁/荷重/過重/
かじゅえん /果樹園/
かじょ /加除/花序/
かじょう /過剰/箇条/渦状/
かじょうがき /箇条書/
かじょうさはん /家常茶飯/
かじょうせいさん /過剰生産/
かじょうひなん /過剰避難/
かじょうぼうえい /過剰防衛/
かじわら /梶原/
かじん /家人/歌人/佳人/寡人/
かじんはくめい /佳人薄命/
かす /糟/粕/滓/
かすい /下垂/河水/加水/仮睡/
かすいたい /下垂体/
かすいぶんかい /加水分解/
かすう /仮数/
かすかべ /春日部/
かすが /春日/
かすがい /春日井/鎹/
かすがの /春日野/
かすがのつぼね /春日局/
かすがばん /春日版/
かすがやま /春日山/
かすじる /粕汁/
かすみ /霞/
かすみがうら /霞ヶ浦/
かすみがせき /霞ヶ関/
かすり /絣/飛白/
かすれ /掠れ/
かず /数/下図/
かずえのかみ /主計頭/
かずかず /数々/
かずさ /上総/
かずしれず /数知れず/
かずのこ /数の子/
かずのみや /和宮/
かずもの /数物/
かずら /葛/鬘/蔓/
かせ /枷/綛/
かせい /火星/化成/仮性/加勢/家政/苛性/化政/火勢/
かせいかり /苛性加里/
かせいがく /家政学/
かせいがん /火成岩/
かせいきんし /仮性近視/
かせいひりょう /化成肥料/
かせいふ /家政婦/
かせき /化石/
かせぎだか /稼ぎ高/
かせだ /加世田/
かせつ /仮説/仮設/架設/佳節/
かせやま /鹿背山/
かせん /寡占/加線/河川/化繊/架線/火線/歌仙/
かせんしき /河川敷/
かせんほう /河川法/
かぜ /風/風邪/
かぜあたり /風当り/
かぜい /課税/苛税/寡勢/
かぜいかかく /課税価格/
かぜいしょとく /課税所得/
かぜいひょうじゅん /課税標準/
かぜいぶっけん /課税物件/
かぜいりつ /課税率/
かぜぐすり /風邪薬/
かぜけ /風邪気/
かぜごこち /風邪心地/
かぜとおし /風通し/
かぜまち /風待ち/
かぜむき /風向き/
かぜん /果然/
かそ /過疎/
かそう /仮想/下層/仮装/火葬/家相/仮葬/
かそうかいきゅう /下層階級/
かそうきおく /仮想記憶/
かそうぎょうれつ /仮装行列/
かそうてきこく /仮想敵国/
かそうば /火葬場/
かそく /加速/
かそくき /加速器/
かそくけい /加速系/
かそくど /加速度/
かそくどてき /加速度的/
かそざい /可塑剤/
かそせい /可塑性/
かぞ /加須/
かぞう /家蔵/加増/架蔵/
かぞえ /数え/
かぞえうた /数え歌/
かぞえどし /数え年/
かぞく /家族/華族/
かぞくおん /下属音/
かぞくけいかく /家族計画/
かぞくてあて /家族手当/
かぞくぶろ /家族風呂/
かぞくれき /家族歴/
かた /方/形/型/肩/潟/片/過多/夥多/
かたあし /片足/
かたあて /肩当て/
かたい /下腿/過怠/歌体/
かたいきん /過怠金/
かたいじ /片意地/
かたいっぽう /片一方/
かたいと /片糸/
かたいなか /片田舎/
かたいれ /肩入れ/
かたうで /片腕/
かたうらみ /片恨み/
かたおか /片岡/
かたおし /型押し/
かたおなみ /片男波/
かたおもい /片思い/
かたおや /片親/
かたかけ /肩掛/
かたかな /片仮名/
かたかま /片鎌/
かたがい /片貝/
かたがき /肩書/
かたがた /方々/旁/
かたがみ /型紙/
かたがわ /片側/
かたがわり /肩代り/
かたき /敵/
かたきうち /敵討/
かたきやく /敵役/
かたぎ /気質/堅気/
かたぎり /片桐/
かたく /仮託/家宅/火宅/花托/
かたくそうさく /家宅捜索/
かたくち /片口/
かたくな /頑/
かたくら /片倉/
かたくり /片栗/
かたくりこ /片栗粉/
かたくるし /堅苦し/
かたぐち /肩口/
かたぐるま /肩車/
かたこ /片子/
かたこい /片恋/
かたこう /形鋼/
かたこと /片言/
かたこり /肩凝り/
かたさき /肩先/
かたしき /型式/
かたしろ /形代/
かたじん /堅人/
かたすかし /肩透かし/
かたすみ /片隅/
かたず /固唾/
かたずみ /堅炭/
かたせ /片瀬/
かたそで /片袖/
かたた /堅田/
かたたがえ /方違え/
かただより /片便り/
かたち /形/容/
かたっぱし /片っ端/
かたつ /下達/
かたつき /型付/肩付き/
かたつけ /型付け/
かたつむり /蝸牛/
かたづけ /片付け/
かたて /片手/
かたてま /片手間/
かたとき /片時/
かたな /刀/
かたながり /刀狩/
かたなし /形無し/
かたならし /肩慣らし/
かたの /交野/
かたはい /片肺/
かたはし /片端/
かたはだ /片肌/
かたはば /肩幅/
かたはら /片腹/
かたばかり /形許り/
かたばみ /酢漿草/
かたひざ /片膝/
かたひじ /肩肘/片肘/
かたびら /帷子/
かたふち /片淵/
かたぶつ /堅物/
かたほ /片帆/
かたほう /片方/
かたぼう /片棒/
かたま /片間/
かたまち /片町/
かたまちせん /片町線/
かたまり /塊/
かたみ /肩身/形見/片身/
かたみだし /肩見出し/
かたみち /片道/
かたむき /傾き/
かたむすび /片結び/
かため /片目/固め/
かためん /片面/
かたもの /型物/
かたや /片や/
かたやぶり /型破り/
かたやま /片山/
かたやまづおんせん /片山津温泉/
かたやまてつ /片山哲/
かたより /偏り/
かたり /語り/騙り/
かたりくち /語り口/
かたりぐさ /語り種/
かたわ /片輪/片端/
かたわき /片脇/
かたわら /傍ら/
かたわれ /片割れ/
かたん /下端/荷担/
かたんちゅうてつ /可鍛鋳鉄/
かだ /伽陀/
かだい /課題/過大/仮題/架台/歌題/
かだん /花壇/歌壇/果断/華壇/
かち /価値/勝ち/徒/
かちいろ /褐色/
かちうま /勝馬/
かちかん /価値観/
かちき /勝気/
かちく /家畜/
かちたいけい /価値体系/
かちどき /勝鬨/
かちどきばし /勝鬨橋/
かちなのり /勝名乗り/
かちにげ /勝ち逃げ/
かちはんだん /価値判断/
かちぼし /勝星/
かちまけ /勝ち負け/
かちみ /勝ち味/
かちめ /勝ち目/
かちゅう /渦中/火中/家中/花柱/華中/
かちょう /課長/家長/蚊帳/花鳥/
かちょうおん /可聴音/
かちょうきん /課徴金/
かちょうふうえい /花鳥諷詠/
かちょうふうげつ /花鳥風月/
かっ /合/
かっか /閣下/各課/
かっかい /各界/角界/
かっかく /赫々/
かっかざん /活火山/
かっき /活気/画期/
かっきてき /画期的/劃期的/
かっきゅう /割球/
かっきょ /割拠/
かっきょう /活況/
かっくう /滑空/
かっくうき /滑空機/
かっくうひ /滑空比/
かっけ /脚気/
かっけい /活計/
かっけつ /喀血/
かっこ /括弧/確固/各個/各戸/【/】/（/）/』/『/［/］/
かっこう /格好/滑降/恰好/郭公/
かっこうきょうぎ /滑降競技/
かっこうほう /滑腔砲/
かっこくぼん /活刻本/
かっこげきは /各個撃破/
かっこんとう /葛根湯/
かっさい /喝采/
かっさつ /活殺/
かっさつじざい /活殺自在/
かっしゃ /滑車/活写/
かっしょう /滑翔/
かっしょく /褐色/
かっすい /渇水/活水/
かっすいき /渇水期/
かっせい /活性/
かっせいか /活性化/
かっせいざい /活性剤/
かっせいたん /活性炭/
かっせき /滑石/
かっせん /合戦/活栓/割線/
かっそう /滑走/
かっそうろ /滑走路/
かったつ /闊達/
かったん /褐炭/
かっちゃく /活着/
かって /勝手/
かってぐち /勝手口/
かっとう /葛藤/
かっぱ /河童/喝破/合羽/
かっぱつ /活発/活溌/
かっぱつはっち /活溌溌地/
かっぱばん /合羽版/
かっぱん /活版/
かっぱんずり /活版刷/
かっぱんぼん /活版本/
かっぷ /割賦/
かっぷく /恰幅/割腹/
かっぷはんばい /割賦販売/
かっぽ /闊歩/
かっぽう /割烹/
かっぽうぎ /割烹着/
かつ /割/滑/轄/褐/渇/活/括/喝/勝/闊/濶/且つ/且/葛/恰/
かつあい /割愛/
かつうら /勝浦/
かつえき /滑液/
かつお /鰹/
かつおぶし /鰹節/
かつかいしゅう /勝海舟/
かつかつ /戛戛/
かつかわ /勝川/
かつがん /活眼/
かつぎや /担ぎ屋/
かつぎょ /活魚/
かつげき /活劇/
かつざい /滑剤/
かつしか /葛飾/
かつじ /活字/
かつじたい /活字体/
かつじばん /活字版/
かつじぼん /活字本/
かつじょう /割譲/
かつた /勝田/
かつだんそう /活断層/
かつて /嘗て/曾て/
かつどう /活動/
かつどうしゃしん /活動写真/
かつどうてき /活動的/
かつぬま /勝沼/
かつぶし /鰹節/
かつべん /活弁/
かつぼう /渇望/
かつま /勝間/
かつまた /且つ又/
かつみ /勝見/
かつもく /刮目/
かつやく /活躍/
かつやくきん /括約筋/
かつやま /勝山/
かつよう /活用/
かつようけい /活用形/
かつようご /活用語/
かつようごび /活用語尾/
かつようじゅ /闊葉樹/
かつら /桂/鬘/
かつらがわ /桂川/
かつらぎ /葛城/
かつらく /滑落/
かつらたろう /桂太郎/
かつらだ /桂田/
かつらのみや /桂宮/
かつらはま /桂浜/
かつらりきゅう /桂離宮/
かつりょく /活力/
かつれい /割礼/
かつれき /活歴/
かつろ /活路/
かづき /香月/
かづの /鹿角/
かて /糧/
かてい /仮定/過程/課程/家庭/河底/
かていか /家庭科/
かていきょういく /家庭教育/
かていきょうし /家庭教師/
かていけい /仮定形/
かていさいばんしょ /家庭裁判所/
かていそうぎ /家庭争議/
かていてき /家庭的/
かていほう /仮定法/
かていほうもん /家庭訪問/
かていらん /家庭欄/
かてん /加点/火点/
かでな /嘉手納/
かでん /家電/家伝/荷電/瓜田/訛伝/
かでんし /価電子/
かでんしょ /花伝書/
かと /過渡/
かとう /加藤/下等/寡頭/果糖/過当/河東/
かとうしょくぶつ /下等植物/
かとうともさぶろう /加藤友三郎/
かとき /過渡期/
かとく /家督/嘉徳/
かとくそうぞく /家督相続/
かとてき /過渡的/
かとり /香取/
かとりじんぐう /香取神宮/
かとりせんこう /蚊取線香/
かとん /火遁/
かど /角/門/過度/廉/┘/┐/┌/└/
かどう /稼働/華道/可動/稼動/火道/渦動/歌道/
かどうかん /仮導管/
かどうりつ /稼働率/
かどかわ /角革/
かどがまえ /門構え/
かどく /可読/
かどくせい /可読性/
かどぐち /門口/
かどた /門田/
かどち /角地/
かどちがい /門違い/
かどで /門出/
かどばしら /門柱/
かどび /門火/
かどべ /門辺/
かどま /門真/
かどまつ /門松/
かどや /門屋/角屋/
かどわき /門脇/
かな /金/仮名/哉/
かなあみ /金網/
かない /家内/
かないこうぎょう /家内工業/
かないろ /金色/
かないろうどう /家内労働/
かなえ /鼎/
かなおか /金岡/
かなかんじへんかん /仮名漢字変換/
かながき /仮名書き/
かながた /金型/
かながわ /神奈川/
かながわけん /神奈川県/
かなきりごえ /金切り声/
かなくぎ /金釘/
かなくず /金屑/
かなぐ /金具/
かなぐし /金串/
かなざわ /金沢/
かなざわし /金沢市/
かなざわだいがく /金沢大学/
かなざわはっけい /金沢八景/
かなざわぶんこ /金沢文庫/
かなしばり /金縛り/
かなしみ /悲しみ/
かなぞうし /仮名草子/
かなた /彼方/
かなだ /加奈陀/
かなつぼ /金壺/
かなづち /金槌/鉄鎚/
かなで /奏で/
かなでほん /仮名手本/
かなぶつ /金仏/
かなへび /金蛇/
かなぼん /仮名本/
かなまり /鋺/
かなめ /要/
かなめいし /要石/
かなもじ /仮名文字/
かなもの /金物/
かなもり /金森/
かなや /金谷/金屋/
かなやま /金山/
かならず /必ず/
かならずしも /必ずしも/
かならずや /必ずや/
かなり /可成/
かなん /河南/華南/火難/
かに /蟹/可児/
かにく /果肉/
かにこうせん /蟹工船/
かにざ /蟹座/
かにばさみ /蟹挟み/
かにゅう /加入/
かぬま /鹿沼/
かね /金/鐘/
かねあい /兼合い/
かねかし /金貸し/
かねがさき /金ヶ崎/
かねぐら /金蔵/
かねぐり /金繰り/
かねこ /金子/
かねざわ /金沢/
かねしげ /金重/
かねじゃく /矩尺/曲尺/
かねだか /金高/
かねつ /加熱/過熱/火熱/
かねづかい /金遣い/
かねづまり /金詰り/
かねづる /金蔓/
かねて /予て/
かねばこ /金箱/
かねばなれ /金離れ/
かねへん /金偏/
かねまき /金巻/鐘巻/
かねまわり /金回り/
かねめ /金目/
かねもうけ /金儲け/
かねもと /兼元/金元/
かねん /可燃/
かねんせい /可燃性/
かねんど /過年度/
かねんどししゅつ /過年度支出/
かねんぶつ /可燃物/
かの /狩野/彼の/彼/
かのう /可能/化膿/狩野/加納/嘉納/加能/
かのうえいとく /狩野永徳/
かのうざん /鹿野山/
かのうせい /可能性/
かのうどうし /可能動詞/
かのうは /狩野派/
かのえ /庚/
かのえさる /庚申/
かのこ /鹿の子/
かのじょ /彼女/
かのと /辛/
かのや /鹿屋/
かはい /加配/
かはく /下膊/仮泊/
かはらい /過払い/
かはん /過半/河畔/下半/過般/
かはんしん /下半身/
かはんすう /過半数/
かば /樺/蒲/河馬/椛/
かばいだて /庇い立て/
かばしら /蚊柱/
かばね /屍/姓/
かばやき /蒲焼/
かばやま /樺山/
かばん /鞄/
かひ /可否/果皮/花被/痂皮/歌碑/下婢/
かひつ /加筆/
かひょう /苛評/
かひん /佳品/
かび /華美/黴/
かびん /花瓶/過敏/
かふ /下付/寡婦/家父/家扶/家譜/
かふう /家風/荷風/下風/歌風/
かふきゅう /過不及/
かふく /下腹/禍福/
かふくぶ /下腹部/
かふそく /過不足/
かふちょうせい /家父長制/
かふん /花粉/
かふんしょう /花粉症/
かぶ /株/蕪/下部/歌舞/
かぶか /株価/
かぶかしすう /株価指数/
かぶき /歌舞伎/冠木/
かぶきざ /歌舞伎座/
かぶけん /株券/
かぶこうぞう /下部構造/
かぶしき /株式/
かぶしきがいしゃ /株式会社/
かぶしきこうかい /株式公開/
かぶしきしじょう /株式市場/
かぶしきはいとう /株式配当/
かぶしきぶんかつ /株式分割/
かぶしきもちあい /株式持合/
かぶせ /被せ/
かぶつ /果物/
かぶと /兜/
かぶとちょう /兜町/
かぶぬし /株主/
かぶぬしけん /株主権/
かぶぬしそうかい /株主総会/
かぶぬしわりあて /株主割当/
かぶや /株屋/
かぶら /鏑/蕪/
かぶらぎ /鏑木/
かぶり /頭/
かぶれ /気触れ/
かぶわけ /株分け/
かぶん /寡聞/過分/可分/
かぶんさいむ /可分債務/
かぶんすう /仮分数/
かへい /貨幣/加平/花柄/寡兵/
かへいかち /貨幣価値/
かへん /可変/カ変/佳編/
かべ /壁/
かべかけ /壁掛/
かべがみ /壁紙/
かべごし /壁越し/
かべしんぶん /壁新聞/
かべん /花弁/
かほう /下方/果報/加法/家宝/火砲/加俸/家法/過褒/
かほうていり /加法定理/
かほうもの /果報者/
かほうわ /過飽和/
かほく /河北/華北/
かほご /過保護/
かぼく /家僕/
かぼちゃ /南瓜/
かま /鎌/釜/窯/竈/蒲/竃/
かまいし /釜石/
かまいたち /鎌鼬/
かまえ /構え/
かまがや /鎌ヶ谷/
かまきり /螳螂/蟷螂/
かまくび /鎌首/
かまくら /鎌倉/
かまくらじだい /鎌倉時代/
かまくらばくふ /鎌倉幕府/
かまくらぼり /鎌倉彫/
かまくらやま /鎌倉山/
かます /叺/梭魚/梭子魚/
かまた /蒲田/
かまち /框/
かまとと /蒲魚/
かまど /竈/竃/
かまぼこ /蒲鉾/
かまめし /釜飯/
かまもと /窯元/
かみ /上/紙/髪/神/加味/守/佳味/
かみあげ /髪上げ/
かみいずみ /上泉/
かみいれ /紙入れ/
かみかくし /神隠し/
かみかざり /髪飾り/
かみかぜ /神風/
かみがかり /神懸り/
かみがき /神垣/
かみがた /髪型/髪形/上方/
かみがたえ /上方絵/
かみき /上期/
かみきれ /紙切れ/
かみぎょう /上京/
かみくず /紙屑/
かみぐち /上口/
かみこ /神子/
かみこうち /上高地/
かみこんしき /紙婚式/
かみさま /神様/上様/
かみざ /上座/
かみしばい /紙芝居/
かみしほうがため /上四方固め/
かみしも /上下/
かみじま /神島/
かみすき /紙漉き/
かみずもう /紙相撲/
かみせい /紙製/
かみそり /剃刀/
かみた /神田/
かみだな /神棚/
かみだのみ /神頼み/
かみつ /過密/
かみつかさ /上司/
かみて /上手/
かみでっぽう /紙鉄砲/
かみなが /髪長/
かみなづき /神無月/
かみなり /雷/
かみなりもん /雷門/
かみねんど /紙粘土/
かみのく /上の句/
かみのけ /髪の毛/
かみのこ /神の子/
かみのみや /上の宮/
かみのやま /上山/
かみはんき /上半期/
かみひとえ /紙一重/
かみふうせん /紙風船/
かみふくおか /上福岡/
かみふぶき /紙吹雪/
かみぶくろ /紙袋/
かみほとけ /神仏/
かみまき /紙巻/
かみまち /上町/
かみむ /上無/
かみや /紙屋/神屋/
かみやいん /紙屋院/
かみやがみ /紙屋紙/
かみやしき /上屋敷/
かみやま /神山/
かみゆい /髪結い/
かみよ /神代/
かみん /仮眠/夏眠/
かむ /家務/
かむら /嘉村/
かむり /冠/
かめ /亀/瓶/甕/
かめい /仮名/加盟/亀井/下命/家名/下名/
かめいど /亀戸/
かめおか /亀岡/
かめだ /亀田/
かめのこう /亀の甲/
かめやま /亀山/
かめん /仮面/下面/
かめんげき /仮面劇/
かも /鴨/加茂/賀茂/鳧/
かもい /鴨居/
かもいけ /鴨池/
かもがわ /鴨川/賀茂川/
かもく /科目/寡黙/課目/
かもしか /羚羊/
かもじ /髢/
かもつ /貨物/
かもつえき /貨物駅/
かもつせん /貨物船/
かもつれっしゃ /貨物列車/
かもめ /鴎/
かもん /家紋/家門/下問/渦紋/
かもんのかみ /掃部頭/
かや /萱/茅/蚊帳/榧/栢/
かやく /火薬/可約/加薬/課役/
かやくこ /火薬庫/
かやと /茅戸/
かやね /茅根/
かやの /茅野/
かやば /茅場/
かやばちょう /茅場町/
かやぶき /茅葺き/
かやり /蚊遣り/
かゆ /粥/
かゆみ /痒み/
かゆみどめ /痒み止め/
かよいちょう /通い帳/
かよう /火曜/歌謡/花葉/加養/斯様/可溶/
かようきょく /歌謡曲/
かようせい /可溶性/
かようび /火曜日/
かよく /寡欲/
かよちょう /駕輿丁/
から /空/殻/柄/唐/〜/
から> /空/
からあげ /空揚げ/
からいばり /空威張り/
からうま /空馬/
からうり /空売り/
からえ /唐絵/
からおし /空押し/
からかさ /傘/
からかさまつ /傘松/
からかみ /唐紙/
からがい /空買い/
からき /唐木/
からくさ /唐草/
からくさもよう /唐草模様/
からくち /辛口/
からくれない /韓紅/
からくわ /唐桑/
からげいき /空景気/
からげんき /空元気/
からこ /唐子/
からさき /唐崎/
からさわぎ /空騒ぎ/
からし /芥子/
からす /烏/鴉/
からすぐち /烏口/
からすまる /烏丸/
からすむぎ /烏麦/
からそうば /空相場/
からたけわり /幹竹割り/
からたち /枳殻/
からだ /体/身体/
からだき /空焚き/
からちゃ /枯茶/唐茶/空茶/
からっぽ /空っぽ/
からつ /唐津/
からつゆ /空梅雨/
からづみ /空積み/
からづり /空釣/
からて /空手/
からてがた /空手形/
からてんじく /唐天竺/
からでっぽう /空鉄砲/
からと /唐櫃/
からとう /辛党/
からとりひき /空取引/
からに /空荷/
からにしき /唐錦/
からねんぶつ /空念仏/
からはし /唐橋/
からはふ /唐破風/
からばこ /空箱/
からふと /樺太/
からぶき /乾拭き/
からぶり /空振り/
からぼり /空堀/
からまつ /唐松/
からまわり /空回り/
からみ /絡み/空身/
からむし /空蒸し/苧/
からめ /辛目/
からめて /搦手/
からもの /唐物/
からやくそく /空約束/
からよう /唐様/
かり /仮/狩/雁/借り/猟/加里/
かり> /仮/
かりあげ /借上げ/
かりいれ /借入れ/刈入れ/
かりいれきん /借入金/
かりうえ /仮植え/
かりうど /狩人/
かりかし /借り貸し/
かりかた /借方/
かりかぶ /借株/刈株/
かりかんじょう /仮勘定/
かりぎ /借着/
かりぎちょう /仮議長/
かりくび /雁首/
かりこし /借越/
かりしっこう /仮執行/
かりしゃくほう /仮釈放/
かりしゅっしょ /仮出所/
かりしゅつごく /仮出獄/
かりしゅつじょう /仮出場/
かりしょぶん /仮処分/
かりじゅうしょ /仮住所/
かりずまい /仮住い/
かりせいほん /仮製本/
かりた /刈田/
かりたいいん /仮退院/
かりちょういん /仮調印/
かりちん /借賃/
かりて /借り手/
かりていも /訶梨帝母/
かりとうき /仮登記/
かりとじ /仮綴じ/
かりに /仮に/
かりにも /仮にも/
かりぬい /仮縫い/
かりぬし /借り主/
かりね /仮寝/
かりば /狩場/
かりぶしん /仮普請/
かりほ /刈穂/
かりほうめん /仮放免/
かりめんきょ /仮免許/
かりもの /借り物/
かりゃく /下略/嘉暦/
かりや /刈谷/狩谷/仮屋/
かりやど /仮宿/
かりやま /狩山/
かりゅう /下流/顆粒/渦流/河流/加硫/花柳/
かりゅうかい /花柳界/
かりゅうきゅう /顆粒球/
かりゅうど /狩人/
かりょう /科料/加療/過料/下僚/
かりょく /火力/
かりょくはつでん /火力発電/
かりわたし /仮渡し/
かりん /花櫚/
かりんとう /花林糖/
かる /軽/
かるいざわ /軽井沢/
かるいし /軽石/
かるかや /苅萱/刈萱/
かるがる /軽々/
かるくち /軽口/
かるた /骨牌/歌留多/
かるはずみ /軽はずみ/
かるみ /軽み/
かるめ /軽目/
かるら /迦楼羅/
かるわざ /軽業/
かるわざし /軽業師/
かれ /彼/枯れ/嗄れ/
かれい /華麗/鰈/加齢/遐齢/家例/家令/佳麗/嘉例/佳例/餉/
かれいい /餉/
かれいきゃく /過冷却/
かれいろ /枯色/
かれおばな /枯尾花/
かれき /枯木/
かれくさ /枯れ草/
かれこれ /彼此/
かれさんすい /枯山水/
かれし /彼氏/
かれつ /苛烈/
かれの /枯野/
かれは /枯れ葉/
かれはざい /枯葉剤/
かれら /彼等/
かれん /可憐/
かれんちゅうきゅう /苛斂誅求/
かろう /過労/家老/
かろうし /過労死/
かろうじて /辛うじて/
かろとうせん /夏炉冬扇/
かろやか /軽やか/
かろん /歌論/
かわ /側/川/革/河/皮/
かわい /川合/河合/河井/
かわいろ /革色/
かわうお /川魚/
かわうそ /川獺/
かわおび /革帯/
かわかぜ /川風/
かわかみ /川上/河上/
かわきり /皮切り/
かわぎし /河岸/川岸/
かわぐち /川口/河口/
かわぐちこ /河口湖/
かわぐつ /革靴/
かわごえ /川越/
かわごえじょう /川越城/
かわごし /川越し/
かわさき /川崎/
かわさきだいし /川崎大師/
かわざかな /川魚/
かわざんよう /皮算用/
かわしま /川島/
かわしも /川下/
かわじ /川路/
かわじおんせん /川治温泉/
かわじり /川尻/
かわすじ /川筋/
かわず /川津/蛙/河津/
かわせ /為替/川瀬/
かわせしじょう /為替市場/
かわせそうば /為替相場/
かわせてがた /為替手形/
かわせへいか /為替平価/
かわそう /革装/
かわぞこ /川底/
かわち /河内/
かわちおんど /河内音頭/
かわちながの /河内長野/
かわつ /川津/
かわづ /川津/河津/
かわづら /川面/
かわづり /川釣り/
かわなか /川中/
かわなかじま /川中島/
かわなべ /河鍋/
かわなみ /川波/
かわなり /川成/
かわにし /川西/河西/
かわのえ /川之江/
かわはば /川幅/
かわはら /川原/
かわひがし /河東/川東/
かわひも /革紐/
かわびょうし /革表紙/
かわびらき /川開き/
かわぶくろ /皮袋/
かわべ /川辺/
かわべり /川縁/
かわむき /皮剥き/
かわむこう /川向う/
かわむら /川村/河村/
かわも /川面/
かわもと /川本/
かわもり /川守/
かわや /厠/
かわやなぎ /川柳/
かわゆおんせん /川湯温泉/
かわよけ /川除/
かわら /瓦/川原/磧/河原/
かわらけ /土器/
かわらけいろ /土器色/
かわらざき /河原崎/
かわらだ /河原田/
かわらばん /瓦版/
かわらまち /河原町/
かわらもの /河原者/
かわりめ /変り目/
かわりもの /変り者/
かん /間/換/巻/感/甘/観/完/函/関/館/韓/陥/閑/鑑/還/貫/艦/肝/翰/缶/緩/簡/管/看/監/環/漢/汗/歓/款/棺/敢/憾/慣/患/幹/干/寛/官/姦/堪/喚/勧/勘/刊/寒/冠/乾/神/甲/竿/浣/坎/奸/旱/灌/澣/燗/疳/癇/皖/稈/罐/羹/諫/鐶/鑵/骭/緘/舘/諌/莞/潅/澗/桓/柑/侃/
かん> /間/
かんあく /奸悪/
かんあけ /寒明け/
かんあつし /感圧紙/
かんあみ /観阿弥/
かんあん /勘案/
かんい /簡易/官位/冠位/敢為/
かんいさいばんしょ /簡易裁判所/
かんいっぱつ /間一髪/
かんいん /姦淫/官印/官員/
かんうんやかく /閑雲野鶴/
かんえい /寛永/官営/
かんえいつうほう /寛永通宝/
かんえつ /関越/観閲/簡閲/
かんえん /肝炎/寛延/
かんおう /感応/観桜/
かんおけ /棺桶/
かんおん /漢音/
かんおんじ /観音寺/
かんか /感化/看過/干戈/管下/坩堝/乾果/柑果/閑暇/換価/
かんかい /官界/寛解/感懐/
かんかいかんちょう /管海官庁/
かんかいん /感化院/
かんかく /感覚/間隔/
かんかくきかん /感覚器官/
かんかくさいぼう /感覚細胞/
かんかくしんけい /感覚神経/
かんかくもう /感覚毛/
かんかこどく /鰥寡孤独/
かんかつ /管轄/寛闊/
かんかつちがい /管轄違い/
かんかん /汗簡/
かんかんがくがく /侃々諤々;遠慮なく議論する,侃諤/侃侃諤諤/
かんかんしき /観艦式/
かんが /官衙/
かんがい /感慨/寒害/干害/灌漑/管外/
かんがいむりょう /感慨無量/
かんがえ /考え/
かんがえかた /考え方/
かんがえごと /考え事/
かんがえもの /考え物/
かんがく /漢学/官学/勧学/
かんがっき /管楽器/
かんがん /宦官/汗顔/
かんき /歓喜/換気/乾期/寒気/喚起/乾季/刊記/官紀/官記/勘気/
かんきせん /換気扇/
かんきだん /寒気団/
かんきつるい /柑橘類/
かんきゃく /観客/閑却/
かんきゅう /緩急/官給/感泣/
かんきゅうしゃ /緩急車/
かんきょ /官許/閑居/
かんきょう /環境/感興/艦橋/
かんきょうきじゅん /環境基準/
かんきょうせってい /環境設定/
かんきょうへんすう /環境変数/
かんきょく /寒極/
かんきり /缶切り/
かんきん /換金/監禁/桿菌/看経/官金/
かんぎく /観菊/寒菊/
かんぎてん /歓喜天/
かんぎょ /還御/
かんぎょう /勧業/官業/寒行/
かんぎん /勧銀/閑吟/感吟/
かんく /管区/甘苦/寒苦/
かんぐん /官軍/
かんけ /菅家/
かんけい /関係/奸計/換刑/寛刑/還啓/
かんけいがいしゃ /関係会社/
かんけいしき /関係式/
かんけいしゃ /関係者/
かんけいだいめいし /関係代名詞/
かんけいどうぶつ /環形動物/
かんけつ /簡潔/完結/間欠/間歇/
かんけん /官憲/官権/管見/
かんげ /勧化/
かんげい /歓迎/
かんげいこ /寒稽古/
かんげき /感激/観劇/間隙/
かんげつ /寒月/観月/
かんげん /換言/還元/甘言/管弦/管絃/
かんげんがく /管弦楽/
かんげんがくだん /管弦楽団/
かんげんしゅぎ /還元主義/
かんげんぶんれつ /還元分裂/
かんこ /歓呼/
かんこう /観光/慣行/敢行/刊行/感光/官公/完工/緩行/箝口/還向/甘汞/款項/漢口/勘考/勧降/寛厚/
かんこうし /感光紙/
かんこうしげん /観光資源/
かんこうしょ /官公署/
かんこうせい /感光性/
かんこうちょう /官公庁/
かんこうとし /観光都市/
かんこうばい /寒紅梅/
かんこうぶつ /刊行物/
かんこうへん /肝硬変/
かんこうり /官公吏/
かんこうれい /箝口令/
かんこく /韓国/勧告/官刻/寒国/
かんこくご /韓国語/
かんこつ /顴骨/
かんこつきゅう /寛骨臼/
かんこつだったい /換骨奪胎/
かんこんそうさい /冠婚葬祭/
かんご /看護/漢語/監護/閑語/
かんごう /嵌合/勘合/
かんごうふ /勘合符/
かんごえ /寒肥/
かんごがく /看護学/
かんごく /監獄/
かんごくほう /監獄法/
かんごし /看護士/
かんごにん /看護人/
かんごふ /看護婦/
かんさ /監査/鑑査/感作/
かんさい /関西/完済/艦載/
かんさいいん /監査委員/
かんさいき /艦載機/
かんさいだいがく /関西大学/
かんさいべん /関西弁/
かんさいほんせん /関西本線/
かんさいぼう /幹細胞/
かんさく /間作/奸策/
かんさつ /観察/監察/鑑札/
かんさやく /監査役/
かんさん /閑散/換算/甘酸/
かんさんひょう /換算表/
かんざい /寒剤/
かんざいにん /管財人/
かんざき /神崎/
かんざし /簪/
かんざらし /寒晒し/
かんし /監視/冠詞/干支/管子/鉗子/漢詩/環視/
かんしき /鑑識/乾式/
かんしつ /乾湿/乾漆/
かんしつけい /乾湿計/
かんしゃ /感謝/官舎/
かんしゃく /癇癪/官爵/
かんしゃくだま /癇癪玉/
かんしゃさい /感謝祭/
かんしゃじょう /感謝状/
かんしゅ /看守/看取/艦首/緩手/監守/巻首/観取/
かんしゅう /慣習/監修/観衆/
かんしゅうほう /慣習法/
かんしゅく /甘粛/
かんしょ /甘蔗/甘薯/官署/寒暑/漢書/
かんしょう /観賞/鑑賞/干渉/感傷/緩衝/環礁/完勝/管掌/勧奨/冠省/観照/冠称/勧賞/感賞/寛正/観象/
かんしょうえき /緩衝液/
かんしょうぎょ /観賞魚/
かんしょうけい /干渉計/
かんしょうこく /緩衝国/
かんしょうしゅぎ /感傷主義/
かんしょうちたい /緩衝地帯/
かんしょうてき /感傷的/
かんしょく /感触/官職/間食/閑職/寒色/間色/
かんしん /感心/関心/寒心/歓心/奸臣/甘心/汗疹/
かんじ /漢字/幹事/感じ/完治/監事/寛治/莞爾/
かんじおん /漢字音/
かんじぎょう /閑事業/
かんじゃ /患者/冠者/間者/
かんじゃく /閑寂/
かんじゅ /甘受/感受/官需/
かんじゅく /完熟/慣熟/
かんじゅせい /感受性/
かんじょ /緩徐/寛恕/官女/漢書/
かんじょう /感情/勘定/冠状/環状/感状/艦上/管状/
かんじょういにゅう /感情移入/
かんじょうか /管状花/
かんじょうしょ /勘定書/
かんじょうせん /環状線/
かんじょうてき /感情的/
かんじょうろん /感情論/
かんじん /肝心/肝腎/閑人/勧進/漢人/韓人/
かんじんかなめ /肝心要/
かんじんたいど /寛仁大度/
かんじんちょう /勧進帳/
かんじんもと /勧進元/
かんすい /完遂/冠水/灌水/鹹水/
かんすう /関数/函数/巻数/
かんすうかいせき /関数解析/
かんすうくうかん /関数空間/
かんすうじ /漢数字/
かんすうめい /関数名/
かんすうろん /関数論/
かんすぼん /巻子本/
かんする /関する/
かんせい /完成/感性/歓声/慣性/管制/官製/乾性/喚声/閑静/監製/官制/陥穽/喊声/関西/
かんせいけい /慣性系/
かんせいこうほう /慣性航法/
かんせいしつりょう /慣性質量/
かんせいとう /管制塔/
かんせいはがき /官製葉書/
かんせき /漢籍/艦籍/
かんせつ /間接/関節/冠雪/官設/環節/
かんせつえん /関節炎/
かんせつきょうせい /間接強制/
かんせつしょうこ /間接証拠/
かんせつしょうめい /間接照明/
かんせつぜい /間接税/
かんせつてき /間接的/
かんせつひ /間接費/
かんせつわざ /関節技/
かんせつわほう /間接話法/
かんせん /感染/幹線/観戦/艦船/汗腺/官撰/官選/乾癬/
かんせんけいろ /感染経路/
かんせんしょう /感染症/
かんせんべんごにん /官選弁護人/
かんぜい /関税/勧説/
かんぜいけいさつ /関税警察/
かんぜいしょうへき /関税障壁/
かんぜいじしゅけん /関税自主権/
かんぜいじょうきょ /関税譲許/
かんぜいどうめい /関税同盟/
かんぜおん /観世音/
かんぜおんじ /観世音寺/
かんぜつ /冠絶/
かんぜりゅう /観世流/
かんぜん /完全/勧善/敢然/
かんぜんか /完全花/
かんぜんしあい /完全試合/
かんぜんしゅぎ /完全主義/
かんぜんすう /完全数/
かんぜんちょうあく /勧善懲悪/
かんぜんはんざい /完全犯罪/
かんぜんへんたい /完全変態/
かんぜんむけつ /完全無欠/
かんぜんりゅうたい /完全流体/
かんそ /簡素/
かんそう /感想/乾燥/完走/間奏/歓送/観相/乾草/観想/
かんそうき /乾燥機/
かんそうきょく /間奏曲/
かんそうざい /乾燥剤/
かんそうしつ /乾燥室/
かんそうゆ /乾燥油/
かんそく /観測/
かんそくしょ /観測所/
かんそくじょ /観測所/
かんそん /寒村/
かんそんみんぴ /官尊民卑/
かんぞう /肝臓/甘草/
かんぞういろ /萱草色/
かんぞうがん /肝臓癌/
かんぞく /漢族/奸賊/
かんたい /艦隊/歓待/寒帯/緩怠/
かんたいじ /簡体字/
かんたく /干拓/乾拓/
かんたくち /干拓地/
かんたん /簡単/感嘆/邯鄲/肝胆/
かんたんし /感嘆詞/
かんたんふ /感嘆符/
かんだ /神田/
かんだい /寛大/
かんだか /甲高/
かんだち /神立/
かんだみょうじん /神田明神/
かんだん /歓談/寒暖/間断/閑談/
かんだんけい /寒暖計/
かんち /関知/完治/感知/寒地/姦智/奸知/換地/監置/閑地/
かんちがい /勘違い/
かんちしょぶん /換地処分/
かんちつ /巻帙/
かんちゅう /寒中/冠注/勘注/
かんちょう /艦長/館長/官庁/浣腸/管長/干潮/間諜/勧懲/
かんつう /貫通/姦通/
かんつうざい /姦通罪/
かんつうじゅうそう /貫通銃創/
かんつばき /寒椿/
かんづめ /缶詰/
かんてい /鑑定/官邸/艦艇/勘亭/
かんていしょ /鑑定書/
かんていにん /鑑定人/
かんていりゅう /勘亭流/
かんてつ /貫徹/
かんてん /観点/寒天/干天/旱天/
かんてんきち /歓天喜地/
かんてんぼうき /観天望気/
かんでん /感電/乾田/
かんでんち /乾電池/
かんと /官途/
かんとう /関東/巻頭/竿灯/敢闘/完投/竿頭/
かんとうぐん /関東軍/
かんとうげん /巻頭言/
かんとうし /間投詞/
かんとうじょし /間投助詞/
かんとうちほう /関東地方/
かんとうに /関東煮/
かんとうへいや /関東平野/
かんとく /監督/感得/
かんとくえん /関特演/
かんとくかん /監督官/
かんとくかんちょう /監督官庁/
かんとくきかん /監督機関/
かんとくけん /監督権/
かんとん /広東/嵌頓/
かんとんご /広東語/
かんとんりょうり /広東料理/
かんど /感度/
かんどう /感動/勘当/間道/
かんどうし /感動詞/
かんどうみゃく /冠動脈/
かんどころ /勘所/
かんな /鉋/寛和/
かんない /管内/関内/
かんなぎ /巫/覡/
かんなづき /神無月/
かんなめさい /神嘗祭/
かんなん /艱難/
かんなんしんく /艱難辛苦/
かんにゅう /嵌入/貫入/陥入/
かんにょ /官女/
かんにん /堪忍/官人/
かんにんぶくろ /堪忍袋/
かんぬき /閂/貫木/
かんぬし /神主/
かんねい /姦佞/奸佞/
かんねつし /感熱紙/
かんねん /観念/
かんねんてき /観念的/
かんねんろん /観念論/
かんの /管野/
かんのう /官能/間脳/完納/感応/肝脳/還納/
かんのうてき /官能的/
かんのん /観音/
かんのんざき /観音崎/
かんのんじ /観音寺/
かんのんどう /観音堂/
かんのんびらき /観音開き/
かんはっしゅう /関八州/
かんば /悍馬/
かんばい /完売/寒梅/観梅/
かんばつ /簡抜/間伐/旱魃/
かんばのろう /汗馬の労/
かんばやし /上林/
かんばら /蒲原/
かんばん /看板/燗番/
かんばんだおれ /看板倒れ/
かんばんむすめ /看板娘/
かんぱ /寒波/看破/
かんぱい /乾杯/完敗/
かんぱく /関白/
かんぱつ /煥発/渙発/
かんぱん /甲板/干犯/乾板/
かんび /完備/甘美/艦尾/巻尾/
かんびょう /看病/
かんぴ /官費/
かんぴょう /乾瓢/干瓢/
かんぴょうき /間氷期/
かんぶ /幹部/患部/官武/
かんぶこうほせい /幹部候補生/
かんぶつ /乾物/換物/奸物/官物/観仏/
かんぶん /漢文/寛文/
かんぷ /乾布/還付/完膚/関釜/官府/姦夫/姦婦/
かんぷう /寒風/完封/
かんぷきん /還付金/
かんぷく /感服/官服/
かんぷん /感奮/
かんべ /神戸/神部/
かんべつ /鑑別/
かんべに /寒紅/
かんべん /勘弁/簡便/
かんぺい /勘平/寛平/
かんぺいしき /観兵式/
かんぺき /完璧/癇癖/
かんぺん /官辺/
かんぼう /官房/感冒/監房/奸謀/観望/姦謀/
かんぼうちょうかん /官房長官/
かんぼく /灌木/翰墨/
かんぼつ /陥没/
かんぽう /官報/漢方/艦砲/汗疱/寛保/観法/
かんぽうい /漢方医/
かんぽうやく /漢方薬/
かんぽん /完本/刊本/官本/監本/韓本/
かんまつ /巻末/
かんまん /緩慢/干満/
かんみ /甘味/
かんみりょう /甘味料/
かんみん /官民/
かんみんぞく /漢民族/
かんむへいし /桓武平氏/
かんむり /冠/
かんめ /貫目/
かんめい /感銘/官名/簡明/官命/
かんめん /乾麺/
かんもく /緘黙/
かんもち /寒餅/
かんもん /関門/喚問/
かんもんかいきょう /関門海峡/
かんやく /簡約/完訳/漢訳/漢薬/
かんやどり /神宿り/
かんゆ /肝油/
かんゆう /勧誘/奸雄/官有/
かんよ /関与/干与/
かんよう /肝要/慣用/寛容/涵養/咸陽/簡要/間葉/
かんようおん /慣用音/
かんようく /慣用句/
かんようしょくぶつ /観葉植物/
かんらい /寒雷/
かんらく /陥落/歓楽/乾酪/
かんらくがい /歓楽街/
かんらん /観覧/甘藍/橄欖/
かんらんしゃ /観覧車/
かんり /管理/官吏/監理/
かんりかかく /管理価格/
かんりけん /管理権/
かんりこうい /管理行為/
かんりこうがく /管理工学/
かんりしゃ /管理者/
かんりしゃかい /管理社会/
かんりしょく /管理職/
かんりつ /官立/
かんりにん /管理人/
かんりめいれい /管理命令/
かんりゃく /簡略/
かんりゅう /寒流/環流/貫流/乾溜/緩流/
かんりょう /完了/官僚/管領/
かんりょうしゅぎ /官僚主義/
かんりょうせい /官僚制/
かんりょうせいじ /官僚政治/
かんりょうてき /官僚的/
かんるい /感涙/
かんれい /慣例/寒冷/管領/艦齢/
かんれいしゃ /寒冷紗/
かんれいぜんせん /寒冷前線/
かんれき /還暦/
かんれん /関連/
かんろ /寒露/甘露/
かんろく /貫禄/勘六/
かんろに /甘露煮/
かんわ /緩和/漢和/閑話/
かんわきゅうだい /閑話休題/
かんわじてん /漢和辞典/漢和字典/
が /我/駕/餓/雅/賀/蛾/芽/臥/画/牙/衙/瓦/俄/峨/
がい /外/街/害/概/骸/該/蓋/涯/慨/劾/我意/垓/亥/賀意/鎧/碍/崖/凱/咳/
がいあく /害悪/
がいあつ /外圧/
がいい /害意/外衣/
がいいん /外因/
がいえん /外延/外苑/
がいか /凱歌/外貨/蓋果/
がいかい /外界/外海/
がいかく /外郭/外角/外殻/
がいかくだんたい /外郭団体/
がいかさい /外貨債/
がいかつ /概括/
がいかよきん /外貨預金/
がいかん /概観/外観/外患/
がいき /外気/
がいきゃく /外客/
がいきょう /概況/
がいきょく /外局/
がいきん /外勤/
がいく /街区/
がいけい /外形/外径/
がいけん /外見/
がいこう /外交/外向/外光/外寇/外港/
がいこういん /外交員/
がいこうか /外交家/
がいこうかん /外交官/
がいこうじれい /外交辞令/
がいこうせい /外向性/
がいこうとっけん /外交特権/
がいこうぶんしょ /外交文書/
がいこうるい /外肛類/
がいこきゅう /外呼吸/
がいこく /外国/
がいこくかわせ /外国為替/
がいこくご /外国語/
がいこくさい /外国債/
がいこくじん /外国人/
がいこくほう /外国法/
がいこくぼうえき /外国貿易/
がいこつ /骸骨/
がいご /外語/
がいさい /外債/
がいさん /概算/
がいさんようきゅう /概算要求/
がいざい /外材/外在/
がいし /外史/外資/外紙/碍子/
がいして /概して/
がいしどうにゅう /外資導入/
がいしゃ /外車/
がいしゅう /外周/鎧袖/
がいしゅつ /外出/
がいしょ /外書/
がいしょう /外傷/外相/外商/街娼/
がいしょく /外食/
がいしん /外信/外心/害心/
がいじ /外字/外耳/外事/
がいじえん /外耳炎/
がいじどう /外耳道/
がいじゅ /外需/
がいじゅうないごう /外柔内剛/
がいじょう /街上/
がいじん /外人/外陣/
がいじんぶたい /外人部隊/
がいすう /概数/
がいせい /外征/慨世/蓋世/
がいせき /外積/外戚/
がいせつ /概説/外接/
がいせつえん /外接円/
がいせん /外線/凱旋/
がいせんもん /凱旋門/
がいぜん /蓋然/
がいぜんせい /蓋然性/
がいそう /外層/外装/咳嗽/
がいそく /外側/
がいそふ /外祖父/
がいそぼ /外祖母/
がいそん /外孫/
がいたい /外帯/
がいため /外為/
がいためほう /外為法/
がいたん /慨嘆/慨歎/
がいだ /咳唾/
がいち /外地/
がいちゅう /外注/害虫/
がいちょう /害鳥/
がいちょうどう /外聴道/
がいてき /外的/外敵/
がいてん /外典/
がいでん /外電/外伝/
がいとう /該当/街頭/外灯/街灯/外套/
がいどく /害毒/
がいねん /概念/
がいねんきかん /外燃機関/
がいねんず /概念図/
がいねんてき /概念的/
がいはいよう /外胚葉/
がいはく /外泊/該博/
がいはん /外販/外板/
がいひ /外皮/
がいひょう /概評/
がいぶ /外部/外侮/
がいぶけいざい /外部経済/
がいぶこうか /外部効果/
がいぶつ /外物/
がいぶん /外聞/外分/
がいぶんぴつ /外分泌/
がいへき /外壁/
がいほう /外報/
がいぼう /外貌/
がいまい /外米/
がいむ /外務/
がいむしょう /外務省/
がいむだいじん /外務大臣/
がいめん /外面/
がいめんてき /外面的/
がいや /外野/
がいやしゅ /外野手/
がいゆう /外遊/
がいよう /概要/外用/外洋/
がいようやく /外用薬/
がいらい /外来/
がいらいご /外来語/
がいらん /外乱/
がいりゃく /概略/
がいりょく /外力/
がいりん /外輪/
がいりんざん /外輪山/
がいろ /街路/
がいろじゅ /街路樹/
がいろん /概論/
がいわくせい /外惑星/
がか /画家/画架/
がかい /瓦解/画会/雅懐/
がかく /画角/
がかり /掛/
がが /峨々/峨峨/
ががく /雅楽/画学/
がき /餓鬼/
がきだいしょう /餓鬼大将/
がきょう /画境/
がぎょ /駕御/
がぎょう /ガ行/画業/
がく /楽/額/学/顎/嶽/鄂/萼/岳/
がくい /学位/
がくいろんぶん /学位論文/
がくいん /学院/楽員/
がくえん /学園/
がくおん /楽音/
がくがい /学外/
がくぎょう /学業/
がくげい /学芸/
がくげいいん /学芸員/
がくげいかい /学芸会/
がくげいだいがく /学芸大学/
がくげき /楽劇/
がくさい /学際/学才/楽才/
がくし /学士/学資/楽師/
がくしいん /学士院/
がくしかい /学士会/
がくしき /学識/
がくしほけん /学資保険/
がくしゃ /学者/学舎/
がくしゅ /楽手/
がくしゅう /学習/学修/
がくしゅういん /学習院/
がくしゅうしどう /学習指導/
がくしゅうじゅく /学習塾/
がくしょう /楽章/楽匠/
がくしょく /学殖/
がくじ /学事/
がくじゅつ /学術/
がくじゅつかいぎ /学術会議/
がくじゅつだんたい /学術団体/
がくじゅつようご /学術用語/
がくじん /楽人/
がくせい /学生/学制/楽聖/
がくせいうんどう /学生運動/
がくせいふく /学生服/
がくせいわりびき /学生割引/
がくせき /学籍/
がくせきぼ /学籍簿/
がくせつ /学説/楽節/
がくぜん /愕然/
がくそう /学窓/楽想/学僧/
がくそく /学則/
がくそつ /学卒/
がくたい /楽隊/
がくだん /楽団/楽壇/
がくちょう /学長/楽長/楽調/
がくてき /学的/
がくてん /楽典/
がくでん /学田/
がくと /学徒/学都/
がくとう /学頭/
がくとく /学徳/
がくとどういん /学徒動員/
がくどう /学童/学堂/
がくどうほいく /学童保育/
がくない /学内/
がくねん /学年/
がくは /学派/
がくばつ /学閥/
がくひ /学費/
がくふ /楽譜/学府/岳父/
がくふう /学風/
がくぶ /学部/
がくぶち /額縁/
がくへん /萼片/
がくほう /学報/
がくぼう /学帽/
がくぼく /学僕/
がくむ /学務/
がくめい /学名/
がくめん /額面/
がくめんかかく /額面価格/
がくめんはっこう /額面発行/
がくめんわれ /額面割れ/
がくもん /学問/
がくもんじょ /学問所/
がくもんてき /学問的/
がくや /楽屋/
がくやうら /楽屋裏/
がくやおち /楽屋落ち/
がくゆう /学友/
がくよう /岳陽/
がくようひん /学用品/
がくらん /学らん/
がくり /学理/
がくりょう /学寮/
がくりょく /学力/
がくれい /学齢/
がくれき /学歴/
がくろく /岳麓/
がくわり /学割/
がけ /崖/掛け/
がけい /雅兄/
がけん /我見/
がげき /画劇/
がげん /雅言/
がこう /画稿/画工/
がご /雅語/
がごう /雅号/
がさい /画才/
がざい /画材/
がし /餓死/賀詞/
がしつ /画質/画室/
がしゅ /雅趣/画趣/
がしゅう /画集/我執/
がしゅん /賀春/
がしょう /賀正/画商/臥床/雅称/
がしら /頭/
がしんしょうたん /臥薪嘗胆/
がじょう /牙城/賀状/画帖/
がじん /画人/雅人/
がす /瓦斯/
がせい /画聖/
がせき /瓦石/
がせんし /画仙紙/
がぜん /俄然/瓦全/
がそ /画素/
がぞう /画像/
がぞうこうがく /画像工学/
がぞうしょり /画像処理/
がぞうじょうほう /画像情報/
がぞく /雅俗/
がた /方/型/
がたおち /がた落ち/
がだい /画題/
がだん /画壇/
がち /勝ち/雅致/
がちょう /鵞鳥/画帳/
がっ /合/
がっか /学科/学課/
がっかい /学会/学界/楽界/
がっかいし /学会誌/
がっかせん /顎下腺/
がっかん /学館/学監/
がっき /楽器/学期/
がっきゅう /学級/学究/
がっきょく /楽曲/
がっく /学区/楽句/
がっけい /学兄/
がっこう /学校/
がっこうしんぶん /学校新聞/
がっこうちゅう /顎口虫/
がっこうほうじん /学校法人/
がっこうれい /学校令/
がっさい /合切/
がっさく /合作/
がっさつ /合冊/
がっさん /合算/月山/
がっしゅうこく /合衆国/
がっしゅく /合宿/
がっしょう /合唱/合掌/合従/
がっしょうきょく /合唱曲/
がっしょうひねり /合掌捻り/
がっしょうれんこう /合従連衡/
がっそう /合奏/
がったい /合体/
がっち /合致/
がってつ /合綴/
がってん /合点/月天/
がっぴ /月日/
がっぴつ /合筆/
がっぴょう /合評/
がっぺい /合併/
がっぺいしゅうごう /合併集合/
がっぺいしょう /合併症/
がっぽう /合邦/
がっぽん /合本/
がつ /月/
がてん /合点/
がでんいんすい /我田引水/
がに /蟹/
がはく /画伯/
がばん /画板/
がひつ /画筆/
がびょう /画鋲/
がふ /画布/画譜/
がふう /画風/
がふく /画幅/
がぶのみ /がぶ飲み/
がぶん /雅文/
がべい /画餅/
がほ /牙保/
がほう /画法/芽胞/画報/
がま /蝦蟇/蒲/蝦蟆/
がまごおり /蒲郡/
がまん /我慢/
がめい /雅名/
がめん /画面/
がもう /蒲生/
がようし /画用紙/
がよく /我欲/
がら /柄/
がらす /硝子/
がらすたい /硝子体/
がらん /伽藍/
がらんどう /伽藍堂/
がり /我利/
がりばん /がり版/
がりゅう /我流/
がりょう /雅量/画料/
がりょうてんせい /画竜点睛/
がりん /芽鱗/
がれき /瓦礫/
がろう /画廊/
がろん /画論/
がわ /側/
がん /癌/岩/頑/雁/鴈/贋/顔/願/元/丸/含/岸/眼/玩/翫/巌/龕/
がんあつ /眼圧/
がんい /含意/願意/
がんえん /岩塩/
がんか /眼科/癌化/眼下/眼窩/
がんかい /眼界/
がんかけ /願掛け/
がんきゅう /眼球/
がんきょう /眼鏡/頑強/
がんきん /眼筋/元金/
がんぎ /雁木/
がんくつ /岩窟/
がんくつおう /巌窟王/
がんくび /雁首/
がんぐ /玩具/頑愚/
がんけい /眼形/
がんけん /頑健/眼瞼/
がんこ /頑固/
がんこいってつ /頑固一徹/
がんこう /眼光/雁行/眼孔/
がんこうしゅてい /眼高手低/
がんさい /岩滓/
がんさいぼう /癌細胞/
がんさく /贋作/
がんさつ /贋札/
がんざい /丸剤/
がんしき /眼識/
がんしつ /眼疾/
がんしゅ /癌腫/願主/
がんしゅう /含羞/
がんしょ /願書/雁書/
がんしょう /岩礁/岩漿/岩床/翫賞/
がんしょく /顔色/
がんじつ /元日/
がんじょう /頑丈/
がんじん /鑑真/
がんすいたんそ /含水炭素;炭水化物/
がんせいひろう /眼精疲労/
がんせき /岩石/
がんせきがく /岩石学/
がんせん /頑癬/
がんぜん /眼前/
がんそ /元祖/
がんそう /含嗽/
がんぞう /贋造/
がんたい /眼帯/
がんたん /元旦/
がんだて /願立て/
がんちく /含蓄/
がんちゅう /眼中/
がんてい /眼底/
がんていしゅっけつ /眼底出血/
がんねん /元年/
がんばり /頑張り/
がんばん /岩盤/
がんぱく /雁帛/
がんびょう /眼病/
がんぴ /雁皮/
がんぴし /雁皮紙/
がんぶつ /贋物/
がんぶつそうし /玩物喪志/
がんぷく /眼福/
がんぺき /岩壁/岸壁/
がんぼう /願望/顔貌/
がんぽん /元本/
がんま /γ/Γ/
がんません /γ線/
がんみ /玩味/
がんめい /頑迷/
がんめいふれい /頑冥不霊/
がんめん /顔面/
がんもう /願望/
がんもく /眼目/
がんもん /雁門/願文/
がんやく /丸薬/
がんゆう /含有/
がんらい /元来/
がんり /元利/
がんりき /眼力/願力/
がんりゅうじま /巌流島/
がんりょう /顔料/
がんりょく /眼力/
がんろう /玩弄/
き /気/記/期/機/規/基/木/起/企/帰/奇/貴/棄/危/寄/紀/希/季/黄/器/軌/既/亀/揮/鬼/岐/飢/汽/忌/生/喜/騎/幾/輝/旗/棋/稀/祈/毅/机/嬉/畿/己/樹/綺/着/棊/城/冀/几/毀/揆/癸/饑/驥/箕/碁/酒/伎/徽/
き> /貴/
きーせん /妓生/
きーるん /基隆/
きあい /気合/
きあいまけ /気合負け/
きあけ /忌明け/
きあつ /気圧/
きあつけい /気圧計/
きあつはいち /気圧配置/
きあん /起案/
きい /紀伊/奇異/貴意/忌諱/
きいけ /紀伊家/
きいすいどう /紀伊水道/
きいちご /木苺/
きいっぽん /生一本/
きいつ /帰一/
きいと /生糸/
きいはんとう /紀伊半島/
きいろ /黄色/
きいん /起因/基因/気韻/棋院/
きいんせいどう /気韻生動/
きう /気宇/
きうけ /気受け/
きうち /木内/
きうつ /気鬱/
きうつり /気移り/
きうん /気運/機運/
きえ /消え/帰依/
きえい /気鋭/機影/帰営/
きえつ /喜悦/
きえん /気炎/奇縁/機縁/気焔/
きえんさん /希塩酸/
きえんばんじょう /気炎万丈/
きおい /気負い/
きおう /既往/
きおうしょう /既往症/
きおく /記憶/
きおくじゅつ /記憶術/
きおくそうち /記憶装置/
きおくようりょう /記憶容量/
きおくれ /気後れ/
きおち /気落ち/
きおん /気温/基音/
きか /幾何/帰化/気化/貴下/奇禍/奇貨/貴家/麾下/机下/季夏/
きかい /機械/機会/奇怪/器械/気塊/毀壊/棋界/
きかいあぶら /機械油/
きかいか /機械化/
きかいきんとう /機会均等/
きかいこうがく /機械工学/
きかいこうぎょう /機械工業/
きかいご /機械語/
きかいたいそう /器械体操/
きかいてき /機械的/
きかいひよう /機会費用/
きかいろん /機械論/
きかがく /幾何学/
きかき /気化器/
きかきゅうすうてき /幾何級数的/
きかく /企画/規格/
きかくか /規格化/
きかくばん /規格判/
きかくひん /規格品/
きかげき /喜歌劇/
きかこうがく /幾何光学/
きかしょくぶつ /帰化植物/
きかじん /帰化人/
きかねつ /気化熱/
きかへいきん /幾何平均/
きかん /期間/機関/基幹/季刊/器官/帰還/気管/既刊/貴簡/旗艦/軌間/奇観/帰館/貴官/
きかんいにんじむ /機関委任事務/
きかんく /機関区/
きかんさんぎょう /基幹産業/
きかんし /機関紙/機関士/機関誌/気管支/
きかんしえん /気管支炎/
きかんしつ /機関室/
きかんしゃ /機関車/
きかんじゅう /機関銃/
きかんとうしか /機関投資家/
きかんほう /機関砲/
きが /飢餓/起臥/帰臥/
きがい /危害/気概/
きがいしゅうしゅく /期外収縮/
きがえ /着替え/
きがかり /気掛り/
きがく /器楽/貴学/
きがた /木型/
きがね /気兼ね/
きがまえ /気構え/
きがみ /生紙/
きがらちゃ /黄枯茶/
きがる /気軽/
きがん /祈願/奇岩/
きき /機器/危機/鬼気/記紀/器機/騏驥/忌諱/汽機/奇気/奇奇/奇鰭/記旗/起期/帰期/喜気/毀棄/嬉嬉/輝輝/暉暉/窺基/嬉々/効き/
ききあし /利き足/
ききあわせ /聞合せ/
ききいしき /危機意識/
ききうで /利き腕/
ききおさめ /聞き納め/
ききおぼえ /聞き覚え/
ききかいかい /奇々怪々/奇奇怪怪/
ききかた /聞き方/
ききかん /危機感/
ききかんり /危機管理/
ききがき /聞書/
ききざけ /利酒/
ききじょうず /聞き上手/
ききずて /聞き捨て/
ききちがえ /聞き違え/
ききつたえ /聞き伝え/
ききて /聞き手/利き手/
ききどころ /利き所/聞き所/
ききべた /聞き下手/
ききみょうみょう /奇奇妙妙/
ききめ /効き目/利き目/
ききもの /聞き物/
ききゃく /棄却/
ききやく /聞き役/
ききゅう /気球/希求/危急/帰休/企及/
ききゅうそんぼう /危急存亡/
ききょ /起居/寄居/
ききょう /桔梗/帰郷/帰京/帰敬/気胸/奇矯/
ききょういろ /桔梗色/
ききょく /危局/
ききょらい /帰去来/
ききわけ /聞分け/
ききん /基金/寄金/飢饉/
ききんぞく /貴金属/
きぎ /木々/機宜/
きぎぬ /生絹/
きぎょう /企業/起業/機業/
きぎょうか /企業家/
きぎょうかいけい /企業会計/
きぎょうくみあい /企業組合/
きぎょうしゅうだん /企業集団/
きぎょうねんきん /企業年金/
きく /菊/規矩/起句/鞠/掬/
きくおか /菊岡/
きくか /菊科/
きくかわ /菊川/
きくがわ /菊川/
きくざ /菊座/
きくざけ /菊酒/
きくじゅんじょう /規矩準縄/
きくじん /麹塵/
きくすい /菊水/
きくず /木屑/
きくずれ /着崩れ/
きくた /菊田/
きくち /菊池/
きくづき /菊月/
きくな /菊菜/
きくにんぎょう /菊人形/
きくばり /気配り/
きくばん /菊判/
きくみ /菊見/
きくらげ /木耳/
きくん /貴君/
きぐ /危惧/器具/機具/
きぐう /奇遇/
きぐすり /生薬/
きぐち /木口/
きぐみ /木組み/気組み/
きぐらい /気位/
きぐろう /気苦労/
きけい /貴兄/奇形/畸型/畸形/詭計/奇計/
きけいじ /奇形児/
きけつ /帰結/既決/
きけつしゅう /既決囚/
きけもの /利け者/
きけん /危険/棄権/気圏/貴顕/
きけんしそう /危険思想/
きけんじんぶつ /危険人物/
きけんふたん /危険負担/
きげき /喜劇/
きげん /期限/機嫌/起源/紀元/
きげんせつ /紀元節/
きげんぜん /紀元前/
きこ /騎虎/旗鼓/
きこう /機構/気候/寄稿/寄港/気功/気孔/紀行/季候/奇行/帰港/起工/騎行/機甲/寄航/希覯/帰航/稀覯/起稿/奇功/奇効/機巧/貴公/
きこうがく /機構学/
きこうし /貴公子/
きこうたい /気候帯/
きこうぶたい /機甲部隊/
きこうぶん /紀行文/
きこうぼん /稀覯本/
きこえ /聞え/
きこく /帰国/鬼哭/貴国/
きこつ /気骨/奇骨/
きこり /樵/
きこん /既婚/気根/
きご /季語/綺語/
きごう /記号/揮毫/〓/↓/↑/←/→/〒/※/▼/▽/▲/△/■/□/◆/◇/◎/●/○/★/☆/§/£/¢/¥/℃/″/′/°/♀/♂/∴/∞/≧/≦/≠/÷/×/±/】/【/』/『/》/《/〉/〈/〕/〔/“/‥/…/‖/‐/—/〇/〆/々/仝/〃/ゞ/ゝ/ヾ/ヽ/‾/¨/｀/´/゜/゛/・/＠/＞/＃/％/＆/＊/〜/＄/＝/≒/＜/♪/−/＋/／/＼/？/」/！/｜/「/｝/］/｛/［/；/）/（/”/’/．/、/‘/＿/，/ー/：/≡/♭/＾/。/Ц/⌒/¶/‡/∵/ヶ/≫/∧/∨/¬/∠/≪/∝/∫/Å/‰/†/∪/
きごうがく /記号学/
きごうしょり /記号処理/
きごうろん /記号論/
きごうろんりがく /記号論理学/
きごこち /着心地/
きごころ /気心/
きさ /蚶/
きさい /記載/奇才/既済/起債/鬼才/
きさかた /象潟/
きさき /后/
きさく /奇策/気さく/詭策/
きさつ /貴札/
きさま /貴様/
きさらぎ /如月/
きさらづ /木更津/
きさん /帰参/起算/帰山/
きさんじ /気散じ/
きさんてん /起算点/
きさんび /起算日/
きざ /気障/起坐/刻/
きざい /機材/器材/器財/
きざきこ /木崎湖/
きざくら /黄桜/
きざけ /生酒/
きざはし /階/
きざみ /刻み/
きざみあし /刻み足/
きざみめ /刻み目/
きざわり /気障り/
きし /岸/騎士/棋士/貴紙/貴誌/愧死/
きしかいせい /起死回生/
きしかん /既視感/
きしだ /岸田/
きしつ /気質/基質/器質/
きしつか /器質化/
きしどう /騎士道/
きしね /岸根/
きしの /岸野/
きしべ /岸辺/
きしぼじん /鬼子母神/
きしもじん /鬼子母神/
きしもと /岸本/
きしゃ /記者/貴社/汽車/
きしゃく /希釈/稀釈/
きしゅ /騎手/旗手/期首/機首/貴種/奇手/起首/機種/
きしゅう /紀州/奇習/奇襲/既習/貴州/貴酬/季秋/
きしゅく /寄宿/耆宿/
きしゅくしゃ /寄宿舎/
きしゅん /季春/
きしょ /寄書/貴所/貴書/奇書/
きしょう /起床/気象/気性/記章/希少/徽章/起請/毀傷/稀少/奇勝/
きしょうえいせい /気象衛星/
きしょうかち /稀少価値/
きしょうがく /気象学/
きしょうけいほう /気象警報/
きしょうだい /気象台/
きしょうちょう /気象庁/
きしょうてんけつ /起承転結/
きしょうてんごう /起承転合/
きしょうもん /起請文/
きしょく /気色/喜色/寄食/
きしわだ /岸和田/
きしん /紀信/寄進/帰心/鬼神/忌辰/貴紳/
きじ /記事/生地/木地/雉/棄児/
きじく /機軸/基軸/
きじすう /記事数/
きじせんたく /記事選択/
きじつ /期日/忌日/
きじばと /雉鳩/
きじゃく /着尺/
きじや /木地屋/
きじゅ /喜寿/
きじゅう /機銃/
きじゅうき /起重機/
きじゅつ /記述/奇術/既述/
きじゅつし /奇術師/
きじゅん /基準/規準/帰順/
きじゅんめん /基準面/
きじょ /機序/貴女/鬼女/
きじょう /机上/機上/騎乗/軌条/気丈/
きじょうぶ /気丈夫/
きじん /奇人/鬼神/貴人/畸人/
きす /鱚/
きすい /既遂/
きすう /奇数/基数/帰趨/
きすうほう /記数法/
きず /傷/瑕/疵/生酢/
きずあと /傷跡/傷痕/
きずい /奇瑞/
きずかい /気遣い/
きずき /杵築/
きずきがみ /生漉紙/
きずぐち /傷口/
きずな /絆/
きずもの /傷物/疵物/
きせ /木瀬/
きせい /規制/帰省/既成/寄生/奇声/既製/気勢/規正/棋聖/祈誓/期成/
きせいかざん /寄生火山/
きせいこん /寄生根/
きせいしょくぶつ /寄生植物/
きせいじじつ /既成事実/
きせいじぬし /寄生地主/
きせいちゅう /寄生虫/
きせいひん /既製品/
きせいほんせん /紀勢本線/
きせき /奇跡/軌跡/鬼籍/帰責/帰籍/奇石/貴石/輝石/
きせきてき /奇跡的/
きせつ /季節/既設/気節/
きせつかんぜい /季節関税/
きせつふう /季節風/
きせつれっしゃ /季節列車/
きせる /煙管/
きせん /基線/機先/汽船/棋戦/機船/貴賤/
きぜつ /気絶/奇絶/
きぜわ /生世話/
きぜん /毅然/
きそ /基礎/起訴/木曾/
きそう /奇想/気相/起草/帰巣/寄贈/
きそうかん /気送管/
きそうきょく /奇想曲/
きそうせい /帰巣性/
きそうてんがい /奇想天外/
きそく /規則/気息/羈束/
きそくえんえん /気息奄奄/気息奄々/
きそくてき /規則的/
きそけんきゅう /基礎研究/
きそこうじょ /基礎控除/
きそじょう /起訴状/
きそたいしゃ /基礎代謝/
きそべんぎしゅぎ /起訴便宜主義/
きそゆうよ /起訴猶予/
きそん /既存/毀損/
きぞう /寄贈/寄蔵/
きぞく /帰属/貴族/
きぞくいん /貴族院/
きぞめ /着初め/
きた /北/喜多/喜田/
きたい /期待/気体/危殆/機体/稀代/奇態/
きたいち /期待値/
きたいっき /北一輝/
きたいばらき /北茨城/
きたえ /鍛え/
きたお /北尾/
きたおおじ /北大路/
きたかいきせん /北回帰線/
きたかぜ /北風/
きたかた /喜多方/
きたかみ /北上/
きたかみがわ /北上川/
きたがわ /北川/喜多川/
きたきゅうしゅう /北九州/
きたく /帰宅/寄託/
きたぐに /北国/
きたけ /着丈/
きたざと /北里/
きたじま /北島/
きたたいせいよう /北大西洋/
きたたいへいよう /北太平洋/
きただけ /北岳/
きたちょうせん /北朝鮮/
きたの /北野/
きたのてんまんぐう /北野天満宮/
きたのまる /北の丸/
きたはま /北浜/
きたはら /北原/
きたはらはくしゅう /北原白秋/
きたはんきゅう /北半球/
きたばたけ /北畠/
きたまくら /北枕/
きたまちぶぎょう /北町奉行/
きたみ /北見/
きたみち /北道/
きたむき /北向き/
きたむら /北村/喜多村/
きたもと /北本/
きたやま /北山/
きたりゅう /喜多流/
きたる /来る/
きたわき /北脇/
きたん /忌憚/奇譚/
きたんかいきょう /紀淡海峡/
きだい /貴台/季題/
きだおれ /着倒れ/
きだち /木太刀/
きだて /気立て/
きだん /奇談/気団/綺談/
きち /吉/基地/既知/機知/貴地/機智/危地/窺知/
きちがい /気違い/
きちく /鬼畜/
きちじ /吉事/
きちじつ /吉日/
きちじょう /吉祥/吉上/
きちじょうじ /吉祥寺/
きちぞう /吉蔵/
きちゃく /帰着/
きちゅう /忌中/期中/
きちょ /貴著/
きちょう /貴重/基調/記帳/機長/几帳/帰朝/
きちょうめん /几帳面/
きちれい /吉例/
きちん /木賃/
きちんやど /木賃宿/
きっか /菊花/
きっかけ /切っ掛け/
きっかわ /吉川/
きっかわもとはる /吉川元春/
きっきょう /吉凶/吃驚/
きっきん /喫緊/
きっこう /亀甲/拮抗/
きっさ /喫茶/
きっさてん /喫茶店/
きっしょう /吉祥/
きっすい /生粋/喫水/吃水/
きっすいせん /喫水線/
きっせき /詰責/
きっそう /吉左右/吉相/
きったて /切立/
きっちょう /吉兆/
きって /切手/
きっと /急度/屹度/
きっぷ /切符/気風/
きっぽう /吉報/
きつ /詰/喫/吃/吉/橘/桔/
きつえん /喫煙/
きつえんしつ /喫煙室/
きつおん /吃音/
きつき /杵築/
きつけ /着付け/気付け/
きつけぐすり /気付け薬/
きつぜん /屹然/
きつつき /啄木鳥/
きつね /狐/
きつねいろ /狐色/
きつねつき /狐憑き/
きつねづか /狐塚/
きつもん /詰問/
きつりつ /屹立/
きつりん /吉林/
きつるばみ /黄橡/
きづかい /気遣い/
きづかれ /気疲れ/
きづがわ /木津川/
きづき /杵築/
きづけ /気付/
きづた /木蔦/
きづち /木槌/
きづまり /気詰り/
きてい /規定/基底/既定/規程/汽艇/
きていじょうたい /基底状態/
きていひ /既定費/
きていまく /基底膜/
きているい /奇蹄類/
きてき /汽笛/
きてん /基点/起点/機転/
きでん /貴殿/紀伝/記伝/起電/
きでんりょく /起電力/
きと /帰途/企図/
きとう /気筒/祈祷/亀頭/帰投/貴答/
きとうし /祈祷師/
きとうしょ /祈祷書/
きとく /危篤/奇特/既得/
きとくけん /既得権/
きど /木戸/輝度/喜怒/
きどあいらく /喜怒哀楽/
きどう /起動/軌道/機動/棋道/鬼道/気道/奇童/奇道/
きどうしゃ /気動車/
きどうせい /機動性/
きどうぶたい /機動部隊/
きどうようそ /軌道要素/
きどうらく /着道楽/
きどうりょく /機動力/
きどぐち /木戸口/
きどころ /木所/
きどせん /木戸銭/
きどり /木取り/気取り/
きない /畿内/
きなが /気長/
きながし /着流し/
きなぐさみ /気慰み/
きなこ /黄粉/
きなり /生成り/
きなん /危難/
きにち /忌日/
きにゅう /記入/
きにん /帰任/貴人/
きぬ /絹/衣/
きぬいと /絹糸/
きぬおりもの /絹織物/
きぬがさ /衣笠/
きぬがわ /鬼怒川/
きぬけ /気抜け/
きぬごし /絹漉し/
きぬじ /絹地/
きぬた /砧/
きぬのみち /絹の道/
きぬばり /絹針/絹張り/
きぬもの /絹物/
きぬや /絹屋/
きぬわた /絹綿/
きね /杵/木根/
きねづか /杵柄/
きねや /杵屋/
きねん /記念/祈念/紀年/
きねんきって /記念切手/
きねんさい /記念祭/
きねんひ /記念碑/
きねんび /記念日/
きのう /機能/昨日/帰納/気嚢/帰農/
きのうきょう /昨日今日/
きのうしゅぎ /機能主義/
きのうしょうがい /機能障害/
きのうち /木内/
きのうてき /帰納的/機能的/
きのうてきていぎ /帰納的定義/
きのうび /機能美/
きのうほう /帰納法/
きのえ /甲/
きのえね /甲子/
きのかわ /紀ノ川/
きのくにや /紀伊国屋/
きのこ /茸/
きのした /木下/
きのつらゆき /紀貫之/
きのと /乙/
きのどく /気の毒/
きのぼり /木登り/
きのみ /木の実/
きのめ /木の芽/
きのり /気乗り/
きはい /跪拝/
きはく /希薄/気迫/気魄/稀薄/
きはだ /木肌/黄蘗/
きはだいろ /黄蘗色/
きはちじょう /黄八丈/
きはつ /揮発/既発/
きはつゆ /揮発油/
きはつゆぜい /揮発油税/
きはん /規範/帰帆/
きはんせん /機帆船/
きはんりょく /既判力/
きば /牙/木場/騎馬/
きばい /木灰/
きばく /起爆/
きばくやく /起爆薬/
きばせん /騎馬戦/
きばたらき /気働き/
きばつ /奇抜/
きばみんぞく /騎馬民族/
きばや /気早/
きばらし /気晴し/
きばん /基盤/基板/
きばんし /生半紙/
きひ /忌避/基肥/
きひざい /忌避剤/
きひつ /起筆/
きひん /気品/貴賓/気稟/
きび /黍/吉備/機微/驥尾/
きびき /忌引/
きびす /踵/
きびたき /黄鶲/
きびだんご /黍団子/
きびつじんじゃ /吉備津神社/
きびょう /奇病/
きびょうし /黄表紙/
きびん /機敏/
きふ /寄付/棋譜/寄附/
きふう /気風/棋風/
きふく /起伏/帰服/
きふこうい /寄付行為/
きふじん /貴夫人/貴婦人/
きぶ /基部/
きぶさい /気塞い/
きぶっせい /気ぶっせい/
きぶつ /器物/木仏/
きぶつそんかいざい /器物損壊罪/
きぶとり /着太り/
きぶね /貴船/
きぶねじんじゃ /貴船神社/
きぶん /気分/紀文/奇聞/
きへい /騎兵/
きへいたい /奇兵隊/
きへき /奇癖/
きへん /木偏/机辺/
きべん /詭弁/
きほう /貴方/既報/気泡/危峰/気胞/機鋒/
きほん /基本/
きほんきゅう /基本給/
きほんざいさん /基本財産/
きほんせっけい /基本設計/
きほんそしきけい /基本組織系/
きほんたんい /基本単位/
きほんてき /基本的/
きほんてきじんけん /基本的人権/
きほんほう /基本法/
きぼ /規模/鬼簿/
きぼう /希望/既望/
きぼうてきかんそく /希望的観測/
きぼうほう /喜望峰/
きぼく /亀卜/
きぼね /気骨/
きまえ /気前/
きまかせ /気任せ/
きまぐれ /気紛れ/
きまじめ /生真面目/
きまつ /期末/
きまま /気儘/
きまよい /気迷い/
きまり /決り/
きみ /気味/黄身/公/黄み/君/
きみいでら /紀三井寺/
きみがよ /君が代/
きみじか /気短/
きみつ /機密/君津/気密/
きみつひ /機密費/
きみどり /黄緑/
きみゃく /気脈/
きみょう /奇妙/帰命/
きみょうちょうらい /帰命頂礼/
きみん /飢民/
きむいるそん /金日成/
きむすめ /生娘/
きむち /沈菜/
きむら /木村/
きむらしょうのすけ /木村庄之助/
きめ /肌理/木目/決め/
きめい /記名/記銘/
きめいしき /記名式/
きめいしゃさい /記名社債/
きめいとうひょう /記名投票/
きめだま /決め球/
きめて /決め手/
きめん /鬼面/
きも /肝/胆/
きもいり /肝煎/
きもう /起毛/
きもうとかく /亀毛兎角/
きもすい /肝吸/
きもだめし /肝試し/
きもち /気持/
きもったま /肝っ玉/
きもの /着物/
きもん /奇問/鬼門/
きゃ /脚/
きゃく /客/脚/却/
きゃくあし /客足/
きゃくあしらい /客あしらい/
きゃくあつかい /客扱い/
きゃくい /客位/
きゃくいん /客員/脚韻/
きゃくうけ /客受け/
きゃくえん /客演/
きゃくし /客死/
きゃくしつ /客室/
きゃくしゃ /客車/客舎/
きゃくしょうばい /客商売/
きゃくしょく /脚色/
きゃくじん /客人/
きゃくすじ /客筋/
きゃくせき /客席/
きゃくせん /客船/脚線/
きゃくせんび /脚線美/
きゃくぜん /客膳/
きゃくそう /客層/客僧/
きゃくたい /客体/
きゃくちゅう /脚注/脚註/
きゃくでん /客殿/
きゃくど /客土/
きゃくどめ /客止め/
きゃくひき /客引き/
きゃくぶ /脚部/
きゃくぶん /客分/
きゃくほん /脚本/
きゃくま /客間/
きゃくよう /客用/
きゃくよせ /客寄せ/
きゃくらい /客来/
きゃくりょく /脚力/
きゃしゃ /華奢/花車/
きゃたつ /脚立/
きゃっか /却下/脚下/
きゃっかん /客観/
きゃっかんしゅぎ /客観主義/
きゃっかんせい /客観性/
きゃっかんてき /客観的/
きゃっこう /脚光/
きゃつ /彼奴/
きゃはん /脚絆/
きゃら /伽羅/
きゃらいろ /伽羅色/
きや /木屋/
きやく /規約/奇薬/
きやくぶんすう /既約分数/
きやすめ /気休め/
きやせ /着痩せ/
きやま /木山/
きやみ /気病み/
きゅう /久/吸/急/泣/救/休/及/求/旧/給/糾/級/窮/究/球/灸/朽/弓/宮/仇/丘/九/笈/糺/鳩/汲/
きゅう> /旧/
きゅうあい /求愛/
きゅうあく /旧悪/
きゅういん /吸引/吸飲/
きゅうえん /休演/救援/旧怨/旧縁/求縁/
きゅうおん /吸音/旧恩/
きゅうおんざい /吸音材/
きゅうか /休暇/旧家/球果/急火/
きゅうかい /休会/球界/旧懐/
きゅうかく /嗅覚/
きゅうかくど /急角度/
きゅうかざん /休火山/
きゅうかぶ /旧株/
きゅうかん /休刊/休館/休閑/急患/旧慣/
きゅうかんち /休閑地/
きゅうかんちょう /九官鳥/
きゅうがく /休学/
きゅうがた /旧型/
きゅうき /吸気/旧記/
きゅうきおん /吸気音/
きゅうきゅう /救急/汲々/
きゅうきゅうしゃ /救急車/
きゅうきゅうばこ /救急箱/
きゅうきょ /急遽/旧居/
きゅうきょう /窮境/旧教/究竟/
きゅうきょく /究極/窮極/
きゅうきん /球菌/給金/
きゅうぎ /球技/球戯/
きゅうぎょう /休業/
きゅうくつ /窮屈/
きゅうけい /休憩/求刑/球形/球茎/弓形/
きゅうけつ /吸血/灸穴/給血/
きゅうけつき /吸血鬼/
きゅうけんぽう /旧憲法/
きゅうげき /急激/急劇/旧劇/
きゅうげん /給源/
きゅうこ /旧故/
きゅうこう /急行/休講/旧交/休校/休耕/九江/旧稿/休航/救荒/
きゅうこうか /急降下/
きゅうこうぐん /急行軍/
きゅうこうけん /急行券/
きゅうこうさくもつ /救荒作物/
きゅうこうれっしゃ /急行列車/
きゅうこく /急告/救国/
きゅうこん /求婚/球根/窮困/
きゅうご /救護/
きゅうごう /糾合/鳩合/
きゅうごしらえ /急拵え/
きゅうごはん /救護班/
きゅうさい /救済/休載/旧債/
きゅうさく /旧作/窮策/
きゅうざひょう /球座標/
きゅうし /休止/臼歯/急死/九死/九紫/旧址/旧師/急使/窮死/
きゅうしき /旧式/旧識/
きゅうしつ /吸湿/
きゅうしつせい /吸湿性/
きゅうしふ /休止符/
きゅうしゃ /厩舎/急斜/鳩舎/柩車/
きゅうしゅ /旧主/鳩首/
きゅうしゅう /九州/吸収/急襲/旧習/
きゅうしゅうさんち /九州山地/
きゅうしゅうちほう /九州地方/
きゅうしゅうべん /九州弁/
きゅうしゅつ /救出/
きゅうしゅん /急峻/
きゅうしょ /急所/
きゅうしょう /旧称/求償/急症/
きゅうしょうがつ /旧正月/
きゅうしょうけん /求償権/
きゅうしょく /休職/給食/求職/
きゅうしん /休診/急進/求心/急伸/球審/丘疹/旧臣/急信/急診/
きゅうしんてき /急進的/
きゅうしんりょく /求心力/
きゅうじ /給仕/給餌/旧時/灸治/
きゅうじつ /休日/
きゅうじゅつ /弓術/救恤/
きゅうじょ /救助/宮女/
きゅうじょう /球場/休場/球状/窮状/宮城/弓状/
きゅうじょりょう /救助料/
きゅうじん /求人/旧人/
きゅうす /急須/
きゅうすい /吸水/給水/
きゅうすいしゃ /給水車/
きゅうすいとう /給水塔/
きゅうすう /級数/
きゅうせい /旧姓/急性/急逝/旧制/救世/九星/
きゅうせいぐん /救世軍/
きゅうせいしゅ /救世主/
きゅうせいど /旧制度/
きゅうせかい /旧世界/
きゅうせき /旧跡/求積/
きゅうせっき /旧石器/
きゅうせっきじだい /旧石器時代/
きゅうせつ /旧説/急設/
きゅうせん /休戦/弓箭/
きゅうせんぽう /急先鋒/
きゅうそ /窮鼠/泣訴/
きゅうそう /急送/穹蒼/
きゅうそく /急速/休息/球速/
きゅうそだい /窮措大/
きゅうぞう /急増/急造/旧蔵/
きゅうたい /球体/旧態/
きゅうたいいぜん /旧態依然/
きゅうたいせい /旧体制/
きゅうたいりく /旧大陸/
きゅうたく /旧宅/
きゅうたん /急湍/
きゅうだい /及第/旧題/
きゅうだん /球団/糾弾/糺弾/
きゅうち /窮地/旧知/
きゅうちしん /求知心/
きゅうちゃく /吸着/
きゅうちゅう /宮中/
きゅうちょう /級長/急潮/急調/窮鳥/
きゅうつい /急追/
きゅうつう /窮通/
きゅうてい /宮廷/休廷/
きゅうていたいりょ /九鼎大呂/
きゅうてき /仇敵/
きゅうてん /急転/灸点/
きゅうてんちょっか /急転直下/
きゅうでん /宮殿/給電/給田/休電/
きゅうと /旧都/
きゅうとう /給湯/急騰/旧冬/旧套/
きゅうどう /弓道/旧道/求道/
きゅうなん /救難/急難/
きゅうにゅう /吸入/
きゅうにゅうき /吸入器/
きゅうねん /旧年/
きゅうは /急派/旧派/
きゅうはい /九拝/朽廃/
きゅうはく /急迫/窮迫/
きゅうはん /旧版/急坂/旧藩/
きゅうはんぼん /求版本/
きゅうば /急場/
きゅうばく /旧幕/
きゅうばん /吸盤/
きゅうひ /給費/厩肥/
きゅうひん /救貧/
きゅうび /鳩尾/
きゅうびょう /急病/
きゅうびん /急便/
きゅうふ /休符/給付/
きゅうふう /旧風/
きゅうぶん /旧聞/給分/
きゅうへい /旧弊/
きゅうへん /急変/
きゅうほう /急報/旧法/臼砲/
きゅうぼ /急募/
きゅうぼう /窮乏/
きゅうぼん /旧盆/
きゅうみん /休眠/窮民/救民/
きゅうみんが /休眠芽/
きゅうみんぽう /旧民法/
きゅうむ /急務/
きゅうむいん /厩務員/
きゅうめい /究明/救命/糾明/旧名/窮命/糺明/
きゅうめいぐ /救命具/
きゅうめいてい /救命艇/
きゅうめん /球面/
きゅうめんしゅうさ /球面収差/
きゅうやく /旧訳/
きゅうやくせいしょ /旧約聖書/
きゅうゆ /給油/
きゅうゆう /級友/旧友/
きゅうよ /給与/窮余/
きゅうよう /休養/急用/球陽/給養/
きゅうらい /旧来/救癩/
きゅうらく /急落/及落/
きゅうり /胡瓜/究理/
きゅうりがく /窮理学/
きゅうりゅう /急流/穹窿/
きゅうりょう /給料/丘陵/旧領/
きゅうれき /旧暦/
きゅうろう /旧臘/
きゆう /杞憂/嬉遊/
きょ /居/去/距/許/虚/渠/挙/拠/拒/巨/炬/墟/鋸/
きょあく /巨悪/
きょい /虚位/
きょう /今日/京/強/狭/橋/鏡/胸/共/香/狂/経/叫/教/驚/饗/響/郷/興/脅/矯/況/挟/恭/恐/怯/峡/境/卿/協/凶/競/侠/供/享/兄/驕/匈/嬌/拱/羌/莢/轎/竟/梟/彊/喬/匡/兇/僑/亨/
きょうあい /狭隘/
きょうあく /凶悪/兇悪/強悪/梟悪/
きょうあす /今日明日/
きょうあつ /強圧/
きょうあん /教案/
きょうい /脅威/胸囲/驚異/強意/
きょういく /教育/
きょういくかてい /教育課程/
きょういくかんじ /教育漢字/
きょういくがく /教育学/
きょういくがくぶ /教育学部/
きょういくきき /教育機器/
きょういくけん /教育権/
きょういくこうがく /教育工学/
きょういくしゃ /教育者/
きょういくそうだん /教育相談/
きょういくちょう /教育長/
きょういくちょくご /教育勅語/
きょういくてき /教育的/
きょういくひょうか /教育評価/
きょういん /教員/
きょういんようせい /教員養成/
きょううん /強運/
きょうえい /競泳/共栄/鏡映/胸泳/競映/
きょうえき /共益/
きょうえきけん /共益権/
きょうえきさいけん /共益債権/
きょうえきひ /共益費/
きょうえきひよう /共益費用/
きょうえつ /恐悦/
きょうえん /共演/競演/饗宴/
きょうえんき /強塩基/
きょうおう /供応/饗応/胸奥/
きょうおん /跫音/
きょうおんな /京女/
きょうか /強化/教科/教化/狂歌/莢果/鏡花/橋架/
きょうかい /協会/境界/教会/教誨/胸懐/
きょうかいおんがく /教会音楽/
きょうかいせんぽう /教会旋法/
きょうかいそう /境界層/
きょうかいどう /京街道/
きょうかいへんこう /境界変更/
きょうかく /胸郭/侠客/匡郭/
きょうかしょ /教科書/
きょうかたびら /経帷子/
きょうかつ /恐喝/
きょうかつざい /恐喝罪/
きょうかまい /強化米/
きょうかん /教官/共感/叫喚/驕悍/胸間/胸管/経巻/郷貫/
きょうが /恭賀/狂画/
きょうがい /境涯/
きょうがく /共学/驚愕/教学/
きょうき /狂気/凶器/狂喜/驚喜/狭軌/強記/兇器/侠気/
きょうきゃく /橋脚/
きょうきゅう /供給/
きょうきゅうげん /供給源/
きょうきょう /恐々/兢々/
きょうきん /胸襟/胸筋/
きょうぎ /協議/競技/狭義/供犠/教義/経木/
きょうぎじょう /競技場/
きょうぎょう /協業/競業/
きょうぎょうきんし /競業禁止/
きょうぎりえん /協議離縁/
きょうぎりこん /協議離婚/
きょうく /教区/恐懼/狂句/
きょうくん /教訓/
きょうぐ /教具/
きょうぐう /境遇/
きょうけい /恭敬/
きょうけつ /供血/
きょうけん /強健/強権/狂犬/強肩/
きょうけんびょう /狂犬病/
きょうげき /京劇/挟撃/
きょうげべつでん /教外別伝/
きょうげん /狂言/
きょうげんきご /狂言綺語/
きょうげんぼん /狂言本/
きょうこ /強固/鞏固/
きょうこう /恐慌/強行/強硬/凶行/教皇/胸腔/凶荒/強攻/
きょうこうきんげん /恐惶謹言/
きょうこうぐん /強行軍/
きょうこく /峡谷/強国/郷国/
きょうこつ /胸骨/侠骨/
きょうことば /京言葉/
きょうご /教護/
きょうごう /競合/強豪/強剛/
きょうごく /京極/
きょうさ /教唆/
きょうさい /共済/共催/恐妻/凶歳/
きょうさいくみあい /共済組合/
きょうさく /競作/凶作/狭窄/警策/
きょうさつ /恐察/
きょうさはん /教唆犯/
きょうさん /協賛/共産/強酸/
きょうさんしゅぎ /共産主義/
きょうさんとう /共産党/
きょうざい /教材/
きょうざつ /夾雑/
きょうざめ /興醒め/
きょうし /教師/狂死/狂詩/教旨/
きょうしきこきゅう /胸式呼吸/
きょうしきょく /狂詩曲/
きょうしつ /教室/
きょうしゃ /強者/香車/狂者/驕奢/
きょうしゅ /興趣/教主/強取/拱手/
きょうしゅう /教習/郷愁/強襲/
きょうしゅく /恐縮/強縮/
きょうしゅつ /供出/
きょうしゅぼうかん /拱手傍観/
きょうしょ /教書/校書/
きょうしょう /狭小/協商/強将/嬌笑/
きょうしょく /教職/
きょうしょくいん /教職員/
きょうしん /共振/強震/狂信/驕心/
きょうしんざい /強心剤/
きょうしんしょう /狭心症/
きょうじ /凶事/教示/矜持/
きょうじせい /強磁性/
きょうじつ /凶日/
きょうじゃく /強弱/
きょうじゅ /教授/享受/
きょうじゅうごう /共重合/
きょうじゅかい /教授会/
きょうじゅつ /供述/
きょうじゅつしょ /供述書/
きょうじゅん /恭順/
きょうじょ /狂女/共助/
きょうじょう /教条/兇状/教場/
きょうじょうしゅぎ /教条主義/
きょうじん /狂人/兇刃/凶刃/強靱/強靭/
きょうすい /胸水/
きょうせい /強制/矯正/教生/共棲/共生/強請/嬌声/匡正/
きょうせいけいばい /強制競売/
きょうせいしっこう /強制執行/
きょうせいしょぶん /強制処分/
きょうせいしんどう /強制振動/
きょうせいそうかん /強制送還/
きょうせいそうさ /強制捜査/
きょうせいてき /強制的/
きょうせいにんち /強制認知/
きょうせいほけん /強制保険/
きょうせいりこう /強制履行/
きょうせいりょく /強制力/
きょうせいろうどう /強制労働/
きょうせいわぎ /強制和議/
きょうせん /胸腺/
きょうそ /教祖/
きょうそう /競争/競走/強壮/競漕/狂躁/凶相/
きょうそうきょく /協奏曲/狂想曲/
きょうそうざい /強壮剤/
きょうそうしけん /競争試験/
きょうそうば /競走馬/
きょうそうばいばい /競争売買/
きょうそく /教則/脇息/
きょうそくぼん /教則本/
きょうそん /共存/
きょうぞう /鏡像/胸像/経蔵/
きょうぞめ /京染/
きょうたい /筐体/狂態/嬌態/
きょうたく /供託/教卓/
きょうたくきん /供託金/
きょうたくしょ /供託所/供託書/
きょうたろう /京太郎/
きょうたん /驚嘆/
きょうだ /強打/怯懦/
きょうだい /兄弟/強大/橋台/鏡台/
きょうだいぶん /兄弟分/
きょうだん /凶弾/教団/教壇/兇弾/
きょうち /境地/
きょうちくとう /夾竹桃/
きょうちゅう /胸中/
きょうちょ /共著/
きょうちょう /強調/協調/凶兆/
きょうちょく /強直/
きょうつい /胸椎/
きょうつう /共通/
きょうつうかんかく /共通感覚/
きょうつうこう /共通項/
きょうつうご /共通語/
きょうつうぶぶん /共通部分/
きょうづか /経塚/
きょうてい /競艇/協定/教程/胸底/
きょうていせかいじ /協定世界時/
きょうてき /強敵/狂的/
きょうてん /経典/教典/
きょうてんどうち /驚天動地/
きょうでん /強電/
きょうと /京都/教徒/
きょうとう /教頭/共闘/驚倒/郷党/
きょうとうほ /橋頭堡/
きょうとく /享徳/
きょうとごしょ /京都御所/
きょうとし /京都市/
きょうとだいがく /京都大学/
きょうど /強度/郷土/匈奴/
きょうどう /共同/協同/経堂/鏡胴/教導/嚮導/共働/協働/
きょうどうかいそん /共同海損/
きょうどうくみあい /協同組合/
きょうどうしゃかい /共同社会/
きょうどうしゅっし /共同出資/
きょうどうせいはん /共同正犯/
きょうどうせんげん /共同宣言/
きょうどうせんせん /共同戦線/
きょうどうそうぞく /共同相続/
きょうどうそしょう /共同訴訟/
きょうどうたい /共同体/協同体/
きょうどうたんぽ /共同担保/
きょうどうだいり /共同代理/
きょうどうていとう /共同抵当/
きょうどうべんじょ /共同便所/
きょうどうほしょう /共同保証/
きょうどうぼうぎ /共同謀議/
きょうどうぼきん /共同募金/
きょうどし /郷土史/
きょうどしょく /郷土色/
きょうどりょうり /郷土料理/
きょうな /京菜/
きょうにんぎょう /京人形/
きょうねん /享年/凶年/
きょうは /教派/
きょうはく /脅迫/強迫/強拍/
きょうはくかんねん /強迫観念/
きょうはくざい /脅迫罪/
きょうはん /共犯/教範/橋畔/
きょうばい /競売/
きょうばし /京橋/
きょうばん /響板/夾板/
きょうひしょう /強皮症/
きょうび /今日日/
きょうふ /恐怖/教父/
きょうふう /強風/京風/狂風/矯風/
きょうふしょう /恐怖症/
きょうぶ /胸部/
きょうぶん /凶聞/狂文/
きょうへい /強兵/
きょうへき /胸壁/
きょうへん /共編/
きょうべん /強弁/教鞭/
きょうほ /競歩/
きょうほう /凶報/享保/教法/
きょうほん /教本/狂奔/経本/
きょうぼう /凶暴/兇暴/共謀/狂暴/強暴/
きょうぼく /喬木/
きょうま /京間/
きょうまい /供米/京舞/
きょうまく /莢膜/胸膜/強膜/
きょうまん /驕慢/
きょうみ /興味/
きょうみしんしん /興味津々/興味津津/
きょうみぶかい /興味深い/
きょうみほんい /興味本位/
きょうむ /教務/凶夢/
きょうむらさき /京紫/
きょうめい /共鳴/嬌名/
きょうめん /鏡面/
きょうもん /経文/
きょうやく /協約/共訳/共役/
きょうゆ /教諭/
きょうゆう /共有/享有/梟雄/侠勇/
きょうゆうけつごう /共有結合/
きょうゆうでんたい /強誘電体/
きょうよ /供与/
きょうよう /共用/教養/強要/供用/
きょうようざい /強要罪/
きょうようぶ /教養部/
きょうらく /享楽/京洛/
きょうらん /狂乱/供覧/
きょうり /郷里/教理/
きょうりき /経力/
きょうりきこ /強力粉/
きょうりつ /共立/
きょうりゅう /恐竜/
きょうりょう /橋梁/狭量/
きょうりょく /協力/強力/
きょうりん /杏林/
きょうれつ /強烈/
きょうれん /教練/狂恋/
きょうろく /享禄/
きょうわ /協和/共和/享和/
きょうわおん /協和音/
きょうわこく /共和国/
きょうわせい /共和制/
きょうわとう /共和党/
きょうわん /峡湾/
きょえい /虚栄/
きょえいしん /虚栄心/
きょおく /巨億/
きょか /許可/炬火/
きょかん /巨漢/巨艦/居館/
きょがく /巨額/
きょがん /巨岩/炬眼/
きょきょじつじつ /虚々実々/虚虚実実/
きょぎ /虚偽/
きょぎひょうじ /虚偽表示/
きょぎょう /虚業/
きょぎょうか /虚業家/
きょく /曲/局/極/棘/巨躯/
きょくいん /局員/
きょくう /極右/
きょくがい /局外/
きょくがくあせい /曲学阿世/
きょくぎ /曲技/
きょくげい /曲芸/
きょくげん /極言/極限/局限/
きょくさ /極左/
きょくざひょう /極座標/
きょくし /曲師/局紙/
きょくしょ /局所/
きょくしょう /極小/極少/
きょくしょうち /極小値/
きょくじ /曲事/
きょくじつ /旭日/
きょくじつき /旭日旗/
きょくじつしょう /旭日章/
きょくすい /曲水/
きょくせい /極性/
きょくせいぶんし /極性分子/
きょくせき /跼蹐/
きょくせつ /曲折/曲節/
きょくせん /曲線/
きょくせんひょう /曲線標/
きょくせんび /曲線美/
きょくそう /曲想/
きょくたい /極体/
きょくたん /極端/
きょくだい /極大/
きょくだいち /極大値/
きょくち /極値/極致/局地/極地/
きょくちせん /局地戦/
きょくちょう /局長/曲調/
きょくちょく /曲直/
きょくてん /極点/
きょくてんせきち /跼天蹐地/
きょくとう /極東/
きょくど /極度/
きょくどめ /局留/
きょくのり /曲乗り/
きょくば /曲馬/
きょくばだん /曲馬団/
きょくばん /局番/
きょくひつ /曲筆/
きょくび /極微/
きょくびき /曲弾き/
きょくふ /曲譜/
きょくぶ /局部/
きょくぶますい /局部麻酔/
きょくほく /極北/
きょくめい /曲名/
きょくめん /局面/曲面/
きょくもく /曲目/極目/
きょくよう /極洋/
きょくりつ /曲率/
きょくりつはんけい /曲率半径/
きょくりょう /極量/
きょくりょく /極力/
きょくろん /極論/曲論/
きょけつ /虚血/
きょげつ /去月/
きょげん /虚言/
きょこう /虚構/挙行/
きょこく /挙国/
きょこくいっち /挙国一致/
きょこつ /距骨/
きょこん /許婚/虚根/
きょごう /倨傲/
きょさつ /巨刹/
きょざい /巨財/巨材/
きょし /挙止/鋸歯/巨資/
きょしき /挙式/
きょしつ /居室/
きょしてき /巨視的/
きょしゅ /挙手/
きょしゅう /去就/去秋/
きょしゅつ /拠出/醵出/
きょしゅん /去春/
きょしょ /居所/
きょしょう /巨匠/挙証/裾礁/
きょしょうせきにん /挙証責任/
きょしょく /虚飾/
きょしょくしょう /拒食症/
きょしん /虚心/許慎/
きょしんたんかい /虚心坦懐/
きょしんへいき /虚心平気/
きょじ /虚字/虚辞/
きょじつ /虚実/
きょじゃく /虚弱/
きょじゅ /巨樹/
きょじゅう /居住/
きょじゅうせい /居住性/
きょじゅうち /居住地/
きょじょう /許状/居城/
きょじん /巨人/
きょすう /虚数/
きょすうたんい /虚数単位/
きょせい /虚勢/去勢/巨星/
きょせき /巨石/
きょせつ /虚説/
きょせん /巨船/
きょぜつ /拒絶/
きょぜつしょうしょ /拒絶証書/
きょぜつはんのう /拒絶反応/
きょそ /挙措/
きょぞう /虚像/
きょた /許多/
きょたい /巨体/
きょたく /居宅/
きょだい /巨大/
きょだいじしん /巨大地震/
きょだく /許諾/
きょだつ /虚脱/
きょっかい /曲解/
きょっきゅう /曲球/
きょっけい /極刑/
きょっこう /旭光/極光/
きょてん /拠点/
きょでん /虚伝/
きょとう /巨頭/挙党/
きょどう /挙動/
きょねん /去年/
きょひ /拒否/巨費/許否/
きょひけん /拒否権/
きょひはんのう /拒否反応/
きょふ /巨富/
きょぶん /虚聞/
きょへい /挙兵/
きょほ /巨歩/
きょほう /虚報/巨峰/巨砲/
きょぼく /巨木/
きょまん /巨万/
きょむ /虚無/
きょめい /虚名/
きょもう /虚妄/
きょよう /許容/挙用/
きょようりょう /許容量/
きょらい /去来/
きょり /距離/巨利/
きょりくうかん /距離空間/
きょりけい /距離計/
きょりゅう /居留/
きょりゅうち /居留地/
きょりゅうみん /居留民/
きょれい /虚礼/
きよ /寄与/毀誉/
きよう /器用/起用/紀要/貴陽/
きようびんぼう /器用貧乏/
きようら /清浦/
きよがき /清書/
きよさと /清里/
きよざわ /清沢/
きよす /清洲/
きよずり /清刷/
きよせ /清瀬/
きよはら /清原/
きよひめ /清姫/
きよぶき /清拭き/
きよぶん /寄与分/
きよほうへん /毀誉褒貶/
きよみ /清見/
きよみがた /清見潟/
きよみず /清水/
きよみずでら /清水寺/
きよもと /清元/
きよらか /清らか/
きよわ /気弱/
きら /綺羅/吉良/
きらい /嫌い/帰来/機雷/
きらく /気楽/喜楽/帰洛/
きらずり /雲母刷/
きらびき /雲母引/
きらぼし /綺羅星/
きらら /雲母/
きららがみ /雲母紙/
きらん /貴覧/
きり /桐/霧/錐/切り/
きりあげ /切上げ/
きりいし /切石/
きりうり /切売り/
きりえ /切絵/
きりえず /切絵図/
きりかえ /切換え/切替え/
きりかた /切り方/
きりかぶ /切株/
きりかみ /切紙/切髪/
きりきず /切り傷/
きりぎりす /蟋蟀/
きりくち /切り口/
きりこ /切子/
きりこうじょう /切口上/
きりこみ /切込み/
きりさげ /切下げ/
きりさめ /霧雨/
きりしたん /切支丹/
きりしま /霧島/
きりしまやま /霧島山/
きりすて /切捨て/
きりたんぽ /切りたんぽ/
きりだし /切出し/
きりつ /規律/起立/
きりつぼ /桐壺/
きりづま /切妻/
きりとり /切取り/
きりとりせん /切り取り線/切取り線/
きりどおし /切通し/
きりぬき /切抜き/
きりの /桐野/
きりはた /切畑/
きりばな /切り花/
きりばり /切り張り/
きりひとは /桐一葉/
きりび /鑽り火/
きりふき /霧吹き/
きりふだ /切札/
きりみ /切り身/
きりもち /切餅/
きりもみ /錐揉み/
きりもり /切り盛り/
きりゃく /機略/
きりゅう /桐生/気流/寄留/
きりょう /器量/
きりょく /気力/棋力/
きりん /麒麟/
きりんじ /麒麟児/
きれ /切れ/
きれあじ /切れ味/
きれい /綺麗/奇麗/
きれいごと /綺麗事/
きれいずき /綺麗好き/
きれいどころ /綺麗所/
きれぎれ /切れ切れ/
きれじ /切れ地/切字/
きれつ /亀裂/
きれなが /切れ長/
きれはし /切れ端/
きれま /切れ間/
きれめ /切れ目/
きれもの /切れ者/切れ物/
きろ /岐路/帰路/
きろく /記録/
きろくえいが /記録映画/
きろくてき /記録的/
きろくやぶり /記録破り/
きろめーとる /粁/
きろりっとる /竏/
きわ /際/奇話/
きわた /木棉/
きわだ /黄蘗/
きわまりづき /極月/
きわみ /極み/
きわめ /極め/
きわめいん /極印/
きわめがき /極書/
きわめつき /極め付き/
きわめて /極めて/
きわめふだ /極札/
きわもの /際物/
きをつけ /気を付け/
きん /今/近/金/筋/謹/襟/衿/菌/緊/禽/禁/琴/欽/欣/斤/錦/巾/均/勤/僅/听/釁/衾/芹/
きんあつ /禁圧/
きんい /金位/
きんいぎょくしょく /錦衣玉食/
きんいっぷう /金一封/
きんいつ /均一/
きんいろ /金色/
きんいん /近因/金印/金員/
きんうん /金運/
きんえい /近影/近詠/
きんえん /禁煙/近縁/筋炎/
きんおうむけつ /金甌無欠/
きんか /金貨/近火/槿花/
きんかい /金塊/近海/欣快/禁戒/
きんかぎょくじょう /金科玉条/
きんかく /金閣/
きんかくし /金隠し/
きんかくじ /金閣寺/
きんかざん /金華山/
きんかん /金管/近刊/金柑/金冠/金環/
きんかんがっき /金管楽器/
きんかんしょく /金環蝕/金環食/
きんかんばん /金看板/
きんが /謹賀/
きんがく /金額/
きんがしんねん /謹賀新年/
きんがみ /金紙/
きんがん /近眼/
きんき /近畿/禁忌/錦旗/欣喜/
きんきじゃくやく /欣喜雀躍/
きんきだいがく /近畿大学/
きんきちほう /近畿地方/
きんきゅう /緊急/
きんきゅうじたい /緊急事態/
きんきゅうたいほ /緊急逮捕/
きんきゅうひなん /緊急避難/
きんきょう /近況/
きんきょく /琴曲/
きんきょり /近距離/
きんきん /僅々/近々/
きんぎょ /金魚/
きんぎょく /金玉/
きんぎょくきん /金玉均/
きんぎょばち /金魚鉢/
きんぎん /金銀/
きんく /禁句/金句/
きんぐち /金口/
きんけい /謹啓/近景/
きんけつ /金欠/
きんけつびょう /金欠病/
きんけん /金券/金権/近県/勤倹/
きんけんせいじ /金権政治/
きんげん /金言/謹厳/謹言/
きんこ /金庫/禁固/禁錮/近古/
きんこう /均衡/近郊/金鉱/金工/欣幸/金坑/
きんこうよさん /均衡予算/
きんこうりろん /均衡理論/
きんこく /謹告/
きんこつ /筋骨/
きんこん /菌根/
きんこんいちばん /緊褌一番/
きんこんしき /金婚式/
きんご /金吾/
きんごう /近郷/
きんごく /禁獄/
きんさ /僅差/
きんさく /近作/金策/
きんさつ /禁札/
きんざ /金座/
きんざい /近在/
きんざん /金山/
きんし /禁止/近視/菌糸/金鵄/金糸/
きんしがん /近視眼/
きんしがんてき /近視眼的/
きんしぎょくよう /金枝玉葉/
きんしくんしょう /金鵄勲章/
きんしじょう /金市場/
きんしたまご /金糸卵/錦糸卵/
きんしつ /均質/
きんしぼん /禁止本/
きんしゅ /禁酒/筋腫/金主/
きんしゅう /錦繍/
きんしゅく /緊縮/
きんしゅほう /禁酒法/
きんしょ /禁書/謹書/
きんしょう /金賞/僅少/近称/金将/金章/
きんしん /近親/謹慎/近臣/近信/
きんしんけっこん /近親結婚/
きんしんこん /近親婚/
きんしんしゅうこう /錦心繍口/
きんしんそうかん /近親相姦/
きんじ /近似/近侍/近事/近時/金地/金字/
きんじき /禁色/
きんじち /近似値/
きんじつ /近日/
きんじつてん /近日点/
きんじて /禁じ手/
きんじとう /金字塔/
きんじゅう /禽獣/近習/
きんじょ /近所/
きんじょう /近状/金城/今上/錦上/謹上/
きんじょうてっぺき /金城鉄壁/
きんじょうとうち /金城湯池/
きんじょがっぺき /近所合壁/
きんじょめいわく /近所迷惑/
きんす /金子/
きんせい /金星/禁制/均整/謹製/近世/均斉/
きんせいひん /禁制品/
きんせき /金石/
きんせきぶん /金石文/
きんせつ /近接/
きんせつさよう /近接作用/
きんせん /金銭/琴線/謹選/
きんせんい /筋繊維/
きんせんか /金盞花/
きんせんさいけん /金銭債権/
きんせんさいむ /金銭債務/
きんせんしんたく /金銭信託/
きんせんすいとうぼ /金銭出納簿/
きんぜい /禁制/
きんぜつ /禁絶/
きんぜん /欣然/
きんそう /巾箱/
きんそく /禁則/禁足/
きんぞく /金属/勤続/
きんぞくおん /金属音/
きんぞくきじだい /金属器時代/
きんぞくこうたく /金属光沢/
きんぞくせい /金属性/
きんぞくせっけん /金属石鹸/
きんぞくひろう /金属疲労/
きんたい /勤怠/近体/
きんたま /金玉/
きんたろう /金太郎/
きんたろうあめ /金太郎飴/
きんだい /近代/
きんだいか /近代化/
きんだいげき /近代劇/
きんだいこっか /近代国家/
きんだいし /近代詩/
きんだいち /金田一/
きんだいてき /近代的/
きんだか /金高/
きんだく /欣諾/
きんだち /公達/
きんだん /禁断/金談/
きんちさんしゃ /禁治産者/
きんちてん /近地点/
きんちゃ /金茶/
きんちゃく /近着/巾着/
きんちゅう /禁中/
きんちょ /近著/
きんちょう /緊張/謹聴/金打/禁鳥/
きんちょく /謹直/
きんつば /金鍔/
きんてい /謹呈/欽定/
きんてき /金的/
きんてん /近点/均霑/
きんでい /金泥/
きんでんぎょくろう /金殿玉楼/
きんでんず /筋電図/
きんとう /均等/近東/
きんとうわり /均等割り/
きんとき /金時/
きんどけい /金時計/
きんなら /緊那羅/
きんにく /筋肉/
きんにくしつ /筋肉質/
きんにっせい /金日成/
きんねん /近年/
きんのう /勤皇/金納/
きんはんげん /禁反言/
きんば /金歯/
きんばく /緊縛/
きんばつ /禁伐/
きんぱ /金波/
きんぱい /金杯/金牌/
きんぱく /金箔/緊迫/金帛/
きんぱつ /金髪/
きんぱら /金原/
きんびょうぶ /金屏風/
きんぴょう /勤評/
きんぴん /金品/
きんぶち /金縁/
きんぶん /均分/金文/
きんぷん /金粉/
きんべん /勤勉/
きんぺいばい /金瓶梅/
きんぺん /近辺/
きんほんい /金本位/
きんぼ /欽慕/
きんぼう /近傍/
きんぼうすい /筋紡錘/
きんぼし /金星/
きんぽ /金浦/
きんまく /筋膜/
きんまんか /金満家/
きんみつ /緊密/
きんみゃく /金脈/
きんみらい /近未来/
きんむ /勤務/
きんむく /金無垢/
きんむりょくしょう /筋無力症/
きんめ /斤目/
きんもくせい /金木犀/
きんもじ /金文字/
きんもつ /禁物/
きんもん /金文/禁門/
きんやっかん /金約款/
きんゆ /禁輸/
きんゆう /金融/
きんゆうかい /金融界/
きんゆうきかん /金融機関/
きんゆうきょうこう /金融恐慌/
きんゆうさい /金融債/
きんゆうしさん /金融資産/
きんゆうせいさく /金融政策/
きんよう /金曜/
きんようび /金曜日/
きんよく /禁欲/
きんよくしゅぎ /禁欲主義/
きんらい /近来/
きんらん /金襴/金蘭/
きんり /金利/
きんりょう /禁漁/禁猟/金陵/斤量/
きんりょうく /禁猟区/
きんりょく /筋力/金力/
きんりん /近隣/
きんるい /菌類/
きんれい /禁令/金鈴/
きんろう /勤労/
きんろうしゃ /勤労者/
きんろうしょとく /勤労所得/
きんわ /謹話/
ぎ /技/疑/議/誼/義/欺/擬/戯/宜/妓/儀/偽/犠/魏/気/蟻/祇/
ぎあく /偽悪/
ぎあん /議案/
ぎいん /議員/議院/偽印/
ぎいんきそく /議院規則/
ぎいんないかくせい /議院内閣制/
ぎいんりっぽう /議員立法/
ぎえん /義捐/
ぎえんきん /義捐金/
ぎおん /祇園/擬音/
ぎおんご /擬音語/
ぎおんしょうじゃ /祇園精舎/
ぎおんばやし /祇園囃子/
ぎおんまつり /祇園祭/
ぎか /偽果/
ぎかい /議会/
ぎかく /擬革/
ぎかん /技官/
ぎが /戯画/
ぎがん /義眼/
ぎき /義気/
ぎきょ /義挙/
ぎきょう /義侠/
ぎきょうだい /義兄弟/
ぎきょく /戯曲/
ぎきん /義金/
ぎぎ /疑義/
ぎく /疑懼/
ぎぐん /義軍/
ぎけい /義兄/偽計/
ぎけつ /議決/
ぎけつきかん /議決機関/
ぎけつけん /議決権/
ぎげ /義解/
ぎげい /技芸/
ぎげいてん /伎芸天/
ぎこ /擬古/
ぎこう /技巧/技工/
ぎこうは /技巧派/
ぎこぶん /擬古文/
ぎごく /疑獄/
ぎさく /偽作/戯作/
ぎさん /蟻酸/
ぎし /技師/義肢/義姉/義歯/義士/擬死/
ぎしき /儀式/
ぎしゅ /義手/技手/
ぎしゅう /蟻集/
ぎしょ /偽書/戯書/
ぎしょう /偽称/偽証/宜昌/
ぎしわじんでん /魏志倭人伝/
ぎしん /疑心/義心/
ぎしんあんき /疑心暗鬼/
ぎじ /擬似/議事/疑似/擬餌/
ぎじどう /議事堂/
ぎじばり /擬餌鉤/
ぎじゅく /義塾/
ぎじゅつ /技術/
ぎじゅついてん /技術移転/
ぎじゅつか /技術家/
ぎじゅつかくしん /技術革新/
ぎじゅつし /技術士/
ぎじゅつしゃ /技術者/
ぎじゅつてき /技術的/
ぎじょ /妓女/
ぎじょう /議場/議定/儀仗/戯場/
ぎじろく /議事録/
ぎじん /擬人/義人/
ぎじんか /擬人化/
ぎじんほう /擬人法/
ぎせい /犠牲/擬制/擬製/
ぎせいご /擬声語/
ぎせいしほん /擬制資本/
ぎせいしゃ /犠牲者/
ぎせいだ /犠牲打/
ぎせき /議席/
ぎせん /義戦/
ぎぜつ /義絶/
ぎぜん /偽善/
ぎそう /偽装/擬装/艤装/
ぎそく /義足/
ぎぞう /偽造/
ぎぞく /義賊/
ぎたい /擬態/
ぎたいご /擬態語/
ぎだ /犠打/
ぎだい /議題/
ぎだゆう /義太夫/
ぎだゆうぼん /義太夫本/
ぎちょう /議長/
ぎっしゃ /牛車/
ぎてい /議定/義弟/
ぎていしょ /議定書/
ぎてん /儀典/疑点/
ぎねん /疑念/
ぎのう /技能/
ぎのわん /宜野湾/
ぎはん /偽版/
ぎひつ /偽筆/
ぎひょう /儀表/戯評/
ぎふ /岐阜/義父/
ぎふけん /岐阜県/
ぎふし /岐阜市/
ぎふん /義憤/
ぎぶつ /偽物/
ぎぶん /戯文/
ぎへい /義兵/
ぎほう /技法/
ぎぼ /義母/
ぎぼし /擬宝珠/
ぎまい /義妹/
ぎまん /欺瞞/
ぎみ /気味/
ぎみん /義民/
ぎむ /義務/
ぎむきょういく /義務教育/
ぎむしゃ /義務者/
ぎむてき /義務的/
ぎめい /偽名/
ぎもう /欺罔/
ぎもん /疑問/
ぎもんし /疑問詞/
ぎもんてん /疑問点/
ぎもんふ /疑問符/
ぎもんぶん /疑問文/
ぎゃく /逆/虐/瘧/
ぎゃく> /逆/
ぎゃくうん /逆運/
ぎゃくえん /逆縁/
ぎゃくかんすう /逆関数/
ぎゃくがわせ /逆為替/
ぎゃくきでんりょく /逆起電力/
ぎゃくこうか /逆効果/
ぎゃくこうせん /逆光線/
ぎゃくさつ /虐殺/
ぎゃくさん /逆算/
ぎゃくさんかっけい /逆三角形/
ぎゃくざや /逆鞘/
ぎゃくし /虐使/
ぎゃくしゅう /逆襲/
ぎゃくしん /逆心/逆臣/
ぎゃくしんぜい /逆進税/
ぎゃくしんとう /逆浸透/
ぎゃくじゅん /逆順/
ぎゃくじょう /逆上/
ぎゃくすう /逆数/
ぎゃくせい /虐政/
ぎゃくせつ /逆説/逆接/
ぎゃくせつてき /逆説的/
ぎゃくせんでん /逆宣伝/
ぎゃくぞく /逆賊/
ぎゃくたい /虐待/
ぎゃくたんち /逆探知/
ぎゃくて /逆手/
ぎゃくてん /逆転/
ぎゃくてんそう /逆転層/
ぎゃくと /逆徒/
ぎゃくばり /逆張り/
ぎゃくひ /逆比/
ぎゃくひぶ /逆日歩/
ぎゃくひれい /逆比例/
ぎゃくびき /逆引き/
ぎゃくふう /逆風/
ぎゃくもどり /逆戻り/
ぎゃくゆにゅう /逆輸入/
ぎゃくよう /逆用/
ぎゃくり /逆理/
ぎゃくりゅう /逆流/
ぎゃっきょう /逆境/
ぎゃっこう /逆行/逆光/
ぎやく /偽薬/
ぎゅう /牛/
ぎゅういんばしょく /牛飲馬食/
ぎゅうえき /牛疫/
ぎゅうご /牛後/
ぎゅうし /牛脂/
ぎゅうしゃ /牛舎/牛車/
ぎゅうじ /牛耳/
ぎゅうとう /牛刀/牛痘/
ぎゅうどん /牛丼/
ぎゅうなべ /牛鍋/
ぎゅうにく /牛肉/
ぎゅうにゅう /牛乳/
ぎゅうば /牛馬/
ぎゅうひ /牛皮/
ぎゅうほ /牛歩/
ぎゅうほせんじゅつ /牛歩戦術/
ぎゅうらく /牛酪/
ぎゆう /義勇/
ぎゆうぐん /義勇軍/
ぎょ /魚/御/漁/禦/
ぎょーざ /餃子/
ぎょい /御意/御衣/
ぎょう /行/仰/業/暁/尭/凝/形/
ぎょうあん /暁闇/
ぎょううん /暁雲/
ぎょうかい /業界/凝塊/
ぎょうかいがん /凝灰岩/
ぎょうかいし /業界紙/
ぎょうかく /仰角/
ぎょうかん /行間/
ぎょうが /仰臥/
ぎょうき /行基/
ぎょうぎ /行儀/凝議/
ぎょうけい /行刑/行啓/
ぎょうけつ /凝結/凝血/
ぎょうこ /凝固/
ぎょうこう /行幸/僥倖/暁光/
ぎょうこてん /凝固点/
ぎょうさい /業際/
ぎょうざ /餃子/
ぎょうし /凝視/仰視/凝脂/
ぎょうしゃ /業者/
ぎょうしゅ /業種/
ぎょうしゅう /凝集/凝聚/
ぎょうしゅうりょく /凝集力/
ぎょうしゅく /凝縮/
ぎょうしょ /行書/
ぎょうしょう /行商/
ぎょうじ /行事/行司/
ぎょうじゃ /行者/
ぎょうじゅうざが /行住坐臥/
ぎょうじょう /行状/
ぎょうずい /行水/
ぎょうせい /行政/暁星/
ぎょうせいいん /行政院/
ぎょうせいかん /行政官/
ぎょうせいがく /行政学/
ぎょうせいきかん /行政機関/
ぎょうせいく /行政区/
ぎょうせいくかく /行政区画/
ぎょうせいけん /行政権/
ぎょうせいこうい /行政行為/
ぎょうせいざいさん /行政財産/
ぎょうせいしどう /行政指導/
ぎょうせいしょし /行政書士/
ぎょうせいしょぶん /行政処分/
ぎょうせいじけん /行政事件/
ぎょうせいじむ /行政事務/
ぎょうせいそしき /行政組織/
ぎょうせいそしょう /行政訴訟/
ぎょうせいちょう /行政庁/
ぎょうせいてつづき /行政手続/
ぎょうせいばつ /行政罰/
ぎょうせいふ /行政府/
ぎょうせいほう /行政法/
ぎょうせき /業績/
ぎょうそう /形相/行草/
ぎょうたい /業態/凝滞/
ぎょうだ /行田/
ぎょうちゃく /凝着/
ぎょうちゅう /蟯虫/
ぎょうてん /仰天/暁天/
ぎょうとう /行頭/
ぎょうとく /行徳/
ぎょうにんべん /行人偏/
ぎょうねん /行年/
ぎょうぶ /行歩/
ぎょうぼう /仰望/
ぎょうまつ /行末/
ぎょうむ /業務/
ぎょうりつ /凝立/
ぎょうれつ /行列/
ぎょうれつしき /行列式/
ぎょえい /魚影/御影/
ぎょえん /御苑/
ぎょかい /魚介/
ぎょかいるい /魚介類/
ぎょかく /漁獲/
ぎょがん /魚眼/
ぎょき /漁期/
ぎょきょう /漁況/
ぎょぎょう /漁業/
ぎょぎょうくみあい /漁業組合/
ぎょぎょうけん /漁業権/
ぎょく /玉/漁区/
ぎょくおん /玉音/
ぎょくがん /玉顔/
ぎょくさい /玉砕/
ぎょくざ /玉座/
ぎょくしょう /玉将/
ぎょくせい /玉成/
ぎょくせき /玉石/
ぎょくせきこんこう /玉石混淆/
ぎょくたい /玉体/
ぎょくはい /玉杯/
ぎょくはく /玉帛/
ぎょくろ /玉露/
ぎょぐ /漁具/
ぎょぐん /魚群/
ぎょけい /御慶/
ぎょこう /漁港/
ぎょざ /御座/
ぎょしゃ /馭者/御者/
ぎょしゅう /漁舟/
ぎょしょう /漁礁/
ぎょしょく /漁色/
ぎょしん /魚信/御寝/
ぎょじ /御璽/
ぎょじょう /漁場/
ぎょせい /御製/
ぎょせん /漁船/御撰/
ぎょそん /漁村/
ぎょぞく /魚族/
ぎょたく /魚拓/
ぎょたん /魚探/
ぎょだい /御題/
ぎょっこう /玉稿/
ぎょにく /魚肉/
ぎょば /漁場/
ぎょひ /魚肥/
ぎょび /魚尾/
ぎょふ /漁夫/御府/
ぎょふん /魚粉/
ぎょぶつ /御物/
ぎょほう /漁法/
ぎょみん /漁民/
ぎょめい /御名/
ぎょもう /魚網/
ぎょゆ /魚油/
ぎょらい /魚雷/
ぎょりょう /漁猟/
ぎょりん /魚鱗/
ぎょるい /魚類/
ぎょろう /漁撈/
ぎよう /儀容/
ぎり /義理/
ぎりしあ /希臘/
ぎりだて /義理立て/
ぎりょう /技量/議了/技倆/
ぎれい /儀礼/
ぎれつ /義烈/
ぎろん /議論/
ぎわく /疑惑/
ぎん /銀/吟/
ぎんいろ /銀色/
ぎんえい /吟詠/
ぎんか /銀貨/
ぎんかい /銀塊/
ぎんかいしょく /銀灰色/
ぎんかく /銀閣/
ぎんかくじ /銀閣寺/
ぎんが /銀河/
ぎんがけい /銀河系/
ぎんがだん /銀河団/
ぎんがみ /銀紙/
ぎんぎつね /銀狐/
ぎんこう /銀行/銀鉤/吟行/銀坑/銀鉱/
ぎんこうか /銀行家/
ぎんこうけん /銀行券/
ぎんこうとりひき /銀行取引/
ぎんこんしき /銀婚式/
ぎんざ /銀座/
ぎんざん /銀山/
ぎんし /銀糸/
ぎんしゅ /銀朱/
ぎんしょう /吟嘯/吟誦/銀将/
ぎんしょく /銀燭/
ぎんじ /銀字/
ぎんじょう /吟醸/
ぎんじょうしゅ /吟醸酒/
ぎんす /銀子/
ぎんせい /吟声/
ぎんせかい /銀世界/
ぎんせん /銀川/
ぎんだま /銀玉/
ぎんでい /銀泥/
ぎんなん /銀杏/
ぎんねず /銀鼠/
ぎんはくしょく /銀白色/
ぎんばん /銀盤/
ぎんぱ /銀波/
ぎんぱい /銀杯/
ぎんぱく /銀箔/
ぎんぱつ /銀髪/
ぎんぷん /銀粉/
ぎんほんい /銀本位/
ぎんまく /銀幕/
ぎんみ /吟味/
ぎんもくせい /銀木犀/
ぎんゆうしじん /吟遊詩人/
ぎんよく /銀翼/
ぎんりん /銀輪/銀鱗/
ぎんれい /銀嶺/
く /口/苦/工/駆/躯/矩/区/句/九/供/貢/久/宮/庫/功/紅/垢/来/駈/玖/狗/倶/駒/
くーにゃん /姑娘/
くーりー /苦力/
くい /杭/悔い/句意/
くいあげ /食い上げ/
くいあらため /悔い改め/
くいあわせ /食合せ/
くいいじ /食い意地/
くいき /区域/
くいけ /食い気/
くいしろ /食い代/
くいしんぼう /食いしん坊/
くいぞめ /食い初め/
くいだおれ /食い倒れ/
くいちがい /食い違い/
くいどうらく /食い道楽/
くいにげ /食い逃げ/
くいぶん /食い分/
くいほうだい /食い放題/
くいもの /食い物/
くう /空/
くうい /空位/空尉/
くういき /空域/
くうかい /空海/
くうかぶ /空株/
くうかん /空間/
くうかんち /空閑地/
くうかんてき /空間的/
くうき /空気/
くうきあっしゅくき /空気圧縮機/
くうきじゅう /空気銃/
くうきょ /空虚/
くうぐん /空軍/
くうけい /空閨/
くうけん /空拳/
くうげき /空隙/
くうげん /空言/
くうこう /空港/
くうさ /空佐/
くうさつ /空撮/
くうし /空士/
くうしつ /空室/
くうしゃ /空車/
くうしゅう /空襲/
くうしゅうごう /空集合/
くうしょ /空所/
くうしょう /空将/
くうせき /空席/
くうせつ /空説/
くうせん /空戦/
くうぜん /空前/
くうぜんぜつご /空前絶後/
くうそ /空疎/
くうそう /空想/空曹/
くうそくぜしき /空即是色/
くうたい /空諦/
くうだん /空談/
くうち /空地/
くうちゅう /空中/
くうちゅうしゃしん /空中写真/
くうちゅうせん /空中戦/空中線/
くうちゅうぶんかい /空中分解/
くうちゅうろうかく /空中楼閣/
くうちょう /空調/空腸/
くうてい /空挺/
くうていぶたい /空挺部隊/
くうてん /空転/
くうでん /空電/
くうとりひき /空取引/
くうどう /空洞/
くうはく /空白/
くうばく /空爆/
くうひ /空費/
くうびん /空便/
くうふく /空腹/
くうぶん /空文/
くうほう /空砲/空包/空胞/
くうぼ /空母/
くうめい /空名/
くうや /空也/
くうゆ /空輸/
くうらん /空欄/
くうり /空理/
くうりく /空陸/
くうれい /空冷/
くうろ /空路/
くうろん /空論/
くえき /苦役/
くえん /枸櫞/
くえんさん /枸櫞酸/
くおん /久遠/
くかい /句会/区会/苦海/
くかく /区画/
くかくせいり /区画整理/
くかん /区間/躯幹/
くが /陸/
くがい /苦界/
くがいそう /九蓋草/
くがく /苦学/
くがつ /九月/
くがら /句柄/
くき /茎/久喜/九鬼/
くきょう /苦境/
くぎ /釘/供犠/
くぎかい /区議会/
くぎづけ /釘付け/
くぎょう /苦行/公卿/
くぎり /区切り/句切り/区切/
くぎん /苦吟/
くく /区々/九九/区区/
くぐい /鵠/
くぐつ /傀儡/裹/
くぐつし /傀儡師/
くぐりど /潜り戸/
くけい /矩形/
くけつ /口訣/
くけんさつちょう /区検察庁/
くげ /公家/
くげがた /公家方/
くげん /苦言/
くこ /枸杞/
くこう /句稿/
くさ /草/種/
くさいきれ /草いきれ/
くさいろ /草色/
くさか /久坂/
くさかべ /日下部/
くさかり /草刈/
くさかんむり /草冠/
くさがき /草垣/
くさき /草木/
くさく /句作/
くさぐさ /種々/
くさけいば /草競馬/
くさずもう /草相撲/
くさせんり /草千里/
くさぞうし /草双紙/
くさたけ /草丈/
くさつ /草津/
くさなぎのつるぎ /草薙剣/
くさのね /草の根/
くさはら /草原/
くさば /草葉/草場/
くさばな /草花/
くさび /楔/
くさびがた /楔形/
くさぶえ /草笛/
くさまくら /草枕/
くさみ /臭み/
くさむら /叢/
くさもち /草餅/
くさやきゅう /草野球/
くさり /鎖/
くさりかたびら /鎖帷子/
くされえん /腐れ縁/
くさわけ /草分け/
くし /櫛/串/駆使/
くしがた /櫛形/
くしきの /串木野/
くしくも /奇しくも/
くしげ /櫛笥/
くしざし /串刺し/
くしだ /櫛田/
くしま /串間/
くしめ /櫛目/
くしもと /串本/
くしゃみ /嚔/
くしやき /串焼/
くしゅう /句集/
くしょ /区処/
くしょう /苦笑/
くしろ /釧路/釧/
くしん /苦心/苦辛/
くしんさんたん /苦心惨憺/
くじ /久慈/籤/九字/
くじうん /籤運/
くじびき /籤引き/
くじゃく /孔雀/
くじゅ /口授/
くじゅう /苦渋/苦汁/久住/
くじゅうくりはま /九十九里浜/
くじょ /駆除/
くじょう /苦情/九条/
くじら /鯨/
くじらじゃく /鯨尺/
くす /樟/
くすだま /薬玉/
くすのき /樟/楠/楠木/
くすのきまさしげ /楠木正成/
くすもと /楠本/
くすやま /楠山/
くすり /薬/
くすりうり /薬売り/
くすりし /薬師/
くすりみず /薬水/
くすりや /薬屋/
くすりゆび /薬指/
くず /屑/葛/
くずいと /屑糸/
くずかご /屑籠/
くずきり /葛切り/
くずこ /葛粉/
くずしがき /崩し書き/
くずてつ /屑鉄/
くずはら /葛原/
くずまき /葛巻/
くずもち /葛餅/
くずゆ /葛湯/
くずりゅうがわ /九頭竜川/
くずれ /崩れ/
くせ /癖/曲/
くせげ /癖毛/
くせごと /曲事/
くせつ /苦節/
くせなおし /癖直し/
くせもの /曲者/
くせん /苦戦/
くせんてい /駆潜艇/
くぜつ /口説/
くそ /糞/
くそぢから /糞力/
くたにやき /九谷焼/
くだ /管/
くだい /句題/
くだけ /砕け/
ください /下さい/
くだされもの /下され物/
くだしぐすり /下し薬/
くだばしら /管柱/
くだまつ /下松/
くだもの /果物/
くだら /百済/
くだり /下り/件/
くだりざか /下り坂/
くだん /九段/件/
くち /口/
くちあたり /口当り/
くちいれ /口入れ/
くちうつし /口移し/
くちうら /口裏/口占/
くちえ /口絵/
くちおも /口重/
くちかず /口数/
くちがき /口書/
くちがため /口固め/
くちがたり /口語り/
くちがね /口金/
くちがる /口軽/
くちき /朽木/口木/
くちきき /口利き/
くちきり /口切り/
くちく /駆逐/
くちくかん /駆逐艦/
くちぐせ /口癖/
くちぐち /口々/
くちぐるま /口車/
くちげんか /口喧嘩/
くちごたえ /口答え/
くちさき /口先/
くちざわり /口触り/
くちしのぎ /口凌ぎ/
くちじょうず /口上手/
くちすぎ /口過ぎ/
くちせん /口銭/
くちぞえ /口添え/
くちだし /口出し/
くちだっしゃ /口達者/
くちづたえ /口伝え/
くちづて /口伝て/
くちとり /口取/
くちどめ /口止め/
くちどめりょう /口止め料/
くちなおし /口直し/
くちなしいろ /梔子色/
くちのは /口の端/
くちば /朽葉/
くちばいろ /朽葉色/
くちばし /嘴/
くちばや /口早/
くちひげ /口髭/
くちび /口火/
くちびょうし /口拍子/
くちびる /唇/
くちふうじ /口封じ/
くちぶえ /口笛/
くちぶり /口振り/
くちへん /口偏/
くちへんとう /口返答/
くちべた /口下手/
くちべに /口紅/
くちべらし /口減らし/
くちまえ /口前/
くちまかせ /口任せ/
くちまね /口真似/
くちもと /口許/
くちやくそく /口約束/
くちゅう /駆虫/苦衷/
くちゅうざい /駆虫剤/
くちょう /口調/区長/
くちよごし /口汚し/
くちよせ /口寄せ/
くちわき /口脇/
くちわる /口悪/
くっきょう /屈強/究竟/
くっきょく /屈曲/
くっきん /屈筋/
くっこうせい /屈光性/
くっさく /掘削/掘鑿/
くっし /屈指/
くっしゃろこ /屈斜路湖/
くっしん /屈伸/掘進/
くっせい /屈性/
くっせつ /屈折/
くっせつりつ /屈折率/
くったく /屈託/
くっちせい /屈地性/
くっぷく /屈伏/屈服/
くつ /靴/掘/沓/窟/屈/履/
くつう /苦痛/
くつがた /沓形/
くつき /朽木/
くつした /靴下/
くつじゅう /屈従/
くつじょく /屈辱/
くつずれ /靴擦れ/
くつぞこ /靴底/
くつひも /靴紐/
くつみ /久津見/
くつわ /銜/轡/
くてん /句点/
くでん /口伝/
くとう /苦闘/句読/
くとうてん /句読点/
くどう /駆動/工藤/
くどき /口説き/
くどく /功徳/
くどやま /九度山/
くない /宮内/区内/
くないしょう /宮内省/
くないちょう /宮内庁/
くなん /苦難/
くに /邦/訓/国/
くにいり /国入り/
くにおもて /国表/
くにかね /国包/
くにがえ /国替/
くにがまえ /国構え/
くにがら /国柄/
くにがろう /国家老/
くにきだ /国木田/
くにきだどっぽ /国木田独歩/
くにくのさく /苦肉の策/
くにことば /国言葉/
くにさだ /国貞/
くにざかい /国境/
くにざむらい /国侍/
くにしげ /国重/
くにたち /国立/
くにつな /国綱/
くにとも /国友/
くになまり /国訛/
くにのみやつこ /国造/
くにひろ /国広/
くにびと /国人/
くにみ /国見/
くにみつ /国光/
くにもち /国持/
くにやす /国安/
くによし /国吉/
くぬぎ /椚/櫟/
くねつ /苦熱/
くのう /苦悩/
くのうざん /久能山/
くはい /苦杯/
くはら /久原/
くひ /句碑/
くび /首/頸/
くびおけ /首桶/
くびかざり /首飾り/
くびかせ /首枷/
くびき /軛/
くびきり /首切り/
くびくくり /首縊り/
くびじっけん /首実検/
くびす /踵/
くびすじ /首筋/
くびっぴき /首っ引き/
くびなげ /首投げ/
くびひねり /首捻り/
くびれ /括れ/
くびわ /首輪/
くふう /工夫/
くぶくりん /九分九厘/
くぶん /区分/
くぶんしょゆう /区分所有/
くぶんでん /口分田/
くべつ /区別/
くほう /句法/
くほんぶつ /九品仏/
くぼ /久保/窪/
くぼう /公方/
くぼた /久保田/窪田/
くぼち /窪地/
くま /熊/隈/
くまいでん /供米田/
くまがい /熊谷/
くまがや /熊谷/
くまがわ /球磨川/
くまげら /熊啄木鳥/
くまさか /熊坂/
くまざわ /熊沢/
くまそ /熊襲/
くまたか /熊鷹/
くまで /熊手/
くまどり /隈取り/
くまなく /隈無く/
くまの /熊野/
くまのい /熊胆/
くまのがわ /熊野川/
くまばち /熊蜂/
くまもと /熊本/
くまもとけん /熊本県/
くまもとし /熊本市/
くまもとじょう /熊本城/
くまもとだいがく /熊本大学/
くまんばち /熊ん蜂/
くみ /組/苦味/
くみあい /組合/
くみあいいん /組合員/
くみあいけいやく /組合契約/
くみあわせ /組合せ/
くみいれ /組入れ/
くみいん /組員/
くみかえ /組換え/
くみがしら /組頭/
くみきょく /組曲/
くみした /組下/
くみたてこう /組立工/
くみちょう /組長/
くみはん /組版/
くみひも /組紐/
くみみほん /組見本/
くみもの /組物/
くみん /区民/
くむら /久村/
くめ /久米/粂/
くめじま /久米島/
くめん /工面/
くも /雲/蜘蛛/
くもあし /雲脚/
くもい /雲井/雲居/
くもがくれ /雲隠れ/
くもがた /雲形/
くもがたじょうぎ /雲形定規/
くもがみ /雲紙/
くもつ /供物/
くものす /蜘蛛の巣/
くもま /雲間/
くもゆき /雲行き/
くもり /曇り/曇/
くもりごえ /曇り声/
くもりぞら /曇り空/
くもん /苦悶/公文/
くもんじょ /公文所/
くやくしょ /区役所/
くやし /悔し/
くやしなき /悔し泣き/
くやしなみだ /悔し涙/
くやしまぎれ /悔し紛れ/
くやみごと /悔み言/
くよう /供養/九曜/
くら /蔵/倉/鞍/庫/
くらい /位/
くらいし /倉石/
くらいだおれ /位倒れ/
くらいどり /位取り/
くらいまけ /位負け/
くらかた /倉方/
くらがえ /鞍替え/
くらがり /闇/暗がり/
くらく /苦楽/
くらげ /海月/水母/
くらざらえ /蔵浚え/
くらしき /倉敷/
くらしきりょう /倉敷料/
くらしむき /暮し向き/
くらた /倉田/
くらに /倉荷/
くらにしょうけん /倉荷証券/
くらのすけ /内蔵助/
くらばらい /蔵払い/
くらびらき /蔵開き/
くらぶ /倶楽部/
くらべもの /比べ物/
くらま /鞍馬/
くらまい /蔵米/
くらまえ /蔵前/
くらまち /蔵町/
くらまてんぐ /鞍馬天狗/
くらまやま /鞍馬山/
くらめ /暗め/
くらもち /倉持/
くらもと /蔵元/倉元/
くらやしき /蔵屋敷/
くらやみ /暗闇/
くらよし /倉吉/
くらわたし /倉渡し/
くらんど /蔵人/
くり /栗/庫裡/涅/繰り/繰/
くりあげ /繰上げ/
くりいし /栗石/
くりいれ /繰入れ/
くりいろ /栗色/
くりうめ /栗梅/
くりかえ /繰替え/
くりかえし /繰返し/
くりかた /栗形/
くりから /倶利迦羅/
くりき /功力/
くりげ /栗毛/
くりこし /繰越し/
くりこしきん /繰越金/
くりごと /繰り言/
くりさげ /繰下げ/
くりしま /栗島/
くりた /栗田/
くりど /繰り戸/
くりねずみ /栗鼠/
くりのべ /繰延べ/
くりのべかんじょう /繰延勘定/
くりはま /久里浜/
くりもと /栗本/
くりや /厨/
くりやがわ /厨川/
くりやま /栗山/
くりょ /苦慮/
くりん /九輪/
くるいざき /狂い咲き/
くるいじに /狂い死に/
くるしまぎれ /苦し紛れ/
くるすの /栗栖野/
くるひ /来る日/
くるぶし /踝/
くるま /車/
くるまいす /車椅子/
くるまいど /車井戸/
くるまがえし /車返し/
くるまざ /車座/
くるまじ /車路/
くるまだい /車代/
くるまづか /車塚/
くるまどめ /車止め/
くるまへん /車偏/
くるまや /車屋/
くるまやど /車宿/
くるまゆり /車百合/
くるまよせ /車寄せ/
くるみ /胡桃/
くるみいろ /胡桃色/
くるめ /久留米/
くるわ /廓/
くれ /呉/暮れ/塊/
くれがた /暮れ方/
くれぐれ /呉呉/
くれたけ /呉竹/
くれない /紅/
くれむつ /暮六つ/
くろ /黒/
くろいし /黒石/
くろいそ /黒磯/
くろいわ /黒岩/
くろう /苦労/
くろうしょう /苦労性/
くろうと /玄人/
くろうど /蔵人/
くろうにん /苦労人/
くろえ /黒江/
くろかび /黒黴/
くろかみ /黒髪/
くろかわ /黒川/
くろがね /鉄/
くろがも /黒鴨/
くろき /黒木/
くろくも /黒雲/
くろぐろ /黒々/
くろげ /黒毛/
くろこげ /黒焦げ/
くろこま /黒駒/
くろご /黒衣/黒子/
くろさわ /黒沢/
くろざとう /黒砂糖/
くろしお /黒潮/
くろしま /黒島/
くろしょうぞく /黒装束/
くろしろ /黒白/
くろじ /黒字/
くろじとうさん /黒字倒産/
くろず /黒酢/
くろせがわ /黒瀬川/
くろだい /黒鯛/
くろだきよたか /黒田清隆/
くろだに /黒谷/
くろだま /黒玉/
くろちゃ /黒茶/
くろつち /黒土/
くろつるばみ /黒橡/
くろづか /黒塚/
くろとり /黒鳥/
くろど /黒戸/
くろぬり /黒塗り/
くろねこ /黒猫/
くろねずみ /黒鼠/
くろは /黒羽/
くろびかり /黒光り/
くろびょうし /黒表紙/
くろふね /黒船/
くろべ /黒部/
くろべがわ /黒部川/
くろほん /黒本/
くろぼし /黒星/
くろまく /黒幕/
くろまつ /黒松/
くろまめ /黒豆/
くろまる /黒丸/
くろみ /黒み/
くろめ /黒目/
くろめがち /黒目勝ち/
くろやなぎ /黒柳/
くろやま /黒山/
くろゆり /黒百合/
くろわく /黒枠/
くろんぼう /黒ん坊/
くわ /鍬/桑/
くわえ /加え/
くわがた /鍬形/
くわき /桑木/
くわけ /区分け/
くわこ /桑子/
くわずぎらい /食わず嫌い/
くわぞめ /桑染/
くわだて /企て/
くわちゃ /桑茶/
くわな /桑名/
くわばら /桑原/
くわやま /桑山/
くわり /区割り/
くん /君/訓/薫/勲/葷/裙/
くんい /勲位/
くんいく /訓育/
くんえん /燻煙/
くんえんざい /燻煙剤/
くんおん /君恩/
くんか /訓化/
くんかい /訓戒/訓解/
くんき /勲記/
くんげん /訓言/
くんこう /君公/勲功/
くんこく /訓告/君国/
くんし /君子/
くんしゃく /訓釈/勲爵/
くんしゅ /君主/
くんしゅこく /君主国/
くんしゅせい /君主制/
くんしゅろん /君主論/
くんしょう /勲章/
くんしん /君臣/
くんじ /訓示/訓辞/
くんじきてい /訓示規定/
くんじょう /燻蒸/
くんせい /燻製/薫製/
くんせん /薫染/
くんそく /君側/
くんちょう /君寵/
くんづけ /君付け/
くんてん /訓点/
くんでん /訓電/
くんとう /薫陶/勲等/
くんどう /訓導/
くんどく /訓読/
くんのう /君王/
くんぷ /君父/
くんぷう /薫風/
くんみん /君民/
くんみんせいおん /訓民正音/
くんめい /君命/
くんもう /訓蒙/
くんゆ /訓諭/
くんよみ /訓読み/
くんりん /君臨/
くんれい /訓令/
くんれん /訓練/
くんわ /訓話/
ぐ /愚/具/弘/虞/
ぐあい /具合/工合/
ぐあん /愚案/具案/
ぐう /隅/遇/寓/偶/宮/
ぐうい /寓意/
ぐういん /偶因/
ぐうえい /偶詠/
ぐうかく /隅角/
ぐうかん /偶感/
ぐうかんすう /偶関数/
ぐうきせい /偶奇性/
ぐうげん /寓言/
ぐうさく /偶作/
ぐうじ /宮司/
ぐうすう /偶数/
ぐうせい /偶成/
ぐうぜん /偶然/
ぐうぞう /偶像/
ぐうぞうすうはい /偶像崇拝/
ぐうているい /偶蹄類/
ぐうはつ /偶発/
ぐうもく /寓目/
ぐうゆう /偶有/
ぐうりょく /偶力/
ぐうわ /寓話/
ぐがん /具眼/
ぐきょ /愚挙/
ぐけい /愚兄/愚計/
ぐけん /愚見/
ぐげん /具現/
ぐこう /愚行/愚考/愚公/
ぐさい /愚妻/
ぐさく /愚作/愚策/
ぐしかわ /具志川/
ぐしゃ /愚者/
ぐしょ /愚書/
ぐしょう /具象/
ぐしん /具申/供進/
ぐじん /愚人/
ぐせい /愚生/
ぐせつ /愚説/
ぐそう /愚僧/
ぐそく /具足/愚息/
ぐたい /具体/
ぐたいか /具体化/
ぐたいせい /具体性/
ぐたいてき /具体的/
ぐち /愚痴/
ぐちょく /愚直/
ぐちん /具陳/
ぐてい /愚弟/
ぐとう /愚答/
ぐどう /求道/
ぐどん /愚鈍/
ぐのこっちょう /愚の骨頂/
ぐび /具備/
ぐびじん /虞美人/
ぐびじんそう /虞美人草/
ぐふう /颶風/
ぐふとくく /求不得苦/
ぐぶ /供奉/
ぐぶつ /愚物/
ぐほう /求法/
ぐまい /愚昧/愚妹/
ぐみん /愚民/
ぐもん /愚問/
ぐゆう /具有/
ぐるり /周/
ぐれつ /愚劣/
ぐれん /紅蓮/
ぐれんたい /愚連隊/
ぐろう /愚弄/愚老/
ぐろん /愚論/
ぐわい /具合/
ぐん /群/郡/軍/
ぐんい /軍医/
ぐんえい /軍営/
ぐんか /軍歌/軍靴/
ぐんかく /軍拡/
ぐんかん /軍艦/
ぐんかんき /軍艦旗/
ぐんかんく /軍管区/
ぐんがく /軍学/軍楽/
ぐんがくたい /軍楽隊/
ぐんき /軍旗/軍機/軍紀/軍記/
ぐんきものがたり /軍記物語/
ぐんきょ /群居/
ぐんぎ /群議/
ぐんけ /郡家/
ぐんけん /軍犬/
ぐんこう /軍港/軍功/
ぐんこく /軍国/
ぐんこくしゅぎ /軍国主義/
ぐんざん /群山/
ぐんし /軍士/軍師/軍使/
ぐんしきん /軍資金/
ぐんしゅう /群衆/群集/群聚/
ぐんしゅうしんり /群集心理/
ぐんしゅく /軍縮/
ぐんしょ /軍書/群書/
ぐんしょう /群小/
ぐんしれいかん /軍司令官/
ぐんしれいぶ /軍司令部/
ぐんしん /軍神/群臣/
ぐんじ /郡司/軍事/
ぐんじこうどう /軍事行動/
ぐんじゅ /軍需/
ぐんじゅひん /軍需品/
ぐんじょう /群青/
ぐんじょういろ /群青色/
ぐんじん /軍人/軍陣/
ぐんせい /群生/軍政/軍制/
ぐんせき /軍籍/
ぐんせん /軍船/
ぐんぜい /軍勢/
ぐんそう /軍曹/軍装/
ぐんそつ /軍卒/
ぐんぞう /群像/
ぐんぞく /軍属/
ぐんたい /軍隊/群体/
ぐんだり /軍荼利/
ぐんだん /軍団/軍談/
ぐんちゅう /軍中/
ぐんて /軍手/
ぐんとう /群島/軍刀/群盗/
ぐんない /郡内/
ぐんば /軍馬/
ぐんばい /軍配/
ぐんばつ /軍閥/
ぐんぱつじしん /群発地震/
ぐんび /軍備/
ぐんぴ /軍費/
ぐんぴょう /軍兵/軍票/
ぐんぶ /郡部/群舞/軍部/
ぐんぷく /軍服/
ぐんぼう /軍帽/
ぐんぽう /軍法/群峰/
ぐんぽうかいぎ /軍法会議/
ぐんま /群馬/
ぐんまけん /群馬県/
ぐんまだいがく /群馬大学/
ぐんみん /軍民/
ぐんむ /軍務/
ぐんもう /群盲/
ぐんもん /軍門/
ぐんゆう /群雄/
ぐんゆうかっきょ /群雄割拠/
ぐんよう /軍用/
ぐんようきん /軍用金/
ぐんようけん /軍用犬/
ぐんらく /群落/
ぐんりつ /軍律/
ぐんりゃく /軍略/
ぐんりょ /軍旅/
ぐんれい /軍令/
ぐんれいぶ /軍令部/
ぐんろん /群論/
け /気/化/家/毛/怪/卦/仮/恠/懸/褻/華/消/祁/
けあがり /蹴上がり/
けあげ /蹴上/蹴上げ/
けあし /毛足/
けあな /毛穴/
けい /形/型/系/兄/計/継/恵/軽/経/傾/鶏/警/詣/蛍/荊/茎/罫/繋/渓/桂/景/敬/携/掲/憩/慧/慶/径/契/圭/啓/刑/係/京/競/境/稽/蹊/奎/磬/卿/頃/閨/頚/珪/畦/
けい> /計/
けいあい /敬愛/
けいあん /慶安/
けいい /敬意/経緯/軽易/
けいいん /契印/
けいえい /経営/形影/継泳/警衛/
けいえいがく /経営学/
けいえいけん /経営権/
けいえいこうがく /経営工学/
けいえいしゃ /経営者/
けいえん /敬遠/
けいえんげき /軽演劇/
けいおう /慶応/
けいおうぎじゅく /慶応義塾/
けいおんがく /軽音楽/
けいか /経過/京華/
けいかい /警戒/軽快/啓開/
けいかいしょく /警戒色/
けいかいせん /警戒線/
けいかく /計画/圭角/
けいかくけいざい /計画経済/
けいかりし /経過利子/
けいかん /警官/景観/鶏姦/桂冠/荊冠/渓間/
けいが /慶賀/
けいがい /形骸/謦咳/
けいがく /経学/
けいがん /慧眼/炯眼/
けいき /景気/契機/継起/刑期/計器/慶喜/軽機/
けいきじゅんかん /景気循環/
けいきづけ /景気付け/
けいきひこう /計器飛行/
けいきゅうひば /軽裘肥馬/
けいきょ /軽挙/
けいきょう /景況/景教/
けいきょもうどう /軽挙妄動/
けいきんぞく /軽金属/
けいく /警句/
けいぐ /敬具/
けいけつ /経穴/
けいけん /経験/敬虔/
けいけんしゃ /経験者/
けいけんそく /経験則/
けいけんろん /経験論/
けいげつ /桂月/
けいげん /軽減/
けいこ /稽古/
けいこう /傾向/携行/蛍光/経口/馨香/鶏口/径行/
けいこうぎょう /軽工業/
けいこうたい /蛍光体/
けいこうとう /蛍光灯/
けいこうとりょう /蛍光塗料/
けいこうひにんやく /経口避妊薬/
けいこく /警告/渓谷/谿谷/経国/傾国/
けいこごと /稽古事/
けいこだい /稽古台/
けいこつ /脛骨/
けいこぼん /稽古本/
けいご /敬語/警護/
けいごう /契合/
けいごうきん /軽合金/
けいさい /掲載/
けいさつ /警察/
けいさつかん /警察官/
けいさつがっこう /警察学校/
けいさつけん /警察権/
けいさつしょ /警察署/
けいさつちょう /警察庁/
けいさつてちょう /警察手帳/
けいさつよびたい /警察予備隊/
けいさん /計算/珪酸/
けいさんき /計算機/
けいさんきかがく /計算機科学/
けいさんしょう /経産省/
けいさんじゃく /計算尺/
けいさんぷ /経産婦/
けいさんりょう /計算量/
けいざい /経済/軽罪/
けいざいか /経済家/
けいざいかい /経済界/
けいざいがく /経済学/
けいざいざい /経済財/
けいざいし /経済史/
けいざいせい /経済性/
けいざいせいさく /経済政策/
けいざいせいちょう /経済成長/
けいざいてき /経済的/
けいざいとうけい /経済統計/
けいざいとっく /経済特区/
けいざいはくしょ /経済白書/
けいざいふうさ /経済封鎖/
けいざいめん /経済面/
けいし /軽視/罫紙/警視/刑死/継子/継嗣/
けいしき /形式/型式/
けいしきげんご /形式言語/
けいしきしゅぎ /形式主義/
けいしきてき /形式的/
けいしきび /形式美/
けいしそうかん /警視総監/
けいしちょう /警視庁;東京都の警察本部,国の機関は警察庁/
けいしつ /形質/継室/憩室/
けいしゃ /傾斜/鶏舎/珪砂/
けいしゅ /警手/
けいしゅう /閨秀/慶州/
けいしゅく /慶祝/
けいしゅつ /掲出/
けいしょ /経書/
けいしょう /継承/敬称/形象/景勝/警鐘/軽傷/軽症/形勝/
けいしょく /軽食/
けいしん /軽震/敬信/京津/敬神/軽信/
けいじ /刑事/掲示/計時/啓示/慶事/兄事/
けいじか /形而下/
けいじしょぶん /刑事処分/
けいじじけん /刑事事件/
けいじじょう /形而上/
けいじじょうがく /形而上学/
けいじせいさく /刑事政策/
けいじせきにん /刑事責任/
けいじそしょう /刑事訴訟/
けいじそしょうほう /刑事訴訟法/
けいじつ /頃日/
けいじどうしゃ /軽自動車/
けいじはん /刑事犯/
けいじばつ /刑事罰/
けいじばん /掲示板/
けいじほしょう /刑事補償/
けいじゅう /軽重/
けいじょう /形状/計上/経常/啓上/京城/刑場/敬譲/警乗/
けいじょうしゅうし /経常収支/
けいじょうひ /経常費/
けいじょうみゃく /頸静脈/
けいじょうりえき /経常利益/
けいじょし /係助詞/
けいすい /軽水/
けいすいろ /軽水炉/
けいすう /係数/計数/
けいすうかん /計数管/
けいすうき /計数器/
けいず /系図/
けいずかい /窩主買/
けいせい /形成/形勢/傾城/形声/経世/警世/警醒/
けいせいさいみん /経世済民/
けいせいそう /形成層/
けいせいりょく /形成力/
けいせき /形跡/珪石/
けいせつ /蛍雪/
けいせつのこう /蛍雪の功;苦学した成果/
けいせん /罫線/経線/繋船/係船/┴/┤/┼/┘/┬/├/└/┐/┌/│/─/━/┃/┏/┓/┛/┗/┣/┳/┫/┻/╋/┠/┯/┨/┷/┿/┝/┰/┥/┸/╂/
けいそ /硅素/ケイ素/珪素/
けいそう /軽装/係争/計装/珪藻/勁草/形相/軽躁/継走/
けいそうど /珪藻土/軽鬆土/
けいそうぶつ /係争物/
けいそく /計測/
けいそつ /軽率/
けいそん /恵存/
けいぞう /恵贈/形像/
けいぞく /継続/係属/
けいぞくひ /継続費/
けいたい /形態/携帯/敬体/継体/
けいたいがく /形態学/
けいたいけいせい /形態形成/
けいたいそ /形態素/
けいたいろん /形態論/
けいたく /恵沢/
けいだい /境内/
けいだんれん /経団連/
けいちつ /啓蟄/
けいちゅう /傾注/閨中/
けいちょう /慶弔/傾聴/慶長/軽重/敬重/軽佻/敬弔/
けいちょうふはく /軽佻浮薄/
けいてい /兄弟/逕庭/
けいてき /警笛/
けいてん /経典/
けいてんあいじん /敬天愛人/
けいでんき /継電器/
けいと /毛糸/
けいとう /系統/傾倒/継投/恵投/鶏頭/
けいとうじゅ /系統樹/
けいとうてき /系統的/
けいとうはっせい /系統発生/
けいど /経度/軽度/傾度/
けいどうみゃく /頸動脈/
けいにく /鶏肉/
けいねん /経年/
けいはい /珪肺/軽輩/
けいはく /軽薄/敬白/
けいはつ /啓発/
けいはん /京阪/
けいはんざい /軽犯罪/
けいはんざいほう /軽犯罪法/
けいはんしん /京阪神/
けいば /競馬/
けいばい /競売/啓培/
けいばく /繋縛/
けいばつ /刑罰/閨閥/
けいばつけん /刑罰権/
けいひ /経費/桂皮/荊扉/
けいひこうき /軽飛行機/
けいひん /京浜/景品/
けいび /警備/軽微/
けいふ /系譜/継父/
けいふく /敬服/慶福/
けいふぼ /継父母/
けいふん /鶏糞/軽粉/
けいぶ /軽侮/警部/頸部/
けいぶつ /景物/
けいぶつし /景物詩/
けいぶほ /警部補/
けいべつ /軽蔑/
けいべん /軽便/
けいほう /警報/刑法/
けいほうき /警報器/
けいぼ /継母/敬慕/景慕/
けいぼう /警棒/閨房/警防/
けいま /桂馬/
けいみょう /軽妙/
けいみょうしゃだつ /軽妙洒脱/
けいむ /警務/
けいむかん /刑務官/
けいむしょ /刑務所/
けいめい /啓明/
けいもう /啓蒙/
けいやく /契約/
けいやくしょ /契約書/
けいゆ /経由/軽油/
けいゆう /経由/
けいよ /恵与/刑余/
けいよう /京葉/形容/掲揚/
けいようく /形容句/
けいようし /形容詞/
けいようせん /京葉線/
けいようたい /茎葉体/
けいようどうし /形容動詞/
けいようむじゅん /形容矛盾/
けいら /警邏/
けいらく /経絡/
けいらん /鶏卵/
けいり /経理/計理/刑吏/警吏/
けいりし /計理士/
けいりゃく /計略/経略/
けいりゅう /渓流/繋留/稽留/係留/
けいりょう /計量/軽量/
けいりょうき /計量器/
けいりん /競輪/桂林/経綸/
けいるい /係累/繋累/
けいれい /敬礼/
けいれき /経歴/
けいれつ /系列/
けいれん /痙攣/
けいろ /経路/毛色/
けいろう /敬老/
けいろうどう /軽労働/
けう /希有/稀有/
けおり /毛織/
けおりもの /毛織物/
けかえし /蹴返し/
けが /怪我/
けがに /毛蟹/
けがにん /怪我人/
けがれ /汚れ/
けがわ /毛皮/
けぎらい /毛嫌い/
けげん /怪訝/
けこみ /蹴込/
けご /毛蚕/
けごん /華厳/
けごんしゅう /華厳宗/
けごんのたき /華厳滝/
けさ /今朝/袈裟/
けさがた /今朝方/
けさがため /袈裟固め/
けさほど /今朝程/
けし /芥子/
けしいん /消印/
けしからぬ /怪しからぬ/
けしき /景色/気色/
けしずみ /消炭/
けしぼん /芥子本/
けしむらさき /滅紫/
けしょう /化粧/化生/
けしょうしつ /化粧室/
けしょうすい /化粧水/
けしょうだい /化粧台/
けしょうだち /化粧裁ち/
けしょうばこ /化粧箱/
けしょうばん /化粧板/
けしょうひん /化粧品/
けしん /化身/
けすじ /毛筋/
けずね /毛脛/
けずりぶし /削り節/
けせんぬま /気仙沼/
けそう /懸想/
けそうぶみ /懸想文/
けた /桁/
けたい /懈怠/仮諦/
けたぐり /蹴手繰り/
けたちがい /桁違い/
けたはずれ /桁外れ/
けたゆき /桁行/
けだかい /気高い/
けだし /蓋し/
けだま /毛玉/
けだもの /獣/
けちょう /怪鳥/
けちんぼう /けちん坊/
けっか /結果/欠課/結跏/決河/
けっかい /決壊/欠壊/決潰/結界/血塊/
けっかく /結核/欠格/
けっかくきん /結核菌/
けっかふざ /結跏趺坐/
けっかろん /結果論/
けっかん /血管/欠陥/欠巻/
けっかんしゅ /血管腫/
けっき /決起/血気/蹶起/
けっきざかり /血気盛り/
けっきゅう /血球/結球/
けっきょ /穴居/
けっきょく /結局/
けっきん /欠勤/
けっく /結句/
けっこう /結構/決行/血行/欠航/
けっこん /結婚/血痕/
けっこんきねんび /結婚記念日/
けっこんしき /結婚式/
けっこんてきれいき /結婚適齢期/
けっこんねんれい /結婚年齢/
けっこんゆびわ /結婚指輪/
けっさい /決裁/決済/潔斎/
けっさく /傑作/
けっさつ /結紮/
けっさん /決算/
けっさんき /決算期/
けっさんび /決算日/
けっさんほうこく /決算報告/
けっし /決死/傑士/
けっしきそ /血色素/
けっしたい /決死隊/
けっして /決して/
けっしゃ /結社/
けっしゅ /血腫/
けっしゅう /結集/
けっしゅつ /傑出/
けっしょ /血書/
けっしょう /決勝/結晶/血漿/
けっしょうけい /結晶系/
けっしょうこうぞう /結晶構造/
けっしょうすい /結晶水/
けっしょうてん /決勝点/
けっしょうばん /血小板/
けっしょく /欠食/血色/
けっしん /決心/結審/
けっせい /結成/血清/
けっせいかんえん /血清肝炎/
けっせいりょうほう /血清療法/
けっせき /欠席/結石/
けっせきはんけつ /欠席判決/
けっせつ /結節/
けっせん /血栓/決戦/血戦/
けっせんとうひょう /決選投票/
けっそう /血相/傑僧/
けっそく /結束/
けっそん /欠損/
けったく /結託/
けったん /血痰/
けっちゃく /結着/決着/
けっちゅう /桀紂/
けっちょう /結腸/
けっちん /血沈/
けってい /決定/
けっていそしき /結締組織/
けっていてき /決定的/
けっていばん /決定版/
けっていろん /決定論/
けってん /欠点/
けっとう /血統/決闘/結党/血糖/
けっとうざい /決闘罪/
けっとうしょ /血統書/
けっとうじょう /決闘状/
けっぱい /欠配/
けっぱく /潔白/
けっぱつ /結髪/
けっぱん /血判/
けっぴょう /結氷/
けっぷん /血粉/
けっぺい /血餅/
けっぺき /潔癖/
けつ /穴/決/結/訣/血/潔/欠/傑/桀/碣/闕/
けつあつ /血圧/
けつあつけい /血圧計/
けつい /決意/
けついん /欠員/闕員/
けつえき /血液/
けつえきがた /血液型/
けつえん /血縁/結縁/
けつえんかんけい /血縁関係/
けつがん /頁岩/
けつぎ /決議/
けつぎあん /決議案/
けつご /結語/
けつごう /結合/
けつごうしき /結合織/
けつごうそしき /結合組織/
けつごうほうそく /結合法則/
けつじつ /結実/
けつじょ /欠如/闕如/
けつじょう /欠場/決定/結縄/
けつじん /傑人/
けつぜい /血税/
けつぜん /蹶然/決然/
けつぞく /血族/
けつだん /決断/結団/
けつにく /血肉/
けつにょう /血尿/
けつばん /欠番/
けつび /結尾/
けつぶつ /傑物/
けつべつ /訣別/決別/
けつべん /血便/
けつぼう /欠乏/
けつまく /結膜/
けつまくえん /結膜炎/
けつまつ /結末/
けつみゃく /血脈/
けつめい /結盟/血盟/
けつゆうびょう /血友病/
けつらく /欠落/
けつりょう /結了/
けつるい /血涙/
けつれい /欠礼/
けつれつ /決裂/
けつろ /結露/血路/
けつろん /結論/
けづくろい /毛繕い/
けづな /毛綱/
けとう /毛唐/
けない /家内/
けなげ /健気/
けなみ /毛並/
けにん /化人/
けぬき /鑷/
けねん /懸念/
けはい /気配/
けば /毛羽/
けばり /毛鉤/
けびいし /検非違使/
けびょう /仮病/
けぼうず /毛坊主/
けぼり /毛彫/
けまり /蹴鞠/
けむ /煙/烟/
けむし /毛虫/
けむり /煙/烟/
けもの /獣/
けものへん /獣偏/
けものみち /獣道/
けやき /欅/
けら /螻蛄/
けらい /家来/
けらく /快楽/
けりょう /家領/仮令/
けわい /化粧/
けん /見/間/件/研/肩/犬/嫌/権/験/顕/険/遣/軒/賢/謙/県/絹/献/牽/検/拳/懸/憲/建/堅/圏/剣/券/兼/健/倹/繭/鍵/喧/腱/妍/黔/乾/硯/捲/倦/
けんあく /険悪/
けんあん /懸案/検案/
けんあんしょ /検案書/
けんい /権威/
けんいしゅぎ /権威主義/
けんいん /牽引/検印/
けんいんしゃ /牽引車/
けんうん /絹雲/
けんえい /県営/兼営/献詠/顕栄/
けんえき /検疫/権益/
けんえつ /検閲/
けんえん /嫌煙/犬猿/倦厭/
けんお /嫌悪/
けんおん /検温/
けんおんき /検温器/
けんか /喧嘩/県下/堅果/献花/鹸化/
けんかい /見解/県会/狷介/
けんかく /懸隔/剣客/
けんかごし /喧嘩腰/
けんかしょくぶつ /顕花植物/
けんかん /建艦/兼官/顕官/
けんが /懸河/
けんがい /圏外/懸崖/遣外/
けんがく /見学/建学/研学/兼学/
けんがん /検眼/
けんき /嫌忌/
けんきゃく /健脚/剣客/
けんきゅう /研究/
けんきゅうかい /研究会/
けんきゅうかいはつ /研究開発/
けんきゅうしつ /研究室/
けんきゅうしゃ /研究者/
けんきゅうしょ /研究所/
けんきゅうじょ /研究所/
けんきょ /謙虚/検挙/
けんきょう /牽強/検鏡/
けんきょうふかい /牽強附会/
けんきん /献金/兼勤/
けんぎ /嫌疑/県議/建議/
けんぎかい /県議会/
けんぎゅう /牽牛/
けんぎゅうせい /牽牛星/
けんぎょう /兼業/検校/
けんぎょうのうか /兼業農家/
けんぐ /賢愚/
けんけい /賢兄/
けんけつ /献血/欠缺/
けんけんがくがく /喧喧諤諤;喧々囂々(けんけんごうごう)あるいは侃々諤々(かんかんがくがく)の間違い,色々な意見が出て収拾がつかない,喧喧囂囂+侃侃諤諤/
けんけんごうごう /喧々囂々;多くの人々が口々に騒がしい/喧喧囂囂/
けんけんひきゅう /蹇蹇匪躬;君主につくし私利をかえりみない/
けんけんふくよう /拳拳服膺;心して忘れず守る/
けんげき /剣劇/
けんげん /権限/顕現/権原/建言/献言/
けんこう /健康/軒昂;意気-/兼行;昼夜-/箝口;口をつぐむ,発言を封ずる,カンコウとも/権衡;平均/堅甲;堅い甲殻/
けんこうこつ /肩甲骨/肩胛骨/
けんこうしんだん /健康診断/
けんこうたい /健康体/
けんこうてき /健康的/
けんこうほけん /健康保険/
けんこうほけんほう /健康保険法/
けんこく /建国/
けんこんいってき /乾坤一擲;のるかそるかの勝負をする/
けんご /堅固/謙語/
けんごう /剣豪/堅剛/
けんさ /検査/
けんさい /賢才/
けんさかん /検査官/
けんさき /剣先/
けんさく /検索/献策/研削/羂索/
けんさくばん /研削盤/
けんさつ /検察/検札/賢察/
けんさつかん /検察官/
けんさつしんさかい /検察審査会/
けんさつちょう /検察庁/
けんさやく /検査役/
けんさん /研鑽/建盞/
けんざい /健在/顕在/建材/
けんざん /検算/剣山/見参/験算/
けんし /犬歯/剣士/検視/絹糸/献詞/繭糸/
けんしき /見識/
けんしゃ /検車/
けんしゅ /堅守/賢主/
けんしゅう /研修/兼修/献酬/
けんしゅつ /検出/
けんしょ /見所/
けんしょう /検証/憲章/健勝/懸賞/顕彰/肩章/腱鞘/見性/兼掌/謙称/
けんしょうえん /腱鞘炎/
けんしょうぶつ /検証物/
けんしょく /兼職/顕職/
けんしん /検診/献身/検針/健診/検真/献進/
けんじ /検事/健児/顕示/堅持/献辞/建治/検字/謙辞/
けんじきょく /検事局/
けんじせい /検事正/
けんじそうちょう /検事総長/
けんじちょう /検事長/
けんじつ /堅実/
けんじゃ /賢者/
けんじゃく /間尺/
けんじゃのいし /賢者の石/
けんじゅう /拳銃/
けんじゅつ /剣術/
けんじょ /賢女/
けんじょう /謙譲/献上/堅城/
けんじょうご /謙譲語/
けんじょうしゃ /健常者/
けんじん /県人/賢人/堅陣/
けんじんかい /県人会/
けんすい /懸垂/建水/
けんすう /件数/軒数/間数/
けんずいし /遣隋使/
けんせい /牽制/権勢/憲政/県勢/
けんせき /譴責/
けんせきうん /巻積雲/
けんせつ /建設/兼摂/
けんせつぎょう /建設業/
けんせつだいじん /建設大臣/
けんせつてき /建設的/
けんせつりそく /建設利息/
けんぜい /県税/
けんぜつ /懸絶/
けんぜん /健全/
けんそ /倹素/
けんそう /喧噪/喧騒/険相/
けんそううん /巻層雲/
けんそく /検束/
けんそん /謙遜/
けんぞう /建造/
けんぞうぶつ /建造物/
けんぞく /眷属/眷族/
けんたい /倦怠/検体/献体/兼帯/
けんたいき /倦怠期/
けんたん /健啖/検痰/
けんだい /見台/兼題/賢台/
けんち /検知/見地/見知/検地/
けんちく /建築/
けんちくきょうてい /建築協定/
けんちくし /建築士/
けんちくせん /建築線/
けんちくぶつ /建築物/
けんちじ /県知事/
けんちゃ /献茶/
けんちょ /顕著/
けんちょう /県庁/堅調/建長/
けんちょうしゃ /健聴者/
けんてい /検定/献呈/賢弟/
けんていしけん /検定試験/
けんてき /硯滴/
けんてつ /賢哲/
けんてん /圏点/
けんでん /喧伝/
けんとう /検討/見当/健闘/拳闘/賢答/
けんとうし /遣唐使/
けんとうちがい /見当違い/
けんとく /乾徳/
けんどう /剣道/県道/権道/
けんどじゅうらい /捲土重来/
けんどちょうらい /捲土重来/
けんない /圏内/県内/
けんなん /険難/剣難/
けんにょう /検尿/
けんにん /兼任/検認/堅忍/
けんにんふばつ /堅忍不抜/
けんのう /献納/権能/
けんのん /剣呑/
けんはんしゃ /腱反射/
けんば /犬馬/
けんばいき /券売機/
けんばん /鍵盤/
けんばんがっき /鍵盤楽器/
けんぱ /検波/
けんぱく /建白/絹帛/
けんぱくしょ /建白書/
けんぱくどうい /堅白同異/
けんび /兼備/顕微/
けんびきょう /顕微鏡/
けんびし /剣菱/
けんぴ /建碑/
けんぴつ /健筆/
けんぴょう /堅氷/
けんぴん /検品/
けんぶ /剣舞/
けんぶつ /見物/
けんぶん /見聞/検分/見分/
けんぷ /絹布/
けんぷじん /賢夫人/
けんべつ /軒別/
けんべん /検便/
けんぺい /憲兵/権柄/兼併/
けんぺいりつ /建蔽率/
けんぼ /賢母/
けんぼう /権謀/健忘/
けんぼうしょう /健忘症/
けんぼうじゅっすう /権謀術数/
けんぽ /健保/
けんぽう /憲法/拳法/剣法/
けんぽういはん /憲法違反/
けんぽうかいせい /憲法改正/
けんぽうきねんび /憲法記念日/
けんぽん /献本/絹本/
けんま /研磨/研摩/
けんまき /研磨機/
けんまこくげき /肩摩轂撃/
けんみ /検見/
けんみん /県民/
けんむ /兼務/建武/
けんめい /懸命/賢明/件名/
けんめいしゅぎ /顕名主義/
けんめん /券面/
けんもつ /監物/献物/
けんもん /検問/見聞/権門/
けんもんしょ /検問所/
けんやく /倹約/
けんゆう /県有/
けんゆうしゃ /硯友社/
けんよう /兼用/険要/顕要/顕揚/
けんようすい /懸壅垂/
けんらん /絢爛/
けんり /権利/
けんりおち /権利落/
けんりかぶ /権利株/
けんりきん /権利金/
けんりしち /権利質/
けんりつ /県立/
けんりつき /権利付/
けんりのうりょく /権利能力/
けんりもんだい /権利問題/
けんりょ /賢慮/
けんりょう /見料/
けんりょく /権力/
けんるい /堅塁/
けんれい /県令/
けんれんはん /牽連犯/
けんろう /堅牢/
けんろくえん /兼六園/
けんわんちょくひつ /懸腕直筆/
げ /下/外/解/夏/偈/気/牙/
げい /鯨/迎/芸/黥/
げいいき /芸域/
げいいん /鯨飲/
げいか /猊下/
げいかい /芸界/
げいぎ /芸妓/
げいげき /迎撃/
げいこ /芸子/
げいごう /迎合/
げいごと /芸事/
げいしゃ /芸者/
げいしゅう /芸州/
げいしゅん /迎春/
げいじゅつ /芸術/
げいじゅついん /芸術院/
げいじゅつか /芸術家/
げいじゅつさい /芸術祭/
げいじゅつてき /芸術的/
げいじゅつひん /芸術品/
げいだん /芸談/
げいとう /芸当/
げいどう /芸道/
げいにん /芸人/
げいのう /芸能/
げいは /鯨波/
げいひん /迎賓/
げいひんかん /迎賓館/
げいび /芸備/
げいびせん /芸備線/
げいふう /芸風/
げいぶん /芸文/
げいめい /芸名/
げいゆ /鯨油/
げか /外科/
げかい /下界/外科医/
げかん /下疳/
げき /激/撃/戟/劇/隙/屐/檄/闃/鷁/外記/
げき> /激/
げきえいが /劇映画/
げきえつ /激越/
げきか /激化/劇化/
げきかい /劇界/
げきが /劇画/
げきげん /激減/
げきご /激語/
げきさく /劇作/
げきし /劇詩/
げきしょ /激暑/
げきしょう /激賞/
げきしょく /激職/
げきしん /激震/
げきじょう /劇場/激情/撃攘/
げきせん /激戦/
げきぞう /激増/
げきたい /撃退/
げきだん /劇団/劇談/劇壇/
げきちゅうげき /劇中劇/
げきちん /撃沈/
げきつい /撃墜/
げきつう /激痛/劇通/
げきてき /劇的/
げきてつ /撃鉄/
げきとう /激闘/
げきとつ /激突/
げきど /激怒/
げきどう /激動/
げきどく /劇毒/
げきは /撃破/
げきはつ /激発/
げきひょう /劇評/
げきぶつ /劇物/
げきぶん /檄文/
げきへん /激変/
げきむ /激務/劇務/
げきめつ /撃滅/
げきやく /劇薬/
げきりゅう /激流/
げきりょく /撃力/
げきりん /逆鱗/
げきれい /激励/
げきれつ /激烈/
げきろう /激浪/
げきろん /激論/
げぎ /外儀/
げくう /外宮/
げけつ /下血/
げこ /下戸/
げこう /下校/下向/
げこく /下刻/
げこくじょう /下剋上/
げこん /下根/
げごく /下獄/
げさく /戯作/下作/下策/
げさくしゃ /戯作者/
げざ /下座/
げざい /下剤/
げし /夏至/
げしゃ /下車/
げしゅく /下宿/
げしゅくや /下宿屋/
げしゅにん /下手人/
げじく /牙軸/
げじげじ /蚰蜒/
げじゅん /下旬/
げじょ /下女/
げじょう /下乗/下城/
げじん /外陣/
げす /下衆/下種/下司/
げすい /下水/
げすいかん /下水管/
げすいしょり /下水処理/
げすいどう /下水道/
げせわ /下世話/
げせん /下船/牙籤/
げそく /下足/
げそくばん /下足番/
げた /下駄/
げたばこ /下駄箱/
げだい /外題/
げだつ /解脱/
げだん /下段/
げち /下知/
げっか /月下/
げっかひょうじん /月下氷人/
げっかびじん /月下美人/
げっかん /月刊/月間/
げっきゅう /月給/
げっけい /月経/月計/
げっけいかん /月桂冠/
げっけいじゅ /月桂樹/
げっこう /月光/激昂/激高/
げっさん /月産/
げっしゃ /月謝/
げっしゅう /月収/
げっしょう /月商/
げっしょく /月食/月蝕/
げっしるい /齧歯類/
げっせかい /月世界/
げったん /月旦/
げっぴょう /月評/月表/
げっぷ /月賦/
げっぺい /月餅/
げっぽう /月報/月俸/
げつ /月/
げつえい /月影/
げつがく /月額/
げつじ /月次/
げつまつ /月末/
げつめい /月明/
げつめん /月面/
げつよ /月余/
げつよう /月曜/
げつようび /月曜日/
げつらい /月来/
げつり /月利/
げつりん /月輪/
げつれい /月例/月齢/
げてもの /下手物/
げてん /下天/外典/
げどう /外道/
げどく /解毒/
げどくざい /解毒剤/
げなん /下男/
げに /実に/
げにん /下人/解任/
げねつ /解熱/
げねつざい /解熱剤/
げはん /下阪/
げば /下馬/
げばひょう /下馬評/
げひん /下品/
げび /下卑/
げほう /外法;外道,⇔内法,内道/
げぼく /下僕/
げめん /外面/
げや /下屋/下野/
げらく /下落/
げり /下痢/
げりゃく /下略/
げるまにうむ /Germanium/
げれつ /下劣/
げろう /下郎/
げろおんせん /下呂温泉/
げん /原/現/言/限/源/元/減/厳/玄/弦/幻/舷/験/嫌/絃/眼/監/諺/
げん> /現/元/
げんあつ /減圧/
げんあつしょう /減圧症/
げんあん /原案/
げんい /原意/
げんいん /原因/減員/現員/
げんうん /眩暈/
げんえい /幻影/
げんえき /現役/減益/原液/
げんえん /減塩/
げんおう /元応/玄奥/
げんおん /原音/
げんか /原価/言下/減価/現下/現価/厳科/
げんかい /限界/厳戒/言海/幻怪/諺解/
げんかいこうよう /限界効用/
げんかいなだ /玄界灘/
げんかいひよう /限界費用/
げんかく /厳格/幻覚/
げんかくせいぶつ /原核生物/
げんかけいさん /原価計算/
げんかしょうきゃく /減価償却/
げんかん /玄関/厳寒/
げんかんさき /玄関先/
げんかんばらい /玄関払い/
げんかんばん /玄関番/
げんが /原画/
げんがい /言外/限外/
げんがく /弦楽/減額/衒学/絃楽/
げんがっき /弦楽器/
げんき /元気/原器/原基/
げんきゃく /減却/
げんきゅう /言及/減給/原級/
げんきょ /原拠/
げんきょう /元凶/現況/
げんきょく /原曲/元曲/限局/
げんきん /現金/厳禁/
げんきんかきとめ /現金書留/
げんきんかんじょう /現金勘定/
げんきんとりひき /現金取引/
げんぎ /原義/
げんぎょ /言語/
げんぎょう /現業/
げんくう /源空/
げんくん /元勲/厳君/
げんけい /原形/原型/減刑/減軽/現形/厳刑/
げんけいしつ /原形質/
げんけいしつまく /原形質膜/
げんげつ /限月/弦月/
げんこ /拳固/
げんこう /原稿/現行/言行/元寇/元弘/原鉱/
げんこうはん /現行犯/
げんこうほう /現行法/
げんこうようし /原稿用紙/
げんこうりょう /原稿料/
げんこく /原告/
げんこつ /拳骨/
げんこん /現今/
げんご /言語/原語/
げんごう /元号/減号/
げんごうんよう /言語運用/
げんごがく /言語学/
げんごきょういく /言語教育/
げんごしんりがく /言語心理学/
げんごのうりょく /言語能力/
げんごろう /源五郎/
げんさい /減殺/幻妻/衒妻/減債/
げんさいききん /減債基金/
げんさいばん /原裁判/
げんさきとりひき /現先取引/
げんさく /原作/減作/
げんさくどうぶつ /原索動物/
げんさん /原産/減産/
げんさんち /原産地/
げんざい /現在/原罪/
げんざいかんりょう /現在完了/
げんざいだか /現在高/
げんざいち /現在地/
げんざいぶんし /現在分詞/
げんざいりょう /原材料/
げんざん /減算/
げんし /原子/原始/減資/原資/幻視/原紙/元始/
げんしかく /原子核/
げんしかんすう /原始関数/
げんしきごう /原子記号/
げんしじ /原子時/
げんしじだい /原始時代/原史時代/
げんしじん /原始人/
げんしだん /原子団/
げんしつ /言質/玄室/原質/
げんしてき /原始的/
げんしどけい /原子時計/
げんしばくだん /原子爆弾/
げんしばんごう /原子番号/
げんしびょう /原子病/
げんしぶつりがく /原子物理学/
げんしゃ /減車/
げんしゃく /現尺/
げんしゅ /厳守/元首/原種/原酒/
げんしゅう /減収/現収/
げんしゅく /厳粛/減縮/
げんしゅつ /現出/
げんしょ /原書/原初/厳暑/
げんしょう /現象/減少/
げんしょうがく /現象学/
げんしょく /現職/原色/減食/
げんしょくばん /原色版/
げんしりょう /原子量/
げんしりょく /原子力/
げんしりょくせん /原子力船/
げんしりん /原始林/
げんしろ /原子炉/
げんしろう /源四郎/
げんしろん /原子論/
げんしん /原審/
げんじ /源氏/言辞/現示/現時/
げんじえ /源氏絵/
げんじつ /現実/
げんじつげんそく /現実原則/
げんじつせい /現実性/
げんじつてき /現実的/
げんじてん /現時点/
げんじな /源氏名/
げんじものがたり /源氏物語/
げんじゅう /厳重/現住/
げんじゅうしょ /現住所/
げんじゅうみん /原住民/
げんじゅつ /幻術/
げんじょう /現状/現場/原状/玄奘/
げんじょうかいふく /原状回復/
げんじん /原人/
げんすい /減衰/元帥/減水/
げんすいしんどう /減衰振動/
げんすいばく /原水爆/
げんすう /減数/現数/
げんすうぶんれつ /減数分裂/
げんすん /原寸/
げんず /原図/
げんせ /現世/
げんせい /厳正/現世/現勢/原生/
げんせいじんるい /現生人類/
げんせいだい /原生代/
げんせいどうぶつ /原生動物/
げんせいりん /原生林/
げんせき /原石/原籍/言責/
げんせつ /言説/
げんせりやく /現世利益/
げんせん /厳選/源泉/言泉/
げんせんかぜい /源泉課税/
げんぜい /減税/
げんぜん /厳然/儼然/現前/
げんそ /元素/
げんそう /幻想/現送/舷窓/
げんそうきょく /幻想曲/
げんそうてき /幻想的/
げんそきごう /元素記号/
げんそく /原則/減速/舷側/
げんそくざい /減速材/
げんそん /現存/減損/玄孫/厳存/
げんぞう /現像/幻像/
げんぞうえき /現像液/
げんぞく /還俗/
げんた /源太/
げんたい /減退/原隊/
げんたいけん /原体験/
げんたつ /厳達/
げんたん /減反/
げんだい /現代/原題/
げんだいかなづかい /現代仮名遣/
げんだいげき /現代劇/
げんだいご /現代語/
げんだいてき /現代的/
げんだいぶん /現代文/
げんだか /現高/
げんち /現地/言質/玄地/
げんちほうじん /現地法人/
げんちゅう /原註/原虫/
げんちょ /原著/
げんちょう /幻聴/
げんてい /限定/
げんていし /限定詞/
げんていしょうにん /限定承認/
げんていそうぞく /限定相続/
げんていばん /限定版/
げんてん /原点/減点/原典/
げんとう /厳冬/幻灯/舷灯/
げんとく /玄徳/元徳/
げんど /限度/
げんどう /言動/原動/
げんどうき /原動機/
げんどうりょく /原動力/
げんな /元和/
げんない /源内/
げんなおし /験直し/
げんなま /現生/
げんに /現に/
げんにん /現任/現認/
げんのう /玄能/玄翁/玄応/源翁/
げんはんけつ /原判決/
げんば /現場/玄蕃/
げんばかんとく /現場監督/
げんばく /原爆/
げんばくしょう /原爆症/
げんばつ /厳罰/
げんばん /原盤/
げんぱい /減配/
げんぱつ /原発/
げんぱん /原版/
げんぴ /厳秘/
げんぴょう /原票/
げんぴん /現品/原品/
げんふうけい /原風景/
げんぶ /玄武/
げんぶがん /玄武岩/
げんぶつ /現物/原物/
げんぶつきゅうよ /現物給与/
げんぶつしゅっし /現物出資/
げんぶつとりひき /現物取引/
げんぶん /原文/言文/元文/
げんぶんいっち /言文一致/
げんぷ /厳父/
げんぷう /厳封/
げんぺい /源平/
げんぺいとうきつ /源平藤橘/
げんぼ /原簿/
げんぼく /原木/
げんぽう /減法/減俸/
げんぽん /原本/
げんま /減摩/
げんまい /玄米/
げんまいしょく /玄米食/
げんまいちゃ /玄米茶/
げんみつ /厳密/
げんみょう /玄妙/
げんむ /幻夢/
げんめい /言明/厳命/
げんめつ /幻滅/
げんめん /減免/原綿/
げんもう /減耗/原毛/
げんもく /眩目/
げんや /原野/
げんゆ /原油/
げんゆう /現有/
げんようたい /原葉体/
げんり /原理/
げんりゅう /源流/
げんりょう /原料/減量/
げんろう /元老/
げんろういん /元老院/
げんろく /元禄/
げんろん /原論/言論/
げんわ /元和/
げんわく /眩惑/幻惑/
こ /子/小/個/故/古/己/固/庫/弧/去/拠/戸/呼/湖/粉/誇/顧/木/鼓/孤/乎/雇/股/胡/枯/姑/虚/鈷/糊/袴/児/来/箇/滬/瞽/壺/濃/賈/黄/虎/狐/跨/菰/
こ> /仔/小/
こーつ /刻子/
こあきない /小商い/
こあげ /小揚/
こあざ /小字/
こあし /小足/
こあたり /小当り/
こあゆ /小鮎/
こい /恋/鯉/故意/請い/
こいうた /恋歌/
こいかぜ /恋風/
こいがたき /恋敵/
こいき /小粋/
こいくち /濃口/
こいぐち /鯉口/
こいごころ /恋心/
こいし /礫/恋し/小石/
こいしかわ /小石川/
こいじ /恋路/
こいずみ /小泉/古泉/
こいずみやくも /小泉八雲/
こいそ /小磯/
こいた /小板/
こいちゃ /濃茶/
こいで /小出/
こいと /小糸/
こいなか /恋仲/
こいにょうぼう /恋女房/
こいぬ /子犬/小犬/
こいねず /濃鼠/
こいのたきのぼり /鯉の滝登り/
こいのぼり /鯉幟/
こいはん /故意犯/
こいびと /恋人/
こいぶみ /恋文/
こいやみ /恋病み/
こいん /雇員/
こう /行/高/構/工/公/向/効/校/交/考/項/稿/後/更/講/好/広/候/幸/康/抗/紅/降/購/功/貢/光/航/甲/口/格/興/荒/恒/港/孝/皇/攻/厚/耕/鉱/慌/酵/肯/硬/浩/江/拘/巧/孔/仰/香/鋼/郊/衡/綱/洪/控/黄/弘/侯/絞/溝/坑/膏/昂/宏/喉/垢/耗/庚/后/巷/爻/国府/亢/薨/鉤/斯う/劫/神/梗/晃/勾/腔/紘/鴻/佼/杭/倖/閤/砿/肱/糠/
こう> /高/広/
こうあつ /高圧/光圧/
こうあつざい /降圧剤/
こうあつせん /高圧線/
こうあつてき /高圧的/
こうあん /考案/公安/公案/弘安/
こうあんいいんかい /公安委員会/
こうあんじょうれい /公安条例/
こうい /行為/好意/高位/更衣/厚意/校医/皇位/攻囲/校異/
こういき /広域/
こういけいしょう /皇位継承/
こういしょう /後遺症/
こういぜい /行為税/
こういっつい /好一対/
こういってん /紅一点/
こういつ /後逸/
こういど /高緯度/
こういのうりょく /行為能力/
こういろ /香色/
こういん /公印/工員/拘引/行員/光陰/荒淫/勾引/後印/後胤/
こういんじょう /勾引状/
こうう /降雨/項羽/
こううりょう /降雨量/
こううん /幸運/好運/耕耘/
こううんき /耕運機/耕耘機/
こううんじ /幸運児/
こううんりゅうすい /行雲流水/
こうえい /光栄/公営/後衛/後裔/
こうえいへい /紅衛兵/
こうえき /交易/公益/公役/
こうえきしちや /公益質屋/
こうえきしんたく /公益信託/
こうえきじぎょう /公益事業/
こうえきじょうけん /交易条件/
こうえきほうじん /公益法人/
こうえつ /校閲/
こうえつぼん /光悦本/
こうえん /講演/公園/公演/後援/好演/口演/高遠/香煙/
こうえんききゅう /好塩基球/
こうお /好悪/
こうおう /康応/
こうおつ /甲乙/
こうおん /高温/恒温/構音/高音/厚恩/高恩/
こうおんそう /恒温槽/
こうおんどうぶつ /恒温動物/
こうか /効果/高架/高価/降下/工科/硬貨/硬化/考課/校歌/黄禍/功科/公課/降嫁/膠化/
こうかい /公開/後悔/航海/更改/黄海/公海/紅海/狡獪/高階/
こうかいぎ /公会議/
こうかいこうざ /公開講座/
こうかいし /航海士/
こうかいじょう /公開状/
こうかいどう /公会堂/
こうかいにっし /航海日誌/
こうかがく /光化学/
こうかき /効果器/
こうかきょう /高架橋/
こうかく /降格/広角/甲殻/口角/交角/後覚/
こうかくさいぼう /厚角細胞/
こうかくそしき /厚角組織/
こうかくほう /高角砲/
こうかくるい /甲殻類/
こうかせん /高架線/
こうかつ /狡猾/広闊/
こうかてき /効果的/
こうかひょう /考課表/
こうかぶたい /降下部隊/
こうかん /交換/好感/交歓/鋼管/高官/公刊/公館/好漢/巷間/向寒/後患/校勘/
こうかんがくせい /交換学生/
こうかんき /交換機/
こうかんきょく /交換局/
こうかんしゅ /交換手/
こうかんしんけい /交感神経/
こうかんじょ /交換所/
こうかんじょうけん /交換条件/
こうかんだい /交換台/
こうかんぶんごう /交換分合/
こうかんほうそく /交換法則/
こうが /甲賀/黄河/高雅/光画/江河/
こうがい /口外/梗概/公害/郊外/口蓋/校外/構外/慷慨/笄/鉱害/
こうがいおん /口蓋音/
こうがいでんしゃ /郊外電車/
こうがいびょう /公害病/
こうがく /工学/後学/光学/高額/向学/溝壑/好学/
こうがくけい /光学系/
こうがくしん /向学心/
こうがん /睾丸/紅顔/厚顔/
こうがんざい /抗癌剤/
こうき /後期/後記/高貴/好奇/好機/広軌/香気/光輝/公器/校規/綱紀/降旗/校旗/康煕/弘毅/好期/皇紀/校紀/
こうきあつ /高気圧/
こうきかい /好機会/
こうきぎょう /公企業/
こうきしゅくせい /綱紀粛正/
こうきしん /好奇心/
こうきじてん /康煕字典/
こうきとじ /康煕綴じ/
こうきゅう /高級/恒久/講究/高給/公休/硬球/考究/後宮/降給/光球/攻究/購求/
こうきゅうげんご /高級言語/
こうきゅうび /公休日/
こうきょ /皇居/薨去/溝渠/
こうきょう /交響/公共/好況/広狭/口供/鋼橋/荒凶/高教/
こうきょういく /公教育/
こうきょうかい /公教会/
こうきょうがく /交響楽/
こうきょうがくだん /交響楽団/
こうきょうきょく /交響曲/
こうきょうくみあい /公共組合/
こうきょうざい /公共財/
こうきょうし /交響詩/
こうきょうしん /公共心/
こうきょうじぎょう /公共事業/
こうきょうせい /公共性/
こうきょうだんたい /公共団体/
こうきょうとうし /公共投資/
こうきょうのふくし /公共の福祉/
こうきょうほうそう /公共放送/
こうきん /公金/拘禁/行金/
こうきんじょう /拘禁場/
こうきんせい /抗菌性/
こうぎ /抗議/講義/広義/高誼/厚誼/好誼/公儀/公議/巧技/交誼/
こうぎょう /工業/興業/鉱業/興行/功業/
こうぎょうかがく /工業化学/
こうぎょうきかく /工業規格/
こうぎょうけん /鉱業権/
こうぎょうざいだん /鉱業財団/
こうぎょうだんち /工業団地/
こうぎょうちたい /工業地帯/
こうぎょく /紅玉/硬玉/鋼玉/
こうぎょくしゃ /攻玉社/
こうぎろく /講義録/
こうぎん /興銀/
こうく /工区/鉱区/
こうくう /航空/口腔/高空/
こうくうかんせい /航空管制/
こうくうき /航空機/
こうくうしゃしん /航空写真/
こうくうじえいたい /航空自衛隊/
こうくうびん /航空便/
こうくうぼかん /航空母艦/
こうくうゆうびん /航空郵便/
こうくうゆそう /航空輸送/
こうくうろ /航空路/
こうくぜい /鉱区税/
こうくつ /後屈/
こうくり /高句麗/高勾麗/
こうくん /校訓/
こうぐ /工具/香具/校具/耕具/
こうぐう /厚遇/皇宮/
こうぐん /皇軍/行軍/
こうけい /光景/後継/口径/皇兄/肯綮/黄経/後景/
こうけいき /好景気/
こうけっせい /抗血清/
こうけっとう /高血糖/
こうけつ /高潔/硬結/膏血/
こうけん /貢献/後見/後件/公権/高見/効験/
こうけんにん /後見人/
こうけんりょく /公権力/
こうげ /高下/
こうげい /工芸/
こうげいひん /工芸品/
こうげき /攻撃/
こうげん /公言/高原/光源/巧言/広言/抗原/荒原/抗言/高言/
こうげんがく /考現学/
こうげんせんい /膠原線維/
こうげんびょう /膠原病/
こうげんれいしょく /巧言令色/
こうこ /公庫/江湖/後顧/
こうこう /高校/孝行/航行/口腔/膏肓/後攻/交媾/煌々/耿々/硬鋼/後考/港口/硬膏/
こうこうがい /硬口蓋/
こうこうさ /光行差/
こうこうせい /向光性/
こうこうや /好好爺/
こうこがく /考古学/
こうこく /広告/皇国/公告/公国/興国/侯国/抗告/鴻鵠/
こうこくばいたい /広告媒体/
こうこくや /広告屋/
こうこつ /恍惚/硬骨/
こうこつかん /硬骨漢/
こうこん /後根/
こうご /交互/口語/庚午/向後/
こうごう /皇后/媾合/咬合/校合/
こうごうせい /光合成/
こうごき /小動き/
こうごけいさん /交互計算/
こうごたい /口語体/
こうごぶん /口語文/
こうごほう /口語法;口語文法/
こうさ /交差/交叉/考査/較差/公差/黄砂/
こうさい /高裁/交際/公債/虹彩/光彩/口才/
こうさいか /交際家/
こうさいしょうしょ /公債証書/
こうさいひ /交際費/
こうさいりくり /光彩陸離/
こうさく /交錯/耕作/工作/鋼索/
こうさくきかい /工作機械/
こうさくせん /工作船/
こうさくてつどう /鋼索鉄道/
こうさくぶつ /工作物/
こうさつ /考察/高察/絞殺/高札/
こうさてん /交差点/交叉点/
こうさん /公算/鉱産/降参/恒産/
こうさんきゅう /好酸球/
こうさんきん /抗酸菌/
こうさんぜい /鉱産税/
こうざ /口座/講座/高座/
こうざい /鋼材/功罪/
こうざいしっそく /高材疾足/
こうざいりょう /好材料/
こうざつ /交雑/
こうざん /鉱山/高山/江山/
こうざんしょくぶつ /高山植物/
こうざんじ /高山寺/
こうざんたい /高山帯/
こうざんびょう /高山病/
こうし /講師/格子/公私/行使/光子/公使/公司/厚志/甲子/子牛/孝子/嚆矢/犢/郊祀/後肢/考試/皇子/皇嗣/公子/後嗣/紅紫/高士/黄紙/皓歯/
こうしいん /考試院/
こうしえん /甲子園/
こうしかん /公使館/
こうしき /公式/硬式/
こうしきせん /公式戦/
こうしせい /高姿勢/
こうしそうにく /行尸走肉/
こうしつ /皇室/硬質/後室/膠質/
こうしつざいさん /皇室財産/
こうしつてんぱん /皇室典範/
こうしていすう /格子定数/
こうしてん /格子点/
こうしど /格子戸/
こうしゃ /後者/校舎/公社/降車/公舎/後車/巧者/
こうしゃく /侯爵/公爵/講釈/
こうしゃくし /講釈師/
こうしゃぐち /降車口/
こうしゃさい /公社債/
こうしゃほう /高射砲/
こうしゅ /攻守/好手/絞首/公主/好守/校主/甲種/工手/巧手/
こうしゅう /講習/公衆/口臭/広州/甲州/杭州/
こうしゅうえいせい /公衆衛生/
こうしゅうかい /講習会/
こうしゅうかいどう /甲州街道/
こうしゅうじょ /講習所/
こうしゅうせい /光周性/
こうしゅうでんわ /公衆電話/
こうしゅうどうとく /公衆道徳/
こうしゅうは /高周波/
こうしゅうべんじょ /公衆便所/
こうしゅうわん /杭州湾/
こうしゅく /拘縮/
こうしゅだい /絞首台/
こうしょ /高所/向暑/公署/校書/高書/講書/購書/
こうしょう /交渉/公称/高尚/公証/校章/考証/鉱床/好尚/公傷/口誦/公娼/口承/工匠/工廠/哄笑/厚相/行賞/工商/高唱/咬傷/康正/
こうしょうにん /公証人/
こうしょく /更埴/交織/公職/好色/紅色/降職/黄色/
こうしょくついほう /公職追放/
こうしょくぼん /好色本/
こうしん /更新/交信/行進/後進/口唇/高進/庚申/後身/昂進/亢進/功臣/孝心/恒心/紅唇/
こうしんきょく /行進曲/
こうしんくう /高真空/
こうしんこく /後進国/
こうしんじょ /興信所/
こうしんせい /更新世/
こうしんづか /庚申塚/
こうしんりょう /香辛料/
こうしんりょく /向心力/
こうしんろく /興信録/
こうじ /麹/工事/高次/公示/小路/糀/康治/柑子/好餌/鉤餌/好事/弘治/公事/後事/
こうじいろ /柑子色/
こうじきん /麹菌/
こうじく /光軸/
こうじさいこく /公示催告/
こうじそうたつ /公示送達/
こうじつ /口実/好日/
こうじつせい /向日性/
こうじつびきゅう /曠日弥久/
こうじまち /麹町/
こうじゅ /口授/坑儒/
こうじゅく /黄熟/
こうじゅつ /後述/口述/講述/
こうじゅつしけん /口述試験/
こうじゅつにん /公述人/
こうじゅつひっき /口述筆記/
こうじゅん /降順/公準/孝順/
こうじょ /控除/公序/孝女/後序/皇女/
こうじょう /向上/工場/口上/甲状/恒常/厚情/荒城/交情/攻城/
こうじょうざいだん /工場財団/
こうじょうしょ /口上書/
こうじょうせん /甲状腺/
こうじょりょうぞく /公序良俗/
こうじん /工人/後塵/幸甚/荒神/後陣/黄塵/公人/紅塵/行人/後人/
こうじんばんじょう /黄塵万丈/
こうじんぶつ /好人物/
こうすい /香水/硬水/降水/交綏/鉱水/
こうすいい /高水位/
こうすいりょう /降水量/
こうすう /口数/恒数/工数/
こうず /構図/高津/公図/好事/
こうずい /洪水/
こうずか /好事家/
こうずけ /上野/
こうせい /構成/更生/校正/後世/厚生/恒星/攻勢/公正/較正/後生/向性/更正/硬性/高声/江西/江青/好晴/甦生/
こうせいかいしゃ /更生会社/
こうせいけい /恒星系/
こうせいけいかく /更生計画/
こうせいけってい /更正決定/
こうせいさいけん /更生債権/
こうせいしゅぎ /構成主義/
こうせいしょうしょ /公正証書/
こうせいずり /校正刷/
こうせいたんぽけん /更生担保権/
こうせいだいじん /厚生大臣/
こうせいとうき /更正登記/
こうせいねんきん /厚生年金/
こうせいぶっしつ /抗生物質/
こうせいようけん /構成要件/
こうせき /功績/洪積/鉱石/口跡/航跡/
こうせきうん /高積雲/
こうせきせい /洪積世/
こうせきそう /洪積層/
こうせつ /巧拙/降雪/公設/高説/交接/巷説/講説/
こうせつりょう /降雪量/
こうせん /光線/交戦/鉱泉/口銭/交線/公選/好戦/抗戦/高専/工専/工船/工銭/黄泉/
こうせんけん /交戦権/
こうせんこく /交戦国/
こうぜい /行成/
こうぜいびょうし /行成表紙/
こうぜつ /口舌/
こうぜん /公然/昂然/紅髯/
こうそ /酵素/公訴/控訴/皇祖/公租/高祖/
こうそう /構想/高層/抗争/後送/降霜/好走/高僧/皇宗/航送/香草/公葬/高燥/
こうそううん /高層雲/
こうそうてんきず /高層天気図/
こうそきかん /控訴期間/
こうそききゃく /公訴棄却/控訴棄却/
こうそく /高速/拘束/梗塞/校則/光束/高足/
こうそくか /高速化/
こうそくど /光速度/高速度/
こうそくどうろ /高速道路/
こうそくりょく /拘束力/
こうそさいばんしょ /控訴裁判所/
こうそしゅいしょ /控訴趣意書/
こうそしん /控訴審/
こうそじこう /公訴時効/
こうそじじつ /公訴事実/
こうそつ /高卒/
こうそにん /控訴人/
こうそふ /高祖父/
こうそぼ /高祖母/
こうそん /皇孫/
こうぞ /楮/
こうぞう /構造/
こうぞうしき /構造式/
こうぞうしゅぎ /構造主義/
こうぞうせん /構造線/
こうぞうたい /構造体/
こうぞがみ /楮紙/
こうぞく /後続/皇族/
こうぞくきょり /航続距離/
こうぞくひ /皇族費/
こうた /小唄/小歌/
こうたい /交代/後退/交替/抗体/
こうたいごう /皇太后/
こうたいし /皇太子/
こうたいしひ /皇太子妃/
こうたいそん /皇太孫/
こうたいよく /後退翼/
こうたく /光沢/
こうたくし /光沢紙/
こうたくみん /江沢民/
こうたつ /公達/
こうたん /後端/降誕/荒誕/
こうたんさい /降誕祭/
こうだ /幸田/好打/
こうだい /広大/後代/
こうだいじ /高台寺/
こうだいむへん /広大無辺/
こうだか /甲高/
こうだく /黄濁/
こうだん /講談/公団/講壇/後段/高段/降壇/巷談/光弾/高談/
こうだんし /講談師/好男子/
こうち /高知/公知/高地/後置/巧遅/巧緻/拘置/耕地/狡知/狡智/河内/
こうちく /構築/
こうちけん /高知県/
こうちし /高知市/後置詞/
こうちしょ /拘置所/
こうちせい /向地性/
こうちせいり /耕地整理/
こうちゃ /紅茶/
こうちゃく /降着/膠着/
こうちゃくご /膠着語/
こうちやま /河内山/
こうちゅう /甲虫/校注/口中/
こうちゅうきゅう /好中球/
こうちょ /光緒/高著/
こうちょう /好調/校長/高調/紅潮/腔腸/高潮/弘長/高張/硬調/
こうちょうかい /公聴会/
こうちょうどうぶつ /腔腸動物/
こうちょうは /高調波/
こうちょうりょく /抗張力/
こうちょく /硬直/
こうちん /工賃/
こうつう /交通/
こうつうきかん /交通機関/
こうつうじこ /交通事故/
こうつうひ /交通費/
こうつうもう /交通網/
こうつごう /好都合/
こうづ /高津/
こうてい /肯定/工程/高低/皇帝/行程/校庭/公定/公邸/校訂/皇弟/高弟/黄帝/航程/公廷/考訂/更訂/校定/
こうていかかく /公定価格/
こうていかんり /工程管理/
こうていひょう /工程表/
こうていぶあい /公定歩合/
こうてき /公的/好適/
こうてきしゅ /好敵手/
こうてきねんきん /公的年金/
こうてきふじょ /公的扶助/
こうてつ /鋼鉄/更迭/
こうてん /交点/好転/後天/公転/荒天/好天/高点/
こうてんてき /後天的/
こうでい /拘泥/膠泥/
こうでん /香典/香奠/公電/
こうでんかん /光電管/
こうでんこうか /光電効果/
こうでんし /光電子/
こうでんち /光電池/
こうとう /口頭/高等/後頭/口答/高騰/喉頭/江東/公党/降等/好投/高踏/
こうとうか /高等科/
こうとうかん /高等官/
こうとうがっこう /高等学校/
こうとうきょういく /高等教育/
こうとうけいさつ /高等警察/
こうとうしき /恒等式/
こうとうしもん /口頭試問/
こうとうしょくぶつ /高等植物/
こうとうどうぶつ /高等動物/
こうとうふ /皇統譜/
こうとうぶ /後頭部/
こうとうべんろん /口頭弁論/
こうとうむけい /荒唐無稽/
こうとうよう /後頭葉/
こうとく /公徳/孝徳/幸徳/高徳/
こうとくしん /公徳心/
こうとりい /公取委/
こうど /高度/光度/硬度/耕土/黄土/荒土/
こうどう /行動/講堂/公道/坑道/黄道/皇道/香道/孝道/
こうどうかがく /行動科学/
こうどうかん /講道館/
こうどうきちにち /黄道吉日/
こうどうしゅぎ /行動主義/
こうどうしんりがく /行動心理学/
こうどうたい /黄道帯/
こうどうは /皇道派/
こうどうはんけい /行動半径/
こうどく /講読/購読/鉱毒/
こうどくそ /抗毒素/
こうどけい /高度計/
こうどせいちょう /高度成長/
こうない /校内/構内/港内/坑内/口内/
こうないえん /口内炎/
こうなん /江南/硬軟/後難/
こうにち /抗日/
こうにゅう /購入/
こうにん /後任/公認/降任/
こうにんかいけいし /公認会計士/
こうねつ /高熱/
こうねつひ /光熱費/
こうねん /後年/光年/高年/行年/
こうねんき /更年期/
こうの /河野/幸野/
こうのいけ /鴻池/
こうのう /効能/後納/
こうのうがき /効能書き/
こうのす /鴻巣/
こうのだい /国府台/
こうのとり /鸛/
こうのもの /香の物/
こうのもろなお /高師直/
こうは /硬派/光波/
こうはい /後輩/荒廃/交配/高配/興廃/後背/降灰/光背/好配/向背/
こうはいきん /広背筋/
こうはいち /後背地/
こうはく /紅白/厚薄/黄白/工博/
こうはくじあい /紅白試合/
こうはつ /後発/
こうはん /後半/広汎/広範/公判/孔版/鋼板/甲板/紅斑/
こうはんい /広範囲/
こうはんき /後半期/
こうはんきじつ /公判期日/
こうはんじゅんび /公判準備/
こうはんせい /後半生/
こうはんちょうしょ /公判調書/
こうはんてい /公判廷/
こうば /工場/
こうばい /購買/勾配/公売/紅梅/
こうばいいろ /紅梅色/
こうばいすう /公倍数/
こうばいぶ /購買部/
こうばいりょく /購買力/
こうばく /宏漠/広漠/
こうばこ /香箱/
こうばん /交番/降板/
こうひ /公費/公比/工費/口碑/公妃/后妃/高庇/高批/
こうひつ /硬筆/
こうひょう /公表/好評/講評/公評/高評/
こうひょうき /後氷期/
こうひん /公賓/
こうび /後尾/交尾/後備/
こうびん /後便/幸便/
こうふ /甲府/交付/公布/坑夫/工夫/鉱夫/
こうふう /校風/
こうふうせいげつ /光風霽月/
こうふきん /交付金/
こうふく /幸福/降伏/降服/
こうふくじ /興福寺/
こうふくまく /後腹膜/
こうふし /甲府市/
こうふぼんち /甲府盆地/
こうふん /興奮/公憤/口吻/昂奮/亢奮/紅粉/
こうふんざい /興奮剤/
こうぶ /後部/公武/
こうぶつ /好物/鉱物/
こうぶん /構文/公文/
こうぶんし /高分子/
こうぶんしかがく /高分子化学/
こうぶんしょ /公文書/
こうぶんぼ /公分母/
こうぶんろん /構文論/
こうへい /公平/康平/工兵/衡平/
こうへいいいんかい /公平委員会/
こうへいほう /衡平法/
こうへいむし /公平無私/
こうへき /厚壁/
こうへきさいぼう /厚壁細胞/
こうへきそしき /厚壁組織/
こうへん /後編/後篇/口辺/
こうへんさいぼう /孔辺細胞/
こうべ /神戸/頭/首/
こうべし /神戸市/
こうべじょがくいん /神戸女学院/
こうべだいがく /神戸大学/
こうべん /抗弁/口弁/
こうべんけん /抗弁権/
こうほ /候補/黄埔/
こうほう /広報/後方/工法/公報/航法/高峰/公法/構法/後報/
こうほうじん /公法人/
こうほく /江北/
こうほしゃ /候補者/
こうほせい /候補生/
こうほん /校本/稿本/広本/
こうぼ /公募/酵母/
こうぼう /攻防/興亡/工房/光芒/弘法/
こうぼうだいし /弘法大師/
こうぼきん /酵母菌/
こうぼく /公僕/高木/香木/坑木/
こうぼくしかい /槁木死灰/
こうま /子馬/
こうまい /高邁/
こうまん /高慢/
こうみ /香味/小海/
こうみゃく /鉱脈/
こうみょう /巧妙/功名/光明/高名/
こうみょうしん /功名心/
こうみょうじ /光明寺/
こうみん /公民/
こうみんかん /公民館/
こうみんけん /公民権/
こうむ /公務/工務/校務/
こうむいん /公務員/
こうむしょ /公務所/
こうめ /小梅/
こうめい /高名/公明/光明/
こうめいせいだい /公明正大/
こうめいせんきょ /公明選挙/
こうめいとう /公明党/
こうめん /後面/
こうもう /孔孟/紅毛/鴻毛/
こうもうへきがん /紅毛碧眼/
こうもく /項目/綱目/
こうもくてん /広目天/
こうもり /蝙蝠/
こうもりがさ /蝙蝠傘/
こうもん /肛門/校門/後門/閘門/黄門/
こうや /荒野/広野/高野/曠野/紺屋/
こうやがみ /高野紙/
こうやく /公約/口約/膏薬/
こうやくすう /公約数/
こうやぐち /高野口/
こうやさん /高野山/
こうやどうふ /高野豆腐/
こうやばん /高野版/
こうゆ /香油/膏油/鉱油/
こうゆう /交友/公有/交遊/孔融/校友/
こうゆうざいさん /公有財産/
こうゆうすいめん /公有水面/
こうよう /紅葉/効用/高揚/公用/後葉/広葉/昂揚/綱要/黄葉/衡陽/
こうようご /公用語/
こうようじゅ /広葉樹/
こうようじゅりん /硬葉樹林/
こうようにん /公用人/
こうようぶん /公用文/
こうら /甲羅/
こうらい /高麗/光来/後来/
こうらいしば /高麗芝/
こうらく /行楽/攻落/後楽/
こうらくえん /後楽園/
こうらん /高覧/攪乱/鉤欄/紅蘭/高欄/
こうらんけい /広卵形/
こうり /公理/功利/高利/小売/公吏/行李/
こうりがし /高利貸/
こうりけい /公理系/
こうりしゅぎ /功利主義/
こうりつ /効率/公立/高率/工率/
こうりつがっこう /公立学校/
こうりつてき /効率的/
こうりてきほうほう /公理的方法/
こうりゃく /後略/攻略/
こうりゅう /交流/興隆/拘留/勾留/幸流/
こうりゅうじ /広隆寺/
こうりゅうじょう /勾留状/
こうりょ /考慮/行旅/
こうりょう /荒涼/稿料/衡量/香料/校了/綱領/荒寥/公領/考量/
こうりょく /効力/抗力/
こうりょしぼうにん /行旅死亡人/
こうりん /光臨/降臨/光輪/
こうるい /紅涙/
こうれい /恒例/好例/高齢/交霊/
こうれいかしゃかい /高齢化社会/
こうれつ /後列/
こうろ /航路/高炉/行路/香炉/公路/
こうろう /功労/高楼/
こうろうい /公労委/
こうろうむ /紅楼夢/
こうろく /高禄/
こうろぜん /黄櫨染/
こうろひょうしき /航路標識/
こうろん /口論/公論/高論/硬論/抗論/
こうろんおつばく /甲論乙駁/
こうわ /講話/講和/高話/弘和/
こうわじょうやく /講和条約/
こうわほう /口話法/
こうわん /港湾/
こえ /声/肥/
こえい /孤影/
こえがかり /声掛り/
こえがわり /声変り/
こえだ /小枝/
こおう /呼応/
こおうこんらい /古往今来/
こおとこ /小男/
こおどり /小躍り/
こおもて /小面/
こおり /氷/郡/
こおりがし /氷菓子/
こおりざとう /氷砂糖/
こおりづめ /氷詰め/
こおりまくら /氷枕/
こおりみず /氷水/
こおりやま /郡山/
こおろぎ /蟋蟀/
こか /古歌/
こかく /顧客/
こかげ /木陰/
こかじ /小鍛冶/
こかた /子方/
こかつ /枯渇/涸渇/
こかつじぼん /古活字本/
こかぶ /子株/
こかん /股間/
こかんせつ /股関節/
こかんぼん /古刊本/
こが /古賀/古河/古雅/古画/個我/
こがい /戸外/子飼い/
こがいしゃ /子会社/
こがき /小書/
こがく /古楽/古学/
こがくれ /木隠れ/
こがた /小型/小形/
こがたな /小刀/
こがね /黄金/小金/
こがねい /小金井/
こがねいろ /黄金色/
こがまさお /古賀政男/
こがら /小柄/
こがらし /木枯し/凩/
こがれじに /焦れ死に/
こがわせ /小為替/
こがん /湖岸/
こき /古希/呼気/古稀/古記/
こきいろ /濃色/
こきざみ /小刻み/
こきみ /小気味/
こきゃく /顧客/
こきゅう /呼吸/胡弓/故旧/故宮/
こきゅうおん /呼吸音/
こきゅうき /呼吸器/
こきゅうこん /呼吸根/
こきゅうこんなん /呼吸困難/
こきょう /故郷/古経/
こきろく /古記録/
こきん /古今/
こきんしゅう /古今集/
こきんわかしゅう /古今和歌集/
こぎ /小木/古義/狐疑/
こぎがく /古義学/
こぎしゅんじゅん /狐疑逡巡/
こぎって /小切手/
こぎて /漕ぎ手/
こぎれ /小切れ/
こぎれい /小綺麗/
こく /国/黒/鵠/酷/穀/告/刻/克/石/谷/哭/斛/轂/古句/
こくあく /酷悪/
こくい /国威/黒衣/
こくいっこく /刻一刻/
こくいん /刻印/黒印/
こくいんじょう /黒印状/
こくう /穀雨/虚空/
こくうん /国運/黒雲/
こくえい /国営/
こくえき /国益/
こくえん /黒鉛/黒煙/
こくおう /国王/
こくおん /国恩/
こくが /国衙/
こくがい /国外/
こくがいはん /国外犯/
こくがく /国学/
こくがくいん /国学院/
こくがくしゃ /国学者/
こくぎ /国技/国議/
こくぎかん /国技館/
こくぐう /酷遇/
こくぐら /穀倉/
こくぐん /国軍/
こくげき /国劇/
こくげん /刻限/
こくこく /刻々/刻刻/
こくご /国語/
こくごう /国号/
こくごか /国語科/
こくごがく /国語学/
こくごきょういく /国語教育/
こくごしんぎかい /国語審議会/
こくごじてん /国語辞典/
こくさい /国際/国債/
こくさいか /国際化/
こくさいかいぎ /国際会議/
こくさいくうこう /国際空港/
こくさいこうほう /国際公法;国際法/
こくさいご /国際語/
こくさいしほう /国際私法/
こくさいしゅうし /国際収支/
こくさいしょうけん /国債証券/
こくさいしょく /国際色/
こくさいじょうやく /国際条約/
こくさいたんいけい /国際単位系;systeme international d'unites,SI/
こくさいだいがく /国際大学/
こくさいつうしん /国際通信/
こくさいてがた /国際手形/
こくさいてき /国際的/
こくさいでんわ /国際電話/
こくさいふんそう /国際紛争/
こくさいほう /国際法/
こくさいほうそう /国際放送/
こくさいれんごう /国際連合/
こくさいれんめい /国際連盟/
こくさく /国策/
こくさん /国産/
こくし /酷使/国士/国史/国司/国使/国師/
こくしかん /国子監/
こくしびょう /黒死病/
こくしむそう /国士無双/
こくしゅ /国主/国守/
こくしょ /国書/酷暑/国初/
こくしょく /黒色/穀食/
こくしょくしゅ /黒色腫/
こくじ /告示/酷似/国事/国字/国璽/告辞/刻字/
こくじこうい /国事行為/
こくじしょうしょ /国璽尚書/
こくじはん /国事犯/
こくじぼん /国字本/
こくじょう /国情/
こくじょく /国辱/
こくじん /黒人/国人/
こくすい /国粋/
こくせい /国政/国勢/
こくせいちょうさ /国勢調査/
こくせき /国籍/刻石/
こくせん /国選/
こくせんべんごにん /国選弁護人/
こくせんや /国姓爺/
こくぜ /国是/
こくぜい /国税/酷税/
こくぜいちょう /国税庁/
こくそ /告訴/
こくそう /穀倉/国葬/国喪/
こくそじょう /告訴状/
こくぞく /国賊/
こくたい /国体/
こくたいほうしゃ /黒体放射/
こくたん /黒檀/黒炭/
こくだか /石高/
こくち /告知/
こくちぎむ /告知義務/
こくちょう /国鳥/
こくてい /国定/
こくていこうえん /国定公園/
こくてつ /国鉄/
こくてん /黒点/国典/
こくでん /国電/
こくと /国都/
こくど /国土/黒土/黒奴/
こくどう /国道/
こくどけいかく /国土計画/
こくどちりいん /国土地理院/
こくない /国内/
こくないしじょう /国内市場/
こくないしょう /黒内障/
こくないほう /国内法/
こくなん /国難/
こくねつ /酷熱/
こくはく /告白/酷薄/
こくはつ /告発/
こくばん /黒板/
こくひ /国費/
こくひょう /酷評/
こくひん /国賓/
こくび /小首/
こくびゃく /黒白/
こくふ /国府/国父/国富/
こくふう /国風/
こくふく /克服/
こくふろん /国富論/
こくぶ /国分/国府/
こくぶん /国文/告文/
こくぶんがく /国文学/
こくぶんじ /国分寺/
こくぶんぽう /国文法/
こくべつ /告別/
こくべつしき /告別式/
こくほう /国宝/国法/
こくほん /刻本/
こくぼ /国母/
こくぼう /国防/
こくぼうしょく /国防色/
こくみん /国民/
こくみんかいへい /国民皆兵/
こくみんがくは /国民楽派/
こくみんぎかい /国民議会/
こくみんぐん /国民軍/
こくみんけいざい /国民経済/
こくみんしゅくしゃ /国民宿舎/
こくみんしょとく /国民所得/
こくみんしんさ /国民審査/
こくみんせい /国民性/
こくみんせいふ /国民政府/
こくみんてき /国民的/
こくみんとう /国民党/
こくみんとうひょう /国民投票/
こくみんねんきん /国民年金/
こくむ /国務/
こくむいん /国務院/
こくむしょう /国務省/国務相/
こくむだいじん /国務大臣/
こくめい /克明/国名/刻銘/
こくもつ /穀物/
こくやく /国訳/
こくゆ /告諭/
こくゆう /国有/
こくゆうざいさん /国有財産/
こくゆうりん /国有林/
こくようせき /黒曜石/
こくら /小倉/
こくり /国利/
こくりつ /国立/
こくりつげきじょう /国立劇場/
こくりつこうえん /国立公園/
こくりつだいがく /国立大学/
こくりみんぷく /国利民福/
こくりょう /国領/
こくりょく /国力/
こくるい /穀類/
こくれつ /酷烈/
こくれん /国連/
こくれんき /国連旗/
こくれんぐん /国連軍/
こくれんけんしょう /国連憲章/
こくろん /国論/
こくん /古訓/
こぐし /小串/
こぐち /小口/木口/
こぐちあつかい /小口扱い/
こぐちがき /小口書/
こぐちぼり /木口彫/
こぐちもくはん /木口木版/
こぐま /小熊/子熊/
こぐん /孤軍/
こぐんふんとう /孤軍奮闘/
こけ /苔/
こけい /固形/孤閨/
こけいさんしょう /虎渓三笑/
こけいぶつ /固形物/
こけいろ /苔色/
こけしょくぶつ /苔植物/
こけつ /虎穴/固結/
こけでら /苔寺/
こけもも /苔桃/
こけら /柿/
こけらおとし /柿落し/
こけん /估券/沽券/
こげ /焦げ/
こげちゃ /焦茶/
こげつ /湖月/
こげめ /焦げ目/
ここ /個々/此処/個個/
ここう /孤高/餬口/股肱/糊口/戸口/虎口/
ここく /故国/
ここじん /個々人/個個人/
ここち /心地/
ここの /九/
ここのえ /九重/
ここのか /九日/
ここのつ /九つ/
ここまい /古々米/
こころ /心/
こころあたり /心当り/
こころあて /心当て/
こころいき /心意気/
こころいれ /心入れ/
こころいわい /心祝い/
こころえ /心得/
こころえがお /心得顔/
こころえちがい /心得違い/
こころおくれ /心後れ/
こころおち /心落ち/
こころおぼえ /心覚え/
こころから /心から/
こころがけ /心掛け/
こころがまえ /心構え/
こころがわり /心変り/
こころくばり /心配り/
こころぐみ /心組み/
こころざし /志/
こころざま /心様/
こころぞえ /心添え/
こころだのみ /心頼み/
こころづかい /心遣い/
こころづくし /心尽し/
こころづけ /心付け/
こころづもり /心積り/
こころづよ /心強/
こころな /心無/
こころね /心根/
こころのこり /心残り/
こころばせ /心馳せ/
こころまかせ /心任せ/
こころまち /心待ち/
こころみ /試み/
こころもち /心持/
こころやり /心遣り/
こころゆ /心ゆ/
ここん /古今/
ここんとうざい /古今東西/
ここんどっぽ /古今独歩/
ここんむそう /古今無双/
こご /古語/
こごう /古豪/呼号/
こごえ /小声/
こごし /小腰/
こごと /小言/
こさい /湖西/小才/
こさかこうざん /小坂鉱山/
こさく /小作/古作/
こさくち /小作地/
こさくにん /小作人/
こさくのう /小作農/
こさくりょう /小作料/
こさじ /小匙/
こさつ /古刹/故殺/
こさめ /小雨/
こさん /古参/
こざいく /小細工/
こざかな /小魚/
こざき /小崎/
こざくら /小桜/
こざさ /小笹/
こざさはら /小笹原/
こざら /小皿/
こざん /故山/
こし /腰/虎視/枯死/輿/古紙/古史/越/
こしあて /腰当/
こしあん /漉餡/
こしいれ /輿入れ/
こしお /小潮/
こしかけ /腰掛/
こしかた /来し方/
こしがや /越谷/
こしき /甑/古式/轂/
こしぎんちゃく /腰巾着/
こしくだけ /腰砕け/
こしぐるま /腰車/
こしごえ /腰越/
こしじ /越路/
こしたんたん /虎視眈々/虎視眈眈/
こしだか /腰高/
こしつ /個室/固執/痼疾/鼓室/
こしなげ /腰投げ/
こしぬけ /腰抜け/
こしのぎ /小鎬/
こしば /小柴/
こしばい /小芝居/
こしひも /腰紐/
こしぼそ /腰細/
こしぼね /腰骨/
こしまき /腰巻/
こしみの /腰蓑/
こしもと /腰元/
こしゃきょう /古写経/
こしゃく /小癪/
こしゃほん /古写本/
こしゅ /固守/戸主/古酒/鼓手/
こしゅう /固執/呼集/孤舟/故習/
こしゅけん /戸主権/
こしょ /古書/
こしょう /故障/湖沼/呼称/胡椒/小姓/小性/壺觴/古称/誇称/
こしょうがつ /小正月/
こしょうにん /小商人/
こしょく /古色/
こしょくそうぜん /古色蒼然/
こしよわ /腰弱/
こしらえ /拵え/
こしらえごと /拵え事/
こしわざ /腰技/
こしん /湖心/
こじ /誇示/故事/孤児/古寺/固持/固辞/古字/居士/
こじいん /孤児院/
こじき /乞食/古事記/
こじつ /故実/
こじま /小島/児島/古島/
こじまわん /児島湾/
こじゅう /扈従/
こじゅうと /小姑/小舅/
こじゅうとめ /小姑/
こじょう /古城/湖上/弧状/
こじょうらくじつ /孤城落日/
こじょうるり /古浄瑠璃/
こじらいれき /故事来歴/
こじり /鐺/
こじれ /拗れ/
こじん /個人/故人/古人/
こじんきょうぎ /個人競技/
こじんさ /個人差/
こじんしゅぎ /個人主義/
こじんてき /個人的/
こすい /湖水/鼓吹/
こすう /個数/戸数/
こすぎ /小杉/
こすげ /小菅/
こすみ /小角/
こずえ /梢/
こせ /巨勢/
こせい /個性/古生/
こせいせん /湖西線/
こせいだい /古生代/
こせいてき /個性的/
こせいぶつ /古生物/
こせがれ /小倅/
こせき /戸籍/小関/古跡/古関/
こせきしょうほん /戸籍抄本/
こせきとうほん /戸籍謄本/
こせつ /古拙/
こせん /古銭/弧線/
こせんきょう /跨線橋/
こせんじょう /古戦場/
こぜい /小勢/
こぜき /小関/
こぜつ /孤絶/
こぜに /小銭/
こぜりあい /小競り合い/
こそうねつ /枯草熱/
こそく /姑息/
こそだて /子育て/
こそで /小袖/
こそどろ /こそ泥/
こぞう /小僧/
こぞって /挙って/
こたい /固体/個体/固態/古体/
こたいぐん /個体群/
こたいはっせい /個体発生/
こたえ /答/堪え/
こたえられない /堪えられない/
こたか /小鷹/
こたつ /炬燵/
こたび /此度/
こたん /枯淡/
こだい /古代/誇大/
こだいこ /小太鼓/
こだいこうこく /誇大広告/
こだいむらさき /古代紫/
こだいもうそう /誇大妄想/
こだいら /小平/
こだから /子宝/
こだくさん /子沢山/
こだし /小出し/
こだち /木立/小太刀/
こだね /子種/
こだま /児玉/木霊/小玉/谺/
こち /故知/鯒/東風/故地/
こちず /古地図/
こちゃく /固着/
こちょう /誇張/蝴蝶/孤蝶/古調/鼓腸/胡蝶/
こちら /此方/
こちり /古地理/
こっか /国家/国歌/国花/刻下/骨化/
こっかい /国会/黒海/告解/
こっかいぎいん /国会議員/
こっかいぎじどう /国会議事堂/
こっかいとしょかん /国会図書館/
こっかきかん /国家機関/
こっかく /骨格/
こっかくきん /骨格筋/
こっかけんりょく /国家権力/
こっかこうむいん /国家公務員/
こっかしけん /国家試験/
こっかしゅぎ /国家主義/
こっかっしょく /黒褐色/
こっかばいしょう /国家賠償/
こっかほしょう /国家補償/
こっかん /酷寒/骨幹/
こっき /国旗/黒旗/克己/
こっきしん /克己心/
こっきふくれい /克己復礼/
こっきょう /国境/国教/
こっきょうがっさく /国共合作/
こっきん /国禁/
こっく /刻苦/
こっくん /国訓/
こっけい /滑稽/酷刑/
こっけいせつ /国慶節/
こっけいぼん /滑稽本/
こっけん /国権/黒鍵/国憲/
こっこ /国庫/
こっこう /国交/国光/
こっこく /刻々/
こっし /骨子/
こっせつ /骨折/
こっそう /骨相/
こっそうがく /骨相学/
こったん /骨炭/
こっち /此方/
こっちょう /骨頂/
こっとう /骨董/
こっとうひん /骨董品/
こっぱ /木っ端/
こっぱみじん /木端微塵/
こっぷん /骨粉/
こっぺん /骨片/
こっぽう /骨法/
こつ /骨/忽/笏/惚/
こつあげ /骨揚げ/
こつえん /忽焉/
こつがら /骨柄/
こつずい /骨髄/
こつずいいしょく /骨髄移植/
こつぜん /忽然/
こつそしょうしょう /骨粗鬆症/
こつづみ /小鼓/
こつにく /骨肉/
こつばん /骨盤/
こつひろい /骨拾い/
こつぶ /小粒/
こつまく /骨膜/
こつまくえん /骨膜炎/
こつみ /木積/
こづかい /小使/
こづかいせん /小遣銭/
こづくり /小作り/
こづち /小槌/
こづつみ /小包/
こづめ /小爪/
こづれ /子連れ/
こて /小手/鏝/籠手/
こてい /固定/湖底/
こていかんねん /固定観念/
こていきゅう /固定給/
こていしさんぜい /固定資産税/
こていしほん /固定資本/
こていひ /固定費/
こていひりつ /固定比率/
こていふさい /固定負債/
こてき /鼓笛/
こてきたい /鼓笛隊/
こてさき /小手先/
こてしらべ /小手調べ/
こてなげ /小手投げ/
こてん /古典/個展/古点/
こてんしゅぎ /古典主義/
こてんてき /古典的/
こてんりきがく /古典力学/
こでん /古伝/
こと /事/異/言/殊/琴/古都/糊塗/
ことあげ /言挙げ/
こといみ /言忌み/
ことう /孤島/古刀/
ことえり /言選り/
ことがら /事柄/
ことく /古徳/
ことこまか /事細か/
ことごと /事々/
ことごとく /悉く/尽く/
ことさら /殊更/
ことざ /琴座/
ことし /今年/
ことしろ /事代/
ことだま /言霊/
ことづけ /言付け/
こととい /言問/
ことに /殊に/
ことのは /言の葉/
ことのほか /殊の外/
ことば /言葉/詞/
ことばあそび /言葉遊び/
ことばかず /言葉数/
ことばがき /詞書/
ことばじち /言葉質/
ことばじり /言葉尻/
ことばづかい /言葉遣い/
ことばのあや /言葉の綾/
ことひら /琴平/
ことぶき /寿/
ことほどさように /事程左様に/
ことまき /異巻/
ことり /小鳥/
ことわけ /事訳/
ことわざ /諺/
ことわり /理/
ことわりがき /断り書き/
こど /弧度/
こどう /鼓動/古道/
こどうぐ /小道具/
こどく /孤独/
こどほう /弧度法;弧度(radian)で角度を図る方法/
こども /子供/
こどもかい /子供会/
こどもごころ /子供心/
こどもずき /子供好き/
こどもだまし /子供騙し/
こな /粉/小名/
こなから /二合半/
こなぐすり /粉薬/
こなごな /粉々/
こなし /小梨/
こなた /此方/
こなべ /小鍋/
こなまいき /小生意気/
こなみ /小波/
こなみじん /粉微塵/
こなや /粉屋/
こなゆき /粉雪/
こなわ /小縄/
こなん /湖南/
こにし /小西/
こにもつ /小荷物/
こにんずう /小人数/
こねこ /子猫/小猫/仔猫/
この /此の/斯の/
このあいだ /此の間/
このえ /近衛/
このえしだん /近衛師団/
このえへい /近衛兵/
このかた /此の方/
このしろ /鮗/
このせつ /此の節/
このたび /此の度/
このは /木の葉/
このほど /此の程/
このみ /好み/木の実/
このめ /木の芽/
このめどき /木の芽時/
このよ /此の世/
このわた /海鼠腸/
このんで /好んで/
こはぎ /小萩/
こはく /琥珀/
こはぜ /鞐/
こはば /小幅/
こはる /小春/
こはるびより /小春日和/
こはん /湖畔/古版/
こはんとき /小半時/
こはんにち /小半日/
こば /木場/
こばい /故買/
こばか /小馬鹿/
こばしり /小走り/
こばた /小旗/
こばち /小鉢/
こばな /小鼻/
こばなし /小話/
こばなれ /子離れ/
こばやかわ /小早川/
こばやかわたかかげ /小早川隆景/
こばやかわひであき /小早川秀秋/
こばやし /小林/
こばやしいっさ /小林一茶/
こばら /小腹/
こばり /小針/
こばん /小判/
こばんがた /小判形/
こばんざめ /小判鮫/
こひ /古碑/
こひしつ /古皮質/
こひつ /古筆/
こひつぎれ /古筆切/
こひつじ /子羊/小羊/
こひょう /小兵/
こび /媚/
こびき /木挽/
こびきちょう /木挽町/
こびちゃ /媚茶/
こびと /小人/
こびゃくしょう /小百姓/
こびら /小平/
こふ /誇負/
こふう /古風/
こふきいも /粉吹き芋/
こふくげきじょう /鼓腹撃壌/
こふん /古墳/
こぶ /鼓舞/瘤/昆布/
こぶくろ /小袋/
こぶし /拳/辛夷/小節/古武士/
こぶちざわ /小淵沢/
こぶちゃ /昆布茶/
こぶつ /古仏/古物/個物/
こぶつしょう /古物商/
こぶとり /小肥り/
こぶね /小舟/
こぶまき /昆布巻/
こぶり /小降り/小振り/
こぶん /古文/子分/
こぶんじがく /古文辞学/
こへい /雇兵/古兵/
こへん /子偏/
こべつ /個別/戸別/
こべつほうもん /戸別訪問/
こほく /湖北/
こほん /小本/古本/孤本/
こぼう /顧望/
こぼうず /小坊主/
こぼく /枯木/
こぼくかんがん /枯木寒巌/
こぼとけ /小仏/
こぼね /小骨/
こぼり /小堀/
こぼれ /毀れ/零れ/
こぼんのう /子煩悩/
こま /狛/駒/独楽/齣/小間/高麗/
こまい /古米/
こまいぬ /狛犬/狛/
こまえ /狛江/小前/
こまか /細か/
こまがた /駒形/
こまがたけ /駒ヶ岳/
こまがね /駒ヶ根/
こまき /小牧/
こまぎれ /細切れ/
こまく /鼓膜/
こまくら /小枕/木枕/
こまぐみ /駒組み/
こまごま /細々/
こまざわだいがく /駒沢大学/
こまた /小股/
こまたすくい /小股掬い/
こまち /小町/
こまつ /小松/
こまつしま /小松島/
こまつな /小松菜/
こまつばら /小松原/
こまば /駒場/
こまむすび /細結び/
こまめ /小まめ/
こまもの /小間物/
こまやか /細やか/
こまりもの /困り者/
こまわり /小回り/
こみ /込み/込/
こみかど /小御門/
こみだし /小見出し/
こみち /小道/
こみなと /小湊/
こみね /小峰/
こみの /小美濃/
こみみ /小耳/
こみや /小宮/
こみやま /小宮山/
こむ /込/
こむぎ /小麦/
こむぎいろ /小麦色/
こむぎこ /小麦粉/
こむすび /小結/
こむすめ /小娘/
こむそう /虚無僧/
こむら /小村/腓/
こむらがえり /腓返り/
こめ /米/
こめい /古名/
こめそうば /米相場/
こめだわら /米俵/
こめつき /米搗き/
こめつぶ /米粒/
こめどころ /米所/
こめぬか /米糠/
こめびつ /米櫃/
こめぶくろ /米袋/
こめへん /米偏/
こめや /米屋/
こめやまち /米屋町/
こめん /湖面/
こも /菰/薦/
こもく /小目/
こもじ /小文字/
こもち /子持/
こもちけい /子持罫/
こもちづき /小望月/
こもどり /小戻り/
こもの /小物/小者/
こもり /子守/木守/
こもりうた /子守唄/子守歌/
こもれび /木洩れ日/
こもろ /小諸/
こもん /顧問/小紋/
こもんじょ /古文書/
こもんじょがく /古文書学/
こや /小屋/昆陽/木屋/
こやいけ /昆陽池/
こやく /子役/
こやくにん /小役人/
こやぐみ /小屋組/
こやし /肥やし/
こやす /子安/
こやつ /此奴/
こやつら /此奴等/
こやづか /小屋束/
こやなぎ /小柳/
こやま /小山/
こやみ /小止み/
こゆい /小結/
こゆう /固有/
こゆううんどう /固有運動/
こゆうざいさん /固有財産/
こゆうしんどう /固有振動/
こゆうせい /固有性/
こゆうち /固有値/
こゆうめいし /固有名詞/
こゆき /小雪/
こゆび /小指/
こゆみ /小弓/
こよい /今宵/
こよう /雇用/雇傭/小用/
こようたい /固溶体/
こようほう /胡耀邦/
こようほけん /雇用保険/
こよみ /暦/
こら /子等/児等/
こらい /古来/
こらえしょう /堪え性/
こり /狐狸/凝り/梱/
こりしょう /凝り性/
こりつ /孤立/
こりつけい /孤立系/
こりつご /孤立語/
こりや /凝り屋/
こりゅう /古流/
こりょ /顧慮/
こりょうり /小料理/
こりょうりや /小料理屋/
こるい /孤塁/
これ /此/是/惟/之/
これい /古例/
これしき /是しき/
これだけ /是だけ/
これほど /是程/
これまで /是迄/
これみつ /惟光/
ころ /頃/転/
ころあい /頃合/
ころう /固陋/虎狼/古老/狐狼/
ころく /小六/
ころし /殺し/
ころしもんく /殺し文句/
ころも /衣/
ころもがえ /衣更え/
ころもがわ /衣川/
ころもで /衣手/
ころもへん /衣偏/
こわ /強/声/
こわいろ /声色/
こわかれ /子別れ/
こわき /小脇/
こわく /蠱惑/
こわくだに /小涌谷/
こわけ /小分け/
こわざ /小技/
こわざし /声差し/
こわだか /声高/
こわだんぱん /強談判/
こわっぱ /小童/
こわね /声音/
こわもて /強面/
こわれもの /壊れ物/
こん /今/金/混/根/魂/紺/痕/昆/昏/懇/恨/婚/墾/坤/困/献/建/鯀/鯤/艮/梱/
こん> /今/
こんい /懇意/
こんいん /婚姻/
こんいんてきれい /婚姻適齢/
こんいんとどけ /婚姻届/
こんか /今夏/婚家/
こんかい /今回/
こんかん /根幹/根冠/
こんがみ /紺紙/
こんがん /懇願/
こんき /根気/今期/婚期/
こんきゃく /困却/
こんきゅう /困窮/
こんきょ /根拠/
こんきょち /根拠地/
こんぎ /婚儀/
こんく /困苦/
こんくらべ /根競べ/
こんけい /根茎/根系/
こんけつ /混血/
こんけつじ /混血児/
こんげつ /今月/
こんげつごう /今月号/
こんげん /根源/根元/
こんこう /混交/混淆/渾淆/
こんこうきょう /金光教/
こんこん /懇々/滾滾/昏昏/渾渾/
こんご /今後/
こんごう /混合/金剛/根号/
こんごうき /混合気/
こんごうけんご /金剛堅固/
こんごうさん /金剛山/
こんごうしゃ /金剛砂/
こんごうじ /金剛寺/
こんごうせき /金剛石/
こんごうづえ /金剛杖/
こんごうひ /混合比/
こんごうふえ /金剛不壊/
こんごうぶじ /金剛峰寺/
こんごうぶつ /混合物/
こんごうりき /金剛力/
こんごうりゅう /金剛流/
こんさい /根菜/混載/
こんさく /混作/
こんざい /混在/
こんざつ /混雑/
こんし /紺紙/
こんしこんでい /紺紙金泥/
こんしゅう /今週/今秋/
こんしゅご /混種語/
こんしゅん /今春/
こんしょ /懇書/
こんしょう /混晶/
こんしょく /混色/混食/
こんしん /懇親/渾身/混信/
こんじ /今時/今次/恨事/根治/金字/紺地/
こんじき /金色/
こんじきどう /金色堂/
こんじゃく /今昔/
こんじゅほうしょう /紺綬褒章/
こんじょう /根性/今生/懇情/紺青/
こんすい /昏睡/
こんせい /混成/混声/懇請/混生/
こんせいがっしょう /混声合唱/
こんせいりょだん /混成旅団/
こんせき /痕跡/今夕/
こんせききかん /痕跡器官/
こんせつ /懇切/今節/
こんせん /混線/混戦/
こんぜつ /根絶/
こんぜん /渾然/
こんたん /魂胆/
こんだく /混濁/溷濁/
こんだて /献立/
こんだてひょう /献立表/
こんだん /懇談/
こんだんかい /懇談会/
こんち /根治/
こんちゅう /昆虫/
こんちゅうき /昆虫記/
こんちょう /今朝/
こんてい /根底/
こんとう /今冬/昏倒/
こんとん /混沌/渾沌/
こんど /今度/
こんどう /混同/近藤/金堂/金銅/
こんなん /困難/
こんにち /今日/
こんにちは /今日は/
こんにゃく /菎蒻/蒟蒻/
こんにゃくぼん /蒟蒻本/
こんにゅう /混入/
こんねん /今年/
こんねんど /今年度/
こんばん /今晩/
こんばんは /今晩は/
こんぱい /困憊/
こんぱく /魂魄/
こんぱん /今般/
こんぴら /金比羅/
こんぶ /昆布/
こんぺき /紺碧/
こんぼう /混紡/棍棒/
こんぽう /梱包/
こんぽん /根本/
こんぽんてき /根本的/
こんまけ /根負け/
こんめい /混迷/昆明/昏迷/
こんもう /懇望/根毛/
こんや /今夜/紺屋/
こんやく /婚約/
こんゆう /今夕/渾融/
こんよう /混用/
こんよく /混浴/
こんらん /混乱/
こんりゅう /建立/根粒/根瘤/
こんりん /金輪/
こんりんざい /金輪際/
こんりんならく /金輪奈落/
こんるり /紺瑠璃/
こんれい /婚礼/
こんろ /焜炉/
こんろん /崑崙/
こんわ /懇話/混和/
こんわく /困惑/
ご /後/語/御/誤/護/碁/悟/吾/呉/午/伍/互/五/期/娯/后/梧/
ご> /御/誤/
ごあんない /御案内/
ごい /語彙/五位/語意/
ごいけん /御意見/
ごいし /碁石/
ごいっしん /御一新/
ごう /合/号/強/轟/豪/濠/拷/壕/劫/剛/業/郷/毫/
ごうい /合意/
ごういつ /合一/
ごういん /強引/業因/
ごうう /豪雨/
ごうおん /轟音/号音/
ごうか /豪華/劫火/業火/
ごうかい /豪快/
ごうかく /合格/
ごうかばん /豪華版/
ごうかん /強姦/合巻/
ごうかんざい /強姦罪/
ごうがい /号外/
ごうがしゃ /恒河沙/
ごうがん /傲岸/
ごうき /剛気/豪毅/豪気/剛毅/
ごうきゅう /号泣/強弓/
ごうきょう /剛強/
ごうきん /合金/
ごうぎ /合議/豪儀/
ごうぎせい /合議制/
ごうく /業苦/
ごうけい /合計/
ごうけつ /豪傑/
ごうけん /合憲/剛健/剛堅/
ごうこく /合刻/
ごうご /豪語/
ごうごう /囂囂/轟々/
ごうし /郷士/合資/合祀/
ごうしがいしゃ /合資会社/
ごうしゃ /豪奢/
ごうしゅ /強酒/
ごうしゅう /豪州/
ごうしょう /豪商/江商/
ごうじ /合字/
ごうじょう /強情/
ごうじょっぱり /強情っ張り/
ごうすう /号数/
ごうせい /合成/豪勢/剛性/
ごうせいご /合成語/
ごうせいしゅ /合成酒/
ごうせいじゅし /合成樹脂/
ごうせいせんい /合成繊維/
ごうせいせんざい /合成洗剤/
ごうせいせんりょう /合成染料/
ごうせいりょく /合成力/
ごうせっとう /強窃盗/
ごうせつ /豪雪/
ごうせん /合繊/
ごうぜん /轟然/傲然/
ごうそ /強訴/
ごうそう /豪壮/合装/
ごうぞく /豪族/
ごうたい /剛体/
ごうたん /豪胆/剛胆/
ごうだつ /強奪/
ごうだん /強談/
ごうちゃく /合着/
ごうちょく /剛直/
ごうちん /轟沈/
ごうつ /江津/
ごうてい /豪邸/
ごうとう /強盗/鼇頭/
ごうどう /合同/
ごうのう /豪農/
ごうのもの /剛の者/
ごうはら /業腹/
ごうはん /合板/
ごうひ /合否/合肥/
ごうひつ /合筆/
ごうびょう /業病/
ごうふ /豪富/
ごうふく /剛腹/剛愎/
ごうべん /合弁/
ごうべんか /合弁花/
ごうほう /合法/号砲/号俸/豪放/業報/
ごうほうせい /合法性/
ごうほうてき /合法的/
ごうま /降魔/
ごうまん /傲慢/
ごうめいがいしゃ /合名会社/
ごうもう /剛毛/
ごうもん /拷問/
ごうゆう /豪遊/
ごうよく /強欲/強慾/
ごうり /合理/
ごうりか /合理化/
ごうりき /合力/強力/剛力/
ごうりしゅぎ /合理主義/
ごうりせい /合理性/
ごうりてき /合理的/
ごうりゃく /劫掠/
ごうりゅう /合流/
ごうりょく /合力/
ごうれい /号令/
ごえ /越え/
ごえい /護衛/
ごえいか /御詠歌/
ごえもんぶろ /五右衛門風呂/
ごおう /五黄/
ごおん /呉音/語音/御恩/
ごおんじょうく /五陰盛苦/
ごか /五加/
ごかい /誤解/五戒/碁会/
ごかいしょ /碁会所/
ごかいどう /五街道/
ごかく /互角/五角/
ごかくけい /五角形/
ごかん /互換/語幹/五感/語感/五官/
ごかんせい /互換性/
ごがく /語学/
ごがつ /五月/
ごがつびょう /五月病/
ごがん /護岸/
ごき /誤記/語気/御器/語基/御忌/
ごきげん /御機嫌/
ごきげんうかがい /御機嫌伺い/
ごきげんよう /御機嫌よう/
ごきゅう /御給/
ごきょう /五経/
ごぎ /語義/
ごぎょう /五行/御形/
ごく /獄/極/語句/
ごくあく /極悪/
ごくあくにん /極悪人/
ごくい /極意/獄衣/
ごくいん /極印/
ごくう /御供/
ごくかん /極寒/
ごくげつ /極月/
ごくごく /極々/
ごくさいしき /極彩色/
ごくし /獄死/
ごくしゃ /獄舎/
ごくしゅう /獄囚/
ごくしょ /極暑/
ごくしん /極信/
ごくじょう /極上/
ごくそう /獄窓/
ごくそく /獄則/
ごくそつ /獄卒/
ごくちゅう /獄中/
ごくつぶし /穀潰し/
ごくどう /極道/
ごくない /獄内/
ごくひ /極秘/
ごくひん /極貧/
ごくび /極微/
ごくぶと /極太/
ごくぼそ /極細/
ごくもん /獄門/
ごくやす /極安/
ごくらく /極楽/
ごくらくじ /極楽寺/
ごくらくじょうど /極楽浄土/
ごくらくちょう /極楽鳥/
ごくり /獄吏/
ごくろう /御苦労/
ごくろうさま /御苦労様/
ごぐん /語群/
ごけ /後家/碁笥/
ごけい /互恵/語形/
ごけいかんぜい /互恵関税/
ごけにん /御家人/
ごけん /護憲/
ごげん /語源/
ごこう /後光/五香/五光/
ごこうごみん /五公五民/
ごこく /後刻/護国/五穀/
ごこくじ /護国寺/
ごこん /語根/
ごご /午後/午后/
ごごん /五言/
ごごんぜっく /五言絶句/
ごさ /誤差/
ごさい /後妻/
ごさかんすう /誤差関数/
ごさつ /誤殺/
ごさん /誤算/午餐/
ごさんけ /御三家/
ござ /茣蓙/蓙/後座/御座/
ごし /五指/越し/呉子/
ごしき /五色/
ごしちちょう /五七調/
ごしゃ /誤写/
ごしゃく /語釈/
ごしゅ /五種/御酒/
ごしゅうぎ /御祝儀/
ごしゅうしょうさま /御愁傷様/
ごしゅん /呉春/
ごしょ /御所/五所/
ごしょう /後生/
ごしょうだいじ /後生大事/
ごしょがわら /五所川原/
ごしょく /誤植/五色/
ごしん /誤信/誤診/護身/誤審/
ごしんえい /御真影/
ごしんとう /御神灯/
ごじ /誤字/護持/五時/
ごじっぽひゃっぽ /五十歩百歩/
ごじつ /後日/
ごじつだん /後日談/
ごじぶん /御自分/
ごじゅう /五重/
ごじゅうおん /五十音/
ごじゅうおんじゅん /五十音順/
ごじゅうおんず /五十音図/
ごじゅうかた /五十肩/
ごじゅうさんつぎ /五十三次/
ごじゅうしょう /五重唱/
ごじゅうそう /五重奏/
ごじゅうのとう /五重塔/
ごじゅん /語順/
ごじょ /互助/
ごじょう /五条/互譲/五常/
ごじょうざか /五条坂/
ごじょかい /互助会/
ごじょほう /互除法/
ごじん /御仁/吾人/
ごじんか /御神火/
ごすい /午睡/
ごすう /語数/
ごすんくぎ /五寸釘/
ごず /牛頭/
ごずみ /後炭/
ごずめず /牛頭馬頭/
ごせ /御所/
ごせい /悟性/語勢/互生/碁聖/
ごせっけ /五摂家/
ごせん /五線/五泉/互選/
ごせんえん /五千円/
ごせんえんさつ /五千円札/
ごせんし /五線紙/
ごせんふ /五線譜/
ごぜ /瞽女/
ごぜん /午前/御前/御膳/
ごぜんかいぎ /御前会議/
ごぜんさま /午前様/
ごそう /護送/誤想/
ごそうぼうえい /誤想防衛/
ごそくろう /御足労/
ごぞう /五臓/
ごぞうろっぷ /五臓六腑/
ごぞく /語族/五族/
ごぞんじ /御存知/御存じ/
ごたい /五体/
ごたいそう /御大層/
ごたいまんぞく /五体満足/
ごたく /御託/
ごたくせん /御託宣/
ごたぶん /御多分/
ごだい /五代/
ごだいこ /五大湖/
ごだいさん /五台山/
ごだいどう /五大堂/
ごだつ /誤脱/
ごだん /五段/誤断/
ごだんかつよう /五段活用/
ごち /五智/
ごちそう /御馳走/
ごちょう /語調/伍長/
ごっかん /極寒/
ごったに /ごった煮/
ごつごうしゅぎ /御都合主義/
ごて /後手/
ごてい /五帝/
ごていしゅ /御亭主/
ごてん /御殿/
ごてんば /御殿場/
ごでん /誤伝/
ごと /毎/五斗/如/
ごとう /後藤/五島/語頭/誤答/
ごとうしょ /御当所/
ごとうち /御当地/
ごとうてん /後藤点/
ごとうれっとう /五島列島/
ごとく /五徳/
ごとし /如し/
ごど /五度/
ごどく /誤読/
ごなん /御難/
ごにん /誤認/五人/
ごにんばやし /五人囃子/
ごねどく /ごね得/
ごねん /御念/
ごのう /御悩/
ごは /語派/
ごはさん /御破算/
ごはっと /御法度/
ごはん /御飯/誤判/
ごば /後場/
ごばらい /後払い/
ごばん /碁盤/五番/
ごばんわり /碁盤割り/
ごひゃく /五百/
ごひゃくらかん /五百羅漢/
ごび /語尾/
ごびへんか /語尾変化/
ごびゅう /誤謬/
ごびょう /御廟/
ごふ /護符/後夫/
ごふうじゅうう /五風十雨/
ごふく /五福/呉服/
ごふくや /呉服屋/
ごふじょう /御不浄/
ごふん /胡粉/
ごぶ /五分/五部/
ごぶがり /五分刈り/
ごぶごぶ /五分五分/
ごぶさた /御無沙汰/
ごぶじ /御無事/
ごぶん /誤聞/
ごへい /語弊/
ごほう /誤報/語法/午砲/御報/
ごほうぜん /御宝前/
ごほん /御本/
ごぼう /御坊/牛蒡/
ごま /胡麻/護摩/
ごまあぶら /胡麻油/
ごまつ /語末/
ごまどう /護摩堂/
ごまどうふ /胡麻豆腐/
ごみ /五味/塵/
ごみゃく /語脈/
ごみょう /五明/
ごむ /護謨/
ごむよう /御無用/
ごめい /五明/
ごめん /御免/
ごもく /五目/
ごもくならべ /五目並べ/
ごもつ /御物/
ごもん /御紋/御門/五門/
ごやく /誤訳/
ごゆ /御油/
ごよう /御用/誤用/五葉/
ごようおさめ /御用納め/
ごようがくしゃ /御用学者/
ごようきき /御用聞き/
ごようきん /御用金/
ごようたし /御用達/
ごようてい /御用邸/
ごようはじめ /御用始め/
ごようまつ /五葉松/
ごようろん /語用論/
ごよく /五欲/
ごらいこう /御来光/
ごらいごう /御来迎/
ごらく /娯楽/
ごらん /御覧/
ごり /鮴/
ごりおし /ごり押し/
ごりむちゅう /五里霧中/
ごりやく /御利益/
ごりょう /御陵/御寮/御領/御料/
ごりょうかく /五稜郭/
ごりょうしゃ /御料車/
ごりょうち /御料地/
ごりょうにん /御寮人/
ごりん /五輪/五倫/
ごれい /語例/
ごれいぜん /御霊前/
ごろ /語呂/頃/
ごろあわせ /語呂合せ/
ごろう /五郎/
ごろく /語録/
ごろね /ごろ寝/
ごん /言/権/厳/艮/勤/
ごんか /言下/
ごんぎょう /勤行/
ごんぐ /欣求/
ごんぐじょうど /欣求浄土/
ごんげ /権化/
ごんげん /権現/
ごんご /言語/
ごんごどうだん /言語道断/
ごんじゃ /権者/
ごんじょう /言上/
ごんずい /権瑞/
ごんだ /権田/
ごんどうくじら /巨頭鯨/
ごんべえ /権兵衛/
ごんべん /言偏/
さ /差/左/茶/鎖/詐/砂/査/叉/佐/些/再/作/紗/梭/瑳/沙/唆/
さい /際/最/歳/才/西/再/妻/載/裁/菜/細/斎/祭/砕/犀/采/災/済/栽/採/彩/宰/塞/催/債/財/殺/切/差異/蔡/綵/豺/賽/差違/砦/哉/
さい> /再/最/歳/
さいあい /最愛/
さいあく /最悪/
さいいき /西域/
さいいん /斎院/
さいう /細雨/
さいうん /彩雲/
さいえん /才媛/再演/菜園/再縁/
さいおう /塞翁/再往/最奥/再応/
さいおん /蔡温/
さいおんじ /西園寺/
さいおんじきんもち /西園寺公望/
さいか /最下/裁可/災禍/再嫁/西下/
さいかい /再開/再会/斎戒/際会/西海/最下位/
さいかいはつ /再開発/
さいかいもくよく /斎戒沐浴/
さいかく /才覚/西鶴/
さいかん /再刊/才幹/菜館/災患/彩管/
さいかんさんゆう /歳寒三友/
さいがい /災害/
さいがいほしょう /災害補償/
さいがく /才学/
さいがわ /犀川/
さいき /再起/才気/祭器/債鬼/佐伯/再帰/
さいきかんぱつ /才気煥発/
さいきそ /再起訴/
さいきだいめいし /再帰代名詞/
さいきょ /再挙/裁許/
さいきょう /最強/西京/
さいきょういく /再教育/
さいきょうせん /埼京線/
さいきん /最近/細菌/
さいぎ /猜疑/祭儀/再議/
さいぎょう /西行/
さいぎんみ /再吟味/
さいく /細工/
さいくじょ /細工所/
さいくつ /採掘/
さいくつけん /採掘権/
さいくもの /細工物/
さいくん /細君/
さいぐ /祭具/
さいぐう /斎宮/
さいぐさ /三枝/
さいぐんび /再軍備/
さいけい /歳計/
さいけいこく /最恵国/
さいけいれい /最敬礼/
さいけつ /採決/採血/裁決/
さいけん /再建/債券/債権/細見/再見/
さいけんしゃ /債権者/
さいけんとう /再検討/
さいげい /才芸/
さいげつ /歳月/
さいげん /再現/際限/
さいこ /最古/西湖/
さいこう /最高/再考/採光/再興/採鉱/再校/砕鉱/
さいこうがくふ /最高学府/
さいこうこく /再抗告/
さいこうしん /最高神/
さいこうちょう /最高潮/
さいこうび /最後尾/
さいこうべん /再抗弁/
さいこうほう /最高峰/
さいこうほうき /最高法規/
さいこく /催告/
さいこくぼん /再刻本/
さいころ /賽子/骰子/
さいこん /再婚/菜根/再建/
さいご /最後/最期/
さいごう /西郷/
さいごうたかもり /西郷隆盛/
さいごく /西国/
さいごつうちょう /最後通牒/
さいごん /西貢/
さいさ /歳差/
さいさい /歳々/再々/
さいさうんどう /歳差運動/
さいさき /幸先/
さいさん /採算/再三/
さいさんさいし /再三再四/
さいさんわれ /採算割れ/
さいし /妻子/才子/祭祀/祭司/
さいしき /彩色/才識/祭式/
さいしたびょう /才子多病/
さいしつ /妻室/
さいして /際して/
さいしゅ /採取/採種/祭主/
さいしゅう /最終/採集/
さいしゅうてき /最終的/
さいしゅうとう /済州島/
さいしゅうべんろん /最終弁論/
さいしゅっぱつ /再出発/
さいしゅつ /歳出/
さいしょ /最初/税所/細書/
さいしょう /最小/最少/宰相/妻妾/
さいしょうげん /最小限/
さいしょうこうばいすう /最小公倍数/
さいしょうじ /最勝寺/
さいしょうすう /最小数/
さいしょうち /最小値/
さいしょく /才色/菜食/彩色/
さいしょくけんび /才色兼備/
さいしん /最新/細心/再審/最深/
さいしんばん /最新版/
さいじ /細事/祭事/細字/歳次/
さいじき /歳時記/
さいじつ /祭日/
さいじょ /才女/妻女/細叙/
さいじょう /西条/最上/斎場/祭場/
さいじょうきゅう /最上級/
さいじょうりゅう /最上流/
さいじん /才人/祭神/
さいすん /採寸/
さいせい /再生/再製/最盛/済世/済生/祭政/
さいせいかい /済生会/
さいせいき /最盛期/
さいせいさん /再生産/
さいせいし /再生紙/
さいせき /採石/砕石/
さいせきけん /採石権/
さいせつ /細説/砕屑/再説/
さいせつぶつ /砕屑物/
さいせん /再選/賽銭/
さいせんきょ /再選挙/
さいせんたん /最先端/
さいぜん /最善/最前/
さいぜんせん /最前線/
さいそ /再訴/
さいそう /再送/彩層/採草/
さいそく /催促/細則/
さいぞう /才蔵/
さいた /最多/
さいたい /妻帯/臍帯/
さいたく /採択/
さいたま /埼玉/
さいたまけん /埼玉県/
さいたまし /さいたま市;2001年5月1日に浦和、大宮、与野三市が合併してできた市/
さいたる /最たる/
さいたん /最短/採炭/
さいたんきょり /最短距離/
さいだい /最大/細大/
さいだいきゅう /最大級/
さいだいげん /最大限/
さいだいじ /西大寺/
さいだいすう /最大数/
さいだいたすう /最大多数/
さいだいち /最大値/
さいだいりかく /最大離角/
さいだん /裁断/祭壇/
さいち /才知/細緻/
さいちゅう /最中/
さいちょう /最長/最澄/再調/
さいてい /最低/裁定/再訂/
さいていげん /最低限/
さいていとりひき /裁定取引/
さいてき /最適/
さいてきか /最適化/
さいてん /採点/祭典/西天/再転/
さいでん /祭殿/
さいと /西都/
さいとう /斎藤/
さいとく /才徳/
さいど /再度/彩度/
さいどく /再読/
さいなん /災難/済南/
さいにゅう /歳入/
さいにゅうけっかん /歳入欠陥/
さいにょう /採尿/
さいにん /再任/再認/
さいにんしき /再認識/
さいねん /再燃/西念/
さいのう /才能/臍嚢/採納/
さいのかわら /賽の河原/
さいのめ /賽の目/
さいはい /采配/再拝/
さいはいふ /再配布/
さいはつ /再発/
さいはて /最果て/
さいはん /再版/再犯/
さいばい /栽培/
さいばし /菜箸/
さいばん /裁判/
さいばんかん /裁判官/
さいばんかんかつ /裁判管轄/
さいばんけん /裁判権/
さいばんざた /裁判沙汰/
さいばんしょ /裁判所/裁判書/
さいばんせき /裁判籍/
さいばんちょう /裁判長/
さいひ /採否/歳費/
さいひつ /才筆/細筆/
さいひょう /砕氷/細評/
さいひょうか /再評価/
さいひょうせん /砕氷船/
さいひんち /最頻値/
さいび /最微/細微/
さいふ /財布/採譜/宰府/
さいぶ /細部/西部/
さいぶつ /才物/
さいぶん /細分/祭文/
さいへん /再編/砕片/
さいべつ /細別/
さいほう /裁縫/西方/
さいほうじょうど /西方浄土/
さいぼう /細胞/才望/
さいぼうこうがく /細胞工学/
さいぼうしつ /細胞質/
さいぼうしん /細胞診/
さいぼうぶんれつ /細胞分裂/
さいぼうへき /細胞壁/
さいぼうまく /細胞膜/
さいまつ /歳末/
さいみつ /細密/
さいみゃく /細脈/
さいみん /催眠/細民/
さいみんじゅつ /催眠術/
さいむ /債務/
さいむしゃ /債務者/
さいむふりこう /債務不履行/
さいむめいぎ /債務名義/
さいめい /才名/
さいもく /細目/
さいもん /柴門/
さいもんどき /彩文土器/
さいやく /災厄/
さいゆ /採油/
さいゆう /西遊/
さいゆうき /西遊記/
さいゆうせん /最優先/
さいゆしゅつ /再輸出/
さいゆにゅう /再輸入/
さいよう /採用/細腰/
さいらい /再来/
さいり /犀利/
さいりゃく /才略/
さいりゅう /細流/細粒/
さいりょう /最良/裁量/宰領/才量/
さいりょく /才力/
さいりよう /再利用/
さいりん /再臨/
さいるい /催涙/
さいるいだん /催涙弾/
さいれい /祭礼/
さいろう /豺狼/
さいろく /採録/再録/載録/
さいろん /再論/細論/
さいわ /再話/
さいわい /幸い/
さいわん /才腕/
さえき /佐伯/差益/
さえざえ /冴え冴え/
さえつ /査閲/
さえもん /左衛門/
さえん /茶園/
さお /竿/棹/佐保/
さおだけ /竿竹/
さおとめ /早乙女/
さおもの /棹物/
さか /酒/坂/逆/茶菓/阪/
さかい /堺/酒井/界/境/
さかいすじ /堺筋/
さかいちょう /堺町/
さかいで /坂出/
さかいみなと /境港/
さかいめ /境目/
さかうらみ /逆恨み/
さかえ /栄え/栄/
さかおとし /逆落し/
さかき /榊/賢木/
さかきばら /榊原/
さかぐち /坂口/
さかぐちあんご /坂口安吾/
さかぐら /酒蔵/
さかげ /逆毛/
さかさ /逆さ/逆/
さかし /賢し/
さかしたもん /坂下門/
さかしま /倒/
さかしら /賢しら/
さかずき /杯/盃/
さかた /坂田/酒田/
さかだい /酒代/
さかだち /逆立ち/
さかだる /酒樽/
さかて /逆手/酒手/
さかど /坂戸/
さかな /魚/肴/
さかなや /魚屋/
さかのうえ /坂上/
さかば /酒場/
さかべ /酒部/
さかみず /逆水/
さかみち /坂道/坂路/
さかむけ /逆剥け/
さかむし /酒蒸し/
さかもぎ /逆茂木/
さかもと /坂本/
さかもとりょうま /坂本竜馬/
さかもり /酒盛り/
さかや /酒屋/
さかやき /月代/
さかゆめ /逆夢/
さかり /盛り/
さかりば /盛り場/
さかわがわ /酒匂川/
さかん /左官/佐官/主典/盛ん/
さが /佐賀/性/嵯峨/
さがいこうい /詐害行為/
さがえ /寒河江/
さがく /差額/
さがけん /佐賀県/
さがし /佐賀市/
さがしもの /捜し物/探し物/
さがの /嵯峨野/
さがぼん /嵯峨本/
さがみ /相模/
さがみがわ /相模川/
さがみこ /相模湖/
さがみはら /相模原/
さがら /相良/
さがり /下がり/
さがりめ /下がり目/
さがん /左岸/砂岩/
さき /先/崎/左記/前/碕/埼/咲/
さきいき /先行き/
さきおくり /先送り/
さきおととい /一昨昨日/
さきおととし /一昨昨年/
さきがいけん /先買権/
さきがけ /先駆け/魁/
さきがし /先貸し/
さきがり /先借り/
さきぎり /先限/
さきごろ /先頃/
さきさか /向坂/
さきさま /先様/
さきざき /先々/
さきぞなえ /先備え/
さきだか /先高/
さきて /先手/
さきどり /先取り/
さきどりとっけん /先取特権/
さきのり /先乗り/
さきばらい /先払い/
さきぶれ /先触れ/
さきほど /先程/
さきぼう /先棒/
さきぼそり /先細り/
さきまわり /先回り/
さきもの /先物/
さきものがい /先物買/
さきものとりひき /先物取引/
さきもり /防人/
さきやす /先安/
さきゅう /砂丘/
さきゆき /先行き/
さきょう /左京/
さきわけ /咲分け/
さきわたし /先渡し/
さきん /砂金/差金/
さぎ /詐欺/鷺/詐偽/
さぎざい /詐欺罪/
さぎし /詐欺師/
さぎはさんざい /詐欺破産罪/
さぎょう /作業/サ行/
さぎょうかせつ /作業仮説/
さぎり /狭霧/
さく /作/冊/錯/索/策/柵/朔/昨/搾/削/酢/佐久/簀/窄/咋/
さくい /作意/作為/
さくいん /索引/
さくおう /策応/
さくか /昨夏/
さくが /作画/
さくがら /作柄/
さくがんき /削岩機/
さくぎょう /昨暁/
さくぐ /索具/
さくげん /削減/
さくご /錯誤/
さくさん /酢酸/
さくざつ /錯雑/
さくし /作詩/錯視/作詞/策士/
さくしゃ /作者/
さくしゅ /搾取/
さくしゅう /昨秋/作州/
さくしゅん /昨春/
さくじ /作事/作字/
さくじつ /昨日/朔日/
さくじば /作事場/
さくじょ /削除/
さくじょう /作条/
さくじょうそしき /柵状組織/
さくず /作図/
さくせい /作成/作製/
さくせん /作戦/
さくそう /錯綜/
さくちょう /昨朝/
さくづけ /作付け/
さくてい /策定/
さくてき /索敵/
さくとう /昨冬/作陶/
さくどう /策動/索道/
さくにゅう /搾乳/
さくねん /昨年/
さくはつ /炸発/
さくばく /索漠/索莫/索寞/
さくばん /昨晩/
さくひこんぜ /昨非今是/
さくひん /作品/
さくふう /作風/
さくぶん /作文/
さくほう /作法/昨報/
さくぼう /策謀/朔望/
さくぼうげつ /朔望月/
さくま /佐久間/作間/削磨/
さくもつ /作物/
さくもん /作文/
さくや /昨夜/
さくやく /炸薬/
さくゆ /搾油/
さくゆう /昨夕/
さくら /桜/佐倉/佐久良/
さくらい /桜井/
さくらいろ /桜色/
さくらがい /桜貝/
さくらがわ /桜川/
さくらぎ /桜木/
さくらじま /桜島/
さくらぜんせん /桜前線/
さくらそう /桜草/
さくらだ /桜田/
さくらだい /桜鯛/
さくらだもん /桜田門/
さくらにく /桜肉/
さくらま /桜間/
さくらもち /桜餅/
さくらん /錯乱/
さくりつ /冊立/
さくりゃく /策略/
さくれい /作例/
さくれつ /炸裂/
さけ /酒/鮭/
さけい /左傾/
さけかす /酒粕/
さけくせ /酒癖/
さけづけ /酒漬け/
さけのみ /酒飲み/
さけびたり /酒浸り/
さけめ /裂け目/
さけよい /酒酔い/
さけん /差遣/
さげ /下げ/
さげあし /下げ足/
さげお /下げ緒/
さげかじ /下げ舵/
さげしお /下げ潮/
さげもどし /下げ戻し/
さげん /左舷/
さこ /迫/
さこう /鎖港/
さこうべん /左顧右眄/
さこく /鎖国/
さこつ /鎖骨/
さこん /左近/
ささ /篠/笹/
ささい /些細/瑣細/
ささえ /支え/
ささかわ /笹川/
ささき /佐々木/
ささげ /捧げ/
ささげつつ /捧げ銃/
ささげもの /捧げ物/
ささつ /査察/
ささど /笹戸/
ささはら /笹原/
ささまき /笹巻/
ささめゆき /細雪/
ささや /笹屋/
ささやか /細やか/
ささやま /篠山/
ささら /簓/
ささわら /笹原/
ささわり /障り/
さざなみ /漣/細波/小波/
さざれ /細/
さざんか /山茶花/
さし /砂嘴/沙市/
さしあし /差し足/
さしあみ /刺網/
さしいれ /差入れ/
さしえ /挿絵/
さしおさえ /差押え/
さしかけ /指し掛け/差掛け/
さしがさ /差し傘/
さしがね /差し金/
さしき /挿し木/
さしきず /刺し傷/
さしげ /差し毛/
さしこ /刺子/
さしさわり /差障り/
さしず /指図/
さしずさいけん /指図債権/
さしずしょうけん /指図証券/
さしだしにん /差出人/
さしちがえ /刺し違え/差し違え/
さしつかえ /差支え/
さして /指し手/差し手/
さしで /差し出/
さしでぐち /差し出口/
さしとめ /差止め/
さしにない /差し担い/
さしね /指値/
さしば /差し歯/
さしばな /挿花/
さしひき /差引き/
さしま /猿島/
さしみ /刺身/差し身/
さしみず /差水/
さしむかい /差向い/
さしもどし /差戻し/
さしもの /指物/
さしゅ /詐取/
さしゅう /査収/
さしゅうごう /差集合/
さしゆうご /左支右吾/
さしょう /詐称/査証/些少/
さしりょう /差料/
さしわたし /差渡し/
さしんしつ /左心室/
さしんぼう /左心房/
さじ /匙/些事/瑣事/
さじかげん /匙加減/
さじき /桟敷/
さじゅつ /詐術/
さじょう /砂上/叉状/
さじん /砂塵/
さずかりもの /授かり物/
させつ /左折/
させぼ /佐世保/
させん /左遷/
さそいみず /誘い水/
さそく /左側/
さそり /蠍/
さそりざ /蠍座/
さそん /差損/
さぞ /嘸/
さた /沙汰/
さたけ /佐竹/
さたみさき /佐多岬/
さたろう /佐太郎/
さたん /嗟嘆/嗟歎/
さだ /定/
さだいじん /左大臣/
さだか /定か/
さだつぐ /貞次/
さだとし /定利/
さだまりごと /定まり事/
さだみさき /佐田岬/
さだめ /定め/
さだめごと /定め事/
さち /幸/
さちゅうぐうご /沙中偶語/
さっ /早/
さっか /作家/擦過/作歌/昨夏/
さっかく /錯覚/錯角/
さっかしょう /擦過傷/
さっかん /錯簡/
さっき /殺気/
さっきゅう /早急/
さっきょう /作況/
さっきょく /作曲/
さっきょくほう /作曲法/
さっきん /殺菌/
さっきんざい /殺菌剤/
さっこう /作興/
さっこん /昨今/
さっさ /佐々/
さっし /冊子/察し/
さっしぼん /冊子本/
さっしょう /殺傷/
さっしん /刷新/
さっすい /撒水/
さっすう /冊数/
さっせい /殺青/
さっそう /颯爽/
さっそく /早速/
さっそざい /殺鼠剤/
さっち /察知/
さっちゅうざい /殺虫剤/
さっちょう /薩長/
さって /幸手/
さっと /颯と/
さっとう /殺到/
さっぷ /撒布/
さっぷうけい /殺風景/
さっぽろ /札幌/
さっぽろし /札幌市/
さつ /札/冊/擦/殺/撮/察/刷/薩/
さつい /殺意/
さつえい /撮影/
さつがい /殺害/
さつき /皐月/五月/皐/
さつきやま /五月山/
さつじん /殺人/殺陣/
さつじんき /殺人鬼/
さつじんざい /殺人罪/
さつじんてき /殺人的/
さつたば /札束/
さつなん /薩南/
さつばつ /殺伐/
さつま /薩摩/
さつまいも /薩摩芋/
さつまじる /薩摩汁/
さつまのかみ /薩摩守/
さつまはんとう /薩摩半島/
さつまばん /薩摩版/
さつよう /撮要/
さつりく /殺戮/
さてい /査定/
さておき /扨措き/
さてつ /砂鉄/蹉跌/
さてん /茶店/
さと /里/
さといも /里芋/
さとう /佐藤/砂糖/差等/左党/
さとおや /里親/
さとかた /里方/
さとがえり /里帰り/
さとご /里子/
さとごころ /里心/
さとだ /里田/
さとなか /里中/
さとぼう /里坊/
さとみ /里見/
さとみはっけんでん /里見八犬伝/
さとむら /里村/
さとり /悟り/
さど /佐渡/砂土/
さどう /作動/茶道/
さどがしま /佐渡島/
さどく /査読/
さなえ /早苗/
さなか /最中/
さながら /宛ら/
さなぎ /蛹/
さなだ /真田/
さなだひも /真田紐/
さなだまさゆき /真田昌幸/
さなだゆきむら /真田幸村/
さぬき /讃岐/
さの /佐野/
さのう /砂嚢/
さは /左派/
さはい /差配/
さはん /茶飯/
さはんじ /茶飯事/
さば /鯖/
さばえ /鯖江/
さばおり /鯖折り/
さばく /砂漠/佐幕/
さばずし /鯖鮨/
さひょうえ /左兵衛/
さび /錆/寂/銹/
さびいろ /錆色/
さびどめ /錆止め/
さびねず /錆鼠/
さびれ /寂れ/
さぶろう /三郎/
さぶん /差分/
さへん /左辺/サ変/
さべつ /差別/
さべつかんぜい /差別関税/
さべつたいぐう /差別待遇/
さほ /佐保/
さほう /作法/左方/
さほど /然程/
さほやま /佐保山/
さぼう /砂防/茶房/詐謀/
さぼてん /仙人掌/
さま /様/
さまかたち /様形/
さまがわり /様変り/
さまさま /様様/
さまざま /様々/
さまたげ /妨げ/
さまつ /瑣末/
さまのすけ /左馬助/
さみ /三味/
さみだれ /五月雨/
さむ /寒/
さむえ /作務衣/
さむかぜ /寒風/
さむかわじんじゃ /寒川神社/
さむがり /寒がり/
さむけ /寒気/
さむさ /寒さ/
さむざむ /寒々/
さむぞら /寒空/
さむらい /侍/士/
さめ /鮫/
さめがわ /沙皮/鮫皮/
さめはだ /鮫肌/
さも /然も/
さもん /査問/左門/
さや /鞘/莢/
さやあて /鞘当て/
さやいんげん /莢隠元/
さやえんどう /莢豌豆/
さやどう /鞘堂/
さやま /狭山/佐山/
さゆ /白湯/
さゆう /左右/
さゆうそうしょう /左右相称/
さよ /小夜/
さよう /作用/左様/
さようそ /作用素/
さようてん /作用点/
さよきょく /小夜曲/
さよく /左翼/
さら /皿/更/
さらいげつ /再来月/
さらいしゅう /再来週/
さらいねん /再来年/
さらさ /更紗/
さらさら /更々/
さらし /晒/
さらしあん /晒し餡/
さらしくび /晒し首/
さらしな /更級/更科/
さらしもの /晒し者/
さらしや /晒屋/
さらす /晒/
さらそうじゅ /沙羅双樹/
さらち /更地/
さらに /更に/
さらぬ /然らぬ/
さらば /然らば/
さらまわし /皿回し/
さりとて /然りとて/
さりょう /茶寮/
さる /猿/申/
さるお /猿尾/
さるかい /猿飼/
さるぎ /猿木/
さるぐつわ /猿轡/
さるげ /猿毛/
さるしばい /猿芝居/
さるすべり /百日紅/
さるたひこ /猿田彦/
さるぢえ /猿知恵/
さるとびさすけ /猿飛佐助/
さるはし /猿橋/
さるまた /猿股/
さるまね /猿真似/
さるまわし /猿回し/
さるめんかじゃ /猿面冠者/
されき /砂礫/
されこうべ /髑髏/
さわ /沢/茶話/
さわいずみ /沢泉/
さわかい /茶話会/
さわがに /沢蟹/
さわだ /沢田/
さわちりょうり /皿鉢料理/
さわの /沢野/
さわべ /沢辺/
さわむら /沢村/
さわやか /爽やか/
さわやなぎ /沢柳/
さわやま /沢山/
さわら /佐原/鰆/椹/
さわらび /早蕨/
さわん /左腕/
さん /山/三/散/餐/酸/賛/讃/蚕/算/産/燦/桟/惨/参/傘/纂/撒/
さんあい /三愛/
さんい /賛意/三位/
さんいつ /散逸/散佚/
さんいん /山陰/参院/産院/
さんいんちほう /山陰地方/
さんいんどう /山陰道/
さんいんほんせん /山陰本線/
さんう /山雨/
さんか /参加/酸化/讃歌/産科/傘下/賛歌/山窩/惨禍/山下/山河/
さんかあえん /酸化亜鉛/
さんかい /参会/散会/散開/山海/山塊/
さんかいき /三回忌/
さんかきんたい /山河襟帯/
さんかく /三角/参画/▽/▼/△/▲/
さんかくかんけい /三角関係/
さんかくかんすう /三角関数/
さんかくきん /三角巾/三角筋/
さんかくけい /三角形/
さんかくじょうぎ /三角定規/
さんかくす /三角州/
さんかくそくりょう /三角測量/
さんかくちゅう /三角柱/
さんかくてん /三角点/
さんかくひ /三角比/
さんかくほう /三角法/
さんかくぼうし /三角帽子/
さんかしゃ /参加者/
さんかっけい /三角形/
さんかてつ /酸化鉄/
さんかどう /酸化銅/
さんかぶつ /酸化物/
さんかん /参観/山間/三韓/三冠/参看/
さんかんおう /三冠王/
さんかんしおん /三寒四温/
さんかんば /三冠馬/
さんが /参賀/
さんがい /三階/惨害/三界/
さんがく /山岳/産額/算額/散楽/
さんがくきょうどう /産学協同/
さんがつ /三月/
さんがにち /三箇日/
さんきち /三吉/
さんきゃく /三脚/
さんきゅう /産休/
さんきょ /山居/
さんきょう /山峡/三峡/
さんきんこうたい /参勤交代/
さんぎ /参議/算木/
さんぎいん /参議院/
さんぎいんぎいん /参議院議員/
さんぎょう /産業/三業/蚕業/
さんぎょうかくめい /産業革命/
さんぎょうこうぞう /産業構造/
さんく /惨苦/
さんぐう /参宮/三宮/
さんぐん /三軍/
さんけ /産気/三家/
さんけい /山系/参詣/散形/三景/
さんけいかじょ /散形花序/
さんけいしんぶん /産経新聞/
さんけつ /酸欠/三傑/
さんけん /散見/三権/
さんけんぶんりつ /三権分立/
さんげ /散華/山下/
さんげき /惨劇/
さんげつ /山月/
さんげん /三元/
さんげんしょく /三原色/
さんこ /三顧/
さんこう /参考/山行/三光/三皇/参向/散光/
さんこうしょ /参考書/
さんこうしりょう /参考資料/
さんこうすいちょう /山高水長/
さんこうせいうん /散光星雲/
さんこうにん /参考人/
さんこうぶんけん /参考文献/
さんご /珊瑚/産後/
さんごう /三合/山号/
さんごかい /珊瑚海/
さんごく /三国/
さんごくかんしょう /三国干渉/
さんごくしえんぎ /三国志演義/
さんごくじだい /三国時代/
さんごくどうめい /三国同盟/
さんごしょう /珊瑚礁/
さんさ /三叉/
さんさい /三才/山菜/三彩/
さんさく /散策/
さんさろ /三叉路/
さんさん /三々/燦々/
さんさんくど /三三九度/
さんさんごご /三々五々/三三五五/
さんざい /散財/散在/散剤/
さんざん /散々/
さんし /蚕糸/三思/
さんしき /算式/三色/
さんしすいめい /山紫水明/
さんした /三下/
さんしつ /蚕室/産室/散失/
さんしゃ /三者/三社/三舎/山車/
さんしゃく /参酌/
さんしゅ /三種/
さんしゅう /参集/三周/纂輯/
さんしゅうき /三周忌/
さんしゅつ /算出/産出/
さんしゅのじんぎ /三種の神器/
さんしょ /山椒/
さんしょう /参照/三章/三唱/山椒/
さんしょううお /山椒魚/
さんしょく /三色/三食/蚕食/
さんしょくき /三色旗/
さんしろう /三四郎/
さんしん /三振/三信/参審/参進/
さんしんとう /三親等/
さんじ /参事/産児/惨事/賛辞/三時/讃辞/
さんじかん /参事官/
さんじげん /三次元/
さんじせいげん /産児制限/
さんじゃく /三尺/
さんじゅ /傘寿/
さんじゅう /三重/
さんじゅうく /三重苦/
さんじゅうさつ /三重殺/
さんじゅうし /三銃士/
さんじゅうしょう /三重唱/
さんじゅうそう /三重奏/
さんじゅうろっけい /三十六計/
さんじゅつ /算術/
さんじゅつへいきん /算術平均/
さんじょ /賛助/産所/
さんじょう /参上/三条/惨状/山上/三乗/
さんじょうき /三畳紀/
さんじょく /産褥/
さんすい /山水/撒水/
さんすいが /山水画/
さんすう /算数/
さんすくみ /三竦み/
さんず /三途/
さんずのかわ /三途の川/
さんずん /三寸/
さんずんふりつ /三寸不律/
さんせい /賛成/参政/酸性/三世/三精/産生/山西/三省/三聖/
さんせいう /酸性雨/
さんせいけん /参政権/
さんせいし /酸性紙/
さんせいしょくひん /酸性食品/
さんせいど /酸性度/
さんせき /山積/
さんせん /参戦/三遷/山川/
さんせんけ /三千家/
さんせんべん /三尖弁/
さんぜん /燦然/三千/産前/参禅/
さんぜんいん /三千院/
さんぜんせかい /三千世界/
さんそ /酸素/
さんそう /山荘/
さんそうこうりゅう /三相交流/
さんそん /山村/散村/
さんぞう /三蔵/
さんぞうほうし /三蔵法師/
さんぞく /山賊/
さんたい /三体/三態/三台/三諦/
さんたろう /三太郎/
さんたん /賛嘆/惨憺/惨澹/讃嘆/讃歎/
さんだ /三田/
さんだい /三大/参内/散大/三代/
さんだいじ /三大寺/
さんだいばなし /三題噺/
さんだいめ /三代目/
さんだつ /簒奪/
さんだゆう /三太夫/
さんだん /三段/散弾/算段/
さんだんがまえ /三段構え/
さんだんきょう /三段峡/
さんだんじゅう /散弾銃/
さんだんとび /三段跳/
さんだんめ /三段目/
さんだんろんぽう /三段論法/
さんち /産地/山地/
さんちゃく /参着/
さんちゅう /山中/
さんちょう /山頂/
さんちょく /産直/
さんつう /三通/
さんてい /算定/刪定/
さんてん /散点/
さんでん /三伝/散田/参殿/
さんと /三都/
さんとう /三島/三等/山東/
さんとうか /山頭火/
さんとうせいじ /三頭政治/
さんど /三度/
さんどう /賛同/参道/産道/山道/参堂/散瞳/
さんどがさ /三度笠/
さんどめ /三度目/
さんない /山内/三内/
さんにゅう /参入/算入/
さんにん /三人/
さんにんぐみ /三人組/
さんにんしょう /三人称/
さんねん /三年/
さんねんざか /三年坂/
さんのう /山王/
さんのまる /三の丸/
さんのみや /三宮/
さんはんきかん /三半規管/
さんば /産婆/
さんばい /三杯/
さんばいず /三杯酢/
さんばがらす /三羽烏/
さんばがわ /三波川/
さんばし /桟橋/
さんばそう /三番叟/
さんばん /三番/
さんぱい /参拝/酸敗/三拝/
さんぱいきゅうはい /三拝九拝/
さんぱつ /散髪/散発/
さんぱつや /散髪屋/
さんび /賛美/讃美/
さんびか /賛美歌/
さんびゃく /三百/
さんびゃくだいげん /三百代言/
さんびょうし /三拍子/
さんぴ /賛否/
さんぴょう /散票/
さんぴん /三一/
さんふじんか /産婦人科/
さんぶ /三部/
さんぶかい /三部会/
さんぶさく /三部作/
さんぶつ /産物/
さんぶん /散文/三分/
さんぶんし /散文詩/
さんぶんてき /散文的/
さんぷ /散布/撒布/産婦/参府/
さんぷく /山腹/三伏/
さんぺい /散兵/
さんぺいじる /三平汁/
さんぺいせん /散兵線/
さんぺき /三碧/
さんぼう /参謀/三方/三宝/
さんぼうほんぶ /参謀本部/
さんぼだい /三菩提/
さんぼん /三本/
さんぼんぎ /三本木/
さんぼんすぎ /三本杉/
さんぽ /散歩/刪補/
さんぽう /算法/山砲/
さんま /秋刀魚/
さんまい /三枚/三昧/産米/
さんまいめ /三枚目/
さんまん /散漫/
さんみ /酸味/三位/
さんみいったい /三位一体/
さんみゃく /山脈/
さんみょう /三明/
さんめん /三面/
さんめんきじ /三面記事/
さんめんきょう /三面鏡/
さんめんろっぴ /三面六臂/
さんもうさく /三毛作/
さんもん /三文/山門/
さんもんきょう /三門峡/
さんもんばん /三文判/
さんや /山谷/山野/
さんやく /三役/散薬/纂訳/
さんゆうてい /三遊亭/
さんゆこく /産油国/
さんよ /参与/
さんよう /山陽/算用/山容/
さんようすうじ /算用数字/
さんようちゅう /三葉虫/
さんようどう /山陽道/
さんようほんせん /山陽本線/
さんらく /三楽/惨落/
さんらん /散乱/産卵/
さんらんけい /産卵鶏/
さんり /三里/
さんりく /三陸/
さんりくかいがん /三陸海岸/
さんりつ /簒立/
さんりづか /三里塚/
さんりゃく /三略/
さんりゅう /三流/
さんりょう /三稜/山陵/山稜/
さんりん /山林/三輪/
さんりんしゃ /三輪車/
さんりんぼう /三隣亡/
さんるい /三塁/
さんれい /山霊/山嶺/
さんれいごしん /三令五申/
さんれつ /参列/惨烈/
さんれん /三連/
さんれんせい /三連星/
さんろく /山麓/
さんわ /三和/
ざ /座/挫/坐/
ざい /財/在/罪/材/剤/
ざいあく /罪悪/
ざいい /在位/
ざいえき /在役/
ざいおう /在欧/
ざいか /在荷/財貨/罪科/罪過/
ざいかい /財界/
ざいかた /在方/
ざいかん /在官/
ざいがい /在外/
ざいがく /在学/
ざいきょう /在京/在郷/
ざいきん /在勤/
ざいきんてあて /在勤手当/
ざいけ /在家/
ざいけい /財形/財経/
ざいげん /財源/
ざいこ /在庫/
ざいこう /在校/
ざいこく /在国/
ざいごう /在郷/罪業/
ざいさん /財産/
ざいさんか /財産家/
ざいさんく /財産区/
ざいさんけい /財産刑/
ざいさんけん /財産権/
ざいさんぜい /財産税/
ざいさんそうぞく /財産相続/
ざいさんぶんり /財産分離/
ざいさんもくろく /財産目録/
ざいしつ /材質/在室/
ざいしゃ /在社/
ざいしゅう /罪囚/
ざいしゅく /在宿/
ざいしょ /在所/
ざいしょう /罪証/罪障/
ざいしょく /在職/
ざいじゅう /在住/
ざいじょう /罪状/
ざいす /座椅子/
ざいせい /財政/在世/
ざいせいがく /財政学/
ざいせいとうゆうし /財政投融資/
ざいせき /在籍/在席/材積/罪跡/
ざいぞく /在俗/
ざいたい /罪体/
ざいたく /在宅/
ざいだん /財団/
ざいだんさいけん /財団債権/
ざいだんほうじん /財団法人/
ざいちゅう /在中/
ざいちょう /在庁/
ざいてい /在廷/
ざいていしょうにん /在廷証人/
ざいてん /在天/
ざいにち /在日/
ざいにん /在任/罪人/
ざいのう /財嚢/
ざいはく /財帛/
ざいばつ /財閥/
ざいふ /在府/
ざいぶつ /財物/
ざいほう /財宝/罪報/
ざいむ /財務/
ざいむかんり /財務管理/
ざいめい /罪名/在銘/
ざいもく /材木/
ざいや /在野/
ざいよく /財欲/
ざいらい /在来/
ざいらいしゅ /在来種/
ざいらいせん /在来線/
ざいりゅう /在留/
ざいりょう /材料/
ざいりょく /財力/
ざいん /座員/
ざう /座右/
ざおう /蔵王/
ざおうさん /蔵王山/
ざか /座下/
ざが /坐臥/
ざがしら /座頭/
ざがね /座金/
ざきょう /座興/
ざくつ /座屈/
ざくろ /柘榴/石榴/
ざこ /雑喉/雑魚/
ざこう /座高/
ざこつ /坐骨/挫骨/
ざこね /雑魚寝/
ざこば /雑喉場/
ざさ /坐作/
ざし /座視/差し/
ざしき /座敷/
ざしきろう /座敷牢/
ざしきわらし /座敷童/
ざしょう /座礁/挫傷/坐礁/
ざせき /座席/
ざせつ /挫折/
ざぜん /座禅/坐禅/
ざぞう /座像/
ざたく /座卓/
ざだん /座談/
ざだんかい /座談会/
ざちゅう /座中/
ざちょう /座長/
ざっか /雑貨/
ざっかん /雑感/
ざっき /雑記/
ざっきちょう /雑記帳/
ざっきょ /雑居/
ざっきん /雑菌/
ざっけん /雑件/
ざっこう /雑考/
ざっこく /雑穀/
ざっさん /雑纂/
ざっし /雑誌/
ざっしゅ /雑種/
ざっしゅうにゅう /雑収入/
ざっしゅきょうせい /雑種強勢/
ざっしょ /雑書/
ざっしょく /雑食/雑色/
ざっそう /雑草/
ざっそく /雑則/
ざっそん /雑損/
ざった /雑多/
ざっとう /雑踏/雑沓/
ざっぱい /雑俳/
ざっぱく /雑駁/
ざっぴ /雑費/
ざっぴつ /雑筆/
ざっぽう /雑報/
ざつ /雑/
ざつえい /雑詠/
ざつえき /雑役/
ざつおん /雑音/
ざつかぶ /雑株/
ざつがく /雑学/
ざつき /座付/
ざつぎょう /雑業/
ざつしょとく /雑所得/
ざつじ /雑事/
ざつぜん /雑然/
ざつだい /雑題/
ざつだん /雑談/
ざつねん /雑念/
ざつのう /雑嚢/
ざつぶつ /雑物/
ざつぶん /雑文/
ざつぼく /雑木/
ざつむ /雑務/
ざつよう /雑用/
ざつろく /雑録/
ざつわ /雑話/
ざとう /座頭/
ざね /実/
ざひょう /座標/
ざひょうけい /座標系/
ざひょうじく /座標軸/
ざひょうへんかん /座標変換/
ざぶとん /座蒲団/
ざま /座間/
ざもち /座持ち/
ざやく /座薬/坐薬/
ざゆう /座右/
ざゆうのめい /座右の銘/
ざらがみ /ざら紙/
ざらめ /粗目/
ざる /笊/
ざるご /笊碁/
ざるそば /笊蕎麦/
ざれ /戯れ/
ざれい /座礼/
ざれうた /戯歌/
ざれごと /戯事/戯言/
ざん /残/暫/斬/惨/讒/
ざんえい /残映/
ざんかい /慚悔/
ざんかん /残寒/
ざんがい /残骸/残害/
ざんがく /残額/
ざんき /慙愧/慙悸/慚愧/
ざんきょう /残響/
ざんきょうじかん /残響時間/
ざんきん /残金/
ざんぎゃく /残虐/
ざんぎょう /残業/
ざんげ /懺悔/
ざんげつ /残月/
ざんげん /讒言/
ざんこう /残光/
ざんこく /残酷/
ざんこん /残痕/
ざんごう /塹壕/
ざんさ /残渣/
ざんさい /斬衰/残滓/
ざんさつ /惨殺/斬殺/
ざんざい /斬罪/
ざんし /残滓/惨死/慙死/
ざんしゃ /讒者/
ざんしゅ /斬首/
ざんしょ /残暑/
ざんしょう /残照/
ざんしん /斬新/残心/
ざんじ /暫時/
ざんせつ /残雪/
ざんぜん /嶄然/
ざんそ /讒訴/
ざんそん /残存/
ざんぞう /残像/
ざんだか /残高/
ざんち /残置/
ざんてい /暫定/
ざんていてき /暫定的/
ざんていよさん /暫定予算/
ざんてき /残敵/
ざんとう /残党/
ざんにん /残忍/
ざんねん /残念/残年/
ざんねんかい /残念会/
ざんばつ /斬伐/
ざんぱい /惨敗/
ざんぱつ /斬髪/
ざんぱん /残飯/
ざんぴん /残品/
ざんぶ /残部/
ざんぶつ /残物/
ざんぺん /残片/
ざんぼう /讒謗/残亡/
ざんぽん /残本/槧本/
ざんむ /残務/
ざんよ /残余/
ざんよざいさん /残余財産/
ざんりゅう /残留/
ざんりょう /残量/
ざんるい /残塁/
し /私/子/氏/指/紙/使/誌/死/旨/姿/姉/伺/至/師/歯/止/試/飼/雌/賜/資/諮/詩/詞/視/脂/肢/紫/糸/祉/枝/施/斯/支/思/志/市/屍/始/士/四/嗣/史/司/刺/仕/次/示/自/矢/巳/尸/巵/祠/緇/肆/諡/駟/梓/瓷/觜/贄/覗/獅/孜/仔/
しあい /試合/仕合/
しあげ /仕上げ/仕上/
しあさって /明明後日/
しあつ /指圧/
しあつほう /指圧法/
しあわせ /仕合せ/
しあん /思案/試案/私案/
しい /椎/恣意/私意/思惟/示威/肆意/四囲/四位/紫衣/詩意/
しいか /詩歌/
しいき /市域/
しいぎゃく /弑逆/
しいく /飼育/
しいそさん /尸位素餐/
しいたけ /椎茸/
しいて /強いて/
しいな /椎名/秕/粃/
しいば /椎葉/
しいれ /仕入れ/
しいん /子音/試飲/死因/私印/
しいんぎぞう /私印偽造/
しいんこうい /死因行為/
しいんぞうよ /死因贈与/
しうち /仕打ち/
しうと /舅/
しうとめ /姑/
しうん /紫雲/
しうんてん /試運転/
しえい /市営/私営/
しえき /使役/私益/
しえん /支援/紫煙/私怨/試演/
しえんかたんそ /四塩化炭素/
しお /汐/塩/潮/入/
しおあい /潮合/
しおあじ /塩味/
しおい /塩井/
しおう /四王/雌黄/
しおうてん /四王天/
しおかげん /塩加減/
しおかぜ /潮風/
しおから /塩辛/
しおからごえ /塩辛声/
しおがま /塩釜/
しおき /仕置/
しおぎ /塩木/
しおくみ /汐汲/
しおくり /仕送り/
しおけ /塩気/
しおけむり /潮煙/
しおこんぶ /塩昆布/
しおさい /潮騒/
しおさめ /仕納め/
しおざかい /潮境/
しおざけ /塩鮭/
しおざわ /塩沢/
しおじ /潮路/
しおじり /塩尻/
しおた /塩田/
しおだし /塩出し/
しおだち /塩断ち/
しおづけ /塩漬/
しおづる /塩鶴/
しおどき /潮時/
しおのみさき /潮岬/
しおのや /塩谷/
しおはま /塩浜/
しおばら /塩原/
しおひ /潮干/
しおひがり /潮干狩/
しおぶね /塩船/
しおまねき /潮招き/
しおみず /塩水/潮水/
しおもの /塩物/
しおや /塩屋/
しおやき /塩焼/
しおゆ /塩湯/
しおり /栞/撓/枝折/
しおん /紫苑/子音/師恩/
しか /鹿/歯科/史家/市価/紙価/雌花/爾/然/翅果/志賀/私家/子夏/
しかい /司会/視界/市会/死海/斯界/四海/
しかいけいてい /四海兄弟/
しかいしゃ /司会者/
しかえし /仕返し/
しかかり /仕掛り/
しかく /資格/視覚/四角/刺客/死角/視角/■/□/
しかくけい /四角形/
しかくごうま /四角号碼/
しかくしめん /四角四面/
しかけ /仕掛け/仕掛/
しかけひん /仕掛品/
しかざん /死火山/
しかし /然し/併し/
しかしながら /然し乍ら/
しかじか /云々/然々/然然/
しかず /如かず/若かず/
しかた /仕方/
しかっけい /四角形/
しかつ /死活/
しかの /鹿野/
しかばね /屍/
しかばん /私家版/
しかま /飾磨/
しかも /而も/然も/
しからずんば /然らずんば/
しからば /然らば/
しかり /然り/
しかれども /然れども/
しかれば /然れば/
しかん /弛緩/歯冠/仕官/士官/視感/篩管/私感/子癇/史官/屍姦/
しかんがっこう /士官学校/
しかんこうほせい /士官候補生/
しが /滋賀/志賀/歯牙/
しがい /市外/死骸/市街/屍骸/
しがいせん /紫外線/市街戦/
しがく /私学/史学/志学/詩学/
しがけん /滋賀県/
しがこうげん /志賀高原/
しがつ /四月/
しがつばか /四月馬鹿/
しがらき /信楽/
しがらみ /柵/
しがん /志願/此岸/
しき /色/式/識/織/敷/指揮/四季/死期/士気/始期/志木/志気/鋪/磯城/子規/私記/紙器/拭/
しきい /敷居/
しきいき /識閾/
しきいし /敷石/
しきいた /敷板/
しきうつし /敷写し/
しきかく /色覚/
しきかくいじょう /色覚異常/
しきかん /指揮官/色感/
しきがみ /式神/敷紙/
しきがわ /敷皮/
しききん /敷金/
しきぎょう /私企業/
しきけん /指揮権/識見/
しきご /識語/
しきさい /色彩/
しきさいかんかく /色彩感覚/
しきし /色紙/
しきしだい /式次第/
しきしま /敷島/磯城島/
しきしゃ /指揮者/識者/
しきしん /色神/
しきじ /式辞/式次/識字/
しきじつ /式日/
しきじゃく /色弱/
しきじょう /式場/色情/
しきじょうきょう /色情狂/
しきそ /色素/
しきそう /色相/
しきそくぜくう /色即是空/
しきだ /敷田/
しきだい /式台/
しきち /敷地/
しきちょう /色調/
しきてん /式典/
しきど /色度/
しきねじま /式根島/
しきねん /式年/
しきねんさい /式年祭/
しきふ /敷布/
しきふく /式服/
しきぶ /式部/
しきぶかん /式部官/
しきべつ /識別/
しきぼう /指揮棒/
しきま /色魔/
しきみ /樒/
しきめい /色名/
しきもう /色盲/
しきもの /敷物/
しきやみ /頻闇/
しきゅう /至急/支給/子宮/四球/死球/
しきゅうしき /始球式/
しきょ /死去/
しきょう /司教/市況/詩経/示教/至境/詩境/詩興/
しきょうひん /試供品/
しきょく /支局/四極/
しきり /仕切り/頻り/
しきりきん /仕切金/
しきりねだん /仕切値段/
しきりばいばい /仕切売買/
しきわら /敷藁/
しきん /資金/至近/試金/賜金/
しきんぐり /資金繰り/
しきんぐりひょう /資金繰り表/
しきんせき /試金石/
しぎ /鴫/仕儀/市議/思議/私議/鷸/
しぎかい /市議会/
しぎかいぎいん /市議会議員/
しぎさん /信貴山/
しぎゃく /嗜虐/弑逆/
しぎょう /始業/施業/斯業/執行/
しぎん /詩吟/市銀/
しく /市区/詩句/四苦/
しくつ /試掘/
しくはちがい /四衢八街/
しくはっく /四苦八苦/
しくみ /仕組み/
しぐさ /仕草/仕種/
しぐま /Σ/σ/
しぐれ /時雨/
しけい /死刑/私刑/紙型/
しけいおん /歯茎音/
しけつ /止血/
しけん /試験/私見/私権/
しけんかん /試験官/試験管/
しけんし /試験紙/
しけんじょう /試験場/
しけんだい /試験台/
しけんてき /試験的/
しけんへん /試験片/
しげ /繁/
しげい /至芸/
しげき /刺激/刺戟/史劇/詩劇/
しげく /繁く/
しげの /重野/滋野/
しげみ /茂み/繁み/
しげみつ /重光/
しげやま /繁山/茂山/
しげん /資源/始原/至言/
しこ /鬼/四股/醜/四庫/
しこう /指向/思考/試行/施行/嗜好/至高/志向/施工/歯垢/私行/紙工/伺候/支考/詩稿/
しこうきそく /施行規則/
しこうさくご /試行錯誤/
しこうして /而して/
しこうじっけん /思考実験/
しこうせい /指向性/志向性/
しこうひん /嗜好品/
しこうれい /施行令/
しこく /四国/
しこくさんち /四国山地/
しこくちほう /四国地方/
しこたん /色丹/
しこつ /死骨/肢骨/指骨/趾骨/歯骨/篩骨/
しこつおきな /醜つ翁/
しこつこ /支笏湖/
しこな /醜名/
しこのみたて /醜の御楯/
しこみ /仕込み/
しこめ /醜女/
しこり /凝/痼/
しころ /錏/錣/
しこん /紫紺/歯根/士魂/紫根/詩魂/
しこんしょうさい /士魂商才/
しご /死後/死語/私語/識語/
しごう /諡号/
しごく /至極/
しごこうちょく /死後硬直/
しごせん /子午線/
しごと /仕事/
しごとぎ /仕事着/
しごとし /仕事師/
しごとはじめ /仕事始め/
しごとば /仕事場/
しごとりつ /仕事率/
しごめん /子午面/
しさ /示唆/視差/
しさい /子細/司祭/仔細/市債/詩才/
しさく /試作/施策/思索/詩作/
しさつ /視察/刺殺/
しさん /資産/試算/四散/私産/
しさんか /資産家/
しさんちょうさ /資産調査/
しさんひょう /試算表/
しさんひょうか /資産評価/
しざ /視座/
しざい /資材/私財/死罪/資財/
しざん /死産/
しし /宍/獅子/四肢/死屍/肉/志士/子思/史詩/嗣子/
ししき /司式/
ししざ /獅子座/
ししそうしょう /師資相承/
ししつ /資質/紙質/脂質/私室/
ししとう /獅子唐/
ししばな /獅子鼻/
ししふんじん /獅子奮迅/
ししまい /獅子舞/
ししゃ /支社/死者/試写/使者/試射/
ししゃく /子爵/
ししゃごにゅう /四捨五入/
ししゃざい /止瀉剤/
ししゃのしょ /死者の書/
ししゃも /柳葉魚/
ししゅ /死守/旨趣/詩趣/
ししゅう /詩集/刺繍/死臭/屍臭/四周/
ししゅく /私淑/止宿/
ししゅつ /支出/
ししゅんき /思春期/
ししょ /支所/司書/支署/史書/私書/四書/詩書/
ししょう /支障/師匠/刺傷/死傷/視床/四生/私娼/指掌/師承/
ししょうかぶ /視床下部/
ししょうせつ /私小説/
ししょく /試食/
ししょごきょう /四書五経/
ししょばこ /私書箱/
ししん /私信/指針/私心/視診/至心/使臣/
ししんけい /視神経/
ししんでん /紫宸殿/
しじ /指示/支持/私事/師事/榻/指事/指似/死児/
しじご /指示語/
しじつ /史実/
しじつたい /子実体/
しじま /静寂/黙/
しじみ /蜆/
しじやく /指示薬/
しじゅう /始終/四重/
しじゅうから /四十雀/
しじゅうくにち /四十九日/
しじゅうしちし /四十七士/
しじゅうしょう /四重唱/
しじゅうそう /四重奏/
しじゅうはって /四十八手/
しじゅく /私塾/
しじゅつ /施術/
しじゅほうしょう /紫綬褒章/
しじゅんかせき /示準化石/
しじゅんせつ /四旬節/
しじょ /子女/
しじょう /史上/市場/至上/私情/詩情/試乗/紙上/誌上/市上/四条/糸状/至情/
しじょうかかく /市場価格/
しじょうかち /市場価値/
しじょうけいざい /市場経済/
しじょうちょうさ /市場調査/
しじょうなわて /四条畷/
しじょうめいれい /至上命令/
しじん /詩人/私人/士人/
しすい /止水/泗水/
しすう /指数/
しすうかんすう /指数関数/
しすうほうそく /指数法則/
しず /静/志津/
しずい /雌蕊/歯髄/
しずおか /静岡/
しずおかけん /静岡県/
しずおかし /静岡市/
しずか /閑か/静か/静/
しずがたけ /賤ヶ岳/
しずく /滴/雫/
しずけさ /静けさ/
しずごころ /静心/
しずしず /静々/
しずめ /沈め/鎮め/
しせい /姿勢/四声/至誠/市制/市政/施政/私製/市勢/市井/私生/刺青/雌性/死生/氏姓/詩聖/資性/
しせいかつ /私生活/
しせいかん /司政官/
しせいけん /施政権/
しせいじ /私生児/
しせいせいど /氏姓制度/
しせいだい /始生代/
しせいはがき /私製葉書/
しせき /史跡/歯石/史籍/
しせつ /施設/私設/使節/私説/士節/
しせん /視線/支線/死線/四川/私撰/私選/脂腺/詩仙/
しせんどう /詩仙堂/
しせんべんごにん /私選弁護人/
しぜい /市税/
しぜん /自然/至善/
しぜんかい /自然界/
しぜんかがく /自然科学/
しぜんがく /自然学/
しぜんげんご /自然言語/
しぜんげんしょう /自然現象/
しぜんこう /自然光/
しぜんこうえん /自然公園/
しぜんさいがい /自然災害/
しぜんし /自然死/自然史/
しぜんしんろん /自然神論/
しぜんじん /自然人/
しぜんすう /自然数/
しぜんたい /自然体/
しぜんたいすう /自然対数/
しぜんてつがく /自然哲学/
しぜんとうた /自然淘汰/
しぜんのうほう /自然農法/
しぜんはっか /自然発火/
しぜんはっせい /自然発生/
しぜんはん /自然犯/
しぜんぶつ /自然物/
しぜんほう /自然法/
しぜんほうそく /自然法則/
しぜんほご /自然保護/
しそ /始祖/紫蘇/
しそう /思想/試走/使嗾/志操/死相/歯槽/詩想/
しそうか /思想家/
しそうかい /思想界/
しそうのうろう /歯槽膿漏/
しそうはん /思想犯/
しそく /四則/子息/四足/
しそちょう /始祖鳥/
しそつ /士卒/
しそん /子孫/至尊/
しぞう /死蔵/私蔵/
しぞく /士族/氏族/
した /下/舌/↓/
したあご /下顎/
したあじ /下味/
したい /死体/姿態/肢体/屍体/詩体/
したいふ /士大夫/
したうけ /下請/
したうけにん /下請人/
したうち /舌打ち/
したえ /下絵/
したおび /下帯/
したかた /下方/
したがき /下書き/
したがって /従って/
したがり /下刈り/
したぎ /下着/
したく /仕度/支度/私宅/
したくきん /支度金/
したくさ /下草/
したくちびる /下唇/
したぐつ /襪/
したぐみ /下組み/
したけんぶん /下検分/
したげいこ /下稽古/
したごころ /下心/
したごしらえ /下拵え/
したさき /舌先/
したざわり /舌触り/
したし /親し/
したしく /親しく/
したしごと /下仕事/
したしょく /下職/
したしらべ /下調べ/
したじ /下地/
したじき /下敷/
したじゅんび /下準備/
したず /下図/
したそうだん /下相談/
したたか /強か/健か/
したため /認め/
したたらず /舌足らず/
しただい /舌代/
したっぱ /下っ端/
したっぱら /下っ腹/
したつけ /下付/
したつづみ /舌鼓/
したづつみ /舌鼓/
したづみ /下積み/
したて /仕立て/下手/
したてだしなげ /下手出し投げ/
したてなげ /下手投げ/
したてひねり /下手捻り/
したてもの /仕立物/
したてや /仕立屋/
したどり /下取り/
したぬり /下塗り/
したね /下値/
したのね /舌の根/
したはら /下腹/
したば /下葉/下端/
したばき /下履/
したばたらき /下働き/
したばなし /下話/
したび /下火/
したまえ /下前/
したまち /下町/
したみ /下見/
したみち /下道/
したむき /下向き/
しため /下目/
したや /下谷/
したやく /下役/
したよみ /下読み/
したりがお /したり顔/
したん /紫檀/
しだ /志太/志田/羊歯/
しだい /次第/私大/四大/
しだし /仕出し/
しだしょくぶつ /羊歯植物/
しだれざくら /垂れ桜/
しだれやなぎ /垂れ柳/
しだん /指弾/師団/詩壇/史談/
しち /質/七/死地/
しちいれ /質入れ/
しちいれうらがき /質入裏書/
しちいれしょうけん /質入証券/
しちうけ /質請け/
しちかいき /七回忌/
しちがつ /七月/
しちく /紫竹/
しちぐさ /質草/
しちけい /七経/
しちけん /質権/
しちけんしゃ /質権者/
しちごさん /七五三/
しちごちょう /七五調/
しちごん /七言/
しちさん /七三/
しちしゃ /七社/
しちしょ /七書/
しちしょう /七生/
しちじゅう /七重/
しちじょう /七条/
しちせい /七星/
しちせき /七赤/
しちてんばっとう /七転八倒/
しちどうがらん /七堂伽藍/
しちながれ /質流れ/
しちなん /七難/
しちなんはっく /七難八苦/
しちねん /七年/
しちふくじん /七福神/
しちふだ /質札/
しちぶ /七分/
しちへんげ /七変化/
しちほのさい /七歩の才/
しちほん /七本/
しちめんちょう /七面鳥/
しちめんどう /七面倒/
しちゃく /試着/
しちや /質屋/七夜/
しちゅう /市中/支柱/死中/
しちゅうぎんこう /市中銀行/
しちゅうこん /支柱根/
しちょう /市長/試聴/視聴/市庁/思潮/支庁/輜重/
しちょうかく /視聴覚/
しちょうかくしつ /視聴覚室/
しちょうしゃ /視聴者/
しちょうそん /市町村/
しちょうそんぎかい /市町村議会/
しちょうそんぜい /市町村税/
しちょうそんちょう /市町村長/
しちょうねつ /弛張熱/
しちょうへい /輜重兵/
しちょうゆそつ /輜重輸卒/
しちょうりつ /視聴率/
しちょく /司直/
しちょっけい /視直径/
しちよう /七曜/
しちようせい /七曜星/
しちり /七里/
しちりん /七輪/
しっか /失火/膝下/
しっかい /悉皆/
しっかく /失格/
しっかり /確り/聢り/
しっかん /疾患/失陥/
しっき /漆器/湿気/
しっきゃく /失脚/
しっきん /失禁/
しっく /疾駆/
しっくい /漆喰/
しっけ /湿気/
しっけい /失敬/
しっけつ /失血/
しっけん /識見/失権/執権/
しっこ /疾呼/
しっこう /執行/失効/
しっこうかん /執行官/
しっこうきかん /執行機関/
しっこうけん /執行権/
しっこうこうい /執行行為/
しっこうしょぶん /執行処分/
しっこうていし /執行停止/
しっこうぶ /執行部/
しっこうゆうよ /執行猶予/
しっこうりょく /執行力/
しっこく /漆黒/桎梏/
しっこし /尻腰/
しっさく /失策/
しっしき /湿式/
しっしっ /叱叱/
しっしょう /失笑/
しっしょく /失職/
しっしん /失神/湿疹/
しっせい /失政/叱正/叱声/執政/湿性/
しっせいかん /執政官/
しっせき /叱責/失跡/
しっそ /質素/
しっそう /失踪/疾走/執奏/
しっそうせんこく /失踪宣告/
しっそく /失速/
しった /叱咤/
しったい /失態/
しったかぶり /知ったか振り/
しったん /悉曇/
しっち /湿地/失地/
しっちょう /失調/
しっちんまんぽう /七珍万宝/
しっつい /失墜/
しってん /失点/
しってんばっとう /七転八倒/
しっと /嫉妬/
しっとう /失投/執刀/失当/
しっぱい /失敗/
しっぴ /櫛比/失費/
しっぴつ /執筆/
しっぷ /湿布/
しっぷう /疾風/
しっぷうじんらい /疾風迅雷/
しっぷうもくう /櫛風沐雨/
しっぺい /疾病/
しっぽ /尻尾/
しっぽう /七宝/
しっぽうやき /七宝焼/
しっぽく /卓袱/
しっぽくりょうり /卓袱料理/
しつ /失/質/疾/漆/湿/悉/室/執/叱/瑟/嫉/
しつい /失意/
しつう /止痛/私通/歯痛/
しつうはったつ /四通八達/
しつおん /室温/
しつかん /質感/
しつかんせつ /膝関節/
しつがい /室外/膝蓋/
しつがいこつ /膝蓋骨/
しつぎ /質疑/
しつぎおうとう /質疑応答/
しつぎょう /失業/
しつぎょうしゃ /失業者/
しつぎょうほけん /失業保険/
しつぎょうりつ /失業率/
しつげい /漆芸/
しつげん /失言/湿原/
しつご /失語/
しつごしょう /失語症/
しつじ /執事/
しつじつ /質実/
しつじゅん /湿潤/
しつちょう /室長/
しつてき /質的/
しつてん /質点/
しつでん /湿田/
しつど /湿度/
しつどくしょう /失読症/
しつどけい /湿度計/
しつない /室内/
しつないがく /室内楽/
しつねん /失念/
しつば /叱罵/
しつぼう /失望/
しつむ /執務/
しつめい /失明/
しつもん /質問/
しつよう /執拗/
しつらえ /設え/
しつりょう /質量/質料/
しつりょうすう /質量数/
しつれい /失礼/
しつれん /失恋/
しづ /志津/
しづき /志筑/
して /仕手/
してい /指定/師弟/私邸/姉弟/子弟/視程/
していしょく /指定職/
していせき /指定席/
していとし /指定都市/
していめいがら /指定銘柄/
してかぶ /仕手株/
してき /指摘/私的/詩的/史的/
してきゆいぶつろん /史的唯物論/
してつ /私鉄/
してん /視点/支店/始点/支点/祀典/
してんのう /四天王/
してんのうじ /四天王寺/
しで /死出/
しでのたび /死出の旅/
しでのやま /死出の山/
しではら /幣原/
しでむし /埋葬虫/
しでん /市電/紫電/史伝/
しでんいっせん /紫電一閃/
しと /使途/使徒/司徒/尿/
しとう /死闘/至当/私党/私闘/紫藤/
しとく /四徳/至徳/
しとど /鵐/
しとね /褥/
しとみ /蔀/
しとみや /蔀屋/
しとやか /淑やか/
しど /示度/
しどう /指導/始動/私道/市道/士道/斯道/
しどうどうき /示導動機/
しどり /倭文/
しな /品/支那/科/
しない /市内/竹刀/
しなうす /品薄/
しなかず /品数/
しながき /品書/
しながら /品柄/
しながれ /品枯れ/
しながわ /品川/
しなぎれ /品切れ/
しなさだめ /品定め/
しなじな /品々/
しなじへん /支那事変/
しなぞろえ /品揃え/
しなだま /品玉/
しなの /信濃/
しなのがわ /信濃川/
しなのじ /信濃路/
しなもの /品物/
しなん /至難/指南/
しなんばん /指南番/
しなんやく /指南役/
しにがお /死に顔/
しにがね /死に金/
しにぎわ /死に際/
しにく /屍肉/
しにくえん /歯肉炎/
しにざま /死に様/
しにしょうぞく /死装束/
しにせ /老舗/
しにぞこない /死に損い/
しにどき /死に時/
しにはじ /死に恥/
しにばしょ /死に場所/
しにばな /死に花/
しにみ /死に身/
しにみず /死に水/
しにめ /死に目/
しにものぐるい /死に物狂い/
しにょう /屎尿/
しにわかれ /死に別れ/
しにん /死人/視認/
しねん /思念/
しの /篠/志野/
しのう /子嚢/
しのうこうしょう /士農工商/
しのがき /篠垣/
しのぎ /鎬/凌ぎ/篠木/
しのぎじ /鎬地/
しのごの /四の五の/
しのざき /篠崎/
しのしょうにん /死の商人/
しのだ /信田/
しのだけ /篠竹/
しののい /篠ノ井/
しののめ /東雲/
しのはら /篠原/
しのばずのいけ /不忍池/
しのび /忍び/
しのびあし /忍び足/
しのびあるき /忍び歩き/
しのびごえ /忍び声/
しのびなき /忍び泣き/
しのびわらい /忍び笑い/
しのぶ /忍/信夫/
しのぶえ /篠笛/
しはい /支配/賜杯/紙背/
しはいかいきゅう /支配階級/
しはいけん /支配権/
しはいにん /支配人/
しはす /師走/
しはつ /始発/
しはらい /支払い/
しはらいかんじょう /支払勘定/
しはらいち /支払地/
しはらいていし /支払停止/
しはらいてがた /支払手形/
しはらいにん /支払人/
しはらいほしょう /支払保証/
しはん /市販/師範/四半/紫斑/死斑/私版/
しはんき /四半期/
しはんだい /師範代/
しはんびょう /紫斑病/
しはんぶん /四半分/
しば /芝/柴/司馬/死馬/斯波/
しばい /芝居/
しばいえ /芝居絵/
しばいぎ /芝居気/
しばいぢゃや /芝居茶屋/
しばいぬ /柴犬/
しばうら /芝浦/
しばかり /柴刈り/芝刈り/
しばがき /柴垣/
しばき /柴木/
しばくさ /芝草/
しばこうえん /芝公園/
しばし /暫し/
しばしば /屡/
しばた /柴田/新発田/
しばち /芝地/
しばの /柴野/芝野/
しばはし /柴橋/
しばはま /芝浜/
しばはら /芝原/
しばふ /芝生/
しばまた /柴又/
しばやま /柴山/芝山/
しばらく /暫く/
しばりくび /縛り首/
しばん /篩板/
しばんむし /死番虫/
しひ /私費/市費/詩碑/
しひつ /史筆/紙筆/
しひゃくしびょう /四百四病/
しひょう /指標/死票/
しび /至微/
しびと /死人/
しびょう /死病/
しびょうし /四拍子/
しびれ /痺れ/
しびん /溲瓶/
しふ /師父/詩賦/
しふく /私服/雌伏/至福/私腹/紙幅/
しふん /私憤/脂粉/
しぶ /渋/支部/市部/篩部/四分/四部/
しぶいち /四分一/
しぶえ /渋江/
しぶかわ /渋川/渋皮/
しぶがき /渋柿/
しぶがっしょう /四部合唱/
しぶき /渋木/
しぶくさ /渋草/
しぶさわ /渋沢/
しぶしぶ /渋々/
しぶちゃ /渋茶/
しぶつ /私物/死物/
しぶぬき /渋抜き/
しぶみ /渋み/
しぶや /渋谷/
しぶり /仕振り/
しぶりばら /渋り腹/
しぶろく /四分六/
しぶん /詩文/死文/士分/四分/
しぶんぎ /四分儀/
しぶんごれつ /四分五裂/
しぶんしょ /私文書/
しへい /紙幣/子平/私兵/
しへき /四壁/
しへん /詩篇/紙片/四辺/
しへんけい /四辺形/
しべ /蕊/蘂/
しべつ /士別/死別/
しべん /思弁/支弁/至便/
しほ /試補/
しほう /四方/司法/至宝/死法/私法/
しほういいん /司法委員/
しほうかん /司法官/
しほうきかん /司法機関/
しほうきょうじょ /司法共助/
しほうぎょうせい /司法行政/
しほうけん /司法権/
しほうしけん /司法試験/
しほうしょし /司法書士/
しほうじん /私法人/
しほうどうぶつ /刺胞動物/
しほうはっぽう /四方八方/
しほん /資本/紙本/
しほんか /資本家/
しほんかんじょう /資本勘定/
しほんきん /資本金/
しほんさんか /資本参加/
しほんざい /資本財/
しほんしじょう /資本市場/
しほんしゅぎ /資本主義/
しほんじょうよきん /資本剰余金/
しほんちくせき /資本蓄積/
しほんとりひき /資本取引/
しほんろん /資本論/
しぼ /思慕/私募/皺/
しぼう /脂肪/死亡/志望/子房/
しぼうさいぼう /脂肪細胞/
しぼうさん /脂肪酸/
しぼうしんだんしょ /死亡診断書/
しぼうほけん /死亡保険/
しぼうゆ /脂肪油/
しぼうりつ /死亡率/
しぼつ /死没/死歿/
しぼり /絞り/
しま /縞/島/志摩/揣摩/嶋/
しまい /姉妹/仕舞/
しまいご /姉妹語/
しまいとし /姉妹都市/
しまいへん /姉妹編/
しまお /島尾/
しまおくそく /揣摩臆測/
しまかげ /島陰/島影/
しまかぜ /島風/
しまがくれ /島隠れ/
しまがら /縞柄/
しまき /島木/
しまぐに /島国/
しまさき /島崎/
しまざき /島崎/
しまざきとうそん /島崎藤村/
しまじ /島地/
しまず /島津/
しまだ /島田/
しまつ /始末/
しまつしょ /始末書/
しまづ /島津/
しまづたい /島伝い/
しまなか /嶋中/
しまながし /島流し/
しまね /島根/
しまねけん /島根県/
しまのうち /島之内/
しまばら /島原/
しまばらじょう /島原城/
しまばらはんとう /島原半島/
しままつ /島松/
しまむら /島村/
しまもよう /縞模様/
しまもり /島守/
しまやま /島山/
しまりや /締り屋/
しまんとがわ /四万十川/
しみ /衣魚/紙魚/染み/凍み/
しみず /清水/
しみどうふ /凍み豆腐/
しみぬき /染み抜き/
しみゃく /支脈/
しみょう /至妙/
しみん /市民/嗜眠/
しみんうんどう /市民運動/
しみんけん /市民権/
しみんしゃかい /市民社会/
しみんぜい /市民税/
しむけ /仕向け/
しむけち /仕向け地/
しめ /締め/
しめい /氏名/指名/使命/指命/死命/
しめいかん /使命感/
しめいさいけん /指名債権/
しめいすいせん /指名推選/
しめいだしゃ /指名打者/
しめいてはい /指名手配/
しめがね /締金/
しめきり /締切り/
しめし /示し/
しめすへん /示偏/
しめつ /死滅/
しめつけ /締付け/
しめなわ /注連縄/
しめり /湿り/
しめりごえ /湿り声/
しめん /紙面/誌面/四面/
しめんそか /四面楚歌/
しめんたい /四面体/
しも /下/霜/
しもう /刺毛/
しもうさ /下総/
しもおか /下岡/
しもかた /下方/
しもがこい /霜囲い/
しもがもじんじゃ /下鴨神社/
しもがれ /霜枯れ/
しもき /下期/
しもきたはんとう /下北半島/
しもぎょう /下京/
しもく /四木/
しもこうべ /下河辺/
しもごえ /下肥/
しもさか /下坂/
しもざ /下座/
しもじも /下々/下下/
しもだ /下田/
しもだて /下館/
しもつき /霜月/
しもつけ /下野/
しもつま /下妻/
しもて /下手/
しもなか /下中/
しもにた /下仁田/
しものく /下の句/
しものせき /下関/
しもはんき /下半期/
しもはんしん /下半身/
しもばしら /霜柱/
しもべ /下部/僕/
しもむ /下無/
しもむら /下村/
しもやけ /霜焼け/
しもやしき /下屋敷/
しもん /諮問/指紋/試問/
しゃ /車/者/社/煮/写/斜/遮/謝/紗/赦/捨/射/舎/砂/奢/洒/瀉/
しゃい /謝意/斜位/
しゃいん /社員/
しゃうん /社運/
しゃえい /射影/写影/
しゃおく /社屋/
しゃおん /謝恩/遮音/
しゃか /釈迦/
しゃかい /社会/
しゃかいあく /社会悪/
しゃかいいしき /社会意識/
しゃかいか /社会科/社会化/
しゃかいかがく /社会科学/
しゃかいがく /社会学/
しゃかいきょういく /社会教育/
しゃかいけん /社会権/
しゃかいげんしょう /社会現象/
しゃかいこうがく /社会工学/
しゃかいこうぞう /社会構造/
しゃかいしほん /社会資本/
しゃかいしゅぎ /社会主義/
しゃかいしんりがく /社会心理学/
しゃかいじん /社会人/
しゃかいせい /社会性/
しゃかいせいど /社会制度/
しゃかいたいせい /社会体制/
しゃかいちつじょ /社会秩序/
しゃかいつうねん /社会通念/
しゃかいてき /社会的/
しゃかいとう /社会党/
しゃかいふくし /社会福祉/
しゃかいふっき /社会復帰/
しゃかいほう /社会法/
しゃかいほうし /社会奉仕/
しゃかいほけん /社会保険/
しゃかいほしょう /社会保障/
しゃかいめん /社会面/
しゃかいもんだい /社会問題/
しゃかく /射角/斜格/
しゃかくきん /斜角筋/
しゃかさんぞん /釈迦三尊/
しゃかっこう /斜滑降/
しゃかどう /釈迦堂/
しゃかにょらい /釈迦如来/
しゃかん /舎監/
しゃがい /社外/
しゃがん /斜眼/
しゃき /社旗/
しゃきょう /写経/
しゃきょり /射距離/
しゃきん /謝金/
しゃぎ /謝儀/
しゃぎょう /社業/
しゃく /釈/借/尺/石/爵/酌/杓/錫/昔/勺/赤/笏/癪/灼/
しゃくい /爵位/
しゃくぎ /釈義/
しゃくざい /借財/
しゃくし /杓子/
しゃくしじょうぎ /杓子定規/
しゃくじょう /錫杖/
しゃくすん /尺寸/
しゃくせん /借銭/
しゃくぜん /釈然/
しゃくそん /釈尊/
しゃくち /借地/尺地/
しゃくちけん /借地権/
しゃくちほう /借地法/
しゃくとりむし /尺取虫/
しゃくど /尺度/
しゃくどう /赤銅/
しゃくどういろ /赤銅色/
しゃくなが /尺長/
しゃくねつ /灼熱/
しゃくはち /尺八/
しゃくふ /酌婦/
しゃくぶく /折伏/
しゃくほう /釈放/
しゃくま /借間/
しゃくめい /釈明/
しゃくや /借家/
しゃくやく /芍薬/
しゃくやにん /借家人/
しゃくよう /借用/
しゃくらん /借覧/
しゃくりょう /酌量/借料/
しゃけ /鮭/社家/
しゃけい /舎兄/
しゃけつ /瀉血/
しゃけん /車検/
しゃげき /射撃/
しゃこ /車庫/蝦蛄/鷓鴣/
しゃこう /社交/斜行/遮光/
しゃこうかい /社交界/
しゃこうしん /射幸心/射倖心/
しゃこうじれい /社交辞令/
しゃこうせい /社交性/
しゃこうてき /社交的/
しゃこく /社告/
しゃこたんはんとう /積丹半島/
しゃさい /社債/車載/
しゃさいけん /社債券/
しゃさつ /射殺/
しゃざい /謝罪/
しゃし /斜視/奢侈/奢恣/奢肆/
しゃしゃく /車借/
しゃしゅ /射手/社主/
しゃしゅつ /射出/
しゃしょう /車掌/捨象/社章/
しゃしょく /写植/
しゃしん /写真/
しゃしんうつり /写真写り/
しゃしんか /写真家/
しゃしんかん /写真館/
しゃしんき /写真機/
しゃしんはんてい /写真判定/
しゃしんばん /写真版/
しゃしんや /写真屋/
しゃじ /謝辞/社寺/写字/
しゃじく /車軸/
しゃじせい /写字生/
しゃじつ /写実/
しゃじつしゅぎ /写実主義/
しゃじつてき /写実的/
しゃじょう /謝状/車上/射場/赦状/
しゃせい /射精/写生/
しゃせいが /写生画/
しゃせいご /写声語/
しゃせつ /社説/
しゃせん /車線/斜線/社線/
しゃぜ /社是/
しゃぜつ /謝絶/
しゃそう /社葬/車窓/
しゃそく /社則/
しゃぞう /写像/
しゃたい /車体/斜体/
しゃたく /社宅/
しゃだつ /洒脱/
しゃだん /社団/遮断/
しゃだんき /遮断機/遮断器/
しゃだんほうじん /社団法人/
しゃち /鯱/
しゃちほこ /鯱/
しゃちゅう /車中/社中/
しゃちょう /社長/
しゃっか /借家/
しゃっかにん /借家人/
しゃっかん /借款/
しゃっかんほう /尺貫法;尺、升、貫の単位を使用するわが国古来の度量衡法/
しゃっきん /借金/
しゃっく /赤口/
しゃっけい /借景/
しゃっこう /赤光/赤口/
しゃっこつ /尺骨/
しゃてい /射程/舎弟/
しゃてき /射的/
しゃでん /社殿/
しゃどう /車道/
しゃない /社内/車内/
しゃないとう /車内灯/
しゃないほう /社内報/
しゃにくさい /謝肉祭/
しゃにむに /遮二無二/
しゃはん /這般/
しゃば /娑婆/車馬/
しゃひ /社費/舎費/
しゃび /奢靡/
しゃふ /写譜/車夫/
しゃふく /車幅/
しゃふつ /煮沸/
しゃへい /遮蔽/
しゃへん /斜辺/
しゃほん /写本/
しゃまく /紗幕/
しゃみ /三味/沙弥/
しゃみせん /三味線/
しゃむ /暹羅/社務/
しゃむしょ /社務所/
しゃめい /社名/社命/
しゃめん /斜面/赦免/
しゃも /軍鶏/
しゃもん /沙門/
しゃゆう /社友/
しゃよう /社用/斜陽/
しゃようぞく /社用族/
しゃらく /写楽/
しゃらそうじゅ /娑羅双樹/
しゃり /舎利/射利/
しゃりき /車力/
しゃりょう /車両/車輛/社領/
しゃりん /車輪/
しゃれ /洒落/
しゃれい /謝礼/
しゃれぼん /洒落本/
しゃんはい /上海/
しや /視野/
しやきょうさく /視野狭窄/
しやく /試薬/
しやくしょ /市役所/
しゅ /手/主/種/修/首/酒/取/趣/腫/珠/狩/殊/朱/守/衆/銖/株/須/
しゅ> /主/
しゅーまい /焼売/
しゅい /首位/主意/趣意/主位/
しゅいしょ /趣意書/
しゅいろ /朱色/
しゅいん /主因/手淫/朱印/
しゅいんじょう /朱印状/
しゅう /集/修/週/秋/祝/拾/習/醜/酬/襲/衆/舟/臭/終/秀/洲/愁/州/就/宗/周/収/囚/執/羞/聚/袖/輯/蹴/繍/讐/蒐/酋/
しゅうあく /醜悪/
しゅうあけ /週明け/
しゅうい /周囲/拾遺/衆意/
しゅういつ /秀逸/
しゅういん /衆院/秋陰/
しゅうう /驟雨/秋雨/
しゅううん /舟運/
しゅうえい /秀英/
しゅうえき /収益/就役/
しゅうえん /終焉/終演/周縁/
しゅうお /羞悪/
しゅうおんらい /周恩来/
しゅうか /集荷/衆寡/秀歌/集貨/
しゅうかい /集会/周回/醜怪/
しゅうかく /収穫/臭覚/
しゅうかくていげん /収穫逓減/
しゅうかすいそ /臭化水素/
しゅうかぶつ /臭化物/
しゅうかへいげつ /羞花閉月/
しゅうかん /週間/習慣/週刊/収監/終刊/終巻/
しゅうかんし /週刊誌/
しゅうがく /修学/就学/
しゅうがくりつ /就学率/
しゅうがくりょこう /修学旅行/
しゅうき /秋季/周期/周忌/終期/臭気/秋期/秋気/
しゅうきうんどう /周期運動/
しゅうきかんすう /周期関数/
しゅうきてき /周期的/
しゅうきゅう /週休/蹴球/週給/
しゅうきょう /宗教/
しゅうきょうか /宗教家/
しゅうきょうが /宗教画/
しゅうきょうがく /宗教学/
しゅうきょうしん /宗教心/
しゅうきょく /終曲/終局/褶曲/終極/
しゅうきりつ /周期律/
しゅうきん /集金/
しゅうぎ /祝儀/衆議/宗義/
しゅうぎいん /衆議院/
しゅうぎいんぎいん /衆議院議員/
しゅうぎょう /就業/終業/修業/
しゅうぎょうきそく /就業規則/
しゅうぎん /秀吟/
しゅうく /秀句/
しゅうぐ /衆愚/
しゅうぐせいじ /衆愚政治/
しゅうけい /集計/
しゅうけつ /終結/集結/
しゅうけん /集権/
しゅうげき /襲撃/
しゅうげつ /秋月/
しゅうげん /祝言/
しゅうこう /周航/就航/修好/醜行/舟行/舟航/衆口/
しゅうこうてん /周口店/
しゅうこつ /収骨/
しゅうごう /集合/習合/
しゅうごうか /集合果/
しゅうごうがいねん /集合概念/
しゅうごうぞく /集合族/
しゅうごうはん /集合犯/
しゅうごうぶつ /集合物/
しゅうごうろん /集合論/
しゅうさ /収差/
しゅうさい /秀才/収載/
しゅうさく /秀作/習作/
しゅうさつ /集札/
しゅうさん /集散/蓚酸/
しゅうさんかじょ /集散花序/
しゅうさんき /周産期/
しゅうさんち /集散地/
しゅうざい /集材/秋材/
しゅうし /修士/収支/終始/宗旨/終止/修史/
しゅうしいっかん /終始一貫/
しゅうしかてい /修士課程/
しゅうしけい /終止形/
しゅうしふ /終止符/
しゅうしゃ /終車/
しゅうしゅう /蒐集/収集/収拾/拾集/集輯/啾啾/
しゅうしゅく /収縮/
しゅうしゅぼうかん /袖手傍観/
しゅうしょ /集書/
しゅうしょう /愁傷/周章/就床/秋宵/
しゅうしょく /就職/修飾/秋色/愁色/襲職/
しゅうしょくぐち /就職口/
しゅうしょくご /修飾語/
しゅうしょくなん /就職難/
しゅうしん /就寝/執心/終身/修身/終審/
しゅうしんけい /終身刑/
しゅうしんこよう /終身雇用/
しゅうしんねんきん /終身年金/
しゅうじ /習字/修辞/
しゅうじがく /修辞学/
しゅうじつ /終日/週日/秋日/
しゅうじゅ /収受/
しゅうじゅく /習熟/
しゅうじょ /醜女/
しゅうじょう /醜状/
しゅうじょく /就褥/
しゅうじょし /終助詞/
しゅうじん /囚人/衆人/
しゅうじんかんし /衆人環視/
しゅうすい /秋水/
しゅうせい /修正/習性/修整/集成/終世/終生/秋声/
しゅうせいざい /集成材/
しゅうせいしゅぎ /修正主義/
しゅうせき /集積/
しゅうせきかいろ /集積回路/
しゅうせきてん /集積点/
しゅうせん /周旋/終戦/鞦韆/
しゅうせんぎょう /周旋業/
しゅうせんや /周旋屋/
しゅうぜい /収税/
しゅうぜつ /秀絶/
しゅうぜん /修繕/
しゅうそ /臭素/愁訴/宗祖/
しゅうそう /秋霜/
しゅうそうれつじつ /秋霜烈日/
しゅうそく /収束/集束/終息/終熄/
しゅうそん /集村/
しゅうぞう /収蔵/修造/
しゅうぞく /習俗/
しゅうたい /醜態/
しゅうたいせい /集大成/
しゅうたん /愁嘆/
しゅうたんば /愁嘆場/
しゅうだつ /収奪/
しゅうだん /集団/
しゅうち /周知/習知/衆知/
しゅうちく /修築/
しゅうちしん /羞恥心/
しゅうちゃく /執着/終着/祝着/
しゅうちゃくえき /終着駅/
しゅうちゅう /集中/
しゅうちゅうごうう /集中豪雨/
しゅうちゅうほうか /集中砲火/
しゅうちょう /酋長/
しゅうちん /袖珍/
しゅうちんばん /聚珍版/
しゅうちんぼん /袖珍本/
しゅうづら /主面/
しゅうてい /舟艇/修訂/
しゅうてん /終点/秋天/
しゅうでん /終電/
しゅうでんしゃ /終電車/
しゅうと /姑/舅/州都/宗徒/衆徒/囚徒/
しゅうとう /周到/
しゅうとく /修得/習得/収得/拾得/
しゅうとくぜい /収得税/
しゅうとくぶつ /拾得物/
しゅうとめ /姑/
しゅうどう /修道/
しゅうどういん /修道院/
しゅうどうし /修道士/
しゅうどうじょ /修道女/
しゅうにゅう /収入/
しゅうにゅういんし /収入印紙/
しゅうにゅうやく /収入役/
しゅうにん /就任/
しゅうねん /周年/執念/終年/
しゅうのう /収納/
しゅうは /宗派/周波/秋波/
しゅうはい /集配/
しゅうはすう /周波数/
しゅうはつ /終発/
しゅうばく /就縛/
しゅうばつ /秀抜/
しゅうばん /終盤/終板/週番/
しゅうひょう /衆評/
しゅうび /愁眉/秀眉/秀美/
しゅうふ /醜婦/
しゅうふう /宗風/秋風/
しゅうふく /修復/
しゅうふつ /修祓/
しゅうぶん /秋分/醜聞/
しゅうぶんてん /秋分点/
しゅうぶんのひ /秋分の日/
しゅうへい /衆兵/
しゅうへき /習癖/周壁/
しゅうへん /周辺/
しゅうへんし /周辺視/
しゅうへんそうち /周辺装置/
しゅうほ /修補/
しゅうほう /週報/秀峰/
しゅうほうどう /秋芳洞/
しゅうぼう /衆望/醜貌/
しゅうまく /終幕/
しゅうまつ /週末/終末/
しゅうまつろん /終末論/
しゅうみ /臭味/
しゅうみつ /周密/
しゅうみん /就眠/衆民/
しゅうむ /宗務/
しゅうめい /襲名/醜名/
しゅうもく /衆目/
しゅうもん /宗門/
しゅうや /終夜/秋夜/
しゅうやく /集約/
しゅうゆう /周遊/
しゅうゆうけん /周遊券/
しゅうよう /収容/収用/修養/襲用/
しゅうようじょ /収容所/
しゅうらい /襲来/
しゅうらく /集落/聚落/
しゅうらん /収攬/
しゅうり /修理/
しゅうりつ /収率/
しゅうりょう /終了/修了/収量/秋涼/
しゅうりょく /衆力/
しゅうれい /秋冷/秀麗/
しゅうれっしゃ /終列車/
しゅうれん /修練/収斂/習練/
しゅうれんざい /収斂剤/
しゅうろう /就労/
しゅうろく /収録/集録/
しゅうろん /宗論/衆論/修論/
しゅうわい /収賄/
しゅうわいざい /収賄罪/
しゅえい /守衛/
しゅえん /主演/酒宴/
しゅおん /主音/主恩/
しゅか /酒家/主家/
しゅかい /首魁/
しゅかく /主格/主客/酒客/
しゅかん /主幹/主観/主管/首巻/
しゅかんせい /主観性/
しゅかんてき /主観的/
しゅが /主我/珠芽/
しゅがき /朱書/
しゅがん /主眼/
しゅき /手記/酒気/酒器/
しゅきおくそうち /主記憶装置/
しゅきゃく /主客/
しゅきゅう /首級/
しゅきょう /主教/酒興/
しゅきん /手巾/
しゅぎ /主義/手技/
しゅぎしゃ /主義者/
しゅぎょう /修行/修業/
しゅぎょく /珠玉/
しゅく /宿/祝/粛/縮/淑/夙/叔/粥/菽/
しゅくあ /宿痾/
しゅくあく /宿悪/
しゅくい /祝意/宿意/
しゅくうん /宿運/
しゅくえい /宿営/
しゅくえき /宿駅/
しゅくえん /祝宴/祝筵/宿怨/宿縁/
しゅくが /祝賀/
しゅくがく /宿学/
しゅくがん /宿願/
しゅくぎ /祝儀/
しゅくけい /粛啓/
しゅくげん /縮減/
しゅくごう /宿業/縮合/
しゅくさい /祝祭/
しゅくさいじつ /祝祭日/
しゅくさつ /縮刷/
しゅくさつばん /縮刷版/
しゅくし /祝詞/宿志/宿紙/
しゅくしゃ /宿舎/縮写/
しゅくしゃく /縮尺/
しゅくしゅ /宿主/
しゅくしゅく /粛々/粛粛/
しゅくしょう /縮小/祝勝/
しゅくじ /祝辞/
しゅくじつ /祝日/
しゅくじょ /淑女/
しゅくず /縮図/
しゅくせ /宿世/
しゅくせい /粛正/粛清/
しゅくせつ /祝節/宿雪/
しゅくぜん /宿善/粛然/
しゅくたい /縮退/
しゅくだい /宿題/
しゅくちょく /宿直/
しゅくてき /宿敵/
しゅくてん /祝典/
しゅくでん /祝電/
しゅくとう /祝祷/粛党/
しゅくとく /淑徳/
しゅくどう /縮瞳/
しゅくはい /祝杯/
しゅくはく /宿泊/
しゅくば /宿場/
しゅくばまち /宿場町/
しゅくふく /祝福/
しゅくへい /宿弊/
しゅくべん /宿便/
しゅくほう /祝砲/
しゅくぼう /宿望/宿坊/
しゅくみょう /宿命/
しゅくめい /宿命/
しゅくめいてき /宿命的/
しゅくめいろん /宿命論/
しゅくもう /縮毛/
しゅくやく /縮約/
しゅくよう /宿曜/
しゅくん /主君/殊勲/
しゅぐう /殊遇/
しゅけい /主計/主刑/
しゅけいきょく /主計局/
しゅけん /主権/
しゅけんざいみん /主権在民/
しゅけんしゃ /主権者/
しゅげい /手芸/
しゅげた /主桁/
しゅげんじゃ /修験者/
しゅげんどう /修験道/
しゅこう /趣向/酒肴/首肯/珠孔/手工/手交/手稿/殊功/
しゅこうぎょう /手工業/
しゅこうげい /手工芸/
しゅこうりょう /酒肴料/
しゅこつ /手骨/
しゅこん /主根/
しゅご /主語/守護/
しゅごう /酒豪/
しゅごしき /守護職/
しゅごじん /守護神/
しゅごだい /守護代/
しゅごだいみょう /守護大名/
しゅさ /主査/
しゅさい /主催/主宰/主菜/
しゅさんち /主産地/
しゅさんぶつ /主産物/
しゅざい /取材/主剤/首罪/
しゅざん /珠算/
しゅし /主旨/趣旨/種子/朱子/手指/
しゅしがく /朱子学/
しゅしきぼん /手識本/
しゅししょくぶつ /種子植物/
しゅしゃ /取捨/手写/
しゅしょ /朱書/手書/
しゅしょう /首相/主将/主唱/殊勝/首唱/手掌/首将/
しゅしょく /主食/酒食/酒色/
しゅしん /主審/珠心/主神/
しゅしんこうし /朱唇皓歯/
しゅじ /主事/主辞/朱字/
しゅじい /主治医/
しゅじく /主軸/
しゅじゃく /朱雀/
しゅじゅ /種々/侏儒/
しゅじゅう /主従/
しゅじゅざった /種々雑多/
しゅじゅつ /手術/
しゅじょう /衆生/主上/主情/
しゅじょうさいど /衆生済度/
しゅじん /主人/
しゅじんこう /主人公/
しゅじんもん /主尋問/
しゅす /繻子/
しゅすい /取水/
しゅずみ /朱墨/
しゅせい /守勢/酒精/首星/
しゅせいぶん /主成分/
しゅせき /主席/首席/酒席/酒石/
しゅせきさん /酒石酸/
しゅせつ /主節/
しゅせん /主戦/守戦/酒戦/酒仙/
しゅせんど /守銭奴/
しゅぜい /酒税/
しゅぜいきょく /主税局/
しゅぜん /主膳/
しゅぜんじ /修善寺/修禅寺/
しゅそ /主訴/
しゅそりょうたん /首鼠両端/
しゅぞう /酒造/
しゅぞく /種族/
しゅたい /主体/
しゅたいせい /主体性/
しゅたいてき /主体的/
しゅたくぼん /手沢本/
しゅだい /主題/首題/
しゅだいか /主題歌/
しゅだん /手段/
しゅち /主知/趣致/
しゅちく /種畜/
しゅちせつ /主知説/
しゅちにくりん /酒池肉林/
しゅちゅう /手中/主柱/
しゅちょ /主著/
しゅちょう /主張/主潮/首長/腫脹/主調/殊寵/
しゅっか /出荷/出火/
しゅっかん /出棺/
しゅっきょう /出京/出郷/
しゅっきん /出勤/出金/
しゅっきんぼ /出勤簿/
しゅっけ /出家/
しゅっけつ /出欠/出血/
しゅっこ /出庫/
しゅっこう /出向/出航/出港/出講/
しゅっこく /出国/
しゅっさつ /出札/
しゅっさつぐち /出札口/
しゅっさん /出産/
しゅっし /出資/出仕/
しゅっしゃ /出社/
しゅっしょ /出所/出処/
しゅっしょう /出生/
しゅっしょうとどけ /出生届/
しゅっしょうりつ /出生率/
しゅっしょく /出色/
しゅっしょしんたい /出処進退/
しゅっしん /出身/
しゅっすい /出水/
しゅっせ /出世/
しゅっせい /出生/出征/出精/
しゅっせうお /出世魚/
しゅっせがしら /出世頭/
しゅっせき /出席/
しゅっせきぼ /出席簿/
しゅっせけん /出世間/
しゅっせさく /出世作/
しゅっせばらい /出世払い/
しゅっそう /出走/
しゅったい /出来/
しゅったつ /出立/
しゅったん /出炭/
しゅっちょう /出張/出超/
しゅっちょうじょ /出張所/
しゅっちん /出陳/
しゅってい /出廷/
しゅってん /出典/出展/
しゅっとう /出頭/
しゅっとうにん /出頭人/
しゅっぱつ /出発/
しゅっぱつてん /出発点/
しゅっぱん /出版/出帆/
しゅっぱんけん /出版権/
しゅっぱんしゃ /出版社/
しゅっぱんぶつ /出版物/
しゅっぴ /出費/
しゅっぴん /出品/
しゅっぷ /出府/
しゅっぺい /出兵/
しゅっぽん /出奔/
しゅつ /出/
しゅつえん /出演/出捐/
しゅつが /出芽/出駕/
しゅつがん /出願/
しゅつぎょ /出御/
しゅつげき /出撃/
しゅつげん /出現/
しゅつごく /出獄/
しゅつざん /出山/
しゅつじ /出自/
しゅつじょう /出場/出定/
しゅつじん /出陣/
しゅつだい /出題/
しゅつど /出土/
しゅつどう /出動/
しゅつどひん /出土品/
しゅつにゅう /出入/
しゅつにゅうこく /出入国/
しゅつのう /出納/
しゅつば /出馬/
しゅつぼつ /出没/
しゅつらい /出来/
しゅつらん /出藍/
しゅつり /出離/
しゅつりしょうじ /出離生死/
しゅつりょう /出漁/出猟/
しゅつりょく /出力/
しゅつるい /出塁/
しゅてん /主点/主典/朱点/
しゅてんどうじ /酒呑童子/
しゅと /首都/首途/酒徒/
しゅとう /種痘/酒盗/
しゅとく /取得/
しゅとくげんか /取得原価/
しゅとくじこう /取得時効/
しゅとけん /首都圏/
しゅとして /主として/
しゅどう /手動/主導/主動/衆道/
しゅどうけん /主導権/
しゅにく /朱肉/酒肉/
しゅにん /主任/
しゅのう /首脳/主脳/
しゅのうはんたい /酒嚢飯袋/
しゅのうぶ /首脳部/
しゅはい /手背/
しゅはん /主犯/首班/
しゅば /種馬/
しゅひ /守秘/種皮/珠皮/
しゅひぎむ /守秘義務/
しゅひつ /主筆/朱筆/
しゅひん /主賓/
しゅび /守備/首尾/
しゅびいっかん /首尾一貫/
しゅびき /朱引/
しゅびょう /種苗/
しゅふ /主婦/主夫/首府/
しゅふく /首服/
しゅぶ /主部/
しゅぶつ /主物/
しゅぶん /主文/
しゅへい /手兵/守兵/
しゅへき /酒癖/
しゅべつ /種別/
しゅほ /酒保/
しゅほう /手法/主峰/主砲/修法/
しゅぼう /首謀/
しゅぼくてん /朱墨点/
しゅまつ /朱抹/
しゅみ /趣味/
しゅみざ /須弥座/
しゅみせん /須弥山/
しゅみだん /須弥壇/
しゅみゃく /主脈/
しゅむ /主務/
しゅむかんちょう /主務官庁/
しゅむだいじん /主務大臣/
しゅめ /主馬/
しゅめい /主命/
しゅもく /種目/撞木/
しゅもくまち /撞木町/
しゅもつ /腫物/
しゅやく /主役/主薬/
しゅゆ /須臾/
しゅよう /主要/腫瘍/主用/
しゅよく /主翼/
しゅら /修羅/
しゅらじょう /修羅場/
しゅらば /修羅場/
しゅらん /酒乱/
しゅり /首里/
しゅりけん /手裏剣/
しゅりゅう /主流/腫瘤/
しゅりゅうだん /手榴弾/
しゅりょう /狩猟/首領/酒量/
しゅりょく /主力/
しゅりょくかん /主力艦/
しゅるい /種類/酒類/
しゅるいさいけん /種類債権/
しゅれいもん /守礼門/
しゅれん /手練/
しゅろ /棕櫚/椶櫚/
しゅわ /手話/
しゅわおん /主和音/
しゅわん /手腕/
しゅわんか /手腕家/
しゅん /春/瞬/舜/峻/俊/旬/皴/駿/竣/
しゅんえい /俊英/
しゅんかしゅうとう /春夏秋冬/
しゅんかん /瞬間/春寒/
しゅんが /春画/
しゅんき /春期/春季/
しゅんきょ /峻拒/
しゅんぎく /春菊/
しゅんぎょう /春暁/
しゅんけつ /俊傑/
しゅんけん /峻険/
しゅんげつ /春月/
しゅんげん /峻厳/
しゅんこう /竣工/竣功/春光/
しゅんさい /俊才/
しゅんざい /春材/
しゅんしゅう /俊秀/春愁/
しゅんしょう /春宵/
しゅんしょく /春色/
しゅんじ /瞬時/
しゅんじつ /春日/
しゅんじゅう /春秋/
しゅんじゅん /逡巡/
しゅんじょう /春情/
しゅんせい /竣成/
しゅんせつ /浚渫/春雪/
しゅんせつせん /浚渫船/
しゅんそく /駿足/俊足/
しゅんだん /春暖/
しゅんでい /春泥/
しゅんとう /春闘/
しゅんどう /蠢動/
しゅんば /駿馬/
しゅんぱつりょく /瞬発力/
しゅんびん /俊敏/
しゅんぶん /春分/
しゅんぶんてん /春分点/
しゅんぷう /春風/
しゅんぷうたいとう /春風駘蕩/
しゅんべつ /峻別/
しゅんぽん /春本/
しゅんみん /春眠/
しゅんめ /駿馬/
しゅんや /春夜/
しゅんよう /春陽/
しゅんらい /春雷/
しゅんらん /春蘭/
しゅんれい /峻嶺/
しゅんれつ /峻烈/
しゆう /私有/雌雄/市有/子游/師友/
しゆういしゅ /雌雄異株/
しゆういたい /雌雄異体/
しゆうざいさん /私有財産/
しゆうち /私有地/
しゆうどうしゅ /雌雄同株/
しゆうどうたい /雌雄同体/
しゆうりん /私有林/
しょ /所/初/書/暑/諸/署/緒/庶/処/杵/藷/薯/渚/曙/
しょ> /諸/
しょあく /諸悪/
しょい /所為/
しょいこ /背負子/
しょいちねん /初一念/
しょいん /所員/書院/署員/書淫/
しょいんし /書院紙/
しょいんぼん /初印本/
しょう /小/証/商/象/少/消/勝/賞/将/称/障/照/症/章/承/省/償/唱/正/紹/昭/掌/詳/傷/衝/奨/生/渉/笑/性/焼/晶/招/焦/祥/彰/召/装/裳/相/昇/床/松/尚/精/昌/訟/匠/捷/抄/鐘/肖/硝/醤/礁/娼/上/詔/声/姓/鍾/星/政/宵/升/青/沼/廠/妾/鉦/粧/湘/漿/荘/笙/簫/誦/頌/井/従/清/庄/梢/哨/鞘/樟/蒋/嘗/樵/蕉/
しょう> /小/
しょうあい /鍾愛/
しょうあく /掌握/性悪/
しょうあん /正安/硝安/
しょうい /小異/少尉/傷痍/焼夷/
しょういだん /焼夷弾/
しょういん /勝因/証印/正院/小引/小飲/承引/
しょうう /小雨/
しょううちゅう /小宇宙/
しょううん /昌運/勝運/
しょうえき /漿液/
しょうえきち /承役地/
しょうえん /小宴/招宴/硝煙/荘園/
しょうえんざい /消炎剤/
しょうえんだんう /硝煙弾雨/
しょうおう /照応/商鞅/正応/蕉翁/
しょうおく /小屋/
しょうおん /消音/
しょうおんき /消音器/
しょうか /消化/消火/昇華/唱歌/商家/商科/頌歌/漿果/銷夏/小過/娼家/硝化/
しょうかい /紹介/照会/商会/哨戒/詳解/
しょうかいじょう /紹介状/
しょうかいせき /蒋介石/
しょうかいは /小会派/
しょうかえき /消化液/
しょうかき /消火器/消化器/小火器/
しょうかく /昇格/
しょうかこうそ /消化酵素/
しょうかせん /消火栓/消化腺/
しょうかそんじゅく /松下村塾/
しょうかたい /松果体/
しょうかふりょう /消化不良/
しょうかぶ /正株/
しょうかん /償還/召喚/小寒/召還/商館/将官/招喚/小官/
しょうかんかぶしき /償還株式/
しょうかんさえき /償還差益/
しょうかんしゅう /商慣習/
しょうが /生姜/小我/
しょうがい /障害/生涯/渉外/傷害/障碍/生害/
しょうがいざい /傷害罪/
しょうがいちしざい /傷害致死罪/
しょうがいほけん /傷害保険/
しょうがく /小学/奨学/小額/少額/商学/
しょうがくきん /奨学金/
しょうがくせい /小学生/
しょうがっこう /小学校/
しょうがつ /正月/
しょうがわ /庄川/
しょうき /正気/勝機/商機/鍾馗/瘴気/詳記/笑気/焼燬/小器/将器/
しょうきぎょう /小企業/
しょうきぼ /小規模/
しょうきゃく /償却/焼却/消却/正客/
しょうきゅう /昇給/昇級/
しょうきゅうし /小休止/小臼歯/
しょうきょ /消去/
しょうきょう /商況/
しょうきょうと /小京都/
しょうきょく /消極/小曲/唱曲/
しょうきょくてき /消極的/
しょうきょほう /消去法/
しょうきん /賞金/償金/正金/
しょうぎ /将棋/商議/娼妓/床几/象棋/省議/
しょうぎだおし /将棋倒し/
しょうぎばん /将棋盤/
しょうぎょう /商業/
しょうぎょうてき /商業的/
しょうぎょうとうき /商業登記/
しょうく /章句/
しょうぐん /将軍/
しょうぐんけ /将軍家/
しょうぐんづか /将軍塚/
しょうけい /小計/小憩/象形/上卿/小径/小逕/小経/小景/小慧/少頃/少憩/正慶/承継/昌慶/松径/祥啓/祥慶/商計/捷径/捷勁/紹継/勝景/晶系/憧憬/鐘形/
しょうけいしゅとく /承継取得/
しょうけつ /焼結/猖獗/
しょうけん /証券/商圏/正絹/小見/商権/
しょうけんがいしゃ /証券会社/
しょうけんとうし /証券投資/
しょうげ /障礙/障碍/
しょうげき /衝撃/小隙/笑劇/
しょうげきじょう /小劇場/
しょうげきは /衝撃波/
しょうげん /証言/将監/象限/
しょうこ /証拠/商估/商賈/
しょうこう /商工/小康/症候/将校/昇降/焼香/商港/消耗/昇汞/消光/紹興/照校/
しょうこうい /商行為/
しょうこうき /昇降機/
しょうこうぎょう /商工業/
しょうこうぐん /症候群/
しょうこうし /小公子/
しょうこうしゅ /紹興酒/
しょうこうだ /昇降舵/
しょうこうてん /昇交点/
しょうこうねつ /猩紅熱/
しょうこかいじ /証拠開示/
しょうこきん /証拠金/
しょうこく /小国/生国/
しょうこくみん /少国民/
しょうこしょるい /証拠書類/
しょうこしらべ /証拠調べ/
しょうこつ /踵骨/
しょうこのうりょく /証拠能力/
しょうこぶつ /証拠物/
しょうこほぜん /証拠保全/
しょうこり /性懲り/
しょうこりょく /証拠力/
しょうこん /商魂/傷痕/招魂/
しょうご /正午/
しょうごいん /聖護院/
しょうごう /照合/称号/商号/
しょうごん /荘厳/
しょうさ /照査/小差/少佐/証左/
しょうさい /詳細/商才/小才/
しょうさく /小策/
しょうさっし /小冊子/
しょうさつ /小冊/笑殺/
しょうさん /勝算/称賛/賞賛/消散/硝酸/賞讃/
しょうさんえん /硝酸塩/
しょうさんぎん /硝酸銀/
しょうし /笑止/焼死/証紙/少子/小史/抄紙/将士/硝子/賞詞/賞賜/
しょうしせんばん /笑止千万/
しょうしつ /消失/焼失/
しょうしみん /小市民/
しょうしゃ /勝者/商社/照射/小社/瀟洒/抄写/傷者/
しょうしゃく /小尺/焼灼/
しょうしゅう /召集/招集/消臭/
しょうしゅうかん /商習慣/
しょうしゅくしゃく /小縮尺/
しょうしゅつ /抄出/
しょうしゅん /頌春/
しょうしょ /証書/小暑/詔書/尚書/
しょうしょう /少々/少将/小升/小哨/小祥/小照/少小/少少/小小/昌昌/昭昭/省掌/将相/悚悚/悄悄/商聖/章章/彰彰/晶晶/蕭牆/蕭蕭/鏘鏘/瀟湘/
しょうしょく /小食/小職/少食/
しょうしん /昇進/傷心/焼身/正真/小心/焦心/小身/衝心/
しょうしんもの /小心者/
しょうしんよくよく /小心翼翼/
しょうじ /商事/障子/東海林/消磁/小事/少時/小路/正治/精進/小字/賞辞/庄司/荘司/
しょうじき /正直/
しょうじこ /精進湖/
しょうじばいばい /商事売買/
しょうじゃ /精舎/盛者/生者/
しょうじゃく /小弱/
しょうじゅう /小銃/
しょうじゅつ /詳述/
しょうじゅん /照準/
しょうじゅんき /照準器/
しょうじょ /少女/消除/小序/
しょうじょう /症状/賞状/小乗/商状/猩猩/清浄/掌状/霄壌/招状/掌上/
しょうじょうせぜ /生生世世/
しょうじょうひ /猩々緋/
しょうじょうみゃく /掌状脈/
しょうじょうるてん /生生流転/
しょうじょしゅみ /少女趣味/
しょうじん /精進/焼尽/小人/
しょうじんあげ /精進揚/
しょうじんけっさい /精進潔斎/
しょうじんぶつ /小人物/
しょうじんりょうり /精進料理/
しょうすい /憔悴/将帥/小水/松翠/
しょうすう /小数/少数/
しょうすういけん /少数意見/
しょうすうせいえい /少数精鋭/
しょうすうてん /小数点/
しょうすうは /少数派/
しょうすうみんぞく /少数民族/
しょうず /小豆/
しょうずい /祥瑞/
しょうせい /小生/招請/小成/焼成/勝勢/
しょうせき /硝石/証跡/
しょうせっかい /消石灰/
しょうせつ /小説/小節/詳説/小雪/章節/
しょうせつか /小説家/
しょうせつせん /小節線/
しょうせん /商船/商戦/省線/
しょうせんきょう /昇仙峡/
しょうせんきょく /小選挙区/
しょうぜつ /勝絶/
しょうぜん /承前/性善/悄然/小善/
しょうぜんてい /小前提/
しょうそ /勝訴/
しょうそう /尚早/焦燥/傷愴/悄愴/焦躁/少壮/
しょうそういん /正倉院/
しょうそく /消息/
しょうそくすじ /消息筋/
しょうそくつう /消息通/
しょうそつ /将卒/
しょうそん /焼損/
しょうぞう /肖像/
しょうぞうが /肖像画/
しょうぞうけん /肖像権/
しょうぞく /装束/
しょうたい /招待/正体/小隊/
しょうたいじょう /招待状/
しょうたく /妾宅/沼沢/
しょうたん /賞嘆/
しょうだい /掌大/昭代/
しょうだく /承諾/
しょうだん /商談/昇段/
しょうち /承知/招致/召致/
しょうちく /松竹/
しょうちくばい /松竹梅/
しょうちゅう /掌中/焼酎/
しょうちょ /小著/
しょうちょう /象徴/小腸/消長/省疔/
しょうちょうてき /象徴的/
しょうちょく /詔勅/
しょうちん /消沈/銷沈/
しょうつき /祥月/
しょうてい /小弟/
しょうてん /焦点/商店/昇天/衝天/小篆/聖天/小店/
しょうてんがい /商店街/
しょうてんきょり /焦点距離/
しょうてんしんど /焦点深度/
しょうでん /小伝/召電/招電/昇殿/詳伝/
しょうと /商都/
しょうとう /消灯/小刀/
しょうとく /承徳/称徳/正徳/生得/
しょうとくたいし /聖徳太子/
しょうとつ /衝突/
しょうとりひき /商取引/
しょうど /照度/焦土/焼土/
しょうどう /衝動/章動/唱道/唱導/
しょうどうがい /衝動買い/
しょうどうてき /衝動的/
しょうどく /消毒/
しょうどくやく /消毒薬/
しょうどけい /照度計/
しょうどしま /小豆島/
しょうどせんじゅつ /焦土戦術/
しょうない /庄内/荘内/
しょうなごん /少納言/
しょうなん /湘南/小難/
しょうなんでんしゃ /湘南電車/
しょうに /小児/少弐/
しょうにか /小児科/
しょうにびょう /小児病/
しょうにゅうせき /鍾乳石/
しょうにゅうたい /鍾乳体/
しょうにゅうどう /鍾乳洞/
しょうにん /承認/証人/商人/小人/昇任/上人/聖人/
しょうね /性根/
しょうねつ /焦熱/
しょうねん /少年/正念/生年/
しょうねんいん /少年院/
しょうねんだん /少年団/
しょうねんはんざい /少年犯罪/
しょうねんば /正念場/
しょうねんほう /少年法/
しょうのう /小脳/笑納/樟脳/小農/
しょうは /小破/消波/
しょうはい /勝敗/賞杯/賞牌/
しょうはさん /小破産/
しょうばい /商売/
しょうばいがたき /商売敵/
しょうばいがら /商売柄/
しょうばいぎ /商売気/
しょうばいにん /商売人/
しょうばつ /賞罰/
しょうばら /庄原/
しょうばん /相伴/
しょうひ /消費/
しょうひきたく /消費寄託/
しょうひざい /消費財/
しょうひしゃ /消費者/
しょうひせいこう /消費性向/
しょうひぜい /消費税/
しょうひたいしゃく /消費貸借/
しょうひつ /省筆/
しょうひょう /商標/証票/証憑/
しょうひょうけん /商標権/
しょうひょうほう /商標法/
しょうひん /商品/賞品/小品/
しょうひんけん /商品券/
しょうび /焦眉/賞美/
しょうびのきゅう /焦眉の急/
しょうびょう /傷病/
しょうびょうへい /傷病兵/
しょうふ /娼婦/
しょうふうろうげつ /嘯風弄月/
しょうふく /承服/承伏/妾腹/
しょうふだ /正札/
しょうぶ /勝負/菖蒲/尚武/
しょうぶごと /勝負事/
しょうぶし /勝負師/
しょうぶつ /生仏/
しょうぶどころ /勝負所/
しょうぶん /性分/小文/
しょうへい /正平/招聘/小兵/昌平/将兵/哨兵/傷兵/昇平/
しょうへいが /障屏画/
しょうへいこう /昌平黌/
しょうへき /障壁/牆壁/
しょうへん /掌篇/掌編/小片/小変/
しょうべつ /小別/
しょうべん /小便/
しょうほう /商法/詳報/勝報/捷報/正保/
しょうほうたい /小胞体/
しょうほうてい /小法廷/
しょうほん /抄本/正本/証本/
しょうぼ /召募/
しょうぼう /消防/焼亡/
しょうぼうし /消防士/
しょうぼうしょ /消防署/
しょうぼうじ /正法寺/
しょうぼうちょう /消防庁/消防長/
しょうま /消磨/
しょうまく /漿膜/
しょうまん /小満/
しょうみ /賞味/正味/
しょうみきかん /賞味期間/
しょうみつ /詳密/
しょうみょう /声明/称名/小名/
しょうむ /商務/
しょうめい /証明/照明/正銘/
しょうめいしょ /証明書/
しょうめいだん /照明弾/
しょうめいりょく /証明力/
しょうめつ /消滅/生滅/
しょうめつじこう /消滅時効/
しょうめん /正面/
しょうもう /消耗/睫毛/
しょうもうせん /消耗戦/
しょうもうひん /消耗品/
しょうもん /証文/
しょうや /庄屋/
しょうやく /抄訳/生薬/硝薬/
しょうゆ /醤油/
しょうゆう /少輔/小勇/
しょうよ /賞与/
しょうよう /商用/小用/従容/称揚/逍遥/小葉/縦容/慫慂/賞揚/
しょうようじゅりん /照葉樹林/
しょうらい /将来/生来/招来/
しょうらいせい /将来性/
しょうらん /照覧/笑覧/
しょうり /勝利/捷利/掌理/小吏/小利/
しょうりつ /勝率/
しょうりとうしゅ /勝利投手/
しょうりゃく /省略/商略/
しょうりゅう /小流/
しょうりょ /焦慮/
しょうりょう /少量/小量/精霊/聖霊/渉猟/商量/
しょうりょうえ /聖霊会/
しょうりょうながし /精霊流し/
しょうりょく /省力/
しょうりん /松林/
しょうりんじ /少林寺/
しょうるい /生類/
しょうれい /奨励/症例/省令/
しょうれいきん /奨励金/
しょうれんげ /青蓮華/
しょうろ /松露/捷路/
しょうろう /鐘楼/
しょうろうびょうし /生老病死/
しょうろく /抄録/詳録/
しょうろん /詳論/小論/
しょうわ /昭和/唱和/小話/笑話/倡和/正和/
しょうわきち /昭和基地/
しょうわくせい /小惑星/
しょうわしんざん /昭和新山/
しょうわる /性悪/
しょえん /初演/所縁/諸縁/
しょおく /書屋/
しょか /初夏/書架/書家/諸家/
しょかい /初会/初回/所懐/
しょかつ /所轄/
しょかん /所感/書簡/所管/初寒/初刊/初巻/書函/書巻/
しょかんちょう /所管庁/
しょかんぶん /書簡文/
しょが /書画/
しょがかり /諸掛り/
しょがく /初学/
しょがん /所願/
しょき /初期/書記/所期/暑気/書紀/書櫃/
しょきか /初期化/
しょきかん /書記官/
しょききょく /書記局/
しょきけい /初期型/
しょきせい /書記生/
しょきちょう /書記長/
しょきばらい /暑気払い/
しょきゅう /初級/初給/書笈/
しょきょう /書経/
しょぎょう /諸行/所業/所行/
しょぎょうむじょう /諸行無常/
しょく /色/燭/食/蝕/触/職/織/殖/植/飾/嘱/蜀/贖/軾/初句/拭/埴/
しょくあたり /食中り/
しょくあん /職安/
しょくい /職位/
しょくいき /職域/
しょくいん /職員/職印/
しょくいんだんたい /職員団体/
しょくいんろく /職員録/
しょくえん /食塩/
しょくがい /食害/
しょくぎょう /職業/
しょくぎょうがら /職業柄/
しょくぎょうびょう /職業病/
しょくげん /食言/
しょくご /食後/
しょくさいぼう /食細胞/
しょくさん /殖産/
しょくさんじん /蜀山人/
しょくざい /贖罪/殖財/
しょくし /食指/
しょくしゅ /職種/触手/
しょくしゅどうぶつ /触手動物/
しょくしょう /職掌/食傷/
しょくしょうがら /職掌柄/
しょくしん /触診/
しょくじ /食事/食餌/植字/
しょくじゅ /植樹/
しょくじゅう /職住/
しょくじょ /織女/
しょくじょせい /織女星/
しょくじんしゅ /食人種/
しょくせい /職制/植生/食性/
しょくせいかつ /食生活/
しょくせき /職責/
しょくせつ /触接/
しょくぜん /食前/食膳/
しょくたい /食滞/
しょくたく /食卓/嘱託/
しょくたくえん /食卓塩/
しょくたくさつじん /嘱託殺人/
しょくだい /燭台/
しょくち /諸口/初口/
しょくちゅうどく /食中毒/
しょくちゅうるい /食虫類/
しょくちょう /職長/
しょくつう /食通/
しょくてん /触点/
しょくど /埴土/
しょくどう /食堂/食道/
しょくどうしゃ /食堂車/
しょくにく /食肉/
しょくにくるい /食肉類/
しょくにん /職人/
しょくにんげい /職人芸/
しょくのう /職能/
しょくのうきゅう /職能給/
しょくはつ /触発/
しょくば /職場/
しょくばい /触媒/
しょくひ /食費/植皮/
しょくひん /食品/
しょくひんぐん /食品群/
しょくぶつ /植物/食物/
しょくぶつえん /植物園/
しょくぶつかい /植物界/
しょくぶつがく /植物学/
しょくぶつしつ /植物質/
しょくぶつせい /植物性/
しょくぶつにんげん /植物人間/
しょくぶつゆ /植物油/
しょくぶん /職分/
しょくべに /食紅/
しょくほうじだい /織豊時代/
しょくぼう /嘱望/
しょくみ /食味/
しょくみん /植民/
しょくみんち /植民地/
しょくむ /職務/
しょくむきゅう /職務給/
しょくむけんげん /職務権限/
しょくむしつもん /職務質問/
しょくめい /職名/
しょくもう /植毛/
しょくもく /属目/
しょくもつ /食物/
しょくもつれんさ /食物連鎖/
しょくゆう /贖宥/
しょくよう /食用/
しょくようがえる /食用蛙/
しょくようじょう /食養生/
しょくよく /食欲/
しょくらい /触雷/
しょくりょう /食料/食糧/
しょくりょうちょう /食糧庁/
しょくりょうひん /食料品/
しょくりん /植林/
しょくれき /職歴/
しょくん /諸君/
しょぐう /処遇/
しょけい /諸兄/処刑/初経/書契/
しょけつ /処決/
しょけん /所見/初見/書見/諸賢/
しょげい /諸芸/
しょげつ /初月/
しょげん /諸元/緒言/
しょこ /書庫/書賈/
しょこう /諸侯/初校/曙光/初更/初項/諸公/
しょこく /諸国/初刻/
しょこん /初婚/
しょごう /初号/
しょさ /所作/
しょさい /書斎/所載/
しょさつ /初刷/書冊/書札/
しょさん /所産/初産/
しょざ /初座/
しょざい /所在/
しょざいち /所在地/
しょざん /諸山/
しょし /諸氏/諸子/初志/書誌/書司/書肆/所司/庶子/所思/諸姉/書史/書笥/
しょしがく /書誌学/
しょしき /書式/諸式/
しょしだい /所司代/
しょしつ /書室/
しょしひゃっか /諸子百家/
しょしゃ /書写/
しょしゅ /諸種/書手/
しょしゅう /初秋/所収/諸宗/
しょしゅつ /初出/庶出/所出/
しょしゅん /初春/
しょしょ /諸処/処暑/所々/
しょしょう /書証/所掌/諸将/
しょしん /初心/初審/初診/所信/書信/
しょしんしゃ /初心者/
しょじ /所持/諸事/
しょじひんけんさ /所持品検査/
しょじゃく /書籍/
しょじゃくかん /書籍館/
しょじゅん /初旬/
しょじょ /処女/
しょじょう /書状/
しょじょこうかい /処女航海/
しょじょさく /処女作/
しょじょち /処女地/
しょじょまく /処女膜/
しょじょりん /処女林/
しょずり /初刷/
しょせい /処世/書生/初生/諸政/庶政/書聖/
しょせいくん /処世訓/
しょせいじ /初生児/
しょせいじゅつ /処世術/
しょせいろん /書生論/
しょせき /書籍/
しょせきかん /書籍館/
しょせきこづつみ /書籍小包/
しょせつ /諸説/所説/
しょせん /所詮/緒戦/
しょそう /諸相/所相/書窓/
しょそく /初速/
しょそくど /初速度/
しょそん /書損/
しょぞう /所蔵/
しょぞく /所属/
しょぞん /所存/
しょたい /書体/所帯/
しょたいぬし /所帯主/
しょたいめん /初対面/
しょたいもち /所帯持ち/
しょだい /初代/書題/
しょだち /初太刀/
しょだな /書棚/
しょだん /初段/処断/
しょだんけい /処断刑/
しょち /処置/書痴/
しょちつ /書帙/
しょちゅう /暑中/書中/
しょちゅうみまい /暑中見舞/
しょちょう /所長/署長/初潮/
しょっかい /職階/
しょっかいきゅう /職階給/
しょっかいせい /職階制/
しょっかく /触角/触覚/食客/
しょっかん /触感/食管/食間/
しょっかんほう /食管法;食糧管理法/
しょっき /食器/織機/
しょっきり /初っ切り/
しょっけん /食券/職権/
しょっけんらんよう /職権濫用/
しょっこう /職工/燭光/
しょっぱな /初っ端/
しょづくえ /書机/
しょて /初手/
しょてい /所定/
しょてん /書店/諸点/
しょでん /初伝/所伝/書伝/
しょとう /諸島/初等/初頭/初冬/蔗糖/書套/
しょとうきょういく /初等教育/
しょとうすうがく /初等数学/
しょとく /所得/
しょとくこうか /所得効果/
しょとくこうじょ /所得控除/
しょとくせいさく /所得政策/
しょとくぜい /所得税/
しょどう /書道/初動/所動/諸道/
しょない /所内/
しょなぬか /初七日/
しょなのか /初七日/
しょにち /初日/
しょにゅう /初乳/
しょにん /初任/諸人/
しょにんきゅう /初任給/
しょねつ /暑熱/
しょねん /初年/
しょは /諸派/
しょはつ /初発/
しょはん /初版/諸般/初犯/
しょばつ /処罰/
しょひ /諸費/書皮/
しょひょう /書評/書票/
しょびょう /諸病/
しょふ /書譜/
しょふう /書風/
しょふく /書幅/
しょぶつ /諸仏/庶物/
しょぶん /処分/
しょへき /書癖/
しょへん /初編/
しょほ /初歩/
しょほう /処方/書法/諸方/
しょほうせん /処方箋/
しょほてき /初歩的/
しょぼう /書房/
しょみん /庶民/
しょみんてき /庶民的/
しょむ /庶務/
しょめい /署名/書名/
しょめいうんどう /署名運動/
しょめん /書面/
しょめんしんり /書面審理/
しょもう /所望/
しょもく /書目/
しょもつ /書物/
しょや /初夜/
しょやく /初訳/
しょゆう /所有/所由/
しょゆうけん /所有権/
しょよ /所与/
しょよう /所要/所用/初陽/
しょり /処理/
しょりけい /処理系/
しょりゅう /庶流/諸流/
しょりょう /所領/
しょりん /書林/
しょるい /書類/
しょるいそうけん /書類送検/
しょろう /初老/所労/
しょろん /所論/緒論/
しょわけ /諸訳/
しよ /賜与/
しよう /使用/仕様/私用/試用/枝葉/飼養/子葉/止揚/施用/
しようがき /仕様書/
しようしゃ /使用者/
しようしょ /仕様書/
しようたいしゃく /使用貸借/
しようにん /使用人/
しようほう /使用法/
しようまっせつ /枝葉末節/
しようりょう /使用料/
しよく /私欲/
しら /白/
しらい /白井/
しらいた /白板/
しらいと /白糸/
しらうお /白魚/
しらうめ /白梅/
しらかば /白樺/
しらかばこ /白樺湖/
しらかばは /白樺派/
しらかべ /白壁/
しらかわ /白河/白川/
しらかわよふね /白川夜船;見たふりをすること/
しらが /白髪/
しらがあたま /白髪頭/
しらき /白木/
しらぎ /新羅/
しらぎく /白菊/
しらくも /白癬/白雲/
しらけ /白け/
しらこ /白子/
しらさぎ /白鷺/
しらさや /白鞘/
しらじ /白地/
しらじら /白々/
しらす /白砂/白子/
しらず /知らず/
しらせ /知らせ/白瀬/
しらたき /白滝/
しらたま /白玉/
しらたまこ /白玉粉/
しらちゃ /白茶/
しらつち /白土/
しらつゆ /白露/
しらとり /白鳥/
しらなみ /白波/白浪/
しらに /白煮/
しらぬい /不知火/
しらぬひ /不知火/
しらね /白根/
しらねさん /白根山/
しらは /白羽/白刃/
しらはた /白旗/
しらはま /白浜/
しらひげ /白鬚/白髭/
しらびょうし /白拍子/
しらふ /素面/
しらふじ /白藤/
しらべ /調べ/
しらべもの /調べ物/
しらほ /白帆/
しらほね /白骨/
しらほねおんせん /白骨温泉/
しらみ /虱/蝨/
しらみね /白峰/
しらみぼん /虱本/
しらやき /白焼/
しらやなぎ /白柳/
しらやま /白山/
しらゆき /白雪/
しらゆきひめ /白雪姫/
しらゆり /白百合/
しり /尻/私利/臀/
しりあい /知合い/
しりうま /尻馬/
しりお /尻尾/
しりおも /尻重/
しりがる /尻軽/
しりきれ /尻切れ/
しりごみ /後込み/尻込み/
しりつ /私立/市立/
しりつがっこう /私立学校/
しりつたんてい /私立探偵/
しりつだいがく /私立大学/
しりとり /尻取り/
しりぬぐい /尻拭い/
しりぬけ /尻抜け/
しりびと /知り人/
しりべし /後志/
しりめ /後目/尻目/
しりめつれつ /支離滅裂/
しりもち /尻餅/
しりゃく /史略/
しりゅう /支流/
しりょ /思慮/
しりょう /資料/試料/史料/思量/死霊/飼料/思料/
しりょく /視力/死力/資力/
しりん /四隣/
しる /汁/
しるけ /汁気/
しるけんり /知る権利/
しるこ /汁粉/
しるし /印/標/
しるひと /知る人/
しるべ /標/導/
しるもの /汁物/
しれい /指令/司令/
しれいかん /司令官/
しれいちょうかん /司令長官/
しれいぶ /司令部/
しれつ /熾烈/歯列/
しれとこ /知床/
しれん /試練/試煉/
しろ /城/白/代/
しろあお /白青/
しろあと /城跡/
しろあり /白蟻/
しろあん /白餡/
しろいし /白石/
しろいと /白糸/
しろいもの /白い物/
しろう /屍蝋/脂漏/
しろうさぎ /白兎/
しろうと /素人/
しろうとげい /素人芸/
しろうとしばい /素人芝居/
しろうとすじ /素人筋/
しろうとばなれ /素人離れ/
しろうとめ /素人目/
しろうま /白馬/
しろうまだけ /白馬岳/
しろがね /銀/
しろき /白木/
しろく /四緑/
しろくじちゅう /四六時中/
しろくばん /四六判/
しろくま /白熊/
しろくろ /白黒/
しろこ /白子/
しろざけ /白酒/
しろざとう /白砂糖/
しろしょうぞく /白装束/
しろじ /白地/
しろずみ /白炭/
しろた /白田/代田/
しろたえ /白妙/
しろだすき /白襷/
しろつめくさ /白詰草/
しろとり /白鳥/
しろなまず /白癜/
しろぬき /白抜き/
しろぬり /白塗り/
しろね /白根/
しろねずみ /白鼠/
しろへび /白蛇/
しろべえ /四郎兵衛/
しろぼし /白星/
しろまく /白幕/
しろまだら /白斑/
しろみ /白身/
しろみず /白水/
しろみそ /白味噌/
しろむく /白無垢/
しろめ /白目/白眼/
しろもと /城本/
しろもの /代物/白物/
しろやま /城山/
しろん /史論/私論/試論/詩論/至論/
しわ /皺/皴/私話/史話/詩話/
しわく /思惑/
しわけ /仕訳/仕分け/
しわけちょう /仕訳帳/
しわざ /仕業/
しわす /師走/
しわほう /指話法/視話法/
しわよせ /皺寄せ/
しん /心/新/真/親/身/神/伸/森/寝/辛/辰/進/信/震/針/診/薪/臣/紳/秦/疹/申/深/浸/晋/振/慎/審/娠/唇/侵/請/清/宸/箴/讖/軫/津/芯/榛/
しん> /新/真/
しんあい /親愛/信愛/
しんあん /新案/
しんい /真意/深意/襯衣/瞋恚/心意/神意/
しんいき /神域/震域/
しんいり /新入り/
しんいん /心因/神韻/真因/
しんうち /真打/
しんうん /進運/
しんえい /新鋭/親衛/真影/
しんえいたい /親衛隊/
しんえつ /信越/親閲/
しんえつほんせん /信越本線/
しんえん /深遠/深淵/神苑/
しんおう /震央/深奥/
しんおうきょり /震央距離/
しんおん /唇音/心音/震音/
しんか /進化/真価/深化/臣下/真果/神化/心窩/神火/
しんかい /新開/深海/
しんかいぎょ /深海魚/
しんかいち /新開地/
しんかく /神格/
しんかくせいぶつ /真核生物/
しんかげりゅう /新陰流/
しんかしゃ /新華社/
しんかしょてん /新華書店/
しんかぶ /新株/
しんから /心から/
しんかろん /進化論/
しんかん /新館/新刊/神官/森閑/深閑/震撼/信管/心肝/宸翰/
しんかんせん /新幹線/
しんがい /侵害/心外/震駭/辛亥/
しんがいかくめい /辛亥革命/
しんがお /新顔/
しんがく /進学/神学/新学/心学/
しんがた /新型/
しんがっこう /神学校/
しんがぽーる /新嘉坡/
しんがら /新柄/
しんがり /殿/
しんがん /心眼/真贋/心願/
しんき /新規/新奇/心機/神器/心気/辛気/振起/
しんきいってん /心機一転/
しんきげん /新紀元/
しんきじく /新機軸/
しんきゅう /新旧/進級/審級/鍼灸/
しんきょ /新居/
しんきょう /心境/新疆/信教/新京/進境/新教/
しんきょうごく /新京極/
しんきょうと /新教徒/
しんきょく /新曲/神曲/
しんきろう /蜃気楼/
しんきろく /新記録/
しんきん /心筋/伸筋/親近/真菌/
しんきんかん /親近感/
しんきんこうそく /心筋梗塞/
しんぎ /審議/真偽/信義/真義/神技/
しんぎかい /審議会/
しんぎそく /信義則/
しんぎん /呻吟/
しんく /辛苦/深紅/真紅/
しんくう /真空/
しんくうかん /真空管/
しんくうけい /真空計/
しんくん /神君/
しんぐ /寝具/
しんぐう /新宮/
しんぐん /進軍/
しんけ /新家/
しんけい /神経/
しんけいかいろ /神経回路/
しんけいかびん /神経過敏/
しんけいけい /神経系/
しんけいさいぼう /神経細胞/
しんけいしつ /神経質/
しんけいしょう /神経症/
しんけいすいじゃく /神経衰弱/
しんけいせつ /神経節/
しんけいせん /神経戦/
しんけいそう /神経叢/
しんけいつう /神経痛/
しんけいまひ /神経麻痺/
しんけつ /心血/審決/
しんけん /真剣/親権/神権/新券/神剣/
しんけんざい /新建材/
しんけんしゃ /親権者/
しんけんしょうぶ /真剣勝負/
しんけんせいじ /神権政治/
しんけんぽう /新憲法/
しんげき /進撃/新劇/
しんげつ /新月/心月/
しんげん /進言/信玄/震源/箴言/
しんこ /新香/新古/
しんこう /進行/振興/信仰/親交/新興/侵攻/親好/深厚/深更/進攻/侵寇/進講/深紅/神幸/深交/進航/新香/
しんこうがかり /進行係/
しんこうけい /進行形/
しんこうは /進行波/
しんこきゅう /深呼吸/
しんこく /深刻/申告/親告/神国/新刻/新穀/
しんこくげき /新国劇/
しんこっちょう /真骨頂/
しんこてんしゅぎ /新古典主義/
しんこん /新婚/心根/身魂/
しんこんりょこう /新婚旅行/
しんご /新語/
しんごう /信号/
しんごうじょう /信号場/
しんごん /真言/
しんごんしゅう /真言宗/
しんさ /審査/
しんさい /震災/親祭/親裁/
しんさいばしすじ /心斎橋筋/
しんさく /新作/振作/
しんさせいきゅう /審査請求/
しんさつ /診察/新札/
しんさよく /新左翼/
しんさん /辛酸/
しんざ /神座/新座/
しんざい /心材/浸剤/
しんざん /新参/深山/神山/
しんざんもの /新参者/
しんし /真摯/紳士/振子/進士/
しんしき /新式/神式/
しんしきょうてい /紳士協定/
しんしつ /寝室/心室/
しんしてき /紳士的/
しんしほしゃ /唇歯輔車/
しんしゃ /新車/深謝/親炙/
しんしゃく /斟酌/新釈/
しんしゅ /新種/新酒/進取/神酒/
しんしゅう /信州/真宗/新秋/神州/新修/
しんしゅうきょう /新宗教/
しんしゅうだいがく /信州大学/
しんしゅく /伸縮/新宿/
しんしゅつ /進出/浸出/滲出/新出/
しんしゅつえき /滲出液/
しんしゅつきぼつ /神出鬼没/
しんしゅん /新春/
しんしょ /新書/信書/親書/神書/真書/親署/
しんしょう /辛勝/心証/心象/身上/真症/
しんしょうしゃ /身障者/
しんしょうひつばつ /信賞必罰/
しんしょうぼうだい /針小棒大/
しんしょく /侵食/寝食/侵蝕/浸食/浸蝕/神職/
しんしろ /新城/
しんしろく /紳士録/
しんしん /心身/津々/新進/心神/津津/
しんしんきえい /新進気鋭/
しんしんしょう /心身症/
しんじ /進士/神事/新字/信士/真字/
しんじこ /宍道湖/
しんじたい /新字体/
しんじつ /真実/信実/
しんじゃ /信者/
しんじゅ /真珠/神授/新樹/親授/
しんじゅう /心中/臣従/
しんじゅがい /真珠貝/
しんじゅく /新宿/
しんじゅくぎょえん /新宿御苑/
しんじゅくく /新宿区/
しんじゅつ /申述/心術/
しんじゅわん /真珠湾/
しんじゅん /浸潤/
しんじょ /神助/寝所/
しんじょう /信条/心情/新庄/身上/進上/真情/
しんじん /新人/信心/深甚/審訊/
しんじんるい /新人類/
しんすい /浸水/心酔/進水/深水/
しんすいしき /進水式/
しんすう /真数/
しんずい /真髄/心髄/神髄/
しんせい /申請/新星/真性/神聖/新生/新制/真正/新製/神性/新政/心性/親政/
しんせいがん /深成岩/
しんせいじ /新生児/
しんせいだい /新生代/
しんせいねん /新青年/
しんせいひん /新製品/
しんせいめん /新生面/
しんせかい /新世界/
しんせき /親戚/浸漬/
しんせだい /新世代/
しんせっきじだい /新石器時代/
しんせつ /親切/新設/新説/新雪/真説/深雪/
しんせつごかし /親切ごかし/
しんせん /新鮮/深浅/神仙/神泉/震顫/神饌/新選/神僊/
しんせんぐみ /新撰組/新選組/
しんぜん /神前/親善/
しんぜんび /真善美/
しんそ /親疎/
しんそう /真相/新装/深層/深窓/神葬/真草/
しんそうしんりがく /深層心理学/
しんそく /神速/
しんそこ /心底/真底/
しんそつ /新卒/
しんぞう /心臓/新造/心像/神像/
しんぞうびょう /心臓病/
しんぞく /親族/
しんぞくかい /親族会/
しんたい /身体/進退/神体/新体/
しんたいうかがい /進退伺い/
しんたいけんさ /身体検査/
しんたいし /新体詩/
しんたいせい /新体制/
しんたいそう /新体操/
しんたいようじ /真太陽時/
しんたいりく /新大陸/
しんたく /信託/神託/新宅/
しんたくぎんこう /信託銀行/
しんたくざいさん /信託財産/
しんたくとうち /信託統治/
しんたくほう /信託法/
しんたつ /申達/進達/
しんたん /薪炭/心胆/
しんだい /寝台/身代/
しんだいしゃ /寝台車/
しんだつ /侵奪/
しんだん /診断/
しんだんしょ /診断書/
しんち /新地/深智/深知/心地/神智/新知/
しんちく /新築/
しんちしき /新知識/
しんちゃ /新茶/
しんちゃく /新着/
しんちゅう /心中/進駐/真鍮/
しんちょ /新著/心緒/
しんちょう /身長/慎重/新潮/新調/伸長/伸張/深長/清朝/
しんちょく /進捗/
しんちん /新陳/
しんちんたいしゃ /新陳代謝/
しんつう /心痛/
しんて /新手/
しんてい /進呈/新訂/心底/新帝/
しんてき /心的/
しんてん /進展/親展/伸展/神典/
しんてんち /新天地/
しんてんどうち /震天動地/
しんでし /新弟子/
しんでん /神殿/新田/神伝/寝殿/震電/親電/
しんでんず /心電図/
しんと /信徒/新都/
しんとう /浸透/心頭/新党/親等/滲透/神道/新刀/
しんとうあつ /浸透圧/
しんとうき /神統記/
しんとく /神徳/
しんど /震度/進度/深度/心土/
しんどう /振動/新道/神童/震動/伸銅/神道/
しんどうすう /振動数/
しんどく /真読/
しんない /心内/新内/
しんなんよう /新南陽/
しんにち /親日/
しんにゅう /新入/侵入/浸入/進入/
しんにゅうせい /新入生/
しんにゅうまく /新入幕/
しんにょ /真如/信女/
しんにん /信任/新任/信認/親任/
しんにんじょう /信任状/
しんにんとうひょう /信任投票/
しんねん /信念/新年/
しんのう /親王/心嚢/
しんのうとう /秦皇島/
しんば /新馬/
しんばし /新橋/
しんばた /新畑/
しんばつ /神罰/
しんぱ /新派/
しんぱい /心配/神拝/
しんぱいごと /心配事/
しんぱいしょう /心配性/
しんぱく /心拍/心搏/
しんぱつ /進発/
しんぱん /信販/侵犯/審判/新版/親藩/
しんぱんいん /審判員/
しんぱんかん /審判官/
しんひしつ /新皮質/
しんび /審美/
しんびがん /審美眼/
しんぴ /神秘/真否/心皮/真皮/
しんぴしゅぎ /神秘主義/
しんぴつ /真筆/宸筆/親筆/
しんぴてき /神秘的/
しんぴょう /信憑/
しんぴょうせい /信憑性/
しんぴん /新品/
しんふがい /申不害/
しんふぜん /心不全/
しんぶ /深部/神武/
しんぶつ /神仏/
しんぶつしゅうごう /神仏習合/
しんぶん /新聞/
しんぶんきしゃ /新聞記者/
しんぶんこうこく /新聞広告/
しんぶんし /新聞紙/
しんぶんしゃ /新聞社/
しんぶんすう /真分数/
しんぶんだね /新聞種/
しんぷ /新譜/新婦/神父/親父/
しんぷう /新風/
しんぷく /振幅/信服/心服/臣服/
しんぷくじ /真福寺/
しんぺい /神兵/新兵/
しんぺん /身辺/
しんほう /心法/
しんぼう /辛抱/信望/心房/心棒/深謀/
しんぼうさいどう /心房細動/
しんぼく /親睦/神木/臣僕/
しんぼくかい /親睦会/
しんぼとけ /新仏/
しんぼり /新堀/
しんぽ /進歩/
しんぽう /信奉/新法/新報/
しんぽてき /進歩的/
しんぽん /新本/
しんまい /新米/
しんまえ /新前/
しんまく /心膜/
しんまち /新町/
しんみ /親身/新味/新見/
しんみつ /親密/
しんみなと /新湊/
しんみょう /神妙/
しんみん /臣民/
しんむら /新村/
しんめ /新芽/
しんめい /身命/神明/神命/新明/
しんめんぼく /真面目/
しんめんもく /真面目/新面目/
しんもつ /進物/
しんもん /審問/
しんや /深夜/新家/
しんやく /新薬/新訳/
しんやくしじ /新薬師寺/
しんやくせいしょ /新約聖書/
しんやしき /新屋敷/
しんやま /新山/
しんゆ /新湯/
しんゆう /親友/心友/深憂/
しんよう /信用/瀋陽/新陽/針葉/
しんようきんこ /信用金庫/
しんようくみあい /信用組合/
しんようじゅ /針葉樹/
しんようじょう /信用状/
しんようそうぞう /信用創造/
しんようちょうさ /信用調査/
しんようとりひき /信用取引/
しんらい /信頼/新来/
しんらいせい /信頼性/
しんらいのげんそく /信頼の原則/
しんらつ /辛辣/
しんらばんしょう /森羅万象/
しんらん /親鸞/
しんり /真理/心理/審理/
しんりがく /心理学/
しんりち /真理値/
しんりひょう /真理表/
しんりびょうしゃ /心理描写/
しんりゃく /侵略/侵掠/
しんりょ /深慮/神慮/
しんりょう /診療/新涼/
しんりょうしょ /診療所/
しんりょうないか /心療内科/
しんりょく /新緑/深緑/心力/
しんりりゅうほ /心裡留保/
しんりりょうほう /心理療法/
しんりん /森林/
しんりんくみあい /森林組合/
しんりんげんかい /森林限界;森林育成の上限,亜寒帯と寒帯の境,亜高山帯と高山帯の境/
しんりんこうえん /森林公園/
しんりんてつどう /森林鉄道/
しんりんよく /森林浴/
しんるい /親類/
しんれい /心霊/神霊/
しんれき /新暦/
しんろ /進路/針路/
しんろう /新郎/心労/辛労/
しんろしどう /進路指導/
しんろん /新論/
しんわ /神話/親和/
しんわせい /親和性/
しんわりょく /親和力/
じ /時/事/自/字/次/示/地/辞/治/寺/磁/持/似/路/児/耳/慈/滋/痔/侍/除/仕/璽/爾/餌/而/蒔/
じ> /次/
じあい /自愛/慈愛/地合/時合/
じあえんそさん /次亜塩素酸/
じあげ /地上げ/
じあまり /字余り/
じあめ /地雨/
じあん /事案/
じい /自慰/爺/示威/辞意/侍医/字彙/次位/事彙/辞彙/
じいさん /爺さん/
じいしき /自意識/
じいや /爺や/
じいろ /地色/
じいん /寺院/
じう /慈雨/
じうた /地歌/
じうたい /地謡/
じうん /時運/
じえい /自衛/自営/
じえいかん /自衛官/
じえいけん /自衛権/
じえいたい /自衛隊/
じおう /地黄/
じおん /字音/
じおんじ /慈恩寺/
じか /時下/時価/自家/磁化/耳科/直/磁荷/
じかい /次回/磁界/自戒/耳介/字解/自壊/持戒/
じかく /自覚/痔核/字画/寺格/耳殻/
じかくしょうじょう /自覚症状/
じかしゅぎ /時価主義/
じかじゅせい /自花受精/
じかせい /自家製/
じかせん /耳下腺/
じかせんえん /耳下腺炎/
じかた /地方/
じかたび /地下足袋/
じかだん /直談/
じかだんぱん /直談判/
じかつ /自活/
じかづけ /直付け/
じかどうちゃく /自家撞着/
じかに /直に/
じかはっこう /時価発行/
じかはつでん /自家発電/
じかび /直火/
じかよう /自家用/
じかろ /地火炉/
じかん /時間/字間/次官/耳管/
じかんがい /時間外/
じかんきゅう /時間給/
じかんぎれ /時間切れ/
じかんたい /時間帯/
じかんちかく /時間知覚/
じかんつぶし /時間潰し/
じかんひょう /時間表/
じかんわり /時間割/
じが /自我/自画/
じがい /自害/
じがいしき /自我意識/
じがお /地顔/
じがく /自学/
じがじさん /自画自賛/自画自讃/
じがぞう /自画像/
じがため /地固め/
じがね /地金/
じがみ /地神/地紙/
じき /直/時期/次期/磁気/自棄/時機/食/磁器/時季/自記/敷/
じきあらし /磁気嵐/
じきさん /直参/
じきしょ /直書/
じきしょうそう /時期尚早/
じきじき /直々/
じきそ /直訴/
じきそう /直奏/
じきだん /直談/
じきでし /直弟子/
じきでん /直伝/
じきとう /直答/
じきひつ /直筆/
じきもん /直門/
じきゅう /自給/時給/持久/
じきゅうこうい /自救行為/
じきゅうじそく /自給自足/
じきゅうせん /持久戦/
じきょ /辞去/
じきょう /自供/
じきょく /磁極/時局/
じきらん /直覧/
じきわ /直話/
じぎ /字義/辞儀/児戯/時宜/
じぎゃく /自虐/
じぎょう /事業/
じぎょうか /事業家/
じぎょうしょぜい /事業所税/
じぎょうしょとく /事業所得/
じぎょうぜい /事業税/
じぎょうねんど /事業年度/
じぎょうぶ /事業部/
じく /軸/字句/舳/宍/竺/
じくあし /軸足/
じくう /時空/
じくうけ /軸受/
じくぎ /軸木/
じくさく /軸索/
じくじ /忸怩/
じくばこ /軸箱/
じくばり /字配り/
じくもの /軸物/
じくりゅう /軸流/
じくん /字訓/
じぐち /地口/
じけ /寺家/
じけい /自警/慈恵/字形/次兄/
じけいだん /自警団/
じけいれつ /時系列/
じけつ /自決/
じけん /事件/
じげ /地毛/自解/地下/
じげん /次元/時限/字源/示現/辞源/
じげんかいせき /次元解析/
じげんばくだん /時限爆弾/
じげんりっぽう /時限立法/
じこ /事故/自己/
じこあい /自己愛/
じこあんじ /自己暗示/
じこう /事項/時効/自校/時候/時好/
じこうきかん /時効期間/
じこかぶしき /自己株式/
じこきんゆう /自己金融/
じこぎまん /自己欺瞞/
じこく /時刻/自国/二黒/
じこくてん /持国天/
じこくひょう /時刻表/
じこけんお /自己嫌悪/
じここうたい /自己抗体;自己免疫により作られる抗体/
じこしょうかい /自己紹介/
じこそがい /自己疎外;精神による自己否定/
じこちゅうしん /自己中心/
じこはさん /自己破産/
じこばいばい /自己売買;証券会社が自らの勘定で行う有価証券の売買,⇔委託売買/
じこひてい /自己否定/
じこひはん /自己批判/
じこべんご /自己弁護/
じこほぞん /自己保存/
じこまんぞく /自己満足/
じこむじゅん /自己矛盾/
じこりゅう /自己流/
じご /事後/爾後/持碁/
じごう /次号/寺号/
じごうじとく /自業自得/
じごえ /地声/
じごく /地獄/
じごくへん /地獄変;地獄変相の略/
じごくみみ /地獄耳/
じごごうとう /事後強盗;窃盗犯が窃盗の後に強盗を行うこと/
じごしょうだく /事後承諾/
じさ /時差/
じさく /自作/
じさくのう /自作農/
じさしゅっきん /時差出勤/
じさつ /自殺/
じさつてん /自殺点/
じさん /持参/自賛/自讃/
じさんきん /持参金/
じざい /自在/
じざかい /地境/
じざけ /地酒/
じし /次子/
じしつ /自失/痔疾/地質/自室/
じしゃ /侍者/寺社/自社/
じしゃく /磁石/
じしゅ /自主/自首/
じしゅう /自習/次週/時宗/自修/
じしゅきせい /自主規制/
じしゅく /自粛/
じしゅけん /自主権/
じしゅてき /自主的/
じしゅどくおう /自主独往/
じしょ /辞書/自署/地所/字書/璽書/自書/
じしょう /事象/自称/時称/自照/
じしょうぎ /持将棋/
じしょく /辞職/
じしん /自身/自信/地震/磁針/時針/
じしんがく /地震学/
じしんけい /地震計/
じしんどう /地震動/
じしんは /地震波/
じしんよち /地震予知/
じじ /爺/時事/時々/
じじこっこく /時々刻々/
じじつ /事実/時日/
じじつうしんしゃ /時事通信社/
じじつこん /事実婚/
じじつしん /事実審/
じじつにんてい /事実認定/
じじつむこん /事実無根/
じじもんだい /時事問題/
じじゃく /自若/
じじゅう /侍従/自重/
じじゅん /耳順/
じじょ /次女/侍女/自助/自序/自叙/
じじょう /事情/自乗/二乗/磁場/自浄/治定/
じじょうじばく /自縄自縛;自業自得/
じじょうつう /事情通/
じじょでん /自叙伝/
じじん /自刃/自尽/時人/
じすい /自炊/
じすう /字数/次数/
じすべり /地滑り/
じずめ /字詰め/
じずら /字面/
じせい /時制/自制/時世/磁性/自製/時勢/自生/自省/辞世/
じせいたい /磁性体/
じせき /自席/次席/自責/事跡/耳石/事績/
じせきてん /自責点/
じせつ /時節/自説/持説/
じせつがら /時節柄/
じせん /自薦/自選/
じぜん /事前/次善/慈善/
じぜんうんどう /事前運動;根回し/
じぜんじぎょう /慈善事業/
じぜんじゅんび /事前準備/
じそ /自訴/
じそう /自走/事相/時相/
じそうほう /自走砲/
じそく /自足/時速/磁束/
じそくみつど /磁束密度/
じそん /自存/自尊/
じそんしん /自尊心/
じぞう /地蔵/
じぞうどう /地蔵堂/
じぞく /持続/
じた /自他/
じたい /自体/事態/辞退/字体/
じたく /自宅/
じたつ /示達/
じたん /時短/
じだ /耳朶/
じだい /時代/地代/次代/事大/
じだいおくれ /時代後れ/
じだいげき /時代劇/
じだいこうしょう /時代考証;時代劇で設定された時代に適合するかどうかの考証/
じだいさくご /時代錯誤;アナクロニズム,時代後れ/
じだいしゅぎ /事大主義;虎の威をかる狐/
じだいしょうせつ /時代小説/
じだいしょく /時代色/
じだいせいしん /時代精神;ある時代の象徴的な精神,cf.民族精神/
じだいそう /時代相/
じだいもの /時代物/
じだらく /自堕落/
じだん /示談/
じだんだ /地団駄/地団太/
じち /自治/
じちいかだいがく /自治医科大学/
じちかい /自治会/
じちぎょうせい /自治行政/
じちく /自治区/
じちけん /自治権/
じちたい /自治体/
じちだいじん /自治大臣/
じちょ /自著/
じちょう /次長/自重/自嘲/次丁/
じちょうけんじ /次長検事;検事総長の補佐を行う検察官/
じちりょう /自治領/
じちん /自沈/
じちんさい /地鎮祭/
じっ /十/
じっか /実家/実科/
じっかい /十戒/十界/
じっかん /実感/十干/
じっき /実記/
じっきょう /実況/
じっきょうけんぶん /実況見分/
じっけい /実刑/実兄/実景/
じっけつ /十傑/
じっけん /実験/実権/実検/実見/
じっけんしき /実験式/
じっけんしつ /実験室/
じっけんしんりがく /実験心理学/
じっけんだい /実験台/
じっけんてき /実験的/
じっけんどうぶつ /実験動物/
じっけんぶつりがく /実験物理学/
じっこう /実行/実効/
じっこうぜいりつ /実効税率/
じっこうち /実効値/
じっこん /実根/入魂/昵懇/
じっさい /実際/
じっさいか /実際家/
じっさいてき /実際的/
じっさく /実作/
じっし /実施/実子/実姉/十指/
じっしつ /実質/
じっしつちんぎん /実質賃金/
じっしつてき /実質的/
じっしゃ /実写/実車/
じっしゃかい /実社会/
じっしゅ /十種/
じっしゅう /実習/実収/
じっしゅきょうぎ /十種競技/
じっしょう /実証/実正/
じっしょうしゅぎ /実証主義/
じっしょうてき /実証的/
じっしんほう /十進法/
じっすう /実数/
じっせい /実勢/
じっせいかかく /実勢価格/
じっせいかつ /実生活/
じっせかい /実世界/
じっせき /実績/
じっせつ /実説/
じっせん /実践/実線/実戦/
じっせんきゅうこう /実践躬行;自ら実際に行動する/
じっせんてき /実践的/
じっそう /実相/実装/
じっそく /実測/
じっそくず /実測図/
じったい /実体/実態/
じったいか /実体化/
じったいきょう /実体鏡/
じったいほう /実体法/
じっち /実地/
じっちけんしょう /実地検証/
じっちゅうはっく /十中八九/
じっちょく /実直/
じって /十手/
じってい /実弟/実体/
じっていほう /実定法/
じっとく /十徳/拾得/
じっぱひとからげ /十把一絡げ;何もかも一緒くた/
じっぴ /実費/実否/
じっぷ /実父/
じっぺんしゃいっく /十返舎一九;人名,江戸後期の戯作者/
じっぽう /実包/十方/
じつ /日/実/
じつい /実意/
じついん /実印/実員/
じつう /耳痛/
じつえき /実益/
じつえん /実演/
じつかた /実方/
じつかぶ /実株/
じつかわ /実川/
じつがい /実害/
じつがく /実学/
じつぎ /実技/
じつぎょう /実業/
じつぎょうか /実業家/
じつぎょうかい /実業界/
じつぎょうだん /実業団/
じつげつ /日月/
じつげん /実現/
じつざい /実在/
じつざいせい /実在性/
じつざいろん /実在論/
じつじ /実字/
じつじきゅうぜ /実事求是;事実に即して真実を探究する/
じつじゅ /実需/
じつじょう /実状/実情/
じつぞう /実像/
じつぞん /実存/
じつぞんしゅぎ /実存主義;人間の個別存在を中心に置く哲学の立場/
じつだん /実弾/
じつづき /地続き/
じつどう /実働/実動/
じつどうじかん /実働時間/
じつに /実に/
じつねんろん /実念論/
じつは /実は/
じつばりき /実馬力/
じつぶつ /実物/
じつぶつだい /実物大/
じつぶつとりひき /実物取引/
じつぼ /実母/地坪/
じつまい /実妹/
じつむ /実務/
じつむか /実務家/
じつめい /実名/
じつやく /実役/
じつよう /実用/
じつようか /実用化/
じつようしゅぎ /実用主義/
じつようしんあん /実用新案/
じつようてき /実用的/
じつり /実利/実理/
じつりょく /実力/
じつりょくこうし /実力行使/
じつりょくしゃ /実力者/
じつれい /実例/
じつれき /実歴/
じつろく /実録/
じつわ /実話/
じづめ /字詰め/
じづら /字面/
じてい /自邸/
じていすう /時定数/
じてき /自適/
じてっこう /磁鉄鉱/
じてん /時点/辞典/字典/事典/次点/自転/
じてんしゃ /自転車/
じでん /自伝/
じとう /地頭/
じとく /自得/自涜/
じどう /自動/児童/
じどうか /自動化/
じどうがっき /自動楽器/
じどうし /自動詞/
じどうしゃ /自動車/
じどうしゃぜい /自動車税/
じどうしょうじゅう /自動小銃/
じどうせいぎょ /自動制御/
じどうてあて /児童手当/
じどうてき /自動的/
じどうはんばいき /自動販売機/
じどうふくししせつ /児童福祉施設/
じどうふくしほう /児童福祉法/
じどうぶんがく /児童文学/
じどり /地取り/
じない /寺内/
じないちょう /寺内町/
じならし /地均し/
じなり /地鳴り/
じなん /次男/二男/
じにん /辞任/自任/自認/
じぬし /地主/
じねつ /地熱/
じねん /自然/
じねんほうに /自然法爾/
じのし /地伸し/
じは /自派/
じはく /自白/
じはだ /地肌/
じはつ /自発/
じはつせい /自発性/
じはつてき /自発的/
じはん /事犯/
じば /磁場/地場/
じばいせきほけん /自賠責保険/
じばく /自爆/自縛/
じばさんぎょう /地場産業/
じばら /自腹/
じばん /地盤/
じばんちんか /地盤沈下/
じひ /自費/慈悲/
じひしゅっぱん /自費出版/
じひつ /自筆/
じひびき /地響き/
じひょう /辞表/時評/
じびいんこうか /耳鼻咽喉科/
じびか /耳鼻科/
じびき /字引/
じびょう /持病/
じふ /自負/慈父/
じふく /地覆/時服/
じふしん /自負心/
じふぶき /地吹雪/
じふん /自噴/
じぶ /治部/
じぶくろ /地袋/
じぶつ /事物/
じぶん /自分/時分/
じぶんかって /自分勝手/
じぶんじしん /自分自身/
じへい /時弊/
じへいしょう /自閉症/
じへん /事変/時変/
じべた /地べた/
じべん /自弁/
じほう /時報/
じぼ /字母/慈母/
じぼう /自暴/
じぼうじき /自暴自棄/
じまい /仕舞/
じまえ /自前/
じまく /字幕/
じまま /自儘/
じまん /自慢/
じみ /地味/滋味/
じみち /地道/
じむ /事務/寺務/
じむいん /事務員/
じむかん /事務官/
じむかんり /事務管理/
じむきょく /事務局/
じむし /地虫/
じむしつ /事務室/
じむしょ /事務所/
じむじかん /事務次官/
じむそうちょう /事務総長/
じむちょう /事務長/
じむてき /事務的/
じむや /事務屋/
じめい /自明/
じめつ /自滅/
じめん /地面/字面/
じもく /耳目/
じもくじ /甚目寺/
じもと /地元/
じもの /地物/
じもん /自問/寺門/
じもんじとう /自問自答/
じゃ /邪/蛇/麝/
じゃあく /邪悪/
じゃかん /蛇管/
じゃき /邪気/邪鬼/
じゃきょう /邪教/
じゃく /弱/若/寂/着/惹/
じゃくおんき /弱音器/
じゃくさん /弱酸/
じゃくし /弱視/弱志/
じゃくしゃ /弱者/
じゃくしょう /弱小/
じゃくしん /弱震/
じゃくじょう /寂静/
じゃくそつ /弱卒/
じゃくたい /弱体/
じゃくてき /弱敵/
じゃくてん /弱点/
じゃくでん /弱電/
じゃくねん /若年/寂然/
じゃくはい /若輩/弱輩/
じゃくはく /弱拍/
じゃくめつ /寂滅/
じゃくめついらく /寂滅為楽/
じゃくやく /雀躍/
じゃくら /雀羅/
じゃぐち /蛇口/
じゃけん /邪険/邪慳/邪見/
じゃこう /麝香/
じゃし /邪視/
じゃしゅう /邪宗/
じゃしん /邪神/邪心/
じゃじゃうま /じゃじゃ馬/
じゃすい /邪推/
じゃせつ /邪説/
じゃそく /蛇足/
じゃっか /弱化/
じゃっかん /若干/弱冠/
じゃっき /惹起/
じゃっく /惹句/
じゃっこう /弱行/寂光/
じゃっこういん /寂光院/
じゃっこく /弱国/
じゃどう /邪道/
じゃねん /邪念/
じゃのめ /蛇の目/
じゃはな /謝花/
じゃばら /蛇腹/
じゃひ /邪飛/
じゃほう /邪法/
じゃま /邪魔/
じゃまだて /邪魔立て/
じゃまもの /邪魔物/
じゃよく /邪欲/
じゃり /砂利/
じゃれん /邪恋/
じゃわ /爪哇/
じゃんそう /雀荘/
じやく /持薬/
じゅ /受/需/綬/樹/授/寿/呪/儒/就/聚/従/
じゅい /呪医/
じゅいしゃ /受遺者/
じゅいん /樹陰/
じゅう /重/十/住/従/渋/柔/充/獣/銃/縦/戎/汁/什/拾/中/
じゅう> /重/
じゅうあつ /重圧/
じゅうい /獣医/重囲/
じゅういちがつ /十一月/
じゅういつ /充溢/
じゅういん /充員/
じゅうえいそう /重営倉/
じゅうえき /獣疫/
じゅうえん /重縁/
じゅうおう /十王/縦横/
じゅうおうか /縦横家/
じゅうおうむぐう /縦横無隅/
じゅうおうむじん /縦横無尽/
じゅうか /住家/銃火/重科/
じゅうかい /重解/
じゅうかき /重火器/
じゅうかく /縦隔/
じゅうかさんぜい /重加算税/
じゅうかしつ /重過失/
じゅうかぜい /従価税/
じゅうかん /縦貫/獣姦/重患/
じゅうがつ /十月/
じゅうがん /銃眼/
じゅうき /什器/銃器/重機/重器/
じゅうきょ /住居/
じゅうきんぞく /重金属/
じゅうぎょう /従業/
じゅうぎょういん /従業員/
じゅうく /重苦/
じゅうぐん /従軍/
じゅうぐんいあんふ /従軍慰安婦/
じゅうぐんきしゃ /従軍記者/
じゅうけい /従兄/重刑/重慶/銃刑/
じゅうけいてい /従兄弟/
じゅうけつ /充血/
じゅうけん /銃剣/
じゅうげき /銃撃/
じゅうげん /重言/
じゅうこう /重厚/銃口/獣行/
じゅうこうぎょう /重工業/
じゅうこく /重刻/縦谷/
じゅうこん /重根/重婚/
じゅうご /銃後/
じゅうごう /重合/
じゅうごうたい /重合体/
じゅうごや /十五夜/
じゅうさいぼう /柔細胞/
じゅうさつ /銃殺/重刷/重殺/
じゅうさんづか /十三塚/
じゅうさんや /十三夜/
じゅうざ /銃座/
じゅうざい /重罪/
じゅうし /重視/従姉/獣脂/
じゅうしまい /従姉妹/
じゅうしまつ /十姉妹/
じゅうしゃ /従者/
じゅうしゅつ /重出/
じゅうしょ /住所/
じゅうしょう /重症/重傷/重賞/重唱/
じゅうしょうしゅぎ /重商主義/
じゅうしょく /住職/重職/
じゅうしょろく /住所録/
じゅうしん /重心/銃身/獣身/重臣/獣心/
じゅうじ /従事/十字/十時/
じゅうじか /十字架/
じゅうじぐん /十字軍/
じゅうじつ /充実/
じゅうじほうか /十字砲火/
じゅうじゅう /重々/
じゅうじゅつ /柔術/
じゅうじゅん /従順/柔順/
じゅうじろ /十字路/
じゅうすい /重水/
じゅうすいそ /重水素/
じゅうせい /獣性/銃声/
じゅうせき /重責/
じゅうせん /縦線/
じゅうぜい /重税/
じゅうぜん /従前/十全/
じゅうぜんじ /十禅師/
じゅうそう /縦走/重奏/重層/重曹/銃創/
じゅうそく /充足/充塞/
じゅうそしき /柔組織/
じゅうそつ /従卒/
じゅうぞく /従属/
じゅうぞくこく /従属国/
じゅうぞくせつ /従属節/
じゅうたい /渋滞/重体/縦隊/獣帯/銃隊/重態/紐帯/
じゅうたく /住宅/
じゅうたん /絨毯/絨緞/
じゅうたんばくげき /絨毯爆撃/
じゅうだい /重大/十代/重代/
じゅうだん /縦断/銃弾/
じゅうだんめん /縦断面/
じゅうちん /重鎮/
じゅうづめ /重詰め/
じゅうてい /重訂/従弟/
じゅうてん /重点/充填/
じゅうてんてき /重点的/
じゅうでん /充電/
じゅうでんき /充電器/
じゅうとう /充当/重盗/
じゅうとく /重篤/
じゅうど /重度/
じゅうどう /柔道/
じゅうなん /柔軟/
じゅうなんざい /柔軟剤/
じゅうなんたいそう /柔軟体操/
じゅうにがつ /十二月/
じゅうにきゅう /十二宮/
じゅうにく /獣肉/
じゅうにし /十二支/
じゅうにしちょう /十二指腸/
じゅうにしと /十二使徒/
じゅうにてん /十二天/
じゅうにひとえ /十二単/
じゅうにぶん /十二分/
じゅうにりつ /十二律/
じゅうにん /住人/十人/重任/
じゅうにんといろ /十人十色/
じゅうにんなみ /十人並/
じゅうねん /十年/十念/
じゅうねんいちじつ /十年一日/
じゅうのうしゅぎ /重農主義/
じゅうはちばん /十八番/
じゅうはっしりゃく /十八史略/
じゅうはっぱん /十八般/
じゅうはん /従犯/重版/重犯/
じゅうばくげきき /重爆撃機/
じゅうばこ /重箱/
じゅうばこよみ /重箱読み/
じゅうばつ /重罰/
じゅうひ /柔皮/獣皮/
じゅうびょう /重病/
じゅうふく /重複/
じゅうぶつ /従物/
じゅうぶん /十分/充分/重文/
じゅうへい /従兵/
じゅうべんか /重弁花/
じゅうほう /銃砲/重砲/什宝/重宝/
じゅうぼいん /重母音/
じゅうぼく /従僕/
じゅうまい /従妹/
じゅうまん /充満/
じゅうみん /住民/
じゅうみんうんどう /住民運動/
じゅうみんぜい /住民税/
じゅうみんそしょう /住民訴訟/
じゅうみんとうろく /住民登録/
じゅうみんひょう /住民票/
じゅうめん /渋面/
じゅうもう /絨毛/獣毛/
じゅうもつ /什物/
じゅうもんじ /十文字/
じゅうやく /重役/重訳/
じゅうゆ /重油/
じゅうよう /重要/充用/重用/
じゅうようし /重要視/重陽子/
じゅうよく /獣欲/
じゅうらい /従来/
じゅうらん /縦覧/
じゅうり /重利/
じゅうりゅうし /重粒子/
じゅうりょう /重量/十両/銃猟/
じゅうりょうあげ /重量挙げ/
じゅうりょうかん /重量感/
じゅうりょうぜい /従量税/
じゅうりょく /重力/
じゅうりょくは /重力波/
じゅうりん /蹂躙/
じゅうるい /獣類/
じゅうれつ /縦列/
じゅうれん /重連/
じゅうろうどう /重労働/
じゅうろく /十六/
じゅうろくや /十六夜/
じゅえい /樹影/
じゅえき /受益/樹液/
じゅえきしょうけん /受益証券/
じゅか /儒家/樹下/
じゅかい /樹海/受戒/授戒/
じゅかせきじょう /樹下石上/
じゅかん /樹幹/
じゅがく /儒学/
じゅきしゃ /受寄者/
じゅきぶつ /受寄物/
じゅきゅう /受給/需給/
じゅきょう /儒教/
じゅぎょう /授業/受業/
じゅぎょうりょう /授業料/
じゅく /熟/塾/
じゅくぎ /熟議/
じゅくご /熟語/
じゅくし /熟視/熟柿/熟思/
じゅくじ /熟字/
じゅくじくん /熟字訓/
じゅくすい /熟睡/
じゅくせい /熟成/塾生/
じゅくたつ /熟達/
じゅくだん /熟談/
じゅくち /熟知/
じゅくとう /塾頭/
じゅくどく /熟読/
じゅくねん /熟年/
じゅくみん /熟眠/
じゅくらん /熟覧/
じゅくりょ /熟慮/
じゅくりょだんこう /熟慮断行/
じゅくれん /熟練/
じゅくれんこう /熟練工/
じゅけい /受刑/
じゅけん /受験/受検/授権/
じゅけんしほん /授権資本/
じゅげむ /寿限無/
じゅこう /受講/
じゅこん /樹根/
じゅごん /呪禁/儒艮/
じゅさん /授産/
じゅし /樹脂/孺子/樹枝/
じゅしどう /樹脂道/
じゅしゃ /儒者/
じゅしょ /儒書/
じゅしょう /受賞/授賞/受章/
じゅしん /受信/受診/
じゅしんき /受信機/
じゅしんにん /受信人/
じゅじゅ /授受/
じゅじゅつ /呪術/
じゅじょう /樹上/
じゅじょうとっき /樹状突起/
じゅすい /入水/
じゅず /数珠/
じゅずだま /数珠玉/
じゅせい /受精/授精/樹勢/
じゅせいらん /受精卵/
じゅせん /受洗/
じゅぜん /受禅/
じゅそ /呪詛/受訴/
じゅそさいばんしょ /受訴裁判所/
じゅぞう /受像/受贈/
じゅぞうき /受像機/
じゅたい /受胎/
じゅたく /受託/
じゅたくしゃ /受託者/
じゅたくはんばい /受託販売/
じゅだい /入内/
じゅだく /受諾/
じゅちゅう /受注/
じゅっかい /述懐/
じゅっけい /術計/
じゅっこう /熟考/
じゅっさく /術策/述作/
じゅっすう /術数/
じゅっちゅう /術中/
じゅつ /述/術/戌/
じゅつご /述語/術後/術語/
じゅつごろんり /述語論理/
じゅつしゃ /術者/
じゅつぶ /述部/
じゅどう /受動/
じゅどうたい /受動態/
じゅどうてき /受動的/
じゅなん /受難/
じゅなんきょく /受難曲/
じゅにゅう /授乳/
じゅにゅうき /授乳期/
じゅのう /受納/
じゅはい /受配/
じゅばく /呪縛/
じゅばん /襦袢/
じゅひ /樹皮/
じゅひょう /樹氷/
じゅふ /呪符/授付/
じゅふく /寿福/
じゅふくじ /寿福寺/
じゅふん /受粉/
じゅぶつ /呪物/
じゅほう /呪法/
じゅみょう /寿命/
じゅめい /受命/
じゅもく /樹木/
じゅもん /呪文/
じゅよ /授与/
じゅよう /需要/受容/
じゅようき /受容器/
じゅようきょくせん /需要曲線/
じゅようたい /受容体/
じゅらい /入来/
じゅらく /聚楽/入洛/
じゅらくだい /聚楽第;豊臣秀吉の京都の邸宅,ジュラクテイとも/
じゅらくやき /聚楽焼/
じゅり /受理/
じゅりつ /樹立/
じゅりょう /受領/
じゅりょうしょう /受領証/
じゅりょうちたい /受領遅滞/
じゅりん /樹林/
じゅれい /樹齢/寿齢/
じゅろうじん /寿老人;七福神の一つ/
じゅわき /受話器/
じゅん /順/醇/遵/巡/純/盾/潤/準/淳/殉/旬/循/准/閏/楯/
じゅん> /準/
じゅんあい /純愛/
じゅんい /順位/准尉/
じゅんいつ /純一/
じゅんいにん /準委任/
じゅんえき /純益/
じゅんえつ /巡閲/
じゅんえん /順延/巡演/順縁/
じゅんおう /順応/
じゅんおくり /順送り/
じゅんおん /純音/
じゅんか /純化/順化/馴化/醇化/
じゅんかい /巡回/
じゅんかつ /潤滑/
じゅんかつざい /潤滑剤/
じゅんかつゆ /潤滑油/
じゅんかん /循環/准看/旬刊/旬間/
じゅんかんき /循環器/
じゅんかんしょうすう /循環小数/
じゅんかんろんぽう /循環論法/
じゅんきゅう /準急/
じゅんきょ /準拠/
じゅんきょう /殉教/順境/
じゅんきょうゆう /準共有/
じゅんきょほう /準拠法/
じゅんきん /純金/
じゅんぎゃく /順逆/
じゅんぎょう /巡業/
じゅんぎん /純銀/
じゅんぐり /順繰り/
じゅんけい /巡警/純系/
じゅんけっしょう /準決勝/準結晶/
じゅんけつ /純潔/純血/
じゅんけん /巡検/巡見/純絹/
じゅんげつ /旬月/
じゅんこう /巡航/巡行/巡幸/順行/
じゅんこうこく /準抗告/
じゅんこうそくど /巡航速度/
じゅんこく /殉国/
じゅんごうかん /準強姦/
じゅんごうとう /準強盗/
じゅんさ /巡査/
じゅんさい /蓴菜/
じゅんさちょう /巡査長/
じゅんさつ /巡察/
じゅんさぶちょう /巡査部長/
じゅんし /巡視/殉死/荀子/
じゅんしかん /准士官;将校と下士官との間の位/
じゅんしさん /純資産/
じゅんしせん /巡視船/
じゅんしゃく /巡錫/
じゅんしゅ /遵守/順守/
じゅんしょう /准将/
じゅんしょく /殉職/潤色/純色/
じゅんしょとく /純所得/
じゅんしん /純真/
じゅんじ /順次/
じゅんじつ /旬日/
じゅんじゅん /順々/恂恂/循循/順順/諄諄/
じゅんじょ /順序/
じゅんじょう /純情/
じゅんじょかんけい /順序関係/
じゅんじょすう /順序数/
じゅんじょつい /順序対/
じゅんすい /純粋/純水/
じゅんせい /純正/準正/醇正/
じゅんせいちょう /純正調/
じゅんせいてき /準静的/
じゅんせいりつ /純正律/
じゅんせつ /順接/
じゅんせん /準線/
じゅんせんゆう /準占有/
じゅんぜん /純然/
じゅんそく /準則/
じゅんぞう /純増/
じゅんたく /潤沢/
じゅんち /馴致/
じゅんちょう /順調/
じゅんて /順手/
じゅんてん /順天/
じゅんとう /順当/
じゅんとく /順徳/
じゅんど /純度/
じゅんなん /殉難/
じゅんねん /閏年/
じゅんのう /順応/
じゅんばん /順番/
じゅんぱい /巡拝/
じゅんぱく /純白/
じゅんひぶ /順日歩/
じゅんび /準備/
じゅんびきん /準備金/
じゅんびしょめん /準備書面/
じゅんびてつづき /準備手続/
じゅんぴつりょう /潤筆料;漫画・文章を書いた報酬/
じゅんふどう /順不同/
じゅんぶん /純分/
じゅんぶんがく /純文学/
じゅんぷう /順風/
じゅんぷうまんぱん /順風満帆/
じゅんぼく /純朴/
じゅんぽう /遵法/順法/旬報/遵奉/
じゅんまいしゅ /純米酒/
じゅんめん /純綿/
じゅんもう /純毛/
じゅんゆう /巡遊/
じゅんよ /旬余/
じゅんよう /準用/
じゅんようかん /巡洋艦/
じゅんようせんかん /巡洋戦艦/
じゅんら /巡邏/
じゅんらん /巡覧/
じゅんり /純利/純理/
じゅんりえき /純利益/
じゅんりょう /純量/純良/順良/
じゅんれい /巡礼/
じゅんれき /巡歴/
じゅんれつ /順列/
じゅんろ /順路/
じゆう /自由/事由/
じゆういし /自由意志/
じゆうえん /自由円/
じゆうがた /自由形/
じゆうきょうそう /自由競争/
じゆうぎょう /自由業/
じゆうけい /自由刑/
じゆうけいざい /自由経済/
じゆうけん /自由権/
じゆうこう /自由港/
じゆうこうどう /自由行動/
じゆうさいりょう /自由裁量/
じゆうし /自由市/自由詩/
じゆうしゅぎ /自由主義/
じゆうじざい /自由自在/
じゆうでんし /自由電子/
じゆうとう /自由党/
じゆうど /自由度/
じゆうぼうえき /自由貿易/
じゆうみんしゅとう /自由民主党/
じゆうらっか /自由落下/
じゆうれんそう /自由連想/
じょ /女/如/除/恕/徐/序/叙/助/鋤/
じょい /女医/叙位/
じょう /上/情/常/場/状/乗/条/城/定/譲/丈/剰/浄/蒸/醸/冗/錠/畳/成/壌/静/盛/嬢/杖/丞/帖/縄/諚/穣/擾/
じょう> /上/
じょうあい /情愛/情合/
じょうい /上位/譲位/上意/攘夷/上衣/情意/
じょういかたつ /上意下達/
じょういがいねん /上位概念/
じょういき /浄域/
じょういん /乗員/上院/剰員/冗員/畳韻/
じょううち /常打/
じょうえ /浄衣/
じょうえい /上映/
じょうえいしきもく /貞永式目/
じょうえつ /上越/上謁/
じょうえつせん /上越線/
じょうえん /上演/情炎/
じょうおく /場屋/
じょうおん /常温/
じょうか /浄化/城下/浄火/情火/
じょうかい /上界/上階/常会/
じょうかく /城郭/城閣/
じょうかそう /浄化槽/
じょうかた /城方/
じょうかまち /城下町/
じょうかん /上官/情感/乗艦/
じょうかんぱん /上甲板/
じょうがい /場外/城外/
じょうがく /上顎/
じょうがしま /城ヶ島/
じょうき /上記/蒸気/常軌/上気/条規/常規/
じょうきあつ /蒸気圧/
じょうききかん /蒸気機関/
じょうききかんしゃ /蒸気機関車/
じょうきげん /上機嫌/
じょうきせん /蒸気船/
じょうきゃく /乗客/上客/常客/
じょうきゅう /上級/承久/
じょうきゅうしん /上級審/
じょうきょう /状況/上京/情況/貞享/常況/
じょうきん /常勤/
じょうぎ /定規/情義/
じょうく /冗句/
じょうくう /上空/
じょうぐう /上宮/
じょうけい /情景/常形/上計/場景/
じょうけん /条件/
じょうけんつき /条件付/
じょうけんづけ /条件付け/
じょうけんはんしゃ /条件反射/
じょうげ /上下/
じょうげどう /上下動/
じょうげん /上限/上弦/
じょうこ /上古/
じょうこう /条項/上皇/乗降/情交/
じょうこく /上告/
じょうこくきかん /上告期間/
じょうこくしん /上告審/
じょうこくにん /上告人/
じょうこしゃそ /城狐社鼠/
じょうこん /乗根/上根/
じょうご /上戸/漏斗/畳語/
じょうごう /乗号/
じょうごわ /情強/
じょうさい /城塞/城砦/
じょうさく /上策/上作/
じょうさし /状差し/
じょうさん /蒸散/
じょうざ /上座/常座/
じょうざい /錠剤/浄財/常在/浄罪/
じょうざん /乗算/
じょうざんけい /定山渓/
じょうし /上司/上梓/城址/城市/上肢/情死/上使/
じょうしき /常識/定式/
じょうしつ /上質/
じょうしゃ /乗車/盛者/浄写/
じょうしゃぐち /乗車口/
じょうしゃけん /乗車券/
じょうしゅ /城主/情趣/
じょうしゅう /上州/常習/常州/城州/
じょうしゅうはん /常習犯/
じょうしゅび /上首尾/
じょうしょ /上書/情緒/浄書/
じょうしょう /上昇/丞相/常勝/
じょうしょく /常食/
じょうしょてんめん /情緒纏綿/
じょうしん /上申/上進/
じょうしんえつ /上信越/
じょうじ /常時/情事/貞治/畳字/
じょうじつ /情実/
じょうじゅ /成就/上寿/
じょうじゅう /常住/
じょうじゅうふだん /常住不断/
じょうじゅつ /上述/
じょうじゅん /上旬/
じょうじょ /乗除/
じょうじょう /上々/上場/上乗/情状/嫋嫋/上上/条条/烝烝/常状/常常/常情/畳畳/擾擾/穣穣/
じょうじん /常人/成尋/情人/
じょうすい /上水/浄水/
じょうすいじょう /浄水場/
じょうすいち /浄水池/
じょうすいどう /上水道/
じょうすう /乗数/常数/
じょうすうこうか /乗数効果/
じょうず /上手/
じょうせい /情勢/醸成/状勢/上製/
じょうせいほん /上製本/
じょうせき /定跡/定石/上席/乗積/定席/
じょうせつ /常設/
じょうせん /乗船/情宣/上船/
じょうぜつ /饒舌/
じょうそ /上訴/
じょうそう /上層/情操/上奏/常総/情想/
じょうそううん /上層雲/
じょうそけん /上訴権/
じょうぞう /醸造/
じょうぞうしゅ /醸造酒/
じょうたい /状態/常態/上体/情態/上腿/
じょうたいず /状態図/
じょうたいへんか /状態変化/
じょうたいりょう /状態量/
じょうたつ /上達/
じょうたん /上端/
じょうだい /上代/城代/
じょうだま /上玉/
じょうだん /冗談/上段/
じょうち /上智/常置/城地/上地/上知/情致/情痴/
じょうちだいがく /上智大学/
じょうちゃく /蒸着/
じょうちゅう /常駐/
じょうちょ /情緒/
じょうちょう /冗長/情調/上長/
じょうちょく /常直/
じょうてい /上程/上帝/上底/
じょうてもの /上手物/
じょうてん /上天/
じょうてんき /上天気/
じょうでき /上出来/
じょうと /譲渡/
じょうとう /常套/上等/城東/上棟/
じょうとうしき /上棟式/
じょうとうしゅだん /常套手段/
じょうとうへい /上等兵/
じょうとく /常徳/
じょうとくい /上得意/常得意/
じょうとしょとく /譲渡所得/
じょうとたんぽ /譲渡担保/
じょうど /浄土/
じょうどう /常道/情動/成道/
じょうどがはま /浄土ヶ浜/
じょうどきょう /浄土教/
じょうどしゅう /浄土宗/
じょうどしんしゅう /浄土真宗/
じょうどじ /浄土寺/
じょうない /場内/城内/
じょうにん /常任/
じょうにんいいん /常任委員/
じょうねつ /情熱/
じょうねん /情念/
じょうのう /上納/
じょうはく /上白/上膊/
じょうはつ /蒸発/
じょうはつざら /蒸発皿/
じょうはん /上半/
じょうはんしん /上半身/
じょうば /乗馬/
じょうばこ /状箱/
じょうばん /常磐/定盤/
じょうばんせん /常磐線/
じょうひ /上皮/冗費/
じょうひん /上品/
じょうび /常備/
じょうびぐん /常備軍/
じょうびやく /常備薬/
じょうふ /情夫/情婦/上布/丈夫/
じょうふく /浄福/
じょうふんべつ /上分別/
じょうぶ /丈夫/上部/
じょうぶくろ /状袋/
じょうぶこうぞう /上部構造/
じょうぶつ /成仏/
じょうぶん /条文/上聞/冗文/
じょうへい /城兵/
じょうへき /城壁/
じょうへん /上編/
じょうほ /譲歩/
じょうほう /情報/上方/乗法/定法/常法/
じょうほうか /情報科/
じょうほうかがく /情報科学/
じょうほうきき /情報機器/
じょうほうきょく /情報局/
じょうほうけんさく /情報検索/
じょうほうげん /情報源/
じょうほうし /情報誌/
じょうほうしょり /情報処理/
じょうほうそうさ /情報操作/
じょうほうつう /情報通/
じょうほうもう /情報網/
じょうほうりろん /情報理論/
じょうまえ /錠前/
じょうまん /冗漫/
じょうみ /情味/
じょうみゃく /静脈/
じょうみゃくけつ /静脈血/
じょうみょう /定命/
じょうみん /常民/
じょうむ /常務/乗務/
じょうむいん /乗務員/
じょうめん /上面/
じょうもう /上毛/
じょうもく /条目/
じょうもの /上物/
じょうもん /城門/縄文/定紋/
じょうもんじだい /縄文時代/
じょうもんどき /縄文土器/
じょうや /常夜/
じょうやく /条約/
じょうやくかいせい /条約改正/
じょうやとい /常雇い/
じょうやど /常宿/定宿/
じょうよ /剰余/譲与/丈余/
じょうよう /城陽/常用/乗用/
じょうようかんじ /常用漢字/
じょうようしゃ /乗用車/
じょうようたいすう /常用対数/
じょうよかち /剰余価値/
じょうよきん /剰余金/
じょうよく /情欲/
じょうらく /上洛/常楽/
じょうらん /擾乱/上覧/
じょうらんずもう /上覧相撲/
じょうり /条理/条里/常理/情理/
じょうりく /上陸/
じょうりゃく /上略/
じょうりゅう /上流/蒸留/蒸溜/
じょうりゅうしゅ /蒸留酒/
じょうりゅうすい /蒸留水/
じょうりょく /常緑/
じょうりょくじゅ /常緑樹/
じょうるり /浄瑠璃/
じょうるりぼん /浄瑠璃本/
じょうれい /常例/条例/条令/
じょうれん /常連/定連/
じょうろ /如雨露/
じょうろう /上臈/
じょうろく /丈六/
じょうわ /情話/貞和/
じょうわん /上腕/
じょえん /助演/
じょおう /女王/
じょおうばち /女王蜂/
じょかん /女官/
じょがい /除外/
じょがくせい /女学生/
じょがっこう /女学校/
じょきゅう /女給/
じょきょ /除去/
じょきょうじゅ /助教授/
じょきょく /序曲/
じょく /辱/
じょくそう /褥瘡/
じょくち /辱知/
じょくふ /褥婦/
じょくれい /縟礼/
じょくん /叙勲/
じょけい /叙景/女系/
じょけつ /女傑/
じょけん /女権/
じょけんはんけつ /除権判決/
じょげん /助言/序言/
じょこう /徐行/女工/
じょごう /除号/
じょさい /如才/助祭/
じょさんぷ /助産婦/
じょざん /除算/
じょし /女子/助詞/女史/序詞/序詩/
じょしつ /除湿/
じょしゃく /叙爵/
じょしゅ /助手/
じょしゅう /女囚/徐州/
じょしゅせき /助手席/
じょしょう /序章/女将/
じょしょく /女色/
じょしん /女真/女神/
じょじ /女児/叙事/助辞/助字/序次/
じょじし /叙事詩/
じょじゅつ /叙述/
じょじょ /徐々/
じょじょう /叙情/抒情/如上/
じょじょうし /抒情詩/
じょじょうふ /女丈夫/
じょすう /除数/序数/
じょすうし /助数詞/序数詞/
じょせい /女性/助成/女声/助勢/女婿/
じょせいご /女性語/
じょせいてき /女性的/
じょせいと /女生徒/
じょせき /除籍/除斥/
じょせききかん /除斥期間/
じょせつ /序説/除雪/叙説/
じょせつしゃ /除雪車/
じょそう /女装/序奏/除草/助走/助奏/
じょそうざい /除草剤/
じょそんだんぴ /女尊男卑/
じょたい /除隊/
じょちゅう /女中/
じょちゅうぎく /除虫菊/
じょちょう /助長/
じょてい /女帝/
じょどうし /助動詞/
じょなん /女難/
じょにだん /序二段/
じょにん /叙任/
じょのくち /序の口/
じょはきゅう /序破急/
じょばん /序盤/
じょぶん /序文/
じょほう /除法/叙法/
じょまく /序幕/
じょまくしき /除幕式/
じょみゃく /徐脈/
じょめい /除名/助命/
じょや /除夜/
じょやく /助役/
じょやのかね /除夜の鐘/
じょゆう /女優/
じょりゅう /女流/
じょりゅうぶんがく /女流文学/
じょりょく /助力/
じょれつ /序列/
じょろう /女郎/
じょろん /序論/
じよ /時余/
じよう /滋養/自養/
じらい /地雷/爾来/
じらいや /児雷也/
じり /事理/
じりき /自力/地力/
じりきしゅう /自力宗/
じりだか /じり高/
じりつ /自立/自律/而立/
じりつご /自立語/
じりつしんけい /自律神経/
じりひん /じり貧/
じりやす /じり安/
じりゅう /自流/時流/
じりょう /寺領/
じりょく /磁力/
じりょくけい /磁力計/
じりょくせん /磁力線/
じりん /字林/辞林/
じるい /字類/
じるこにうむ /Zirconium/
じるし /印/
じれい /事例/辞令/
じろう /痔瘻/耳漏/二郎/次郎/
じろん /持論/時論/
じわり /地割/
じわれ /地割れ/
じん /人/尽/陣/迅/腎/甚/尋/壬/塵/刃/仁/神/臣/仞/靭/訊/
じんあい /仁愛/塵埃/
じんい /人為/人意/
じんいてき /人為的/
じんいん /人員/
じんいんせいり /人員整理/
じんう /腎盂/
じんうえん /腎盂炎/
じんえい /陣営/
じんえん /腎炎/人煙/
じんか /人家/
じんかい /燼灰/塵芥/人界/塵界/
じんかいせんじゅつ /人海戦術/
じんかく /人格/
じんかくけん /人格権/
じんかくしゃ /人格者/
じんかん /人間/
じんがい /人外/塵外/
じんがいきょう /人外境/
じんがさ /陣笠/
じんきょ /腎虚/
じんきょう /人境/
じんぎ /仁義/神器/
じんく /甚句/
じんくん /人君/
じんぐう /神宮/
じんぐうこうごう /神功皇后/
じんぐうしちょう /神宮司庁/
じんぐうじ /神宮寺/
じんけい /陣形/仁兄/仁恵/
じんけつ /人傑/
じんけん /人権/人件/人絹/
じんけんじゅうりん /人権蹂躙/
じんけんせんげん /人権宣言/
じんけんひ /人件費/
じんこう /人工/人口/人皇/沈香/
じんこうえいせい /人工衛星/
じんこうかいすい /人工海水/
じんこうこうう /人工降雨/
じんこうしば /人工芝/
じんこうじゅせい /人工受精/人工授精/
じんこうぞうき /人工臓器/
じんこうちのう /人工知能/
じんこうてき /人工的/
じんこうとうせき /人工透析/
じんこうどうたい /人口動態/
じんこうみつど /人口密度/
じんこうりん /人工林/
じんこうわくせい /人工惑星/
じんこつ /人骨/
じんご /人後/人語/
じんごじ /神護寺/
じんさい /人災/
じんざい /人材/
じんしゅ /人種/
じんしゅさべつ /人種差別/
じんしん /人身/壬申/人心/人臣/
じんしんじこ /人身事故/
じんしんばいばい /人身売買/
じんじ /人事/神事/仁慈/
じんじいいんかい /人事委員会/
じんじいどう /人事異動/
じんじいん /人事院/
じんじこうか /人事考課/
じんじそしょう /人事訴訟;婚姻、養子縁組、親子関係などに関する民事訴訟/
じんじつ /尽日/
じんじふせい /人事不省;意識不明/
じんじゃ /神社/
じんじゃほんちょう /神社本庁/
じんじゅ /人寿/
じんじゅつ /仁術/
じんじょ /仁恕/
じんじょう /尋常/
じんじょういちよう /尋常一様/
じんせい /人生/人世/
じんせいかん /人生観/
じんせいこうろ /人生行路/
じんせき /人跡/
じんせん /人選/仁川/
じんそく /迅速/
じんぞう /腎臓/人造/
じんぞうえん /腎臓炎/
じんぞうけっせき /腎臓結石/
じんぞうにんげん /人造人間/
じんたい /人体/靱帯/
じんだい /甚大/神代/
じんだいこ /陣太鼓/
じんだいじ /深大寺/
じんち /陣地/人知/人智/
じんちく /人畜/
じんちゅう /陣中/尽忠/
じんちょうげ /沈丁花/
じんつう /陣痛/
じんつうがわ /神通川/
じんつうりき /神通力/
じんてい /人定/
じんていしつもん /人定質問/
じんていじんもん /人定尋問/
じんてき /人的/
じんてきしげん /人的資源/
じんてきしょうこ /人的証拠/
じんてん /人天/
じんとう /陣頭/人頭/
じんとうしき /陣頭指揮/
じんとうぜい /人頭税/
じんとく /人徳/仁徳/
じんとり /陣取り/
じんどう /人道/仁道/
じんどうてき /人道的/
じんない /陣内/
じんば /人馬/陣場/
じんばおり /陣羽織/
じんぱい /塵肺/
じんぴん /人品/
じんふぜん /腎不全/
じんぶつ /人物/
じんぶつが /人物画/
じんぶん /人文/
じんぶんかがく /人文科学/
じんぶんちりがく /人文地理学/
じんぷう /陣風/仁風/
じんぷん /人糞/
じんべえ /甚兵衛/
じんぼう /人望/神保/
じんぼつ /陣没/
じんぽんしゅぎ /人本主義/
じんまく /陣幕/
じんましん /蕁麻疹/
じんみゃく /人脈/
じんみん /人民/
じんみんにっぽう /人民日報/
じんむ /神武/
じんめい /人名/人命/
じんめいぼ /人名簿/
じんめん /人面/
じんめんじゅうしん /人面獣心/
じんもん /尋問/訊問/陣門/
じんや /陣屋/
じんよう /陣容/
じんらい /人籟/迅雷/
じんりき /人力/
じんりきしゃ /人力車/
じんりょく /尽力/人力/
じんりん /人倫/
じんるい /人類/
じんるいあい /人類愛/
じんるいがく /人類学/
じんれつ /陣列/
じんろく /甚六/
す /素/須/子/守/巣/酢/州/主/数/洲/栖/簾/笥/諏/
すあし /素足/
すい /水/吹/錘/錐/酔/遂/衰/粋/睡/炊/推/帥/垂/出/穂/膵/騅/酸い/翠/
すいあげ /吸上げ/
すいあつ /水圧/
すいい /推移/水位/
すいいき /水域/
すいいりつ /推移律/
すいうん /衰運/水運/
すいえい /水泳/
すいえん /水煙/炊煙/
すいおん /水温/
すいおんけい /水温計/
すいか /誰何/西瓜/垂下/水瓜/水火/水禍/
すいかん /水管/酔漢/吹管/
すいがい /水害/
すいがら /吸殻/
すいがん /酔眼/
すいきゃく /酔客/
すいきゅう /水球/
すいきょ /推挙/
すいきょう /酔狂/粋狂/
すいきんくつ /水琴窟/
すいぎゅう /水牛/
すいぎょ /水魚/
すいぎょく /翠玉/
すいぎん /水銀/
すいぎんちゅう /水銀柱/
すいぎんでんち /水銀電池/
すいぎんとう /水銀灯/
すいくち /吸口/
すいくん /垂訓/
すいぐん /水軍/
すいけい /水系/推計/
すいけん /水圏/
すいげつ /水月/
すいげん /水源/
すいこ /推古/
すいこう /遂行/推敲/推考/水行/
すいこでん /水滸伝/
すいごう /水郷/
すいさい /水彩/水災/
すいさいが /水彩画/
すいさつ /推察/
すいさん /水産/推算/炊爨/推参/
すいさんか /水酸化/
すいさんか> /水酸化/
すいさんかぶつ /水酸化物/
すいさんぎょう /水産業/
すいさんしげん /水産資源/
すいさんちょう /水産庁/
すいさんぶつ /水産物/
すいざん /衰残/
すいし /水死/
すいしつ /水質/
すいしつおだく /水質汚濁/
すいしゃ /水車/
すいしゅ /水腫/
すいしょう /推奨/水晶/推賞/水漿/推称/
すいしょうきゅう /水晶宮/
すいしょうたい /水晶体/
すいしょく /水色/衰色/
すいしん /推進/水深/垂心/
すいしんき /推進器/
すいしんざい /推進剤/
すいしんりょく /推進力/
すいじ /炊事/垂示/
すいじゃく /衰弱/垂迹/
すいじゅん /水準/
すいじゅんき /水準器/
すいじゅんぎ /水準儀/
すいじょう /水上/穂状/錐状/
すいじょうかじょ /穂状花序/
すいじょうき /水蒸気/水上機/
すいじん /粋人/水神/
すいす /瑞西/
すいせい /水星/水性/彗星/水勢/水棲/水生/水声/衰勢/
すいせいがん /水成岩/
すいせいとりょう /水性塗料/
すいせいむし /酔生夢死/
すいせん /推薦/垂線/水洗/水仙/
すいせんにゅうがく /推薦入学/
すいぜん /垂涎/
すいぜんじこうえん /水前寺公園/
すいそ /水素/
すいそう /水槽/吹奏/水葬/水草/
すいそうがく /吹奏楽/
すいそうがくだん /吹奏楽団/
すいそく /推測/
すいそけつごう /水素結合/
すいそばくだん /水素爆弾/
すいそん /水損/
すいぞう /膵臓/
すいぞくかん /水族館/
すいた /吹田/
すいたい /衰退/錐体/酔態/推戴/
すいたいろ /錐体路/
すいだし /吸出し/
すいだん /推断/
すいち /推知/
すいちゅう /水中/水柱/
すいちゅうめがね /水中眼鏡/
すいちゅうよくせん /水中翼船/
すいちょう /水鳥/推重/
すいちょうこうけい /翠帳紅閨/
すいちょく /垂直/
すいちょくせん /垂直線/
すいちょくびよく /垂直尾翼/
すいてい /推定/水底/
すいてき /水滴/
すいてん /水天/
すいてんぐう /水天宮/
すいてんほうふつ /水天彷彿/
すいでん /水田/
すいとう /水筒/出納/水稲/水痘/膵島/
すいとうしょう /水頭症/
すいとうちょう /出納長/
すいとうぼ /出納簿/
すいとん /水団/
すいどう /水道/隧道/
すいなん /水難/
すいのう /水嚢/
すいはん /炊飯/垂範/水飯/
すいはんき /炊飯器/
すいはんきゅう /水半球/
すいばいか /水媒花/
すいばく /水爆/
すいばら /杉原/
すいばん /水盤/
すいひ /水肥/
すいひつ /水筆/
すいび /衰微/
すいふ /水夫/水府/炊夫/炊婦/
すいふく /推服/
すいぶん /水分/
すいへい /水平/水兵/
すいへいきょり /水平距離/
すいへいしゃ /水平社/
すいへいせん /水平線/
すいへいどう /水平動/
すいへいびよく /水平尾翼/
すいへいめん /水平面/
すいへん /水辺/
すいほ /酔歩/
すいほう /水泡/水疱/
すいぼう /衰亡/水防/
すいぼく /水墨/
すいぼくが /水墨画/
すいぼつ /水没/
すいま /睡魔/水魔/
すいまつ /水沫/
すいみつ /水密/水蜜/
すいみつかくへき /水密隔壁/
すいみつとう /水蜜桃/
すいみつひ /水密扉/
すいみゃく /水脈/
すいみん /睡眠/
すいみんやく /睡眠薬/
すいめい /水明/吹鳴/
すいめつ /衰滅/
すいめん /水面/錐面/
すいめんか /水面下/
すいもの /吸物/
すいもん /水門/
すいやく /水薬/
すいよ /酔余/睡余/
すいよう /水曜/水溶/
すいようえき /水溶液/水様液/
すいようせい /水溶性/
すいようび /水曜日/
すいよく /水浴/
すいらい /水雷/
すいらん /翠嵐/
すいり /推理/水利/
すいりく /水陸/
すいりけん /水利権/
すいりしょうせつ /推理小説/
すいりゅう /水流/垂柳/
すいりょう /水量/推量/
すいりょく /水力/推力/翠緑/
すいりょくはつでん /水力発電/
すいれい /水冷/
すいれん /睡蓮/水練/
すいろ /水路/
すいろぶ /水路部/
すいろん /推論/水論/
すう /数/趨/枢/崇/鄒/雛/嵩/
すう> /数/
すうぇーでん /瑞典/
すうがく /数学/
すうがくきそろん /数学基礎論/
すうき /数奇/枢機/
すうけい /崇敬/
すうこ /数個/
すうこう /崇高/趨向/
すうこく /数刻/
すうし /数詞/
すうしき /数式/
すうじ /数字/数次/
すうじく /枢軸/
すうじくこく /枢軸国/
すうじつ /数日/
すうせい /趨勢/
すうた /数多/
すうたい /素謡/
すうだん /数段/
すうち /数値/
すうちかいせき /数値解析/
すうちょくせん /数直線/
すうちよほう /数値予報/
すうとう /数等/
すうにん /数人/
すうねん /数年/
すうはい /崇拝/
すうひょう /数表/
すうふん /数分/
すうみつ /枢密/
すうみついん /枢密院/
すうめい /数名/
すうよう /枢要/
すうり /数理/
すうりけいかくほう /数理計画法/
すうりてつがく /数理哲学/
すうりょう /数量/
すうりろんりがく /数理論理学/
すうれつ /数列/
すえ /末/陶/
すえおき /据置き/
すえかわ /末川/
すえぜん /据え膳/
すえっこ /末っ子/
すえつぐ /末次/
すえつむはな /末摘花/
すえの /末野/
すえひろ /末広/末弘/
すえひろがり /末広がり/
すえまつ /末松/
すえよし /末吉/
すおう /周防/
すおういろ /蘇芳色/
すおうなだ /周防灘/
すかがわ /須賀川/
すかさず /透かさず/
すかんぴん /素寒貧/
すが /菅/
すがい /酢貝/
すがお /素顔/
すがすが /清々/
すがた /姿/
すがたかたち /姿形/
すがたに /姿煮/
すがたみ /姿見/
すがたり /素語り/
すがぬま /菅沼/
すがの /菅野/
すがも /巣鴨/
すがわら /菅原/
すがわらのみちざね /菅原道真/
すき /隙/鋤/好き/犂/数寄/
すきうつし /透き写し/
すきかって /好き勝手/
すききらい /好き嫌い/
すきぎ /透木/
すきぐし /梳櫛/
すきごころ /好き心/
すきしゃ /数寄者/
すきずき /好き好き/
すきっぱら /空きっ腹/
すきなべ /鋤鍋/
すきほうだい /好き放題/
すきま /隙間/透き間/
すきまかぜ /隙間風/
すきみ /透き見/
すきもの /好き者/
すきや /数奇屋/
すきやばし /数寄屋橋/
すぎ /椙/過ぎ/杉/
すぎうら /杉浦/
すぎがき /杉垣/
すぎた /杉田/
すぎたげんぱく /杉田玄白/
すぎど /杉戸/
すぎなみ /杉並/
すぎはら /杉原/
すぎはらがみ /杉原紙/
すぎむら /杉村/
すぎやま /杉山/
すぎわら /杉原/
すくいなげ /掬い投げ/
すくいぬし /救い主/
すくな /少な/
すくない /少ない/
すくなくとも /少なくとも/
すくね /宿禰/
すくも /宿毛/
すぐ /直ぐ/
すぐは /直刃/
すぐり /村主/
すけ /助/介/
すけだち /助太刀/
すけっと /助っ人/
すけべえ /助兵衛/
すけむね /助宗/
すけろく /助六/
すけん /素見/
すげ /菅/
すこし /少し/
すこしも /少しも/
すこっとらんど /蘇格蘭/
すこぶる /頗る/頗/
すこやか /健やか/
すごい /凄い/
すごうで /凄腕/
すごみ /凄み/
すごろく /双六/
すさき /須崎/洲崎/
すさのおのみこと /須佐之男命/
すざか /須坂/
すざく /朱雀/
すし /鮨/鮓/
すしめし /鮨飯/
すじ /筋/
すじあい /筋合/
すじかい /筋交い/
すじがき /筋書/
すじがね /筋金/
すじがねいり /筋金入り/
すじこ /筋子/
すじだて /筋立/
すじちがい /筋違い/
すじぼね /筋骨/
すじみち /筋道/
すじむかい /筋向い/
すじむこう /筋向う/
すじめ /筋目/
すじゃく /朱雀/
すじょう /素性/素姓/
すす /煤/
すすき /薄/芒/
すすけ /煤け/
すすたけいろ /煤竹色/
すすめ /勧め/
すすりなき /啜り泣き/
すず /鈴/錫/珠洲/
すずか /鈴鹿/
すずかぜ /涼風/
すずかとうげ /鈴鹿峠/
すずき /鈴木/鱸/
すずきかんたろう /鈴木貫太郎/
すずこんしき /錫婚式/
すずし /生絹/
すずなり /鈴生り/
すずむし /鈴虫/
すずめ /雀/
すずめばち /雀蜂/
すずらん /鈴蘭/
すずり /硯/
すずりいし /硯石/
すずりばこ /硯箱/
すそ /裾/
すそとり /裾取り/
すその /裾野/
すそもよう /裾模様/
すそよけ /裾除け/
すそわけ /裾分け/
すたれ /廃れ/
すだ /須田/
すだこ /酢蛸/
すだち /巣立ち/
すだれ /簾/
すっとんきょう /素頓狂/
すっぱ /透波/
すっぱだか /素っ裸/
すっぽん /鼈/
すていん /捨て印/
すてうり /捨て売り/
すてがね /捨て金/
すてき /素敵/
すてご /捨て子/
すてぜりふ /捨て台詞/
すてどころ /捨て所/
すてね /捨て値/
すてみ /捨て身/
すてやく /捨役/
すで /素手/既/
すでに /既に/已に/
すとくいん /崇徳院/
すどうふ /酢豆腐/
すどおし /素通し/
すどおり /素通り/
すどまり /素泊り/
すな /沙/砂/
すなあらし /砂嵐/
すなえ /砂絵/
すなお /素直/
すながわ /砂川/
すなぎも /砂肝/
すなけむり /砂煙/
すなご /砂子/
すなじ /砂地/
すなどけい /砂時計/
すなはま /砂浜/
すなはら /砂原/
すなば /砂場/
すなぶろ /砂風呂/
すなぼこり /砂埃/
すなめり /砂滑/
すなやま /砂山/
すなわち /即ち/則ち/
すなわら /砂原/
すね /脛/臑/
すのまた /墨俣/
すのもの /酢の物/
すはだ /素肌/
すはだか /素裸/
すばこ /巣箱/
すばなし /素話/
すばなれ /巣離れ/
すばる /昴/
すびき /巣引/
すびつ /炭櫃/
すぶた /酢豚/
すぶり /素振り/
すべ /術/
すべからく /須く/
すべて /全て/総て/凡て/総/
すべりだい /滑り台/
すぺいん /西班牙/
すほん /素本/
すま /須磨/須万/
すまい /住まい/
すまた /素股/
すまたきょう /寸又峡/
すみ /隅/炭/墨/済み/角/
すみいろ /墨色/
すみえ /墨絵/
すみか /住処/
すみかえ /住替え/
すみじ /墨字/
すみずみ /隅々/
すみそ /酢味噌/
すみぞめ /墨染/
すみだ /墨田/
すみだがわ /隅田川/
すみっこ /隅っこ/
すみつき /墨付/
すみつぎ /墨継ぎ/
すみつぼ /墨壺/
すみながし /墨流し/
すみのくら /角倉/
すみのくらぼん /角倉本/
すみび /炭火/
すみぶと /墨太/
すみません /済みません/
すみやか /澄みやか/速やか/
すみやき /炭焼き/
すみよし /住吉/
すみよしじんじゃ /住吉神社/
すみれ /菫/
すみれいろ /菫色/
すめらぎ /天皇/
すめん /素面/
すもう /相撲/
すもうとり /相撲取/
すもぐり /素潜り/
すもと /洲本/
すもも /李/
すや /須屋/
すやき /素焼/
すやま /陶山/巣山/
すり /摺/刷/掏摸/
すりきず /擦傷/
すりこぎ /擂粉木/摺子木/
すりばち /擂鉢/
すりほん /刷本/
するが /駿河/
するがだい /駿河台/
するがばん /駿河版/
するがや /駿河屋/
するがわん /駿河湾/
するめ /鯣/
すろうにん /素浪人/
すわ /諏訪/
すわこ /諏訪湖/
すわじんじゃ /諏訪神社/
すわとう /汕頭/
すん /寸/
すんいん /寸陰/
すんか /寸暇/
すんげき /寸劇/寸隙/
すんげん /寸言/
すんこく /寸刻/
すんごう /寸毫/
すんし /寸志/
すんしゃく /寸尺/寸借/
すんしゅう /駿州/
すんしょ /寸書/
すんしんしゃくたい /寸進尺退/
すんじ /寸時/
すんぜん /寸前/
すんぜんしゃくま /寸善尺魔/
すんたらず /寸足らず/
すんだい /駿台/
すんだん /寸断/
すんち /寸地/
すんづまり /寸詰り/
すんてつ /寸鉄/
すんど /寸土/
すんばとうじん /寸馬豆人/
すんびょう /寸秒/寸描/
すんぴょう /寸評/
すんぶん /寸分/
すんぷ /駿府/
すんぽう /寸法/
すんれつ /寸裂/
すんわ /寸話/
ず /図/頭/豆/事/厨/
ずあん /図案/
ずい /髄/瑞/随/蕊/隋/蘂/
ずいい /随意/
ずいいきん /随意筋/
ずいいけいやく /随意契約/
ずいいち /随一/
ずいいん /随員/
ずいうん /瑞雲/
ずいえん /随縁/
ずいおう /瑞応/
ずいかん /随感/
ずいき /随喜/芋茎/
ずいこう /随行/瑞光/
ずいしょ /随所/
ずいしょう /瑞祥/
ずいじ /随時/
ずいじゅう /随従/
ずいじゅん /随順/
ずいそう /随想/
ずいちょう /瑞兆/
ずいのう /髄脳/
ずいはん /随伴/
ずいひつ /随筆/
ずいぶん /随分/
ずいほうしょう /瑞宝章/
ずいまく /髄膜/
ずいまくえん /髄膜炎/
ずいむし /螟虫/
ずいり /図入り/
ずうたい /図体/
ずえ /図会/図絵/
ずかい /図解/
ずかん /図鑑/
ずかんそくねつ /頭寒足熱/
ずが /図画/
ずがい /頭蓋/
ずがいこつ /頭蓋骨/
ずがら /図柄/
ずきん /頭巾/
ずけ /付/
ずけい /図形/
ずこう /図工/
ずさん /杜撰/
ずし /逗子/図示/厨子/
ずしき /図式/
ずしょ /図書/
ずしょのかみ /図書頭/
ずしょりょう /図書寮/
ずじゅう /頭重/
ずじょう /頭上/
ずせつ /図説/
ずぞう /図像/
ずぞうがく /図像学/
ずつう /頭痛/
ずつき /頭突き/
ずどり /図取り/
ずのう /頭脳/図嚢/
ずはん /図版/
ずひょう /図表/
ずふ /図譜/
ずぶぬれ /ずぶ濡れ/
ずぼし /図星/
ずみ /桷/
ずめん /図面/
ずよう /図様/
ずりょう /受領/
ずろく /図録/
ずんどう /寸胴/
せ /世/背/瀬/畝/施/脊/
せい /生/声/世/星/成/性/西/製/正/姓/青/勢/斉/静/逝/請/誓/誠/聖/精/盛/清/棲/晴/整/政/征/制/省/歳/情/婿/背/牲/所為/旌/井/醒/栖/凄/
せい> /性/正/
せいあい /性愛/
せいあくせつ /性悪説/
せいあつ /制圧/静圧/
せいあん /成案/西安/
せいい /誠意/征夷/勢威/
せいいき /声域/聖域/西域/
せいいく /成育/生育/
せいいっぱい /精一杯/
せいいつ /斉一/
せいいん /成員/正員/成因/
せいう /晴雨/
せいうん /青雲/星雲/盛運/
せいえい /清栄/精鋭/盛栄/
せいえき /精液/
せいえん /声援/製塩/凄艶/
せいおう /西欧/
せいおん /清音/静穏/声音/
せいか /成果/西夏/精華/正価/正課/生家/生花/盛夏/聖火/製菓/青果/正貨/聖歌/声価/製靴/
せいかい /正解/盛会/政界/精解/青海/
せいかいけん /制海権/
せいかがく /生化学/
せいかく /正確/性格/精確/製革/正格/政客/
せいかじゅう /静荷重/
せいかたい /聖歌隊/
せいかたんでん /臍下丹田/
せいかつ /生活/
せいかつか /生活科/
せいかつかん /生活環/
せいかつかんきょう /生活環境/
せいかつきゅう /生活給/
せいかつく /生活苦/
せいかつくうかん /生活空間/
せいかつしどう /生活指導/
せいかつすいじゅん /生活水準/
せいかつたいど /生活態度/
せいかつなん /生活難/
せいかつひ /生活費/
せいかつりょく /生活力/
せいかぶつ /青果物/
せいかん /青函/静観/生還/製缶/精悍/精管/性感/清閑/盛観/
せいかんたい /性感帯/
せいかんぶっしつ /星間物質/
せいかんろん /征韓論/
せいが /清雅/
せいがいは /青海波/
せいがく /声楽/聖楽/
せいがん /請願/西岸/正眼/青眼/晴眼/誓願/
せいがんけん /請願権/
せいがんざい /制癌剤/
せいき /世紀/正規/生気/生起/精気/精機/性器/星紀/西紀/成規/盛期/正気/清規/
せいきぐん /正規軍/
せいきぶんぷ /正規分布/
せいきまつ /世紀末/
せいきゅう /請求/性急/制球/
せいきゅうけん /請求権/
せいきゅうしょ /請求書/
せいきょ /逝去/盛挙/
せいきょう /生協/盛況/正教/聖教/清興/精強/
せいきょういく /性教育/
せいきょうかい /正教会/
せいきょうと /清教徒/
せいきょうぶんり /政教分離/
せいきょく /政局/
せいきん /精勤/
せいぎ /正義/盛儀/精義/
せいぎかん /正義感/
せいぎょ /制御/成魚/制禦/生魚/
せいぎょう /成業/盛業/正業/生業/聖業/
せいぎょく /青玉/
せいぎょそうち /制御装置/
せいぎょぼう /制御棒/
せいく /成句/
せいくうけん /制空権/
せいくらべ /背比べ/
せいくん /正訓/請訓/
せいけ /清家/
せいけい /整形/成形/政経/生計/成蹊/成型/西経/正系/
せいけいげか /整形外科/
せいけつ /清潔/
せいけん /政権/政見/生検/
せいげん /制限/正弦/誓言/
せいげんは /正弦波/
せいこう /成功/製鋼/性交/精巧/精工/正孔/性向/生硬/政綱/西郊/性行/
せいこうい /性行為/
せいこううき /晴好雨奇/
せいこううどく /晴耕雨読/
せいこうとうてい /西高東低/
せいこうほう /正攻法/
せいこく /正鵠/
せいこつ /整骨/
せいこん /成婚/精魂/精根/
せいご /正誤/生後/成語/
せいごう /整合/正号/
せいごうせい /整合性/
せいごひょう /正誤表/
せいごぶん /正誤文/
せいごん /誓言/
せいさ /性差/精査/
せいさい /制裁/正妻/精細/生彩/精彩/
せいさいぼう /性細胞/精細胞/
せいさく /製作/政策/制作/精索/
せいさつ /制札/省察/精察/
せいさつよだつ /生殺与奪/
せいさん /生産/精算/清算/凄惨/成算/青酸/正餐/聖餐/製産/悽惨/制酸/
せいさんかかく /生産価格/
せいさんかっけい /正三角形/
せいさんかり /青酸加里/
せいさんかんり /生産管理/
せいさんざい /生産財/
せいさんしゃ /生産者/
せいさんしょとく /清算所得/
せいさんせい /生産性/
せいさんてき /生産的/
せいさんにん /清算人/
せいさんひ /生産費/
せいさんほうじん /清算法人/
せいさんようそ /生産要素/
せいさんりょく /生産力/
せいざ /星座/正座/
せいざい /製材/製剤/
せいざん /青山/
せいし /正視/精子/静止/制止/正史/生死/製紙/姓氏/製糸/西施/誓紙/誓詞/正使/勢至/静思/整枝/
せいしえいせい /静止衛星/
せいしが /静止画/
せいしき /正式/制式/整式/清拭/
せいしきさいばん /正式裁判/
せいししつりょう /静止質量/
せいしつ /性質/正室/
せいしまさつ /静止摩擦/
せいしめんたい /正四面体/
せいしゃ /生者/斉射/
せいしゃえい /正射影/
せいしゅ /清酒/
せいしゅく /静粛/整粛/静淑/星宿/
せいしゅん /青春/
せいしょ /清書/正書/聖書/青書/盛暑/誓書/成書/
せいしょう /清祥/清勝/斉唱/政商/制勝/
せいしょうき /西廂記/
せいしょうなごん /清少納言/
せいしょうねん /青少年/
せいしょく /生殖/聖職/生食/生色/声色/青色/
せいしょくき /生殖器/
せいしょくさいぼう /生殖細胞/
せいしょくしゃ /聖職者/
せいしょくせん /生殖腺/
せいしょほう /正書法/
せいしん /精神/誠心/清心/清新/誠信/星辰/生新/成心/
せいしんいがく /精神医学/
せいしんえいせい /精神衛生/
せいしんか /精神科/
せいしんかい /精神界/
せいしんし /精神史/
せいしんしゅぎ /精神主義/
せいしんすいじゃく /精神衰弱/
せいしんてき /精神的/
せいしんねんれい /精神年齢/
せいしんはくじゃく /精神薄弱/
せいしんびょう /精神病/
せいしんびょういん /精神病院/
せいしんびょうしつ /精神病質/
せいしんぶんか /精神文化/
せいしんぶんせき /精神分析/
せいしんりょく /精神力/
せいしんろん /精神論/
せいじ /政治/正字/青磁/盛事/盛時/
せいじか /政治家/
せいじがく /政治学/
せいじけっしゃ /政治結社/
せいじけんきん /政治献金/
せいじけんりょく /政治権力/
せいじだんたい /政治団体/
せいじつ /誠実/
せいじてき /政治的/
せいじてつがく /政治哲学/
せいじはん /政治犯/
せいじゃ /聖者/正邪/
せいじゃく /静寂/
せいじゅう /西戎/
せいじゅうろう /清十郎/
せいじゅく /成熟/
せいじゅくぶんれつ /成熟分裂/
せいじゅくらん /成熟卵/
せいじゅん /清純/
せいじょ /聖女/整除/
せいじょう /正常/清浄/政情/性状/性情/
せいじょううえ /正条植え/
せいじょうか /正常化/
せいじょうき /星条旗/
せいじょうたい /星状体/
せいじりょく /政治力/
せいじん /成人/聖人/
せいじんしき /成人式/
せいじんびょう /成人病/
せいすい /盛衰/静水/清水/精粋/
せいすう /整数/正数/
せいすうろん /整数論/
せいず /星図/製図/
せいずい /精髄/
せいずばん /製図板/
せいせい /生成/正々/清々/精製/生々/正声/凄凄/悽悽/
せいせいかつ /性生活/
せいせいどうどう /正々堂々/正正堂堂/
せいせいぶんぽう /生成文法/
せいせいるてん /生生流転/
せいせき /成績/
せいせきひょう /成績表/
せいせっかい /生石灰/
せいせつ /正接/
せいせん /清泉/生鮮/精選/聖戦/井泉/性腺/征戦/政戦/
せいせんしょくたい /性染色体/
せいぜつ /凄絶/
せいぜん /整然/生前/正善/凄然/
せいぜんこうい /生前行為/
せいぜんしょぶん /生前処分/
せいぜんせつ /性善説/
せいそ /清楚/凄楚/精粗/世祖/
せいそう /清掃/正装/成層/政争/盛装/星霜/悽愴/精巣/清爽/
せいそうかざん /成層火山/
せいそうき /西廂記/
せいそうけん /成層圏/
せいそく /棲息/生息/正則/栖息/悽惻/
せいそくかんすう /正則関数/
せいぞう /製造/聖像/
せいぞうぎょう /製造業/
せいぞく /正続/
せいぞろい /勢揃い/
せいぞん /生存/
せいぞんきょうそう /生存競争/
せいぞんけん /生存権/
せいた /清田/背板/
せいたい /生態/生体/声帯/正対/政体/静態/整体/成体/聖体/
せいたいがく /生態学/
せいたいけい /生態系/
せいたいはんのう /生体反応/
せいたいまく /生体膜/
せいたいもしゃ /声帯模写/
せいたかっけい /正多角形/
せいたく /請託/
せいためんたい /正多面体/
せいたん /生誕/製炭/
せいたんさい /聖誕祭/
せいだい /盛大/正大/
せいだく /清濁/
せいだん /政談/星団/清談/聖壇/
せいち /聖地/整地/生地/精緻/
せいちあんこう /生知安行/
せいちゃ /製茶/
せいちゃく /正嫡/
せいちゅう /正中/成虫/掣肘/精虫/誠忠/
せいちゅうめん /正中面/
せいちょう /成長/整調/静聴/正調/生長/清帳/声調/清澄/整腸/性徴/政庁/清朝/清聴/
せいちょうかぶ /成長株/
せいちょうてん /生長点/
せいつう /精通/
せいてい /制定/聖帝/
せいてき /静的/性的/政敵/正嫡/清適/
せいてつ /製鉄/
せいてつじょ /製鉄所/
せいてん /晴天/盛典/性典/聖典/青天/
せいてんかん /性転換/
せいてんはくじつ /青天白日/
せいでん /静電/正殿/正伝/井田/
せいでんき /静電気/正電気/
せいでんようりょう /静電容量/
せいと /生徒/成都/征途/星斗/聖徒/
せいとう /正当/政党/正答/正統/製糖/精糖/征討/
せいとうか /正当化/
せいとうせい /正当性/
せいとうせいじ /政党政治/
せいとうないかく /政党内閣/
せいとうは /正統派/
せいとうぼうえい /正当防衛/
せいとうやじん /斉東野人/
せいとかい /生徒会/
せいとく /生得/成徳/聖徳/盛徳/
せいとくせつ /生得説/
せいとくてき /生得的/
せいとしどう /生徒指導/
せいとん /整頓/
せいど /制度/精度/西土/
せいどう /正道/制動/正堂/聖堂/青銅/生動/政道/精銅/
せいどうき /制動機/青銅器/
せいどうきじだい /青銅器時代/
せいどく /精読/西独/
せいどん /晴曇/
せいなん /西南/
せいなんせい /西南西/
せいなんにほん /西南日本/
せいにく /精肉/
せいねい /西寧/
せいねん /青年/生年/成年/盛年/
せいねんがっぴ /生年月日/
せいねんき /青年期/
せいねんしき /成年式/
せいねんだん /青年団/
せいのう /性能/
せいは /制覇/
せいはい /聖杯/成敗/
せいはく /精薄/精白/生魄/清白/
せいはくまい /精白米/
せいはちめんたい /正八面体/
せいはつ /整髪/
せいはん /製版/整版/正犯/
せいはんごう /正反合/
せいはんざい /性犯罪/
せいはんたい /正反対/
せいはんぼん /整版本/
せいばい /成敗/
せいばく /精麦/
せいばつ /征伐/
せいひ /正否/成否/性比/
せいひつ /静謐/省筆/
せいひょう /製氷/星表/
せいひょうき /製氷機/
せいひれい /正比例/
せいひん /製品/清貧/正賓/
せいび /整備/精美/精微/
せいびし /整備士/
せいびょう /性病/聖廟/
せいふ /政府/正負/
せいふう /清風/西風/
せいふく /制服/征服/正副/清福/整復/
せいふすじ /政府筋/
せいふほしょうさい /政府保証債/
せいふまい /政府米/
せいふん /製粉/
せいぶ /西部/声部/
せいぶげき /西部劇/
せいぶせんせん /西部戦線/
せいぶつ /生物/静物/
せいぶつかい /生物界/
せいぶつかがく /生物化学/
せいぶつが /静物画/
せいぶつがく /生物学/
せいぶつけん /生物圏/
せいぶつしゃかい /生物社会/
せいぶつのうやく /生物農薬/
せいぶつぶつりがく /生物物理学/
せいぶん /成分/成文/正文/
せいぶんほう /成文法/
せいへい /精兵/
せいへき /性癖/
せいへん /政変/正編/
せいべつ /性別/聖別/生別/
せいほ /生保/
せいほう /正方/製法/西方/青峰/
せいほうぎょうれつ /正方行列/
せいほうけい /正方形/
せいほく /西北/
せいほくせい /西北西/
せいほん /製本/正本/
せいぼ /歳暮/生母/聖母/
せいぼう /制帽/声望/
せいま /製麻/
せいまい /精米/
せいみつ /精密/
せいみつかがく /精密科学/
せいみつきかい /精密機械/
せいみょう /精妙/
せいむ /政務/
せいむじかん /政務次官/
せいめい /生命/姓名/声明/清明/声名/
せいめいしょ /声明書/
せいめいせん /生命線/
せいめいはんだん /姓名判断/
せいめいほけん /生命保険/
せいめいりょく /生命力/
せいめいりんり /生命倫理/
せいめん /製麺/
せいもん /正門/声紋/声門/誓文/
せいや /聖夜/征野/星夜/
せいやく /制約/誓約/製薬/成約/
せいゆ /製油/精油/
せいゆう /声優/西遊/清遊/
せいよう /静養/西洋/
せいようおんがく /西洋音楽/
せいようかん /西洋館/
せいようがく /西洋学/
せいようし /西洋紙/
せいようじん /西洋人/
せいよく /性欲/制欲/
せいらい /生来/
せいらん /晴嵐/青藍/青嵐/清覧/
せいり /整理/生理/
せいりがく /生理学/性理学/
せいりきがく /静力学/
せいりきゅうか /生理休暇/
せいりけん /整理券/
せいりつ /成立/
せいりてき /生理的/
せいりび /生理日/
せいりゃく /政略/
せいりゃくけっこん /政略結婚/
せいりゅう /整流/清流/青竜/
せいりゅうき /整流器/
せいりゅうし /整流子/
せいりょ /征旅/
せいりょう /声量/清涼/凄涼/凄寥/精良/
せいりょうざい /清涼剤/
せいりょうじ /清涼寺/
せいりょうでん /清涼殿/
せいりょく /勢力/精力/
せいりょくけん /勢力圏/
せいりょくぜつりん /精力絶倫/
せいりょくてき /精力的/
せいりょくはんい /勢力範囲/
せいるい /生類/声涙/
せいれい /政令/精霊/精励/生霊/聖霊/蜻蛉/制令/
せいれき /西暦/
せいれつ /整列/清冽/
せいれん /精錬/清廉/精練/製錬/
せいろ /蒸籠/
せいろう /晴朗/蒸籠/清朗/
せいろくめんたい /正六面体/
せいろん /正論/政論/
せいわ /清和/
せいわげんじ /清和源氏/
せおい /背負/
せおと /瀬音/
せかい /世界/
せかいかん /世界観/
せかいきろく /世界記録/
せかいし /世界史/
せかいしゅぎ /世界主義/
せかいじ /世界時/
せかいじゅう /世界中/
せかいぞう /世界像/
せかいたいせん /世界大戦/
せかいてき /世界的/
せがしら /瀬頭/
せがれ /倅/悴/
せがわ /瀬川/背革/
せき /昔/積/席/夕/関/寂/跡/赤/責/績/籍/石/析/斥/戚/惜/隻/堰/咳/碩/蹟/脊/
せきい /赤緯/
せきいん /石印/
せきうん /積雲/
せきえい /石英/隻影/
せきえん /積怨/
せきか /石果/
せきかく /刺客/
せきかん /石棺/
せきがいせん /赤外線/
せきがく /碩学/
せきがね /関金/
せきがはら /関ヶ原/
せきがん /隻眼/
せきぐち /関口/
せきぐん /赤軍/
せきこ /潟湖/
せきさい /積載/
せきさいぼう /石細胞/
せきさく /脊索/
せきさくどうぶつ /脊索動物/
せきさん /積算/
せきざい /石材/
せきしつ /石室/
せきしゅ /隻手/
せきしゅうごう /積集合/
せきしゅつ /析出/
せきしゅん /惜春/
せきしょ /関所/
せきしょうし /赤松子/
せきしょうせん /石勝線/
せきしょく /赤色/
せきしん /赤心/
せきじ /席次/昔時/
せきじつ /昔日/
せきじゅうじ /赤十字/
せきじゅうじしゃ /赤十字社/
せきじゅん /席順/石筍/
せきじょう /席上/関城/
せきじょうし /赤縄子/
せきすい /積水/
せきずい /脊髄/
せきずいはんしゃ /脊髄反射/
せきずいろう /脊髄癆/
せきせつ /積雪/
せきそうひん /積送品/
せきぞう /石像/石造/
せきたん /石炭/
せきたんき /石炭紀/
せきたんさん /石炭酸/
せきだい /席代/席題/
せきちく /石竹/
せきちくいろ /石竹色/
せきちゅう /脊柱/石柱/
せきちん /赤沈/
せきつい /脊椎/
せきついどうぶつ /脊椎動物/
せきてい /石庭/席亭/
せきてっこう /赤鉄鉱/
せきとう /石塔/
せきとり /関取/
せきど /関戸/
せきどう /赤道/
せきどうぎ /赤道儀/
せきどうちょっか /赤道直下/
せきにん /責任/
せきにんかん /責任感/
せきにんしゃ /責任者/
せきにんのうりょく /責任能力/
せきにんほけん /責任保険/
せきね /関根/
せきねつ /赤熱/
せきねん /積年/昔年/
せきの /関野/
せきのやま /関の山/
せきはい /惜敗/
せきはん /赤飯/
せきばく /寂寞/
せきばらい /咳払い/
せきばん /石版/石盤/
せきばんが /石版画/
せきひ /石碑/
せきひつ /石筆/
せきひん /赤貧/
せきふ /石斧/
せきぶつ /石仏/
せきぶん /積分/
せきべつ /惜別/
せきほうへんい /赤方偏移/
せきほん /石本/
せきぼく /石墨/
せきみず /関水/
せきむ /責務/
せきめん /赤面/石綿/
せきもり /関守/
せきもん /責問/
せきもんけん /責問権/
せきや /関屋/
せきやど /関宿/
せきやま /関山/
せきゆ /石油/
せきゆきき /石油危機/
せきら /赤裸/
せきらら /赤裸裸/赤裸々/
せきらんうん /積乱雲/
せきり /赤痢/石理/
せきりゅう /石榴/
せきりょう /寂寥/席料/脊梁/
せきりょく /斥力/
せきりょくしきもう /赤緑色盲/
せきりん /赤燐/
せきるい /石塁/
せきれい /鶺鴒/
せきろう /石蝋/
せきわけ /関脇/
せきわん /隻腕/
せぎょう /施行/
せけん /世間/
せけんぎ /世間気/
せけんし /世間師/
せけんしらず /世間知らず/
せけんずれ /世間擦れ/
せけんてい /世間体/
せけんてき /世間的/
せけんなみ /世間並/
せけんばなし /世間話/
せこ /世故/
せこう /施工/施行/
せさい /世才/
せしゅ /施主/
せしゅう /世襲/
せじ /世辞/世事/
せじょう /施錠/世情/世上/
せじり /瀬尻/
せじん /世人/世塵/
せすじ /背筋/
せそう /世相/
せそん /世尊/
せぞく /世俗/
せた /瀬田/
せたい /世帯/世態/
せたいぬし /世帯主/
せたがや /世田谷/
せたけ /背丈/
せだい /世代/
せだいこうたい /世代交代/
せち /節/世知/世智/
せちょう /背丁/
せっか /石火/石化/赤化/接架/
せっかい /節介/切開/石灰/雪塊/
せっかいがん /石灰岩/
せっかいすい /石灰水/
せっかいせき /石灰石/
せっかく /折角/刺客/
せっかはんりゅう /折花攀柳/
せっかん /折檻/石棺/摂関/
せっき /石器/節気/節季/
せっきじだい /石器時代/
せっきゃく /接客/
せっきゃくぎょう /接客業/
せっきょう /説教/説経/
せっきょうぶし /説経節/
せっきょく /積極/
せっきょくてき /積極的/
せっきん /接近/
せっく /節句/
せっくつ /石窟/
せっけ /摂家/
せっけい /設計/雪渓/雪景/
せっけいず /設計図/
せっけっきゅう /赤血球/
せっけん /石鹸/接見/席巻/席捲/節倹/
せっこう /石膏/拙稿/浙江/斥候/石工/
せっこつ /接骨/
せっさ /切磋/
せっさく /拙作/切削/拙策/
せっさたくま /切磋琢磨/
せっし /摂氏/切歯/℃/
せっしゃ /拙者/接写/
せっしやくわん /切歯扼腕/
せっしゅ /摂取/接種/窃取/截取/節酒/
せっしゅう /接収/雪舟/
せっしょう /折衝/殺生/摂政/
せっしょく /接触/節食/摂食/
せっしょくでんいさ /接触電位差/
せっすい /節水/
せっせい /摂生/節制/拙生/
せっせん /接戦/接線/切線/折線/雪線/
せっそう /節操/拙僧/切創/節奏/
せっそく /拙速/
せっそくどうぶつ /節足動物/
せっそん /折損/
せった /雪駄/
せったい /接待/
せったく /拙宅/
せっち /設置/接地/
せっちゃく /接着/
せっちゃくざい /接着剤/
せっちゅう /折衷/雪中/折中/
せっちょ /拙著/
せっちょうしゅう /節用集/
せっちん /雪隠/
せっつ /摂津/
せってい /設定/
せってん /接点/節点/
せっとう /窃盗/
せっとうご /接頭語/
せっとうじ /接頭辞/
せっとく /説得/
せっぱ /切羽/説破/
せっぱく /切迫/雪白/
せっぱん /折半/
せっぴ /雪庇/
せっぴつ /拙筆/
せっぴょう /雪氷/
せっぷく /切腹/説伏/
せっぷん /接吻/
せっぺん /切片/
せっぽう /説法/
せつ /雪/説/節/切/設/折/窃/摂/接/拙/殺/截/
せつえい /設営/拙詠/
せつえん /節煙/
せつがい /雪害/
せつがん /接岸/切願/
せつぎ /拙技/節義/
せつげん /節減/雪原/切言/
せつごう /接合/
せつごうし /接合子/
せつごうたい /接合体/
せつじ /接辞/説示/
せつじつ /切実/
せつじゅ /接受/
せつじゅつ /説述/
せつじょ /切除/
せつじょう /雪上/
せつじょうしゃ /雪上車/
せつじょく /雪辱/
せつせつ /切々/切切/
せつぜい /節税/
せつぞく /接続/
せつぞくご /接続語/
せつぞくし /接続詞/
せつぞくじょし /接続助詞/
せつぞくほう /接続法/
せつだい /設題/
せつだん /切断/
せつだんめん /切断面/
せつでん /節電/
せつど /節度/
せつどう /摂動/
せつどうろん /摂動論/
せつな /刹那/
せつない /切ない/
せつに /切に/
せつび /設備/
せつびご /接尾語/
せつびじ /接尾辞/
せつびとうし /設備投資/
せつぶん /節分/拙文/
せつへいめん /接平面/
せつぼう /切望/
せつめい /説明/
せつめいぶん /説明文/
せつもん /設問/説文/
せつもんかいじ /説文解字/
せつやく /節約/
せつゆ /説諭/
せつよう /窃用/切要/節用/
せつようしゅう /節用集/
せつり /摂理/節理/
せつりつ /設立/
せつりゅう /設立/
せつれつ /拙劣/
せつろん /拙論/切論/
せつわ /説話/
せと /瀬戸/
せとうち /瀬戸内/
せとおおはし /瀬戸大橋/
せとおおはしせん /瀬戸大橋線/
せとぎわ /瀬戸際/
せとぐち /瀬戸口/
せとないかい /瀬戸内海/
せともの /瀬戸物/
せどう /世道/
せどうか /旋頭歌/
せなか /背中/
せのび /背伸び/
せはば /背幅/
せばんごう /背番号/
せひ /施肥/
せひょう /世評/
せびょうし /背表紙/
せびらき /背開き/
せびれ /背鰭/
せびろ /背広/
せぶみ /瀬踏み/
せぼね /背骨/
せまきもん /狭き門/
せみ /蝉/
せみしぐれ /蝉時雨/
せみまる /蝉丸/
せむし /傴僂/
せめ /責め/
せめく /責め苦/
せめくち /攻め口/
せめぐ /責具/
せめて /攻め手/
せもたれ /背凭れ/
せやく /施薬/
せよ /施与/
せり /糶/芹/
せりあげ /競上げ/
せりいち /競り市/
せりかわ /芹川/
せりざわ /芹沢/
せりふ /台詞/科白/
せりょう /芹生/施療/
せろ /世路/
せろん /世論/
せわ /世話/
せわにん /世話人/
せわもの /世話物/
せわやき /世話焼き/
せわやく /世話役/
せわり /背割/
せん /先/線/千/仙/繊/専/宣/戦/選/占/鮮/染/洗/栓/泉/船/川/銑/銭/遷/践/詮/薦/腺/羨/箭/旋/煎/潜/浅/撰/扇/尖/箋/餞/僊/暹/氈/甎/疝/磚/籤/賤/饌/閃/賎/穿/煽/舛/
せんい /遷移/繊維/戦意/船医/
せんいき /戦域/
せんいつ /専一/
せんいん /船員/
せんいんほけん /船員保険/
せんうん /戦雲/
せんえい /先鋭/尖鋭/
せんえき /戦役/
せんえつ /僭越/
せんえん /遷延/千円/
せんえんさつ /千円札/
せんおう /専横/先王/
せんおく /千億/
せんか /専科/戦果/戦火/戦禍/選歌/泉下/選科/
せんかい /旋回/仙界/浅海/
せんかく /先覚/
せんかくしょとう /尖閣諸島/
せんかし /泉貨紙/
せんかん /戦艦/選管/専管/潜函/
せんが /線画/
せんがい /選外/
せんがき /線描き/
せんがく /先学/浅学/
せんがくじ /泉岳寺/
せんがん /洗顔/洗眼/千貫/
せんがんしゅぎ /先願主義/
せんき /戦記/戦旗/戦機/
せんきゃく /先客/船客/
せんきゃくばんらい /千客万来/
せんきゅう /選球/
せんきょ /選挙/占拠/占居/
せんきょいはん /選挙違反/
せんきょう /宣教/戦況/船橋/
せんきょうし /宣教師/
せんきょうんどう /選挙運動/
せんきょく /選曲/戦局/選局/選挙区/
せんきょけん /選挙権/
せんきょこうほう /選挙公報/
せんきょそしょう /選挙訴訟/
せんきょちょう /選挙長/
せんきょにん /選挙人/
せんきょにんめいぼ /選挙人名簿/
せんきん /千金/
せんぎ /先議/詮議/
せんぎょ /鮮魚/
せんぎょう /専業/
せんぎょうしゅふ /専業主婦/
せんぎょうのうか /専業農家/
せんぎり /千切り/
せんく /先駆/線区/選句/
せんくしゃ /先駆者/
せんくち /先口/
せんくん /先君/
せんぐ /船具/
せんぐう /遷宮/
せんぐんばんば /千軍万馬/
せんけ /千家/
せんけい /線型/線形/扇形/尖形/船型/
せんけいくうかん /線形空間/
せんけいけつごう /線形結合/
せんけいへんかん /線形変換/
せんけつ /先決/鮮血/潜血/専決/
せんけん /先見/浅見/先遣/擅権/専権/
せんけんてき /先験的/
せんけんのめい /先見の明/
せんげ /宣下/遷化/
せんげつ /先月/
せんげん /宣言/浅間/泉源/
せんげんじんじゃ /浅間神社/
せんげんばんご /千言万語/
せんこ /千古/
せんこう /先行/選考/専攻/線香/穿孔/潜行/先攻/閃光/選鉱/戦功/染工/潜航/先考/専行/繊巧/鮮紅/
せんこうか /専攻科/
せんこうき /穿孔機/
せんこうだい /線香代/
せんこうてい /潜航艇/
せんこうはなび /線香花火/
せんこく /宣告/先刻/
せんこくゆうよ /宣告猶予/
せんこつ /仙骨/
せんこふえき /千古不易/
せんご /戦後/
せんごく /戦国/千石/
せんごくじだい /戦国時代/
せんごくだいみょう /戦国大名/
せんごくぶね /千石船/
せんごは /戦後派/
せんさい /繊細/戦災/先妻/浅才/
せんさいこじ /戦災孤児/
せんさいちゃ /仙斎茶/
せんさく /詮索/穿鑿/
せんさばんべつ /千差万別/
せんざい /潜在/洗剤/千載/前栽/千歳/
せんざいいしき /潜在意識/
せんざいいちぐう /千載一遇/
せんざいじゅよう /潜在需要/
せんざいてき /潜在的/
せんざんこう /穿山甲/
せんざんばんすい /千山万水/
せんし /戦士/先史/戦死/穿刺/戦史/擅恣/先師/
せんしじだい /先史時代/
せんしつ /船室/泉質/
せんしばんこう /千思万考/千紫万紅/
せんしばんたい /千姿万態/
せんしゃ /洗車/戦車/
せんしゅ /選手/先取/船首/僭主/船主/繊手/
せんしゅう /先週/泉州/専修/選集/千秋/撰修/撰集/
せんしゅうがっこう /専修学校/
せんしゅうだいがく /専修大学/
せんしゅうらく /千秋楽/
せんしゅけん /選手権/
せんしゅつ /選出/
せんしゅぼうえい /専守防衛/
せんしゅん /浅春/
せんしょ /選書/
せんしょう /先勝/戦勝/戦捷/僭称/僭上/戦傷/選奨/
せんしょく /染織/染色/
せんしょくたい /染色体/
せんしん /先進/専心/線審/潜心/
せんしんこく /先進国/
せんしんばんく /千辛万苦/
せんじ /戦時/煎じ/宣旨/
せんじがみ /宣旨紙/
せんじぐすり /煎じ薬/
せんじつ /先日/
せんじもん /千字文/
せんじゃ /選者/撰者/
せんじゃく /繊弱/
せんじゅ /千住/千手/
せんじゅう /専従/先住/
せんじゅうみん /先住民/
せんじゅかんのん /千手観音/
せんじゅつ /戦術/仙術/占術/撰述/
せんじゅつか /戦術家/
せんじょ /剪除/
せんじょう /線上/線状/戦場/洗浄/扇状/船上/千丈/洗滌/煽情/線条/
せんじょうざい /洗浄剤/
せんじょうじき /千畳敷/
せんじょうち /扇状地/
せんじん /先人/千尋/先陣/戦塵/戦陣/
せんす /扇子/
せんすい /潜水/泉水/
せんすいかん /潜水艦/
せんすいてい /潜水艇/
せんすいびょう /潜水病/
せんすいふ /潜水夫/
せんすいふく /潜水服/
せんずるところ /詮ずる所/
せんせい /先生/宣誓/先制/専制/専政/
せんせいくんしゅ /専制君主/
せんせいじゅつ /占星術/
せんせいせいじ /専制政治/
せんせいりょく /潜勢力/
せんせき /戦績/船籍/戦跡/
せんせきこう /船籍港/
せんせきせん /仙石線/
せんせん /戦々/戦線/宣戦/先占/
せんせんげつ /先々月/先先月/
せんせんしゅとく /先占取得/
せんせんふこく /宣戦布告/
せんぜん /戦前/
せんぜんは /戦前派/
せんそ /践祚/
せんそう /戦争/船倉/船艙/船窓/線装/
せんそうじ /浅草寺/
せんそうはんざい /戦争犯罪/
せんそく /洗足/船側/
せんぞ /先祖/
せんぞがえり /先祖返り/
せんぞく /専属/
せんぞくかんかつ /専属管轄/
せんたい /戦隊/船体/蘚苔/船隊/
せんたいしょう /線対称/
せんたく /選択/洗濯/
せんたくいた /洗濯板/
せんたくかもく /選択科目/
せんたくき /洗濯機/
せんたくさいけん /選択債権/
せんたくし /選択肢/
せんたくせっけん /洗濯石鹸/
せんたくばさみ /洗濯挟み/
せんたくもの /洗濯物/
せんたん /先端/戦端/尖端/
せんだい /仙台/先代/川内/
せんだいし /仙台市/
せんだいじょう /仙台城/
せんだいみそ /仙台味噌/
せんだち /先達/
せんだつ /先達/
せんだん /栴檀/船団/剪断/
せんち /戦地/糎/
せんちめーとる /糎/
せんちゃ /煎茶/
せんちゃく /先着/
せんちゅう /戦中/船中/
せんちゅうは /戦中派/
せんちょう /船長/
せんつう /疝痛/
せんて /先手/
せんてい /選定/剪定/船底/先帝/撰定/
せんていとうじしゃ /選定当事者/
せんてつ /銑鉄/先哲/
せんてひっしょう /先手必勝/
せんてん /先天/旋転/
せんてんてき /先天的/
せんでき /洗滌/
せんでん /宣伝/
せんと /遷都/
せんとう /先頭/戦闘/銭湯/尖塔/仙洞/先登/剪刀/
せんとういん /戦闘員/
せんとうかん /戦闘艦/
せんとうき /戦闘機/
せんとうごしょ /仙洞御所/
せんとうてい /宣統帝/
せんとうりょく /戦闘力/
せんど /鮮度/先途/先度/
せんどう /先導/仙道/煽動/船頭/扇動/
せんない /船内/
せんなん /泉南/
せんにく /鮮肉/
せんにち /千日/
せんにちて /千日手/
せんにちまえ /千日前/
せんにゅう /潜入/
せんにゅうかん /先入観/
せんにょ /仙女/
せんにん /専任/仙人/千人/選任/先任/
せんにんぎり /千人斬り/
せんにんばり /千人針/
せんにんりき /千人力/
せんぬき /栓抜き/
せんねつ /潜熱/
せんねん /専念/千年/先年/
せんのう /洗脳/
せんのりきゅう /千利休/
せんば /船場/
せんばい /専売/
せんばいこうしゃ /専売公社/
せんばいとっきょ /専売特許/
せんばつ /選抜/
せんばづる /千羽鶴/
せんばん /千万/旋盤/先番/先晩/
せんぱい /先輩/戦敗/
せんぱく /船舶/浅薄/銭帛/
せんぱくかんりにん /船舶管理人/
せんぱくしょくいん /船舶職員/
せんぱくでんわ /船舶電話/
せんぱくほけん /船舶保険/
せんぱつ /先発/洗髪/染髪/
せんぱん /先般/戦犯/
せんひゃく /千百/
せんび /船尾/戦備/
せんびき /線引き/
せんびょう /線描/
せんびょうし /戦病死/
せんびょうしつ /腺病質/
せんびん /船便/先便/
せんぴ /戦費/先非/
せんぴつ /染筆/
せんぴょう /選評/
せんぶ /先負/宣撫/
せんぶん /線分/撰文/
せんぶんりつ /千分率/
せんぷ /先夫/宣布/
せんぷう /旋風/
せんぷうき /扇風機/
せんぷうよう /旋風葉/
せんぷく /潜伏/船腹/船幅/
せんぷくき /潜伏期/
せんべい /煎餅/
せんべつ /選別/餞別/
せんべん /先鞭/
せんぺい /尖兵/
せんぺんいちりつ /千篇一律/
せんぺんばんか /千変万化/
せんぼう /羨望/
せんぼうきょう /潜望鏡/
せんぼつ /戦没/潜没/
せんぼん /千本/
せんぽう /先方/戦法/旋法/先鋒/占法/尖峰/
せんぽく /泉北/
せんまい /千枚/洗米/
せんまいどおし /千枚通し/
せんまけ /先負/
せんまん /千万/
せんまんむりょう /千万無量/
せんみん /選民/
せんむ /専務/
せんめい /鮮明/船名/
せんめつ /殲滅/剪滅/
せんめん /洗面/扇面/
せんめんき /洗面器/
せんめんじょ /洗面所/
せんめんだい /洗面台/
せんもう /繊毛/譫妄/剪毛/腺毛/旋毛/
せんもうちゅう /旋毛虫/
せんもん /専門/
せんもんい /専門医/
せんもんか /専門家/
せんもんがっこう /専門学校/
せんもんきょういく /専門教育/
せんもんご /専門語/
せんもんてん /専門店/
せんや /先夜/戦野/
せんやく /先約/煎薬/
せんゆう /占有/専有/戦友/
せんゆうけん /占有権/
せんゆうこうらく /先憂後楽/
せんよう /専用/宣揚/占用/
せんようかいせん /専用回線/
せんらん /戦乱/
せんり /千里/戦利/
せんりがん /千里眼/
せんりつ /旋律/戦慄/
せんりどうふう /千里同風/
せんりひん /戦利品/
せんりゃく /戦略/
せんりゃくばくげき /戦略爆撃/
せんりゅう /川柳/
せんりょ /浅慮/千慮/
せんりょう /占領/線量/染料/千両/選良/
せんりょうばこ /千両箱/
せんりょうやくしゃ /千両役者/
せんりょく /戦力/浅緑/
せんりん /線輪/
せんるい /蘚類/
せんれい /洗礼/先例/船齢/
せんれき /戦歴/
せんれつ /鮮烈/戦列/
せんれん /洗練/
せんろ /線路/
せんわく /煽惑/
ぜ /是/
ぜあみ /世阿弥/
ぜい /税/説/贅/筮/脆/
ぜいかん /税関/
ぜいがく /税額/
ぜいがくこうじょ /税額控除/
ぜいきん /税金/
ぜいげん /税源/贅言/
ぜいこみ /税込/
ぜいしゅう /税収/
ぜいじゃく /脆弱/
ぜいせい /税制/脆性/
ぜいたく /贅沢/
ぜいたくざんまい /贅沢三昧/
ぜいたくひん /贅沢品/
ぜいにく /贅肉/
ぜいぶつ /贅物/
ぜいほう /税法/
ぜいむ /税務/
ぜいむしょ /税務署/
ぜいむだいりし /税務代理士/
ぜいり /税吏/
ぜいりし /税理士/
ぜいりつ /税率/
ぜげん /女衒/
ぜせい /是正/
ぜぜ /膳所/
ぜっか /舌禍/絶佳/
ぜっかい /絶海/
ぜっきょう /絶叫/絶境/
ぜっく /絶句/
ぜっけ /絶家/
ぜっけい /絶景/
ぜっこう /絶好/絶交/
ぜっこうちょう /絶好調/
ぜっこつ /舌骨/
ぜっこん /舌根/
ぜっさん /絶賛/絶讃/
ぜっしょう /絶唱/絶勝/
ぜっしょく /絶食/
ぜっせい /絶世/
ぜっせん /舌戦/
ぜっそく /絶息/
ぜったい /絶対/舌苔/
ぜったいおんかん /絶対音感/
ぜったいおんど /絶対温度/
ぜったいし /絶対視/
ぜったいしゃ /絶対者/
ぜったいしゅぎ /絶対主義/
ぜったいぜつめい /絶体絶命/
ぜったいたすう /絶対多数/
ぜったいたんいけい /絶対単位系/
ぜったいち /絶対値/
ぜったいてき /絶対的/
ぜったいとうきゅう /絶対等級/
ぜったいひょうか /絶対評価/
ぜったいりょう /絶対量/
ぜったいれいど /絶対零度/
ぜったん /舌端/
ぜっちょう /絶頂/
ぜっとう /舌頭/絶倒/絶島/
ぜっぱん /絶版/
ぜっぴつ /絶筆/
ぜっぴん /絶品/
ぜっぺき /絶壁/
ぜっぽう /舌鋒/
ぜつ /絶/舌/
ぜつ> /絶/
ぜついき /絶域/
ぜつえん /絶縁/絶遠/
ぜつえんたい /絶縁体/
ぜつおん /舌音/
ぜつがん /舌癌/
ぜつぎ /絶技/
ぜつご /絶後/
ぜつだい /絶大/舌代/
ぜつぼう /絶望/
ぜつぼうてき /絶望的/
ぜつみょう /絶妙/
ぜつむ /絶無/
ぜつめい /絶命/
ぜつめつ /絶滅/
ぜつめつきぐしゅ /絶滅危惧種/
ぜつりん /絶倫/
ぜに /銭/
ぜにかね /銭金/
ぜにがた /銭形/
ぜにごけ /銭苔/
ぜにばこ /銭箱/
ぜにん /是認/
ぜひ /是非/
ぜひとも /是非とも/
ぜろせん /零戦/
ぜん /前/全/膳/繕/禅/然/漸/善/
ぜん> /前/全/
ぜんあく /善悪/
ぜんい /善意/
ぜんいき /全域/
ぜんいしゅとく /善意取得/
ぜんいつ /全一/
ぜんいん /全員/
ぜんいんぜんか /善因善果/
ぜんえい /前衛/
ぜんえいは /前衛派/
ぜんえん /全縁/前縁/
ぜんおう /全欧/
ぜんおん /全音/
ぜんおんかい /全音階/
ぜんか /前科/全科/全課/
ぜんかい /前回/全開/全快/全会/全壊/全潰/
ぜんかく /全角/
ぜんかくかな /全角仮名/
ぜんかもの /前科者/
ぜんかん /全館/全巻/前漢/前官/善感/
ぜんがく /全学/全額/前額/禅学/
ぜんがくれん /全学連/
ぜんき /前期/前記/全期/
ぜんきゃく /前脚/
ぜんきょうとう /全共闘/
ぜんきょく /全局/
ぜんきん /前金/
ぜんきんせん /漸近線/
ぜんきんだいてき /前近代的/
ぜんく /前駆/
ぜんくつ /前屈/
ぜんぐん /全軍/
ぜんけ /禅家/
ぜんけい /前掲/全形/全景/前傾/前景/
ぜんけん /前件/全権/全県/
ぜんげつ /前月/
ぜんげん /前言/漸減/善言/
ぜんこ /全戸/
ぜんこう /前項/全校/善行/
ぜんこうじ /善光寺/
ぜんこく /全国/
ぜんこくく /全国区/
ぜんこくし /全国紙/
ぜんこくてき /全国的/
ぜんこみぞう /前古未曾有/
ぜんこん /前根/善根/
ぜんご /前後/善後/
ぜんごう /前号/善業/
ぜんごさく /善後策/
ぜんごさゆう /前後左右/
ぜんごふかく /前後不覚/
ぜんさい /前菜/
ぜんさく /前作/
ぜんざ /前座/
ぜんざい /善哉/
ぜんざん /全山/
ぜんし /全市/全紙/前肢/前史/全姿/
ぜんしつ /禅室/
ぜんしゃ /前者/前車/全射/漸写/全社/
ぜんしゃく /前借/
ぜんしゅう /全集/前週/禅宗/全州/
ぜんしゅつ /前出/
ぜんしょ /善処/全書/善書/
ぜんしょう /前章/全称/全勝/全焼/前哨/
ぜんしょうせん /前哨戦/
ぜんしょうとう /前照灯/
ぜんしん /前進/全身/漸進/前身/前震/前審/前信/善心/
ぜんしんぜんれい /全身全霊/
ぜんしんますい /全身麻酔/
ぜんじ /漸次/善事/
ぜんじだいてき /前時代的/
ぜんじつ /前日/全日/
ぜんじゅつ /前述/
ぜんじょう /前条/禅譲/禅定/
ぜんじん /前人/全人/
ぜんじんみとう /前人未踏/
ぜんじんるい /全人類/
ぜんすう /全数/
ぜんすうちょうさ /全数調査/
ぜんせ /前世/
ぜんせい /全盛/善政/前世/
ぜんせかい /全世界/前世界/
ぜんせき /前席/
ぜんせつ /前説/前節/
ぜんせん /前線/善戦/全線/
ぜんぜん /全然/前々/前前/
ぜんぜんげつ /前々月/
ぜんそう /前奏/禅僧/
ぜんそうきょく /前奏曲/
ぜんそく /喘息/
ぜんそくりょく /全速力/
ぜんそん /全損/全村/
ぜんぞう /漸増/
ぜんたい /全体/全隊/
ぜんたいしゅうごう /全体集合/
ぜんたいしゅぎ /全体主義/
ぜんたん /前端/
ぜんたんしゃ /全単射/
ぜんだい /前代/
ぜんだいみもん /前代未聞/
ぜんだて /膳立て/
ぜんだま /善玉/
ぜんだん /前段/全段/
ぜんち /全治/前置/全知/
ぜんちし /前置詞/
ぜんちぜんのう /全知全能/
ぜんちょう /全長/前兆/全町/
ぜんつう /全通/
ぜんつうじ /善通寺/
ぜんてい /前提/前庭/
ぜんてつ /前轍/
ぜんてん /全店/全天/
ぜんでら /禅寺/
ぜんと /前途/全都/
ぜんとう /前頭/漸騰/
ぜんとうよう /前頭葉/
ぜんとりょうえん /前途遼遠/
ぜんど /全土/髯奴/
ぜんどう /善導/蠕動/禅堂/
ぜんなん /善男/
ぜんなんぜんにょ /善男善女/
ぜんに /禅尼/
ぜんにちせい /全日制/
ぜんにん /善人/前任/
ぜんねん /前年/
ぜんのう /全能/前納/全納/全農/
ぜんはん /前半/
ぜんはんき /前半期/
ぜんはんしゃ /全反射/
ぜんはんせい /前半生/
ぜんば /前場/
ぜんばん /全判/
ぜんぱい /全廃/全敗/
ぜんぱん /全般/
ぜんひてい /全否定/
ぜんび /善美/
ぜんびん /前便/
ぜんぴ /前非/
ぜんぶ /全部/前部/膳部/
ぜんぶはんけつ /全部判決/
ぜんぶん /全文/前文/
ぜんぷ /前夫/
ぜんぷく /全幅/
ぜんべい /全米/
ぜんぺき /前壁/
ぜんぺん /全編/前編/前篇/
ぜんぼう /全貌/
ぜんぽう /前方/
ぜんぽん /善本/
ぜんまい /薇/発条/撥条/
ぜんまく /善悪/
ぜんみ /禅味/
ぜんめい /喘鳴/
ぜんめつ /全滅/
ぜんめん /全面/前面/
ぜんめんこうこく /全面広告/
ぜんめんてき /全面的/
ぜんもう /全盲/
ぜんもん /前門/禅門/
ぜんもんどう /禅問答/
ぜんや /前夜/
ぜんやく /全訳/前約/
ぜんやさい /前夜祭/
ぜんゆ /全癒/
ぜんよう /全容/善用/
ぜんようたい /前葉体/
ぜんら /全裸/
ぜんらく /漸落/
ぜんりつせん /前立腺/
ぜんりゃく /前略/
ぜんりょう /善良/全量/
ぜんりょうせい /全寮制/
ぜんりょく /全力/
ぜんりん /善隣/禅林/
ぜんれい /前例/全霊/
ぜんれき /前歴/
ぜんれつ /前列/全裂/
ぜんろう /全労/
ぜんわ /禅話/
ぜんわん /前腕/
そ /組/遡/阻/訴/蘇/素/粗/租/祖/礎/疎/疏/楚/塑/想/措/疽/俎/酥/鼠/狙/曽/曾/岨/
そーだ /曹達/
そあく /粗悪/
そあん /素案/
そい /粗衣/
そいね /添い寝/
そいん /素因/訴因/疎音/
そいんすう /素因数/
そいんすうぶんかい /素因数分解/
そう /騒/総/層/相/想/送/早/霜/鎗/遭/走/装/藻/蒼/葬/荘/草/聡/綜/窓/争/燥/槽/槍/巣/曹/操/挿/掃/捜/惣/宋/爽/奏/壮/喪/倉/叢/双/創/僧/宗/贈/箏/艘/瘡/叟/嫂/躁/曾/桑/甑/左右/笙/糟/痩/漕/掻/匝/
そう> /総/双/
そうあい /相愛/
そうあげ /総揚げ/
そうあたり /総当り/
そうあん /草案/創案/草庵/僧庵/
そうい /相違/創意/総意/創痍/僧衣/僧位/
そういれば /総入れ歯/
そういん /僧院/総員/
そううつ /躁鬱/
そううつびょう /躁鬱病/
そううん /層雲/
そううんきょう /層雲峡/
そうえん /桑園/荘園/蒼鉛/
そうおう /相応/
そうおく /草屋/
そうおん /騒音/噪音/宋音/相恩/
そうおんきせいほう /騒音規制法/
そうおんけい /騒音計/
そうか /草加/痩果/装荷/挿花/
そうかい /総会/爽快/壮快/掃海/
そうかいそうでん /滄海桑田/
そうかいてい /掃海艇/
そうかいや /総会屋/
そうかがっかい /創価学会/
そうかく /総画/
そうかだいがく /創価大学/
そうかつ /総括/総轄/
そうかへいきん /相加平均/
そうかん /相関/壮観/相姦/創刊/送還/総監/
そうかんかんけい /相関関係/
そうかんけいすう /相関係数/
そうかんしゃ /相姦者/
そうかんじょう /総勘定/
そうかんず /相関図/
そうが /挿画/装画/爪牙/草画/
そうがい /窓外/霜害/
そうがかり /総掛り/
そうがく /総額/奏楽/
そうがん /双眼/
そうがんきょう /双眼鏡/
そうき /早期/想起/総記/
そうきへい /槍騎兵/
そうきゃく /双脚/
そうきゅう /早急/送球/蒼穹/躁急/
そうきょ /壮挙/
そうきょういく /早教育/
そうきょく /箏曲/
そうきょくし /双極子/
そうきょくせん /双曲線/
そうきょくめん /双曲面/
そうきん /送金/
そうきんるい /藻菌類/
そうぎ /葬儀/争議/
そうぎけん /争議権/
そうぎこうい /争議行為/
そうぎゃ /僧伽/
そうぎや /葬儀屋/
そうぎょう /創業/操業/早暁/
そうぎょうど /操業度/
そうぎょうひ /創業費/
そうぎり /総桐/
そうく /痩躯/走狗/
そうくう /蒼空/
そうくずれ /総崩れ/
そうくつ /巣窟/
そうぐ /装具/
そうぐう /遭遇/
そうぐん /総軍/
そうけ /宗家/
そうけい /総計/早計/
そうけいせん /早慶戦/
そうけっさん /総決算/
そうけん /壮健/双肩/送検/創建/総見/創見/想見/
そうげい /送迎/
そうげん /草原/
そうこ /倉庫/
そうこう /走行/草稿/壮行/装甲/操行/霜降/奏効/送稿/走向/糟糠/爪甲/奏功/
そうこうげき /総攻撃/
そうこうのつま /糟糠の妻/
そうこえいぎょう /倉庫営業/
そうこく /相克/相剋/
そうこしょうけん /倉庫証券/
そうこほうし /桑弧蓬矢/
そうこん /早婚/草根/
そうご /相互/壮語/
そうごう /総合/綜合/相好/
そうごうかぜい /総合課税/
そうごうこうざ /総合口座/
そうごうしょく /総合職/
そうごうだいがく /総合大学/
そうごうはんだん /総合判断/
そうごかんけい /相互関係/
そうごぎんこう /相互銀行/
そうごさよう /相互作用/
そうごしゅぎ /相互主義/
そうごほけん /相互保険/
そうごん /荘厳/
そうさ /操作/走査/捜査/匝瑳;千葉県匝瑳郡/
そうさい /相殺/葬祭/総裁/
そうさいけん /相殺権/
そうさいりょう /葬祭料/
そうさきかん /捜査機関/
そうさく /創作/捜索/
そうさくぶつ /創作物/
そうさせん /走査線/
そうさつ /相殺/
そうさほんぶ /捜査本部/
そうざい /惣菜/
そうざん /早産/
そうし /創始/相思/草紙/荘子/壮士/壮志/双紙/宗祀/
そうしき /葬式/相識/
そうしつ /喪失/
そうしはいにん /総支配人/
そうしゃ /奏者/走者/操車/壮者/掃射/
そうしゃじょう /操車場/
そうしゅ /双手/宗主/漕手/操守/
そうしゅう /総集/早秋/爽秋/
そうしゅけん /宗主権/
そうしゅこく /宗主国/
そうしゅつ /創出/
そうしゅん /早春/
そうしょ /草書/双書/叢書/
そうしょう /総称/争訟/相称/相生/創傷/宗匠/相承/
そうしょく /装飾/草食/僧職/
そうしょくおん /装飾音/
そうしょくきょう /装飾経/
そうしょくじゅう /草食獣/
そうしょくせい /草食性/
そうしょくどうぶつ /草食動物/
そうしょくひん /装飾品/
そうしれいかん /総司令官/
そうしん /送信/痩身/喪心/壮心/喪神/総身/
そうしんき /送信機/
そうしんぐ /装身具/
そうじ /掃除/相似/送辞/走時/
そうじうんそう /相次運送/
そうじけい /相似形/
そうじしょく /総辞職/
そうじじ /総持寺/
そうじて /総じて/
そうじめ /総締め/
そうじゃ /総社/
そうじゅ /送受/双樹/
そうじゅう /操縦/
そうじゅうかん /操縦桿/
そうじゅうし /操縦士/
そうじゅうりょう /総重量/
そうじゅうりん /操縦輪/
そうじゅく /早熟/
そうじゅつ /槍術/
そうじょう /層状/相乗/僧正/奏上/総状/騒擾/
そうじょうかじょ /総状花序/
そうじょうざい /騒擾罪/
そうじょうせき /相乗積/
そうじょうへいきん /相乗平均/
そうじん /騒人/
そうすい /総帥/送水/
そうすう /総数/双数/
そうず /挿図/
そうせい /創成/早世/創製/簇生/創世/叢生/双生/
そうせいき /創世記/
そうせいじ /双生児/早生児/
そうせき /漱石/踪跡/僧籍/
そうせきうん /層積雲/
そうせきちんりゅう /漱石枕流/
そうせつ /創設/総説/霜雪/
そうせん /操船/
そうせんきょ /総選挙/
そうぜい /総勢/
そうぜつ /壮絶/
そうぜん /騒然/蒼然/愴然/
そうぜんじ /崇禅寺/
そうそ /曾祖/
そうそう /早々/草々/然う然う/怱々/匆々/錚々/淙々/層々/蒼々/葬送/草創/簇々/蹌々/鏘々/草叢/滄桑/早早/草草/怱怱/匆匆/錚錚/淙淙/層層/蒼蒼/簇簇/蹌蹌/鏘鏘/
そうそく /総則/相即/
そうそくふり /相即不離/
そうそふ /曾祖父/
そうそぼ /曾祖母/
そうそん /曾孫/
そうぞう /想像/創造/
そうぞうにんしん /想像妊娠/
そうぞうりょく /想像力/
そうぞく /相続/宗族/装束/僧俗/
そうぞくけん /相続権/
そうぞくざいさん /相続財産/
そうぞくぜい /相続税/
そうぞくにん /相続人/
そうぞくぶん /相続分/
そうぞくほう /相続法/
そうぞくほうき /相続放棄/
そうたい /相対/早退/総体/草体/
そうたいごさ /相対誤差/
そうたいせいげんり /相対性原理/
そうたいせいりろん /相対性理論/
そうたいてき /相対的/
そうたいひょうか /相対評価/
そうたいろん /相対論/
そうたつ /送達/
そうたん /操短/
そうたんかん /総胆管/
そうだ /操舵/左右田/
そうだい /壮大/総代/
そうだいしょう /総大将/
そうだか /総高/
そうだち /総立ち/
そうだつ /争奪/
そうだん /相談/装弾/
そうだんやく /相談役/
そうち /装置/送致/
そうちゃく /装着/早着/
そうちょう /早朝/総長/荘重/曹長/宋朝/
そうてい /想定/装丁/装釘/送呈/装幀/漕艇/壮丁/
そうてん /争点/装填/操典/蒼天/総点/
そうてんい /相転移/
そうで /総出/
そうでん /送電/相伝/
そうでんせん /送電線/
そうと /壮図/壮途/僧徒/
そうとう /相当/争闘/双頭/総統/相等/想到/
そうとうしゅう /曹洞宗/
そうとうせい /相等性/
そうとく /総督/
そうどう /騒動/相同/草堂/僧堂/
そうどういん /総動員/
そうどうせん /双胴船/
そうなめ /総嘗め/
そうなん /遭難/
そうにゅう /挿入/
そうにゅうく /挿入句/
そうねん /壮年/想念/
そうは /争覇/走破/掻爬/
そうはい /送配/
そうはく /蒼白/糟粕/
そうはつき /双発機/
そうば /相場/
そうばし /相場師/
そうばな /総花/
そうばひょう /相場表/
そうばん /早晩/
そうひょう /総評/
そうび /装備/壮美/
そうびょう /躁病/宗廟/
そうふ /送付/総譜/孀婦/
そうふう /送風/
そうふうき /送風機/
そうぶほんせん /総武本線/
そうへい /僧兵/
そうへき /双璧/
そうべつ /送別/
そうべつかい /送別会/
そうほう /双方/奏法/走法/双峰/総包/総苞/
そうほうだいり /双方代理/
そうほせい /相補性/
そうほん /草本/
そうほんけ /総本家/
そうほんざん /総本山/
そうぼう /蒼氓/双眸/相貌/蒼茫/僧帽/想望/
そうぼうきん /僧帽筋/
そうぼうべん /僧帽弁/
そうぼり /総掘り/
そうま /相馬/
そうまい /草昧/
そうまくり /総捲り/
そうまとう /走馬灯/
そうみ /総身/
そうむ /総務/双務/
そうむけいやく /双務契約/
そうめい /聡明/
そうめいきょく /奏鳴曲/
そうめん /索麺/創面/
そうもく /草木/総目/
そうもくじ /総目次/
そうもくろく /総目録/
そうもん /桑門/相聞/僧門/総門/
そうや /宗谷/
そうやかいきょう /宗谷海峡/
そうやく /草薬/装薬/
そうやみさき /宗谷岬/
そうゆう /曾遊/
そうよく /双翼/
そうよさん /総予算/
そうらん /総覧/騒乱/争乱/奏覧/総攬/
そうらんざい /騒乱罪/
そうり /総理/
そうりだいじん /総理大臣/
そうりつ /創立/
そうりふれい /総理府令/
そうりゅう /層流/
そうりょ /僧侶/
そうりょう /送料/総量/惣領/総領/爽涼/
そうりょうきせい /総量規制/
そうりょうじ /総領事/
そうりょうぶん /惣領分/
そうりょく /総力/
そうりょくせん /総力戦/
そうりん /叢林/相輪/
そうりんかんけい /相隣関係/
そうりんしゃ /相隣者/
そうるい /藻類/走塁/
そうれい /壮麗/葬礼/壮齢/
そうれつ /壮烈/葬列/
そうれん /操練/
そうれんしゅう /総練習/
そうろ /走路/
そうろう /早漏/早老/候/
そうろうぶん /候文/
そうろん /総論/争論/
そうわ /総和/挿話/送話/
そうわき /送話器/
そえ /添え/副/添/
そえいし /添石/
そえじま /副島/
そえじょう /添状/
そえだ /添田/
そえつどうしゅう /楚越同舟/
そえもの /添え物/
そえん /疎遠/
そお /赭/
そか /粗菓/
そかい /疎開/租界/素懐/
そかく /疎隔/組閣/阻隔/
そが /蘇我/曾我/疎画/
そがい /阻害/疎外/阻碍/
そがのえみし /蘇我蝦夷/
そがん /訴願/
そきゅう /遡及/遡求/訴求/
そきゅうこう /遡及効/
そぎ /枌/
そぎょう /祖業/
そく /足/側/速/息/即/測/束/則/促/塞/仄/捉/
そくあつ /側圧/
そくい /即位/
そくいん /惻隠/
そくえい /即詠/
そくえん /測鉛/
そくおう /即応/
そくおん /促音/
そくおんき /足温器/
そくおんびん /促音便/
そくが /側芽/側臥/
そくぎん /即吟/
そくさ /側鎖/
そくさい /息災/
そくさいえんめい /息災延命/
そくさん /速算/
そくざ /即座/
そくし /即死/足趾/
そくしつ /側室/
そくしゃ /速写/速射/
そくしゃほう /速射砲/
そくしん /促進/測深/即身/
そくしんじょうぶつ /即身成仏/
そくしんぶつ /即身仏/
そくじ /即時/即事/
そくじこうこく /即時抗告/
そくじしゅとく /即時取得/
そくじつ /即日/
そくじょ /息女/
そくせい /促成/速成/側生/即製/
そくせいさいばい /促成栽培/
そくせいどうぶつ /側生動物/
そくせき /即席/足跡/足蹠/
そくせん /側線/塞栓/
そくせんそっけつ /速戦即決/
そくせんりょく /即戦力/
そくそく /促促/惻惻/
そくたい /束帯/
そくたつ /速達/
そくだい /即題/
そくだく /即諾/
そくだん /即断/速断/
そくち /測地/
そくちせん /測地線/
そくてい /測定/
そくていち /測定値/
そくてん /測点/
そくてんきょし /則天去私/
そくとう /即答/側頭/速答/
そくとうよう /側頭葉/
そくど /速度/測度/
そくどく /速読/
そくどけい /速度計/
そくのう /即納/
そくはく /束帛/促迫/
そくはたい /側波帯/
そくはつ /即発/束髪/
そくばい /即売/
そくばく /束縛/
そくひつ /速筆/
そくぶつてき /即物的/
そくぶん /仄聞/
そくへき /側壁/
そくへん /側辺/
そくほ /速歩/
そくほう /速報/側方/
そくみょう /即妙/
そくめつ /熄滅/
そくめん /側面/
そくめんず /側面図/
そくりょう /測量/
そくりょうきかい /測量器械/
そくりょうし /測量士/
そくりょうせん /測量船/
そくりょく /速力/
そくろう /足労/
そけい /祖型/
そけん /訴権/
そげき /狙撃/
そこ /底/其処/其所/
そこあげ /底上げ/
そこい /底意/
そこいじ /底意地/
そこいれ /底入れ/
そこう /素行/粗鋼/遡航/遡行/
そこうけん /租鉱権/
そこく /祖国/
そこくら /底倉/
そこち /底地/
そこぢから /底力/
そこつ /粗忽/
そこつち /底土/
そこづみ /底積み/
そこなし /底無し/
そこぬけ /底抜け/
そこね /底値/
そこびえ /底冷え/
そこびかり /底光り/
そご /齟齬/祖語/
そさい /蔬菜/
そざい /素材/
そざつ /粗雑/
そし /阻止/素子/祖師/素志/
そしき /組織/
そしきがく /組織学/
そしききゅう /組織球/
そしきてき /組織的/
そしたいよう /麁枝大葉/
そしつ /素質/
そして /然して/
そしな /粗品/
そしゃく /租借/咀嚼/
そしゃくち /租借地/
そしゅ /粗酒/
そしゅう /蘇州/
そしょう /訴訟/
そしょうきろく /訴訟記録/
そしょうこうい /訴訟行為/
そしょうこくち /訴訟告知/
そしょうさんか /訴訟参加/
そしょうしき /訴訟指揮/
そしょうじょうけん /訴訟条件/
そしょうだいりにん /訴訟代理人/
そしょうてつづき /訴訟手続/
そしょうのうりょく /訴訟能力/
そしょうひよう /訴訟費用/
そしょうぶつ /訴訟物/
そしょうほう /訴訟法/
そしょく /粗食/素食/
そしり /謗り/誹り/
そしりょう /粗飼料/
そしん /蘇秦/祖神/
そじ /素地/措辞/
そじゅつ /祖述/
そじょう /遡上/訴状/俎上/溯上/
そすい /疎水/
そすう /素数/
そせい /素性/塑性/粗製/組成/蘇生/甦生/
そせいしき /組成式/
そせいらんぞう /粗製乱造/
そせき /礎石/
そせん /祖先/
そぜい /租税/
そぜいほう /租税法/
そそ /楚楚/楚々/
そそう /粗相/阻喪/沮喪/
そそん /祖孫/
そぞう /塑像/
そだ /粗朶/
そだい /粗大/
そだち /育ち/
そだて /育て/
そち /措置/
そちゃ /粗茶/
そっか /足下/
そっき /速記/測器/
そっきしゃ /速記者/
そっきじゅつ /速記術/
そっきゅう /即急/速急/
そっきょ /卒去/
そっきょう /即興/
そっきょうえんそう /即興演奏/
そっきょうきょく /即興曲/
そっきょうし /即興詩/
そっきょうてき /即興的/
そっきろく /速記録/
そっきん /側近/即金/
そっけつ /即決/
そっけつさいばん /即決裁判/
そっこう /速攻/即効/測光/側溝/速効/即行/
そっこうじょ /測候所/
そっこく /即刻/
そっこん /即今/
そっせん /率先/
そっせんきゅうこう /率先躬行/
そっせんすいはん /率先垂範/
そっちゅう /卒中/
そっちょく /率直/
そっとう /卒倒/
そっぱ /反っ歯/
そっぽ /外方/
そつ /率/卒/
そつい /訴追/
そつう /疎通/疏通/
そつえん /卒園/
そつぎょう /卒業/
そつぎょうろんぶん /卒業論文/
そつじゅ /卒寿/
そつろん /卒論/
そてい /措定/
そてつ /蘇鉄/
そてん /素点/
そで /袖/
そでがうら /袖ケ浦/
そでぐち /袖口/
そでぐり /袖刳り/
そでたけ /袖丈/
そでなし /袖無し/
そでのした /袖の下/
そでまく /袖幕/
そでやま /袖山/
そと /外/
そとう /粗糖/
そとうば /卒塔婆/
そとうみ /外海/
そとおもて /外表/
そとがけ /外掛け/
そとがこい /外囲い/
そとがまえ /外構え/
そとがわ /外側/
そとづら /外面/
そとで /外出/
そとば /卒都婆/卒塔婆/率塔婆/
そとぼう /外房/
そとぼり /外堀/
そとまご /外孫/
そとまた /外股/
そとまわり /外回り/
そとみ /外見/
そとむき /外向き/
そとむそう /外無双/
そともうこ /外蒙古/
そとわく /外枠/
そどう /粗銅/
そどく /素読/
そなえ /供え/備え/
そなえつけ /備付け/
そなえもの /供え物/
そにん /訴人/
そねざき /曾根崎/
その /苑/其の/園/其/
そのほう /其の方/
そはんのう /素反応/
そば /蕎麦/側/傍/
そばこ /蕎麦粉/
そばめ /側目/
そばや /蕎麦屋/
そばやく /側役/
そばようにん /側用人/
そびょう /素描/祖廟/粗描/
そふ /祖父/
そふく /粗服/
そふぼ /祖父母/
そぶ /蘇武/
そぶり /素振り/
そほう /粗放/
そほうか /素封家/
そほん /粗笨/祖本/
そぼ /祖母/
そぼう /粗暴/
そぼく /素朴/
そま /杣/
そまぎ /杣木/
そまつ /粗末/
そみつ /疎密/粗密/
そみんしょうらい /蘇民将来/
そめ /染め/
そめい /疏明/疎明/
そめいよしの /染井吉野/
そめつけ /染付け/
そめもの /染物/
そめもよう /染模様/
そめや /染屋/
そめわけ /染分け/
そめん /粗面/
そや /粗野/
そよう /素養/
そようちょう /租庸調/
そよかぜ /微風/
そら /空/
そらあい /空合い/
そらい /徂徠/
そらいろ /空色/
そらおぼえ /空覚え/
そらぎき /空聞き/
そらだのみ /空頼み/
そらなき /空泣き/
そらなみだ /空涙/
そらに /空似/
そらね /空寝/空音/
そらみみ /空耳/
そらめ /空目/
そらもよう /空模様/
そらゆめ /空夢/
そらよみ /空読み/
そらわらい /空笑い/
そり /反り/橇/
そりみ /反り身/
そりゃく /粗略/
そりゅうし /素粒子/
そりゅうしろん /素粒子論/
そりん /疎林/
それ /其/
それい /祖霊/
それがし /某/
それぞれ /夫々/其其/夫夫/
それとなく /其と無く/
それどころ /其処/
それん /ソ連/
そろい /揃い/
そろいぶみ /揃い踏み/
そろう /疎漏/
そろえ /揃え/
そろばん /算盤/十露盤/
そん /損/存/遜/村/尊/孫/巽/樽/
そんい /尊意/
そんえい /村営/尊詠/尊影/
そんえき /損益/
そんえきかんじょう /損益勘定/
そんえきぶんきてん /損益分岐点/
そんか /尊下/尊家/
そんかい /損壊/村会/
そんがい /損害/
そんがいばいしょう /損害賠償/
そんがいほけん /損害保険/
そんがん /尊顔/
そんきょ /蹲踞/
そんきん /損金/
そんぎ /村議/
そんぎかい /村議会/
そんけい /尊敬/尊兄/
そんけいご /尊敬語/
そんげん /尊厳/
そんげんし /尊厳死/
そんこう /損耗/存稿/
そんごう /尊号/
そんごくう /孫悟空/
そんざい /存在/
そんざいりゆう /存在理由/
そんざいろん /存在論/
そんし /尊師/
そんしつ /損失/
そんしゃさんゆう /損者三友/
そんしょ /尊書/
そんしょう /損傷/尊称/
そんしょく /遜色/
そんしん /尊信/
そんじゃ /尊者/
そんじゅく /村塾/
そんせい /村政/
そんぜい /村税/
そんぜん /尊前/
そんそせっしょう /樽俎折衝/
そんぞう /尊像/
そんぞく /存続/尊属/
そんたい /尊体/
そんたく /忖度/尊宅/
そんだい /尊大/
そんち /存置/
そんちょう /尊重/村長/
そんとく /損得/
そんどう /村道/尊堂/
そんない /村内/
そんのう /尊皇/尊王/
そんのうじょうい /尊皇攘夷/
そんぱい /存廃/
そんぴ /存否/尊卑/
そんぶ /孫武/
そんぶん /孫文/
そんぷ /尊父/
そんぷうし /村夫子/
そんぼう /存亡/
そんぽ /損保/
そんみん /村民/
そんめい /尊名/尊命/
そんもう /損耗/損亡/
そんゆう /村有/
そんよう /尊容/
そんらく /村落/
そんらん /尊覧/
そんりつ /存立/村立/
そんりょ /尊慮/
そんりょう /損料/
ぞう /臓/贈/造/蔵/憎/増/像/雑/象/贓/
ぞうあく /増悪/
ぞうい /贈位/
ぞういん /増員/
ぞうえい /造営/
ぞうえいざい /造影剤/
ぞうえき /増益/
ぞうえん /増援/造園/
ぞうお /憎悪/
ぞうか /増加/造花/造化/増価/
ぞうかん /増刊/増感/
ぞうがく /増額/
ぞうがん /象嵌/象眼/
ぞうき /臓器/造機/雑木/
ぞうきいしょく /臓器移植/
ぞうきばやし /雑木林/
ぞうきゅう /増給/
ぞうきょう /増強/
ぞうきん /雑巾/
ぞうけい /造詣/造形/造型/
ぞうけいびじゅつ /造形美術/
ぞうけつ /増結/造血/
ぞうげ /象牙/
ぞうげいろ /象牙色/
ぞうげん /増減/造言/雑言/
ぞうこく /増石/
ぞうご /造語/
ぞうごう /贈号/
ぞうごん /雑言/
ぞうさ /造作/雑作/
ぞうさく /造作/
ぞうさつ /増刷/
ぞうさん /増産/
ぞうざい /造材/
ぞうざんたい /造山帯/
ぞうし /増資/
ぞうしがや /雑司ヶ谷/
ぞうしき /雑色/
ぞうしゅ /造酒/
ぞうしゅう /増収/
ぞうしゅうわい /贈収賄/
ぞうしょ /蔵書/
ぞうしょう /蔵相/
ぞうしょく /増殖/
ぞうしょくろ /増殖炉/
ぞうしん /増進/
ぞうじ /造次/
ぞうじてんぱい /造次顛沛/
ぞうじょう /増上/
ぞうじょうじ /増上寺/
ぞうじょうてん /増長天/
ぞうす /蔵主/
ぞうすい /雑炊/増水/
ぞうせい /造成/
ぞうせいき /蔵精器/造精器/
ぞうせつ /増設/造設/
ぞうせん /造船/
ぞうせんじょ /造船所/
ぞうぜい /増税/
ぞうたん /増反/増炭/
ぞうだい /増大/
ぞうちく /増築/
ぞうちょう /増長/増徴/
ぞうてい /贈呈/増訂/
ぞうとう /贈答/
ぞうとく /蔵匿/
ぞうに /雑煮/
ぞうは /増派/
ぞうはい /増配/
ぞうはつ /増発/
ぞうはん /造反/
ぞうひょう /雑兵/
ぞうび /増備/
ぞうふ /臓腑/
ぞうふく /増幅/
ぞうふくき /増幅器/
ぞうぶつ /贓物/
ぞうぶつしゃ /造物者/
ぞうぶつしゅ /造物主/
ぞうぶん /増分/
ぞうへい /造幣/造兵/
ぞうへいきょく /造幣局/
ぞうほ /増補/
ぞうほう /増俸/
ぞうほうたい /造胞体/
ぞうほん /造本/蔵本/
ぞうぼく /雑木/
ぞうむし /象虫/
ぞうもつ /臓物/雑物/
ぞうよ /贈与/
ぞうよう /雑用/
ぞうよぜい /贈与税/
ぞうらんき /蔵卵器/造卵器/
ぞうり /草履/
ぞうりょう /増量/
ぞうりん /造林/
ぞうわい /贈賄/
ぞうわいざい /贈賄罪/
ぞく /続/族/賊/属/俗/粟/
ぞくあく /俗悪/
ぞくうけ /俗受け/
ぞくえい /続映/
ぞくえん /続演/俗縁/
ぞくおん /属音/
ぞくがく /俗学/
ぞくがら /続柄/
ぞくがん /俗眼/
ぞくぐ /属具/
ぞくぐん /賊軍/
ぞくけ /俗気/
ぞくげん /俗言/俗諺/
ぞくご /俗語/
ぞくさい /続載/
ぞくさんへんど /粟散辺土/
ぞくし /賊子/続紙/
ぞくしゅ /俗手/
ぞくしゅう /俗臭/俗習/
ぞくしゅつ /続出/
ぞくしょ /俗書/
ぞくしょう /俗称/族称/
ぞくしん /続伸/俗信/賊臣/
ぞくじ /俗事/俗字/俗耳/
ぞくじょう /俗情/
ぞくじん /俗人/俗塵/属人/
ぞくせ /俗世/
ぞくせい /属性/俗世/族生/俗姓/族制/
ぞくせかい /俗世界/
ぞくせけん /俗世間/
ぞくせつ /俗説/
ぞくぞく /続々/
ぞくたい /俗体/
ぞくだん /俗談/
ぞくち /属地/
ぞくちしゅぎ /属地主義/
ぞくちほう /属地法/
ぞくちょう /族長/俗調/
ぞくでん /俗伝/
ぞくと /賊徒/
ぞくとう /属島/
ぞくに /俗に/
ぞくねん /俗念/
ぞくはい /俗輩/
ぞくはつ /続発/
ぞくばなれ /俗離れ/
ぞくふ /族譜/
ぞくぶつ /俗物/
ぞくぶん /俗文/
ぞくへい /賊兵/
ぞくへん /続編/続篇/
ぞくほう /続報/
ぞくみょう /俗名/
ぞくむ /俗務/
ぞくめい /俗名/賊名/
ぞくめつ /族滅/
ぞくよう /俗謡/俗用/
ぞくらく /続落/
ぞくり /俗吏/属吏/
ぞくりゅう /粟粒/俗流/
ぞくりょう /属領/俗了/属僚/
ぞくろん /俗論/
ぞくわおん /属和音/
ぞっか /俗化/
ぞっかい /俗界/俗解/続開/
ぞっかん /俗間/属官/
ぞっきぼん /ぞっき本/
ぞっきや /ぞっき屋/
ぞっきょう /俗境/
ぞっきょく /俗曲/
ぞっこう /続行/続稿/
ぞっこく /属国/
ぞめ /初め/
ぞん /存/
ぞんい /存意/
ぞんがい /存外/
ぞんじ /存知/存じ/
ぞんじあたり /存じ当り/
ぞんじょう /存生/
ぞんじより /存じ寄り/
ぞんち /存知/
ぞんねん /存念/
ぞんぶん /存分/
ぞんめい /存命/
た /他/太/多/田/手/詑/汰/
た> /多/他/
たあい /他愛/
たい /大/代/袋/体/隊/対/態/鯛/逮/退/貸/胎/滞/泰/替/戴/怠/待/帯/耐/堆/台/太/黛/他意/田井/諦/頽/田居/苔/腿/岱/
たい> /対/耐/
たいあたり /体当り/
たいあつ /耐圧/
たいあん /大安/対案/泰安/
たいあんきちじつ /大安吉日/
たいい /大意/体位/退位/大尉/胎位/
たいいく /体育/
たいいくかん /体育館/
たいいほう /対位法/
たいいん /退院/隊員/退隠/
たいいんれき /太陰暦/
たいえい /退嬰/
たいえき /体液/退役/
たいおう /対応/滞欧/
たいおん /体温/
たいおんけい /体温計/
たいおんちょうせつ /体温調節/
たいか /退化/大家/大過/耐火/大化/滞貨/対価/大火/大廈/袋果/
たいかい /大会/大海/退会/
たいかく /体格/対角/対格/
たいかくせん /対角線/
たいかざい /耐火材/
たいかん /退官/体感/耐寒/戴冠/大患/大観/大官/
たいかんおんど /体感温度/
たいかんしき /戴冠式/
たいが /大河/胎芽/
たいがい /大概/対外/体外/
たいがいじゅせい /体外受精/
たいがく /退学/
たいがしょうせつ /大河小説/
たいがため /体固め/
たいがん /対岸/大願/対顔/
たいき /待機/大気/大器/
たいきあつ /大気圧/
たいきおせん /大気汚染/
たいきけん /大気圏/
たいきばんせい /大器晩成/
たいきゃく /退却/
たいきゅう /耐久/
たいきゅうりょく /耐久力/
たいきょ /大挙/退去/
たいきょう /胎教/体協/滞京/
たいきょく /対極/太極/対局/大局/大曲/
たいきょくかん /大局観/
たいきょくき /太極旗/
たいきょくけん /太極拳/
たいきん /大金/退勤/
たいぎ /大義/大儀/体技/
たいぎご /対義語/
たいぎめいぶん /大義名分/
たいぎゃく /大逆/
たいぎゃくざい /大逆罪/
たいぎゃくむどう /大逆無道/
たいぎょ /大魚/
たいぎょう /怠業/大業/
たいく /体躯/
たいくう /対空/滞空/
たいくつ /退屈/
たいくん /大君/
たいぐ /大愚/
たいぐう /待遇/対偶/
たいぐん /大群/大軍/
たいけ /大家/
たいけい /体系/体型/体形/大慶/大系/大兄/大計/体刑/隊形/
たいけいてき /体系的/
たいけつ /対決/
たいけん /体験/大圏/大権/大剣/帯剣/
たいげ /帯下/
たいげん /体現/体言/大言/
たいげんそうご /大言壮語/
たいげんどめ /体言止め/
たいこ /太古/太鼓/大呼/
たいこう /対抗/対向/退行/大綱/大功/帯鉤/対校/退校/大江/大行/体腔/太閤/
たいこうき /太閤記/
たいこうしゃ /対向車/
たいこうしょく /退紅色/
たいこうば /対抗馬/
たいこうようけん /対抗要件/
たいこうりょく /対抗力/
たいこく /大国/
たいこばら /太鼓腹/
たいこばん /太鼓判/
たいこやき /太鼓焼/
たいご /隊伍/対語/
たいごう /対合/
たいごく /大獄/
たいさ /大差/大佐/
たいさい /大祭/大才/
たいさいじつ /大祭日/
たいさいぼう /体細胞/
たいさく /対策/大作/
たいさつ /大冊/
たいさん /退散/
たいざ /対座/胎座/退座/
たいざい /滞在/大罪/
たいざん /大山/泰山/
たいざんほくと /泰山北斗/
たいし /大使/大志/太子/大史/
たいしかん /大使館/
たいした /大した/
たいしつ /体質/退室/対質/耐湿/
たいしどう /太子堂/
たいしゃ /退社/代謝/大赦/大社/
たいしゃいろ /代赭色/
たいしゃく /貸借/帝釈/
たいしゃくきょう /帝釈峡/
たいしゃくてん /帝釈天/
たいしゃくとりひき /貸借取引/
たいしゅ /大酒/太守/
たいしゅう /体臭/大衆/
たいしゅうか /大衆化/
たいしゅうし /大衆誌/
たいしゅうせい /大衆性/
たいしゅうてき /大衆的/
たいしゅうぶんがく /大衆文学/
たいしゅつ /退出/帯出/
たいしょ /対処/対蹠/大暑/大書/大所/太初/
たいしょう /対象/大将/大賞/大正/対称/対照/対症/隊商/大勝/大笑/大捷/大詔/
たいしょうごと /大正琴/
たいしょうじっけん /対照実験/
たいしょうせい /対称性/
たいしょうてき /対照的/対称的/
たいしょうめん /対称面/
たいしょうりつ /対称律/
たいしょく /退職/大食/退色/褪色/
たいしょくかん /大食漢/
たいしょくきん /退職金/
たいしょくねんきん /退職年金/
たいしん /耐震/対審/大身/大震/
たいじ /退治/胎児/対峙/帯磁/太地/
たいじゅ /大樹/
たいじゅう /体重/
たいじゅうけい /体重計/
たいじゅつ /体術/
たいじょう /退場/帯状/
たいじょうほうしん /帯状疱疹/
たいじん /対人/退陣/大人/対陣/
たいじんかんけい /対人関係/
たいすい /耐水/大水/大酔/
たいすう /対数/大数/
たいすうかんすう /対数関数/
たいすうひょう /対数表/
たいする /対する/
たいせい /体制/態勢/大勢/耐性/大成/体勢/胎生/対生/大政/大声/大聖/
たいせいきん /耐性菌/
たいせいしっこ /大声疾呼/
たいせいほうかん /大政奉還/
たいせいよう /大西洋/
たいせき /体積/退席/堆積/滞積/対蹠/堆石/
たいせきがん /堆積岩/
たいせきじ /大石寺/
たいせつ /大切/大雪/体節/
たいせん /対戦/大戦/
たいせんしゃほう /対戦車砲/
たいせんちゅうるい /苔蘚虫類/
たいぜい /大勢/
たいぜん /泰然/大全/
たいぜんじじゃく /泰然自若/
たいそう /大層/体操/大喪/大葬/大宗/太宗/
たいそく /体側/大息/
たいぞう /退蔵/
たいだ /怠惰/
たいだん /対談/退団/
たいち /対地/対置/
たいちょ /大著/
たいちょう /体調/隊長/体長/退庁/退潮/
たいちょうかく /対頂角/
たいてい /大抵/退廷/
たいてき /大敵/対敵/
たいてん /大典/退転/
たいでん /帯電/
たいと /泰斗/
たいとう /対等/台東/台頭/擡頭/帯刀/対当/
たいとうがく /対当額/
たいとく /体得/
たいど /態度/大度/
たいどう /胎動/帯同/
たいどく /胎毒/
たいない /体内/胎内/対内/
たいないどけい /体内時計/
たいにち /対日/滞日/
たいにん /退任/大任/体認/
たいねつ /耐熱/
たいのう /滞納/怠納/
たいのうしょぶん /滞納処分/
たいは /大破/
たいはい /大敗/退廃/頽廃/
たいはく /太白/
たいはん /大半/大藩/
たいばつ /体罰/
たいばん /胎盤/
たいひ /退避/対比/堆肥/待避/貸費/
たいひせん /待避線/
たいひょう /体表/
たいびょう /大病/
たいふ /大夫/大輔/
たいふう /台風/颱風/
たいぶつ /対物/
たいぶんすう /帯分数/
たいへい /太平/大兵/泰平/
たいへいき /太平記/
たいへいよう /太平洋/
たいへいらく /太平楽/
たいへん /大変/対辺/
たいべつ /大別/
たいべん /胎便/
たいぺい /台北/
たいほ /逮捕/退歩/
たいほう /大砲/大鵬/大宝/
たいほく /台北/
たいほじょう /逮捕状/
たいぼう /待望/耐乏/大望/体貌/
たいぼく /大木/
たいま /大麻/当麻/
たいまい /大枚/玳瑁/
たいまつ /松明/
たいまん /怠慢/
たいめい /大命/待命/
たいめいがっき /体鳴楽器/
たいめし /鯛飯/
たいめん /対面/体面/
たいもう /大望/
たいやき /鯛焼/
たいやく /対訳/大役/大厄/大約/
たいゆう /大勇/
たいよ /貸与/
たいよう /大要/太陽/大洋/耐用/態様/体用/
たいようけい /太陽系/
たいようこくてん /太陽黒点/
たいようしゅう /大洋州/
たいようしん /太陽神/
たいようじ /太陽時/
たいようでんち /太陽電池/
たいようねん /太陽年/
たいようねんすう /耐用年数/
たいようふう /太陽風/
たいようれき /太陽暦/
たいら /平/平ら/
たいらのきよもり /平清盛/
たいらん /大乱/台覧/
たいり /大利/
たいりく /大陸/
たいりくだな /大陸棚/
たいりくほう /大陸法/
たいりつ /対立/
たいりついでんし /対立遺伝子/
たいりゃく /大略/
たいりゅう /対流/滞留/
たいりゅうけん /対流圏/
たいりょう /大量/退寮/大漁/大猟/
たいりょうせいさん /大量生産/
たいりょく /体力/
たいりん /大輪/台臨/
たいるい /苔類/
たいれい /大礼/
たいれつ /隊列/
たいろ /退路/
たいろう /大老/
たいろん /対論/
たいわ /対話/
たいわしゃ /対話者/
たいわへん /対話篇/
たいわん /台湾/
たいわんかいきょう /台湾海峡/
たう /多雨/
たうえ /田植/
たうた /田歌/
たえ /妙/栲/
たえず /絶えず/
たえだえ /絶え絶え/
たえま /絶え間/
たおか /田岡/
たおやか /嫋やか/
たおやめ /手弱女/
たおれ /倒れ/
たか /鷹/高/多寡/
たかあがり /高上がり/
たかあし /高足/
たかい /高井/他界/
たかいし /高石/
たかいびき /高鼾/
たかお /高尾/高雄/
たかおか /高岡/
たかおさん /高尾山/
たかか /多花果/
たかかわ /高河/
たかかんすう /多価関数/
たかがき /高垣/
たかがり /鷹狩/
たかき /高木/
たかぎ /高木/
たかぎし /高岸/
たかく /高久/多角/
たかくけい /多角形/
たかくけいえい /多角経営/
たかくてき /多角的/
たかくら /高倉/
たかくわ /高桑/
たかさ /高さ/
たかさき /高崎/
たかさきせん /高崎線/
たかさご /高砂/
たかさごだい /高砂台/
たかし /鷹師/
たかしお /高潮/
たかしま /高島/鷹島/
たかしまだ /高島田/
たかしまや /高島屋/
たかじょう /鷹匠/
たかすぎ /高杉/
たかすぎしんさく /高杉晋作/
たかせ /高瀬/
たかせがわ /高瀬川/
たかせぶね /高瀬舟/
たかた /高田/
たかだ /高田/
たかだい /高台/
たかだか /高々/
たかだのばば /高田馬場/
たかちほ /高千穂/
たかちほのみね /高千穂峰/
たかっけい /多角形/
たかつかさ /鷹司/
たかつき /高槻/
たかてこて /高手小手/
たかとお /高遠/
たかとき /高時/
たかとび /高飛び/
たかとり /高取/
たかどの /高殿/
たかな /高菜/
たかなみ /高波/高浪/
たかなわ /高縄/
たかに /高荷/
たかにし /高西/
たかね /高値/高根/高音/高嶺/
たかねのはな /高嶺の花/
たかの /高野/鷹野/
たかのす /鷹の巣/
たかのぞみ /高望み/
たかのつめ /鷹の爪/
たかはぎ /高萩/
たかはし /高橋/高梁/
たかはしこれきよ /高橋是清/
たかはな /高花/
たかはま /高浜/
たかはまきょし /高浜虚子/
たかはら /高原/
たかば /高場/
たかばたけ /高畠/
たかばなし /高話/
たかひく /高低/
たかひら /高平/
たかびしゃ /高飛車/
たかふだ /高札/
たかまがはら /高天原/
たかまくら /高枕/
たかまつ /高松/
たかまつし /高松市/
たかまつじょう /高松城/
たかまつのみや /高松宮/
たかまどのみや /高円宮/
たかまのはら /高天原/
たかみ /高見/高み/
たかみくら /高御座/
たかみず /高水/
たかみね /高峰/高嶺/
たかみや /高宮/
たかむこのくろまろ /高向玄理/
たかむしろ /簟/
たかむら /高村/篁/
たかむらこうたろう /高村光太郎/
たかもり /高盛/
たかや /高屋/
たかやす /高安/
たかやなぎ /高柳/
たかやま /高山/鷹山/
たかやまほんせん /高山本線/
たかようじ /高楊枝/
たから /財/宝/
たからい /宝井/
たからか /高らか/
たからじま /宝島/
たからずか /宝塚/
たからづか /宝塚/
たからぶね /宝船/
たからもの /宝物/
たかわらい /高笑い/
たかん /多感/
たかんしょう /多汗症/
たが /箍/
たがい /互い/違い/
たがいちがい /互い違い/
たがいに /互いに/
たがく /多額/
たがじょう /多賀城/
たがね /鏨/
たがらす /田烏/
たがわ /田川/田河/
たがわすいほう /田河水泡/
たき /滝/多岐/瀧/
たきい /滝井/
たきかわ /滝川/
たきがわ /滝川/
たきぎ /薪/
たきぎのう /薪能/
たきぐち /滝口/
たきざわ /滝沢/
たきた /滝田/
たきだし /炊出し/
たきなみ /滝波/
たきのがわ /滝野川/
たきび /焚火/
たきもと /滝本/
たきもの /焚物/
たきょう /他郷/
たきょく /多極/
たきょくか /多極化/
たきれんたろう /滝廉太郎/
たぎ /多義/
たぎご /多義語/
たぎょう /タ行/
たく /鐸/託/沢/拓/択/托/宅/卓/度/濯/柝/謫/多久/磔/琢/啄/
たくあつかい /宅扱い/
たくあん /沢庵/
たくいつ /択一/
たくえつ /卓越/
たくえつふう /卓越風/
たくけい /磔刑/
たくさい /卓才/
たくさり /田鎖/
たくさん /沢山/
たくしき /卓識/
たくしゅつ /卓出/
たくしょく /拓殖/
たくしょくだいがく /拓殖大学/
たくしん /宅診/
たくじ /卓爾/
たくじしょ /託児所/
たくじょう /卓上/
たくせつ /卓説/
たくせん /託宣/
たくぜつ /卓絶/
たくそう /託送/
たくそうてにもつ /託送手荷物/
たくち /宅地/
たくちなみかぜい /宅地並課税/
たくはい /宅配/
たくはつ /托鉢/
たくばつ /卓抜/
たくほん /拓本/
たくぼく /啄木/
たくま /琢磨/
たくみ /内匠/
たくよう /托葉/
たくらくしつろ /拓落失路/
たくりつ /卓立/
たくろん /卓論/
たくわえ /蓄え/貯え/
たぐい /類/
たぐち /田口/
たけ /茸/岳/丈/竹/他家/嶽/
たけい /多形/
たけうち /竹内/武内/
たけうま /竹馬/
たけお /武雄/丈夫/
たけかわ /竹河/
たけかんむり /竹冠/
たけがき /竹垣/
たけがり /茸狩/
たけこし /竹越/
たけざお /竹竿/
たけざき /竹崎/
たけざわ /竹沢/
たけしま /竹島/武島/
たけぞえ /竹添/
たけた /竹田/
たけだ /武田/竹田/
たけだしんげん /武田信玄/
たけち /武市/
たけっしょう /多結晶/
たけつ /多血/
たけつしつ /多血質/
たけづつ /竹筒/
たけとみじま /竹富島/
たけとりものがたり /竹取物語/
たけなか /竹中/
たけなわ /酣/闌/竹縄/
たけの /武野/
たけのうち /竹内/
たけのこ /竹の子/筍/笋/
たけのだい /竹の台/
たけのぶ /武信/
たけはら /竹原/
たけばし /竹橋/竹箸/
たけばやし /竹林/
たけひご /竹籤/
たけひさ /竹久/
たけひさゆめじ /竹久夢二/
たけふ /武生/
たけぶえ /竹笛/
たけべ /建部/
たけぼうき /竹箒/
たけみつ /竹光/
たけむら /竹村/
たけもと /竹本/
たけや /竹屋/
たけやり /竹槍/
たけん /他見/
たげい /多芸/
たげん /多元/多言/他言/
たげんてき /多元的/
たこ /凧/胼胝/蛸/
たこう /他校/多幸/多項/他行/
たこうしき /多項式/
たこく /他国/
たこくせき /多国籍/
たこくせききぎょう /多国籍企業/
たこやき /蛸焼/
たこん /多恨/
たご /田子/多胡/
たごのうら /田子の浦/
たごん /他言/多言/
たさい /多彩/多才/
たさいぼうせいぶつ /多細胞生物/
たさつ /他殺/
たさん /多産/
たざい /多罪/
たざき /田崎/
たざわこ /田沢湖/
たざん /他山/
たし /他紙/他誌/
たしか /確か/
たしき /多識/
たしざん /足し算/
たしせいせい /多士済済/
たしつ /多湿/
たしゃ /他社/他者/多謝/
たしゃく /他借/
たしゅ /多種/
たしゅう /他州/他宗/
たしゅたよう /多種多様/
たしゅつ /他出/
たしゅみ /多趣味/
たしょ /他所/他書/
たしょう /多少/他称/多祥/多生/他生/
たしょく /多色/
たしょくずり /多色刷/
たしろ /田代/
たしん /他心/
たしんきょう /多神教/
たじ /他事/多事/
たじたたん /多事多端/
たじたなん /多事多難/
たじつ /他日/
たじま /但馬/
たじみ /多治見/
たじゅう /多重/
たじゅうしょり /多重処理/
たじゅうほうそう /多重放送/
たじょう /多情/
たじょうたこん /多情多恨/
たじょうぶっしん /多情仏心/
たす /足す/
たすう /多数/
たすうけつ /多数決/
たすうは /多数派/
たすき /襷/
たすきがけ /襷掛け/
たすきぞり /襷反り/
たすけ /助け/
たすけぶね /助け船/
たずな /手綱/
たずね /尋ね/
たずねびと /尋ね人/
たずねもの /尋ね物/
たせん /他薦/
たぜい /多勢/
たそがれ /黄昏/
たそがれづき /黄昏月/
たそがれどき /黄昏時/
たそく /多足/
たそくるい /多足類/
たぞえ /田添/
たた /多々/
たたい /多胎/
たたいもんだい /多体問題/
たたえ /湛え/
たたかい /戦い/
たたきあげ /叩き上げ/
たたきだい /叩き台/
たたみ /畳/
たたみがえ /畳替え/
たたみもの /畳物/
たたん /他端/多端/
ただ /唯/只/多田/
ただい /多大/
ただいま /只今/唯今/
ただごと /唯事/
ただし /但し/正し/
ただちに /直ちに/
ただなか /只中/
ただのり /忠度/只乗り/
ただもの /只者/
ただよし /忠吉/
ただれ /爛れ/
たち /館/達/立/太刀/質/大刀/
たちあい /立合/立会/
たちあいえんぜつ /立会演説/
たちあいていし /立会停止/
たちあいにん /立会人/
たちい /立ち居/
たちいふるまい /立居振舞/
たちいり /立入/立入り/
たちうお /太刀魚/
たちうち /太刀打ち/立射ち/
たちおうじょう /立往生/
たちおよぎ /立ち泳ぎ/
たちかぜ /太刀風/
たちかわ /立川/
たちかわぶんこ /立川文庫/
たちがれ /立枯れ/
たちき /立木/
たちぎ /立木/
たちぎえ /立消え/
たちぎき /立聞き/
たちぐい /立食い/
たちさき /太刀先/
たちすがた /立ち姿/
たちすじ /太刀筋/
たちどころ /立ち所/
たちぬい /裁ち縫い/
たちはら /立原/
たちば /立場/
たちばな /橘/立花/
たちばなし /立ち話/
たちばん /立ち番/
たちまち /忽ち/
たちまわり /立回り/
たちみ /立見/
たちもの /断ち物/裁ち物/
たちやく /立役/
たちやま /立山/
たちよみ /立読み/
たちんぼう /立ちん坊/
たっかん /達観/
たっきゅう /卓球/
たっけい /磔刑/
たっけん /卓見/達見/
たっし /達し/
たっしき /達識/
たっしゃ /達者/
たっせい /達成/
たったいま /たった今/
たっちゅう /塔頭/
たっぴつ /達筆/
たつ /辰/竜/達/立/
たつい /達意/
たつき /立木/
たつじん /達人/
たつせ /立つ瀬/
たつた /竜田/
たつたがわ /竜田川/
たつなみ /立浪/
たつの /竜野/辰野/
たつのくち /竜ノ口/
たつぶん /達文/
たつべん /達弁/
たつまき /竜巻/
たつみ /巽/辰巳/
たづくり /田作り/
たづな /手綱/
たづら /田面/
たて /縦/楯/盾/館/建/殺陣/立て/竪/│/
たてあな /竪穴/
たていし /立石/
たていた /立板/
たていと /縦糸/
たてうり /建売/
たてかえ /立替え/
たてかえきん /立替金/
たてかわ /立川/
たてがき /縦書き/
たてがみ /鬣/
たてぎょうじ /立行司/
たてぎょく /建玉/
たてぐ /建具/
たてぐみ /縦組/
たてこう /竪坑/
たてごと /竪琴/
たてし /殺陣師/
たてしんどう /縦振動/
たてじく /縦軸/
たてじま /縦縞/
たてじょう /楯状/
たてすじ /縦筋/
たてちゃ /点茶/立茶/
たてつづけ /立て続け/
たてつぼ /建坪/立坪/
たてなが /縦長/
たてなみ /縦波/
たてね /建値/
たての /立野/
たてばやし /館林/
たてふだ /立て札/
たてぶえ /縦笛/
たてぼう /縦棒/
たてまえ /建前/立前/
たてまし /建増し/
たてまつ /立松/
たてむすび /縦結び/
たてもの /建物/
たてや /建家/
たてやくしゃ /立役者/
たてやま /立山/館山/
たてよこ /縦横/
たてわき /帯刀/
たてわり /縦割り/
たてん /他店/
たで /蓼/
たとえ /喩え/譬え/
たとえば /例えば/
たとえばなし /譬え話/
たどう /他動/
たどうし /他動詞/
たどく /多読/
たどころ /田所/
たどつ /多度津/
たどん /炭団/
たな /棚/店/
たなあげ /棚上げ/
たないけ /種池/
たないた /棚板/
たなおろし /棚卸し/
たなかぎいち /田中義一/
たなかだて /田中館/
たなこ /店子/
たなごころ /掌/
たなざらし /店晒し/
たなし /田無/
たなだ /棚田/
たなちん /店賃/
たなはし /棚橋/
たなばた /七夕/
たなべ /田辺/
たなもの /店者/
たなわ /手縄/
たなん /多難/
たに /谷/渓/谿/
たにあい /谷間/
たにかぜ /谷風/
たにかわ /谷川/
たにがわ /谷川/
たにがわだけ /谷川岳/
たにく /多肉/
たにぐち /谷口/
たにぐみ /谷汲/
たにざき /谷崎/
たにし /田螺/
たになか /谷中/
たにま /谷間/
たにまち /谷町/
たにみず /谷水/
たにむら /谷村/
たにん /他人/
たにんぎょうぎ /他人行儀/
たにんずう /多人数/
たぬき /狸/貍/
たぬきじる /狸汁/
たぬきねいり /狸寝入り/
たぬし /田主/
たぬま /田沼/
たね /種/
たねあかし /種明し/
たねあぶら /種油/
たねい /種井/
たねいも /種芋/
たねうし /種牛/
たねうま /種馬/
たねかわ /種川/
たねがしま /種子島/
たねぎれ /種切れ/
たねせん /種銭/
たねだ /種田/
たねつけ /種付け/
たねとり /種取り/
たねび /種火/
たねほん /種本/
たねまき /種蒔き/
たねもの /種物/
たねもみ /種籾/
たねん /多年/他年/他念/
たねんせい /多年生/
たねんそう /多年草/
たのう /多能/
たのかみ /田の神/
たのしみ /楽しみ/
たのみのつな /頼みの綱/
たのもし /頼もし/
たのもしこう /頼母子講/
たはた /田畑/
たはつ /多発/
たば /束/
たばい /多売/
たばこ /煙草/莨/
たばこせん /煙草銭/
たばね /束ね/
たばねがみ /束ね髪/
たばるざか /田原坂/
たび /度/旅/足袋/
たびかせぎ /旅稼ぎ/
たびがらす /旅烏/
たびげいにん /旅芸人/
たびこうぎょう /旅興行/
たびごころ /旅心/
たびさき /旅先/
たびじ /旅路/
たびじたく /旅支度/
たびすがた /旅姿/
たびたび /度々/
たびだち /旅立ち/
たびどり /旅鳥/
たびびと /旅人/
たびまわり /旅回り/
たびょう /多病/
たびらこ /田平子/
たぶのき /椨/
たぶん /多分/他聞/多聞/
たへんけい /多辺形/
たべ /田部/
たべあるき /食べ歩き/
たべごろ /食べ頃/
たべずぎらい /食べず嫌い/
たべもの /食べ物/
たべん /多弁/
たほう /他方/多方/
たほうめん /多方面/
たぼ /髱/
たぼう /多忙/多望/
たま /霊/玉/球/多摩/珠/偶/弾/
たまい /玉井/
たまいれ /玉入れ/
たまえ /玉江/
たまかずら /玉鬘/
たまがき /玉垣/
たまがわ /玉川/多摩川/
たまがわじょうすい /玉川上水/
たまき /環/
たまぐすく /玉城/
たまこ /多摩湖/
たまご /卵/玉子/
たまごいろ /卵色/
たまごやき /卵焼/
たまさきじんじゃ /玉前神社/
たましい /魂/
たましま /玉島/
たまじゃり /玉砂利/
たまたま /偶/
たまつき /玉突き/
たまつくり /玉造/
たまつばき /玉椿/
たまてばこ /玉手箱/
たまで /玉手/
たまど /玉戸/
たまな /玉名/
たまに /偶に/
たまねぎ /玉葱/
たまの /玉野/
たまのい /玉井/
たまのお /玉の緒/
たまのこし /玉の輿/
たまはし /玉橋/
たまみず /玉水/
たまむし /玉虫/
たまむしいろ /玉虫色/
たまもの /賜物/賜/
たまや /玉屋/
たまよけ /弾除け/
たまらない /堪らない/
たみ /民/
たみくさ /民草/
たみや /田宮/
たむけ /手向け/
たむし /田虫/
たむら /田村/
たむろ /屯/
ため /為/溜め/
ためいき /溜息/
ためいけ /溜池/
ためし /試し/例/
ためしぎり /試し斬り/
ためしざん /試し算/
ためなが /為永/
ために /為に/
ためん /多面/他面/
ためんたい /多面体/
ためんてき /多面的/
たもうさく /多毛作/
たもうるい /多毛類/
たもくてき /多目的/
たもと /袂/
たもり /田守/
たもん /多聞/他門/
たもんてん /多聞天/
たや /田谷/田屋/
たやま /田山/
たゆう /大輔/太夫/大夫/
たよう /多様/多用/他用/
たよく /多欲/
たより /便り/
たら /鱈/
たらい /盥/
たらいまわし /盥回し/
たらこ /鱈子/
たらじる /鱈汁/
たらず /足らず/
たらちね /垂乳根/
たり /足り/
たりき /他力/
たりきほんがん /他力本願/
たりつ /他律/
たりゅう /他流/
たりょう /多量/
たる /樽/垂/
たるい /樽井/
たるき /椽/榱/
たるざけ /樽酒/
たるだい /樽代/
たるみ /垂水/弛み/
たるみず /垂水/
たれ /垂れ/誰/
たれがし /誰某/
たれがみ /垂れ髪/
たれながし /垂れ流し/
たれまく /垂幕/
たろう /太郎/
たろうかじゃ /太郎冠者/
たろうまる /太郎丸/
たわ /撓/
たわけ /戯け/
たわけもの /戯け者/
たわごと /戯言/
たわし /束子/
たわむれ /戯れ/
たわむれがき /戯れ書き/
たわむれごと /戯れ言/戯れ事/
たわら /俵/
たん /単/端/反/鍛/誕/胆/短/炭/淡/歎/旦/探/担/嘆/丹/毯/痰/堪/壇/耽/湛/坦/箪/
たん> /短/
たんい /単位/
たんいえん /単位円/
たんいかぶせいど /単位株制度/
たんいけい /単位系/
たんいげん /単位元/
たんいせいしょく /単為生殖/
たんいつ /単一/
たんえ /丹絵/
たんおん /単音/短音/
たんおんかい /短音階/
たんか /単価/短歌/担架/炭化/啖呵/譚歌/
たんかか /単花果/
たんかくそうしょ /丹鶴叢書/
たんかすいそ /炭化水素/
たんかだいがく /単科大学/
たんかぶつ /炭化物/
たんかん /胆管/
たんがん /単眼/嘆願/歎願/単願/
たんき /短期/短気/単騎/単記/単機/
たんききおく /短期記憶/
たんきじこう /短期時効/
たんきだいがく /短期大学/
たんきゅう /探究/探求/単球/
たんきょく /単極/
たんきょり /短距離/
たんきん /鍛金/
たんぎょく /単玉/
たんく /短躯/
たんぐつ /短靴/
たんけい /短径/
たんけっしょう /単結晶/
たんけん /探検/探険/短剣/短見/
たんげい /端倪/
たんげん /単元/
たんこう /炭坑/単行/炭鉱/鍛工/鍛鋼/単鉤/湛江/淡紅/
たんこうしき /単項式/
たんこうのうりょく /堪航能力/
たんこうぼん /単行本/
たんこうるい /単孔類/
たんご /単語/丹後/端午/
たんごはんとう /丹後半島/
たんさ /探査/
たんさい /淡彩/短才/
たんさいが /淡彩画/
たんさいぼう /単細胞/
たんさき /探査機/
たんさく /探索/単作/
たんさん /炭酸/単産/
たんさんいんりょう /炭酸飲料/
たんさんえん /炭酸塩/
たんさんすい /炭酸水/
たんさんせん /炭酸泉/
たんざ /端座/単座/
たんざく /短冊/
たんざくがた /短冊形/
たんし /端子/譚詩/短枝/単子/箪食/短詩/短資/
たんしき /単式/
たんしこしょう /箪食壺漿/
たんしつ /炭質/
たんしゃ /単車/単射/
たんしゅく /短縮/
たんしゅん /探春/
たんしょ /短所/端緒/
たんしょう /短小/探勝/短章/
たんしょうしき /単勝式/
たんしょうはんだん /単称判断/
たんしょく /単色/
たんしょくこう /単色光/
たんしろん /単子論/
たんしん /単身/短針/短信/
たんしんし /単振子/
たんしんどう /単振動/
たんしんふにん /単身赴任/
たんじく /短軸/
たんじじつ /短時日/
たんじつ /短日/
たんじつげつ /短日月/
たんじゅう /短銃/胆汁/
たんじゅうしつ /胆汁質/
たんじゅん /単純/
たんじゅんおん /単純音/
たんじゅんせん /単純泉/
たんじょう /誕生/
たんじょうせき /誕生石/
たんじょうび /誕生日/
たんじん /炭塵/
たんす /箪笥/
たんすい /淡水/
たんすいかぶつ /炭水化物/
たんすいぎょ /淡水魚/
たんすいこ /淡水湖/
たんすいろ /短水路/
たんすう /単数/
たんせい /丹精/丹青/単性/端正/嘆声/端整/
たんせいか /単性花/
たんせき /胆石/旦夕/痰咳/
たんせん /単線/
たんぜい /担税/
たんぜん /丹前/端然/
たんそ /炭素/炭疽/
たんそう /単相/炭層/担送/
たんそきん /炭疽菌/
たんそく /嘆息/歎息/探測/
たんそせんい /炭素繊維/
たんぞう /鍛造/
たんたい /単体/担体/
たんたん /淡々/淡淡/眈々/眈眈/
たんだ /単打/短打/
たんだい /短大/探題/
たんち /探知/
たんちょ /端緒/
たんちょう /単調/短調/丹頂/探鳥/
たんてい /探偵/端艇/
たんていしょうせつ /探偵小説/
たんていもの /探偵物/
たんてき /端的/
たんてつ /鍛鉄/
たんでき /耽溺/
たんでん /炭田/丹田/
たんとう /担当/短刀/丹東/
たんどく /単独/耽読/丹毒/
たんどくかいそん /単独海損/
たんどくこうい /単独行為/
たんどくこうわ /単独講和/
たんなる /単なる/
たんに /単に/
たんにしょう /歎異抄/
たんにん /担任/
たんねん /丹念/
たんのう /堪能/胆嚢/
たんば /丹波/
たんばいろ /胆礬色/
たんばぐち /丹波口/
たんばん /胆礬/
たんぱ /短波/
たんぱく /蛋白/淡白/淡泊/
たんぱくしつ /蛋白質/
たんぱくせき /蛋白石/
たんぱくにょう /蛋白尿/
たんぱつ /単発/短髪/
たんび /耽美/
たんびは /耽美派/
たんぴょう /短評/
たんぴん /単品/
たんぶ /反歩/
たんぶん /短文/単文/探聞/
たんぷく /単複/
たんべんか /単弁花/
たんぺん /短編/短篇/
たんほんい /単本位/
たんぼ /田圃/
たんぼう /探訪/
たんぽ /担保/
たんぽつきしゃさい /担保付社債/
たんぽぶっけん /担保物権/
たんぽぶつ /担保物/
たんぽぽ /蒲公英/
たんまつ /端末/
たんまつそうち /端末装置/
たんめい /短命/
たんめん /湯麺/
たんもの /反物/
たんゆう /胆勇/
たんよう /単葉/
たんようき /単葉機/
たんよく /貪欲/
たんらく /短絡/
たんらん /貪婪/
たんり /単利/
たんりゃく /胆略/
たんりょ /短慮/
たんりょうたい /単量体/
たんりょく /胆力/淡緑/
たんりょくぼん /丹緑本/
たんれい /端麗/
たんれつ /単列/
たんれん /鍛練/鍛錬/
たんろくぼん /丹緑本/
だ /駄/舵/打/惰/妥/堕/蛇/兌/懦/儺/陀/楕/柁/唾/
だい /大/第/内/代/台/題/弟/
だい> /第/大/
だいあん /代案/
だいあんじ /大安寺/
だいい /題意/代位/
だいいち /第一/
だいいちいんしょう /第一印象/
だいいちぎ /第一義/
だいいちにんしゃ /第一人者/
だいいちにんしょう /第一人称/
だいいちりゅう /第一流/
だいいっしん /第一審/
だいいっせん /第一線/
だいいべんさい /代位弁済/
だいいん /代印/代員/
だいうちゅう /大宇宙/
だいえい /大永/
だいえいていこく /大英帝国/
だいえん /大円/
だいおう /大王/大黄/
だいおうじょう /大往生/
だいおん /大恩/
だいおんじょう /大音声/
だいか /代価/台下/
だいかえ /代替/
だいかくじ /大覚寺/
だいかこ /大過去/
だいかぞく /大家族/
だいかつ /大喝/
だいかべんさい /代価弁済/
だいかん /代官/大寒/
だいかんみんこく /大韓民国/
だいがく /大学/
だいがくいん /大学院/
だいがくせい /大学生/
だいがっこう /大学校/
だいがわり /代替り/
だいがん /大願/
だいがんじょうじゅ /大願成就/
だいき /大機/
だいきち /大吉/
だいきぼ /大規模/
だいきゅう /代休/
だいきゅうし /大臼歯/
だいきょう /大凶/
だいきょうこう /大恐慌/
だいきらい /大嫌い/
だいきん /代金/
だいぎ /代議/
だいぎいん /代議員/
だいぎし /代議士/
だいぎせいど /代議制度/
だいぎょうじ /大行事/
だいく /第九/大工/
だいぐうじ /大宮司/
だいけい /台形/大慶/
だいけつ /代決/
だいげん /代言/題言/
だいげんかい /大言海/
だいげんにん /代言人/
だいこう /代行/乃公/代講/
だいこうかいじだい /大航海時代/
だいこうどう /大講堂/
だいこく /大黒/
だいこくてん /大黒天/
だいこくばしら /大黒柱/
だいこん /大根/
だいこんあし /大根足/
だいこんやくしゃ /大根役者/
だいご /醍醐/第五/大悟/
だいごう /題号/
だいごくでん /大極殿/
だいごじ /醍醐寺/
だいごてってい /大悟徹底/
だいごみ /醍醐味/
だいさく /代作/
だいさん /第三/代参/
だいさんき /第三紀/
だいさんごく /第三国/
だいさんさいむしゃ /第三債務者/
だいさんしゃ /第三者/
だいさんせいりょく /第三勢力/
だいざ /台座/
だいざい /題材/大罪/
だいし /台紙/大師/第四/大姉/大志/台詞/題詞/題詩/
だいしがわら /大師河原/
だいしきょう /大司教/
だいしぜん /大自然/
だいしっこう /代執行/
だいしどう /大師堂/
だいしゃ /台車/
だいしゃりん /大車輪/
だいしゅうそうぞく /代襲相続/
だいしゅくしゃく /大縮尺/
だいしょ /代書/
だいしょう /大小/代償/大将/
だいしょうじ /大聖寺/
だいしょうり /大勝利/
だいしょにん /代書人/
だいしん /代診/
だいしんいん /大審院/
だいしんさい /大震災/
だいじ /大事/題字/大治/大字/大寺/大慈/題辞/
だいじしん /大地震/
だいじだいひ /大慈大悲/
だいじゃ /大蛇/
だいじゅんかん /大循環/
だいじょう /大嘗/大乗/大判官/台状/
だいじょうかん /太政官/
だいじょうきょう /大乗経/
だいじょうさい /大嘗祭/
だいじょうじ /大乗寺/
だいじょうだいじん /太政大臣/
だいじょうだん /大上段/
だいじょうぶ /大丈夫/
だいじょうみゃく /大静脈/
だいじり /台尻/
だいじん /大臣/大尽/大神/
だいじんかんぼう /大臣官房/
だいじんぐう /大神宮/
だいじんぶつ /大人物/
だいす /台子/
だいすう /代数/台数/
だいすうがく /代数学/
だいすうきかがく /代数幾何学/
だいすうきょくせん /代数曲線/
だいすうけい /代数系/
だいすうしき /代数式/
だいすき /大好き/
だいず /大豆/
だいせつざん /大雪山/
だいせん /大山/
だいせんきょく /大選挙区/
だいぜん /大膳/
だいぜんてい /大前提/
だいそう /代走/
だいそうじょう /大僧正/
だいそつ /大卒/
だいたい /大体/代替/大腿/大隊/
だいたいこうか /代替効果/
だいたいこつ /大腿骨/
だいたいしっこう /代替執行/
だいたいぶつ /代替物/
だいたすう /大多数/
だいたん /大胆/
だいたんふてき /大胆不敵/
だいだ /代打/
だいだい /橙/大々/代々/
だいだいいろ /橙色/
だいだいてき /大々的/
だいだいり /大内裏/
だいだんえん /大団円/
だいち /大地/台地/代地/代置/
だいちょう /台帳/大腸/
だいちょうえん /大腸炎/
だいちょうきん /大腸菌/
だいてん /大篆/大典/
だいてんし /大天使/
だいてんもく /台天目/
だいと /大都/
だいとう /大東/大刀/大塔/
だいとうあ /大東亜/
だいとうあせんそう /大東亜戦争/
だいとうりょう /大統領/
だいとかい /大都会/
だいとく /大徳/
だいとくじ /大徳寺/
だいとし /大都市/
だいどう /大同/大道/
だいどうげい /大道芸/
だいどうしょうい /大同小異/
だいどうじ /大道寺/
だいどうだんけつ /大同団結/
だいどうみゃく /大動脈/
だいどく /代読/
だいどころ /台所/
だいなごん /大納言/
だいなし /台無し/
だいなん /大難/
だいに /第二/大弐/
だいにぎ /第二義/
だいにじさんぎょう /第二次産業/
だいにち /大日/
だいにちだけ /大日岳/
だいにちにょらい /大日如来/
だいにっぽん /大日本/
だいにほん /大日本/
だいにゅう /代入/
だいにん /代人/大人/代任/
だいの /大の/
だいのう /大脳/代納/
だいのうかい /大納会/
だいのうはんきゅう /大脳半球/
だいのうひしつ /大脳皮質/
だいのじ /大の字/
だいはち /大八/
だいはっかい /大発会/
だいはっせい /大発生/
だいば /台場/
だいばかり /台秤/
だいばん /台盤/
だいひ /大悲/
だいひつ /代筆/
だいひゃっか /大百科/
だいひょう /代表/
だいひょうけん /代表権/
だいひょうさく /代表作/
だいひょうしゃいん /代表社員/
だいひょうち /代表値/
だいひょうてき /代表的/
だいひん /代品/
だいふく /大福/
だいふくちょう /大福帳/
だいふくもち /大福餅/
だいふだ /台札/
だいぶ /大分/大夫/
だいぶつ /大仏/代物/
だいぶつべんさい /代物弁済/
だいぶぶん /大部分/
だいぶん /大分/
だいへん /代返/
だいべん /代弁/大便/
だいべんしゃ /代弁者/
だいほう /大宝/
だいほん /台本/
だいほんえい /大本営/
だいほんざん /大本山/
だいぼさつ /大菩薩/
だいみょう /大名/
だいみょうじん /大明神/
だいみょうりょこう /大名旅行/
だいめ /台目/代目/
だいめい /題名/
だいめいし /代名詞/
だいもく /題目/
だいもつ /大物/代物/
だいもん /大門/大紋/
だいもんじ /大文字/
だいもんじやま /大文字山/
だいやく /代役/
だいやくしん /大躍進/
だいよう /代用/
だいようかんごく /代用監獄/
だいようしょく /代用食/
だいよん /第四/
だいよんき /第四紀/
だいり /代理/内裏/大理/
だいりき /大力/
だいりけん /代理権/
だいりこうい /代理行為/
だいりしょう /代理商/
だいりせき /大理石/
だいりせんそう /代理戦争/
だいりせんゆう /代理占有/
だいりてん /代理店/
だいりにん /代理人/
だいりはは /代理母/
だいりびな /内裏雛/
だいりょう /代料/大領/
だいれん /大連/
だいろく /第六/
だいわくせい /大惑星/
だえき /唾液/
だえきせん /唾液腺/
だえん /楕円/橢円/
だえんけい /楕円形/
だえんたい /楕円体/
だえんめん /楕円面/
だかい /打開/
だかつ /蛇蝎/蛇蠍/
だかん /兌換/蛇管/朶翰/
だかんけん /兌換券/
だかんしへい /兌換紙幣/
だがし /駄菓子/
だがっき /打楽器/
だき /唾棄/舵機/惰気/
だきみょうが /抱茗荷/
だきょう /妥協/
だく /諾/濁/駄句/
だくい /諾意/
だくおん /濁音/
だくしゅ /濁酒/
だくすい /濁水/
だくせい /濁世/
だくてん /濁点/
だくひ /諾否/
だくりゅう /濁流/
だけ /岳/嶽/
だけつ /妥結/
だけん /打鍵/駄犬/
だげき /打撃/
だこう /蛇行/
だこく /打刻/
ださく /駄作/
ださん /打算/
ださんてき /打算的/
だざい /太宰/
だざいおさむ /太宰治/
だざいふ /太宰府/大宰府/
だし /山車/
だしいれ /出し入れ/
だしおしみ /出し惜しみ/
だしじる /出し汁/
だしもの /出し物/
だしゃ /打者/
だしゅ /舵手/
だしん /打診/
だじゃく /懦弱/
だじゃれ /駄洒落/
だじゅん /打順/
だじょうだいじん /太政大臣/
だすう /打数/
だせい /惰性/打製/
だせいせっき /打製石器/
だせき /打席/
だせきすう /打席数/
だせん /打線/
だそく /蛇足/
だたい /堕胎/
だたいざい /堕胎罪/
だだ /駄々/
だち /立ち/
だちょう /駝鳥/
だちん /駄賃/
だっか /脱化/
だっかい /脱会/奪回/
だっかく /奪格/
だっかん /奪還/
だっきゃく /脱却/
だっきゅう /脱臼/
だっこ /抱っこ/
だっこう /脱稿/脱肛/
だっこく /脱穀/
だっこくき /脱穀機/
だっし /脱脂/
だっしにゅう /脱脂乳/
だっしめん /脱脂綿/
だっしゅ /奪取/
だっしゅう /脱臭/
だっしゅうざい /脱臭剤/
だっしゅつ /脱出/
だっしゅつそくど /脱出速度/
だっしょく /脱色/
だっしょくざい /脱色剤/
だっすい /脱水/
だっすいき /脱水機/
だっせん /脱線/
だっそう /脱走/
だったい /脱退/奪胎/
だったん /韃靼/
だっちょう /脱腸/
だっと /脱兎/
だっとう /脱党/脱刀/
だっぱん /脱藩/
だっぴ /脱皮/
だっぷん /脱糞/
だっぽう /脱法/
だつ /奪/脱/獺/
だつい /脱衣/
だつえい /脱営/
だつご /脱誤/
だつごく /脱獄/
だつじ /脱字/
だつぜい /脱税/
だつぞく /脱俗/
だつぶん /脱文/
だつぼう /脱帽/
だつもう /脱毛/
だつらく /脱落/
だつり /脱離/
だつりゃく /奪略/奪掠/
だつりゅう /脱硫/
だつりょくかん /脱力感/
だつろう /脱漏/脱牢/
だて /伊達/立て/建て/
だておとこ /伊達男/
だてしゃ /伊達者/
だてすがた /伊達姿/
だてまき /伊達巻/
だてまさむね /伊達政宗/
だてん /打点/
だでん /打電/
だとう /妥当/打倒/
だに /壁蝨/
だは /打破/
だば /駄馬/
だび /荼毘/
だぶつ /陀仏/
だぶん /駄文/
だべん /駄弁/
だほ /拿捕/
だほん /駄本/
だぼう /打棒/
だぼく /打撲/
だぼくしょう /打撲傷/
だましうち /騙し討ち/
だみん /惰眠/
だめ /駄目/
だめおし /駄目押し/
だもの /駄物/
だらく /堕落/
だらに /陀羅尼/
だりつ /打率/
だりょく /惰力/
だるま /達磨/
だれ /誰/
だれそれ /誰某/
だれひとり /誰一人/
だん /男/段/断/弾/暖/談/檀/壇/団/旦/
だん> /団/
だんあつ /弾圧/
だんあん /断案/
だんい /段位/
だんいた /段板/
だんいほうしょく /暖衣飽食/
だんいん /団員/
だんう /弾雨/
だんうん /断雲/
だんおち /檀越/
だんおつ /檀越/
だんか /檀家/
だんかい /段階/団塊/
だんがい /弾劾/断崖/
だんがん /弾丸/
だんがんれっしゃ /弾丸列車/
だんき /暖気/断機/
だんきゅう /段丘/
だんきん /弾琴/断琴/断金/
だんぎ /談議/談義/
だんけい /男系/
だんけつ /団結/
だんけつけん /団結権/
だんげん /断言/
だんこ /断固/断乎/
だんこう /断交/断行/団交/
だんこん /男根/弾痕/
だんご /団子/
だんごう /談合/
だんごうこうい /談合行為/
だんごばな /団子鼻/
だんさ /段差/
だんさい /断裁/
だんさいき /断裁機/
だんざい /断罪/
だんし /男子/弾指/檀紙/弾糸/
だんしゃく /男爵/
だんしゅ /断種/断酒/
だんしゅう /男囚/
だんしょう /談笑/断章/男娼/
だんしょく /暖色/男色/
だんじ /男児/
だんじき /断食/
だんじて /断じて/
だんじょ /男女/
だんじょう /壇上/弾正/
だんじょどうけん /男女同権/
だんすい /断水/
だんせい /男性/男声/弾性/
だんせいたい /弾性体/
だんせいは /弾性波/
だんせいび /男性美/
だんせん /断線/
だんぜつ /断絶/
だんぜん /断然/
だんそう /断層/男装/弾倉/断想/弾奏/
だんそうしゃしん /断層写真/
だんそうめん /断層面/
だんそんじょひ /男尊女卑/
だんぞく /断続/
だんたい /団体/弾帯/
だんたいきょうぎ /団体競技/
だんたいこうしょう /団体交渉/
だんだん /段々/
だんち /団地/暖地/
だんちがい /段違い/
だんちゃく /弾着/
だんちょう /団長/断腸/
だんてい /断定/
だんと /檀徒/
だんとう /暖冬/弾頭/
だんとうだい /断頭台/
だんどう /弾道/
だんどうがく /弾道学/
だんどうだん /弾道弾/
だんどり /段取り/
だんな /旦那/
だんねつ /断熱/
だんねつざい /断熱材/
だんねん /断念/
だんのうら /壇ノ浦/
だんばしご /段梯子/
だんぱつ /断髪/
だんぱん /談判/
だんびら /段平/
だんぺん /断片/
だんぺんてき /断片的/
だんぼう /暖房/煖房/
だんまく /弾幕/段幕/
だんまつま /断末魔/断末摩/
だんめつ /断滅/
だんめん /断面/
だんめんず /断面図/
だんめんせき /断面積/
だんもの /段物/
だんやく /弾薬/
だんゆう /男優/
だんらく /段落/
だんらん /団欒/
だんりゅう /暖流/
だんりょく /弾力/
だんりん /檀林/
だんろ /暖炉/煖炉/
だんろん /談論/
だんろんふうはつ /談論風発/
だんわ /談話/
ち /値/恥/地/知/茅/遅/致/置/稚/痴/池/智/治/血/質/千/乳/笞/馳/弛/
ちあい /血合/
ちあん /治安/
ちあんいじほう /治安維持法/
ちい /地位/地衣/地異/地維/
ちいき /地域/値域/
ちいきかいはつ /地域開発/
ちいきしゃかい /地域社会/
ちいく /知育/
ちいさな /小さな/
ちいるい /地衣類/
ちいん /知音/
ちうみ /血膿/
ちえ /千枝/千重/知恵/智慧/
ちえきけん /地役権/
ちえしゃ /知恵者/
ちえねつ /知恵熱/
ちえぶくろ /知恵袋/
ちえん /遅延/地縁/
ちえんりそく /遅延利息/
ちおん /地温/
ちおんいん /知恩院/
ちか /地下/地価/治下/
ちかい /地階/
ちかかつどう /地下活動/
ちかがい /地下街/
ちかく /地殻/知覚/近く/地核/
ちかくしんけい /知覚神経/
ちかくへんどう /地殻変動/
ちかけい /地下茎/
ちかごろ /近頃/
ちかし /近し/
ちかしげん /地下資源/
ちかしつ /地下室/
ちかじか /近々/
ちかすい /地下水/
ちかぜい /地価税/
ちかそしき /地下組織/
ちかぢか /近々/
ちかって /誓って/
ちかてつ /地下鉄/
ちかどう /地下道/
ちかば /近場/
ちかま /近間/
ちかまつ /近松/
ちかまわり /近回り/
ちかみち /近道/
ちから /力/
ちからいし /力石/
ちからいっぱい /力一杯/
ちからおとし /力落し/
ちからがみ /力紙/
ちからこぶ /力瘤/
ちからしごと /力仕事/
ちからじまん /力自慢/
ちからぞえ /力添え/
ちからだのみ /力頼み/
ちからだめし /力試し/
ちからづよい /力強い/
ちからぬけ /力抜け/
ちからまかせ /力任せ/
ちからまけ /力負け/
ちからみず /力水/
ちからもち /力餅/力持/
ちからわざ /力業/
ちかん /置換/痴漢/弛緩/遅緩/
ちがい /違い/
ちがいほうけん /治外法権/
ちがえ /違え/
ちがく /地学/
ちがさき /茅ヶ崎/
ちがや /茅/
ちき /知己/
ちきゅう /地球/恥丘/
ちきゅうかがく /地球科学/
ちきゅうぎ /地球儀/
ちきゅうじば /地球磁場/
ちきゅうぶつりがく /地球物理学/
ちきょう /地峡/
ちきょうだい /乳兄弟/
ちぎ /遅疑/
ちぎょ /稚魚/
ちぎょう /知行/
ちく /地区/逐/蓄/筑/竹/畜/築/馳駆/
ちくいち /逐一/
ちくおんき /蓄音機/
ちくかん /竹簡/
ちくご /筑後/
ちくごがわ /筑後川/
ちくごやく /逐語訳/
ちくさ /千種/
ちくさつ /畜殺/
ちくさん /畜産/
ちくざい /蓄財/
ちくし /竹枝/竹紙/
ちくしの /筑紫野/
ちくしゃ /畜舎/
ちくしょう /畜生/
ちくしょうどう /畜生道/
ちくじ /逐次/
ちくじょう /築城/逐条/
ちくせき /蓄積/
ちくぜん /筑前/
ちくぜんに /筑前煮/
ちくぞう /築造/蓄蔵/
ちくてい /築庭/築堤/
ちくてん /逐電/
ちくでんき /蓄電器/
ちくでんち /蓄電池/
ちくとうぼくせつ /竹頭木屑/
ちくねん /逐年/
ちくのうしょう /蓄膿症/
ちくはく /竹帛/
ちくば /竹馬/
ちくひ /竹皮/
ちくび /乳首/
ちくほう /筑豊/
ちくほうほんせん /筑豊本線/
ちくまがわ /千曲川/
ちくりん /竹林/
ちくるい /畜類/
ちくろく /逐鹿/
ちくわ /竹輪/
ちぐ /痴愚/
ちぐう /知遇/
ちぐさ /千草/
ちぐさいろ /千草色/
ちけい /地形/
ちけいがく /地形学/
ちけいず /地形図/
ちけむり /血煙/
ちけん /知見/地検/
ちこう /遅効/地溝/知行/
ちこうふう /地衡風/
ちこく /遅刻/治国/
ちこつ /恥骨/
ちご /稚児/
ちさい /地裁/
ちさと /千里/
ちさん /治山/遅参/治産/
ちし /致死/致仕/智歯/地誌/地史/
ちしお /血潮/
ちしき /知識/
ちしきかいきゅう /知識階級/
ちしきこうがく /知識工学/
ちしきじん /知識人/
ちしきそう /知識層/
ちしきよく /知識欲/
ちしつ /地質/知悉/
ちしつがく /地質学/
ちしつねんだい /地質年代/
ちしま /千島/
ちしまれっとう /千島列島/
ちしゃ /知者/萵苣/治者/智者/
ちしょ /地所/
ちしょう /知将/池沼/地象/
ちしりつ /致死率/
ちしりょう /致死量/
ちしん /地心/
ちじ /知事/
ちじき /地磁気/
ちじく /地軸/
ちじつ /遅日/
ちじゅつ /治術/
ちじょう /地上/痴情/笞杖/
ちじょうけい /地上茎/
ちじょうけん /地上権/
ちじょく /恥辱/
ちじん /知人/痴人/
ちすい /治水/池水/
ちすいかふう /地水火風/
ちすじ /血筋/
ちず /地図/
ちせい /知性/治世/地勢/
ちせいがく /地政学/
ちせいてき /知性的/
ちせき /地積/治績/
ちせつ /稚拙/
ちそ /地租/
ちそう /馳走/地層/地相/
ちそく /遅速/知足/
ちぞめ /血染め/
ちた /知多/
ちたい /地帯/遅滞/痴態/
ちたつ /遅達/
ちたはんとう /知多半島/
ちだい /地代/
ちだるま /血達磨/
ちち /父/乳/遅々/
ちちうえ /父上/
ちちうし /乳牛/
ちちおや /父親/
ちちかた /父方/
ちちぎみ /父君/
ちちご /父御/
ちちじま /父島/
ちちなしご /父無し子/
ちちはる /斉斉哈爾/
ちちばなれ /乳離れ/
ちちぶ /秩父/
ちちぶのみや /秩父宮/
ちちゅう /地中/
ちちゅうかい /地中海/
ちぢ /千々/
ちぢれ /縮れ/
ちぢわ /千々石/
ちっかん /竹簡/
ちっきょ /蟄居/
ちっこう /築港/
ちっし /窒死/
ちっそ /窒素/
ちっそく /窒息/
ちっそさんかぶつ /窒素酸化物/
ちっと /些と/
ちっとも /些とも/
ちつ /窒/秩/膣/帙/腟/
ちつじょ /秩序/
ちつづき /血続き/
ちづか /千束/
ちてい /地底/
ちてき /知的/
ちてきざいさんけん /知的財産権/
ちてん /地点/
ちと /些と/少と/
ちとく /知得/地徳/
ちとせ /千歳/
ちとせあめ /千歳飴/
ちとせせん /千歳線/
ちどうせつ /地動説/
ちどめ /血止め/
ちどり /千鳥/鵆/
ちどりあし /千鳥足/
ちどん /遅鈍/
ちなみに /因みに/
ちにち /知日/
ちねつ /地熱/
ちの /茅野/
ちのう /知能/智能/
ちのうしすう /知能指数/
ちのうはん /知能犯/
ちのうみ /血の海/
ちのけ /血の気/
ちのり /血糊/地の利/
ちはい /遅配/
ちはつ /遅発/
ちはやじょう /千早城/
ちはら /茅原/
ちはらい /遅払い/
ちば /千葉/
ちばけん /千葉県/
ちばし /千葉市/
ちばだいがく /千葉大学/
ちばなれ /乳離れ/
ちばん /地番/
ちひつ /遅筆/
ちひょう /地表/
ちひょうすい /地表水/
ちひろ /千尋/
ちびっこ /ちびっ子/
ちぶ /恥部/
ちぶさ /乳房/
ちぶつ /地物/
ちへい /地平/治平/
ちへいせん /地平線/
ちへいめん /地平面/
ちへど /血反吐/
ちへん /地変/
ちべん /智辯/
ちほ /地歩/
ちほう /地方/痴呆/
ちほうかん /地方官/
ちほうぎょうせい /地方行政/
ちほうぎんこう /地方銀行/
ちほうく /地方区/
ちほうこうふぜい /地方交付税/
ちほうこうむいん /地方公務員/
ちほうさい /地方債/
ちほうさいばんしょ /地方裁判所/
ちほうざいせい /地方財政/
ちほうし /地方紙/
ちほうしょく /地方色/
ちほうじ /地方時/
ちほうじち /地方自治/
ちほうじちたい /地方自治体/
ちほうじむしょ /地方事務所/
ちほうせんきょ /地方選挙/
ちほうぜい /地方税/
ちほうだんたい /地方団体/
ちほうてつどう /地方鉄道/
ちほうばん /地方版/
ちほうぶんけん /地方分権/
ちほうれんらくぶ /地方連絡部/
ちぼう /知謀/智謀/
ちまき /粽/
ちまた /巷/
ちまつり /血祭/
ちまなこ /血眼/
ちまみれ /血塗れ/
ちまめ /血豆/
ちみ /地味/魑魅/
ちみち /血道/
ちみつ /緻密/
ちみどろ /血みどろ/
ちみもうりょう /魑魅魍魎/
ちみゃく /地脈/
ちみん /治民/
ちめい /地名/致命/知名/知命/
ちめいしょう /致命傷/
ちめいてき /致命的/
ちめいど /知名度/
ちもう /恥毛/
ちもく /地目/
ちゃ /茶/
ちゃーしゅー /叉焼/
ちゃーしゅーめん /叉焼麺/
ちゃーはん /炒飯/
ちゃいれ /茶入/
ちゃいろ /茶色/
ちゃうけ /茶請け/
ちゃうす /茶臼/
ちゃうすやま /茶臼山/
ちゃえん /茶園/
ちゃおず /餃子/
ちゃか /茶菓/
ちゃかい /茶会/
ちゃかっしょく /茶褐色/
ちゃがし /茶菓子/
ちゃがま /茶釜/
ちゃがら /茶殻/
ちゃき /茶器/
ちゃきん /茶巾/
ちゃく /着/嫡/
ちゃくい /着衣/着意/
ちゃくえき /着駅/
ちゃくがん /着眼/着岸/
ちゃくさい /嫡妻/
ちゃくざ /着座/
ちゃくし /嫡子/
ちゃくしつ /嫡室/
ちゃくしゅ /着手/
ちゃくしゅつ /嫡出/
ちゃくしゅつし /嫡出子/
ちゃくしょう /着床/
ちゃくしょく /着色/
ちゃくしん /着信/
ちゃくじつ /着実/
ちゃくじゅん /着順/
ちゃくすい /着水/
ちゃくせい /着生/
ちゃくせき /着席/
ちゃくせつ /着雪/
ちゃくせん /着船/
ちゃくそう /着想/着装/
ちゃくそん /嫡孫/
ちゃくたい /着帯/
ちゃくだつ /着脱/
ちゃくだん /着弾/
ちゃくち /着地/
ちゃくちゃく /着々/着着/
ちゃくでん /着電/
ちゃくとう /着到/
ちゃくなん /嫡男/
ちゃくに /着荷/
ちゃくにん /着任/
ちゃくはつ /着発/
ちゃくばらい /着払い/
ちゃくひつ /着筆/
ちゃくひょう /着氷/
ちゃくふく /着服/
ちゃくぼ /嫡母/
ちゃくもく /着目/
ちゃくよう /着用/
ちゃくりく /着陸/
ちゃくりゅう /嫡流/
ちゃこし /茶漉し/
ちゃさじ /茶匙/
ちゃしつ /茶室/
ちゃしぶ /茶渋/
ちゃしゃく /茶杓/
ちゃじ /茶事/
ちゃじん /茶人/
ちゃせき /茶席/
ちゃせん /茶筅/茶筌/
ちゃたく /茶托/
ちゃだい /茶代/
ちゃだな /茶棚/
ちゃだんす /茶箪笥/
ちゃちゃ /茶々/茶茶/
ちゃっか /着火/着荷/
ちゃっかてん /着火点/
ちゃっかん /着艦/
ちゃっきん /着金/
ちゃっけん /着剣/
ちゃっこう /着工/
ちゃつみ /茶摘み/
ちゃづけ /茶漬/
ちゃづつ /茶筒/
ちゃてん /茶店/
ちゃどう /茶道/
ちゃどうぐ /茶道具/
ちゃどころ /茶所/
ちゃのま /茶の間/
ちゃのみ /茶飲み/
ちゃのゆ /茶の湯/
ちゃはる /察哈爾/
ちゃばおり /茶羽織/
ちゃばこ /茶箱/
ちゃばしら /茶柱/
ちゃばたけ /茶畑/
ちゃばな /茶花/
ちゃばなし /茶話/
ちゃばら /茶腹/
ちゃばん /茶番/
ちゃびん /茶瓶/
ちゃぶだい /卓袱台/
ちゃほ /茶舗/
ちゃぼうず /茶坊主/
ちゃみ /茶味/
ちゃみせ /茶店/
ちゃめ /茶目/
ちゃめし /茶飯/
ちゃや /茶屋/
ちゃやま /茶山/
ちゃわ /茶話/
ちゃわん /茶碗/
ちゃわんむし /茶碗蒸し/
ちゅう /中/注/昼/虫/宙/駐/鋳/註/衷/柱/抽/忠/仲/沖/厨/籌/紂/誅/丑/酎/
ちゅう> /中/
ちゅうい /注意/中尉/中位/
ちゅういぎむ /注意義務/
ちゅういじんぶつ /注意人物/
ちゅういほう /注意報/
ちゅういん /中陰/
ちゅうえい /中衛/
ちゅうおう /中央/紂王/中欧/
ちゅうおうぎんこう /中央銀行/
ちゅうおうく /中央区/
ちゅうおうこうろん /中央公論/
ちゅうおうしょりそうち /中央処理装置/
ちゅうおうせいふ /中央政府/
ちゅうおうだいがく /中央大学/
ちゅうおうち /中央値/
ちゅうおうほんせん /中央本線/
ちゅうおん /中音/
ちゅうか /中華/
ちゅうかい /仲介/注解/厨芥/
ちゅうかく /中核/
ちゅうかなべ /中華鍋/
ちゅうかひ /中果皮/
ちゅうかまんじゅう /中華饅頭/
ちゅうかみんこく /中華民国/
ちゅうかりょうり /中華料理/
ちゅうかん /中間/昼間/
ちゅうかんけん /中間圏/
ちゅうかんし /中間子/
ちゅうかんしせつ /中間施設/
ちゅうかんしょく /中間色/
ちゅうかんしんこく /中間申告/
ちゅうかんじんこう /昼間人口/
ちゅうかんそう /中間層/
ちゅうかんはいとう /中間配当/
ちゅうかんはんけつ /中間判決/
ちゅうかんほうこく /中間報告/
ちゅうがい /虫害/中外/
ちゅうがえり /宙返り/
ちゅうがく /中学/
ちゅうがた /中型/中形/
ちゅうがっこう /中学校/
ちゅうき /中期/注記/中気/
ちゅうきこくさい /中期国債/
ちゅうきぼ /中規模/
ちゅうきぼうず /中規模渦/
ちゅうきゅう /中級/誅求/
ちゅうきょう /中京/中共/
ちゅうきょり /中距離/
ちゅうきん /忠勤/鋳金/
ちゅうきんとう /中近東/
ちゅうぎ /忠義/
ちゅうぎがお /忠義顔/
ちゅうぎだて /忠義立て/
ちゅうくう /中空/
ちゅうくん /忠君/
ちゅうぐう /中宮/
ちゅうけい /中継/中啓/仲兄/
ちゅうけいきょく /中継局/
ちゅうけん /中堅/忠犬/
ちゅうげん /中元/忠言/中原/
ちゅうこ /中古/
ちゅうこう /中興/忠孝/中耕/鋳鋼/
ちゅうこうしょく /昼光色/
ちゅうこうねん /中高年/
ちゅうこく /忠告/
ちゅうごく /中国/
ちゅうごくぎんこう /中国銀行/
ちゅうごくご /中国語/
ちゅうごくさんち /中国山地/
ちゅうごくちほう /中国地方/
ちゅうごくぶんがく /中国文学/
ちゅうごくりょうり /中国料理/
ちゅうごし /中腰/
ちゅうさ /中佐/
ちゅうさい /仲裁/
ちゅうさいけいやく /仲裁契約/
ちゅうさいはんだん /仲裁判断/
ちゅうさつ /駐箚/誅殺/
ちゅうさん /昼餐/中産/
ちゅうざ /中座/
ちゅうざい /駐在/
ちゅうざいしょ /駐在所/
ちゅうざん /中山/
ちゅうし /中止/注視/忠士/
ちゅうしこく /中四国/
ちゅうしはん /中止犯/
ちゅうしみすい /中止未遂/
ちゅうしゃ /駐車/注射/
ちゅうしゃき /注射器/
ちゅうしゃく /註釈/注釈/
ちゅうしゃじょう /駐車場/
ちゅうしゅう /中秋/仲秋/
ちゅうしゅこつ /中手骨/
ちゅうしゅつ /抽出/
ちゅうしょう /抽象/中傷/中称/
ちゅうしょうか /抽象化/
ちゅうしょうきぎょう /中小企業/
ちゅうしょうぎ /中将棋/
ちゅうしょうてき /抽象的/
ちゅうしょうめいし /抽象名詞/
ちゅうしょうろん /抽象論/
ちゅうしょく /昼食/
ちゅうしょくかい /昼食会/
ちゅうしん /中心/衷心/忠臣/中震/注進/忠心/
ちゅうしんかく /中心角/
ちゅうしんぐら /忠臣蔵/
ちゅうしんじんぶつ /中心人物/
ちゅうしんちゅう /中心柱/
ちゅうしんてん /中心点/
ちゅうじ /中耳/
ちゅうじえん /中耳炎/
ちゅうじく /中軸/
ちゅうじつ /忠実/
ちゅうじゅん /中旬/
ちゅうじょ /忠恕/
ちゅうじょう /中将/衷情/柱状/
ちゅうすい /注水/虫垂/
ちゅうすいえん /虫垂炎/
ちゅうすう /中枢/
ちゅうせい /中世/中性/忠誠/中正/
ちゅうせいし /中性子/中性紙/
ちゅうせいしせい /中性子星/
ちゅうせいせんざい /中性洗剤/
ちゅうせいだい /中生代/
ちゅうせいびし /中性微子/
ちゅうせき /沖積/柱石/
ちゅうせきせい /沖積世/
ちゅうせきそう /沖積層/
ちゅうせきど /沖積土/
ちゅうせつ /忠節/
ちゅうせん /抽選/抽籤/
ちゅうせんきょく /中選挙区/
ちゅうぜい /中背/
ちゅうぜつ /中絶/
ちゅうぜんじ /中禅寺/
ちゅうぜんじこ /中禅寺湖/
ちゅうそ /註疏/
ちゅうそつ /中卒/
ちゅうそん /中尊/
ちゅうそんじ /中尊寺/
ちゅうぞう /鋳造/
ちゅうたい /中退/中隊/柱体/紐帯/
ちゅうだい /中台/
ちゅうだん /中断/中段/
ちゅうちょ /躊躇/
ちゅうちょう /注腸/
ちゅうっぱら /中っ腹/
ちゅうづり /宙吊り/
ちゅうてつ /鋳鉄/
ちゅうてん /中点/中天/
ちゅうと /中途/
ちゅうとう /中東/中等/仲冬/柱頭/
ちゅうとうせんそう /中東戦争/
ちゅうとはんぱ /中途半端/
ちゅうとん /駐屯/
ちゅうどう /中道/
ちゅうどく /中毒/
ちゅうなごん /中納言/
ちゅうなんべい /中南米/
ちゅうにかい /中二階/
ちゅうにち /中日/
ちゅうにちしんぶん /中日新聞/
ちゅうにゅう /注入/
ちゅうねん /中年/
ちゅうのう /中脳/
ちゅうのり /宙乗り/
ちゅうは /中波/中破/
ちゅうはいよう /中胚葉/
ちゅうはば /中幅/
ちゅうばいか /虫媒花/
ちゅうばつ /誅伐/
ちゅうばん /中盤/中判/
ちゅうび /中火/
ちゅうふく /中腹/
ちゅうぶ /中部/
ちゅうぶう /中風/
ちゅうぶちほう /中部地方/
ちゅうぶる /中古/
ちゅうぶん /籀文/
ちゅうへい /駐兵/
ちゅうへいけん /駐兵権/
ちゅうへん /中辺/中篇/中編/
ちゅうべい /中米/
ちゅうほん /中本/
ちゅうぼう /厨房/
ちゅうぼく /忠僕/
ちゅうま /中馬/
ちゅうみつ /稠密/
ちゅうめん /柱面/
ちゅうもく /注目/
ちゅうもん /注文/中門/
ちゅうもんせいさん /注文生産/
ちゅうや /昼夜/
ちゅうやけんこう /昼夜兼行/
ちゅうゆ /注油/
ちゅうゆう /忠勇/
ちゅうよう /中庸/中葉/
ちゅうようとっき /虫様突起/
ちゅうりつ /中立/
ちゅうりつこく /中立国/
ちゅうりゃく /中略/
ちゅうりゅう /中流/駐留/
ちゅうりんじょう /駐輪場/
ちゅうろう /中老/柱廊/
ちゅうろうい /中労委/
ちゅうろく /中肋/
ちゅうわ /中和/
ちゆ /治癒/
ちゆう /知友/知勇/
ちょ /貯/著/緒/儲/苧/瀦/樗/猪/
ちょう /長/超/弔/重/帳/調/張/鳥/頂/跳/諜/蝶/腸/脹/聴/眺/町/牒/潮/朝/暢/挑/懲/徴/彫/庁/帖/寵/兆/丁/澄/嘲/釣/趙/貼/疔/挺/肇/喋/凋/
ちょう> /超/
ちょうあい /寵愛/丁合/帳合/
ちょうあく /懲悪/
ちょうあん /長安/
ちょうい /弔意/弔慰/潮位/
ちょういん /調印/
ちょううんぼう /朝雲暮雨/
ちょうえき /懲役/
ちょうえつ /超越/
ちょうえつすう /超越数/
ちょうえん /腸炎/長円/
ちょうおん /長音/調音/聴音/
ちょうおんかい /長音階/
ちょうおんき /聴音機/
ちょうおんそく /超音速/
ちょうおんてん /調音点/
ちょうおんぱ /超音波/
ちょうか /超過/釣果/長靴/長歌/弔歌/町家/
ちょうかい /懲戒/鳥海/朝会/潮解/町会/
ちょうかいけん /懲戒権/
ちょうかいさん /鳥海山/
ちょうかいしょぶん /懲戒処分/
ちょうかいぼへん /朝改暮変/
ちょうかく /聴覚/弔客/頂角/
ちょうかくき /聴覚器/
ちょうかじゅよう /超過需要/
ちょうかほけん /超過保険/
ちょうかりじゅん /超過利潤/
ちょうかん /長官/朝刊/聴感/鳥瞰/腸管/
ちょうかんすう /超関数/
ちょうかんず /鳥瞰図/
ちょうかんまく /腸間膜/
ちょうが /頂芽/
ちょうがくりょう /張学良/
ちょうき /長期/寵姫/弔旗/
ちょうきこくさい /長期国債/
ちょうきしきん /長期資金/
ちょうきせん /長期戦/
ちょうきゃく /弔客/
ちょうきゅう /長久/
ちょうきょ /聴許/
ちょうきょう /調教/長享/
ちょうきょり /長距離/
ちょうきょりでんわ /長距離電話/
ちょうきよほう /長期予報/
ちょうきん /超勤/彫金/
ちょうぎ /町議/張儀/朝議/
ちょうぎかい /町議会/
ちょうぎゃく /嘲謔/
ちょうく /長駆/長句/長躯/
ちょうけい /長兄/長径/
ちょうけいこつ /蝶形骨/
ちょうけし /帳消し/
ちょうけつ /長欠/
ちょうけん /長剣/朝権/朝憲/
ちょうげん /調弦/
ちょうこう /徴候/聴講/長考/兆候/長江/釣鉤/長講/朝貢/潮紅/
ちょうこうせい /聴講生/
ちょうこうぜつ /長広舌/
ちょうこうそう /超高層/
ちょうこく /彫刻/超克/
ちょうこくとう /彫刻刀/
ちょうこっかしゅぎ /超国家主義/
ちょうこつ /腸骨/
ちょうこん /長恨/
ちょうこんか /長恨歌/
ちょうごう /調合/調号/
ちょうごうきん /超合金/
ちょうさ /調査/潮差/長沙/
ちょうさん /逃散/
ちょうさんぼし /朝三暮四/
ちょうさんりし /張三李四/
ちょうざ /長座/
ちょうざい /調剤/聴罪/
ちょうし /調子/銚子/長子/聴視/弔詞/弔詩/長姉/
ちょうしぜん /超自然/
ちょうしはずれ /調子外れ/
ちょうしぶえ /調子笛/
ちょうしもの /調子者/
ちょうしゃ /庁舎/
ちょうしゅ /聴取/
ちょうしゅう /徴収/聴衆/長州/徴集/
ちょうしゅしゃ /聴取者/
ちょうしゅん /長春/
ちょうしょ /調書/長所/
ちょうしょう /嘲笑/弔鐘/長嘯/徴証/
ちょうしょく /朝食/調色/
ちょうしん /長身/聴診/長針/寵臣/朝臣/調進/
ちょうしんき /聴診器/
ちょうしんけい /聴神経/
ちょうしんせい /超新星/
ちょうしんりがく /超心理学/
ちょうしんるこつ /彫心鏤骨/
ちょうじ /長治/弔辞/寵児/
ちょうじいろ /丁子色/
ちょうじかん /長時間/
ちょうじく /長軸/
ちょうじちゃ /丁子茶/
ちょうじつ /長日/
ちょうじゃ /長者/
ちょうじゅ /長寿/
ちょうじゅう /鳥獣/聴従/
ちょうじゅうぎが /鳥獣戯画/
ちょうじゅうろう /長十郎/
ちょうじょ /長女/
ちょうじょう /長上/頂上/重畳/長城/
ちょうじり /帳尻/
ちょうじろう /長次郎/
ちょうじん /超人/鳥人/釣人/
ちょうじんてき /超人的/
ちょうすいろ /長水路/
ちょうず /手水/
ちょうずばち /手水鉢/
ちょうせい /調整/調性/長生/調製/長征/町政/頂生/町制/長逝/
ちょうせいき /調整器/
ちょうせき /長石/潮汐/
ちょうせつ /調節/
ちょうせついでんし /調節遺伝子/
ちょうせん /挑戦/朝鮮/
ちょうせんあめ /朝鮮飴/
ちょうせんご /朝鮮語/
ちょうせんせんそう /朝鮮戦争/
ちょうせんにんじん /朝鮮人参/
ちょうせんぼん /朝鮮本/
ちょうぜい /徴税/町税/
ちょうぜつ /超絶/
ちょうぜん /超然/
ちょうそ /彫塑/
ちょうそう /鳥葬/
ちょうそかべ /長宗我部/
ちょうそく /長足/
ちょうそん /町村/
ちょうそんせい /町村制/
ちょうそんそうかい /町村総会/
ちょうそんちょう /町村長/
ちょうそんやくば /町村役場/
ちょうぞう /彫像/
ちょうぞく /超俗/
ちょうたく /彫琢/
ちょうたつ /調達/暢達/
ちょうたん /長短/
ちょうたんぱ /超短波/
ちょうだ /長蛇/長打/
ちょうだい /長大/頂戴/
ちょうだつ /超脱/
ちょうちゃく /打擲/
ちょうちょう /長調/町長/蝶々/蝶蝶/喋々/
ちょうちん /提灯/
ちょうつがい /蝶番/
ちょうづけ /丁付/
ちょうづめ /腸詰/
ちょうづら /帳面/
ちょうてい /調停/朝廷/調定/長堤/
ちょうていきょくほ /長汀曲浦/
ちょうてき /朝敵/
ちょうてん /頂点/長点/
ちょうでん /弔電/
ちょうでんどう /超伝導/
ちょうと /長途/
ちょうとう /長刀/
ちょうとうは /超党派/
ちょうとく /長徳/
ちょうとっきゅう /超特急/
ちょうど /丁度/調度/
ちょうどきゅう /超弩級/
ちょうな /手斧/
ちょうない /町内/
ちょうないかい /町内会/
ちょうなめ /手斧目/
ちょうなん /長男/
ちょうにん /町人/
ちょうねんてん /腸捻転/
ちょうのうりょく /超能力/
ちょうは /長波/
ちょうはつ /長髪/挑発/徴発/挑撥/調髪/
ちょうはつてき /挑発的/
ちょうはん /丁半/
ちょうば /帳場/嘲罵/
ちょうばいか /鳥媒花/
ちょうばつ /懲罰/
ちょうひょう /徴憑/帳票/
ちょうび /掉尾/
ちょうびるい /長鼻類/
ちょうふ /調布/貼付/
ちょうふく /重複/
ちょうぶ /町歩/
ちょうぶく /調伏/
ちょうぶつ /長物/
ちょうぶん /長文/弔文/
ちょうへい /徴兵/
ちょうへいせい /徴兵制/
ちょうへいそく /腸閉塞/
ちょうへき /腸壁/
ちょうへん /長編/長篇/
ちょうほう /重宝/諜報/弔砲/調法/
ちょうほうけい /長方形/
ちょうほんにん /張本人/
ちょうぼ /帳簿/徴募/
ちょうぼう /眺望/
ちょうみ /調味/
ちょうみつ /稠密/
ちょうみりょう /調味料/
ちょうみん /町民/兆民/
ちょうむ /庁務/
ちょうむすび /蝶結び/
ちょうめ /丁目/
ちょうめい /長命/澄明/長明/朝命/町名/
ちょうめん /帳面/
ちょうめんづら /帳面面/
ちょうもく /鳥目/
ちょうもくひじ /長目飛耳/
ちょうもと /帳元/
ちょうもん /弔問/聴聞/
ちょうや /長夜/
ちょうやく /跳躍/重訳/調薬/
ちょうよう /徴用/重陽/重用/朝陽/長幼/
ちょうらい /朝来/
ちょうらく /凋落/長楽/
ちょうらくじ /長楽寺/
ちょうり /調理/
ちょうりし /調理師/
ちょうりつ /調律/町立/
ちょうりゃく /調略/
ちょうりゅう /潮流/
ちょうりゅうどう /超流動/
ちょうりょう /跳梁/
ちょうりょく /張力/聴力/
ちょうるい /鳥類/
ちょうれい /朝礼/
ちょうれいぼかい /朝令暮改/
ちょうれん /調練/
ちょうろ /朝露/
ちょうろう /長老/嘲弄/
ちょうわ /調和/
ちょうわしんどうし /調和振動子/
ちょうわへいきん /調和平均/
ちょきん /貯金/
ちょきんきょく /貯金局/
ちょく /直/勅/猪口/捗/
ちょくえい /直営/
ちょくおう /直往/
ちょくおうまいしん /直往邁進/
ちょくおん /直音/
ちょくがん /勅願/
ちょくげき /直撃/
ちょくげん /直言/
ちょくご /直後/勅語/
ちょくさ /直鎖/
ちょくさい /直截/直裁/勅裁/
ちょくし /直視/勅使/勅旨/
ちょくしゃ /直射/直写/
ちょくしょ /勅書/
ちょくしょう /勅詔/
ちょくしん /直進/
ちょくじょう /直上/直情/
ちょくせき /直積/
ちょくせつ /直接/直截/
ちょくせつしょうこ /直接証拠/
ちょくせつせんきょ /直接選挙/
ちょくせつぜい /直接税/
ちょくせつてき /直接的/
ちょくせつとうし /直接投資/
ちょくせつひ /直接費/
ちょくせつほう /直接法/直説法/
ちょくせん /直線/勅撰/
ちょくせんきょり /直線距離/
ちょくせんしゅう /勅撰集/
ちょくせんび /直線美/
ちょくせんへんこう /直線偏光/
ちょくぜん /直前/
ちょくそう /直送/
ちょくぞく /直属/
ちょくだい /勅題/
ちょくちょう /直腸/
ちょくつう /直通/
ちょくとう /直答/勅答/直刀/
ちょくどく /直読/
ちょくにん /勅任/
ちょくにんかん /勅任官/
ちょくはい /直配/
ちょくはん /直販/勅版/
ちょくばい /直売/
ちょくひつ /直筆/
ちょくほうたい /直方体/
ちょくめい /勅命/
ちょくめん /直面/
ちょくやく /直訳/
ちょくやくてき /直訳的/
ちょくゆ /直喩/勅諭/
ちょくゆしゅつ /直輸出/
ちょくゆにゅう /直輸入/
ちょくりつ /直立/
ちょくりつけい /直立茎/
ちょくりつふどう /直立不動/
ちょくりゅう /直流/
ちょくれい /勅令/直隷/
ちょくれつ /直列/
ちょくれつせつぞく /直列接続/
ちょくろ /直路/
ちょげん /緒言/
ちょこ /猪口/
ちょこざい /猪口才/
ちょさく /著作/
ちょさくか /著作家/
ちょさくけん /著作権/
ちょさくけんほう /著作権法/
ちょさくしゃ /著作者/
ちょさくぶつ /著作物/
ちょし /楮紙/
ちょしゃ /著者/
ちょしょ /著書/
ちょじゅつ /著述/
ちょじゅつか /著述家/
ちょすい /貯水/
ちょすいそしき /貯水組織/
ちょすいち /貯水池/
ちょせん /緒戦/
ちょぞう /貯蔵/著増/
ちょぞうこん /貯蔵根/
ちょぞうそしき /貯蔵組織/
ちょだい /著大/
ちょちく /貯蓄/
ちょちくせいこう /貯蓄性向/
ちょちくほけん /貯蓄保険/
ちょっか /直下/
ちょっかく /直覚/直角/
ちょっかくざひょう /直角座標/
ちょっかっこう /直滑降/
ちょっかつ /直轄/
ちょっかん /直観/直感/
ちょっかんしゅぎ /直観主義/
ちょっかんてき /直観的/
ちょっかんひりつ /直間比率/
ちょっきゅう /直球/
ちょっきょ /勅許/
ちょっけい /直径/直系/
ちょっけいいんぞく /直系姻族/
ちょっけいけつぞく /直系血族/
ちょっけいそんぞく /直系尊属/
ちょっけいひぞく /直系卑属/
ちょっけつ /直結/
ちょっこう /直交/直行/直航/
ちょっこうざひょう /直交座標/
ちょっと /一寸/
ちょとつ /猪突/
ちょとつもうしん /猪突猛進/
ちょびひげ /ちょび髭/
ちょぶん /著聞/
ちょぼく /貯木/
ちょめい /著名/著明/
ちょりつ /佇立/
ちょりゅう /貯留/
ちょろく /著録/
ちょろん /緒論/
ちょんまげ /丁髷/
ちよ /千代/
ちよがみ /千代紙/
ちよだ /千代田/
ちよろず /千万/
ちらく /地絡/
ちらしがき /散らし書き/
ちらん /治乱/
ちり /地理/塵/智利/
ちりあくた /塵芥/
ちりがく /地理学/
ちりがみ /塵紙/
ちりとり /塵取/
ちりなべ /ちり鍋/
ちりめん /縮緬/
ちりめんえ /縮緬絵/
ちりゃく /知略/智略/治略/
ちりゅう /知立/
ちりょう /治療/
ちりょく /知力/地力/
ちれい /地霊/
ちれき /地歴/
ちろうい /地労委/
ちわ /痴話/
ちわげんか /痴話喧嘩/
ちん /陳/鎮/賃/珍/沈/朕/狆/鴆/椿/
ちん> /珍/
ちんあげ /賃上げ/
ちんあつ /鎮圧/
ちんうつ /沈鬱/
ちんか /沈下/鎮火/
ちんがいざい /鎮咳剤/
ちんがし /賃貸し/
ちんがり /賃借り/
ちんき /珍奇/丁幾/
ちんきゃく /珍客/
ちんきん /沈金/
ちんぎょらくがん /沈魚落雁/
ちんぎん /賃金/
ちんぎんすいじゅん /賃金水準/
ちんぎんたいけい /賃金体系/
ちんげい /珍芸/
ちんこう /沈降/鎮江/
ちんこん /鎮魂/
ちんこんか /鎮魂歌/
ちんこんきしん /鎮魂帰神/
ちんご /鎮護/
ちんさげ /賃下げ/
ちんざ /鎮座/
ちんし /沈思/
ちんしゃ /陳謝/
ちんしゃく /賃借/
ちんしゃくけん /賃借権/
ちんしゃくにん /賃借人/
ちんしゅ /珍種/
ちんしょ /珍書/
ちんじ /珍事/椿事/
ちんじゅ /鎮守/
ちんじゅう /珍獣/
ちんじゅつ /陳述/
ちんじゅふ /鎮守府/
ちんじょう /陳情/陳状/
ちんすい /沈水/
ちんすいしょくぶつ /沈水植物/
ちんせい /鎮静/沈静/
ちんせいざい /鎮静剤/
ちんせき /枕席/沈積/珍籍/
ちんせつ /珍説/
ちんせん /沈潜/賃銭/
ちんぜい /鎮西/
ちんぞう /珍蔵/
ちんたい /賃貸/沈滞/
ちんたいしゃく /賃貸借/
ちんたいにん /賃貸人/
ちんたお /青島/
ちんだい /鎮台/
ちんだん /珍談/
ちんちゃく /沈着/
ちんちょう /珍重/
ちんちょうげ /沈丁花/
ちんつう /鎮痛/沈痛/
ちんつうざい /鎮痛剤/
ちんてい /鎮定/
ちんでき /沈溺/
ちんでん /沈殿/沈澱/
ちんとう /枕頭/珍答/
ちんとうびょう /沈頭鋲/
ちんにゅう /闖入/
ちんば /跛/
ちんぱん /青幇/
ちんぴ /陳皮/
ちんぴん /珍品/
ちんぶ /鎮撫/
ちんぶつ /珍物/
ちんぶん /珍聞/
ちんぷ /陳腐/
ちんべん /陳弁/
ちんぺい /陳平/
ちんぼつ /沈没/
ちんぽう /珍宝/
ちんぽん /珍本/
ちんみ /珍味/
ちんみょう /珍妙/
ちんむるい /珍無類/
ちんめん /沈湎/
ちんもく /沈黙/
ちんもん /珍問/
ちんれつ /陳列/
ちんろうどう /賃労働/
つ /津/都/通/
つい /対/追/墜/終/鎚/槌/椎/
ついおく /追憶/
ついか /追加/
ついかい /追懐/
ついかはいとう /追加配当/
ついかん /追完/
ついかんばん /椎間板/
ついき /追記/
ついきそ /追起訴/
ついきゅう /追及/追求/追究/追給/椎弓/
ついく /対句/
ついげき /追撃/
ついこう /追行/追考/
ついこつ /椎骨/
ついご /対語/
ついごう /追号/
ついし /追試/墜死/
ついしけん /追試験/
ついしょう /追従/
ついしん /追伸/
ついじ /築地/
ついじゅう /追従/
ついじゅく /追熟/
ついずい /追随/
ついせき /追跡/
ついせきちょうさ /追跡調査/
ついぜん /追善/
ついぜんくよう /追善供養/
ついそ /追訴/
ついそう /追想/追送/
ついぞう /追贈/
ついたい /椎体/
ついたいけん /追体験/
ついたち /一日/朔日/
ついたて /衝立/
ついだつ /追奪/
ついちょう /追徴/
ついで /序で/次いで/尋いで/
ついとう /追悼/追討/
ついとつ /追突/
ついに /終に/遂に/
ついにん /追認/
ついのう /追納/
ついひ /追肥/
ついび /追尾/
ついほ /追補/追捕/
ついほう /追放/
ついぼ /追慕/
ついらく /墜落/
ついろく /追録/
つう /通/痛/
つういん /通院/痛飲/
つううん /通運/
つうえん /通園/
つうか /通過/通貨/
つうかい /痛快/通解/
つうかぎれい /通過儀礼/
つうかく /痛覚/
つうかん /痛感/通関/通巻/通観/
つうがく /通学/
つうき /通気/
つうきこう /通気孔/
つうきせい /通気性/
つうきそしき /通気組織/
つうきん /通勤/
つうきんけん /通勤圏/
つうぎょう /通暁/
つうく /痛苦/
つうけい /通計/
つうげき /痛撃/
つうげん /痛言/
つうこう /通行/通交/通好/通航/
つうこうぜい /通行税/
つうこうぼん /通行本/
つうこく /通告/痛哭/
つうこくしょぶん /通告処分/
つうこん /痛恨/
つうごう /通号/
つうさん /通算/
つうし /通史/
つうしき /通式/
つうしゃく /通釈/
つうしょう /通称/通商/
つうしん /通信/痛心/
つうしんいん /通信員/
つうしんえいせい /通信衛星/
つうしんきかん /通信機関/
つうしんきょういく /通信教育/
つうしんしゃ /通信社/
つうしんはんばい /通信販売/
つうしんぼ /通信簿/
つうしんもう /通信網/
つうじ /通詞/
つうじょう /通常/
つうじょうこっかい /通常国会/
つうじょうそうかい /通常総会/
つうじょうたいほ /通常逮捕/
つうじょうへいき /通常兵器/
つうじん /通人/
つうせい /通性/
つうせき /痛惜/
つうせつ /通説/痛切/
つうそうていおん /通奏低音/
つうそく /通則/
つうぞく /通俗/
つうぞくてき /通俗的/
つうたつ /通達/
つうち /通知/
つうちひょう /通知表/
つうちょう /通帳/通牒/
つうてい /通底/
つうてん /痛点/
つうてんかく /通天閣/
つうでん /通電/
つうどう /通洞/
つうどうそしき /通導組織/
つうどく /通読/
つうねん /通年/通念/
つうはん /通販/
つうば /痛罵/
つうふう /通風/痛風/
つうふうき /通風機/
つうふん /痛憤/
つうぶん /通分/
つうへい /通弊/
つうほう /通報/通宝/
つうぼう /通謀/
つうや /通夜/
つうやく /通訳/通約/
つうゆう /通有/
つうゆうせい /通有性/
つうよう /通用/痛痒/
つうようきかん /通用期間/
つうようぐち /通用口/
つうようもん /通用門/
つうらん /通覧/
つうりき /通力/
つうれい /通例/
つうれつ /痛烈/
つうろ /通路/
つうろん /通論/痛論/
つうわ /通話/
つえ /杖/
つか /塚/束/冢/柄/
つかあな /塚穴/
つかい /使い/遣い/
つかいかた /使い方/
つかいがって /使い勝手/
つかいし /束石/
つかいすて /使い捨て/
つかいばしり /使い走り/
つかいみち /使い道/
つかいもの /使い物/遣い物/
つかいわけ /使い分け/
つかえ /仕え/
つかがしら /柄頭/
つかさ /司/
つかのま /束の間/
つかはら /塚原/
つかみ /掴み/
つかみほん /束見本/
つかれ /疲れ/
つが /栂/都賀/
つがい /番/
つがる /津軽/
つがるかいきょう /津軽海峡/
つがるじゃみせん /津軽三味線/
つがるはんとう /津軽半島/
つき /月/槻/付き/突き/尽き/付/
つきあかり /月明り/
つきあわせ /突合せ/
つきいち /月一/
つきおか /月岡/
つきかげ /月影/
つきがけ /月掛け/
つきがた /月形/
つきがわり /月代り/
つききず /突き傷/
つきぎめ /月極め/
つきぎょうじ /月行事/
つきぎり /月切り/
つきごし /月越し/
つきごと /月毎/
つきごろ /月頃/
つきしま /月島/
つきじ /築地/
つきずえ /月末/
つきそい /付添い/
つきたらず /月足らず/
つきづき /月々/
つきなみ /月並/月次/
つきのさわり /月の障り/
つきのもの /月の物/
つきのわ /月の輪/
つきはじめ /月初め/
つきばらい /月払い/
つきばん /月番/
つきひ /月日/
つきびと /付人/
つきへん /月偏/
つきまいり /月参り/
つきみ /月見/
つきみそう /月見草/
つきめ /尽き目/
つきもの /付き物/
つきやく /月役/
つきやま /築山/
つきゆび /突き指/
つきよ /月夜/
つきわり /月割/
つぎ /次/
つぎがみ /継紙/
つぎき /継木/接木/
つぎしきし /継色紙/
つぎつぎ /次々/
つぎのま /次の間/
つぎはぎ /継ぎ接ぎ/
つぎほ /接ぎ穂/
つぎめ /継目/
つぎもの /継ぎ物/
つくえ /机/
つくし /筑紫/土筆/
つくだ /佃/
つくだじま /佃島/
つくだに /佃煮/
つくづく /熟/
つくば /筑波/
つくばさん /筑波山/
つくばだいがく /筑波大学/
つくばね /筑波嶺/
つくみ /津久見/
つくも /九十九/
つくもがみ /九十九髪/
つくり /作り/
つくりかえ /作り替え/
つくりかた /作り方/
つくりごえ /作り声/
つくりごと /作り事/
つくりざかや /造酒屋/
つくりつけ /作り付け/
つくりて /作り手/
つくりばなし /作り話/
つくりもの /作り物/
つくりわらい /作り笑い/
つぐみ /鶫/
つけおち /付け落ち/
つけかた /付け方/
つけぐすり /付け薬/
つけこみちょう /付込帳/
つけとどけ /付け届け/
つけね /付け根/付け値/
つけひげ /付け髭/
つけび /付け火/
つけびと /付け人/
つけぶみ /付け文/
つけもの /漬物/
つけやき /付け焼き/
つけやきば /付焼刃/
つげ /告げ/柘植/柘/
つげぐち /告げ口/
つごう /都合/
つごもり /晦/
つざき /津崎/
つし /津市/
つしま /津島/対馬/
つしまかいきょう /対馬海峡/
つじ /辻/
つじうら /辻占/
つじぎみ /辻君/
つじぐるま /辻車/
つじせっぽう /辻説法/
つじつま /辻褄/
つじどう /辻堂/
つじばしゃ /辻馬車/
つた /蔦/
つたえ /伝え/
つたない /拙い/
つたや /蔦屋/
つだ /津田/
つだじゅくだいがく /津田塾大学/
つち /土/槌/椎/
つちい /土井/土居/
つちいじり /土弄り/
つちいろ /土色/
つちうら /土浦/
つちおと /槌音/
つちかべ /土壁/
つちくれ /土塊/
つちけいろ /土気色/
つちけむり /土煙/
つちざき /土崎/
つちだ /土田/
つちつかず /土付かず/
つちのえ /戊/
つちのと /己/
つちばし /土橋/
つちふまず /土踏まず/
つちへん /土偏/
つちぼこり /土埃/
つちみかど /土御門/
つちむろ /土室/
つちもち /土持/
つちや /土屋/
つちやま /土山/
つちよせ /土寄せ/
つっけんどん /突慳貪/
つっこみ /突っ込み/
つつ /筒/砲/
つつい /筒井/
つつうらうら /津々浦々/津津浦浦/
つつおと /筒音/
つつが /恙/
つつがむし /恙虫/
つつぐち /筒口/
つつさき /筒先/
つつしんで /謹んで/
つつじ /躑躅/
つつぬけ /筒抜け/
つつみ /堤/包み/恙/
つつみがまえ /包構え/
つつみがみ /包み紙/
つつみびょうし /包表紙/
つつもたせ /美人局/
つづき /続き/
つづきがら /続柄/
つづきもの /続き物/
つづく /続く/
つづけ /続け/
つづみ /鼓/
つづら /葛/
つづらおり /葛折/
つづりかた /綴方/
つづれ /綴れ/
つて /伝/
つとに /夙に/
つとめ /勤め/
つとめぐち /勤め口/
つとめさき /勤め先/
つとめて /努めて/
つとめにん /勤め人/
つど /都度/
つどい /集い/集/
つな /綱/
つなぎめ /繋ぎ目/
つなしま /綱島/
つなみ /津波/
つなわたり /綱渡り/
つね /常/
つねづね /常々/
つねとう /恒藤/
つねなみ /常並/
つねに /常に/
つねひごろ /常日頃/
つの /角/
つのかくし /角隠し/
つのがき /角書/
つのがら /角柄/
つのぎ /角木/
つのごけるい /角苔類/
つのぶえ /角笛/
つのへん /角偏/
つば /鍔/唾/鐔/
つばき /椿/
つばきひめ /椿姫/
つばくらめ /燕/
つばくろ /燕/
つばさ /翼/
つばぜりあい /鍔迫り合い/
つばめ /燕/
つばめがえし /燕返し/
つばもと /鍔元/
つぶ /粒/
つぶあん /粒餡/
つぶぎん /粒銀/
つぶさに /具に/備に/悉に/
つぶじょう /粒状/
つぶぞろい /粒揃い/
つぶて /礫/
つぶやき /呟き/
つぶより /粒選り/
つぶれ /潰れ/
つぼ /坪/壺/壷/
つぼあたり /坪当り/
つぼい /坪井/壺井/
つぼうち /坪内/
つぼかわ /坪川/
つぼた /坪田/
つぼにわ /坪庭/
つぼね /局/
つぼみ /蕾/莟/
つぼや /壺屋/
つま /妻/褄/嬬/
つまおと /爪音/
つまご /妻籠/
つまごい /嬬恋/
つまさき /爪先/
つまど /妻戸/
つまどり /褄取り/
つまはじき /爪弾き/
つまびき /爪弾き/
つまびらか /詳らか/審らか/
つまみぐい /撮み食い/
つまようじ /爪楊枝/
つみ /罪/詰み/
つみいれ /摘入れ/
つみおろし /積み卸し/
つみかえ /積み替え/
つみき /積木/
つみきん /積金/
つみくさ /摘み草/
つみたて /積立て/
つみたてきん /積立金/
つみつくり /罪作り/
つみとが /罪科/
つみに /積荷/
つみにほけん /積荷保険/
つみびと /罪人/
つみほろぼし /罪滅ぼし/
つむ /錘/舶/紡錘/
つむぎ /紬/
つむぎいと /紬糸/
つむじ /旋毛/
つむじかぜ /旋風/
つむり /頭/
つめ /爪/詰め/詰/
つめあと /爪痕/
つめあわせ /詰合せ/
つめいん /爪印/
つめえり /詰襟/
つめかえ /詰め替え/
つめご /詰碁/
つめしょ /詰所/
つめしょうぎ /詰将棋/
つめた /冷た/
つめばら /詰腹/
つめもの /詰物/
つもり /津守/
つや /通夜/艶/
つやけし /艶消し/
つやごと /艶事/
つやぶみ /艶文/
つやま /津山/
つやもの /艶物/
つゆ /露/梅雨/
つゆくさ /露草/
つゆくさいろ /露草色/
つゆじも /露霜/
つゆぞら /梅雨空/
つゆどき /梅雨時/
つゆはらい /露払い/
つゆほど /露程/
つよき /強気/
つよごし /強腰/
つよび /強火/
つよみ /強み/
つら /面/
つらあて /面当て/
つらがまえ /面構え/
つらだし /面出し/
つらだましい /面魂/
つらなり /連なり/
つらよごし /面汚し/
つり /釣/吊/
つりあい /釣合/
つりいと /釣糸/
つりかわ /吊革/
つりがき /釣書/
つりがね /釣鐘/
つりがねそう /釣鐘草/
つりぐ /釣具/
つりざお /釣竿/
つりし /釣師/
つりせん /釣銭/
つりて /釣手/
つりどの /釣殿/
つりばし /吊橋/
つりばり /釣針/
つりぼり /釣堀/
つりもと /釣元/
つる /鶴/弦/蔓/都留/絃/
つるい /釣井/
つるおか /鶴岡/
つるかめ /鶴亀/
つるかめざん /鶴亀算/
つるが /敦賀/鶴賀/
つるがおか /鶴岡/
つるぎ /剣/
つるくさ /蔓草/
つるさき /鶴崎/
つるしあげ /吊し上げ/
つるはぎ /鶴脛/
つるはし /鶴嘴/
つるばみ /橡/
つるべ /釣瓶/
つるべおとし /釣瓶落し/
つるまき /弦巻/
つるみ /鶴見/
つるや /鶴屋/
つれ /連れ/
つれこ /連れ子/
つれづれ /徒然/
つれづれぐさ /徒然草/
つわの /津和野/
つわもの /兵/
つんどく /積ん読/
つんぼ /聾/
つんぼさじき /聾桟敷/
づき /付/
づけ /付/
づめ /詰め/詰/
づれ /連れ/
て /手/
てあい /手合/
てあか /手垢/
てあし /手足/
てあしくちびょう /手足口病/
てあそび /手遊び/
てあたり /手当り/
てあて /手当/
てあぶり /手焙り/
てあみ /手編み/
てあら /手荒/
てあらい /手洗い/
てあわせ /手合せ/
てい /定/程/鼎/鄭/邸/逓/諦/訂/艇/締/提/挺/抵/悌/弟/廷/庭/底/帝/堤/呈/貞/偵/停/低/亭/体/丁/第/釘/蹄/禎/碇/汀/梯/剃/
てい> /低/
ていあつ /低圧/定圧/
ていあん /提案/
ていあんけん /提案権/
ていい /定位/低位/帝位/
ていいかぶ /低位株/
ていいん /定員/
ていえん /庭園/
ていおう /帝王/
ていおうせっかい /帝王切開/
ていおん /低温/低音/定温/
ていおんどうぶつ /定温動物/
ていか /定価/低下/定家/低価/
ていかい /低徊/停会/
ていかいはつこく /低開発国/
ていかく /底角/
ていかん /定款/諦観/停刊/
ていかんし /定冠詞/
ていが /定芽/
ていがく /停学/定額/低額/
ていがくほう /定額法/
ていき /提起/定期/定気/
ていきあつ /低気圧/
ていきかんこうぶつ /定期刊行物/
ていききんさいけん /定期金債権/
ていきけん /定期券/
ていきしけん /定期試験/
ていきしょうきゅう /定期昇給/
ていきせん /定期船/
ていきつみきん /定期積金/
ていきてき /定期的/
ていきとりひき /定期取引/
ていきびん /定期便/
ていきゅう /低級/庭球/定休/
ていきゅうび /定休日/
ていきょう /提供/帝京/
ていきよきん /定期預金/
ていきん /提琴/
ていぎ /定義/提議/
ていぎいき /定義域/
ていくう /低空/
ていくうひこう /低空飛行/
ていけい /提携/定型/定形/梯形/
ていけいし /定型詩/
ていけつ /締結/貞潔/
ていけつあつ /低血圧/
ていけん /定見/
ていげん /提言/低減/定限/
ていこ /艇庫/
ていこう /抵抗/
ていこうき /抵抗器/
ていこうせい /抵抗性/
ていこうりょく /抵抗力/
ていこく /帝国/定刻/
ていこくぎかい /帝国議会/
ていこくげきじょう /帝国劇場/
ていこくしゅぎ /帝国主義/
ていさい /体裁/
ていさく /定朔/
ていさつ /偵察/
ていさつき /偵察機/
ていし /停止/底止/
ていしき /定式/
ていしじょうけん /停止条件/
ていしせい /低姿勢/
ていしつ /低湿/帝室/
ていしゃ /停車/
ていしゃじょう /停車場/
ていしゃば /停車場/
ていしゅ /亭主/艇首/
ていしゅう /鄭州/
ていしゅうにゅう /定収入/
ていしゅうは /低周波/
ていしゅかんぱく /亭主関白/
ていしゅく /貞淑/
ていしゅつ /提出/挺出/
ていしゅつよう /低出葉/
ていしょう /提唱/定昇/低唱/
ていしょく /抵触/定食/定職/停職/牴触/定植/
ていしん /挺身/逓信/挺進/廷臣/艇身/
ていしんしょう /逓信省/
ていじ /提示/定時/呈示/丁字/綴字/
ていじげん /低次元/
ていじせい /定時制/
ていじそうかい /定時総会/
ていじつ /定日/
ていじぶ /提示部/
ていじゅう /定住/
ていじょ /貞女/
ていじょう /定常/呈上/
ていじょうは /定常波/
ていじろ /丁字路/
ていすう /定数/
ていすうこう /定数項/
ていせい /訂正/定性/帝政/低声/
ていせいてき /定性的/
ていせいぶんせき /定性分析/
ていせきぶん /定積分/
ていせつ /定説/貞節/
ていせん /停戦/停船/
ていぜん /挺然/庭前/
ていそ /提訴/定礎/
ていそう /貞操/低層/逓送/
ていそうたい /貞操帯/
ていそく /定則/低速/
ていそくすう /定足数/
ていぞく /低俗/
ていたい /停滞/手痛い/
ていたく /邸宅/
ていたらく /為体/
ていだい /帝大/提題/
ていだん /鼎談/梯団/
ていち /低地/定置/
ていちあみ /定置網/
ていちゃく /定着/
ていちゃくえき /定着液/
ていちゃくぶつ /定着物/
ていちょう /低調/丁重/低潮/鄭重/
ていっぱい /手一杯/
ていてつ /蹄鉄/
ていてん /定点/
ていてんかんそく /定点観測/
ていでん /停電/
ていと /帝都/
ていとう /抵当/提灯/低頭/
ていとうがし /抵当貸/
ていとうけん /抵当権/
ていとうしょうけん /抵当証券/
ていとく /提督/
ていど /程度/
ていどもんだい /程度問題/
ていない /廷内/邸内/庭内/
ていねい /丁寧/
ていねいご /丁寧語/
ていねん /停年/定年/丁年/諦念/
ていねんせい /停年制/
ていのう /低能/
ていはく /停泊/碇泊/
ていはつ /剃髪/
ていばん /定番/
ていひょう /定評/
ていびょう /帝廟/
ていふ /貞婦/
ていぶ /底部/
ていへん /底辺/
ていほん /定本/底本/
ていぼう /堤防/
ていぼく /低木/
ていまい /弟妹/
ていめい /低迷/締盟/
ていめん /底面/
ていやく /締約/定訳/
ていよう /提要/
ていらく /低落/
ていり /定理/低利/廷吏/
ていりつ /定立/低率/定率/鼎立/定律/
ていりつぜい /定率税/
ていりつほう /定率法/
ていりゅう /停留/底流/
ていりゅうじょ /停留所/
ていりゅうじょう /停留場/
ていりょう /定量/
ていれ /手入れ/
ていれい /定例/
ていれつ /低劣/貞烈/
ていれん /低廉/
ていろん /定論/
てうえ /手植え/
てうす /手薄/
てうち /手打/
ておい /手負い/
ておくれ /手遅れ/
ておけ /手桶/
ておし /手押し/
ておち /手落ち/
ておの /手斧/
ており /手織/
てかがみ /手鏡/手鑑/
てかげん /手加減/
てかず /手数/
てがい /手飼/
てがかり /手掛り/
てがき /手書き/
てがた /手形/
てがたこうい /手形行為/
てがたさいけん /手形債権/
てがたな /手刀/
てがたひきうけ /手形引受/
てがたわりびき /手形割引/
てがぬま /手賀沼/
てがみ /手紙/
てがら /手柄/
てがらばなし /手柄話/
てがる /手軽/
てき /的/敵/適/笛/滴/摘/擲/狄/鏑/擢/
てきい /敵意/
てきえい /敵影/
てきおう /適応/
てきおうしょう /適応症/
てきおうせいぎょ /適応制御/
てきおうほうさん /適応放散/
てきおん /適温/
てきか /滴下/摘果/
てきかく /的確/適格/
てきかん /敵艦/
てきが /摘芽/
てきがいしん /敵愾心/
てきがた /敵方/
てきき /敵機/適期/
てきぎ /適宜/
てきぎょう /適業/
てきぐん /敵軍/
てきげん /適言/
てきこく /敵国/
てきごう /適合/
てきさい /適才/
てきさく /適作/
てきざい /適材/
てきざいてきしょ /適材適所/
てきし /敵視/
てきしゃ /適者/
てきしゃせいぞん /適者生存/
てきしゅ /敵手/
てきしゅう /敵襲/
てきしゅつ /摘出/剔出/
てきしょ /適所/
てきしょう /敵将/
てきしょく /適職/
てきしん /摘心/
てきじ /適時/
てきじだ /適時打/
てきじょ /摘除/滌除/
てきじょう /敵情/
てきじん /敵陣/
てきず /手傷/手創/手疵/
てきせい /適正/適性/敵性/
てきせいけんさ /適性検査/
てきせいてつづき /適正手続/
てきせつ /適切/
てきぜん /敵前/
てきたい /敵対/
てきだん /敵弾/
てきだんとう /擲弾筒/
てきち /適地/敵地/
てきちゅう /的中/適中/
てきちょく /躑躅/
てきてい /滴定/
てきとう /適当/
てきど /適度/
てきにん /適任/
てきはい /敵背/
てきはつ /摘発/
てきひ /適否/
てきひょう /適評/
てきふてき /適不適/
てきへい /敵兵/
てきほう /適法/
てきめん /覿面/
てきや /的屋/
てきやく /適役/敵役/適訳/適薬/
てきよう /適用/摘要/
てきりょう /適量/
てきるい /敵塁/
てきれい /適齢/適例/
てきれいき /適齢期/
てきろく /摘録/
てぎれ /手切れ/
てぎれきん /手切れ金/
てぎわ /手際/
てくせ /手癖/
てくだ /手管/
てくばり /手配り/
てくび /手首/
てくらがり /手暗がり/
てぐさり /手鎖/
てぐす /天蚕糸/
てぐち /手口/
てこ /梃/梃子/
てこいれ /梃入れ/
てこう /手甲/
てご /手児/
てごころ /手心/
てごたえ /手応え/
てごま /手駒/
てごろ /手頃/
てさき /手先/
てさぎょう /手作業/
てさぐり /手探り/
てさげ /手提げ/
てさばき /手捌き/
てざいく /手細工/
てざし /手差し/
てざわり /手触り/
てしお /手塩/天塩/
てしごと /手仕事/
てした /手下/
てしま /手島/
てしょく /手燭/手職/
てしんごう /手信号/
てじか /手近/
てじな /手品/
てじなし /手品師/
てじめ /手締め/
てじゃく /手酌/
てじゅん /手順/
てじょう /手錠/
てすう /手数/
てすうりょう /手数料/
てすき /手漉き/
てすじ /手筋/
てずか /手塚/
てずり /手刷/
てずれ /手擦れ/
てせい /手製/
てぜい /手勢/
てぜま /手狭/
てそう /手相/
てだい /手代/
てだし /手出し/
てだすけ /手助け/
てだて /手立て/
てだま /手玉/
てだれ /手練/
てちがい /手違い/
てちょう /手帳/
てぢか /手近/
てっか /鉄火/
てっかい /撤回/
てっかく /適格/的確/
てっかどんぶり /鉄火丼/
てっかば /鉄火場/
てっかまき /鉄火巻/
てっかん /鉄管/
てっき /鉄器/敵機/適期/鉄騎/摘記/
てっきょ /撤去/
てっきょう /鉄橋/
てっきん /鉄筋/鉄琴/
てっけつ /鉄血/
てっけん /鉄拳/鉄剣/
てっけんせいさい /鉄拳制裁/
てっこう /鉄鋼/鉄鉱/鉄工/手甲/
てっこうだん /徹甲弾/
てっこつ /鉄骨/
てっさ /鉄鎖/
てっさく /鉄柵/鉄索/
てっしゅう /撤収/
てっしょう /鉄漿/徹宵/
てっしんせきちょう /鉄心石腸/
てっせい /鉄製/
てっせき /鉄石/
てっせん /鉄線/鉄扇/
てっそく /鉄則/
てったい /撤退/
てっつい /鉄槌/鉄鎚/
てってい /徹底/
てっていてき /徹底的/
てっとう /鉄塔/
てっとうてつび /徹頭徹尾/
てっぱい /撤廃/
てっぱん /鉄板/
てっぱんやき /鉄板焼/
てっぴ /鉄扉/
てっぴつ /鉄筆/
てっぴつばん /鉄筆版/
てっぷ /轍鮒/
てっぷん /鉄粉/
てっぺい /撤兵/
てっぺき /鉄壁/
てっぺん /天辺/鉄片/
てっぽう /鉄砲/
てっぽうだま /鉄砲玉/
てっぽうみず /鉄砲水/
てつ /鉄/迭/轍/撤/徹/哲/姪/
てつあれい /鉄亜鈴/
てついろ /鉄色/
てつかず /手付かず/
てつかぶと /鉄兜/
てつがく /哲学/
てつがくしゃ /哲学者/
てつがくてき /哲学的/
てつき /手付/
てつくず /鉄屑/
てつけ /手付/
てつけきん /手付金/
てつげんばん /鉄眼版/
てつごうし /鉄格子/
てつざい /鉄材/鉄剤/
てつじょう /鉄条/
てつじょうもう /鉄条網/
てつじん /鉄人/哲人/
てつだい /手伝い/
てつづき /手続/
てつづきほう /手続法/
てつどう /鉄道/
てつどうきょく /鉄道局/
てつどうしょう /鉄道省/
てつどうしょうか /鉄道唱歌/
てつどうせんろ /鉄道線路/
てつどうもう /鉄道網/
てつびん /鉄瓶/
てつぶん /鉄分/
てつぼう /鉄棒/
てつめん /鉄面/
てつめんぴ /鉄面皮/
てつもん /鉄門/
てつや /徹夜/
てつようそう /綴葉装/
てつり /哲理/
てつろ /鉄路/
てつわん /鉄腕/
てづか /手塚/
てづかおさむ /手塚治虫/
てづかみ /手掴み/
てづくり /手作り/
てづまり /手詰り/
てづめ /手詰め/
てづり /手釣/
てづる /手蔓/
てどり /手取り/
てないしょく /手内職/
てなおし /手直し/
てなが /手長/
てなぐさみ /手慰み/
てなべ /手鍋/
てなみ /手並/
てならい /手習い/
てなれ /手馴れ/
てなわ /手縄/
てにもつ /手荷物/
てにをは /天爾遠波/
てぬい /手縫い/
てぬかり /手抜かり/
てぬき /手抜き/
てぬぐい /手拭/
てのうち /手の内/
てのこう /手の甲/
てのなか /手の中/
てのひら /掌/手の平/
てはい /手配/
てはいし /手配師/
てはじめ /手始め/
てはず /手筈/
てば /手羽/
てばこ /手箱/
てばさき /手羽先/
てばた /手旗/
てばなし /手放し/
てばなれ /手離れ/
てばや /手早/
てびかえ /手控え/
てびき /手引/
てびょうし /手拍子/
てびろ /手広/
てふうきん /手風琴/
てふき /手拭き/
てふだ /手札/
てぶくろ /手袋/
てぶそく /手不足/
てぶら /手ぶら/
てぶり /手振り/
てへん /頂辺/天辺/手偏/
てべんとう /手弁当/
てほどき /手解き/
てほん /手本/
てま /手間/
てまえ /手前/
てまえがって /手前勝手/
てまえみそ /手前味噌/
てまき /手巻/
てまくら /手枕/
てまだい /手間代/
てまちん /手間賃/
てまつぶし /手間潰し/
てまね /手真似/
てまねき /手招き/
てまり /手毬/手鞠/
てまりうた /手鞠唄/
てまわし /手回し/
てまわり /手回り/
てみじか /手短/
てみず /手水/
てみやげ /手土産/
てもち /手持/
てもと /手元/手許/
てもときん /手許金/
てもり /手盛り/
てやき /手焼/
てやく /手役/
てら /寺/
てらい /寺井/
てらうち /寺内/
てらお /寺尾/
てらおとこ /寺男/
てらかた /寺方/
てらかど /寺門/
てらこ /寺子/
てらこしょう /寺小姓/
てらこや /寺子屋/
てらさか /寺坂/
てらさき /寺崎/
てらじま /寺島/
てらせん /寺銭/
てらだ /寺田/
てらどまり /寺泊/
てらにし /寺西/
てらまち /寺町/
てりかえし /照り返し/
てりゅうだん /手榴弾/
てりょうり /手料理/
てれ /照れ/
てれや /照れ屋/
てれん /手練/
てれんてくだ /手練手管/
てわけ /手分け/
てわざ /手業/
てわたし /手渡し/
てん /点/店/天/転/添/展/典/・/．/甜/顛/填/貼/殿/
てんあんもん /天安門/
てんあんもんじけん /天安門事件/
てんい /転移/転位/天衣/天意/典医/
てんいち /天一/
てんいむほう /天衣無縫/
てんいん /店員/
てんうん /天運/
てんえ /天衣/
てんえい /天永/
てんおん /天恩/転音/
てんか /転嫁/天下/点火/添加/転化/転訛/
てんかい /展開/天海/転回/天界/
てんかいず /展開図/
てんかいっぴん /天下一品/
てんかいぶ /展開部/
てんかごめん /天下御免/
てんかす /天滓/
てんかたいへい /天下泰平/
てんかとり /天下取り/
てんかふん /天花粉/
てんかむそう /天下無双/
てんかわけめ /天下分け目/
てんかん /転換/癲癇/転官/展観/
てんかんかぶしき /転換株式/
てんかんき /転換器/
てんかんしゃさい /転換社債/
てんが /典雅/
てんがい /天外/天蓋/天涯/
てんがいこどく /天涯孤独/
てんがく /転学/
てんがん /点眼/天眼/
てんがんすい /点眼水/
てんき /天気/転記/転機/天機/転帰/
てんきあめ /天気雨/
てんきず /天気図/
てんきゅう /天球/
てんきゅうぎ /天球儀/
てんきょ /転居/典拠/
てんきょう /癲狂/
てんきよほう /天気予報/
てんきん /転勤/
てんぎ /典儀/転義/
てんぎょう /転業/
てんく /転句/
てんくう /天空/
てんくうかいかつ /天空海闊/
てんぐ /天狗/
てんぐさ /天草/
てんけい /典型/天啓/天恵/
てんけいてき /典型的/
てんけつ /点穴/転結/
てんけん /点検/
てんげん /天元/
てんこ /点呼/典故/
てんこう /転校/天候/転向/天功/
てんこうこくしょく /天香国色/
てんこうりょく /転向力/
てんこく /篆刻/
てんこもり /天こ盛り/
てんごく /天国/典獄/
てんさい /転載/天才/天災/甜菜/
てんさいじ /天才児/
てんさいてき /天才的/
てんさいとう /甜菜糖/
てんさく /添削/転作/
てんさんぶつ /天産物/
てんざい /点在/
てんざん /天山/
てんし /天使/天子/天資/展翅/
てんしき /点式/
てんしち /転質/
てんしつ /天質/
てんしゃ /転写/
てんしゃく /転借/
てんしゃだい /転車台/
てんしゅ /店主/天主/天守/
てんしゅうごう /点集合/
てんしゅかく /天守閣/
てんしゅきょう /天主教/
てんしゅつ /転出/点出/
てんしゅどう /天主堂/
てんしゅん /転瞬/
てんしょ /添書/篆書/典書/転所/
てんしょう /転生/天正/天承/天象/
てんしょく /転職/天職/
てんしん /転身/転進/天津/点心/天真/天心/
てんしんらんまん /天真爛漫/
てんじ /展示/点字/篆字/典侍/
てんじく /天竺/
てんじくもめん /天竺木綿/
てんじつ /天日/
てんじつえん /天日塩/
てんじとしょかん /点字図書館/
てんじゃ /点者/
てんじゅ /天寿/天授/
てんじゅう /転住/
てんじょ /天助/
てんじょう /天井/天上/天壌/添乗/纏繞/殿上/
てんじょういん /添乗員/
てんじょううら /天井裏/
てんじょうかい /天上界/
てんじょうがわ /天井川/
てんじょうけい /纏繞茎/
てんじょうさじき /天井桟敷/
てんじょうびと /殿上人/
てんじょうむきゅう /天壌無窮/
てんじん /天神/天人/
てんじんばし /天神橋/
てんじんまつり /天神祭/
てんすい /天水/
てんすう /点数/
てんせい /天性/転生/転成/展性/天成/点睛/
てんせき /転籍/転石/典籍/
てんせん /点線/転戦/
てんぜん /恬然/典膳/
てんそう /転送/
てんそく /天測/典則/纏足/店則/
てんそんこうりん /天孫降臨/
てんぞく /転属/
てんたい /天体/転貸/
てんたいかんそく /天体観測/
てんたいしゃく /転貸借/
てんたいしゃしん /天体写真/
てんたいしょう /点対称/
てんたいぶつりがく /天体物理学/
てんたく /転宅/
てんたん /恬淡/
てんだい /天台/
てんだいしゅう /天台宗/
てんち /天地/転地/転置/
てんちかいびゃく /天地開闢/
てんちしんめい /天地神明/
てんちむよう /天地無用/
てんちゃ /点茶/
てんちゅう /天誅/転注/天柱/
てんちょう /転調/天頂/天聴/
てんちょうちきゅう /天長地久/
てんちりょうよう /転地療養/
てんてい /天帝/点綴/
てんていとう /転抵当/
てんてき /天敵/点滴/
てんてん /転々/点々/輾転/展転/・・・/…/‥/
てんてんはんそく /輾転反側/
てんとう /店頭/点灯/転倒/顛倒/天道/
てんとく /転得/
てんとくじ /天徳寺/
てんとり /点取り/
てんどう /天童/天道/
てんどうせつ /天動説/
てんどん /天丼/
てんにゅう /転入/
てんにょ /天女/
てんにん /転任/天人/
てんねん /天然/
てんねんかじつ /天然果実/
てんねんきねんぶつ /天然記念物/
てんねんしげん /天然資源/
てんねんしょく /天然色/
てんねんせんりょう /天然染料/
てんねんとう /天然痘/
てんねんりん /天然林/
てんのう /天皇/天王/
てんのうきかんせつ /天皇機関説/
てんのうざん /天王山/
てんのうじ /天王寺/
てんのうじや /天王寺屋/
てんのうせい /天皇制/天王星/
てんのうへいか /天皇陛下/
てんば /天馬/
てんばい /転売/
てんばいかいもどし /転売買戻し/
てんばつ /天罰/
てんばつてきめん /天罰覿面/
てんぱい /聴牌/顛沛/
てんぱん /典範/
てんびき /天引き/
てんびょう /点描/
てんびん /天秤/
てんびんざ /天秤座/
てんびんぼう /天秤棒/
てんぴ /天火/天日/
てんぴじお /天日塩/
てんぴょう /天平/
てんぴん /天稟/
てんぶくろ /天袋/
てんぶつ /天物/典物/
てんぶん /天分/天文/篆文/
てんぷ /添付/天賦/貼付/
てんぷく /転覆/天福/
てんぷら /天麩羅/
てんぺん /転変/天変/天辺/
てんぺんちい /天変地異/
てんぼう /展望/
てんぼうしゃ /展望車/
てんぽ /店舗/填補/転補/
てんぽう /天保/
てんぽうざん /天保山/
てんぽうせん /天保銭/
てんぽん /点本/
てんま /天魔/伝馬/
てんまく /天幕/
てんません /伝馬船/
てんまつ /顛末/
てんまど /天窓/
てんまんぐう /天満宮/
てんめい /天命/天明/
てんめつ /点滅/
てんめん /纏綿/
てんもう /天網/
てんもく /天目/
てんもくぢゃわん /天目茶碗/
てんもん /天文/
てんもんがく /天文学/
てんもんたんい /天文単位/
てんもんだい /天文台/
てんや /店屋/
てんやく /点訳/点薬/
てんやもの /店屋物/
てんゆう /天佑/
てんよ /天与/
てんよう /転用/
てんらい /天来/
てんらく /転落/
てんらん /展覧/天覧/
てんり /天理/
てんりきょう /天理教/
てんりゅう /天竜/
てんりゅうがわ /天竜川/
てんりょう /天領/
てんりんおう /転輪王/
てんれい /典礼/典例/典麗/
てんろうせい /天狼星/
てんわ /天和/
で /弟/出/
であい /出会い/出合い/
であいがしら /出合い頭/
であし /出足/
でい /泥/
でいすい /泥酔/泥水/
でいたん /泥炭/
でいちゅう /泥中/
でいど /泥土/
でいねい /泥濘/
でいばんがん /泥板岩/
でいり /出入り/
でいりぐち /出入口/
でいりゅう /泥流/
でかせぎ /出稼ぎ/
でかた /出方/
でがたり /出語り/
でき /出来/溺/
できあい /溺愛/出来合/
できぐあい /出来具合/
できごころ /出来心/
できごと /出来事/
できし /溺死/
できだか /出来高/
できね /出来値/
できばえ /出来映え/
できぼし /出来星/
できぼつ /溺没/
できもの /出来物/
でぎわ /出際/
でく /木偶/
でぐち /出口/
でげいこ /出稽古/
でこ /凸/
でこぼこ /凸凹/
でさかり /出盛り/
でさき /出先/
でさききかん /出先機関/
でし /弟子/
でしいり /弟子入り/
でしお /出潮/
でしょく /出職/
でじま /出島/
でじろ /出城/
ですぎ /出過ぎ/
でずいらず /出ず入らず/
でせん /出銭/
でぞめ /出初め/
でぞめしき /出初め式/
でたて /出立て/
でだし /出出し/
でっち /丁稚/
でっちょうそう /粘葉装/
でっちり /出っ尻/
でっぱ /出っ歯/
でつぞう /捏造/
でづっぱり /出突っ張り/
でづら /出面/
でどころ /出所/出処/
ではいり /出入り/
ではじめ /出始め/
ではずれ /出外れ/
でば /出刃/出場/出歯/
でばかめ /出歯亀/
でばしょ /出場所/
でばな /出鼻/
でばぼうちょう /出刃庖丁/
でばん /出番/
でふね /出船/
でぶしょう /出不精/
でほうだい /出放題/
でまえ /出前/
でまかせ /出任せ/
でまど /出窓/
でまる /出丸/
でみず /出水/
でみせ /出店/
でむかえ /出迎え/
でむら /出村/
でめ /出目/
でめきん /出目金/
でもどり /出戻り/
でもの /出物/
でやしき /出屋敷/
でゆ /出湯/
でよう /出様/
でるた /Δ/δ/
でわ /出羽/
でん /電/田/殿/伝/澱/
でんあつ /電圧/
でんあつけい /電圧計/
でんい /電位/
でんいさ /電位差/
でんえん /田園/
でんえんとし /田園都市/
でんえんとしせん /田園都市線/
でんか /電化/殿下/伝家/電荷/田家/
でんかい /電解/電界/
でんかいしつ /電解質/
でんかのほうとう /伝家の宝刀/
でんがく /田楽/
でんき /電気/電機/伝記/電器/伝奇/
でんきえいどう /電気泳動/
でんきかいり /電気解離/
でんきかいろ /電気回路/
でんきかがく /電気化学/
でんきがっき /電気楽器/
でんきがま /電気釜/
でんききかんしゃ /電気機関車/
でんきこうがく /電気工学/
でんきじぎょう /電気事業/
でんきじどうしゃ /電気自動車/
でんきそうじき /電気掃除機/
でんきていこう /電気抵抗/
でんきてつどう /電気鉄道/
でんきぶんかい /電気分解/
でんきもうふ /電気毛布/
でんきゅう /電球/
でんきょく /電極/
でんきようりょう /電気容量/
でんきりょう /電気量/
でんきりょうほう /電気療法/
でんきれいぞうこ /電気冷蔵庫/
でんきろ /電気炉/
でんげき /電撃/
でんげん /電源/
でんげんかいはつ /電源開発/
でんこう /電工/電光/
でんこうせっか /電光石火/
でんごん /伝言/
でんごんばん /伝言板/
でんさん /電算/
でんさんき /電算機/
でんし /電子/
でんしおんがく /電子音楽/
でんしがっき /電子楽器/
でんしけいさんき /電子計算機/
でんしけんびきょう /電子顕微鏡/
でんしこうがく /電子工学/
でんししゅっぱん /電子出版/
でんしじゅう /電子銃/
でんしせん /電子線/
でんしてちょう /電子手帳/
でんしは /電子波/
でんしゃ /電車/
でんしゃく /電車区/
でんしゅう /伝習/
でんしゆうびん /電子郵便/
でんしょ /伝書/
でんしょう /伝承/伝唱/伝誦/
でんしょうぶんがく /伝承文学/
でんしょく /電飾/
でんしょばと /伝書鳩/
でんしん /電信/
でんしんき /電信機/
でんしんばしら /電信柱/
でんじ /電磁/
でんじきがく /電磁気学/
でんじしゃく /電磁石/
でんじは /電磁波/
でんじば /電磁場/
でんじゅ /伝授/
でんじゆうどう /電磁誘導/
でんじりょく /電磁力/
でんすけ /伝助/
でんせいかん /伝声管/
でんせつ /伝説/
でんせん /電線/伝染/伝線/
でんせんせい /伝染性/
でんせんびょう /伝染病/
でんそう /伝送/電送/電装/
でんそく /電束/
でんたく /電卓/
でんたつ /伝達/
でんたん /電探/
でんだい /田代/
でんち /電池/
でんちく /電蓄/
でんちゅう /電柱/殿中/
でんてつ /電鉄/
でんでんこうしゃ /電電公社/
でんとう /伝統/電灯/
でんどう /伝道/伝導/電動/殿堂/伝動/
でんどうき /電動機/
でんどうし /伝道師/
でんどうしゃ /電動車/
でんねつ /電熱/
でんねつき /電熱器/
でんのう /電脳/
でんば /電場/
でんぱ /電波/伝播/
でんぱた /田畑/
でんぱつ /電髪/
でんぱてんたい /電波天体/
でんぱてんもんがく /電波天文学/
でんぱほう /電波法/
でんぱん /殿版/
でんぴょう /伝票/
でんぶ /臀部/田麩/
でんぶん /伝聞/電文/
でんぶんしょうこ /伝聞証拠/
でんぷん /澱粉/
でんぷんしつ /澱粉質/
でんぼう /伝法/
でんぽ /田圃/
でんぽう /電報/
でんぽん /伝本/
でんまーく /丁抹/
でんめい /電命/
でんや /田野/
でんらい /伝来/
でんらん /電纜/
でんり /電離/
でんりそう /電離層/
でんりばこ /電離箱/
でんりゃく /電略/
でんりゅう /電流/
でんりゅうけい /電流計/
でんりょく /電力/
でんりょくけい /電力計/
でんりょくりょう /電力量/
でんれい /伝令/電鈴/
でんろ /電路/
でんわ /電話/
でんわき /電話機/
でんわきょく /電話局/
でんわぐち /電話口/
でんわせん /電話線/
でんわだい /電話代/
でんわちょう /電話帳/
でんわばんごう /電話番号/
と /都/登/途/図/戸/頭/十/土/徒/渡/塗/斗/吐/賭/度/砥/屠/堵/人/蠧/外/杜/砺/妬/鍍/兎/菟/
とあさ /遠浅/
とあみ /投網/
とい /土肥/樋/問い/問/
といあわせ /問合せ/
といき /吐息/
といし /砥石/
といた /戸板/
といつ /対子/
といみさき /都井岬/
といめん /対面/
といや /問屋/
といやまち /問屋町/
とう /等/頭/当/討/東/投/冬/盗/闘/騰/陶/透/逃/踏/豆/謄/蕩/到/統/糖/筒/答/祷/痘/燈/灯/湯/棟/桃/悼/島/套/塘/塔/唐/刀/凍/党/倒/登/読/道/納/籐/榻/濤/纛/骰/稲/董/鐙/藤/涛/淘/梼/搭/嶋/宕/逗/
とう> /当/
とうあ /東亜/
とうあつせん /等圧線/
とうあん /答案/
とうい /等位/東夷/当為/当意/
とういじょう /糖衣錠/
とういす /籐椅子/
とういそくみょう /当意即妙/
とういつ /統一/
とういつこうどう /統一行動/
とういつばりろん /統一場理論/
とういん /党員/登院/頭韻/
とううん /東雲/
とうえい /投影/
とうえいほう /投影法/
とうえいめん /投影面/
とうえんめい /陶淵明/
とうおう /東欧/
とうおん /唐音/等温/
とうおんせん /等温線/
とうか /等価/透過/投下/灯火/桃花/糖化/豆果/陶化/橙果/
とうかい /東海/韜晦/倒壊/倒潰/
とうかいじしん /東海地震/
とうかいだいがく /東海大学/
とうかいちほう /東海地方/
とうかいどう /東海道/
とうかく /当確/頭角/等角/倒閣/
とうかくりつ /等確率/
とうかげんり /等価原理/
とうかこうかん /等価交換/
とうかせい /透過性/
とうかつ /統轄/統括/
とうかん /投函/等閑/凍寒/統監/
とうが /陶瓦/冬芽/
とうがい /当該/頭蓋/等外/凍害/
とうがいこつ /頭蓋骨/
とうがね /東金/
とうがらし /唐辛子/
とうがん /冬瓜/東岸/
とうき /冬季/冬期/投棄/登記/当期/陶器/騰貴/投機/党紀/当季/党規/
とうきしょ /登記所/
とうきせん /登記船/
とうきてき /投機的/
とうきとりひき /投機取引/
とうきび /唐黍/
とうきぼ /登記簿/
とうきゅう /投球/等級/討究/
とうきょう /東京/
とうきょうえき /東京駅/
とうきょうおんど /東京音頭/
とうきょうご /東京語/
とうきょうさいばん /東京裁判/
とうきょうしんぶん /東京新聞/
とうきょうだいがく /東京大学/
とうきょうと /東京都/
とうきょうわん /東京湾/
とうきょく /当局/
とうぎ /討議/東儀/闘技/党議/
とうぎゅう /闘牛/
とうぎゅうし /闘牛士/
とうぎょ /統御/
とうぎり /当限/
とうくつ /盗掘/
とうくろう /藤九郎/
とうぐう /東宮/
とうけ /当家/
とうけい /統計/東経/闘鶏/
とうけいがく /統計学/
とうけいてき /統計的/
とうけいりきがく /統計力学/
とうけつ /凍結/
とうけん /闘犬/刀剣/
とうけんがけい /陶犬瓦鶏/
とうげ /峠/
とうげい /陶芸/
とうげつ /当月/
とうげん /桃源/
とうげんきょう /桃源郷/
とうこう /投稿/登校/投降/陶工/刀工/東郊/投光/
とうこうきょひ /登校拒否/
とうこうぎゃくし /倒行逆施/
とうこうしゃ /投稿者/
とうこうせん /等高線/
とうこく /透谷/
とうこつ /橈骨/頭骨/
とうこん /闘魂/当今/刀痕/
とうご /頭語/
とうごう /統合/等号/東郷/投合/
とうごく /投獄/東国/当国/
とうごろん /統語論/
とうさ /踏査/等差/
とうさい /搭載/登載/当歳/統裁/
とうさきゅうすう /等差級数/
とうさく /倒錯/盗作/東作/
とうさすうれつ /等差数列/
とうさま /父様/
とうさん /父さん/倒産/
とうさんさい /唐三彩/
とうざ /当座/
とうざい /東西/
とうざいなんぼく /東西南北/
とうざかりこし /当座借越/
とうざのがれ /当座逃れ/
とうざよきん /当座預金/
とうざん /唐山/当山/
とうし /投資/透視/凍死/闘士/闘志/唐詩/唐紙/
とうしがほう /透視画法/
とうしき /等式/
とうしこもんぎょう /投資顧問業/
とうししんたく /投資信託/
とうしせん /唐詩選/
とうしつ /等質/糖質/
とうしゃ /当社/投射/謄写/透写/
とうしゃばん /謄写版/
とうしゅ /投手/党首/当主/頭首/
とうしゅう /踏襲/東周/
とうしゅく /投宿/
とうしょ /当初/投書/当所/島嶼/当処/頭書/
とうしょう /闘将/東証/凍傷/刀匠/刀傷/
とうしょうぐう /東照宮/
とうしょうだいじ /唐招提寺/
とうしょく /当職/
とうしん /等親/答申/等身/投身/東進/刀身/投信/灯心/
とうしんせん /等深線/
とうしんだい /等身大/
とうしんてつどう /東清鉄道/
とうじ /当時/答辞/湯治/冬至/杜氏/東寺/刀自/当寺/当事/悼辞/統治/蕩児/
とうじいん /等持院/
とうじき /陶磁器/
とうじしゃ /当事者/
とうじしゃしゅぎ /当事者主義/
とうじしゃてきかく /当事者適格/
とうじせい /等時性/
とうじつ /当日/
とうじばん /東寺版/
とうじゅ /藤樹/
とうじょ /唐書/
とうじょう /登場/搭乗/東条/東上/頭状/登城/凍上/
とうじょうか /頭状花/
とうじょうかじょ /頭状花序/
とうじりつ /透磁率/
とうじん /蕩尽/陶人/唐人/党人/
とうじんぼう /東尋坊/
とうじんまち /唐人町/
とうす /刀子/
とうすい /陶酔/統帥/透水/
とうすいきょう /陶酔境/
とうすいけん /統帥権/
とうせい /当世/統制/陶製/東征/倒生/党勢/騰勢/
とうせいけいざい /統制経済/
とうせいは /統制派/
とうせいふう /当世風/
とうせき /投石/透析/党籍/
とうせつ /当節/
とうせん /当選/盗泉/唐船/当籤/東遷/
とうせんかろ /冬扇夏炉/
とうぜ /党是/
とうぜん /当然/陶然/
とうそう /闘争/党争/逃走/痘瘡/
とうそく /等速/党則/
とうそくるい /頭足類/
とうそつ /統率/
とうぞく /盗賊/
とうた /淘汰/
とうたつ /到達/
とうたつしゅぎ /到達主義/
とうたん /東端/
とうだい /当代/灯台/東台/
とうだいじ /東大寺/
とうだん /登壇/
とうち /当地/倒置/統治/等値/島地/
とうちこうい /統治行為/
とうちしゃ /統治者/
とうちゃ /闘茶/
とうちゃく /到着/
とうちゃん /父ちゃん/
とうちゅう /頭注/
とうちゅうかそう /冬虫夏草/
とうちょう /盗聴/登頂/登庁/唐朝/等張/
とうちょく /当直/
とうつう /疼痛/頭痛/
とうてい /到底/
とうてき /投擲/
とうてつ /透徹/
とうてん /読点/当店/東天/
とうてんこう /東天紅/
とうでん /盗電/
とうと /東都/
とうとう /等々/到頭/丁丁/東塔/偸盗/登登/蕩蕩/鼕鼕/疾う疾う/等等/滔々/滔滔/
とうとつ /唐突/
とうど /凍土/陶土/
とうどう /藤堂/東堂/東道/
とうどうばつい /党同伐異/
とうどく /東独/
とうどり /頭取/
とうなん /東南/盗難/
とうなんとう /東南東/
とうなんほけん /盗難保険/
とうにゅう /投入/豆乳/
とうにょう /糖尿/
とうにょうびょう /糖尿病/
とうにん /当人/
とうねん /当年/
とうの /当の/
とうは /党派/踏破/
とうはつ /頭髪/
とうはん /登攀/登坂/盗犯/
とうば /塔婆/
とうばく /倒幕/討幕/
とうばつ /討伐/盗伐/党閥/
とうばん /当番/登板/
とうひ /逃避/当否/等比/討匪/
とうひきゅうすう /等比級数/
とうひこう /逃避行/
とうひすうれつ /等比数列/
とうひょう /投票/
とうひん /盗品/
とうび /掉尾/
とうびょう /闘病/投錨/
とうふ /豆腐/
とうふう /東風/党風/唐風/
とうふくじ /東福寺/
とうぶ /東武/頭部/
とうぶつ /唐物/
とうぶん /当分/等分/糖分/
とうへき /盗癖/
とうへん /等辺/
とうへんついほう /陶片追放/
とうへんぼく /唐変木/
とうべん /答弁/
とうべんしょ /答弁書/
とうほう /当方/東邦/東方/答訪/答砲/
とうほうせい /等方性/
とうほく /東北/
とうほくだいがく /東北大学/
とうほくとう /東北東/
とうほくべん /東北弁/
とうほくほんせん /東北本線/
とうほん /謄本/唐本/
とうほんせいそう /東奔西走/
とうぼう /逃亡/
とうぼく /倒木/冬木/唐木/
とうまちくい /稲麻竹葦/
とうみつ /糖蜜/
とうみょう /灯明/
とうみん /冬眠/島民/
とうむ /党務/
とうめい /東名/透明/
とうめいたい /透明体/
とうめいど /透明度/
とうめん /当面/東面/
とうめんよう /等面葉/
とうもく /頭目/
とうもつ /唐物/
とうもろこし /玉蜀黍/
とうや /当夜/陶冶/
とうやく /投薬/湯薬/
とうやこ /洞爺湖/
とうゆ /灯油/
とうよ /投与/東予/
とうよう /東洋/盗用/登用/当用/陶窯/
とうよういがく /東洋医学/
とうようかんじ /当用漢字/
とうようがく /東洋学/
とうようだいがく /東洋大学/
とうようぶんこ /東洋文庫/
とうらい /到来/当来/
とうらく /当落/騰落/
とうり /桃李/党利/統理/
とうりつ /倒立/
とうりゃく /党略/
とうりゅう /逗留/当流/
とうりゅうもん /登竜門/
とうりょう /統領/等量/棟梁/投了/当量/頭領/
とうりん /登臨/
とうるい /盗塁/糖類/
とうれい /答礼/
とうろ /当路/
とうろう /灯籠/蟷螂/
とうろく /登録/
とうろくいしょう /登録意匠/
とうろくしち /登録質/
とうろん /討論/
とうわく /当惑/
とえい /都営/渡英/
とえはたえ /十重二十重/
とお /十/遠/
とおあさ /遠浅/
とおあるき /遠歩き/
とおう /渡欧/
とおえん /遠縁/
とおか /十日/
とおかまち /十日町/
とおからず /遠からず/
とおく /遠く/
とおし /通し/
とおしばしら /通し柱/
とおしばんごう /通し番号/
とおせんぼう /通せん坊/
とおぜめ /遠攻め/
とおで /遠出/
とおとうみ /遠江/
とおなり /遠鳴り/
とおね /遠音/
とおの /遠野/
とおのり /遠乗り/
とおび /遠火/
とおぼえ /遠吠え/
とおまき /遠巻き/
とおまわし /遠回し/
とおまわり /遠回り/
とおみ /遠見/
とおめ /遠目/
とおめがね /遠眼鏡/
とおや /遠矢/
とおやま /遠山/
とおやまざくら /遠山桜/
とおり /通り/通/
とおりあめ /通り雨/
とおりいっぺん /通り一遍/
とおりすがり /通りすがり/
とおりそうば /通り相場/
とおりちょう /通町/
とおりな /通り名/
とおりぬけ /通り抜け/
とおりね /通り値/
とおりま /通り魔/
とおりみち /通り道/
とおる /融/
とか /都下/渡河/
とかい /都会/渡海/
とかいじん /都会人/
とかげ /蜥蜴/石竜子/
とかち /十勝/
とかちがわ /十勝川/
とかちへいや /十勝平野/
とが /咎/科/栂/
とがき /ト書/
とがくし /戸隠/
とがし /富樫/
とがにん /咎人/
とがのお /栂尾/
とがめ /咎め/
とがめだて /咎め立て/
とがりごえ /尖り声/
とがわ /戸川/
とき /時/土岐/朱鷺/鬨/鴇/
ときいろ /鴇色/
ときえだ /時枝/
ときおり /時折/
ときかた /解き方/
ときがし /時貸し/
ときがり /時借り/
ときぐし /解き櫛/
ときたま /時偶/
ときどき /時々/時時/
ときなし /時無し/
ときに /時に/
ときもの /解き物/
ときょうそう /徒競走/
ときよ /時世/
ときよじせつ /時世時節/
ときわ /常盤/常葉/常磐/
ときわかえで /常磐楓/
ときわぎ /常磐木/
ときわこうえん /常磐公園/
ときわじんじゃ /常磐神社/
ときわず /常磐津/
ときん /と金/鍍金/
とぎ /都議/伽/研ぎ/
とぎかい /都議会/
とぎもの /研ぎ物/
とぎゃく /吐逆/
とぎれ /跡切れ/
とく /特/得/篤/禿/督/徳/匿/読/犢/疾く/涜/
とくい /得意/特異/
とくいく /徳育/
とくいげ /得意気/
とくいさき /得意先/
とくいせい /特異性/
とくいたいしつ /特異体質/
とくいてん /特異点/
とくいび /特異日/
とくいまんめん /得意満面/
とくおか /徳岡/
とくがく /篤学/
とくがわ /徳川/
とくがわいえやす /徳川家康/
とくがわよしのぶ /徳川慶喜/
とくぎ /特技/徳義/
とくぎょう /得業/
とくさ /木賊/
とくさいろ /木賊色/
とくさく /得策/
とくさつ /特撮/
とくさん /特産/
とくし /特使/篤志/特旨/
とくしつ /特質/得失/
とくしま /徳島/
とくしまけん /徳島県/
とくしまし /徳島市/
とくしゃ /特赦/特写/
とくしゅ /特殊/特種/
とくしゅう /特集/
とくしゅうごう /特集号/
とくしゅがっきゅう /特殊学級/
とくしゅこう /特殊鋼/
とくしゅさつえい /特殊撮影/
とくしゅつ /特出/
とくしゅぶらく /特殊部落/
とくしゅほうじん /特殊法人/
とくしょう /特賞/特称/
とくしょく /特色/涜職/
とくしん /得心/特進/涜神/篤信/
とくじ /徳治/
とくじつ /篤実/
とくじゅ /特需/
とくじょう /特上/
とくじん /徳人/
とくずき /特漉き/
とくせい /特性/特製/徳政/徳星/徳性/
とくせつ /特設/
とくせん /特選/特撰/特薦/督戦/
とくそう /得喪/禿瘡/徳操/
とくそく /督促/
とくそくてつづき /督促手続/
とくたい /特待/
とくたいせい /特待生/
とくだ /徳田/
とくだい /特大/
とくだいじ /徳大寺/
とくだしゅうせい /徳田秋声/
とくだね /特種/
とくだん /特段/
とくちゅう /特注/
とくちょう /特徴/特長/
とくてい /特定/
とくていいぞう /特定遺贈/
とくていざいさん /特定財産/
とくていしょうけい /特定承継/
とくていぶつ /特定物/
とくてん /得点/特典/特点/
とくでん /特電/
とくとう /特等/禿頭/
とくとみ /徳富/
とくど /得度/
とくなが /徳永/
とくに /特に/
とくにん /特認/
とくのう /篤農/
とくのしま /徳之島/
とくは /特派/
とくはい /特配/
とくはいん /特派員/
とくはつ /特発/
とくばい /特売/
とくばん /特番/
とくひつ /特筆/
とくひつたいしょ /特筆大書/
とくひょう /得票/
とくべつ /特別/
とくべつあつかい /特別扱い/
とくべついいんかい /特別委員会/
とくべついにん /特別委任/
とくべつかいけい /特別会計/
とくべつきてい /特別規定/
とくべつきゅうこう /特別急行/
とくべつく /特別区/
とくべつけつぎ /特別決議/
とくべつこうこく /特別抗告/
とくべつこっかい /特別国会/
とくべつしょく /特別職/
とくべつじょうこく /特別上告/
とくべつたんぽ /特別担保/
とくべつべんごにん /特別弁護人/
とくべつほう /特別法/
とくほう /特報/
とくほん /読本/
とくぼう /徳望/
とくむ /特務/
とくむかん /特務艦/
とくむきかん /特務機関/
とくむしかん /特務士官/
とくむそうちょう /特務曹長/
とくめい /匿名/特命/
とくめいくみあい /匿名組合/
とくもく /徳目/
とくやく /特約/
とくやくてん /特約店/
とくやま /徳山/
とくゆう /特有/特融/
とくゆうざいさん /特有財産/
とくよう /徳用/特用/
とくり /徳利/
とくりつ /特立/
とくれい /特例/督励/
とぐち /戸口/
とけい /時計/徒刑/
とけいだい /時計台/
とけつ /吐血/
とげ /刺/棘/
とげぬき /刺抜き/
とこ /常/床/
とこあげ /床上げ/
とこい /常井/
とこいた /床板/
とこう /渡航/
とこずれ /床擦れ/
とこだたみ /床畳/
とこなつ /常夏/
とこなめ /常滑/
とこのま /床の間/
とこはる /常春/
とこばしら /床柱/
とこばなれ /床離れ/
とこばらい /床払い/
とこや /床屋/
とこやま /床山/
とこよ /常世/
ところ /処/所/
ところがき /所書/
ところがら /所柄/
ところざわ /所沢/
ところてん /心太/
ところどころ /所々/
ところばらい /所払い/
とさ /土佐/
とさいぬ /土佐犬/
とさえ /土佐絵/
とさか /鶏冠/戸坂/
とさしみず /土佐清水/
とさつ /屠殺/塗擦/
とざい /吐剤/
とざま /外様/
とざまだいみょう /外様大名/
とざん /登山/
とざんてつどう /登山鉄道/
とし /年/歳/都市/徒死/
としうえ /年上/
としおとこ /年男/
としおんな /年女/
としかさ /年嵩/
としがい /年甲斐/
としぎんこう /都市銀行/
としけいかく /都市計画/
としこうがく /都市工学/
としこし /年越し/
としこっか /都市国家/
としご /年子/
としごいのまつり /祈年祭/
としごと /年毎/
としごもり /年籠り/
としごろ /年頃/
としした /年下/
としだか /年高/
としつき /年月/
としづよ /年強/
としなみ /年波/
としのうち /年の内/
としのこう /年の功/
としのせ /年の瀬/
としのは /年の端/
としのよ /年の夜/
としま /豊島/年増/
としまわり /年回り/
としゃ /吐瀉/
としゅ /徒手/斗酒/
としゅくうけん /徒手空拳/
としょ /図書/屠所/
としょかん /図書館/
としょがく /図書学/
としょく /徒食/
としょけん /図書券/
としょしつ /図書室/
としょもくろく /図書目録/
としより /年寄/
としよわ /年弱/
としわか /年若/
としわすれ /年忘れ/
としん /都心/妬心/
とじ /刀自/途次/綴じ/徒事/
とじいと /綴じ糸/
とじしろ /綴じ代/
とじほん /綴本/
とじまり /戸締り/
とじめ /綴じ目/
とじょう /途上/登城/屠場/外城/
とす /鳥栖/
とせ /歳/
とせい /渡世/都政/
とせいにん /渡世人/
とせん /渡船/
とぜい /都税/
とぜつ /途絶/杜絶/
とぜん /徒然/
とそ /屠蘇/
とそう /塗装/
とそつ /兜率/
とそつてん /兜率天/
とたん /途端/塗炭/
とだ /戸田/
とだな /戸棚/
とち /土地/橡/栃/
とちお /栃尾/
とちかいりょうく /土地改良区/
とちかん /土地勘/
とちかんかつ /土地管轄/
とちがら /土地柄/
とちぎ /栃木/
とちぎけん /栃木県/
とちく /屠畜/
とちくじょう /屠畜場/
とちしゅうよう /土地収用/
とちしょゆうけん /土地所有権/
とちしようけん /土地使用権/
とちだいちょう /土地台帳/
とちっこ /土地っ子/
とちゅう /途中/
とちゅうげしゃ /途中下車/
とちょう /都庁/登頂/
とっか /特化/特価/特科/徳化/
とっかん /突貫/吶喊/
とっき /特記/突起/
とっきゅう /特急/特級/
とっきょ /特許/
とっきょけん /特許権/
とっきょじむしょ /特許事務所/
とっきょちょう /特許庁/
とっきょほう /特許法/
とっく /疾っく/
とっくり /徳利/
とっくん /特訓/
とっけい /特恵/
とっけつ /突厥/
とっけん /特権/
とっけんかいきゅう /特権階級/
とっこ /独鈷/
とっこう /特効/特高/徳行/
とっこうたい /特攻隊/
とっこうやく /特効薬/
とっさ /咄嗟/
とっしゅつ /突出/
とっしん /突進/
とったん /突端/
とって /把手/取っ手/
とってい /突堤/
とっておき /取って置き/
とっとり /鳥取/
とっとりけん /鳥取県/
とっとりさきゅう /鳥取砂丘/
とっとりし /鳥取市/
とっぱ /突破/鳥羽/
とっぱこう /突破口/
とっぱつ /突発/
とっぱつてき /突発的/
とっぱん /凸版/
とっぴ /突飛/
とっぴょうし /突拍子/
とっぷう /突風/
とつ /突/凸/吶/咄/訥/
とつか /戸塚/
とつがわ /十津川/
とつぎさき /嫁ぎ先/
とつげき /突撃/
とつじょ /突如/
とつぜん /突然/
とつぜんし /突然死/
とつぜんへんい /突然変異/
とつとつかいじ /咄咄怪事/
とつにゅう /突入/
とつべん /訥弁/
とつめん /凸面/
とつめんきょう /凸面鏡/
とてい /徒弟/
とても /迚も/
とでん /都電/
ととう /徒党/渡頭/渡島/
ととさま /父様/
とど /椴/
とどうふけん /都道府県/
とどうふけんぎかい /都道府県議会/
とどうふけんちじ /都道府県知事/
とどけ /届け/
とどけさき /届け先/
とどまつ /椴松/
とどめ /止め/
とどろ /轟/
とどろき /轟き/
とない /都内/
となかい /馴鹿/
となみ /砺波/礪波/
となり /隣/
となりきんじょ /隣近所/
となりぐみ /隣組/
とにゅう /吐乳/
とね /刀禰/
とねがわ /利根川/
とねり /舎人/
との /殿/
とのがた /殿方/
とのご /殿御/
とのさま /殿様/
とのと /殿戸/
とはい /徒輩/
とはいえ /とは言え/
とば /鳥羽/賭場/
とばえ /鳥羽絵/
とばく /賭博/
とばくざい /賭博罪/
とばた /戸畑/
とばり /帳/帷/戸張り;戸板で張物をする/戸張;姓/
とひ /都鄙/徒費/
とび /鳶/鴟/鵄/
とびいし /飛石/
とびいり /飛入り/
とびいろ /鳶色/
とびうお /飛魚/
とびきゅう /飛び級/
とびきり /飛切り/
とびぐち /鳶口/
とびこ /飛子/
とびしま /飛島/
とびしょく /鳶職/
とびとび /飛び飛び/
とびどうぐ /飛道具/
とびひ /飛び火/
とびら /扉/
とびらえ /扉絵/
とふ /塗布/都府/
とぶくろ /戸袋/
とぶすま /戸襖/
とぶとり /飛ぶ鳥/
とべい /渡米/
とほ /徒歩/杜甫/
とほう /途方/
とま /苫/篷/
とまこまい /苫小牧/
とます /斗/
とまつ /塗抹/
とまり /泊り/
とまりぎ /止り木/
とみ /富/登美/
とみい /富井/
とみおか /富岡/
とみくじ /富籤/
とみた /富田/
とみなが /富永/
とみに /頓に/
とみもと /富本/
とみん /都民/
とみんぜい /都民税/
とむらいがっせん /弔い合戦/
とめがね /留金/
とめそで /留袖/
とめど /止処/留処/
とめば /留場/
とめべん /止め弁/
とめやま /留山/
とも /共/供/朋/伴/艫/鞆/侶/友/
ともうら /共裏/
ともえ /巴/
ともえなげ /巴投げ/
ともえり /共襟/
ともかせぎ /共稼ぎ/
ともぐい /共食い/
ともこ /友子/
ともしび /灯/灯火/
ともだ /友田/
ともだおれ /共倒れ/
ともだち /友達/
ともづな /纜/
ともづり /友釣/
ともども /共々/
ともなが /朝永/朝長/
ともなり /友成/共鳴り/
ともに /共に/
ともね /共寝/
ともの /友野/
ともばたらき /共働き/
ともびき /友引/
とや /鳥屋/
とやま /富山/外山/
とやまけん /富山県/
とやまし /富山市/
とよ /豊/
とよあきつしま /豊秋津洲/
とよあけ /豊明/
とよあしはら /豊葦原/
とよう /渡洋/
とよおか /豊岡/
とよかわ /豊川/
とよかわいなり /豊川稲荷/
とよさか /豊栄/
とよしま /豊島/
とよた /豊田/
とよだ /豊田/
とよとし /豊年/
とよとみ /豊臣/
とよとみひでよし /豊臣秀吉/
とよとみひでより /豊臣秀頼/
とよなか /豊中/
とよはし /豊橋/
とよはら /豊原/
とら /虎/寅/
とらい /渡来/
とらがり /虎刈り/
とらのこ /虎の子/
とらのまき /虎の巻/
とらのもん /虎ノ門/
とらわれ /囚われ/
とり /酉/鳥/取り/禽/
とりあえず /取り敢えず/
とりあつかい /取扱い/
とりあわせ /取合せ/
とりい /鳥居/
とりいれ /取入れ/
とりうち /鳥打ち/
とりえ /取柄/
とりおどし /鳥威し/
とりかい /鳥飼/
とりかえ /取替え/
とりかご /鳥籠/
とりかじ /取舵/
とりくち /取口/
とりくみ /取組/
とりけし /取消し/
とりけしけん /取消権/
とりこ /虜/擒/
とりこしぐろう /取越し苦労/
とりごや /鳥小屋/
とりさげ /取下げ/
とりざた /取沙汰/
とりざら /取り皿/
とりしま /鳥島/
とりしまり /取締り/
とりしまりやく /取締役/
とりしまりやくかい /取締役会/
とりしらべ /取調べ/
とりたてきん /取立金/
とりだか /取高/
とりつ /都立/
とりつぎ /取次/
とりつぎてん /取次店/
とりつけ /取付け/
とりて /取り手/
とりてき /取的/
とりで /砦/取手/
とりのいち /酉の市/
とりのこ /鳥の子/
とりのこいろ /鳥の子色/
とりのこがみ /鳥の子紙/
とりはだ /鳥肌/
とりひき /取引/
とりひきじょ /取引所/
とりひきだかぜい /取引高税/
とりぶん /取り分/
とりほうだい /取り放題/
とりまえ /取り前/
とりみ /鳥見/
とりめ /鳥目/
とりもどしけん /取戻権/
とりもの /捕物/
とりものちょう /捕物帳/
とりや /鳥屋/
とりょう /塗料/斗量/
とりよせ /鳥寄せ/
とるこ /土耳古/
とれつ /堵列/
とろ /瀞/吐露/
とろいせき /登呂遺跡/
とろう /徒労/
とろび /とろ火/
とろん /徒論/
とわずがたり /問わず語り/
とわだ /十和田/
とわだこ /十和田湖/
とん /豚/頓/遁/敦/屯/噸/団/瓲/沌/惇/問/
とんえい /屯営/
とんきょう /頓狂/
とんぐう /頓宮/
とんこう /遁甲/敦煌/燉煌/
とんこつ /豚骨/
とんご /頓悟/
とんざ /頓挫/
とんし /頓死/
とんしゃ /豚舎/頓写/
とんしゅ /頓首/
とんしょ /屯所/
とんしょうぼだい /頓証菩提/
とんじ /遁辞/
とんじゃく /頓着/
とんせい /遁世/
とんそう /遁走/
とんぞく /遁俗/
とんだばやし /富田林/
とんち /頓知/頓智/
とんちゃく /頓着/
とんでん /屯田/
とんでんへい /屯田兵/
とんとんびょうし /とんとん拍子/
とんにく /豚肉/
とんび /鳶/
とんぷく /頓服/
とんぷくやく /頓服薬/
とんぼ /蜻蛉/
とんぼがえり /蜻蛉返り/
とんま /頓馬/
とんや /問屋/
ど /度/奴/土/怒/努/弩/駑/
ど> /度/
どあい /度合/
どあつ /土圧/
どい /土居/土井/
どいつ /独逸/何奴/
どう /道/動/導/同/銅/胴/童/洞/堂/働/如何/鐃/瞳/撞/憧/
どう> /同/
どうあげ /胴上げ/
どうい /同意/同位/胴衣/
どういかく /同位角/
どういげんそ /同位元素/
どういご /同意語/
どういたい /同位体/
どういつ /同一/
どういつし /同一視/
どういつせい /同一性/
どういん /動員/動因/導引/
どううら /胴裏/
どうおん /同音/
どうおんご /同音語/
どうか /同化/銅貨/道家/導火/道歌/
どうかく /同格/
どうかせん /導火線/
どうかそしき /同化組織/
どうかつ /恫喝/
どうかん /同感/導管/道管/道灌/
どうかんすう /導関数/
どうが /動画/童画/
どうがく /同額/道学/同学/
どうがしま /堂ヶ島/
どうがん /童顔/
どうき /同期/動機/動悸/銅器/同気/
どうきき /同期機/
どうきせい /同期生/
どうきづけ /動機付け/
どうきゅう /同級/撞球/
どうきょ /同居/
どうきょう /同郷/道教/道鏡/
どうきょにん /同居人/
どうきん /同衾/
どうぎ /同義/道義/動議/胴着/
どうぎかい /道議会/
どうぎご /同義語/
どうぎょう /同業/同行/童形/
どうぎょうしゃ /同業者/
どうくつ /洞窟/
どうくん /同君/
どうぐ /道具/
どうぐだて /道具立て/
どうぐばこ /道具箱/
どうぐや /道具屋/
どうけ /道化/道家/同家/
どうけい /同型/同形/同系/同慶/憧憬/
どうけし /道化師/
どうけつ /洞穴/
どうけん /同権/同県/洞見/
どうげつ /同月/
どうげん /同源/道元/
どうこ /銅壺/
どうこう /動向/瞳孔/同行/同好/同工/道幸/銅鉱/
どうこういきょく /同工異曲/
どうこうかい /同好会/
どうこうほう /道交法/
どうこく /同国/慟哭/
どうこん /同根/
どうご /同語/
どうごうきん /銅合金/
どうごおんせん /道後温泉/
どうごはんぷく /同語反復/
どうさ /動作/
どうさつ /洞察/
どうさん /動産/道産/
どうざ /同座/動座/
どうざい /同罪/
どうざん /銅山/
どうし /動詞/同士/同志/導師/道志/同旨/同視/道士/
どうししゃだいがく /同志社大学/
どうしつ /同室/同質/
どうして /如何して/
どうしゃ /同社/同車/
どうしゅ /同種/
どうしゅう /同舟/同臭/
どうしゅく /同宿/
どうしゅつ /導出/
どうしゅんてん /道春点/
どうしょ /同所/
どうしょう /同床/道床/
どうしょういむ /同床異夢/
どうしょく /同色/同職/
どうしょくぶつ /動植物/
どうしん /童心/同心/道心/
どうしんえん /同心円/
どうじ /同時/童子/同次/同字/
どうじつ /同日/
どうじつうやく /同時通訳/
どうじま /堂島/
どうじめ /胴締め/
どうじょ /童女/
どうじょう /同上/同乗/同情/道場/道上/堂上/
どうじょうじ /道成寺/
どうじょうやぶり /道場破り/
どうじろくおん /同時録音/
どうじん /同人/同仁/
どうじんし /同人誌/
どうじんしゃ /同人社/
どうすい /導水/
どうすう /同数/
どうせい /同姓/同性/同棲/銅製/動静/同声/
どうせいあい /同性愛/
どうせき /同席/
どうせん /導線/同船/銅線/動線/銅銭/
どうぜい /同勢/
どうぜん /同然/同前/
どうそ /同素/
どうそう /同窓/
どうそうかい /同窓会/
どうそじん /道祖神/
どうそたい /同素体/
どうぞう /銅像/
どうぞく /同族/道俗/同属/
どうぞくがいしゃ /同族会社/
どうたい /導体/動態/同体/胴体/動体/
どうたく /銅鐸/
どうだい /同大/
どうだん /道断/同断/満天星/
どうち /同値/同地/同治/
どうちかんけい /同値関係/
どうちゃく /撞着/同着/
どうちゅう /道中/
どうちゅうき /道中記/
どうちょう /同調/道庁/
どうちょうかいろ /同調回路/
どうちょうしゃ /同調者/
どうちょうとせつ /道聴塗説/
どうてい /同定/童貞/道程/
どうてき /動的/
どうてん /同点/動転/
どうとう /同等/同党/
どうとく /道徳/
どうとくきょういく /道徳教育/
どうとくしん /道徳心/
どうとくせい /道徳性/
どうとくてき /道徳的/
どうとくてつがく /道徳哲学/
どうとくほうそく /道徳法則/
どうとんぼり /道頓堀/
どうどう /堂々/同道/
どうなが /胴長/
どうなん /道南/
どうにゅう /導入/
どうにゅうぶ /導入部/
どうにょう /導尿/
どうにん /同人/
どうねん /同年/道念/
どうは /道破/
どうはい /同輩/
どうはん /同伴/
どうはんしゃ /同伴者/
どうばち /銅鉢/
どうばん /銅板/銅版/銅盤/
どうばんが /銅版画/
どうひつ /同筆/
どうひょう /道標/
どうびょう /同病/
どうふう /同封/同風/
どうふく /同腹/
どうふけん /道府県/
どうふけんぜい /道府県税/
どうふけんみんぜい /道府県民税/
どうぶち /胴縁/
どうぶつ /動物/
どうぶつえん /動物園/
どうぶつかい /動物界/
どうぶつがく /動物学/
どうぶつしつ /動物質/
どうぶつじっけん /動物実験/
どうぶつせい /動物性/
どうぶん /同文/
どうほう /同胞/同法/
どうほく /道北/
どうぼ /同母/
どうまき /胴巻/
どうまごえ /胴間声/
どうまさつ /動摩擦/
どうまわり /胴回り/
どうみゃく /動脈/
どうみゃくけつ /動脈血/
どうみゃくりゅう /動脈瘤/
どうみょう /同苗/
どうみょうじ /道明寺/
どうみょうじこ /道明寺粉/
どうめい /同名/同盟/
どうめいこく /同盟国/
どうめいし /動名詞/
どうめいひぎょう /同盟罷業/
どうもう /獰猛/童蒙/艟艨/
どうもく /瞠目/
どうもと /胴元/堂本/
どうもん /洞門/同門/
どうや /同夜/
どうやく /同役/
どうゆう /同友/同憂/
どうよう /同様/動揺/童謡/童幼/
どうらく /道楽/
どうらくもの /道楽者/
どうらん /動乱/胴乱/
どうり /道理/
どうりきがく /動力学/
どうりつ /同率/
どうりゅう /同流/
どうりょう /同僚/
どうりょく /動力/
どうりょくしゃ /動力車/
どうりょくろ /動力炉/
どうりん /動輪/
どうるい /同類/
どうるいこう /同類項/
どうれつ /同列/
どうろ /道路/
どうろこうつうほう /道路交通法/
どうろひょうしき /道路標識/
どうろひょうじ /道路標示/
どうわ /同和/童話/道話/
どうわきょういく /同和教育/
どかい /土塊/
どかた /土方/
どかゆき /どか雪/
どかん /土管/
どがい /度外/
どがいし /度外視/
どき /土器/怒気/度器/
どきょう /度胸/読経/
どぎも /度肝/
どく /毒/読/独/
どくあたり /毒中り/
どくえい /独泳/
どくえき /毒液/
どくえん /独演/
どくおう /独往/
どくが /毒牙/毒蛾/
どくがい /毒害/
どくがく /独学/
どくがん /独眼/
どくがんりゅう /独眼竜/
どくぎょ /毒魚/
どくぎん /独吟/
どくけ /毒気/
どくけし /毒消し/
どくご /読後/独語/
どくさい /独裁/
どくさいせいじ /独裁政治/
どくさつ /毒殺/
どくし /毒死/
どくしゃ /読者/
どくしゃそう /読者層/
どくしゅ /毒手/毒酒/
どくしゅう /独習/独修/
どくしょ /読書/
どくしょう /独唱/
どくしょさんとう /読書三到/
どくしょしゅうかん /読書週間/
どくしょじん /読書人/
どくしん /独身/
どくしんきぞく /独身貴族/
どくしんじゅつ /読心術/
どくじ /独自/
どくじゃ /毒蛇/
どくじゅ /読誦/
どくじん /毒刃/
どくず /読図/
どくせい /毒性/
どくせん /独占/独擅/毒腺/
どくせんきんしほう /独占禁止法/
どくせんじょう /独擅場/
どくぜつ /毒舌/
どくぜん /独善/
どくぜんしゅぎ /独善主義/
どくそ /毒素/
どくそう /独創/独奏/独走/毒草/
どくそうてき /独創的/
どくそん /独尊/
どくだん /独断/
どくだんじょう /独壇場/
どくだんせんこう /独断専行/
どくだんてき /独断的/
どくだんろん /独断論/
どくとく /独特/独得/
どくは /読破/
どくはく /独白/
どくひつ /毒筆/
どくふ /毒婦/
どくぶつ /毒物/
どくぶん /独文/
どくへび /毒蛇/
どくぼう /独房/
どくみ /毒見/
どくむし /毒虫/
どくや /毒矢/
どくやく /毒薬/
どくらく /独楽/
どくりつ /独立/
どくりつこく /独立国/
どくりつご /独立語/
どくりつせんげん /独立宣言/
どくりつどっぽ /独立独歩/
どくりつへんすう /独立変数/
どくりょう /読了/
どくりょく /独力/
どくろ /髑髏/
どくわ /独話/
どぐう /土偶/
どけん /土建/
どげざ /土下座/
どこ /何処/
どこう /土侯/土工/
どこそこ /何処其処/
どこんじょう /ど根性/
どごう /怒号/土豪/
どごうれっしん /土豪劣紳/
どさくさまぎれ /どさくさ紛れ/
どさまわり /どさ回り/
どさんこ /道産子/
どざえもん /土左衛門/
どしつ /土質/
どしゃ /土砂/
どしゃぶり /土砂降り/
どしょうまち /道修町/
どじょう /土壌/泥鰌/鰌/
どじん /土人/
どすう /度数/
どすうぶんぷ /度数分布/
どせい /土星/土製/怒声/
どせき /土石/
どせきりゅう /土石流/
どそう /土葬/土倉/
どそく /土足/
どぞう /土蔵/
どぞく /土俗/
どたんば /土壇場/
どだい /土台/土代/
どだん /土壇/
どちゃく /土着/
どちゅう /土中/
どちょう /怒張/
どちら /何方/
どっか /読過/
どっかい /読解/読会/
どっき /毒気/
どっきょ /独居/
どっきょう /読経/
どっきんほう /独禁法/
どっけ /毒気/
どっこう /独行/
どっこうせん /独航船/
どっち /何方/
どっぽ /独歩/
どて /土手/
どてっぱら /土手っ腹/
どてら /褞袍/
どとう /怒濤/
どどいつ /都々逸/
どどめ /土留め/
どなた /何方/
どなべ /土鍋/
どにち /土日/
どの /殿/
どのう /土嚢/
どはずれ /度外れ/
どはつ /怒髪/
どば /土場/駑馬/
どばし /土橋/
どばと /土鳩/
どひ /土肥/奴婢/
どひょう /土俵/
どひょういり /土俵入/
どひょうぎわ /土俵際/
どひょうば /土俵場/
どびん /土瓶/
どびんむし /土瓶蒸し/
どふん /土墳/
どぶ /溝/
どぶいた /溝板/
どぶろ /土風炉/
どぶろく /濁醪/濁酒/
どべい /土塀/
どぼく /土木/奴僕/
どぼくこうじ /土木工事/
どま /土間/
どまんなか /ど真ん中/
どみん /土民/
ども /共/吃/
どもり /土盛り/度盛り/
どもん /土門/
どよう /土曜/土用/
どようび /土曜日/
どら /銅鑼/
どらむすこ /どら息子/
どりょう /度量/
どりょうこう /度量衡/
どりょく /努力/
どるい /土塁/
どれい /奴隷/土鈴/
どれいかいほう /奴隷解放/
どろ /泥/
どろうみ /泥海/
どろえ /泥絵/
どろじあい /泥仕合/
どろた /泥田/
どろつち /泥土/
どろなわ /泥縄/
どろぬま /泥沼/
どろぼう /泥棒/
どろぼうねこ /泥棒猫/
どろみず /泥水/
どろみち /泥道/
どろよけ /泥除け/
どろんこ /泥んこ/
どわすれ /度忘れ/
どん /鈍/曇/呑/丼/貪/
どんか /鈍化/
どんかく /鈍角/
どんかん /鈍感/
どんき /鈍器/
どんぐり /団栗/
どんこう /鈍行/
どんこん /鈍根/
どんさい /鈍才/
どんしょく /貪食/
どんじゅう /鈍重/
どんじり /どん尻/
どんす /緞子/
どんそく /鈍足/
どんぞこ /どん底/
どんちょう /緞帳/
どんつう /鈍痛/
どんづまり /どん詰り/
どんてん /曇天/
どんでんがえし /どんでん返し/
どんと /呑吐/
どんとう /鈍刀/
どんぶつ /鈍物/
どんぶり /丼/
どんま /鈍磨/鈍麻/
どんよく /貪欲/
どんらん /貪婪/曇鸞/
な /名/菜/納/儺/無/那/奈/南/
なあて /名宛/
ない /内/
ない> /内/
ないい /内意/
ないいん /内因/内院/
ないえつ /内謁/内閲/
ないえん /内縁/内苑/
ないおう /内応/内奥/
ないか /内科/
ないかい /内界/内科医/内海/
ないかく /内閣/内角/
ないかくかんぼう /内閣官房/
ないかくぶんこ /内閣文庫/
ないかひ /内果皮/
ないかん /内患/内観/
ないがい /内外/
ないがしろ /蔑ろ/
ないき /内記/内規/
ないきょく /内局/
ないきん /内勤/
ないぎ /内儀/
ないくん /内訓/
ないけい /内径/
ないけん /内見/
ないこう /内向/内攻/内訌/
ないこうしょう /内交渉/
ないこうせい /内向性/
ないこく /内国/
ないこくかいしゃ /内国会社/
ないこくさい /内国債/
ないさい /内妻/内済/
ないざい /内在/
ないし /乃至/内侍/
ないしきょう /内視鏡/
ないしつ /内室/
ないしゃく /内借/
ないしゅう /内周/
ないしゅうげん /内祝言/
ないしゅっけつ /内出血/
ないしょ /内緒/
ないしょう /内証/内相/
ないしょく /内職/
ないしょばなし /内緒話/
ないしん /内心/内申/内診/
ないしんしょ /内申書/
ないしんのう /内親王/
ないじ /内示/内耳/
ないじつ /内実/
ないじゅ /内需/
ないじょ /内助/
ないじょう /内情/
ないじん /内陣/
ないせい /内省/内政/内生/
ないせいかんしょう /内政干渉/
ないせき /内積/
ないせつ /内接/
ないせつえん /内接円/
ないせん /内線/内戦/
ないぜん /内膳/
ないそう /内装/内層/内争/内奏/
ないそうほう /内挿法/
ないそく /内則/
ないぞう /内蔵/内臓/
ないたい /内帯/
ないたつ /内達/
ないだい /内題/
ないだいじん /内大臣/
ないだく /内諾/
ないだん /内談/
ないち /内地/内治/
ないつう /内通/
ないてい /内定/内偵/内庭/
ないていひ /内廷費/
ないてき /内的/
ないてん /内典/
ないとう /内藤/
ないどう /内道;内法,⇔外道,外法/
ないない /内々/
ないにゅう /内乳/
ないねんき /内燃機/
ないねんきかん /内燃機関/
ないはいよう /内胚葉/
ないひ /内皮/
ないふ /内府/
ないふく /内服/
ないふん /内紛/
ないぶ /内部/
ないぶていこう /内部抵抗/
ないぶりゅうほ /内部留保/
ないぶん /内聞/内分/
ないぶんぴ /内分泌/
ないぶんぴつ /内分泌/
ないへき /内壁/
ないほう /内包/内方/内報/内法;内道,⇔外法,外道/
ないまく /内幕/
ないまぜ /綯い交ぜ/
ないみつ /内密/
ないむ /内務/
ないむしょう /内務省/
ないむだいじん /内務大臣/
ないめい /内命/
ないめん /内面/
ないめんてき /内面的/
ないもうこ /内蒙古/
ないや /内野/
ないやく /内約/
ないやしゅ /内野手/
ないゆう /内憂/
ないゆうがいかん /内憂外患/
ないよう /内容/内用/
ないようしょうめい /内容証明/
ないらん /内乱/内覧/
ないらんざい /内乱罪/
ないりく /内陸/
ないりょく /内力/
ないりん /内輪/
ないりんざん /内輪山/
ないわくせい /内惑星/
なうて /名うて/
なえ /苗/
なえいろ /苗色/
なえぎ /苗木/
なえしろ /苗代/
なえどこ /苗床/
なえま /苗間/
なお /直/猶/尚/
なおえ /直江/
なおえつ /直江津/
なおき /直木/
なおきしょう /直木賞/
なおさら /尚更/
なおざり /等閑/
なおし /直し/
なおしま /直島/
なおれ /名折れ/
なか /中/那珂/仲/
なかい /中井/仲居/中居/
なかいり /中入/
なかうみ /中海/
なかえ /中江/
なかえちょうみん /中江兆民/
なかおか /中岡/
なかおく /中奥/
なかおち /中落ち/
なかおもて /中表/
なかがい /仲買/
なかがき /中垣/
なかがわ /中川/那賀川/那珂川/
なかぎょう /中京/
なかぎり /中限/
なかくぎ /中釘/
なかぐち /中口/
なかぐろ /中黒/
なかこ /仲子/
なかご /中心/中子/
なかごろ /中頃/
なかざ /中座/
なかし /仲仕/
なかじめ /中締め/
なかす /中洲/中州/
なかすぎ /中杉/
なかず /中洲/
なかずみ /中澄/
なかせんどう /中山道/中仙道/
なかぞら /中空/
なかたがい /仲違い/
なかだ /中田/
なかだか /中高/
なかだち /中立/媒/仲立/
なかだちえいぎょう /仲立営業/
なかだちにん /仲立人/
なかだるみ /中弛み/
なかちょう /仲町/
なかつ /中津/
なかつか /中塚/
なかつかさ /中務/
なかつがわ /中津川/
なかつぎ /中継ぎ/
なかつくに /中つ国/
なかづり /中吊り/
なかて /中手/
なかてん /中点/
なかとじ /中綴じ/
なかど /中戸/
なかなか /中々/中中/
なかにし /中西/
なかにも /中にも/
なかにわ /中庭/
なかぬり /中塗り/
なかね /中根/中値/
なかの /中野/
なかのちょう /仲之町/
なかはし /中橋/
なかはま /中浜/
なかはらちゅうや /中原中也/
なかば /半ば/
なかばやし /中林/
なかばん /中番/
なかび /中日/
なかびしゃ /中飛車/
なかほど /中程/
なかま /仲間/中間/
なかまいり /仲間入り/
なかまく /中幕/
なかまどうし /仲間同士/
なかまはずれ /仲間外れ/
なかまわれ /仲間割れ/
なかみ /中身/中味/
なかみかど /中御門/
なかみせ /仲見世/
なかみち /中道/
なかみなと /那珂湊/
なかむら /中村/
なかむらや /中村屋/
なかやしき /中屋敷/
なかやすみ /中休み/
なかやま /中山/
なかゆび /中指/
なかよし /仲良し/
なかれ /莫れ/勿れ/毋れ/
なかわた /中綿/
なかんずく /就中/
なが /長/永/
ながあめ /長雨/
ながい /永井/長井/長居/
ながいかふう /永井荷風/
ながいき /長生き/
ながいす /長椅子/
ながいた /長板/
ながうた /長唄/長歌/
ながえ /長柄/轅/
ながお /長尾/
ながおい /長追い/
ながおか /長岡/
ながおかきょう /長岡京/
ながくて /長久手/
ながくぼ /長久保/
ながくら /長倉/
ながぐつ /長靴/
ながごと /長言/
ながさ /長さ/
ながさき /長崎/
ながさきけん /長崎県/
ながさきし /長崎市/
ながさきだいがく /長崎大学/
ながさきほんせん /長崎本線/
ながさわ /長沢/
ながしかく /長四角/
ながしずき /流し漉き/
ながしだい /流し台/
ながしの /長篠/
ながしめ /流し目/
ながそで /長袖/
ながた /永田/長田/
ながたちょう /永田町/
ながたび /長旅/
ながだんぎ /長談義/
ながちょうば /長丁場/
ながっちり /長っ尻/
ながつか /長塚/
ながつき /長月/
ながつづき /長続き/永続き/
ながて /長手/
ながと /長門/
ながとの /長殿/
ながとろ /長瀞/
ながなが /長々/
ながねぎ /長葱/
ながねん /長年/永年/
ながの /長野/永野/
ながのけん /長野県/
ながのし /長野市/
ながはし /長橋/
ながはま /長浜/
ながばかま /長袴/
ながばなし /長話/
ながひと /長人/
ながひばち /長火鉢/
ながみち /長道/
ながみつ /長光/
ながめ /眺め/
ながもち /長持/
ながもちうた /長持唄/
ながや /長屋/
ながやおう /長屋王/
ながやみ /長病み/
ながゆ /長湯/
ながよ /長与/
ながよし /長吉/
ながら /乍/
ながらがわ /長良川/
ながらく /長らく/
ながれ /流れ/
ながれず /流れ図/
ながれぼし /流れ星/
ながれもの /流れ者/
ながれや /流れ矢/
ながれやま /流山/
ながわずらい /長患い/
なき /泣き/亡き/
なきおとし /泣落し/
なきがお /泣き顔/
なきがら /亡骸/
なきごえ /鳴き声/泣き声/
なきごと /泣き言/
なきじょうご /泣き上戸/
なきっつら /泣きっ面/
なきつら /泣き面/
なきどころ /泣き所/
なきねいり /泣き寝入り/
なきべそ /泣きべそ/
なきむし /泣き虫/
なきり /菜切り/
なきわかれ /泣き別れ/
なきわらい /泣き笑い/
なぎ /凪/薙/梛/
なぎさ /渚/
なぎなた /長刀/薙刀/
なぎょう /ナ行/
なくなく /泣く泣く/
なぐ /薙/
なぐさ /慰/
なぐさみもの /慰み物/
なぐさめ /慰め/
なぐさめがお /慰め顔/
なげ /投げ/無げ/
なげうり /投売り/
なげし /長押/
なげづり /投げ釣り/
なげなわ /投げ縄/
なげやり /投げ遣り/投槍/
なこうど /仲人/
なこうどぐち /仲人口/
なご /名護/名子/
なごや /名古屋/名護屋/
なごやか /和やか/
なごやし /名古屋市/
なごやじょう /名古屋城/
なごやだいがく /名古屋大学/
なごり /名残/
なごん /納言/
なさけ /情け/
なさけしらず /情け知らず/
なさぬなか /生さぬ仲/
なざし /名指し/
なし /梨/無し/
なしくずし /済し崩し/
なしじ /梨子地/
なじみ /馴染/
なす /那須/茄子/
なすこん /茄子紺/
なすの /那須野/
なすび /茄子/茄/
なずな /薺/
なぜ /何故/名瀬/
なぜなら /何故なら/
なぞ /謎/
なぞとき /謎解き/
なた /鉈/
なたね /菜種/
なだ /灘/
なだい /名代/名題/
なだいやくしゃ /名題役者/
なだたる /名立たる/
なだれ /雪崩/
なち /那智/
なっ /納/
なっせん /捺染/
なっとう /納豆/
なっとうきん /納豆菌/
なっとく /納得/
なっぱ /菜っ葉/
なつ /夏/捺/
なついん /捺印/
なつか /長束/
なつかぜ /夏風邪/
なつがれ /夏枯れ/
なつぎ /夏着/
なつくさ /夏草/
なつぐも /夏雲/
なつげ /夏毛/
なつごろも /夏衣/
なつさく /夏作/
なつじかん /夏時間/
なつどり /夏鳥/
なつの /夏野/
なつば /夏場/
なつばおり /夏羽織/
なつばしょ /夏場所/
なつばて /夏ばて/
なつび /夏日/
なつふく /夏服/
なつまけ /夏負け/
なつまつり /夏祭/
なつみかん /夏蜜柑/
なつむき /夏向き/
なつめ /夏目/棗/
なつめそうせき /夏目漱石/
なつもの /夏物/
なつやすみ /夏休み/
なつやせ /夏痩せ/
なつやま /夏山/
なづけ /名付け/
なづけおや /名付け親/
なでがた /撫で肩/
なでしこ /撫子/
なとり /名取/
など /等/
などころ /名所/
なな /七/
なないろ /七色/
ななえ /七重/
ななお /七尾/
ななくさ /七草/
ななころびやおき /七転び八起き/
ななし /名無し/
ななせ /七瀬/
ななそ /七十/
ななそじ /七十路/
ななたび /七度/
ななつ /七つ/
ななつぼし /七つ星/
ななひかり /七光/
ななふしぎ /七不思議/
ななまがり /七曲り/
ななめ /斜め/
なに /何/
なにか /何か/
なにかと /何彼と/
なにがし /某/何某/
なにごと /何事/
なにさま /何様/
なにしろ /何しろ/
なにせ /何せ/
なにとぞ /何卒/
なになに /何々/何何/
なにはさておき /何は扨措き/
なにびと /何人/
なにぶん /何分/
なにほど /何程/
なにも /何も/
なにもの /何者/何物/
なにやつ /何奴/
なにゆえ /何故/
なにわ /浪花/浪速/難波/
なにわぶし /浪花節/
なぬか /七日/
なぬし /名主/
なの /七/
なのか /七日/
なのはな /菜の花/
なは /那覇/
なはし /那覇市/
なばり /名張/
なふだ /名札/
なへん /奈辺/那辺/ナ変/
なべ /鍋/
なべしま /鍋島/
なべぞこ /鍋底/
なべた /鍋田/
なべて /並べて/
なべぶぎょう /鍋奉行/
なべぶた /鍋蓋/
なべもの /鍋物/
なべやき /鍋焼/
なま /生/
なまあげ /生揚げ/
なまいき /生意気/
なまえ /名前/
なまえまけ /名前負け/
なまえんそう /生演奏/
なまおぼえ /生覚え/
なまかべ /生壁/
なまかべいろ /生壁色/
なまかわ /生皮/
なまがし /生菓子/
なまがわき /生乾き/
なまき /生木/
なまくび /生首/
なまくら /鈍/
なまぐさ /生臭/
なまぐさぼうず /生臭坊主/
なまけぐせ /怠け癖/
なまけもの /怠け者/
なまこ /海鼠/
なまごめ /生米/
なまごろし /生殺し/
なまざかな /生魚/
なます /膾/鱠/
なまず /鯰/癜/
なまたまご /生卵/
なまち /生血/
なまちゅうけい /生中継/
なまつば /生唾/
なまづめ /生爪/
なまなま /生生/生々/
なまにえ /生煮え/
なまにく /生肉/
なまはんか /生半可/
なまびょうほう /生兵法/
なまふ /生麩/
なまへんじ /生返事/
なまほうそう /生放送/
なまぼし /生乾し/
なまみ /生身/
なまみず /生水/
なまみそ /生味噌/
なまむぎ /生麦/
なまもの /生物/
なまやけ /生焼け/
なまよい /生酔い/
なまり /鉛/訛/
なまりいろ /鉛色/
なみ /並/浪/波/〜/
なみあし /並足/
なみうちぎわ /波打際/
なみおと /波音/
なみかぜ /波風/
なみかわ /並河/
なみがしら /波頭/
なみがた /波形/
なみき /並木/
なみじ /波路/
なみせい /並製/
なみたいてい /並大抵/
なみだ /涙/泪/
なみだがお /涙顔/
なみだきん /涙金/
なみだごえ /涙声/
なみとう /並等/
なみなみ /並々/
なみのり /波乗り/
なみはずれ /並外れ/
なみはば /並幅/
なみひととおり /並一通り/
なみま /波間/
なみまくら /波枕/
なみまつ /並松/
なみよけ /波除け/
なむ /南無/
なむあみだぶつ /南無阿弥陀仏/
なむさん /南無三/
なめ /滑/嘗/
なめくじ /蛞蝓/
なめこ /滑子/
なめし /菜飯/
なめらか /滑らか/
なめりかわ /滑川/
なや /納屋/
なやみ /悩み/
なゆた /那由多/那由他/
なよせ /名寄せ/
なよたけ /弱竹/
なよろ /名寄/
なら /奈良/楢/柞/枹/
ならい /奈良井/
ならいごと /習い事/
ならいしょう /習い性/
ならえ /奈良絵/
ならえほん /奈良絵本/
ならく /奈落/
ならけん /奈良県/
ならし /奈良市/
ならしの /習志野/
ならじだい /奈良時代/
ならじょしだいがく /奈良女子大学/
ならずもの /ならず者/
ならづけ /奈良漬/
ならび /並び/
ならびに /並びに/
ならべ /並べ/
ならわし /習わし/
なり /鳴り/形/
なりあい /成合/
なりあいじ /成相寺/
なりきん /成金/
なりこま /成駒/
なりた /成田/
なりたち /成立ち/
なりたや /成田屋/
なりひら /業平/
なりゆき /成行き/
なりゆきちゅうもん /成行き注文/
なりわい /生業/
なる /成/
なるかみ /鳴神/
なるこ /鳴子/
なるさわ /鳴沢/
なるしま /成島/
なるせ /成瀬/
なると /鳴門/鳴戸/
なるべく /成る可く/
なるほど /成程/
なるみ /鳴海/
なれ /慣れ/熟れ/
なれずし /熟鮨/
なれのはて /成れの果/
なわ /縄/名和/苗/
なわしろ /苗代/
なわしろだ /苗代田/
なわて /畷/縄手/
なわのれん /縄暖簾/
なわばしご /縄梯子/
なわばり /縄張/
なわめ /縄目/
なん /何/難/南/軟/男/納/楠/
なん> /何/
なんあ /南ア/
なんい /難易/南緯/
なんいど /難易度/
なんおう /南欧/
なんか /南下/軟化/
なんかい /南海/難解/何回/
なんかん /難関/
なんき /南紀/
なんきつ /難詰/
なんきゅう /軟球/
なんきょう /難境/
なんきょく /南極/難局/難曲/
なんきょくかい /南極海/
なんきょくけん /南極圏/
なんきょくたいりく /南極大陸/
なんきん /南京/軟禁/
なんきんじけん /南京事件/
なんきんじょう /南京錠/
なんきんむし /南京虫/
なんぎ /難儀/
なんぎょう /難行/難業/
なんぎょうくぎょう /難行苦行/
なんくせ /難癖/
なんくん /難訓/
なんけ /南家/
なんけん /難件/
なんこ /何個/
なんこう /難航/軟膏/楠公/軟鋼/
なんこうがい /軟口蓋/
なんこうふらく /難攻不落/
なんこく /南国/
なんこつ /軟骨/
なんご /喃語/難語/
なんごく /南国/
なんざん /南山/難産/
なんし /男子/
なんしき /軟式/
なんしつ /軟質/
なんしょ /難所/
なんしょう /南昌/難症/
なんしょく /難色/男色/
なんじ /汝/爾/難事/難字/難治/何時/
なんじゃく /軟弱/
なんじゅう /難渋/
なんじょう /南条/
なんすい /軟水/
なんせい /南西/軟性/
なんせいげかん /軟性下疳/
なんせいしょとう /南西諸島/
なんせん /難船/
なんせんほくば /南船北馬/
なんぜんじ /南禅寺/
なんそう /南総/南宋/
なんたい /男体/
なんたいさん /男体山/
なんたいどうぶつ /軟体動物/
なんたる /何たる/
なんたん /南端/
なんだい /難題/
なんだいもん /南大門/
なんだか /何だか/
なんち /難治/
なんちゃくりく /軟着陸/
なんちゅう /南中/
なんちょう /難聴/軟調/南朝/
なんて /何て/
なんてき /難敵/
なんてつ /軟鉄/
なんてん /難点/南天/
なんでも /何でも/
なんでもや /何でも屋/
なんと /何と/南都/
なんとう /南東/南島/
なんとか /何とか/
なんとなれば /何となれば/
なんとほくれい /南都北嶺/
なんど /何度/難度/納戸/
なんどいろ /納戸色/
なんどき /何時/
なんどく /難読/
なんなく /難無く/
なんなんせい /南南西/
なんなんとう /南南東/
なんにち /何日/
なんにょ /男女/
なんにん /何人/
なんねい /南寧/
なんねん /難燃/何年/
なんの /何の/
なんば /難波/難場/
なんばら /南原/
なんばん /南蛮/
なんばんじん /南蛮人/
なんぱ /軟派/難破/
なんびょう /難病/
なんぴと /何人/
なんぴょうよう /南氷洋/
なんぶ /南部/
なんぶせん /南武線/
なんぶつ /難物/
なんぶん /難文/
なんぷう /南風/軟風/
なんべい /南米/
なんべん /何遍/軟便/
なんぼく /南北/
なんぼくせんそう /南北戦争/
なんぼくちょう /南北朝/
なんぼくもんだい /南北問題/
なんぽう /南方/
なんみん /難民/
なんみんじょうやく /難民条約/
なんめん /南面/
なんもん /難問/
なんやく /難役/
なんよう /南陽/南洋/
なんら /何等/
なんらか /何らか/
なんろ /難路/
に /二/荷/仁/児/尼/弐/煮/丹/迩/
にあげ /荷揚げ/
にあし /荷足/
にい /新/
にいがた /新潟/
にいがたけん /新潟県/
にいがたし /新潟市/
にいがただいがく /新潟大学/
にいさと /新里/
にいさん /兄さん/
にいざ /新座/
にいじま /新島/
にいつ /新津/
にいづま /新妻/
にいはま /新居浜/
にいぼん /新盆/
にいみ /新美/新見/
にいんせい /二院制/
にうけ /荷受/
にうけにん /荷受人/
にうごき /荷動き/
にうま /荷馬/
にえ /贄/錵/煮え/
にえゆ /煮え湯/
にお /鳰/
におい /匂/荷負/
においぶくろ /匂袋/
におう /仁王/
におうだち /仁王立ち/
におうみや /匂宮/
におくりにん /荷送人/
におやか /匂やか/
におろし /荷卸し/荷下ろし/
にかい /二階/
にかわ /膠/
にがお /似顔/
にがおえ /似顔絵/
にがき /苦木/
にがたけ /苦竹/
にがつ /二月/
にがつち /苦土/
にがて /苦手/
にがびゃくどう /二河白道/
にがみ /苦み/
にがむし /苦虫/
にがわせ /荷為替/
にがわらい /苦笑い/
にき /仁木/
にきさく /二期作/
にきび /面皰/
にきゅう /二級/
にきょく /二曲/二極/
にぎてき /二義的/
にぎやか /賑やか/
にぎりずし /握り鮨/
にく /肉/
にくいろ /肉色/
にくかい /肉塊/
にくが /肉芽/
にくがん /肉眼/
にくぎゅう /肉牛/
にくけい /肉桂/
にくしつ /肉質/
にくしみ /憎しみ/
にくしゅ /肉腫/
にくしょく /肉食/
にくしょくせい /肉食性/
にくしょくどうぶつ /肉食動物/
にくしん /肉親/
にくじき /肉食/
にくじきさいたい /肉食妻帯/
にくじゅう /肉汁/
にくすいかじょ /肉穂花序/
にくずれ /荷崩れ/
にくせい /肉声/
にくたい /肉体/
にくたいかんけい /肉体関係/
にくたいてき /肉体的/
にくたいろうどう /肉体労働/
にくだん /肉弾/
にくづき /肉付き/
にくづけ /肉付け/
にくはく /肉迫/肉薄/
にくばなれ /肉離れ/
にくひつ /肉筆/
にくふん /肉粉/
にくぶと /肉太/
にくへん /肉片/
にくぼそ /肉細/
にくまれぐち /憎まれ口/
にくまれっこ /憎まれっ子/
にくまれやく /憎まれ役/
にくや /肉屋/
にくよく /肉欲/
にくるい /肉類/
にぐるま /荷車/
にげ /逃げ/
にげあし /逃げ足/
にげこうじょう /逃げ口上/
にげごし /逃げ腰/
にげじたく /逃げ支度/
にげば /逃げ場/
にげみず /逃げ水/
にげみち /逃げ道/
にげん /二元/
にげんろん /二元論/
にこ /二胡/
にこう /二項/
にこうていり /二項定理/
にこげ /和毛/
にこみ /煮込み/
にころがし /煮転がし/
にごう /二号/二合/
にごしらえ /荷拵え/
にごりざけ /濁り酒/
にごん /二言/
にさん /二三/
にさんか /二酸化/
にさんかいおう /二酸化硫黄/
にさんかたんそ /二酸化炭素/
にさんかちっそ /二酸化窒素/
にざかな /煮魚/
にし /西/螺/
にしあまね /西周/
にしお /西尾/
にしおおたに /西大谷/
にしかぜ /西風/
にしかわ /西川/
にしがわ /西側/
にしき /錦/
にしきえ /錦絵/
にしきごい /錦鯉/
にしきた /西北/
にしきのみはた /錦の御旗/
にしざわ /西沢/
にしじん /西陣/
にしじんおり /西陣織/
にしだ /西田/
にしな /仁科/
にしにほん /西日本/
にしにほんしんぶん /西日本新聞/
にしのうち /西の内/
にしのおもて /西之表/
にしのきょう /西の京/
にしのみや /西宮/
にしはんきゅう /西半球/
にしび /西日/
にしみなみ /西南/
にしむき /西向き/
にしむら /西村/
にしゃ /二者/
にしゃせんいつ /二者選一/
にしゃたくいつ /二者択一/
にしやま /西山/
にしょうがくしゃ /二松学舎/
にしわき /西脇/
にしん /二審/鯡/二伸/鰊/
にしんとう /二親等/
にしんほう /二進法/
にじ /虹/二次/二字/尼寺/
にじかい /二次会/
にじかんせん /二次感染/
にじきょくせん /二次曲線/
にじげん /二次元/
にじっせいき /二十世紀/
にじてき /二次的/
にじでんち /二次電池/
にじほうていしき /二次方程式/
にじます /虹鱒/
にじゅう /二重/廿/
にじゅうあご /二重顎/
にじゅういっし /二十一史/
にじゅううつし /二重写し/
にじゅうこうぞう /二重構造/
にじゅうこくせき /二重国籍/
にじゅうしせっき /二十四節気/
にじゅうしょう /二重唱/
にじゅうじんかく /二重人格/
にじゅうそう /二重奏/
にじゅうばし /二重橋/
にじゅうぼいん /二重母音/
にじゅうまる /二重丸/
にじょう /二乗/二条/
にじょうき /二畳紀/
にじょうじょう /二条城/
にじる /煮汁/
にじるし /荷印/
にすがた /荷姿/
にせ /偽/贋/
にせい /二世/
にせさつ /偽札/
にせもの /偽物/贋物/偽者/
にせんえん /二千円/
にせんえんさつ /二千円札/
にそう /尼僧/
にそく /二足/
にそくさんもん /二束三文/
にたき /煮炊き/
にたもの /似た者/
にたやま /仁田山/
にたりよったり /似たり寄ったり/
にだい /荷台/
にだん /二段/
にだんめ /二段目/
にち /日/
にちいき /日域/
にちえい /日英/
にちぎん /日銀/
にちげん /日限/
にちじ /日時/日次/
にちじょう /日常/
にちじょうさはん /日常茶飯/
にちじょうさはんじ /日常茶飯事/
にちなん /日南/
にちなんかいがん /日南海岸/
にちにち /日々/
にちぶ /日舞/
にちべい /日米/
にちぼつ /日没/
にちや /日夜/
にちょうなげ /二丁投げ/
にちよう /日曜/日用/
にちようだいく /日曜大工/
にちようひん /日用品/
にちようび /日曜日/
にちりん /日輪/
にちれん /日蓮/
にちれんしゅう /日蓮宗/
にちろ /日露/
にちろく /日録/
にちろせんそう /日露戦争/
にっか /日課/日華/日貨/
にっかじへん /日華事変/
にっかん /日刊/日韓/
にっかんじょうやく /日韓条約/
にっき /日記/
にっきちょう /日記帳/
にっきゅう /日給/
にっきん /日勤/
にっけい /日系/日計/肉桂/日経/
にっけいひょう /日計表/
にっけいれん /日経連/
にっこう /日光/日興/
にっこうよく /日光浴/
にっさん /日産/日参/
にっし /日誌/
にっしゃ /日射/
にっしゃびょう /日射病/
にっしゅう /日収/日周/
にっしゅつ /日出/
にっしょう /日商/日照/日章/
にっしょうき /日章旗/
にっしょうけん /日照権/
にっしょく /日食/日蝕/
にっしん /日清/日新/日進/
にっしんげっぽ /日進月歩/
にっしんせんそう /日清戦争/
にっすう /日数/
にっせい /日精/
にっせき /日赤/日夕/
にっそ /日ソ/
にった /新田/仁田/
にっちゅう /日中/
にっちゅうせんそう /日中戦争/
にっちょう /日朝/
にっちょく /日直/
にってい /日程/
にってん /日展/
にっとう /日当/日東/入唐/
にっぽう /日報/日豊/
にっぽうほんせん /日豊本線/
にっぽじしょ /日葡辞書/
にっぽん /日本/
にっぽんいち /日本一/
にっぽんばし /日本橋/
にづくり /荷造り/
にづみ /荷積み/
にと /二兎/二途/
にとう /二等/二頭/
にとうしゃ /二等車/
にとうだて /二頭立て/
にとうぶん /二等分/
にとうへい /二等兵/
にとうりゅう /二刀流/
にとべ /新渡戸/
にとものがたり /二都物語/
にど /二度/
にどざき /二度咲き/
にどでま /二度手間/
にな /蜷/
にないて /担い手/
にながわ /蜷川/
ににんさんきゃく /二人三脚/
ににんしょう /二人称/
にぬき /煮抜き/
にぬし /荷主/
にのあし /二の足/
にのうで /二の腕/
にのく /二の句/
にのつぎ /二の次/
にのへ /二戸/
にのまい /二の舞/
にのまる /二の丸/
にのみや /二宮/二の宮/
にのや /二の矢/
にはいず /二杯酢/
にばしゃ /荷馬車/
にばん /二番/
にばんかん /二番館/
にばんせんじ /二番煎じ/
にばんめ /二番目/
にびいろ /鈍色/
にふ /二夫/
にふだ /荷札/
にぶさく /二部作/
にぶん /二分/
にぶんほう /二分法/
にほん /日本/二本/
にほんいかだいがく /日本医科大学/
にほんいくえいかい /日本育英会/
にほんかい /日本海/
にほんかいかいせん /日本海海戦/
にほんかいこう /日本海溝/
にほんが /日本画/
にほんがくしいん /日本学士院/
にほんがみ /日本髪/
にほんがわ /日本側/
にほんきいん /日本棋院/
にほんぎんこう /日本銀行/
にほんけいざいしんぶん /日本経済新聞/
にほんけん /日本犬/
にほんこくけんぽう /日本国憲法/
にほんご /日本語/
にほんごか /日本語化/
にほんごにゅうりょく /日本語入力/
にほんざし /二本差し/
にほんざる /日本猿/
にほんしゃかいとう /日本社会党/
にほんしゅ /日本酒/
にほんしょき /日本書紀/
にほんじかん /日本時間/
にほんじん /日本人/
にほんだいがく /日本大学/
にほんだいら /日本平/
にほんづつみ /日本堤/
にほんとう /日本刀/
にほんのうえん /日本脳炎/
にほんばし /日本橋/
にほんぶよう /日本舞踊/
にほんま /日本間/
にほんまい /日本米/
にほんまち /日本町/
にほんまつ /二本松/
にほんりょうり /日本料理/
にほんれっとう /日本列島/
にぼし /煮干し/
にまい /二枚/
にまいがい /二枚貝/
にまいがさね /二枚重ね/
にまいげり /二枚蹴り/
にまいごし /二枚腰/
にまいじた /二枚舌/
にまいめ /二枚目/
にまめ /煮豆/
にもうさく /二毛作/
にもつ /荷物/
にもの /煮物/
にゃく /若/
にやく /荷役/
にやっかい /荷厄介/
にゅーじーらんど /新西蘭/
にゅーよーく /紐育/
にゅう /入/乳/柔/
にゅういん /入院/
にゅういんりょう /乳飲料/
にゅうえい /入営/
にゅうえき /乳液/
にゅうえん /入園/
にゅうか /入荷/乳化/
にゅうかい /入会/
にゅうかく /入閣/
にゅうかざい /乳化剤/
にゅうかん /乳管/入棺/
にゅうがく /入学/
にゅうがくきん /入学金/
にゅうがくしき /入学式/
にゅうがん /乳癌/
にゅうきょ /入居/入渠/
にゅうきょう /入鋏/入京/
にゅうきん /入金/
にゅうぎゅう /乳牛/
にゅうぎょ /入漁/入御/
にゅうぎょう /乳業/
にゅうぎょく /入玉/
にゅうこ /入庫/
にゅうこう /入港/入校/入坑/入貢/
にゅうこうりょう /入港料/
にゅうこく /入国/
にゅうこん /入魂/
にゅうごく /入獄/
にゅうさつ /入札/
にゅうさん /乳酸/
にゅうさんきん /乳酸菌/
にゅうざい /乳剤/
にゅうざん /入山/
にゅうし /入試/乳歯/
にゅうしち /入質/
にゅうしつ /入室/
にゅうしぼう /乳脂肪/
にゅうしゃ /入社/入射/入舎/
にゅうしゃかく /入射角/
にゅうしゃしき /入社式/
にゅうしゅ /入手/
にゅうしょ /入所/
にゅうしょう /入賞/
にゅうしょく /入植/
にゅうしん /入信/入神/
にゅうじ /乳児/
にゅうじゃく /柔弱/
にゅうじゅう /乳汁/
にゅうじゅく /入塾/
にゅうじょう /入場/乳状/入城/入定/
にゅうじょうぜい /入場税/
にゅうすい /入水/
にゅうせいひん /乳製品/
にゅうせき /入籍/
にゅうせん /入選/入船/乳腺/
にゅうたい /入隊/
にゅうだん /入団/
にゅうちょう /入超/入朝/
にゅうてい /入廷/
にゅうでん /入電/
にゅうとう /乳頭/入党/乳糖/入湯/
にゅうとうぜい /入湯税/
にゅうどう /入道/
にゅうどうぐも /入道雲/
にゅうない /入内/
にゅうねん /入念/
にゅうはくしょく /乳白色/
にゅうばい /入梅/
にゅうばち /乳鉢/
にゅうひ /入費/
にゅうふ /入夫/
にゅうふこんいん /入夫婚姻/
にゅうぶ /入部/
にゅうぼう /乳棒/乳房/
にゅうまく /入幕/
にゅうめつ /入滅/
にゅうもん /入門/
にゅうよう /入用/
にゅうようじ /乳幼児/
にゅうよく /入浴/
にゅうらい /入来/
にゅうらく /入洛/乳酪/
にゅうりょく /入力/
にゅうろう /入牢/
にゅうわ /柔和/
にょ /女/如/
にょい /如意/
にょいん /女院/
にょう /尿/女/繞/
にょうい /尿意/
にょういん /女院/
にょうかん /尿管/
にょうけっせき /尿結石/
にょうそ /尿素/
にょうどう /尿道/
にょうどうえん /尿道炎/
にょうどくしょう /尿毒症/
にょうぼう /女房/
にょうぼうやく /女房役/
にょうまく /尿膜/
にょうろけっせき /尿路結石/
にょかん /女官/
にょし /女子/
にょしょう /女性/
にょじつ /如実/
にょぜがもん /如是我聞/
にょたい /女体/
にょにん /女人/
にょほう /如法/
にょぼん /女犯/
にょらい /如来/
にら /韮/韭/
にらさき /韮崎/
にらみ /睨み/
にらみあい /睨み合い/
にらめっこ /睨めっこ/
にらやま /韮山/
にりつはいはん /二律背反/
にりゅう /二流/
にりん /二輪/
にりんしゃ /二輪車/
にるい /二塁/
にるいしゅ /二塁手/
にるいだ /二塁打/
にれ /楡/
にわ /庭/丹羽/
にわいし /庭石/
にわか /俄/
にわかあめ /俄雨/
にわき /庭木/
にわさき /庭先/
にわし /庭師/
にわとり /鶏/
にん /人/任/妊/忍/認/刃/仁/
にんい /任意/
にんいきてい /任意規定/
にんいしゅっとう /任意出頭/
にんいじゅんびきん /任意準備金/
にんいせいさん /任意清算/
にんいそうさ /任意捜査/
にんいだいり /任意代理/
にんいだんたい /任意団体/
にんいほけん /任意保険/
にんか /認可/
にんかん /任官/
にんがい /人界/人外/
にんき /人気/任期/
にんきょ /認許/
にんきょう /仁侠/任侠/
にんぎょ /人魚/
にんぎょう /人形/
にんぎょうげき /人形劇/
にんく /忍苦/人工/
にんげん /人間/
にんげんかい /人間界/
にんげんかんけい /人間関係/
にんげんがく /人間学/
にんげんぎらい /人間嫌い/
にんげんこうがく /人間工学/
にんげんこくほう /人間国宝/
にんげんせい /人間性/
にんげんぞう /人間像/
にんげんてき /人間的/
にんげんなみ /人間並/
にんげんばなれ /人間離れ/
にんげんみ /人間味/
にんげんわざ /人間業/
にんさんばけしち /人三化七/
にんさんぷ /妊産婦/
にんしき /認識/
にんしきひょう /認識票/
にんしきぶそく /認識不足/
にんしきろん /認識論/
にんしょう /認証/人称/人証/
にんしょうかん /認証官/
にんしょうしき /認証式/
にんしん /妊娠/
にんしんちゅうぜつ /妊娠中絶/
にんじゃ /忍者/
にんじゅう /忍従/
にんじゅつ /忍術/
にんじょう /人情/刃傷/
にんじょうざた /刃傷沙汰/
にんじょうばなし /人情話/人情噺/
にんじょうぼん /人情本/
にんじょうみ /人情味/
にんじん /人参/
にんずう /人数/
にんそう /人相/
にんそうがく /人相学/
にんそうみ /人相見/
にんそく /人足/
にんたい /忍耐/
にんだく /認諾/
にんだくちょうしょ /認諾調書/
にんち /認知/任地/
にんちかがく /認知科学/
にんちしんりがく /認知心理学/
にんちゅう /人中/
にんてい /認定/
にんていしぼう /認定死亡/
にんでん /人天/
にんとうぜい /人頭税/
にんとく /仁徳/
にんなじ /仁和寺/
にんにく /大蒜/葫/
にんぴ /認否/
にんぴにん /人非人/
にんぷ /妊婦/人夫/
にんべつ /人別/
にんべつちょう /人別帳/
にんべん /人偏/
にんぽう /忍法/
にんむ /任務/
にんめい /任命/
にんめん /任免/
にんよう /任用/認容/
ぬ /怒/奴/
ぬいいと /縫糸/
ぬいしろ /縫代/
ぬいめ /縫い目/
ぬいもの /縫物/
ぬえ /鵺/
ぬか /糠/額/
ぬかか /糠蚊/
ぬかご /糠子/零余子/
ぬかたのおおきみ /額田王/
ぬかづけ /糠漬/
ぬかどこ /糠床/
ぬかばたらき /糠働き/
ぬかぶくろ /糠袋/
ぬかみそ /糠味噌/
ぬかるみ /泥濘/
ぬき /貫/抜き/緯/
ぬきあしさしあし /抜き足差し足/
ぬきいと /緯糸/
ぬきうつし /抜写し/
ぬきさし /抜き差し/
ぬきずり /抜刷/
ぬきて /抜手/
ぬきに /抜荷/
ぬきほん /抜本/
ぬきみ /抜身/
ぬきよみ /抜読み/
ぬぎすて /脱ぎ捨て/
ぬく /温/
ぬくみ /温み/
ぬけ /抜け/
ぬけあな /抜け穴/
ぬけがけ /抜け駆け/
ぬけがら /抜殻/蛻/脱け殻/抜け殻/
ぬけに /抜け荷/
ぬけみち /抜け道/
ぬけめ /抜け目/
ぬさ /幣/
ぬし /主/
ぬすっと /盗人/
ぬすびと /盗人/
ぬすみ /盗み/
ぬすみぎき /盗み聞き/
ぬすみぐい /盗み食い/
ぬすみみ /盗み見/
ぬすみよみ /盗み読み/
ぬの /布/
ぬのきれ /布切れ/
ぬのじ /布地/
ぬのびき /布引/
ぬのまき /布巻/
ぬのめ /布目/
ぬま /沼/
ぬまかぜ /沼風/
ぬまかわ /沼川/
ぬまず /沼津/
ぬまた /沼田/
ぬまち /沼地/
ぬまづ /沼津/
ぬめ /絖/
ぬりえ /塗り絵/
ぬりかべ /塗壁/
ぬりもの /塗物/
ぬるま /微温/
ぬるまゆ /微温湯/
ぬれ /濡れ/
ぬれぎぬ /濡れ衣/
ぬれごと /濡事/
ぬれねずみ /濡れ鼠/
ぬれば /濡場/
ぬればいろ /濡れ羽色/
ね /音/値/寝/根/子/嶺/祢/禰/
ねあがり /根上り/
ねあげ /値上げ/
ねあせ /寝汗/
ねあらい /値洗い/
ねい /寧/佞/祢/禰/
ねいか /寧夏/
ねいき /寝息/
ねいし /根石/
ねいしん /佞臣/
ねいじつ /寧日/
ねいす /寝椅子/
ねいは /寧波/
ねいりばな /寝入り端/
ねいろ /音色/
ねうごき /値動き/
ねうち /値打/
ねえさん /姉さん/
ねえや /姉や/
ねお /根緒/
ねおき /寝起き/
ねかた /根方/
ねかぶ /根株/
ねがい /願い/
ねがいごと /願い事/
ねがいさげ /願い下げ/
ねがいで /願い出/
ねがえり /寝返り/
ねがお /寝顔/
ねがさかぶ /値嵩株/
ねがわくば /願わくば/
ねぎ /葱/
ねぎし /根岸/
ねぎわ /根際/
ねくずれ /値崩れ/
ねくび /寝首/
ねぐせ /寝癖/
ねぐら /塒/
ねこ /猫/
ねこあし /猫脚/
ねこいらず /猫いらず/
ねこかぶり /猫被り/
ねこかわいがり /猫かわいがり/
ねこぐるま /猫車/
ねこじた /猫舌/
ねこぜ /猫背/
ねこそぎ /根刮ぎ/
ねこなでごえ /猫撫で声/
ねこのひたい /猫の額/
ねこのめ /猫の目/
ねこま /猫間/
ねこまた /猫又/
ねこまたぎ /猫跨ぎ/
ねこめいし /猫目石/
ねこやなぎ /猫柳/
ねごこち /寝心地/
ねごと /寝言/
ねごや /根小屋/
ねごろ /根来/値頃/
ねごろばん /根来版/
ねさげ /値下げ/
ねざかな /根魚/
ねざけ /寝酒/
ねざし /根差し/
ねざま /寝様/
ねざめ /寝覚め/
ねざや /値鞘/
ねしょうがつ /寝正月/
ねしょうべん /寝小便/
ねじ /捻子/螺子/捩子/捻/
ねじけ /拗け/
ねじめ /根締め/
ねじろ /根城/
ねすがた /寝姿/
ねず /根津/
ねずみ /鼠/
ねずみいろ /鼠色/
ねずみこう /鼠講/
ねずみこぞう /鼠小僧/
ねずみざん /鼠算/
ねぞう /寝相/
ねた /妬/
ねたばこ /寝煙草/
ねだ /根太/
ねだめ /寝溜め/
ねだやし /根絶やし/
ねだん /値段/
ねちがえ /寝違え/
ねっか /熱河/
ねっから /根っから/
ねっき /熱気/
ねっきょう /熱狂/
ねっきょうてき /熱狂的/
ねっけつ /熱血/
ねっこ /根っこ/
ねっさ /熱砂/
ねっさん /熱讃/
ねっしゃびょう /熱射病/
ねっしょ /熱暑/
ねっしょう /熱唱/熱傷/
ねっしん /熱心/
ねっすい /熱水/
ねっせい /熱性/
ねっせん /熱戦/熱線/
ねったい /熱帯/
ねったいうりん /熱帯雨林/
ねったいぎょ /熱帯魚/
ねったいていきあつ /熱帯低気圧/
ねったいや /熱帯夜/
ねったいりん /熱帯林/
ねっちゅう /熱中/
ねっとう /熱湯/
ねっぱ /熱波/
ねっぱつ /熱発/
ねっぷう /熱風/
ねつ /熱/
ねつあい /熱愛/
ねつい /熱意/
ねつうんどう /熱運動/
ねつえん /熱演/
ねつがん /熱願/
ねつき /寝付き/
ねつききゅう /熱気球/
ねつぎ /根継ぎ/
ねつけ /根付/熱気/
ねつげん /熱源/
ねつこうかんき /熱交換器/
ねつこうりつ /熱効率/
ねつさまし /熱冷まし/
ねつしょり /熱処理/
ねつじょう /熱情/
ねつぞう /捏造/
ねつちゅうせいし /熱中性子/
ねつでんつい /熱電対/
ねつでんどう /熱伝導/
ねつでんどうりつ /熱伝導率/
ねつど /熱度/
ねつびょう /熱病/
ねつふくしゃ /熱輻射/
ねつへいこう /熱平衡/
ねつべん /熱弁/
ねつぼう /熱望/
ねつぼうちょう /熱膨張/
ねつようりょう /熱容量/
ねつらい /熱雷/
ねつりきがく /熱力学/
ねつりょう /熱量/
ねつりょうけい /熱量計/
ねつるい /熱涙/
ねつれつ /熱烈/
ねつろん /熱論/
ねづ /根津/
ねていとう /根抵当/
ねとまり /寝泊り/
ねどこ /寝床/
ねなし /根無し/
ねなしぐさ /根無草/根無し草/
ねはば /値幅/
ねはん /涅槃;煩悩を無くした静寂の状態/
ねはんえ /涅槃会/
ねば /粘/
ねばつち /粘土/
ねばりけ /粘り気/
ねばりごし /粘り腰/
ねびえ /寝冷え/
ねびき /値引き/
ねびらき /値開き/
ねふだ /値札/
ねぶ /合歓/
ねぶか /根深/
ねぶくろ /寝袋/
ねぶそく /寝不足/
ねぶと /根太/
ねぶみ /値踏み/
ねほん /根本/
ねぼう /寝坊/
ねぼけ /寝惚け/
ねぼすけ /寝坊助/
ねま /寝間/
ねまき /寝間着/
ねまちづき /寝待月/
ねまわし /根回し/
ねまわり /根回り/
ねみみ /寝耳/
ねむ /合歓/
ねむけ /眠気/
ねむのき /合歓木/
ねむりぐすり /眠り薬/
ねむろ /根室/
ねもと /根本/根元/
ねものがたり /寝物語/
ねや /閨/
ねやがわ /寝屋川/
ねゆき /根雪/
ねらい /狙い/
ねらいうち /狙い撃ち/
ねらいめ /狙い目/
ねり /練り/
ねりいろ /練色/
ねりえ /煉餌/
ねりこう /練香/
ねりせいひん /練製品/
ねりぬき /練貫/
ねりべい /練塀/
ねりま /練馬/
ねりもの /練物/
ねるちんすく /尼布楚/
ねわけ /根分け/
ねわざ /寝技/
ねわざし /寝業師/
ねわら /寝藁/
ねん /年/念/粘/燃/然/撚/捻/
ねんあき /年明き/
ねんあけ /年明け/
ねんいり /念入り/
ねんえき /粘液/
ねんえきしつ /粘液質/
ねんえきすいしゅ /粘液水腫/
ねんかい /年会/年回/
ねんかん /年間/年刊/年鑑/
ねんが /年賀/
ねんがく /年額/
ねんがじょう /年賀状/
ねんがっぴ /年月日/
ねんがはがき /年賀葉書/
ねんがらねんじゅう /年がら年中/
ねんがん /念願/
ねんき /年期/年忌/年季/年紀/
ねんきゅう /年休/年給/
ねんきり /年切り/
ねんきん /年金/粘菌/
ねんぐ /年貢/
ねんげつ /年月/
ねんげみしょう /拈華微笑/
ねんげん /年限/
ねんこう /年功/
ねんこうじょれつ /年功序列/
ねんごう /年号/
ねんごろ /懇ろ/
ねんさ /年差/
ねんさん /年産/
ねんざ /捻挫/
ねんし /年始/撚糸/
ねんしき /年式/
ねんしまわり /年始回り/
ねんしゃ /念写/
ねんしゅう /年収/
ねんしゅつ /捻出/
ねんしょ /念書/年初/
ねんしょう /年少/燃焼/年商/
ねんしょうしつ /燃焼室/
ねんじ /年次/
ねんじゅ /念珠/
ねんじゅう /年中/
ねんすう /年数/
ねんせい /粘性/
ねんだい /年代/
ねんだいき /年代記/
ねんだいもの /年代物/
ねんだんせい /粘弾性/
ねんちゃく /粘着/
ねんちゃくせい /粘着性/
ねんちゃくりょく /粘着力/
ねんちゅうぎょうじ /年中行事/
ねんちょう /年長/
ねんてん /捻転/
ねんとう /念頭/年頭/
ねんど /年度/粘度/粘土/
ねんどう /念動/
ねんどしつ /粘土質/
ねんない /年内/
ねんねん /年々/年年/
ねんねんさいさい /年年歳歳/
ねんのため /念の為/
ねんばらい /年払い/
ねんばん /年版/
ねんばんがん /粘板岩/
ねんぱい /年配/年輩/
ねんぴ /燃費/
ねんぴょう /年表/
ねんぶつ /念仏/
ねんぶん /年分/
ねんぷ /年譜/年賦/
ねんべつ /年別/
ねんぽう /年報/年俸/念法/
ねんまえ /年前/
ねんまく /粘膜/
ねんまつ /年末/
ねんまつちょうせい /年末調整/
ねんらい /年来/
ねんり /年利/
ねんりき /念力/
ねんりつ /年率/
ねんりょ /念慮/
ねんりょう /燃料/
ねんりょうでんち /燃料電池/
ねんりん /年輪/
ねんれい /年齢/
ねんれいそう /年齢層/
の /野/埜/之/廼/乃/
のあそび /野遊び/
のう /農/膿/脳/能/納/濃/悩/嚢/衲/
のういっけつ /脳溢血/
のうえん /農園/脳炎/濃艶/
のうか /農家/濃化/
のうかい /納会/
のうかしん /膿痂疹/
のうかすいたい /脳下垂体/
のうかん /能管/納棺/脳幹/
のうかんき /農閑期/
のうがき /能書/
のうがく /農学/能楽/
のうがくし /能楽師/
のうがくどう /能楽堂/
のうき /納期/農期/
のうきぐ /農機具/
のうきょう /農協/納経/膿胸/
のうきょうげん /能狂言/
のうきん /納金/
のうぎょう /農業/
のうぐ /農具/
のうけっせん /脳血栓/
のうげい /農芸/
のうげいかがく /農芸化学/
のうげか /脳外科/
のうこう /濃厚/農工/農耕/
のうこうしりょう /濃厚飼料/
のうこうそく /脳梗塞/
のうこつ /納骨/
のうこん /濃紺/
のうさい /納采/
のうさぎ /野兎/
のうさく /農作/
のうさくぶつ /農作物/
のうさつ /悩殺/納札/
のうさん /農産/
のうさんぶつ /農産物/
のうざしょう /脳挫傷/
のうし /脳死/直衣/野牛/
のうしつ /脳室/
のうしゅ /嚢腫/
のうしゅう /濃州/
のうしゅく /濃縮/
のうしゅっけつ /脳出血/
のうしゅよう /脳腫瘍/
のうしょ /能書/農書/
のうしょう /農相/脳漿/脳症/
のうしんけい /脳神経/
のうしんとう /脳震盪/
のうじ /農事/能地/能事/
のうじゅ /納受/
のうじゅう /膿汁/
のうじょう /農場/嚢状/
のうずい /脳髄/
のうせい /農政/
のうぜい /納税/
のうぜいかんりにん /納税管理人/
のうぜいしんこく /納税申告/
のうぜんかずら /凌霄花/
のうそっちゅう /脳卒中/
のうそん /農村/
のうたん /濃淡/
のうち /農地/
のうちゅう /脳中/嚢中/嚢虫/
のうてん /脳天/
のうてんき /能天気/
のうど /濃度/農奴/
のうどう /能動/農道/
のうどうたい /能動態/
のうどうてき /能動的/
のうどかいほう /農奴解放/
のうなし /能無し/
のうなんかしょう /脳軟化症/
のうにゅう /納入/
のうは /脳波/
のうはんき /農繁期/
のうひつ /能筆/
のうひん /納品/
のうひんけつ /脳貧血/
のうひんしょ /納品書/
のうび /濃尾/
のうびょう /脳病/
のうふ /納付/農夫/農婦/
のうぶたい /能舞台/
のうぶん /能文/
のうへい /農兵/
のうべん /能弁/
のうほう /膿疱/
のうほん /納本/
のうまく /脳膜/
のうまくえん /脳膜炎/
のうみそ /脳味噌/
のうみつ /濃密/
のうみん /農民/
のうむ /濃霧/
のうめん /能面/
のうやく /農薬/
のうやくしゃ /能役者/
のうよう /膿瘍/
のうらん /悩乱/
のうり /脳裏/能吏/脳裡/
のうりつ /能率/
のうりつきゅう /能率給/
のうりつてき /能率的/
のうりょう /納涼/脳梁/
のうりょく /能力/
のうりょくきゅう /能力給/
のうりん /農林/
のおがた /直方/
のかぜ /野風/
のかた /野方/
のがみ /野上/
のがわ /野川/
のき /軒/
のきうら /軒裏/
のきげた /軒桁/
のきさき /軒先/
のきした /軒下/
のきたけ /軒丈/
のきなみ /軒並/
のきならび /軒並び/
のきば /軒端/
のきわり /軒割/
のぎ /乃木/芒/
のぎく /野菊/
のぎまれすけ /乃木希典/
のぎわ /野際/
のぐち /野口/
のぐちひでよ /野口英世/
のぐら /野倉/
のけもの /除け者/
のげ /野毛/
のこ /鋸/
のこぎり /鋸/
のこくず /鋸屑/
のこらず /残らず/
のこり /残り/
のこりが /残り香/
のこりび /残り火/
のこりもの /残り物/
のさっぷみさき /納沙布岬/
のざき /野崎/
のざと /野里/
のざらし /野晒し/
のざわ /野沢/
のざわおんせん /野沢温泉/
のざわな /野沢菜/
のし /熨/熨斗/
のしがみ /熨斗紙/
のしぶくろ /熨斗袋/
のしろ /能代/
のじ /野路/野地/
のじいた /野地板/
のじゅく /野宿/
のじりこ /野尻湖/
のずえ /野末/
のそだち /野育ち/
のぞきまど /覗き窓/
のぞみ /望み/
のたれじに /野垂れ死に/
のだ /野田/
のだて /野点/
のち /後/
のちぞい /後添い/
のちぞえ /後添え/
のちのち /後々/
のちほど /後程/
のちょう /野帳/
のづみ /野積み/
のてう /盧泰愚/
のてん /野天/
のてんぶろ /野天風呂/
のでら /野寺/
のと /能登/
のとはんとう /能登半島/
のど /喉/咽/
のどか /長閑/
のどじまん /喉自慢/
のどぶえ /喉笛/
のどぼとけ /喉仏/
のどもと /喉元/
のなか /野中/
のねずみ /野鼠/
ののぐち /野々口/
ののむら /野々村/
のはら /野原/
のば /野場/
のばな /野花/
のばなし /野放し/
のばら /野薔薇/
のび /野火/
のびのび /伸び伸び/
のびる /野蒜/
のぶ /信/
のぶこ /伸子/
のぶせり /野臥せり/野伏せり/
のぶたか /信高/
のぶふさ /信房/
のへん /野辺/
のべ /野辺/延べ/
のべいた /延板/
のべおか /延岡/
のべおくり /野辺送り/
のべがね /延金/
のべがみ /延紙/
のべじんいん /延べ人員/
のべつぼ /延坪/
のべにっすう /延べ日数/
のべばらい /延べ払い/
のぼり /上り/幟/
のぼりざか /登り坂/上り坂/
のぼりべつ /登別/
のま /野間/
のまおい /野馬追/
のみ /蚤/鑿/
のみくい /飲み食い/
のみぐち /呑口/
のみこうい /呑行為/
のみしろ /飲み代/
のみすぎ /飲み過ぎ/
のみず /野水/
のみて /飲み手/
のみのいち /蚤の市/
のみみず /飲み水/
のみもの /飲物/
のみや /呑屋/
のみりょう /飲み料/
のむぎ /野麦/
のむぎとうげ /野麦峠/
のむら /野村/
のやき /野焼き/
のやま /野山/
のら /野良/
のらいぬ /野良犬/
のらぎ /野良着/
のらしごと /野良仕事/
のらねこ /野良猫/
のり /法/糊/則/範/海苔/矩/乗り/典/
のりあい /乗合/
のりいれ /乗入れ/
のりいれがみ /糊入紙/
のりおり /乗り降り/
のりかえ /乗換え/
のりき /乗り気/
のりくみいん /乗組員/
のりくら /乗鞍/
のりくらこうげん /乗鞍高原/
のりくらだけ /乗鞍岳/
のりごこち /乗心地/
のりしろ /糊代/
のりづけ /糊付け/
のりて /乗り手/
のりと /祝詞/
のりにげ /乗逃げ/
のりば /乗場/
のりまき /海苔巻/
のりもの /乗物/
のるうぇー /諾威/
のれん /暖簾/
のろ /野呂/
のろい /呪い/
のろけ /惚気/
のろし /烽火/狼煙/
のわき /野分/
のんき /呑気/暢気/暖気/
のんだくれ /飲んだくれ/
のんべえ /飲兵衛/
は /破/葉/歯/波/端/派/覇/播/把/羽/刃/巴/
はあく /把握/
はい /背/配/輩/肺/牌/盃/杯/敗/排/拝/廃/俳/灰/佩/癈/胚/
はいあん /廃案/
はいい /廃位/配位/配意/
はいいけつごう /配位結合/
はいいろ /灰色/
はいいろぐま /灰色熊/
はいいん /敗因/排印/
はいいんぼん /排印本/
はいえい /背泳/
はいえき /廃液/廃駅/
はいえつ /拝謁/
はいえん /肺炎/排煙/
はいおく /廃屋/
はいか /配下/廃家/
はいかい /徘徊/俳諧/誹諧/
はいかきょう /拝火教/
はいかつりょう /肺活量/
はいかん /廃刊/配管/拝観/廃官/廃艦/
はいが /胚芽/拝賀/俳画/
はいがい /拝外/排外/
はいがく /廃学/
はいがまい /胚芽米/
はいがん /肺癌/拝顔/
はいき /廃棄/排気/
はいきかん /排気管/
はいきしゅ /肺気腫/
はいきべん /排気弁/
はいきゅう /配給/排球/配球/
はいきゅうちゅう /肺吸虫/
はいきょ /廃墟/
はいきょう /背教/
はいきりょう /排気量/
はいきん /背筋/拝金/
はいぎょ /肺魚/
はいぎょう /廃業/
はいく /俳句/
はいぐ /拝具/
はいぐう /配偶/
はいぐうし /配偶子/
はいぐうしゃ /配偶者/
はいぐうたい /配偶体/
はいぐん /敗軍/
はいけい /背景/拝啓/
はいけっかく /肺結核/
はいけつしょう /敗血症/
はいけん /拝見/佩剣/
はいげき /排撃/
はいこう /廃校/廃鉱/廃坑/
はいご /背後/廃語/
はいごう /配合/俳号/廃合/
はいごかんけい /背後関係/
はいさつ /拝察/
はいざい /廃材/配剤/
はいざら /灰皿/
はいざん /敗残/廃山/廃残/
はいし /廃止/廃市/胚子/
はいしつ /癈疾/肺疾/
はいしゃ /廃車/歯医者/配車/敗者/拝謝/
はいしゃく /拝借/
はいしゅ /胚珠/
はいしゅつ /排出/輩出/
はいしょ /俳書/配所/
はいしょう /拝承/敗将/廃娼/
はいしょく /配色/敗色/
はいしん /背信/背進/
はいしんこうい /背信行為/
はいじ /拝辞/
はいじつせい /背日性/
はいじゅ /拝受/
はいじゅんかん /肺循環/
はいじょ /排除/廃除/
はいじょうみゃく /肺静脈/
はいじん /廃人/俳人/癈人/配陣/拝塵/
はいすい /排水/配水/背水/廃水/
はいすいかん /配水管/
はいすいしゅ /肺水腫/
はいすいのじん /背水の陣/
はいすいりょう /排水量/
はいせい /敗勢/
はいせき /排斥/
はいせつ /排泄/排雪/
はいせつぶつ /排泄物/
はいせん /配線/敗戦/廃船/廃線/配船/肺尖/
はいせんいしょう /肺線維症/
はいぜつ /廃絶/
はいぜん /配膳/沛然/
はいそ /敗訴/
はいそう /配送/敗走/背走/
はいぞう /肺臓/
はいぞく /配属/
はいた /排他/歯痛/
はいたい /敗退/胚胎/廃退/廃頽/
はいたつ /配達/
はいたつしょうめい /配達証明/
はいたてき /排他的/
はいだん /俳壇/
はいち /配置/背馳/
はいちせい /背地性/
はいちてんかん /配置転換/
はいちゃく /廃嫡/
はいちゅうりつ /排中律/
はいちょう /拝聴/
はいちょうきん /腓腸筋/
はいてい /拝呈/廃帝/
はいてん /配点/配転/
はいでん /配電/拝殿/
はいでんばん /配電盤/
はいとう /配当/佩刀/
はいとうきん /配当金/
はいとうせいこう /配当性向/
はいとうりつ /配当率/
はいとうれい /廃刀令/
はいとく /背徳/
はいどう /廃道/
はいどうみゃく /肺動脈/
はいどく /拝読/
はいにち /排日/
はいにゅう /胚乳/
はいにょう /排尿/
はいにん /背任/
はいにんざい /背任罪/
はいねつ /廃熱/
はいのう /背嚢/胚嚢/排膿/
はいはん /背反/
はいはんちけん /廃藩置県/
はいばん /廃盤/
はいばんろうぜき /杯盤狼藉/
はいひん /廃品/
はいび /配備/拝眉/
はいびょう /肺病/
はいふ /配布/配付/肺腑/配賦/
はいふう /俳風/誹風/
はいふく /拝復/
はいぶ /背部/
はいぶつ /廃物/
はいぶん /配分/拝聞/俳文/
はいへい /敗兵/
はいべん /排便/
はいほう /肺胞/敗報/
はいほん /配本/
はいぼう /敗亡/
はいぼく /敗北/
はいぼくしゅぎ /敗北主義/
はいまつ /這松/
はいみ /俳味/
はいみょう /俳名/
はいめい /拝命/俳名/
はいめつ /廃滅/
はいめん /背面/
はいもん /肺門/
はいや /灰屋/
はいやく /配役/背約/
はいゆ /廃油/
はいゆう /俳優/俳友/
はいゆうざ /俳優座/
はいよう /胚葉/肺葉/
はいらる /海拉爾/
はいらん /排卵/
はいり /背理/背離/
はいりつ /廃立/
はいりほう /背理法/
はいりょ /配慮/
はいりょう /拝領/
はいる /配流/
はいれい /拝礼/
はいれつ /配列/排列/
はいろ /葉色/
はいろん /俳論/
はいわ /俳話/
はうた /端唄/
はえ /蠅/南風/生え/蝿/
はえぎわ /生え際/
はえなわ /延縄/
はえぬき /生え抜き/
はおう /覇王/
はおく /破屋/
はおと /羽音/
はおり /羽織/
はおんきごう /ハ音記号/
はか /墓/破瓜/
はかい /破壊/破戒/破潰/
はかいかつどうぼうしほう /破壊活動防止法;破防法/
はかいし /墓石/
はかいてき /破壊的/
はかいむざん /破戒無慙/
はかいりょく /破壊力/
はかく /破格/
はかげ /葉陰/
はかしょ /墓所/
はかじるし /墓標/
はかせ /博士/
はかぜ /羽風/葉風/
はかた /博多/
はかば /墓場/
はかぶ /端株/
はかま /袴/
はかまいり /墓参り/
はかもり /墓守/
はからい /計らい/
はかり /秤/
はかりうり /量り売り/
はかりきり /量り切り/
はかりごと /謀/
はかりめ /秤目/
はが /芳賀/
はがいじめ /羽交締め/
はがえ /羽替え/
はがき /葉書/
はがくれ /葉隠れ/
はがた /歯形/
はがね /鋼/
はがみ /歯噛み/
はがん /破顔/
はがんいっしょう /破顔一笑/
はき /破棄/覇気/破毀/
はきいそう /破棄移送/
はきくだし /吐き下し/
はきけ /吐き気/
はきさしもどし /破棄差戻し/
はきじはん /破棄自判/
はきそうじ /掃き掃除/
はきもの /履物/
はきゃく /破却;壊すこと/
はきゅう /波及/
はきょく /破局/
はぎ /萩/脛/矧/
はぎしり /歯軋り/
はぎの /萩野/
はぎはら /萩原/
はぎょう /ハ行/覇業/
はぎり /歯切り/
はぎれ /歯切れ/端切れ/
はぎわら /萩原/
はく /泊/白/薄/迫/舶/箔/拍/博/剥/伯/魄/帛/粕/柏/
はくあ /白亜/白堊/
はくあい /博愛/
はくあき /白亜紀/
はくい /白衣/羽咋/
はくいんぼうしょう /博引旁証/
はくう /白雨/
はくうん /白雲/
はくえん /白煙/
はくおう /白鴎/
はくおし /箔押し/
はくが /博雅/
はくがい /迫害/
はくがく /博学/
はくがん /白眼/
はくがんし /白眼視/
はくぎん /白銀/
はくぐう /薄遇/
はくげい /白鯨/
はくげき /迫撃/搏撃/
はくげきほう /迫撃砲/
はくさ /白砂/
はくさい /白菜/舶載/
はくさん /白山/
はくし /博士/白紙/薄志/
はくしいにん /白紙委任/
はくしいにんじょう /白紙委任状/
はくしかてい /博士課程/
はくしき /博識/
はくしじゃっこう /薄志弱行/
はくしつ /白質/
はくしゃ /拍車/薄謝/白砂/
はくしゃく /伯爵/
はくしゃせいしょう /白砂青松/
はくしゅ /拍手/
はくしゅう /白秋/
はくしゅかっさい /拍手喝采/
はくしょ /白書/帛書/薄暑/
はくしょく /白色/
はくしょくこう /白色光/
はくしょくじんしゅ /白色人種/
はくしん /迫真/
はくじ /白磁/白字/
はくじつ /白日/
はくじつむ /白日夢/
はくじゃ /白蛇/
はくじゃく /薄弱/
はくじゅ /白寿/
はくじょう /白状/薄情/
はくじん /白人/白刃/
はくじんしゅ /白人種/
はくず /白図/
はくせい /剥製/
はくせき /白皙/白石/
はくせつ /白雪/
はくせん /白線/白癬/
はくぜん /白髯/
はくたん /白炭/
はくだく /白濁/
はくだつ /剥奪/剥脱/
はくち /白痴/泊地/白地/
はくちず /白地図/
はくちび /白痴美/
はくちゅう /白昼/伯仲/
はくちゅうむ /白昼夢/
はくちょう /白鳥/
はくちょうざ /白鳥座/
はくちょうのうた /白鳥の歌/
はくとう /白糖/白桃/白頭/
はくどう /白道/白銅/
はくどうか /白銅貨/
はくないしょう /白内障/
はくねつ /白熱/
はくはつ /白髪/
はくはん /白斑/
はくば /白馬/
はくばい /白梅/
はくひょう /薄氷/白票/
はくびせん /伯備線/
はくびょう /白描/
はくふ /白布/伯父/
はくぶつ /博物/
はくぶつかん /博物館/
はくぶつがく /博物学/
はくぶつし /博物誌/
はくぶん /博文/白文/博聞/
はくぶんやくれい /博文約礼/
はくへい /白兵/
はくへいせん /白兵戦/
はくへき /白壁/
はくへん /剥片/薄片/
はくへんせっき /剥片石器/
はくほう /白鳳/
はくぼ /薄暮/
はくぼく /白墨/
はくま /白魔/
はくまい /白米/
はくめい /薄命/薄明/
はくめん /白面/
はくや /白夜/
はくよう /白楊/
はくようきゅう /白羊宮/
はくらい /舶来/
はくらく /伯楽/剥落/
はくらん /博覧/
はくらんかい /博覧会/
はくらんきょうき /博覧強記/
はくり /剥離/薄利/白痢/
はくりきこ /薄力粉/
はくりたばい /薄利多売/
はくりょく /迫力/
はくろ /白露/白鷺/
はくろう /伯労/白蝋/
はくわ /白話/
はくわしょうせつ /白話小説/
はぐき /歯茎/
はぐるま /歯車/
はぐろ /歯黒/
はけ /刷毛/捌け/
はけい /波形/
はけぐち /捌け口/
はけん /派遣/覇権/
はげ /禿/剥げ/
はげあたま /禿頭/
はげたか /禿鷹/
はげやま /禿山/
はげわし /禿鷲/
はこ /箱/函/筐/筥/匣/
はこいり /箱入り/
はこう /跛行/波高/
はこかなもの /箱金物/
はこがき /箱書/
はこだて /函館/
はこだてほんせん /函館本線/
はこづめ /箱詰/
はこにわ /箱庭/
はこね /箱根/
はこねざいく /箱根細工/
はこねじ /箱根路/
はこねゆもと /箱根湯本/
はこぶね /箱船/方舟/
はこん /破婚/
はご /羽子/
はごいた /羽子板/
はごく /破獄/
はごし /葉越し/
はごたえ /歯応え/
はごろも /羽衣/
はさい /破砕/
はさき /刃先/
はさつおん /破擦音/
はさみ /鋏/
はさみうち /挟み撃ち/
はさん /破産/破算/
はさんかんざいにん /破産管財人/
はさんさいけん /破産債権/
はさんざいだん /破産財団/
はさんせんこく /破産宣告/
はさんほう /破産法/
はざかいき /端境期/
はざくら /葉桜/
はざま /間/狭間/硲/
はし /箸/橋/端/觜/梯/
はしい /端居/
はしいた /橋板/
はしおか /橋岡/
はしおき /箸置き/
はしか /麻疹/
はしがき /端書き/
はしくれ /端くれ/
はしぐち /橋口/
はしけ /艀/
はしげた /橋桁/
はしご /梯子/
はしござけ /梯子酒/
はしごだん /梯子段/
はしずめ /橋爪/
はしぞめ /箸初め/
はした /端/
はしたか /鷂/
はしたがね /端金/
はしため /端女/
はしだ /橋田/
はしづめ /橋詰/橋爪/
はしば /羽柴/
はしばし /端々/
はしばみ /榛/
はしひめ /橋姫/
はしま /羽島/
はしもと /橋本/
はしもり /橋守/
はしゃ /覇者/
はしやすめ /箸休め/
はしゅ /把手/播種/
はしゅつ /派出/
はしゅつじょ /派出所/
はしゅつふ /派出婦/
はしょうふう /破傷風/
はしら /柱/
はしらどけい /柱時計/
はしり /走り/
はしりい /走井/
はしりがき /走り書き/
はしりづかい /走り使い/
はしりで /走り出/
はしりよみ /走り読み/
はしわたし /橋渡し/
はじ /恥/端/把持/土師/
はじいろ /黄櫨色/
はじかみ /薑/
はじさらし /恥曝し/
はじしらず /恥知らず/
はじまり /始まり/
はじめ /初め/始め/肇/
はじめて /初めて/
はじめね /始値/
はじめまして /始めまして/
はじゃ /破邪/
はじゃけんしょう /破邪顕正/
はじょう /波状/
はじろ /羽白/
はす /蓮/斜/
はすい /破水/
はすいけ /蓮池/
はすう /端数/波数/
はすだ /蓮田/
はすっぱ /蓮っ葉/
はすね /蓮根/
はすむかい /斜向い/
はず /筈/
はずえ /葉末/
はずかしめ /辱め/
はずみぐるま /弾み車/
はずれ /外れ/葉擦れ/外/
はせ /長谷/
はせい /派生/
はせいご /派生語/
はせいてき /派生的/
はせがわ /長谷川/
はせくら /支倉/
はせん /破線/波線/破船/
はぜ /鯊/黄櫨/櫨/
はそく /波束/把捉/
はそん /破損/
はた /旗/機/畠/秦/傍/将/端/畑/幡/
はたあげ /旗揚げ/
はたいろ /旗色/
はたおり /機織/
はたがしら /旗頭/
はたきこみ /叩き込み/
はたけ /畑/畠/
はたけちがい /畑違い/
はたけなか /畠中/
はたけやま /畠山/畑山/
はたご /旅籠/
はたごや /旅籠屋/
はたさく /畑作/
はたさしもの /旗指物/
はたざお /旗竿/
はたしあい /果し合い/
はたしじょう /果し状/
はたして /果して/
はたじるし /旗印/
はたち /二十/畑地/
はたて /旗手/
はたとせ /二十歳/
はたなか /畑中/
はたの /波多野/
はたはた /鰰/
はたび /旗日/
はたふり /旗振り/
はため /傍目/
はためいわく /傍迷惑/
はたもち /旗持/
はたもと /旗本/
はたもとやっこ /旗本奴/
はたや /機屋/
はたやま /畑山/
はたらき /働き/
はたらきぐち /働き口/
はたらきざかり /働き盛り/
はたらきて /働き手/
はたらきもの /働き者/
はたん /破綻/
はだ /肌/膚/
はだあい /肌合い/
はだいろ /肌色/
はだか /裸/
はだかけ /肌掛け/
はだかそうば /裸相場/
はだかび /裸火/
はだかむぎ /裸麦/
はだぎ /肌着/
はださむ /肌寒/
はだざわり /肌触り/
はだし /裸足/跣/
はだの /秦野/
はだみ /肌身/
はだん /破談/
はち /鉢/八/蜂/
はちあわせ /鉢合せ/
はちうえ /鉢植え/
はちおうじ /八王子/
はちがつ /八月/
はちく /破竹/
はちけんや /八軒屋/
はちじゅうはちや /八十八夜/
はちじょう /八丈/
はちじょうじま /八丈島/
はちす /蜂巣/蓮/
はちすか /蜂須賀/
はちだいしゅう /八代集/
はちにん /八人/
はちのじ /八の字/
はちのす /蜂の巣/
はちのへ /八戸/
はちはちかんたい /八八艦隊/
はちぶ /八分/八部/
はちぶんめ /八分目/
はちぼく /八木/
はちまい /八枚/
はちまき /鉢巻/
はちまん /八幡/八万/
はちまんぐう /八幡宮/
はちまんざ /八幡座/
はちまんたい /八幡平/
はちみつ /蜂蜜/
はちめん /八面/
はちめんたい /八面体/
はちめんれいろう /八面玲瓏/
はちめんろっぴ /八面六臂/
はちもの /鉢物/
はちゅうるい /爬虫類/
はちょう /波長/ハ調/
はちりゅう /八竜/
はちろうがた /八郎潟/
はちろぐん /八路軍/
はっ /法/
はっか /発火/薄荷/白化/
はっかい /発会/八戒/
はっかく /発覚/八角/
はっかけ /八掛/
はっかてん /発火点/
はっかん /発刊/発汗/発艦/
はっき /発揮/白旗/
はっきゅう /発給/薄給/
はっきょう /発狂/
はっきん /発禁/白金/
はっく /八苦/
はっくつ /発掘/
はっけ /八卦/
はっけい /八景/
はっけっきゅう /白血球/
はっけつびょう /白血病/
はっけん /発見/発券/白鍵/
はっけんでん /八犬伝/
はっこう /発行/発酵/発光/発効/醗酵/薄幸/八紘/白光/発航/八講/発向/
はっこういちう /八紘一宇/
はっこうかかく /発行価格/
はっこうしじょう /発行市場/
はっこうせいぶつ /発光生物/
はっこうたい /発光体/
はっこうださん /八甲田山/
はっこうびとりひき /発行日取引/
はっこつ /白骨/
はっさく /八朔/
はっさん /発散/
はっしゃ /発射/発車/
はっしゃかん /発射管/
はっしゅうけんがく /八宗兼学/
はっしゅつ /発出/
はっしょう /発祥/発症/八省/
はっしょうち /発祥地/
はっしょく /発色/
はっしん /発信/発疹/発振/発進/八神/
はっしんにん /発信人/
はっすい /撥水/
はっすいかこう /撥水加工/
はっせい /発生/発声/
はっせいがく /発生学/
はっせいきかん /発声器官/
はっせいしゅぎ /発生主義/
はっせいほう /発声法/
はっせき /発赤/
はっせん /八仙/
はっそう /発送/発想/発走/八相/八双/
はっそく /発足/
はった /八田/
はったつ /発達/
はったつしんりがく /発達心理学/
はったん /発端/
はっちゃく /発着/
はっちゅう /発注/
はっちょう /八丁/
はっちょうぼり /八丁堀/
はっちょうみそ /八丁味噌/
はってん /発展/
はっと /法度/
はっとうしん /八頭身/
はっとり /服部/
はっぱ /葉っぱ/発破/
はっぱく /八白/
はっぴ /法被/
はっぴゃく /八百/
はっぴゃくやちょう /八百八町/
はっぴょう /発表/
はっぷ /発布/髪膚/
はっぷん /発奮/発憤/
はっぽう /八方/発砲/発泡/
はっぽうおね /八方尾根/
はっぽうさい /八宝菜/
はっぽうびじん /八方美人/
はつ /髪/初/発/鉢/醗/溌/
はつ> /初/
はつあん /発案/
はつい /発意/
はついく /発育/
はつうま /初午/
はつうり /初売り/
はつえき /発駅/
はつえん /発煙/
はつえんとう /発煙筒/
はつおん /発音/撥音/
はつおんたい /発音体/
はつおんびん /撥音便/
はつか /二十日/
はつかいち /廿日市/
はつかぜ /初風/
はつかり /初雁/
はつが /発芽/
はつがい /初買い/
はつがしら /発頭/
はつがつお /初鰹/
はつがん /発癌/
はつがんぶっしつ /発癌物質/
はつぎ /発議/
はつげん /発言/発現/発源/
はつげんがっき /撥弦楽器/
はつげんけん /発言権/
はつげんりょく /発言力/
はつこい /初恋/
はつご /発語/初子/
はつごおり /初氷/
はつざくら /初桜/
はつざん /初産/
はつしごと /初仕事/
はつしま /初島/
はつしも /初霜/
はつじょう /発情/発条/
はつずり /初刷/
はつぜっく /初節句/
はつぜみ /初蝉/
はつた /初田/
はつたけ /初茸/
はつだ /発兌/
はつだより /初便り/
はつつき /初月/
はつづき /初月/
はつで /初出/
はつでん /発電/
はつでんき /発電機/
はつでんしょ /発電所/
はつどう /発動/
はつどうき /発動機/
はつなつ /初夏/
はつに /初荷/
はつね /初音/初値/
はつねつ /発熱/
はつねつりょう /発熱量/
はつはな /初花/
はつはる /初春/
はつばい /発売/
はつばしょ /初場所/
はつひ /初日/
はつひので /初日の出/
はつびょう /発病/
はつふゆ /初冬/
はつぶたい /初舞台/
はつほ /初穂/
はつぼん /初盆/
はつまいり /初参り/
はつまご /初孫/
はつみみ /初耳/
はつめい /発明/
はつもの /初物/
はつものぐい /初物食い/
はつもん /発問/
はつやま /初山/
はつゆ /初湯/
はつゆき /初雪/
はつゆめ /初夢/
はつよう /発揚/
はつらつ /溌剌/
はつらん /撥乱/
はつらんはんせい /撥乱反正/
はつれい /発令/
はつろ /発露/
はつわ /発話/
はづき /葉月/
はづくろい /羽繕い/
はて /果て/
はてし /果てし/
はてな /？/
はてんこう /破天荒/
はで /派手/
はと /鳩/鴿/
はとう /波頭/波濤/坡塘/
はとがや /鳩ヶ谷/
はとどけい /鳩時計/
はとば /波止場/
はとばいろ /鳩羽色/
はとむぎ /鳩麦/
はとむね /鳩胸/
はとやま /鳩山/
はとやまいちろう /鳩山一郎/
はどう /波動/覇道/
はどうかんすう /波動関数/
はどうほうていしき /波動方程式/
はどめ /歯止め/
はな /花/鼻/華/洟/端/
はなあさぎ /花浅葱/
はなあらし /鼻嵐/
はない /花井/
はないき /鼻息/
はないろ /花色/
はなうた /鼻唄/
はなうり /花売り/
はなお /鼻緒/
はなおか /華岡/
はなかくし /鼻隠し/
はなかご /花籠/
はなが /花香/
はながき /花垣/
はながさ /花笠/
はながた /花形/
はながつお /花鰹/
はながみ /鼻紙/
はながら /花柄/
はなきん /花金/
はなぎ /鼻木/
はなぎれ /花布/
はなくそ /鼻糞/
はなぐすり /鼻薬/
はなぐもり /花曇り/
はなげ /鼻毛/
はなことば /花言葉/
はなごえ /鼻声/
はなごおり /花氷/
はなごよみ /花暦/
はなさかじじい /花咲爺/
はなさき /鼻先/
はなざかり /花盛り/
はなざくら /花桜/
はなし /話/噺/
はなしあい /話し合い/
はなしあいて /話し相手/
はなしか /噺家/
はなしかた /話し方/
はなしがい /放し飼い/
はなしことば /話し言葉/
はなしごえ /話し声/
はなしじょうず /話上手/
はなしずき /話好き/
はなして /話し手/
はなしょうぶ /花菖蒲/
はなじ /鼻血/
はなすじ /鼻筋/
はなずもう /花相撲/
はなずら /鼻面/
はなぞの /花園/
はなぞめ /花染/
はなたば /花束/
はなだ /花田/縹/
はなだい /花代/
はなだいろ /縹色/
はなだより /花便り/
はなちるさと /花散里/
はなぢ /鼻血/
はなっぱし /鼻っぱし/
はなっぱしら /鼻っ柱/
はなづな /鼻綱/
はなづら /鼻面/
はなでんしゃ /花電車/
はなどき /花時/
はなどけい /花時計/
はなぬすびと /花盗人/
はなの /花野/
はなのき /花の木/
はなのみやこ /花の都/
はなはだ /甚だ/
はなばさみ /花鋏/
はなばしら /鼻柱/
はなばたけ /花畑/
はなび /花火/
はなびえ /花冷え/
はなびら /花弁/
はなふだ /花札/
はなふぶき /花吹雪/
はなぶえ /鼻笛/
はなぶさ /英/花房/
はなまがり /鼻曲り/
はなまき /花巻/
はなまち /花街/
はなまつり /花祭/
はなみ /花見/花実/羽並/歯並/
はなみず /鼻水/花水/
はなみずき /花水木/
はなみち /花道/
はなみづき /花見月/
はなむけ /餞/
はなむこ /花婿/
はなむすび /花結び/
はなめがね /鼻眼鏡/
はなもじ /花文字/
はなもの /花物/
はなもよう /花模様/
はなや /花屋/
はなやぎ /花柳/
はなやしき /花屋敷/
はなやなぎ /花柳/
はなよめ /花嫁/
はならび /歯並び/
はなれこじま /離れ小島/
はなればなれ /離れ離れ/
はなれや /離れ家/
はなれわざ /離れ業/
はなわ /塙/鼻輪/花輪/
はに /埴/羽仁/
はにゅう /羽生/埴生/
はにゅうのやど /埴生の宿/
はにわ /埴輪/
はね /羽/翅/跳ね/撥ね/羽根/
はねじ /羽地/
はねだ /羽田/
はねばし /跳ね橋/
はは /母/
ははうえ /母上/
ははおや /母親/
ははかた /母方/
ははきぎ /帚木/
ははぎみ /母君/
ははこ /母子/
ははこぐさ /母子草/
ははご /母御/
ははじま /母島/
ははのひ /母の日/
ははびと /母人/
はば /巾/幅/
はばきき /幅利き/
はばつ /派閥/
はばとび /幅跳/
はびきの /羽曳野/
はふ /破風/
はぶ /土生/
はぶたえ /羽二重/
はぶり /羽振り/
はへい /派兵/
はへん /破片/歯偏/
はほん /端本/
はぼうほう /破防法/
はぼたん /葉牡丹/
はぼまいしょとう /歯舞諸島/
はま /浜/破魔/
はまいで /浜出/
はまお /浜尾/
はまおか /浜岡/
はまおぎ /浜荻/
はまかぜ /浜風/
はまかた /浜方/
はまがわ /浜側/
はまき /葉巻/
はまきた /浜北/
はまぐち /浜口/
はまぐちおさち /浜口雄幸/
はまぐり /蛤/
はまこ /浜子/
はまだ /浜田/
はまち /刃区/
はまちどり /浜千鳥/
はまなこ /浜名湖/
はまなす /浜茄子/
はまびと /浜人/
はまべ /浜辺/
はままつ /浜松/
はまみち /浜道/
はまもと /浜元/
はまや /破魔矢/浜屋/
はまやき /浜焼/
はまゆう /浜木綿/
はまりきゅう /浜離宮/
はみ /馬銜/
はみがき /歯磨き/
はむし /羽虫/
はむら /羽村/
はむろ /葉室/
はめ /羽目/
はめいた /羽目板/
はめごろし /嵌め殺し/
はめつ /破滅/
はめん /波面/
はも /鱧/
はもの /刃物/端物/葉物/
はもん /波紋/破門/刃文/
はや /早/鮠/
はやあし /早足/
はやい /速い/
はやいものがち /早い者勝ち/
はやうち /早打ち/
はやうま /早馬/
はやうまれ /早生れ/
はやおき /早起き/
はやかわ /早川/
はやがてん /早合点/
はやがね /早鐘/
はやく /端役/破約/
はやくち /早口/
はやくちことば /早口言葉/
はやぐい /早食い/
はやさ /速さ/
はやざき /早咲き/
はやし /林/囃子/
はやしお /早潮/
はやしや /林屋/
はやじに /早死/
はやじまい /早仕舞/
はやせ /早瀬/
はやた /早田/
はやだし /早出し/
はやだち /早立ち/
はやて /疾風/
はやてまわし /早手回し/
はやで /早出/
はやと /隼人/
はやとちり /早とちり/
はやね /早寝/
はやば /早場/
はやばまい /早場米/
はやばや /早々/
はやばん /早番/早版/
はやぶさ /隼/
はやま /葉山/端山/早馬/
はやみ /早見/速水/
はやみず /早水/
はやみち /早道/
はやみみ /早耳/
はやめ /早め/
はやめし /早飯/
はやり /流行/
はやりやまい /流行病/
はやわかり /早分り/
はやわざ /早業/早技/
はら /腹/原/肚/
はらあて /腹当/
はらい /祓い/払い/
はらいこみ /払込み/
はらいごし /払い腰/
はらいさげ /払下げ/
はらいた /腹痛/
はらいっぱい /腹一杯/
はらいもどし /払戻し/
はらおび /腹帯/
はらか /腹赤/
はらから /同胞/
はらがまえ /腹構え/
はらきり /腹切り/
はらくだし /腹下し/
はらくだり /腹下り/
はらぐあい /腹具合/
はらぐろ /腹黒/
はらげい /腹芸/
はらごしらえ /腹拵え/
はらじゅく /原宿/
はらだ /原田/
はらだち /腹立ち/
はらちがい /腹違い/
はらっぱ /原っぱ/
はらつづみ /腹鼓/
はらてっけつ /爬羅剔抉/
はらどけい /腹時計/
はらなか /原中/
はらの /原野/
はらはちぶ /腹八分/
はらばい /腹這い/
はらびれ /腹鰭/
はらぺこ /腹ぺこ/
はらまき /腹巻/
はらまち /原町/
はらもち /腹持ち/
はらわた /腸/
はらん /波瀾/波乱/
はらんばんじょう /波瀾万丈/
はり /針/梁/玻璃/榛/
はりあい /張合い/
はりいた /張板/
はりがね /針金/
はりがみ /貼り紙/張り紙/
はりくよう /針供養/
はりこ /張子/針子/
はりしごと /針仕事/
はりつけ /磔/
はりて /張手/
はりねずみ /針鼠/
はりばこ /針箱/
はりぼて /張りぼて/
はりま /播磨/
はりまなだ /播磨灘/
はりまや /播磨屋/
はりみち /針道/
はりめ /針目/
はりやま /針山/
はりん /破倫/
はる /春/
はるあき /春秋/
はるいちばん /春一番/
はるか /遥か/遥/
はるかぜ /春風/
はるがすみ /春霞/
はるき /春木/
はるぎ /春着/
はるさき /春先/
はるさく /春作/
はるさめ /春雨/
はるた /春田/
はるな /春菜/
はるなさん /榛名山/
はるの /春野/
はるばしょ /春場所/
はるびん /哈爾浜/
はるまき /春巻/
はるやすみ /春休み/
はるやま /春山/
はれ /晴れ/腫れ/
はれぎ /晴れ着/
はれすがた /晴れ姿/
はれつ /破裂/
はれつおん /破裂音/
はればれ /晴れ晴れ/
はれま /晴れ間/
はれもの /腫物/
はれんち /破廉恥/
はれんちざい /破廉恥罪/
はろう /波浪/
はわい /布哇/
はわたり /刃渡り/
はん /版/半/坂/判/反/飯/頒/煩/範/販/藩/般/繁/畔/班/犯/汎/板/斑/搬/帆/叛/伴/凡/釆/氾/
はん> /反/半/
はんい /範囲/犯意/叛意/
はんいご /反意語/
はんいんよう /半陰陽/
はんえい /反映/繁栄/半影/
はんえいきゅう /半永久/
はんえり /半襟/
はんえん /半円/
はんえんけい /攀縁茎/
はんおん /半音/
はんおんかい /半音階/
はんか /繁華/頒価/反歌/半価/
はんかい /半壊/半解/半開/
はんかく /半角/反核/
はんかくかたかな /半角片仮名/
はんかくかな /半角仮名/
はんかくめい /反革命/
はんかこ /半過去/
はんかちょう /犯科帳/
はんかつう /半可通/
はんかん /反感/反間/繁閑/繁簡/
はんかんすう /汎関数/
はんかんはんみん /半官半民/
はんが /版画/
はんがく /半額/藩学/
はんがりー /洪牙利/
はんがん /判官/半眼/
はんき /半期/半旗/叛旗/半季/
はんきかん /半規管/
はんきゅう /半休/半球/半弓/
はんきょう /反響/反共/
はんきれ /半切れ/
はんきん /半金/
はんぎゃく /反逆/叛逆/
はんぎゃくじ /反逆児/
はんぎょく /半玉/
はんく /半句/
はんぐん /反軍/
はんけい /半径/
はんけつ /判決/
はんけつしょ /判決書/
はんけつりゆう /判決理由/
はんけん /版権/半券/
はんけんじ /判検事/
はんげき /反撃/繁劇/
はんげつ /半月/
はんげん /半減/半舷/
はんげんき /半減期/
はんこ /判子/
はんこう /反抗/犯行/反攻/藩侯/藩校/
はんこうき /反抗期/
はんこつ /反骨/
はんこん /瘢痕/
はんご /反語/
はんごう /飯盒/
はんごろし /半殺し/
はんごんたん /反魂丹/
はんさ /煩瑣/
はんさい /半済/半裁/半歳/
はんさく /半作/
はんさつ /藩札/
はんさよう /反作用/
はんざい /犯罪/
はんざいしゃ /犯罪者/
はんざつ /繁雑/煩雑/
はんし /半紙/藩士/範士/
はんしき /版式/範式/
はんした /版下/
はんしはんしょう /半死半生/
はんしぼん /半紙本/
はんしゃ /反射/
はんしゃかく /反射角/
はんしゃきょう /反射鏡/
はんしゃてき /反射的/
はんしゃりつ /反射律/
はんしゃろ /反射炉/
はんしゅ /藩主/
はんしゅう /半周/
はんしゅつ /搬出/
はんしょう /反証/半焼/半鐘/反照/
はんしょく /繁殖/蕃殖/
はんしん /阪神/半身/版心/叛臣/
はんしんはんぎ /半信半疑/
はんしんふずい /半身不随/
はんしんろん /汎心論/汎神論/
はんじ /判事/判じ/半時/
はんじせい /反磁性/
はんじつ /半日/
はんじほ /判事補/
はんじゃ /判者/
はんじゅく /半熟/
はんじゅくたまご /半熟卵/
はんじょう /繁盛/犯情/半畳/繁昌/
はんじょく /繁縟/
はんすい /半睡/
はんすう /反芻/半数/
はんせい /反省/半生/藩政/
はんせいいでん /伴性遺伝/
はんせいひん /半製品/
はんせき /犯跡/版籍/
はんせつ /反切/
はんせん /帆船/反戦/半銭/
はんぜん /判然/
はんそ /反訴/
はんそう /搬送/帆走/
はんそうは /搬送波/
はんそく /反則/犯則/反側/
はんそくきん /反則金/
はんそで /半袖/
はんぞう /楾/
はんぞく /反俗/
はんた /煩多/繁多/
はんたい /反対/
はんたいきゅうふ /反対給付/
はんたいご /反対語/
はんたいしょうりつ /反対称律/
はんたいしょく /反対色/
はんたいじんもん /反対尋問/
はんたいせい /反体制/
はんだ /半田/盤陀/
はんだい /飯台/
はんだくおん /半濁音/
はんだくてん /半濁点/
はんだずけ /半田付け/
はんだづけ /半田付け/
はんだん /判断/
はんだんりょく /判断力/
はんちゅう /範疇/藩中/
はんちょう /班長/
はんちょくせん /半直線/
はんつき /半月/
はんつきまい /半搗き米/
はんづら /版面/
はんてい /判定/藩邸/
はんてん /反転/斑点/飯店/半纏/半天/
はんと /版図/叛徒/半途/
はんとう /半島/反騰/
はんとうまく /半透膜/
はんとうめい /半透明/
はんとき /半時;一時間/
はんとし /半年/
はんとりちょう /判取帳/
はんどう /反動/半道/
はんどうたい /半導体/
はんどく /判読/
はんなん /阪南/
はんにえ /半煮え/
はんにち /半日/
はんにゃ /般若/
はんにゃじ /般若寺/
はんにゃとう /般若湯/
はんにゅう /搬入/
はんにん /犯人/半人/
はんにんまえ /半人前/
はんね /半値/
はんねん /半年/
はんのう /反応/飯能/半農/半納/半能/
はんのうじかん /反応時間/
はんのうそくど /反応速度/
はんはん /半々/
はんば /飯場/
はんばい /販売/
はんばいそくしん /販売促進/
はんばく /反駁/
はんばつ /藩閥/
はんぱ /半端/
はんぱせいりゅう /半波整流/
はんぱつ /反発/反撥/
はんぱつりょく /反発力/
はんびょうにん /半病人/
はんびらき /半開き/
はんぴれい /反比例/
はんぶっしつ /反物質/
はんぶん /半分/
はんぶんじょくれい /繁文縟礼/
はんぶんすう /繁分数/
はんぷ /頒布/帆布/
はんぷく /反復/反覆/
はんぷくほう /反復法/
はんべえ /半兵衛/
はんべつ /判別/
はんべつしき /判別式/
はんぺん /半片/
はんぼいん /半母音/
はんぼう /繁忙/
はんま /半間/
はんまい /飯米/
はんみ /半身/
はんみょう /斑猫/
はんむ /煩務/繁務/
はんめい /判明/
はんめん /反面/半面/版面/
はんめんきょうし /反面教師/
はんも /繁茂/
はんもう /反毛/半盲/
はんもく /反目/
はんもと /版元/
はんもん /反問/斑紋/煩悶/半文/
はんもんてん /板門店/
はんや /半夜/
はんやき /半焼き/
はんやく /反訳/
はんやけ /半焼け/
はんよう /汎用/繁用/
はんようし /反陽子/
はんら /半裸/
はんらく /反落/
はんらん /氾濫/反乱/叛乱/
はんりゅうし /反粒子/
はんりょ /伴侶/
はんりん /半輪/
はんるい /煩累/
はんれい /判例/凡例/範例/
はんれいほう /判例法/
はんろ /販路/坂路/
はんろう /煩労/藩老/
はんろん /反論/汎論/
ば /場/馬/罵/婆/羽/
ばーん /barn/
ばあ /婆/
ばあい /場合/
ばあさま /婆様/
ばあたり /場当り/
ばあや /婆や/
ばい /倍/陪/賠/売/買/梅/媒/培/唄/貝/霾/狽/煤/楳/
ばいいん /売淫/
ばいう /梅雨/
ばいうぜんせん /梅雨前線/
ばいえん /煤煙/梅園/
ばいおん /倍音/
ばいか /倍加/売価/買価/梅花/
ばいかい /媒介/
ばいかいへんすう /媒介変数/
ばいかく /倍角/
ばいかん /陪観/
ばいがく /倍額/
ばいきゃく /売却/
ばいきゅう /倍旧/
ばいきん /黴菌/
ばいこく /売国/
ばいこくど /売国奴/
ばいしつ /媒質/
ばいしゃく /媒酌/媒妁/倍尺/
ばいしゅう /買収/
ばいしゅん /買春/売春/
ばいしゅんふ /売春婦/
ばいしょう /賠償/売笑/
ばいしょく /陪食/
ばいしん /陪審/陪臣/
ばいじゅう /陪従/
ばいじょう /陪乗/
ばいすう /倍数/
ばいせい /媒精/
ばいせき /陪席/
ばいせん /焙煎/媒染/
ばいぞう /倍増/
ばいた /売女/
ばいたい /媒体/
ばいだい /倍大/
ばいち /培地/
ばいちょう /陪聴/
ばいてん /売店/
ばいどく /梅毒/
ばいにん /売人/
ばいばい /売買/
ばいひん /売品/
ばいぶん /売文/
ばいめい /売名/
ばいやく /売約/売薬/
ばいよう /培養/
ばいようえき /培養液/
ばいようき /培養基/
ばいりつ /倍率/
ばいりん /梅林/
ばか /馬鹿/莫迦/
ばかさわぎ /馬鹿騒ぎ/
ばかしょうじき /馬鹿正直/
ばかじから /馬鹿力/
ばかず /場数/
ばかぢから /馬鹿力/
ばかづら /馬鹿面/
ばかていねい /馬鹿丁寧/
ばかね /馬鹿値/
ばかばなし /馬鹿話/
ばかもの /馬鹿者/
ばかやろう /馬鹿野郎/
ばかり /許り/
ばかわらい /馬鹿笑い/
ばきゃく /馬脚/
ばく /麦/駁/莫/縛/爆/漠/博/暴/幕/貘/獏/曝/
ばくえい /幕営/
ばくえき /博奕/
ばくおん /爆音/
ばくか /幕下/
ばくが /麦芽/
ばくがとう /麦芽糖/
ばくぎ /博戯/
ばくげき /爆撃/駁撃/
ばくげきき /爆撃機/
ばくさい /爆砕/博才/
ばくし /爆死/
ばくしゃ /幕舎/
ばくしゅう /麦秋/
ばくしょ /曝書/
ばくしょう /爆笑/
ばくしん /爆心/驀進/幕臣/
ばくせい /幕政/
ばくせつ /駁説/
ばくぜん /漠然/
ばくだい /莫大/
ばくだん /爆弾/
ばくち /博打/博奕/
ばくちく /爆竹/
ばくちん /爆沈/
ばくと /博徒/
ばくは /爆破/
ばくはつ /爆発/
ばくはつてき /爆発的/
ばくはつぶつ /爆発物/
ばくはつりょく /爆発力/
ばくはん /麦飯/
ばくふ /幕府/瀑布/
ばくふう /爆風/
ばくまつ /幕末/
ばくやく /爆薬/
ばくらい /爆雷/
ばくりょう /幕僚/曝涼/
ばくれつ /爆裂/
ばくれつだん /爆裂弾/
ばくろ /暴露/曝露/
ばくろう /伯楽/博労/
ばくろん /駁論/
ばぐ /馬具/
ばけ /化け/
ばけがく /化学/
ばけのかわ /化けの皮/
ばけもの /化物/
ばけん /馬券/
ばしゃ /馬車/
ばしゃうま /馬車馬/
ばしゃく /馬借/
ばしゅ /馬主/
ばしょ /場所/
ばしょう /芭蕉/
ばしょうふ /芭蕉布/
ばしょがら /場所柄/
ばしょく /馬食/
ばしょわり /場所割り/
ばじとうふう /馬耳東風/
ばじゅつ /馬術/
ばじょう /馬上/
ばすえ /場末/
ばせい /罵声/
ばせき /場席/
ばせん /場銭/
ばそり /馬橇/
ばぞく /馬賊/
ばたや /ばた屋/
ばだい /場代/
ばち /罰/撥/
ばちがい /場違い/
ばっかん /麦稈/
ばっかんさなだ /麦稈真田/
ばっき /曝気/
ばっきん /罰金/
ばっくよらく /抜苦与楽/
ばっけん /抜剣/
ばっこ /跋扈/
ばっさい /伐採/
ばっし /抜歯/抜糸/末子/
ばっしょう /跋渉/
ばっすい /抜粋/
ばっせき /末席/
ばっせん /抜染/
ばっそく /罰則/
ばっそん /末孫/
ばった /飛蝗/
ばってい /末弟/
ばってき /抜擢/
ばってん /罰点/
ばっとう /抜刀/
ばっぽん /抜本/
ばっぽんそくげん /抜本塞源/
ばっぽんてき /抜本的/
ばつ /罰/×/抜/伐/末/閥/跋/筏/
ばつえい /末裔/
ばつぐん /抜群/
ばつご /跋語/
ばつざんがいせい /抜山蓋世/
ばつぞく /閥族/
ばつびょう /抜錨/
ばつぶん /跋文/
ばつぼく /伐木/
ばつよう /末葉/
ばつりゅう /末流/
ばてい /馬丁/馬蹄/
ばていけい /馬蹄形/
ばとう /罵倒/
ばとうきん /馬頭琴/
ばなか /場中/
ばなれ /場馴れ/
ばにく /馬肉/
ばね /発条/
ばば /馬場/婆/
ばばさき /馬場先/
ばひつ /馬匹/
ばび /馬尾/
ばふん /馬糞/
ばふんし /馬糞紙/
ばめん /場面/
ばら /薔薇/原/
ばらいろ /薔薇色/
ばり /罵詈/張り/
ばりき /馬力/
ばりざんぼう /罵詈讒謗/
ばりぞうごん /罵詈雑言/
ばるかん /巴爾幹/
ばれい /馬齢/
ばれいしょ /馬鈴薯/
ばれん /馬連/
ばん /番/判/版/板/万/晩/盤/磐/伴/蛮/挽/蕃/播/鷭/幡/塙/
ばんえつさいせん /磐越西線/
ばんか /挽歌/晩夏/蕃茄/
ばんかい /挽回/
ばんかず /番数/
ばんかん /万感/
ばんがい /番外/
ばんがいち /番外地/
ばんがく /晩学/
ばんがた /晩方/
ばんき /晩期/万機/
ばんきょ /蟠踞/
ばんきん /板金/鈑金/
ばんぎ /板木/
ばんぎく /晩菊/
ばんくるわせ /番狂わせ/
ばんぐみ /番組/
ばんけい /晩景/
ばんけん /番犬/
ばんこ /万戸/万古/
ばんこう /蛮行/
ばんこく /万国/
ばんこつ /万骨/蛮骨/
ばんこふえき /万古不易/
ばんこん /晩婚/
ばんこんさくせつ /盤根錯節/
ばんごう /番号/
ばんごはん /晩御飯/
ばんごや /番小屋/
ばんさく /万策/
ばんさん /晩餐/
ばんざい /万歳/
ばんし /万死/
ばんしゃ /万謝/
ばんしゃく /晩酌/
ばんしゅう /晩秋/播州/磐州/
ばんしゅん /晩春/
ばんしょ /板書/番所/
ばんしょう /万障/番匠/晩鐘/万象/
ばんしょく /伴食/
ばんじ /万事/
ばんじゃく /磐石/盤石/
ばんじゅく /晩熟/
ばんじょう /万丈/盤上/番匠/
ばんじん /万人/
ばんすい /晩翠/
ばんせい /晩成/万世/蛮声/伴星/晩生/
ばんせいいっけい /万世一系/
ばんせつ /晩節/
ばんせん /番線/
ばんぜん /万全/
ばんそう /伴奏/晩霜/伴走/
ばんそうこう /絆創膏/
ばんそつ /番卒/
ばんぞく /蛮族/
ばんたい /万態/
ばんたん /万端/播但/
ばんだ /万朶/
ばんだい /番台/万代/番代/
ばんだいさん /磐梯山/
ばんだいふえき /万代不易/
ばんち /番地/
ばんちゃ /番茶/
ばんちょう /番長/
ばんづけ /番付/
ばんて /番手/
ばんとう /番頭/晩冬/晩稲/
ばんどう /坂東/阪東/
ばんどころ /番所/
ばんなん /万難/
ばんにん /番人/万人/
ばんねん /晩年/
ばんのう /万能/
ばんば /輓馬/馬場/番場/
ばんばんざい /万万歳/
ばんばんじー /棒々鶏/棒棒鶏/
ばんぱく /万博/
ばんぱん /万般/
ばんぶつ /万物/
ばんぶつるてん /万物流転/
ばんぷう /蛮風/
ばんぷく /万福/
ばんぷふとう /万夫不当/
ばんべつ /万別/
ばんぺい /番兵/
ばんみん /万民/
ばんめ /番目/
ばんめし /晩飯/
ばんめん /盤面/
ばんもく /万目/
ばんや /番屋/
ばんゆう /万有/蛮勇/
ばんゆういんりょく /万有引力/
ばんらい /万雷/
ばんり /万里/
ばんりどうふう /万里同風/
ばんりょく /万緑/蛮力/
ぱい /牌/π/Π/
ぱお /包/
ぱおず /包子/
ぱなま /巴奈馬/
ぱり /巴里/
ぱん /麺麭/幇/
ひ /日/彼/比/扉/火/費/樋/飛/非/避/被/肥/罷/緋/秘/碑/皮/疲/泌/披/批/悲/妃/否/卑/氷/檜/脾/干/妣/杼/梭/鄙/匕/婢/陽/誹/斐/庇/匪/灯/
ひ> /被/非/
ひあい /悲哀/
ひあそび /火遊び/
ひあたり /日当り/
ひあぶり /火焙り/
ひい /非違/
ひいき /贔屓/
ひいきめ /贔屓目/
ひいく /肥育/
ひいな /雛/
ひいなぼん /雛本/
ひいまご /曾孫/
ひいらぎ /柊/
ひいれ /火入れ/
ひいろ /緋色/
ひうお /氷魚/
ひうち /燧/
ひうら /日裏/
ひうん /悲運/非運/飛雲/
ひえ /稗/冷え/
ひえいざん /比叡山/
ひえき /裨益/
ひえしょう /冷え性/
ひえだ /稗田/
ひえん /飛燕/
ひおう /秘奥/
ひおおい /日覆い/
ひおけ /火桶/
ひか /皮下/悲歌/
ひかえ /控え/
ひかえしつ /控室/
ひかえめ /控え目/
ひかがみ /膕/
ひかく /比較/皮革/非核/皮角/
ひかくきゅう /比較級/
ひかくげんごがく /比較言語学/
ひかくてき /比較的/
ひかくてき> /比較的/
ひかげ /日陰/日蔭/日影/
ひかげもの /日陰者/
ひかげん /火加減/
ひかしぼう /皮下脂肪/
ひかず /日数/
ひかぜいしょとく /非課税所得/
ひかそしき /皮下組織/
ひかた /日方/
ひかちゅうしゃ /皮下注射/
ひかり /光/
ひかりつうしん /光通信/
ひかわ /簸川/
ひかわじんじゃ /氷川神社/
ひかん /悲観/避寒/
ひかんてき /悲観的/
ひが /彼我/非我/僻/
ひがい /被害/鰉/
ひがいしゃ /被害者/
ひがいもうそう /被害妄想/
ひがえり /日帰り/
ひがき /檜垣/
ひがけ /日掛け/
ひがさ /日傘/
ひがし /東/干菓子/
ひがしおおさか /東大阪/
ひがしおおたに /東大谷/
ひがしかぜ /東風/
ひがしがわ /東側/
ひがしくるめ /東久留米/
ひがしにほん /東日本/
ひがしね /東根/
ひがしはんきゅう /東半球/
ひがしひろしま /東広島/
ひがしまつやま /東松山/
ひがしむき /東向き/
ひがしむらやま /東村山/
ひがしやま /東山/
ひがしやまと /東大和/
ひがた /干潟/
ひがないちにち /日がな一日/
ひがね /日金/
ひがら /日柄/
ひがん /悲願/彼岸/
ひがんえ /彼岸会/
ひがんばな /彼岸花/
ひき /匹/疋/比企/悲喜/引き/蟇/
ひきあい /引合い/
ひきあけ /引明け/
ひきあて /引当て/
ひきあてきん /引当金/
ひきあわせ /引合せ/
ひきうけ /引受け/
ひきうけにん /引受人/
ひきうた /引歌/
ひきお /引尾/
ひきかえ /引替え/
ひきがえる /蟾蜍/
ひきがたり /弾き語り/
ひきがね /引き金/
ひきぎわ /引き際/
ひきげき /悲喜劇/
ひきごと /引言/
ひきさげ /引下げ/
ひきざん /引き算/
ひきしお /引き潮/
ひきしめ /引締め/
ひきすう /引数/
ひきぞめ /弾き初め/
ひきたて /引立て/
ひきたてやく /引立て役/
ひきだし /引出し/
ひきつけ /引付け/
ひきつづき /引き続き/
ひきて /弾き手/
ひきでもの /引出物/
ひきど /引戸/
ひきどき /引き時/
ひきにく /挽肉/
ひきにげ /轢き逃げ/
ひきのばしき /引伸機/
ひきふだ /引札/
ひきまく /引幕/
ひきめ /蟇目/
ひきめかぎはな /引目鉤鼻/
ひきもの /引物/
ひきゃく /飛脚/
ひきやま /引山/
ひきゅう /飛球/秘笈/
ひきょう /卑怯/秘境/比況/悲況/悲境/
ひきょく /秘曲/悲曲/
ひきわたし /引渡し/
ひきわり /引割/
ひきん /卑近/
ひきんぞく /非金属/卑金属/
ひぎ /秘儀/秘戯/非義/
ひぎしゃ /被疑者/
ひぎょう /罷業/
ひぎんえんしゃしん /非銀塩写真/
ひくつ /卑屈/
ひくて /引く手/
ひくみ /低み/
ひぐち /樋口/火口/
ひぐちいちよう /樋口一葉/
ひぐま /羆/
ひぐらし /蜩/日暮し/
ひぐれ /日暮/
ひけ /引け/
ひけい /秘計/
ひけぎわ /引け際/
ひけし /火消し/
ひけそうば /引け相場/
ひけっていろん /非決定論/
ひけつ /秘訣/否決/秘結/
ひけね /引け値/
ひけめ /引け目/
ひけん /披見/比肩/
ひけんしゃ /被験者/
ひげ /髭/卑下/鬚/髯/
ひげき /悲劇/
ひげきてき /悲劇的/
ひげづら /髭面/
ひげね /鬚根/
ひげんぎょう /非現業/
ひこ /彦/曾孫/
ひこう /飛行/非行/肥厚/披講/
ひこうかい /非公開/
ひこうき /飛行機/
ひこうきぐも /飛行機雲/
ひこうけんにん /被後見人/
ひこうしき /非公式/
ひこうしょうねん /非行少年/
ひこうしん /粃糠疹/
ひこうじょう /飛行場/
ひこうせん /飛行船/
ひこうてい /飛行艇/
ひこく /被告/
ひこくにん /被告人/
ひこくみん /非国民/
ひこしま /彦島/
ひこつ /腓骨/
ひこね /彦根/
ひこばえ /蘖/
ひこぼし /彦星/
ひご /肥後/庇護/卑語/飛語/籤/蜚語/
ひごい /緋鯉/
ひごう /非業/
ひごうほう /非合法/
ひごうり /非合理/
ひごと /日毎/
ひごろ /日頃/
ひさ /久/
ひさい /被災/久居/
ひさいべんさい /非債弁済/
ひさかた /久方/
ひさかたぶり /久方振り/
ひさく /秘策/
ひさくに /久国/
ひさご /瓢/匏/瓠/
ひさし /庇/廂/
ひさしぶり /久し振り/
ひさびさ /久々/
ひさべつぶらく /被差別部落/
ひさまつ /久松/
ひさめ /氷雨/
ひさん /悲惨/飛散/砒酸/
ひざ /膝/
ひざかけ /膝掛け/
ひざかり /日盛り/
ひざがしら /膝頭/
ひざくりげ /膝栗毛/
ひざぐるま /膝車/
ひざこぞう /膝小僧/
ひざし /日差し/陽射し/
ひざまくら /膝枕/
ひざもと /膝元/
ひざら /火皿/
ひし /菱/皮脂/秘史/斐紙/
ひしお /醤/
ひしかわ /菱川/
ひしがた /菱形/
ひししょくぶつ /被子植物/
ひしせん /皮脂腺/
ひしだ /菱田/
ひしつ /皮質/
ひしと /緊と/犇と/
ひしね /菱根/
ひしひし /犇々/緊々/
ひしもち /菱餅/
ひしゃ /飛車/
ひしゃかいしんど /被写界深度/
ひしゃく /柄杓/杓/
ひしゃたい /被写体/
ひしゅ /匕首/脾腫/
ひしゅう /悲愁/
ひしょ /秘書/避暑/
ひしょう /飛翔/卑小/費消/
ひしょかん /秘書官/
ひしょく /比色/非職/
ひしょち /避暑地/
ひしん /皮疹/
ひじ /肘/肱/秘事/
ひじかけ /肘掛け/
ひじかた /土方/
ひじかたとしぞう /土方歳三/
ひじちょうもく /飛耳長目/
ひじてつ /肘鉄/
ひじでっぽう /肘鉄砲/
ひじゅう /比重/
ひじゅつ /秘術/
ひじゅん /批准/
ひじょう /非常/非情/
ひじょうきん /非常勤/
ひじょうぐち /非常口/
ひじょうしき /非常識/
ひじょうしゅだん /非常手段/
ひじょうしょく /非常食/
ひじょうじ /非常時/
ひじょうじょうこく /非常上告/
ひじょうすう /被乗数/
ひじょうせん /非常線/
ひじょうに /非常に/
ひじょすう /被除数/
ひじり /聖/
ひすい /翡翠/
ひずけ /日付/
ひせい /批正/
ひせいさんてき /非生産的/
ひせき /飛跡/秘蹟/砒石/碑石/
ひせつ /秘説/
ひせん /卑賤/
ひせんきょけん /被選挙権/
ひせんとういん /非戦闘員/
ひせんろん /非戦論/
ひぜに /日銭/
ひぜめ /火攻め/火責め/
ひぜん /肥前/
ひそ /砒素/
ひそう /悲愴/悲壮/皮相/皮層/
ひそうぞくにん /被相続人/
ひそか /密か/
ひそく /秘色/
ひそすう /非素数/
ひそひそばなし /ひそひそ話/
ひそみ /顰み/
ひそやか /密やか/
ひそんざい /非存在/
ひぞう /秘蔵/脾臓/
ひぞく /卑俗/匪賊/卑属/
ひた /日田/
ひたい /額/
ひたいぎわ /額際/
ひたかくし /直隠し/
ひたき /鶲/
ひたすら /一向/只管/頓/
ひたち /日立/常陸/
ひたちおおた /常陸太田/
ひたちのみや /常陸宮/
ひたちやま /常陸山/
ひたむき /直向き/
ひたん /悲嘆/悲歎/
ひだ /飛騨/襞/
ひだい /肥大/比田井/
ひだか /日高/
ひだち /肥立ち/
ひだね /火種/
ひだま /火玉/
ひだまり /日溜り/
ひだり /左/←/
ひだりがわ /左側/
ひだりきき /左利き/
ひだりて /左手/
ひだりまえ /左前/
ひだりまき /左巻き/
ひだりまわり /左回り/
ひだりむき /左向き/
ひだりよつ /左四つ/
ひだりより /左寄り/
ひだん /被弾/
ひちしゃ /被治者/
ひちゅう /秘中/
ひちょう /悲調/飛鳥/
ひちりき /篳篥/
ひっか /筆禍/
ひっかく /筆画/
ひっかけ /引っ掛け/
ひっき /筆記/
ひっきしけん /筆記試験/
ひっきたい /筆記体/
ひっきょう /畢竟/
ひっけい /必携/
ひっけん /必見/
ひっこう /筆耕/
ひっこし /引越し/
ひっこみじあん /引っ込み思案/
ひっさいぼん /筆彩本/
ひっさつ /必殺/
ひっさん /筆算/
ひっし /必死/必至/筆紙/
ひっしゃ /筆者/筆写/
ひっしゅう /必修/
ひっしゅうかもく /必修科目/
ひっしょう /必勝/
ひっしょく /筆触/
ひっす /必須/
ひっすい /必衰/
ひっせい /畢生/筆生/筆勢/
ひっせき /筆跡/
ひっせん /筆洗/筆戦/
ひっそく /逼塞/
ひったん /筆端/
ひっち /筆致/
ひっちゃく /必着/
ひっちゅう /必中/筆誅/
ひっつめ /引っ詰め/
ひってき /匹敵/
ひっとう /筆頭/筆答/
ひっとうしゃ /筆頭者/
ひっぱく /逼迫/
ひっぷ /匹夫/
ひっぽう /筆法/筆鋒/
ひつ /必/筆/畢/弼/泌/匹/櫃/蹕/逼/
ひつあつ /筆圧/
ひつい /筆意/
ひつう /悲痛/
ひつき /火付き/
ひつぎ /棺/柩/
ひつけ /火付け/
ひつけやく /火付け役/
ひつじ /羊/未/
ひつじさる /坤/
ひつじゅ /必需/
ひつじゅつ /筆述/
ひつじゅひん /必需品/
ひつじゅん /筆順/
ひつじょう /必定/
ひつじん /筆陣/
ひつぜつ /筆舌/
ひつぜん /必然/
ひつぜんせい /必然性/
ひつぜんてき /必然的/
ひつだん /筆談/
ひつどく /必読/
ひつばつ /必罰/
ひつび /必備/
ひつぼく /筆墨/
ひつめい /筆名/
ひつめつ /必滅/
ひつもんひっとう /筆問筆答/
ひつよう /必要/必用/
ひつようあく /必要悪/
ひつようけいひ /必要経費/
ひつようじゅうぶんじょうけん /必要十分条件/
ひつようじょうけん /必要条件/
ひつようせい /必要性/
ひつりょく /筆力/
ひづけ /日付/
ひづけへんこうせん /日付変更線/
ひづめ /蹄/
ひてい /否定/
ひていてき /否定的/
ひてつきんぞく /非鉄金属/
ひてん /飛天/批点/
ひてんしゅうさ /非点収差/
ひで /英/
ひでり /日照り/旱/
ひでん /秘伝/飛電/
ひでんいん /悲田院/
ひでんか /比電荷/妃殿下/
ひと /一/人/費途/
ひとあし /一足/
ひとあしちがい /一足違い/
ひとあしらい /人あしらい/
ひとあせ /一汗/
ひとあたり /人当り/
ひとあな /人穴/
ひとあめ /一雨/
ひとあれ /一荒れ/
ひとあわ /一泡/
ひとあんしん /一安心/
ひといき /一息/
ひといきれ /人いきれ/
ひといちばい /人一倍/
ひといろ /人色/一色/
ひとう /秘湯/
ひとえ /一重/単/
ひとえに /偏に/
ひとえばおり /単羽織/
ひとえもの /単物/
ひとおじ /人怖じ/
ひとおと /人音/
ひとかい /人買い/
ひとかかえ /一抱え/
ひとかげ /人影/
ひとかすみ /一霞/
ひとかず /人数/
ひとかせぎ /一稼ぎ/
ひとかた /一方/
ひとかたならず /一方ならず/
ひとかど /一廉/
ひとかぶ /一株/
ひとかわ /一皮/
ひとがき /人垣/
ひとがら /人柄/
ひときり /人斬り/一切り/
ひときわ /一際/
ひとぎき /人聞き/
ひとぎらい /人嫌い/
ひとく /秘匿/
ひとくくり /一括り/
ひとくせ /一癖/
ひとくだり /一行/
ひとくち /一口/
ひとくろう /一苦労/
ひとけ /人気/
ひとこえ /一声/
ひとこと /一言/
ひとこま /一齣/
ひところ /一頃/
ひとごえ /人声/
ひとごこち /人心地/
ひとごころ /人心/
ひとごと /人事/他人事/
ひとごみ /人込み/
ひとごろし /人殺し/
ひとさしゆび /人差指/
ひとさま /人様/
ひとさらい /人攫い/
ひとさわがせ /人騒がせ/
ひとざと /人里/
ひとし /等し/
ひとしお /一入/一塩/
ひとしごと /一仕事/
ひとしばい /一芝居/
ひとしれず /人知れず/
ひとじち /人質/
ひとすじ /一筋/
ひとすじなわ /一筋縄/
ひとずき /人好き/
ひとたち /一太刀/
ひとたび /一度/
ひとたまり /一溜り/
ひとだかり /人集り/
ひとだすけ /人助け/
ひとだのみ /人頼み/
ひとだま /人魂/
ひとだまり /人溜り/
ひとちがい /人違い/
ひとっこ /人っ子/
ひとつ /一つ/
ひとつおぼえ /一つ覚え/
ひとつかま /一つ釜/
ひとつばし /一橋/
ひとつばしだいがく /一橋大学/
ひとつぶ /一粒/
ひとつぶえり /一粒選り/
ひとつぶだね /一粒種/
ひとつぶより /一粒選り/
ひとつまみ /一撮み/
ひとつみ /一つ身/
ひとつや /一つ家/
ひとつら /一連/
ひとづかい /人使い/
ひとづき /人付き/
ひとづて /人伝/
ひとづま /人妻/
ひとて /一手/
ひとで /人手/人出/海星/
ひととおり /一通り/
ひととき /一時/
ひととせ /一年/
ひととなり /為人/
ひとどおり /人通り/
ひとなか /人中/
ひとなかせ /人泣かせ/
ひとなみ /人波/人並/
ひとにぎり /一握り/
ひとねいり /一寝入り/
ひとは /一葉/
ひとはこ /一箱/
ひとはしり /一走り/
ひとはた /一旗/
ひとはたらき /一働き/
ひとはだ /人肌/一肌/
ひとはな /一花/
ひとばし /人橋/
ひとばしら /人柱/
ひとばらい /人払い/
ひとばん /一晩/
ひとひ /一日/
ひとひねり /一捻り/
ひとひら /一片/一枚/
ひとびと /人々/
ひとふし /一節/
ひとふで /一筆/
ひとふでがき /一筆書/
ひとふろ /一風呂/
ひとほね /一骨/
ひとま /一間/
ひとまえ /人前/
ひとまかせ /人任せ/
ひとまき /一巻/
ひとまく /一幕/
ひとまち /人待ち/
ひとまちがお /人待ち顔/
ひとまね /人真似/
ひとまわり /一回り/
ひとみ /人見/瞳/
ひとみごくう /人身御供/
ひとみしり /人見知り/
ひとむかし /一昔/
ひとむね /一棟/
ひとむら /一叢/
ひとめ /人目/一目/
ひとめぼれ /一目惚れ/
ひともうけ /一儲け/
ひともじ /一文字/人文字/
ひとやく /一役/
ひとやすみ /一休み/
ひとやま /一山/人山/
ひとよ /一夜/一世/
ひとよぎり /一節切/
ひとよし /人吉/
ひとよせ /人寄せ/
ひとり /一人/独り/
ひとりあるき /独り歩き/
ひとりがてん /独り合点/
ひとりぐち /一人口/
ひとりごと /独り言/
ひとりじめ /独り占め/
ひとりずもう /独り相撲/
ひとりたび /一人旅/
ひとりだち /独り立ち/
ひとりっこ /一人っ子/
ひとりぶたい /独り舞台/
ひとりまえ /一人前/
ひとりみ /独り身/
ひとりむすこ /一人息子/
ひとりむすめ /一人娘/
ひとりもの /独り者/
ひとりよがり /独り善がり/
ひど /肥土/
ひどう /非道/
ひどけい /日時計/
ひどり /日取り/
ひな /雛/鄙/
ひなあそび /雛遊び/
ひなか /日中/
ひながた /雛形/
ひなぎく /雛菊/
ひなた /日向/
ひなだん /雛壇/
ひなつ /日夏/
ひなどり /雛鳥/
ひなにんぎょう /雛人形/
ひなまつり /雛祭/
ひなまめほん /雛豆本/
ひならず /日ならず/
ひなわ /火縄/
ひなわじゅう /火縄銃/
ひなん /非難/避難/批難/
ひなんみん /避難民/
ひにく /皮肉/髀肉/
ひにち /日々/日日/
ひにょうき /泌尿器/
ひにょうきか /泌尿器科/
ひにん /非人/否認/避妊/
ひにんぐ /避妊具/
ひにんけん /否認権/
ひにんじょう /非人情/
ひね /陳/
ひねつ /比熱/
ひねもす /終日/
ひねり /捻り/
ひねん /比年/
ひの /日野/火野/
ひのいり /日の入り/
ひのうみ /火の海/
ひのえ /丙/
ひのえうま /丙午/
ひのき /檜/桧/
ひのくち /樋の口/
ひのくるま /火の車/
ひのけ /火の気/
ひのこ /火の粉/
ひのたま /火の玉/
ひのて /火の手/
ひので /日の出/
ひのと /丁/
ひのとり /火の鳥/
ひのべ /日延べ/
ひのまる /日の丸/
ひのみさき /日御碕/
ひのめ /日の目/
ひのもと /日の本/火の元/
ひはく /菲薄/
ひはつ /被髪/
ひはん /批判/
ひばい /肥培/
ひばいひん /非売品/
ひばく /被曝/被爆/飛瀑/
ひばし /火箸/
ひばしら /火柱/
ひばち /火鉢/
ひばな /火花/
ひばら /檜原/脾腹/
ひばり /雲雀/
ひばん /非番/
ひひ /狒狒/比比/霏霏/
ひひょう /批評/
ひひょうか /批評家/
ひひょうがん /批評眼/
ひび /日々/日日/皹/罅/
ひびき /響き/
ひびや /日比谷/
ひびやこうえん /日比谷公園/
ひふ /皮膚/
ひふえん /皮膚炎/
ひふか /皮膚科/
ひふく /被服/被覆/
ひふくきん /腓腹筋/
ひふびょう /皮膚病/
ひふみ /日文/
ひふん /悲憤/
ひぶ /日歩/
ひぶた /火蓋/
ひぶん /碑文/非分/
ひへい /疲弊/
ひへん /日偏/火偏/
ひほう /秘宝/悲報/秘法/非法/飛報/
ひほけんしゃ /被保険者/
ひほけんぶつ /被保険物/
ひほん /秘本/
ひぼう /誹謗/非望/
ひぼうりょく /非暴力/
ひぼし /干乾し/
ひぼん /非凡/
ひま /暇/閑/隙/
ひまく /皮膜/被膜/
ひまご /曾孫/
ひまし /日増し/
ひましに /日増しに/
ひましゆ /蓖麻子油/
ひまじん /暇人/閑人/
ひまち /日待ち/
ひまつ /飛沫/
ひまつでんせん /飛沫伝染/
ひまつぶし /暇潰し/
ひまつり /火祭/
ひまわり /向日葵/
ひまん /肥満/
ひまんしょう /肥満症/
ひみ /氷見/
ひみつ /秘密/
ひみつかい /秘密会/
ひみつけっしゃ /秘密結社/
ひみつつみたてきん /秘密積立金/
ひむかい /日向/
ひむろ /氷室/
ひめ /姫/媛/
ひめい /悲鳴/非命/碑銘/
ひめかいどう /姫街道/
ひめかわ /姫川/
ひめぎみ /姫君/
ひめごと /秘め事/
ひめじ /姫路/
ひめじじょう /姫路城/
ひめまつ /姫松/
ひめみや /姫宮/
ひめゆり /姫百合/
ひめん /罷免/
ひめんけん /罷免権/
ひも /紐/
ひもく /費目/皮目/
ひもち /日持ち/
ひもつき /紐付き/
ひもと /火元/
ひもの /干物/檜物/
ひゃく /百/
ひゃくがい /百害/
ひゃくしゅつ /百出/
ひゃくしょう /百姓/
ひゃくしょういっき /百姓一揆/
ひゃくしょうよみ /百姓読み/
ひゃくじ /百事/
ひゃくじゅう /百獣/
ひゃくせん /百選/百戦/百千/
ひゃくせんれんま /百戦練磨/
ひゃくそく /百足/
ひゃくたい /百態/
ひゃくだい /百代/
ひゃくど /百度/
ひゃくどまいり /百度参り/
ひゃくにち /百日/
ひゃくにちぜき /百日咳/
ひゃくにちそう /百日草/
ひゃくにん /百人/
ひゃくにんいっしゅ /百人一首/
ひゃくにんりき /百人力/
ひゃくねん /百年/
ひゃくねんせんそう /百年戦争/
ひゃくはちじゅうど /百八十度/
ひゃくはちぼんのう /百八煩悩/
ひゃくぶん /百聞/百分/
ひゃくぶんひ /百分比/
ひゃくぶんりつ /百分率/
ひゃくまん /百万/
ひゃくまんべん /百万遍/
ひゃくみ /百味/
ひゃくみだんす /百味箪笥/
ひゃくめんそう /百面相/
ひゃくものがたり /百物語/
ひゃくやく /百薬/
ひゃくやくのちょう /百薬の長/
ひゃくらい /百雷/
ひゃくり /百里/
ひゃっか /百科/百家/百花/
ひゃっかじてん /百科事典/百科辞典/
ひゃっかせいほう /百花斉放/
ひゃっかぜんしょ /百科全書/
ひゃっかぜんしょか /百科全書家/
ひゃっかそうめい /百家争鳴/
ひゃっかてん /百貨店/
ひゃっかりょうらん /百花繚乱/
ひゃっかん /百貫/百官/
ひゃっきやぎょう /百鬼夜行/
ひゃっけい /百計/
ひゃっこう /百行/
ひゃっぱん /百般/
ひゃっぽう /百方/
ひやあせ /冷汗/
ひやく /飛躍/秘薬/非役/
ひやくてき /飛躍的/
ひやけ /日焼け/
ひやま /檜山/
ひやみず /冷水/
ひやむぎ /冷麦/
ひやめし /冷飯/
ひややか /冷やか/
ひややっこ /冷奴/
ひゅうが /日向/
ひゅうがなだ /日向灘/
ひゆ /比喩/譬喩/
ひょう /表/豹/評/票/漂/氷/標/俵/拍/兵/瓢/平/雹/彪/
ひょうい /表意/憑依/
ひょうえ /兵衛/
ひょうおん /表音/
ひょうか /評価/氷菓/
ひょうかい /氷解/氷塊/氷海/
ひょうかえき /評価益/
ひょうかん /慓悍/
ひょうが /氷河/
ひょうがい /表外/
ひょうがき /氷河期/
ひょうがじだい /氷河時代/
ひょうき /表記/標記/氷期/
ひょうきほう /表記法/
ひょうきょ /憑拠/
ひょうきん /剽軽/標金/
ひょうぎ /評議/
ひょうぎいん /評議員/
ひょうぎかい /評議会/
ひょうぐ /表具/
ひょうけい /表敬/
ひょうけつ /氷結/票決/表決/評決/
ひょうけつけん /表決権/
ひょうけんだいり /表見代理/
ひょうげん /表現/氷原/評言/
ひょうげんけい /表現型/
ひょうげんは /表現派/
ひょうこう /標高/
ひょうご /標語/兵庫/評語/
ひょうごけん /兵庫県/
ひょうごもじ /表語文字/
ひょうさくさん /氷酢酸/
ひょうさつ /表札/
ひょうざん /氷山/
ひょうし /表紙/拍子/
ひょうしき /標識/表式/
ひょうしきとう /標識灯/
ひょうしぎ /拍子木/
ひょうしつ /氷室/
ひょうしぬけ /拍子抜け/
ひょうしゃ /評者/
ひょうしゃく /評釈/
ひょうしゅつ /表出/
ひょうしょう /表象/表彰/標章/氷床/氷晶/
ひょうじ /表示/標示/
ひょうじゅん /標準/
ひょうじゅんか /標準化/
ひょうじゅんきかく /標準規格/
ひょうじゅんきかん /標準軌間/
ひょうじゅんご /標準語/
ひょうじゅんじ /標準時/
ひょうじゅんてき /標準的/
ひょうじゅんでんぱ /標準電波/
ひょうじゅんへんさ /標準偏差/
ひょうじょう /表情/平調/氷上/評定/
ひょうじょうしゅう /評定衆/
ひょうせつ /氷雪/剽窃/評説/
ひょうぜん /飄然/
ひょうそう /表層/表装/
ひょうそうなだれ /表層雪崩/
ひょうそく /平仄/
ひょうたん /瓢箪/氷炭/
ひょうたんなまず /瓢箪鯰/
ひょうだい /表題/標題/
ひょうだん /評壇/
ひょうちゃく /漂着/
ひょうちゅう /標注/氷柱/標註/標柱/
ひょうちょう /漂鳥/
ひょうちん /氷枕/
ひょうてい /評定/
ひょうていしゃくど /評定尺度/
ひょうてき /標的/
ひょうてん /氷点/評点/
ひょうてんか /氷点下/
ひょうでん /評伝/票田/
ひょうど /表土/
ひょうのう /氷嚢/
ひょうはく /漂白/漂泊/表白/
ひょうはくざい /漂白剤/
ひょうばん /評判/
ひょうばんき /評判記/
ひょうひ /表皮/
ひょうひょう /飄々/飄飄/
ひょうびょう /縹渺/縹眇/縹緲/
ひょうぶ /兵部/
ひょうへき /氷壁/
ひょうへん /豹変/
ひょうほう /兵法/
ひょうほん /標本/
ひょうぼう /標榜/
ひょうめい /表明/
ひょうめん /表面/
ひょうめんか /表面化/
ひょうめんしょり /表面処理/
ひょうめんせき /表面積/
ひょうめんは /表面波/
ひょうもく /標目/
ひょうよみ /票読み/
ひょうり /表裏/
ひょうりいったい /表裏一体/
ひょうりゅう /漂流/
ひょうりょう /秤量/
ひょうりん /評林/
ひょうろう /兵糧/
ひょうろうぜめ /兵糧攻め/
ひょうろん /評論/
ひょうろんか /評論家/
ひよう /費用/比容/日傭/飛揚/
ひようしゃ /被用者/
ひよく /肥沃/比翼/
ひよくれんり /比翼連理/
ひよけ /日除け/火除け/
ひよこ /雛/
ひよどり /鵯/
ひより /日和/
ひよりみ /日和見/
ひよりみしゅぎ /日和見主義/
ひら /平/片/
ひらあやまり /平謝り/
ひらい /平井/飛来/避雷/
ひらいし /平石/
ひらいしん /避雷針/
ひらいずみ /平泉/
ひらうち /平打/
ひらおし /平押し/
ひらおよぎ /平泳/
ひらおり /平織/
ひらかた /枚方/
ひらが /平賀/
ひらがげんない /平賀源内/
ひらがな /平仮名/
ひらきど /開き戸/
ひらきふう /開き封/
ひらぎぬ /平絹/
ひらこ /平子/
ひらさん /比良山/
ひらざら /平皿/
ひらしま /平島/
ひらしゃいん /平社員/
ひらじ /平地/
ひらじょう /平城/
ひらじろ /平城/
ひらせ /平瀬/
ひらぞこ /平底/
ひらた /平田/
ひらだい /平台/
ひらち /平地/
ひらつか /平塚/
ひらつぼ /平坪/
ひらて /平手/
ひらとじ /平綴じ/
ひらど /平戸/
ひらどま /平土間/
ひらなべ /平鍋/
ひらにわ /平庭/
ひらぬま /平沼/
ひらの /平野/
ひらのじんじゃ /平野神社/
ひらはし /平橋/
ひらば /平場/
ひらばやし /平林/
ひらばり /平針/
ひらひも /平紐/
ひらふく /平福/
ひらまく /平幕/
ひらまつ /平松/
ひらめ /鮃/平目/
ひらめき /閃き/
ひらや /平屋/
ひらら /平良/
ひり /非理/
ひりき /非力/
ひりつ /比率/
ひりゅう /飛竜/
ひりょう /肥料/
ひりょく /臂力/
ひりん /比倫/比隣/
ひる /昼/蛭/蒜/
ひるあんどん /昼行灯/
ひるい /比類/
ひるがお /昼顔/
ひるげ /昼餉/
ひるこ /蛭子/
ひるごはん /昼御飯/
ひるさがり /昼下り/
ひるざけ /昼酒/
ひるすぎ /昼過ぎ/
ひるぜん /蒜山/
ひるた /蛭田/
ひるどき /昼時/
ひるなか /昼中/
ひるね /昼寝/
ひるひなか /昼日中/
ひるま /昼間/
ひるまえ /昼前/
ひるめし /昼飯/
ひるやすみ /昼休み/
ひれ /鰭/
ひれい /比例/非礼/
ひれいぜい /比例税/
ひれいていすう /比例定数/
ひれいはいぶん /比例配分/
ひれき /披瀝/
ひれつ /卑劣/
ひれん /悲恋/
ひろ /尋/裕/
ひろいもの /拾い物/
ひろいよみ /拾い読み/
ひろう /疲労/披露/
ひろうえん /披露宴/
ひろうこんぱい /疲労困憊/
ひろえん /広縁/
ひろく /秘録/
ひろくち /広口/
ひろこうじ /広小路/
ひろさき /弘前/
ひろさきだいがく /弘前大学/
ひろさわ /広沢/
ひろしげ /広重/
ひろしま /広島/
ひろしまけん /広島県/
ひろしまし /広島市/
ひろしまだいがく /広島大学/
ひろせ /広瀬/
ひろそで /広袖/
ひろた /広田/弘田/
ひろつ /広津/
ひろの /広野/
ひろはし /広橋/
ひろはば /広幅/
ひろば /広場/
ひろびろ /広々/
ひろま /広間/
ひろまえ /広前/
ひろみつ /広光/
ひろんりてき /非論理的/
ひわ /秘話/悲話/鶸/
ひわい /卑猥/鄙猥/
ひわいろ /鶸色/
ひわたり /火渡り/
ひわだいろ /檜皮色/
ひわちゃ /鶸茶/
ひわり /日割/
ひわれ /干割れ/
ひん /頻/賓/貧/浜/品/顰/嬪/牝/瀕/斌/彬/
ひんい /品位/
ひんか /貧家/
ひんかく /品格/賓客/
ひんきゃく /賓客/
ひんきゅう /殯宮/貧窮/
ひんぎ /稟議/
ひんく /貧苦/
ひんけつ /貧血/
ひんこう /品行/貧鉱/
ひんこうほうせい /品行方正/
ひんこん /貧困/
ひんし /品詞/瀕死/
ひんしつ /品質/
ひんしつかんり /品質管理/
ひんしゅ /品種/
ひんしゅかいりょう /品種改良/
ひんしゅく /顰蹙/
ひんしゅつ /頻出/
ひんしょう /貧小/
ひんしるい /貧歯類/
ひんじ /賓辞/
ひんじゃ /貧者/
ひんじゃく /貧弱/
ひんせい /品性/稟性/
ひんそう /貧相/
ひんそん /貧村/
ひんだ /貧打/
ひんとう /品等/
ひんど /頻度/貧土/
ひんのう /貧農/
ひんば /牝馬/
ひんばん /品番/
ひんぱつ /頻発/
ひんぱん /頻繁/
ひんぴょう /品評/
ひんぴょうかい /品評会/
ひんぷ /貧富/
ひんみゃく /頻脈/
ひんみん /貧民/
ひんみんくつ /貧民窟/
ひんめい /品名/
ひんもく /品目/
び /鼻/美/眉/微/尾/備/媚/靡/未/毘/
び> /微/
びーる /麦酒/
びい /微意/
びいしき /美意識/
びう /眉宇/微雨/
びえん /鼻炎/
びおん /鼻音/微温/美音/微音/
びか /美化/
びかん /美観/美感/
びがく /美学/
びがん /美顔/
びき /美姫/
びきょ /美挙/
びきょう /鼻鏡/
びぎ /美技/美妓/
びくしょう /微苦笑/
びくに /比丘尼/
びけい /美形/美景/
びけいすう /微係数/
びげん /美言/
びこう /備考/尾行/鼻孔/鼻腔/微光/微香/備荒/微行/
びこつ /尾骨/
びさい /微細/尾西/
びざい /微罪/
びしつ /美質/
びしてき /微視的/
びしゃもん /毘沙門/
びしゃもんてん /毘沙門天/
びしゃもんどう /毘沙門堂/
びしゅ /美酒/
びしゅう /美醜/
びしょう /微少/微笑/微小/美称/美粧/微傷/
びしょうじしん /微小地震/
びしょうじょ /美少女/
びしょうねん /美少年/
びしょく /美食/
びしょぬれ /びしょ濡れ/
びしん /微震/美神/美身/
びじ /美辞/
びじゃく /微弱/
びじゅつ /美術/
びじゅつかん /美術館/
びじゅつし /美術史/
びじゅつひん /美術品/
びじょ /美女/
びじょう /尾錠/
びじょうふ /美丈夫/
びじょざくら /美女桜/
びじれいく /美辞麗句/
びじん /美人/
びすい /微酔/微睡/
びせい /美声/
びせいぶつ /微生物/
びせきぶん /微積分/
びせきぶんがく /微積分学/
びぜん /備前/靡然/
びぜんやき /備前焼/
びそう /美装/
びぞう /微増/
びぞく /美俗/
びた /鐚/
びたい /媚態/
びたいちもん /鐚一文/
びたせん /鐚銭/
びだい /尾大/
びだくおん /鼻濁音/
びだん /美談/
びだんし /美男子/
びちく /備蓄/
びちゅう /微衷/
びちゅうかく /鼻中隔/
びちょうせい /微調整/
びっくり /！/
びっこ /跛/
びっちゅう /備中/
びてき /美的/
びてん /美点/
びでん /美田/
びとう /尾灯/尾藤/
びとく /美徳/
びどう /微動/
びなん /美男/
びなんし /美男子/
びねつ /微熱/
びはく /美白/
びはつ /美髪/
びばい /美唄/
びひん /備品/
びび /微々/
びふう /微風/美風/
びふく /微服/
びぶん /微分/美文/
びぶんがく /微分学/
びぶんきかがく /微分幾何学/
びぶんけいすう /微分係数/
びぶんほうていしき /微分方程式/
びほう /弥縫/
びほん /美本/
びぼいん /鼻母音/
びぼう /美貌/備忘/
びぼうろく /備忘録/
びまん /瀰漫/
びみ /美味/
びみょう /微妙/美妙/
びめい /美名/
びもく /眉目/
びゃく /白/
びゃくい /白衣/
びゃくえ /白衣/
びゃくだん /白檀/
びゃくや /白夜/
びゃくれん /白蓮/
びゃっこ /白虎/白狐/
びゃっこたい /白虎隊/
びやく /媚薬/
びゅう /謬/
びょう /秒/平/鋲/苗/病/描/廟/猫/渺/眇/錨/
びょういん /病院/病因/
びょうか /病家/
びょうかん /病患/病間/
びょうが /描画/病臥/
びょうがい /病害/
びょうき /病気/病期/
びょうきん /病菌/
びょうく /病苦/病躯/
びょうけつ /病欠/
びょうげん /病原/病源/
びょうげんきん /病原菌/
びょうげんたい /病原体/
びょうこん /病根/
びょうご /病後/
びょうし /病死/
びょうしき /病識/
びょうしつ /病室/
びょうしゃ /描写/病舎/病者/
びょうしゅつ /描出/
びょうしょ /廟所/
びょうしょう /病床/病症/
びょうしん /病身/秒針/
びょうじゃく /病弱/
びょうじょう /病状/苗条/
びょうせい /病勢/
びょうそう /病巣/
びょうそく /秒速/
びょうたい /病態/病体/
びょうち /錨地/
びょうちゅう /病中/
びょうちゅうがい /病虫害/
びょうてき /病的/
びょうとう /病棟/
びょうどう /平等/廟堂/
びょうどういん /平等院/
びょうどうかん /平等観/
びょうどうしゅぎ /平等主義/
びょうどく /病毒/
びょうなん /病難/
びょうにん /病人/
びょうびょう /渺渺/眇眇/
びょうぶ /屏風/
びょうぶえ /屏風絵/
びょうへい /病弊/
びょうへき /病癖/
びょうへん /病変/
びょうぼつ /病没/
びょうま /病魔/
びょうめい /病名/
びょうゆう /病友/
びょうよみ /秒読み/
びょうり /病理/
びょうりかいぼう /病理解剖/
びょうりがく /病理学/
びょうれき /病歴/
びよう /美容/
びよういん /美容院/
びようし /美容師/
びよく /尾翼/鼻翼/
びらん /糜爛/
びりゅうし /微粒子/
びりょう /鼻梁/微量/
びりょく /微力/
びるいかん /鼻涙管/
びるま /緬甸/
びれい /美麗/
びろーど /天鵞絨/
びろく /美禄/微禄/
びわ /枇杷/琵琶/
びわき /琵琶記/
びわこ /琵琶湖/
びん /瓶/敏/貧/便/憫/緡/鬢/
びんかつ /敏活/
びんかん /敏感/
びんが /頻伽/
びんぎ /便宜/
びんぐし /鬢櫛/
びんご /備後/
びんさつ /憫察/
びんしょう /敏捷/憫笑/
びんじょう /便乗/
びんせん /便箋/便船/
びんぜん /愍然/
びんそく /敏速/
びんちょう /備長/
びんづめ /瓶詰/
びんぼう /貧乏/
びんぼうがみ /貧乏神/
びんぼうくじ /貧乏籤/
びんぼうしょう /貧乏性/
びんぼうにん /貧乏人/
びんらん /便覧/紊乱/
びんわん /敏腕/
ぴかいち /光一/
ぴょんやん /平壌/
ふ /父/負/附/赴/賦/譜/腐/符/浮/普/敷/扶/怖/府/布/富/婦/夫/付/不/風/歩/膚/生/傅/巫/桴/腑/訃/賻/麩/冨/埠/斧/阜/
ふ> /不/負/
ふあん /不安/
ふあんてい /不安定/
ふあんない /不案内/
ふぃーと /呎/
ふぃりぴん /比律賓/
ふぃんらんど /芬蘭/
ふい /不意/
ふいうち /不意打/
ふいく /扶育/
ふいちょう /吹聴/
ふいっち /不一致/
ふいつ /不一/
ふいふいきょう /回回教/
ふいり /不入り/
ふいん /訃音/
ふう /風/封/夫/富/楓/諷/
ふうあつ /風圧/
ふうい /風位/
ふういん /封印/風韻/
ふうう /風雨/
ふううん /風雲/
ふううんじ /風雲児/
ふうえい /諷詠/
ふうか /風化/
ふうかい /諷戒/風懐/風解/
ふうかく /風格/
ふうかん /風乾/封緘/
ふうが /風雅/
ふうがい /風害/
ふうがら /風柄/
ふうがわり /風変り/
ふうがん /風眼/
ふうき /風紀/富貴/
ふうきょう /風狂/
ふうきり /封切/
ふうきん /風琴/
ふうぎ /風儀/
ふうけい /風景/
ふうけつ /風穴/
ふうげつ /風月/
ふうこう /風光/風向/
ふうこうけい /風向計/
ふうこうめいび /風光明媚/
ふうさ /封鎖/
ふうさい /風采/風災/
ふうさつ /封殺/
ふうさんろしゅく /風餐露宿/
ふうし /風刺/諷刺/夫子/風姿/
ふうしかでん /風姿花伝/
ふうしゃ /風車/
ふうしゅ /風趣/
ふうしゅう /風習/
ふうしょ /封書/
ふうしん /風疹/
ふうじ /封じ/
ふうじて /封じ手/
ふうじん /風神/風塵/
ふうすい /風水/
ふうすいがい /風水害/
ふうせい /風勢/風声/
ふうせいかくれい /風声鶴唳/
ふうせつ /風雪/風説/
ふうせん /風船/
ふうせんだま /風船玉/
ふうせんばくだん /風船爆弾/
ふうぜん /風前/
ふうぜんのともしび /風前の灯/
ふうそう /風葬/風霜/風騒/
ふうそく /風速/
ふうそくけい /風速計/
ふうぞく /風俗/
ふうたい /風袋/風帯/風体/
ふうたく /風鐸/
ふうち /風致/
ふうちちく /風致地区/
ふうちょう /風潮/風鳥/
ふうちりん /風致林/
ふうちん /風鎮/
ふうつう /風通/
ふうてい /風体/
ふうてん /瘋癲/
ふうとう /封筒/
ふうとうぼく /風倒木/
ふうど /風土/
ふうどう /風洞/
ふうどしょく /風土色/
ふうどびょう /風土病/
ふうにゅう /封入/
ふうは /風波/
ふうはく /風伯/
ふうはつ /風発/
ふうばいか /風媒花/
ふうばぎゅう /風馬牛/
ふうひ /封皮/
ふうひょう /風評/
ふうび /風靡/
ふうふ /夫婦/
ふうふげんか /夫婦喧嘩/
ふうふざいさんせい /夫婦財産制/
ふうぶつ /風物/
ふうぶつし /風物詩/
ふうぶん /風聞/
ふうぼう /風貌/風防/
ふうみ /風味/
ふうもん /風紋/
ふうらい /風来/
ふうらいぼう /風来坊/
ふうりゅう /風流/
ふうりゅういんじ /風流韻事/
ふうりゅうじん /風流人/
ふうりょく /風力/
ふうりょくはつでん /風力発電/
ふうりん /風鈴/
ふうりんかざん /風林火山/
ふうろう /封蝋/風浪/
ふうん /不運/浮雲/
ふえ /笛/不壊/吭/鰾/
ふえいせい /不衛生/
ふえいようか /富栄養化/
ふえき /不易/賦役/
ふえきりゅうこう /不易流行/
ふえて /不得手/
ふえん /不縁/敷衍/
ふおうせんそう /普墺戦争/
ふおん /不穏/
ふおんとう /不穏当/
ふか /付加/負荷/不可/孵化/府下/鱶/賦課/附加/浮華/富家/
ふかい /不快/深い/深井/府会/附会/付会/不会/
ふかいしすう /不快指数/
ふかいにゅう /不介入/
ふかいり /深入り/
ふかえ /深江/
ふかお /深尾/
ふかおい /深追い/
ふかかい /不可解/
ふかかち /付加価値/
ふかかちぜい /付加価値税/
ふかがわ /深川/
ふかぎゃくへんか /不可逆変化/
ふかく /不覚/俯角/
ふかくさ /深草/
ふかくじつ /不確実/
ふかくだい /不拡大/
ふかくてい /不確定/
ふかくていきげん /不確定期限/
ふかけつ /不可欠/
ふかこうりょく /不可抗力/
ふかさ /深さ/
ふかさわ /深沢/
ふかさんめいし /不可算名詞/
ふかざけ /深酒/
ふかざわ /深沢/
ふかし /不可視/
ふかしぎ /不可思議/
ふかしん /不可侵/
ふかせつ /不可説/
ふかぜい /付加税/附加税/
ふかそく /不可測/
ふかだ /深田/
ふかちろん /不可知論/
ふかっぱつ /不活発/
ふかつ /賦活/
ふかづめ /深爪/
ふかなさけ /深情け/
ふかの /深野/
ふかのう /不可能/
ふかひ /不可避/深緋/
ふかぶか /深々/
ふかぶん /不可分/
ふかみ /深み/
ふかみどり /深緑/
ふかむらさき /深紫/
ふかや /深谷/
ふかよみ /深読み/
ふかん /俯瞰/
ふかんしへい /不換紙幣/
ふかんしょう /不干渉/不感症/
ふかんず /俯瞰図/
ふかんせいゆ /不乾性油/
ふかんぜん /不完全/
ふがく /富嶽/不学/
ふき /付記/附記/苳/不軌/不帰/蕗/葺/
ふきあげ /吹上げ/
ふきかえ /吹替え/
ふきげん /不機嫌/
ふきさらし /吹き曝し/
ふきそ /不起訴/
ふきそうじ /拭き掃除/
ふきそく /不規則/
ふきだし /吹き出し/
ふきだまり /吹き溜り/
ふきつ /不吉/
ふきつけ /吹付け/
ふきでもの /吹出物/
ふきながし /吹流し/
ふきぬけ /吹抜け/
ふきのとう /蕗の薹/
ふきぶり /吹き降り/
ふきまわし /吹き回し/
ふきや /吹矢/吹屋/
ふきゅう /普及/不休/不朽/不急/腐朽/
ふきょう /布教/不況/不興/富強/
ふきょうほう /不競法;不正競争防止法/
ふきょうわ /不協和/
ふきょうわおん /不協和音/
ふきょか /不許可/
ふきん /付近/布巾/附近/賦金/
ふきんこう /不均衡/
ふきんしん /不謹慎/
ふぎ /不義/付議/府議/
ふぎかい /府議会/
ふぎょうぎ /不行儀/
ふぎょうじょう /不行状/
ふぎょうせき /不行跡/
ふぎり /不義理/
ふく /覆/幅/腹/福/服/複/復/副/伏/輻/
ふく> /副/複/
ふくあつ /腹圧/
ふくあん /腹案/
ふくい /福井/復位/
ふくいけん /福井県/
ふくいし /福井市/
ふくいん /福音/復員/幅員/副因/
ふくいんしょ /福音書/
ふくうん /福運/
ふくえ /福江/
ふくえき /服役/
ふくえん /復縁/復円/
ふくおか /福岡/
ふくおかけん /福岡県/
ふくおかし /福岡市/
ふくおかだいがく /福岡大学/
ふくかん /副官/
ふくが /伏臥/
ふくがく /復学/
ふくがみ /福紙/
ふくがん /複眼/
ふくがんてき /複眼的/
ふくぎ /福木/
ふくぎちょう /副議長/
ふくぎょう /副業/
ふくくっせつ /複屈折/
ふくけい /復啓/
ふくけんじ /副検事/
ふくげん /復元/復原/
ふくこう /腹腔/
ふくこうがん /副睾丸/
ふくごう /復号/複合/
ふくごうおせん /複合汚染/
ふくごうご /複合語/
ふくごうたい /複合体/
ふくさ /袱紗/帛紗/
ふくさい /副菜/
ふくさよう /副作用/
ふくさんぶつ /副産物/
ふくざい /伏在/服罪/
ふくざつ /複雑/
ふくざつかいき /複雑怪奇/
ふくざつこっせつ /複雑骨折/
ふくざわ /福沢/
ふくし /福祉/副詞/復氏/副使/複視/
ふくしき /複式/
ふくしきこきゅう /腹式呼吸/
ふくしきぼき /複式簿記/
ふくしこっか /福祉国家/
ふくしま /福島/
ふくしまけん /福島県/
ふくしまし /福島市/
ふくしゃ /複写/輻射/伏射/
ふくしゃき /複写機/
ふくしゃし /複写紙/
ふくしゃせん /輻射線/
ふくしゃねつ /輻射熱/
ふくしゅ /副手/
ふくしゅう /復習/復讐/福州/
ふくしゅうにゅう /副収入/
ふくしょ /副書/副署/
ふくしょう /復唱/副賞/副将/復誦/副章/
ふくしょうぐん /副将軍/
ふくしょうしき /複勝式/
ふくしょく /復職/服飾/
ふくしょくひん /服飾品/
ふくしょくぶつ /副食物/
ふくしん /腹心/復申/
ふくじ /服地/福地/
ふくじてき /副次的/
ふくじゅ /福寿/
ふくじゅう /服従/
ふくじゅそう /福寿草/
ふくじょし /副助詞/
ふくじん /副腎/
ふくじんづけ /福神漬/
ふくじんひしつ /副腎皮質/
ふくすい /覆水/腹水/
ふくすう /複数/
ふくすけ /福助/
ふくせい /複製/服制/復姓/
ふくせき /復席/復籍/
ふくせん /伏線/複線/
ふくそう /服装/福相/副葬/複相/
ふくそうり /副総理/
ふくそかんすう /複素関数/
ふくそくるい /腹足類/
ふくそすう /複素数/
ふくそへいめん /複素平面/
ふくぞう /腹蔵/
ふくぞく /服属/
ふくたい /腹帯/
ふくたけ /福武/
ふくだ /福田/
ふくだい /副題/
ふくだいり /復代理/
ふくち /福地/
ふくちじ /副知事/
ふくちやま /福知山/
ふくちゅう /腹中/
ふくちょう /復調/副長/
ふくつ /不屈/
ふくつう /腹痛/
ふくとう /復党/
ふくとく /福徳/
ふくとしん /副都心/
ふくとみ /福富/
ふくど /覆土/
ふくどく /服毒/
ふくどくほん /副読本/
ふくなが /福永/
ふくのかみ /福の神/
ふくはい /復配/腹背/
ふくはら /福原/
ふくひ /複比/
ふくひれい /複比例/
ふくびき /福引/
ふくびこう /副鼻腔/
ふくふくせん /複複線/複々線/
ふくぶ /腹部/
ふくぶくろ /福袋/
ふくぶん /複文/復文/福分/
ふくぶんすう /複分数/
ふくへい /伏兵/
ふくへき /腹壁/
ふくほう /副砲/複方/
ふくほん /副本/複本/
ふくぼく /副木/
ふくぼつ /覆没/
ふくまく /腹膜/
ふくまくえん /腹膜炎/
ふくまでん /伏魔殿/
ふくまめ /福豆/
ふくみ /含み/
ふくみえき /含み益/
ふくみごえ /含み声/
ふくみしさん /含み資産/
ふくみみ /福耳/
ふくみわらい /含み笑い/
ふくむ /服務/
ふくめい /復命/
ふくめつ /覆滅/
ふくめに /含め煮/
ふくめん /覆面/
ふくも /服喪/
ふくもと /福本/
ふくやく /服薬/
ふくやま /福山/
ふくよう /服用/複葉/
ふくようき /複葉機/
ふくよか /脹よか/膨よか/
ふくよし /福吉/
ふくらはぎ /脹脛/
ふくり /福利/複利/
ふくりき /福力/
ふくりゅう /伏流/
ふくろ /袋/復路/嚢/
ふくろあみ /袋網/
ふくろい /袋井/
ふくろいりぼん /袋入本/
ふくろう /梟/
ふくろおび /袋帯/
ふくろおり /袋織/
ふくろくじゅ /福禄寿/
ふくろこうじ /袋小路/
ふくろぞうし /袋草紙/
ふくろだおんせん /袋田温泉/
ふくろだたき /袋叩き/
ふくろだな /袋棚/
ふくろとじ /袋綴じ/
ふくろとだな /袋戸棚/
ふくろど /袋戸/
ふくろぬい /袋縫い/
ふくろのねずみ /袋の鼠/
ふくろばり /袋貼り/
ふくろまち /袋町/
ふくろもの /袋物/
ふくわじゅつ /腹話術/
ふくん /夫君/父君/
ふぐ /河豚/鰒/不具/
ふぐあい /不具合/
ふぐう /不遇/
ふぐたいてん /不倶戴天/
ふけい /父兄/婦警/父系/不敬/
ふけいかい /父兄会/
ふけいき /不景気/
ふけいざい /不経済/不敬罪/賦形剤/
ふけいせい /父系制/
ふけだ /深田/
ふけっか /不結果/
ふけつ /不潔/
ふけやく /老け役/
ふけん /府県/父権/夫権/
ふけんこう /不健康/
ふけんしき /不見識/
ふけんぜん /不健全/
ふげん /付言/不言/普賢/富源/
ふげんじっこう /不言実行/
ふこ /巫蠱/
ふこう /不幸/不孝/
ふこうせい /不公正/
ふこうせいとりひき /不公正取引/
ふこうへい /不公平/
ふこく /布告/富国/
ふこくきょうへい /富国強兵/
ふこころえ /不心得/
ふこつ /腐骨/
ふごう /符号/負号/符合/富豪/附合/
ふごうか /符号化/
ふごうかく /不合格/
ふごうり /不合理/
ふさ /房/総/
ふさい /夫妻/負債/不才/
ふさく /不作/
ふさくい /不作為/
ふさくいさいむ /不作為債務/
ふさくいはん /不作為犯/
ふさん /不参/
ふざ /趺坐/
ふざい /不在/
ふざん /釜山/
ふし /節/不死/父子/
ふしあな /節穴/
ふしあわせ /不仕合せ/
ふしいと /節糸/
ふしき /伏木/
ふしぎ /不思議/
ふしぜん /不自然/
ふしちょう /不死鳥/
ふしつ /不悉/
ふしづけ /節付け/
ふしど /臥所/
ふしぶし /節々/
ふしまつ /不始末/
ふしまわし /節回し/
ふしみ /伏見/
ふしみじょう /伏見城/
ふしみばん /伏見版/
ふしめ /伏し目/節目/
ふしゃ /富者/
ふしゃくしんみょう /不惜身命/
ふしゅ /浮腫/
ふしゅう /腐臭/
ふしゅつ /不出/
ふしゅび /不首尾/
ふしょう /負傷/不詳/不肖/不承/不祥/
ふしょうか /不消化/
ふしょうじ /不祥事/
ふしょうじき /不正直/
ふしょうち /不承知/
ふしょうにん /不承認/
ふしょうふずい /夫唱婦随/
ふしょうぶしょう /不承不承/
ふしょく /不食/腐食/腐蝕/扶植/
ふしょくど /腐植土/
ふしょくふ /不織布/
ふしょぞん /不所存/
ふしん /不信/不審/腐心/普請/不振/
ふしんがみ /不審紙/
ふしんせつ /不親切/
ふしんにん /不信任/
ふしんにんあん /不信任案/
ふしんばん /不寝番/
ふじ /富士/藤/不二/不時/不治/
ふじい /藤井/
ふじいでら /藤井寺/
ふじいろ /藤色/
ふじえだ /藤枝/
ふじおか /藤岡/
ふじかわ /藤川/富士川/
ふじがわ /富士川/
ふじき /藤木/
ふじごこ /富士五湖/
ふじさわ /藤沢/
ふじさん /富士山/
ふじしま /藤島/
ふじた /藤田/
ふじたに /富士谷/
ふじだな /藤棚/
ふじちゃく /不時着/
ふじつ /不実/不日/
ふじづか /富士塚/
ふじと /藤戸/
ふじなみ /藤波/
ふじなわ /藤縄/
ふじのみや /富士宮/
ふじばかま /藤袴/
ふじびたい /富士額/
ふじまりゅう /藤間流/
ふじみ /富士見/不死身/
ふじむら /藤村/
ふじむらさき /藤紫/
ふじもと /藤本/
ふじもり /藤森/
ふじやま /藤山/
ふじやまかんび /藤山寛美/
ふじゅうぶん /不十分/
ふじゅく /不熟/
ふじゅん /不順/不純/
ふじゆう /不自由/
ふじょ /婦女/扶助/巫女/
ふじょう /浮上/不浄/不定/
ふじょうり /不条理/
ふじょし /婦女子/
ふじよしだ /富士吉田/
ふじわら /藤原/
ふじわらきょう /藤原京/
ふじん /夫人/婦人/布陣/不尽/
ふじんか /婦人科/
ふじんかい /婦人会/
ふじんびょう /婦人病/
ふすう /負数/
ふすま /襖/衾/
ふすまえ /襖絵/
ふず /付図/
ふずい /付随/附随/不随/
ふずいい /不随意/
ふずいいきん /不随意筋/
ふせ /布施/伏せ/
ふせい /不正/不整/不斉/父性/府政/
ふせいかく /不正確/
ふせいきょうそうぼうしほう /不正競争防止法/
ふせいこう /不成功/
ふせいごう /不整合/
ふせいしゅつ /不世出/
ふせいじつ /不誠実/
ふせいせき /不成績/
ふせいみゃく /不整脈/
ふせいりつ /不成立/
ふせき /布石/
ふせぎ /伏木/
ふせじ /伏せ字/
ふせっせい /不摂生/
ふせつ /敷設/付設/布設/浮説/符節/
ふせや /伏屋/
ふせん /不戦/付箋/附箋/不宣/普選/
ふせんしょう /不戦勝/
ふせんめい /不鮮明/
ふぜい /風情/
ふぜん /不全/不善/
ふそ /父祖/
ふそう /扶桑/
ふそうおう /不相応/
ふそく /不足/附則/不測/付則/
ふそくふり /不即不離/
ふそん /不遜/
ふぞく /附属/付属/
ふぞくご /付属語/
ふぞくし /付属肢/
ふぞくひん /付属品/
ふぞろい /不揃い/
ふた /二/蓋/双/
ふたあい /二藍/
ふたあけ /蓋明け/
ふたい /付帯/附帯/
ふたいこうそ /付帯控訴/
ふたいぜい /付帯税/
ふたいてん /不退転/
ふたえ /二重/
ふたおや /二親/
ふたかた /二方/
ふたく /付託/負託/
ふたこ /二子/
ふたこと /二言/
ふたことめ /二言目/
ふたご /双子/
ふたござ /双子座/
ふたごやま /二子山/
ふたしか /不確か/
ふたすじ /二筋/
ふたせ /二瀬/
ふたせがわ /二瀬川/
ふたたび /再び/
ふたつ /二つ/不達/布達/
ふたつおり /二つ折/
ふたつへんじ /二つ返事/
ふたつめ /二つ目/
ふたつわり /二つ割り/
ふたて /二手/
ふたなり /二形/
ふたば /双葉/二葉/
ふたばていしめい /二葉亭四迷/
ふたばやま /双葉山/
ふたま /二間/
ふたまた /二股/
ふたまたごうやく /二股膏薬/
ふたみち /二道/
ふため /二目/不為/
ふたもじ /二文字/
ふたり /二人/
ふたん /負担/
ふだ /札/簡/
ふだい /譜代/
ふだしょ /札所/
ふだつき /札付/
ふだのつじ /札の辻/
ふだば /札場/
ふだらく /普陀落/補陀落/
ふだん /不断/普段/
ふだんぎ /普段着/
ふち /淵/縁/付置/扶持/附置/布置/不治/不知/
ふちあんない /不知案内/
ふちじ /府知事/
ふちまい /扶持米/
ふちゃく /付着/不着/
ふちゅう /府中/不忠/釜中/
ふちゅうい /不注意/
ふちょう /不調/符牒/府庁/婦長/符丁/
ふちょうわ /不調和/
ふちん /浮沈/
ふっかく /伏角/
ふっかすいそ /弗化水素/
ふっかつ /復活/
ふっかつさい /復活祭/
ふっかん /復刊/
ふっき /復帰/
ふっきゅう /復旧/復仇/
ふっきん /腹筋/
ふっけん /復権/福建/
ふっこ /復古/
ふっこう /復興/復航/復校/
ふっこく /復刻/覆刻/
ふっさ /福生/
ふっしょく /払拭/
ふっせき /沸石/
ふっつ /富津/
ふってい /払底/
ふってん /沸点/
ふっとう /沸騰/
ふっとうてん /沸騰点/
ふつ /沸/払/仏/弗/
ふついん /仏印/
ふつう /普通/不通/
ふつうきょういく /普通教育/
ふつうけつぎ /普通決議/
ふつうじどうしゃ /普通自動車/
ふつうじん /普通人/
ふつうせんきょ /普通選挙/
ふつうぜい /普通税/
ふつうほう /普通法/
ふつうめいし /普通名詞/
ふつうよきん /普通預金/
ふつうれっしゃ /普通列車/
ふつか /二日/
ふつかよい /二日酔い/
ふつぎょう /払暁/
ふつご /仏語/
ふつごう /不都合/
ふつじん /仏人/
ふつつか /不束/
ふつぶん /仏文/
ふつりあい /不釣合/
ふつりょう /仏領/
ふづき /文月/
ふづくえ /文机/
ふてい /不定/不貞/不逞/不弟/不悌/婦弟/
ふていかんし /不定冠詞/
ふていき /不定期/
ふていきけい /不定期刑/
ふていけい /不定形/
ふていこん /不定根/
ふていさい /不体裁/
ふていし /不定詞/
ふていしょう /不定称/
ふていせきぶん /不定積分/
ふてき /不適/不敵/
ふてきおう /不適応/
ふてきとう /不適当/
ふてきにん /不適任/
ふてぎわ /不手際/
ふてってい /不徹底/
ふてね /ふて寝/
ふてん /普天/
ふてんそっと /普天率土/
ふで /筆/
ふでいれ /筆入れ/
ふでがしら /筆頭/
ふでき /不出来/
ふでさき /筆先/
ふでたて /筆立て/
ふでづかい /筆遣い/
ふでばこ /筆箱/
ふでぶしょう /筆無精/
ふでぶと /筆太/
ふでんき /負電気/
ふと /太/
ふとう /不当/埠頭/不等/不撓/不党/
ふとういつ /不統一/
ふとうえき /不凍液/
ふとうおう /不倒翁/
ふとうこう /不凍港/
ふとうごう /不等号/
ふとうしき /不等式/
ふとうしょぶん /不当処分/
ふとうひょうじ /不当表示/
ふとうふくつ /不撓不屈/
ふとうめい /不透明/
ふとうりとく /不当利得/
ふとく /不徳/婦徳/
ふとくい /不得意/
ふとくぎ /不徳義/
ふとくさく /不得策/
ふとくてい /不特定/
ふとくていたすう /不特定多数/
ふとくようりょう /不得要領/
ふところ /懐/
ふところがたな /懐刀/
ふところがみ /懐紙/
ふところで /懐手/
ふとざお /太棹/
ふとっちょ /太っちょ/
ふとっぱら /太っ腹/
ふとどき /不届き/
ふとまき /太巻/
ふともの /太物/
ふともも /太股/
ふとりじし /太り肉/
ふとん /布団/蒲団/
ふどう /浮動/不同/不動/
ふどうい /不同意/
ふどうさん /不動産/
ふどうたい /不導体/不動態/
ふどうとく /不道徳/
ふどうひょう /浮動票/
ふどうみょうおう /不動明王/
ふどき /風土記/
ふな /鮒/船/舟/
ふなあし /船脚/船足/
ふなあそび /船遊び/
ふない /府内/
ふないた /船板/
ふなか /不仲/
ふなかた /船方/
ふながた /船形/舟形/
ふなき /船木/
ふなくいむし /船食虫/
ふなぐ /船具/
ふなぐら /船蔵/
ふなこし /船越/
ふなごや /船小屋/
ふなじ /船路/
ふなぞこ /船底/
ふなたび /船旅/
ふなだいく /船大工/
ふなちん /船賃/
ふなつ /船津/
ふなづみ /船積み/
ふなで /船出/
ふなどめ /船留め/
ふなに /船荷/
ふなにしょうけん /船荷証券/
ふなぬし /船主/
ふなのり /船乗り/
ふなはし /船橋/舟橋/
ふなば /船場/
ふなばし /船橋/
ふなばた /船端/舷/
ふなびと /舟人/
ふなびん /船便/
ふなべり /船縁/舷/
ふなまち /船待ち/
ふなむし /船虫/
ふなもり /舟盛り/
ふなやど /船宿/
ふなよい /船酔い/
ふなれ /不馴れ/
ふなわたし /船渡し/
ふにく /腐肉/
ふにゅう /不入/
ふにょい /不如意/
ふにん /赴任/不妊/
ふにんしょう /不妊症/
ふにんじょう /不人情/
ふぬけ /腑抜け/
ふね /船/舟/
ふねへん /舟偏/
ふねん /不燃/
ふねんぶつ /不燃物/
ふのう /不能/不納/富農/
ふのうじょうけん /不能条件/
ふはい /腐敗/不敗/
ふはく /浮薄/布帛/
ふはつ /不発/
ふばい /不買/
ふばいうんどう /不買運動/
ふばらい /不払い/
ふひつよう /不必要/
ふひょう /付表/不評/浮標/歩兵/浮氷/譜表/
ふひんこう /不品行/
ふび /不備/
ふびじん /不美人/
ふびょうどう /不平等/
ふびん /不便/不敏/
ふふく /不服/
ふふつせんそう /普仏戦争/
ふぶき /吹雪/
ふぶん /不文/
ふぶんりつ /不文律/
ふへい /不平/
ふへいか /不平家/
ふへん /不変/普遍/不偏/
ふへんか /普遍化/
ふへんせい /普遍性/
ふへんふとう /不偏不党/
ふへんろんそう /普遍論争/
ふべん /不便/
ふべんきょう /不勉強/
ふほう /不法/訃報/
ふほうかんきん /不法監禁/
ふほうこうい /不法行為/
ふほんい /不本意/
ふぼ /父母/
ふぼく /浮木/
ふぼん /不犯/
ふまい /不昧/
ふまえ /踏まえ/
ふまえどころ /踏まえ所/
ふまじめ /不真面目/
ふまん /不満/
ふまんぞく /不満足/
ふみ /文/
ふみいし /踏石/
ふみいた /踏板/
ふみえ /踏絵/
ふみきり /踏切/
ふみこみ /踏込み/
ふみだい /踏台/
ふみだん /踏段/
ふみづき /文月/
ふみづくえ /文机/
ふみどの /文殿/
ふみもち /不身持/
ふみん /不眠/富民/
ふみんしょう /不眠症/
ふみんふきゅう /不眠不休/
ふむき /不向き/
ふめい /不明/
ふめいすう /不名数/
ふめいよ /不名誉/
ふめいりょう /不明瞭/
ふめいろう /不明朗/
ふめつ /不滅/
ふめん /譜面/
ふめんぼく /不面目/
ふめんもく /不面目/
ふもう /不毛/
ふもと /麓/
ふもん /不問/
ふやじょう /不夜城/
ふゆ /冬/
ふゆう /浮遊/富裕/富有/
ふゆかい /不愉快/
ふゆがれ /冬枯れ/
ふゆき /冬木/
ふゆきとどき /不行届き/
ふゆぎ /冬着/
ふゆくさ /冬草/
ふゆげ /冬毛/
ふゆげしょう /冬化粧/
ふゆこだち /冬木立/
ふゆさくもつ /冬作物/
ふゆざれ /冬ざれ/
ふゆしょうぐん /冬将軍/
ふゆじたく /冬支度/
ふゆぞら /冬空/
ふゆどり /冬鳥/
ふゆの /冬野/
ふゆば /冬場/
ふゆばれ /冬晴れ/
ふゆび /冬日/
ふゆびより /冬日和/
ふゆふく /冬服/
ふゆもの /冬物/
ふゆやすみ /冬休み/
ふゆやま /冬山/
ふよ /付与/賦与/
ふよう /不要/不用/扶養/浮揚/芙蓉;ハスの花/
ふようい /不用意/
ふようぎむ /扶養義務/
ふようじょう /不養生/
ふようせい /不溶性/
ふようど /腐葉土/
ふよく /扶翼/
ふらち /不埒/
ふらの /富良野/
ふらん /不乱/腐乱/腐爛/孵卵/
ふらんき /孵卵器/
ふらんす /仏蘭西/
ふり /不利/降り/振り/不離/
ふりえき /不利益/
ふりかえ /振替/
ふりかえゆそう /振替輸送/
ふりかけ /振掛け/
ふりかた /振り方/
ふりがな /振り仮名/
ふりこ /振子/
ふりこみ /振込み/
ふりごま /振り駒/
ふりそで /振袖/
ふりだしにん /振出人/
ふりつ /府立/
ふりつけ /振付け/
ふりにげ /振り逃げ/
ふりゅう /浮流/
ふりゅうもんじ /不立文字/
ふりょ /不慮/俘虜/
ふりょう /不良/不漁/不猟/
ふりょうけん /不料簡/
ふりょうしょうじょ /不良少女/
ふりょく /浮力/富力/
ふりわけ /振分け/
ふりん /不倫/
ふる /古/
ふるい /古井/古い/篩/
ふるいえ /古家/
ふるいけ /古池/
ふるいど /古井戸/
ふるえ /震え/古江/
ふるかぶ /古株/
ふるかわ /古川/古河/
ふるがお /古顔/
ふるき /古木/
ふるきず /古傷/
ふるぎ /古着/
ふるぎつね /古狐/
ふるくさい /古臭い/
ふるさと /故郷/古里/
ふるざけ /古酒/
ふるす /古巣/
ふるた /古田/
ふるだぬき /古狸/
ふるつわもの /古強者/古兵/
ふるづけ /古漬/
ふるて /古手/
ふるでら /古寺/
ふるとり /隹/
ふるどうぐ /古道具/
ふるなじみ /古馴染/
ふるはた /古畑/
ふるび /古び/
ふるほん /古本/
ふるほんや /古本屋/
ふるまい /振舞/
ふるみち /古道/
ふるみや /古宮/
ふるもの /古物/
ふるや /古屋/
ふれ /触れ/
ふれい /布令/不例/
ふれぶみ /触文/
ふれんぞく /不連続/
ふれんぞくせん /不連続線/
ふろ /風呂/風炉/
ふろう /不老/浮浪/
ふろうしゃ /浮浪者/
ふろうしょとく /不労所得/
ふろうじ /浮浪児/
ふろうふし /不老不死/
ふろおけ /風呂桶/
ふろく /付録/附録/
ふろしき /風呂敷/
ふろば /風呂場/
ふろや /風呂屋/
ふわ /不和/不破/付和/
ふわく /不惑/
ふわけ /腑分け/
ふわたり /不渡り/
ふわらいどう /付和雷同/
ふん /分/糞/雰/紛/粉/奮/扮/憤/墳/噴/吻/芬/焚/
ふんいき /雰囲気/
ふんえん /噴煙/
ふんか /噴火/
ふんかこう /噴火口/
ふんがい /憤慨/
ふんき /奮起/噴気/
ふんきこう /噴気孔/
ふんきゅう /紛糾/
ふんぎ /紛議/
ふんげき /憤激/
ふんこつさいしん /粉骨砕身/
ふんごう /吻合/
ふんさい /粉砕/
ふんさつ /焚殺/
ふんざい /粉剤/
ふんし /憤死/
ふんしつ /紛失/
ふんしゃ /噴射/
ふんしゅつ /噴出/
ふんしょ /焚書/
ふんしょく /粉飾/扮飾/粉食/
ふんしょこうじゅ /焚書坑儒/
ふんしん /分針/
ふんじん /粉塵/奮迅/
ふんすい /噴水/
ふんせき /噴石/
ふんせん /奮戦/噴泉/
ふんぜん /奮然/憤然/
ふんそう /扮装/紛争/
ふんたん /粉炭/
ふんづまり /糞詰り/
ふんとう /奮闘/
ふんど /憤怒/忿怒/糞土/
ふんどう /分銅/
ふんどし /褌/
ふんにゅう /粉乳/
ふんにょう /糞尿/
ふんぬ /憤怒/忿怒/
ふんぱつ /奮発/
ふんぱん /噴飯/
ふんびょう /分秒/
ふんぷん /紛々/
ふんべつ /分別/
ふんべつざかり /分別盛り/
ふんべん /糞便/
ふんぼ /墳墓/
ふんぽん /粉本/
ふんまつ /粉末/
ふんまん /憤懣/忿懣/
ふんむき /噴霧器/
ふんもん /噴門/憤悶/
ふんらん /紛乱/
ふんれい /奮励/
ぶ /分/部/無/舞/武/撫/侮/不/歩/奉/蕪/
ぶあい /歩合/
ぶあいきょう /無愛敬/
ぶあいそう /無愛想/
ぶあく /武悪/
ぶあんない /不案内/
ぶい /部位/武威/
ぶいく /撫育/
ぶいん /部員/無音/
ぶうん /武運/
ぶえんりょ /無遠慮/
ぶおとこ /醜男/
ぶおんな /醜女/
ぶか /部下/
ぶかっこう /不恰好/
ぶかつ /部活/
ぶかつどう /部活動/
ぶかん /武官/武漢/武鑑/
ぶがい /部外/
ぶがく /舞楽/
ぶき /武器/
ぶきみ /不気味/
ぶきょく /部局/舞曲/
ぶきよう /不器用/
ぶきりょう /不器量/
ぶぎ /武技/
ぶぎょう /奉行/
ぶぎょうしょ /奉行所/
ぶくん /武勲/
ぶぐ /武具/
ぶけ /武家/
ぶけやしき /武家屋敷/
ぶげい /武芸/
ぶげいしゃ /武芸者/
ぶげん /侮言/
ぶこう /武功/
ぶこく /誣告/
ぶこくざい /誣告罪/
ぶこつ /無骨/
ぶさいく /不細工/
ぶさた /無沙汰/不沙汰/
ぶさほう /無作法/不作法/
ぶざい /部材/
ぶざつ /蕪雑/
ぶざま /不様/無様/
ぶし /武士/
ぶしつけ /不躾/
ぶしどう /武士道/
ぶしゅ /部首/
ぶしゅうぎ /不祝儀/
ぶしょ /部署/
ぶしょう /不精/無精/武将/
ぶしょうひげ /無精髭/
ぶじ /無事/武事/
ぶじゅつ /武術/
ぶじゅん /撫順/
ぶじょく /侮辱/
ぶじょくざい /侮辱罪/
ぶじん /武人/
ぶすい /不粋/無粋/
ぶすう /部数/
ぶすや /附子矢/
ぶぜい /無勢/
ぶぜん /豊前/憮然/
ぶそう /武装/
ぶそうかいじょ /武装解除/
ぶそん /蕪村/
ぶぞく /部族/部属/
ぶた /豚/
ぶたい /部隊/舞台/
ぶたいうら /舞台裏/
ぶたいげいこ /舞台稽古/
ぶたいげいじゅつ /舞台芸術/
ぶたいげき /舞台劇/
ぶたいこうか /舞台効果/
ぶたいそうち /舞台装置/
ぶたいびじゅつ /舞台美術/
ぶたごや /豚小屋/
ぶたじる /豚汁/
ぶたにく /豚肉/
ぶたばこ /豚箱/
ぶだん /武断/
ぶち /斑/
ぶちょう /部長/
ぶちょうほう /不調法/
ぶっか /物価/
ぶっかい /仏界/物界/
ぶっかく /仏閣/
ぶっかしすう /物価指数/
ぶっかだか /物価高/
ぶっきょう /仏教/
ぶっけ /仏家/
ぶっけん /物件/物権/
ぶっけんひ /物件費/
ぶっこ /物故/
ぶっさつ /仏刹/
ぶっさん /物産/仏参/
ぶっし /物資/仏師/仏子/
ぶっしき /仏式/
ぶっしつ /物質/
ぶっしつたいしゃ /物質代謝/
ぶっしつてき /物質的/
ぶっしつめいし /物質名詞/
ぶっしゃり /仏舎利/
ぶっしょ /仏書/
ぶっしょう /物証/物象/
ぶっしょうえ /仏生会/
ぶっしょく /物色/
ぶっしん /物心/仏心/仏身/
ぶっせい /物性/
ぶっせいろん /物性論/
ぶっせつ /仏説/
ぶっそ /仏祖/
ぶっそう /物騒/仏葬/
ぶったい /物体/仏体/
ぶっちょうずら /仏頂面/
ぶっちょうづら /仏頂面/
ぶってき /物的/
ぶってきしょうこ /物的証拠/
ぶってん /仏典/
ぶっと /仏徒/
ぶっとう /仏塔/
ぶっぴん /物品/
ぶっぴんぜい /物品税/
ぶっぽう /仏法/
ぶっぽうそう /仏法僧/
ぶつ /物/仏/
ぶつえん /仏縁/
ぶつえんほう /仏炎苞/
ぶつおん /仏恩/
ぶつが /仏画/
ぶつがく /仏学/
ぶつぎ /物議/
ぶつぎり /ぶつ切り/
ぶつぐ /物具/仏具/
ぶつご /仏語/
ぶつざ /仏座/
ぶつざん /仏山/
ぶつじ /仏事/仏寺/
ぶつじょう /物情/
ぶつじょうだいい /物上代位/
ぶつぜん /仏前/
ぶつぞう /仏像/
ぶつだ /仏陀/
ぶつだん /仏壇/
ぶつでん /仏伝/仏殿/
ぶつど /仏土/
ぶつどう /仏道/仏堂/
ぶつのう /物納/
ぶつぶつこうかん /物々交換/
ぶつま /仏間/
ぶつみょう /仏名/
ぶつめつ /仏滅/
ぶつもん /仏門/
ぶつよく /物欲/
ぶつり /物理/
ぶつりかがく /物理化学/
ぶつりがく /物理学/
ぶつりき /仏力/
ぶつりけい /物理系/
ぶつりていすう /物理定数/
ぶつりてき /物理的/
ぶつりほうそく /物理法則/
ぶつりゅう /物流/
ぶつりょう /物量/物療/
ぶつりりょう /物理量/
ぶてい /武帝/
ぶと /太/
ぶとう /舞踏/
ぶとうかい /舞踏会/
ぶどう /葡萄/武道/
ぶどういろ /葡萄色/
ぶどうしゅ /葡萄酒/
ぶどうじょう /葡萄状/
ぶどうとう /葡萄糖/
ぶどうねずみ /葡萄鼠/
ぶどまり /歩留り/
ぶな /椈/山毛欅/
ぶない /部内/
ぶなん /無難/
ぶにん /無人/
ぶひん /部品/
ぶび /武備/
ぶびき /歩引き/
ぶふうりゅう /無風流/
ぶぶん /部分/
ぶぶんおん /部分音/
ぶぶんきょくひつ /舞文曲筆/
ぶぶんしゅうごう /部分集合/
ぶぶんしょく /部分食/
ぶぶんてき /部分的/
ぶぶんひん /部分品/
ぶへん /武辺/
ぶべつ /侮蔑/
ぶめい /武名/
ぶめん /部面/
ぶもん /部門/武門/
ぶゆ /蚋/
ぶゆう /武勇/
ぶゆうでん /武勇伝/
ぶよ /蚋/
ぶよう /舞踊/
ぶようじん /不用心/
ぶらい /無頼/
ぶらいかん /無頼漢/
ぶらく /部落/
ぶらじる /伯剌西爾/
ぶり /鰤/
ぶりゃく /武略/
ぶりょう /無聊/
ぶりょうとうげん /武陵桃源/
ぶりょく /武力/
ぶりょくかくめい /武力革命/
ぶるい /部類/
ぶるがりあ /勃牙利/
ぶれい /無礼/
ぶれいこう /無礼講/
ぶれつ /武烈/
ぶわけ /部分け/
ぶわり /歩割/
ぶん /分/文/聞/
ぶんあつ /分圧/
ぶんあん /文案/文安/
ぶんい /文意/
ぶんいん /分院/
ぶんえい /文永/
ぶんおう /文応/
ぶんか /文化/分科/分化/文科/文華/分課/
ぶんかい /分解/分会/分界/
ぶんかいのう /分解能/
ぶんかかい /分科会/
ぶんかくんしょう /文化勲章/
ぶんかさい /文化祭/
ぶんかざい /文化財/
ぶんかし /文化史/
ぶんかじん /文化人/
ぶんかだいかくめい /文化大革命/
ぶんかちょう /文化庁/
ぶんかつ /分割/
ぶんかつばらい /分割払い/
ぶんかてき /文化的/
ぶんかん /文官/
ぶんがい /分外/
ぶんがく /文学/
ぶんがくかい /文学界/
ぶんがくし /文学史/
ぶんがくしゃ /文学者/
ぶんがくせいねん /文学青年/
ぶんがくろん /文学論/
ぶんき /分岐/
ぶんきき /分岐器/
ぶんきてん /分岐点/
ぶんきゅう /文久/
ぶんきょう /文京/文教/
ぶんきょうじょう /分教場/
ぶんきょく /分極/
ぶんきょくか /分極化/
ぶんぎ /分木/文義/
ぶんぎょう /分業/文業/
ぶんぐ /文具/
ぶんけ /分家/
ぶんけい /文系/文型/
ぶんけん /文献/分権/分遣/文検/
ぶんけんがく /文献学/
ぶんけんちず /分県地図/
ぶんげい /文芸/
ぶんげいえいが /文芸映画/
ぶんげいか /文芸家/
ぶんげいがく /文芸学/
ぶんげん /分限/文言/
ぶんこ /文庫/
ぶんこう /分光/分校/
ぶんこうがく /分光学/
ぶんこうき /分光器/
ぶんこつ /分骨/
ぶんご /文語/豊後/
ぶんごう /文豪/分合/
ぶんごすいどう /豊後水道/
ぶんごたい /文語体/
ぶんごたかだ /豊後高田/
ぶんごぶん /文語文/
ぶんごほう /文語法/
ぶんさい /文才/
ぶんさつ /分冊/
ぶんさん /分散/
ぶんさんしょり /分散処理/
ぶんざい /分際/
ぶんし /分子/分詞/文士/分枝/
ぶんししき /分子式/
ぶんしせいぶつがく /分子生物学/
ぶんしつ /分室/
ぶんしつひんぴん /文質彬彬/
ぶんしゃ /分社/
ぶんしゅう /文集/
ぶんしゅく /分宿/
ぶんしょ /文書/分所/分署/
ぶんしょう /文章/分掌/文相/
ぶんしょうご /文章語/
ぶんしょうほう /文章法/
ぶんしょく /文飾/
ぶんしりょう /分子量/
ぶんしん /分身/
ぶんじ /文治/文事/文辞/
ぶんじょう /分乗/分譲/
ぶんじょうち /分譲地/
ぶんじん /文人/
ぶんすい /分水/
ぶんすいかい /分水界/
ぶんすいれい /分水嶺/
ぶんすう /分数/
ぶんすうしき /分数式/
ぶんせい /文政/文勢/
ぶんせき /分析/文責/
ぶんせきかがく /分析化学/
ぶんせつ /文節/分節/
ぶんせん /文選/
ぶんそうおう /分相応/
ぶんそん /分損/分村/
ぶんたい /文体/分隊/
ぶんたん /分担/
ぶんだい /文題/
ぶんだん /分断/文壇/分団/
ぶんち /文治/聞知/
ぶんちゅう /文中/
ぶんちょう /文鳥/
ぶんちん /文鎮/
ぶんつう /文通/
ぶんてん /分点/分店/文展/文典/
ぶんとう /文頭/
ぶんどき /分度器/
ぶんにん /分任/
ぶんのう /分納/
ぶんばい /分売/
ぶんぱ /分派/
ぶんぱい /分配/
ぶんぱいほうそく /分配法則/
ぶんぱん /文範/
ぶんぴ /分泌/
ぶんぴつ /分泌/文筆/分筆/
ぶんぴつえき /分泌液/
ぶんぴつか /文筆家/
ぶんぴつぶつ /分泌物/
ぶんぶ /文武/
ぶんぶつ /文物/
ぶんぷ /分布/分賦/
ぶんべつ /分別/
ぶんべん /分娩/
ぶんぼ /分母/
ぶんぼうぐ /文房具/
ぶんぽう /文法/分封/
ぶんまつ /文末/
ぶんみゃく /文脈/
ぶんみん /文民/
ぶんめい /文明/文名/
ぶんめいかいか /文明開化/
ぶんめいし /文明史/
ぶんめいひひょう /文明批評/
ぶんめん /文面/
ぶんや /分野/
ぶんゆう /分有/
ぶんよ /分与/
ぶんらく /文楽/
ぶんらくざ /文楽座/
ぶんらん /紊乱/
ぶんり /分離/文理/分利/
ぶんりかぜい /分離課税/
ぶんりき /分離器/
ぶんりつ /分立/
ぶんりは /分離派/
ぶんりゅう /分留/分流/分溜/
ぶんりゅうき /分流器/
ぶんりょう /分量/分領/
ぶんるい /分類/
ぶんるいがく /分類学/
ぶんれい /文例/分霊/
ぶんれつ /分裂/分列/
ぶんれつしき /分列式/
ぶんれつそしき /分裂組織/
ぶんれつびょう /分裂病/
ぶんろく /文禄/
ぶんわ /文話/
ぷろしあ /普魯西/
へ /屁/戸/辺/舳/
へい /閉/平/陛/並/柄/弊/幣/塀/兵/併/丙/病/聘/炳/瓶/蔽/
へい> /閉/
へいあん /平安/
へいあんきょう /平安京/
へいあんじだい /平安時代/
へいあんじんぐう /平安神宮/
へいあんちょう /平安朝/
へいい /平易/
へいいはぼう /弊衣破帽/
へいいん /兵員/閉院/
へいえい /兵営/
へいえき /兵役/
へいおく /弊屋/
へいおん /平穏/平温/
へいおんせつ /閉音節/
へいか /陛下/平価/兵科/閉果/併科/兵火/
へいかい /閉会/
へいかつ /平滑/
へいかつかいろ /平滑回路/
へいかつきん /平滑筋/
へいが /平臥/
へいがい /弊害/
へいがく /兵学/
へいがっこう /兵学校/
へいがん /併願/
へいき /平気/併記/兵器/
へいきこ /兵器庫/
へいきしょう /兵器廠/
へいきょ /閉居/
へいきょく /平曲/
へいきょくせん /閉曲線/
へいきょくめん /閉曲面/
へいきん /平均/
へいきんかぶか /平均株価/
へいきんじゅみょう /平均寿命/
へいきんだい /平均台/
へいきんち /平均値/
へいきんてき /平均的/
へいきんてん /平均点/
へいきんひよう /平均費用/
へいきんりつ /平均律/平均率/
へいぎょう /閉業/
へいくかん /閉区間/
へいけ /平家/
へいけい /閉経/
へいけものがたり /平家物語/
へいげい /睥睨/
へいげん /平原/
へいこう /並行/閉口/平行/平衡/併行/閉校/
へいこういどう /平行移動/
へいこうかんかく /平衡感覚/
へいこうしへんけい /平行四辺形/
へいこうしんか /平行進化/
へいこうせん /平行線/
へいこうていすう /平衡定数/
へいこうぼう /平行棒/
へいこうみゃく /平行脈/
へいこうゆにゅう /並行輸入/
へいご /平語/
へいごう /併合/
へいごうざい /併合罪/
へいさ /閉鎖/
へいさく /平朔/平作/
へいさけい /閉鎖系/
へいさつ /併殺/
へいさてき /閉鎖的/
へいざん /閉山/
へいし /兵士/瓶子/平氏/閉止/斃死/
へいしゃ /弊社/兵舎/平射/
へいしゅ /兵種/
へいしゅう /弊習/
へいしゅうごう /閉集合/
へいしょ /閉所/兵書/
へいしん /並進/平身/平信/
へいしんうんどう /並進運動/
へいしんていとう /平身低頭/
へいじ /平時/平治/兵事/
へいじつ /平日/
へいじゅつ /兵術/
へいじゅん /平準/
へいじょ /平叙/
へいじょう /平常/閉場/平城/平壌/
へいじょうきょう /平城京/
へいじょうしん /平常心/
へいじょぶん /平叙文/
へいせい /平成/平静/兵制/幣制/弊政/
へいせき /兵籍/
へいせつ /併設/
へいせん /兵船/
へいぜい /平生/
へいぜん /平然/
へいそ /平素/
へいそう /兵曹/
へいそく /閉塞/屏息/
へいそつ /兵卒/
へいそん /併存/並存/
へいぞく /平俗/
へいたい /兵隊/
へいたく /弊宅/
へいたん /平坦/兵站/平淡/
へいだん /兵団/
へいち /平地/並置/併置/
へいちょう /兵長/
へいてい /平定/閉廷/
へいてん /閉店/弊店/
へいどく /併読/
へいどん /併呑/
へいない /平内/
へいにん /併任/
へいねつ /平熱/
へいねん /平年/
へいのうぶんり /兵農分離/
へいはく /幣帛/
へいはつ /併発/
へいはん /平版/
へいば /兵馬/
へいばん /平板/
へいび /兵備/
へいふう /弊風/
へいふく /平服/平伏/平復/
へいぶん /平分/
へいへい /平平/
へいへいぼんぼん /平平凡凡/
へいべい /平米/
へいほう /平方/兵法/
へいほうこん /平方根/
へいぼん /平凡/
へいまく /閉幕/
へいみゃく /平脈/
へいみん /平民/
へいめい /平明/
へいめん /平面/
へいめんきょう /平面鏡/
へいめんず /平面図/
へいめんずけい /平面図形/
へいめんてき /平面的/
へいめんは /平面波/
へいもつ /幣物/
へいもん /閉門/
へいや /平野/
へいゆ /平癒/
へいゆう /併有/
へいよう /併用/
へいらん /兵乱/
へいり /弊履/
へいりつ /並立/
へいりゃく /兵略/
へいりょく /兵力/
へいれつ /並列/
へいれつしょり /並列処理/
へいろ /閉路/平炉/
へいわ /平和/
へいわしゅぎ /平和主義/
へいわじょうこう /平和条項/
へいわじょうやく /平和条約/
へき /壁/碧/癖/僻/璧/
へきえき /辟易/
へきえん /僻遠/
へきかい /碧海/劈開/
へきかん /壁間/
へきが /壁画/
へきがん /碧眼/壁龕/
へきぎょく /碧玉/
へきくう /碧空/
へきけん /僻見/
へきすい /碧水/
へきすう /僻陬/
へきせつ /僻説/
へきそん /僻村/
へきち /僻地/
へきとう /劈頭/
へきなん /碧南/
へきめん /壁面/
へきめんせん /壁面線/
へきれき /霹靂/
へきろん /僻論/
へくとぐらむ /瓸/
へくとめーとる /粨/
へくとりっとる /竡/
へぐらじま /舳倉島/
へさき /舳先/
へしきや /平敷屋/
へそ /臍/巻子/綜麻/
へそくり /臍繰り/
へそのお /臍の緒/
へそまがり /臍曲り/
へた /下手/蔕/
へたくそ /下手糞/
へだて /隔て/
へちま /糸瓜/
へな /埴/
へなちょこ /埴猪口/
へび /蛇/
へびくち /蛇口/
へびどく /蛇毒/
へや /部屋/
へやぎ /部屋着/
へやずみ /部屋住み/
へやわり /部屋割り/
へら /箆/
へらずぐち /減らず口/
へり /縁/
へりくつ /屁理屈/
へん /変/辺/編/返/遍/篇/片/偏/
へんあい /偏愛/
へんあつ /変圧/
へんあつき /変圧器/
へんい /変位/変移/変異/
へんいき /変域/
へんうん /片雲/
へんえい /片影/
へんおんどうぶつ /変温動物/
へんか /変化/返歌/
へんかい /変改/
へんかきゅう /変化球/
へんかく /変革/偏角/変格/
へんかくかつよう /変格活用/
へんかりつ /変化率/
へんかん /変換/返還/
へんきごう /変記号/
へんきゃく /返却/
へんきょう /偏狭/辺境/
へんきょく /編曲/変局/
へんきょくてん /変曲点/
へんきん /返金/
へんくつ /偏屈/
へんけい /変形/変型/扁形/
へんけいきん /変形菌/
へんけいたい /変形体/
へんけん /偏見/
へんげ /変化/
へんげん /片言/変幻/
へんこう /変更/偏光/偏向/
へんこうし /偏光子/
へんこうせい /変光星/
へんさ /偏差/騙詐/
へんさい /返済/変災/
へんさち /偏差値/
へんさん /編纂/
へんざい /遍在/偏在/辺材/
へんし /変死/
へんしつ /変質/偏執/
へんしつしゃ /変質者/
へんしゃ /編者/
へんしゅ /変種/騙取/
へんしゅう /編集/編修/偏執/編輯/
へんしゅうきょう /偏執狂/
へんしゅうけん /編集権/
へんしゅうにん /編集人/
へんしゅうびょう /偏執病/
へんしょ /返書/
へんしょう /返照/
へんしょく /変色/偏食/
へんしん /返信/変身/偏心/変心/
へんじ /返事/変事/返辞/片時/
へんじょう /返上/変成/
へんじん /変人/
へんすう /変数/
へんすうめい /変数名/
へんずつう /偏頭痛/
へんせい /編成/変成/編制/変性/
へんせいがん /変成岩/
へんせいき /変声期/
へんせいふう /偏西風/
へんせつ /変節/変説/
へんせん /変遷/
へんそう /返送/変装/
へんそうきょく /変奏曲/
へんそく /変則/変速/
へんぞう /変造/
へんたい /変態/変体/編隊/
へんたいがな /変体仮名/
へんち /辺地/
へんちょ /編著/
へんちょう /変調/偏重/
へんつう /変通/
へんてつ /変哲/
へんてん /変転/
へんでん /返電/
へんでんしょ /変電所/
へんとう /返答/扁桃/
へんとうえん /扁桃炎/
へんとうせん /扁桃腺/
へんど /辺土/
へんどう /変動/
へんどうかんすう /偏導関数/
へんどうしょとく /変動所得/
へんどうひ /変動費/
へんにゅう /編入/
へんねん /編年/
へんねんし /編年史/
へんねんたい /編年体/
へんのう /返納/
へんのうゆ /片脳油/
へんぱ /偏頗/
へんぱい /返杯/
へんびぶん /偏微分/
へんぴ /辺鄙/
へんぴん /返品/
へんぶん /変分/
へんぷ /返付/
へんぷく /蝙蝠/辺幅/
へんぺい /扁平/
へんぺいそく /扁平足/
へんぼう /変貌/偏旁/
へんぽう /返報/
へんぽん /返本/
へんみん /辺民/
へんむけいやく /片務契約/
へんめい /変名/
へんやく /変約/
へんよう /変容/
へんらん /変乱/
へんりょう /変量/
へんりん /片鱗/
へんれい /返礼/返戻/
へんれき /遍歴/
へんろ /遍路/
べ /部/辺/
べーた /β/
べーたせん /β線/
べい /米/
べいか /米価/米貨/
べいこく /米国/米穀/
べいさく /米作/
べいさん /米産/
べいしゅう /米収/
べいしょく /米食/
べいじゅ /米寿/
べいせいせんそう /米西戦争/
べいはん /米飯/
べいばく /米麦/
べいふん /米粉/
べいべつ /袂別/
べき /羃/冪/
べくさかずき /可杯/
べたぐみ /べた組み/
べたぼれ /べた惚れ/
べっかく /別格/
べっかん /別館/別巻/
べっき /別記/
べっきょ /別居/
べっけ /別家/
べっけい /別掲/
べっけん /別件/瞥見/
べっけんたいほ /別件逮捕/
べっこ /別個/
べっこう /別項/鼈甲/
べっこん /別懇/
べっさつ /別冊/
べっし /別紙/蔑視/別使/
べっしつ /別室/
べっしゅ /別種/
べっしゅう /別集/
べっしょ /別所/
べっしょう /別称/蔑称/
べっせい /別製/
べっせかい /別世界/
べっせき /別席/
べっそ /別訴/
べっそう /別荘/別送/
べったい /別体/
べったく /別宅/
べっちん /別珍/
べってい /別邸/
べってんち /別天地/
べっと /別途/
べっとう /別当/
べっぱ /別派/
べっぴょう /別表/
べっぴん /別嬪/別品/
べっぷ /別府/
べっぷう /別封/
べっぽう /別報/別法/
べっぽん /別本/
べつ /別/蔑/鼈/瞥/
べつい /別異/
べついん /別院/
べつぎ /別儀/
べつぎょう /別業/
べつくち /別口/
べつげん /別言/
べつじ /別事/別辞/
べつじょう /別状/別条/
べつじょけん /別除権/
べつじん /別人/
べつずり /別刷/
べつだん /別段/
べつでん /別伝/
べつどうたい /別働隊/
べつに /別に/
べつのう /別納/
べつびん /別便/
べつべつ /別々/
べつま /別間/
べつみょう /別名/
べつむね /別棟/
べつめい /別名/別命/
べつもの /別物/
べつもんだい /別問題/
べつよう /別様/
べつり /別離/
べつるい /別涙/
べつわく /別枠/
べに /紅/
べにいろ /紅色/
べにうこん /紅鬱金/
べにえ /紅絵/
べにお /紅緒/
べにがら /紅殻/
べにこ /紅粉/
べにざけ /紅鮭/
べにばな /紅花/
べにふで /紅筆/
べるぎー /白耳義/
べるりん /伯林/
べん /勉/鞭/弁/便/冕/辨/瓣/辯/娩/
べんい /便意/便衣/
べんえき /便益/
べんかい /弁解/
べんがく /勉学/
べんき /便器/
べんきょう /勉強/
べんぎ /便宜/
べんぎちせきせん /便宜置籍船/
べんぎてき /便宜的/
べんけい /弁慶/
べんこう /弁口/弁巧/
べんご /弁護/
べんごし /弁護士/
べんごしかい /弁護士会/
べんごしほう /弁護士法/
べんごにん /弁護人/
べんさい /弁済/弁才/
べんざ /便座/
べんざいてん /弁財天/
べんし /弁士/
べんしき /弁識/
べんしょう /弁償/
べんしょうほう /弁証法/
べんじょ /便所/
べんぜつ /弁舌/
べんたつ /鞭撻/
べんち /胼胝/
べんちゅう /鞭虫/
べんつう /便通/
べんてん /弁天/
べんてんじま /弁天島/
べんとう /弁当/
べんとうばこ /弁当箱/
べんとうや /弁当屋/
べんなん /弁難/
べんばく /弁駁/
べんぱつ /辮髪/
べんぴ /便秘/
べんべつ /弁別/
べんぽう /便法/
べんまく /弁膜/
べんむかん /弁務官/
べんめい /弁明/
べんもう /鞭毛/
べんらん /便覧/
べんり /便利/弁理/
べんりこうし /弁理公使/
べんりし /弁理士/
べんりや /便利屋/
べんれい /勉励/
べんろん /弁論/
ぺーじ /頁/
ぺきん /北京/
ぺるしあ /波斯/
ぺんぺんぐさ /ぺんぺん草/
ほ /保/穂/輔/補/歩/捕/圃/鋪/舗/火/帆/哺/浦/畝/甫/
ほあし /帆足/
ほあん /保安/
ほあんかん /保安官/
ほあんしょぶん /保安処分/
ほあんたい /保安隊/
ほあんちょう /保安庁/
ほあんよういん /保安要員/
ほあんりん /保安林/
ほい /補遺/
ほいく /保育/哺育/
ほいくえん /保育園/
ほいくき /保育器/
ほいくしょ /保育所/
ほいっぽ /歩一歩/
ほいつ /捕逸/
ほう /方/法/泡/砲/放/報/鵬/鳳/飽/鋒/邦/豊/訪/芳/胞/朋/抱/崩/峯/峰/宝/奉/包/俸/倣/縫/封/褒/烽/保/苞/袍/蓬/萌/烹/捧/庖/呆/蜂/
ほうあん /法案/奉安/
ほうい /方位/包囲/法衣/
ほういかく /方位角/
ほういがく /法医学/
ほういつ /放逸/
ほういん /法印/
ほうえ /法会/法衣/
ほうえい /放映/宝永/
ほうえき /法益/
ほうえつ /法悦/
ほうえん /方円/砲煙/豊艶/
ほうおう /法王/法皇/訪欧/鳳凰/
ほうおん /報恩/
ほうか /放火/法科/邦貨/烽火/放課/法家/砲火/放下/邦家/法貨/
ほうかい /崩壊/崩潰/法界/抱懐/
ほうかいけいれつ /崩壊系列/
ほうかいじ /法界寺/
ほうかいせき /方解石/
ほうかいりんき /法界悋気/
ほうかご /放課後/
ほうかしきえん /蜂窩織炎/
ほうかつ /包括/
ほうかついぞう /包括遺贈/
ほうかつざいさん /包括財産/
ほうかつしょうけい /包括承継/
ほうかん /奉還/幇間/宝冠/法官/宝鑑/砲艦/
ほうかんげきたく /抱関撃柝/
ほうかんしょう /宝冠章/
ほうが /奉賀/邦画/萌芽/奉加/
ほうがい /法外/
ほうがく /方角/邦楽/法学/放学/
ほうがくちがい /方角違い/
ほうがん /包含/砲丸/判官/
ほうがんし /方眼紙/
ほうがんびいき /判官贔屓/
ほうき /放棄/法規/伯耆/蜂起/帚/箒/抛棄/芳紀/宝器/法器/
ほうきぼし /箒星/
ほうきゃく /訪客/
ほうきゅう /俸給/
ほうきょう /法橋/豊凶/豊頬/
ほうきりゅう /伯耆流/
ほうきん /砲金/
ほうぎょ /崩御/
ほうぎょく /宝玉/
ほうぎん /放吟/
ほうけい /包茎/方形/
ほうけん /封建/奉献/宝剣/
ほうけんしゃかい /封建社会/
ほうけんじだい /封建時代/
ほうけんてき /封建的/
ほうげ /放下/
ほうげい /奉迎/
ほうげき /砲撃/
ほうげん /方言/放言/法眼/
ほうげんのらん /保元の乱/
ほうこ /宝庫/
ほうこう /方向/奉行/芳香/奉公/放校/咆哮/彷徨/砲口/
ほうこうじ /方広寺/
ほうこうだ /方向舵/
ほうこうてんかん /方向転換/
ほうこうにん /奉公人/
ほうこうゆ /芳香油/
ほうこく /報告/報国/邦国/奉告/
ほうご /邦語/法語/
ほうごう /縫合/抱合/法号/
ほうさい /奉斎/
ほうさく /方策/豊作/
ほうさくびんぼう /豊作貧乏/
ほうさん /放散/硼酸/
ほうざ /砲座/
ほうし /奉仕/法師/胞子/芳志/奉祀/奉伺/褒詞/
ほうしき /方式/法式/
ほうしたい /胞子体/
ほうしちょうだ /封豕長蛇/
ほうしのう /胞子嚢/
ほうしゃ /放射/砲車/報謝/硼砂/
ほうしゃかいがく /法社会学/
ほうしゃくじ /宝積寺/
ほうしゃじょう /放射状/
ほうしゃせい /放射性/
ほうしゃせいげんそ /放射性元素/
ほうしゃせん /放射線/
ほうしゃせんたい /放射線帯/
ほうしゃそうしょう /放射相称/
ほうしゃそしき /放射組織/
ほうしゃねつ /放射熱/
ほうしゃのう /放射能/
ほうしゅ /宝珠/法主/砲手/
ほうしゅう /報酬/
ほうしゅく /奉祝/
ほうしゅつ /放出/
ほうしゅん /芳春/
ほうしょ /奉書/芳書/
ほうしょう /放縦/宝生/褒賞/報償/報奨/法相/褒章/奉唱/
ほうしょうりゅう /宝生流/
ほうしょがみ /奉書紙/
ほうしょく /奉職/飽食/宝飾/
ほうしん /方針/放心/砲身/疱疹/芳心/芳信/
ほうじ /法事/邦字/捧持/
ほうじちゃ /焙じ茶/
ほうじゅう /放縦/
ほうじゅく /豊熟/
ほうじゅつ /砲術/方術/
ほうじゅん /芳醇/豊潤/
ほうじょ /幇助/
ほうじょう /北条/豊穣/豊饒/方丈/芳情/法帖/褒状/
ほうじょうえ /放生会/
ほうじょうき /方丈記/
ほうじょうじ /法成寺/
ほうじょうそううん /北条早雲/
ほうじん /法人/邦人/方陣/
ほうじんかく /法人格/
ほうじんぜい /法人税/
ほうすい /放水/豊水/
ほうすいろ /放水路/
ほうすう /鳳雛/
ほうすん /方寸/
ほうせい /方正/法政/法制/縫製/砲声/
ほうせいきょく /法制局/
ほうせいしんぎかい /法制審議会/
ほうせいだいがく /法政大学/
ほうせき /宝石/
ほうせつ /包摂/
ほうせつかごうぶつ /包接化合物/
ほうせん /法線/砲戦/
ほうせんか /鳳仙花/
ほうぜん /宝前/
ほうそ /硼素/
ほうそう /放送/包装/法曹/疱瘡/奉送/
ほうそうえいせい /放送衛星/
ほうそうかい /法曹界/
ほうそうきょく /放送局/
ほうそうげき /放送劇/
ほうそうだいがく /放送大学/
ほうそうもう /放送網/
ほうそく /法則/
ほうぞう /包蔵/法蔵/宝蔵/
ほうたい /包帯/繃帯/奉戴/
ほうたん /放胆/
ほうだい /放題/砲台/邦題/
ほうだん /放談/砲弾/法談/
ほうち /放置/法治/報知/封地/
ほうちく /放逐/
ほうちこっか /法治国家/
ほうちしゅぎ /法治主義/
ほうちしんぶん /報知新聞/
ほうちゃく /逢着/
ほうちゅう /包虫/庖厨/
ほうちょう /包丁/庖丁/放鳥/
ほうづえ /方杖/
ほうてい /法廷/法定/奉呈/
ほうていかじつ /法定果実/
ほうていきかん /法定期間/
ほうていけい /法定刑/
ほうていけつぞく /法定血族/
ほうていしき /方程式/
ほうていせいさん /法定清算/
ほうていだいり /法定代理/
ほうていとうそう /法廷闘争/
ほうていりそく /法定利息/
ほうていりりつ /法定利率/
ほうてき /法的/放擲/抛擲/法敵/
ほうてつがく /法哲学/
ほうてん /法典/宝典/奉天/
ほうでん /放電/宝殿/
ほうでんかこう /放電加工/
ほうでんかん /放電管/
ほうと /方途/
ほうとう /宝刀/放蕩/砲塔/包頭/法灯/奉答/宝塔/
ほうとく /宝徳/報徳/
ほうど /封土/邦土/
ほうどう /報道/
ほうどうきかん /報道機関/
ほうどうきょうてい /報道協定/
ほうどうじん /報道陣/
ほうどく /奉読/
ほうなん /法難/
ほうにち /訪日/
ほうにょう /放尿/
ほうにん /放任/
ほうにんしゅぎ /放任主義/
ほうねつ /放熱/
ほうねつき /放熱器/
ほうねん /放念/豊年/法然/芳年/芳念/
ほうのう /奉納/
ほうはい /奉拝/
ほうはつ /蓬髪/
ほうばい /傍輩/朋輩/
ほうばつ /放伐/
ほうひ /放屁/包皮/
ほうび /褒美/
ほうふ /豊富/抱負/防府/
ほうふく /報復/抱腹/法服/
ほうふくかんぜい /報復関税/
ほうふつ /彷彿/髣髴/
ほうぶ /邦舞/
ほうぶつせん /放物線/抛物線/
ほうぶつめん /放物面/
ほうぶん /邦文/法文/
ほうへい /砲兵/奉幣/
ほうへん /褒貶/
ほうべん /方便/
ほうほう /方法/
ほうほうじょせつ /方法序説/
ほうほうろん /方法論/
ほうほんはんし /報本反始/
ほうぼう /方々/方方/宝坊/蜂房/鋒鋩/竹麦魚/謗法/
ほうぼく /放牧/芳墨/
ほうまつ /泡沫/
ほうまん /放漫/豊満/飽満/
ほうみょう /法名/
ほうむ /法務/
ほうむきょく /法務局/
ほうむしょう /法務省/
ほうむだいじん /法務大臣/
ほうめい /芳名/
ほうめん /方面/放免/
ほうめんたい /方面隊/
ほうもう /法網/
ほうもつ /宝物/
ほうもん /訪問/砲門/法文/法門/
ほうもんぎ /訪問着/
ほうもんはんばい /訪問販売/
ほうや /保谷/
ほうやく /邦訳/
ほうゆう /朋友/包有/
ほうよう /抱擁/包容/法要/包葉/放鷹/苞葉/
ほうよく /豊沃/
ほうらい /蓬莱/
ほうらく /崩落/炮烙/法楽/
ほうらくせん /包絡線/
ほうらつ /放埒/
ほうらん /抱卵/
ほうり /法理/
ほうりき /法力/
ほうりつ /法律/
ほうりつあん /法律案/
ほうりつか /法律家/
ほうりつがく /法律学/
ほうりつこうい /法律行為/
ほうりつしん /法律審/
ほうりつじむしょ /法律事務所/
ほうりつふじょ /法律扶助/
ほうりつもんだい /法律問題/
ほうりゃく /方略/宝暦/
ほうりゅう /放流/
ほうりゅうじ /法隆寺/
ほうりょう /豊漁/方領/法量/
ほうりん /法輪/
ほうるい /堡塁/
ほうれい /法令/法例/豊麗/
ほうれいしんさけん /法令審査権/
ほうれつ /芳烈/放列/
ほうれんそう /菠薐草/
ほうろう /放浪/琺瑯/
ほうろく /焙烙/俸禄/
ほうろん /放論/
ほうわ /飽和/法話/
ほうわじょうきあつ /飽和蒸気圧/
ほえき /補益/
ほえづら /吠え面/
ほお /頬/朴/
ほおかぶり /頬被り/
ほおげた /頬桁/
ほおじろ /頬白/
ほおづえ /頬杖/
ほおば /朴歯/
ほおべに /頬紅/
ほおぼね /頬骨/
ほおん /保温/
ほか /他/外/
ほかく /保革/捕獲/補角/
ほかけぶね /帆掛け船/
ほかげ /帆影/火影/
ほかぜ /帆風/
ほかならぬ /他ならぬ/
ほかん /保管/補完/
ほかんざい /補完財/
ほかんほう /補間法/
ほがらか /朗らか/
ほき /補記/
ほきゅう /補給/捕球/
ほきゅうせん /補給線/
ほきょう /補強/
ほきょうしょうこ /補強証拠/
ほきんしゃ /保菌者/
ほぎうた /寿歌/
ほく /北/
ほくい /北緯/
ほくえつ /北越/
ほくおう /北欧/
ほくおうしんわ /北欧神話/
ほくが /北画/
ほくがん /北岸/
ほくげん /北限/
ほくさい /北斎/
ほくしゅう /北州/
ほくしん /北辰/北進/
ほくじょう /北上/
ほくせい /北西/
ほくたん /北端/
ほくちょう /北朝/
ほくてき /北狄/
ほくてん /北天/
ほくと /北斗/北都/
ほくとう /北東/
ほくとしちせい /北斗七星/
ほくとせい /北斗星/
ほくふう /北風/
ほくへん /北辺/
ほくべい /北米/
ほくほくせい /北北西/
ほくほくとう /北北東/北々東/
ほくめい /北溟/
ほくめん /北面/
ほくよう /北洋/
ほくりく /北陸/
ほくりくどう /北陸道/
ほくりくほんせん /北陸本線/
ほくりょなんわ /北虜南倭/
ほくれい /北嶺/
ほくろ /黒子/
ほけきょう /法華経/
ほけつ /補欠/
ほけん /保険/保健/
ほけんかがく /保険価額/
ほけんがいしゃ /保険会社/
ほけんきん /保険金/
ほけんけいやく /保険契約/
ほけんしつ /保健室/
ほけんしゃ /保険者/
ほけんしょうけん /保険証券/
ほけんじょ /保健所/
ほけんたいいく /保健体育/
ほけんふ /保健婦/
ほけんやく /保険薬/
ほけんりょう /保険料/
ほげい /捕鯨/
ほげいせん /捕鯨船/
ほげた /帆桁/
ほこ /矛/鉾/戈/
ほこう /歩行/補講/
ほこうき /歩行器/
ほこうしゃ /歩行者/
ほこうそ /補酵素/
ほこさき /矛先/鋒/
ほこら /叢祠/祠/
ほこり /埃/誇り/
ほころび /綻び/
ほご /保護/補語/反古/反故/
ほごあずかり /保護預り/
ほごかんさつ /保護観察/
ほごかんぜい /保護関税/
ほごこく /保護国/
ほごし /保護司/
ほごしせつ /保護施設/
ほごしゃ /保護者/
ほごしゅぎ /保護主義/
ほごしょく /保護色/
ほごしょぶん /保護処分/
ほごちょう /保護鳥/
ほごりん /保護林/
ほさ /補佐/輔佐/保佐/
ほさき /穂先/
ほさく /補作/
ほさつ /捕殺/補殺/
ほさにん /保佐人/補佐人/
ほし /星/干し/欲し/※/☆/★/
ほしあかり /星明り/
ほしい /糒/
ほしいまま /恣/
ほしうらない /星占い/
ほしかげ /星影/
ほしがき /干柿/
ほしがた /星型/
ほしくず /星屑/
ほしじし /干肉/
ほしぞら /星空/
ほしつ /保湿/
ほしづきよ /星月夜/
ほしとり /星取り/
ほしな /保科/
ほしゃく /保釈/
ほしゅ /保守/捕手/
ほしゅう /補修/補習/
ほしゅうごう /補集合/
ほしゅしゅぎ /保守主義/
ほしゅてき /保守的/
ほしゅとう /保守党/
ほしょう /保証/保障/補償/堡礁/歩哨/
ほしょうきん /保証金/
ほしょうさいむ /保証債務/
ほしょうしょ /保証書/
ほしょうにん /保証人/
ほしょく /捕食/補色/補職/
ほしょくしゃ /捕食者/
ほしん /保身/
ほじ /保持/
ほじゅう /補充/
ほじょ /補助/
ほじょう /捕縄/
ほじょきかん /補助機関/
ほじょきん /補助金/
ほじょさんか /補助参加/
ほじょたんい /補助単位/
ほじょていり /補助定理/
ほじょぼ /補助簿/
ほじょよく /補助翼/
ほじりょく /保磁力/
ほすう /補数/歩数/
ほずみ /穂積/
ほせい /補正/補整/
ほせいよさん /補正予算/
ほせつ /補説/
ほせん /保線/
ほぜい /保税/
ほぜいうわや /保税上屋/
ほぜいこうじょう /保税工場/
ほぜいそうこ /保税倉庫/
ほぜいちいき /保税地域/
ほぜん /保全/
ほぜんしょぶん /保全処分/
ほそ /細/
ほそい /細井/
ほそいり /細入/
ほそう /舗装/鋪装/
ほそうで /細腕/
ほそえ /細江/
ほそおび /細帯/
ほそおもて /細面/
ほそかわ /細川/
ほそかわがみ /細川紙/
ほそき /細木/
ほそく /補足/補則/捕捉/歩測/
ほそぐち /細口/
ほそじ /細字/
ほそだ /細田/
ほそつ /歩卒/
ほそづくり /細作り/
ほそなが /細長/
ほそぼそ /細々/
ほそみ /細身/細み/
ほそみち /細道/
ほそめ /細目/
ほぞ /臍/
ほぞん /保存/
ほぞんこうい /保存行為/
ほたい /補体/
ほたかじんじゃ /穂高神社/
ほたてがい /帆立貝/
ほたる /蛍/
ほたるいし /蛍石/
ほたるび /蛍火/
ほだ /絆/
ほだい /補題/
ほちゅう /補注/捕虫/
ほちゅうあみ /捕虫網/
ほちょう /歩調/
ほちょうき /補聴器/
ほっ /法/
ほっかい /北海/法界/
ほっかいどう /北海道/
ほっき /発起/
ほっきせつりつ /発起設立/
ほっきにん /発起人/
ほっきょく /北極/
ほっきょくかい /北極海/
ほっきょくけん /北極圏/
ほっきょくせい /北極星/
ほっきょくてん /北極点/
ほっく /発句/
ほっけ /法華/
ほっけきょう /法華経/
ほっけしゅう /法華宗/
ほっこう /北郊/
ほっこく /北国/
ほっさ /発作/
ほっさてき /発作的/
ほっしん /発心/発疹/
ほっす /払子/法主/
ほっせき /発赤/
ほっそく /発足/
ほった /堀田/
ほったん /発端/
ほっとうにん /発頭人/
ほっぴょうよう /北氷洋/
ほっぽう /北方/
ほつ /発/
ほつい /発意/
ほつがん /発願/
ほつぎ /発議/
ほつご /発語/
ほつれ /解れ/
ほづがわ /保津川/
ほづつ /火筒/
ほづな /帆綱/
ほづみ /穂積/
ほてい /布袋/補綴/保定/補訂/
ほてつ /補綴/
ほてん /補填/
ほとぎ /缶/
ほとけ /仏/
ほとけごころ /仏心/
ほとけのざ /仏の座/
ほととぎす /杜鵑/蜀魂/不如帰/子規/時鳥/
ほとり /辺/
ほとんど /殆ど/幾ど/
ほど /程/歩度/
ほどあい /程合い/
ほどう /補導/歩道/舗道/
ほどうきょう /歩道橋/
ほどがや /保土ヶ谷/
ほどこし /施し/
ほどこしもの /施し物/
ほどほど /程々/
ほなが /穂長/
ほなみ /穂波/
ほにゅう /哺乳/
ほにゅうどうぶつ /哺乳動物/
ほにゅうるい /哺乳類/
ほにん /補任/
ほぬの /帆布/
ほね /骨/
ほねおしみ /骨惜しみ/
ほねおり /骨折り/
ほねおりぞん /骨折り損/
ほねかわ /骨皮/
ほねぐみ /骨組/
ほねっぷし /骨っ節/
ほねつき /骨付き/
ほねつぎ /骨接ぎ/
ほねなし /骨無し/
ほねぬき /骨抜き/
ほねぶと /骨太/
ほねぼそ /骨細/
ほねみ /骨身/
ほねやすめ /骨休め/
ほの /仄/
ほのお /炎/焔/
ほのか /仄か/
ほのぼの /仄々/仄仄/
ほはば /歩幅/
ほばく /捕縛/
ほばしら /帆柱/檣/
ほひ /補肥/
ほひつ /補筆/輔弼/
ほふ /保父/
ほふく /匍匐/
ほぶ /歩武/
ほぶね /帆船/
ほへい /歩兵/
ほほ /頬/
ほほえみ /微笑み/
ほぼ /保母/保姆/
ほまれ /誉れ/
ほむぎ /穂麦/
ほむら /焔/
ほゆう /保有/
ほよう /保養/
ほようじょ /保養所/
ほら /洞/法螺/
ほらあな /洞穴/
ほらがい /法螺貝/
ほらがとうげ /洞ヶ峠/
ほらぐち /洞口/
ほり /堀/捕吏/
ほりえ /堀江/
ほりお /堀尾/
ほりかわ /堀川/
ほりきり /堀切/
ほりぐち /堀口/
ほりこし /堀越/
ほりし /彫師/
ほりたつお /堀辰雄/
ほりどめ /堀留/
ほりのうち /堀の内/
ほりばた /堀端/
ほりべ /堀部/
ほりもの /彫物/
ほりものし /彫物師/
ほりゅう /保留/蒲柳/
ほりょ /捕虜/
ほりわり /掘割/
ほるい /堡塁/
ほれい /保冷/
ほれぐすり /惚れ薬/
ほれぼれ /惚れ惚れ/
ほろ /幌/保呂/
ほろう /歩廊/
ほろばしゃ /幌馬車/
ほわんちゅー /黄酒/
ほん /本/翻/奔/反/飜/叛/
ほん> /本/
ほんあみ /本阿弥/
ほんあん /本案/翻案/
ほんあんはんけつ /本案判決/
ほんい /本位/本意/翻意/
ほんいん /本院/本員/
ほんいんぼう /本因坊/
ほんえい /本営/本影/
ほんか /本科/本歌/
ほんかい /本懐/
ほんかいぎ /本会議/
ほんかく /本格/
ほんかくてき /本格的/
ほんかわ /本革/
ほんかん /本館/本官/本管/
ほんがん /本願/
ほんがんじ /本願寺/
ほんき /本気/
ほんきゅう /本給/
ほんきょ /本拠/
ほんきょく /本局/
ほんきん /本金/
ほんぎ /本義/本紀/
ほんぎょう /本業/
ほんぐう /本宮/
ほんぐみ /本組/
ほんぐもり /本曇り/
ほんけ /本家/
ほんけい /本刑/
ほんけほんもと /本家本元/
ほんけん /本件/本権/
ほんげつ /本月/
ほんげん /本源/
ほんこう /本校/本甲/本稿/
ほんこく /翻刻/
ほんこん /香港/
ほんご /本語/
ほんごう /本郷/
ほんごうしん /本郷新/
ほんごく /本国/本石/
ほんごくほう /本国法/
ほんごし /本腰/
ほんさい /本妻/
ほんざん /本山/
ほんし /本誌/本旨/本紙/本志/
ほんしき /本式/
ほんしけん /本試験/
ほんしつ /本質/
ほんしつてき /本質的/
ほんしびさんせん /本四備讃線/
ほんしゃ /本社/
ほんしゅう /本州/
ほんしゅつ /奔出/
ほんしょ /本書/本署/本初/
ほんしょう /本性/本省/本証/
ほんしょく /本職/本色/
ほんしん /本心/本震/
ほんじ /本字/本地/翻字/
ほんじつ /本日/
ほんじょ /本所/
ほんじょう /本庄/本城/本荘/
ほんじん /本陣/
ほんすじ /本筋/
ほんせい /本性/本姓/
ほんせいほん /本製本/
ほんせき /本籍/
ほんせきち /本籍地/
ほんせん /本線/本船/本選/
ほんぜん /本然/翻然/
ほんそ /本訴/
ほんそう /奔走/本葬/
ほんそく /本則/
ほんぞう /本草/
ほんぞく /本属/
ほんぞん /本尊/
ほんたい /本体/本隊/本態/
ほんたいせい /本態性/
ほんたく /本宅/
ほんたて /本立て/
ほんだ /本多/本田/
ほんだい /本題/
ほんだち /本裁ち/
ほんだな /本棚/
ほんち /本地/
ほんちゅう /本中/奔注/
ほんちょう /本庁/本朝/
ほんちょうし /本調子/
ほんつや /本通夜/
ほんて /本手/
ほんてい /本邸/
ほんてん /本店/
ほんでん /本殿/本田/本伝/
ほんと /本当/
ほんとう /本当/奔騰/本島/
ほんとじ /本綴じ/
ほんど /本土/本渡/
ほんどう /本道/本堂/
ほんなだい /本名題/
ほんにん /本人/
ほんね /本音/
ほんねん /本年/本然/
ほんねんど /本年度/
ほんのう /本能/
ほんのうじ /本能寺/
ほんのうてき /本能的/
ほんば /本場/奔馬/
ほんばこ /本箱/
ほんばしょ /本場所/
ほんばん /本番/
ほんぱん /紅幇/
ほんぶ /本部/
ほんぶしん /本普請/
ほんぶたい /本舞台/
ほんぶり /本降り/
ほんぶん /本文/本分/
ほんぷ /本譜/
ほんぷく /本復/
ほんぺん /本編/本篇/
ほんぽ /本舗/
ほんぽう /奔放/本邦/本俸/本法/
ほんま /本間/本馬/
ほんまつ /本末/
ほんまつてんとう /本末転倒/
ほんまる /本丸/
ほんみょう /本名/
ほんむ /本務/
ほんめ /本目/
ほんめい /本命/本名/奔命/
ほんもう /本望/
ほんもと /本元/
ほんもの /本物/
ほんもん /本文/
ほんや /本屋/
ほんやく /翻訳/
ほんやくけん /翻訳権/
ほんゆう /本有/
ほんよさん /本予算/
ほんよみ /本読み/
ほんらい /本来/
ほんらん /本欄/
ほんりゅう /本流/奔流/
ほんりょう /本領/
ほんるい /本塁/
ほんるいだ /本塁打/
ほんれき /本暦/
ほんろう /翻弄/
ほんろん /本論/
ぼ /母/暮/簿/戊/慕/墓/募/模/
ぼいき /墓域/
ぼいん /母音/拇印/
ぼう /某/妨/防/貿/貌/謀/膨/紡/冒/棒/望/暴/房/忙/忘/坊/剖/傍/亡/乏/妄/肪/帽/茫/芒/卯/茅/昴/
ぼう> /某/
ぼうあく /暴悪/
ぼうあつ /暴圧/
ぼうあんき /棒暗記/
ぼうい /暴威/
ぼういん /暴飲/
ぼうう /暴雨/
ぼうえい /防衛/
ぼうえいちょう /防衛庁/
ぼうえき /貿易/防疫/
ぼうえきしゅうし /貿易収支/
ぼうえきしょう /貿易商/
ぼうえきふう /貿易風/
ぼうえきまさつ /貿易摩擦/
ぼうえん /望遠/防煙/
ぼうえんきょう /望遠鏡/
ぼうおん /防音/忘恩/
ぼうか /防火/
ぼうかちいき /防火地域/
ぼうかへき /防火壁/
ぼうかん /傍観/防寒/望観/暴漢/坊間/
ぼうが /忘我/
ぼうがい /妨害/望外/
ぼうきゃく /忘却/
ぼうきょ /暴挙/
ぼうきょう /望郷/防共/
ぼうきれ /棒切れ/
ぼうぎ /謀議/
ぼうぎゃく /暴虐/
ぼうぎょ /防御/防禦/
ぼうぎょりつ /防御率/
ぼうくう /防空/
ぼうくうごう /防空壕/
ぼうくん /暴君/亡君/傍訓/
ぼうぐ /防具/
ぼうぐみ /棒組/
ぼうけい /傍系/亡兄/謀計/
ぼうけいけつぞく /傍系血族/
ぼうけいしんぞく /傍系親族/
ぼうけん /冒険/剖検/望見/
ぼうけんしょうせつ /冒険小説/
ぼうげん /暴言/妄言/
ぼうこう /暴行/膀胱/
ぼうこうえん /膀胱炎/
ぼうこうがん /膀胱癌/
ぼうこうざい /暴行罪/
ぼうこく /亡国/坊刻/
ぼうご /防護/
ぼうさ /防砂/
ぼうさい /防災/亡妻/
ぼうさき /棒先/
ぼうさつ /忙殺/謀殺/
ぼうさん /坊さん/
ぼうし /帽子/防止/某氏/紡糸/亡姉/
ぼうしつ /亡失/忘失/防湿/房室/
ぼうしゅ /芒種/
ぼうしゅう /防臭/房州/
ぼうしゅうざい /防臭剤/
ぼうしゅく /防縮/
ぼうしょ /某所/防暑/
ぼうしょう /傍証/帽章/
ぼうしょく /暴食/望蜀/紡織/
ぼうしょくざい /防食剤/
ぼうじ /亡児/房事/
ぼうじつ /某日/
ぼうじま /棒縞/
ぼうじゃくぶじん /傍若無人/
ぼうじゅ /傍受/
ぼうじゅつ /棒術/
ぼうじょ /防除/
ぼうじょう /棒状/坊城/暴状/
ぼうじん /防塵/
ぼうすい /紡錘/防水/
ぼうすいかこう /防水加工/
ぼうすいけい /紡錘形/
ぼうすいちゅう /紡錘虫/
ぼうすいふ /防水布/
ぼうず /坊主/
ぼうずあたま /坊主頭/
ぼうせい /暴政/
ぼうせき /紡績/
ぼうせつ /防雪/
ぼうせつりん /防雪林/
ぼうせん /防戦/傍線/棒線/
ぼうせんもう /防潜網/
ぼうぜん /呆然/茫然/
ぼうぜんじしつ /茫然自失/
ぼうそう /暴走/房総/
ぼうそうぞく /暴走族/
ぼうそうはんとう /房総半島/
ぼうたおし /棒倒し/
ぼうだ /滂沱/
ぼうだい /膨大/厖大/傍題/
ぼうだち /棒立ち/
ぼうだら /棒鱈/
ぼうだん /防弾/
ぼうちゅう /傍注/防虫/忙中/
ぼうちゅうざい /防虫剤/
ぼうちょう /膨張/傍聴/膨脹/防諜/防長/防潮/
ぼうちょうりつ /膨張率/
ぼうてい /亡弟/
ぼうてん /傍点/
ぼうと /暴徒/
ぼうとう /冒頭/暴騰/暴投/
ぼうとうちんじゅつ /冒頭陳述/
ぼうとく /冒涜/
ぼうどう /暴動/
ぼうどく /防毒/
ぼうにょう /乏尿/
ぼうねん /忘年/
ぼうねんかい /忘年会/
ぼうのつ /坊津/
ぼうはく /傍白/
ぼうはつ /暴発/
ぼうはてい /防波堤/
ぼうはん /防犯/謀判/
ぼうばく /茫漠/
ぼうひょう /暴評/
ぼうび /防備/
ぼうびき /棒引き/
ぼうふ /亡夫/亡父/防腐/
ぼうふう /暴風/防風/
ぼうふうう /暴風雨/
ぼうふうりん /防風林/
ぼうふざい /防腐剤/
ぼうへき /防壁/
ぼうぼ /亡母/
ぼうぼう /某々/茫茫/
ぼうまい /亡妹/
ぼうまん /暴慢/
ぼうみん /暴民/
ぼうめい /亡命/
ぼうもう /紡毛/
ぼうや /坊や/
ぼうゆう /亡友/暴勇/
ぼうよう /望洋/茫洋/
ぼうよみ /棒読み/
ぼうらく /暴落/
ぼうり /暴利/
ぼうりゃく /謀略/
ぼうりゅう /傍流/
ぼうりょう /坊領/
ぼうりょく /暴力/
ぼうりょくだん /暴力団/
ぼうれい /亡霊/暴戻/
ぼうろう /望楼/
ぼうろん /暴論/
ぼおん /母音/
ぼか /簿価/
ぼかん /母艦/
ぼがいしさん /簿外資産/
ぼき /簿記/
ぼきん /募金/
ぼく /僕/木/牧/朴/撲/墨/卜/目/樸/穆/睦/
ぼくが /墨画/
ぼくぎゅう /牧牛/
ぼくさつ /撲殺/
ぼくし /牧師/墨子/
ぼくしゃ /牧舎/卜者/
ぼくしゅ /墨守/
ぼくしょ /墨書/
ぼくしょく /墨色/
ぼくしん /牧神/
ぼくじ /墨字/
ぼくじゅう /墨汁/
ぼくじょう /牧場/
ぼくじん /牧人/
ぼくすい /墨水/
ぼくせき /木石/
ぼくせん /卜占/
ぼくそう /牧草/
ぼくたく /木鐸/
ぼくちく /牧畜/
ぼくてき /牧笛/
ぼくとう /木刀/墨東/
ぼくとつ /朴訥/
ぼくどう /牧童/
ぼくねんじん /朴念仁/
ぼくふ /牧夫/
ぼくめつ /撲滅/
ぼくよう /牧羊/
ぼくようしん /牧羊神/
ぼけ /惚け/木瓜/
ぼけい /母系/母型/
ぼけつ /墓穴/
ぼけん /母権/
ぼこう /母校/母港/母后/
ぼこく /母国/
ぼこくご /母国語/
ぼご /母語/
ぼさい /募債/
ぼさつ /菩薩/
ぼさん /墓参/
ぼざい /母材/
ぼし /母子/墓誌/
ぼしかてい /母子家庭/
ぼしゅう /募集/暮秋/
ぼしゅうせつりつ /募集設立/
ぼしゅうだん /母集団/
ぼしゅん /暮春/
ぼしょ /墓所/簿書/
ぼしょう /暮鐘/
ぼしょく /暮色/
ぼしりょう /母子寮/
ぼしん /戊辰/
ぼしんせんそう /戊辰戦争/
ぼじょう /慕情/
ぼすう /母数/
ぼせい /母性/
ぼせいあい /母性愛/
ぼせき /墓石/
ぼせん /母船/母線/
ぼぜん /墓前/
ぼたい /母体/母胎/
ぼたもち /牡丹餅/
ぼたやま /ぼた山/
ぼたん /釦/牡丹/鈕/
ぼたんこう /牡丹江/
ぼたんどうろう /牡丹灯籠/
ぼだい /菩提/
ぼだいじ /菩提寺/
ぼだいじゅ /菩提樹/
ぼち /墓地/
ぼっ /坊/
ぼっか /牧歌/
ぼっかい /渤海/
ぼっかく /墨客/
ぼっかてき /牧歌的/
ぼっき /勃起/
ぼっきゃく /没却/
ぼっこう /勃興/
ぼっこん /墨痕/
ぼっしゅ /没取/
ぼっしゅう /没収/
ぼっしゅみ /没趣味/
ぼっしょ /没書/
ぼっちゃん /坊っちゃん/
ぼっとう /没頭/
ぼっぱつ /勃発/
ぼつ /没/勃/歿/
ぼつが /没我/
ぼつご /没後/歿後/
ぼつじょうしき /没常識/
ぼつぜん /勃然/
ぼつにゅう /没入/
ぼつねん /歿年/
ぼつふうりゅう /没風流/
ぼつらく /没落/
ぼどう /母堂/
ぼにゅう /母乳/
ぼはん /母斑/
ぼば /牡馬/
ぼひ /墓碑/
ぼひめい /墓碑銘/
ぼひょう /墓標/
ぼぶんさん /母分散/
ぼへい /募兵/
ぼへいきん /母平均/
ぼめい /墓銘/
ぼや /暮夜/
ぼら /鯔/鰡/
ぼろ /襤褸/
ぼろもうけ /ぼろ儲け/
ぼん /盆/凡/煩/梵/
ぼんおどり /盆踊/
ぼんがいちにょ /梵我一如/
ぼんくれ /盆暮/
ぼんぐ /凡愚/
ぼんけい /盆景/
ぼんこつ /凡骨/
ぼんご /梵語/
ぼんさい /盆栽/凡才/
ぼんさく /凡作/凡策/
ぼんしつ /凡失/
ぼんしゅ /凡手/
ぼんしょう /梵鐘/凡小/
ぼんじ /梵字/
ぼんじん /凡人/
ぼんせき /盆石/
ぼんせん /凡戦/
ぼんぞく /凡俗/
ぼんたい /凡退/
ぼんだ /凡打/
ぼんだて /盆点/
ぼんち /盆地/
ぼんてん /梵天/
ぼんのう /煩悩/
ぼんぶん /梵文/
ぼんべい /孟買/
ぼんよう /凡庸/
ぼんりょ /凡慮/
ぽーらんど /波蘭/
ぽっくりびょう /ぽっくり病/
ぽっとで /ぽっと出/
ぽるとがる /葡萄牙/
ぽん /本/
ぽんかん /椪柑/
ぽんとちょう /先斗町/
ぽんびき /ぽん引き/
ま /間/目/真/麻/魔/磨/摩/馬/
ま> /真/
まーじゃん /麻雀/
まあい /間合/
まい /枚/毎/昧/妹/埋/米/麻衣/参/舞/
まい> /毎/
まいあさ /毎朝/
まいおさめ /舞い納め/
まいかい /毎回/
まいかぜ /舞風/
まいき /毎期/
まいきょ /枚挙/
まいげつ /毎月/
まいこ /舞妓/毎戸/舞子/
まいこつ /埋骨/
まいご /迷子/
まいごう /毎号/
まいさか /舞阪/
まいしゅう /毎週/
まいしょく /毎食/
まいしん /邁進/
まいじ /毎時/毎次/
まいすう /枚数/
まいせき /毎夕/
まいせつ /埋設/
まいそう /埋葬/
まいぞう /埋蔵/
まいぞうぶつ /埋蔵物/
まいたけ /舞茸/
まいちもんじ /真一文字/
まいつき /毎月/
まいづる /舞鶴/
まいとし /毎年/
まいど /毎度/
まいにち /毎日/
まいにちしんぶん /毎日新聞/
まいねん /毎年/
まいはら /米原/
まいばん /毎晩/
まいひめ /舞姫/
まいぼつ /埋没/
まいまい /毎々/
まいや /毎夜/
まいゆう /毎夕/
まいよ /毎夜/
まいる /哩/
まうえ /真上/
まうち /間内/
まうら /真裏/
まえ /前/
まえあし /前足/前脚/
まえいた /前板/
まえいわい /前祝/
まえうしろ /前後ろ/
まえうり /前売り/
まえおき /前置き/
まえかがみ /前屈み/
まえかけ /前掛け/
まえかた /前方/
まえかんじょう /前勘定/
まえがき /前書/
まえがし /前貸し/
まえがしら /前頭/
まえがみ /前髪/
まえがり /前借り/
まえきん /前金/
まえげいき /前景気/
まえこうじょう /前口上/
まえこぐち /前小口/
まえさがり /前下がり/
まえしょり /前処理/
まえじま /前島/
まえじらせ /前知らせ/
まえずもう /前相撲/
まえせつ /前説/
まえせんでん /前宣伝/
まえだ /前田/
まえだおし /前倒し/
まえだとしいえ /前田利家/
まえだれ /前垂れ/
まえづけ /前付/
まえの /前野/
まえのめり /前のめり/
まえのりょうたく /前野良沢/
まえば /前歯/
まえばし /前橋/
まえばしし /前橋市/
まえばら /前原/
まえばらい /前払い/
まえひょうばん /前評判/
まえび /前日/
まえびろ /前広/
まえぶれ /前触れ/
まえまえ /前々/
まえむき /前向き/
まえもって /前以て/
まえやく /前厄/
まえわたし /前渡し/
まお /苧麻/真麻/
まおう /魔王/
まおたいちゅー /茅台酒/
まおとこ /間男/
まか /摩訶/
まかい /魔界/
まかお /澳門/
まかず /間数/
まかせ /任せ/
まかふしぎ /摩訶不思議/
まがお /真顔/
まがき /籬/
まがし /間貸し/
まがたま /勾玉/
まがも /真鴨/
まがり /間借り/
まがりかど /曲り角/
まき /巻/牧/薪/真木/槙/
まきえ /蒔絵/撒き餌/
まきかわ /巻川/
まきがい /巻貝/
まきがみ /巻紙/
まきじく /巻軸/
まきじた /巻き舌/
まきじゃく /巻尺/
まきせん /巻線/
まきぞえ /巻き添え/
まきた /真北/蒔田/
まきつけ /蒔付け/
まきの /牧野/
まきば /牧場/
まきばしら /真木柱/
まきひげ /巻鬚/
まきほん /巻本/
まきもの /巻物/
まきょう /魔境/
まきわり /薪割り/
まぎ /間木/
まぎょう /マ行/
まぎら /紛ら/
まぎらわし /紛らわし/
まぎれ /紛れ/
まぎわ /間際/真際/
まく /膜/幕/
まくあい /幕間/
まくあき /幕開き/
まくあけ /幕開け/
まくうち /幕内/
まくぎれ /幕切れ/
まくした /幕下/
まくしつ /膜質/
まくつ /魔窟/
まくでんい /膜電位/
まくのうち /幕の内/
まくま /幕間/
まくら /枕/
まくらえ /枕絵/
まくらぎ /枕木/
まくらことば /枕詞/枕言葉/
まくらざき /枕崎/
まくらのそうし /枕草子/
まくらぼん /枕本/
まくらもと /枕元/
まぐさ /秣/
まぐし /馬櫛/
まぐそ /馬糞/
まぐち /間口/
まぐれ /紛れ/
まぐろ /鮪/
まけ /負け/
まけいぬ /負け犬/
まけいろ /負け色/
まけおしみ /負け惜しみ/
まけぎらい /負け嫌い/
まけじだましい /負けじ魂/
まけずぎらい /負けず嫌い/
まけぼし /負星/
まけんき /負けん気/
まげ /髷/曲げ/
まこ /真子/
まこと /誠/真/
まご /孫/馬子/
まごい /真鯉/
まごうた /馬子唄/
まごこ /孫子/
まごころ /真心/
まごでし /孫弟子/
まごのて /孫の手/
まごびき /孫引き/
まごむすめ /孫娘/
まごめ /馬籠/
まさ /正/柾/
まさおか /政岡/正岡/
まさおかしき /正岡子規/
まさかど /将門/
まさかり /鉞/
まさき /真先/真崎/正木/
まさご /真砂/
まさしく /正しく/
まさつ /摩擦/
まさつおん /摩擦音/
まさつけいすう /摩擦係数/
まさつていこう /摩擦抵抗/
まさつね /正恒/
まさつりょく /摩擦力/
まさに /正に/
まさひで /正秀/
まさむね /正宗/
まさめ /正目/
まさゆめ /正夢/
まさりおとり /優り劣り/
まし /麻紙/
ましお /真潮/
ましかく /真四角/
ましこ /益子/
ました /真下/増田/
まして /況して/
ましば /真柴/
ましばがき /真柴垣/
ましゃく /間尺/
ましゅ /魔手/
ましゅうこ /摩周湖/
ましょう /魔性/魔障/
ましょうじき /真正直/
ましょうめん /真正面/
ましら /猿/
ましん /麻疹/
まじ /真風/
まじか /間近/
まじきり /間仕切/
まじない /呪い/
まじま /真島/
まじめ /真面目/
まじゅつ /魔術/
まじょ /魔女/
まじわり /交わり/
まじん /魔神/
ます /鱒/升/枡/桝/舛/
ますい /麻酔/
ますいやく /麻酔薬/
ますだ /益田/升田/
ますとみおんせん /増富温泉/
ますほ /増穂/
ますみ /真澄/
ますみだじんじゃ /真清田神社/
ますめ /升目/枡目/
ますやま /増山/
ますらお /益荒男/丈夫/
まず /先ず/
まずい /不味い/
まそん /摩損/
また /又/亦/股/俣/
またがし /又貸し/
またがり /又借り/
またぎき /又聞き/
またぐらごうやく /股座膏薬/
またした /股下/
またぞろ /又候/
またたくま /瞬く間/
またたび /股旅/
まただのみ /又頼み/
またどなり /又隣/
または /又は/
またま /真玉/
またもの /又者/
まだ /未だ/
まだい /真鯛/
まだこ /真蛸/
まだし /未だし/
まだら /斑/真鱈/
まち /町/襠/待ち/区/街/
まちあい /待合/
まちあいしつ /待合室/
まちあわせ /待合せ/
まちいしゃ /町医者/
まちかた /町方/
まちかど /街角/
まちかね /待兼/
まちかねやま /待兼山/
まちがい /間違い/
まちこうば /町工場/
まちじかん /待ち時間/
まちじゅう /町中/
まちすじ /町筋/
まちだ /町田/
まちなか /町中/
まちなみ /街並/町並/
まちはずれ /町外れ/
まちばり /待針/
まちびと /待ち人/
まちぶぎょう /町奉行/
まちぶせ /待ち伏せ/
まちぼうけ /待ち惚け/
まちまち /区々/区区/
まちや /町家/
まちやくば /町役場/
まちやっこ /町奴/
まぢか /間近/
まっか /真っ赤/
まっかつ /靺鞨/
まっかん /末巻/
まっき /末期/
まっきてき /末期的/
まっくら /真っ暗/
まっくらやみ /真っ暗闇/
まっくろ /真っ黒/
まっこう /真っ向/抹香/
まっさいちゅう /真っ最中/
まっさお /真っ青/
まっさかさま /真っ逆さま/
まっさかり /真っ盛り/
まっさき /真っ先/
まっさつ /抹殺/
まっさら /真っ新/
まっし /末子/
まっしゃ /末社/
まっしょう /抹消/末梢/
まっしょうしんけい /末梢神経/
まっしょうじき /真っ正直/
まっしょうとうき /抹消登記/
まっしろ /真っ白/
まっすぐ /真っ直ぐ/
まっせ /末世/
まっせき /末席/
まっせつ /末節/
まっそん /末孫/
まったいら /真っ平ら/
まったく /全く/
まっただなか /真っ只中/
まったなし /待った無し/
まったん /末端/
まっち /燐寸/
まっちゃ /抹茶/
まってい /末弟/
まっとう /松任/
まっぱ /末派/
まっぱい /末輩/
まっぴつ /末筆/
まっぴら /真っ平/
まっぴるま /真っ昼間/
まっぷたつ /真っ二つ/
まっぽう /末法/
まつ /松/末/抹/沫/
まつい /松井/松居/末位/
まついだ /松井田/
まつうら /松浦/
まつえ /松江/
まつえい /末裔/
まつえし /松江市/
まつお /松尾/
まつおか /松岡/
まつおばしょう /松尾芭蕉/
まつかざり /松飾り/
まつかぜ /松風/
まつかた /松方/
まつかたまさよし /松方正義/
まつげ /睫/睫毛/
まつご /末期/
まつさか /松阪/松坂/
まつざ /末座/
まつざき /松崎/
まつした /松下/
まつしま /松島/
まつしろ /松代/
まつじ /末寺/
まつじつ /末日/
まつたけ /松茸/
まつだ /松田/
まつだい /末代/
まつだいら /松平/
まつち /真土/
まつど /松戸/
まつなが /松永/
まつなみ /松波/
まつなん /末男/
まつね /松根/
まつねん /末年/
まつのうち /松の内/
まつば /松葉/
まつばいろ /松葉色/
まつばづえ /松葉杖/
まつばやし /松林/
まつばら /松原/
まつび /末尾/
まつぶん /末文/
まつまえ /松前/
まつむし /松虫/
まつむら /松村/
まつもと /松本/
まつもとこうしろう /松本幸四郎/
まつやに /松脂/
まつやま /松山/
まつやまし /松山市/
まつよう /末葉/
まつら /松浦/
まつり /祭り/祭/
まつりごと /政/
まつりゅう /末流/
まつろ /末路/
まて /蟶/
まてがい /蟶貝/
まてき /魔笛/
まてんろう /摩天楼/
まで /迄/
まと /的/
まとい /纏/
まとうだい /的鯛/
まとはずれ /的外れ/
まとば /的場/
まとも /真面/真艫/
まとや /的矢/
まとり /真鳥/
まど /窓/窗/
まどう /魔道/
まどお /間遠/
まどか /円か/
まどぎわ /窓際/
まどぐち /窓口/
まどころ /政所/
まどだい /窓台/
まどべ /窓辺/
まどり /間取り/
まどわく /窓枠/
まな /真名/愛/
まないた /俎/俎板/
まなか /真中/
まなこ /眼/
まなご /真砂/
まなじり /眥/眦/
まなつ /真夏/
まなつび /真夏日/
まなづる /真鶴/
まなでし /愛弟子/
まなびや /学舎/
まなべ /真鍋/
まなむすめ /愛娘/
まにあわせ /間に合せ/
まにし /真西/
まにまに /随に/
まにんげん /真人間/
まぬけ /間抜け/
まね /真似/
まねきねこ /招き猫/
まねごと /真似事/
まのび /間延び/
まばしら /間柱/
まばたき /瞬き/
まばら /疎ら/
まひ /麻痺/痲痺/
まひがし /真東/
まひと /真人/
まひる /真昼/
まびき /間引き/
まふね /真船/
まふゆ /真冬/
まふゆび /真冬日/
まぶ /間夫/
まぶか /目深/
まぶた /瞼/目蓋/
まぶに /摩文仁/
まほ /真帆/真秀/
まほう /魔法/
まほうじん /魔方陣/
まほうつかい /魔法使い/
まほうびん /魔法瓶/
まぼろし /幻/
まま /儘/随/侭/
ままおや /継親/
ままこ /継子/
ままこあつかい /継子扱い/
ままごと /飯事/
ままちち /継父/
ままはは /継母/
まみず /真水/
まみなみ /真南/
まみや /間宮/
まみやかいきょう /間宮海峡/
まむかい /真向い/
まむき /真向き/
まむし /蝮/
まむすび /真結び/
まめ /豆/荳/
まめあぶら /豆油/
まめか /豆科/
まめしぼり /豆絞り/
まめぞう /豆蔵/
まめたん /豆炭/
まめつ /摩滅/磨滅/
まめつぶ /豆粒/
まめでっぽう /豆鉄砲/
まめでんきゅう /豆電球/
まめほん /豆本/
まもう /摩耗/磨耗/
まもなく /間も無く/
まもの /魔物/
まもりがみ /守り神/
まや /摩耶/馬屋/
まやく /麻薬/
まやさん /摩耶山/
まやま /真山/
まゆ /繭/眉/
まゆげ /眉毛/
まゆじり /眉尻/
まゆずみ /黛/
まゆだま /繭玉/
まゆつば /眉唾/
まゆつばもの /眉唾物/
まゆね /眉根/
まゆみ /真弓/檀/
まよい /迷い/
まよけ /魔除け/
まよこ /真横/
まよなか /真夜中/
まら /摩羅/
まり /鞠/毬/
まりこ /丸子/
まりしてん /摩利支天/
まりも /毬藻/
まりょく /魔力/
まる /円/丸/○/●/◎/
まるあき /丸明き/
まるあらい /丸洗い/
まるあんき /丸暗記/
まるいち /丸一/
まるうつし /丸写し/
まるえり /丸襟/
まるがお /丸顔/
まるがかえ /丸抱え/
まるがめ /丸亀/
まるがり /丸刈り/
まるき /丸木/
まるくび /丸首/
まるこ /丸子/
まるごし /丸腰/
まるざい /丸材/
まるぞん /丸損/
まるた /丸太/
まるたんぼう /丸太ん棒/
まるだし /丸出し/
まるつぶれ /丸潰れ/
まるづか /丸塚/
まるてんじょう /円天井/
まるどり /丸取り/
まるのうち /丸の内/
まるのこ /丸鋸/
まるのみ /丸呑み/
まるはだか /丸裸/
まるはち /丸八/
まるばし /丸橋/
まるばしら /丸柱/
まるひ /丸秘/
まるほん /丸本/
まるぼうず /丸坊主/
まるぼし /丸干し/
まるぽちゃ /丸ぽちゃ/
まるまげ /丸髷/
まるまど /円窓/
まるまる /丸々/
まるみえ /丸見え/
まるもうけ /丸儲け/
まるもじ /丸文字/
まるやき /丸焼き/
まるやけ /丸焼け/
まるやま /丸山/円山/
まるゆう /マル優/
まれ /稀/希/
まろ /麿/麻呂/
まろやか /円やか/
まわし /回し/
まわしもの /回し者/
まわた /真綿/
まわり /廻り/周り/回り/
まわりみち /回り道/
まん /万/満/漫/慢/饅/幔/蔓/
まんいち /万一/
まんいつ /万一/
まんいん /満員/
まんえつ /満悦/
まんえん /蔓延/万延/万円/
まんかい /満開/
まんかぶ /満株/
まんかん /満干/
まんかんしょく /満艦飾/
まんが /漫画/
まんがいち /万が一/
まんがか /漫画家/
まんがく /満額/
まんがん /満貫/満願/万巻/
まんき /満期/
まんきじつ /満期日/
まんきつ /満喫/
まんきん /万金/
まんぎょう /万行/
まんげきょう /万華鏡/
まんげつ /満月/
まんげん /万言/漫言/
まんこう /満腔/
まんごう /万劫/
まんさい /満載/
まんさく /満作/
まんざ /満座/
まんざい /漫才/万歳/
まんざおんせん /万座温泉/
まんざら /満更/
まんざん /満山/
まんしゃ /満車/
まんしゅいん /曼殊院/
まんしゅう /満州/
まんしゅうこく /満州国/
まんしゅうご /満州語/
まんしゅうじへん /満州事変/
まんしゅうぞく /満州族/
まんしょう /満床/
まんしん /満身/慢心/
まんしんそうい /満身創痍/
まんじ /卍/万治/
まんじゅう /饅頭/
まんじゅうやぼん /饅頭屋本/
まんじゅしゃげ /曼珠沙華/
まんじょう /満場/
まんじょういっち /満場一致/
まんすい /満水/
まんせい /慢性/
まんせいびょう /慢性病/
まんせき /満席/
まんぜん /漫然/万善/
まんぞく /満足/
まんだい /万代/
まんだら /曼陀羅/曼荼羅/
まんだん /漫談/
まんちゃく /瞞着/
まんちょう /満潮/
まんてつ /満鉄/
まんてん /満点/満天/
まんてんか /満天下/
まんどころ /政所/
まんなか /真ん中/
まんにょうしゅう /万葉集/
まんにん /万人/
まんねん /万年/
まんねんどこ /万年床/
まんねんひつ /万年筆/
まんねんゆき /万年雪/
まんねんれい /満年齢/
まんば /漫罵/
まんぱ /万波/
まんぱい /満杯/
まんびき /万引/
まんびょう /万病/
まんぴつ /漫筆/
まんぴょう /満票/漫評/
まんぶ /万部/
まんぶん /漫文/
まんぷく /満腹/満幅/万福/
まんぷくじ /万福寺/
まんべん /満遍/
まんぼう /翻車魚/
まんぽ /漫歩/
まんぽけい /万歩計/
まんまえ /真ん前/
まんまく /幔幕/
まんまん /満々/
まんめん /満面/
まんもう /満蒙/
まんもく /万目/満目/
まんゆう /漫遊/
まんよう /万葉/
まんようがな /万葉仮名/
まんようしゅう /万葉集/
まんりき /万力/
まんりょう /満了/万両/
まんるい /満塁/
み /実/味/三/身/未/箕/巳/魅/見/御/
み> /未/
みあい /見合い/
みあげ /見上/
みい /三井/御井/
みいけ /三池/
みいでら /三井寺/
みいら /木乃伊/
みいり /実入り/
みうけ /身請け/
みうごき /身動き/
みうち /身内/御内/
みうら /三浦/
みうらはんとう /三浦半島/
みうり /身売り/
みえ /三重/見え/
みえがくれ /見え隠れ/
みえけん /三重県/
みえっぱり /見栄っ張り/
みえぼう /見栄坊/
みえみえ /見え見え/
みお /水脈/澪/
みおくり /見送り/
みおさめ /見納め/
みおつくし /澪標/
みおとし /見落し/
みおとり /見劣り/
みおぼえ /見覚え/
みおも /身重/
みか /甕/
みかい /未開/味解/
みかいけつ /未解決/
みかえし /見返し/
みかえり /見返り/
みかえりひん /見返り品/
みかく /味覚/
みかくにん /未確認/
みかぐら /御神楽/
みかけ /見掛け/
みかげ /御影/御蔭/
みかげいし /御影石/
みかさ /三笠/
みかさのみや /三笠宮/
みかた /味方/見方/
みかづき /三日月/
みかづきこ /三日月湖/
みかど /御門/
みかみ /三上/
みかわ /三河/
みかわわん /三河湾/
みかん /未完/未刊/蜜柑/味感/
みかんせい /未完成/
みがきこ /磨き粉/
みがきずな /磨き砂/
みがため /身固め/
みがって /身勝手/
みがまえ /身構え/
みがら /身柄/
みがらそうけん /身柄送検/
みがる /身軽/
みがわり /身代り/
みき /幹/神酒/三木/御酒/
みきき /見聞き/
みきたけお /三木武夫/
みきり /見切り/
みきりはっしゃ /見切り発車/
みきわめ /見極め/
みぎ /右/→/
みぎうで /右腕/
みぎがき /右書き/
みぎがわ /右側/
みぎきき /右利き/
みぎて /右手/
みぎてけい /右手系/
みぎひだり /右左/
みぎまえ /右前/
みぎまわり /右回り/
みぎよつ /右四つ/
みぎり /砌/
みぎわ /汀/
みくだりはん /三行半/三下半/
みくに /三国/御国/
みくにとうげ /三国峠/
みくりや /御厨/
みけ /三毛/
みけつ /未決/
みけつこうりゅう /未決勾留/
みけつしゅう /未決囚/
みけねこ /三毛猫/
みけん /眉間/未見/
みこ /御子/巫女/皇子/
みこし /御輿/
みこと /命/尊/
みことのり /詔/勅/
みこみ /見込み/
みこみちがい /見込み違い/
みこん /未婚/未墾/
みごうしゃ /見巧者/
みごしらえ /身拵え/
みごたえ /見応え/
みごと /見事/
みごろ /見頃/
みごろし /見殺し/
みさい /未済/
みさお /操/
みさか /御坂/
みさかい /見境/
みさき /御前/崎/岬/
みさご /鶚/
みささ /三朝/
みささぎ /陵/
みさと /三郷/
みさわ /三沢/
みしま /三島/
みしまゆきお /三島由紀夫/
みしゅう /未収/
みしょう /未詳/実生/
みしらず /身知らず/
みじか /身近/短/
みじたく /身支度/身仕度/
みじまい /身仕舞/
みじめ /惨め/
みじゅく /未熟/
みじゅくじ /未熟児/
みじろぎ /身じろぎ/
みじん /微塵/
みじんぎり /微塵切り/
みじんこ /微塵子/
みす /御簾/
みすい /未遂/
みすいざい /未遂罪/
みすじ /三筋/
みず /水/瑞/
みずあか /水垢/
みずあげ /水揚げ/
みずあさぎ /水浅葱/
みずあし /水足/
みずあそび /水遊び/
みずあび /水浴び/
みずあめ /水飴/
みずあらい /水洗い/
みずいも /水芋/
みずいらず /水入らず/
みずいり /水入り/
みずいろ /水色/
みずうみ /湖/
みずえ /水絵/瑞枝/
みずおけ /水桶/
みずおと /水音/
みずかがみ /水鏡/
みずかき /蹼/水掻き/
みずかけろん /水掛け論/
みずかげん /水加減/
みずかさ /水嵩/
みずから /自ら/
みずがめ /水瓶/
みずがめざ /水瓶座/
みずがれ /水涸れ/
みずき /水木/水城/瑞木/
みずききん /水飢饉/
みずきり /水切り/
みずぎ /水着/
みずぎわ /水際/
みずくさ /水草/
みずくさい /水臭い/
みずぐすり /水薬/
みずぐち /水口/
みずぐるま /水車/
みずけ /水気/
みずけむり /水煙/
みずげい /水芸/
みずごえ /水肥/
みずごころ /水心/
みずさいばい /水栽培/
みずさき /水先/
みずさきあんない /水先案内/
みずさきにん /水先人/
みずさわ /水沢/
みずしげん /水資源/
みずしごと /水仕事/
みずしま /水島/
みずしょうばい /水商売/
みずしらず /見ず知らず/
みずぜめ /水攻め/水責め/
みずた /水田/
みずたき /水炊き/
みずたに /水谷/
みずたま /水玉/
みずたまもよう /水玉模様/
みずだこ /水蛸/
みずち /蛟/
みずでっぽう /水鉄砲/
みずとり /水鳥/
みずどけい /水時計/
みずな /水菜/
みずなし /水梨/
みずなみ /瑞浪/
みずに /水煮/
みずの /水野/
みずのあわ /水の泡/
みずのえ /壬/
みずのて /水の手/
みずのと /癸/
みずはけ /水捌け/
みずはら /水原/
みずば /水場/
みずばしょう /水芭蕉/
みずばしら /水柱/
みずばら /水腹/
みずばり /水張り/
みずひき /水引/
みずびたし /水浸し/
みずぶとり /水太り/
みずぶろ /水風呂/
みずべ /水辺/
みずほ /瑞穂/
みずぼうそう /水疱瘡/
みずぼり /水堀/
みずまき /水撒き/
みずまくら /水枕/
みずまし /水増し/
みずむけ /水向け/
みずむし /水虫/
みずもの /水物/
みずもれ /水漏れ/
みずや /水屋/
みずら /髻/鬟/
みずわり /水割り/
みせ /店/
みせいねん /未成年/
みせいねんしゃ /未成年者/
みせかけ /見せ掛け/
みせがね /見せ金/
みせがまえ /店構え/
みせさき /店先/
みせしめ /見せしめ/
みせじまい /店仕舞い/
みせつ /未設/
みせば /見せ場/
みせばん /店番/
みせびらき /店開き/
みせもの /見世物/
みせや /店屋/
みぜに /身銭/
みぜん /未然/
みぜんけい /未然形/
みそ /味噌/三十/
みそか /晦日/三十日/晦/
みそぎ /禊/
みそこし /味噌漉し/
みそさざい /鷦鷯/
みそしき /未組織/
みそしる /味噌汁/
みそじ /三十路/
みそっかす /味噌っ滓/
みそづけ /味噌漬/
みそに /味噌煮/
みその /御園/
みそのう /御園生/
みそひともじ /三十一文字/
みそまめ /味噌豆/
みそら /身空/
みそらひばり /美空ひばり/
みぞ /溝/
みぞう /未曾有/
みぞおち /鳩尾/
みぞぐち /溝口/
みぞれ /霙/
みた /三田/
みたか /三鷹/
みたけ /身丈/御岳/
みたて /見立て/御館/
みたま /御霊/
みたまや /御霊屋/
みたむら /三田村/
みため /見た目/
みたらい /御手洗/
みたらし /御手洗/
みだ /弥陀/
みだい /御台/
みだいどころ /御台所/
みだし /見出し/
みだしなみ /身嗜み/
みだれ /乱れ/
みだれがみ /乱れ髪/
みだれば /乱れ刃/
みだればん /乱れ版/
みち /未知/道/路/途/満ち/
みちあんない /道案内/
みちいと /道糸/
みちがい /見違い/
みちがえ /見違え/
みちくさ /道草/
みちしお /満ち潮/
みちしるべ /道標/
みちじゅん /道順/
みちすう /未知数/
みちすじ /道筋/
みちづれ /道連れ/
みちなか /道中/
みちのく /陸奥/
みちのくがみ /陸奥紙/
みちのし /道師/
みちのり /道程/
みちばた /道端/
みちひ /満ち干/
みちぶしん /道普請/
みちべ /道辺/
みちみち /道々/
みちゃく /未着/
みちゆき /道行/
みぢか /身近/
みっか /三日/
みっかい /密会/
みっかてんか /三日天下/
みっかぼうず /三日坊主/
みっきょう /密教/
みっけい /密計/
みっこう /密航/密行/
みっこく /密告/
みっさつ /密殺/
みっし /密使/
みっしつ /密室/
みっしゅう /密集/
みっしょ /密書/
みっせい /密生/
みっせつ /密接/
みっせん /密栓/
みっそう /密葬/密送/密奏/
みっちゃく /密着/
みっつ /三つ/
みっつう /密通/
みってい /密偵/
みっぷう /密封/
みっぺい /密閉/
みつ /蜜/密/三つ/
みつい /三井/
みつうん /密雲/
みつえ /御杖/
みつかいどう /水海道/
みつが /密画/
みつがさね /三つ重ね/
みつぎ /調/密議/
みつぎりぼん /三つ切本/
みつくり /箕作/
みつぐみ /三つ組/
みつけ /見付/見附/
みつげつ /蜜月/
みつご /蜜語/
みつじ /密事/
みつせん /蜜腺/
みつぞう /密造/
みつぞろい /三つ揃い/
みつだ /光田/
みつだん /密談/
みつど /密度/
みつどもえ /三つ巴/
みつのぶ /光信/
みつば /三葉/
みつばい /密売/
みつばち /蜜蜂/
みつぼうえき /密貿易/
みつぼし /三つ星/
みつまた /三椏/
みつまめ /蜜豆/
みつめ /三つ目/
みつもり /見積り/
みつやく /密約/
みつゆ /密輸/
みつゆしゅつ /密輸出/
みつゆにゅう /密輸入/
みつゆび /三つ指/
みつよ /光世/
みつりょう /密漁/密猟/
みつりん /密林/
みつろう /蜜蝋/
みつわ /三輪/
みづくろい /身繕い/
みてい /未定/
みていこう /未定稿/
みていねん /未丁年/
みてくれ /見て呉れ/
みと /水戸/
みとう /未踏/未到/
みとおし /見通し/
みとかいどう /水戸街道/
みとく /味得/
みとけ /水戸家/
みとこうもん /水戸黄門/
みところ /三所/
みとし /水戸市/
みとせ /三年/
みとみ /三富/
みとめ /認め/
みとめいん /認印/
みとりず /見取図/
みどう /御堂/
みどうすじ /御堂筋/
みどく /味読/未読/
みどころ /見所/
みども /身共/
みどり /翠/緑/
みどりご /嬰児/
みどりのとう /緑の党/
みな /皆/
みなかた /南方/
みなかみ /水上/
みながわ /皆川/
みなくち /水口/
みなげ /身投げ/
みなごろし /皆殺し/
みなさま /皆様/
みなせ /水無瀬/
みなづき /水無月/
みなと /港/湊/
みなとがわ /湊川/
みなとまち /港町/
みなのしゅう /皆の衆/
みなまた /水俣/
みなまたびょう /水俣病/
みなみ /南/
みなみあしがら /南足柄;地名,神奈川県西南部の市/
みなみかぜ /南風/
みなみしなかい /南支那海/
みなみたいへいよう /南太平洋/
みなみだいとうじま /南大東島/
みなみとりしま /南鳥島/
みなみはんきゅう /南半球/
みなみむき /南向き/
みなみむら /南村/
みなも /水面/
みなもと /源/
みなもとのよりとも /源頼朝/
みならい /見習い/
みなり /身形/
みなわ /水泡/
みね /嶺/美祢/峰/
みねうち /峰打ち/
みねざき /峰崎/
みの /蓑/美濃/
みのう /未納/
みのうえ /身の上/
みのお /箕面/
みのかも /美濃加茂/
みのかわ /身の皮/
みのがみ /美濃紙/
みのけ /身の毛/
みのげ /蓑毛/
みのしろ /身の代/
みのしろきん /身の代金/
みのばん /美濃判/
みのぶ /身延/
みのぶさん /身延山/
みのべ /美濃部/
みのほど /身の程/
みのほどしらず /身の程知らず/
みのぼん /美濃本/
みのまわり /身の回り/
みのむし /蓑虫/
みのり /実り/御法/
みのる /稔/
みはい /未配/
みはっぴょう /未発表/
みはつ /未発/
みはま /美浜/
みはら /三原/
みはらい /未払い/
みはらいかんじょう /未払勘定/
みはらし /見晴らし/
みはり /見張り/
みはる /三春/
みば /見端/
みばえ /見栄え/見映え/
みひつのこい /未必の故意;自分の行為からある事実が発生しても仕方がないと認めて行為する心理状態/
みひとつ /身一つ/
みひらき /見開き/
みびいき /身贔屓/
みふたつ /身二つ/
みぶ /壬生/
みぶり /身振り/
みぶるい /身震い/
みぶん /身分/
みぶんか /未分化/
みぶんそうおう /身分相応/
みへん /身偏/
みほじんじゃ /美保神社/
みほのせき /美保関/
みほん /見本/
みほんいち /見本市/
みほんずり /見本刷/
みぼうじん /未亡人/
みまい /見舞/
みまいじょう /見舞状/
みまき /御牧/
みまさか /美作/
みまちがい /見間違い/
みまな /任那/
みまね /見真似/
みまん /未満/
みみ /耳/
みみあか /耳垢/
みみうち /耳打ち/
みみかき /耳掻き/
みみかくし /耳隠し/
みみかざり /耳飾り/
みみがくもん /耳学問/
みみざわり /耳障り/
みみず /蚯蚓/
みみずく /木菟/角鴟/
みみたぶ /耳朶/
みみどしま /耳年増/
みみなり /耳鳴り/
みみぶくろ /耳袋/
みみへん /耳偏/
みみもと /耳許/耳元/
みみより /耳寄り/
みみわ /耳輪/
みめ /見目/
みめい /未明/
みもだえ /身悶え/
みもち /身持ち/
みもと /身元/
みもとほしょう /身元保証/
みもとほしょうきん /身元保証金/
みもの /見物/実物/
みもん /未聞/
みゃく /脈/
みゃくあつ /脈圧/
みゃくかん /脈管/
みゃくどう /脈動/
みゃくはく /脈拍/脈搏/
みゃくみゃく /脈脈/
みゃくらく /脈絡/
みゃくらくまく /脈絡膜/
みゃくりゅう /脈流/
みや /宮/
みやい /宮居/
みやがわ /宮川/
みやがわちょう /宮川町/
みやぎ /宮城/宮木/
みやぎけん /宮城県/
みやぎの /宮城野/
みやけ /三宅/宮家/
みやけじま /三宅島/
みやげ /土産/
みやげばなし /土産話/
みやげもの /土産物/
みやこ /都/宮古/
みやこいり /都入り/
みやこおち /都落ち/
みやこじ /都路/
みやこじま /宮古島/
みやこびと /都人/
みやさま /宮様/
みやざき /宮崎/
みやざきけん /宮崎県/
みやざきし /宮崎市/
みやざわ /宮沢/
みやざわけんじ /宮沢賢治/
みやじ /宮路/
みやじま /宮島/
みやたけ /宮武/
みやだいく /宮大工/
みやち /宮地/
みやづ /宮津/
みやづかえ /宮仕え/
みやでら /宮寺/
みやび /雅/
みやびと /宮人/
みやべ /宮部/
みやま /深山/
みやまいり /宮参り/
みやまえ /宮前/
みやもと /宮本/
みやもとむさし /宮本武蔵/
みやもり /宮守/
みゅー /μ/
みゆき /御幸/深雪/
みょう /名/明/命/妙/冥/
みょうあさ /明朝/
みょうあん /妙案/
みょうえ /明恵/
みょうおう /明王/
みょうおん /妙音/
みょうかい /冥界/
みょうが /茗荷/冥加/
みょうきょく /妙曲/
みょうぎ /妙技/
みょうぎさん /妙義山/
みょうぎしょう /名義抄/
みょうく /妙句/
みょうけい /妙計/
みょうこうじ /妙興寺/
みょうごう /名号/
みょうごにち /明後日/
みょうごねん /明後年/
みょうさく /妙策/
みょうしゅ /妙手/妙趣/
みょうしゅん /明春/
みょうしょ /妙所/
みょうじ /苗字/名字/
みょうじょう /明星/
みょうじん /明神/
みょうせき /名跡/
みょうせんじしょう /名詮自性/
みょうぜつ /妙絶/
みょうだい /名代/
みょうちょう /明朝/
みょうちん /明珍/
みょうにち /明日/
みょうねん /明年/
みょうは /妙葩/
みょうばん /明晩/明礬/
みょうほう /妙法/
みょうほうじ /妙法寺/
みょうみ /妙味/
みょうもく /名目/
みょうもん /名聞/
みょうもんりよう /名聞利養/
みょうや /明夜/
みょうやく /妙薬/
みょうよう /妙用/
みょうり /冥利/名利/
みょうれい /妙齢/
みよ /御代/
みよう /見様/
みようみまね /見様見真似/
みよし /三好/三善/三次/
みより /身寄り/
みらい /未来/味蕾/
みらいえいごう /未来永劫/
みらいがく /未来学/
みらいき /未来記/
みらいは /未来派/
みり /粍/
みりぐらむ /瓱/
みりめーとる /粍/
みりょう /未了/魅了/
みりょく /魅力/
みりょくてき /魅力的/
みりりっとる /竓/
みりん /味醂/
みるからに /見るからに/
みるめ /見る目/
みれん /未練/
みろく /弥勒/
みわ /神酒/三輪/
みわく /魅惑/
みわけ /見分け/
みわた /三輪田/
みわやま /三輪山/
みん /眠/民/明/
みんい /民意/
みんえい /民営/
みんか /民家/
みんかん /民間/
みんかんじん /民間人/
みんかんでんしょう /民間伝承/
みんかんりょうほう /民間療法/
みんぎょう /民業/
みんぐ /民具/
みんけん /民権/
みんげい /民芸/
みんげいひん /民芸品/
みんこく /民国/
みんしゃ /民社/
みんしゃとう /民社党/
みんしゅ /民主/
みんしゅう /民衆/
みんしゅか /民主化/
みんしゅく /民宿/
みんしゅこっか /民主国家/
みんしゅしゅぎ /民主主義/
みんしゅせいじ /民主政治/
みんしゅてき /民主的/
みんしゅとう /民主党/
みんしん /民心/
みんじ /民事/
みんじさいせい /民事再生/
みんじさいせいほう /民事再生法/
みんじさいばん /民事裁判/
みんじしっこう /民事執行/
みんじしっこうほう /民事執行法/
みんじせきにん /民事責任/
みんじそしょう /民事訴訟/
みんじそしょうほう /民事訴訟法/
みんじゅ /民需/
みんじょう /民情/
みんせい /民生/民政/民声/
みんせいいいん /民生委員/
みんせいぶ /民生部/
みんせん /民選/
みんそ /民訴/
みんぞく /民族/民俗/
みんぞくいしょう /民族衣装/
みんぞくおんがく /民族音楽/
みんぞくがく /民俗学/民族学/
みんぞくこっか /民族国家/
みんぞくしゅぎ /民族主義/
みんぞくじけつ /民族自決/
みんぞくせい /民族性/
みんちょう /明朝/
みんど /民度/
みんな /皆/
みんぱく /民泊/
みんぶ /民部/
みんぷう /民風/
みんぺい /民兵/
みんぼう /民望/
みんぽう /民放/民法/
みんぽんしゅぎ /民本主義/
みんゆう /民有/
みんよう /民謡/
みんりょく /民力/
みんわ /民話/
む /夢/無/霧/矛/務/武/六/謀/无/牟/
む> /無/
むい /無為/無意/無位/六/
むいか /六日/
むいしき /無意識/
むいしきてき /無意識的/
むいそん /無医村/
むいちもん /無一文/
むいとしょく /無為徒食/
むいみ /無意味/
むいん /無韻/
むえき /無益/
むえん /無縁/無煙/無鉛/無塩/無援/
むえんたん /無煙炭/
むおん /無音/
むかい /向井/向かい/
むかいかぜ /向い風/
むかえ /迎え/
むかえかく /迎え角/
むかえび /迎え火/
むかか /無花果/
むかご /零余子/
むかし /昔/
むかしつ /無過失/
むかしつせきにん /無過失責任/
むかしばなし /昔話/
むかしふう /昔風/
むかしむかし /昔々/昔昔/
むかで /蜈蚣/百足/
むかん /無冠/無官/
むかんかく /無感覚/
むかんがえ /無考え/
むかんけい /無関係/
むかんさ /無鑑査/
むかんしょう /無干渉/
むかんしん /無関心/
むが /無我/
むがい /無害/無蓋/
むがく /無学/
むがくめんかぶ /無額面株/
むがむちゅう /無我夢中/
むき /向き/無機/無期/無記/無季/
むきえんき /無期延期/
むきおん /無気音/
むきかがく /無機化学/
むきかごうぶつ /無機化合物/
むききんこ /無期禁錮/
むきげん /無期限/
むきしつ /無機質/
むきじょうでんしゃ /無軌条電車/
むきず /無傷/
むきちょうえき /無期懲役/
むきてき /無機的/
むきどう /無軌道/
むきはい /無気肺/
むきぶつ /無機物/
むきむき /向き向き/
むきめい /無記名/
むきめいかぶけん /無記名株券/
むきめいさいけん /無記名債権/
むきめいしき /無記名式/
むきめいとうひょう /無記名投票/
むきゅう /無休/無給/無窮/
むきょういく /無教育/
むきょく /無極/
むきょくせいぶんし /無極性分子/
むきりつ /無規律/
むきりょく /無気力/
むきん /無菌/
むぎ /麦/
むぎこ /麦粉/
むぎさく /麦作/
むぎちゃ /麦茶/
むぎばたけ /麦畑/
むぎぶえ /麦笛/
むぎめし /麦飯/
むぎゆ /麦湯/
むぎわら /麦藁/
むぎわらぼう /麦藁帽/
むく /椋/無垢/
むくげ /槿/毳/
むくち /無口/
むくどり /椋鳥/
むくみ /浮腫/
むくろ /躯/
むけい /無形/
むけつ /無欠/無血/
むけつかくめい /無血革命/
むけん /無間/
むけんじごく /無間地獄/
むけんだいり /無権代理/
むげ /無碍/無下/
むげい /無芸/
むげいたいしょく /無芸大食/
むげん /無限/夢幻/
むげんきどう /無限軌道/
むげんきゅうすう /無限級数/
むげんしゅうごう /無限集合/
むげんしょう /無限小/
むげんしょうすう /無限小数/
むげんすうれつ /無限数列/
むげんせきにん /無限責任/
むげんそく /無原則/
むげんだい /無限大/
むこ /婿/無辜/壻/聟/
むこいり /婿入り/
むこう /無効/向こう/向日/無功/
むこうじま /向島/
むこうずね /向う脛/
むこく /無告/
むことり /婿取り/
むこようし /婿養子/
むこようしえんぐみ /婿養子縁組/
むこん /無根/
むご /惨/
むごん /無言/
むごんか /無言歌/
むごんげき /無言劇/
むごんのぎょう /無言の行/
むさい /無才/
むさく /無策/
むさくい /無作為/
むさし /武蔵/
むさしの /武蔵野/
むさしのせん /武蔵野線/
むさしむらやま /武蔵村山/
むさつ /無札/
むさべつ /無差別/
むさん /無産/霧散/
むざい /無罪/
むざつ /無雑/
むざん /無惨/無残/
むし /無視/虫/無死/無私/蒸し/
むしかえし /蒸し返し/
むしかく /無資格/
むしき /蒸し器/
むしくだし /虫下し/
むしぐすり /虫薬/
むしけ /虫気/
むしけら /虫螻/
むしけん /無試験/
むしず /虫酸/虫唾/
むしとり /虫取り/
むしのいき /虫の息/
むしば /虫歯/
むしばら /虫腹/
むしふうじ /虫封じ/
むしぶろ /蒸し風呂/
むしへん /虫偏/
むしぼし /虫干し/
むしむしゅう /無始無終/
むしめがね /虫眼鏡/
むしもの /蒸し物/
むしゃ /武者/
むしゃく /無錫/
むしゃしゅぎょう /武者修行/
むしゃのこうじ /武者小路/
むしやき /蒸し焼き/
むしゅ /無主/
むしゅう /無臭/
むしゅく /無宿/
むしゅくもの /無宿者/
むしゅぶつ /無主物/
むしゅみ /無趣味/
むしょう /無償/無性/
むしょうこうい /無償行為/
むしょうこうふ /無償交付/
むしょく /無職/無色/
むしょぞく /無所属/
むしよけ /虫除け/
むしりょく /無資力/
むしろ /筵/蓆/莚/寧ろ/
むしん /無心/
むしんけい /無神経/
むしんろん /無神論/
むじ /無地/
むじかく /無自覚/
むじつ /無実/
むじな /貉/
むじひ /無慈悲/
むじゃき /無邪気/
むじゅう /無住/
むじゅうりょう /無重量/
むじゅうりょく /無重力/
むじゅん /矛盾/
むじょう /無常/無情/無上/
むじょうかん /無常観/
むじょうけん /無条件/
むじょうじんそく /無常迅速/
むじるし /無印/
むじん /無人/無尽/
むじんぞう /無尽蔵/
むじんとう /無人島/
むすい /無水/
むすいありゅうさん /無水亜硫酸/
むすう /無数/
むすこ /息子/
むすび /結び/
むすびつき /結び付き/
むすびとじ /結び綴じ/
むすびめ /結び目/
むすめ /娘/
むすめざかり /娘盛り/
むすめむこ /娘婿/
むせい /夢精/無声/無性/
むせいおん /無声音/
むせいか /無声化/
むせいげん /無制限/
むせいせいしょく /無性生殖/
むせいせだい /無性世代/
むせいふ /無政府/
むせいふしゅぎ /無政府主義/
むせいふしゅぎしゃ /無政府主義者/
むせいふじょうたい /無政府状態/
むせいぶつ /無生物/
むせいらん /無精卵/
むせき /無籍/
むせきにん /無責任/
むせっそう /無節操/
むせん /無線/無銭/
むせんつうしん /無線通信/
むせんでんしん /無線電信/
むせんでんわ /無線電話/
むせんとじ /無線綴じ/
むぜい /無税/無勢/
むぜいひん /無税品/
むそう /夢想/無双/無想/
むそじ /六十路/
むぞうさ /無造作/
むたい /無体/
むたいざいさんけん /無体財産権/
むたいぶつ /無体物/
むたんぽ /無担保/
むだ /無駄/徒/
むだあし /無駄足/
むだい /無題/無代/
むだがね /無駄金/
むだじに /無駄死に/
むだづかい /徒遣い/無駄遣い/
むだばなし /無駄話/
むだぼね /無駄骨/
むだん /無断/
むち /無知/鞭/笞/無恥/
むちく /無畜/
むちゃ /無茶/
むちゃくちゃ /無茶苦茶/
むちゃくりく /無着陸/
むちゅう /夢中/霧中/
むちん /無賃/
むっつ /六つ/
むつ /睦/陸奥/六つ/
むつう /無痛/
むつうぶんべん /無痛分娩/
むつき /睦月/
むつごと /睦言/
むつれじま /六連島/
むつわん /陸奥湾/
むて /無手/
むていけい /無定形/無定型/
むていこう /無抵抗/
むてかつりゅう /無手勝流/
むてき /無敵/霧笛/
むてっぽう /無鉄砲/
むてんか /無添加/
むてんぼん /無点本/
むでん /無電/
むとう /武藤/無糖/
むとうは /無党派/
むとうひょう /無投票/
むとく /無徳/
むとどけ /無届け/
むとんちゃく /無頓着/
むどう /無道/
むどく /無毒/
むな /胸/棟/
むないた /胸板/
むなかた /宗像/棟方/
むなぎ /棟木/
むなくそ /胸糞/
むなぐら /胸倉/
むなげ /胸毛/
むなさき /胸先/
むなさわぎ /胸騒ぎ/
むなざんよう /胸算用/
むなだか /胸高/
むなびれ /胸鰭/
むなもと /胸元/
むに /無二/
むにむさん /無二無三/
むね /旨/胸/棟/宗/
むねあげ /棟上げ/
むねうち /刀背打ち/
むねがわら /棟瓦/
むねくそ /胸糞/
むねざんよう /胸算用/
むねまち /棟区/
むねん /無念/
むねんむそう /無念無想/
むのう /無能/
むのうりょく /無能力/
むのうりょくしゃ /無能力者/
むは /無派/
むはい /無配/
むはんどうほう /無反動砲/
むひ /無比/
むひつ /無筆/
むひょう /霧氷/
むひょうじょう /無表情/
むびゅう /無謬/
むびょう /無病/
むびょうそくさい /無病息災/
むふう /無風/
むふんべつ /無分別/
むへん /無辺/
むほう /無法/
むほうもの /無法者/
むほん /謀反/謀叛/
むぼう /無謀/無帽/
むぼうび /無防備/
むま /夢魔/
むみ /無味/
むみかんそう /無味乾燥/
むみょう /無明/
むみょうじょうや /無明長夜/
むむじゅんせい /無矛盾性/
むめい /無名/無銘/
むめいすう /無名数/
むめんきょ /無免許/
むもん /無文/無紋/
むやく /無役/無益/
むやま /無山/
むやみ /無闇/
むゆうびょう /夢遊病/
むよう /無用/
むよく /無欲/無慾/
むら /群/村/叢/斑/
むらい /村井/
むらおか /村岡/
むらかた /村方/
むらかみ /村上/
むらくも /叢雲/
むらさき /紫/
むらさきしきぶ /紫式部/
むらさきの /紫野/
むらさめ /叢雨/村雨/
むらざと /村里/
むらじ /連/
むらすずめ /群雀/
むらせ /村瀬/
むらた /村田/
むらはちぶ /村八分/
むらびと /村人/
むらまさ /村正/
むらやくにん /村役人/
むらやくば /村役場/
むらやま /村山/
むり /無理/
むりおうじょう /無理圧状/
むりおし /無理押し/
むりかい /無理解/
むりからぬ /無理からぬ/
むりさんだん /無理算段/
むりし /無利子/
むりしんじゅう /無理心中/
むりじい /無理強い/
むりすう /無理数/
むりそく /無利息/
むりなんだい /無理難題/
むりむたい /無理無体/
むりやり /無理矢理/
むりょ /無慮/
むりょう /無料/無量/無聊/
むりょうじゅ /無量寿/
むりょうたいすう /無量大数/
むりょく /無力/
むりょくかん /無力感/
むるい /無類/
むれ /群れ/群/
むろ /室/榁/
むろう /室生/
むろうさいせい /室生犀星/
むろつ /室津/
むろと /室戸/
むろまち /室町/
むろまちじだい /室町時代/
むろまちばくふ /室町幕府/
むろや /室屋/
むろらん /室蘭/
むろん /無論/
め /目/女/芽/雌/眼/奴/
めあき /目明き/
めあて /目当て/
めい /名/明/命/迷/姪/鳴/銘/盟/冥/茗/
めい> /名/
めいあん /名案/明暗/
めいい /名医/
めいうん /命運/
めいえん /名演/
めいおう /明応/
めいおうせい /冥王星/
めいか /名家/銘菓/名歌/名花/名菓/
めいかい /明解/明快/冥界/
めいかく /明確/
めいかん /名鑑/銘肝/
めいが /名画/
めいがら /銘柄/
めいき /明記/名器/銘記/
めいきゅう /迷宮/
めいきゅういり /迷宮入り/
めいきょう /明鏡/
めいきょうしすい /明鏡止水/
めいきょく /名曲/名局/
めいぎ /名義/名妓/
めいぎにん /名義人/
めいぎん /名吟/
めいく /名句/
めいくん /名君/明君/
めいけん /名剣/
めいげつ /明月/名月/
めいげつき /明月記/
めいげん /名言/明言/鳴弦/
めいこう /名工/名香/
めいさい /明細/迷彩/
めいさいしょ /明細書/
めいさく /名作/
めいさつ /名刹/明察/
めいさん /名産/
めいざん /名山/
めいし /名詞/名刺/名士/明視/
めいしく /名詞句/
めいしせつ /名詞節/
めいしばん /名刺判/
めいしゃ /眼医者/鳴謝/
めいしゅ /名手/盟主/銘酒/名酒/名主/明主/
めいしょ /名所/
めいしょう /名称/名勝/名将/名匠/明証/名相/
めいしょく /明色/
めいしょずえ /名所図会/
めいしん /迷信/名神/
めいしんか /迷信家/
めいじ /明示/明治/名辞/
めいじいしん /明治維新/
めいじじんぐう /明治神宮/
めいじだいがく /明治大学/
めいじつ /名実/
めいじむら /明治村/
めいじゅんのう /明順応/
めいじょう /名城/名状/
めいじん /名人/
めいじんげい /名人芸/
めいすい /名水/
めいすう /命数/名数/
めいすうほう /命数法/
めいせい /名声/
めいせき /明晰/
めいせつ /名節/
めいそう /冥想/瞑想/迷走/名僧/
めいそうしんけい /迷走神経/
めいぞく /名族/
めいた /目板/
めいたつ /明達/
めいだい /命題/
めいだいろんり /命題論理/
めいだん /明断/
めいち /明知/
めいちゃ /銘茶/
めいちゅう /命中/
めいちょ /名著/
めいちょう /明徴/明澄/
めいっぱい /目一杯/
めいてい /酩酊/
めいてつ /明哲/
めいてん /名店/
めいとう /名答/名刀/明答/銘刀/
めいとく /明徳/
めいど /明度/冥土/冥途/
めいどう /鳴動/
めいにち /命日/
めいはく /明白/
めいば /名馬/
めいばん /名盤/
めいひつ /名筆/
めいひん /名品/
めいび /明媚/
めいびゅう /迷謬/
めいびん /明敏/
めいふ /冥府/
めいふく /冥福/
めいぶつ /名物/
めいぶつおとこ /名物男/
めいぶん /名分/名文/明文/銘文/名聞/
めいぶんか /明文化/
めいほう /盟邦/名宝/名峰/
めいぼ /名簿/
めいぼう /明眸/名望/
めいぼうこうし /明眸皓歯/
めいぼく /銘木/名木/
めいみゃく /命脈/
めいむ /迷夢/
めいめい /命名/銘々/
めいめいはくはく /明々白々/明明白白/
めいめつ /明滅/
めいもう /迷妄/
めいもく /名目/瞑目/
めいもん /名門/
めいやく /名訳/盟約/名薬/
めいゆう /盟友/名優/
めいよ /名誉/
めいよきそんざい /名誉毀損罪/
めいよきょうじゅ /名誉教授/
めいよしょく /名誉職/
めいり /名利/
めいりゅう /名流/
めいりょう /明瞭/
めいりんかん /明倫館/
めいりんどう /明倫堂/
めいれい /命令/
めいれいけい /命令形/
めいれいぶん /命令文/
めいれいほう /命令法/
めいれき /明暦/
めいろ /迷路/目色/
めいろう /明朗/
めいろん /名論/
めいわ /明和/
めいわく /迷惑/
めうえ /目上/
めうし /牝牛/
めうち /目打/
めうつり /目移り/
めおと /夫婦/
めかくし /目隠し/
めかけ /妾/
めかけばら /妾腹/
めかた /目方/
めかど /目角/
めがお /目顔/
めがしら /目頭/
めがね /眼鏡/
めがねちがい /眼鏡違い/
めがねばし /眼鏡橋/
めがみ /女神/
めきき /目利き/
めきしこ /墨西哥/
めぎれ /目切れ/
めくぎ /目釘/
めくされ /目腐れ/
めくばり /目配り/
めくら /盲/
めくらばん /盲判/
めくらめっぽう /盲滅法/
めくるめく /目眩く/
めぐすり /目薬/
めぐろ /目黒/
めこぼし /目溢し/
めさき /目先/
めざし /目刺し/
めざと /目敏/
めざまし /目覚し/
めざましどけい /目覚し時計/
めざめ /目覚め/
めざわり /目障り/
めし /飯/
めしい /盲/
めした /目下/
めしたき /飯炊き/
めしつかい /召使/
めしつぶ /飯粒/
めしびつ /飯櫃/
めしべ /雌蕊/
めしもの /召し物/
めしもり /飯盛り/
めしや /飯屋/
めじ /目地/
めじか /牝鹿/
めじり /目尻/
めじるし /目印/
めじろ /目白/
めじろおし /目白押し/
めす /牝/雌/♀/
めず /馬頭/
めせん /目線/
めだつ /目立つ/
めだま /目玉/
めだまやき /目玉焼/
めちがい /目違い/
めっき /鍍金/滅金/
めっきゃく /滅却/
めっきん /滅菌/
めっし /滅私/
めっしつ /滅失/
めっそう /滅相/
めった /滅多/
めったうち /滅多打ち/
めったに /滅多に/
めったやたら /滅多矢鱈/
めっぽう /滅法/
めつ /滅/
めつけ /目付/
めつご /滅後/滅期/
めつざい /滅罪/
めつじん /滅尽/
めつぼう /滅亡/
めつれつ /滅裂/
めて /右手/
めで /愛で/
めど /目処/目途/
めどおり /目通り/
めなみ /女波/
めぬき /目抜き/目貫/
めぬきどおり /目抜き通り/
めのう /瑪瑙/
めのと /乳母/
めのまえ /目の前/
めはし /目端/
めはちぶ /目八分/
めはな /目鼻/
めはなだち /目鼻立ち/
めばえ /芽生え/
めばな /雌花/
めぶんりょう /目分量/
めへん /目偏/
めべり /目減り/
めぼし /目星/
めまい /眩暈/
めみえ /目見え/
めもと /目許/
めもり /目盛/
めやす /目安/
めやすばこ /目安箱/
めやに /目脂/
めりはり /減り張り/乙張/
めろう /女郎/
めん /面/麺/綿/免/緬/棉/
めんえき /免疫/免役/
めんえきたい /免疫体/
めんおりもの /綿織物/
めんか /綿花/棉花/
めんかい /面会/
めんかやく /綿火薬/
めんかん /免官/
めんきつ /面詰/
めんきょ /免許/
めんきょかいでん /免許皆伝/
めんきょしょう /免許証/
めんきょじょう /免許状/
めんくい /面食い/
めんこ /面子/
めんざい /免罪/
めんざいふ /免罪符/
めんし /綿糸/
めんしき /面識/
めんしょく /免職/
めんじゅう /面従/
めんじゅうふくはい /面従腹背/
めんじょ /免除/
めんじょう /免状/面上/
めんせき /面積/免責/
めんせつ /面接/
めんぜい /免税/
めんぜいてん /免税店/免税点/
めんぜん /面前/
めんそ /免租/免訴/
めんそう /面相/
めんたいこ /明太子/
めんだん /面談/
めんちょう /面疔/
めんつ /面子/
めんてい /免停/面体/
めんでん /免田/
めんとおし /面通し/
めんとり /面取り/
めんどう /面倒/
めんどうみ /面倒見/
めんどり /雌鳥/
めんば /面罵/
めんぴ /面皮/
めんぶ /面部/
めんぷ /綿布/
めんぼう /綿棒/麺棒/面貌/綿紡/
めんぼく /面目/
めんぼくやくじょ /面目躍如/
めんぽお /面頬/
めんみつ /綿密/
めんめん /面々/綿々/面面/
めんもく /面目/
めんよう /綿羊/面妖/緬羊/面容/
めんるい /麺類/
も /茂/模/喪/藻/裳/面/摸/
もう /蒙/耗/網/盲/猛/毛/孟/妄/亡/望/申/
もうあ /盲唖/
もうあい /盲愛/
もうあく /猛悪/
もうい /猛威/
もうう /猛雨/
もうか /猛火/
もうかん /毛管/
もうかんじゅうそう /盲管銃創/
もうがっこう /盲学校/
もうき /盲亀/
もうきのふぼく /盲亀の浮木/
もうきん /猛禽/
もうきんるい /猛禽類/
もうけぐち /儲け口/
もうけもの /儲け物/
もうけやく /儲け役/
もうけん /猛犬/
もうげん /妄言/
もうこ /蒙古/猛虎/
もうこはん /蒙古斑/
もうこん /毛根/
もうさいかん /毛細管/
もうさいけっかん /毛細血管/
もうし /孟子/
もうしあわせ /申合せ/
もうしいれ /申入れ/
もうしこみしょ /申込書/
もうしご /申し子/
もうしたて /申立て/
もうしで /申し出/
もうしひらき /申し開き/
もうしぶん /申し分/
もうしゃ /盲者/猛射/
もうしゅう /妄執/猛襲/
もうしょ /猛暑/
もうしょう /猛将/
もうしわけ /申し訳/
もうしわけない /申し訳ない/
もうしん /盲信/猛進/盲進/妄信/
もうじゃ /亡者/
もうじゅう /猛獣/盲従/
もうじょう /網状/
もうじょうみゃく /網状脈/
もうじん /盲人/
もうせい /猛省/
もうせつ /妄説/
もうせん /毛氈/
もうぜん /猛然/
もうそう /妄想/
もうそうちく /孟宗竹/
もうたくとう /毛沢東/
もうだ /猛打/
もうだん /妄断/
もうちょう /盲腸/猛鳥/
もうちょうえん /盲腸炎/
もうてん /盲点/
もうとう /毛頭/
もうどう /艨艟/妄動/
もうどうけん /盲導犬/
もうどく /猛毒/
もうねん /妄念/
もうのう /毛嚢/
もうはつ /毛髪/
もうばく /猛爆/盲爆/
もうひつ /毛筆/
もうひょう /妄評/
もうふ /毛布/
もうほう /毛包/
もうぼ /孟母/
もうまい /蒙昧/濛昧/
もうまく /網膜/
もうまくはくり /網膜剥離/
もうもう /濛々/濛濛/
もうもく /盲目/
もうもくてき /盲目的/
もうゆう /猛勇/
もうようたい /毛様体/
もうら /網羅/
もうり /毛利/
もうりてるもと /毛利輝元/
もうりもとなり /毛利元就/
もうりょう /魍魎/
もうれつ /猛烈/
もうろう /朦朧/
もうろく /耄碌/
もえ /燃え/
もえぎ /萌葱/萌黄/萌え木/
もえぎいろ /萌黄色/
もおか /真岡/
もがさ /痘瘡/
もがみ /最上/
もがみがわ /最上川/
もぎ /模擬/摸擬/
もぎしけん /模擬試験/
もぎてん /模擬店/
もぎどう /没義道/
もく /目/木/杢/黙/
もくあみ /木阿弥/黙阿弥/
もくぎょ /木魚/
もくぐう /木偶/
もくげき /目撃/黙劇/
もくさく /木柵/
もくさつ /黙殺/
もくさん /目算/
もくざい /木材/
もくし /目視/黙視/黙示/黙止/
もくしつ /木質/
もくしろく /黙示録/
もくじ /目次/
もくず /藻屑/
もくせい /木星/木製/木犀/木精/
もくぜん /目前/黙然/
もくそう /黙想/目送/
もくそく /目測/
もくぞう /木造/木像/
もくたん /木炭/
もくだく /黙諾/
もくちょう /木彫/
もくてき /目的/
もくてきいしき /目的意識/
もくてきかく /目的格/
もくてきご /目的語/
もくてきぜい /目的税/
もくてきち /目的地/
もくてきぶつ /目的物/
もくてきろん /目的論/
もくと /目途/目睹/
もくとう /黙祷/
もくどく /黙読/
もくにん /黙認/
もくねん /黙念/
もくはん /木版/
もくはんが /木版画/
もくば /木馬/
もくひ /黙秘/木皮/
もくひけん /黙秘権/
もくひょう /目標/
もくぶ /木部/
もくへん /木片/
もくほん /木本/
もくめ /木目/
もくもく /黙々/
もくよう /木曜/
もくようび /木曜日/
もくよく /沐浴/
もくらん /木蘭/
もくれい /黙礼/目礼/
もくれん /木蓮/
もくろく /目録/
もくろみ /目論見/
もくろみしょ /目論見書/
もぐさ /藻草/
もぐら /土竜/
もけい /模型/
もこ /模糊/糢糊/
もこく /模刻/
もこくぼん /模刻本/
もさ /猛者/
もさく /模索/模作/摸索/
もし /模試/若し/
もしか /若しか/
もしき /模式/
もしくは /若しくは/
もしも /若しも/
もしゃ /模写/摸写/
もしゅ /喪主/
もしょう /喪章/
もじ /文字/門司/綟/
もじづら /文字面/
もじどおり /文字通り/
もじばん /文字盤/
もじほうそう /文字放送/
もじれつ /文字列/
もすそ /裳裾/
もず /百舌/鵙/
もずめ /物集/
もぞう /模造/摸造/
もぞうし /模造紙/
もだえ /悶え/
もち /餅/持ち/望/糯/黐/勿/
もちあい /持合/
もちあじ /持ち味/
もちあみ /餅網/
もちあわせ /持合せ/
もちい /用い/
もちいえ /持ち家/
もちうた /持ち歌/
もちかた /持ち方/
もちかぶ /持株/
もちがし /餅菓子/
もちぐされ /持腐れ/
もちごま /持駒/
もちごめ /糯米/
もちじかん /持ち時間/
もちずき /望月/
もちだい /餅代/
もちづき /望月/
もちてん /持ち点/
もちにげ /持逃げ/
もちぬし /持主/
もちはだ /餅肌/餅膚/
もちばん /持番/
もちぶん /持ち分/
もちまえ /持ち前/
もちまる /持丸/
もちもの /持ち物/
もちや /餅屋/
もちゅう /喪中/
もちろん /勿論/
もっか /目下/黙過/
もっかく /木槨/
もっかつじばん /木活字版/
もっかん /木管/木簡/
もっかんがっき /木管楽器/
もっきょ /黙許/
もっきん /木琴/
もっけ /勿怪/
もっけい /黙契/
もっこう /木工/黙考/木瓜/
もっこつ /木骨/
もっこん /目今/
もったい /勿体/
もったいない /勿体無い/
もって /以て/
もってこい /持って来い/
もってのほか /以ての外/
もっとも /最も/尤も/
もっぱら /専ら/
もつ /物/
もつやく /没薬/
もつれ /縺れ/
もと /下/本/基/許/元/
もと> /元/
もとい /基/
もといれ /元入れ/
もとうり /元売り/
もとおり /本居/
もとがしわ /本柏/
もとき /本木/
もときん /元金/
もとこ /元子/
もとごえ /基肥/
もとしげ /元重/
もとじめ /元締/
もとすえ /本末/
もとすこ /本栖湖/
もとせん /元栓/
もとだ /元田/
もとだか /元高/
もとちょう /元帳/
もとで /元手/
もとどおり /元通り/
もとどり /髻/
もとね /元値/
もとのぶ /元信/
もとはこね /元箱根/
もとみや /本宮/
もとむら /本村/
もとめ /求め/
もともと /元々/
もとやま /本山/
もとゆい /元結/
もどき /擬き/
もどり /戻り/
もどりてがた /戻手形/
もなか /最中/
もぬけ /蛻/
もの /物/者/
ものあらそい /物争い/
ものあんじ /物案じ/
ものいい /物言い/
ものいり /物入り/
ものう /物憂/
ものうい /物憂い/懶い/
ものうち /物打/
ものうらやみ /物羨み/
ものうり /物売り/
ものおき /物置/
ものおしみ /物惜しみ/
ものおじ /物怖じ/
ものおと /物音/
ものおぼえ /物覚え/
ものおもい /物思い/
ものかき /物書き/
ものかげ /物陰/物影/
ものかず /物数/
ものがたり /物語/
ものぎわ /物際/
ものぐさ /懶/
ものぐるい /物狂い/
ものごい /物乞い/
ものごころ /物心/
ものごし /物腰/物越し/
ものごと /物事/
ものさし /物差し/物指し/
ものしずか /物静か/
ものしらず /物知らず/
ものしり /物知り/
ものしりがお /物知り顔/
ものじたい /物自体/
ものずき /物好き/
ものたりない /物足りない/
ものだね /物種/
ものづくし /物尽し/
ものとり /物取り/
ものども /者共/
ものねたみ /物妬み/
もののあわれ /物の哀れ/
もののけ /物の怪/
もののふ /武士/
もののべ /物部/
もののほん /物の本/
ものはじめ /物始め/
ものび /物日/
ものほし /物干し/
ものまえ /物前/
ものまね /物真似/
ものみ /物見/
ものみやぐら /物見櫓/
ものみゆさん /物見遊山/
ものもち /物持/
ものもらい /物貰い/
ものわかり /物分り/
ものわかれ /物別れ/
ものわすれ /物忘れ/
ものわらい /物笑い/
もはや /最早/
もはん /模範/
もばら /茂原/
もふく /喪服/
もほう /模倣/
もみ /籾/樅/
もみがら /籾殻/
もみごめ /籾米/
もみじ /紅葉/
もみじのが /紅葉賀/
もみすり /籾摺り/
もみだね /籾種/
もみぬか /籾糠/
もめ /揉め/
もめごと /揉め事/
もめん /木綿/
もめんどうふ /木綿豆腐/
もめんばり /木綿針/
もも /桃/百/股/
ももいろ /桃色/
ももえ /百枝/
ももき /百木/
ももぞの /桃園/
ももたろう /桃太郎/
ももひき /股引/
ももやま /桃山/
ももよ /百代/
ももわれ /桃割れ/
もや /母屋/靄/
もやし /萌やし/
もよう /模様/
もようがえ /模様替え/
もよおし /催し/
もよおしもの /催し物/
もより /最寄り/
もらいご /貰い子/
もらいなき /貰い泣き/
もらいび /貰い火/
もらいもの /貰い物/
もらいゆ /貰い湯/
もり /森/杜/銛/守/盛/
もりあわせ /盛合せ/
もりおうがい /森鴎外/
もりおか /盛岡/
もりおかし /盛岡市/
もりかわ /森川/
もりき /守木/
もりきり /盛切り/
もりぐち /守口/
もりしたがみ /森下紙/
もりしま /森島/
もりそば /盛蕎麦/
もりた /森田/守田/
もりだくさん /盛り沢山/
もりつち /盛り土/
もりばな /盛花/
もりべ /守部/
もりもと /森本/
もりや /守屋/
もりやく /守役/
もりやま /守山/
もれ /洩れ/漏れ/
もろ /諸/
もろくち /諸口/
もろこ /諸子/
もろこし /蜀黍/
もろごえ /諸声/
もろて /諸手/
もろとも /諸共/
もろはし /諸橋/
もろはだ /諸肌/
もろひざ /諸膝/
もろびと /諸人/
もろみ /醪/諸味/
もろもろ /諸/諸々/
もろや /諸矢/
もん /問/文/門/紋/悶/聞/
もんえい /門衛/
もんおり /紋織/
もんか /門下/
もんかせい /門下生/
もんがい /門外/
もんがいかん /門外漢/
もんがいふしゅつ /門外不出/
もんがまえ /門構え/
もんきりがた /紋切型/
もんく /文句/
もんくなし /文句無し/
もんげん /門限/
もんこ /門戸/
もんこかいほう /門戸開放/
もんごん /文言/
もんさつ /門札/
もんざい /問罪/
もんし /悶死/門歯/
もんしょう /紋章/
もんしょうがく /紋章学/
もんしろちょう /紋白蝶/
もんしん /問診/
もんじ /文字/
もんじゅ /文殊/
もんじょ /文書/
もんじょぶくろ /文書袋/
もんじん /門人/問訊/
もんせい /門生/
もんせき /問責/
もんせん /門扇/
もんぜき /門跡/
もんぜつ /悶絶/
もんぜん /門前/文選/
もんぜんちょう /門前町/
もんぜんばらい /門前払い/
もんぜんまち /門前町/
もんだい /問題/
もんだいいしき /問題意識/
もんだいがい /問題外/
もんだいじ /問題児/
もんだいてん /問題点/
もんち /門地/
もんちゃく /悶着/
もんちゅう /門柱/
もんちゅうじょ /問注所/
もんちょう /紋帳/
もんつき /紋付/
もんてい /門弟/
もんていし /門弟子/
もんと /門徒/
もんとう /門灯/
もんど /主水/
もんどう /問答/
もんどうむよう /問答無用/
もんどころ /紋所/
もんない /門内/
もんなし /文無し/
もんはぶたえ /紋羽二重/
もんばつ /門閥/
もんばん /門番/
もんび /紋日/
もんぴ /門扉/
もんぴょう /門標/
もんぶ /文部/
もんぶしょう /文部省;2001年1月の中央省庁再編で文部科学省に再編された/
もんぶだいじん /文部大臣/
もんぷく /紋服/
もんべつ /紋別/
もんみゃく /門脈/
もんめ /匁/
もんもう /文盲/
もんもん /悶々/
もんよう /文様/紋様/
もんりゅう /門柳/
や /屋/家/夜/矢/↓/←/→/↑/弥/野/冶/八/谷/耶/爺/也/
やいごめ /焼米/
やいた /矢板/
やいづ /焼津/
やいと /灸/
やいば /刃/
やいん /夜陰/
やうち /家内/
やえ /八重/
やえい /野営/夜営/
やえがき /八重垣/
やえざくら /八重桜/
やえば /八重歯/
やえやま /八重山/
やえん /野猿/夜宴/
やお /八尾/八百/
やおちょう /八百長/
やおもて /矢面/
やおや /八百屋/
やおよろず /八百万/
やかい /夜会/
やかいふく /夜会服/
やかず /矢数/家数/
やかた /館/屋形/
やかたぶね /屋形船/
やかたまち /屋形町/
やから /族/
やかん /夜間/
やがい /野外/
やがいげき /野外劇/
やがく /夜学/
やがっこう /夜学校/
やがて /軈て/
やき /夜気/焼き/
やきいも /焼芋/
やきいれ /焼入れ/
やきいん /焼印/
やきえ /焼絵/
やきぐし /焼串/
やきざかな /焼魚/
やきつけ /焼付/
やきとり /焼鳥/焼き鳥/
やきどうふ /焼豆腐/
やきなおし /焼直し/
やきなまし /焼鈍し/
やきにく /焼肉/
やきはまぐり /焼蛤/
やきば /焼場/
やきふ /焼麩/
やきぶた /焼豚/
やきまし /焼増し/
やきみょうばん /焼明礬/
やきめし /焼飯/
やきもの /焼物/
やきゅう /野球/
やきょく /夜曲/
やきりんご /焼林檎/
やきん /夜勤/冶金/野禽/
やぎ /八木/柳/山羊/
やぎざ /山羊座/
やぎゅう /柳生/野牛/
やぎょう /夜業/ヤ行/夜行/
やぎり /矢切/
やく /約/役/訳/薬/躍/厄/益/籥/葯/疫/
やく> /約/
やくいん /役員/役印/
やくえき /薬液/
やくおとし /厄落し/
やくおん /約音/
やくかい /訳解/
やくがい /薬害/
やくがえ /役替え/
やくがく /薬学/
やくがら /役柄/
やくぎ /役儀/
やくぎょう /訳業/
やくげん /約言/
やくご /訳語/
やくさい /厄災/訳載/
やくさつ /薬殺/扼殺/
やくざい /薬剤/
やくざいし /薬剤師/
やくし /訳詞/訳詩/薬師/
やくしじ /薬師寺/
やくしどう /薬師堂/
やくしにょらい /薬師如来/
やくしま /屋久島/
やくしゃ /訳者/役者/
やくしゃえ /役者絵/
やくしゅ /薬酒/薬種/
やくしゅしょう /薬種商/
やくしゅつ /訳出/
やくしょ /役所/訳書/
やくしょく /役職/
やくしん /躍進/薬疹/
やくじ /薬餌/
やくじほう /薬事法/
やくじゅつ /訳述/
やくじょ /躍如/
やくじょう /約定/
やくじょうしょ /約定書/
やくじょうりそく /約定利息/
やくじょうりりつ /約定利率/
やくじん /厄神/疫神/
やくすう /約数/
やくすぎ /屋久杉/
やくせき /薬石/
やくそう /薬草/
やくそく /約束/
やくそくごと /約束事/
やくそくてがた /約束手形/
やくたい /益体/
やくだい /薬代/
やくだく /約諾/
やくちゅう /訳注/訳註/
やくづき /役付/
やくて /約手/
やくてん /薬店/
やくとう /薬湯/
やくとく /役得/
やくどう /躍動/
やくどく /訳読/薬毒/
やくどころ /役所/
やくどし /厄年/
やくなん /厄難/
やくにん /役人/
やくば /役場/
やくひん /薬品/
やくび /厄日/
やくびょう /疫病/
やくびょうがみ /疫病神/
やくぶそく /役不足/
やくぶつ /薬物/
やくぶん /約分/訳文/
やくほう /薬包/薬方/
やくほうし /薬包紙/
やくほん /訳本/
やくまわり /役回り/
やくみ /薬味/
やくむき /役向き/
やくめ /役目/
やくめい /役名/
やくも /八雲/
やくよう /薬用/
やくよけ /厄除け/
やくり /薬理/
やくりがく /薬理学/
やくりきし /役力士/
やくりょう /薬料/
やくろう /薬籠/
やくろん /約論/
やくわり /役割/
やぐ /夜具/
やぐち /矢口/
やぐちのわたし /矢口渡/
やぐら /櫓/矢倉/
やぐらなげ /櫓投げ/
やぐるま /矢車/
やけ /自棄/焼け/
やけあと /焼け跡/
やけい /夜景/夜警/野鶏/
やけいし /焼け石/
やけこげ /焼け焦げ/
やけだけ /焼岳/
やけだされ /焼け出され/
やけど /火傷/
やけの /焼野/
やけのはら /焼野原/
やけひばし /焼け火箸/
やけぶとり /焼け太り/
やけぼっくい /焼け棒杭/
やけやま /焼山/焼け山/
やけん /野犬/
やげんぼり /薬研堀/
やこう /夜行/夜光/
やこうせい /夜行性/
やこうちゅう /夜光虫/
やこうれっしゃ /夜行列車/
やこぜん /野狐禅/
やごう /屋号/野合/
やさい /野菜/
やさおとこ /優男/
やさか /八尺/弥栄/
やさかじんじゃ /八坂神社/
やさかりゅう /屋坂流/八坂流/
やさがた /優形/
やさき /矢先/
やし /椰子/香具師/野史/
やしお /八潮/八入/
やしき /邸/屋敷/
やしきまち /屋敷町/
やしま /屋島/
やしゃ /夜叉/
やしゃご /玄孫/
やしゅ /野趣/野手/
やしゅう /夜襲/
やしょく /夜食/夜色/
やしろ /社/矢代/屋代/
やしわご /玄孫/
やしん /野心/
やしんか /野心家/
やじ /野次/
やじうま /野次馬/弥次馬/
やじきた /弥次喜多/
やじま /矢島/
やじゅう /野獣/
やじり /鏃/
やじるし /矢印/↑/↓/→/←/⇒/⇔/
やじろべえ /弥次郎兵衛/
やじん /野人/
やす /安/
やすい /安井/保井/靖/
やすうけあい /安請合い/
やすうり /安売り/
やすかた /安方/
やすぎ /安来/八杉/
やすくに /安国/
やすくにじんじゃ /靖国神社/
やすけ /弥助/
やすだ /安田/保田/
やすで /安手/
やすね /安値/
やすはら /安原/
やすぶしん /安普請/
やすみ /休み/
やすもの /安物/
やすやす /易々/
やすやど /安宿/
やすよ /安代/
やすよし /安吉/
やすら /安ら/
やすらか /安らか/
やすり /鑢/
やせ /八瀬/
やせい /野生/野性/
やせいてき /野性的/
やせいみ /野性味/
やせうで /痩せ腕/
やせがた /痩せ形/
やせがまん /痩せ我慢/
やせぎす /痩せぎす/
やせち /痩せ地/
やせっぽち /痩せっぽち/
やせん /夜戦/野戦/野選/
やぜん /夜前/
やそ /八十/耶蘇/
やそう /野草/
やそうきょく /夜想曲/
やそかい /耶蘇会/
やそかわ /八十川/
やそきょう /耶蘇教/
やそしま /八十島/
やそじ /八十路/
やそよろず /八十万/
やた /八咫/
やたい /屋台/
やたいぼね /屋台骨/
やたがらす /八咫烏/
やたて /矢立/
やたのかがみ /八咫鏡/
やたべ /矢田部/
やだね /矢種/
やち /谷地/屋地/
やちだ /谷地田/
やちまた /八衢/
やちゅう /夜中/
やちょう /野鳥/野帳/
やちよ /八千代/
やちん /家賃/
やっか /薬価/薬禍/
やっかい /厄介/訳解/
やっかいもの /厄介者/
やっかん /約款/
やっき /躍起/
やっきょう /薬莢/
やっきょく /薬局/
やっきょくほう /薬局方/
やっこ /奴/
やっこう /薬効/
やっつ /八つ/
やっとこ /鋏/
やつ /奴/谷/八つ/
やつあたり /八つ当り/
やつか /八束/
やつかほ /八束穂/
やつがたけ /八ヶ岳/
やつぎばや /矢継ぎ早/
やつくち /八口/
やつざき /八つ裂き/
やつしろ /八代/
やつで /八手/
やつはし /八橋/
やつめうなぎ /八目鰻/
やつら /奴等/
やと /野兎/
やといぬし /雇い主/
やとう /野党/野盗/夜盗/
やど /宿/
やどいり /宿入り/
やどかり /宿借り/
やどがえ /宿替え/
やどさがり /宿下がり/
やどせん /宿銭/
やどちょう /宿帳/
やどちん /宿賃/
やどなし /宿無し/
やどぬし /宿主/
やどひき /宿引き/
やどや /宿屋/
やどろく /宿六/
やどわり /宿割り/
やな /梁/簗/
やない /柳井/屋内/箭内/
やないはら /矢内原/
やなか /谷中/
やながわ /柳川/梁川/
やなぎ /柳/
やなぎいろ /柳色/
やなぎごし /柳腰/
やなぎさわ /柳沢/
やなぎた /柳田/
やなぎだる /柳樽/
やなぎば /柳葉/
やなぎばし /柳橋/
やなぎや /柳家/
やなせ /柳瀬/梁瀬/
やなだ /梁田/
やなはら /柵原/
やなり /家鳴り/
やに /脂/
やにょうしょう /夜尿症/
やぬし /家主/
やね /屋根/
やねいた /屋根板/
やねうら /屋根裏/
やの /矢野/
やはぎ /矢矧/矢作/
やはた /八幡/
やはん /夜半/
やば /矢場/
やばけい /耶馬渓/
やばせ /矢橋/
やばね /矢羽/
やばん /野蛮/
やばんじん /野蛮人/
やひ /野卑/
やぶ /藪/薮/
やぶさか /吝か/
やぶにらみ /藪睨み/
やぶみ /矢文/
やぶれかぶれ /破れかぶれ/
やぶれめ /破れ目/
やぶん /夜分/
やほう /野砲/
やぼ /野暮/
やぼう /野望/
やぼてん /野暮天/
やぼよう /野暮用/
やま /山/
やまあい /山間/
やまあらし /山嵐/
やまあるき /山歩き/
やまい /病/山井/
やまいし /山石/
やまいぬ /山犬/豺/
やまいも /山芋/
やまうち /山内/
やまうば /山姥/
やまお /山尾/
やまおか /山岡/
やまおく /山奥/
やまおとこ /山男/
やまかけ /山掛け/
やまかげ /山影/山陰/
やまかじ /山火事/
やまかぜ /山風/
やまかわ /山川/
やまかん /山勘/
やまかんむり /山冠/
やまが /山鹿/山家/
やまがさ /山笠/
やまがた /山形/山県/山型/
やまがたけん /山形県/
やまがたし /山形市/
やまがただいがく /山形大学/
やまがみ /山神/
やまがら /山雀/
やまがり /山狩/
やまがわ /山側/山川/
やまき /山木/八巻/
やまぎし /山岸/
やまぎわ /山際/山極/
やまくさ /山草/
やまくずれ /山崩れ/
やまぐち /山口/
やまぐちけん /山口県/
やまぐちし /山口市/
やまぐちだいがく /山口大学/
やまぐに /山国/
やまぐま /山隈/
やまぐも /山雲/
やまけ /山気/
やまごえ /山越え/
やまごし /山越し/
やまごもり /山籠り/
やまごや /山小屋/
やまさか /山坂/
やまさき /山崎/
やまさわ /山沢/
やまざき /山崎/
やまざくら /山桜/
やまざと /山里/
やまざる /山猿/
やまし /山師/
やました /山下/
やましな /山科/
やましろ /山城/
やましろおんせん /山代温泉/
やまじ /山路/
やますげ /山菅/
やますそ /山裾/
やませ /山背/
やまそだち /山育ち/
やまぞい /山沿い/
やまたいこく /邪馬台国/
やまたか /山高/
やまたに /山谷/
やまたのおろち /八岐大蛇/
やまだ /山田/
やまだし /山出し/
やまっけ /山っ気/
やまづみ /山積み/
やまづら /山面/
やまて /山手/
やまでら /山寺/
やまと /大和/
やまとえ /大和絵/倭絵/
やまとおおじ /大和大路/
やまとがわ /大和川/
やまとこおりやま /大和郡山/
やまとことば /大和言葉/
やまとじ /大和路/
やまとたかだ /大和高田/
やまとだましい /大和魂/
やまとちょうてい /大和朝廷/
やまととじ /大和綴じ/
やまとなでしこ /大和撫子/
やまとに /大和煮/
やまとみんぞく /大和民族/
やまどめ /山止め/
やまどり /山鳥/
やまな /山名/
やまなか /山中/
やまなかこ /山中湖/
やまなし /山梨/
やまなしけん /山梨県/
やまなみ /山並/
やまなり /山形/山鳴り/
やまねこ /山猫/
やまの /山野/
やまのうえ /山上/
やまのうち /山内/
やまのかみ /山の神/
やまのさち /山の幸/
やまのて /山の手/
やまのてせん /山手線/
やまのぼり /山登り/
やまはた /山畑/
やまはだ /山肌/
やまば /山場/
やまばと /山鳩/
やまばといろ /山鳩色/
やまびこ /山彦/
やまびと /山人/
やまびらき /山開き/
やまふじ /山藤/
やまふところ /山懐/
やまぶき /山吹/
やまぶきいろ /山吹色/
やまぶし /山伏/
やまへん /山偏/
やまべ /山部/山辺/
やまほど /山程/
やまぼこ /山鉾/
やままつ /山松/
やまみ /山見/
やまみち /山道/
やまむら /山村/
やまむろ /山室/
やまめ /山女/
やまもと /山本/山元/
やまもといそろく /山本五十六/
やまもも /山桃/
やまもり /山盛り/山守/
やまやき /山焼き/
やまやま /山々/
やまゆり /山百合/
やまわき /山脇/
やまわけ /山分け/
やまんば /山姥/
やみ /闇/
やみいち /闇市/
やみうち /闇討/
やみくも /闇雲/
やみごめ /闇米/
やみじ /闇路/
やみそうば /闇相場/
やみつき /病み付き/
やみとりひき /闇取引/
やみね /闇値/
やみや /闇屋/
やみよ /闇夜/
やむちゃ /飲茶/
やむをえず /止むを得ず/
やめ /八女/
やもうしょう /夜盲症/
やや /漸/稍/
やゆ /揶揄/
やよい /弥生/
やよいじだい /弥生時代/
やよいどき /弥生土器/
やらい /矢来/夜来/
やり /鑓/槍/遣り/
やりがたけ /槍ヶ岳/鑓ヶ岳/
やりくち /遣り口/
やりだま /槍玉/
やりとり /遣り取り/
やりなげ /槍投げ/
やりもち /槍持/
やるき /遣る気/
やろう /野郎/
やろうじだい /夜郎自大/
やわ /夜話/
やわた /八幡/
やわたはま /八幡浜/
やわはだ /柔肌/
やんばる /山原/
ゆ /諭/油/由/輸/癒/愉/湯/遊/喩/斎/柚/弓/揺/愈/
ゆあか /湯垢/
ゆあさ /湯浅/
ゆあたり /湯中り/
ゆあつ /油圧/
ゆあみ /湯浴み/
ゆい /由/唯/遺/由比/由井/結い/
ゆいいつ /唯一/
ゆいいつむに /唯一無二/
ゆいがどくそん /唯我独尊/
ゆいがはま /由比ヶ浜/
ゆいごん /遺言/
ゆいごんしょ /遺言書/
ゆいごんじょう /遺言状/
ゆいしき /唯識/
ゆいしょ /由緒/
ゆいしん /唯心/
ゆいしんろん /唯心論/
ゆいつ /唯一/
ゆいのう /結納/
ゆいぶつ /唯物/
ゆいぶつしかん /唯物史観/
ゆいぶつろん /唯物論/
ゆいめいろん /唯名論/
ゆう /有/優/由/夕/友/郵/誘/裕/融/遊/右/勇/雄/憂/幽/悠/猶/邑/揖/柚/尤/酉/木綿/祐/湧/宥/佑/猷/涌/
ゆう> /優/
ゆうあい /友愛/
ゆうあかり /夕明り/
ゆうあん /幽暗/
ゆうい /有為/優位/有意/雄偉/
ゆういぎ /有意義/
ゆういさ /有意差/
ゆういすいじゅん /有意水準/
ゆういん /誘因/誘引/
ゆううつ /憂鬱/
ゆうえい /遊泳/游泳/
ゆうえき /有益/
ゆうえつ /優越/
ゆうえつかん /優越感/
ゆうえん /幽艶/幽遠/悠遠/優婉/
ゆうえんち /遊園地/
ゆうおうまいしん /勇往邁進/
ゆうか /有価/
ゆうかい /誘拐/有界/融解/幽界/
ゆうかいざい /誘拐罪/
ゆうかいてん /融解点/
ゆうかいねつ /融解熱/
ゆうかく /遊廓/遊客/
ゆうかげ /夕陰/夕影/
ゆうかしょうけん /有価証券/
ゆうかぜ /夕風/
ゆうかん /夕刊/勇敢/有閑/憂患/
ゆうかんじしん /有感地震/
ゆうが /優雅/
ゆうがい /有害/有蓋/
ゆうがお /夕顔/
ゆうがく /遊学/
ゆうがた /夕方/
ゆうがとう /誘蛾灯/
ゆうき /勇気/有機/結城/幽鬼/誘起/有期/
ゆうきおん /有気音/
ゆうきかがく /有機化学/
ゆうきかごうぶつ /有機化合物/
ゆうききんこ /有期禁錮/
ゆうきさん /有機酸/
ゆうきしつ /有機質/
ゆうきたい /有機体/
ゆうきちょうえき /有期懲役/
ゆうきてき /有機的/
ゆうきひりょう /有機肥料/
ゆうきぶつ /有機物/
ゆうきゅう /遊休/悠久/有給/
ゆうきゅうきゅうか /有給休暇/
ゆうきょ /幽居/
ゆうきょう /遊興/遊侠/
ゆうきん /遊金/
ゆうぎ /遊戯/遊技/友誼/
ゆうぎょ /游魚/
ゆうぎり /夕霧/
ゆうく /憂苦/
ゆうぐ /遊具/
ゆうぐう /優遇/
ゆうぐも /夕雲/
ゆうぐれ /夕暮/
ゆうぐん /友軍/遊軍/
ゆうけい /有形/夕景/
ゆうけいむけい /有形無形/
ゆうけむり /夕煙/
ゆうけん /有権/勇健/郵券/
ゆうけんしゃ /有権者/
ゆうげ /夕餉/
ゆうげい /遊芸/
ゆうげき /遊撃/
ゆうげきしゅ /遊撃手/
ゆうげきせん /遊撃戦/
ゆうげきたい /遊撃隊/
ゆうげん /有限/幽玄/
ゆうげんがいしゃ /有限会社/
ゆうげんしゅうごう /有限集合/
ゆうげんすうれつ /有限数列/
ゆうげんせきにん /有限責任/
ゆうこう /有効/友好/有功/遊行/
ゆうこうじゅよう /有効需要/
ゆうこうすうじ /有効数字/
ゆうこうせんぶん /有向線分/
ゆうこうちゅう /有孔虫/
ゆうこく /憂国/夕刻/幽谷/
ゆうこん /雄渾/幽魂/
ゆうごう /融合/
ゆうさく /優作/
ゆうさん /有産/
ゆうざい /有罪/
ゆうざん /雄山/
ゆうし /融資/有志/勇士/勇姿/雄姿/有史/遊資/遊子/有司/猶子/雄志/雄視/憂思/
ゆうしき /有識/
ゆうししゃ /有志者/
ゆうしてっせん /有刺鉄線/
ゆうしゃ /勇者/優者/
ゆうしゅう /優秀/憂愁/有終/幽囚/幽愁/
ゆうしゅうのび /有終の美/
ゆうしゅつ /湧出/
ゆうしゅん /優駿/
ゆうしょう /優勝/有償/湧昇/勇将/優賞/
ゆうしょうき /優勝旗/
ゆうしょうけいやく /有償契約/
ゆうしょうこうい /有償行為/
ゆうしょうはい /優勝杯/
ゆうしょうれっぱい /優勝劣敗/
ゆうしょく /夕食/憂色/有色/有職/
ゆうしょくじんしゅ /有色人種/
ゆうしん /有心/雄心/憂心/
ゆうしんろん /有神論/
ゆうじ /有事/
ゆうじゃく /幽寂/
ゆうじゅう /優柔/
ゆうじゅうふだん /優柔不断/
ゆうじょ /遊女/宥恕/佑助/
ゆうじょう /友情/
ゆうじん /友人/遊人/
ゆうすい /湧水/
ゆうすいち /遊水池/
ゆうすう /有数/
ゆうすずみ /夕涼み/
ゆうずい /雄蕊/
ゆうずう /融通/
ゆうずうむげ /融通無碍/
ゆうせい /郵政/優勢/優性/優生/有性/遊星/雄性/幽静/
ゆうせいおん /有声音/
ゆうせいがく /優生学/
ゆうせいしょう /郵政省;2001年1月の中央省庁再編で総務省に再編された/
ゆうせいせいしょく /有性生殖/
ゆうせいせだい /有性世代/
ゆうせいだいじん /郵政大臣/
ゆうせいらん /有精卵/
ゆうせき /有責/
ゆうせつ /融雪/
ゆうせん /優先/有線/郵船/勇戦/
ゆうせんかぶ /優先株/
ゆうせんけん /優先権/
ゆうせんつうしん /有線通信/
ゆうせんてき /優先的/
ゆうせんほうそう /有線放送/
ゆうぜい /有税/遊説/郵税/
ゆうぜん /友禅/悠然/
ゆうぜんぞめ /友禅染/
ゆうそう /郵送/勇壮/
ゆうそうさいぼう /遊走細胞/
ゆうそく /有職/
ゆうそくこじつ /有職故実/
ゆうたい /優待/勇退/郵袋/
ゆうたいどうさん /有体動産/
ゆうたいぶつ /有体物/
ゆうたいるい /有袋類/
ゆうだ /遊惰/
ゆうだい /雄大/
ゆうだち /夕立/
ゆうだん /勇断/
ゆうだんしゃ /有段者/
ゆうち /誘致/
ゆうちょう /悠長/
ゆうづう /融通/
ゆうづき /夕月/
ゆうづる /夕鶴/
ゆうてん /融点/
ゆうてんじ /祐天寺/
ゆうでんたい /誘電体/
ゆうでんりつ /誘電率/
ゆうと /雄図/雄途/
ゆうとう /優等/遊蕩/友党/
ゆうとうせい /優等生/
ゆうとく /有徳/
ゆうどう /誘導/
ゆうどうえんぼく /遊動円木/
ゆうどうき /誘導機/
ゆうどうじんもん /誘導尋問/
ゆうどうたい /誘導体/
ゆうどうだん /誘導弾/
ゆうどうでんどうき /誘導電動機/
ゆうどく /有毒/
ゆうなぎ /夕凪/
ゆうなみ /夕波/
ゆうに /優に/
ゆうのう /有能/
ゆうはい /有配/
ゆうはつ /誘発/
ゆうはん /夕飯/有半/雄藩/
ゆうばえ /夕映え/
ゆうばく /誘爆/
ゆうばり /夕張/
ゆうばれ /夕晴れ/
ゆうひ /夕日/夕陽/雄飛/
ゆうび /優美/
ゆうびん /郵便/〒/
ゆうびんうけ /郵便受け/
ゆうびんかわせ /郵便為替/
ゆうびんきって /郵便切手/
ゆうびんきょく /郵便局/
ゆうびんしょかん /郵便書簡/
ゆうびんちょきん /郵便貯金/
ゆうびんばこ /郵便箱/
ゆうびんばんごう /郵便番号/〒/
ゆうびんふりかえ /郵便振替/
ゆうびんぶつ /郵便物/
ゆうびんりょう /郵便料/
ゆうふ /有夫/
ゆうふく /裕福/
ゆうふん /憂憤/
ゆうぶ /勇武/
ゆうへい /幽閉/
ゆうべ /夕べ/
ゆうべん /雄弁/
ゆうほ /遊歩/
ゆうほう /友邦/友朋/雄峰/
ゆうほどう /遊歩道/
ゆうぼう /有望/
ゆうぼく /遊牧/
ゆうぼくみんぞく /遊牧民族/
ゆうまぐれ /夕間暮れ/
ゆうみん /遊民/
ゆうむ /有無/
ゆうめい /有名/勇名/幽明/幽冥/
ゆうめいじん /有名人/
ゆうめいむじつ /有名無実/
ゆうめし /夕飯/
ゆうめん /宥免/
ゆうもう /勇猛/
ゆうもや /夕靄/
ゆうもん /幽門/憂悶/
ゆうやく /勇躍/釉薬/
ゆうやけ /夕焼け/
ゆうやみ /夕闇/
ゆうゆう /悠悠/悠々/
ゆうゆうじてき /悠々自適/悠悠自適/
ゆうよ /猶予/有余/
ゆうよう /有用/悠揚/
ゆうよく /遊弋/
ゆうらく /遊楽/
ゆうらくちょう /有楽町/
ゆうらん /遊覧/
ゆうり /有利/有理/遊離/遊里/
ゆうりすう /有理数/
ゆうりゃく /雄略/
ゆうりょ /憂慮/
ゆうりょう /有料/優良/遊猟/
ゆうりょうかぶ /優良株/
ゆうりょうどうろ /有料道路/
ゆうりょく /有力/
ゆうりょくしゃ /有力者/
ゆうれい /幽霊/優麗/
ゆうれき /遊歴/
ゆうれつ /優劣/
ゆうわ /融和/宥和/
ゆうわく /誘惑/
ゆえ /故/
ゆえい /輸贏/
ゆえき /輸液/
ゆえつ /愉悦/踰越/
ゆえに /故に/
ゆえよし /故由/
ゆえん /所以/由縁/油煙/
ゆか /床/由加/
ゆかい /愉快/
ゆかいた /床板/
ゆかいはん /愉快犯/
ゆかうんどう /床運動/
ゆかげん /湯加減/
ゆかした /床下/
ゆかた /浴衣/
ゆかだんぼう /床暖房/
ゆかばり /床張り/
ゆかほん /床本/
ゆかり /縁/
ゆかわ /湯川/
ゆかわひでき /湯川秀樹/
ゆかん /湯灌/
ゆが /瑜伽/
ゆがしま /湯ヶ島/
ゆがしゅう /瑜伽宗/
ゆがま /湯釜/
ゆがわら /湯河原/
ゆき /雪/裄/行き/
ゆきあい /行合/
ゆきあかり /雪明り/
ゆきあそび /雪遊び/
ゆきうさぎ /雪兎/
ゆきおこし /雪起し/
ゆきおとこ /雪男/
ゆきおれ /雪折れ/
ゆきおんな /雪女/
ゆきかき /雪掻き/
ゆきかぜ /雪風/
ゆきかた /行き方/
ゆきがた /行き方/
ゆきがっせん /雪合戦/
ゆきき /行き来/
ゆきぐに /雪国/
ゆきぐも /雪雲/
ゆきけむり /雪煙/
ゆきげしき /雪景色/
ゆきげしょう /雪化粧/
ゆきころがし /雪転がし/
ゆきさき /行先/
ゆきしつ /雪質/
ゆきじ /雪路/
ゆきすぎ /行過ぎ/
ゆきぞら /雪空/
ゆきだおれ /行き倒れ/
ゆきだるま /雪達磨/
ゆきつけ /行き付け/
ゆきどけ /雪解け/
ゆきどころ /行き所/
ゆきなり /行成/
ゆきぬけ /行き抜け/
ゆきのぶ /行信/
ゆきば /行き場/
ゆきばな /雪花/
ゆきばれ /雪晴れ/
ゆきひらなべ /雪平鍋/
ゆきみ /雪見/
ゆきみち /雪道/雪路/
ゆきむし /雪虫/
ゆきもどり /行き戻り/
ゆきもよう /雪模様/
ゆきやま /雪山/
ゆきわかれ /行別れ/
ゆきわりそう /雪割草/
ゆぎ /由木/
ゆぎょう /遊行/
ゆくえ /行方/
ゆくえふめい /行方不明/
ゆくかた /行く方/
ゆくさき /行く先/
ゆくすえ /行く末/
ゆくて /行く手/
ゆくとし /行く年/
ゆくは /的/
ゆくはし /行橋/
ゆぐち /湯口/
ゆけつ /輸血/
ゆけむり /湯煙/
ゆげ /湯気/弓削/
ゆげい /靫負/
ゆこく /諭告/
ゆごう /癒合/
ゆさい /油彩/
ゆさん /遊山/
ゆざい /油剤/
ゆざまし /湯冷まし/
ゆざめ /湯冷め/
ゆざわ /湯沢/
ゆし /油脂/諭旨/油紙/
ゆしま /湯島/
ゆしゅつ /輸出/
ゆしゅつぜい /輸出税/
ゆしゅつちょうか /輸出超過/
ゆしゅつにゅう /輸出入/
ゆしゅつひん /輸出品/
ゆしょく /愉色/
ゆすらうめ /山桜桃/
ゆず /柚/柚子/
ゆずゆ /柚湯/
ゆずりうけ /譲り受け/
ゆせい /油性/油井/
ゆせいかん /輸精管/
ゆせん /湯煎/湯銭/
ゆそう /輸送/油送/油層/油槽/
ゆそうき /輸送機/
ゆそうせん /輸送船/油槽船/
ゆそつ /輸卒/
ゆたか /豊か/裕/
ゆたんぽ /湯湯婆/
ゆだち /弓立/
ゆだて /湯立/
ゆだま /湯玉/
ゆだや /猶太/
ゆだん /油断/
ゆちゃ /湯茶/
ゆちゃく /癒着/
ゆづかれ /湯疲れ/
ゆづけ /湯漬/
ゆづる /弓弦/
ゆてき /油滴/
ゆてん /油点/
ゆで /茹で/
ゆでたまご /茹で卵/
ゆでん /油田/
ゆとう /湯桶/
ゆとうよみ /湯桶読み/
ゆどうふ /湯豆腐/
ゆどおし /湯通し/
ゆどの /湯殿/
ゆな /湯女/
ゆにゅう /輸入/
ゆにゅうぜい /輸入税/
ゆにゅうちょうか /輸入超過/
ゆにゅうひん /輸入品/
ゆにょうかん /輸尿管/
ゆのかわ /湯ノ川/
ゆのはま /湯野浜/
ゆのみ /湯飲み/
ゆば /湯葉/弓場/
ゆび /指/
ゆびおり /指折り/
ゆびき /湯引き/
ゆびきり /指切り/
ゆびさき /指先/
ゆびにんぎょう /指人形/
ゆびぬき /指貫/
ゆびわ /指輪/指環/
ゆぶね /湯船/
ゆまく /油膜/
ゆみ /弓/
ゆみがた /弓形/
ゆみがはま /弓ヶ浜/
ゆみず /湯水/
ゆみづる /弓弦/
ゆみとり /弓取/
ゆみはり /弓張/
ゆみへん /弓偏/
ゆみや /弓矢/
ゆむらおんせん /湯村温泉/
ゆめ /夢/
ゆめあわせ /夢合せ/
ゆめうらない /夢占い/
ゆめがたり /夢語り/
ゆめごこち /夢心地/
ゆめじ /夢路/
ゆめどの /夢殿/
ゆめのうきはし /夢浮橋/
ゆめのきゅうさく /夢野久作/
ゆめはんだん /夢判断/
ゆめまくら /夢枕/
ゆめまぼろし /夢幻/
ゆめみ /夢見/
ゆめみごこち /夢見心地/
ゆめものがたり /夢物語/
ゆもと /湯本/湯元/
ゆや /湯屋/
ゆよく /湯浴/
ゆら /由良/
ゆらい /由来/
ゆらく /愉楽/
ゆらんかん /輸卵管/
ゆり /百合/由利/
ゆりかえし /揺り返し/
ゆりょう /湯量/
ゆる /緩/
ゆるやか /緩やか/
ゆれ /揺れ/
ゆわかし /湯沸し/
よ /代/世/余/夜/予/預/輿/誉/与/四/豫/餘/
よーろっぱ /欧羅巴/
よあかし /夜明し/
よあけ /夜明け/
よあけまえ /夜明け前/
よあそび /夜遊び/
よあらし /夜嵐/
よあるき /夜歩き/
よい /宵/良い/酔い/余威/
よいごこち /酔心地/
よいごし /宵越し/
よいち /世一/
よいっぱり /宵っ張り/
よいづき /宵月/
よいづきよ /宵月夜/
よいどれ /酔いどれ/
よいね /宵寝/
よいのくち /宵の口/
よいまちぐさ /宵待草/
よいまつり /宵祭/
よいみや /宵宮/
よいやま /宵山/
よいやみ /宵闇/
よいん /余韻/余音/
よう /用/様/要/陽/遥/葉/養/踊/謡/羊/窯/溶/洋/曜/擁/揺/揚/庸/容/妖/幼/傭/腰/俑/徭/杳/癰/耀/熔/楊/八/
よう> /要/
ようあん /溶暗/
ようい /用意/容易/妖異/
よういく /養育/
よういしゅうとう /用意周到/
よういん /要因/要員/
ようえい /揺曳/
ようえき /溶液/葉腋/用益/用役/
ようえきち /要役地/
ようえん /陽炎/妖艶/
ようおん /拗音/
ようか /八日/蛹化/妖花/養家/
ようかい /妖怪/溶解/容喙/鎔解/熔解/
ようかいち /八日市/
ようかいちば /八日市場/
ようかいねつ /溶解熱/
ようかいへんげ /妖怪変化/
ようかた /養方/
ようかん /洋館/羊羹/腰間/
ようかんすう /陽関数/
ようが /洋画/幼芽/陽画/
ようがい /要害/
ようがく /洋楽/洋学/
ようがさ /洋傘/
ようがし /洋菓子/
ようがっき /洋楽器/
ようがん /溶岩/熔岩/容顔/
ようき /容器/陽気/妖気/
ようきゅう /要求/洋弓/
ようきょう /佯狂/
ようきょく /陽極/謡曲/
ようきょくせん /陽極線/
ようきん /用金/洋琴/
ようぎ /容疑/要義/容儀/
ようぎしゃ /容疑者/
ようぎょ /養魚/幼魚/
ようぎょう /窯業/
ようぎん /洋銀/
ようくん /幼君/
ようぐ /用具/要具/庸愚/
ようけい /養鶏/
ようけつ /溶血/要訣/
ようけん /用件/要件/洋犬/
ようけんじじつ /要件事実/
ようけんどう /養賢堂/
ようげき /邀撃/
ようげん /用言/揚言/
ようこう /要項/洋行/陽光/要綱/要港/妖光/
ようこうろ /溶鉱炉/
ようこん /幼根/
ようご /用語/擁護/養護/用後/
ようごがっこう /養護学校/
ようごきょうゆ /養護教諭/
ようさい /要塞/洋裁/洋才/
ようさん /養蚕/葉酸/
ようざい /溶剤/用材/
ようざん /腰斬/要斬/
ようし /用紙/容姿/要旨/養子/陽子/洋紙/夭死/羊歯/羊脂/
ようしえんぐみ /養子縁組/
ようしき /様式/洋式/要式/
ようしし /養嗣子/
ようしつ /洋室/溶質/
ようしゃ /容赦/幼者/用捨/
ようしゅ /洋酒/楊朱/洋種/
ようしゅう /揚州/
ようしゅん /陽春/
ようしょ /洋書/要所/
ようしょう /幼少/要衝/葉鞘/
ようしょく /養殖/洋食/要職/容色/
ようしん /葉身/養親/
ようしんし /養親子/
ようじ /用事/幼児/幼時/楊枝/用字/要事/
ようじき /幼児期/
ようじきょういく /幼児教育/
ようじご /幼児語/
ようじゃく /幼弱/
ようじゅつ /妖術/
ようじょ /幼女/養女/妖女/葉序/
ようじょう /養生/洋上/
ようじょうたい /葉状体/
ようじん /用心/要人/洋人/
ようじんぼう /用心棒/
ようす /様子/
ようすい /羊水/用水/揚水/
ようすいちえきけん /用水地役権/
ようすいろ /用水路/
ようすこう /揚子江/
ようするに /要するに/
ようず /要図/
ようずみ /用済み/
ようせい /要請/妖精/養成/陽性/夭逝/幼生/妖星/
ようせき /容積/
ようせきりつ /容積率/
ようせつ /溶接/夭折/熔接/
ようせん /用箋/用船/傭船/
ようせんけいやく /傭船契約/
ようそ /要素/
ようそう /様相/洋装/
ようたい /様態/
ようだ /様だ/
ようだい /容体/容態/
ようだん /用談/要談/
ようち /幼稚/用地/要地/夜討ち/
ようちあさがけ /夜討ち朝駆け/
ようちえん /幼稚園/
ようちゅう /幼虫/
ようちゅうい /要注意/
ようちょう /膺懲/羊腸/
ようつい /腰椎/
ようつう /腰痛/
ようてい /要諦/揚程/
ようていざん /羊蹄山/
ようてん /要点/陽転/
ようでんき /陽電気/
ようでんし /陽電子/
ようと /用途/
ようとうくにく /羊頭狗肉/
ようとして /杳として/
ようとじ /洋綴じ/
ようとん /養豚/
ようど /用度/用土/
ようどう /揺動/幼童/
ようなし /洋梨/用無し/
ようにく /葉肉/
ようにん /容認/用人/傭人/
ようねん /幼年/
ようはい /遥拝/
ようはつ /洋髪/
ようばい /溶媒/
ようばん /洋盤/
ようひし /羊皮紙/
ようひつ /用筆/
ようひん /用品/洋品/
ようひんてん /洋品店/
ようび /曜日/妖美/
ようふ /養父/用布/妖婦/
ようふう /洋風/
ようふく /洋服/
ようふぼ /養父母/
ようぶ /洋舞/腰部/
ようぶつけいやく /要物契約/
ようぶん /養分/
ようへい /用兵/傭兵/葉柄/
ようへき /擁壁/
ようへん /窯変/曜変/
ようべん /用便/
ようほう /用法/養蜂/陽報/
ようほうじばん /要法寺版/
ようほん /洋本/
ようぼ /養母/
ようぼう /要望/容貌/
ようぼく /用木/
ようま /洋間/妖魔/
ようまく /羊膜/
ようみゃく /葉脈/
ようみょう /幼名/
ようむ /用務/要務/
ようむいん /用務員/
ようむき /用向き/
ようめい /用命/幼名/溶明/
ようめいがく /陽明学/
ようめん /容面/
ようもう /羊毛/
ようもく /要目/
ようもの /洋物/
ようもん /要文/
ようやく /要約/
ようゆう /溶融/熔融/
ようよう /様々/要用/揚々/
ようらん /要覧/揺籃/洋蘭/
ようらんき /揺籃期/
ようりく /揚陸/
ようりつ /擁立/
ようりゃく /要略/
ようりゅう /楊柳/
ようりょう /容量/要領/用量/養料/
ようりょく /揚力/
ようりょくそ /葉緑素/
ようりょくたい /葉緑体/
ようれい /用例/妖麗/
ようれき /陽暦/
ようれつ /庸劣/
ようろ /要路/
ようろう /養老/
ようろういん /養老院/
ようろうのたき /養老の滝/
ようわ /養和/
よえい /余映/余栄/
よえん /余炎/
よか /余暇/予科/予価/
よかく /与格/予覚/余角/
よかぜ /夜風/
よかれ /善かれ/
よかれん /予科練/
よかん /予感/余寒/
よがたり /夜語り/
よき /予期/
よきょう /余興/
よきん /預金/
よきんつうか /預金通貨/
よきんつうちょう /預金通帳/
よきんほけんせいど /預金保険制度/
よぎ /余儀/余技/夜着/
よぎしゃ /夜汽車/
よぎり /夜霧/
よく /翼/翌/浴/欲/抑/慾/良く/沃/
よく> /翌/
よくあさ /翌朝/
よくあつ /抑圧/
よくうつ /抑鬱/
よくか /翼果/
よくかい /欲界/
よくけ /欲気/
よくげつ /翌月/
よくご /浴後/
よくさん /翼賛/
よくし /抑止/
よくしつ /浴室/
よくしゅう /翌週/翌秋/
よくしゅるい /翼手類/
よくしゅん /翌春/
よくしん /欲心/
よくじつ /翌日/
よくじょう /浴場/欲情/翼状/抑情/
よくせい /抑制/
よくそう /浴槽/
よくち /沃地/
よくちょう /翌朝/
よくとく /欲得/
よくとし /翌年/
よくど /沃土/
よくねん /翌年/欲念/
よくばり /欲張り/
よくばん /翌晩/
よくふか /欲深/
よくぼう /欲望/
よくめ /欲目/
よくや /沃野/
よくよう /抑揚/浴用/
よくようとんざ /抑揚頓挫/
よくよく /翌々/
よくよくじつ /翌々日/
よくりゅう /抑留/
よくん /余薫/
よけい /余計/
よけつ /預血/
よけん /予見/与件/
よげん /予言/余弦/預言/
よげんしゃ /預言者/
よこ /横/
よこあい /横合い/
よこあな /横穴/
よこあめ /横雨/
よこい /横井/
よこいた /横板/
よこいと /横糸/
よこう /予行/余光/余香/予稿/
よこうえんしゅう /予行演習/
よこえ /横絵/
よこかぜ /横風/
よこかわ /横川/
よこがお /横顔/
よこがき /横書き/
よこがく /横額/
よこがみ /横紙/
よこぎ /横木/
よこく /予告/与国/
よこくとうき /予告登記/
よこぐみ /横組/
よこぐるま /横車/
よこざ /横座/
よこざま /横方/
よこしま /邪/
よこじく /横軸/
よこじま /横縞/
よこすか /横須賀/
よこすかせん /横須賀線/
よこすじ /横筋/
よこすべり /横滑り/
よこせ /横瀬/
よこだおし /横倒し/
よこちょう /横町/
よこっつら /横っ面/
よこっぱら /横っ腹/
よこつら /横面/
よこづけ /横付け/
よこづな /横綱/
よこて /横手/
よこで /横手/
よことじ /横綴じ/
よこどい /横樋/
よこどり /横取り/
よこなが /横長/
よこながし /横流し/
よこながれ /横流れ/
よこなぐり /横殴り/
よこなみ /横波/
よこね /横根/
よこはば /横幅/
よこはま /横浜/
よこはまし /横浜市/
よこばい /横這い/
よこばしり /横走り/
よこばら /横腹/
よこぶえ /横笛/
よこぶとり /横太り/
よこぶり /横降り/
よこほん /横本/
よこぼう /横棒/
よこまち /横町/
よこみ /横見/
よこみち /横道/
よこみつ /横光/
よこめ /横目/
よこもじ /横文字/
よこもの /横物/
よこや /横谷/横矢/横屋/
よこやま /横山/
よこやり /横槍/
よこれんぼ /横恋慕/
よこわり /横割り/
よご /予後/
よごと /夜毎/
よごれ /汚れ/
よごれやく /汚れ役/
よさ /与謝/善さ/
よさつ /予察/
よさの /与謝野/
よさぶそん /与謝蕪村/
よさむ /夜寒/
よさん /予算/
よさんがい /予算外/
よさんちょうか /予算超過/
よざい /余罪/余財/
よざかり /世盛り/
よざくら /夜桜/
よし /由/葦/葭/
よしあし /善し悪し/
よしい /吉井/
よしえ /吉江/
よしお /吉雄/
よしおか /吉岡/
よしかわ /吉川/
よしざわ /吉沢/芳沢/
よしずみ /吉住/
よしだ /吉田/
よしだけんこう /吉田兼好/
よしだしげる /吉田茂/
よしだちょう /吉田町/
よしだや /吉田屋/
よしの /吉野/
よしのがわ /吉野川/
よしのじんぐう /吉野神宮/
よしのやま /吉野山/
よしひろ /義弘/
よしみ /吉見/誼/
よしみつ /吉光/
よしむら /吉村/芳村/
よしや /吉屋/
よしゅう /予習/余臭/
よしょく /余色/
よしわら /吉原/
よしん /余震/予診/予審/
よじ /余事/
よじげん /四次元/
よじつ /余日/
よじょう /余剰/余情/
よじょうはん /四畳半/
よじろう /与次郎/
よじん /余燼/余人/余塵/
よすい /余水/
よすてびと /世捨て人/
よすみ /四隅/
よせ /寄せ/寄席/
よせあつめ /寄せ集め/
よせい /余生/余勢/
よせがき /寄せ書き/
よせざん /寄せ算/
よせつ /余接/
よせなべ /寄せ鍋/
よせん /予選/
よせんかい /予餞会/
よぜん /余喘/
よそ /他所/余所/
よそう /予想/
よそうがい /予想外/
よそおい /装い/
よそく /予測/
よそごと /余所事/
よそじ /四十路/
よそみ /余所見/
よそめ /余所目/
よそもの /余所者/
よそゆき /余所行き/
よぞら /夜空/
よた /与太/
よたいりつ /預貸率/
よたか /夜鷹/
よたく /預託/余沢/
よたもの /与太者/
よたろう /与太郎/
よだ /依田/
よだち /夜立ち/
よだつ /与奪/予奪/
よだれ /涎/
よだれかけ /涎掛け/
よだん /余談/予断/
よち /余地/予知/輿地/
よちず /輿地図/
よちょう /予兆/
よちょきん /預貯金/
よっか /四日/翼下/
よっかいち /四日市/
よっきゅう /欲求/
よっきゅうふまん /欲求不満/
よっつ /四つ/
よつ /四つ/
よつあし /四足/
よつかいどう /四街道/
よつかど /四つ角/
よつぎ /世嗣/世継/
よつぎり /四つ切/
よつずもう /四つ相撲/
よつつじ /四辻/
よつどき /四つ時/
よつみ /四つ身/
よつめ /四つ目/
よつめとじ /四つ目綴じ/
よつや /四谷/
よつやかいだん /四谷怪談/
よつゆ /夜露/
よづり /夜釣/
よてい /予定/
よていちょうわ /予定調和/
よていひょう /予定表/
よてき /余滴/
よとう /与党/
よとぎ /夜伽/
よとく /余得/余徳/
よど /淀/
よどおし /夜通し/
よどがわ /淀川/
よどぎみ /淀君/
よどみ /澱/
よない /米内/
よないみつまさ /米内光政/
よなおし /世直し/
よなか /夜中/
よなが /夜長/
よなき /夜泣き/
よなぐにじま /与那国島/
よなご /米子/
よなよな /夜な夜な/
よにげ /夜逃げ/
よにん /余人/
よね /米/
よねざわ /米沢/
よねしろがわ /米代川/
よねず /米酢/
よねだ /米田/
よねつ /余熱/
よねやま /米山/
よねん /余念/余年/
よの /与野/
よのう /予納/
よのつね /世の常/
よのなか /世の中/
よのならい /世の習い/
よは /余波/
よはく /余白/
よばたらき /夜働き/
よばわり /呼ばわり/
よばん /夜番/
よび /予備/
よびえき /予備役/
よびかけ /呼掛け/
よびぐん /予備軍/
よびこ /呼子/
よびこう /予備校/
よびごえ /呼び声/
よびしはらいにん /予備支払人/
よびすて /呼捨て/
よびだし /呼出し/
よびちしき /予備知識/
よびちょうさ /予備調査/
よびな /呼び名/
よびね /呼値/
よびひ /予備費/
よびみず /呼び水/
よびもどし /呼び戻し/
よびもの /呼び物/
よびや /呼び屋/
よびょう /余病/
よびりん /呼び鈴/
よふう /余風/
よふかし /夜更し/
よふけ /夜更け/
よふん /余憤/
よぶこ /呼子/
よぶん /余分/余聞/
よへい /余弊/
よほう /予報/
よほど /余程/
よぼう /予防/
よぼういがく /予防医学/
よぼうせっしゅ /予防接種/
よぼうせん /予防線/
よぼうせんそう /予防戦争/
よぼうちゅうしゃ /予防注射/
よまわり /夜回り/
よみ /読み/黄泉/
よみあげ /読上げ/
よみあわせ /読合せ/
よみうり /読売/
よみうりしんぶん /読売新聞/
よみかき /読み書き/
よみかた /読み方/
よみがな /読み仮名/
よみきり /読切り/
よみごたえ /読み応え/
よみじ /黄泉路/
よみせ /夜店/
よみち /夜道/
よみて /読み手/
よみで /読みで/
よみのくに /黄泉の国/
よみふだ /読み札/
よみほん /読本/
よみもの /読み物/
よめ /嫁/夜目/
よめい /余命/
よめいり /嫁入り/
よめご /嫁御/
よめごりょう /嫁御寮/
よめじょ /嫁女/
よめとり /嫁取り/
よも /四方/
よもぎ /蓬/艾/
よもぎう /蓬生/
よもすがら /終夜/
よもやま /四方山/
よもやまばなし /四方山話/
よやく /予約/
よやくしゅっぱん /予約出版/
よやくはんばい /予約販売/
よゆう /余裕/
よゆうしゃくしゃく /余裕綽綽/
よよぎ /代々木/
よりあい /寄合/
よりあいがき /寄合書/
よりい /寄居/
よりき /与力/寄木/
よりしろ /依代/憑代/
よりつき /寄付き/
よりどころ /拠/
よりまし /憑坐/
よりみ /寄り身/
よりみち /寄り道/
よりめ /寄り目/
よりょく /余力/
よる /夜/
よるい /余類/
よるひる /夜昼/
よるよなか /夜夜中/
よれい /予鈴/余齢/
よろい /鎧/
よろいど /鎧戸/
よろいむしゃ /鎧武者/
よろく /余録/余禄/
よろこび /喜び/悦び/
よろしく /宜しく/
よろず /万/
よろずちょうほう /万朝報/
よろずや /万屋/
よろん /世論/
よわ /夜半/余話/
よわい /弱い/齢/
よわき /弱気/
よわごし /弱腰/
よわたり /世渡り/
よわね /弱音/
よわふくみ /弱含み/
よわみ /弱味/
よわみそ /弱味噌/
よわむし /弱虫/
よわめ /弱目/
よわよわ /弱々/
よわりめ /弱り目/
よん /四/
よんど /四度/
よんりん /四輪/
よんりんくどう /四輪駆動/
ら /等/裸/螺/羅/拉/
らーめん /拉麺/
らーゆ /辣油/
らい /来/雷/頼/礼/癩/籟/罍/耒/莱/
らい> /来/
らいい /来意/
らいう /雷雨/
らいうん /雷雲/
らいえん /来演/来援/
らいおう /来往/
らいか /雷火/
らいかい /来会/
らいかん /雷管/来観/
らいが /来駕/
らいがくねん /来学年/
らいがっき /来学期/
らいき /来期/礼記/
らいきゃく /来客/
らいぎょ /雷魚/
らいげき /雷撃/
らいげきき /雷撃機/
らいげつ /来月/
らいこう /来航/来光/雷光/来寇/来貢/雷公/
らいごう /来降/来迎/
らいさん /礼賛/礼讃/
らいさんよう /頼山陽/
らいしゃ /来社/来車/
らいしゅう /来週/来襲/来集/
らいしゅん /来春/
らいしょ /来書/
らいしん /来信/来診/
らいじ /来示/
らいじょう /来場/来状/
らいじん /雷神/
らいせ /来世/
らいたく /来宅/
らいだん /来談/
らいちゃく /来着/
らいちょう /来聴/雷鳥/来朝/
らいてん /来店/
らいでん /雷電/来電/
らいどう /雷同/
らいにち /来日/
らいにん /来任/
らいねん /来年/
らいねんど /来年度/
らいはい /礼拝/
らいはいどう /礼拝堂/
らいはる /来春/
らいひん /来賓/
らいびょう /癩病/
らいほう /来訪/来報/
らいめい /雷鳴/雷名/
らいゆう /来由/来遊/
らいらく /磊落/
らいりん /来臨/
らいれき /来歴/
らおちゅー /老酒/
らかん /羅漢/
らがん /裸眼/
らぎょう /ラ行/裸形/
らく /楽/落/酪/絡/洛/
らくいん /烙印/落胤/
らくいんきょ /楽隠居/
らくえん /楽園/
らくがい /洛外/
らくがき /落書/
らくがん /落雁/
らくご /落語/落後/落伍/
らくごか /落語家/
らくさ /落差/
らくさつ /落札/
らくしゅ /落手/落首/
らくしょ /落書/
らくしょう /楽勝/落掌/酪漿/
らくしょく /落飾/
らくじつ /落日/
らくじょう /落城/
らくせい /落成/
らくせき /落石/落籍/
らくせつ /落屑/
らくせん /落選/
らくたい /落体/
らくたん /落胆/
らくだ /駱駝/
らくだい /落第/
らくだいろ /駱駝色/
らくちゃく /落着/
らくちゅう /洛中/
らくちょう /落丁/
らくぢゃわん /楽茶碗/
らくてん /楽天/
らくてんか /楽天家/
らくてんてき /楽天的/
らくとう /洛東/
らくど /楽土/
らくのう /酪農/
らくはく /落魄/落剥/
らくはつ /落髪/
らくば /落馬/
らくばい /落梅/
らくばん /落磐/落盤/
らくひつ /落筆/
らくび /楽日/
らくめい /落命/
らくやき /楽焼/
らくよう /落葉/洛陽/落陽/
らくようじゅ /落葉樹/
らくらい /落雷/
らくらく /楽々/
らくるい /落涙/
らし /螺子/
らししょくぶつ /裸子植物/
らしゅつ /裸出/
らしょうもん /羅生門/
らしん /裸身/羅針/
らしんぎ /羅針儀/
らしんばん /羅針盤/
らせつ /羅切/羅刹/
らせん /螺旋/螺線/
らせんかいだん /螺旋階段/
らぞう /裸像/
らたい /裸体/
らち /埒/拉致/
らちがい /埒外/
らっか /落下/落花/落果/
らっかさん /落下傘/
らっかせい /落花生/
らっかてん /落下点/
らっかりゅうすい /落花流水/
らっかろうぜき /落花狼藉/
らっかん /楽観/落款/
らっかんてき /楽観的/
らっぱ /喇叭/
らつ /辣/剌/
らつわん /辣腕/
らでん /螺鈿/
らば /騾馬/
らふ /裸婦/
らへん /ラ変/
らもん /羅門/
られつ /羅列/
らん /覧/欄/嵐/乱/蘭/藍/濫/卵/爛/襴/鸞/
らんうん /乱雲/
らんおう /卵黄/
らんかく /乱獲/濫獲/卵殻/
らんかつ /卵割/
らんかん /欄干/卵管/
らんがい /欄外/
らんがく /蘭学/
らんき /嵐気/
らんきりゅう /乱気流/
らんぎく /乱菊/
らんぎょう /乱行/
らんぎり /乱切り/
らんぐん /乱軍/
らんけい /卵形/
らんげき /乱撃/
らんこうげ /乱高下/
らんこん /乱婚/
らんご /蘭語/
らんごく /乱国/
らんさいぼう /卵細胞/
らんざつ /乱雑/
らんざん /嵐山/
らんし /卵子/乱視/
らんしゃ /乱射/
らんしゅ /乱酒/
らんしゅう /蘭州/
らんしょ /蘭書/
らんしょう /濫觴/
らんしん /乱心/乱臣/
らんしんぞくし /乱臣賊子/
らんじゅく /爛熟/
らんすう /乱数/
らんすうひょう /乱数表/
らんせい /乱世/卵生/
らんせん /乱戦/
らんぜん /爛然/
らんそ /濫訴/
らんそう /卵巣/藍藻/
らんそううん /乱層雲/
らんぞう /乱造/濫造/
らんたいせい /卵胎生/
らんだ /乱打/
らんちき /乱痴気/
らんちきさわぎ /乱痴気騒ぎ/
らんちょう /乱丁/乱調/鸞鳥/
らんちょうし /乱調子/
らんでん /藍田/
らんとう /乱闘/
らんどく /乱読/濫読/
らんない /欄内/
らんにゅう /乱入/
らんはんしゃ /乱反射/
らんばい /乱売/
らんばつ /乱伐/濫伐/
らんぱく /卵白/
らんぱつ /乱発/
らんぴ /乱費/濫費/
らんぴつ /乱筆/
らんぶ /乱舞/
らんぶん /乱文/
らんぼう /乱暴/
らんぼうろうぜき /乱暴狼藉/
らんぽう /蘭方/卵胞/
らんぽん /藍本/
らんま /乱麻/欄間/
らんまく /卵膜/
らんまん /爛漫/
らんみゃく /乱脈/
らんよう /乱用/濫用/
らんらん /爛々/爛爛/
らんりつ /乱立/
らんりゅう /乱流/
らんる /襤褸/
り /裏/里/離/理/利/痢/裡/履/吏/俚/罹/釐/浬/璃/李/梨/
りーち /立直/
りあげ /利上げ/
りいん /吏員/
りえき /利益/
りえきはいとう /利益配当/
りえきりつ /利益率/
りえん /離縁/梨園/
りえんじょう /離縁状/
りおち /利落ち/
りか /理科/李下/梨花/
りかい /理解/理会/
りかがく /理化学/
りかく /離角/離隔/
りかん /罹患/離間/
りがい /利害/理外/
りがいかんけい /利害関係/
りがく /理学/
りがん /離岸/
りき /力/利器/
りきえい /力泳/
りきえん /力演/
りきかん /力感/
りきがく /力学/
りきさく /力作/
りきし /力士/
りきしゃ /力車/
りきせき /力積/
りきせつ /力説/
りきせん /力戦/力線/
りきそう /力走/力漕/
りきてん /力点/
りきとう /力闘/力投/
りきゅう /離宮/利休/
りきゅういろ /利休色/
りきゅうねずみ /利休鼠/
りきょう /離京/離郷/
りきりょう /力量/
りきん /利金/
りく /陸/
りくあげ /陸揚げ/
りくい /陸尉/
りくう /陸羽/
りくうん /陸運/
りくぎ /六義/
りくぐん /陸軍/
りくぐんしょう /陸軍省/
りくぐんだいじん /陸軍大臣/
りくさ /陸佐/
りくし /陸士/
りくしょ /六書/
りくしょう /陸相/陸将/
りくじょう /陸上/
りくじょうき /陸上機/
りくじょうきょうぎ /陸上競技/
りくせい /陸生/
りくせいそう /陸成層/
りくせん /陸戦/
りくせんたい /陸戦隊/
りくぜん /陸前/
りくぜんたかた /陸前高田/
りくそう /陸送/陸曹/
りくぞく /陸続/
りくたい /六体/
りくだな /陸棚/
りくち /陸地/
りくちゅう /陸中/
りくちょう /六朝/
りくつ /理屈/
りくつぜめ /理屈責め/
りくつづき /陸続き/
りくつや /理屈屋/
りくとう /陸稲/
りくとうさんりゃく /六韜三略/
りくどう /六道/
りくはんきゅう /陸半球/
りくふう /陸風/
りくへい /陸兵/
りくやね /陸屋根/
りくりょく /戮力/
りくろ /陸路/
りぐい /利食い/
りけい /理系/
りけん /理研/利権/利剣/
りこ /利己/
りこう /利口/履行/理工/
りこうちたい /履行遅滞/
りこうふのう /履行不能/
りこしゅぎ /利己主義/
りこしん /利己心/
りこん /離婚/利根/
りご /俚語/
りごう /離合/
りごうしゅうさん /離合集散/
りさい /罹災/
りさげ /利下げ/
りさつ /利札/
りさん /離散/
りさんすうがく /離散数学/
りさんてき /離散的/
りざい /理財/
りざや /利鞘/
りし /利子/李斯/
りしほきゅう /利子補給/
りしゅう /履修/離愁/
りしょう /離床/離昇/離礁/
りしょうばん /李承晩/
りしょく /離職/利殖/
りしり /利尻/
りしんりつ /離心率/
りしんろん /理神論/
りじ /理事/
りじこく /理事国/
りじゅん /利潤/
りじん /利刃/
りじんしょう /離人症/
りす /栗鼠/
りすい /利水/離水/
りすう /理数/
りすうか /理数科/
りせい /理性/
りせいてき /理性的/
りせいろん /理性論/
りせき /離籍/
りせん /離船/利銭/
りそう /理想/
りそうか /理想化/
りそうきたい /理想気体/
りそうきょう /理想郷/
りそうしゅぎ /理想主義/
りそうてき /理想的/
りそうは /理想派/
りそうろん /理想論/
りそく /利息/
りそん /離村/
りた /利他/
りたつ /利達/
りだつ /離脱/
りち /理知/律/
りちぎ /律義/律儀/
りちてき /理知的/
りちゃくりく /離着陸/
りちょう /李朝/
りっか /立夏/
りっかん /律管/
りっきゃく /立脚/
りっきゃくてん /立脚点/
りっきょう /陸橋/
りっきょうだいがく /立教大学/
りっけん /立件/立憲/
りっけんせいじ /立憲政治/
りっこう /立后/
りっこうほ /立候補/
りっこく /立国/
りっこくし /六国史/
りっし /立志/律師/律詩/
りっしでん /立志伝/
りっしゃくじ /立石寺/
りっしゅう /立秋/律宗/
りっしゅん /立春/
りっしょう /立証/
りっしょうせきにん /立証責任/
りっしょく /立食/
りっしん /立身/
りっしんしゅっせ /立身出世/
りっすい /立錐/
りっすいのち /立錐の地/
りったい /立体/
りったいかく /立体角/
りったいかん /立体感/
りったいきょう /立体鏡/
りったいこうさ /立体交差/
りったいし /立体視/立太子/
りったいしゃしん /立体写真/
りったいてき /立体的/
りっち /立地/
りっちじょうけん /立地条件/
りっとう /立冬/立党/
りっぱ /立派/
りっぷく /立腹/
りっぽう /立方/立法/律法/
りっぽういん /立法院/
りっぽうきかん /立法機関/
りっぽうけん /立法権/
りっぽうこん /立方根/
りっぽうたい /立方体/
りっぽうふ /立法府/
りつ /率/立/律/葎/
りつあん /立案/
りつがん /立願/
りつき /利付き/
りつげん /立言/
りつご /律語/
りつぜん /慄然/
りつぞう /立像/
りつどう /律動/
りつめい /立命/
りつめんず /立面図/
りつりょう /律令/
りつれい /立礼/律令/
りつろん /立論/
りづめ /理詰め/
りてい /里程/
りてき /利敵/
りてん /利点/
りとう /離島/離党/利刀/
りとく /利得/
りどう /里道/
りどん /利鈍/
りにち /離日/
りにゅう /離乳/
りにゅうしょく /離乳食/
りにょう /利尿/
りにん /離任/
りねん /理念/
りのう /離農/
りはい /離背/
りはく /李白/理博/
りはつ /理髪/利発/
りはつし /理髪師/
りはば /利幅/
りはん /離反/離叛/
りばらい /利払い/
りひ /理非/
りひきょくちょく /理非曲直/
りびょう /罹病/痢病/
りふじん /理不尽/
りふだ /利札/
りぶん /利分/
りへい /利平/
りべつ /離別/
りべん /利便/
りべんか /離弁花/
りほう /李鵬/理法/
りまわり /利回り/
りむ /吏務/
りめん /裏面/
りゃく /略/掠/
りゃくおう /暦応/
りゃくが /略画/
りゃくぎ /略儀/
りゃくげ /略解/
りゃくげん /略言/
りゃくご /略語/
りゃくごう /略号/
りゃくしき /略式/
りゃくしきてつづき /略式手続/
りゃくしゅ /略取/
りゃくしょう /略称/略章/
りゃくじ /略字/
りゃくじゅつ /略述/
りゃくじょ /略叙/
りゃくず /略図/
りゃくせつ /略説/
りゃくそう /略装/
りゃくたい /略体/
りゃくだつ /略奪/掠奪/
りゃくでん /略伝/
りゃくひつ /略筆/
りゃくひょう /略表/
りゃくふ /略譜/
りゃくふく /略服/
りゃくほん /略本/
りゃくめい /略名/
りゃくれき /略歴/
りゃっかい /略解/
りゃっき /略記/
りやく /利益/
りゅう /流/隆/立/竜/粒/硫/留/溜/柳/龍/劉/
りゅうあん /硫安/
りゅうあんかめい /柳暗花明/
りゅうあんじ /竜安寺/
りゅうい /留意/
りゅういき /流域/
りゅういん /溜飲/
りゅううん /隆運/
りゅうおう /竜王/
りゅうおん /流音/
りゅうか /硫化/琉歌/流下/
りゅうかい /流会/
りゅうかん /流感/流汗/
りゅうがく /留学/
りゅうがくせい /留学生/
りゅうがさき /竜ケ崎/
りゅうがん /竜顔/竜眼/
りゅうき /隆起/
りゅうきこう /硫気孔/
りゅうきへい /竜騎兵/
りゅうきゅう /琉球/
りゅうきゅうこ /琉球弧/
りゅうきゅうご /琉球語/
りゅうぎ /流儀/
りゅうぐう /竜宮/流寓/
りゅうぐうじょう /竜宮城/
りゅうけい /流刑/
りゅうけつ /流血/
りゅうげん /流言/
りゅうげんひご /流言蜚語/
りゅうこ /竜虎/
りゅうこう /流行/
りゅうこうか /流行歌/
りゅうこうご /流行語/
りゅうこうびょう /流行病/
りゅうこつ /竜骨/
りゅうさん /硫酸/
りゅうさんし /硫酸紙/
りゅうさんどう /硫酸銅/
りゅうざん /流産/
りゅうし /粒子/
りゅうしせん /粒子線/
りゅうしち /流質/
りゅうしつ /流失/
りゅうしゅつ /流出/
りゅうしょう /隆昌/
りゅうしょく /粒食/
りゅうじょう /粒状/
りゅうじょうこし /竜驤虎視/
りゅうじょうこはく /竜攘虎搏/
りゅうじん /竜神/
りゅうすい /流水/
りゅうず /竜頭/
りゅうせい /流星/隆盛/
りゅうせいう /流星雨/
りゅうせいぐん /流星群/
りゅうせつ /流説/
りゅうせん /流線/流涎/
りゅうせんけい /流線形/流線型/
りゅうそく /流速/
りゅうぞく /流俗/
りゅうたい /流体/隆替/
りゅうたいりきがく /流体力学/
りゅうたく /流謫/
りゅうだん /榴弾/流弾/
りゅうち /留置/
りゅうちけん /留置権/
りゅうちじょう /留置場/
りゅうちぶつ /留置物/
りゅうちょう /流暢/留鳥/
りゅうつう /流通/
りゅうつうきこう /流通機構/
りゅうつうしじょう /流通市場/
りゅうつうしゅだん /流通手段/
りゅうつぼ /立坪/
りゅうでん /流電/流伝/
りゅうとう /竜頭/
りゅうとうげきしゅ /竜頭鷁首/
りゅうとうだび /竜頭蛇尾/
りゅうど /粒度/
りゅうどう /流動/
りゅうどうしょく /流動食/
りゅうどうせい /流動性/
りゅうどうたい /流動体/
りゅうどうてき /流動的/
りゅうどうひりつ /流動比率/
りゅうどうふさい /流動負債/
りゅうどうぶつ /流動物/
りゅうにゅう /流入/
りゅうにん /留任/
りゅうねん /留年/
りゅうは /流派/
りゅうばんこきょ /竜蟠虎踞/
りゅうひょう /流氷/
りゅうび /柳眉/
りゅうびじゅつ /隆鼻術/
りゅうへい /流弊/
りゅうべい /立米/
りゅうべつ /留別/
りゅうほ /留保/
りゅうほう /劉邦/
りゅうぼう /流亡/
りゅうぼく /流木/立木/
りゅうま /竜馬/
りゅうみん /流民/
りゅうもん /竜門/
りゅうよう /流用/柳腰/
りゅうり /流離/
りゅうりゅう /隆々/
りゅうりゅうしんく /粒粒辛苦/
りゅうりょう /流量/
りゅうりょくかこう /柳緑花紅/
りゅうれい /流麗/
りゅうれんこうぼう /流連荒亡/
りゅうろ /流露/
りゆう /理由/
りょ /虜/旅/慮/呂/閭/侶/
りょう /量/寮/両/領/陵/遼/諒/良/糧/稜/瞭/療/猟/涼/梁/料/僚/了/漁/霊/粮/令/凌/亮/
りょう> /両/
りょうあし /両足/
りょうあん /良案/
りょうあんじ /竜安寺/
りょうい /良医/
りょういき /領域/
りょういん /両院/
りょうう /涼雨/
りょううで /両腕/
りょううん /凌雲/
りょうえん /良縁/遼遠/
りょうか /良貨/良家/寮歌/
りょうかい /了解/領海/諒解/領会/
りょうかん /量感/僚艦/良寛/涼感/
りょうが /凌駕/
りょうがえ /両替/
りょうがえしょう /両替商/
りょうがえや /両替屋/
りょうがわ /両側/
りょうがん /両眼/両岸/
りょうき /漁期/猟奇/猟期/僚機/涼気/量器/
りょうきゃく /両脚/
りょうきょく /両極/
りょうきょくたん /両極端/
りょうきん /料金/
りょうぎせい /両義性/
りょうぎり /両切り/
りょうくう /領空/
りょうけ /両家/良家/領家/
りょうけい /量刑/良計/菱形/
りょうけん /了見/猟犬/了簡/料簡/
りょうげん /燎原/
りょうこう /良好/良港/良工/
りょうごく /両国/領国/
りょうごくばし /両国橋/
りょうさい /良妻/
りょうさいけんぼ /良妻賢母/
りょうさく /良策/
りょうさつ /了察/
りょうさん /量産/
りょうざい /良材/良剤/
りょうざんぱく /梁山泊/
りょうし /量子/漁師/猟師/良師/料紙/
りょうしかがく /量子化学/
りょうしき /良識/
りょうしつ /良質/
りょうしぶつりがく /量子物理学/
りょうしゃ /両者/
りょうしゅ /領主/領取/良種/
りょうしゅう /領収/領袖/涼秋/
りょうしゅけん /領主権/
りょうしょ /良書/両所/
りょうしょう /了承/諒承/
りょうしょく /糧食/
りょうしりきがく /量子力学/
りょうしろん /量子論/
りょうしん /両親/良心/
りょうしんてき /良心的/
りょうじ /療治/領事/両次/
りょうじかん /領事館/
りょうじつ /両日/
りょうじゅう /猟銃/
りょうじょく /凌辱/陵辱/
りょうじん /猟人/梁塵/良人/
りょうすい /量水/領水/
りょうせい /寮生/良性/両性/両生/両棲/
りょうせいか /両性花/
りょうせいばい /両成敗/
りょうせいるい /両生類/
りょうせつ /両説/
りょうせん /稜線/僚船/
りょうぜつ /両舌/
りょうぜん /瞭然/霊山/両全/
りょうそで /両袖/
りょうぞく /良俗/
りょうたん /両端/
りょうだめ /両為/
りょうだん /両断/
りょうち /領地/了知/領置/良知/料地/
りょうちょう /寮長/猟鳥/
りょうつ /両津/
りょうて /両手/
りょうてい /料亭/量定/
りょうてき /量的/
りょうてんびん /両天秤/
りょうと /良図/
りょうとう /両刀/両頭/竜頭/遼東/両統/
りょうとく /両得/領得/
りょうど /領土/両度/
りょうどう /両道/糧道/
りょうどうたい /良導体/
りょうどなり /両隣/
りょうない /領内/
りょうにん /両人/
りょうねい /遼寧/
りょうはし /両端/
りょうはん /量販/
りょうば /両刃/良馬/猟場/
りょうばんこきょ /竜蟠虎踞/
りょうひ /寮費/良否/
りょうひん /良品/
りょうびょう /療病/
りょうびらき /両開き/
りょうふ /両夫/
りょうふう /涼風/良風/
りょうぶ /両部/
りょうぶん /両分/領分/
りょうへい /良平/
りょうへん /両辺/
りょうほう /両方/療法/良法/
りょうぼ /寮母/陵墓/
りょうまい /糧米/
りょうまえ /両前/
りょうまつ /糧秣/
りょうみ /涼味/
りょうみん /良民/
りょうめ /両目/量目/
りょうめん /両面/
りょうもう /両毛/
りょうや /良夜/涼夜/
りょうやく /良薬/
りょうゆう /僚友/領有/両雄/良友/
りょうよう /療養/両様/両用/
りょうよく /両翼/
りょうらん /撩乱/繚乱/
りょうり /料理/
りょうりつ /両立/
りょうりにん /料理人/
りょうりばん /料理番/
りょうりや /料理屋/
りょうりょう /了了/両両/喨喨/稜稜/寥寥/
りょうりん /両輪/
りょうろん /両論/
りょうわき /両脇/
りょかく /旅客/
りょかくき /旅客機/
りょかん /旅館/
りょがい /慮外/
りょきゃく /旅客/
りょぎん /旅銀/
りょく /力/緑/
りょくいん /緑陰/
りょくう /緑雨/
りょくおうしょく /緑黄色/
りょくがん /緑眼/
りょくぎょく /緑玉/
りょくしきもう /緑色盲/
りょくしょく /緑色/
りょくじゅ /緑樹/
りょくすい /緑水/
りょくそう /緑草/
りょくそうるい /緑藻類/
りょくち /緑地/
りょくちたい /緑地帯/
りょくちゃ /緑茶/
りょくとう /緑豆/
りょくど /緑土/
りょくないしょう /緑内障/
りょくのうきん /緑膿菌/
りょくひ /緑肥/
りょくふう /緑風/
りょくべん /緑便/
りょくもん /緑門/
りょくや /緑野/
りょくりん /緑林/
りょけん /旅券/
りょこう /旅行/
りょこうき /旅行記/
りょしゅう /虜囚/旅愁/
りょしゅく /旅宿/
りょじ /旅次/
りょじゅん /旅順/
りょじょう /旅情/
りょそう /旅装/
りょだん /旅団/
りょっか /緑化/
りょてい /旅程/旅亭/
りょてん /旅店/
りょひ /旅費/
りょふい /呂不韋/
りょりつ /呂律/
りょりょく /膂力/
りよう /利用/理容/
りようかち /利用価値/
りようこうせい /利用厚生/
りようし /理容師/
りようしゃ /利用者/
りよく /利欲/
りりく /離陸/
りりつ /利率/
りりょう /李陵/
りれき /履歴/
りれきしょ /履歴書/
りろ /理路/
りろん /理論/
りろんか /理論家/
りろんかがく /理論化学/
りろんてき /理論的/
りろんぶつりがく /理論物理学/
りん /隣/輪/臨/燐/淋/林/厘/倫/鈴/凛/麟/鱗/琳/
りんう /霖雨/
りんか /隣家/輪禍/燐火/
りんかい /臨海/臨界/
りんかいかく /臨界角/
りんかいがっこう /臨海学校/
りんかいげんしょう /臨界現象/
りんかいじょうたい /臨界状態/
りんかいりょう /臨界量/
りんかく /輪郭/
りんかん /林間/輪姦/
りんかんがっこう /林間学校/
りんが /臨画/鱗芽/
りんがく /林学/
りんき /臨機/
りんきおうへん /臨機応変/
りんぎ /稟議/
りんぎしょ /稟議書/
りんぎょ /臨御/
りんぎょう /林業/
りんけい /鱗茎/輪形/鱗形/
りんけん /臨検/
りんげつ /臨月/
りんげん /綸言/
りんこ /凛乎/
りんこう /輪講/燐光/燐鉱/隣好/臨幸/
りんこうせん /臨港線/
りんご /林檎/
りんごく /隣国/
りんさく /輪作/
りんさん /林産/燐酸/
りんざいしゅう /臨済宗/
りんししつ /燐脂質/
りんしつ /隣室/
りんしゃ /臨写/
りんしょ /臨書/
りんしょう /臨床/輪唱/
りんしょういがく /臨床医学/
りんしょうか /臨床家/
りんしょく /吝嗇/
りんしん /稟申/
りんじ /臨時/
りんじこっかい /臨時国会/
りんじゅう /臨終/
りんじょう /臨場/輪状/鱗状/
りんじょうかん /臨場感/
りんじん /隣人/
りんじんあい /隣人愛/
りんず /綸子/綾子/
りんせい /林政/輪生/稟請/
りんせき /臨席/隣席/
りんせつ /隣接/鱗屑/
りんせん /林泉/臨戦/
りんせんじばん /臨川寺版/
りんぜん /凛然/
りんそん /隣村/
りんち /隣地/林地/
りんてん /輪転/
りんと /凛と/
りんどう /林道/竜胆/
りんどく /輪読/
りんね /輪廻/
りんばつ /輪伐/
りんばん /輪番/
りんびょう /淋病/
りんぴ /燐肥/
りんぶ /輪舞/
りんぶん /林分/
りんぷん /鱗粉/
りんぺん /鱗片/
りんぽう /隣邦/
りんぽん /臨本/
りんもう /厘毛/鱗毛/
りんや /林野/
りんやちょう /林野庁/
りんらく /淪落/
りんり /倫理/淋漓/
りんりがく /倫理学/
りんりつ /林立/
りんりてき /倫理的/
りんりん /凛々/凛凛/
りんれつ /凛冽/
る /縷/留/鏤/瑠/流/
るい /塁/累/類/涙/誄/
るいえん /類縁/類苑/
るいか /累加/類火/
るいがいねん /類概念/
るいぎご /類義語/
るいく /類句/
るいけい /類型/累計/
るいげつ /累月/
るいげん /累減/
るいげんぜい /累減税/
るいご /類語/
るいさん /累算/類纂/
るいしょ /類書/
るいしょう /類焼/類症/
るいしん /累進/塁審/
るいしんぜい /累進税/
るいじ /類似/類字/累次/
るいじつ /累日/
るいじゅう /類従/類聚/
るいじょう /累乗/
るいじょうこん /累乗根/
るいじんえん /類人猿/
るいすい /類推/
るいすいかいしゃく /類推解釈/
るいせい /累世/
るいせき /累積/
るいせきとうひょう /累積投票/
るいせん /涙腺/
るいぞう /累増/
るいぞく /類族/
るいだい /累代/類題/
るいどう /類同/
るいねん /累年/
るいのう /涙嚢/
るいはん /累犯/類板/
るいひ /類比/
るいへき /塁壁/
るいべつ /類別/
るいらん /累卵/
るいるい /累々/累累/
るいれい /類例/
るいれき /瘰癧/
るけい /流刑/
るこく /鏤刻/
るざい /流罪/
るす /留守/
るすい /留守居/
るすたく /留守宅/
るすばん /留守番/
るすばんでんわ /留守番電話/
るせつ /流説/
るそん /呂宋/
るたく /流謫/
るつぼ /坩堝/
るてん /流転/
るでん /流伝/
るにん /流人/
るふ /流布/
るふぼん /流布本/
るもい /留萌/
るり /瑠璃/
るりいろ /瑠璃色/
るる /縷々/縷縷/
るろう /流浪/
れい /例/齢/麗/霊/零/隷/鈴/礼/嶺/励/冷/令/戻/癘/苓/玲/怜/伶/
れいあんしつ /霊安室/
れいいき /霊域/
れいう /冷雨/
れいうん /嶺雲/
れいえん /霊園/
れいか /冷夏/零下/隷下/冷菓/
れいかい /例会/例解/霊界/
れいかん /霊感/冷汗/冷感/冷寒/
れいかんさんと /冷汗三斗/
れいかんしょう /冷感症/
れいがい /例外/冷害/
れいがん /冷眼/
れいき /冷気/励起/霊気/例規/
れいきじょうたい /励起状態/
れいきゃく /冷却/
れいきゃくき /冷却器/
れいきゃくきかん /冷却期間/
れいきゃくざい /冷却材/
れいきゅう /霊柩/
れいきゅうしゃ /霊柩車/
れいきょりしゃげき /零距離射撃/
れいきん /礼金/
れいぎ /礼儀/
れいく /麗句/
れいぐう /冷遇/礼遇/
れいけい /令閨/令兄/
れいけつ /冷血/
れいけつどうぶつ /冷血動物/
れいげつ /例月/
れいげん /冷厳/霊験/例言/
れいこう /励行/霊光/
れいこく /冷酷/例刻/
れいこん /霊魂/
れいさい /零細/例祭/
れいさいきぎょう /零細企業/
れいざん /霊山/
れいし /令姉/令嗣/霊芝/麗姿/令旨/
れいしき /礼式/
れいしつ /令室/麗質/
れいしゃ /礼者/
れいしゅ /冷酒/
れいしょ /隷書/令書/
れいしょう /例証/冷笑/冷床/
れいしょく /令色/冷色/
れいじ /例示/零時/
れいじつ /例日/
れいじゅう /隷従/霊獣/
れいじょう /令嬢/令状/礼状/霊場/礼譲/
れいじん /麗人/霊神/
れいすい /冷水/霊水/
れいせい /冷静/令婿/
れいせつ /礼節/例説/
れいせん /冷戦/冷泉/霊泉/
れいぜい /冷泉/
れいぜん /冷然/霊前/
れいそう /礼装/
れいそく /令息/
れいそん /令孫/
れいぞう /冷蔵/
れいぞうこ /冷蔵庫/
れいぞく /隷属/
れいたつ /令達/
れいたん /冷淡/
れいだい /例題/
れいだん /冷暖/
れいだんぼう /冷暖房/
れいち /霊地/
れいちゃ /冷茶/
れいちょう /霊長/
れいちょうるい /霊長類/
れいてい /令弟/
れいてき /霊的/
れいてつ /冷徹/
れいてん /零点/礼典/冷点/
れいとう /冷凍/
れいとうき /冷凍機/
れいとうしょくひん /冷凍食品/
れいど /零度/
れいにく /冷肉/
れいねつ /冷熱/
れいねん /例年/
れいの /例の/
れいのうしゃ /霊能者/
れいはい /礼拝/零敗/霊牌/
れいはいどう /礼拝堂/
れいば /冷罵/
れいばい /霊媒/冷媒/
れいひつ /麗筆/
れいひょう /冷評/
れいびょう /霊廟/
れいふう /冷風/
れいふく /礼服/
れいふじん /令夫人/
れいぶん /例文/礼文/令聞/
れいへい /例幣/
れいほう /礼法/礼砲/霊峰/霊宝/
れいほん /零本/
れいぼう /冷房/礼帽/
れいぼうこう /礼奉公/
れいぼく /零墨/霊木/
れいまい /令妹/
れいまいり /礼参り/
れいむ /霊夢/
れいめい /黎明/令名/
れいめいき /黎明期/
れいめん /冷麺/
れいもつ /礼物/
れいやく /霊薬/
れいよう /羚羊/麗容/
れいらく /零落/
れいり /伶俐/
れいりょう /冷涼/
れいりょく /霊力/
れいろう /玲瓏/
れいわ /例話/
れき /歴/暦/礫/轢/鬲/
れきがん /礫岩/
れきさつ /轢殺/
れきし /歴史/轢死/
れきしか /歴史家/
れきしかん /歴史観/
れきしがく /歴史学/
れきしてき /歴史的/
れきじ /歴事/
れきじつ /暦日/
れきせい /瀝青/歴世/
れきせん /歴戦/
れきぜん /歴然/
れきだい /歴代/
れきだん /轢断/
れきちょう /歴朝/
れきてい /歴程/
れきど /礫土/
れきにん /歴任/
れきねん /歴年/暦年/
れきねんれい /暦年齢/
れきひょう /暦表/
れきひょうじ /暦表時/
れきほう /歴訪/暦法/
れきほん /暦本/
れきゆう /歴遊/
れきれき /歴々/
れっか /劣化/烈火/列火/
れっかい /裂開/
れっかいか /裂開果/
れっき /列記/
れっきと /歴と/
れっきょ /列挙/
れっきょう /列強/
れっこう /列侯/
れっこく /列国/
れっし /列子/
れっしゃ /列車/
れっしょう /裂傷/
れっしん /烈震/
れっせい /劣性/劣勢/列聖/
れっせき /列席/
れっちゅう /列柱/
れっとう /劣等/列島/
れっとうかん /劣等感/
れっとうざい /劣等財/
れっぱい /劣敗/
れっぱく /裂帛/
れっぱん /列藩/
れっぴん /列品/
れっぷ /烈夫/烈婦/
れっぷう /烈風/
れつ /列/裂/烈/劣/
れつ> /劣/
れつあく /劣悪/
れつい /劣位/列位/
れつご /劣後/
れつざ /列座/
れつじつ /烈日/
れつじゃく /劣弱/
れつじょう /劣情/
れつだい /列代/
れつでん /列伝/
れつりつ /列立/
れつれつ /冽冽/
れてん /レ点/
れぶんとう /礼文島/
れもん /檸檬/
れん /恋/連/聯/練/簾/煉/憐/廉/錬/匳/奩/輦/蓮/漣/
れんあい /恋愛/
れんか /廉価/恋歌/
れんかん /聯関/連関/連環/
れんが /連歌/煉瓦/
れんがづくり /煉瓦造り/
れんき /連記/
れんきゅう /連休/
れんきんじゅつ /錬金術/
れんぎ /連木/
れんぎん /連吟/
れんく /連句/
れんけい /連携/連係/連繋/
れんけつ /連結/廉潔/
れんけつき /連結器/
れんけつけっさん /連結決算/
れんげ /蓮華/
れんげおうじょう /蓮華往生/
れんこ /連呼/
れんこう /連行/連衡/
れんこん /蓮根/
れんご /連語/
れんごう /連合/聯合/
れんごうかんたい /連合艦隊/
れんごうぐん /連合軍/
れんごうこく /連合国/
れんごうこっか /連合国家/
れんごうや /連合野/
れんごく /煉獄/
れんさ /連鎖/
れんさい /連載/
れんさく /連作/
れんさつ /憐察/
れんさはんのう /連鎖反応/
れんざ /連座/
れんざん /連山/
れんし /連枝/
れんしゅう /練習/
れんしゅうき /練習機/
れんしゅうきょく /練習曲/
れんしゅうせん /練習船/
れんしゅく /攣縮/
れんしょ /連署/
れんしょう /連勝/
れんしょうたんしき /連勝単式/
れんしょうふくしき /連勝複式/
れんじつ /連日/
れんじゃく /連尺/連雀/
れんじゅ /連珠/
れんじゅう /連中/
れんじゅく /練熟/
れんじょう /連城/連声/恋情/
れんせい /錬成/連星/
れんせつ /連接/廉節/
れんせん /連戦/
れんぜんあしげ /連銭葦毛/
れんそう /連想/連奏/聯想/
れんそうほう /連装砲/
れんぞく /連続/
れんぞくかんすう /連続関数/
れんぞくち /連続値/
れんたい /連帯/連隊/聯隊/
れんたいき /連隊旗/
れんたいけい /連体形/
れんたいさいむ /連帯債務/
れんたいし /連体詞/
れんたいせきにん /連帯責任/
れんたいちょう /連隊長/
れんたつ /練達/
れんたん /練炭/煉炭/
れんだ /連打/
れんだい /蓮台/
れんだく /連濁/
れんだん /連弾/
れんち /廉恥/
れんちゃく /恋着/
れんちゅう /連中/
れんちょく /廉直/
れんどう /連動/
れんにゅう /練乳/煉乳/
れんにょ /蓮如/
れんねん /連年/
れんばい /廉売/
れんばん /連番/
れんぱ /連破/連覇/
れんぱい /連敗/連俳/
れんぱつ /連発/
れんぱん /連判/
れんぱんじょう /連判状/
れんびん /憐愍/憐憫/
れんぶ /練武/
れんぺい /練兵/
れんぼ /恋慕/
れんぽう /連邦/連峰/聯邦/
れんぽうこっか /連邦国家/
れんま /錬磨/練磨/
れんめい /連盟/連名/聯盟/
れんめん /連綿/
れんや /連夜/
れんよう /連用/
れんようけい /連用形/
れんらく /連絡/聯絡/
れんらくさき /連絡先/
れんらくせん /連絡船/
れんり /連理/
れんりつ /連立/聯立/
れんるい /連累/
れんれん /恋恋/恋々/
ろ /露/路/炉/櫓/魯/廬/絽/艪/驢/艫/呂/
ろーとる /老頭児/
ろーま /羅馬/
ろあく /露悪/
ろいろ /蝋色/
ろいろうるし /蝋色漆/
ろう /朗/郎/蝋/聾/老/牢/漏/浪/楼/弄/婁/労/糧/露/狼/廊/癆/籠/臘/臈/鑞/陋/隴/榔/篭/
ろうあ /聾唖/
ろういろ /蝋色/
ろうえい /漏洩/朗詠/
ろうえき /労役/
ろうえきじょう /労役場/
ろうえん /狼煙/
ろうおう /老翁/
ろうおく /陋屋/
ろうか /廊下/老化/
ろうかい /老獪/
ろうかく /楼閣/
ろうかん /蝋管/
ろうがっこう /聾学校/
ろうがん /老眼/
ろうがんきょう /老眼鏡/
ろうき /牢記/
ろうきほう /労基法/
ろうきゅう /老朽/籠球/
ろうきょ /籠居/
ろうきょう /老境/
ろうきょく /浪曲/
ろうきん /労金/
ろうぎん /労銀/朗吟/
ろうく /労苦/老躯/
ろうくみ /労組/
ろうくん /郎君/
ろうけい /老兄/
ろうけん /老健/
ろうこ /牢固/
ろうこう /陋巷/老公/老巧/瘻孔/
ろうこく /鏤刻/
ろうこつ /老骨/
ろうご /老後/
ろうごく /牢獄/
ろうさい /労災/老妻/
ろうさく /労作/
ろうざいく /蝋細工/
ろうざん /老残/
ろうし /労使/浪士/老子/老師/老死/労資/牢死/
ろうしゃ /聾者/
ろうしゅう /老醜/陋習/
ろうしゅつ /漏出/
ろうしょう /労相/老将/朗唱/朗笑/
ろうしょうふじょう /老少不定/
ろうしん /老臣/老身/
ろうじつ /老実/
ろうじゃく /老若/老弱/
ろうじゅ /老樹/
ろうじゅう /老中/
ろうじゅく /老熟/
ろうじょ /老女/
ろうじょう /老嬢/籠城/楼上/
ろうじん /老人/
ろうじんいりょう /老人医療/
ろうじんびょう /老人病/
ろうすい /漏水/老衰/
ろうせい /老成/労政/老生/
ろうせき /蝋石/
ろうせつ /漏洩/漏泄/
ろうぜき /狼藉/
ろうそ /労組/
ろうそう /老荘/老僧/
ろうそく /蝋燭/
ろうぞめ /蝋染/
ろうたい /老体/
ろうたいか /老大家/
ろうたいこく /老大国/
ろうちん /労賃/
ろうでん /漏電/
ろうと /漏斗/
ろうどう /労働/
ろうどういいんかい /労働委員会/
ろうどううんどう /労働運動/
ろうどうきじゅんほう /労働基準法/
ろうどうきょうやく /労働協約/
ろうどうくみあい /労働組合/
ろうどうけいやく /労働契約/
ろうどうしじょう /労働市場/
ろうどうしゃ /労働者/
ろうどうじかん /労働時間/
ろうどうじょうけん /労働条件/
ろうどうそうぎ /労働争議/
ろうどうだいじん /労働大臣/
ろうどうとう /労働党/
ろうどうほう /労働法/
ろうどうりょく /労働力/
ろうどく /朗読/
ろうなぬし /牢名主/
ろうにゃく /老若/
ろうにん /浪人/
ろうにんぎょう /蝋人形/
ろうねん /老年/
ろうねんき /老年期/
ろうのう /老農/労農/
ろうはい /老廃/老輩/
ろうはいぶつ /老廃物/
ろうば /老婆/
ろうばい /狼狽/老梅/
ろうばしん /老婆心/
ろうばん /牢番/
ろうひ /浪費/
ろうびょう /老病/
ろうふ /老夫/老父/老婦/
ろうへい /老兵/
ろうほう /朗報/
ろうぼ /老母/
ろうぼく /老木/老僕/
ろうむ /労務/
ろうむしゃ /労務者/
ろうもう /老耄/
ろうもん /楼門/
ろうや /牢屋/老爺/
ろうやぶり /牢破り/
ろうゆう /老友/老雄/老優/
ろうよう /老幼/
ろうらく /籠絡/
ろうりょく /労力/
ろうるい /蝋涙/
ろうれい /老齢/
ろうれつ /陋劣/
ろうれん /老練/
ろうろう /朗朗/朗々/
ろうわ /朗話/
ろえい /露営/
ろか /濾過/蘆花/
ろかき /濾過器/
ろかく /鹵獲/
ろかた /路肩/
ろぎん /路銀/
ろく /緑/録/肋/禄/六/勒/
ろくおん /録音/鹿苑/
ろくが /録画/
ろくがつ /六月/
ろくごう /六合/
ろくさんせい /六三制/
ろくざい /肋材/
ろくしゃく /六尺/
ろくしょう /緑青/
ろくじ /六時/録事/
ろくじぞう /六地蔵/
ろくじょう /六条/
ろくだいしゅう /六大州/
ろくだか /禄高/
ろくだん /六段/
ろくてん /六天/
ろくどう /六道/
ろくに /陸に/碌に/
ろくはら /六波羅/
ろくはらたんだい /六波羅探題/
ろくぶんぎ /六分儀/
ろくぼく /肋木/
ろくまく /肋膜/
ろくまくえん /肋膜炎/
ろくめいかん /鹿鳴館/
ろくめんたい /六面体/
ろくもんせん /六文銭/
ろくよう /六曜/
ろくよくてん /六欲天/
ろくろ /轆轤/
ろけん /露見/路肩/
ろこう /露光/
ろこうきょう /盧溝橋/
ろこうきょうじけん /盧溝橋事件/
ろこつ /露骨/
ろご /露語/
ろさんじん /魯山人/
ろざん /廬山/
ろし /濾紙/
ろしあ /露西亜/
ろしゅつ /露出/
ろしゅつけい /露出計/
ろしょう /路床/
ろしん /炉心/
ろじ /路地/露地/路次/
ろじうら /路地裏/
ろじょう /路上/
ろじん /魯迅/
ろせん /路線/
ろせんか /路線価/
ろだい /露台/
ろちょう /顱頂/
ろっかく /六角/
ろっかせん /六歌仙/
ろっかん /肋間/
ろっきとう /六気筒/
ろっけつ /六穴/
ろっこつ /肋骨/
ろっこん /六根/
ろっぱく /六白/
ろっぷ /六腑/
ろっぽう /六法/六方/
ろっぽうぜんしょ /六法全書/
ろっぽんぎ /六本木/
ろてい /露呈/路程/
ろてき /蘆荻/
ろてん /露天/露店/露点/
ろてんぼり /露天掘り/
ろとう /路頭/露頭/
ろどん /魯鈍/
ろはん /露伴/
ろば /驢馬/
ろばた /炉端/
ろばん /路盤/露盤/
ろひ /路費/
ろひょう /路標/
ろびらき /炉開き/
ろふさぎ /炉塞ぎ/
ろぶん /露文/
ろへん /炉辺/
ろへんだんわ /炉辺談話/
ろほう /濾胞/
ろぼう /路傍/
ろめい /露命/
ろめん /路面/
ろめんでんしゃ /路面電車/
ろよう /路用/
ろれつ /呂律/
ろん /論/
ろんかく /論客/
ろんがい /論外/
ろんきつ /論詰/
ろんきゃく /論客/
ろんきゅう /論及/論究/
ろんきょ /論拠/
ろんぎ /論議/
ろんけつ /論決/論結/
ろんこう /論考/論攷/論功/
ろんこうこうしょう /論功行賞/
ろんこく /論告/
ろんご /論語/
ろんさく /論策/
ろんさん /論纂/
ろんし /論旨/
ろんしゃ /論者/
ろんしゅう /論集/
ろんしょう /論証/
ろんじゅつ /論述/
ろんじん /論陣/
ろんせつ /論説/
ろんせつぶん /論説文/
ろんせん /論戦/
ろんそう /論争/
ろんだい /論題/
ろんだん /論壇/論断/
ろんちょう /論調/
ろんてい /論定/
ろんてき /論敵/
ろんてん /論点/
ろんどん /倫敦/
ろんなん /論難/
ろんばく /論駁/
ろんぱ /論破/
ろんぴょう /論評/
ろんぶん /論文/
ろんべん /論弁/
ろんぽう /論法/論鋒/
ろんり /論理/
ろんりかいろ /論理回路/
ろんりがく /論理学/
ろんりきごう /論理記号/
ろんりけいさん /論理計算/
ろんりしき /論理式/
ろんりしゅぎ /論理主義/
ろんりてき /論理的/
わ /話/和/我/輪/倭/羽/把/環/吾/
わい /賄/猥/歪/
わいおく /矮屋/
わいか /矮化/
わいきょく /歪曲/
わいく /矮躯/
わいざつ /猥雑/
わいしょう /矮小/
わいせい /矮星/矮性/
わいせつ /猥褻/
わいだて /脇楯/
わいだん /猥談/
わいない /和井内/
わいほん /猥本/
わいろ /賄賂/
わえい /和英/
わえいじてん /和英辞典/
わおん /和音/
わか /若/和歌/
わかい /和解/和諧/
わかいもの /若い者/
わかがき /若書き/
わかき /若木/
わかぎ /若気/
わかぎみ /若君/
わかくさ /若草/
わかげ /若気/
わかさ /若狭/若さ/
わかさま /若様/
わかさわん /若狭湾/
わかしゅ /若衆/
わかしらが /若白髪/
わかじに /若死に/
わかす /若洲/
わかぞう /若造/
わかたけ /若竹/
わかだいしょう /若大将/
わかだんな /若旦那/
わかつき /若槻/
わかづくり /若作り/
わかづま /若妻/
わかて /若手/
わかとおおはし /若戸大橋/
わかとの /若殿/
わかどしより /若年寄/
わかどり /若鶏/
わかな /若菜/
わかはげ /若禿/
わかば /若葉/
わかまつ /若松/
わかみず /若水/
わかみどり /若緑/
わかみや /若宮/
わかむき /若向き/
わかむしゃ /若武者/
わかむらさき /若紫/
わかめ /若布/若芽/
わかもの /若者/
わかやく /若役/
わかやま /和歌山/若山/
わかやまけん /和歌山県/
わかやまし /和歌山市/
わかれ /別れ/
わかればなし /別れ話/
わかれみち /別れ道/
わかれわかれ /別れ別れ/
わかん /和漢/和姦/
わかんしょ /和漢書/
わかんよう /和漢洋/
わがく /和楽/
わがくに /我が国/
わがし /和菓子/
わがつま /我妻/
わがとう /我が党/
わがはい /我輩/吾輩/
わがまま /我儘/
わがみ /我が身/
わがものがお /我が物顔/
わがや /我が家/
わき /和気/腋/沸き/脇/
わきあいあい /和気藹々/和気藹藹/
わきかた /脇方/
わきが /腋臭/
わきげ /脇毛/腋毛/
わきさか /脇坂/
わきざし /脇差/
わきし /脇師/
わきじ /脇士/
わきだち /脇立/
わきだて /脇楯/
わきづくえ /脇机/
わきづけ /脇付/
わきて /脇手/
わきでら /脇寺/
わきのう /脇能/
わきばしら /脇柱/
わきばら /脇腹/
わきまえ /弁え/
わきみ /脇見/
わきみず /湧き水/
わきみち /脇道/
わきめ /脇目/
わきもん /脇門/
わきやく /脇役/
わきょう /和協/
わきろ /脇艪/
わきん /和金/
わぎ /和議/
わぎゅう /和牛/
わぎょう /ワ行/
わぎり /輪切り/
わく /枠/惑/
わくがい /枠外/
わくぐみ /枠組み/
わくせい /惑星/
わくでき /惑溺/
わくない /枠内/
わくもん /或問/
わくら /和倉/
わくらん /惑乱/
わけ /訳/和気/分け/
わけい /和敬/
わけがら /訳柄/
わけぎ /分葱/
わけどり /分け取り/
わけへだて /別け隔て/
わけまえ /分け前/
わけめ /分け目/
わげい /話芸/
わこう /和光/倭寇/
わこうど /若人/
わこうどうじん /和光同塵/
わこく /倭国/
わこくぼん /和刻本/
わこん /和魂/
わこんかんさい /和魂漢才/
わこんようさい /和魂洋才/
わご /和語/
わごう /和合/
わごん /和琴/
わさい /和裁/
わさび /山葵/
わさん /和算/和讃/
わさんぼん /和三盆/
わざ /技/業/
わざし /業師/
わざと /態と/
わざもの /業物/
わざわい /災い/禍/
わし /鷲/和紙/儂/
わしき /和式/
わしざ /鷲座/
わしつ /和室/
わしづ /鷲津/
わしづかみ /鷲掴み/
わしばな /鷲鼻/
わしゃ /話者/
わしゅうごう /和集合/
わしゅうざん /鷲羽山/
わしょ /和書/
わしょく /和食/
わしん /和親/
わしんとん /華盛頓/
わじ /和字/
わじま /輪島/
わじゅう /輪中/
わじゅつ /話術/
わじゅん /和順/
わじるし /わ印/
わじん /倭人/
わじんでん /倭人伝/
わすれ /忘れ/
わすれがたみ /忘れ形見/
わすれなぐさ /勿忘草/
わすれもの /忘れ物/
わせ /早稲/早生/
わせい /和声/和製/
わせいえいご /和製英語/
わせいほう /和声法;作曲技法の一,⇔対位法/
わせだ /早稲田/
わせだだいがく /早稲田大学/
わせん /和戦/和船/
わそう /和装/
わそうぼん /和装本/
わた /綿/棉/腸/
わたあめ /綿飴/
わたいれ /綿入れ/
わたうち /綿打ち/
わたがし /綿菓子/
わたくし /私/
わたくしごと /私事/
わたくしりつ /私立/
わたくり /綿繰り/
わたぐも /綿雲/
わたげ /綿毛/
わたし /私/渡し/
わたしこみ /渡し込み/
わたしば /渡し場/
わたしぶね /渡し船/
わたしもり /渡し守/
わたせ /渡瀬/
わたどの /渡殿/
わたなべ /渡辺/
わたぬき /綿貫/
わたぼうし /綿帽子/
わたや /綿屋/
わたゆき /綿雪/
わたらい /度会/
わたらせがわ /渡良瀬川/
わたり /渡り/
わたりぞめ /渡り初め/
わたりどり /渡り鳥/
わたりろうか /渡り廊下/
わだ /和田/
わだい /話題/
わだち /轍/
わちゅうきょうどう /和衷協同/
わっかない /稚内/
わっぷ /割賦/
わつじ /和辻/
わとじ /和綴じ/
わどう /和銅/
わどうかいちん /和同開珎/
わどうかいほう /和同開珎/
わどくじてん /和独辞典/
わどめ /輪留め/
わな /罠/
わなげ /輪投げ/
わに /鰐/王仁/
わにがわ /鰐皮/
わにぐち /鰐口/
わぬけ /輪抜け/
わはん /和版/
わび /侘/
わびじょう /詫状/
わびずまい /侘住い/
わびちゃ /侘茶/
わびね /侘寝/
わふう /和風/
わふく /和服/
わふつ /和仏/
わぶん /和文/
わへい /和平/
わほう /話法/
わほん /和本/
わぼく /和睦/
わめい /和名/
わやく /和訳/
わよう /和洋/和様/
わようせっちゅう /和洋折衷/
わら /藁/
わらい /笑い/
わらいがお /笑い顔/
わらいぐさ /笑い種/
わらいごえ /笑い声/
わらいごと /笑い事/
わらいじょうご /笑い上戸/
わらいばなし /笑い話/
わらいもの /笑い物/
わらがみ /藁紙/
わらく /和楽/
わらじ /草鞋/
わらにんぎょう /藁人形/
わらばんし /藁半紙/
わらび /蕨/藁火/
わらぶき /藁葺き/
わらぶとん /藁蒲団/
わらべ /童/
わらべうた /童歌/
わらわ /妾/童/
わり /割/
わりあい /割合/
わりあて /割当て/
わりいし /割石/
わりいん /割印/
わりかた /割方/
わりかん /割り勘/
わりがき /割書/
わりぐりいし /割栗石/
わりこみ /割込み/
わりざん /割り算/
わりした /割下/
わりだか /割高/
わりだし /割出し/
わりつけ /割付け/
わりばし /割箸/
わりびき /割引/
わりびきさい /割引債/
わりびきりょう /割引料/
わりふ /割符/
わりふり /割り振り/
わりまえ /割前/
わりまし /割増/
わりましきん /割増金/
わりめ /割目/
わりもどし /割戻し/
わりやす /割安/
わる /悪/
わるあがき /悪足掻き/
わるあそび /悪遊び/
わるぎ /悪気/
わるくち /悪口/
わるさ /悪さ/
わるじえ /悪知恵/
わるずれ /悪擦れ/
わるだくみ /悪巧み/
わるぢえ /悪知恵/
わるどめ /悪止め/
わるもの /悪者/悪物/
わるよい /悪酔い/
われ /我/吾/
われき /和暦/
われさき /我先/
われしらず /我知らず/
われながら /我乍ら/
われひと /我人/
われめ /割れ目/
われもの /割れ物/
われら /我等/
われわれ /我々/我我/
わん /腕/碗/湾/椀/
わんがん /湾岸/
わんがんしょこく /湾岸諸国/
わんがんせんそう /湾岸戦争/
わんきょく /湾曲/彎曲/
わんこう /湾口/
わんこそば /椀子蕎麦/
わんこつ /腕骨/
わんしょう /腕章/
わんそくるい /腕足類/
わんたん /雲呑/
わんとう /湾頭/
わんない /湾内/
わんにゅう /湾入/彎入/
わんぱく /腕白/
わんりゅう /湾流/
わんりょく /腕力/
