package littlemaid;

import java.util.List;

import littlemaid.entity.EntityLittleMaid;
import littlemaid.network.MessagePlaySound;
import littlemaid.network.MessageRequestEquip;
import net.minecraft.command.IEntitySelector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LittleMaidEventHandler {

	private double distanceToGreeting = 6.0D;

	public LittleMaidEventHandler() {}

	// ==============================================================================
	//  Playerイベント
	// ------------------------------------------------------------------------------

	/**
	 * プレイヤーがベットに入った
	 */
	@SubscribeEvent
	public void PlayerSleepInBedEventMethod(PlayerSleepInBedEvent event) {
		LittleMaidCore.getLogger().info("MaidEventHandler_PlayerSleepInBedEventMethod");

		World worldIn = event.entity.worldObj;
		// 就寝を試みたらサーバー側でイベントが発生。就寝に成功したらクライアント側でイベントが発生。
		if (worldIn.isRemote) {

			// プレイヤーから周囲6ブロック（上下3ブロック）内にいるメイドさんをリストアップ
			List<EntityLittleMaid> maidList = worldIn.getEntitiesWithinAABB(
				EntityLittleMaid.class,
				event.entity.getEntityBoundingBox().expand(this.distanceToGreeting, 3.0D, this.distanceToGreeting),
				IEntitySelector.selectAnything);

			// その中に契約メイドさんがいれば声をかけてくれる
			for (EntityLittleMaid maid : maidList) {
				if (maid.isContract() == true && maid.getOwner() == event.entity) {
					// サーバーにおやすみなさいを再生してもらうように通知
					LittleMaidCore.MESSAGE.sendToServer(new MessagePlaySound(maid, "littlemaid:basic.goodnight"));
					break;
				}
			}
		}
	}

	/**
	 * プレイヤーが起きた
	 */
	@SubscribeEvent
	public void PlayerWakeUpEventMethod(PlayerWakeUpEvent event) {
		LittleMaidCore.getLogger().info("MaidEventHandler_PlayerWakeUpEventMethod");

		World worldIn = event.entity.worldObj;

		if (worldIn.isRemote) {

			// プレイヤーから周囲6ブロック（上下3ブロック）内にいるメイドさんをリストアップ
			List<EntityLittleMaid> maidList = worldIn.getEntitiesWithinAABB(
				EntityLittleMaid.class,
				event.entity.getEntityBoundingBox().expand(this.distanceToGreeting, 3.0D, this.distanceToGreeting),
				IEntitySelector.selectAnything);

			// その中に契約メイドさんがいれば声をかけてくれる
			for (EntityLittleMaid maid : maidList) {
				if (maid.isContract() == true && maid.getOwner() == event.entity) {
					// サーバーにおはようございますを再生してもらうように通知
					LittleMaidCore.MESSAGE.sendToServer(new MessagePlaySound(maid, "littlemaid:basic.goodmorning"));
					break;
				}
			}
		}
	}

	// ==============================================================================
	//  Entityイベント
	// ------------------------------------------------------------------------------

	/**
	 * エンティティがWorldに接続した
	 *  サーバーへの接続時はServer/Clientで発生。
	 *  Entityがプレイヤーから見える範囲に入ってきた時にはClientのみで発生する。
	 */
	@SubscribeEvent
	public void EntityJoinWorldEventMethod(EntityJoinWorldEvent event) {
		// LittleMaidCore.getLogger().info("MaidEventHandler_EntityJoinWorldEvent_Maid");

		World worldIn = event.entity.worldObj;

		if (worldIn.isRemote && event.entity instanceof EntityLittleMaid) {
			// メイドさんがClientに読み込まれたら装備品を送ってもらう

			EntityLittleMaid maid = (EntityLittleMaid)event.entity;
			// このメイドさんの装備品を同期するようにサーバーへ依頼
			LittleMaidCore.MESSAGE.sendToServer(new MessageRequestEquip(maid));

		}

	}

}