package littlemaid.entity;

import littlemaid.LittleMaidCore;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class LayerMaidArmor extends LayerArmorBase {

	public LayerMaidArmor(RendererLivingEntity p_i46125_1_) {
		super(p_i46125_1_);
		// 受け取ったRendererは、メンバ変数"this.field_177190_a"に入る
	}

	/**
	 * コンストラクタから呼び出される初期化メソッド
	 */
	@Override
	protected void func_177177_a() {
		// サイズの違う2枚のレイヤーを被せて靴の大きい感とか肩パットを表現している。
		// レギンス用に僅かにスケールを大きくしたモデル
		this.field_177189_c = new ModelLittleMaid(0.2F);
		// 靴、アーマー、ヘルメット用にレギンスよりもう少しスケールを大きくしたモデル
		this.field_177186_d = new ModelLittleMaid(0.2F);
	}

	/**
	 * 装備番号に合わせて装備品の表示を切り替える
	 */
	@Override
	protected void func_177179_a(ModelBase model, int slot) {
		ModelLittleMaid bipedModel = (ModelLittleMaid) model;

		bipedModel.setInvisible(false);

		// 1-Shoes 2-leggings 3-chest 4-helmet
		switch (slot)
		{
		case 1:
			bipedModel.bipedRightLeg.showModel = true;
			bipedModel.bipedLeftLeg.showModel = true;
			break;
		case 2:
			bipedModel.skirt.showModel = true;
			bipedModel.landingSkirt.showModel = true;
			break;
		case 3:
			bipedModel.bipedBody.showModel = true;
			bipedModel.bipedRightArm.showModel = true;
			bipedModel.bipedLeftArm.showModel = true;
			break;
		case 4:
			bipedModel.bipedHead.showModel = true;
			bipedModel.bipedHeadwear.showModel = true;
		}
	}

	/**
	 * 装備品のテクスチャを返す。
	 * 継承元のLayerArmorBaseでは、他のModで追加される防具テクスチャにも対応できるようにForgeの手が入ってるけどテクスチャ別物なので無視。
	 */
	@Override
	public ResourceLocation getArmorResource(Entity entity, ItemStack stack, int slot, String type) {
		// 装備品の素材名を取得
		String texture = ((ItemArmor) stack.getItem()).getArmorMaterial().getName();
		int idx = texture.indexOf(':');
		if (idx != -1)
		{
			texture = texture.substring(idx + 1);
		}
		// 装備品テクスチャを返す
		String s1 = String.format("%s:textures/models/armor/original/%s_layer_1.png", LittleMaidCore.MODID, texture);
		return new ResourceLocation(s1);
	}

}
